<?= view('base.web.merchant.common.header')?>
<script src="<?= resource('/base/web/public/js/shangfan.merchant/shopGoods.lists.js') ?>"></script>

<div class="layui-layout layui-layout-admin">
    <?= view('base.web.merchant.common.navigation')?>
    <?= view('base.web.merchant.common.menu')?>
    <!-- body -->
    <div class="layui-body">
        <div class="container">
            
            <div class="home-container">
                <i class="layui-icon layui-icon-location"></i>当前位置： 后台首页 / 商品管理 / 商品管理列表
            </div>
            <div class="tab-container">
                <a href="<?= url('/merchant/goods/lists') ?>" class="item active">商品管理</a>
            </div>
            
            <div class="table-container">
                <table class="layui-table">
                    <colgroup>
                        <col style="width: 70px;">
                        <col style="width: 95px;">
                        <col>
                        <col width="10%">
                        <col width="10%">
                        <col width="10%">
                        <col width="10%">
                        <col width="20%">
                    </colgroup>
                    <thead>
                        <tr>
                            <th>序号</th>
                            <th>图片</th>
                            <th>商品名称</th>
                            <th>商城分类/店铺分类</th>
                            <th>价格</th>
                            <th>PC端状态</th>
                            <th>手机端状态</th>
                            <th>操作</th>
                        </tr> 
                    </thead>
                    <tbody>
                        <?php if(isset($results->results) && count($results->results)):?>
                        <?php foreach ($results->results as $key=>$val):?>
                        <tr>
                            <td><?=$key+1?></td>
                            <td>
                                <a href="<?=$val->url?>" target="_blank">
                                    <img src="<?= picPublic($val->cover_mini)?>" style="width: 80px; height: 100px;" />
                                </a>
                            </td>
                            <td>
                                <a href="<?=$val->url?>" target="_blank"><?=$val->name?></a>
                            </td>
                            <td><?=$val->mallCategoryName?>/<?=$val->shopCategoryName?></td>
                            <td>价格：￥<?=$val->price_member?></td>
                            <td>
                                店铺：
                                <?php if($val->is_putaway == 1):?>
                                <span class="statusSuccess"><?=$val->strIsPutway?></span>
                                <?php else:?>
                                <span class="statusWarning"><?=$val->strIsPutway?></span>
                                <?php endif;?>
                                <br/>
                                商城：
                                <?php if($val->is_putaway_mall == 1):?>
                                <span class="statusSuccess"><?=$val->strIsPutwayMall?></span>
                                <?php else:?>
                                <span class="statusWarning"><?=$val->strIsPutwayMall?></span>
                                <?php endif;?>
                            </td>
                            <td>
                                店铺：
                                <?php if($val->h5_is_putaway == 1):?>
                                <span class="statusSuccess"><?=$val->strH5IsPutaway?></span>
                                <?php else:?>
                                <span class="statusWarning"><?=$val->strH5IsPutaway?></span>
                                <?php endif;?>
                                <br/>
                                商城：
                                <?php if($val->h5_is_putaway_mall == 1):?>
                                <span class="statusSuccess"><?=$val->strH5IsPutawayMall?></span>
                                <?php else:?>
                                <span class="statusWarning"><?=$val->strH5IsPutawayMall?></span>
                                <?php endif;?>
                            </td>
                            <td>
                                <p>
                                    <?php if($val->is_putaway == 1):?>
                                    <a href="<?=url('/merchant/goods/soldout/'.$val->md5)?>" class="input-button-blue input-button-a evePutoff">PC端取消上架</a>
                                    <?php else:?>
                                    <a href="<?=url('/merchant/goods/putaway/'.$val->md5)?>" class="input-button-blue input-button-a evePutway">PC端发布上架</a>
                                    <?php endif;?> 
                                    <a href="<?= url('/merchant/goods/step1/edit/'.$val->md5) ?>" class="input-button-blue input-button-a eveSubmit">PC端编辑</a>
                                </p>
                                <p style="margin-top: 15px;">
                                    <?php if($val->h5_is_putaway == 1):?>
                                    <a href="<?=url('/merchant/goods/h5/soldout/'.$val->md5)?>" class="input-button-blue input-button-a eveH5Putoff">手机端取消上架</a>
                                    <?php else:?>
                                    <a href="<?=url('/merchant/goods/h5/putaway/'.$val->md5)?>" class="input-button-blue input-button-a eveH5Putway">手机端发布上架</a>
                                    <?php endif;?> 
                                    <a href="<?= url('/merchant/goods/h5/step2/'.$val->md5) ?>" class="input-button-blue input-button-a eveSubmit">手机端编辑</a>
                                </p>
                                <p style="margin-top: 15px;">
                                    <a href="<?=url('/merchant/goods/h5/preview/'.$val->md5)?>" class="input-button-blue input-button-a eveQrcode">手机端预览</a>
                                    <a href="<?=url('/merchant/stock/lists/'.$val->md5)?>" class="input-button-blue input-button-a eveSubmit">库存</a>
                                    <a href="<?= url('/merchant/goods/del/'.$val->md5) ?>" class="input-button-blue input-button-a eveDel">删除</a>
                                </p>
                            </td>
                        </tr>
                        <?php endforeach;?>
                        <?php else:?>
                        <tr>
                            <td colspan="10">暂无数据</td>
                        </tr>
                        <?php endif;?>
                        <tr>
                            <td colspan="10" style="text-align: right;"><?=$results->render();?></td>
                        </tr>
                    </tbody>
                </table>
            </div>
            
        </div>
    </div>
    <!-- //body -->
</div>

<?= view('base.web.merchant.common.footer')?>