layui.use(['form', 'upload'], function () {
    var layer = layui.layer;
    var upload = layui.upload;
    var uploadCoverPic = upload.render({
        elem: '#uploadCoverPic'
        , url: '/merchant/upload/cover'
        , data: {
            goodsId: function () {
                return $('input[name="goodsId"]').val();
            }
        }
        , accept: 'images'
                //,acceptMime: 'image/*'
        , auto: true
        , size: 1024 * 4
        , multiple: false
        , number: 0
        , drag: true
        , choose: function () {
            $loading = layer.load(1, {shade: false});
        }
        , before: function () {
        }
        , done: function (res) {
            if($loading){
                layer.close($loading);
            }
            window.location.reload();
        }
        ,allDone: function(){
        }
        , error: function () {
            layer.msg('上传出错');
        }
    });
    var uploadGoodsPic = upload.render({
        elem: '#uploadGoodsPic'
        , url: '/merchant/upload/goods'
        , data: {
            goodsId: function () {
                return $('input[name="goodsId"]').val();
            }
        }
        , accept: 'images'
                //,acceptMime: 'image/*'
        , auto: true
        , size: 1024 * 4
        , multiple: true
        , number: 0
        , drag: true
        , choose: function () {
            $loading = layer.load(1, {shade: false});
        }
        , before: function () {
        }
        , done: function (res) {
            if($loading){
                layer.close($loading);
            }
        }
        ,allDone: function(){
            window.location.reload();
        }
        , error: function () {
            layer.msg('上传出错');
        }
    });
});
$(function () {
    $('.evePicSort').blur(function(){
        var $param={
            'goodsId':$(this).attr('goodsId'),
            'goodsImagesId':$(this).attr('goodsImagesId'),
            'sort':$(this).val()
        };
        $.post('/merchant/goods/pic/sort', $param, function($data){
            layer.msg($data.message);
            if ($data.status === 1) {
                window.setTimeout(function () {
                    window.location.reload();
                }, 1000);
            }
        });
    });
    $('.evePicDel').click(function(){
        var $_this=$(this);
        layer.confirm('操作不可撤回，确定操作？', {
            btn: ['确定', '取消']
        }, function () {
            $.get($_this.attr('href'), function ($data) {
                layer.msg($data.message);
                if ($data.status === 1) {
                    window.setTimeout(function () {
                        window.location.reload();
                    }, 1000);
                }
            });
        }, function () {
        });
        return false;
    });
    $('.eveSubmit').click(function () {
        var $param = {
            title: $('input[name="title"]').val(),
            mall_category_id: $('select[name="mall_category_id"]').val(),
            shop_category_id: $('select[name="shop_category_id"]').val(),
            price_market: $('input[name="price_market"]').val(),
            price_member: $('input[name="price_member"]').val()
        };
        $.post(window.location.href, $param, function ($data) {
            if ($data.status === 0) {
                layer.msg($data.message);
                return;
            }
            window.location.href = '/merchant/goods/step2/' + $data.data.goodsId;
        });
    });
    $('.eveShopCategoryPid').change(function () {
        $pid = $(this).val();
        $.post('/merchant/category/ajaxlevel2/' + $pid, function ($data) {
            if ($data.status === 0) {
                layer.msg($data.mesage);
                return;
            }
            var $html = [];
            if ($data.data.length === 0) {
                $html.push('<option value="0">请选择</option>');
                $('.eveShopCategoryId').html($html.join(''));
                return;
            }
            for (var $i in $data.data) {
                $temp = $data.data[$i];
                $html.push('<option value="' + $temp.id + '">' + $temp.title + '</option>');
            }
            $('.eveShopCategoryId').html($html.join(''));
        });
    });
});