<?php
/**
 * Copyright (C) LJCMS All rights reserved.
 * <E-Mail：aspcms@qq.com>
 * Url http://www.liangjing.org
 *     http://www.8CMS.com
 * Update 2016.03.19
 */

class queoptionAModel extends X {
    private $tbname = "question_option";
    private $pkid = "optionid";

    
    public function getList($items) {
        $where = " WHERE 1=1".$items['searchsql'];
        $start = ($items['page']-1)*$items['pagesize'];
        $countsql = "SELECT COUNT(*) AS my_count".
                    " FROM ".DB_PREFIX."{$this->tbname} AS v".$where;
        $total = parent::$obj->fetch_count($countsql);
        if ($total > 0) {
            $sql = "SELECT v.*, q.title FROM ".DB_PREFIX."{$this->tbname} AS v".
                    " LEFT JOIN ".DB_PREFIX."question AS q ON v.queid=q.queid".
                    $where." ORDER BY v.queid DESC,v.orders ASC LIMIT {$start}, {$items['pagesize']}";
            $_data = parent::$obj->getall($sql);
        }
        return array($total, $_data);
    }

    
    public function getData($id) {
        $sql = "SELECT v.*, q.title FROM ".DB_PREFIX."{$this->tbname} AS v".
                " LEFT JOIN ".DB_PREFIX."question AS q ON v.queid=q.queid".
                " WHERE v.{$this->pkid}='{$id}'";
        return parent::$obj->fetch_first($sql);
    }

    
    public function doAdd($args) {
        $res = false;
        $optionid = parent::$obj->fetch_newid("SELECT MAX({$this->pkid}) FROM ".DB_PREFIX."{$this->tbname}", 1);
        $args = array_merge(array(
                "optionid"=>$optionid,
            ), $args);
        $res = parent::$obj->insert(DB_PREFIX."{$this->tbname}", $args);
        if (true === $res) {
            $this->updateOptionNums($args['queid']);
            $this->updatePolls($args['queid']);
        }
        return $res;
    }

    
    public function doEdit($id, $args) {
        $res = parent::$obj->update(DB_PREFIX."{$this->tbname}", $args, "{$this->pkid}='{$id}'");
        if (true === $res) {
            $this->updateOptionNums($args['queid']);
            $this->updatePolls($args['queid']);
        }
        return $res;
    }

    
    public function doDel($id) {
        $res = false;
        $_data = parent::$obj->fetch_first("SELECT * FROM ".DB_PREFIX.$this->tbname." WHERE {$this->pkid}='{$id}'");
        if (!empty($_data)) {
            $queid = $_data['queid'];
        }
        $res = parent::$obj->query("DELETE FROM ".DB_PREFIX.$this->tbname." WHERE {$this->pkid}='{$id}'");
        if (true === $res) {
            $this->updateOptionNums($queid);
            $this->updatePolls($queid);
        }
        return $res;
    }

    
    public function getQueTitle($id) {
        $_title = "";
        $_data = parent::$obj->fetch_first("SELECT title FROM ".DB_PREFIX."question WHERE queid='{$id}'");
        if (!empty($_data)) {
            $_title = $_data['title'];
        }
        return $_title;
    }

    
    public function getVolist($where="", $orderby="", $num=0, $limit="") {
        $sql = "SELECT v.* FROM ".DB_PREFIX."{$this->tbname} AS v".
                " WHERE 1=1";
        $sql .= !empty($where) ? " AND ".$where : "";
        $sql .= !empty($orderby) ? " ".$orderby : " ORDER BY v.orders ASC";
        if (!empty($limit)) {
            $sql .= " LIMIT {$limit}";
        }
        else {
            $num = intval($num)<1 ? 10 : intval($num);
            $sql .= " LIMIT 0, {$num}";
        }
        $data = parent::$obj->getall($sql);
        $i = 1;
        foreach ($data as $key=>$value) {
            $data[$key]['i'] = $i;
            $i++;
        }
        return $data;
    }

    
    public function updateOptionNums($queid) {
        $_count = 0;
        $_count_sql = "SELECT COUNT(*) AS my_count FROM ".DB_PREFIX."question_option".
            " WHERE queid='{$queid}'";
        $_count = parent::$obj->fetch_count($_count_sql);
        $up_array = array(
            "optionnums"=>$_count,
        );
        return parent::$obj->update(DB_PREFIX."question", $up_array, "queid='{$queid}'");
    }

    
    public function updatePolls($queid) {
        $_sql = "SELECT SUM(polls) AS my_sum FROM ".DB_PREFIX."question_option".
                " WHERE queid='{$queid}'";
        $_total_polls = parent::$obj->fetch_count($_sql);

        $_list = parent::$obj->getall("SELECT * FROM ".DB_PREFIX."question_option WHERE queid='{$queid}'");
        foreach ($_list as $key=>$value) {
            $percent = 0;
            $_polls = intval($value['polls']);
            if ($_total_polls > 0) {
                $percent = round(($_polls/$_total_polls)*100);
            }
            parent::$obj->update(DB_PREFIX."question_option", array("percent"=>$percent), "optionid='".$value['optionid']."'");
        }

        return parent::$obj->update(DB_PREFIX."question", array("totalpolls"=>$_total_polls), "queid='{$queid}'");
    }
}
?>
