<?php echo $this->fetch('new_header.html'); ?>

<script type="text/javascript">
//注册表单验证
$(function(){
    $('#register_form').validate({
        errorPlacement: function(error, element){
            var error_td = element.parent('td').next('td');
            error_td.find('.field_notice').hide();
            error_td.append(error);
        },
        success       : function(label){
            label.addClass('validate_right').text('OK!');
        },
        onkeyup: false,
        rules : {
            user_name : {
                required : true,
                byteRange: [3,15,'<?php echo $this->_var['charset']; ?>'],
                remote   : {
                    url :'index.php?app=member&act=check_user&ajax=1',
                    type:'get',
                    data:{
                        user_name : function(){
                            return $('#user_name').val();
                        }
                    },
                    beforeSend:function(){
                        var _checking = $('#checking_user');
                        _checking.prev('.field_notice').hide();
                        _checking.next('label').hide();
                        $(_checking).show();
                    },
                    complete :function(){
                        $('#checking_user').hide();
                    }
                }
            },
            password : {
                required : true,
                minlength: 6
            },
            password_confirm : {
                required : true,
                equalTo  : '#password'
            },
            email : {
                required : true,
                email    : true
            },
            captcha : {
                required : true,
                remote   : {
                    url : 'index.php?app=captcha&act=check_captcha',
                    type: 'get',
                    data:{
                        captcha : function(){
                            return $('#captcha1').val();
                        }
                    }
                }
            },
            agree : {
                required : true
            }
        },
        messages : {
            user_name : {
                required : '您必须提供一个用户名',
                byteRange: '用户名必须在3-15个字符之间',
                remote   : '您提供的用户名已存在'
            },
            password  : {
                required : '您必须提供一个密码',
                minlength: '密码长度应在6-20个字符之间'
            },
            password_confirm : {
                required : '您必须再次确认您的密码',
                equalTo  : '两次输入的密码不一致'
            },
            email : {
                required : '您必须提供您的电子邮箱',
                email    : '这不是一个有效的电子邮箱'
            },
            captcha : {
                required : '请输入右侧图片中的文字',
                remote   : '验证码错误'
            },
            agree : {
                required : '您必须阅读并同意该协议,否则无法注册'
            }
        }
    });
});
</script>
	
    <div class="auto">
    	<div class="reg_panel">
            <form class="reg_box" id="register_form" method="post">
                <table>
                    <tbody>
                        <tr>
                            <td colspan="3"><h2>填写注册信息</h2></td>
                        </tr>
                        <tr>
                            <td><label>用户名：</label></td>
                            <td><input  id="user_name" name="user_name"   type="text" class="text_box"></td>
                              <td class="padding3 fontColor4"><label class="field_notice">用于登录的名字</label><label id="checking_user" class="checking">检查中...</label></td>
                            
                        </tr>
                        <tr>
                            <td><label>密&nbsp;&nbsp;&nbsp;码：</label></td>
                            <td><input  type="password" id="password" name="password" class="text_box"></td>
                             <td class="padding3 fontColor4"><label class="field_notice">您的密码</label></td>
                        </tr>
                        <tr>
                            <td><label>确认密码：</label></td>
                            <td><input  type="password" name="password_confirm" class="text_box"></td>
                               <td class="padding3 fontColor4"><label class="field_notice">重复输入您的密码</label></td>
                        </tr>
                        <tr>
                            <td><label>电子邮箱：</label></td>
                            <td><input  name="email"  type="text" class="text_box"></td>
                             <td class="padding3 fontColor4"><label class="field_notice">请输入一个有效的电子邮箱地址</label></td>
                        </tr>
                        <tr>
                            <td></td>
                            <td><input type="checkbox"  name="agree" value="1" value="1" > <label for="clause">我已阅读并同意 <a class="agreement" target="_blank" href="<?php echo url('app=article&act=system&code=eula'); ?>">用户服务协议</a></label></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td></td>
                            <td colspan="2"><input type="submit" name="Submit"  class="btn_box" value="立即注册"></td>
                        </tr>
                    </tbody>
                </table>
            </form>
       		<a href="<?php echo url('app=member&act=login&ret_url=' . $this->_var['ret_url']. ''); ?>" class="to_log"></a>
        </div>
    </div>
   
<?php echo $this->fetch('footer.html'); ?>