-- 生成日期: 2013 年 03 月 11 日 10:49

SET SQL_MODE="NO_AUTO_VALUE_ON_ZERO";

--
-- 数据库: `iwebshop`
--

-- --------------------------------------------------------

--
-- 表的结构 `{pre}account_log`
--

DROP TABLE IF EXISTS `{pre}account_log`;
CREATE TABLE `{pre}account_log` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `admin_id` int(11) unsigned default '0' COMMENT '管理员ID',
  `user_id` int(11) unsigned default NULL COMMENT '用户id',
  `type` tinyint(1) NOT NULL default '0' COMMENT '0增加,1减少',
  `event` tinyint(3) NOT NULL COMMENT '操作类型 1,充值到预存款 2,从预存款提现 3,从预存款支付 4,退款到预存款 5,佣金提现到预存款 6,充值奖励',
  `time` datetime NOT NULL COMMENT '发生时间',
  `amount` decimal(15,2) NOT NULL COMMENT '金额',
  `amount_log` decimal(15,2) NOT NULL COMMENT '每次增减后面的金额记录',
  `note` text COMMENT '备注',
  PRIMARY KEY  (`id`),
  index (`user_id`),
  index (`admin_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='账户预存款日志表';

-- --------------------------------------------------------

--
-- 表的结构 `{pre}find_password`
--

DROP TABLE IF EXISTS `{pre}find_password`;
CREATE TABLE  `{pre}find_password` (
  `id` INT(11) unsigned NOT NULL auto_increment ,
  `user_id` INT(11) unsigned NOT NULL COMMENT '用户ID',
  `hash` CHAR(32) NOT NULL COMMENT '随机值',
  `addtime` INT NOT NULL COMMENT '申请找回的时间',
  PRIMARY KEY (`id`) ,
  INDEX (`hash`),
  INDEX (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='找回密码';

-- --------------------------------------------------------

--
-- 表的结构 `{pre}invoice`
--

DROP TABLE IF EXISTS `{pre}invoice`;
CREATE TABLE `{pre}invoice` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `user_id` int(11) unsigned default NULL COMMENT '用户id',
  `type` tinyint(1) NOT NULL default '1' COMMENT '发票类型,1:普通发票,2:增值税专用发票',
  `company_name` varchar(80) NOT NULL COMMENT '单位名称',
  `taxcode` varchar(30) NOT NULL COMMENT '纳税人识别码',
  `address` varchar(100) default NULL COMMENT '注册地址',
  `telphone` varchar(20) default NULL COMMENT '注册电话',
  `bankname` varchar(80) default NULL COMMENT '开户银行',
  `bankno` varchar(30) default NULL COMMENT '银行账户',
  PRIMARY KEY  (`id`),
  index (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='发票表';

-- --------------------------------------------------------

--
-- 表的结构 `{pre}address`
--

DROP TABLE IF EXISTS `{pre}address`;
CREATE TABLE `{pre}address` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `user_id` int(11) unsigned NOT NULL COMMENT '用户ID',
  `accept_name` varchar(20) NOT NULL COMMENT '收货人姓名',
  `zip` varchar(6) default NULL COMMENT '邮编',
  `telphone` varchar(20) default NULL COMMENT '联系电话',
  `country` int(11) unsigned default NULL COMMENT '国ID',
  `province` int(11) unsigned NOT NULL COMMENT '省ID',
  `city` int(11) unsigned NOT NULL COMMENT '市ID',
  `area` int(11) unsigned NOT NULL COMMENT '区ID',
  `address` varchar(250) NOT NULL COMMENT '收货地址',
  `mobile` varchar(20) default NULL COMMENT '手机',
  `is_default` tinyint(1) NOT NULL default '0' COMMENT '是否默认,0:为非默认,1:默认',
  PRIMARY KEY  (`id`),
  index (`user_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='收货信息表';

-- --------------------------------------------------------

--
-- 表的结构 `{pre}freight_company`
--

DROP TABLE IF EXISTS `{pre}freight_company`;
CREATE TABLE `{pre}freight_company` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `freight_type` varchar(255) NOT NULL COMMENT '货运代号',
  `freight_name` varchar(255) NOT NULL COMMENT '货运公司名称',
  `url` varchar(255) NOT NULL COMMENT '网址',
  `sort` smallint(5) NOT NULL DEFAULT '99' COMMENT '排序',
  `is_del` tinyint(1) NOT NULL DEFAULT '0' COMMENT '0:未删除 1:删除',
  PRIMARY KEY (`id`),
  index (`sort`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='货运公司';

INSERT INTO `{pre}freight_company` VALUES (NULL,'EMS','ems','http://www.ems.com.cn',0,0);
INSERT INTO `{pre}freight_company` VALUES (NULL,'STO','申通','http://www.sto.cn',0,0);
INSERT INTO `{pre}freight_company` VALUES (NULL,'HHTT','天天','http://www.ttkd.cn',0,0);
INSERT INTO `{pre}freight_company` VALUES (NULL,'YTO','圆通','http://www.yto.net.cn',0,0);
INSERT INTO `{pre}freight_company` VALUES (NULL,'SF','顺丰','http://www.sf-express.com',0,0);
INSERT INTO `{pre}freight_company` VALUES (NULL,'YD','韵达','http://www.yundaex.com',0,0);
INSERT INTO `{pre}freight_company` VALUES (NULL,'ZTO','中通','http://www.zto.cn',0,0);
INSERT INTO `{pre}freight_company` VALUES (NULL,'LB','龙邦物流','http://www.lbex.com.cn',0,0);
INSERT INTO `{pre}freight_company` VALUES (NULL,'ZJS','宅急送','http://www.zjs.com.cn',0,0);
INSERT INTO `{pre}freight_company` VALUES (NULL,'UAPEX','全一快递','http://www.apex100.com',0,0);
INSERT INTO `{pre}freight_company` VALUES (NULL,'HTKY','汇通速递','http://www.htky365.com',0,0);
INSERT INTO `{pre}freight_company` VALUES (NULL,'MHKD','民航快递','http://www.cae.com.cn',0,0);
INSERT INTO `{pre}freight_company` VALUES (NULL,'ZTKY','中铁快运','http://www.cre.cn',0,0);
INSERT INTO `{pre}freight_company` VALUES (NULL,'FEDEX','fedex','http://www.fedex.com/cn',0,0);
INSERT INTO `{pre}freight_company` VALUES (NULL,'DHL','DHL','http://www.cn.dhl.com',0,0);
INSERT INTO `{pre}freight_company` VALUES (NULL,'DBL','德邦物流','http://www.deppon.com',0,0);
INSERT INTO `{pre}freight_company` VALUES (NULL,'FAST','快捷速递','http://www.kjkd.com',0,0);
INSERT INTO `{pre}freight_company` VALUES (NULL,'YZBK','邮政国内','http://www.ems.com.cn',0,0);
INSERT INTO `{pre}freight_company` VALUES (NULL,'GTO','国通快递','http://www.gto365.com',0,0);
INSERT INTO `{pre}freight_company` VALUES (NULL,'HTKY','百世物流','http://www.800bestex.com',0,0);
INSERT INTO `{pre}freight_company` VALUES (NULL,'YCWL','远成物流','http://www.ycgky.com',0,0);
INSERT INTO `{pre}freight_company` VALUES (NULL,'UC','优速物流','http://www.uc56.com',0,0);

-- --------------------------------------------------------

--
-- 表的结构 `{pre}expresswaybill`
--

DROP TABLE IF EXISTS `{pre}expresswaybill`;
CREATE TABLE `{pre}expresswaybill` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `freight_type` varchar(255) NOT NULL COMMENT '货运代号',
  `freight_name` varchar(255) NOT NULL COMMENT '货运公司名称',
  `url` varchar(255) NOT NULL COMMENT '网址',
  `config` text COMMENT '快递单打印配置JSON',
  `description` varchar(255) default NULL COMMENT '描述',
  `is_open` tinyint(1) NOT NULL default 0 COMMENT '是否开启:0关闭;1:开启;',
  `seller_id` int(11) unsigned NOT NULL default '0' COMMENT '商家ID',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='快递单打印物流公司';

INSERT INTO `{pre}expresswaybill` VALUES (NULL,'SF','顺丰速运','http://www.sf-express.com','','无需申请直接可用',1,0);
INSERT INTO `{pre}expresswaybill` VALUES (NULL,'FAST','快捷快递','http://www.kjkd.com/','','无需申请直接可用',1,0);
INSERT INTO `{pre}expresswaybill` VALUES (NULL,'ZTKY','中铁快运','http://www.cre.cn','','无需申请直接可用',1,0);
INSERT INTO `{pre}expresswaybill` VALUES (NULL,'YZBK','邮政国内标快','http://www.ems.com.cn','','无需申请直接可用',1,0);
INSERT INTO `{pre}expresswaybill` VALUES (NULL,'YZPY','邮政快递包裹','http://www.ems.com.cn','','无需申请直接可用',1,0);
INSERT INTO `{pre}expresswaybill` VALUES (NULL,'ZJS','宅急送','http://www.zjs.com.cn','','无需申请直接可用',1,0);
INSERT INTO `{pre}expresswaybill` VALUES (NULL,'UAPEX','全一快递','http://www.unitop-apex.com','','无需申请直接可用',1,0);
INSERT INTO `{pre}expresswaybill` VALUES (NULL,'ZTO','中通快递','http://www.zto.com','{"CustomerName":"","CustomerPwd":""}','需要去营业网点申请<商家ID>，<商家密码>',0,0);
INSERT INTO `{pre}expresswaybill` VALUES (NULL,'STO','申通快递','http://www.sto.cn','{"CustomerName":"","CustomerPwd":"","SendSite":""}','需要去营业网点申请<客户简称>，<客户密码>，<所属网点>',0,0);
INSERT INTO `{pre}expresswaybill` VALUES (NULL,'DBL','德邦快递','https://www.deppon.com','{"CustomerName":""}','需要去营业网点申请<月结编码>',0,0);
INSERT INTO `{pre}expresswaybill` VALUES (NULL,'HHTT','天天快递','http://www.ttkdex.com','{"CustomerName":"","CustomerPwd":"","SendSite":""}','需要去营业网点申请<客户账号>，<客户密码>，<网点名称>',0,0);
INSERT INTO `{pre}expresswaybill` VALUES (NULL,'GTO','国通快递','http://www.gto365.com','{"CustomerName":"","CustomerPwd":"","SendSite":""}','需要去营业网点申请<客户简称>，<客户密码>，<网点名称>',0,0);
INSERT INTO `{pre}expresswaybill` VALUES (NULL,'KYSY','跨越速运','http://www.ky-express.com','{"CustomerName":""}','需要去营业网点申请<客户号>',0,0);
INSERT INTO `{pre}expresswaybill` VALUES (NULL,'YD','韵达速递','http://www.yundaex.com','{"CustomerName":"","CustomerPwd":""}','需要去营业网点申请<客户ID>，<接口联调密码>',0,0);
INSERT INTO `{pre}expresswaybill` VALUES (NULL,'HTKY','百世快递','http://www.800bestex.com','{"CustomerName":"","CustomerPwd":""}','需要去营业网点申请<操作编码>，<ERP秘钥>',0,0);
INSERT INTO `{pre}expresswaybill` VALUES (NULL,'YTO','圆通速递','http://www.yto.net.cn','{"CustomerName":"","MonthCode":""}','需要去营业网点申请<商家代码>，<密钥串>',0,0);
INSERT INTO `{pre}expresswaybill` VALUES (NULL,'YCWL','远成快运','http://www.ycgky.com','{"CustomerName":"","SendSite":""}','需要去营业网点申请<商户代码>，<网点名称>',0,0);
INSERT INTO `{pre}expresswaybill` VALUES (NULL,'UC','优速快递','http://www.uc56.com','{"CustomerName":"","CustomerPwd":""}','需要去营业网点申请<客户编号>，<密钥>',0,0);

-- --------------------------------------------------------

--
-- 表的结构 `{pre}ad_manage`
--

DROP TABLE IF EXISTS `{pre}ad_manage`;
CREATE TABLE `{pre}ad_manage` (
  `id` int(11) unsigned NOT NULL auto_increment COMMENT '广告ID',
  `name` varchar(50) NOT NULL COMMENT '广告名称',
  `type` tinyint(1) NOT NULL COMMENT '广告类型 1:img 2:flash 3:文字 4:code',
  `position_id` int(11) unsigned default '0' COMMENT '广告位ID',
  `link` varchar(255) default NULL COMMENT '链接地址',
  `order` smallint(5) NOT NULL default '0' COMMENT '排列顺序',
  `start_time` date default NULL COMMENT '开始时间',
  `end_time` date default NULL COMMENT '结束时间',
  `content` text COMMENT '图片、flash路径，文字，code等',
  `description` varchar(255) default NULL COMMENT '描述',
  `goods_cat_id` int(11) unsigned default '0' COMMENT '绑定的商品分类ID',
  `seller_id` int(11) unsigned NOT NULL default '0' COMMENT '商家ID',
  `_hash` int(11) unsigned NOT NULL COMMENT '预留散列字段',
  PRIMARY KEY  (`id`,`_hash`),
  index (`position_id`),
  index (`seller_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='广告记录表';

-- --------------------------------------------------------

--
-- 表的结构 `{pre}ad_position`
--

DROP TABLE IF EXISTS `{pre}ad_position`;
CREATE TABLE `{pre}ad_position` (
  `id` int(11) unsigned NOT NULL auto_increment COMMENT '广告位ID',
  `name` varchar(30) NOT NULL COMMENT '广告位名称',
  `width` varchar(255) NOT NULL COMMENT '广告位宽度,px或者%',
  `height` varchar(255) NOT NULL COMMENT '广告位高度,px或者%',
  `fashion` tinyint(1) NOT NULL COMMENT '1:轮显;2:随即',
  `status` tinyint(1) NOT NULL default '0' COMMENT '1:开启; 0: 关闭',
  `seller_id` int(11) unsigned NOT NULL default '0' COMMENT '商家ID',
  `_hash` int(11) unsigned NOT NULL COMMENT '预留散列字段',
  PRIMARY KEY  (`id`,`_hash`),
  index (`name`,`status`),
  index (`seller_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='广告位记录表';

-- --------------------------------------------------------

--
-- 表的结构 `{pre}announcement`
--

DROP TABLE IF EXISTS `{pre}announcement`;
CREATE TABLE `{pre}announcement` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `title` varchar(255) NOT NULL COMMENT '公告标题',
  `content` text COMMENT '公告内容',
  `time` datetime NOT NULL COMMENT '发布时间',
  `keywords` varchar(255) default NULL COMMENT '关键词',
  `description` varchar(255) default NULL COMMENT '描述',
  `_hash` int(11) unsigned NOT NULL COMMENT '预留散列字段',
  PRIMARY KEY  (`id`,`_hash`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='公告消息表';

-- --------------------------------------------------------

--
-- 表的结构 `{pre}session`
--

DROP TABLE IF EXISTS `{pre}session`;
CREATE TABLE `{pre}session` (
  `id` char(32) NOT NULL COMMENT 'session的唯一id',
  `value` text COMMENT 'session序列化数据',
  `time` datetime NOT NULL COMMENT '存储时间',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='session会话表';

-- --------------------------------------------------------

--
-- 表的结构 `{pre}areas`
--

DROP TABLE IF EXISTS `{pre}areas`;
CREATE TABLE `{pre}areas` (
  `area_id` int(10) unsigned NOT NULL auto_increment,
  `parent_id` int(10) unsigned NOT NULL COMMENT '上一级的id值',
  `area_name` varchar(50) NOT NULL COMMENT '地区名称',
  `sort` int(10) unsigned NOT NULL default '99' COMMENT '排序',
  PRIMARY KEY  (`area_id`),
  index (`area_name`),
  index (`parent_id`),
  index (`sort`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='地区信息';

-- --------------------------------------------------------

--
-- 表的结构 `{pre}relation`
--

DROP TABLE IF EXISTS `{pre}relation`;
CREATE TABLE `{pre}relation` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `goods_id` int(11) unsigned NOT NULL COMMENT '商品ID',
  `article_id` int(11) unsigned NOT NULL COMMENT '文章ID',
  PRIMARY KEY  (`id`),
  index (`goods_id`),
  index (`article_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='文章商品关系表';

-- --------------------------------------------------------

--
-- 表的结构 `{pre}article`
--

DROP TABLE IF EXISTS `{pre}article`;
CREATE TABLE `{pre}article` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `title` varchar(250) NOT NULL COMMENT '标题',
  `content` text NOT NULL COMMENT '内容',
  `category_id` int(11) unsigned NOT NULL COMMENT '分类ID',
  `create_time` datetime NOT NULL COMMENT '发布时间',
  `keywords` varchar(255) default NULL COMMENT '关键词',
  `description` varchar(255) default NULL COMMENT '描述',
  `visibility` tinyint(1) NOT NULL default '1' COMMENT '是否显示 0:不显示,1:显示',
  `top` tinyint(1) NOT NULL default '0' COMMENT '置顶',
  `sort` int(11) NOT NULL default '0' COMMENT '排序',
  `style` tinyint(1) NOT NULL default '0' COMMENT '标题字体 0正常 1粗体,2斜体',
  `color` varchar(7) default NULL COMMENT '标题颜色',
  `_hash` int(11) unsigned NOT NULL COMMENT '预留散列字段',
  PRIMARY KEY  (`id`,`_hash`),
  index (`sort`),
  index (`category_id`,`visibility`),
  index (`visibility`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='文章表';

-- --------------------------------------------------------

--
-- 表的结构 `{pre}article_category`
--

DROP TABLE IF EXISTS `{pre}article_category`;
CREATE TABLE `{pre}article_category` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `name` varchar(50) NOT NULL COMMENT '分类名称',
  `parent_id` int(11) unsigned NOT NULL default '0' COMMENT '父分类',
  `issys` tinyint(1) NOT NULL default '0' COMMENT '系统分类',
  `sort` int(11) NOT NULL default '0' COMMENT '排序',
  `path` varchar(255) default NULL COMMENT '路径',
  `title` varchar(255) default NULL COMMENT 'SEO标题',
  `keywords` varchar(255) default NULL COMMENT 'SEO关键词和检索关键词',
  `description` varchar(255) default NULL COMMENT 'SEO描述',
  `_hash` int(11) unsigned NOT NULL COMMENT '预留散列字段',
  PRIMARY KEY  (`id`,`_hash`),
  index (`parent_id`),
  index (`sort`),
  index (`issys`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='文章分类';

-- --------------------------------------------------------

--
-- 表的结构 `{pre}attribute`
--

DROP TABLE IF EXISTS `{pre}attribute`;
CREATE TABLE `{pre}attribute` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `model_id` int(11) unsigned default NULL COMMENT '模型ID',
  `type` tinyint(1) default NULL COMMENT '输入控件的类型,1:单选,2:复选,3:下拉,4:输入框',
  `name` varchar(50) default NULL COMMENT '名称',
  `value` text COMMENT '属性值(逗号分隔)',
  `search` tinyint(1) NOT NULL default '0' COMMENT '是否支持搜索0不支持1支持',
  PRIMARY KEY  (`id`),
  index (`model_id`,`search`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='属性表';

-- --------------------------------------------------------

--
-- 表的结构 `{pre}banner`
--

DROP TABLE IF EXISTS `{pre}banner`;
CREATE TABLE `{pre}banner` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `name` varchar(255) NOT NULL DEFAULT '' COMMENT 'Banner名称',
  `url` varchar(255) NOT NULL DEFAULT '' COMMENT '链接地址',
  `img` varchar(255) NOT NULL DEFAULT '' COMMENT '图片文件',
  `type` enum('mobile','pc') NOT NULL DEFAULT 'pc' COMMENT '类型,pc:电脑端;mobile:手机端',
  `_hash` int(11) unsigned NOT NULL COMMENT '预留散列字段',
  `seller_id` int(11) unsigned NOT NULL default '0' COMMENT '商家ID',
  PRIMARY KEY (`id`,`_hash`),
  index (`seller_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='幻灯片表';
-- --------------------------------------------------------

--
-- 表的结构 `{pre}search`
--
DROP TABLE IF EXISTS `{pre}search`;
CREATE TABLE `{pre}search` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `keyword` varchar(255) NOT NULL COMMENT '搜索关键字',
  `num` int(11) unsigned NOT NULL default '0' COMMENT '搜索次数',
  PRIMARY KEY  (`id`),
  index (`keyword`(12))
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='搜索关键字';


--
-- 表的结构 `{pre}brand`
--

DROP TABLE IF EXISTS `{pre}brand`;
CREATE TABLE `{pre}brand` (
  `id` int(11) unsigned NOT NULL auto_increment COMMENT '品牌ID',
  `name` varchar(255) NOT NULL COMMENT '品牌名称',
  `logo` varchar(255) default NULL COMMENT 'logo地址',
  `url` varchar(255) default NULL COMMENT '网址',
  `description` text COMMENT '描述',
  `sort` smallint(5) NOT NULL default '0' COMMENT '排序',
  `category_ids` varchar(255) default NULL COMMENT '品牌分类,逗号分割id',
  `_hash` int(11) unsigned NOT NULL COMMENT '预留散列字段',
  PRIMARY KEY  (`id`,`_hash`),
  index (`sort`),
  index (`category_ids`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='品牌表';

-- --------------------------------------------------------

--
-- 表的结构 `{pre}brand_category`
--

DROP TABLE IF EXISTS `{pre}brand_category`;
CREATE TABLE `{pre}brand_category` (
  `id` int(11) unsigned NOT NULL auto_increment COMMENT '分类ID',
  `name` varchar(255) NOT NULL COMMENT '分类名称',
  `goods_category_id` int(11) unsigned not null default '0' comment '商品分类ID',
  `_hash` int(11) unsigned NOT NULL COMMENT '预留散列字段',
  PRIMARY KEY  (`id`,`_hash`),
  index (`goods_category_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='品牌分类表';

-- --------------------------------------------------------

--
-- 表的结构 `{pre}category_extend`
--

DROP TABLE IF EXISTS `{pre}category_extend`;
CREATE TABLE `{pre}category_extend` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `goods_id` int(11) unsigned NOT NULL COMMENT '商品ID',
  `category_id` int(11) unsigned NOT NULL COMMENT '商品分类ID',
  PRIMARY KEY  (`id`),
  index (`goods_id`),
  index (`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='商品与其分类关系表';

-- --------------------------------------------------------
--
-- 表的结构 `{pre}category_extend_seller`
--

DROP TABLE IF EXISTS `{pre}category_extend_seller`;
CREATE TABLE `{pre}category_extend_seller` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `goods_id` int(11) unsigned NOT NULL COMMENT '商品ID',
  `category_id` int(11) unsigned NOT NULL COMMENT '商品分类ID',
  PRIMARY KEY  (`id`),
  index (`goods_id`),
  index (`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='商家店内商品分类与商品关系表';

-- --------------------------------------------------------
--
-- 表的结构 `{pre}category_rate`
--

DROP TABLE IF EXISTS `{pre}category_rate`;
CREATE TABLE `{pre}category_rate` (
  `category_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '商品分类ID',
  `category_rate` decimal(15,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '商品分类手续费',
  PRIMARY KEY (`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='商品分类手续费设置表';

----------------------------------------------------------

--
-- 表的结构 `{pre}category_seller`
--

DROP TABLE IF EXISTS `{pre}category_seller`;
CREATE TABLE `{pre}category_seller` (
  `id` int(11) unsigned NOT NULL auto_increment COMMENT '分类ID',
  `name` varchar(50) NOT NULL COMMENT '分类名称',
  `parent_id` int(11) unsigned NOT NULL COMMENT '父分类ID',
  `sort` smallint(5) NOT NULL default '0' COMMENT '排序',
  `keywords` varchar(255) default NULL COMMENT 'SEO关键词和检索关键词',
  `descript` varchar(255) default NULL COMMENT 'SEO描述',
  `title` varchar(255) default NULL COMMENT 'SEO标题title',
  `seller_id` int(11) unsigned NOT NULL COMMENT '商家ID',
  PRIMARY KEY  (`id`),
  index (`parent_id`),
  index (`sort`),
  index (`seller_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='商家店内商品分类表';

-- --------------------------------------------------------
--
-- 表的结构 `{pre}collection_doc`
--

DROP TABLE IF EXISTS `{pre}collection_doc`;
CREATE TABLE `{pre}collection_doc` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `order_id` int(11) unsigned NOT NULL COMMENT '订单号',
  `user_id` int(11) unsigned NOT NULL COMMENT '用户ID',
  `amount` decimal(15,2) NOT NULL default '0.00' COMMENT '金额',
  `time` datetime NOT NULL COMMENT '时间',
  `payment_id` int(11) unsigned NOT NULL COMMENT '支付方式ID',
  `admin_id` int(11) unsigned default NULL COMMENT '管理员id',
  `pay_status` tinyint(1) NOT NULL default '0' COMMENT '支付状态，0:准备，1:支付成功',
  `note` text COMMENT '收款备注',
  `if_del` tinyint(1) NOT NULL default '0' COMMENT '0:未删除 1:删除',
  `_hash` int(11) unsigned NOT NULL COMMENT '预留散列字段',
  PRIMARY KEY  (`id`,`_hash`),
  index (`order_id`),
  index (`user_id`),
  index (`if_del`),
  index (`payment_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='收款单';

-- --------------------------------------------------------

--
-- 表的结构 `{pre}commend_goods`
--

DROP TABLE IF EXISTS `{pre}commend_goods`;
CREATE TABLE `{pre}commend_goods` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `commend_id` int(11) unsigned NOT NULL COMMENT '推荐类型ID 1:最新商品 2:特价商品 3:热卖排行 4:推荐商品',
  `goods_id` int(11) unsigned NOT NULL COMMENT '商品ID',
  `_hash` int(11) unsigned NOT NULL COMMENT '预留散列字段',
  PRIMARY KEY  (`id`,`_hash`),
  index (`goods_id`),
  index (`commend_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='推荐类商品';

-- --------------------------------------------------------

--
-- 表的结构 `{pre}comment`
--

DROP TABLE IF EXISTS `{pre}comment`;
CREATE TABLE `{pre}comment` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `goods_id` int(11) unsigned NOT NULL COMMENT '商品ID',
  `order_no` varchar(20) NOT NULL COMMENT '订单编号',
  `user_id` int(11) unsigned NOT NULL COMMENT '用户ID',
  `time` datetime NOT NULL COMMENT '购买时间',
  `comment_time` date NOT NULL COMMENT '评论时间',
  `contents` text COMMENT '评论内容',
  `recontents` text COMMENT '回复评论内容',
  `recomment_time` date NOT NULL COMMENT '回复评论时间',
  `point` tinyint(1) NOT NULL default '0' COMMENT '评论的分数',
  `status` tinyint(1) NOT NULL default '0' COMMENT '评论状态：0：未评论 1:已评论',
  `seller_id` int(11) unsigned NOT NULL default '0' COMMENT '商家ID',
  `order_goods_id` int(11) unsigned default NULL COMMENT '订单商品表中的ID',
  `img_list` text COMMENT '评价图片',
  `_hash` int(11) unsigned NOT NULL COMMENT '预留散列字段',
  PRIMARY KEY  (`id`,`_hash`),
  index (`goods_id`),
  index (`order_goods_id`),
  index (`user_id`,`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='商品评论表';

-- --------------------------------------------------------

--
-- 表的结构 `{pre}delivery`
--

DROP TABLE IF EXISTS `{pre}delivery`;
CREATE TABLE `{pre}delivery` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `name` varchar(50) default NULL COMMENT '快递名称',
  `description` varchar(50) default NULL COMMENT '快递描述',
  `area_groupid` text COMMENT '配送区域id',
  `firstprice` text COMMENT '配送地址对应的首重价格',
  `secondprice` text COMMENT '配送地区对应的续重价格',
  `type` tinyint(1) NOT NULL default '0' COMMENT '配送类型 0先付款后发货 1先发货后付款',
  `first_weight` int(11) unsigned NOT NULL COMMENT '首重重量(克)',
  `second_weight` int(11) unsigned NOT NULL COMMENT '续重重量(克)',
  `first_price` decimal(15,2) NOT NULL default '0.00' COMMENT '首重价格',
  `second_price` decimal(15,2) NOT NULL default '0.00' COMMENT '续重价格',
  `status` tinyint(1) NOT NULL default '1' COMMENT '开启状态 1启用 0关闭',
  `sort` smallint(5) NOT NULL default '99' COMMENT '排序',
  `is_save_price` tinyint(1) NOT NULL default '0' COMMENT '是否支持物流保价 1支持保价 0  不支持保价',
  `save_rate` decimal(15,2) NOT NULL default '0.00' COMMENT '保价费率',
  `low_price` decimal(15,2) NOT NULL default '0.00' COMMENT '最低保价',
  `price_type` tinyint(1) NOT NULL default '0' COMMENT '费用类型 0统一设置 1指定地区费用',
  `open_default` tinyint(1) NOT NULL default '1' COMMENT '其他地区是否启用默认费用 1启用 0 不启用',
  `is_delete` tinyint(1) NOT NULL default '0' COMMENT '是否删除 0:未删除 1:删除',
  PRIMARY KEY  (`id`),
  index (`status`),
  index (`sort`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='配送方式表';

-- --------------------------------------------------------

--
-- 表的结构 `{pre}delivery_extend`
--

DROP TABLE IF EXISTS `{pre}delivery_extend`;
CREATE TABLE `{pre}delivery_extend` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `delivery_id` int(11) unsigned NOT NULL COMMENT '配送方式关联ID',
  `area_groupid` text COMMENT '单独配置地区id',
  `firstprice` text COMMENT '单独配置地区对应的首重价格',
  `secondprice` text COMMENT '单独配置地区对应的续重价格',
  `first_weight` int(11) unsigned NOT NULL COMMENT '首重重量(克)',
  `second_weight` int(11) unsigned NOT NULL COMMENT '续重重量(克)',
  `first_price` decimal(15,2) NOT NULL default '0.00' COMMENT '默认首重价格',
  `second_price` decimal(15,2) NOT NULL default '0.00' COMMENT '默认续重价格',
  `is_save_price` tinyint(1) NOT NULL default '0' COMMENT '是否支持物流保价 1支持保价 0  不支持保价',
  `save_rate` decimal(15,2) NOT NULL default '0.00' COMMENT '保价费率',
  `low_price` decimal(15,2) NOT NULL default '0.00' COMMENT '最低保价',
  `price_type` tinyint(1) NOT NULL default '0' COMMENT '费用类型 0统一设置 1指定地区费用',
  `open_default` tinyint(1) NOT NULL default '1' COMMENT '其他地区是否启用默认费用 1启用 0 不启用',
  `seller_id` int(11) unsigned NOT NULL COMMENT '商家ID',
  PRIMARY KEY  (`id`),
  index (`delivery_id`),
  index (`seller_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='商家配送方式扩展表';

-- --------------------------------------------------------

--
-- 表的结构 `{pre}delivery_doc`
--

DROP TABLE IF EXISTS `{pre}delivery_doc`;
CREATE TABLE `{pre}delivery_doc` (
  `id` int(11) unsigned NOT NULL auto_increment COMMENT '发货单ID',
  `order_id` int(11) unsigned NOT NULL COMMENT '订单ID',
  `user_id` int(11) unsigned NOT NULL COMMENT '用户ID',
  `admin_id` int(11) unsigned default '0' COMMENT '管理员ID',
  `seller_id` int(11) unsigned default '0' COMMENT '商户ID',
  `name` varchar(255) NOT NULL COMMENT '收货人',
  `postcode` varchar(6) default NULL COMMENT '邮编',
  `telphone` varchar(20) default NULL COMMENT '联系电话',
  `country` int(11) unsigned default NULL COMMENT '国ID',
  `province` int(11) unsigned NOT NULL COMMENT '省ID',
  `city` int(11) unsigned NOT NULL COMMENT '市ID',
  `area` int(11) unsigned NOT NULL COMMENT '区ID',
  `address` varchar(250) NOT NULL COMMENT '收货地址',
  `mobile` varchar(20) default NULL COMMENT '手机',
  `time` datetime NOT NULL COMMENT '创建时间',
  `freight` decimal(15,2) NOT NULL default '0.00' COMMENT '运费',
  `delivery_code` varchar(255) NOT NULL COMMENT '物流单号',
  `delivery_type` int(11) NOT NULL COMMENT '物流方式',
  `note` text COMMENT '管理员添加的备注信息',
  `if_del` tinyint(1) NOT NULL default '0' COMMENT '0:未删除 1:已删除',
  `freight_id` int(11) unsigned default NULL COMMENT '货运公司ID',
  `express_template` mediumtext default NULL COMMENT '快递单模板',
  `_hash` int(11) unsigned NOT NULL COMMENT '预留散列字段',
  PRIMARY KEY  (`id`,`_hash`),
  index (`order_id`),
  index (`user_id`),
  index (`delivery_code`),
  index (`freight_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='发货单';

-- --------------------------------------------------------

--
-- 表的结构 `{pre}discussion`
--

DROP TABLE IF EXISTS `{pre}discussion`;
CREATE TABLE `{pre}discussion` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `goods_id` int(11) unsigned NOT NULL COMMENT '商品ID',
  `user_id` int(11) unsigned  NOT NULL COMMENT '用户ID',
  `time` datetime NOT NULL COMMENT '评论时间',
  `contents` text COMMENT '评论内容',
  `is_check` tinyint(1) NOT NULL default '0' COMMENT '审核状态,0未审核 1已审核',
  `_hash` int(11) unsigned NOT NULL COMMENT '预留散列字段',
  PRIMARY KEY  (`id`,`_hash`),
  index (`user_id`),
  index (`goods_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='商品讨论表';

-- --------------------------------------------------------

--
-- 表的结构 `{pre}email_registry`
--

DROP TABLE IF EXISTS `{pre}email_registry`;
CREATE TABLE `{pre}email_registry` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `email` varchar(80) NOT NULL COMMENT 'Email',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `email` (`email`(15))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Email订阅表';

-- --------------------------------------------------------

--
-- 表的结构 `{pre}favorite`
--

DROP TABLE IF EXISTS `{pre}favorite`;
CREATE TABLE `{pre}favorite` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `user_id` int(11) unsigned  NOT NULL COMMENT '用户ID',
  `goods_id` int(11) unsigned NOT NULL COMMENT '商品ID',
  `time` datetime NOT NULL COMMENT '收藏时间',
  `summary` varchar(255) default NULL COMMENT '备注',
  `cat_id` int(11) unsigned NOT NULL COMMENT '商品分类',
  PRIMARY KEY  (`id`),
  index (`user_id`),
  index (`cat_id`),
  index (`goods_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='收藏夹表';

-- --------------------------------------------------------

--
-- 表的结构 `{pre}goods_attribute`
--

DROP TABLE IF EXISTS `{pre}goods_attribute`;
CREATE TABLE `{pre}goods_attribute` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `goods_id` int(11) unsigned NOT NULL COMMENT '商品ID',
  `attribute_id` int(11) unsigned default NULL COMMENT '属性ID',
  `attribute_value` varchar(255) default NULL COMMENT '属性值',
  `model_id` int(11) unsigned default NULL COMMENT '模型ID',
  `order` smallint(5) NOT NULL default '99' COMMENT '排序',
  PRIMARY KEY  (`id`),
  index (`goods_id`),
  index (`attribute_id`,`attribute_value`),
  index (`order`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='属性值表';

-- --------------------------------------------------------

--
-- 表的结构 `{pre}goods_car`
--

DROP TABLE IF EXISTS `{pre}goods_car`;
CREATE TABLE `{pre}goods_car` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `user_id` int(11) unsigned NOT NULL COMMENT '用户ID',
  `content` text COMMENT '购物内容',
  `create_time` datetime NOT NULL COMMENT '创建时间',
  `unselected` TEXT COMMENT '未选择结算的商品信息',
  PRIMARY KEY  (`id`),
  index (`user_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='购物车';

-- --------------------------------------------------------

--
-- 表的结构 `{pre}goods_photo`
--

DROP TABLE IF EXISTS `{pre}goods_photo`;
CREATE TABLE `{pre}goods_photo` (
  `id` char(32) NOT NULL COMMENT '图片的md5值',
  `img` varchar(255) default NULL COMMENT '原始图片路径',
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='图片表';

-- --------------------------------------------------------

--
-- 表的结构 `{pre}goods_photo_relation`
--

DROP TABLE IF EXISTS `{pre}goods_photo_relation`;
CREATE TABLE `{pre}goods_photo_relation` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `goods_id` int(11) unsigned NOT NULL COMMENT '商品ID',
  `photo_id` char(32) NOT NULL default '' COMMENT '图片ID,图片的md5值',
  PRIMARY KEY  (`id`),
  index (`goods_id`),
  index (`photo_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='相册商品关系表';

----------------------------------------------------------

--
-- 表的结构 `{pre}goods_rate`
--

DROP TABLE IF EXISTS `{pre}goods_rate`;
CREATE TABLE `{pre}goods_rate` (
  `goods_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '商品ID',
  `goods_rate` decimal(15,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '单品手续费',
  PRIMARY KEY (`goods_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='单个商品手续费设置表';

----------------------------------------------------------

--
-- 表的结构 `{pre}group_price`
--

DROP TABLE IF EXISTS `{pre}group_price`;
CREATE TABLE `{pre}group_price` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `goods_id` int(11) unsigned NOT NULL COMMENT '产品ID',
  `product_id` int(11) unsigned default NULL COMMENT '货品ID',
  `group_id` int(11) unsigned NOT NULL COMMENT '用户组ID',
  `price` decimal(15,2) NOT NULL default '0.00' COMMENT '价格',
  PRIMARY KEY  (`id`),
  index (`goods_id`),
  index (`group_id`),
  index (`product_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='记录某件商品对于某组会员的价格关系表，优先权大于组设定的折扣率';

-- --------------------------------------------------------

--
-- 表的结构 `{pre}guide`
--

DROP TABLE IF EXISTS `{pre}guide`;
CREATE TABLE `{pre}guide` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `name` varchar(255) NOT NULL COMMENT '导航名字',
  `link` varchar(255) NOT NULL COMMENT '链接地址',
  `seller_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '卖家ID',
  `_hash` int(11) unsigned NOT NULL COMMENT '预留散列字段',
  PRIMARY KEY  (`id`,`_hash`),
  index(`seller_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='导航栏';


INSERT INTO `{pre}guide` (`id`,`name`,`link`) VALUES
(null, '产品官网', 'http://www.aircheng.com'),
(null, '后台管理', 'admin/index'),
(null, '商家管理', 'seller/index');

-- --------------------------------------------------------

--
-- 表的结构 `{pre}help`
--

DROP TABLE IF EXISTS `{pre}help`;
CREATE TABLE `{pre}help` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `cat_id` int(11) unsigned default NULL COMMENT '帮助分类，如果为0则代表着是下面的帮助单页',
  `sort` smallint(5) NOT NULL default '99' COMMENT '顺序',
  `name` varchar(50) NOT NULL COMMENT '标题',
  `content` text NOT NULL COMMENT '内容',
  `dateline` int(11) NOT NULL COMMENT '发布时间',
  PRIMARY KEY (`id`),
  index (`cat_id`),
  index (`sort`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='帮助内容';

-- --------------------------------------------------------

--
-- 表的结构 `{pre}help_category`
--

DROP TABLE IF EXISTS `{pre}help_category`;
CREATE TABLE `{pre}help_category` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `name` varchar(10) NOT NULL COMMENT '标题',
  `sort` smallint(5) NOT NULL COMMENT '顺序',
  `position_left` tinyint(1) NOT NULL COMMENT '是否在帮助内容、列表页面的左侧显示',
  `position_foot` tinyint(1) NOT NULL COMMENT '是否在整站页面下方显示',
  PRIMARY KEY  (`id`),
  index (`sort`),
  index (`position_left`),
  index (`position_foot`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='帮助分类';

-- --------------------------------------------------------

--
-- 表的结构 `{pre}keyword`
--

DROP TABLE IF EXISTS `{pre}keyword`;
CREATE TABLE `{pre}keyword` (
  `word` varchar(15) NOT NULL COMMENT '关键词',
  `goods_nums` int(11) NOT NULL default '1' COMMENT '产品数量',
  `hot` tinyint(1) NOT NULL default '0' COMMENT '是否为热门',
  `order` smallint(5) NOT NULL default '99' COMMENT '关键词排序',
  `_hash` int(11) unsigned NOT NULL COMMENT '预留散列字段',
  PRIMARY KEY  (`word`,`_hash`),
  index (`hot`),
  index (`order`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='关键词';

-- --------------------------------------------------------

--
-- 表的结构 `{pre}log_error`
--

DROP TABLE IF EXISTS `{pre}log_error`;
CREATE TABLE `{pre}log_error` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `file` varchar(200) NOT NULL COMMENT '文件',
  `line` smallint(5) unsigned NOT NULL COMMENT '出错文件行数',
  `content` varchar(255) NOT NULL COMMENT '内容',
  `datetime` datetime NOT NULL COMMENT '时间',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='错误日志表';

-- --------------------------------------------------------

--
-- 表的结构 `{pre}log_operation`
--

DROP TABLE IF EXISTS `{pre}log_operation`;
CREATE TABLE `{pre}log_operation` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `author` varchar(80) NOT NULL COMMENT '操作人员',
  `action` varchar(200) NOT NULL COMMENT '动作',
  `content` text COMMENT '内容',
  `datetime` datetime NOT NULL COMMENT '时间',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='日志操作记录';

-- --------------------------------------------------------

--
-- 表的结构 `{pre}log_sql`
--

DROP TABLE IF EXISTS `{pre}log_sql`;
CREATE TABLE `{pre}log_sql` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `content` varchar(255) NOT NULL COMMENT '执行的SQL语句',
  `runtime` decimal(15,2) unsigned NOT NULL COMMENT '语句执行时间(秒)',
  `datetime` datetime NOT NULL COMMENT '发生的时间',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='SQL日志记录';

-- --------------------------------------------------------

--
-- 表的结构 `{pre}marketing_sms`
--

DROP TABLE IF EXISTS `{pre}marketing_sms`;
CREATE TABLE IF NOT EXISTS `{pre}marketing_sms` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `content` varchar(255) NOT NULL COMMENT '短信内容',
  `send_nums` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '发送成功数',
  `time` datetime NOT NULL COMMENT '发送时间',
  `rev_info` text COMMENT '收件人信息',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='营销短信';

-- --------------------------------------------------------

--
-- 表的结构 `{pre}member`
--

DROP TABLE IF EXISTS `{pre}member`;
CREATE TABLE `{pre}member` (
  `user_id` int(11) unsigned  NOT NULL COMMENT '用户ID',
  `true_name` varchar(50) default NULL COMMENT '真实姓名',
  `telephone` varchar(50) default NULL COMMENT '联系电话',
  `mobile` varchar(20) default NULL COMMENT '手机',
  `area` varchar(255) default NULL COMMENT '地区',
  `contact_addr` varchar(250) default NULL COMMENT '联系地址',
  `qq` varchar(15) default NULL COMMENT 'QQ',
  `sex` tinyint(1) NOT NULL default '1' COMMENT '性别1男2女',
  `birthday` date default NULL COMMENT '生日',
  `group_id` int(11) default NULL COMMENT '分组',
  `exp` int(11) NOT NULL default '0' COMMENT '经验值',
  `point` int(11) NOT NULL default '0' COMMENT '积分',
  `message_ids` text COMMENT '消息ID',
  `time` datetime default NULL COMMENT '注册日期时间',
  `zip` varchar(10) default NULL COMMENT '邮政编码',
  `status` tinyint(1) NOT NULL default '1' COMMENT '用户状态 1正常状态 2 删除至回收站 3锁定',
  `prop` text default NULL COMMENT '用户拥有的工具',
  `balance` decimal(15,2) NOT NULL default '0.00' COMMENT '用户预存款',
  `last_login` datetime default NULL COMMENT '最后一次登录时间',
  `custom` varchar(255) default NULL COMMENT '用户习惯方式,配送和支付方式等信息',
  `email` varchar(255) default NULL COMMENT 'Email',
  PRIMARY KEY  (`user_id`),
  index (`group_id`),
  index (`mobile`),
  index (`email`),
  index (`status`,`true_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='用户信息表';

-- --------------------------------------------------------

--
-- 表的结构 `{pre}merch_ship_info`
--

DROP TABLE IF EXISTS `{pre}merch_ship_info`;
CREATE TABLE `{pre}merch_ship_info` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `ship_name` varchar(255) NOT NULL COMMENT '发货点名称',
  `ship_user_name` varchar(255) NOT NULL COMMENT '发货人姓名',
  `sex` tinyint(1) NOT NULL default '0' COMMENT '性别 0:女 1:男',
  `country` int(11) default NULL COMMENT '国id',
  `province` int(11) NOT NULL COMMENT '省id',
  `city` int(11) NOT NULL COMMENT '市id',
  `area` int(11) NOT NULL COMMENT '地区id',
  `postcode` varchar(6) default NULL COMMENT '邮编',
  `address` varchar(255) NOT NULL COMMENT '具体地址',
  `mobile` varchar(20) NOT NULL COMMENT '手机',
  `telphone` varchar(20) default NULL COMMENT '电话',
  `is_default` tinyint(1) NOT NULL default '0' COMMENT '1为默认地址，0则不是',
  `note` text COMMENT '备注',
  `addtime` datetime NOT NULL COMMENT '保存时间',
  `is_del` tinyint(1) NOT NULL default '0' COMMENT '1为删除，0为未删除',
  `seller_id` int(11) unsigned  NOT NULL COMMENT '商家ID',
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='商家发货点信息';

-- --------------------------------------------------------

--
-- 表的结构 `{pre}message`
--

DROP TABLE IF EXISTS `{pre}message`;
CREATE TABLE `{pre}message` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `title` varchar(255) NOT NULL COMMENT '标题',
  `content` text COMMENT '内容',
  `time` datetime NOT NULL COMMENT '发送时间',
  `rev_info` text COMMENT '收件人信息',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='会员消息';

-- --------------------------------------------------------

--
-- 表的结构 `{pre}notify_registry`
--

DROP TABLE IF EXISTS `{pre}notify_registry`;
CREATE TABLE `{pre}notify_registry` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `goods_id` int(11) unsigned NOT NULL COMMENT '商品ID',
  `user_id` int(11) unsigned NOT NULL COMMENT '用户ID',
  `email` varchar(255) default NULL COMMENT 'emaill',
  `mobile` varchar(20) default NULL COMMENT '手机',
  `register_time` datetime NOT NULL COMMENT '登记时间',
  `notify_time` datetime default NULL COMMENT '通知时间',
  `notify_status` tinyint(1) NOT NULL default '0' COMMENT '0未通知1仅邮件通知2仅短信通知3已邮件、短信通知',
  PRIMARY KEY  (`id`),
  index (`goods_id`),
  index (`user_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='到货通知表';

-- --------------------------------------------------------

--
-- 表的结构 `{pre}order_goods`
--

DROP TABLE IF EXISTS `{pre}order_goods`;
CREATE TABLE `{pre}order_goods` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `order_id` int(11) unsigned NOT NULL COMMENT '订单ID',
  `goods_id` int(11) unsigned NOT NULL COMMENT '商品ID',
  `img` varchar(255) NOT NULL COMMENT '商品图片',
  `product_id` int(11) unsigned default '0' COMMENT '货品ID',
  `goods_price` decimal(15,2) NOT NULL default '0.00' COMMENT '商品原价',
  `real_price` decimal(15,2) NOT NULL default '0.00' COMMENT '实付金额',
  `goods_nums` int(11) NOT NULL default '1' COMMENT '商品数量',
  `goods_weight` decimal(15,2) NOT NULL default '0' COMMENT '重量',
  `goods_array` text COMMENT '商品和货品名称name和规格value串json数据格式',
  `is_send` tinyint(1) NOT NULL default '0' COMMENT '是否已发货 0:未发货;1:已发货;2:已经退款',
  `delivery_id` int(11) NOT NULL default '0' COMMENT '配送单ID',
  `seller_id` int(11) unsigned NOT NULL default '0' COMMENT '商家ID',
  PRIMARY KEY  (`id`),
  index (`goods_id`),
  index (`order_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='订单商品表';

-- --------------------------------------------------------

--
-- 表的结构 `{pre}order_goods_servicefee`
--
DROP TABLE IF EXISTS `{pre}order_goods_servicefee`;
CREATE TABLE `{pre}order_goods_servicefee` (
  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `order_id` int(11) UNSIGNED NOT NULL COMMENT '订单ID',
  `order_goods_id` int(11) UNSIGNED NOT NULL COMMENT '订单商品ID',
  `type` tinyint(1) NOT NULL DEFAULT '0' COMMENT '手续费类型 0:默认;1:单品;2:分类',
  `rate` decimal(15,2) UNSIGNED NOT NULL DEFAULT '0.00' COMMENT '手续费率',
  `discount` decimal(15,2) UNSIGNED NOT NULL DEFAULT '0.00' COMMENT '商户结算折扣率',
  `amount` decimal(15,2) UNSIGNED NOT NULL DEFAULT '0.00' COMMENT '手续费总额',
  PRIMARY KEY  (`id`),
  index (`order_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='订单商品手续费表';

-- --------------------------------------------------------

--
-- 表的结构 `{pre}order_log`
--

DROP TABLE IF EXISTS `{pre}order_log`;
CREATE TABLE `{pre}order_log` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `order_id` int(11) unsigned default NULL COMMENT '订单id',
  `user` varchar(20) default NULL COMMENT '操作人：顾客或admin或seller',
  `action` varchar(20) default NULL COMMENT '动作',
  `addtime` datetime default NULL COMMENT '添加时间',
  `result` varchar(10) default NULL COMMENT '操作的结果',
  `note` varchar(100) default NULL COMMENT '备注',
  PRIMARY KEY  (`id`),
  index (`order_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='订单日志表';

-- --------------------------------------------------------

--
-- 表的结构 `{pre}order_delivery_trace`
--

DROP TABLE IF EXISTS `{pre}order_delivery_trace`;
CREATE TABLE `{pre}order_delivery_trace` (
  `delivery_code` varchar(30) NOT NULL COMMENT '快递单号',
  `content` text COMMENT '物流跟踪信息',
  PRIMARY KEY  (`delivery_code`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='订单物流跟踪表';

-- --------------------------------------------------------

--
-- 表的结构 `{pre}payment`
--

DROP TABLE IF EXISTS `{pre}payment`;
CREATE TABLE `{pre}payment` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `name` varchar(50) NOT NULL COMMENT '支付名称',
  `type` tinyint(1) NOT NULL default '1' COMMENT '1:线上、2:线下',
  `class_name` varchar(50) NOT NULL COMMENT '支付类名称',
  `description` text COMMENT '描述',
  `logo` varchar(255) NOT NULL COMMENT '支付方式logo图片路径',
  `status` tinyint(1) NOT NULL default '1' COMMENT '安装状态 0启用 1禁用',
  `order` smallint(5) NOT NULL default '99' COMMENT '排序',
  `note` text COMMENT '支付说明',
  `config_param` text COMMENT '配置参数,json数据对象',
  `client_type` tinyint(1) NOT NULL default '1' COMMENT '1:PC端 2:移动端 3:通用',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='支付方式表';

-- --------------------------------------------------------

--
-- 表的结构 `{pre}point_log`
--

DROP TABLE IF EXISTS `{pre}point_log`;
CREATE TABLE `{pre}point_log` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `user_id` int(11) unsigned  NOT NULL COMMENT '用户id',
  `datetime` datetime NOT NULL COMMENT '发生时间',
  `value` int(11) NOT NULL COMMENT '积分增减 增加正数 减少负数',
  `intro` varchar(50) NOT NULL COMMENT '积分改动说明',
  PRIMARY KEY  (`id`),
  index (`user_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='积分增减记录表';

-- --------------------------------------------------------

--
-- 表的结构 `{pre}products`
--

DROP TABLE IF EXISTS `{pre}products`;
CREATE TABLE `{pre}products` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `goods_id` int(11) unsigned NOT NULL COMMENT '商品ID',
  `products_no` varchar(20) NOT NULL COMMENT '货品的货号(以商品的货号加横线加数字组成)',
  `spec_array` text COMMENT 'json规格数据',
  `store_nums` int(11) NOT NULL default '0' COMMENT '库存',
  `market_price` decimal(15,2) NOT NULL default '0.00' COMMENT '市场价格',
  `sell_price` decimal(15,2) NOT NULL default '0.00' COMMENT '销售价格',
  `cost_price` decimal(15,2) NOT NULL default '0.00' COMMENT '成本价格',
  `weight` decimal(15,2) NOT NULL default '0.00' COMMENT '重量',
  PRIMARY KEY  (`id`),
  index (`goods_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='货品表';

-- --------------------------------------------------------

--
-- 表的结构 `{pre}promotion`
--

DROP TABLE IF EXISTS `{pre}promotion`;
CREATE TABLE `{pre}promotion` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `start_time` datetime NOT NULL COMMENT '开始时间',
  `end_time` datetime NOT NULL COMMENT '结束时间',
  `sort` smallint(5) NOT NULL COMMENT '顺序',
  `condition` text NOT NULL COMMENT '活动生效条件 当type=0<促销规则消费额度>,当type=1<限时抢购商品ID>,type=2<特价商品分类ID>,type=3<特价商品ID>,type=4<特价商品品牌ID>,type=5<无意义>,type=6<充值金额>',
  `type` tinyint(1) NOT NULL default '0' COMMENT '活动类型 0:购物车促销规则 1:商品限时抢购 2:商品分类特价 3:商品单品特价 4:商品品牌特价 5:新用户注册促销规则 6:在线充值活动',
  `award_value` varchar(255) default NULL COMMENT '奖励值 type=0,5<奖励值>,type=1<抢购价格>,type=2,3,4<特价折扣>,type=6<充值奖励预存款>',
  `name` varchar(20) NOT NULL COMMENT '活动名称',
  `intro` text COMMENT '活动介绍',
  `award_type` tinyint(1) NOT NULL default '0' COMMENT '奖励方式:0商品限时抢购 1减金额 2奖励折扣 3赠送积分 4赠送优惠券 5赠送赠品 6免运费 7商品特价 8赠送经验',
  `is_close` tinyint(1) NOT NULL default '0' COMMENT '是否关闭 0:否 1:是',
  `user_group` text COMMENT '允许参与活动的用户组,all表示所有用户组',
  `seller_id` int(11) unsigned NOT NULL default '0' COMMENT '商家ID',
  `_hash` int(11) unsigned NOT NULL COMMENT '预留散列字段',
  PRIMARY KEY  (`id`,`_hash`),
  index (`type`,`seller_id`),
  index (`start_time`,`end_time`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='记录促销活动的表';

-- --------------------------------------------------------

--
-- 表的结构 `{pre}online_recharge`
--

DROP TABLE IF EXISTS `{pre}online_recharge`;
CREATE TABLE `{pre}online_recharge` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `user_id` int(11) unsigned  NOT NULL COMMENT '用户id',
  `recharge_no` varchar(20) NOT NULL COMMENT '充值单号',
  `account` decimal(15,2) NOT NULL default '0.00' COMMENT '充值金额',
  `time` datetime NOT NULL COMMENT '时间',
  `payment_name` varchar(80) NOT NULL COMMENT '充值方式名称',
  `status` tinyint(1) NOT NULL default '0' COMMENT '充值状态 0:未成功 1:充值成功',
  PRIMARY KEY  (`id`),
  index (`user_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='在线充值表';

-- --------------------------------------------------------

--
-- 表的结构 `{pre}oauth_user`
--

DROP TABLE IF EXISTS `{pre}oauth_user`;
CREATE TABLE `{pre}oauth_user` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `oauth_user_id` varchar(80) NOT NULL COMMENT '第三方平台的用户唯一标识',
  `oauth_id` smallint(5) unsigned NOT NULL COMMENT 'oauth表关联平台id',
  `user_id` int(11) unsigned  NOT NULL COMMENT '系统内部的用户id',
  `datetime` datetime NOT NULL COMMENT '绑定时间',
  `openid` varchar(80) NOT NULL default '' COMMENT 'openid参数只针对微信',
  PRIMARY KEY  (`id`),
  index (`oauth_user_id`,`oauth_id`),
  index (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='oauth开发平台绑定用户表';

-- --------------------------------------------------------

--
-- 表的结构 `{pre}oauth`
--

DROP TABLE IF EXISTS `{pre}oauth`;
CREATE TABLE `{pre}oauth` (
  `id` smallint(5) unsigned NOT NULL auto_increment,
  `name` varchar(80) NOT NULL COMMENT '名称',
  `config` text default NULL COMMENT '配置信息',
  `file` varchar(80) NOT NULL COMMENT '接口文件名称',
  `description` varchar(80) default NULL COMMENT '描述',
  `is_close` tinyint(1) NOT NULL default '0' COMMENT '是否关闭;0开启,1关闭',
  `logo` varchar(255) default NULL COMMENT 'logo',
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='认证方案oauth2.0';

INSERT INTO {pre}oauth VALUES (NULL, '人人网', '', 'renren', '人人网开放平台，申请地址：http://dev.renren.com/website ', 1, 'plugins/oauth/images/renren.gif');
INSERT INTO {pre}oauth VALUES (NULL, 'QQ', '', 'qq', '腾讯开发平台，申请地址：https://connect.qq.com ', 1, 'plugins/oauth/images/qq.gif');
INSERT INTO {pre}oauth VALUES (NULL, '新浪', '', 'sina', '新浪微博的开发平台，申请地址： http://open.weibo.com/connect ', 1, 'plugins/oauth/images/sina.gif');
INSERT INTO {pre}oauth VALUES (NULL, '淘宝', '', 'taobao', '淘宝的开放平台，申请地址：https://open.taobao.com ', 1, 'plugins/oauth/images/taobao.gif');
INSERT INTO {pre}oauth VALUES (NULL, '微信', '', 'wechatOauth', '微信的开放平台，申请地址： https://open.weixin.qq.com ', 1, 'plugins/oauth/images/wechat.png');

-- --------------------------------------------------------

--
-- 表的结构 `{pre}prop`
--

DROP TABLE IF EXISTS `{pre}prop`;
CREATE TABLE `{pre}prop` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `name` varchar(50) NOT NULL COMMENT '道具名称',
  `card_name` varchar(32) default NULL COMMENT '道具的卡号',
  `card_pwd` varchar(32) default NULL COMMENT '道具的密码',
  `start_time` datetime NOT NULL COMMENT '开始时间',
  `end_time` datetime NOT NULL COMMENT '结束时间',
  `value` decimal(15,2) NOT NULL default '0.00' COMMENT '面值',
  `type` tinyint(1) NOT NULL default '0' COMMENT '道具类型 0:优惠券',
  `condition` varchar(255) default NULL COMMENT '条件数据 type=0时,表示ticket的表id,模型id',
  `is_close` tinyint(1) NOT NULL default '0' COMMENT '是否关闭 0:正常,1:关闭,2:下订单未支付时临时锁定',
  `img` varchar(255) default NULL COMMENT '道具图片',
  `is_userd` tinyint(1) NOT NULL default '0' COMMENT '是否被使用过 0:未使用,1:已使用',
  `is_send` tinyint(1) NOT NULL default '0' COMMENT '是否被发送过 0:否 1:是',
  `seller_id` int(11) unsigned default '0' COMMENT '所属商户ID',
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='道具表';

-- --------------------------------------------------------

--
-- 表的结构 `{pre}quick_naviga`
--

DROP TABLE IF EXISTS `{pre}quick_naviga`;
CREATE TABLE `{pre}quick_naviga` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `admin_id` int(11) unsigned NOT NULL COMMENT '管理员id',
  `naviga_name` varchar(255) NOT NULL COMMENT '导航名称',
  `url` varchar(255) NOT NULL COMMENT '导航链接',
  `is_del` tinyint(1) NOT NULL default '0' COMMENT '是否删除1为删除',
  PRIMARY KEY  (`id`),
  index (`admin_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='管理员快速导航';

-- --------------------------------------------------------

--
-- 表的结构 `{pre}refer`
--

DROP TABLE IF EXISTS `{pre}refer`;
CREATE TABLE `{pre}refer` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `question` text NOT NULL COMMENT '咨询内容',
  `user_id` int(11) unsigned default NULL COMMENT '咨询人会员ID，非会员为空',
  `goods_id` int(11) unsigned NOT NULL COMMENT '产品ID',
  `answer` text COMMENT '回复内容',
  `admin_id` int(11) unsigned default '0' COMMENT '回复的管理员ID',
  `seller_id` int(11) unsigned default '0' COMMENT '回复的商户ID',
  `status` tinyint(1) default '0' COMMENT '0：待回复 1已回复',
  `time` datetime default NULL COMMENT '咨询时间',
  `reply_time` datetime default NULL COMMENT '回复时间',
  `_hash` int(11) unsigned NOT NULL COMMENT '预留散列字段',
  PRIMARY KEY  (`id`,`_hash`),
  index (`user_id`),
  index (`goods_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='咨询表';

-- --------------------------------------------------------

--
-- 表的结构 `{pre}refundment_doc`
--

DROP TABLE IF EXISTS `{pre}refundment_doc`;
CREATE TABLE `{pre}refundment_doc` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `order_no` varchar(20) NOT NULL COMMENT '订单号',
  `order_id` int(11) unsigned NOT NULL COMMENT '订单ID',
  `user_id` int(11) unsigned default 0 COMMENT '用户ID',
  `amount` decimal(15,2) NOT NULL default '0.00' COMMENT '退款金额',
  `time` datetime default NULL COMMENT '时间',
  `admin_id` int(11) unsigned default NULL COMMENT '管理员ID',
  `pay_status` tinyint(1) NOT NULL default '0' COMMENT '状态,0:申请中 1:已拒绝 2:已完成 3:等待买家发货 4:等待商家确认',
  `content` text COMMENT '申请原因',
  `dispose_time` datetime default NULL COMMENT '处理时间',
  `dispose_idea` text COMMENT '处理意见',
  `if_del` tinyint(1) NOT NULL default '0' COMMENT '0:未删除 1:已删除',
  `order_goods_id` text COMMENT '订单与商品关联ID集合',
  `seller_id` int(11) unsigned NOT NULL default '0' COMMENT '商家ID',
  `way` varchar(20) NOT NULL default '' COMMENT '退款方式,balance:用户预存款 other:其他方式 origin:原路退回',
  `trade_no` varchar(255) NOT NULL default '' COMMENT '支付平台退款流水号',
  `img_list` text COMMENT '图片',
  `user_freight_id` int(11) unsigned default NULL COMMENT '用户发货时货运公司ID',
  `user_delivery_code` varchar(30) default NULL COMMENT '用户发货时快递单号',
  `user_send_time` datetime default NULL COMMENT '发货时间',
  `_hash` int(11) unsigned NOT NULL COMMENT '预留散列字段',
  PRIMARY KEY  (`id`,`_hash`),
  index (`order_id`),
  index (`seller_id`),
  index (`if_del`),
  index (`user_id`),
  index (`pay_status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='售后退款单';

-- --------------------------------------------------------

--
-- 表的结构 `{pre}exchange_doc`
--

DROP TABLE IF EXISTS `{pre}exchange_doc`;
CREATE TABLE `{pre}exchange_doc` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `order_no` varchar(20) NOT NULL COMMENT '订单号',
  `order_id` int(11) unsigned NOT NULL COMMENT '订单ID',
  `user_id` int(11) unsigned default 0 COMMENT '用户ID',
  `time` datetime default NULL COMMENT '时间',
  `admin_id` int(11) unsigned default NULL COMMENT '管理员ID',
  `status` tinyint(1) NOT NULL default '0' COMMENT '状态,0:申请中 1:已拒绝 2:已完成 3:等待买家发货 4:等待商家确认',
  `content` text COMMENT '申请原因',
  `dispose_time` datetime default NULL COMMENT '处理时间',
  `dispose_idea` text COMMENT '处理意见',
  `if_del` tinyint(1) NOT NULL default '0' COMMENT '0:未删除 1:已删除',
  `order_goods_id` text COMMENT '订单与商品关联ID集合',
  `seller_id` int(11) unsigned NOT NULL default '0' COMMENT '商家ID',
  `img_list` text COMMENT '图片',
  `user_freight_id` int(11) unsigned default NULL COMMENT '用户发货时货运公司ID',
  `user_delivery_code` varchar(30) default NULL COMMENT '用户发货时快递单号',
  `user_send_time` datetime default NULL COMMENT '发货时间',
  `seller_freight_id` int(11) unsigned default NULL COMMENT '商家发货时货运公司ID',
  `seller_delivery_code` varchar(30) default NULL COMMENT '商家发货时快递单号',
  `seller_send_time` datetime default NULL COMMENT '发货时间',
  `_hash` int(11) unsigned NOT NULL COMMENT '预留散列字段',
  PRIMARY KEY  (`id`,`_hash`),
  index (`order_id`),
  index (`seller_id`),
  index (`if_del`),
  index (`user_id`),
  index (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='售后换货单';

-- --------------------------------------------------------

--
-- 表的结构 `{pre}fix_doc`
--

DROP TABLE IF EXISTS `{pre}fix_doc`;
CREATE TABLE `{pre}fix_doc` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `order_no` varchar(20) NOT NULL COMMENT '订单号',
  `order_id` int(11) unsigned NOT NULL COMMENT '订单ID',
  `user_id` int(11) unsigned default 0 COMMENT '用户ID',
  `time` datetime default NULL COMMENT '时间',
  `admin_id` int(11) unsigned default NULL COMMENT '管理员ID',
  `status` tinyint(1) NOT NULL default '0' COMMENT '状态,0:申请中 1:已拒绝 2:已完成 3:等待买家发货 4:等待商家确认',
  `content` text COMMENT '申请原因',
  `dispose_time` datetime default NULL COMMENT '处理时间',
  `dispose_idea` text COMMENT '处理意见',
  `if_del` tinyint(1) NOT NULL default '0' COMMENT '0:未删除 1:已删除',
  `order_goods_id` text COMMENT '订单与商品关联ID集合',
  `seller_id` int(11) unsigned NOT NULL default '0' COMMENT '商家ID',
  `img_list` text COMMENT '图片',
  `user_freight_id` int(11) unsigned default NULL COMMENT '用户发货时货运公司ID',
  `user_delivery_code` varchar(30) default NULL COMMENT '用户发货时快递单号',
  `user_send_time` datetime default NULL COMMENT '发货时间',
  `seller_freight_id` int(11) unsigned default NULL COMMENT '商家发货时货运公司ID',
  `seller_delivery_code` varchar(30) default NULL COMMENT '商家发货时快递单号',
  `seller_send_time` datetime default NULL COMMENT '发货时间',
  `_hash` int(11) unsigned NOT NULL COMMENT '预留散列字段',
  PRIMARY KEY  (`id`,`_hash`),
  index (`order_id`),
  index (`seller_id`),
  index (`if_del`),
  index (`user_id`),
  index (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='售后维修单';

-- --------------------------------------------------------

--
-- 表的结构 `{pre}regiment`
--

DROP TABLE IF EXISTS `{pre}regiment`;
CREATE TABLE `{pre}regiment` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `title` varchar(255) NOT NULL COMMENT '团购标题',
  `start_time` datetime NOT NULL COMMENT '开始时间',
  `end_time` datetime NOT NULL COMMENT '结束时间',
  `store_nums` int(11) NOT NULL default '0' COMMENT '库存量',
  `sum_count` int(11) NOT NULL default '0' COMMENT '已销售量',
  `limit_min_count` int(11) NOT NULL default '0' COMMENT '每人限制最少购买数量',
  `limit_max_count` int(11) NOT NULL default '0' COMMENT '每人限制最多购买数量',
  `intro` varchar(255) default NULL COMMENT '介绍',
  `is_close` tinyint(1) NOT NULL default '0' COMMENT '0开启,1关闭,2待审核',
  `regiment_price` decimal(15,2) NOT NULL default '0.00' COMMENT '团购价格',
  `sell_price` decimal(15,2) NOT NULL default '0.00' COMMENT '原来价格',
  `goods_id` int(11) unsigned NOT NULL COMMENT '关联商品id',
  `img` varchar(255) default NULL COMMENT '商品图片',
  `sort` smallint(5) NOT NULL DEFAULT '99' COMMENT '排序',
  `seller_id` int(11) unsigned NOT NULL default '0' COMMENT '商家ID',
  `_hash` int(11) unsigned NOT NULL COMMENT '预留散列字段',
  PRIMARY KEY  (`id`,`_hash`),
  index (`is_close`,`start_time`,`end_time`),
  index (`goods_id`),
  index (`sort`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='团购';

-- --------------------------------------------------------

--
-- 表的结构 `{pre}right`
--

DROP TABLE IF EXISTS `{pre}right`;
CREATE TABLE `{pre}right` (
  `id` int(10) NOT NULL auto_increment,
  `name` varchar(80) NOT NULL COMMENT '权限名字',
  `right` text COMMENT '权限码(控制器+动作)',
  `is_del` tinyint(1) NOT NULL default '0' COMMENT '删除状态 1删除,0正常',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='权限资源码';

-- --------------------------------------------------------

--
-- 表的结构 `{pre}spec`
--

DROP TABLE IF EXISTS `{pre}spec`;
CREATE TABLE `{pre}spec` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `name` varchar(50) NOT NULL COMMENT '规格名称',
  `value` text COMMENT '规格值json格式，包括值和图片',
  `note` varchar(255) default NULL COMMENT '备注说明',
  `is_del` tinyint(1) default '0' COMMENT '是否删除 0未删除 1已删除',
  `seller_id` int(11) default '0' COMMENT '商家ID',
  `sort` smallint(5) NOT NULL DEFAULT '99' COMMENT '排序',
  PRIMARY KEY  (`id`),
  index (`is_del`),
  index (`seller_id`,`sort`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='规格表';

-- --------------------------------------------------------

--
-- 表的结构 `{pre}spec_photo`
--

DROP TABLE IF EXISTS `{pre}spec_photo`;
CREATE TABLE `{pre}spec_photo` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `address` varchar(255) default NULL COMMENT '图片地址',
  `name` varchar(100) default NULL COMMENT '图片名称',
  `create_time` datetime default NULL COMMENT '创建时间',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='规格图片表';

-- --------------------------------------------------------

--
-- 表的结构 `{pre}suggestion`
--

DROP TABLE IF EXISTS `{pre}suggestion`;
CREATE TABLE `{pre}suggestion` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `user_id` int(11) unsigned  NOT NULL COMMENT '用户ID',
  `title` varchar(255) NOT NULL COMMENT '标题',
  `content` text NOT NULL COMMENT '内容',
  `time` datetime NOT NULL COMMENT '提问时间',
  `admin_id` int(11) unsigned default NULL COMMENT '管理员ID',
  `re_content` text COMMENT '回复内容',
  `re_time` datetime default NULL COMMENT '回复时间',
  `_hash` int(11) unsigned NOT NULL COMMENT '预留散列字段',
  PRIMARY KEY  (`id`,`_hash`),
  index (`user_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='意见箱表';

-- --------------------------------------------------------

--
-- 表的结构 `{pre}ticket`
--

DROP TABLE IF EXISTS `{pre}ticket`;
CREATE TABLE `{pre}ticket` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `name` varchar(50) NOT NULL COMMENT '优惠券名称',
  `value` decimal(15,2) NOT NULL default '0.00' COMMENT '优惠券面额值',
  `start_time` datetime default NULL COMMENT '开始时间',
  `end_time` datetime default NULL COMMENT '结束时间',
  `point` smallint(5) NOT NULL default '0' COMMENT '兑换优惠券所需积分,如果是0表示禁止兑换',
  `seller_id` int(11) unsigned default '0' COMMENT '卖家ID',
  `type` tinyint(1) NOT NULL DEFAULT '0' COMMENT '活动类型 0:全品类 1:只能用于某个商品 2:只能用于某个分类',
  `condition` text NOT NULL COMMENT '活动生效条件 当type=0空,当type=1<商品ID>,type=2<商品分类ID>',
  `limit_sum` decimal(15,2) NOT NULL COMMENT '满多少元可用',
  PRIMARY KEY  (`id`),
  index (`start_time`,`end_time`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='优惠券类型表';


-- --------------------------------------------------------

--
-- 表的结构 `{pre}user_group`
--

DROP TABLE IF EXISTS `{pre}user_group`;
CREATE TABLE `{pre}user_group` (
  `id` int(11) unsigned NOT NULL auto_increment COMMENT '用户组ID',
  `group_name` varchar(20) NOT NULL COMMENT '组名',
  `discount` decimal(15,2) NOT NULL default '100' COMMENT '折扣率',
  `minexp` int(11) default NULL COMMENT '最小经验',
  `maxexp` int(11) default NULL COMMENT '最大经验',
  `message_ids` varchar(255) default NULL COMMENT '消息ID',
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='用户组';

-- --------------------------------------------------------

--
-- 表的结构 `{pre}withdraw`
--

DROP TABLE IF EXISTS `{pre}withdraw`;
CREATE TABLE `{pre}withdraw` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `user_id` int(11) unsigned NOT NULL COMMENT '用户ID',
  `time` datetime NOT NULL COMMENT '时间',
  `amount` decimal(15,2) NOT NULL default '0.00' COMMENT '金额',
  `name` varchar(255) NOT NULL COMMENT '开户姓名',
  `status` tinyint(1) NOT NULL default '0' COMMENT '-1失败,0未处理,1处理中,2成功',
  `note` varchar(255) default NULL COMMENT '用户备注',
  `re_note` varchar(255) default NULL COMMENT '回复备注信息',
  `is_del` tinyint(1) NOT NULL default '0' COMMENT '0未删除,1已删除',
  PRIMARY KEY  (`id`),
  index (`user_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='提现记录';

------------------------------------------------------------

--
-- 导出表中的数据 `{pre}bill`
--
DROP TABLE IF EXISTS `{pre}bill`;
CREATE TABLE `{pre}bill` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `seller_id` int(11) unsigned NOT NULL COMMENT '商家ID',
  `apply_time` datetime DEFAULT NULL COMMENT '申请结算时间',
  `pay_time` datetime DEFAULT NULL COMMENT '支付结算时间',
  `admin_id` int(11) unsigned DEFAULT NULL COMMENT '管理员ID',
  `is_pay` tinyint(1) NOT NULL DEFAULT '0' COMMENT '0:未结算,1:已结算',
  `apply_content` text COMMENT '申请结算文本',
  `pay_content` text COMMENT '支付结算文本',
  `start_time` date DEFAULT NULL COMMENT '结算起始时间',
  `end_time` date DEFAULT NULL COMMENT '结算终止时间',
  `log` text COMMENT '结算明细',
  `order_ids` text COMMENT 'order表主键ID，结算的ID',
  `amount` decimal(15,2) NOT NULL default '0.00' COMMENT '结算的金额',
  `_hash` int(11) unsigned NOT NULL COMMENT '预留散列字段',
  PRIMARY KEY  (`id`,`_hash`),
  index (`seller_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='商家货款结算单表';

--
-- 导出表中的数据 `{pre}takeself`
--
DROP TABLE IF EXISTS `{pre}takeself`;
CREATE TABLE `{pre}takeself` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL COMMENT '名称',
  `sort` smallint(5) NOT NULL DEFAULT '99' COMMENT '排序',
  `province` int(11) NOT NULL COMMENT '省份ID',
  `city` int(11) NOT NULL COMMENT '城市ID',
  `area` int(11) NOT NULL COMMENT '地区ID',
  `address` varchar(255) NOT NULL COMMENT '地址',
  `phone` varchar(30) DEFAULT NULL COMMENT '座机号码',
  `mobile` varchar(30) DEFAULT NULL COMMENT '手机号码',
  `seller_id` int(11) unsigned default 0 COMMENT '商家ID',
  `logo` varchar(255) DEFAULT NULL COMMENT 'logo图片',
  `_hash` int(11) unsigned NOT NULL COMMENT '预留散列字段',
  PRIMARY KEY (`id`,`_hash`),
  index (`seller_id`),
  index (`province`,`city`,`area`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='自提点';

-- --------------------------------------------------------

--
-- 表的结构 `{pre}user`
--

DROP TABLE IF EXISTS `{pre}user`;
CREATE TABLE `{pre}user` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `username` varchar(20) NOT NULL COMMENT '用户名',
  `password` char(32) NOT NULL COMMENT '密码',
  `head_ico` varchar(255) default NULL COMMENT '头像',
  PRIMARY KEY  (`id`),
  UNIQUE KEY (`username`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='用户表';

-- --------------------------------------------------------

--
-- 表的结构 `{pre}admin`
--

DROP TABLE IF EXISTS `{pre}admin`;
CREATE TABLE `{pre}admin` (
  `id` int(11) unsigned NOT NULL auto_increment COMMENT '管理员ID',
  `admin_name` varchar(20) NOT NULL COMMENT '用户名',
  `password` varchar(32) NOT NULL COMMENT '密码',
  `role_id` int(11) unsigned NOT NULL COMMENT '角色ID',
  `create_time` datetime default NULL COMMENT '创建时间',
  `email` varchar(255) default NULL COMMENT 'Email',
  `last_ip` varchar(30) default NULL COMMENT '最后登录IP',
  `last_time` datetime default NULL COMMENT '最后登录时间',
  `is_del` tinyint(1) NOT NULL default '0' COMMENT '删除状态 1删除,0正常',
  PRIMARY KEY  (`id`),
  index (`admin_name`),
  index (`role_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='管理员用户表';

-- --------------------------------------------------------

--
-- 表的结构 `{pre}admin_role`
--

DROP TABLE IF EXISTS `{pre}admin_role`;
CREATE TABLE `{pre}admin_role` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `name` varchar(20) NOT NULL COMMENT '角色名称',
  `rights` text COMMENT '权限',
  `is_del` tinyint(1) NOT NULL default '0' COMMENT '删除状态 1删除,0正常',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='后台角色分组表';

--
-- 导出表中的数据 `{pre}seller`
--
DROP TABLE IF EXISTS `{pre}seller`;
CREATE TABLE `{pre}seller` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `seller_name` varchar(80) NOT NULL COMMENT '商家登录用户名',
  `password` char(32) NOT NULL COMMENT '商家密码',
  `create_time` datetime DEFAULT NULL COMMENT '加入时间',
  `login_time` datetime DEFAULT NULL COMMENT '最后登录时间',
  `is_vip` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否是特级商家',
  `is_del` tinyint(1) NOT NULL DEFAULT '0' COMMENT '0:未删除,1:已删除',
  `is_lock` tinyint(1) NOT NULL DEFAULT '0' COMMENT '0:未锁定,1:已锁定',
  `true_name` varchar(80) NOT NULL COMMENT '商家真实名称',
  `email` varchar(255) NOT NULL DEFAULT '' COMMENT '电子邮箱',
  `mobile` varchar(20) NOT NULL COMMENT '手机号码',
  `phone` varchar(20) NOT NULL COMMENT '座机号码',
  `paper_img` varchar(255) DEFAULT NULL COMMENT '执照证件照片',
  `cash` decimal(15,2) DEFAULT NULL COMMENT '保证金',
  `country` int(11) unsigned default NULL COMMENT '国ID',
  `province` int(11) unsigned NOT NULL COMMENT '省ID',
  `city` int(11) unsigned NOT NULL COMMENT '市ID',
  `area` int(11) unsigned NOT NULL COMMENT '区ID',
  `address` varchar(255) NOT NULL COMMENT '地址',
  `account` text COMMENT '收款账号信息',
  `server_num` varchar(20) default NULL COMMENT 'QQ号码',
  `home_url` varchar(255) default NULL COMMENT '企业URL网站',
  `sort` smallint(5) NOT NULL default '99' COMMENT '排序',
  `tax` decimal(15,2) NOT NULL default '0.00' COMMENT '税率',
  `seller_message_ids` text COMMENT '商户消息ID',
  `grade` int(11) NOT NULL default '0' COMMENT '评分总数',
  `sale` int(11) NOT NULL default '0' COMMENT '总销量',
  `comments` int(11) NOT NULL default '0' COMMENT '评论次数',
  `logo` varchar(255) NOT NULL default '' COMMENT 'LOGO图标',
  `discount` decimal(15,2) unsigned NOT NULL DEFAULT '100.00' COMMENT '商户结算折扣率',
  `_hash` int(11) unsigned NOT NULL COMMENT '预留散列字段',
  UNIQUE KEY `seller_name` (`seller_name`,`_hash`),
  PRIMARY KEY  (`id`,`_hash`),
  INDEX(`seller_name`,`password`),
  INDEX(`true_name`),
  INDEX(`is_vip`),
  INDEX(`is_del`),
  INDEX(`is_lock`),
  INDEX(`email`),
  INDEX(`sort`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='商家表';

-- --------------------------------------------------------

--
-- 表的结构 `{pre}seller_message`
--

DROP TABLE IF EXISTS `{pre}seller_message`;
CREATE TABLE IF NOT EXISTS `{pre}seller_message` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL COMMENT '标题',
  `content` text COMMENT '内容',
  `time` datetime NOT NULL COMMENT '发送时间',
  `rev_info` text COMMENT '收件人信息',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='商家消息';

-- --------------------------------------------------------
--
-- 表的结构 `{pre}goods`
--

DROP TABLE IF EXISTS `{pre}goods`;
CREATE TABLE `{pre}goods` (
  `id` int(11) unsigned NOT NULL auto_increment COMMENT '商品ID',
  `name` varchar(255) NOT NULL COMMENT '商品名称',
  `goods_no` varchar(20) NOT NULL COMMENT '商品的货号',
  `model_id` int(11) unsigned NOT NULL COMMENT '模型ID',
  `sell_price` decimal(15,2) NOT NULL COMMENT '销售价格',
  `market_price` decimal(15,2) default NULL COMMENT '市场价格',
  `cost_price` decimal(15,2) default NULL COMMENT '成本价格',
  `up_time` datetime default NULL COMMENT '上架时间',
  `down_time` datetime default NULL COMMENT '下架时间',
  `create_time` datetime NOT NULL COMMENT '创建时间',
  `store_nums` int(11) NOT NULL default '0' COMMENT '库存',
  `img` varchar(255) default NULL COMMENT '原图',
  `ad_img` varchar(255) default NULL COMMENT '宣传图',
  `is_del` tinyint(1) NOT NULL default '0' COMMENT '商品状态 0正常 1已删除 2下架 3申请上架',
  `content` text COMMENT '商品描述',
  `keywords` varchar(255) default NULL COMMENT 'SEO关键词',
  `description` varchar(255) default NULL COMMENT 'SEO描述',
  `search_words` varchar(50) default NULL COMMENT '产品搜索词库,逗号分隔',
  `weight` decimal(15,2) NOT NULL default '0.00' COMMENT '重量',
  `point` int(11) NOT NULL default '0' COMMENT '积分',
  `unit` varchar(10) default NULL COMMENT '计件单位。如:件,箱,个',
  `brand_id` int(11) NOT NULL default '0' COMMENT '品牌ID',
  `visit` int(11) NOT NULL default '0' COMMENT '浏览次数',
  `favorite` int(11) NOT NULL default '0' COMMENT '收藏次数',
  `sort` smallint(5) NOT NULL default '99' COMMENT '排序',
  `spec_array` text COMMENT '商品信息json数据',
  `exp` int(11) NOT NULL default '0' COMMENT '经验值',
  `comments` int(11) NOT NULL default '0' COMMENT '评论次数',
  `sale` int(11) NOT NULL default '0' COMMENT '销量',
  `grade` int(11) NOT NULL default '0' COMMENT '评分总数',
  `seller_id` int(11) unsigned default '0' COMMENT '卖家ID',
  `is_share` tinyint(1) NOT NULL default '0' COMMENT '共享商品 0不共享 1共享',
  `is_delivery_fee` tinyint(1) NOT NULL default '0' COMMENT '免运费 0收运费 1免运费',
  `promo` varchar(50) NOT NULL DEFAULT '' COMMENT '默认:普通,groupon:团购,time:限时抢购,costpoint:积分兑换,assemble:拼团',
  `active_id` int(11) NOT NULL DEFAULT '0' COMMENT '活动ID主键',
  `type` varchar(20) NOT NULL DEFAULT 'default' COMMENT 'default:实体,code:到店服务,download:知识付费下载,preorder:时间预订',
  `config` text COMMENT '商品配置参数',
  `_hash` int(11) unsigned NOT NULL COMMENT '预留散列字段',
  PRIMARY KEY  (`id`,`_hash`),
  index (`is_del`),
  index (`sort`),
  index (`sale`),
  index (`grade`),
  index (`sell_price`),
  index (`name`),
  index (`goods_no`),
  index (`is_share`),
  index (`brand_id`,`is_del`),
  index (`brand_id`,`sell_price`),
  index (`brand_id`,`grade`),
  index (`brand_id`,`sale`),
  index (`store_nums`,`is_del`),
  index (`seller_id`,`is_del`),
  index (`seller_id`,`sell_price`),
  index (`seller_id`,`grade`),
  index (`seller_id`,`sale`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='商品信息表';

-- --------------------------------------------------------

--
-- 表的结构 `{pre}order`
--

DROP TABLE IF EXISTS `{pre}order`;
CREATE TABLE `{pre}order` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `order_no` varchar(20) NOT NULL COMMENT '订单号',
  `user_id` int(11) unsigned NOT NULL COMMENT '用户ID',
  `pay_type` int(11) NOT NULL COMMENT '用户支付方式ID,当为0时表示货到付款',
  `distribution` int(11) default NULL COMMENT '用户选择的配送ID',
  `status` tinyint(1) default '1' COMMENT '订单状态 1生成订单,2支付订单,3取消订单(客户触发),4作废订单(管理员触发),5完成订单,6退款(订单完成后),7部分退款(订单完成后)',
  `pay_status` tinyint(1) default '0' COMMENT '支付状态 0：未支付; 1：已支付;',
  `distribution_status` tinyint(1) default '0' COMMENT '配送状态 0：未发送,1：已发送,2：部分发送',
  `accept_name` varchar(20) NOT NULL COMMENT '收货人姓名',
  `postcode` varchar(6) default NULL COMMENT '邮编',
  `telphone` varchar(20) default NULL COMMENT '联系电话',
  `country` int(11) default NULL COMMENT '国ID',
  `province` int(11) default NULL COMMENT '省ID',
  `city` int(11) default NULL COMMENT '市ID',
  `area` int(11) default NULL COMMENT '区ID',
  `address` varchar(250) default NULL COMMENT '收货地址',
  `mobile` varchar(20) default NULL COMMENT '手机',
  `payable_amount` decimal(15,2) default '0.00' COMMENT '应付商品总金额',
  `real_amount` decimal(15,2) NOT NULL default '0.00' COMMENT '实付商品总金额(会员折扣,促销规则折扣)',
  `payable_freight` decimal(15,2) NOT NULL default '0.00' COMMENT '总运费金额',
  `real_freight` decimal(15,2) NOT NULL default '0.00' COMMENT '实付运费',
  `pay_time` datetime default NULL COMMENT '付款时间',
  `send_time` datetime default NULL COMMENT '发货时间',
  `create_time` datetime default NULL COMMENT '下单时间',
  `completion_time` datetime default NULL COMMENT '订单完成时间',
  `invoice` tinyint(1) NOT NULL default '0' COMMENT '发票：0不索要1索要',
  `postscript` varchar(255) default NULL COMMENT '用户附言',
  `note` text COMMENT '管理员备注和促销规则描述',
  `if_del` tinyint(1) default '0' COMMENT '是否删除1为删除',
  `insured` decimal(15,2) NOT NULL default '0.00' COMMENT '保价',
  `invoice_info` text  COMMENT '发票信息JSON数据',
  `taxes` decimal(15,2) NOT NULL default '0.00' COMMENT '税金',
  `promotions` decimal(15,2) NOT NULL default '0.00' COMMENT '促销优惠金额和会员折扣',
  `discount` decimal(15,2) NOT NULL default '0.00' COMMENT '订单折扣或涨价',
  `order_amount` decimal(15,2) NOT NULL default '0.00' COMMENT '订单总金额',
  `prop` varchar(255) default NULL COMMENT '使用的道具id',
  `accept_time` varchar(80) default NULL COMMENT '用户收货时间',
  `exp` smallint(5) unsigned NOT NULL default '0' COMMENT '增加的经验',
  `point` smallint(5) unsigned NOT NULL default '0' COMMENT '增加的积分',
  `type` varchar(50) NOT NULL DEFAULT '' COMMENT '默认:普通,groupon:团购,time:限时抢购,costpoint:积分兑换',
  `trade_no` varchar(255) default NULL COMMENT '支付平台交易号',
  `takeself` int(11) unsigned NOT NULL default '0' COMMENT '自提点ID',
  `checkcode` varchar(255) default NULL COMMENT '自提方式的验证码',
  `active_id` int(11) unsigned NOT NULL default '0' COMMENT '促销活动ID',
  `seller_id` int(11) unsigned NOT NULL default '0' COMMENT '商家ID',
  `is_checkout` tinyint(1) NOT NULL default '0' COMMENT '是否给商家结算货款 0:未结算 1:已结算',
  `prorule_ids` varchar(255) NOT NULL default '' COMMENT '促销活动规格ID串，逗号分隔',
  `spend_point` int(11) NOT NULL DEFAULT '0' COMMENT '花费的积分数',
  `servicefee_amount` decimal(15,2) NOT NULL DEFAULT '0.00' COMMENT '订单手续费总金额',
  `goods_type` varchar(20) NOT NULL default 'default' COMMENT 'default:实体,code:到店服务,download:知识付费下载,preorder:时间预订',
  `_hash` int(11) unsigned NOT NULL COMMENT '预留散列字段',
  PRIMARY KEY  (`id`,`_hash`),
  index (`if_del`),
  index (`order_no`),
  index (`user_id`),
  index (`seller_id`),
  index (`status`),
  index (`order_amount`),
  index (`completion_time`),
  index (`send_time`),
  index (`create_time`),
  index (`distribution_status`),
  index (`pay_status`),
  index (`accept_name`),
  index (`is_checkout`),
  index (`checkcode`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='订单表';

-- --------------------------------------------------------

--
-- 表的结构 `{pre}cost_point`
--

DROP TABLE IF EXISTS `{pre}cost_point`;
CREATE TABLE `{pre}cost_point` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(20) NOT NULL COMMENT '活动名称',
  `sort` smallint(5) NOT NULL COMMENT '顺序',
  `goods_id` int(11) NOT NULL COMMENT '商品id',
  `point` int(11) NOT NULL COMMENT '所需要的积分',
  `is_close` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否关闭 0:否 1:是',
  `user_group` text COMMENT '允许参与活动的用户组,all表示所有用户组',
  `seller_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '商家ID',
  `_hash` int(11) unsigned NOT NULL COMMENT '预留散列字段',
  PRIMARY KEY (`id`,`_hash`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='商品积分兑换表';

-- --------------------------------------------------------

--
-- 表的结构 `{pre}category`
--

DROP TABLE IF EXISTS `{pre}category`;
CREATE TABLE `{pre}category` (
  `id` int(11) unsigned NOT NULL auto_increment COMMENT '分类ID',
  `name` varchar(50) NOT NULL COMMENT '分类名称',
  `parent_id` int(11) unsigned NOT NULL COMMENT '父分类ID',
  `sort` smallint(5) NOT NULL default '0' COMMENT '排序',
  `visibility` tinyint(1) NOT NULL default '1' COMMENT '首页是否显示 1显示 0 不显示',
  `keywords` varchar(255) default NULL COMMENT 'SEO关键词和检索关键词',
  `descript` varchar(255) default NULL COMMENT 'SEO描述',
  `title` varchar(255) default NULL COMMENT 'SEO标题title',
  `img` varchar(255) default NULL COMMENT '分类图片',
  `_hash` int(11) unsigned NOT NULL COMMENT '预留散列字段',
  PRIMARY KEY  (`id`,`_hash`),
  index (`parent_id`,`visibility`),
  index (`sort`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='产品分类表';

-- --------------------------------------------------------

--
-- 表的结构 `{pre}model`
--

DROP TABLE IF EXISTS `{pre}model`;
CREATE TABLE `{pre}model` (
  `id` int(11) unsigned NOT NULL auto_increment COMMENT '模型ID',
  `name` varchar(50) NOT NULL COMMENT '模型名称',
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='模型表';

-- --------------------------------------------------------

--
-- 表的结构 `{pre}order_code_relation`
--

DROP TABLE IF EXISTS `{pre}order_code_relation`;
CREATE TABLE `{pre}order_code_relation` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `order_id` int(11) unsigned NOT NULL COMMENT '订单ID',
  `goods_id` int(11) unsigned NOT NULL COMMENT '商品ID',
  `code` varchar(50) NOT NULL COMMENT '验证码字符串',
  `seller_id` int(11) unsigned default '0' COMMENT '商家ID',
  `user_id` int(11) unsigned NOT NULL COMMENT '用户ID',
  `create_time` datetime DEFAULT NULL COMMENT '生成时间',
  `use_time` datetime DEFAULT NULL COMMENT '使用时间',
  `is_used` tinyint(1) NOT NULL default '0' COMMENT '使用状态 0未用 1已用',
  PRIMARY KEY  (`id`),
  index (`order_id`),
  index (`code`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='虚拟商品订单服务验证码关系';

-- --------------------------------------------------------

--
-- 表的结构 `{pre}order_download_relation`
--

DROP TABLE IF EXISTS `{pre}order_download_relation`;
CREATE TABLE `{pre}order_download_relation` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `order_id` int(11) unsigned NOT NULL COMMENT '订单ID',
  `goods_id` int(11) unsigned NOT NULL COMMENT '商品ID',
  `seller_id` int(11) unsigned default '0' COMMENT '商家ID',
  `user_id` int(11) unsigned NOT NULL COMMENT '用户ID',
  `create_time` datetime DEFAULT NULL COMMENT '生成时间',
  `num` smallint(6) NOT NULL default '0' COMMENT '下载次数',
  PRIMARY KEY  (`id`),
  index (`order_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='虚拟商品订单下载关系';

-- --------------------------------------------------------

--
-- 表的结构 `{pre}goods_extend_download`
--

DROP TABLE IF EXISTS `{pre}goods_extend_download`;
CREATE TABLE `{pre}goods_extend_download` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `goods_id` int(11) unsigned NOT NULL COMMENT '商品ID',
  `url` varchar(255) NOT NULL COMMENT '下载地址',
  `seller_id` int(11) unsigned default '0' COMMENT '商家ID',
  `end_time` date DEFAULT NULL COMMENT '截至时间',
  `limit_num` smallint(6) DEFAULT '0' COMMENT '限制下载次数',
  PRIMARY KEY  (`id`),
  index (`goods_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='商品下载资源地址';

-- --------------------------------------------------------

--
-- 表的结构 `{pre}goods_extend_preorder_discount`
--

DROP TABLE IF EXISTS `{pre}goods_extend_preorder_discount`;
CREATE TABLE `{pre}goods_extend_preorder_discount` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `goods_id` int(11) unsigned NOT NULL COMMENT '商品ID',
  `product_id` int(11) unsigned default '0' COMMENT '货品ID',
  `start_date` date NOT NULL COMMENT '服务开始日期',
  `end_date` date NOT NULL COMMENT '服务结束日期',
  `discount` decimal(15,2) NOT NULL COMMENT '浮动价格正负数',
  `seller_id` int(11) unsigned DEFAULT '0' COMMENT '商家ID',
  PRIMARY KEY (`id`),
  index (`goods_id`),
  index (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='时间预订类商品价格浮动表';

-- --------------------------------------------------------

--
-- 表的结构 `{pre}goods_extend_preorder_disnums`
--

DROP TABLE IF EXISTS `{pre}goods_extend_preorder_disnums`;
CREATE TABLE `{pre}goods_extend_preorder_disnums` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `goods_id` int(11) unsigned NOT NULL COMMENT '商品ID',
  `product_id` int(11) unsigned NOT NULL default '0' COMMENT '货品ID',
  `start_date` date NOT NULL COMMENT '服务开始日期',
  `end_date` date NOT NULL COMMENT '服务结束日期',
  `disnums` int(11) NOT NULL COMMENT '浮动库存正负数',
  `seller_id` int(11) unsigned DEFAULT '0' COMMENT '商家ID',
  PRIMARY KEY (`id`),
  index (`goods_id`),
  index (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='时间预订类商品库存浮动表';

-- --------------------------------------------------------

--
-- 表的结构 `{pre}order_extend_preorder`
--

DROP TABLE IF EXISTS `{pre}order_extend_preorder`;
CREATE TABLE `{pre}order_extend_preorder` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` int(11) unsigned NOT NULL COMMENT '订单ID',
  `goods_id` int(11) unsigned NOT NULL COMMENT '商品ID',
  `product_id` int(11) unsigned NOT NULL default '0' COMMENT '货品ID',
  `goods_nums` int(11) unsigned NOT NULL default '1' COMMENT '商品数量',
  `start_date` date NOT NULL COMMENT '服务开始日期',
  `end_date` date NOT NULL COMMENT '服务结束日期',
  PRIMARY KEY (`id`),
  index (`order_id`),
  index (`goods_id`),
  index (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='订单扩展表预订类';

-- --------------------------------------------------------

--
-- 表的结构 `{pre}assemble'
--

DROP TABLE IF EXISTS `{pre}assemble`;
CREATE TABLE `{pre}assemble` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `is_close` tinyint(1) NOT NULL default '0' COMMENT '0开启,1关闭,2待审核',
  `goods_id` int(11) unsigned NOT NULL COMMENT '关联商品id',
  `assemble_price` decimal(15,2) NOT NULL default '0.00' COMMENT '拼团活动价格',
  `sell_price` decimal(15,2) NOT NULL default '0.00' COMMENT '商品原价格',
  `title` varchar(255) NOT NULL COMMENT '拼团标题',
  `sum_count` int(11) NOT NULL default '0' COMMENT '已销售量',
  `intro` varchar(255) default NULL COMMENT '介绍',
  `img` varchar(255) default NULL COMMENT '活动商品图片',
  `limit_nums` smallint(5) unsigned NOT NULL  COMMENT '达成成团人数条件',
  `sort` smallint(5) NOT NULL DEFAULT '99' COMMENT '排序',
  `seller_id` int(11) unsigned NOT NULL default '0' COMMENT '商家ID',
  `_hash` int(11) unsigned NOT NULL COMMENT '预留散列字段',
  PRIMARY KEY  (`id`,`_hash`),
  index (`is_close`),
  index (`goods_id`),
  index (`seller_id`),
  index (`sort`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='拼团表';

-- --------------------------------------------------------

--
-- 表的结构 `{pre}assemble_commander'
--

DROP TABLE IF EXISTS `{pre}assemble_commander`;
CREATE TABLE `{pre}assemble_commander` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `assemble_id` int(11) unsigned NOT NULL COMMENT '拼团表ID',
  `user_id` int(11) unsigned NOT NULL COMMENT '团长用户ID',
  `user_name` varchar(255) NOT NULL COMMENT '团长用户名',
  `user_ico` varchar(255) NOT NULL COMMENT '团长头像',
  `member_nums` smallint(5) unsigned NOT NULL default '1' COMMENT '当前参团用户数量',
  `limit_nums` smallint(5) unsigned NOT NULL  COMMENT '达成成团人数条件',
  `is_finish` tinyint(1) NOT NULL default '0' COMMENT '0未成团,1已成团',
  `create_time` datetime NOT NULL COMMENT '生成时间',
  PRIMARY KEY  (`id`),
  index (`assemble_id`),
  index (`is_finish`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='拼团团长表';


-- --------------------------------------------------------

--
-- 表的结构 `{pre}assemble_active'
--

DROP TABLE IF EXISTS `{pre}assemble_active`;
CREATE TABLE `{pre}assemble_active` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `assemble_commander_id` int(11) unsigned NOT NULL COMMENT '拼团团长表ID',
  `user_id` int(11) unsigned NOT NULL COMMENT '拼团成员用户ID',
  `order_no` varchar(20) NOT NULL COMMENT '订单号',
  `is_pay` tinyint(1) NOT NULL default '0' COMMENT '0未支付,1已支付',
  `create_time` datetime NOT NULL COMMENT '生成时间',
  PRIMARY KEY  (`id`),
  index (`is_pay`),
  index (`assemble_commander_id`),
  index (`order_no`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='拼团组员报名表';

-- --------------------------------------------------------

--
-- 表的结构 `{pre}topic`
--

DROP TABLE IF EXISTS `{pre}topic`;
CREATE TABLE `{pre}topic` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `name` varchar(50) NOT NULL COMMENT '专题名称',
  `content` mediumtext default null COMMENT '页面内容',
  `update_time` datetime NOT NULL COMMENT '生成时间',
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='专题页面';

-- --------------------------------------------------------
--
-- 导出表中的数据 `{pre}areas`
--

INSERT INTO `{pre}areas` VALUES
(110000, 0, '北京市', 110000),
(110100, 110000, '市辖区', 110100),
(110101, 110100, '东城区', 110101),
(110102, 110100, '西城区', 110102),
(110103, 110100, '崇文区', 110103),
(110104, 110100, '宣武区', 110104),
(110105, 110100, '朝阳区', 110105),
(110106, 110100, '丰台区', 110106),
(110107, 110100, '石景山区', 110107),
(110108, 110100, '海淀区', 110108),
(110109, 110100, '门头沟区', 110109),
(110111, 110100, '房山区', 110111),
(110112, 110100, '通州区', 110112),
(110113, 110100, '顺义区', 110113),
(110114, 110100, '昌平区', 110114),
(110115, 110100, '大兴区', 110115),
(110116, 110100, '怀柔区', 110116),
(110117, 110100, '平谷区', 110117),
(110200, 110000, '县', 110200),
(110228, 110200, '密云县', 110228),
(110229, 110200, '延庆县', 110229),
(120000, 0, '天津市', 120000),
(120100, 120000, '市辖区', 120100),
(120101, 120100, '和平区', 120101),
(120102, 120100, '河东区', 120102),
(120103, 120100, '河西区', 120103),
(120104, 120100, '南开区', 120104),
(120105, 120100, '河北区', 120105),
(120106, 120100, '红桥区', 120106),
(120107, 120100, '塘沽区', 120107),
(120108, 120100, '汉沽区', 120108),
(120109, 120100, '大港区', 120109),
(120110, 120100, '东丽区', 120110),
(120111, 120100, '西青区', 120111),
(120112, 120100, '津南区', 120112),
(120113, 120100, '北辰区', 120113),
(120114, 120100, '武清区', 120114),
(120115, 120100, '宝坻区', 120115),
(120200, 120000, '市辖县', 120200),
(120221, 120200, '宁河县', 120221),
(120223, 120200, '静海县', 120223),
(120225, 120200, '蓟县', 120225),
(130000, 0, '河北省', 130000),
(130100, 130000, '石家庄市', 130100),
(130101, 130100, '市辖区', 130101),
(130102, 130100, '长安区', 130102),
(130103, 130100, '桥东区', 130103),
(130104, 130100, '桥西区', 130104),
(130105, 130100, '新华区', 130105),
(130107, 130100, '井陉矿区', 130107),
(130108, 130100, '裕华区', 130108),
(130121, 130100, '井陉县', 130121),
(130123, 130100, '正定县', 130123),
(130124, 130100, '栾城县', 130124),
(130125, 130100, '行唐县', 130125),
(130126, 130100, '灵寿县', 130126),
(130127, 130100, '高邑县', 130127),
(130128, 130100, '深泽县', 130128),
(130129, 130100, '赞皇县', 130129),
(130130, 130100, '无极县', 130130),
(130131, 130100, '平山县', 130131),
(130132, 130100, '元氏县', 130132),
(130133, 130100, '赵县', 130133),
(130181, 130100, '辛集市', 130181),
(130182, 130100, '藁城市', 130182),
(130183, 130100, '晋州市', 130183),
(130184, 130100, '新乐市', 130184),
(130185, 130100, '鹿泉市', 130185),
(130200, 130000, '唐山市', 130200),
(130201, 130200, '市辖区', 130201),
(130202, 130200, '路南区', 130202),
(130203, 130200, '路北区', 130203),
(130204, 130200, '古冶区', 130204),
(130205, 130200, '开平区', 130205),
(130207, 130200, '丰南区', 130207),
(130208, 130200, '丰润区', 130208),
(130223, 130200, '滦县', 130223),
(130224, 130200, '滦南县', 130224),
(130225, 130200, '乐亭县', 130225),
(130227, 130200, '迁西县', 130227),
(130229, 130200, '玉田县', 130229),
(130230, 130200, '唐海县', 130230),
(130281, 130200, '遵化市', 130281),
(130283, 130200, '迁安市', 130283),
(130300, 130000, '秦皇岛市', 130300),
(130301, 130300, '市辖区', 130301),
(130302, 130300, '海港区', 130302),
(130303, 130300, '山海关区', 130303),
(130304, 130300, '北戴河区', 130304),
(130321, 130300, '青龙满族自治县', 130321),
(130322, 130300, '昌黎县', 130322),
(130323, 130300, '抚宁县', 130323),
(130324, 130300, '卢龙县', 130324),
(130400, 130000, '邯郸市', 130400),
(130401, 130400, '市辖区', 130401),
(130402, 130400, '邯山区', 130402),
(130403, 130400, '丛台区', 130403),
(130404, 130400, '复兴区', 130404),
(130406, 130400, '峰峰矿区', 130406),
(130421, 130400, '邯郸县', 130421),
(130423, 130400, '临漳县', 130423),
(130424, 130400, '成安县', 130424),
(130425, 130400, '大名县', 130425),
(130426, 130400, '涉县', 130426),
(130427, 130400, '磁县', 130427),
(130428, 130400, '肥乡县', 130428),
(130429, 130400, '永年县', 130429),
(130430, 130400, '邱县', 130430),
(130431, 130400, '鸡泽县', 130431),
(130432, 130400, '广平县', 130432),
(130433, 130400, '馆陶县', 130433),
(130434, 130400, '魏县', 130434),
(130435, 130400, '曲周县', 130435),
(130481, 130400, '武安市', 130481),
(130500, 130000, '邢台市', 130500),
(130501, 130500, '市辖区', 130501),
(130502, 130500, '桥东区', 130502),
(130503, 130500, '桥西区', 130503),
(130521, 130500, '邢台县', 130521),
(130522, 130500, '临城县', 130522),
(130523, 130500, '内邱县', 130523),
(130524, 130500, '柏乡县', 130524),
(130525, 130500, '隆尧县', 130525),
(130526, 130500, '任县', 130526),
(130527, 130500, '南和县', 130527),
(130528, 130500, '宁晋县', 130528),
(130529, 130500, '巨鹿县', 130529),
(130530, 130500, '新河县', 130530),
(130531, 130500, '广宗县', 130531),
(130532, 130500, '平乡县', 130532),
(130533, 130500, '威县', 130533),
(130534, 130500, '清河县', 130534),
(130535, 130500, '临西县', 130535),
(130581, 130500, '南宫市', 130581),
(130582, 130500, '沙河市', 130582),
(130600, 130000, '保定市', 130600),
(130601, 130600, '市辖区', 130601),
(130602, 130600, '新市区', 130602),
(130603, 130600, '北市区', 130603),
(130604, 130600, '南市区', 130604),
(130621, 130600, '满城县', 130621),
(130622, 130600, '清苑县', 130622),
(130623, 130600, '涞水县', 130623),
(130624, 130600, '阜平县', 130624),
(130625, 130600, '徐水县', 130625),
(130626, 130600, '定兴县', 130626),
(130627, 130600, '唐县', 130627),
(130628, 130600, '高阳县', 130628),
(130629, 130600, '容城县', 130629),
(130630, 130600, '涞源县', 130630),
(130631, 130600, '望都县', 130631),
(130632, 130600, '安新县', 130632),
(130633, 130600, '易县', 130633),
(130634, 130600, '曲阳县', 130634),
(130635, 130600, '蠡县', 130635),
(130636, 130600, '顺平县', 130636),
(130637, 130600, '博野县', 130637),
(130638, 130600, '雄县', 130638),
(130681, 130600, '涿州市', 130681),
(130682, 130600, '定州市', 130682),
(130683, 130600, '安国市', 130683),
(130684, 130600, '高碑店市', 130684),
(130700, 130000, '张家口市', 130700),
(130701, 130700, '市辖区', 130701),
(130702, 130700, '桥东区', 130702),
(130703, 130700, '桥西区', 130703),
(130705, 130700, '宣化区', 130705),
(130706, 130700, '下花园区', 130706),
(130721, 130700, '宣化县', 130721),
(130722, 130700, '张北县', 130722),
(130723, 130700, '康保县', 130723),
(130724, 130700, '沽源县', 130724),
(130725, 130700, '尚义县', 130725),
(130726, 130700, '蔚县', 130726),
(130727, 130700, '阳原县', 130727),
(130728, 130700, '怀安县', 130728),
(130729, 130700, '万全县', 130729),
(130730, 130700, '怀来县', 130730),
(130731, 130700, '涿鹿县', 130731),
(130732, 130700, '赤城县', 130732),
(130733, 130700, '崇礼县', 130733),
(130800, 130000, '承德市', 130800),
(130801, 130800, '市辖区', 130801),
(130802, 130800, '双桥区', 130802),
(130803, 130800, '双滦区', 130803),
(130804, 130800, '鹰手营子矿区', 130804),
(130821, 130800, '承德县', 130821),
(130822, 130800, '兴隆县', 130822),
(130823, 130800, '平泉县', 130823),
(130824, 130800, '滦平县', 130824),
(130825, 130800, '隆化县', 130825),
(130826, 130800, '丰宁满族自治县', 130826),
(130827, 130800, '宽城满族自治县', 130827),
(130828, 130800, '围场满族蒙古族自治县', 130828),
(130900, 130000, '沧州市', 130900),
(130901, 130900, '市辖区', 130901),
(130902, 130900, '新华区', 130902),
(130903, 130900, '运河区', 130903),
(130921, 130900, '沧县', 130921),
(130922, 130900, '青县', 130922),
(130923, 130900, '东光县', 130923),
(130924, 130900, '海兴县', 130924),
(130925, 130900, '盐山县', 130925),
(130926, 130900, '肃宁县', 130926),
(130927, 130900, '南皮县', 130927),
(130928, 130900, '吴桥县', 130928),
(130929, 130900, '献县', 130929),
(130930, 130900, '孟村回族自治县', 130930),
(130981, 130900, '泊头市', 130981),
(130982, 130900, '任邱市', 130982),
(130983, 130900, '黄骅市', 130983),
(130984, 130900, '河间市', 130984),
(131000, 130000, '廊坊市', 131000),
(131001, 131000, '市辖区', 131001),
(131002, 131000, '安次区', 131002),
(131003, 131000, '广阳区', 131003),
(131022, 131000, '固安县', 131022),
(131023, 131000, '永清县', 131023),
(131024, 131000, '香河县', 131024),
(131025, 131000, '大城县', 131025),
(131026, 131000, '文安县', 131026),
(131028, 131000, '大厂回族自治县', 131028),
(131081, 131000, '霸州市', 131081),
(131082, 131000, '三河市', 131082),
(131100, 130000, '衡水市', 131100),
(131101, 131100, '市辖区', 131101),
(131102, 131100, '桃城区', 131102),
(131121, 131100, '枣强县', 131121),
(131122, 131100, '武邑县', 131122),
(131123, 131100, '武强县', 131123),
(131124, 131100, '饶阳县', 131124),
(131125, 131100, '安平县', 131125),
(131126, 131100, '故城县', 131126),
(131127, 131100, '景县', 131127),
(131128, 131100, '阜城县', 131128),
(131181, 131100, '冀州市', 131181),
(131182, 131100, '深州市', 131182),
(140000, 0, '山西省', 140000),
(140100, 140000, '太原市', 140100),
(140101, 140100, '市辖区', 140101),
(140105, 140100, '小店区(人口含高新经济区)', 140105),
(140106, 140100, '迎泽区', 140106),
(140107, 140100, '杏花岭区', 140107),
(140108, 140100, '尖草坪区', 140108),
(140109, 140100, '万柏林区', 140109),
(140110, 140100, '晋源区', 140110),
(140121, 140100, '清徐县', 140121),
(140122, 140100, '阳曲县', 140122),
(140123, 140100, '娄烦县', 140123),
(140181, 140100, '古交市', 140181),
(140200, 140000, '大同市', 140200),
(140201, 140200, '市辖区', 140201),
(140202, 140200, '大同市城区', 140202),
(140203, 140200, '矿区', 140203),
(140211, 140200, '南郊区', 140211),
(140212, 140200, '新荣区', 140212),
(140221, 140200, '阳高县', 140221),
(140222, 140200, '天镇县', 140222),
(140223, 140200, '广灵县', 140223),
(140224, 140200, '灵丘县', 140224),
(140225, 140200, '浑源县', 140225),
(140226, 140200, '左云县', 140226),
(140227, 140200, '大同县', 140227),
(140300, 140000, '阳泉市', 140300),
(140301, 140300, '市辖区', 140301),
(140302, 140300, '城区', 140302),
(140303, 140300, '矿区', 140303),
(140311, 140300, '郊区', 140311),
(140321, 140300, '平定县', 140321),
(140322, 140300, '盂县', 140322),
(140400, 140000, '长治市', 140400),
(140401, 140400, '市辖区', 140401),
(140402, 140400, '长治市城区', 140402),
(140411, 140400, '长治市郊区', 140411),
(140421, 140400, '长治县', 140421),
(140423, 140400, '襄垣县', 140423),
(140424, 140400, '屯留县', 140424),
(140425, 140400, '平顺县', 140425),
(140426, 140400, '黎城县', 140426),
(140427, 140400, '壶关县', 140427),
(140428, 140400, '长子县', 140428),
(140429, 140400, '武乡县', 140429),
(140430, 140400, '沁县', 140430),
(140431, 140400, '沁源县', 140431),
(140481, 140400, '潞城市', 140481),
(140500, 140000, '晋城市', 140500),
(140501, 140500, '市辖区', 140501),
(140502, 140500, '晋城市城区', 140502),
(140521, 140500, '沁水县', 140521),
(140522, 140500, '阳城县', 140522),
(140524, 140500, '陵川县', 140524),
(140525, 140500, '泽州县', 140525),
(140581, 140500, '高平市', 140581),
(140600, 140000, '朔州市', 140600),
(140601, 140600, '市辖区', 140601),
(140602, 140600, '朔城区', 140602),
(140603, 140600, '平鲁区', 140603),
(140621, 140600, '山阴县', 140621),
(140622, 140600, '应县', 140622),
(140623, 140600, '右玉县', 140623),
(140624, 140600, '怀仁县', 140624),
(140700, 140000, '晋中市', 140700),
(140701, 140700, '市辖区', 140701),
(140702, 140700, '榆次区', 140702),
(140721, 140700, '榆社县', 140721),
(140722, 140700, '左权县', 140722),
(140723, 140700, '和顺县', 140723),
(140724, 140700, '昔阳县', 140724),
(140725, 140700, '寿阳县', 140725),
(140726, 140700, '太谷县', 140726),
(140727, 140700, '祁县', 140727),
(140728, 140700, '平遥县', 140728),
(140729, 140700, '灵石县', 140729),
(140781, 140700, '介休市', 140781),
(140800, 140000, '运城市', 140800),
(140801, 140800, '市辖区', 140801),
(140802, 140800, '盐湖区', 140802),
(140821, 140800, '临猗县', 140821),
(140822, 140800, '万荣县', 140822),
(140823, 140800, '闻喜县', 140823),
(140824, 140800, '稷山县', 140824),
(140825, 140800, '新绛县', 140825),
(140826, 140800, '绛县', 140826),
(140827, 140800, '垣曲县', 140827),
(140828, 140800, '夏县', 140828),
(140829, 140800, '平陆县', 140829),
(140830, 140800, '芮城县', 140830),
(140881, 140800, '永济市', 140881),
(140882, 140800, '河津市', 140882),
(140900, 140000, '忻州市', 140900),
(140901, 140900, '市辖区', 140901),
(140902, 140900, '忻府区', 140902),
(140921, 140900, '定襄县', 140921),
(140922, 140900, '五台县', 140922),
(140923, 140900, '代县', 140923),
(140924, 140900, '繁峙县', 140924),
(140925, 140900, '宁武县', 140925),
(140926, 140900, '静乐县', 140926),
(140927, 140900, '神池县', 140927),
(140928, 140900, '五寨县', 140928),
(140929, 140900, '岢岚县', 140929),
(140930, 140900, '河曲县', 140930),
(140931, 140900, '保德县', 140931),
(140932, 140900, '偏关县', 140932),
(140981, 140900, '原平市', 140981),
(141000, 140000, '临汾市', 141000),
(141001, 141000, '市辖区', 141001),
(141002, 141000, '尧都区', 141002),
(141021, 141000, '曲沃县', 141021),
(141022, 141000, '翼城县', 141022),
(141023, 141000, '襄汾县', 141023),
(141024, 141000, '洪洞县', 141024),
(141025, 141000, '古县', 141025),
(141026, 141000, '安泽县', 141026),
(141027, 141000, '浮山县', 141027),
(141028, 141000, '吉县', 141028),
(141029, 141000, '乡宁县', 141029),
(141030, 141000, '大宁县', 141030),
(141031, 141000, '隰县', 141031),
(141032, 141000, '永和县', 141032),
(141033, 141000, '蒲县', 141033),
(141034, 141000, '汾西县', 141034),
(141081, 141000, '侯马市', 141081),
(141082, 141000, '霍州市', 141082),
(141100, 140000, '吕梁市', 141100),
(141101, 141100, '市辖区', 141101),
(141102, 141100, '离石区', 141102),
(141121, 141100, '文水县', 141121),
(141122, 141100, '交城县', 141122),
(141123, 141100, '兴县', 141123),
(141124, 141100, '临县', 141124),
(141125, 141100, '柳林县', 141125),
(141126, 141100, '石楼县', 141126),
(141127, 141100, '岚县', 141127),
(141128, 141100, '方山县', 141128),
(141129, 141100, '中阳县', 141129),
(141130, 141100, '交口县', 141130),
(141181, 141100, '孝义市', 141181),
(141182, 141100, '汾阳市', 141182),
(150000, 0, '内蒙古自治区', 150000),
(150100, 150000, '呼和浩特市', 150100),
(150101, 150100, '市辖区', 150101),
(150102, 150100, '新城区', 150102),
(150103, 150100, '回民区', 150103),
(150104, 150100, '玉泉区', 150104),
(150105, 150100, '赛罕区', 150105),
(150121, 150100, '土左旗', 150121),
(150122, 150100, '托克托县', 150122),
(150123, 150100, '和林格尔县', 150123),
(150124, 150100, '清水河县', 150124),
(150125, 150100, '武川县', 150125),
(150200, 150000, '包头市', 150200),
(150201, 150200, '市辖区', 150201),
(150202, 150200, '东河区', 150202),
(150203, 150200, '昆都仑区', 150203),
(150204, 150200, '青山区', 150204),
(150205, 150200, '石拐区', 150205),
(150206, 150200, '白云鄂博矿区', 150206),
(150207, 150200, '九原区', 150207),
(150221, 150200, '土默特右旗', 150221),
(150222, 150200, '固阳县', 150222),
(150223, 150200, '达茂联合旗', 150223),
(150300, 150000, '乌海市', 150300),
(150301, 150300, '乌海市辖区', 150301),
(150302, 150300, '海勃湾区', 150302),
(150303, 150300, '海南区', 150303),
(150304, 150300, '乌达区', 150304),
(150400, 150000, '赤峰市', 150400),
(150401, 150400, '市辖区', 150401),
(150402, 150400, '红山区', 150402),
(150403, 150400, '元宝山区', 150403),
(150404, 150400, '松山区', 150404),
(150421, 150400, '阿鲁科尔沁旗', 150421),
(150422, 150400, '巴林左旗', 150422),
(150423, 150400, '巴林右旗', 150423),
(150424, 150400, '林西县', 150424),
(150425, 150400, '克什克腾旗', 150425),
(150426, 150400, '翁牛特旗', 150426),
(150428, 150400, '喀喇沁旗', 150428),
(150429, 150400, '宁城县', 150429),
(150430, 150400, '敖汉旗', 150430),
(150500, 150000, '通辽市', 150500),
(150501, 150500, '市辖区', 150501),
(150502, 150500, '科尔沁区', 150502),
(150521, 150500, '科尔沁左翼中旗', 150521),
(150522, 150500, '科左后旗', 150522),
(150523, 150500, '开鲁县', 150523),
(150524, 150500, '库伦旗', 150524),
(150525, 150500, '奈曼旗', 150525),
(150526, 150500, '扎鲁特旗', 150526),
(150581, 150500, '霍林郭勒市', 150581),
(150600, 150000, '鄂尔多斯市', 150600),
(150602, 150600, '东胜区', 150602),
(150621, 150600, '达拉特旗', 150621),
(150622, 150600, '准格尔旗', 150622),
(150623, 150600, '鄂托克前旗', 150623),
(150624, 150600, '鄂托克旗', 150624),
(150625, 150600, '杭锦旗', 150625),
(150626, 150600, '乌审旗', 150626),
(150627, 150600, '伊金霍洛旗', 150627),
(150700, 150000, '呼伦贝尔市', 150700),
(150701, 150700, '市辖区', 150701),
(150702, 150700, '海拉尔区', 150702),
(150721, 150700, '阿荣旗', 150721),
(150722, 150700, '莫力达瓦达斡尔族自治旗', 150722),
(150723, 150700, '鄂伦春自治旗', 150723),
(150724, 150700, '鄂温克族自治旗', 150724),
(150725, 150700, '陈巴尔虎旗镇', 150725),
(150726, 150700, '新巴尔虎左旗', 150726),
(150727, 150700, '新巴尔虎右旗', 150727),
(150781, 150700, '满洲里市', 150781),
(150782, 150700, '牙克石市', 150782),
(150783, 150700, '扎兰屯市', 150783),
(150784, 150700, '额尔古纳市', 150784),
(150785, 150700, '根河市', 150785),
(150800, 150000, '巴彦淖尔市', 150800),
(150801, 150800, '市辖区', 150801),
(150802, 150800, '临河区', 150802),
(150821, 150800, '五原县', 150821),
(150822, 150800, '磴口县', 150822),
(150823, 150800, '乌拉特前旗', 150823),
(150824, 150800, '乌拉特中旗', 150824),
(150825, 150800, '乌拉特后旗', 150825),
(150826, 150800, '杭锦后旗', 150826),
(150900, 150000, '乌兰察布市', 150900),
(150901, 150900, '市辖区', 150901),
(150902, 150900, '集宁区', 150902),
(150921, 150900, '卓资县', 150921),
(150922, 150900, '化德县', 150922),
(150923, 150900, '商都县', 150923),
(150924, 150900, '兴和县', 150924),
(150925, 150900, '凉城县', 150925),
(150926, 150900, '察哈尔右翼前旗', 150926),
(150927, 150900, '察右中旗', 150927),
(150928, 150900, '察哈尔右翼后旗', 150928),
(150929, 150900, '四子王旗', 150929),
(150981, 150900, '丰镇市', 150981),
(152200, 150000, '兴安盟', 152200),
(152201, 152200, '乌兰浩特市', 152201),
(152202, 152200, '阿尔山市', 152202),
(152221, 152200, '科右前旗', 152221),
(152222, 152200, '科右中旗', 152222),
(152223, 152200, '扎赉特旗', 152223),
(152224, 152200, '突泉县', 152224),
(152500, 150000, '锡林郭勒盟', 152500),
(152501, 152500, '二连浩特市', 152501),
(152502, 152500, '锡林浩特市', 152502),
(152522, 152500, '阿巴嘎旗', 152522),
(152523, 152500, '苏尼特左旗', 152523),
(152524, 152500, '苏尼特右旗', 152524),
(152525, 152500, '东乌珠穆沁旗', 152525),
(152526, 152500, '西乌珠穆沁旗', 152526),
(152527, 152500, '太仆寺旗', 152527),
(152528, 152500, '镶黄旗', 152528),
(152529, 152500, '正镶白旗', 152529),
(152530, 152500, '正蓝旗', 152530),
(152531, 152500, '多伦县', 152531),
(152900, 150000, '阿拉善盟', 152900),
(152921, 152900, '阿拉善左旗', 152921),
(152922, 152900, '阿拉善右旗', 152922),
(152923, 152900, '额济纳旗', 152923),
(210000, 0, '辽宁省', 210000),
(210100, 210000, '沈阳市', 210100),
(210101, 210100, '市辖区', 210101),
(210102, 210100, '和平区', 210102),
(210103, 210100, '沈河区', 210103),
(210104, 210100, '大东区', 210104),
(210105, 210100, '皇姑区', 210105),
(210106, 210100, '铁西区', 210106),
(210111, 210100, '苏家屯区', 210111),
(210112, 210100, '东陵区', 210112),
(210113, 210100, '新城子区', 210113),
(210114, 210100, '于洪区', 210114),
(210122, 210100, '辽中县', 210122),
(210123, 210100, '康平县', 210123),
(210124, 210100, '法库县', 210124),
(210181, 210100, '新民市', 210181),
(210200, 210000, '大连市', 210200),
(210201, 210200, '市辖区', 210201),
(210202, 210200, '中山区', 210202),
(210203, 210200, '西岗区', 210203),
(210204, 210200, '沙河口区', 210204),
(210211, 210200, '甘井子区', 210211),
(210212, 210200, '旅顺口区', 210212),
(210213, 210200, '金州区', 210213),
(210224, 210200, '长海县', 210224),
(210281, 210200, '瓦房店市', 210281),
(210282, 210200, '普兰店市', 210282),
(210283, 210200, '庄河市', 210283),
(210300, 210000, '鞍山市', 210300),
(210301, 210300, '市辖区', 210301),
(210302, 210300, '铁东区', 210302),
(210303, 210300, '铁西区', 210303),
(210304, 210300, '立山区', 210304),
(210311, 210300, '千山区', 210311),
(210321, 210300, '台安县', 210321),
(210323, 210300, '岫岩县', 210323),
(210381, 210300, '海城市', 210381),
(210400, 210000, '抚顺市', 210400),
(210401, 210400, '市辖区', 210401),
(210402, 210400, '新抚区', 210402),
(210403, 210400, '东洲区', 210403),
(210404, 210400, '望花区', 210404),
(210411, 210400, '顺城区', 210411),
(210421, 210400, '抚顺县', 210421),
(210422, 210400, '新宾满族自治县', 210422),
(210423, 210400, '清原满族自治县', 210423),
(210500, 210000, '本溪市', 210500),
(210501, 210500, '市辖区', 210501),
(210502, 210500, '平山区', 210502),
(210503, 210500, '溪湖区', 210503),
(210504, 210500, '明山区', 210504),
(210505, 210500, '南芬区', 210505),
(210521, 210500, '本溪满族自治县', 210521),
(210522, 210500, '桓仁满族自治县', 210522),
(210600, 210000, '丹东市', 210600),
(210601, 210600, '市辖区', 210601),
(210602, 210600, '元宝区', 210602),
(210603, 210600, '振兴区', 210603),
(210604, 210600, '振安区', 210604),
(210624, 210600, '宽甸满族自治县', 210624),
(210681, 210600, '东港市', 210681),
(210682, 210600, '凤城市', 210682),
(210700, 210000, '锦州市', 210700),
(210701, 210700, '市辖区', 210701),
(210702, 210700, '古塔区', 210702),
(210703, 210700, '凌河区', 210703),
(210711, 210700, '太和区', 210711),
(210726, 210700, '黑山县', 210726),
(210727, 210700, '义县', 210727),
(210781, 210700, '凌海市', 210781),
(210782, 210700, '北镇市', 210782),
(210800, 210000, '营口市', 210800),
(210801, 210800, '市辖区', 210801),
(210802, 210800, '站前区', 210802),
(210803, 210800, '西市区', 210803),
(210804, 210800, '鲅鱼圈区', 210804),
(210811, 210800, '老边区', 210811),
(210881, 210800, '盖州市', 210881),
(210882, 210800, '大石桥市', 210882),
(210900, 210000, '阜新市', 210900),
(210901, 210900, '市辖区', 210901),
(210902, 210900, '海州区', 210902),
(210903, 210900, '新邱区', 210903),
(210904, 210900, '太平区', 210904),
(210905, 210900, '清河门区', 210905),
(210911, 210900, '细河区', 210911),
(210921, 210900, '阜新蒙古族自治县', 210921),
(210922, 210900, '彰武县', 210922),
(211000, 210000, '辽阳市', 211000),
(211001, 211000, '市辖区', 211001),
(211002, 211000, '白塔区', 211002),
(211003, 211000, '文圣区', 211003),
(211004, 211000, '宏伟区', 211004),
(211005, 211000, '弓长岭区', 211005),
(211011, 211000, '太子河区', 211011),
(211021, 211000, '辽阳县', 211021),
(211081, 211000, '灯塔市', 211081),
(211100, 210000, '盘锦市', 211100),
(211101, 211100, '市辖区', 211101),
(211102, 211100, '双台子区', 211102),
(211103, 211100, '兴隆台区', 211103),
(211121, 211100, '大洼县', 211121),
(211122, 211100, '盘山县', 211122),
(211200, 210000, '铁岭市', 211200),
(211201, 211200, '市辖区', 211201),
(211202, 211200, '银州区', 211202),
(211204, 211200, '清河区', 211204),
(211221, 211200, '铁岭县', 211221),
(211223, 211200, '西丰县', 211223),
(211224, 211200, '昌图县', 211224),
(211281, 211200, '调兵山市', 211281),
(211282, 211200, '开原市', 211282),
(211300, 210000, '朝阳市', 211300),
(211301, 211300, '市辖区', 211301),
(211302, 211300, '双塔区', 211302),
(211303, 211300, '龙城区', 211303),
(211321, 211300, '朝阳县', 211321),
(211322, 211300, '建平县', 211322),
(211324, 211300, '喀喇沁左翼蒙古族自治县', 211324),
(211381, 211300, '北票市', 211381),
(211382, 211300, '凌源市', 211382),
(211400, 210000, '葫芦岛市', 211400),
(211401, 211400, '市辖区', 211401),
(211402, 211400, '连山区', 211402),
(211403, 211400, '龙港区', 211403),
(211404, 211400, '南票区', 211404),
(211421, 211400, '绥中县', 211421),
(211422, 211400, '建昌县', 211422),
(211481, 211400, '兴城市', 211481),
(220000, 0, '吉林省', 220000),
(220100, 220000, '长春市', 220100),
(220101, 220100, '长春市辖区', 220101),
(220102, 220100, '南关区', 220102),
(220103, 220100, '宽城区', 220103),
(220104, 220100, '朝阳区', 220104),
(220105, 220100, '二道区', 220105),
(220106, 220100, '绿园区', 220106),
(220112, 220100, '双阳区', 220112),
(220122, 220100, '农安县', 220122),
(220181, 220100, '九台市', 220181),
(220182, 220100, '榆树市', 220182),
(220183, 220100, '德惠市', 220183),
(220200, 220000, '吉林市', 220200),
(220201, 220200, '吉林市辖区', 220201),
(220202, 220200, '昌邑区', 220202),
(220203, 220200, '龙潭区', 220203),
(220204, 220200, '船营区', 220204),
(220211, 220200, '丰满区', 220211),
(220221, 220200, '永吉县', 220221),
(220281, 220200, '蛟河市', 220281),
(220282, 220200, '桦甸市', 220282),
(220283, 220200, '舒兰市', 220283),
(220284, 220200, '磐石市', 220284),
(220300, 220000, '四平市', 220300),
(220301, 220300, '四平市辖区', 220301),
(220302, 220300, '铁西区', 220302),
(220303, 220300, '铁东区', 220303),
(220322, 220300, '梨树县', 220322),
(220323, 220300, '伊通满族自治县', 220323),
(220381, 220300, '公主岭市', 220381),
(220382, 220300, '双辽市', 220382),
(220400, 220000, '辽源市', 220400),
(220401, 220400, '辽源市辖区', 220401),
(220402, 220400, '龙山区', 220402),
(220403, 220400, '西安区', 220403),
(220421, 220400, '东丰县', 220421),
(220422, 220400, '东辽县', 220422),
(220500, 220000, '通化市', 220500),
(220501, 220500, '通化市辖区', 220501),
(220502, 220500, '东昌区', 220502),
(220503, 220500, '二道江区', 220503),
(220521, 220500, '通化县', 220521),
(220523, 220500, '辉南县', 220523),
(220524, 220500, '柳河县', 220524),
(220581, 220500, '梅河口市', 220581),
(220582, 220500, '集安市', 220582),
(220600, 220000, '白山市', 220600),
(220601, 220600, '白山市辖区', 220601),
(220602, 220600, '八道江区', 220602),
(220604, 220600, '江源区', 220604),
(220621, 220600, '抚松县', 220621),
(220622, 220600, '靖宇县', 220622),
(220623, 220600, '长白朝鲜族自治县', 220623),
(220681, 220600, '临江市', 220681),
(220700, 220000, '松原市', 220700),
(220701, 220700, '松原市辖区', 220701),
(220702, 220700, '宁江区', 220702),
(220721, 220700, '前郭尔罗斯蒙古族自治县', 220721),
(220722, 220700, '长岭县', 220722),
(220723, 220700, '乾安县', 220723),
(220724, 220700, '扶余县', 220724),
(220800, 220000, '白城市', 220800),
(220801, 220800, '白城市辖区', 220801),
(220802, 220800, '洮北区', 220802),
(220821, 220800, '镇赉县', 220821),
(220822, 220800, '通榆县', 220822),
(220881, 220800, '洮南市', 220881),
(220882, 220800, '大安市', 220882),
(222400, 220000, '延边朝鲜族自治州', 222400),
(222401, 222400, '延吉市', 222401),
(222402, 222400, '图们市', 222402),
(222403, 222400, '敦化市', 222403),
(222404, 222400, '珲春市', 222404),
(222405, 222400, '龙井市', 222405),
(222406, 222400, '和龙市', 222406),
(222424, 222400, '汪清县', 222424),
(222426, 222400, '安图县', 222426),
(230000, 0, '黑龙江省', 230000),
(230100, 230000, '哈尔滨市', 230100),
(230101, 230100, '市辖区', 230101),
(230102, 230100, '道里区', 230102),
(230103, 230100, '南岗区', 230103),
(230104, 230100, '道外区', 230104),
(230108, 230100, '平房区', 230108),
(230109, 230100, '松北区', 230109),
(230110, 230100, '香坊区', 230110),
(230111, 230100, '呼兰区', 230111),
(230112, 230100, '阿城区', 230112),
(230123, 230100, '依兰县', 230123),
(230124, 230100, '方正县', 230124),
(230125, 230100, '宾县', 230125),
(230126, 230100, '巴彦县', 230126),
(230127, 230100, '木兰县', 230127),
(230128, 230100, '通河县', 230128),
(230129, 230100, '延寿县', 230129),
(230182, 230100, '双城市', 230182),
(230183, 230100, '尚志市', 230183),
(230184, 230100, '五常市', 230184),
(230200, 230000, '齐齐哈尔市', 230200),
(230201, 230200, '市辖区', 230201),
(230202, 230200, '龙沙区', 230202),
(230203, 230200, '建华区', 230203),
(230204, 230200, '铁锋区', 230204),
(230205, 230200, '昂昂溪区', 230205),
(230206, 230200, '富拉尔基区', 230206),
(230207, 230200, '碾子山区', 230207),
(230208, 230200, '梅里斯达斡尔族区', 230208),
(230221, 230200, '龙江县', 230221),
(230223, 230200, '依安县', 230223),
(230224, 230200, '泰来县', 230224),
(230225, 230200, '甘南县', 230225),
(230227, 230200, '富裕县', 230227),
(230229, 230200, '克山县', 230229),
(230230, 230200, '克东县', 230230),
(230231, 230200, '拜泉县', 230231),
(230281, 230200, '讷河市', 230281),
(230300, 230000, '鸡西市', 230300),
(230301, 230300, '市辖区', 230301),
(230302, 230300, '鸡冠区', 230302),
(230303, 230300, '恒山区', 230303),
(230304, 230300, '滴道区', 230304),
(230305, 230300, '梨树区', 230305),
(230306, 230300, '城子河区', 230306),
(230307, 230300, '麻山区', 230307),
(230321, 230300, '鸡东县', 230321),
(230381, 230300, '虎林市', 230381),
(230382, 230300, '密山市', 230382),
(230400, 230000, '鹤岗市', 230400),
(230401, 230400, '市辖区', 230401),
(230402, 230400, '向阳区', 230402),
(230403, 230400, '工农区', 230403),
(230404, 230400, '南山区', 230404),
(230405, 230400, '兴安区', 230405),
(230406, 230400, '东山区', 230406),
(230407, 230400, '兴山区', 230407),
(230421, 230400, '萝北县', 230421),
(230422, 230400, '绥滨县', 230422),
(230500, 230000, '双鸭山市', 230500),
(230501, 230500, '市辖区', 230501),
(230502, 230500, '尖山区', 230502),
(230503, 230500, '岭东区', 230503),
(230505, 230500, '四方台区', 230505),
(230506, 230500, '宝山区', 230506),
(230521, 230500, '集贤县', 230521),
(230522, 230500, '友谊县', 230522),
(230523, 230500, '宝清县', 230523),
(230524, 230500, '饶河县', 230524),
(230600, 230000, '大庆市', 230600),
(230601, 230600, '市辖区', 230601),
(230602, 230600, '萨尔图区', 230602),
(230603, 230600, '龙凤区', 230603),
(230604, 230600, '让胡路区', 230604),
(230605, 230600, '红岗区', 230605),
(230606, 230600, '大同区', 230606),
(230621, 230600, '肇州县', 230621),
(230622, 230600, '肇源县', 230622),
(230623, 230600, '林甸县', 230623),
(230624, 230600, '杜尔伯特县', 230624),
(230700, 230000, '伊春市', 230700),
(230701, 230700, '市辖区', 230701),
(230702, 230700, '伊春区', 230702),
(230703, 230700, '南岔区', 230703),
(230704, 230700, '友好区', 230704),
(230705, 230700, '西林区', 230705),
(230706, 230700, '翠峦区', 230706),
(230707, 230700, '新青区', 230707),
(230708, 230700, '美溪区', 230708),
(230709, 230700, '金山屯区', 230709),
(230710, 230700, '五营区', 230710),
(230711, 230700, '乌马河区', 230711),
(230712, 230700, '汤旺河区', 230712),
(230713, 230700, '带岭区', 230713),
(230714, 230700, '乌伊岭区', 230714),
(230715, 230700, '红星区', 230715),
(230716, 230700, '上甘岭区', 230716),
(230722, 230700, '嘉荫县', 230722),
(230781, 230700, '铁力市', 230781),
(230800, 230000, '佳木斯市', 230800),
(230801, 230800, '市辖区', 230801),
(230803, 230800, '向阳区', 230803),
(230804, 230800, '前进区', 230804),
(230805, 230800, '东风区', 230805),
(230811, 230800, '郊区', 230811),
(230822, 230800, '桦南县', 230822),
(230826, 230800, '桦川县', 230826),
(230828, 230800, '汤原县', 230828),
(230833, 230800, '抚远县', 230833),
(230881, 230800, '同江市', 230881),
(230882, 230800, '富锦市', 230882),
(230900, 230000, '七台河市', 230900),
(230901, 230900, '市辖区', 230901),
(230902, 230900, '新兴区', 230902),
(230903, 230900, '桃山区', 230903),
(230904, 230900, '茄子河区', 230904),
(230921, 230900, '勃利县', 230921),
(231000, 230000, '牡丹江市', 231000),
(231001, 231000, '市辖区', 231001),
(231002, 231000, '东安区', 231002),
(231003, 231000, '阳明区', 231003),
(231004, 231000, '爱民区', 231004),
(231005, 231000, '西安区', 231005),
(231024, 231000, '东宁县', 231024),
(231025, 231000, '林口县', 231025),
(231081, 231000, '绥芬河市', 231081),
(231083, 231000, '海林市', 231083),
(231084, 231000, '宁安市', 231084),
(231085, 231000, '穆棱市', 231085),
(231100, 230000, '黑河市', 231100),
(231101, 231100, '市辖区', 231101),
(231102, 231100, '爱辉区', 231102),
(231121, 231100, '嫩江县', 231121),
(231123, 231100, '逊克县', 231123),
(231124, 231100, '孙吴县', 231124),
(231181, 231100, '北安市', 231181),
(231182, 231100, '五大连池市', 231182),
(231200, 230000, '绥化市', 231200),
(231201, 231200, '市辖区', 231201),
(231202, 231200, '北林区', 231202),
(231221, 231200, '望奎县', 231221),
(231222, 231200, '兰西县', 231222),
(231223, 231200, '青冈县', 231223),
(231224, 231200, '庆安县', 231224),
(231225, 231200, '明水县', 231225),
(231226, 231200, '绥棱县', 231226),
(231281, 231200, '安达市', 231281),
(231282, 231200, '肇东市', 231282),
(231283, 231200, '海伦市', 231283),
(232700, 230000, '大兴安岭地区', 232700),
(232701, 232700, '加格达奇区', 232701),
(232702, 232700, '松岭区', 232702),
(232703, 232700, '新林区', 232703),
(232704, 232700, '呼中区', 232704),
(232721, 232700, '呼玛县', 232721),
(232722, 232700, '塔河县', 232722),
(232723, 232700, '漠河县', 232723),
(310000, 0, '上海市', 310000),
(310100, 310000, '市辖区', 310100),
(310101, 310100, '黄浦区', 310101),
(310103, 310100, '卢湾区', 310103),
(310104, 310100, '徐汇区', 310104),
(310105, 310100, '长宁区', 310105),
(310106, 310100, '静安区', 310106),
(310107, 310100, '普陀区', 310107),
(310108, 310100, '闸北区', 310108),
(310109, 310100, '虹口区', 310109),
(310110, 310100, '杨浦区', 310110),
(310112, 310100, '闵行区', 310112),
(310113, 310100, '宝山区', 310113),
(310114, 310100, '嘉定区', 310114),
(310115, 310100, '浦东新区', 310115),
(310116, 310100, '金山区', 310116),
(310117, 310100, '松江区', 310117),
(310118, 310100, '青浦区', 310118),
(310119, 310100, '南汇区', 310119),
(310120, 310100, '奉贤区', 310120),
(310200, 310000, '县', 310200),
(310230, 310200, '崇明县', 310230),
(320000, 0, '江苏省', 320000),
(320100, 320000, '南京市', 320100),
(320101, 320100, '市辖区', 320101),
(320102, 320100, '玄武区', 320102),
(320103, 320100, '白下区', 320103),
(320104, 320100, '秦淮区', 320104),
(320105, 320100, '建邺区', 320105),
(320106, 320100, '鼓楼区', 320106),
(320107, 320100, '下关区', 320107),
(320111, 320100, '浦口区', 320111),
(320113, 320100, '栖霞区', 320113),
(320114, 320100, '雨花台区', 320114),
(320115, 320100, '江宁区', 320115),
(320116, 320100, '六合区', 320116),
(320124, 320100, '溧水县', 320124),
(320125, 320100, '高淳县', 320125),
(320200, 320000, '无锡市', 320200),
(320201, 320200, '市辖区', 320201),
(320202, 320200, '崇安区', 320202),
(320203, 320200, '南长区', 320203),
(320204, 320200, '北塘区', 320204),
(320205, 320200, '锡山区', 320205),
(320206, 320200, '惠山区', 320206),
(320211, 320200, '滨湖区', 320211),
(320281, 320200, '江阴市', 320281),
(320282, 320200, '宜兴市', 320282),
(320300, 320000, '徐州市', 320300),
(320301, 320300, '市辖区', 320301),
(320302, 320300, '鼓楼区', 320302),
(320303, 320300, '云龙区', 320303),
(320304, 320300, '九里区', 320304),
(320305, 320300, '贾汪区', 320305),
(320311, 320300, '泉山区', 320311),
(320321, 320300, '丰县', 320321),
(320322, 320300, '沛县', 320322),
(320323, 320300, '铜山县', 320323),
(320324, 320300, '睢宁县', 320324),
(320381, 320300, '新沂市', 320381),
(320382, 320300, '邳州市', 320382),
(320400, 320000, '常州市', 320400),
(320401, 320400, '常州市区', 320401),
(320402, 320400, '天宁区', 320402),
(320404, 320400, '钟楼区', 320404),
(320405, 320400, '戚墅堰区', 320405),
(320411, 320400, '新北区', 320411),
(320412, 320400, '武进区', 320412),
(320481, 320400, '溧阳市', 320481),
(320482, 320400, '金坛市', 320482),
(320500, 320000, '苏州市', 320500),
(320501, 320500, '市辖区', 320501),
(320502, 320500, '沧浪区', 320502),
(320503, 320500, '平江区', 320503),
(320504, 320500, '金阊区', 320504),
(320505, 320500, '苏州高新区虎丘区', 320505),
(320506, 320500, '吴中区', 320506),
(320507, 320500, '相城区', 320507),
(320581, 320500, '常熟市', 320581),
(320582, 320500, '张家港市', 320582),
(320583, 320500, '昆山市', 320583),
(320584, 320500, '吴江市', 320584),
(320585, 320500, '太仓市', 320585),
(320600, 320000, '南通市', 320600),
(320601, 320600, '市辖区', 320601),
(320602, 320600, '崇川区', 320602),
(320611, 320600, '港闸区', 320611),
(320621, 320600, '海安县', 320621),
(320623, 320600, '如东', 320623),
(320681, 320600, '启东市', 320681),
(320682, 320600, '"如皋市', 320682),
(320683, 320600, '通州市', 320683),
(320684, 320600, '海门市', 320684),
(320700, 320000, '连云港市', 320700),
(320701, 320700, '市辖区', 320701),
(320703, 320700, '连云区', 320703),
(320705, 320700, '新浦区', 320705),
(320706, 320700, '海州区', 320706),
(320721, 320700, '赣榆县', 320721),
(320722, 320700, '东海县', 320722),
(320723, 320700, '灌云县', 320723),
(320724, 320700, '灌南县', 320724),
(320800, 320000, '淮安市', 320800),
(320801, 320800, '市辖区', 320801),
(320802, 320800, '清河区', 320802),
(320803, 320800, '楚州区', 320803),
(320804, 320800, '淮阴区', 320804),
(320811, 320800, '清浦区', 320811),
(320826, 320800, '涟水县', 320826),
(320829, 320800, '洪泽县', 320829),
(320830, 320800, '盱眙县', 320830),
(320831, 320800, '金湖县', 320831),
(320900, 320000, '盐城市', 320900),
(320901, 320900, '市辖区', 320901),
(320902, 320900, '亭湖区', 320902),
(320903, 320900, '盐都区', 320903),
(320921, 320900, '响水县', 320921),
(320922, 320900, '滨海县', 320922),
(320923, 320900, '阜宁县', 320923),
(320924, 320900, '射阳县', 320924),
(320925, 320900, '建湖县', 320925),
(320981, 320900, '东台市', 320981),
(320982, 320900, '大丰市', 320982),
(321000, 320000, '扬州市', 321000),
(321001, 321000, '市辖区', 321001),
(321002, 321000, '广陵区', 321002),
(321003, 321000, '邗江区', 321003),
(321011, 321000, '维扬区', 321011),
(321023, 321000, '宝应县', 321023),
(321081, 321000, '仪征市', 321081),
(321084, 321000, '高邮市', 321084),
(321088, 321000, '江都市', 321088),
(321100, 320000, '镇江市', 321100),
(321101, 321100, '市区', 321101),
(321102, 321100, '京口区', 321102),
(321111, 321100, '润州区', 321111),
(321112, 321100, '丹徒区', 321112),
(321181, 321100, '丹阳市', 321181),
(321182, 321100, '扬中市', 321182),
(321183, 321100, '句容市', 321183),
(321200, 320000, '泰州市', 321200),
(321201, 321200, '市辖区', 321201),
(321202, 321200, '海陵区', 321202),
(321203, 321200, '高港区', 321203),
(321281, 321200, '兴化市', 321281),
(321282, 321200, '靖江市', 321282),
(321283, 321200, '泰兴市', 321283),
(321284, 321200, '姜堰市', 321284),
(321300, 320000, '宿迁市', 321300),
(321301, 321300, '市辖区', 321301),
(321302, 321300, '宿城区', 321302),
(321311, 321300, '宿豫区', 321311),
(321322, 321300, '沭阳县', 321322),
(321323, 321300, '泗阳县', 321323),
(321324, 321300, '泗洪县', 321324),
(330000, 0, '浙江省', 330000),
(330100, 330000, '杭州市', 330100),
(330101, 330100, '市辖区', 330101),
(330102, 330100, '上城区', 330102),
(330103, 330100, '下城区', 330103),
(330104, 330100, '江干区', 330104),
(330105, 330100, '拱墅区', 330105),
(330106, 330100, '西湖区', 330106),
(330108, 330100, '滨江区', 330108),
(330109, 330100, '萧山区', 330109),
(330110, 330100, '余杭区', 330110),
(330122, 330100, '桐庐县', 330122),
(330127, 330100, '淳安县', 330127),
(330182, 330100, '建德市', 330182),
(330183, 330100, '富阳市', 330183),
(330185, 330100, '临安市', 330185),
(330200, 330000, '宁波市', 330200),
(330201, 330200, '市辖区', 330201),
(330203, 330200, '海曙区', 330203),
(330204, 330200, '江东区', 330204),
(330205, 330200, '江北区', 330205),
(330206, 330200, '北仑区', 330206),
(330211, 330200, '镇海区', 330211),
(330212, 330200, '鄞州区', 330212),
(330225, 330200, '象山县', 330225),
(330226, 330200, '宁海县', 330226),
(330281, 330200, '余姚市', 330281),
(330282, 330200, '慈溪市', 330282),
(330283, 330200, '奉化市', 330283),
(330300, 330000, '温州市', 330300),
(330301, 330300, '市辖区', 330301),
(330302, 330300, '鹿城区', 330302),
(330303, 330300, '龙湾区', 330303),
(330304, 330300, '瓯海区', 330304),
(330322, 330300, '洞头县', 330322),
(330324, 330300, '永嘉县', 330324),
(330326, 330300, '平阳县', 330326),
(330327, 330300, '苍南县', 330327),
(330328, 330300, '文成县', 330328),
(330329, 330300, '泰顺县', 330329),
(330381, 330300, '瑞安市', 330381),
(330382, 330300, '乐清市', 330382),
(330400, 330000, '嘉兴市', 330400),
(330401, 330400, '市辖区', 330401),
(330402, 330400, '南湖区', 330402),
(330411, 330400, '秀洲区', 330411),
(330421, 330400, '嘉善县', 330421),
(330424, 330400, '海盐县', 330424),
(330481, 330400, '海宁市', 330481),
(330482, 330400, '平湖市', 330482),
(330483, 330400, '桐乡市', 330483),
(330500, 330000, '湖州市', 330500),
(330501, 330500, '市辖区', 330501),
(330502, 330500, '吴兴区', 330502),
(330503, 330500, '南浔区', 330503),
(330521, 330500, '德清县', 330521),
(330522, 330500, '长兴县', 330522),
(330523, 330500, '安吉县', 330523),
(330600, 330000, '绍兴市', 330600),
(330601, 330600, '市辖区', 330601),
(330602, 330600, '越城区', 330602),
(330621, 330600, '绍兴县', 330621),
(330624, 330600, '新昌县', 330624),
(330681, 330600, '诸暨市', 330681),
(330682, 330600, '上虞市', 330682),
(330683, 330600, '嵊州市', 330683),
(330700, 330000, '金华市', 330700),
(330701, 330700, '市辖区', 330701),
(330702, 330700, '婺城区', 330702),
(330703, 330700, '金东区', 330703),
(330723, 330700, '武义县', 330723),
(330726, 330700, '浦江县', 330726),
(330727, 330700, '磐安县', 330727),
(330781, 330700, '兰溪市', 330781),
(330782, 330700, '义乌市', 330782),
(330783, 330700, '东阳市', 330783),
(330784, 330700, '永康市', 330784),
(330800, 330000, '衢州市', 330800),
(330801, 330800, '市辖区', 330801),
(330802, 330800, '柯城区', 330802),
(330803, 330800, '衢江区', 330803),
(330822, 330800, '常山县', 330822),
(330824, 330800, '开化县', 330824),
(330825, 330800, '龙游县', 330825),
(330881, 330800, '江山市', 330881),
(330900, 330000, '舟山市', 330900),
(330901, 330900, '市辖区', 330901),
(330902, 330900, '定海区', 330902),
(330903, 330900, '普陀区', 330903),
(330921, 330900, '岱山县', 330921),
(330922, 330900, '嵊泗县', 330922),
(331000, 330000, '台州市', 331000),
(331001, 331000, '市辖区', 331001),
(331002, 331000, '椒江区', 331002),
(331003, 331000, '黄岩区', 331003),
(331004, 331000, '路桥区', 331004),
(331021, 331000, '玉环县', 331021),
(331022, 331000, '三门县', 331022),
(331023, 331000, '天台县', 331023),
(331024, 331000, '仙居县', 331024),
(331081, 331000, '温岭市', 331081),
(331082, 331000, '临海市', 331082),
(331100, 330000, '丽水市', 331100),
(331101, 331100, '市辖区', 331101),
(331102, 331100, '莲都区', 331102),
(331121, 331100, '青田县', 331121),
(331122, 331100, '缙云县', 331122),
(331123, 331100, '遂昌县', 331123),
(331124, 331100, '松阳县', 331124),
(331125, 331100, '云和县', 331125),
(331126, 331100, '庆元县', 331126),
(331127, 331100, '景宁畲族自治县', 331127),
(331181, 331100, '龙泉市', 331181),
(340000, 0, '安徽省', 340000),
(340100, 340000, '合肥市', 340100),
(340101, 340100, '市辖区', 340101),
(340102, 340100, '瑶海区', 340102),
(340103, 340100, '庐阳区', 340103),
(340104, 340100, '蜀山区', 340104),
(340111, 340100, '包河区', 340111),
(340121, 340100, '长丰县', 340121),
(340122, 340100, '肥东县', 340122),
(340123, 340100, '肥西县', 340123),
(340200, 340000, '芜湖市', 340200),
(340201, 340200, '市辖区', 340201),
(340202, 340200, '镜湖区', 340202),
(340203, 340200, '弋江区', 340203),
(340207, 340200, '鸠江区', 340207),
(340208, 340200, '三山区', 340208),
(340221, 340200, '芜湖县', 340221),
(340222, 340200, '繁昌县', 340222),
(340223, 340200, '南陵县', 340223),
(340300, 340000, '蚌埠市', 340300),
(340301, 340300, '市辖区', 340301),
(340302, 340300, '龙子湖区', 340302),
(340303, 340300, '蚌山区', 340303),
(340304, 340300, '禹会区', 340304),
(340311, 340300, '淮上区', 340311),
(340321, 340300, '怀远县', 340321),
(340322, 340300, '五河县', 340322),
(340323, 340300, '固镇县', 340323),
(340400, 340000, '淮南市', 340400),
(340401, 340400, '市辖区', 340401),
(340402, 340400, '大通区', 340402),
(340403, 340400, '田家庵区', 340403),
(340404, 340400, '谢家集区', 340404),
(340405, 340400, '八公山区', 340405),
(340406, 340400, '潘集区', 340406),
(340421, 340400, '凤台县', 340421),
(340500, 340000, '马鞍山市', 340500),
(340501, 340500, '市辖区', 340501),
(340502, 340500, '金家庄区', 340502),
(340503, 340500, '花山区', 340503),
(340504, 340500, '雨山区', 340504),
(340521, 340500, '当涂县', 340521),
(340600, 340000, '淮北市', 340600),
(340601, 340600, '市辖区', 340601),
(340602, 340600, '杜集区', 340602),
(340603, 340600, '相山区', 340603),
(340604, 340600, '烈山区', 340604),
(340621, 340600, '濉溪县', 340621),
(340700, 340000, '铜陵市', 340700),
(340701, 340700, '市辖区', 340701),
(340702, 340700, '铜官山区', 340702),
(340703, 340700, '狮子山区', 340703),
(340711, 340700, '铜陵市郊区', 340711),
(340721, 340700, '铜陵县', 340721),
(340800, 340000, '安庆市', 340800),
(340801, 340800, '市辖区', 340801),
(340802, 340800, '迎江区', 340802),
(340803, 340800, '大观区', 340803),
(340811, 340800, '宜秀区', 340811),
(340822, 340800, '怀宁县', 340822),
(340823, 340800, '枞阳县', 340823),
(340824, 340800, '潜山县', 340824),
(340825, 340800, '太湖县', 340825),
(340826, 340800, '宿松县', 340826),
(340827, 340800, '望江县', 340827),
(340828, 340800, '岳西县', 340828),
(340881, 340800, '桐城市', 340881),
(341000, 340000, '黄山市', 341000),
(341001, 341000, '市辖区', 341001),
(341002, 341000, '屯溪区', 341002),
(341003, 341000, '黄山区', 341003),
(341004, 341000, '徽州区', 341004),
(341021, 341000, '歙县', 341021),
(341022, 341000, '休宁县', 341022),
(341023, 341000, '黟县', 341023),
(341024, 341000, '祁门县', 341024),
(341100, 340000, '滁州市', 341100),
(341101, 341100, '市辖区', 341101),
(341102, 341100, '琅琊区', 341102),
(341103, 341100, '南谯区', 341103),
(341122, 341100, '来安县', 341122),
(341124, 341100, '全椒县', 341124),
(341125, 341100, '定远县', 341125),
(341126, 341100, '凤阳县', 341126),
(341181, 341100, '天长市', 341181),
(341182, 341100, '明光市', 341182),
(341200, 340000, '阜阳市', 341200),
(341201, 341200, '市辖区', 341201),
(341202, 341200, '颍州区', 341202),
(341203, 341200, '颍东区', 341203),
(341204, 341200, '颍泉区', 341204),
(341221, 341200, '临泉县', 341221),
(341222, 341200, '太和县', 341222),
(341225, 341200, '阜南县', 341225),
(341226, 341200, '颍上县', 341226),
(341282, 341200, '界首市', 341282),
(341300, 340000, '宿州市', 341300),
(341301, 341300, '市辖区', 341301),
(341302, 341300, '墉桥区', 341302),
(341321, 341300, '砀山县', 341321),
(341322, 341300, '萧县', 341322),
(341323, 341300, '灵璧县', 341323),
(341324, 341300, '泗县', 341324),
(341400, 340000, '巢湖市', 341400),
(341401, 341400, '市辖区', 341401),
(341402, 341400, '居巢区', 341402),
(341421, 341400, '庐江县', 341421),
(341422, 341400, '无为县', 341422),
(341423, 341400, '含山县', 341423),
(341424, 341400, '和县', 341424),
(341500, 340000, '六安市', 341500),
(341501, 341500, '市辖区', 341501),
(341502, 341500, '金安区', 341502),
(341503, 341500, '裕安区', 341503),
(341521, 341500, '寿县', 341521),
(341522, 341500, '霍邱县', 341522),
(341523, 341500, '舒城县', 341523),
(341524, 341500, '金寨县', 341524),
(341525, 341500, '霍山县', 341525),
(341600, 340000, '亳州市', 341600),
(341601, 341600, '市辖区', 341601),
(341602, 341600, '谯城区', 341602),
(341621, 341600, '涡阳县', 341621),
(341622, 341600, '蒙城县', 341622),
(341623, 341600, '利辛县', 341623),
(341700, 340000, '池州市', 341700),
(341701, 341700, '市辖区', 341701),
(341702, 341700, '贵池区', 341702),
(341721, 341700, '东至县', 341721),
(341722, 341700, '石台县', 341722),
(341723, 341700, '青阳县', 341723),
(341800, 340000, '宣城市', 341800),
(341801, 341800, '市辖区', 341801),
(341802, 341800, '宣州区', 341802),
(341821, 341800, '郎溪县', 341821),
(341822, 341800, '广德县', 341822),
(341823, 341800, '泾县', 341823),
(341824, 341800, '绩溪县', 341824),
(341825, 341800, '旌德县', 341825),
(341881, 341800, '宁国市', 341881),
(350000, 0, '福建省', 350000),
(350100, 350000, '福州市', 350100),
(350101, 350100, '市辖区', 350101),
(350102, 350100, '鼓楼区', 350102),
(350103, 350100, '台江区', 350103),
(350104, 350100, '仓山区', 350104),
(350105, 350100, '马尾区', 350105),
(350111, 350100, '晋安区', 350111),
(350121, 350100, '闽侯县', 350121),
(350122, 350100, '连江县', 350122),
(350123, 350100, '罗源县', 350123),
(350124, 350100, '闽清县', 350124),
(350125, 350100, '永泰县', 350125),
(350128, 350100, '平潭县', 350128),
(350181, 350100, '福清市', 350181),
(350182, 350100, '长乐市', 350182),
(350200, 350000, '厦门市', 350200),
(350201, 350200, '市辖区', 350201),
(350203, 350200, '思明区', 350203),
(350205, 350200, '海沧区', 350205),
(350206, 350200, '湖里区', 350206),
(350211, 350200, '集美区', 350211),
(350212, 350200, '同安区', 350212),
(350213, 350200, '翔安区', 350213),
(350300, 350000, '莆田市', 350300),
(350301, 350300, '市辖区', 350301),
(350302, 350300, '城厢区', 350302),
(350303, 350300, '涵江区', 350303),
(350304, 350300, '荔城区', 350304),
(350305, 350300, '秀屿区', 350305),
(350322, 350300, '仙游县', 350322),
(350400, 350000, '三明市', 350400),
(350401, 350400, '市辖区', 350401),
(350402, 350400, '梅列区', 350402),
(350403, 350400, '三元区', 350403),
(350421, 350400, '明溪县', 350421),
(350423, 350400, '清流县', 350423),
(350424, 350400, '宁化县', 350424),
(350425, 350400, '大田县', 350425),
(350426, 350400, '尤溪县', 350426),
(350427, 350400, '沙县', 350427),
(350428, 350400, '将乐县', 350428),
(350429, 350400, '泰宁县', 350429),
(350430, 350400, '建宁县', 350430),
(350481, 350400, '永安市', 350481),
(350500, 350000, '泉州市', 350500),
(350501, 350500, '市辖区', 350501),
(350502, 350500, '鲤城区', 350502),
(350503, 350500, '丰泽区', 350503),
(350504, 350500, '洛江区', 350504),
(350505, 350500, '泉港区', 350505),
(350521, 350500, '惠安县', 350521),
(350524, 350500, '安溪县', 350524),
(350525, 350500, '永春县', 350525);
INSERT INTO `{pre}areas` VALUES
(350526, 350500, '德化县', 350526),
(350527, 350500, '金门县', 350527),
(350581, 350500, '石狮市', 350581),
(350582, 350500, '晋江市', 350582),
(350583, 350500, '南安市', 350583),
(350600, 350000, '漳州市', 350600),
(350601, 350600, '市辖区', 350601),
(350602, 350600, '芗城区', 350602),
(350603, 350600, '龙文区', 350603),
(350622, 350600, '云霄县', 350622),
(350623, 350600, '漳浦县', 350623),
(350624, 350600, '诏安县', 350624),
(350625, 350600, '长泰县', 350625),
(350626, 350600, '东山县', 350626),
(350627, 350600, '南靖县', 350627),
(350628, 350600, '平和县', 350628),
(350629, 350600, '华安县', 350629),
(350681, 350600, '龙海市', 350681),
(350700, 350000, '南平市', 350700),
(350701, 350700, '市辖区', 350701),
(350702, 350700, '延平区', 350702),
(350721, 350700, '顺昌县', 350721),
(350722, 350700, '浦城县', 350722),
(350723, 350700, '光泽县', 350723),
(350724, 350700, '松溪县', 350724),
(350725, 350700, '政和县', 350725),
(350781, 350700, '邵武市', 350781),
(350782, 350700, '武夷山市', 350782),
(350783, 350700, '建瓯市', 350783),
(350784, 350700, '建阳市', 350784),
(350800, 350000, '龙岩市', 350800),
(350801, 350800, '市辖区', 350801),
(350802, 350800, '新罗区', 350802),
(350821, 350800, '长汀县', 350821),
(350822, 350800, '永定县', 350822),
(350823, 350800, '上杭县', 350823),
(350824, 350800, '武平县', 350824),
(350825, 350800, '连城县', 350825),
(350881, 350800, '漳平市', 350881),
(350900, 350000, '宁德市　', 350900),
(350901, 350900, '市辖区', 350901),
(350902, 350900, '蕉城区', 350902),
(350921, 350900, '霞浦县', 350921),
(350922, 350900, '古田县', 350922),
(350923, 350900, '屏南县', 350923),
(350924, 350900, '寿宁县', 350924),
(350925, 350900, '周宁县', 350925),
(350926, 350900, '柘荣县', 350926),
(350981, 350900, '福安市', 350981),
(350982, 350900, '福鼎市', 350982),
(360000, 0, '江西省', 360000),
(360100, 360000, '南昌市', 360100),
(360101, 360100, '市辖区', 360101),
(360102, 360100, '东湖区', 360102),
(360103, 360100, '西湖区', 360103),
(360104, 360100, '青云谱区', 360104),
(360105, 360100, '湾里区', 360105),
(360111, 360100, '青山湖区', 360111),
(360121, 360100, '南昌县', 360121),
(360122, 360100, '新建县', 360122),
(360123, 360100, '安义县', 360123),
(360124, 360100, '进贤县', 360124),
(360200, 360000, '景德镇市', 360200),
(360201, 360200, '市辖区', 360201),
(360202, 360200, '昌江区', 360202),
(360203, 360200, '珠山区', 360203),
(360222, 360200, '浮梁县', 360222),
(360281, 360200, '乐平市', 360281),
(360300, 360000, '萍乡市', 360300),
(360301, 360300, '市辖区', 360301),
(360302, 360300, '安源区', 360302),
(360313, 360300, '湘东区', 360313),
(360321, 360300, '莲花县', 360321),
(360322, 360300, '上栗县', 360322),
(360323, 360300, '芦溪县', 360323),
(360400, 360000, '九江市', 360400),
(360401, 360400, '市辖区', 360401),
(360402, 360400, '庐山区', 360402),
(360403, 360400, '浔阳区', 360403),
(360421, 360400, '九江县', 360421),
(360423, 360400, '武宁县', 360423),
(360424, 360400, '修水县', 360424),
(360425, 360400, '永修县', 360425),
(360426, 360400, '德安县', 360426),
(360427, 360400, '星子县', 360427),
(360428, 360400, '都昌县', 360428),
(360429, 360400, '湖口县', 360429),
(360430, 360400, '彭泽县', 360430),
(360481, 360400, '瑞昌市', 360481),
(360500, 360000, '新余市', 360500),
(360501, 360500, '市辖区', 360501),
(360502, 360500, '渝水区', 360502),
(360521, 360500, '分宜县', 360521),
(360600, 360000, '鹰潭市', 360600),
(360601, 360600, '市辖区', 360601),
(360602, 360600, '月湖区', 360602),
(360622, 360600, '余江县', 360622),
(360681, 360600, '贵溪市', 360681),
(360700, 360000, '赣州市', 360700),
(360701, 360700, '市辖区', 360701),
(360702, 360700, '章贡区', 360702),
(360721, 360700, '赣县', 360721),
(360722, 360700, '信丰县', 360722),
(360723, 360700, '大余县', 360723),
(360724, 360700, '上犹县', 360724),
(360725, 360700, '崇义县', 360725),
(360726, 360700, '安远县', 360726),
(360727, 360700, '龙南县', 360727),
(360728, 360700, '定南县', 360728),
(360729, 360700, '全南县', 360729),
(360730, 360700, '宁都县', 360730),
(360731, 360700, '于都县', 360731),
(360732, 360700, '兴国县', 360732),
(360733, 360700, '会昌县', 360733),
(360734, 360700, '寻乌县', 360734),
(360735, 360700, '石城县', 360735),
(360781, 360700, '瑞金市', 360781),
(360782, 360700, '南康市', 360782),
(360800, 360000, '吉安市', 360800),
(360801, 360800, '市辖区', 360801),
(360802, 360800, '吉州区', 360802),
(360803, 360800, '青原区', 360803),
(360821, 360800, '吉安县', 360821),
(360822, 360800, '吉水县', 360822),
(360823, 360800, '峡江县', 360823),
(360824, 360800, '新干县', 360824),
(360825, 360800, '永丰县', 360825),
(360826, 360800, '泰和县', 360826),
(360827, 360800, '遂川县', 360827),
(360828, 360800, '万安县', 360828),
(360829, 360800, '安福县', 360829),
(360830, 360800, '永新县', 360830),
(360881, 360800, '井冈山市', 360881),
(360900, 360000, '宜春市', 360900),
(360901, 360900, '市辖区', 360901),
(360902, 360900, '袁州区', 360902),
(360921, 360900, '奉新县', 360921),
(360922, 360900, '万载县', 360922),
(360923, 360900, '上高县', 360923),
(360924, 360900, '宜丰县', 360924),
(360925, 360900, '靖安县', 360925),
(360926, 360900, '铜鼓县', 360926),
(360981, 360900, '丰城市', 360981),
(360982, 360900, '樟树市', 360982),
(360983, 360900, '高安市', 360983),
(361000, 360000, '抚州市', 361000),
(361001, 361000, '市辖区', 361001),
(361002, 361000, '临川区', 361002),
(361021, 361000, '南城县', 361021),
(361022, 361000, '黎川县', 361022),
(361023, 361000, '南丰县', 361023),
(361024, 361000, '崇仁县', 361024),
(361025, 361000, '乐安县', 361025),
(361026, 361000, '宜黄县', 361026),
(361027, 361000, '金溪县', 361027),
(361028, 361000, '资溪县', 361028),
(361029, 361000, '东乡县', 361029),
(361030, 361000, '广昌县', 361030),
(361100, 360000, '上饶市', 361100),
(361101, 361100, '市辖区', 361101),
(361102, 361100, '信州区', 361102),
(361121, 361100, '上饶县', 361121),
(361122, 361100, '广丰县', 361122),
(361123, 361100, '玉山县', 361123),
(361124, 361100, '铅山县', 361124),
(361125, 361100, '横峰县', 361125),
(361126, 361100, '弋阳县', 361126),
(361127, 361100, '余干县', 361127),
(361128, 361100, '鄱阳县', 361128),
(361129, 361100, '万年县', 361129),
(361130, 361100, '婺源县', 361130),
(361181, 361100, '德兴市', 361181),
(370000, 0, '山东省', 370000),
(370100, 370000, '济南市', 370100),
(370101, 370100, '市辖区', 370101),
(370102, 370100, '历下区', 370102),
(370103, 370100, '市中区', 370103),
(370104, 370100, '槐荫区', 370104),
(370105, 370100, '天桥区', 370105),
(370112, 370100, '历城区', 370112),
(370113, 370100, '长清区', 370113),
(370124, 370100, '平阴县', 370124),
(370125, 370100, '济阳县', 370125),
(370126, 370100, '商河县', 370126),
(370181, 370100, '章丘市', 370181),
(370200, 370000, '青岛市', 370200),
(370201, 370200, '市辖区', 370201),
(370202, 370200, '市南区', 370202),
(370203, 370200, '市北区', 370203),
(370205, 370200, '四方区', 370205),
(370211, 370200, '黄岛区', 370211),
(370212, 370200, '崂山区', 370212),
(370213, 370200, '李沧区', 370213),
(370214, 370200, '城阳区', 370214),
(370281, 370200, '胶州市', 370281),
(370282, 370200, '即墨市', 370282),
(370283, 370200, '平度市', 370283),
(370284, 370200, '胶南市', 370284),
(370285, 370200, '莱西市', 370285),
(370300, 370000, '淄博市', 370300),
(370301, 370300, '市辖区', 370301),
(370302, 370300, '淄川区', 370302),
(370303, 370300, '张店区', 370303),
(370304, 370300, '博山区', 370304),
(370305, 370300, '临淄区', 370305),
(370306, 370300, '周村区', 370306),
(370321, 370300, '桓台县', 370321),
(370322, 370300, '高青县', 370322),
(370323, 370300, '沂源县', 370323),
(370400, 370000, '枣庄市', 370400),
(370401, 370400, '市辖区', 370401),
(370402, 370400, '市中区', 370402),
(370403, 370400, '薛城区', 370403),
(370404, 370400, '峄城区', 370404),
(370405, 370400, '台儿庄区', 370405),
(370406, 370400, '山亭区', 370406),
(370481, 370400, '滕州市', 370481),
(370500, 370000, '东营市', 370500),
(370501, 370500, '市辖区', 370501),
(370502, 370500, '东营区', 370502),
(370503, 370500, '河口区', 370503),
(370521, 370500, '垦利县', 370521),
(370522, 370500, '利津县', 370522),
(370523, 370500, '广饶县', 370523),
(370600, 370000, '烟台市', 370600),
(370601, 370600, '市辖区', 370601),
(370602, 370600, '芝罘区', 370602),
(370611, 370600, '福山区', 370611),
(370612, 370600, '牟平区', 370612),
(370613, 370600, '莱山区', 370613),
(370634, 370600, '长岛县', 370634),
(370681, 370600, '龙口市', 370681),
(370682, 370600, '莱阳市', 370682),
(370683, 370600, '莱州市', 370683),
(370684, 370600, '蓬莱市', 370684),
(370685, 370600, '招远市', 370685),
(370686, 370600, '栖霞市', 370686),
(370687, 370600, '海阳市', 370687),
(370700, 370000, '潍坊市', 370700),
(370701, 370700, '市辖区', 370701),
(370702, 370700, '潍城区', 370702),
(370703, 370700, '寒亭区', 370703),
(370704, 370700, '坊子区', 370704),
(370705, 370700, '奎文区', 370705),
(370724, 370700, '临朐县', 370724),
(370725, 370700, '昌乐县', 370725),
(370781, 370700, '青州市', 370781),
(370782, 370700, '诸城市', 370782),
(370783, 370700, '寿光市', 370783),
(370784, 370700, '安丘市', 370784),
(370785, 370700, '高密市', 370785),
(370786, 370700, '昌邑市', 370786),
(370800, 370000, '济宁市', 370800),
(370801, 370800, '市辖区', 370801),
(370802, 370800, '市中区', 370802),
(370811, 370800, '任城区', 370811),
(370826, 370800, '"微山县', 370826),
(370827, 370800, '鱼台县', 370827),
(370828, 370800, '金乡县', 370828),
(370829, 370800, '嘉祥县', 370829),
(370830, 370800, '汶上县', 370830),
(370831, 370800, '泗水县', 370831),
(370832, 370800, '梁山县', 370832),
(370881, 370800, '曲阜市', 370881),
(370882, 370800, '兖州市', 370882),
(370883, 370800, '邹城市', 370883),
(370900, 370000, '泰安市', 370900),
(370901, 370900, '市辖区', 370901),
(370902, 370900, '泰山区', 370902),
(370903, 370900, '岱岳区', 370903),
(370921, 370900, '宁阳县', 370921),
(370923, 370900, '东平县', 370923),
(370982, 370900, '新泰市', 370982),
(370983, 370900, '肥城市', 370983),
(371000, 370000, '威海市', 371000),
(371001, 371000, '市辖区', 371001),
(371002, 371000, '环翠区', 371002),
(371081, 371000, '文登市', 371081),
(371082, 371000, '荣成市', 371082),
(371083, 371000, '乳山市', 371083),
(371100, 370000, '日照市', 371100),
(371101, 371100, '市辖区', 371101),
(371102, 371100, '东港区', 371102),
(371103, 371100, '岚山区', 371103),
(371121, 371100, '五莲县', 371121),
(371122, 371100, '莒县', 371122),
(371200, 370000, '莱芜市', 371200),
(371201, 371200, '市辖区', 371201),
(371202, 371200, '莱城区', 371202),
(371203, 371200, '钢城区', 371203),
(371300, 370000, '临沂市', 371300),
(371301, 371300, '临沂市辖区', 371301),
(371302, 371300, '兰山区', 371302),
(371311, 371300, '罗庄区', 371311),
(371312, 371300, '河东区', 371312),
(371321, 371300, '沂南县', 371321),
(371322, 371300, '郯城县', 371322),
(371323, 371300, '沂水县', 371323),
(371324, 371300, '苍山县', 371324),
(371325, 371300, '费县', 371325),
(371326, 371300, '平邑县', 371326),
(371327, 371300, '莒南县', 371327),
(371328, 371300, '蒙阴县', 371328),
(371329, 371300, '临沭县', 371329),
(371400, 370000, '德州市', 371400),
(371401, 371400, '市辖区', 371401),
(371402, 371400, '德城区', 371402),
(371421, 371400, '陵县', 371421),
(371422, 371400, '宁津县', 371422),
(371423, 371400, '庆云县', 371423),
(371424, 371400, '临邑县', 371424),
(371425, 371400, '齐河县', 371425),
(371426, 371400, '平原县', 371426),
(371427, 371400, '夏津县', 371427),
(371428, 371400, '武城县', 371428),
(371481, 371400, '乐陵市', 371481),
(371482, 371400, '禹城市', 371482),
(371500, 370000, '聊城市', 371500),
(371501, 371500, '市辖区', 371501),
(371502, 371500, '东昌府区', 371502),
(371521, 371500, '阳谷县', 371521),
(371522, 371500, '莘县', 371522),
(371523, 371500, '茌平县', 371523),
(371524, 371500, '东阿县', 371524),
(371525, 371500, '冠县', 371525),
(371526, 371500, '高唐县', 371526),
(371581, 371500, '临清市', 371581),
(371600, 370000, '滨州市', 371600),
(371601, 371600, '市辖区', 371601),
(371602, 371600, '滨城区', 371602),
(371621, 371600, '惠民县', 371621),
(371622, 371600, '阳信县', 371622),
(371623, 371600, '无棣县', 371623),
(371624, 371600, '沾化县', 371624),
(371625, 371600, '博兴县', 371625),
(371626, 371600, '邹平县', 371626),
(371700, 370000, '菏泽市', 371700),
(371701, 371700, '市辖区', 371701),
(371702, 371700, '牡丹区', 371702),
(371721, 371700, '曹县', 371721),
(371722, 371700, '单县', 371722),
(371723, 371700, '成武县', 371723),
(371724, 371700, '巨野县', 371724),
(371725, 371700, '郓城县', 371725),
(371726, 371700, '鄄城县', 371726),
(371727, 371700, '定陶县', 371727),
(371728, 371700, '东明县', 371728),
(410000, 0, '河南省', 410000),
(410100, 410000, '郑州市', 410100),
(410101, 410100, '市辖区', 410101),
(410102, 410100, '中原区', 410102),
(410103, 410100, '二七区', 410103),
(410104, 410100, '管城回族区', 410104),
(410105, 410100, '金水区', 410105),
(410106, 410100, '上街区', 410106),
(410108, 410100, '惠济区', 410108),
(410122, 410100, '中牟县', 410122),
(410181, 410100, '巩义市', 410181),
(410182, 410100, '荥阳市', 410182),
(410183, 410100, '新密市', 410183),
(410184, 410100, '新郑市', 410184),
(410185, 410100, '登封市', 410185),
(410200, 410000, '开封市', 410200),
(410201, 410200, '市辖区', 410201),
(410202, 410200, '龙亭区', 410202),
(410203, 410200, '顺河区', 410203),
(410204, 410200, '鼓楼区', 410204),
(410205, 410200, '禹王台区', 410205),
(410211, 410200, '金明区', 410211),
(410221, 410200, '杞县', 410221),
(410222, 410200, '通许县', 410222),
(410223, 410200, '尉氏县', 410223),
(410224, 410200, '开封县', 410224),
(410225, 410200, '兰考县', 410225),
(410300, 410000, '洛阳市', 410300),
(410301, 410300, '市辖区', 410301),
(410302, 410300, '老城区', 410302),
(410303, 410300, '西工区', 410303),
(410304, 410300, '廛河回族区', 410304),
(410305, 410300, '涧西区', 410305),
(410306, 410300, '吉利区', 410306),
(410307, 410300, '洛龙区', 410307),
(410322, 410300, '孟津县', 410322),
(410323, 410300, '新安县', 410323),
(410324, 410300, '栾川县', 410324),
(410325, 410300, '嵩县', 410325),
(410326, 410300, '汝阳县', 410326),
(410327, 410300, '宜阳县', 410327),
(410328, 410300, '洛宁县', 410328),
(410329, 410300, '伊川县', 410329),
(410381, 410300, '偃师市', 410381),
(410400, 410000, '平顶山市', 410400),
(410401, 410400, '市辖区', 410401),
(410402, 410400, '新华区', 410402),
(410403, 410400, '卫东区', 410403),
(410404, 410400, '石龙区', 410404),
(410411, 410400, '湛河区', 410411),
(410421, 410400, '宝丰县', 410421),
(410422, 410400, '叶  县', 410422),
(410423, 410400, '鲁山县', 410423),
(410425, 410400, '郏  县', 410425),
(410481, 410400, '舞钢市', 410481),
(410482, 410400, '汝州市', 410482),
(410500, 410000, '安阳市', 410500),
(410501, 410500, '市辖区', 410501),
(410502, 410500, '文峰区', 410502),
(410503, 410500, '北关区', 410503),
(410505, 410500, '殷都区', 410505),
(410506, 410500, '龙安区', 410506),
(410522, 410500, '安阳县', 410522),
(410523, 410500, '汤阴县', 410523),
(410526, 410500, '滑县', 410526),
(410527, 410500, '内黄县', 410527),
(410581, 410500, '林州市', 410581),
(410600, 410000, '鹤壁市', 410600),
(410601, 410600, '市辖区', 410601),
(410602, 410600, '鹤山区', 410602),
(410603, 410600, '山城区', 410603),
(410611, 410600, '淇滨区', 410611),
(410621, 410600, '浚县', 410621),
(410622, 410600, '淇县', 410622),
(410700, 410000, '新乡市', 410700),
(410701, 410700, '市辖区', 410701),
(410702, 410700, '红旗区', 410702),
(410703, 410700, '卫滨区', 410703),
(410704, 410700, '凤泉区', 410704),
(410711, 410700, '牧野区', 410711),
(410721, 410700, '新乡县', 410721),
(410724, 410700, '获嘉县', 410724),
(410725, 410700, '原阳县', 410725),
(410726, 410700, '延津县', 410726),
(410727, 410700, '封丘县', 410727),
(410728, 410700, '长垣县', 410728),
(410781, 410700, '卫辉市', 410781),
(410782, 410700, '辉县市', 410782),
(410800, 410000, '焦作市', 410800),
(410801, 410800, '市辖区', 410801),
(410802, 410800, '解放区', 410802),
(410803, 410800, '中站区', 410803),
(410804, 410800, '马村区', 410804),
(410811, 410800, '山阳区', 410811),
(410821, 410800, '修武县', 410821),
(410822, 410800, '博爱县', 410822),
(410823, 410800, '武陟县', 410823),
(410825, 410800, '温县', 410825),
(410881, 410800, '济源市', 410881),
(410882, 410800, '沁阳市', 410882),
(410883, 410800, '孟州市', 410883),
(410900, 410000, '濮阳市', 410900),
(410901, 410900, '市辖区', 410901),
(410902, 410900, '华龙区', 410902),
(410922, 410900, '清丰县', 410922),
(410923, 410900, '南乐县', 410923),
(410926, 410900, '范县', 410926),
(410927, 410900, '台前县', 410927),
(410928, 410900, '濮阳县', 410928),
(411000, 410000, '许昌市', 411000),
(411001, 411000, '市辖区', 411001),
(411002, 411000, '魏都区', 411002),
(411023, 411000, '许昌县', 411023),
(411024, 411000, '鄢陵县', 411024),
(411025, 411000, '襄城县', 411025),
(411081, 411000, '禹州市', 411081),
(411082, 411000, '长葛市', 411082),
(411100, 410000, '漯河市', 411100),
(411101, 411100, '市辖区', 411101),
(411102, 411100, '源汇区', 411102),
(411103, 411100, '郾城区', 411103),
(411104, 411100, '召陵区', 411104),
(411121, 411100, '舞阳县', 411121),
(411122, 411100, '临颖县', 411122),
(411200, 410000, '三门峡市', 411200),
(411201, 411200, '市辖区', 411201),
(411202, 411200, '湖滨区', 411202),
(411221, 411200, '渑池县', 411221),
(411222, 411200, '陕县', 411222),
(411224, 411200, '卢氏县', 411224),
(411281, 411200, '义马市', 411281),
(411282, 411200, '灵宝市', 411282),
(411300, 410000, '南阳市', 411300),
(411301, 411300, '市辖区', 411301),
(411302, 411300, '宛城区', 411302),
(411303, 411300, '卧龙区', 411303),
(411321, 411300, '南召县', 411321),
(411322, 411300, '方城县', 411322),
(411323, 411300, '西峡县', 411323),
(411324, 411300, '镇平县', 411324),
(411325, 411300, '内乡县', 411325),
(411326, 411300, '淅川县', 411326),
(411327, 411300, '社旗县', 411327),
(411328, 411300, '唐河县', 411328),
(411329, 411300, '新野县', 411329),
(411330, 411300, '桐柏县', 411330),
(411381, 411300, '邓州市', 411381),
(411400, 410000, '商丘市', 411400),
(411401, 411400, '市辖区', 411401),
(411402, 411400, '梁园区', 411402),
(411403, 411400, '睢阳区', 411403),
(411421, 411400, '民权县', 411421),
(411422, 411400, '睢县', 411422),
(411423, 411400, '宁陵县', 411423),
(411424, 411400, '柘城县', 411424),
(411425, 411400, '虞城县', 411425),
(411426, 411400, '夏邑县', 411426),
(411481, 411400, '永城市', 411481),
(411500, 410000, '信阳市', 411500),
(411501, 411500, '市辖区', 411501),
(411502, 411500, '浉河区', 411502),
(411503, 411500, '平桥区', 411503),
(411521, 411500, '罗山县', 411521),
(411522, 411500, '光山县', 411522),
(411523, 411500, '新县', 411523),
(411524, 411500, '商城县', 411524),
(411525, 411500, '固始县', 411525),
(411526, 411500, '潢川县', 411526),
(411527, 411500, '淮滨县', 411527),
(411528, 411500, '息县', 411528),
(411600, 410000, '周口市', 411600),
(411601, 411600, '市辖区', 411601),
(411602, 411600, '川汇区', 411602),
(411621, 411600, '扶沟县', 411621),
(411622, 411600, '西华县', 411622),
(411623, 411600, '商水县', 411623),
(411624, 411600, '沈丘县', 411624),
(411625, 411600, '郸城县', 411625),
(411626, 411600, '淮阳县', 411626),
(411627, 411600, '太康县', 411627),
(411628, 411600, '鹿邑县', 411628),
(411681, 411600, '项城市', 411681),
(411700, 410000, '驻马店市', 411700),
(411701, 411700, '市辖区', 411701),
(411702, 411700, '驿城区', 411702),
(411721, 411700, '西平县', 411721),
(411722, 411700, '上蔡县', 411722),
(411723, 411700, '平舆县', 411723),
(411724, 411700, '正阳县', 411724),
(411725, 411700, '确山县', 411725),
(411726, 411700, '泌阳县', 411726),
(411727, 411700, '汝南县', 411727),
(411728, 411700, '遂平县', 411728),
(411729, 411700, '新蔡县', 411729),
(420000, 0, '湖北省', 420000),
(420100, 420000, '武汉市', 420100),
(420101, 420100, '市辖区', 420101),
(420102, 420100, '江岸区', 420102),
(420103, 420100, '江汉区', 420103),
(420104, 420100, '硚口区', 420104),
(420105, 420100, '汉阳区', 420105),
(420106, 420100, '武昌区', 420106),
(420107, 420100, '青山区', 420107),
(420111, 420100, '洪山区', 420111),
(420112, 420100, '东西湖区', 420112),
(420113, 420100, '汉南区', 420113),
(420114, 420100, '蔡甸区', 420114),
(420115, 420100, '江夏区', 420115),
(420116, 420100, '黄陂区', 420116),
(420117, 420100, '武汉市新洲区', 420117),
(420200, 420000, '黄石市', 420200),
(420201, 420200, '市辖区', 420201),
(420202, 420200, '黄石港区', 420202),
(420203, 420200, '西塞山区', 420203),
(420204, 420200, '下陆区', 420204),
(420205, 420200, '铁山区', 420205),
(420222, 420200, '阳新县', 420222),
(420281, 420200, '大冶市', 420281),
(420300, 420000, '十堰市', 420300),
(420301, 420300, '市辖区', 420301),
(420302, 420300, '茅箭区', 420302),
(420303, 420300, '张湾区', 420303),
(420321, 420300, '郧县', 420321),
(420322, 420300, '郧西县', 420322),
(420323, 420300, '竹山县', 420323),
(420324, 420300, '竹溪县', 420324),
(420325, 420300, '房县', 420325),
(420381, 420300, '丹江口市', 420381),
(420500, 420000, '宜昌市', 420500),
(420501, 420500, '市辖区', 420501),
(420502, 420500, '西陵区', 420502),
(420503, 420500, '伍家岗区', 420503),
(420504, 420500, '点军区', 420504),
(420505, 420500, '猇亭区', 420505),
(420506, 420500, '夷陵区', 420506),
(420525, 420500, '远安县', 420525),
(420526, 420500, '兴山县', 420526),
(420527, 420500, '秭归县', 420527),
(420528, 420500, '长阳土家族自治县', 420528),
(420529, 420500, '五峰土家族自治县', 420529),
(420581, 420500, '宜都市', 420581),
(420582, 420500, '当阳市', 420582),
(420583, 420500, '枝江市', 420583),
(420600, 420000, '襄樊市', 420600),
(420601, 420600, '市辖区', 420601),
(420602, 420600, '襄城区', 420602),
(420606, 420600, '樊城区', 420606),
(420607, 420600, '襄阳区', 420607),
(420624, 420600, '南漳县', 420624),
(420625, 420600, '谷城县', 420625),
(420626, 420600, '保康县', 420626),
(420682, 420600, '老河口市', 420682),
(420683, 420600, '枣阳市', 420683),
(420684, 420600, '宜城市', 420684),
(420700, 420000, '鄂州市', 420700),
(420701, 420700, '市辖区', 420701),
(420702, 420700, '粱子湖区', 420702),
(420703, 420700, '华容区', 420703),
(420704, 420700, '鄂城区', 420704),
(420800, 420000, '荆门市', 420800),
(420801, 420800, '市辖区', 420801),
(420802, 420800, '东宝区', 420802),
(420804, 420800, '掇刀区', 420804),
(420821, 420800, '京山县', 420821),
(420822, 420800, '沙洋县', 420822),
(420881, 420800, '钟祥市', 420881),
(420900, 420000, '孝感市', 420900),
(420901, 420900, '市辖区', 420901),
(420902, 420900, '孝南区', 420902),
(420921, 420900, '孝昌县', 420921),
(420922, 420900, '大悟县', 420922),
(420923, 420900, '云梦县', 420923),
(420981, 420900, '应城市', 420981),
(420982, 420900, '安陆市', 420982),
(420984, 420900, '汉川市', 420984),
(421000, 420000, '荆州市', 421000),
(421001, 421000, '市辖区', 421001),
(421002, 421000, '沙市区', 421002),
(421003, 421000, '荆州区', 421003),
(421022, 421000, '公安县', 421022),
(421023, 421000, '监利县', 421023),
(421024, 421000, '江陵县', 421024),
(421081, 421000, '石首市', 421081),
(421083, 421000, '洪湖市', 421083),
(421087, 421000, '松滋市', 421087),
(421100, 420000, '黄冈市', 421100),
(421101, 421100, '市辖区', 421101),
(421102, 421100, '黄州区', 421102),
(421121, 421100, '团风县', 421121),
(421122, 421100, '红安县', 421122),
(421123, 421100, '罗田县', 421123),
(421124, 421100, '英山县', 421124),
(421125, 421100, '浠水县', 421125),
(421126, 421100, '蕲春县', 421126),
(421127, 421100, '黄梅县', 421127),
(421181, 421100, '麻城市', 421181),
(421182, 421100, '武穴市', 421182),
(421200, 420000, '咸宁市', 421200),
(421201, 421200, '市辖区', 421201),
(421202, 421200, '咸安区', 421202),
(421221, 421200, '嘉鱼县', 421221),
(421222, 421200, '通城县', 421222),
(421223, 421200, '崇阳县', 421223),
(421224, 421200, '通山县', 421224),
(421281, 421200, '赤壁市', 421281),
(421300, 420000, '随州市', 421300),
(421301, 421300, '市辖区', 421301),
(421302, 421300, '曾都区', 421302),
(421381, 421300, '广水市', 421381),
(422800, 420000, '恩施州', 422800),
(422801, 422800, '恩施市', 422801),
(422802, 422800, '利川市', 422802),
(422822, 422800, '建始县', 422822),
(422823, 422800, '巴东县', 422823),
(422825, 422800, '宣恩县', 422825),
(422826, 422800, '咸丰县', 422826),
(422827, 422800, '来凤县', 422827),
(422828, 422800, '鹤峰县', 422828),
(429000, 420000, '省直辖行政单位', 429000),
(429004, 429000, '仙桃市', 429004),
(429005, 429000, '潜江市', 429005),
(429006, 429000, '天门市', 429006),
(429021, 429000, '神农架林区', 429021),
(430000, 0, '湖南省', 430000),
(430100, 430000, '长沙市', 430100),
(430101, 430100, '市辖区', 430101),
(430102, 430100, '芙蓉区', 430102),
(430103, 430100, '天心区', 430103),
(430104, 430100, '岳麓区', 430104),
(430105, 430100, '开福区', 430105),
(430111, 430100, '雨花区', 430111),
(430121, 430100, '长沙县', 430121),
(430122, 430100, '望城县', 430122),
(430124, 430100, '宁乡县', 430124),
(430181, 430100, '浏阳市', 430181),
(430200, 430000, '株洲市', 430200),
(430201, 430200, '市辖区', 430201),
(430202, 430200, '荷塘区', 430202),
(430203, 430200, '芦淞区', 430203),
(430204, 430200, '石峰区', 430204),
(430211, 430200, '天元区', 430211),
(430221, 430200, '株洲县', 430221),
(430223, 430200, '攸县', 430223),
(430224, 430200, '茶陵县', 430224),
(430225, 430200, '炎陵县', 430225),
(430281, 430200, '醴陵市', 430281),
(430300, 430000, '湘潭市', 430300),
(430301, 430300, '市辖区', 430301),
(430302, 430300, '雨湖区', 430302),
(430304, 430300, '岳塘区', 430304),
(430321, 430300, '湘潭县', 430321),
(430381, 430300, '湘乡市', 430381),
(430382, 430300, '韶山市', 430382),
(430400, 430000, '衡阳市', 430400),
(430401, 430400, '市辖区', 430401),
(430405, 430400, '珠晖区', 430405),
(430406, 430400, '雁峰区', 430406),
(430407, 430400, '石鼓区', 430407),
(430408, 430400, '蒸湘区', 430408),
(430412, 430400, '南岳区', 430412),
(430421, 430400, '衡阳县', 430421),
(430422, 430400, '衡南县', 430422),
(430423, 430400, '衡山县', 430423),
(430424, 430400, '衡东县', 430424),
(430426, 430400, '祁东县', 430426),
(430481, 430400, '耒阳市', 430481),
(430482, 430400, '常宁市', 430482),
(430500, 430000, '邵阳市', 430500),
(430501, 430500, '市辖区', 430501),
(430502, 430500, '双清区', 430502),
(430503, 430500, '大祥区', 430503),
(430511, 430500, '北塔区', 430511),
(430521, 430500, '邵东县', 430521),
(430522, 430500, '新邵县', 430522),
(430523, 430500, '邵阳县', 430523),
(430524, 430500, '隆回县', 430524),
(430525, 430500, '洞口县', 430525),
(430527, 430500, '绥宁县', 430527),
(430528, 430500, '新宁县', 430528),
(430529, 430500, '城步苗族自治县', 430529),
(430581, 430500, '武冈市', 430581),
(430600, 430000, '岳阳市', 430600),
(430601, 430600, '市辖区', 430601),
(430602, 430600, '岳阳楼区', 430602),
(430603, 430600, '云溪区', 430603),
(430611, 430600, '君山区', 430611),
(430621, 430600, '岳阳县', 430621),
(430623, 430600, '华容县', 430623),
(430624, 430600, '湘阴县', 430624),
(430626, 430600, '平江县', 430626),
(430681, 430600, '汩罗市', 430681),
(430682, 430600, '临湘市', 430682),
(430700, 430000, '常德市', 430700),
(430701, 430700, '市辖区', 430701),
(430702, 430700, '武陵区', 430702),
(430703, 430700, '鼎城区', 430703),
(430721, 430700, '安乡县', 430721),
(430722, 430700, '汉寿县', 430722),
(430723, 430700, '澧县', 430723),
(430724, 430700, '临澧县', 430724),
(430725, 430700, '桃源县', 430725),
(430726, 430700, '石门县', 430726),
(430781, 430700, '津市市', 430781),
(430800, 430000, '张家界市', 430800),
(430801, 430800, '市辖区', 430801),
(430802, 430800, '永定区', 430802),
(430811, 430800, '武陵源区', 430811),
(430821, 430800, '慈利县', 430821),
(430822, 430800, '桑植县', 430822),
(430900, 430000, '益阳市', 430900),
(430901, 430900, '市辖区', 430901),
(430902, 430900, '资阳区', 430902),
(430903, 430900, '赫山区', 430903),
(430921, 430900, '南县', 430921),
(430922, 430900, '桃江县', 430922),
(430923, 430900, '安化县', 430923),
(430981, 430900, '沅江市', 430981),
(431000, 430000, '郴州市', 431000),
(431001, 431000, '市辖区', 431001),
(431002, 431000, '北湖区', 431002),
(431003, 431000, '苏仙区', 431003),
(431021, 431000, '桂阳县', 431021),
(431022, 431000, '宜章县', 431022),
(431023, 431000, '永兴县', 431023),
(431024, 431000, '嘉禾县', 431024),
(431025, 431000, '临武县', 431025),
(431026, 431000, '汝城县', 431026),
(431027, 431000, '桂东县', 431027),
(431028, 431000, '安仁县', 431028),
(431081, 431000, '资兴市', 431081),
(431100, 430000, '永州市', 431100),
(431101, 431100, '市辖区', 431101),
(431102, 431100, '零陵区', 431102),
(431103, 431100, '冷水滩区', 431103),
(431121, 431100, '祁阳县', 431121),
(431122, 431100, '东安县', 431122),
(431123, 431100, '双牌县', 431123),
(431124, 431100, '道县', 431124),
(431125, 431100, '江永县', 431125),
(431126, 431100, '宁远县', 431126),
(431127, 431100, '蓝山县', 431127),
(431128, 431100, '新田县', 431128),
(431129, 431100, '江华县', 431129),
(431200, 430000, '怀化市', 431200),
(431201, 431200, '市辖区', 431201),
(431202, 431200, '鹤城区', 431202),
(431221, 431200, '中方县', 431221),
(431222, 431200, '沅陵县', 431222),
(431223, 431200, '辰溪县', 431223),
(431224, 431200, '溆浦县', 431224),
(431225, 431200, '会同县', 431225),
(431226, 431200, '麻阳苗族自治县', 431226),
(431227, 431200, '新晃侗族自治县', 431227),
(431228, 431200, '芷江侗族自治县', 431228),
(431229, 431200, '靖州苗族侗族县', 431229),
(431230, 431200, '通道侗族自治县', 431230),
(431281, 431200, '洪江市', 431281),
(431300, 430000, '娄底市', 431300),
(431301, 431300, '市辖区', 431301),
(431302, 431300, '娄星区', 431302),
(431321, 431300, '双峰县', 431321),
(431322, 431300, '新化县', 431322),
(431381, 431300, '冷水江市', 431381),
(431382, 431300, '涟源市', 431382),
(433100, 430000, '湘西土家族苗族自治州', 433100),
(433101, 433100, '吉首市', 433101),
(433122, 433100, '泸溪县', 433122),
(433123, 433100, '凤凰县', 433123),
(433124, 433100, '花垣县', 433124),
(433125, 433100, '保靖县', 433125),
(433126, 433100, '古丈县', 433126),
(433127, 433100, '永顺县', 433127),
(433130, 433100, '龙山县', 433130),
(440000, 0, '广东省', 440000),
(440100, 440000, '广州市', 440100),
(440101, 440100, '市辖区', 440101),
(440103, 440100, '荔湾区', 440103),
(440104, 440100, '越秀区', 440104),
(440105, 440100, '海珠区', 440105),
(440106, 440100, '天河区', 440106),
(440111, 440100, '白云区', 440111),
(440112, 440100, '黄埔区', 440112),
(440113, 440100, '番禺区', 440113),
(440114, 440100, '花都区', 440114),
(440115, 440100, '南沙区', 440115),
(440116, 440100, '萝岗区', 440116),
(440183, 440100, '增城市', 440183),
(440184, 440100, '从化市', 440184),
(440200, 440000, '韶关市', 440200),
(440201, 440200, '市辖区', 440201),
(440203, 440200, '武江区', 440203),
(440204, 440200, '浈江区', 440204),
(440205, 440200, '曲江区', 440205),
(440222, 440200, '始兴县', 440222),
(440224, 440200, '仁化县', 440224),
(440229, 440200, '翁源县', 440229),
(440232, 440200, '乳源瑶族自治县', 440232),
(440233, 440200, '新丰县', 440233),
(440281, 440200, '乐昌市', 440281),
(440282, 440200, '南雄市', 440282),
(440300, 440000, '深圳市', 440300),
(440301, 440300, '市辖区', 440301),
(440303, 440300, '罗湖区', 440303),
(440304, 440300, '福田区', 440304),
(440305, 440300, '南山区', 440305),
(440306, 440300, '宝安区', 440306),
(440307, 440300, '龙岗区', 440307),
(440308, 440300, '盐田区', 440308),
(440400, 440000, '珠海市', 440400),
(440401, 440400, '市辖区', 440401),
(440402, 440400, '香洲区', 440402),
(440403, 440400, '斗门区', 440403),
(440404, 440400, '金湾区', 440404),
(440500, 440000, '汕头市', 440500),
(440501, 440500, '市辖区', 440501),
(440507, 440500, '龙湖区', 440507),
(440511, 440500, '金平区', 440511),
(440512, 440500, '濠江区', 440512),
(440513, 440500, '潮阳区', 440513),
(440514, 440500, '潮南区', 440514),
(440515, 440500, '澄海区', 440515),
(440523, 440500, '南澳县', 440523),
(440600, 440000, '佛山市', 440600),
(440601, 440600, '市辖区', 440601),
(440604, 440600, '禅城区', 440604),
(440605, 440600, '南海区', 440605),
(440606, 440600, '顺德区', 440606),
(440607, 440600, '三水区', 440607),
(440608, 440600, '高明区', 440608),
(440700, 440000, '江门市', 440700),
(440701, 440700, '市辖区', 440701),
(440703, 440700, '蓬江区', 440703),
(440704, 440700, '江海区', 440704),
(440705, 440700, '新会区', 440705),
(440781, 440700, '台山市', 440781),
(440783, 440700, '开平市', 440783),
(440784, 440700, '鹤山市', 440784),
(440785, 440700, '恩平市', 440785),
(440800, 440000, '湛江市', 440800),
(440801, 440800, '市辖区', 440801),
(440802, 440800, '湛江市赤坎区', 440802),
(440803, 440800, '湛江市霞山区', 440803),
(440804, 440800, '湛江市坡头区', 440804),
(440811, 440800, '湛江市麻章区', 440811),
(440823, 440800, '遂溪县', 440823),
(440825, 440800, '徐闻县', 440825),
(440881, 440800, '廉江市', 440881),
(440882, 440800, '雷州市', 440882),
(440883, 440800, '吴川市', 440883),
(440900, 440000, '茂名市', 440900),
(440901, 440900, '市辖区', 440901),
(440902, 440900, '茂南区', 440902),
(440903, 440900, '茂港区', 440903),
(440923, 440900, '电白县', 440923),
(440981, 440900, '高州市', 440981),
(440982, 440900, '化州市', 440982),
(440983, 440900, '信宜市', 440983),
(441200, 440000, '肇庆市', 441200),
(441201, 441200, '市辖区', 441201),
(441202, 441200, '端州区', 441202),
(441203, 441200, '鼎湖区', 441203),
(441223, 441200, '广宁县', 441223),
(441224, 441200, '怀集县', 441224),
(441225, 441200, '封开县', 441225),
(441226, 441200, '德庆县', 441226),
(441283, 441200, '高要市', 441283),
(441284, 441200, '四会市', 441284),
(441300, 440000, '惠州市', 441300),
(441301, 441300, '市辖区', 441301),
(441302, 441300, '惠城区', 441302),
(441303, 441300, '惠阳区', 441303),
(441322, 441300, '博罗县', 441322),
(441323, 441300, '惠东县', 441323),
(441324, 441300, '龙门县', 441324),
(441400, 440000, '梅州市', 441400),
(441401, 441400, '市辖区', 441401),
(441402, 441400, '梅江区', 441402),
(441421, 441400, '梅县', 441421),
(441422, 441400, '大埔县', 441422),
(441423, 441400, '丰顺县', 441423),
(441424, 441400, '五华县', 441424),
(441426, 441400, '平远县', 441426),
(441427, 441400, '蕉岭县', 441427),
(441481, 441400, '兴宁市', 441481),
(441500, 440000, '汕尾市', 441500),
(441501, 441500, '市辖区', 441501),
(441502, 441500, '城区', 441502),
(441521, 441500, '海丰县', 441521),
(441523, 441500, '陆河县', 441523),
(441581, 441500, '陆丰市', 441581),
(441600, 440000, '河源市', 441600),
(441601, 441600, '市辖区', 441601),
(441602, 441600, '源城区', 441602),
(441621, 441600, '紫金县', 441621),
(441622, 441600, '龙川县', 441622),
(441623, 441600, '连平县', 441623),
(441624, 441600, '和平县', 441624),
(441625, 441600, '东源县', 441625),
(441700, 440000, '阳江市', 441700),
(441701, 441700, '市辖区', 441701),
(441702, 441700, '江城区', 441702),
(441721, 441700, '阳西县', 441721),
(441723, 441700, '阳东县', 441723),
(441781, 441700, '阳春市', 441781),
(441800, 440000, '清远市', 441800),
(441801, 441800, '市辖区', 441801),
(441802, 441800, '清城区', 441802),
(441821, 441800, '佛冈县', 441821),
(441823, 441800, '阳山县', 441823),
(441825, 441800, '连山县', 441825),
(441826, 441800, '连南瑶族自治县', 441826),
(441827, 441800, '清新县', 441827),
(441881, 441800, '英德市', 441881),
(441882, 441800, '连州市', 441882),
(441900, 440000, '东莞市', 441900),
(442000, 440000, '中山市', 442000),
(442100, 442100, '石岐区', 442100),
(442200, 442200, '东区', 442200),
(442300, 442300, '火炬高技术产业开发区', 442300),
(442400, 442400, '西区', 442400),
(442500, 442500, '南区', 442500),
(442600, 442600, '五桂山', 442600),
(445100, 440000, '潮州市', 445100),
(445101, 445100, '市辖区', 445101),
(445102, 445100, '潮州市湘桥区', 445102),
(445121, 445100, '潮州市潮安县', 445121),
(445122, 445100, '潮州市饶平县', 445122),
(445200, 440000, '揭阳市', 445200),
(445201, 445200, '市辖区', 445201),
(445202, 445200, '榕城区', 445202),
(445221, 445200, '揭东县', 445221),
(445222, 445200, '揭西县', 445222),
(445224, 445200, '惠来县', 445224),
(445281, 445200, '普宁市', 445281),
(445300, 440000, '云浮市', 445300),
(445301, 445300, '市辖区', 445301),
(445302, 445300, '云城区', 445302),
(445321, 445300, '新兴县', 445321),
(445322, 445300, '郁南县', 445322),
(445323, 445300, '云安县', 445323),
(445381, 445300, '罗定市', 445381),
(450000, 0, '广西壮族自治区', 450000),
(450100, 450000, '南宁市', 450100),
(450101, 450100, '市辖区', 450101),
(450102, 450100, '兴宁区', 450102),
(450103, 450100, '青秀区', 450103),
(450105, 450100, '江南区', 450105),
(450107, 450100, '西乡塘区', 450107),
(450108, 450100, '良庆区', 450108),
(450109, 450100, '邕宁区', 450109),
(450122, 450100, '武鸣县', 450122),
(450123, 450100, '隆安县', 450123),
(450124, 450100, '马山县', 450124),
(450125, 450100, '上林县', 450125),
(450126, 450100, '宾阳县', 450126),
(450127, 450100, '横县', 450127),
(450200, 450000, '柳州市', 450200),
(450201, 450200, '市辖区', 450201),
(450202, 450200, '城中区', 450202),
(450203, 450200, '鱼峰区', 450203),
(450204, 450200, '柳南区', 450204),
(450205, 450200, '柳北区', 450205),
(450221, 450200, '柳江县', 450221),
(450222, 450200, '柳城县', 450222),
(450223, 450200, '鹿寨县', 450223),
(450224, 450200, '融安县', 450224),
(450225, 450200, '融水苗族自治县', 450225),
(450226, 450200, '三江侗族自治县', 450226),
(450300, 450000, '桂林市', 450300),
(450301, 450300, '市辖区', 450301),
(450302, 450300, '秀峰区', 450302),
(450303, 450300, '叠彩区', 450303),
(450304, 450300, '象山区', 450304),
(450305, 450300, '七星区', 450305),
(450311, 450300, '雁山区', 450311),
(450321, 450300, '阳朔县', 450321),
(450322, 450300, '临桂县', 450322),
(450323, 450300, '灵川县', 450323),
(450324, 450300, '全州县', 450324),
(450325, 450300, '兴安县', 450325),
(450326, 450300, '永福县', 450326),
(450327, 450300, '灌阳县', 450327),
(450328, 450300, '龙胜各族自治县', 450328),
(450329, 450300, '资源县', 450329),
(450330, 450300, '平乐县', 450330),
(450331, 450300, '荔浦县', 450331),
(450332, 450300, '恭城县', 450332),
(450400, 450000, '梧州市', 450400),
(450401, 450400, '市辖区', 450401),
(450403, 450400, '万秀区', 450403),
(450404, 450400, '蝶山区', 450404),
(450405, 450400, '长洲区', 450405),
(450421, 450400, '苍梧县', 450421),
(450422, 450400, '藤县', 450422),
(450423, 450400, '蒙山县', 450423),
(450481, 450400, '岑溪市', 450481),
(450500, 450000, '北海市', 450500),
(450501, 450500, '市辖区', 450501),
(450502, 450500, '海城区', 450502),
(450503, 450500, '银海区', 450503),
(450512, 450500, '铁山港区', 450512),
(450521, 450500, '合浦县', 450521),
(450600, 450000, '防城港市', 450600),
(450601, 450600, '市辖区', 450601),
(450602, 450600, '港口区', 450602),
(450603, 450600, '防城区', 450603),
(450621, 450600, '上思县', 450621),
(450681, 450600, '东兴市', 450681),
(450700, 450000, '钦州市', 450700),
(450701, 450700, '市辖区', 450701),
(450702, 450700, '钦南区', 450702),
(450703, 450700, '钦北区', 450703),
(450721, 450700, '灵山县', 450721),
(450722, 450700, '浦北县', 450722),
(450800, 450000, '贵港市', 450800),
(450801, 450800, '市辖区', 450801),
(450802, 450800, '港北区', 450802),
(450803, 450800, '港南区', 450803),
(450804, 450800, '覃塘区', 450804),
(450821, 450800, '平南县', 450821),
(450881, 450800, '桂平市', 450881),
(450900, 450000, '玉林市', 450900),
(450901, 450900, '市辖区', 450901),
(450902, 450900, '玉州区', 450902),
(450921, 450900, '容县', 450921),
(450922, 450900, '陆川县', 450922),
(450923, 450900, '博白县', 450923),
(450924, 450900, '兴业县', 450924),
(450981, 450900, '北流市', 450981),
(451000, 450000, '百色市', 451000),
(451001, 451000, '市辖区', 451001),
(451002, 451000, '右江区', 451002),
(451021, 451000, '田阳县', 451021),
(451022, 451000, '田东县', 451022),
(451023, 451000, '平果县', 451023),
(451024, 451000, '德保县', 451024),
(451025, 451000, '靖西县', 451025),
(451026, 451000, '那坡县', 451026),
(451027, 451000, '凌云县', 451027),
(451028, 451000, '乐业县', 451028),
(451029, 451000, '田林县', 451029),
(451030, 451000, '西林县', 451030),
(451031, 451000, '隆林各族自治县', 451031),
(451100, 450000, '贺州市', 451100),
(451101, 451100, '市辖区', 451101),
(451102, 451100, '八步区', 451102),
(451121, 451100, '昭平县', 451121),
(451122, 451100, '钟山县', 451122),
(451123, 451100, '富川瑶族自治县', 451123),
(451200, 450000, '河池市', 451200),
(451201, 451200, '市辖区', 451201),
(451202, 451200, '金城江区', 451202),
(451221, 451200, '南丹县', 451221),
(451222, 451200, '天峨县', 451222),
(451223, 451200, '凤山县', 451223),
(451224, 451200, '东兰县', 451224),
(451225, 451200, '罗城仫佬族自治县', 451225),
(451226, 451200, '环江毛南族自治县', 451226),
(451227, 451200, '巴马瑶族自治县', 451227),
(451228, 451200, '都安瑶族自治县', 451228),
(451229, 451200, '大化瑶族自治县', 451229),
(451281, 451200, '宜州市', 451281),
(451300, 450000, '来宾市', 451300),
(451301, 451300, '市辖区', 451301),
(451302, 451300, '兴宾区', 451302),
(451321, 451300, '忻城县', 451321),
(451322, 451300, '象州县', 451322),
(451323, 451300, '武宣县', 451323),
(451324, 451300, '金秀瑶族自治县', 451324),
(451381, 451300, '合山市', 451381),
(451400, 450000, '崇左市', 451400),
(451401, 451400, '市辖区', 451401),
(451402, 451400, '江州区', 451402),
(451421, 451400, '扶绥县', 451421),
(451422, 451400, '宁明县', 451422),
(451423, 451400, '龙州县', 451423),
(451424, 451400, '大新县', 451424),
(451425, 451400, '天等县', 451425),
(451481, 451400, '凭祥市', 451481),
(460000, 0, '海南省', 460000),
(460100, 460000, '海口市', 460100),
(460101, 460100, '市辖区', 460101),
(460105, 460100, '秀英区', 460105),
(460106, 460100, '龙华区', 460106),
(460107, 460100, '琼山区', 460107),
(460108, 460100, '美兰区', 460108),
(460200, 460000, '三亚市', 460200),
(460201, 460200, '市辖区', 460201),
(469000, 460000, '省属虚拟市', 469000),
(469001, 469000, '五指山市', 469001),
(469002, 469000, '琼海市', 469002),
(469003, 469000, '儋州市', 469003),
(469005, 469000, '文昌市', 469005),
(469006, 469000, '万宁市', 469006),
(469007, 469000, '东方市', 469007),
(469025, 469000, '定安县', 469025),
(469026, 469000, '屯昌县', 469026),
(469027, 469000, '澄迈县', 469027),
(469028, 469000, '临高县', 469028),
(469030, 469000, '白沙黎族自治县', 469030),
(469031, 469000, '昌江黎族自治县', 469031),
(469033, 469000, '乐东黎族自治县', 469033),
(469034, 469000, '陵水黎族自治县', 469034),
(469035, 469000, '保亭黎族苗族自治县', 469035),
(469036, 469000, '琼中黎族苗族自治县', 469036),
(469037, 469000, '西沙群岛', 469037),
(469038, 469000, '南沙群岛', 469038),
(469039, 469000, '中沙群岛的岛礁及其海域', 469039),
(500000, 0, '重庆市', 500000),
(500100, 500000, '市辖区', 500100),
(500101, 500100, '万州区', 500101),
(500102, 500100, '涪陵区', 500102),
(500103, 500100, '渝中区', 500103),
(500104, 500100, '大渡口区', 500104),
(500105, 500100, '江北区', 500105),
(500106, 500100, '沙坪坝区', 500106),
(500107, 500100, '九龙坡区', 500107),
(500108, 500100, '南岸区', 500108),
(500109, 500100, '北碚区', 500109),
(500110, 500100, '万盛区', 500110),
(500111, 500100, '双桥区', 500111),
(500112, 500100, '渝北区', 500112),
(500113, 500100, '巴南区', 500113),
(500114, 500100, '黔江区', 500114),
(500115, 500100, '长寿区', 500115),
(500116, 500100, '江津区', 500116),
(500117, 500100, '合川区', 500117),
(500118, 500100, '永川区', 500118),
(500119, 500100, '南川区', 500119),
(500200, 500000, '县', 500200),
(500222, 500200, '綦江县', 500222),
(500223, 500200, '潼南县', 500223),
(500224, 500200, '铜梁县', 500224),
(500225, 500200, '大足县', 500225),
(500226, 500200, '荣昌县', 500226),
(500227, 500200, '璧山县', 500227),
(500228, 500200, '梁平县', 500228),
(500229, 500200, '城口县', 500229),
(500230, 500200, '丰都县', 500230),
(500231, 500200, '垫江县', 500231),
(500232, 500200, '武隆县', 500232),
(500233, 500200, '忠县', 500233),
(500234, 500200, '开县', 500234),
(500235, 500200, '云阳县', 500235),
(500236, 500200, '奉节县', 500236),
(500237, 500200, '巫山县', 500237),
(500238, 500200, '巫溪县', 500238),
(500240, 500200, '石柱县', 500240),
(500241, 500200, '秀山土家族苗族自治县', 500241),
(500242, 500200, '酉阳土家族苗族自治县', 500242),
(500243, 500200, '彭水苗族土家族自治县', 500243),
(510000, 0, '四川省', 510000),
(510100, 510000, '成都市', 510100),
(510101, 510100, '市辖区', 510101),
(510104, 510100, '锦江区', 510104),
(510105, 510100, '青羊区', 510105),
(510106, 510100, '金牛区', 510106),
(510107, 510100, '武侯区', 510107),
(510108, 510100, '成华区', 510108),
(510112, 510100, '龙泉驿区', 510112),
(510113, 510100, '青白江区', 510113),
(510114, 510100, '新都区', 510114),
(510115, 510100, '温江区', 510115),
(510121, 510100, '金堂县', 510121),
(510122, 510100, '双流县', 510122),
(510124, 510100, '郫县', 510124),
(510129, 510100, '大邑县', 510129),
(510131, 510100, '蒲江县', 510131),
(510132, 510100, '新津县', 510132),
(510181, 510100, '都江堰市', 510181),
(510182, 510100, '彭州市', 510182),
(510183, 510100, '邛崃市', 510183),
(510184, 510100, '崇州市', 510184),
(510300, 510000, '自贡市', 510300),
(510301, 510300, '市辖区', 510301),
(510302, 510300, '自流井区', 510302),
(510303, 510300, '贡井区', 510303),
(510304, 510300, '大安区', 510304),
(510311, 510300, '沿滩区', 510311),
(510321, 510300, '荣县', 510321),
(510322, 510300, '富顺县', 510322),
(510400, 510000, '攀枝花市', 510400),
(510401, 510400, '市辖区', 510401),
(510402, 510400, '攀枝花东区', 510402),
(510403, 510400, '西区', 510403),
(510411, 510400, '仁和区', 510411),
(510421, 510400, '米易县', 510421),
(510422, 510400, '盐边县', 510422),
(510500, 510000, '泸州市', 510500),
(510501, 510500, '市辖区', 510501),
(510502, 510500, '江阳区', 510502),
(510503, 510500, '纳溪区', 510503),
(510504, 510500, '龙马潭区', 510504),
(510521, 510500, '泸县', 510521),
(510522, 510500, '合江县', 510522),
(510524, 510500, '叙永县', 510524),
(510525, 510500, '古蔺县', 510525),
(510600, 510000, '德阳市', 510600),
(510601, 510600, '市辖区', 510601),
(510603, 510600, '旌阳区', 510603),
(510623, 510600, '中江县', 510623),
(510626, 510600, '罗江县', 510626),
(510681, 510600, '广汉市', 510681),
(510682, 510600, '什邡市', 510682),
(510683, 510600, '绵竹市', 510683),
(510700, 510000, '绵阳市', 510700),
(510701, 510700, '市辖区', 510701),
(510703, 510700, '涪城区', 510703),
(510704, 510700, '游仙区', 510704),
(510722, 510700, '三台县', 510722),
(510723, 510700, '盐亭县', 510723),
(510724, 510700, '安县', 510724),
(510725, 510700, '梓潼县', 510725),
(510726, 510700, '北川羌族自治县', 510726),
(510727, 510700, '平武县', 510727),
(510781, 510700, '江油市', 510781),
(510800, 510000, '广元市', 510800),
(510801, 510800, '市辖区', 510801),
(510802, 510800, '市中区', 510802),
(510811, 510800, '元坝区', 510811),
(510812, 510800, '朝天区', 510812),
(510821, 510800, '旺苍县', 510821),
(510822, 510800, '青川县', 510822),
(510823, 510800, '剑阁县', 510823),
(510824, 510800, '苍溪县', 510824),
(510900, 510000, '遂宁市', 510900),
(510901, 510900, '市辖区', 510901),
(510903, 510900, '船山区', 510903),
(510904, 510900, '安居区', 510904),
(510921, 510900, '蓬溪县', 510921),
(510922, 510900, '射洪县', 510922),
(510923, 510900, '大英县', 510923),
(511000, 510000, '内江市', 511000),
(511001, 511000, '市辖区', 511001),
(511002, 511000, '市中区', 511002),
(511011, 511000, '东兴区', 511011),
(511024, 511000, '威远县', 511024),
(511025, 511000, '资中县', 511025),
(511028, 511000, '隆昌县', 511028),
(511100, 510000, '乐山市', 511100),
(511101, 511100, '市辖区', 511101),
(511102, 511100, '市中区', 511102),
(511111, 511100, '沙湾区', 511111),
(511112, 511100, '五通桥区', 511112),
(511113, 511100, '金口河区', 511113),
(511123, 511100, '犍为县', 511123),
(511124, 511100, '井研县', 511124),
(511126, 511100, '夹江县', 511126),
(511129, 511100, '沐川县', 511129),
(511132, 511100, '峨边彝族自治县', 511132),
(511133, 511100, '马边彝族自治县', 511133),
(511181, 511100, '峨眉山市', 511181),
(511300, 510000, '南充市', 511300),
(511301, 511300, '市辖区', 511301),
(511302, 511300, '顺庆区', 511302),
(511303, 511300, '高坪区', 511303),
(511304, 511300, '嘉陵区', 511304),
(511321, 511300, '南部县', 511321),
(511322, 511300, '营山县', 511322),
(511323, 511300, '蓬安县', 511323),
(511324, 511300, '仪陇县', 511324),
(511325, 511300, '西充县', 511325),
(511381, 511300, '阆中市', 511381),
(511400, 510000, '眉山市', 511400),
(511401, 511400, '市辖区', 511401),
(511402, 511400, '东坡区', 511402),
(511421, 511400, '仁寿县', 511421),
(511422, 511400, '彭山县', 511422),
(511423, 511400, '洪雅县', 511423),
(511424, 511400, '丹棱县', 511424),
(511425, 511400, '青神县', 511425),
(511500, 510000, '宜宾市', 511500),
(511501, 511500, '市辖区', 511501),
(511502, 511500, '翠屏区', 511502),
(511521, 511500, '宜宾县', 511521),
(511522, 511500, '南溪县', 511522),
(511523, 511500, '江安县', 511523),
(511524, 511500, '长宁县', 511524),
(511525, 511500, '高县', 511525),
(511526, 511500, '珙县', 511526),
(511527, 511500, '筠连县', 511527),
(511528, 511500, '兴文县', 511528),
(511529, 511500, '屏山县', 511529),
(511600, 510000, '广安市', 511600),
(511601, 511600, '市辖区', 511601),
(511602, 511600, '广安区', 511602),
(511621, 511600, '岳池县', 511621);
INSERT INTO `{pre}areas` VALUES
(511622, 511600, '武胜县', 511622),
(511623, 511600, '邻水县', 511623),
(511681, 511600, '华蓥市', 511681),
(511700, 510000, '达州市', 511700),
(511701, 511700, '市辖区', 511701),
(511702, 511700, '通川区', 511702),
(511721, 511700, '达县', 511721),
(511722, 511700, '宣汉县', 511722),
(511723, 511700, '开江县', 511723),
(511724, 511700, '大竹县', 511724),
(511725, 511700, '渠县', 511725),
(511781, 511700, '万源市', 511781),
(511800, 510000, '雅安市', 511800),
(511801, 511800, '市辖区', 511801),
(511802, 511800, '雨城区', 511802),
(511821, 511800, '名山县', 511821),
(511822, 511800, '荥经县', 511822),
(511823, 511800, '汉源县', 511823),
(511824, 511800, '石棉县', 511824),
(511825, 511800, '天全县', 511825),
(511826, 511800, '芦山县', 511826),
(511827, 511800, '宝兴县', 511827),
(511900, 510000, '巴中市', 511900),
(511901, 511900, '市辖区', 511901),
(511902, 511900, '巴州区', 511902),
(511921, 511900, '通江县', 511921),
(511922, 511900, '南江县', 511922),
(511923, 511900, '平昌县', 511923),
(512000, 510000, '资阳市', 512000),
(512001, 512000, '市辖区', 512001),
(512002, 512000, '雁江区', 512002),
(512021, 512000, '安岳县', 512021),
(512022, 512000, '乐至县', 512022),
(512081, 512000, '简阳市', 512081),
(513200, 510000, '阿坝州', 513200),
(513221, 513200, '汶川县', 513221),
(513222, 513200, '理县', 513222),
(513223, 513200, '茂县', 513223),
(513224, 513200, '松潘县', 513224),
(513225, 513200, '九寨沟县', 513225),
(513226, 513200, '金川县', 513226),
(513227, 513200, '小金县', 513227),
(513228, 513200, '黑水县', 513228),
(513229, 513200, '马尔康县', 513229),
(513230, 513200, '壤塘县', 513230),
(513231, 513200, '阿坝县', 513231),
(513232, 513200, '若尔盖县', 513232),
(513233, 513200, '红原县', 513233),
(513300, 510000, '甘孜藏族自治州', 513300),
(513321, 513300, '康定县', 513321),
(513322, 513300, '泸定县', 513322),
(513323, 513300, '丹巴县', 513323),
(513324, 513300, '九龙县', 513324),
(513325, 513300, '雅江县', 513325),
(513326, 513300, '道孚县', 513326),
(513327, 513300, '炉霍县', 513327),
(513328, 513300, '甘孜县', 513328),
(513329, 513300, '新龙县', 513329),
(513330, 513300, '德格县', 513330),
(513331, 513300, '白玉县', 513331),
(513332, 513300, '石渠县', 513332),
(513333, 513300, '色达县', 513333),
(513334, 513300, '理塘县', 513334),
(513335, 513300, '巴塘县', 513335),
(513336, 513300, '乡城县', 513336),
(513337, 513300, '稻城县', 513337),
(513338, 513300, '得荣县', 513338),
(513400, 510000, '凉山州', 513400),
(513401, 513400, '西昌市', 513401),
(513422, 513400, '木里藏族自治县', 513422),
(513423, 513400, '盐源县', 513423),
(513424, 513400, '德昌', 513424),
(513425, 513400, '会理县', 513425),
(513426, 513400, '会东县', 513426),
(513427, 513400, '宁南县', 513427),
(513428, 513400, '普格县', 513428),
(513429, 513400, '布拖县', 513429),
(513430, 513400, '金阳县', 513430),
(513431, 513400, '昭觉县', 513431),
(513432, 513400, '喜德县', 513432),
(513433, 513400, '冕宁县', 513433),
(513434, 513400, '越西县', 513434),
(513435, 513400, '甘洛县', 513435),
(513436, 513400, '美姑县', 513436),
(513437, 513400, '雷波县', 513437),
(520000, 0, '贵州省', 520000),
(520100, 520000, '贵阳市', 520100),
(520101, 520100, '市辖区', 520101),
(520102, 520100, '南明区', 520102),
(520103, 520100, '云岩区', 520103),
(520111, 520100, '花溪区', 520111),
(520112, 520100, '乌当区', 520112),
(520113, 520100, '白云区', 520113),
(520114, 520100, '小河区', 520114),
(520121, 520100, '开阳县', 520121),
(520122, 520100, '息烽县', 520122),
(520123, 520100, '修文县', 520123),
(520181, 520100, '清镇市', 520181),
(520200, 520000, '六盘水市', 520200),
(520201, 520200, '钟山区', 520201),
(520203, 520200, '六枝特区', 520203),
(520221, 520200, '水城县', 520221),
(520222, 520200, '盘县', 520222),
(520300, 520000, '遵义市', 520300),
(520301, 520300, '市辖区', 520301),
(520302, 520300, '红花岗区', 520302),
(520303, 520300, '汇川区', 520303),
(520321, 520300, '遵义县', 520321),
(520322, 520300, '桐梓县', 520322),
(520323, 520300, '绥阳县', 520323),
(520324, 520300, '正安县', 520324),
(520325, 520300, '道真仡佬族苗族自治县', 520325),
(520326, 520300, '务川仡佬族苗族自治县', 520326),
(520327, 520300, '凤冈县', 520327),
(520328, 520300, '湄潭县', 520328),
(520329, 520300, '余庆县', 520329),
(520330, 520300, '习水县', 520330),
(520381, 520300, '赤水市', 520381),
(520382, 520300, '仁怀市', 520382),
(520400, 520000, '安顺市', 520400),
(520401, 520400, '市辖区', 520401),
(520402, 520400, '西秀区', 520402),
(520421, 520400, '平坝县', 520421),
(520422, 520400, '普定县', 520422),
(520423, 520400, '镇宁布依族苗族自治县', 520423),
(520424, 520400, '关岭自治县', 520424),
(520425, 520400, '紫云苗族布依族自治县', 520425),
(522200, 520000, '铜仁地区', 522200),
(522201, 522200, '铜仁市', 522201),
(522222, 522200, '江口县', 522222),
(522223, 522200, '玉屏侗族自治县', 522223),
(522224, 522200, '石阡县', 522224),
(522225, 522200, '思南县　', 522225),
(522226, 522200, '印江土家族苗族自治县', 522226),
(522227, 522200, '德江县', 522227),
(522228, 522200, '沿河土家族自治县', 522228),
(522229, 522200, '松桃苗族自治县', 522229),
(522230, 522200, '万山特区', 522230),
(522300, 520000, '黔西南州', 522300),
(522301, 522300, '兴义市', 522301),
(522322, 522300, '兴仁县', 522322),
(522323, 522300, '普安县', 522323),
(522324, 522300, '晴隆县', 522324),
(522325, 522300, '贞丰县', 522325),
(522326, 522300, '望谟县', 522326),
(522327, 522300, '册亨县', 522327),
(522328, 522300, '安龙县', 522328),
(522400, 520000, '毕节地区', 522400),
(522401, 522400, '毕节市', 522401),
(522422, 522400, '大方县', 522422),
(522423, 522400, '黔西县', 522423),
(522424, 522400, '金沙县', 522424),
(522425, 522400, '织金县', 522425),
(522426, 522400, '纳雍县', 522426),
(522427, 522400, '威宁彝族回族苗族自治县', 522427),
(522428, 522400, '赫章县', 522428),
(522600, 520000, '黔东南苗族侗族自治州', 522600),
(522601, 522600, '凯里市', 522601),
(522622, 522600, '黄平县', 522622),
(522623, 522600, '施秉县', 522623),
(522624, 522600, '三穗县', 522624),
(522625, 522600, '镇远县', 522625),
(522626, 522600, '岑巩县', 522626),
(522627, 522600, '天柱县', 522627),
(522628, 522600, '锦屏县', 522628),
(522629, 522600, '剑河县', 522629),
(522630, 522600, '台江县', 522630),
(522631, 522600, '黎平县', 522631),
(522632, 522600, '榕江县', 522632),
(522633, 522600, '从江县', 522633),
(522634, 522600, '雷山县', 522634),
(522635, 522600, '麻江县', 522635),
(522636, 522600, '丹寨县', 522636),
(522700, 520000, '黔南布依族苗族自治州', 522700),
(522701, 522700, '都匀市', 522701),
(522702, 522700, '福泉市', 522702),
(522722, 522700, '荔波县', 522722),
(522723, 522700, '贵定县', 522723),
(522725, 522700, '瓮安县', 522725),
(522726, 522700, '独山县', 522726),
(522727, 522700, '平塘县', 522727),
(522728, 522700, '罗甸县', 522728),
(522729, 522700, '长顺县', 522729),
(522730, 522700, '龙里县', 522730),
(522731, 522700, '惠水县', 522731),
(522732, 522700, '三都水族自治县', 522732),
(530000, 0, '云南省', 530000),
(530100, 530000, '昆明市', 530100),
(530101, 530100, '市辖区', 530101),
(530102, 530100, '五华区', 530102),
(530103, 530100, '盘龙区', 530103),
(530111, 530100, '官渡区', 530111),
(530112, 530100, '西山区', 530112),
(530113, 530100, '东川区', 530113),
(530121, 530100, '呈贡县', 530121),
(530122, 530100, '晋宁县', 530122),
(530124, 530100, '富民县', 530124),
(530125, 530100, '宜良县', 530125),
(530126, 530100, '石林县', 530126),
(530127, 530100, '嵩明县', 530127),
(530128, 530100, '禄劝县', 530128),
(530129, 530100, '寻甸县', 530129),
(530181, 530100, '安宁市', 530181),
(530300, 530000, '曲靖市', 530300),
(530301, 530300, '市辖区', 530301),
(530302, 530300, '麒麟区', 530302),
(530321, 530300, '马龙县', 530321),
(530322, 530300, '陆良县', 530322),
(530323, 530300, '师宗县', 530323),
(530324, 530300, '罗平县', 530324),
(530325, 530300, '富源县', 530325),
(530326, 530300, '会泽县', 530326),
(530328, 530300, '沾益县', 530328),
(530381, 530300, '宣威市', 530381),
(530400, 530000, '玉溪市', 530400),
(530401, 530400, '市辖区', 530401),
(530402, 530400, '红塔区', 530402),
(530421, 530400, '江川县', 530421),
(530422, 530400, '澄江县', 530422),
(530423, 530400, '通海县', 530423),
(530424, 530400, '华宁县', 530424),
(530425, 530400, '易门县', 530425),
(530426, 530400, '峨山县', 530426),
(530427, 530400, '新平县', 530427),
(530428, 530400, '元江县', 530428),
(530500, 530000, '保山市', 530500),
(530501, 530500, '市辖区', 530501),
(530502, 530500, '隆阳区', 530502),
(530521, 530500, '施甸县', 530521),
(530522, 530500, '腾冲县', 530522),
(530523, 530500, '龙陵县', 530523),
(530524, 530500, '昌宁县', 530524),
(530600, 530000, '昭通市', 530600),
(530601, 530600, '市辖区', 530601),
(530602, 530600, '昭阳区', 530602),
(530621, 530600, '鲁甸县', 530621),
(530622, 530600, '巧家县', 530622),
(530623, 530600, '盐津县', 530623),
(530624, 530600, '大关县', 530624),
(530625, 530600, '永善县', 530625),
(530626, 530600, '绥江县', 530626),
(530627, 530600, '镇雄县', 530627),
(530628, 530600, '彝良县', 530628),
(530629, 530600, '威信县', 530629),
(530630, 530600, '水富县', 530630),
(530700, 530000, '丽江市', 530700),
(530701, 530700, '市辖区', 530701),
(530702, 530700, '古城区', 530702),
(530721, 530700, '玉龙县', 530721),
(530722, 530700, '永胜县', 530722),
(530723, 530700, '华坪县', 530723),
(530724, 530700, '宁蒗县', 530724),
(530800, 530000, '思茅市', 530800),
(530801, 530800, '市辖区', 530801),
(530802, 530800, '翠云区', 530802),
(530821, 530800, '普洱县', 530821),
(530822, 530800, '墨江县', 530822),
(530823, 530800, '景东县', 530823),
(530824, 530800, '景谷县', 530824),
(530825, 530800, '镇沅县', 530825),
(530826, 530800, '江城县', 530826),
(530827, 530800, '孟连县', 530827),
(530828, 530800, '澜沧县', 530828),
(530829, 530800, '西盟县', 530829),
(530900, 530000, '临沧市', 530900),
(530901, 530900, '市辖区', 530901),
(530902, 530900, '临翔区', 530902),
(530921, 530900, '凤庆县', 530921),
(530922, 530900, '云县', 530922),
(530923, 530900, '永德县', 530923),
(530924, 530900, '镇康县', 530924),
(530925, 530900, '双江县', 530925),
(530926, 530900, '耿马县', 530926),
(530927, 530900, '沧源县', 530927),
(532300, 530000, '楚雄州', 532300),
(532301, 532300, '楚雄市', 532301),
(532322, 532300, '双柏县', 532322),
(532323, 532300, '牟定县', 532323),
(532324, 532300, '南华县', 532324),
(532325, 532300, '姚安县', 532325),
(532326, 532300, '大姚县', 532326),
(532327, 532300, '永仁县', 532327),
(532328, 532300, '元谋县', 532328),
(532329, 532300, '武定县', 532329),
(532331, 532300, '禄丰县', 532331),
(532500, 530000, '红河州', 532500),
(532501, 532500, '个旧市', 532501),
(532502, 532500, '开远市', 532502),
(532522, 532500, '蒙自县', 532522),
(532523, 532500, '屏边县', 532523),
(532524, 532500, '建水县', 532524),
(532525, 532500, '石屏县', 532525),
(532526, 532500, '弥勒县', 532526),
(532527, 532500, '泸西县', 532527),
(532528, 532500, '元阳县', 532528),
(532529, 532500, '红河县', 532529),
(532530, 532500, '金平县', 532530),
(532531, 532500, '绿春县', 532531),
(532532, 532500, '河口县', 532532),
(532600, 530000, '文山州', 532600),
(532621, 532600, '文山县', 532621),
(532622, 532600, '砚山县', 532622),
(532623, 532600, '西畴县', 532623),
(532624, 532600, '麻栗坡县', 532624),
(532625, 532600, '马关县', 532625),
(532626, 532600, '丘北县', 532626),
(532627, 532600, '广南县', 532627),
(532628, 532600, '富宁县', 532628),
(532800, 530000, '西双版纳州', 532800),
(532801, 532800, '景洪市', 532801),
(532822, 532800, '勐海县', 532822),
(532823, 532800, '勐腊县', 532823),
(532900, 530000, '大理州', 532900),
(532901, 532900, '大理市', 532901),
(532922, 532900, '漾濞县', 532922),
(532923, 532900, '祥云县', 532923),
(532924, 532900, '宾川县', 532924),
(532925, 532900, '弥渡县', 532925),
(532926, 532900, '南涧县', 532926),
(532927, 532900, '巍山县', 532927),
(532928, 532900, '永平县', 532928),
(532929, 532900, '云龙县', 532929),
(532930, 532900, '洱源县', 532930),
(532931, 532900, '剑川县', 532931),
(532932, 532900, '鹤庆县', 532932),
(533100, 530000, '德宏州', 533100),
(533102, 533100, '瑞丽市', 533102),
(533103, 533100, '潞西市', 533103),
(533122, 533100, '梁河县', 533122),
(533123, 533100, '盈江县', 533123),
(533124, 533100, '陇川县', 533124),
(533300, 530000, '怒江州', 533300),
(533321, 533300, '泸水县', 533321),
(533323, 533300, '福贡县', 533323),
(533324, 533300, '贡山县', 533324),
(533325, 533300, '兰坪县', 533325),
(533400, 530000, '迪庆州', 533400),
(533421, 533400, '香格里拉县', 533421),
(533422, 533400, '德钦县', 533422),
(533423, 533400, '维西县', 533423),
(540000, 0, '西藏自治区', 540000),
(540100, 540000, '拉萨市', 540100),
(540101, 540100, '市辖区', 540101),
(540102, 540100, '城关区', 540102),
(540121, 540100, '林周县', 540121),
(540122, 540100, '当雄县', 540122),
(540123, 540100, '尼木县', 540123),
(540124, 540100, '曲水县', 540124),
(540125, 540100, '堆龙德庆', 540125),
(540126, 540100, '达孜县', 540126),
(540127, 540100, '墨竹工卡县', 540127),
(542100, 540000, '昌都地区', 542100),
(542121, 542100, '昌都县', 542121),
(542122, 542100, '江达县', 542122),
(542123, 542100, '贡觉县', 542123),
(542124, 542100, '类乌齐县', 542124),
(542125, 542100, '丁青县', 542125),
(542126, 542100, '察亚县', 542126),
(542127, 542100, '八宿县', 542127),
(542128, 542100, '左贡县', 542128),
(542129, 542100, '芒康县', 542129),
(542132, 542100, '洛隆县', 542132),
(542133, 542100, '边坝县', 542133),
(542200, 540000, '山南地区', 542200),
(542221, 542200, '乃东县', 542221),
(542222, 542200, '扎囊县', 542222),
(542223, 542200, '贡嘎县', 542223),
(542224, 542200, '桑日县', 542224),
(542225, 542200, '琼结县', 542225),
(542226, 542200, '曲松县', 542226),
(542227, 542200, '措美县', 542227),
(542228, 542200, '洛扎县', 542228),
(542229, 542200, '加查县', 542229),
(542231, 542200, '隆子县', 542231),
(542232, 542200, '错那县', 542232),
(542233, 542200, '浪卡子县', 542233),
(542300, 540000, '日喀则地区', 542300),
(542301, 542300, '日喀则市', 542301),
(542322, 542300, '南木林县', 542322),
(542323, 542300, '江孜县', 542323),
(542324, 542300, '定日县', 542324),
(542325, 542300, '萨迦县', 542325),
(542326, 542300, '拉孜县', 542326),
(542327, 542300, '昂仁县', 542327),
(542328, 542300, '谢通门县', 542328),
(542329, 542300, '白朗县', 542329),
(542330, 542300, '仁布县', 542330),
(542331, 542300, '康马县', 542331),
(542332, 542300, '定结县', 542332),
(542333, 542300, '仲巴县', 542333),
(542334, 542300, '亚东县', 542334),
(542335, 542300, '吉隆县', 542335),
(542336, 542300, '聂拉木县', 542336),
(542337, 542300, '萨嘎县', 542337),
(542338, 542300, '岗巴县', 542338),
(542400, 540000, '那曲地区', 542400),
(542421, 542400, '那曲县', 542421),
(542422, 542400, '嘉黎县', 542422),
(542423, 542400, '比如县', 542423),
(542424, 542400, '聂荣县', 542424),
(542425, 542400, '安多县', 542425),
(542426, 542400, '申扎县', 542426),
(542427, 542400, '索县', 542427),
(542428, 542400, '班戈县', 542428),
(542429, 542400, '巴青县', 542429),
(542430, 542400, '尼玛县', 542430),
(542500, 540000, '阿里地区', 542500),
(542521, 542500, '普兰县', 542521),
(542522, 542500, '札达县', 542522),
(542523, 542500, '噶尔县', 542523),
(542524, 542500, '日土县', 542524),
(542525, 542500, '革吉县', 542525),
(542526, 542500, '改则县', 542526),
(542527, 542500, '措勤县', 542527),
(542600, 540000, '林芝地区', 542600),
(542621, 542600, '林芝县', 542621),
(542622, 542600, '工布江达县', 542622),
(542623, 542600, '米林县', 542623),
(542624, 542600, '墨脱县', 542624),
(542625, 542600, '波密县', 542625),
(542626, 542600, '察隅县', 542626),
(542627, 542600, '朗县', 542627),
(610000, 0, '陕西省', 610000),
(610100, 610000, '西安市', 610100),
(610101, 610100, '市辖区', 610101),
(610102, 610100, '新城区', 610102),
(610103, 610100, '碑林区', 610103),
(610104, 610100, '莲湖区', 610104),
(610111, 610100, '灞桥区', 610111),
(610112, 610100, '未央区', 610112),
(610113, 610100, '雁塔区', 610113),
(610114, 610100, '阎良区', 610114),
(610115, 610100, '临潼区', 610115),
(610116, 610100, '长安区', 610116),
(610122, 610100, '蓝田县', 610122),
(610124, 610100, '周至县', 610124),
(610125, 610100, '户县', 610125),
(610126, 610100, '高陵县', 610126),
(610200, 610000, '铜川市', 610200),
(610201, 610200, '市辖区', 610201),
(610202, 610200, '王益区', 610202),
(610203, 610200, '印台区', 610203),
(610204, 610200, '耀州区', 610204),
(610222, 610200, '宜君县', 610222),
(610300, 610000, '宝鸡市', 610300),
(610301, 610300, '市辖区', 610301),
(610302, 610300, '渭滨区', 610302),
(610303, 610300, '金台区', 610303),
(610304, 610300, '陈仓区', 610304),
(610322, 610300, '凤翔县', 610322),
(610323, 610300, '岐山县', 610323),
(610324, 610300, '扶风县', 610324),
(610326, 610300, '眉县', 610326),
(610327, 610300, '陇县', 610327),
(610328, 610300, '千阳县', 610328),
(610329, 610300, '麟游县', 610329),
(610330, 610300, '凤县', 610330),
(610331, 610300, '太白县', 610331),
(610400, 610000, '咸阳市', 610400),
(610401, 610400, '市辖区', 610401),
(610402, 610400, '秦都区', 610402),
(610403, 610400, '杨凌区', 610403),
(610404, 610400, '渭城区', 610404),
(610422, 610400, '三原县', 610422),
(610423, 610400, '泾阳县', 610423),
(610424, 610400, '乾县', 610424),
(610425, 610400, '礼泉县', 610425),
(610426, 610400, '永寿县', 610426),
(610427, 610400, '彬县', 610427),
(610428, 610400, '长武县', 610428),
(610429, 610400, '旬邑县', 610429),
(610430, 610400, '淳化县', 610430),
(610431, 610400, '武功县', 610431),
(610481, 610400, '兴平市', 610481),
(610500, 610000, '渭南市', 610500),
(610501, 610500, '市辖区', 610501),
(610502, 610500, '临渭区', 610502),
(610521, 610500, '华县', 610521),
(610522, 610500, '潼关县', 610522),
(610523, 610500, '大荔县', 610523),
(610524, 610500, '合阳县', 610524),
(610525, 610500, '澄城县', 610525),
(610526, 610500, '蒲城县', 610526),
(610527, 610500, '白水县', 610527),
(610528, 610500, '富平县', 610528),
(610581, 610500, '韩城市', 610581),
(610582, 610500, '华阴市', 610582),
(610600, 610000, '延安市', 610600),
(610601, 610600, '市辖区', 610601),
(610602, 610600, '宝塔区', 610602),
(610621, 610600, '延长县', 610621),
(610622, 610600, '延川县', 610622),
(610623, 610600, '子长县', 610623),
(610624, 610600, '安塞县', 610624),
(610625, 610600, '志丹县', 610625),
(610626, 610600, '吴起县', 610626),
(610627, 610600, '甘泉县', 610627),
(610628, 610600, '富县', 610628),
(610629, 610600, '洛川县', 610629),
(610630, 610600, '宜川县', 610630),
(610631, 610600, '黄龙县', 610631),
(610632, 610600, '黄陵县', 610632),
(610700, 610000, '汉中市', 610700),
(610701, 610700, '市辖区', 610701),
(610702, 610700, '汉台区', 610702),
(610721, 610700, '南郑县', 610721),
(610722, 610700, '城固县', 610722),
(610723, 610700, '洋县', 610723),
(610724, 610700, '西乡县', 610724),
(610725, 610700, '勉县', 610725),
(610726, 610700, '宁强县', 610726),
(610727, 610700, '略阳县', 610727),
(610728, 610700, '镇巴县', 610728),
(610729, 610700, '留坝县', 610729),
(610730, 610700, '佛坪县', 610730),
(610800, 610000, '榆林市', 610800),
(610801, 610800, '市辖区', 610801),
(610802, 610800, '榆阳区', 610802),
(610821, 610800, '神木县', 610821),
(610822, 610800, '府谷县', 610822),
(610823, 610800, '横山县', 610823),
(610824, 610800, '靖边县', 610824),
(610825, 610800, '定边县', 610825),
(610826, 610800, '绥德县', 610826),
(610827, 610800, '米脂县', 610827),
(610828, 610800, '佳县', 610828),
(610829, 610800, '吴堡县', 610829),
(610830, 610800, '清涧县', 610830),
(610831, 610800, '子洲县', 610831),
(610900, 610000, '安康市', 610900),
(610901, 610900, '市辖区', 610901),
(610902, 610900, '汉滨区', 610902),
(610921, 610900, '汉阴县', 610921),
(610922, 610900, '石泉县', 610922),
(610923, 610900, '宁陕县', 610923),
(610924, 610900, '紫阳县', 610924),
(610925, 610900, '岚皋县', 610925),
(610926, 610900, '平利县', 610926),
(610927, 610900, '镇坪县', 610927),
(610928, 610900, '旬阳县', 610928),
(610929, 610900, '白河县', 610929),
(611000, 610000, '商洛市', 611000),
(611001, 611000, '市辖区', 611001),
(611002, 611000, '商州区', 611002),
(611021, 611000, '洛南县', 611021),
(611022, 611000, '丹凤县', 611022),
(611023, 611000, '商南县', 611023),
(611024, 611000, '山阳县', 611024),
(611025, 611000, '镇安县', 611025),
(611026, 611000, '柞水县', 611026),
(620000, 0, '甘肃省', 620000),
(620100, 620000, '兰州市', 620100),
(620101, 620100, '市辖区', 620101),
(620102, 620100, '城关区', 620102),
(620103, 620100, '七里河区', 620103),
(620104, 620100, '兰州市西固区', 620104),
(620105, 620100, '安宁区', 620105),
(620111, 620100, '红古区', 620111),
(620121, 620100, '永登县', 620121),
(620122, 620100, '皋兰县', 620122),
(620123, 620100, '榆中县', 620123),
(620200, 620000, '嘉峪关市', 620200),
(620201, 620200, '市辖', 620201),
(620300, 620000, '金昌市', 620300),
(620301, 620300, '市辖区', 620301),
(620302, 620300, '金川区', 620302),
(620321, 620300, '永昌县', 620321),
(620400, 620000, '白银市', 620400),
(620401, 620400, '市辖区', 620401),
(620402, 620400, '白银区', 620402),
(620403, 620400, '平川区', 620403),
(620421, 620400, '靖远县', 620421),
(620422, 620400, '会宁县', 620422),
(620423, 620400, '景泰县', 620423),
(620500, 620000, '天水市', 620500),
(620501, 620500, '市辖区', 620501),
(620502, 620500, '秦州区', 620502),
(620503, 620500, '麦积区', 620503),
(620521, 620500, '清水县', 620521),
(620522, 620500, '秦安县', 620522),
(620523, 620500, '甘谷县', 620523),
(620524, 620500, '武山县', 620524),
(620525, 620500, '张家川县', 620525),
(620600, 620000, '武威市', 620600),
(620601, 620600, '市辖区', 620601),
(620602, 620600, '凉州区', 620602),
(620621, 620600, '民勤县', 620621),
(620622, 620600, '古浪县', 620622),
(620623, 620600, '天祝县', 620623),
(620700, 620000, '张掖市', 620700),
(620701, 620700, '市辖区', 620701),
(620702, 620700, '甘州区', 620702),
(620721, 620700, '肃南裕固族自治县', 620721),
(620722, 620700, '民乐县', 620722),
(620723, 620700, '临泽县', 620723),
(620724, 620700, '高台县', 620724),
(620725, 620700, '山丹县', 620725),
(620800, 620000, '平凉市', 620800),
(620801, 620800, '市辖区', 620801),
(620802, 620800, '崆峒区', 620802),
(620821, 620800, '泾川县', 620821),
(620822, 620800, '灵台县', 620822),
(620823, 620800, '崇信县', 620823),
(620824, 620800, '华亭县', 620824),
(620825, 620800, '庄浪县', 620825),
(620826, 620800, '静宁县', 620826),
(620900, 620000, '酒泉市', 620900),
(620901, 620900, '市辖区', 620901),
(620902, 620900, '肃州区', 620902),
(620921, 620900, '金塔县', 620921),
(620922, 620900, '瓜州县', 620922),
(620923, 620900, '肃北蒙古族自治县', 620923),
(620924, 620900, '阿克塞县', 620924),
(620981, 620900, '玉门市', 620981),
(620982, 620900, '敦煌市', 620982),
(621000, 620000, '庆阳市', 621000),
(621001, 621000, '市辖区', 621001),
(621002, 621000, '西峰区', 621002),
(621021, 621000, '庆城县', 621021),
(621022, 621000, '环县', 621022),
(621023, 621000, '华池县', 621023),
(621024, 621000, '合水县', 621024),
(621025, 621000, '正宁县', 621025),
(621026, 621000, '宁县', 621026),
(621027, 621000, '镇原县', 621027),
(621100, 620000, '定西市', 621100),
(621101, 621100, '市辖区', 621101),
(621102, 621100, '安定区', 621102),
(621121, 621100, '通渭县', 621121),
(621122, 621100, '陇西县', 621122),
(621123, 621100, '渭源县', 621123),
(621124, 621100, '临洮县', 621124),
(621125, 621100, '漳县', 621125),
(621126, 621100, '岷县', 621126),
(621200, 620000, '陇南市', 621200),
(621201, 621200, '市辖区', 621201),
(621202, 621200, '武都区', 621202),
(621221, 621200, '成县', 621221),
(621222, 621200, '文县', 621222),
(621223, 621200, '宕昌县', 621223),
(621224, 621200, '康县', 621224),
(621225, 621200, '西和县', 621225),
(621226, 621200, '礼县', 621226),
(621227, 621200, '徽县', 621227),
(621228, 621200, '两当县', 621228),
(622900, 620000, '临夏州', 622900),
(622901, 622900, '临夏市', 622901),
(622921, 622900, '临夏县', 622921),
(622922, 622900, '康乐县', 622922),
(622923, 622900, '永靖县', 622923),
(622924, 622900, '广河县', 622924),
(622925, 622900, '和政县', 622925),
(622926, 622900, '东乡族自治县', 622926),
(622927, 622900, '积石山县', 622927),
(623000, 620000, '甘南州', 623000),
(623001, 623000, '合作市', 623001),
(623021, 623000, '临潭县', 623021),
(623022, 623000, '卓尼县', 623022),
(623023, 623000, '舟曲县', 623023),
(623024, 623000, '迭部县', 623024),
(623025, 623000, '玛曲县', 623025),
(623026, 623000, '碌曲县', 623026),
(623027, 623000, '夏河县', 623027),
(630000, 0, '青海省', 630000),
(630100, 630000, '西宁市', 630100),
(630101, 630100, '市辖区', 630101),
(630102, 630100, '城东区', 630102),
(630103, 630100, '城中区', 630103),
(630104, 630100, '城西区', 630104),
(630105, 630100, '城北区', 630105),
(630121, 630100, '大通回族土族自治县', 630121),
(630122, 630100, '湟中县', 630122),
(630123, 630100, '湟源县', 630123),
(632100, 630000, '海东地区', 632100),
(632121, 632100, '平安县', 632121),
(632122, 632100, '民和县', 632122),
(632123, 632100, '乐都县', 632123),
(632126, 632100, '互助县', 632126),
(632127, 632100, '化隆回族自治县', 632127),
(632128, 632100, '循化县', 632128),
(632200, 630000, '海北州', 632200),
(632221, 632200, '门源县', 632221),
(632222, 632200, '祁连县', 632222),
(632223, 632200, '海晏县', 632223),
(632224, 632200, '刚察县', 632224),
(632300, 630000, '黄南州', 632300),
(632321, 632300, '同仁县', 632321),
(632322, 632300, '尖扎县', 632322),
(632323, 632300, '泽库县', 632323),
(632324, 632300, '河南县', 632324),
(632500, 630000, '海南州', 632500),
(632521, 632500, '共和县', 632521),
(632522, 632500, '同德县', 632522),
(632523, 632500, '贵德县', 632523),
(632524, 632500, '兴海县', 632524),
(632525, 632500, '贵南县', 632525),
(632600, 630000, '果洛州', 632600),
(632621, 632600, '玛沁县', 632621),
(632622, 632600, '班玛县', 632622),
(632623, 632600, '甘德县', 632623),
(632624, 632600, '达日县', 632624),
(632625, 632600, '久治县', 632625),
(632626, 632600, '玛多县', 632626),
(632700, 630000, '玉树州', 632700),
(632721, 632700, '玉树县', 632721),
(632722, 632700, '杂多县', 632722),
(632723, 632700, '称多县', 632723),
(632724, 632700, '治多县', 632724),
(632725, 632700, '囊谦县', 632725),
(632726, 632700, '曲麻莱县', 632726),
(632800, 630000, '海西州', 632800),
(632801, 632800, '格尔木市', 632801),
(632802, 632800, '德令哈市', 632802),
(632821, 632800, '乌兰县', 632821),
(632822, 632800, '都兰县', 632822),
(632823, 632800, '天峻县', 632823),
(640000, 0, '宁夏回族自治区', 640000),
(640100, 640000, '银川市', 640100),
(640101, 640100, '市辖区', 640101),
(640104, 640100, '兴庆区', 640104),
(640105, 640100, '西夏区', 640105),
(640106, 640100, '金凤区', 640106),
(640121, 640100, '永宁县', 640121),
(640122, 640100, '贺兰县', 640122),
(640181, 640100, '灵武市', 640181),
(640200, 640000, '石嘴山市', 640200),
(640201, 640200, '市辖区', 640201),
(640202, 640200, '大武口区', 640202),
(640205, 640200, '惠农区', 640205),
(640221, 640200, '平罗县', 640221),
(640300, 640000, '吴忠市', 640300),
(640301, 640300, '市辖区', 640301),
(640302, 640300, '利通区', 640302),
(640323, 640300, '盐池县', 640323),
(640324, 640300, '同心县', 640324),
(640381, 640300, '青铜峡市', 640381),
(640400, 640000, '固原市', 640400),
(640401, 640400, '市辖区', 640401),
(640402, 640400, '原州区', 640402),
(640422, 640400, '西吉县', 640422),
(640423, 640400, '隆德县', 640423),
(640424, 640400, '泾源县', 640424),
(640425, 640400, '彭阳县', 640425),
(640500, 640000, '中卫市', 640500),
(640501, 640500, '市辖区', 640501),
(640502, 640500, '沙坡头区', 640502),
(640521, 640500, '中宁县', 640521),
(640522, 640500, '海原县', 640522),
(650000, 0, '新疆维吾尔自治区', 650000),
(650100, 650000, '乌鲁木齐市', 650100),
(650101, 650100, '市辖区', 650101),
(650102, 650100, '天山区', 650102),
(650103, 650100, '沙依巴克区', 650103),
(650104, 650100, '新市区', 650104),
(650105, 650100, '水磨沟区', 650105),
(650106, 650100, '头屯河区', 650106),
(650107, 650100, '达坂城区', 650107),
(650108, 650100, '东山区', 650108),
(650121, 650100, '乌鲁木齐县', 650121),
(650200, 650000, '克拉玛依市', 650200),
(650201, 650200, '市辖区', 650201),
(650202, 650200, '独山子区', 650202),
(650203, 650200, '克拉玛依区', 650203),
(650204, 650200, '白碱滩区', 650204),
(650205, 650200, '乌尔禾区', 650205),
(652100, 650000, '吐鲁番地区', 652100),
(652101, 652100, '吐鲁番市', 652101),
(652122, 652100, '鄯善县', 652122),
(652123, 652100, '托克逊县', 652123),
(652200, 650000, '哈密地区', 652200),
(652201, 652200, '哈密市', 652201),
(652222, 652200, '巴里坤县', 652222),
(652223, 652200, '伊吾县', 652223),
(652300, 650000, '昌吉州', 652300),
(652301, 652300, '昌吉市', 652301),
(652302, 652300, '阜康市', 652302),
(652303, 652300, '米泉市', 652303),
(652323, 652300, '呼图壁县', 652323),
(652324, 652300, '玛纳斯', 652324),
(652325, 652300, '奇台县', 652325),
(652327, 652300, '吉木萨尔县', 652327),
(652328, 652300, '木垒县', 652328),
(652700, 650000, '博尔塔拉蒙古自治州', 652700),
(652701, 652700, '博乐市', 652701),
(652722, 652700, '精河县', 652722),
(652723, 652700, '温泉县', 652723),
(652800, 650000, '巴音郭楞蒙古自治州', 652800),
(652801, 652800, '库尔勒市', 652801),
(652822, 652800, '轮台县', 652822),
(652823, 652800, '尉犁县', 652823),
(652824, 652800, '若羌县', 652824),
(652825, 652800, '且末县', 652825),
(652826, 652800, '焉耆县', 652826),
(652827, 652800, '和静县', 652827),
(652828, 652800, '和硕县', 652828),
(652829, 652800, '博湖县', 652829),
(652900, 650000, '阿克苏地区', 652900),
(652901, 652900, '阿克苏市', 652901),
(652922, 652900, '温宿县', 652922),
(652923, 652900, '库车县', 652923),
(652924, 652900, '沙雅县', 652924),
(652925, 652900, '新和县', 652925),
(652926, 652900, '拜城县', 652926),
(652927, 652900, '乌什县', 652927),
(652928, 652900, '阿瓦提县', 652928),
(652929, 652900, '柯坪县', 652929),
(653000, 650000, '克州', 653000),
(653001, 653000, '阿图什市', 653001),
(653022, 653000, '阿克陶县', 653022),
(653023, 653000, '阿合奇县', 653023),
(653024, 653000, '乌恰县', 653024),
(653100, 650000, '喀什地区', 653100),
(653101, 653100, '喀什市', 653101),
(653121, 653100, '疏附县', 653121),
(653122, 653100, '疏勒县', 653122),
(653123, 653100, '英吉沙县', 653123),
(653124, 653100, '泽普县', 653124),
(653125, 653100, '莎车县', 653125),
(653126, 653100, '叶城县', 653126),
(653127, 653100, '麦盖提县', 653127),
(653128, 653100, '岳普湖县', 653128),
(653129, 653100, '伽师县', 653129),
(653130, 653100, '巴楚县', 653130),
(653131, 653100, '塔什库尔干县', 653131),
(653200, 650000, '和田地区', 653200),
(653201, 653200, '和田市', 653201),
(653221, 653200, '和田县', 653221),
(653222, 653200, '墨玉县', 653222),
(653223, 653200, '皮山县', 653223),
(653224, 653200, '洛浦县', 653224),
(653225, 653200, '策勒县', 653225),
(653226, 653200, '于田县', 653226),
(653227, 653200, '民丰县', 653227),
(654000, 650000, '伊犁州', 654000),
(654002, 654000, '伊宁市', 654002),
(654003, 654000, '奎屯市', 654003),
(654021, 654000, '伊宁县', 654021),
(654022, 654000, '察布查尔县', 654022),
(654023, 654000, '霍城县', 654023),
(654024, 654000, '巩留县', 654024),
(654025, 654000, '新源县', 654025),
(654026, 654000, '昭苏县', 654026),
(654027, 654000, '特克斯县', 654027),
(654028, 654000, '尼勒克县', 654028),
(654200, 650000, '塔城地区', 654200),
(654201, 654200, '塔城市', 654201),
(654202, 654200, '乌苏市', 654202),
(654221, 654200, '额敏县', 654221),
(654223, 654200, '沙湾县', 654223),
(654224, 654200, '托里县', 654224),
(654225, 654200, '裕民县', 654225),
(654226, 654200, '和布克赛尔蒙古自治县', 654226),
(654300, 650000, '阿勒泰地区', 654300),
(654301, 654300, '阿勒泰市', 654301),
(654321, 654300, '布尔津县', 654321),
(654322, 654300, '富蕴县', 654322),
(654323, 654300, '福海县', 654323),
(654324, 654300, '哈巴河县', 654324),
(654325, 654300, '青河县', 654325),
(654326, 654300, '吉木乃县', 654326),
(659000, 650000, '省直辖行政单位', 659000),
(659001, 659000, '石河子市', 659001),
(659002, 659000, '阿拉尔市', 659002),
(659003, 659000, '图木舒克市', 659003),
(659004, 659000, '五家渠市', 659004),
(710000, 0, '台湾省', 710000),
(810000, 0, '香港特别行政区', 810000),
(820000, 0, '澳门特别行政区', 820000),
(110101001, 110101, '东华门街道', 110101001),
(110101002, 110101, '景山街道', 110101002),
(110101003, 110101, '交道口街道', 110101003),
(110101004, 110101, '安定门街道', 110101004),
(110101005, 110101, '北新桥街道', 110101005),
(110101006, 110101, '东四街道', 110101006),
(110101007, 110101, '朝阳门街道', 110101007),
(110101008, 110101, '建国门街道', 110101008),
(110101009, 110101, '东直门街道', 110101009),
(110101010, 110101, '和平里街道', 110101010),
(110102001, 110102, '西长安街街道', 110102001),
(110102003, 110102, '新街口街道', 110102003),
(110102007, 110102, '月坛街道', 110102007),
(110102009, 110102, '展览路街道', 110102009),
(110102010, 110102, '德胜街道', 110102010),
(110102011, 110102, '金融街街道', 110102011),
(110102012, 110102, '什刹海街道', 110102012),
(110103001, 110103, '前门街道', 110103001),
(110103002, 110103, '崇文门外街道', 110103002),
(110103003, 110103, '东花市街道', 110103003),
(110103004, 110103, '龙潭街道', 110103004),
(110103005, 110103, '体育馆路街道', 110103005),
(110103006, 110103, '天坛街道', 110103006),
(110103007, 110103, '永定门外街道', 110103007),
(110104001, 110104, '大栅栏街道', 110104001),
(110104002, 110104, '天桥街道', 110104002),
(110104003, 110104, '椿树街道', 110104003),
(110104004, 110104, '陶然亭街道', 110104004),
(110104005, 110104, '广安门内街道', 110104005),
(110104006, 110104, '牛街街道', 110104006),
(110104007, 110104, '白纸坊街道', 110104007),
(110104008, 110104, '广安门外街道', 110104008),
(110105001, 110105, '建外街道', 110105001),
(110105002, 110105, '朝外街道', 110105002),
(110105003, 110105, '呼家楼街道', 110105003),
(110105004, 110105, '三里屯街道', 110105004),
(110105005, 110105, '左家庄街道', 110105005),
(110105006, 110105, '香河园街道', 110105006),
(110105007, 110105, '和平街街道', 110105007),
(110105008, 110105, '安贞街道', 110105008),
(110105009, 110105, '亚运村街道', 110105009),
(110105010, 110105, '小关街道', 110105010),
(110105011, 110105, '酒仙桥街道', 110105011),
(110105012, 110105, '麦子店街道', 110105012),
(110105013, 110105, '团结湖街道', 110105013),
(110105014, 110105, '六里屯街道', 110105014),
(110105015, 110105, '八里庄街道', 110105015),
(110105016, 110105, '双井街道', 110105016),
(110105017, 110105, '劲松街道', 110105017),
(110105018, 110105, '潘家园街道', 110105018),
(110105019, 110105, '垡头街道', 110105019),
(110105021, 110105, '南磨房地区', 110105021),
(110105022, 110105, '高碑店地区', 110105022),
(110105023, 110105, '将台地区', 110105023),
(110105024, 110105, '太阳宫地区', 110105024),
(110105025, 110105, '大屯街道', 110105025),
(110105026, 110105, '望京街道', 110105026),
(110105027, 110105, '小红门地区', 110105027),
(110105028, 110105, '十八里店地区', 110105028),
(110105029, 110105, '平房地区', 110105029),
(110105030, 110105, '东风地区', 110105030),
(110105031, 110105, '奥运村地区', 110105031),
(110105032, 110105, '来广营地区', 110105032),
(110105033, 110105, '常营回族地区', 110105033),
(110105034, 110105, '三间房地区', 110105034),
(110105035, 110105, '管庄地区', 110105035),
(110105036, 110105, '金盏地区', 110105036),
(110105037, 110105, '孙河地区', 110105037),
(110105038, 110105, '崔各庄地区', 110105038),
(110105039, 110105, '东坝地区', 110105039),
(110105040, 110105, '黑庄户地区', 110105040),
(110105041, 110105, '豆各庄地区', 110105041),
(110105042, 110105, '王四营地区', 110105042),
(110105400, 110105, '首都机场街道', 110105400),
(110105501, 110105, '望京开发街道', 110105501),
(110106001, 110106, '右安门街道', 110106001),
(110106002, 110106, '太平桥街道', 110106002),
(110106003, 110106, '西罗园街道', 110106003),
(110106004, 110106, '大红门街道', 110106004),
(110106005, 110106, '南苑街道', 110106005),
(110106006, 110106, '东高地街道', 110106006),
(110106007, 110106, '东铁匠营街道', 110106007),
(110106008, 110106, '卢沟桥街道', 110106008),
(110106009, 110106, '丰台街道', 110106009),
(110106010, 110106, '新村街道', 110106010),
(110106011, 110106, '长辛店街道', 110106011),
(110106012, 110106, '云岗街道', 110106012),
(110106013, 110106, '方庄地区', 110106013),
(110106014, 110106, '宛平城地区', 110106014),
(110106015, 110106, '马家堡街道', 110106015),
(110106016, 110106, '和义街道', 110106016),
(110106100, 110106, '长辛店镇', 110106100),
(110106101, 110106, '王佐镇', 110106101),
(110106201, 110106, '卢沟桥乡', 110106201),
(110106202, 110106, '花乡', 110106202),
(110106203, 110106, '南苑乡', 110106203),
(110107001, 110107, '八宝山街道', 110107001),
(110107002, 110107, '老山街道', 110107002),
(110107003, 110107, '八角街道', 110107003),
(110107004, 110107, '古城街道', 110107004),
(110107005, 110107, '苹果园街道', 110107005),
(110107006, 110107, '金顶街街道', 110107006),
(110107009, 110107, '广宁街道', 110107009),
(110107010, 110107, '五里坨街道', 110107010),
(110107011, 110107, '鲁谷社区行政事务管理中心', 110107011),
(110108001, 110108, '万寿路街道', 110108001),
(110108002, 110108, '永定路街道', 110108002),
(110108003, 110108, '羊坊店街道', 110108003),
(110108004, 110108, '甘家口街道', 110108004),
(110108005, 110108, '八里庄街道', 110108005),
(110108006, 110108, '紫竹院街道', 110108006),
(110108007, 110108, '北下关街道', 110108007),
(110108008, 110108, '北太平庄街道', 110108008),
(110108010, 110108, '学院路街道', 110108010),
(110108011, 110108, '中关村街道', 110108011),
(110108012, 110108, '海淀街道', 110108012),
(110108013, 110108, '青龙桥街道', 110108013),
(110108014, 110108, '清华园街道', 110108014),
(110108015, 110108, '燕园街道', 110108015),
(110108016, 110108, '香山街道', 110108016),
(110108017, 110108, '清河街道', 110108017),
(110108018, 110108, '花园路街道', 110108018),
(110108019, 110108, '西三旗街道', 110108019),
(110108020, 110108, '马连洼街道', 110108020),
(110108021, 110108, '田村路街道', 110108021),
(110108022, 110108, '上地街道', 110108022),
(110108023, 110108, '万柳地区', 110108023),
(110108024, 110108, '东升地区', 110108024),
(110108025, 110108, '曙光街道', 110108025),
(110108101, 110108, '温泉镇', 110108101),
(110108102, 110108, '四季青镇', 110108102),
(110108103, 110108, '西北旺镇', 110108103),
(110108104, 110108, '苏家坨镇', 110108104),
(110108105, 110108, '上庄镇', 110108105),
(110109001, 110109, '大峪街道', 110109001),
(110109002, 110109, '城子街道', 110109002),
(110109003, 110109, '东辛房街道', 110109003),
(110109004, 110109, '大台街道', 110109004),
(110109005, 110109, '王平地区', 110109005),
(110109101, 110109, '潭柘寺镇', 110109101),
(110109102, 110109, '永定镇', 110109102),
(110109103, 110109, '龙泉镇', 110109103),
(110109104, 110109, '军庄镇', 110109104),
(110109105, 110109, '雁翅镇', 110109105),
(110109106, 110109, '斋堂镇', 110109106),
(110109107, 110109, '清水镇', 110109107),
(110109108, 110109, '妙峰山镇', 110109108),
(110111001, 110111, '城关街道', 110111001),
(110111002, 110111, '新镇街道', 110111002),
(110111004, 110111, '向阳街道', 110111004),
(110111005, 110111, '东风街道', 110111005),
(110111006, 110111, '迎风街道', 110111006),
(110111007, 110111, '星城街道', 110111007),
(110111008, 110111, '良乡地区', 110111008),
(110111009, 110111, '周口店地区', 110111009),
(110111010, 110111, '琉璃河地区', 110111010),
(110111011, 110111, '拱辰街道', 110111011),
(110111012, 110111, '西潞街道', 110111012),
(110111101, 110111, '阎村镇', 110111101),
(110111103, 110111, '窦店镇', 110111103),
(110111104, 110111, '石楼镇', 110111104),
(110111105, 110111, '长阳镇', 110111105),
(110111107, 110111, '河北镇', 110111107),
(110111108, 110111, '长沟镇', 110111108),
(110111109, 110111, '大石窝镇', 110111109),
(110111110, 110111, '张坊镇', 110111110),
(110111111, 110111, '十渡镇', 110111111),
(110111112, 110111, '青龙湖镇', 110111112),
(110111115, 110111, '韩村河镇', 110111115),
(110111208, 110111, '霞云岭乡', 110111208),
(110111209, 110111, '南窖乡', 110111209),
(110111210, 110111, '佛子庄乡', 110111210),
(110111211, 110111, '大安山乡', 110111211),
(110111212, 110111, '史家营乡', 110111212),
(110111213, 110111, '蒲洼乡', 110111213),
(110112001, 110112, '中仓街道', 110112001),
(110112002, 110112, '新华街道', 110112002),
(110112003, 110112, '北苑街道', 110112003),
(110112004, 110112, '玉桥街道', 110112004),
(110112005, 110112, '永顺地区', 110112005),
(110112006, 110112, '梨园地区', 110112006),
(110112104, 110112, '宋庄镇', 110112104),
(110112105, 110112, '张家湾镇', 110112105),
(110112106, 110112, '漷县镇', 110112106),
(110112109, 110112, '马驹桥镇', 110112109),
(110112110, 110112, '西集镇', 110112110),
(110112114, 110112, '台湖镇', 110112114),
(110112117, 110112, '永乐店镇', 110112117),
(110112119, 110112, '潞城镇', 110112119),
(110112209, 110112, '于家务回族乡', 110112209),
(110113001, 110113, '胜利街道', 110113001),
(110113002, 110113, '光明街道', 110113002),
(110113003, 110113, '仁和地区', 110113003),
(110113004, 110113, '后沙峪地区', 110113004),
(110113005, 110113, '天竺地区', 110113005),
(110113006, 110113, '杨镇地区', 110113006),
(110113007, 110113, '牛栏山地区', 110113007),
(110113008, 110113, '南法信地区', 110113008),
(110113009, 110113, '马坡地区', 110113009),
(110113010, 110113, '石园街道', 110113010),
(110113101, 110113, '高丽营镇', 110113101),
(110113104, 110113, '李桥镇', 110113104),
(110113105, 110113, '李遂镇', 110113105),
(110113106, 110113, '南彩镇', 110113106),
(110113108, 110113, '北务镇', 110113108),
(110113109, 110113, '大孙各庄镇', 110113109),
(110113110, 110113, '张镇', 110113110),
(110113111, 110113, '龙湾屯镇', 110113111),
(110113112, 110113, '木林镇', 110113112),
(110113113, 110113, '北小营镇', 110113113),
(110113115, 110113, '北石槽镇', 110113115),
(110113116, 110113, '赵全营镇', 110113116),
(110114001, 110114, '城北街道', 110114001),
(110114002, 110114, '南口地区', 110114002),
(110114003, 110114, '马池口地区', 110114003),
(110114004, 110114, '沙河地区', 110114004),
(110114005, 110114, '城南街道', 110114005),
(110114006, 110114, '回龙观地区', 110114006),
(110114007, 110114, '东小口地区', 110114007),
(110114104, 110114, '阳坊镇', 110114104),
(110114110, 110114, '小汤山镇', 110114110),
(110114111, 110114, '南邵镇', 110114111),
(110114112, 110114, '崔村镇', 110114112),
(110114113, 110114, '百善镇', 110114113),
(110114115, 110114, '北七家镇', 110114115),
(110114116, 110114, '兴寿镇', 110114116),
(110114117, 110114, '长陵镇', 110114117),
(110114118, 110114, '流村镇', 110114118),
(110114119, 110114, '十三陵镇', 110114119),
(110115001, 110115, '兴丰街道', 110115001),
(110115002, 110115, '林校路街道', 110115002),
(110115003, 110115, '清源街道', 110115003),
(110115004, 110115, '亦庄地区', 110115004),
(110115005, 110115, '黄村地区', 110115005),
(110115006, 110115, '旧宫地区', 110115006),
(110115007, 110115, '西红门地区', 110115007),
(110115103, 110115, '青云店镇', 110115103),
(110115104, 110115, '采育镇', 110115104),
(110115105, 110115, '安定镇', 110115105),
(110115106, 110115, '礼贤镇', 110115106),
(110115107, 110115, '榆垡镇', 110115107),
(110115108, 110115, '庞各庄镇', 110115108),
(110115109, 110115, '北臧村镇', 110115109),
(110115110, 110115, '魏善庄镇', 110115110),
(110115111, 110115, '长子营镇', 110115111),
(110115112, 110115, '瀛海镇', 110115112),
(110115403, 110115, '亦庄开发区', 110115403),
(110116001, 110116, '泉河街道', 110116001),
(110116002, 110116, '龙山街道', 110116002),
(110116003, 110116, '怀柔地区', 110116003),
(110116004, 110116, '雁栖地区', 110116004),
(110116005, 110116, '庙城地区', 110116005),
(110116102, 110116, '北房镇', 110116102),
(110116103, 110116, '杨宋镇', 110116103),
(110116105, 110116, '桥梓镇', 110116105),
(110116106, 110116, '怀北镇', 110116106),
(110116107, 110116, '汤河口镇', 110116107),
(110116108, 110116, '渤海镇', 110116108),
(110116109, 110116, '九渡河镇', 110116109),
(110116110, 110116, '琉璃庙镇', 110116110),
(110116111, 110116, '宝山镇', 110116111),
(110116211, 110116, '长哨营满族乡', 110116211),
(110116213, 110116, '喇叭沟门满族乡', 110116213),
(110117001, 110117, '滨河街道', 110117001),
(110117002, 110117, '兴谷街道', 110117002),
(110117003, 110117, '渔阳地区', 110117003),
(110117004, 110117, '峪口地区', 110117004),
(110117005, 110117, '马坊地区', 110117005),
(110117006, 110117, '金海湖地区', 110117006),
(110117101, 110117, '东高村镇', 110117101),
(110117102, 110117, '山东庄镇', 110117102),
(110117104, 110117, '南独乐河镇', 110117104),
(110117105, 110117, '大华山镇', 110117105),
(110117106, 110117, '夏各庄镇', 110117106),
(110117108, 110117, '马昌营镇', 110117108),
(110117110, 110117, '王辛庄镇', 110117110),
(110117111, 110117, '大兴庄镇', 110117111),
(110117112, 110117, '刘家店镇', 110117112),
(110117114, 110117, '镇罗营镇', 110117114),
(110117213, 110117, '黄松峪乡', 110117213),
(110117214, 110117, '熊儿寨乡', 110117214),
(110228001, 110228, '鼓楼街道', 110228001),
(110228002, 110228, '果园街道', 110228002),
(110228003, 110228, '檀营地区', 110228003),
(110228100, 110228, '密云镇', 110228100),
(110228101, 110228, '溪翁庄镇', 110228101),
(110228102, 110228, '西田各庄镇', 110228102),
(110228103, 110228, '十里堡镇', 110228103),
(110228104, 110228, '河南寨镇', 110228104),
(110228105, 110228, '巨各庄镇', 110228105),
(110228106, 110228, '穆家峪镇', 110228106),
(110228107, 110228, '太师屯镇', 110228107),
(110228108, 110228, '高岭镇', 110228108),
(110228109, 110228, '不老屯镇', 110228109),
(110228110, 110228, '冯家峪镇', 110228110),
(110228111, 110228, '古北口镇', 110228111),
(110228112, 110228, '大城子镇', 110228112),
(110228113, 110228, '东邵渠镇', 110228113),
(110228114, 110228, '北庄镇', 110228114),
(110228115, 110228, '新城子镇', 110228115),
(110228116, 110228, '石城镇', 110228116),
(110229100, 110229, '延庆镇', 110229100),
(110229101, 110229, '康庄镇', 110229101),
(110229102, 110229, '八达岭镇', 110229102),
(110229103, 110229, '永宁镇', 110229103),
(110229104, 110229, '旧县镇', 110229104),
(110229105, 110229, '张山营镇', 110229105),
(110229106, 110229, '四海镇', 110229106),
(110229107, 110229, '千家店镇', 110229107),
(110229108, 110229, '沈家营镇', 110229108),
(110229109, 110229, '大榆树镇', 110229109),
(110229110, 110229, '井庄镇', 110229110),
(110229207, 110229, '大庄科乡', 110229207),
(110229209, 110229, '刘斌堡乡', 110229209),
(110229210, 110229, '香营乡', 110229210),
(110229214, 110229, '珍珠泉乡', 110229214),
(120101001, 120101, '劝业场街道', 120101001),
(120101002, 120101, '小白楼街道', 120101002),
(120101003, 120101, '体育馆街道', 120101003),
(120101004, 120101, '新兴街道', 120101004),
(120101005, 120101, '南营门社区街道', 120101005),
(120101006, 120101, '南市街道', 120101006),
(120102001, 120102, '大王庄街道', 120102001),
(120102002, 120102, '大直沽街道', 120102002),
(120102003, 120102, '中山门街道', 120102003),
(120102004, 120102, '富民路街道', 120102004),
(120102005, 120102, '二号桥街道', 120102005),
(120102006, 120102, '春华街道', 120102006),
(120102007, 120102, '唐家口街道', 120102007),
(120102008, 120102, '向阳楼街道', 120102008),
(120102009, 120102, '常州道街道', 120102009),
(120102010, 120102, '上杭路街道', 120102010),
(120102011, 120102, '东新街道', 120102011),
(120102012, 120102, '鲁山道街道', 120102012),
(120102013, 120102, '天津铁厂街道', 120102013),
(120103001, 120103, '大营门街道', 120103001),
(120103002, 120103, '下瓦房街道', 120103002),
(120103003, 120103, '桃园街道', 120103003),
(120103004, 120103, '挂甲寺街道', 120103004),
(120103005, 120103, '马场街道', 120103005),
(120103006, 120103, '越秀路街道', 120103006),
(120103007, 120103, '友谊路街道', 120103007),
(120103008, 120103, '天塔街道', 120103008),
(120103009, 120103, '尖山街道', 120103009),
(120103010, 120103, '陈塘庄街道', 120103010),
(120103011, 120103, '柳林街道', 120103011),
(120103012, 120103, '东海街道', 120103012),
(120103400, 120103, '梅江虚拟街道', 120103400),
(120104001, 120104, '长虹街道', 120104001),
(120104002, 120104, '鼓楼街道', 120104002),
(120104003, 120104, '兴南街道', 120104003),
(120104004, 120104, '广开街道', 120104004),
(120104005, 120104, '万兴街道', 120104005),
(120104006, 120104, '学府街道', 120104006),
(120104007, 120104, '向阳路街道', 120104007),
(120104008, 120104, '嘉陵道街道', 120104008),
(120104009, 120104, '王顶堤街道', 120104009),
(120104010, 120104, '水上公园街道', 120104010),
(120104011, 120104, '体育中心街道', 120104011),
(120104012, 120104, '华苑街道', 120104012),
(120105001, 120105, '光复道街道', 120105001),
(120105002, 120105, '望海楼街道', 120105002),
(120105003, 120105, '鸿顺里街道', 120105003),
(120105004, 120105, '新开河街道', 120105004),
(120105005, 120105, '铁东路街道', 120105005),
(120105006, 120105, '建昌道街道', 120105006),
(120105007, 120105, '宁园街道', 120105007),
(120105008, 120105, '王串场街道', 120105008);
INSERT INTO `{pre}areas` VALUES
(120105009, 120105, '江都路街道', 120105009),
(120105010, 120105, '月牙河街道', 120105010),
(120106001, 120106, '西于庄街道', 120106001),
(120106002, 120106, '双环村街道', 120106002),
(120106003, 120106, '咸阳北路街道', 120106003),
(120106004, 120106, '丁字沽街道', 120106004),
(120106005, 120106, '西沽街道', 120106005),
(120106006, 120106, '三条石街道', 120106006),
(120106008, 120106, '邵公庄街道', 120106008),
(120106009, 120106, '芥园街道', 120106009),
(120106010, 120106, '铃铛阁街道', 120106010),
(120106011, 120106, '大胡同街道', 120106011),
(120107001, 120107, '新村街道', 120107001),
(120107002, 120107, '解放路街道', 120107002),
(120107003, 120107, '三槐路街道', 120107003),
(120107004, 120107, '新港街道', 120107004),
(120107005, 120107, '向阳街道', 120107005),
(120107006, 120107, '杭州道街道', 120107006),
(120107007, 120107, '新河街道', 120107007),
(120107008, 120107, '大沽街道', 120107008),
(120107009, 120107, '北塘街道', 120107009),
(120107010, 120107, '渤海石油街道', 120107010),
(120107011, 120107, '胡家园街道', 120107011),
(120107100, 120107, '新城镇', 120107100),
(120107400, 120107, '开发区虚拟街道', 120107400),
(120107401, 120107, '保税区虚拟街道', 120107401),
(120108001, 120108, '汉沽街道', 120108001),
(120108002, 120108, '寨上街道', 120108002),
(120108003, 120108, '河西街道', 120108003),
(120108005, 120108, '盐场街道', 120108005),
(120108100, 120108, '大田镇', 120108100),
(120108101, 120108, '杨家泊镇', 120108101),
(120108102, 120108, '茶淀镇', 120108102),
(120108103, 120108, '营城镇', 120108103),
(120108400, 120108, '开发区汉沽化工小区虚拟街道', 120108400),
(120109001, 120109, '迎宾街道', 120109001),
(120109002, 120109, '胜利街道', 120109002),
(120109003, 120109, '古林街道', 120109003),
(120109004, 120109, '海滨街道', 120109004),
(120109005, 120109, '港西街道', 120109005),
(120109100, 120109, '太平镇', 120109100),
(120109101, 120109, '小王庄镇', 120109101),
(120109102, 120109, '中塘镇', 120109102),
(120109450, 120109, '北大港农场虚拟镇', 120109450),
(120110001, 120110, '张贵庄街道', 120110001),
(120110002, 120110, '丰年村街道', 120110002),
(120110003, 120110, '万新街道', 120110003),
(120110004, 120110, '无瑕街道', 120110004),
(120110005, 120110, '新立街道', 120110005),
(120110006, 120110, '华明街道', 120110006),
(120110102, 120110, '军粮城镇', 120110102),
(120110105, 120110, '大毕庄镇', 120110105),
(120110200, 120110, '么六桥乡', 120110200),
(120110400, 120110, '开发区西区虚拟街道', 120110400),
(120110401, 120110, '保税区空港国际物流区虚拟街道', 120110401),
(120110402, 120110, '保税区空港国际物流加工区虚拟街道', 120110402),
(120110403, 120110, '东丽区开发区虚拟街道', 120110403),
(120110404, 120110, '东丽湖虚拟街道', 120110404),
(120111001, 120111, '西营门街道', 120111001),
(120111002, 120111, '李七庄街道', 120111002),
(120111100, 120111, '中北镇', 120111100),
(120111101, 120111, '杨柳青镇', 120111101),
(120111102, 120111, '辛口镇', 120111102),
(120111103, 120111, '张家窝镇', 120111103),
(120111104, 120111, '南河镇', 120111104),
(120111105, 120111, '大寺镇', 120111105),
(120111106, 120111, '王稳庄镇', 120111106),
(120111400, 120111, '开发区西青微电子小区虚拟街道', 120111400),
(120111401, 120111, '新技术产业园区虚拟街', 120111401),
(120111450, 120111, '西青区开发区虚拟街道', 120111450),
(120112100, 120112, '咸水沽镇', 120112100),
(120112101, 120112, '葛沽镇', 120112101),
(120112102, 120112, '小站镇', 120112102),
(120112103, 120112, '双港镇', 120112103),
(120112104, 120112, '辛庄镇', 120112104),
(120112106, 120112, '双桥河镇', 120112106),
(120112107, 120112, '八里台镇', 120112107),
(120112108, 120112, '北闸口镇', 120112108),
(120112400, 120112, '双林农场虚拟街', 120112400),
(120112401, 120112, '铁路十八局虚拟街', 120112401),
(120112402, 120112, '津南国家农业园区虚拟街', 120112402),
(120112403, 120112, '长青办事处虚拟街', 120112403),
(120112404, 120112, '津南开发区东区虚拟居街', 120112404),
(120112405, 120112, '津南开发区西区虚拟居街', 120112405),
(120113001, 120113, '果园新村街道', 120113001),
(120113002, 120113, '集贤里街道', 120113002),
(120113003, 120113, '普东街道', 120113003),
(120113004, 120113, '佳荣里街道', 120113004),
(120113100, 120113, '天穆镇', 120113100),
(120113101, 120113, '北仓镇', 120113101),
(120113102, 120113, '双街镇', 120113102),
(120113103, 120113, '双口镇', 120113103),
(120113104, 120113, '青光镇', 120113104),
(120113106, 120113, '宜兴埠镇', 120113106),
(120113107, 120113, '小淀镇', 120113107),
(120113108, 120113, '大张庄镇', 120113108),
(120113111, 120113, '西堤头镇', 120113111),
(120113451, 120113, '红旗农场', 120113451),
(120113452, 120113, '曙光农场', 120113452),
(120114001, 120114, '杨村街道', 120114001),
(120114002, 120114, '下朱庄街道', 120114002),
(120114003, 120114, '东蒲洼街道', 120114003),
(120114004, 120114, '黄庄街道', 120114004),
(120114005, 120114, '徐官屯街道', 120114005),
(120114006, 120114, '运河西街道', 120114006),
(120114101, 120114, '梅厂镇', 120114101),
(120114102, 120114, '大碱厂镇', 120114102),
(120114103, 120114, '崔黄口镇', 120114103),
(120114104, 120114, '大良镇', 120114104),
(120114105, 120114, '下伍旗镇', 120114105),
(120114106, 120114, '南蔡村镇', 120114106),
(120114107, 120114, '大孟庄镇', 120114107),
(120114108, 120114, '泗村店镇', 120114108),
(120114109, 120114, '河西务镇', 120114109),
(120114110, 120114, '城关镇', 120114110),
(120114111, 120114, '东马圈镇', 120114111),
(120114112, 120114, '黄花店镇', 120114112),
(120114113, 120114, '石各庄镇', 120114113),
(120114114, 120114, '王庆坨镇', 120114114),
(120114115, 120114, '汊沽港镇', 120114115),
(120114116, 120114, '河北屯镇', 120114116),
(120114117, 120114, '上马台镇', 120114117),
(120114118, 120114, '大王古庄镇', 120114118),
(120114119, 120114, '陈咀镇', 120114119),
(120114203, 120114, '豆张庄乡', 120114203),
(120114206, 120114, '曹子里乡', 120114206),
(120114207, 120114, '大黄堡乡', 120114207),
(120114213, 120114, '高村乡', 120114213),
(120114214, 120114, '白古屯乡', 120114214),
(120114400, 120114, '开发区武清逸仙园小区虚拟街道', 120114400),
(120114401, 120114, '武清区开发区虚拟街道', 120114401),
(120114450, 120114, '武清农场虚拟镇', 120114450),
(120115001, 120115, '海滨街道', 120115001),
(120115002, 120115, '宝平街道', 120115002),
(120115003, 120115, '钰华街道', 120115003),
(120115101, 120115, '大口屯镇', 120115101),
(120115102, 120115, '大白庄镇', 120115102),
(120115103, 120115, '王卜庄镇', 120115103),
(120115104, 120115, '方家庄镇', 120115104),
(120115105, 120115, '林亭口镇', 120115105),
(120115106, 120115, '八门城镇', 120115106),
(120115107, 120115, '大钟庄镇', 120115107),
(120115108, 120115, '新安镇', 120115108),
(120115110, 120115, '马家店镇', 120115110),
(120115111, 120115, '霍各庄镇', 120115111),
(120115113, 120115, '新开口镇', 120115113),
(120115115, 120115, '大唐庄镇', 120115115),
(120115117, 120115, '高家庄镇', 120115117),
(120115118, 120115, '口东镇', 120115118),
(120115119, 120115, '牛道口镇', 120115119),
(120115120, 120115, '史各庄镇', 120115120),
(120115121, 120115, '郝各庄镇', 120115121),
(120115122, 120115, '周良庄镇', 120115122),
(120115204, 120115, '牛家牌乡', 120115204),
(120115207, 120115, '尔王庄乡', 120115207),
(120115210, 120115, '黄庄乡', 120115210),
(120115450, 120115, '里自沽农场虚拟镇', 120115450),
(120115451, 120115, '黄庄农场虚拟镇', 120115451),
(120115452, 120115, '大钟农场虚拟镇', 120115452),
(120115453, 120115, '天宝工业园区虚拟街', 120115453),
(120115454, 120115, '九园工业园区虚拟街', 120115454),
(120115455, 120115, '京津新城虚拟街', 120115455),
(120221100, 120221, '芦台镇', 120221100),
(120221102, 120221, '宁河镇', 120221102),
(120221103, 120221, '苗庄镇', 120221103),
(120221104, 120221, '丰台镇', 120221104),
(120221105, 120221, '岳龙镇', 120221105),
(120221106, 120221, '板桥镇', 120221106),
(120221107, 120221, '潘庄镇', 120221107),
(120221109, 120221, '造甲城镇', 120221109),
(120221110, 120221, '七里海镇', 120221110),
(120221111, 120221, '大北涧沽镇', 120221111),
(120221112, 120221, '东棘坨镇', 120221112),
(120221204, 120221, '北淮淀乡', 120221204),
(120221205, 120221, '俵口乡', 120221205),
(120221206, 120221, '廉庄子乡', 120221206),
(120221450, 120221, '潘庄农场虚拟镇', 120221450),
(120223100, 120223, '静海镇', 120223100),
(120223101, 120223, '唐官屯镇', 120223101),
(120223102, 120223, '独流镇', 120223102),
(120223103, 120223, '王口镇', 120223103),
(120223104, 120223, '台头镇', 120223104),
(120223105, 120223, '子牙镇', 120223105),
(120223106, 120223, '陈官屯镇', 120223106),
(120223107, 120223, '中旺镇', 120223107),
(120223108, 120223, '大邱庄镇', 120223108),
(120223109, 120223, '蔡公庄镇', 120223109),
(120223110, 120223, '梁头镇', 120223110),
(120223111, 120223, '团泊镇', 120223111),
(120223112, 120223, '双塘镇', 120223112),
(120223113, 120223, '大丰堆镇', 120223113),
(120223114, 120223, '沿庄镇', 120223114),
(120223115, 120223, '西翟庄镇', 120223115),
(120223200, 120223, '良王庄乡', 120223200),
(120223201, 120223, '杨成庄乡', 120223201),
(120223400, 120223, '天津静海经济开发区虚拟街', 120223400),
(120223402, 120223, '天津子牙工业园区虚拟街', 120223402),
(120223403, 120223, '中国石油天然气总公司地调一处虚拟街', 120223403),
(120225001, 120225, '文昌街道', 120225001),
(120225100, 120225, '城关镇', 120225100),
(120225101, 120225, '洇溜镇', 120225101),
(120225102, 120225, '官庄镇', 120225102),
(120225103, 120225, '马伸桥镇', 120225103),
(120225104, 120225, '下营镇', 120225104),
(120225105, 120225, '邦均镇', 120225105),
(120225106, 120225, '别山镇', 120225106),
(120225108, 120225, '尤古庄镇', 120225108),
(120225109, 120225, '上仓镇', 120225109),
(120225111, 120225, '下仓镇', 120225111),
(120225112, 120225, '罗庄子镇', 120225112),
(120225113, 120225, '白涧镇', 120225113),
(120225114, 120225, '五百户镇', 120225114),
(120225115, 120225, '侯家营镇', 120225115),
(120225116, 120225, '桑梓镇', 120225116),
(120225117, 120225, '东施古镇', 120225117),
(120225118, 120225, '下窝头镇', 120225118),
(120225119, 120225, '杨津庄镇', 120225119),
(120225120, 120225, '出头岭镇', 120225120),
(120225121, 120225, '西龙虎峪镇', 120225121),
(120225202, 120225, '穿芳峪乡', 120225202),
(120225203, 120225, '孙各庄乡', 120225203),
(120225208, 120225, '东二营乡', 120225208),
(120225210, 120225, '许家台乡', 120225210),
(120225212, 120225, '礼明庄乡', 120225212),
(120225219, 120225, '东赵各庄乡', 120225219),
(130102001, 130102, '建北街道', 130102001),
(130102002, 130102, '青园街道', 130102002),
(130102003, 130102, '广安街道', 130102003),
(130102004, 130102, '育才街道', 130102004),
(130102005, 130102, '跃进街道', 130102005),
(130102007, 130102, '河东街道', 130102007),
(130102010, 130102, '长丰街道', 130102010),
(130102011, 130102, '谈固街道', 130102011),
(130102100, 130102, '西兆通镇', 130102100),
(130102101, 130102, '南村镇', 130102101),
(130102102, 130102, '高营镇', 130102102),
(130103001, 130103, '中山东路街道', 130103001),
(130103002, 130103, '彭后街道', 130103002),
(130103003, 130103, '东风街道', 130103003),
(130103004, 130103, '东华街道', 130103004),
(130103005, 130103, '休门街道', 130103005),
(130103006, 130103, '阜康街道', 130103006),
(130103007, 130103, '建安街道', 130103007),
(130103008, 130103, '胜利北街道', 130103008),
(130103009, 130103, '汇通街道', 130103009),
(130103101, 130103, '桃园镇', 130103101),
(130104001, 130104, '东里街道', 130104001),
(130104002, 130104, '中山路街道', 130104002),
(130104004, 130104, '南长街道', 130104004),
(130104005, 130104, '维明街道', 130104005),
(130104006, 130104, '裕西街道', 130104006),
(130104007, 130104, '友谊街道', 130104007),
(130104008, 130104, '红旗街道', 130104008),
(130104009, 130104, '新石街道', 130104009),
(130104010, 130104, '苑东街道', 130104010),
(130104011, 130104, '西里街道', 130104011),
(130104012, 130104, '振头街道', 130104012),
(130104201, 130104, '留营乡', 130104201),
(130105001, 130105, '革新街街道', 130105001),
(130105003, 130105, '新华路街道', 130105003),
(130105004, 130105, '宁安路街道', 130105004),
(130105005, 130105, '东焦街道', 130105005),
(130105006, 130105, '西苑街道', 130105006),
(130105007, 130105, '合作路街道', 130105007),
(130105008, 130105, '联盟路街道', 130105008),
(130105009, 130105, '石岗大街街道', 130105009),
(130105010, 130105, '五七路街道', 130105010),
(130105011, 130105, '天苑街道', 130105011),
(130105012, 130105, '北苑街道', 130105012),
(130105100, 130105, '大郭镇', 130105100),
(130105101, 130105, '赵陵铺镇', 130105101),
(130105201, 130105, '西三庄乡', 130105201),
(130105202, 130105, '杜北乡', 130105202),
(130107001, 130107, '矿市街街道', 130107001),
(130107002, 130107, '四微街道', 130107002),
(130107100, 130107, '贾庄镇', 130107100),
(130107101, 130107, '凤山镇', 130107101),
(130107200, 130107, '横涧乡', 130107200),
(130108001, 130108, '裕兴街道', 130108001),
(130108002, 130108, '裕强街道', 130108002),
(130108003, 130108, '东苑街道', 130108003),
(130108004, 130108, '建通街道', 130108004),
(130108005, 130108, '槐底街道', 130108005),
(130108006, 130108, '裕华路街道', 130108006),
(130108007, 130108, '裕东街道', 130108007),
(130108010, 130108, '长江街道办事处(高新区)', 130108010),
(130108100, 130108, '宋营镇', 130108100),
(130108101, 130108, '方村镇', 130108101),
(130121100, 130121, '微水镇', 130121100),
(130121101, 130121, '上安镇', 130121101),
(130121102, 130121, '天长镇', 130121102),
(130121103, 130121, '秀林镇', 130121103),
(130121104, 130121, '南峪镇', 130121104),
(130121105, 130121, '威州镇', 130121105),
(130121106, 130121, '小作镇', 130121106),
(130121107, 130121, '南障城镇', 130121107),
(130121108, 130121, '苍岩山镇', 130121108),
(130121109, 130121, '测鱼镇', 130121109),
(130121200, 130121, '吴家窑乡', 130121200),
(130121201, 130121, '北正乡', 130121201),
(130121202, 130121, '于家乡', 130121202),
(130121203, 130121, '孙庄乡', 130121203),
(130121204, 130121, '南陉乡', 130121204),
(130121205, 130121, '辛庄乡', 130121205),
(130121206, 130121, '南王庄乡', 130121206),
(130123100, 130123, '正定镇', 130123100),
(130123101, 130123, '诸福屯镇', 130123101),
(130123102, 130123, '新城铺镇', 130123102),
(130123103, 130123, '新安镇', 130123103),
(130123200, 130123, '南牛乡', 130123200),
(130123201, 130123, '南楼乡', 130123201),
(130123202, 130123, '西平乐乡', 130123202),
(130123203, 130123, '北早现乡', 130123203),
(130123204, 130123, '曲阳桥乡', 130123204),
(130124100, 130124, '栾城镇', 130124100),
(130124101, 130124, '郄马镇', 130124101),
(130124103, 130124, '冶河镇', 130124103),
(130124104, 130124, '窦妪镇', 130124104),
(130124105, 130124, '楼底镇', 130124105),
(130124200, 130124, '南高乡', 130124200),
(130124201, 130124, '柳林屯乡', 130124201),
(130124202, 130124, '西营乡', 130124202),
(130125100, 130125, '龙州镇', 130125100),
(130125101, 130125, '南桥镇', 130125101),
(130125102, 130125, '上碑镇', 130125102),
(130125103, 130125, '口头镇', 130125103),
(130125200, 130125, '独羊岗乡', 130125200),
(130125201, 130125, '安香乡', 130125201),
(130125202, 130125, '只里乡', 130125202),
(130125203, 130125, '市同乡', 130125203),
(130125204, 130125, '翟营乡', 130125204),
(130125205, 130125, '城寨乡', 130125205),
(130125206, 130125, '上方乡', 130125206),
(130125207, 130125, '玉亭乡', 130125207),
(130125208, 130125, '北河乡', 130125208),
(130125209, 130125, '上闫庄乡', 130125209),
(130125210, 130125, '九口子乡', 130125210),
(130126100, 130126, '灵寿镇', 130126100),
(130126101, 130126, '青同镇', 130126101),
(130126102, 130126, '塔上镇', 130126102),
(130126103, 130126, '陈庄镇', 130126103),
(130126104, 130126, '慈峪镇', 130126104),
(130126105, 130126, '岔头镇', 130126105),
(130126200, 130126, '三圣院乡', 130126200),
(130126201, 130126, '北洼乡', 130126201),
(130126202, 130126, '牛城乡', 130126202),
(130126203, 130126, '狗台乡', 130126203),
(130126204, 130126, '南寨乡', 130126204),
(130126205, 130126, '南燕川乡', 130126205),
(130126206, 130126, '北谭庄乡', 130126206),
(130126207, 130126, '寨头乡', 130126207),
(130126208, 130126, '南营乡', 130126208),
(130127100, 130127, '高邑镇', 130127100),
(130127200, 130127, '大营乡', 130127200),
(130127201, 130127, '中韩乡', 130127201),
(130127202, 130127, '万城乡', 130127202),
(130127203, 130127, '西富村乡', 130127203),
(130128100, 130128, '深泽镇', 130128100),
(130128101, 130128, '铁杆镇', 130128101),
(130128200, 130128, '白庄乡', 130128200),
(130128201, 130128, '留村乡', 130128201),
(130128202, 130128, '赵八乡', 130128202),
(130128203, 130128, '桥头乡', 130128203),
(130129100, 130129, '赞皇镇', 130129100),
(130129101, 130129, '院头镇', 130129101),
(130129200, 130129, '西龙门乡', 130129200),
(130129201, 130129, '南邢郭乡', 130129201),
(130129202, 130129, '南清河乡', 130129202),
(130129203, 130129, '西阳泽乡', 130129203),
(130129204, 130129, '土门乡', 130129204),
(130129205, 130129, '黄北坪乡', 130129205),
(130129206, 130129, '嶂石岩乡', 130129206),
(130129207, 130129, '许亭乡', 130129207),
(130129208, 130129, '张楞乡', 130129208),
(130130100, 130130, '无极镇', 130130100),
(130130101, 130130, '七汲镇', 130130101),
(130130102, 130130, '张段固镇', 130130102),
(130130103, 130130, '北苏镇', 130130103),
(130130104, 130130, '郭庄镇', 130130104),
(130130105, 130130, '大陈镇', 130130105),
(130130200, 130130, '高头乡', 130130200),
(130130201, 130130, '郝庄乡', 130130201),
(130130202, 130130, '东侯坊乡', 130130202),
(130130203, 130130, '里城道乡', 130130203),
(130130204, 130130, '南流乡', 130130204),
(130131100, 130131, '平山镇', 130131100),
(130131101, 130131, '东回舍镇', 130131101),
(130131102, 130131, '温塘镇', 130131102),
(130131103, 130131, '南甸镇', 130131103),
(130131104, 130131, '岗南镇', 130131104),
(130131105, 130131, '中古月镇', 130131105),
(130131106, 130131, '下槐镇', 130131106),
(130131107, 130131, '孟家庄镇', 130131107),
(130131108, 130131, '小觉镇', 130131108),
(130131109, 130131, '蛟潭庄镇', 130131109),
(130131110, 130131, '西柏坡镇', 130131110),
(130131111, 130131, '下口镇', 130131111),
(130131200, 130131, '西大吾乡', 130131200),
(130131201, 130131, '上三汲乡', 130131201),
(130131202, 130131, '两河乡', 130131202),
(130131203, 130131, '东王坡乡', 130131203),
(130131204, 130131, '苏家庄乡', 130131204),
(130131205, 130131, '宅北乡', 130131205),
(130131207, 130131, '北冶乡', 130131207),
(130131209, 130131, '上观音堂乡', 130131209),
(130131210, 130131, '杨家桥乡', 130131210),
(130131211, 130131, '营里乡', 130131211),
(130131212, 130131, '合河口乡', 130131212),
(130132100, 130132, '槐阳镇', 130132100),
(130132101, 130132, '因村镇', 130132101),
(130132102, 130132, '南佐镇', 130132102),
(130132103, 130132, '宋曹镇', 130132103),
(130132104, 130132, '南因镇', 130132104),
(130132105, 130132, '姬村镇', 130132105),
(130132200, 130132, '马村乡', 130132200),
(130132201, 130132, '东张乡', 130132201),
(130132202, 130132, '赵同乡', 130132202),
(130132203, 130132, '北褚乡', 130132203),
(130132204, 130132, '苏村乡', 130132204),
(130132205, 130132, '苏阳乡', 130132205),
(130132206, 130132, '北正乡', 130132206),
(130132207, 130132, '前仙乡', 130132207),
(130132208, 130132, '黑水河乡', 130132208),
(130133100, 130133, '赵州镇', 130133100),
(130133101, 130133, '范庄镇', 130133101),
(130133102, 130133, '北王里镇', 130133102),
(130133103, 130133, '新寨店镇', 130133103),
(130133104, 130133, '韩村镇', 130133104),
(130133105, 130133, '南柏舍镇', 130133105),
(130133106, 130133, '沙河店镇', 130133106),
(130133200, 130133, '前大章乡', 130133200),
(130133201, 130133, '谢庄乡', 130133201),
(130133202, 130133, '高村乡', 130133202),
(130133203, 130133, '王西章乡', 130133203),
(130181100, 130181, '辛集镇', 130181100),
(130181101, 130181, '旧城镇', 130181101),
(130181102, 130181, '张古庄镇', 130181102),
(130181103, 130181, '位伯镇', 130181103),
(130181104, 130181, '新垒头镇', 130181104),
(130181105, 130181, '新城镇', 130181105),
(130181106, 130181, '南智丘镇', 130181106),
(130181107, 130181, '王口镇', 130181107),
(130181200, 130181, '天宫营乡', 130181200),
(130181201, 130181, '前营乡', 130181201),
(130181202, 130181, '马庄乡', 130181202),
(130181203, 130181, '和睦井乡', 130181203),
(130181204, 130181, '田家庄乡', 130181204),
(130181205, 130181, '中里厢乡', 130181205),
(130181206, 130181, '小辛庄乡', 130181206),
(130182100, 130182, '廉州镇', 130182100),
(130182101, 130182, '兴安镇', 130182101),
(130182102, 130182, '贾市庄镇', 130182102),
(130182103, 130182, '南营镇', 130182103),
(130182104, 130182, '梅花镇', 130182104),
(130182105, 130182, '岗上镇', 130182105),
(130182106, 130182, '邱头镇', 130182106),
(130182107, 130182, '南董镇', 130182107),
(130182108, 130182, '张家庄镇', 130182108),
(130182109, 130182, '南孟镇', 130182109),
(130182110, 130182, '增村镇', 130182110),
(130182111, 130182, '小常安镇', 130182111),
(130182112, 130182, '前西关镇', 130182112),
(130182200, 130182, '九门回族乡', 130182200),
(130182500, 130182, '石家庄经济技术开发区虚拟乡', 130182500),
(130183100, 130183, '晋州镇', 130183100),
(130183101, 130183, '总十庄镇', 130183101),
(130183102, 130183, '营里镇', 130183102),
(130183103, 130183, '桃园镇', 130183103),
(130183104, 130183, '东卓宿镇', 130183104),
(130183105, 130183, '马于镇', 130183105),
(130183106, 130183, '小樵镇', 130183106),
(130183107, 130183, '槐树镇', 130183107),
(130183200, 130183, '东里庄乡', 130183200),
(130183201, 130183, '周家庄乡', 130183201),
(130184001, 130184, '长寿街道', 130184001),
(130184101, 130184, '化皮镇', 130184101),
(130184102, 130184, '承安镇', 130184102),
(130184103, 130184, '正莫镇', 130184103),
(130184104, 130184, '南大岳镇', 130184104),
(130184105, 130184, '杜固镇', 130184105),
(130184106, 130184, '邯邰镇', 130184106),
(130184107, 130184, '东王镇', 130184107),
(130184108, 130184, '马头铺镇', 130184108),
(130184200, 130184, '协神乡', 130184200),
(130184201, 130184, '木村乡', 130184201),
(130184202, 130184, '彭家庄乡', 130184202),
(130185100, 130185, '获鹿镇', 130185100),
(130185101, 130185, '铜冶镇', 130185101),
(130185102, 130185, '寺家庄镇', 130185102),
(130185103, 130185, '上庄镇', 130185103),
(130185104, 130185, '李村镇', 130185104),
(130185105, 130185, '宜安镇', 130185105),
(130185106, 130185, '黄壁庄镇', 130185106),
(130185107, 130185, '大河镇', 130185107),
(130185200, 130185, '石井乡', 130185200),
(130185201, 130185, '白鹿泉乡', 130185201),
(130185202, 130185, '上寨乡', 130185202),
(130185203, 130185, '山尹村乡', 130185203),
(130185500, 130185, '高新技术产业园区虚拟乡', 130185500),
(130202001, 130202, '学院南路', 130202001),
(130202002, 130202, '友谊', 130202002),
(130202003, 130202, '广场', 130202003),
(130202004, 130202, '永红桥街道', 130202004),
(130202005, 130202, '小山街道', 130202005),
(130202006, 130202, '文北', 130202006),
(130202007, 130202, '钱营', 130202007),
(130202100, 130202, '芦台开发区海北镇', 130202100),
(130202101, 130202, '汉沽管理区汉丰镇', 130202101),
(130202200, 130202, '女织寨乡', 130202200),
(130202450, 130202, '芦台开发区街道', 130202450),
(130202451, 130202, '汉沽管理区兴农', 130202451),
(130202452, 130202, '汉沽管理区振兴街道', 130202452),
(130203001, 130203, '乔屯街道', 130203001),
(130203002, 130203, '文化路街道', 130203002),
(130203003, 130203, '钓鱼台街道', 130203003),
(130203004, 130203, '东新村街道', 130203004),
(130203005, 130203, '缸窑街道', 130203005),
(130203006, 130203, '机场路街道', 130203006),
(130203007, 130203, '河北路街道', 130203007),
(130203008, 130203, '龙东街道', 130203008),
(130203009, 130203, '大里街道', 130203009),
(130203010, 130203, '光明街道', 130203010),
(130203200, 130203, '果园乡', 130203200),
(130203450, 130203, '河北唐山高新技术产业园区', 130203450),
(130204001, 130204, '林西街道', 130204001),
(130204002, 130204, '唐家庄街道', 130204002),
(130204003, 130204, '古冶街道', 130204003),
(130204004, 130204, '赵各庄街道', 130204004),
(130204005, 130204, '吕家坨街道', 130204005),
(130204006, 130204, '南范各庄街道', 130204006),
(130204200, 130204, '卑家店乡', 130204200),
(130204201, 130204, '王辇庄乡', 130204201),
(130204202, 130204, '习家套乡', 130204202),
(130204203, 130204, '大庄坨乡', 130204203),
(130204204, 130204, '范各庄乡', 130204204),
(130205001, 130205, '马家沟', 130205001),
(130205002, 130205, '开平', 130205002),
(130205003, 130205, '税务庄', 130205003),
(130205005, 130205, '陡电', 130205005),
(130205006, 130205, '荆各庄', 130205006),
(130205100, 130205, '开平镇', 130205100),
(130205101, 130205, '栗园镇', 130205101),
(130205200, 130205, '越河乡', 130205200),
(130205201, 130205, '双桥乡', 130205201),
(130205202, 130205, '郑庄子乡', 130205202),
(130205203, 130205, '洼里乡', 130205203),
(130207102, 130207, '稻地镇', 130207102),
(130207103, 130207, '小集镇', 130207103),
(130207104, 130207, '黄各庄镇', 130207104),
(130207105, 130207, '西葛镇', 130207105),
(130207106, 130207, '大新庄镇', 130207106),
(130207107, 130207, '钱营镇', 130207107),
(130207108, 130207, '唐坊镇', 130207108),
(130207109, 130207, '王兰庄镇', 130207109),
(130207110, 130207, '柳树酄镇', 130207110),
(130207111, 130207, '黑沿子镇', 130207111),
(130207112, 130207, '滨海镇', 130207112),
(130207113, 130207, '丰南镇', 130207113),
(130207114, 130207, '大齐镇', 130207114),
(130207201, 130207, '南孙庄乡', 130207201),
(130207202, 130207, '东田庄乡', 130207202),
(130207203, 130207, '尖字沽乡', 130207203),
(130207450, 130207, '河北唐山南堡经济开发区', 130207450),
(130208001, 130208, '太平路', 130208001),
(130208002, 130208, '燕山路', 130208002),
(130208003, 130208, '浭阳', 130208003),
(130208100, 130208, '丰润镇', 130208100),
(130208101, 130208, '老庄子镇', 130208101),
(130208102, 130208, '任各庄镇', 130208102),
(130208103, 130208, '左家坞镇', 130208103),
(130208104, 130208, '泉河头镇', 130208104),
(130208105, 130208, '王官营镇', 130208105),
(130208106, 130208, '火石营镇', 130208106),
(130208107, 130208, '韩城镇', 130208107),
(130208108, 130208, '岔河镇', 130208108),
(130208109, 130208, '新军屯镇', 130208109),
(130208110, 130208, '小张各庄镇', 130208110),
(130208111, 130208, '丰登坞镇', 130208111),
(130208112, 130208, '李钊庄镇', 130208112),
(130208113, 130208, '白官屯镇', 130208113),
(130208114, 130208, '石各庄镇', 130208114),
(130208115, 130208, '沙流河镇', 130208115),
(130208116, 130208, '七树庄镇', 130208116),
(130208117, 130208, '杨官林镇', 130208117),
(130208202, 130208, '姜家营乡', 130208202),
(130208205, 130208, '欢喜庄乡', 130208205),
(130208207, 130208, '银城铺乡', 130208207),
(130208208, 130208, '刘家营乡', 130208208),
(130208209, 130208, '常庄乡', 130208209),
(130223001, 130223, '城区街道', 130223001),
(130223100, 130223, '滦州镇', 130223100),
(130223101, 130223, '响堂镇', 130223101),
(130223102, 130223, '东安各庄镇', 130223102),
(130223103, 130223, '雷庄镇', 130223103),
(130223104, 130223, '茨榆坨镇', 130223104),
(130223105, 130223, '榛子镇', 130223105),
(130223106, 130223, '杨柳庄镇', 130223106),
(130223107, 130223, '油榨镇', 130223107),
(130223108, 130223, '古马镇', 130223108),
(130223109, 130223, '小马庄镇', 130223109),
(130223110, 130223, '九百户镇', 130223110),
(130223111, 130223, '王店子镇', 130223111),
(130224001, 130224, '奔城街道', 130224001),
(130224100, 130224, '奔城镇', 130224100),
(130224101, 130224, '宋道口镇', 130224101),
(130224102, 130224, '长凝镇', 130224102),
(130224103, 130224, '胡各庄镇', 130224103),
(130224104, 130224, '坨里镇', 130224104),
(130224105, 130224, '姚王庄镇', 130224105),
(130224106, 130224, '司各庄镇', 130224106),
(130224107, 130224, '安各庄镇', 130224107),
(130224108, 130224, '扒齿港镇', 130224108),
(130224109, 130224, '程庄镇', 130224109),
(130224110, 130224, '青坨营镇', 130224110),
(130224111, 130224, '柏各庄镇', 130224111),
(130224113, 130224, '柳赞镇', 130224113),
(130224114, 130224, '南堡镇', 130224114),
(130224115, 130224, '方各庄镇', 130224115),
(130224116, 130224, '东黄坨镇', 130224116),
(130224117, 130224, '马城镇', 130224117),
(130225001, 130225, '城区街道', 130225001),
(130225100, 130225, '乐亭镇', 130225100),
(130225101, 130225, '汤家河镇', 130225101),
(130225102, 130225, '胡家坨镇', 130225102),
(130225103, 130225, '王滩镇', 130225103),
(130225104, 130225, '闫各庄镇', 130225104),
(130225105, 130225, '马头营镇', 130225105),
(130225106, 130225, '新寨镇', 130225106),
(130225107, 130225, '汀流河镇', 130225107),
(130225108, 130225, '姜各庄镇', 130225108),
(130225200, 130225, '毛庄乡', 130225200),
(130225201, 130225, '庞各庄乡', 130225201),
(130225202, 130225, '大相各庄乡', 130225202),
(130225203, 130225, '古河乡', 130225203),
(130225204, 130225, '中堡王庄乡', 130225204),
(130225450, 130225, '长芦大清河盐场', 130225450),
(130225451, 130225, '海港区', 130225451),
(130227001, 130227, '栗乡街道', 130227001),
(130227100, 130227, '兴城镇', 130227100),
(130227101, 130227, '金厂峪镇', 130227101),
(130227102, 130227, '洒河桥镇', 130227102),
(130227103, 130227, '太平寨镇', 130227103),
(130227104, 130227, '罗家屯镇', 130227104),
(130227105, 130227, '东荒峪镇', 130227105),
(130227106, 130227, '新集镇', 130227106),
(130227107, 130227, '三屯营镇', 130227107),
(130227108, 130227, '滦阳镇', 130227108),
(130227200, 130227, '白庙子乡', 130227200),
(130227201, 130227, '上营乡', 130227201),
(130227202, 130227, '汉儿庄乡', 130227202),
(130227203, 130227, '渔户寨乡', 130227203),
(130227204, 130227, '旧城乡', 130227204),
(130227205, 130227, '尹庄乡', 130227205),
(130227206, 130227, '东莲花院乡', 130227206),
(130227207, 130227, '新庄子乡', 130227207),
(130229100, 130229, '玉田镇', 130229100),
(130229101, 130229, '亮甲店镇', 130229101),
(130229102, 130229, '鸦鸿桥镇', 130229102),
(130229103, 130229, '窝洛沽镇', 130229103),
(130229104, 130229, '石臼窝镇', 130229104),
(130229105, 130229, '虹桥镇', 130229105),
(130229106, 130229, '散水头镇', 130229106),
(130229107, 130229, '林南仓镇', 130229107),
(130229108, 130229, '林西镇', 130229108),
(130229109, 130229, '杨家板桥镇', 130229109),
(130229110, 130229, '彩亭桥镇', 130229110),
(130229111, 130229, '孤树镇', 130229111),
(130229112, 130229, '大安镇', 130229112),
(130229113, 130229, '唐自头镇', 130229113),
(130229200, 130229, '郭家屯乡', 130229200),
(130229201, 130229, '林头屯乡', 130229201),
(130229202, 130229, '杨家套乡', 130229202),
(130229203, 130229, '潮洛窝乡', 130229203),
(130229204, 130229, '陈家铺乡', 130229204),
(130229205, 130229, '郭家桥乡', 130229205),
(130230100, 130230, '唐海镇', 130230100),
(130230401, 130230, '一农场', 130230401),
(130230403, 130230, '三农场', 130230403),
(130230404, 130230, '四农场', 130230404),
(130230405, 130230, '五农场', 130230405),
(130230406, 130230, '六农场', 130230406),
(130230407, 130230, '七农场', 130230407),
(130230408, 130230, '八农场', 130230408),
(130230409, 130230, '九农场', 130230409),
(130230410, 130230, '十农场', 130230410),
(130230411, 130230, '十一农场', 130230411),
(130230412, 130230, '八里滩养殖场', 130230412),
(130230413, 130230, '十里海养殖场', 130230413),
(130230451, 130230, '曹妃甸工业区', 130230451),
(130281001, 130281, '路南街道', 130281001),
(130281002, 130281, '路北街道', 130281002),
(130281100, 130281, '遵化镇', 130281100),
(130281101, 130281, '堡子店镇', 130281101),
(130281102, 130281, '马兰峪镇', 130281102),
(130281103, 130281, '平安城镇', 130281103),
(130281104, 130281, '东新庄镇', 130281104),
(130281105, 130281, '新店子镇', 130281105),
(130281106, 130281, '党峪镇', 130281106),
(130281107, 130281, '地北头镇', 130281107),
(130281108, 130281, '东旧寨镇', 130281108),
(130281109, 130281, '铁厂镇', 130281109),
(130281110, 130281, '苏家洼镇', 130281110),
(130281111, 130281, '建明镇', 130281111),
(130281112, 130281, '石门镇', 130281112),
(130281200, 130281, '西留村乡', 130281200),
(130281201, 130281, '崔家庄乡', 130281201),
(130281202, 130281, '兴旺寨乡', 130281202),
(130281203, 130281, '西下营满族乡', 130281203),
(130281204, 130281, '汤泉满族乡', 130281204),
(130281205, 130281, '东陵满族乡', 130281205),
(130281206, 130281, '刘备寨乡', 130281206),
(130281207, 130281, '团瓢庄乡', 130281207),
(130281208, 130281, '娘娘庄乡', 130281208),
(130281209, 130281, '西三里乡', 130281209),
(130281210, 130281, '候家寨乡', 130281210),
(130281211, 130281, '小厂乡', 130281211),
(130283100, 130283, '迁安镇', 130283100),
(130283101, 130283, '夏官营镇', 130283101),
(130283102, 130283, '杨各庄镇', 130283102),
(130283103, 130283, '建昌营镇', 130283103),
(130283104, 130283, '赵店子镇', 130283104),
(130283105, 130283, '野鸡坨镇', 130283105),
(130283106, 130283, '大崔庄镇', 130283106),
(130283107, 130283, '杨店子镇', 130283107),
(130283108, 130283, '蔡园镇', 130283108),
(130283109, 130283, '马兰庄镇', 130283109),
(130283110, 130283, '沙河驿镇', 130283110),
(130283111, 130283, '木厂口镇', 130283111),
(130283200, 130283, '扣庄乡', 130283200),
(130283201, 130283, '彭店子乡', 130283201),
(130283202, 130283, '上射雁庄乡', 130283202),
(130283203, 130283, '闫家店乡', 130283203),
(130283204, 130283, '五重安乡', 130283204),
(130283205, 130283, '大五里乡', 130283205),
(130283206, 130283, '太平庄乡', 130283206),
(130302001, 130302, '文化路街道', 130302001),
(130302002, 130302, '海滨路街道', 130302002),
(130302003, 130302, '北环路街道', 130302003),
(130302004, 130302, '建设大街街道', 130302004),
(130302005, 130302, '河东街道', 130302005),
(130302006, 130302, '西港路街道', 130302006),
(130302007, 130302, '燕山大街街道', 130302007),
(130302008, 130302, '港城大街街道', 130302008),
(130302009, 130302, '东环路街道', 130302009),
(130302010, 130302, '白塔岭街道', 130302010),
(130302011, 130302, '秦皇岛经济技术开发区珠江道街道', 130302011),
(130302100, 130302, '东港镇', 130302100),
(130302101, 130302, '海港镇', 130302101),
(130302102, 130302, '西港镇', 130302102),
(130302103, 130302, '海阳镇', 130302103),
(130302104, 130302, '北港镇', 130302104),
(130302450, 130302, '秦皇岛经济技术开发区', 130302450),
(130303001, 130303, '南关街道', 130303001),
(130303002, 130303, '东街街道', 130303002),
(130303003, 130303, '西街街道', 130303003),
(130303004, 130303, '路南街道', 130303004),
(130303005, 130303, '船厂路街道', 130303005),
(130303100, 130303, '第一关镇', 130303100),
(130303101, 130303, '石河镇', 130303101),
(130303102, 130303, '孟姜镇', 130303102),
(130303200, 130303, '渤海乡', 130303200),
(130304001, 130304, '西山街道', 130304001),
(130304002, 130304, '东山街道', 130304002),
(130304100, 130304, '海滨镇', 130304100),
(130304101, 130304, '戴河镇', 130304101),
(130321100, 130321, '青龙镇', 130321100),
(130321101, 130321, '祖山镇', 130321101),
(130321102, 130321, '木头凳镇', 130321102),
(130321103, 130321, '双山子镇', 130321103),
(130321104, 130321, '马圈子镇', 130321104),
(130321105, 130321, '肖营子镇', 130321105),
(130321200, 130321, '凤凰山乡', 130321200),
(130321201, 130321, '龙王庙乡', 130321201),
(130321202, 130321, '三星口乡', 130321202),
(130321203, 130321, '干沟乡', 130321203),
(130321204, 130321, '大巫岚乡', 130321204),
(130321205, 130321, '土门子乡', 130321205),
(130321206, 130321, '大石岭乡', 130321206),
(130321207, 130321, '隔河头乡', 130321207),
(130321208, 130321, '官场乡', 130321208),
(130321209, 130321, '茨榆山乡', 130321209),
(130321210, 130321, '平方子乡', 130321210),
(130321211, 130321, '安子岭乡', 130321211),
(130321212, 130321, '朱杖子乡', 130321212),
(130321213, 130321, '草碾乡', 130321213),
(130321214, 130321, '七道河乡', 130321214),
(130321215, 130321, '八道河乡', 130321215),
(130321216, 130321, '娄杖子乡', 130321216),
(130321217, 130321, '三拨子乡', 130321217),
(130321218, 130321, '凉水河乡', 130321218),
(130322100, 130322, '昌黎镇', 130322100),
(130322101, 130322, '靖安镇', 130322101),
(130322102, 130322, '安山镇', 130322102),
(130322103, 130322, '龙家店镇', 130322103),
(130322104, 130322, '泥井镇', 130322104),
(130322105, 130322, '大蒲河镇', 130322105),
(130322106, 130322, '新集镇', 130322106),
(130322107, 130322, '刘台庄镇', 130322107),
(130322108, 130322, '茹荷镇', 130322108),
(130322109, 130322, '朱各庄镇', 130322109),
(130322201, 130322, '团林乡', 130322201),
(130322202, 130322, '葛条港乡', 130322202),
(130322203, 130322, '马坨店乡', 130322203),
(130322204, 130322, '荒佃庄乡', 130322204),
(130322206, 130322, '两山乡', 130322206),
(130322207, 130322, '十里铺乡', 130322207),
(130323100, 130323, '抚宁镇', 130323100),
(130323101, 130323, '留守营镇', 130323101),
(130323102, 130323, '榆关镇', 130323102),
(130323103, 130323, '牛头崖镇', 130323103),
(130323104, 130323, '石门寨镇', 130323104),
(130323105, 130323, '台营镇', 130323105),
(130323106, 130323, '大新寨镇', 130323106),
(130323107, 130323, '驻操营镇', 130323107),
(130323200, 130323, '茶棚乡', 130323200),
(130323201, 130323, '杜庄乡', 130323201),
(130323202, 130323, '深河乡', 130323202),
(130324100, 130324, '卢龙镇', 130324100),
(130324101, 130324, '潘庄镇', 130324101),
(130324102, 130324, '燕河营镇', 130324102),
(130324103, 130324, '双望镇', 130324103),
(130324104, 130324, '刘田各庄镇', 130324104),
(130324105, 130324, '石门镇', 130324105),
(130324200, 130324, '下寨乡', 130324200),
(130324201, 130324, '刘家营乡', 130324201),
(130324202, 130324, '陈官屯乡', 130324202),
(130324203, 130324, '印庄乡', 130324203),
(130324204, 130324, '蛤泊乡', 130324204),
(130324205, 130324, '木井乡', 130324205),
(130402001, 130402, '火磨街道', 130402001),
(130402002, 130402, '陵园路街道', 130402002),
(130402003, 130402, '光明路街道', 130402003),
(130402004, 130402, '滏东街道', 130402004),
(130402005, 130402, '罗城头街道', 130402005),
(130402006, 130402, '渚河路街道', 130402006),
(130402007, 130402, '浴新南街道', 130402007),
(130402008, 130402, '农林路街道', 130402008),
(130402009, 130402, '贸东街道', 130402009),
(130402010, 130402, '贸西街道', 130402010),
(130402100, 130402, '马头镇', 130402100),
(130402101, 130402, '北张庄镇', 130402101),
(130402200, 130402, '马庄乡', 130402200),
(130403001, 130403, '丛台西街道', 130403001),
(130403002, 130403, '联纺西街道', 130403002),
(130403003, 130403, '联纺东街道', 130403003),
(130403004, 130403, '光明桥街道', 130403004),
(130403005, 130403, '丛台东街道', 130403005),
(130403006, 130403, '四季青街道', 130403006),
(130403007, 130403, '和平街道', 130403007),
(130403008, 130403, '中华街道', 130403008),
(130403009, 130403, '人民路街道', 130403009),
(130403010, 130403, '柳林桥街道', 130403010),
(130403200, 130403, '苏曹乡', 130403200),
(130404001, 130404, '胜利桥街道', 130404001),
(130404002, 130404, '百家村街道', 130404002),
(130404003, 130404, '铁路大院街道', 130404003),
(130404004, 130404, '化林路街道', 130404004),
(130404005, 130404, '庞村街道', 130404005),
(130404006, 130404, '二六七二街道', 130404006),
(130404007, 130404, '石化街道', 130404007),
(130404200, 130404, '彭家寨乡', 130404200),
(130404400, 130404, '华北冶金建设公司', 130404400),
(130406100, 130406, '临水镇', 130406100),
(130406101, 130406, '峰峰镇', 130406101),
(130406102, 130406, '新坡镇', 130406102),
(130406103, 130406, '大社镇', 130406103),
(130406104, 130406, '和村镇', 130406104),
(130406105, 130406, '义井镇', 130406105),
(130406106, 130406, '彭城镇', 130406106),
(130406107, 130406, '界城镇', 130406107),
(130406108, 130406, '大峪镇', 130406108),
(130421100, 130421, '尚璧镇', 130421100),
(130421101, 130421, '黄粱梦镇', 130421101),
(130421102, 130421, '河沙镇镇', 130421102),
(130421104, 130421, '户村镇', 130421104),
(130421200, 130421, '南堡乡', 130421200),
(130421201, 130421, '南吕固乡', 130421201),
(130421202, 130421, '兼庄乡', 130421202),
(130421203, 130421, '代召乡', 130421203),
(130421204, 130421, '康庄乡', 130421204),
(130421205, 130421, '三陵乡', 130421205),
(130423100, 130423, '临漳镇', 130423100),
(130423101, 130423, '南东坊镇', 130423101),
(130423102, 130423, '孙陶集镇', 130423102),
(130423103, 130423, '柳园镇', 130423103),
(130423104, 130423, '称勾集镇', 130423104),
(130423200, 130423, '狄邱乡', 130423200),
(130423201, 130423, '张村集乡', 130423201),
(130423202, 130423, '西羊羔乡', 130423202),
(130423203, 130423, '香菜营乡', 130423203),
(130423204, 130423, '杜村集乡', 130423204),
(130423205, 130423, '章里集乡', 130423205),
(130423206, 130423, '习文乡', 130423206),
(130423207, 130423, '砖寨营乡', 130423207),
(130423208, 130423, '柏鹤集乡', 130423208),
(130424100, 130424, '成安镇', 130424100),
(130424101, 130424, '商城镇', 130424101),
(130424102, 130424, '漳河店镇', 130424102),
(130424103, 130424, '李家疃镇', 130424103),
(130424200, 130424, '辛义乡', 130424200),
(130424201, 130424, '柏寺营乡', 130424201),
(130424202, 130424, '道东堡乡', 130424202),
(130424203, 130424, '北乡义乡', 130424203),
(130424204, 130424, '长巷乡', 130424204),
(130425100, 130425, '大名镇', 130425100),
(130425101, 130425, '杨桥镇', 130425101),
(130425102, 130425, '万堤镇', 130425102),
(130425103, 130425, '龙王庙镇', 130425103),
(130425104, 130425, '束馆镇', 130425104),
(130425105, 130425, '金滩镇', 130425105),
(130425200, 130425, '沙圪塔乡', 130425200),
(130425201, 130425, '王村乡', 130425201),
(130425202, 130425, '铺上乡', 130425202),
(130425203, 130425, '黄金堤乡', 130425203),
(130425204, 130425, '大街乡', 130425204),
(130425205, 130425, '旧治乡', 130425205),
(130425206, 130425, '西未庄乡', 130425206),
(130425207, 130425, '孙甘店乡', 130425207),
(130425208, 130425, '西付集乡', 130425208),
(130425209, 130425, '埝头乡', 130425209),
(130425210, 130425, '北峰乡', 130425210),
(130425211, 130425, '张集乡', 130425211),
(130425212, 130425, '红庙乡', 130425212),
(130425213, 130425, '营镇回族乡', 130425213),
(130426100, 130426, '涉城镇', 130426100),
(130426101, 130426, '河南店镇', 130426101),
(130426102, 130426, '索堡镇', 130426102),
(130426103, 130426, '西戌镇', 130426103),
(130426104, 130426, '井店镇', 130426104),
(130426105, 130426, '更乐镇', 130426105),
(130426106, 130426, '固新镇', 130426106),
(130426107, 130426, '西达镇', 130426107),
(130426108, 130426, '偏城镇', 130426108),
(130426200, 130426, '神头乡', 130426200),
(130426201, 130426, '辽城乡', 130426201),
(130426202, 130426, '偏店乡', 130426202),
(130426203, 130426, '龙虎乡', 130426203),
(130426204, 130426, '木井乡', 130426204),
(130426205, 130426, '关防乡', 130426205),
(130426206, 130426, '合漳乡', 130426206),
(130426207, 130426, '鹿头乡', 130426207),
(130427100, 130427, '磁州镇', 130427100),
(130427101, 130427, '高臾镇', 130427101),
(130427102, 130427, '西光禄镇', 130427102),
(130427103, 130427, '讲武城镇', 130427103),
(130427104, 130427, '岳城镇', 130427104),
(130427105, 130427, '观台镇', 130427105),
(130427106, 130427, '林坦镇', 130427106),
(130427107, 130427, '白土镇', 130427107),
(130427108, 130427, '黄沙镇', 130427108),
(130427200, 130427, '路村营乡', 130427200),
(130427201, 130427, '西固义乡', 130427201),
(130427202, 130427, '辛庄营乡', 130427202),
(130427203, 130427, '花官营乡', 130427203),
(130427204, 130427, '时村营乡', 130427204),
(130427205, 130427, '南城乡', 130427205),
(130427206, 130427, '台城乡', 130427206),
(130427207, 130427, '陶泉乡', 130427207),
(130427208, 130427, '都党乡', 130427208),
(130427209, 130427, '北贾壁乡', 130427209),
(130428100, 130428, '肥乡镇', 130428100),
(130428101, 130428, '天台山镇', 130428101),
(130428200, 130428, '大西韩乡', 130428200),
(130428201, 130428, '辛安镇乡', 130428201),
(130428202, 130428, '毛演堡乡', 130428202),
(130428203, 130428, '元固乡', 130428203),
(130428204, 130428, '屯庄营乡', 130428204),
(130428205, 130428, '东漳堡乡', 130428205),
(130428206, 130428, '旧店乡', 130428206),
(130429100, 130429, '临洺关镇', 130429100),
(130429101, 130429, '大北汪镇', 130429101),
(130429102, 130429, '张西堡镇', 130429102),
(130429103, 130429, '广府镇', 130429103),
(130429104, 130429, '南沿村镇', 130429104),
(130429105, 130429, '永合会镇', 130429105),
(130429200, 130429, '西苏乡', 130429200),
(130429201, 130429, '界河店乡', 130429201),
(130429202, 130429, '刘营乡', 130429202),
(130429203, 130429, '刘汉乡', 130429203),
(130429204, 130429, '正西乡', 130429204),
(130429205, 130429, '讲武乡', 130429205),
(130429206, 130429, '曲陌乡', 130429206),
(130429207, 130429, '辛庄堡乡', 130429207),
(130429208, 130429, '小龙马乡', 130429208),
(130429209, 130429, '东杨庄乡', 130429209),
(130429210, 130429, '小西堡乡', 130429210),
(130429211, 130429, '西河庄乡', 130429211),
(130429212, 130429, '姚寨乡', 130429212),
(130429213, 130429, '西阳城乡', 130429213),
(130430100, 130430, '新马头镇', 130430100),
(130430101, 130430, '邱城镇', 130430101),
(130430200, 130430, '梁二庄乡', 130430200),
(130430201, 130430, '南辛店乡', 130430201),
(130430202, 130430, '香城固乡', 130430202),
(130430203, 130430, '古城营乡', 130430203),
(130430204, 130430, '陈村回族乡', 130430204),
(130431100, 130431, '鸡泽镇', 130431100),
(130431101, 130431, '小寨镇', 130431101),
(130431102, 130431, '双塔镇', 130431102),
(130431200, 130431, '浮图店乡', 130431200),
(130431201, 130431, '吴官营乡', 130431201),
(130431202, 130431, '风正乡', 130431202),
(130431203, 130431, '曹庄乡', 130431203),
(130432100, 130432, '广平镇', 130432100),
(130432101, 130432, '平固店镇', 130432101),
(130432200, 130432, '双庙乡', 130432200),
(130432201, 130432, '十里铺乡', 130432201),
(130432202, 130432, '南韩村乡', 130432202),
(130432203, 130432, '南阳堡乡', 130432203),
(130432204, 130432, '东张孟乡', 130432204),
(130433100, 130433, '馆陶镇', 130433100),
(130433101, 130433, '房寨镇', 130433101),
(130433102, 130433, '柴堡镇', 130433102),
(130433103, 130433, '魏僧寨镇', 130433103),
(130433200, 130433, '寿山寺乡', 130433200),
(130433201, 130433, '王桥乡', 130433201),
(130433202, 130433, '南徐村乡', 130433202),
(130433203, 130433, '路桥乡', 130433203),
(130434100, 130434, '魏城镇', 130434100),
(130434101, 130434, '德政镇', 130434101),
(130434102, 130434, '北皋镇', 130434102),
(130434103, 130434, '双井镇', 130434103),
(130434104, 130434, '牙里镇', 130434104),
(130434105, 130434, '车往镇', 130434105),
(130434106, 130434, '回隆镇', 130434106),
(130434200, 130434, '东代固乡', 130434200),
(130434201, 130434, '棘针寨乡', 130434201),
(130434202, 130434, '沙口集乡', 130434202),
(130434203, 130434, '野胡拐乡', 130434203),
(130434204, 130434, '仕望集乡', 130434204),
(130434205, 130434, '前大磨乡', 130434205),
(130434206, 130434, '院堡乡', 130434206),
(130434207, 130434, '南双庙乡', 130434207),
(130434208, 130434, '大辛庄乡', 130434208),
(130434209, 130434, '大马村乡', 130434209),
(130434210, 130434, '边马乡', 130434210),
(130434211, 130434, '张二庄乡', 130434211),
(130434212, 130434, '北台头乡', 130434212),
(130434213, 130434, '泊口乡', 130434213),
(130435100, 130435, '曲周镇', 130435100),
(130435101, 130435, '安寨镇', 130435101),
(130435102, 130435, '侯村镇', 130435102),
(130435103, 130435, '河南疃镇', 130435103),
(130435200, 130435, '槐桥乡', 130435200),
(130435201, 130435, '南里岳乡', 130435201),
(130435202, 130435, '白寨乡', 130435202),
(130435203, 130435, '大河道乡', 130435203),
(130435204, 130435, '依庄乡', 130435204),
(130435205, 130435, '第四疃乡', 130435205),
(130481100, 130481, '武安镇', 130481100),
(130481101, 130481, '康二城镇', 130481101),
(130481102, 130481, '午汲镇', 130481102),
(130481103, 130481, '磁山镇', 130481103),
(130481104, 130481, '伯延镇', 130481104),
(130481105, 130481, '淑村镇', 130481105),
(130481106, 130481, '大同镇', 130481106),
(130481107, 130481, '邑城镇', 130481107),
(130481108, 130481, '矿山镇', 130481108),
(130481109, 130481, '贺进镇', 130481109),
(130481110, 130481, '阳邑镇', 130481110),
(130481111, 130481, '徘徊镇', 130481111),
(130481112, 130481, '冶陶镇', 130481112),
(130481200, 130481, '上团城乡', 130481200),
(130481201, 130481, '北安庄乡', 130481201),
(130481202, 130481, '北安乐乡', 130481202),
(130481203, 130481, '西土山乡', 130481203),
(130481204, 130481, '西寺庄乡', 130481204),
(130481205, 130481, '活水乡', 130481205),
(130481206, 130481, '石洞乡', 130481206),
(130481207, 130481, '管陶乡', 130481207),
(130481208, 130481, '马家庄乡', 130481208),
(130502001, 130502, '南长街街道', 130502001),
(130502002, 130502, '北大街街道', 130502002),
(130502003, 130502, '西大街街道', 130502003),
(130502004, 130502, '西门里街道', 130502004),
(130502200, 130502, '大梁庄乡', 130502200),
(130502201, 130502, '东郭村乡', 130502201),
(130502400, 130502, '市高新技术开发区', 130502400),
(130503001, 130503, '钢铁路街道', 130503001),
(130503002, 130503, '中兴路街道', 130503002),
(130503003, 130503, '达活泉街道', 130503003),
(130503004, 130503, '张宽街道', 130503004),
(130503005, 130503, '章村街道', 130503005),
(130503200, 130503, '南大郭乡', 130503200),
(130503201, 130503, '李村乡', 130503201),
(130521001, 130521, '豫让桥街道', 130521001),
(130521100, 130521, '东汪镇', 130521100),
(130521101, 130521, '王快镇', 130521101),
(130521102, 130521, '祝村镇', 130521102),
(130521103, 130521, '晏家屯镇', 130521103);
INSERT INTO `{pre}areas` VALUES
(130521104, 130521, '南石门镇', 130521104),
(130521105, 130521, '羊范镇', 130521105),
(130521106, 130521, '皇寺镇', 130521106),
(130521107, 130521, '会宁镇', 130521107),
(130521108, 130521, '西黄村镇', 130521108),
(130521109, 130521, '路罗镇', 130521109),
(130521110, 130521, '将军墓镇', 130521110),
(130521111, 130521, '浆水镇', 130521111),
(130521112, 130521, '宋家庄镇', 130521112),
(130521200, 130521, '太子井乡', 130521200),
(130521201, 130521, '龙泉寺乡', 130521201),
(130521202, 130521, '北小庄乡', 130521202),
(130521203, 130521, '城计头乡', 130521203),
(130521204, 130521, '白岸乡', 130521204),
(130521206, 130521, '冀家村乡', 130521206),
(130522100, 130522, '临城镇', 130522100),
(130522101, 130522, '东镇镇', 130522101),
(130522102, 130522, '西竖镇', 130522102),
(130522103, 130522, '郝庄镇', 130522103),
(130522200, 130522, '黑城乡', 130522200),
(130522201, 130522, '鸭鸽营乡', 130522201),
(130522203, 130522, '石城乡', 130522203),
(130522205, 130522, '赵庄乡', 130522205),
(130523100, 130523, '内邱镇', 130523100),
(130523101, 130523, '大孟村镇', 130523101),
(130523102, 130523, '金店镇', 130523102),
(130523103, 130523, '官庄镇', 130523103),
(130523104, 130523, '柳林镇', 130523104),
(130523200, 130523, '五郭店乡', 130523200),
(130523203, 130523, '南赛乡', 130523203),
(130523204, 130523, '獐么乡', 130523204),
(130523205, 130523, '侯家庄乡', 130523205),
(130524100, 130524, '柏乡镇', 130524100),
(130524101, 130524, '固城店镇', 130524101),
(130524200, 130524, '王家庄乡', 130524200),
(130524201, 130524, '西汪乡', 130524201),
(130524202, 130524, '龙华乡', 130524202),
(130524203, 130524, '内步乡', 130524203),
(130525100, 130525, '隆尧镇', 130525100),
(130525101, 130525, '魏家庄镇', 130525101),
(130525102, 130525, '尹村镇', 130525102),
(130525103, 130525, '山口镇', 130525103),
(130525104, 130525, '莲子镇', 130525104),
(130525105, 130525, '固城镇', 130525105),
(130525200, 130525, '北楼乡', 130525200),
(130525201, 130525, '东良乡', 130525201),
(130525202, 130525, '双碑乡', 130525202),
(130525203, 130525, '牛家桥乡', 130525203),
(130525204, 130525, '千户营乡', 130525204),
(130525205, 130525, '大张庄乡', 130525205),
(130525400, 130525, '柳行农场', 130525400),
(130526100, 130526, '任城镇', 130526100),
(130526101, 130526, '邢家湾镇', 130526101),
(130526102, 130526, '辛店镇', 130526102),
(130526200, 130526, '西固城乡', 130526200),
(130526201, 130526, '永福庄乡', 130526201),
(130526202, 130526, '大屯乡', 130526202),
(130526203, 130526, '天口乡', 130526203),
(130526204, 130526, '骆庄乡', 130526204),
(130527100, 130527, '和阳镇', 130527100),
(130527101, 130527, '贾宋镇', 130527101),
(130527102, 130527, '郝桥镇', 130527102),
(130527200, 130527, '东三召乡', 130527200),
(130527201, 130527, '阎里乡', 130527201),
(130527202, 130527, '河郭乡', 130527202),
(130527203, 130527, '史召乡', 130527203),
(130527204, 130527, '三思乡', 130527204),
(130528100, 130528, '凤凰镇', 130528100),
(130528101, 130528, '河渠镇', 130528101),
(130528102, 130528, '北河庄镇', 130528102),
(130528103, 130528, '耿庄桥镇', 130528103),
(130528104, 130528, '东汪镇', 130528104),
(130528105, 130528, '贾家口镇', 130528105),
(130528106, 130528, '四芝兰镇', 130528106),
(130528107, 130528, '大陆村镇', 130528107),
(130528108, 130528, '苏家庄镇', 130528108),
(130528109, 130528, '换马店镇', 130528109),
(130528200, 130528, '侯口乡', 130528200),
(130528202, 130528, '纪昌庄乡', 130528202),
(130528203, 130528, '唐邱乡', 130528203),
(130528205, 130528, '北鱼乡', 130528205),
(130528206, 130528, '徐家河乡', 130528206),
(130528207, 130528, '大曹庄乡', 130528207),
(130528400, 130528, '大曹庄管理区', 130528400),
(130529100, 130529, '巨鹿镇', 130529100),
(130529101, 130529, '王虎寨镇', 130529101),
(130529102, 130529, '西郭城镇', 130529102),
(130529103, 130529, '官亭镇', 130529103),
(130529104, 130529, '阎疃镇', 130529104),
(130529105, 130529, '小吕寨镇', 130529105),
(130529200, 130529, '堤村乡', 130529200),
(130529201, 130529, '张王疃乡', 130529201),
(130529202, 130529, '观寨乡', 130529202),
(130529203, 130529, '苏家营乡', 130529203),
(130530100, 130530, '新河镇', 130530100),
(130530101, 130530, '寻寨镇', 130530101),
(130530200, 130530, '白神首乡', 130530200),
(130530201, 130530, '荆家庄乡', 130530201),
(130530202, 130530, '西流乡', 130530202),
(130530203, 130530, '仁让里乡', 130530203),
(130531100, 130531, '广宗镇', 130531100),
(130531200, 130531, '葫芦乡', 130531200),
(130531201, 130531, '大平台乡', 130531201),
(130531202, 130531, '件只乡', 130531202),
(130531203, 130531, '核桃园乡', 130531203),
(130531204, 130531, '东召乡', 130531204),
(130531205, 130531, '北塘疃乡', 130531205),
(130531206, 130531, '冯家寨乡', 130531206),
(130532100, 130532, '丰州镇', 130532100),
(130532101, 130532, '平乡镇', 130532101),
(130532102, 130532, '河古庙镇', 130532102),
(130532200, 130532, '节固乡', 130532200),
(130532201, 130532, '油召乡', 130532201),
(130532202, 130532, '田付村乡', 130532202),
(130532203, 130532, '寻召乡', 130532203),
(130533100, 130533, '名州镇', 130533100),
(130533101, 130533, '梨元屯镇', 130533101),
(130533102, 130533, '章台镇', 130533102),
(130533103, 130533, '侯贯镇', 130533103),
(130533104, 130533, '七级镇', 130533104),
(130533200, 130533, '方家营乡', 130533200),
(130533201, 130533, '第什营乡', 130533201),
(130533202, 130533, '枣园乡', 130533202),
(130533203, 130533, '固献乡', 130533203),
(130533204, 130533, '贺钊乡', 130533204),
(130533205, 130533, '贺营乡', 130533205),
(130533206, 130533, '张营乡', 130533206),
(130533207, 130533, '常屯乡', 130533207),
(130533208, 130533, '常庄乡', 130533208),
(130533209, 130533, '高公庄乡', 130533209),
(130533210, 130533, '赵村乡', 130533210),
(130534100, 130534, '葛仙庄镇', 130534100),
(130534101, 130534, '连庄镇', 130534101),
(130534102, 130534, '油坊镇', 130534102),
(130534103, 130534, '谢炉镇', 130534103),
(130534104, 130534, '王官庄镇', 130534104),
(130534105, 130534, '坝营镇', 130534105),
(130535100, 130535, '临西镇', 130535100),
(130535101, 130535, '河西镇', 130535101),
(130535102, 130535, '下堡寺镇', 130535102),
(130535103, 130535, '尖冢镇', 130535103),
(130535200, 130535, '东枣园乡', 130535200),
(130535201, 130535, '老官寨乡', 130535201),
(130535202, 130535, '吕寨乡', 130535202),
(130535203, 130535, '摇鞍镇乡', 130535203),
(130535204, 130535, '大刘庄乡', 130535204),
(130581001, 130581, '凤岗街道', 130581001),
(130581002, 130581, '南杜街道', 130581002),
(130581003, 130581, '北胡街道', 130581003),
(130581004, 130581, '西丁街道', 130581004),
(130581100, 130581, '苏村镇', 130581100),
(130581101, 130581, '大高村镇', 130581101),
(130581102, 130581, '垂杨镇', 130581102),
(130581103, 130581, '明化镇', 130581103),
(130581104, 130581, '段芦头镇', 130581104),
(130581105, 130581, '紫冢镇', 130581105),
(130581200, 130581, '大村乡', 130581200),
(130581201, 130581, '南便村乡', 130581201),
(130581202, 130581, '大屯乡', 130581202),
(130581203, 130581, '王道寨乡', 130581203),
(130581204, 130581, '薛吴村乡', 130581204),
(130582001, 130582, '褡裢街道', 130582001),
(130582002, 130582, '桥东街道', 130582002),
(130582003, 130582, '桥西街道', 130582003),
(130582004, 130582, '赞善街道', 130582004),
(130582005, 130582, '周庄街道', 130582005),
(130582100, 130582, '沙河城镇', 130582100),
(130582101, 130582, '新城镇', 130582101),
(130582102, 130582, '白塔镇', 130582102),
(130582103, 130582, '十里亭镇', 130582103),
(130582104, 130582, '綦村镇', 130582104),
(130582200, 130582, '留村乡', 130582200),
(130582201, 130582, '册井乡', 130582201),
(130582202, 130582, '刘石岗乡', 130582202),
(130582203, 130582, '柴关乡', 130582203),
(130582204, 130582, '蝉房乡', 130582204),
(130582401, 130582, '华北冶金矿山建设公司', 130582401),
(130582402, 130582, '华北冶金设备制造厂', 130582402),
(130602001, 130602, '先锋街道', 130602001),
(130602002, 130602, '新市场街道', 130602002),
(130602003, 130602, '东风街道', 130602003),
(130602004, 130602, '建南街道', 130602004),
(130602005, 130602, '韩村北路街道', 130602005),
(130602200, 130602, '颉庄乡', 130602200),
(130602201, 130602, '富昌乡', 130602201),
(130602202, 130602, '韩村乡', 130602202),
(130602203, 130602, '南奇乡', 130602203),
(130602204, 130602, '江城乡', 130602204),
(130602205, 130602, '大马坊乡', 130602205),
(130602400, 130602, '保定国家高新区', 130602400),
(130603001, 130603, '和平里街道', 130603001),
(130603002, 130603, '五四路街道', 130603002),
(130603003, 130603, '西关街道', 130603003),
(130603004, 130603, '中华路街道', 130603004),
(130603005, 130603, '东关街道', 130603005),
(130603200, 130603, '韩庄乡', 130603200),
(130603201, 130603, '东金庄乡', 130603201),
(130603202, 130603, '百楼乡', 130603202),
(130604001, 130604, '联盟街道', 130604001),
(130604002, 130604, '红星街道', 130604002),
(130604003, 130604, '裕华街道', 130604003),
(130604004, 130604, '永华街道', 130604004),
(130604005, 130604, '南关街道', 130604005),
(130604200, 130604, '杨庄乡', 130604200),
(130604201, 130604, '南大园乡', 130604201),
(130604202, 130604, '焦庄乡', 130604202),
(130604203, 130604, '五尧乡', 130604203),
(130621001, 130621, '惠阳街道', 130621001),
(130621100, 130621, '满城镇', 130621100),
(130621101, 130621, '大册营镇', 130621101),
(130621102, 130621, '神星镇', 130621102),
(130621103, 130621, '南韩村镇', 130621103),
(130621200, 130621, '方顺桥乡', 130621200),
(130621201, 130621, '于家庄乡', 130621201),
(130621202, 130621, '贤台乡', 130621202),
(130621203, 130621, '要庄乡', 130621203),
(130621204, 130621, '白龙乡', 130621204),
(130621205, 130621, '石井乡', 130621205),
(130621206, 130621, '坨南乡', 130621206),
(130621207, 130621, '刘家台乡', 130621207),
(130622100, 130622, '清苑镇', 130622100),
(130622101, 130622, '冉庄镇', 130622101),
(130622102, 130622, '阳城镇', 130622102),
(130622103, 130622, '魏村镇', 130622103),
(130622104, 130622, '温仁镇', 130622104),
(130622105, 130622, '张登镇', 130622105),
(130622106, 130622, '大庄镇', 130622106),
(130622107, 130622, '臧村镇', 130622107),
(130622200, 130622, '白团乡', 130622200),
(130622201, 130622, '北店乡', 130622201),
(130622202, 130622, '石桥乡', 130622202),
(130622203, 130622, '李庄乡', 130622203),
(130622204, 130622, '北王力乡', 130622204),
(130622205, 130622, '东吕乡', 130622205),
(130622206, 130622, '何桥乡', 130622206),
(130622207, 130622, '孙村乡', 130622207),
(130622208, 130622, '阎庄乡', 130622208),
(130622209, 130622, '望亭乡', 130622209),
(130623001, 130623, '城区社区管理办公室街道', 130623001),
(130623100, 130623, '涞水镇', 130623100),
(130623101, 130623, '永阳镇', 130623101),
(130623102, 130623, '义安镇', 130623102),
(130623103, 130623, '石亭镇', 130623103),
(130623104, 130623, '赵各庄镇', 130623104),
(130623105, 130623, '九龙镇', 130623105),
(130623106, 130623, '三坡镇', 130623106),
(130623200, 130623, '明义乡', 130623200),
(130623201, 130623, '王村乡', 130623201),
(130623202, 130623, '东文山乡', 130623202),
(130623203, 130623, '娄村满族乡', 130623203),
(130623204, 130623, '宋各庄乡', 130623204),
(130623205, 130623, '其中口乡', 130623205),
(130623206, 130623, '龙门乡', 130623206),
(130623207, 130623, '胡家庄乡', 130623207),
(130624100, 130624, '阜平镇', 130624100),
(130624101, 130624, '龙泉关镇', 130624101),
(130624102, 130624, '平阳镇', 130624102),
(130624103, 130624, '城南庄镇', 130624103),
(130624200, 130624, '东下关乡', 130624200),
(130624201, 130624, '王林口乡', 130624201),
(130624202, 130624, '台峪乡', 130624202),
(130624203, 130624, '大台乡', 130624203),
(130624204, 130624, '史家寨乡', 130624204),
(130624205, 130624, '砂窝乡', 130624205),
(130624206, 130624, '吴王口乡', 130624206),
(130624207, 130624, '下庄乡', 130624207),
(130624208, 130624, '北果元乡', 130624208),
(130625100, 130625, '安肃镇', 130625100),
(130625101, 130625, '崔庄镇', 130625101),
(130625102, 130625, '大因镇', 130625102),
(130625103, 130625, '遂城镇', 130625103),
(130625104, 130625, '高林村镇', 130625104),
(130625105, 130625, '大王店镇', 130625105),
(130625106, 130625, '漕河镇', 130625106),
(130625200, 130625, '东史端乡', 130625200),
(130625201, 130625, '留村乡', 130625201),
(130625202, 130625, '正村乡', 130625202),
(130625203, 130625, '户木乡', 130625203),
(130625204, 130625, '瀑河乡', 130625204),
(130625205, 130625, '东釜山乡', 130625205),
(130625206, 130625, '义联庄乡', 130625206),
(130626100, 130626, '定兴镇', 130626100),
(130626101, 130626, '固城镇', 130626101),
(130626102, 130626, '贤寓镇', 130626102),
(130626103, 130626, '北河镇', 130626103),
(130626200, 130626, '东落堡乡', 130626200),
(130626201, 130626, '高里乡', 130626201),
(130626202, 130626, '张家庄乡', 130626202),
(130626203, 130626, '姚村乡', 130626203),
(130626204, 130626, '肖村乡', 130626204),
(130626205, 130626, '柳卓乡', 130626205),
(130626206, 130626, '杨村乡', 130626206),
(130626207, 130626, '北田乡', 130626207),
(130626208, 130626, '北南蔡乡', 130626208),
(130626209, 130626, '李郁庄乡', 130626209),
(130626210, 130626, '天宫寺乡', 130626210),
(130626211, 130626, '小朱庄乡', 130626211),
(130627100, 130627, '仁厚镇', 130627100),
(130627101, 130627, '王京镇', 130627101),
(130627102, 130627, '高昌镇', 130627102),
(130627103, 130627, '北罗镇', 130627103),
(130627104, 130627, '白合镇', 130627104),
(130627105, 130627, '军城镇', 130627105),
(130627106, 130627, '川里镇', 130627106),
(130627200, 130627, '长古城乡', 130627200),
(130627201, 130627, '都亭乡', 130627201),
(130627202, 130627, '南店头乡', 130627202),
(130627203, 130627, '北店头乡', 130627203),
(130627204, 130627, '罗庄乡', 130627204),
(130627205, 130627, '雹水乡', 130627205),
(130627206, 130627, '大洋乡', 130627206),
(130627207, 130627, '迷城乡', 130627207),
(130627208, 130627, '齐家佐乡', 130627208),
(130627209, 130627, '羊角乡', 130627209),
(130627210, 130627, '石门乡', 130627210),
(130627211, 130627, '黄石口乡', 130627211),
(130627212, 130627, '倒马关乡', 130627212),
(130628100, 130628, '高阳镇', 130628100),
(130628101, 130628, '庞口镇', 130628101),
(130628102, 130628, '西演镇', 130628102),
(130628200, 130628, '邢家南乡', 130628200),
(130628201, 130628, '晋庄乡', 130628201),
(130628202, 130628, '蒲口乡', 130628202),
(130628203, 130628, '小王果庄乡', 130628203),
(130628204, 130628, '龙化乡', 130628204),
(130628205, 130628, '庞家佐乡', 130628205),
(130629100, 130629, '容城镇', 130629100),
(130629101, 130629, '小里镇', 130629101),
(130629102, 130629, '南张镇', 130629102),
(130629103, 130629, '大河镇', 130629103),
(130629200, 130629, '八于乡', 130629200),
(130629201, 130629, '贾光乡', 130629201),
(130629202, 130629, '晾马台乡', 130629202),
(130629203, 130629, '平王乡', 130629203),
(130630100, 130630, '涞源镇', 130630100),
(130630101, 130630, '银坊镇', 130630101),
(130630102, 130630, '走马驿镇', 130630102),
(130630103, 130630, '水堡镇', 130630103),
(130630104, 130630, '王安镇', 130630104),
(130630105, 130630, '杨家庄镇', 130630105),
(130630200, 130630, '下北头乡', 130630200),
(130630201, 130630, '南屯乡', 130630201),
(130630202, 130630, '马庄乡', 130630202),
(130630203, 130630, '北石佛乡', 130630203),
(130630204, 130630, '金家井乡', 130630204),
(130630205, 130630, '留家庄乡', 130630205),
(130630206, 130630, '上庄乡', 130630206),
(130630207, 130630, '东团堡乡', 130630207),
(130630208, 130630, '塔崖驿乡', 130630208),
(130630209, 130630, '乌龙沟乡', 130630209),
(130630210, 130630, '烟煤洞乡', 130630210),
(130631100, 130631, '望都镇', 130631100),
(130631101, 130631, '固店镇', 130631101),
(130631200, 130631, '寺庄乡', 130631200),
(130631201, 130631, '赵庄乡', 130631201),
(130631202, 130631, '黑堡乡', 130631202),
(130631204, 130631, '高岭乡', 130631204),
(130631205, 130631, '中韩庄乡', 130631205),
(130631206, 130631, '贾村乡', 130631206),
(130632100, 130632, '安新镇', 130632100),
(130632101, 130632, '大王镇', 130632101),
(130632102, 130632, '三台镇', 130632102),
(130632103, 130632, '端村镇', 130632103),
(130632104, 130632, '赵北口镇', 130632104),
(130632105, 130632, '同口镇', 130632105),
(130632106, 130632, '刘李庄镇', 130632106),
(130632107, 130632, '安州镇', 130632107),
(130632108, 130632, '老河头镇', 130632108),
(130632200, 130632, '圈头乡', 130632200),
(130632201, 130632, '寨里乡', 130632201),
(130632202, 130632, '芦庄乡', 130632202),
(130633100, 130633, '易州镇', 130633100),
(130633101, 130633, '梁格庄镇', 130633101),
(130633102, 130633, '西陵镇', 130633102),
(130633103, 130633, '裴山镇', 130633103),
(130633104, 130633, '塘湖镇', 130633104),
(130633105, 130633, '狼牙山镇', 130633105),
(130633106, 130633, '良岗镇', 130633106),
(130633107, 130633, '紫荆关镇', 130633107),
(130633200, 130633, '桥头乡', 130633200),
(130633201, 130633, '白马乡', 130633201),
(130633202, 130633, '流井乡', 130633202),
(130633203, 130633, '高村乡', 130633203),
(130633204, 130633, '高陌乡', 130633204),
(130633205, 130633, '大龙华乡', 130633205),
(130633206, 130633, '安格庄乡', 130633206),
(130633207, 130633, '凌云册乡', 130633207),
(130633208, 130633, '西山北乡', 130633208),
(130633209, 130633, '尉都乡', 130633209),
(130633210, 130633, '独乐乡', 130633210),
(130633211, 130633, '七峪乡', 130633211),
(130633212, 130633, '富岗乡', 130633212),
(130633213, 130633, '坡仓乡', 130633213),
(130633214, 130633, '牛岗乡', 130633214),
(130633215, 130633, '桥家河乡', 130633215),
(130633216, 130633, '甘河净乡', 130633216),
(130633217, 130633, '蔡家峪乡', 130633217),
(130633218, 130633, '南城司乡', 130633218),
(130634100, 130634, '恒州镇', 130634100),
(130634101, 130634, '灵山镇', 130634101),
(130634102, 130634, '燕赵镇', 130634102),
(130634103, 130634, '羊平镇', 130634103),
(130634200, 130634, '路庄子乡', 130634200),
(130634201, 130634, '下河乡', 130634201),
(130634202, 130634, '庄窠乡', 130634202),
(130634203, 130634, '孝墓乡', 130634203),
(130634204, 130634, '文德乡', 130634204),
(130634205, 130634, '东旺乡', 130634205),
(130634206, 130634, '晓林乡', 130634206),
(130634207, 130634, '邸村乡', 130634207),
(130634208, 130634, '产德乡', 130634208),
(130634209, 130634, '齐村乡', 130634209),
(130634210, 130634, '党城乡', 130634210),
(130634211, 130634, '郎家庄乡', 130634211),
(130634212, 130634, '范家庄乡', 130634212),
(130634213, 130634, '北台乡', 130634213),
(130635100, 130635, '蠡吾镇', 130635100),
(130635101, 130635, '留史镇', 130635101),
(130635102, 130635, '大百尺镇', 130635102),
(130635103, 130635, '辛兴镇', 130635103),
(130635104, 130635, '北郭丹镇', 130635104),
(130635105, 130635, '万安镇', 130635105),
(130635106, 130635, '桑园镇', 130635106),
(130635107, 130635, '南庄镇', 130635107),
(130635200, 130635, '小陈乡', 130635200),
(130635201, 130635, '林堡乡', 130635201),
(130635202, 130635, '北埝头乡', 130635202),
(130635203, 130635, '鲍墟乡', 130635203),
(130635204, 130635, '大曲堤乡', 130635204),
(130636100, 130636, '蒲阳镇', 130636100),
(130636101, 130636, '高于铺镇', 130636101),
(130636102, 130636, '腰山镇', 130636102),
(130636200, 130636, '蒲上乡', 130636200),
(130636201, 130636, '白云乡', 130636201),
(130636202, 130636, '河口乡', 130636202),
(130636203, 130636, '安阳乡', 130636203),
(130636204, 130636, '台鱼乡', 130636204),
(130636205, 130636, '大悲乡', 130636205),
(130636206, 130636, '神南乡', 130636206),
(130637100, 130637, '博野镇', 130637100),
(130637101, 130637, '小店镇', 130637101),
(130637102, 130637, '程委镇', 130637102),
(130637200, 130637, '东墟乡', 130637200),
(130637201, 130637, '北杨村乡', 130637201),
(130637202, 130637, '城东乡', 130637202),
(130637203, 130637, '南小王乡', 130637203),
(130638100, 130638, '雄州镇', 130638100),
(130638101, 130638, '昝岗镇', 130638101),
(130638102, 130638, '大营镇', 130638102),
(130638103, 130638, '龙湾镇', 130638103),
(130638200, 130638, '北沙口乡', 130638200),
(130638201, 130638, '朱各庄乡', 130638201),
(130638202, 130638, '米家务乡', 130638202),
(130638203, 130638, '双堂乡', 130638203),
(130638204, 130638, '张岗乡', 130638204),
(130681001, 130681, '双塔街道', 130681001),
(130681002, 130681, '桃园街道', 130681002),
(130681003, 130681, '清凉寺街道', 130681003),
(130681100, 130681, '松林店镇', 130681100),
(130681101, 130681, '码头镇', 130681101),
(130681102, 130681, '东城坊镇', 130681102),
(130681103, 130681, '高官庄镇', 130681103),
(130681104, 130681, '东仙坡镇', 130681104),
(130681200, 130681, '百尺竿乡', 130681200),
(130681202, 130681, '义和庄乡', 130681202),
(130681203, 130681, '林家屯乡', 130681203),
(130681204, 130681, '孙庄乡', 130681204),
(130681205, 130681, '豆庄乡', 130681205),
(130681206, 130681, '刁窝乡', 130681206),
(130681400, 130681, '开发区管理委员会', 130681400),
(130682001, 130682, '南城区街道', 130682001),
(130682002, 130682, '北城区街道', 130682002),
(130682003, 130682, '西城区街道', 130682003),
(130682100, 130682, '留早镇', 130682100),
(130682101, 130682, '清风店镇', 130682101),
(130682102, 130682, '庞村镇', 130682102),
(130682103, 130682, '砖路镇', 130682103),
(130682104, 130682, '明月店镇', 130682104),
(130682105, 130682, '叮咛店镇', 130682105),
(130682106, 130682, '东亭镇', 130682106),
(130682107, 130682, '大辛庄镇', 130682107),
(130682108, 130682, '东旺镇', 130682108),
(130682109, 130682, '高蓬镇', 130682109),
(130682110, 130682, '邢邑镇', 130682110),
(130682111, 130682, '李亲顾镇', 130682111),
(130682112, 130682, '子位镇', 130682112),
(130682113, 130682, '开元镇', 130682113),
(130682200, 130682, '赵村乡', 130682200),
(130682202, 130682, '周村乡', 130682202),
(130682203, 130682, '东留春乡', 130682203),
(130682204, 130682, '号头庄回族乡', 130682204),
(130682205, 130682, '杨家庄乡', 130682205),
(130682206, 130682, '大鹿庄乡', 130682206),
(130682207, 130682, '息冢乡', 130682207),
(130682208, 130682, '西城乡', 130682208),
(130683001, 130683, '祁州药市街道', 130683001),
(130683100, 130683, '祁州镇', 130683100),
(130683101, 130683, '伍仁桥镇', 130683101),
(130683102, 130683, '石佛镇', 130683102),
(130683103, 130683, '郑章镇', 130683103),
(130683104, 130683, '大五女镇', 130683104),
(130683200, 130683, '明官店乡', 130683200),
(130683201, 130683, '南娄底乡', 130683201),
(130683202, 130683, '西安国城乡', 130683202),
(130683203, 130683, '西佛落乡', 130683203),
(130683204, 130683, '北段村乡', 130683204),
(130684001, 130684, '和平街道', 130684001),
(130684002, 130684, '军城街道', 130684002),
(130684003, 130684, '东盛街道', 130684003),
(130684004, 130684, '北城街道', 130684004),
(130684005, 130684, '兴华路街道', 130684005),
(130684100, 130684, '方官镇', 130684100),
(130684101, 130684, '新城镇', 130684101),
(130684102, 130684, '泗庄镇', 130684102),
(130684103, 130684, '白沟镇', 130684103),
(130684104, 130684, '辛立庄镇', 130684104),
(130684200, 130684, '肖官营乡', 130684200),
(130684201, 130684, '梁家营乡', 130684201),
(130684202, 130684, '张六庄乡', 130684202),
(130684203, 130684, '东马营乡', 130684203),
(130684204, 130684, '辛桥乡', 130684204),
(130702001, 130702, '红旗楼街道', 130702001),
(130702002, 130702, '胜利北路街道', 130702002),
(130702003, 130702, '五一路街道', 130702003),
(130702004, 130702, '花园街街道', 130702004),
(130702005, 130702, '工业路街道', 130702005),
(130702006, 130702, '南站街道', 130702006),
(130702007, 130702, '马路东街道', 130702007),
(130702100, 130702, '老鸦庄镇', 130702100),
(130702101, 130702, '姚家庄镇', 130702101),
(130703001, 130703, '新华街街道', 130703001),
(130703002, 130703, '大境门街道', 130703002),
(130703003, 130703, '明德北街街道', 130703003),
(130703004, 130703, '明德南街街道', 130703004),
(130703005, 130703, '堡子里街道', 130703005),
(130703006, 130703, '南营坊街道', 130703006),
(130703007, 130703, '工人新村街道', 130703007),
(130703100, 130703, '东窑子镇', 130703100),
(130703101, 130703, '沈家屯镇', 130703101),
(130705001, 130705, '天泰寺街道', 130705001),
(130705002, 130705, '皇城街道', 130705002),
(130705003, 130705, '南关街道', 130705003),
(130705004, 130705, '南大街街道', 130705004),
(130705005, 130705, '大北街街道', 130705005),
(130705006, 130705, '工业街街道', 130705006),
(130705007, 130705, '建国街街道', 130705007),
(130705100, 130705, '庞家堡镇', 130705100),
(130705200, 130705, '河子西乡', 130705200),
(130705201, 130705, '春光乡', 130705201),
(130705202, 130705, '侯家庙乡', 130705202),
(130706001, 130706, '城镇街道', 130706001),
(130706002, 130706, '煤矿街道', 130706002),
(130706200, 130706, '花园乡', 130706200),
(130706201, 130706, '辛庄子乡', 130706201),
(130706202, 130706, '定方水乡', 130706202),
(130706203, 130706, '段家堡乡', 130706203),
(130721100, 130721, '洋河南镇', 130721100),
(130721101, 130721, '深井镇', 130721101),
(130721102, 130721, '崞村镇', 130721102),
(130721103, 130721, '沙岭子镇', 130721103),
(130721104, 130721, '姚家房镇', 130721104),
(130721105, 130721, '大仓盖镇', 130721105),
(130721106, 130721, '贾家营镇', 130721106),
(130721107, 130721, '顾家营镇', 130721107),
(130721108, 130721, '赵川镇', 130721108),
(130721200, 130721, '王家湾乡', 130721200),
(130721201, 130721, '塔儿村乡', 130721201),
(130721202, 130721, '江家屯乡', 130721202),
(130721203, 130721, '东望山乡', 130721203),
(130721204, 130721, '李家堡乡', 130721204),
(130722100, 130722, '张北镇', 130722100),
(130722101, 130722, '公会镇', 130722101),
(130722102, 130722, '二台镇', 130722102),
(130722103, 130722, '大囫囵镇', 130722103),
(130722200, 130722, '台路沟乡', 130722200),
(130722201, 130722, '油篓沟乡', 130722201),
(130722202, 130722, '馒头营乡', 130722202),
(130722203, 130722, '二泉井乡', 130722203),
(130722204, 130722, '单晶河乡', 130722204),
(130722205, 130722, '大河乡', 130722205),
(130722206, 130722, '海流图乡', 130722206),
(130722207, 130722, '两面井乡', 130722207),
(130722208, 130722, '大西湾乡', 130722208),
(130722209, 130722, '郝家营乡', 130722209),
(130722210, 130722, '白庙滩乡', 130722210),
(130722211, 130722, '小二台乡', 130722211),
(130722212, 130722, '战海乡', 130722212),
(130722213, 130722, '三号乡', 130722213),
(130722214, 130722, '沙沟乡', 130722214),
(130722215, 130722, '宇宙营乡', 130722215),
(130722500, 130722, '察北虚拟乡', 130722500),
(130723100, 130723, '康保镇', 130723100),
(130723101, 130723, '张纪镇', 130723101),
(130723102, 130723, '土城子镇', 130723102),
(130723103, 130723, '邓油坊镇', 130723103),
(130723104, 130723, '李家地镇', 130723104),
(130723105, 130723, '照阳河镇', 130723105),
(130723106, 130723, '屯垦镇', 130723106),
(130723200, 130723, '阎油房乡', 130723200),
(130723201, 130723, '丹清河乡', 130723201),
(130723202, 130723, '哈必嘎乡', 130723202),
(130723203, 130723, '二号卜乡', 130723203),
(130723204, 130723, '芦家营乡', 130723204),
(130723205, 130723, '忠义乡', 130723205),
(130723206, 130723, '处长地乡', 130723206),
(130723207, 130723, '满德堂乡', 130723207),
(130723500, 130723, '康保牧场虚拟乡', 130723500),
(130724100, 130724, '平定堡镇', 130724100),
(130724101, 130724, '小厂镇', 130724101),
(130724102, 130724, '黄盖淖镇', 130724102),
(130724103, 130724, '九连城镇', 130724103),
(130724200, 130724, '高山堡乡', 130724200),
(130724201, 130724, '小河子乡', 130724201),
(130724202, 130724, '二道渠乡', 130724202),
(130724203, 130724, '大二号回族乡', 130724203),
(130724204, 130724, '闪电河乡', 130724204),
(130724205, 130724, '长梁乡', 130724205),
(130724206, 130724, '丰源店乡', 130724206),
(130724207, 130724, '西辛营乡', 130724207),
(130724208, 130724, '莲花滩乡', 130724208),
(130724209, 130724, '白土窑乡', 130724209),
(130724501, 130724, '榆树沟虚拟乡', 130724501),
(130724502, 130724, '沙埌子虚拟乡', 130724502),
(130724503, 130724, '小城子虚拟乡', 130724503),
(130724504, 130724, '东大门虚拟乡', 130724504),
(130725100, 130725, '南壕堑镇', 130725100),
(130725101, 130725, '大青沟镇', 130725101),
(130725102, 130725, '八道沟镇', 130725102),
(130725103, 130725, '红土梁镇', 130725103),
(130725104, 130725, '小蒜沟镇', 130725104),
(130725105, 130725, '三工地镇', 130725105),
(130725200, 130725, '大营盘乡', 130725200),
(130725201, 130725, '大苏计乡', 130725201),
(130725202, 130725, '石井乡', 130725202),
(130725204, 130725, '炕塄乡', 130725204),
(130725205, 130725, '七甲乡', 130725205),
(130725206, 130725, '套里庄乡', 130725206),
(130725207, 130725, '甲石河乡', 130725207),
(130725208, 130725, '下马圈乡', 130725208),
(130726100, 130726, '蔚州镇', 130726100),
(130726101, 130726, '代王城镇', 130726101),
(130726102, 130726, '西合营镇', 130726102),
(130726103, 130726, '吉家庄镇', 130726103),
(130726104, 130726, '白乐镇', 130726104),
(130726105, 130726, '暖泉镇', 130726105),
(130726106, 130726, '南留庄镇', 130726106),
(130726107, 130726, '北水泉镇', 130726107),
(130726108, 130726, '桃花镇', 130726108),
(130726109, 130726, '阳眷镇', 130726109),
(130726110, 130726, '宋家庄镇', 130726110),
(130726200, 130726, '下宫村乡', 130726200),
(130726202, 130726, '南杨庄乡', 130726202),
(130726203, 130726, '柏树乡', 130726203),
(130726204, 130726, '常宁乡', 130726204),
(130726205, 130726, '涌泉庄乡', 130726205),
(130726206, 130726, '杨庄窠乡', 130726206),
(130726207, 130726, '南岭庄乡', 130726207),
(130726208, 130726, '陈家洼乡', 130726208),
(130726209, 130726, '黄梅乡', 130726209),
(130726210, 130726, '白草村乡', 130726210),
(130726211, 130726, '草沟堡乡', 130726211),
(130727100, 130727, '西城镇', 130727100),
(130727101, 130727, '东城镇', 130727101),
(130727102, 130727, '化稍营镇', 130727102),
(130727103, 130727, '揣骨疃镇', 130727103),
(130727104, 130727, '东井集镇', 130727104),
(130727200, 130727, '要家庄乡', 130727200),
(130727201, 130727, '东坊城堡乡', 130727201),
(130727202, 130727, '井儿沟乡', 130727202),
(130727203, 130727, '三马坊乡', 130727203),
(130727204, 130727, '高墙乡', 130727204),
(130727205, 130727, '大田洼乡', 130727205),
(130727206, 130727, '辛堡乡', 130727206),
(130727207, 130727, '马圈堡乡', 130727207),
(130727208, 130727, '浮图讲乡', 130727208),
(130728100, 130728, '柴沟堡镇', 130728100),
(130728101, 130728, '左卫镇', 130728101),
(130728102, 130728, '头百户镇', 130728102),
(130728103, 130728, '怀安城镇', 130728103),
(130728200, 130728, '渡口堡乡', 130728200),
(130728201, 130728, '第六屯乡', 130728201),
(130728202, 130728, '西湾堡乡', 130728202),
(130728203, 130728, '西沙城乡', 130728203),
(130728204, 130728, '太平庄乡', 130728204),
(130728205, 130728, '王虎屯乡', 130728205),
(130728206, 130728, '第三堡乡', 130728206),
(130729100, 130729, '孔家庄镇', 130729100),
(130729101, 130729, '万全镇', 130729101),
(130729102, 130729, '洗马林镇', 130729102),
(130729103, 130729, '郭磊庄镇', 130729103),
(130729200, 130729, '膳房堡乡', 130729200),
(130729201, 130729, '北新屯乡', 130729201),
(130729202, 130729, '宣平堡乡', 130729202),
(130729203, 130729, '高庙堡乡', 130729203),
(130729204, 130729, '旧堡乡', 130729204),
(130729205, 130729, '安家堡乡', 130729205),
(130729206, 130729, '北沙城乡', 130729206),
(130730100, 130730, '沙城镇', 130730100),
(130730101, 130730, '北辛堡镇', 130730101),
(130730102, 130730, '新保安镇', 130730102),
(130730103, 130730, '东花园镇', 130730103),
(130730104, 130730, '官厅镇', 130730104),
(130730105, 130730, '桑园镇', 130730105),
(130730106, 130730, '存瑞镇', 130730106),
(130730107, 130730, '土木镇', 130730107),
(130730108, 130730, '大黄庄镇', 130730108),
(130730109, 130730, '西八里镇', 130730109),
(130730110, 130730, '小南辛堡镇', 130730110),
(130730200, 130730, '狼山乡', 130730200),
(130730203, 130730, '鸡鸣驿乡', 130730203),
(130730205, 130730, '东八里乡', 130730205),
(130730207, 130730, '瑞云观乡', 130730207),
(130730208, 130730, '孙庄子乡', 130730208),
(130730210, 130730, '王家楼回族乡', 130730210),
(130731100, 130731, '涿鹿镇', 130731100),
(130731101, 130731, '张家堡镇', 130731101),
(130731102, 130731, '武家沟镇', 130731102),
(130731103, 130731, '五堡镇', 130731103),
(130731104, 130731, '保岱镇', 130731104),
(130731105, 130731, '矾山镇', 130731105),
(130731106, 130731, '大堡镇', 130731106),
(130731107, 130731, '河东镇', 130731107),
(130731200, 130731, '东小庄乡', 130731200),
(130731201, 130731, '栾庄乡', 130731201),
(130731202, 130731, '温泉屯乡', 130731202),
(130731203, 130731, '辉耀乡', 130731203),
(130731204, 130731, '黑山寺乡', 130731204),
(130731205, 130731, '卧佛寺乡', 130731205),
(130731206, 130731, '谢家堡乡', 130731206),
(130731207, 130731, '大河南乡', 130731207),
(130731208, 130731, '蟒石口乡', 130731208),
(130732100, 130732, '赤城镇', 130732100),
(130732101, 130732, '田家窑镇', 130732101),
(130732102, 130732, '龙关镇', 130732102),
(130732103, 130732, '雕鄂镇', 130732103),
(130732104, 130732, '独石口镇', 130732104),
(130732105, 130732, '白草镇', 130732105),
(130732106, 130732, '龙门所镇', 130732106),
(130732107, 130732, '后城镇', 130732107),
(130732108, 130732, '东卯镇', 130732108),
(130732200, 130732, '炮梁乡', 130732200),
(130732201, 130732, '大海陀乡', 130732201),
(130732202, 130732, '镇宁堡乡', 130732202),
(130732203, 130732, '马营乡', 130732203),
(130732204, 130732, '云州乡', 130732204),
(130732205, 130732, '三道川乡', 130732205),
(130732206, 130732, '东万口乡', 130732206),
(130732207, 130732, '茨营子乡', 130732207),
(130732208, 130732, '样田乡', 130732208),
(130733001, 130733, '西湾子街道办', 130733001),
(130733100, 130733, '西湾子镇', 130733100),
(130733101, 130733, '高家营镇', 130733101),
(130733200, 130733, '四台嘴乡', 130733200),
(130733201, 130733, '红旗营乡', 130733201),
(130733202, 130733, '石窑子乡', 130733202),
(130733203, 130733, '驿马图乡', 130733203),
(130733204, 130733, '石嘴子乡', 130733204),
(130733205, 130733, '狮子沟乡', 130733205),
(130733206, 130733, '清三营乡', 130733206),
(130733207, 130733, '白旗乡', 130733207),
(130802001, 130802, '西大街街道', 130802001),
(130802002, 130802, '头道牌楼街道', 130802002),
(130802003, 130802, '潘家沟街道', 130802003),
(130802004, 130802, '中华路街道', 130802004),
(130802005, 130802, '新华路街道', 130802005),
(130802006, 130802, '石洞子沟街道', 130802006),
(130802007, 130802, '桥东街道', 130802007),
(130802100, 130802, '水泉沟镇', 130802100),
(130802101, 130802, '狮子沟镇', 130802101),
(130802102, 130802, '牛圈子沟镇', 130802102),
(130802103, 130802, '大石庙镇', 130802103),
(130802104, 130802, '冯营子镇', 130802104),
(130803001, 130803, '双塔山街道', 130803001),
(130803002, 130803, '滦河街道', 130803002),
(130803100, 130803, '双塔山镇', 130803100),
(130803101, 130803, '滦河镇', 130803101),
(130803102, 130803, '大庙镇', 130803102),
(130803103, 130803, '偏桥子镇', 130803103),
(130804100, 130804, '鹰手营子镇', 130804100),
(130804101, 130804, '北马圈子镇', 130804101),
(130804102, 130804, '寿王坟镇', 130804102),
(130804103, 130804, '汪家庄镇', 130804103),
(130821100, 130821, '下板城镇', 130821100),
(130821101, 130821, '上板城镇', 130821101),
(130821102, 130821, '甲山镇', 130821102),
(130821103, 130821, '六沟镇', 130821103),
(130821104, 130821, '三沟镇', 130821104),
(130821105, 130821, '头沟镇', 130821105),
(130821106, 130821, '高寺台镇', 130821106),
(130821107, 130821, '双峰寺镇', 130821107),
(130821200, 130821, '东小白旗乡', 130821200),
(130821201, 130821, '鞍匠乡', 130821201),
(130821202, 130821, '刘杖子乡', 130821202),
(130821203, 130821, '新杖子乡', 130821203),
(130821204, 130821, '孟家院乡', 130821204),
(130821205, 130821, '大营子乡', 130821205),
(130821206, 130821, '八家乡', 130821206),
(130821207, 130821, '上谷乡', 130821207),
(130821208, 130821, '满杖子乡', 130821208),
(130821209, 130821, '石灰窑乡', 130821209),
(130821210, 130821, '五道河乡', 130821210),
(130821211, 130821, '岔沟乡', 130821211),
(130821212, 130821, '岗子满族乡', 130821212),
(130821213, 130821, '磴上乡', 130821213),
(130821214, 130821, '两家满族乡', 130821214),
(130821215, 130821, '三家乡', 130821215),
(130821216, 130821, '仓子乡', 130821216),
(130822100, 130822, '兴隆镇', 130822100),
(130822101, 130822, '半壁山镇', 130822101),
(130822102, 130822, '挂兰峪镇', 130822102),
(130822103, 130822, '青松岭镇', 130822103),
(130822104, 130822, '六道河镇', 130822104),
(130822105, 130822, '平安堡镇', 130822105),
(130822106, 130822, '北营房镇', 130822106),
(130822200, 130822, '南天门满族乡', 130822200),
(130822201, 130822, '孤山子乡', 130822201),
(130822202, 130822, '八卦岭满族乡', 130822202),
(130822203, 130822, '陡子峪乡', 130822203),
(130822204, 130822, '上石洞乡', 130822204),
(130822205, 130822, '北水泉乡', 130822205),
(130822206, 130822, '李家营乡', 130822206),
(130822207, 130822, '大杖子乡', 130822207),
(130822208, 130822, '蘑菇峪乡', 130822208),
(130822209, 130822, '三道河乡', 130822209),
(130822210, 130822, '蓝旗营乡', 130822210),
(130822211, 130822, '安子岭乡', 130822211),
(130822212, 130822, '大水泉乡', 130822212),
(130823100, 130823, '平泉镇', 130823100),
(130823101, 130823, '黄土梁子镇', 130823101),
(130823102, 130823, '榆树林子镇', 130823102),
(130823103, 130823, '杨树岭镇', 130823103),
(130823104, 130823, '七沟镇', 130823104),
(130823105, 130823, '小寺沟镇', 130823105),
(130823106, 130823, '党坝镇', 130823106),
(130823107, 130823, '卧龙镇', 130823107),
(130823108, 130823, '南五十家子镇', 130823108),
(130823200, 130823, '王土房乡', 130823200),
(130823202, 130823, '柳溪满族乡', 130823202),
(130823203, 130823, '七家岱满族乡', 130823203),
(130823204, 130823, '平房满族蒙古族乡', 130823204),
(130823205, 130823, '蒙和乌苏蒙古族乡', 130823205),
(130823206, 130823, '茅兰沟满族蒙古族乡', 130823206),
(130823207, 130823, '台头山乡', 130823207),
(130823209, 130823, '松树台乡', 130823209),
(130823210, 130823, '道虎沟乡', 130823210),
(130823212, 130823, '郭杖子满族乡', 130823212),
(130824100, 130824, '滦平镇', 130824100),
(130824101, 130824, '长山峪镇', 130824101),
(130824102, 130824, '红旗镇', 130824102),
(130824103, 130824, '金沟屯镇', 130824103),
(130824104, 130824, '虎什哈镇', 130824104),
(130824105, 130824, '巴克什营镇', 130824105),
(130824106, 130824, '张百湾镇', 130824106),
(130824200, 130824, '平坊满族乡', 130824200),
(130824201, 130824, '安纯沟门满族乡', 130824201),
(130824202, 130824, '西地满族乡', 130824202),
(130824203, 130824, '陈栅子乡', 130824203),
(130824204, 130824, '付营子乡', 130824204),
(130824205, 130824, '小营满族乡', 130824205),
(130824206, 130824, '西沟满族乡', 130824206),
(130824207, 130824, '邓厂满族乡', 130824207),
(130824208, 130824, '五道营子满族乡', 130824208),
(130824209, 130824, '马营子满族乡', 130824209),
(130824210, 130824, '付家店满族乡', 130824210),
(130824211, 130824, '火斗山乡', 130824211),
(130824212, 130824, '两间房乡', 130824212),
(130824213, 130824, '涝洼乡', 130824213),
(130824214, 130824, '大屯满族乡', 130824214),
(130825100, 130825, '隆化镇', 130825100),
(130825101, 130825, '韩麻营镇', 130825101),
(130825102, 130825, '中关镇', 130825102),
(130825103, 130825, '七家镇', 130825103),
(130825104, 130825, '汤头沟镇', 130825104),
(130825105, 130825, '张三营镇', 130825105),
(130825106, 130825, '唐三营镇', 130825106),
(130825107, 130825, '蓝旗镇', 130825107),
(130825108, 130825, '步古沟镇', 130825108),
(130825109, 130825, '郭家屯镇', 130825109),
(130825200, 130825, '荒地乡', 130825200),
(130825201, 130825, '章吉营乡', 130825201),
(130825202, 130825, '茅荆坝乡', 130825202),
(130825203, 130825, '尹家营满族乡', 130825203),
(130825204, 130825, '庙子沟蒙古族满族乡', 130825204),
(130825205, 130825, '偏坡营满族乡', 130825205),
(130825206, 130825, '山湾乡', 130825206),
(130825207, 130825, '八达营蒙古族乡', 130825207),
(130825208, 130825, '太平庄满族乡', 130825208),
(130825209, 130825, '旧屯满族乡', 130825209),
(130825210, 130825, '西阿超满族蒙古族乡', 130825210),
(130825211, 130825, '白虎沟满族蒙古族乡', 130825211),
(130825212, 130825, '碱房乡', 130825212),
(130825213, 130825, '韩家店乡', 130825213),
(130825214, 130825, '湾沟门乡', 130825214),
(130826100, 130826, '大阁镇', 130826100),
(130826101, 130826, '大滩镇', 130826101),
(130826102, 130826, '鱼儿山镇', 130826102),
(130826103, 130826, '土城镇', 130826103),
(130826104, 130826, '黄旗镇', 130826104),
(130826105, 130826, '凤山镇', 130826105),
(130826106, 130826, '波罗诺镇', 130826106),
(130826107, 130826, '黑山咀镇', 130826107),
(130826108, 130826, '天桥镇', 130826108),
(130826200, 130826, '万胜永乡', 130826200),
(130826201, 130826, '四岔口乡', 130826201),
(130826202, 130826, '苏家店乡', 130826202),
(130826203, 130826, '外沟门乡', 130826203),
(130826204, 130826, '草原乡', 130826204),
(130826205, 130826, '窟窿山乡', 130826205),
(130826206, 130826, '小坝子乡', 130826206),
(130826207, 130826, '五道营乡', 130826207),
(130826208, 130826, '南关蒙古族乡', 130826208),
(130826209, 130826, '选将营乡', 130826209),
(130826210, 130826, '西官营乡', 130826210),
(130826211, 130826, '王营乡', 130826211),
(130826212, 130826, '北头营乡', 130826212),
(130826213, 130826, '胡麻营乡', 130826213),
(130826214, 130826, '石人沟乡', 130826214),
(130826215, 130826, '汤河乡', 130826215),
(130826216, 130826, '杨木栅子乡', 130826216),
(130827100, 130827, '宽城镇', 130827100),
(130827101, 130827, '龙须门镇', 130827101),
(130827102, 130827, '峪耳崖镇', 130827102),
(130827103, 130827, '板城镇', 130827103),
(130827104, 130827, '汤道河镇', 130827104),
(130827200, 130827, '化皮溜子乡', 130827200),
(130827201, 130827, '塌山乡', 130827201),
(130827202, 130827, '饽罗台乡', 130827202),
(130827203, 130827, '孟子岭乡', 130827203),
(130827204, 130827, '独石沟乡', 130827204),
(130827205, 130827, '碾子峪乡', 130827205),
(130827206, 130827, '东大地乡', 130827206),
(130827207, 130827, '铧尖乡', 130827207),
(130827208, 130827, '东黄花川乡', 130827208),
(130827209, 130827, '亮甲台乡', 130827209),
(130827210, 130827, '苇子沟乡', 130827210),
(130827211, 130827, '大字沟门乡', 130827211),
(130827212, 130827, '大石柱子乡', 130827212),
(130828100, 130828, '围场镇', 130828100),
(130828101, 130828, '四合永镇', 130828101),
(130828102, 130828, '克勒沟镇', 130828102),
(130828103, 130828, '棋盘山镇', 130828103),
(130828104, 130828, '半截塔镇', 130828104),
(130828105, 130828, '朝阳地镇', 130828105),
(130828106, 130828, '朝阳湾镇', 130828106),
(130828200, 130828, '道坝子乡', 130828200),
(130828201, 130828, '龙头山乡', 130828201),
(130828202, 130828, '腰站乡', 130828202),
(130828203, 130828, '黄土坎乡', 130828203),
(130828204, 130828, '四道沟乡', 130828204),
(130828205, 130828, '兰旗卡伦乡', 130828205),
(130828206, 130828, '银窝沟乡', 130828206),
(130828207, 130828, '新地乡', 130828207),
(130828208, 130828, '广发永乡', 130828208),
(130828209, 130828, '育太和乡', 130828209),
(130828210, 130828, '郭家湾乡', 130828210),
(130828211, 130828, '杨家湾乡', 130828211),
(130828212, 130828, '大唤起乡', 130828212),
(130828213, 130828, '哈里哈乡', 130828213),
(130828214, 130828, '新拨乡', 130828214),
(130828215, 130828, '张家湾乡', 130828215),
(130828216, 130828, '宝元栈乡', 130828216),
(130828217, 130828, '山湾子乡', 130828217),
(130828218, 130828, '三义永乡', 130828218),
(130828219, 130828, '姜家店乡', 130828219),
(130828220, 130828, '下伙房乡', 130828220),
(130828221, 130828, '燕格柏乡', 130828221),
(130828222, 130828, '牌楼乡', 130828222),
(130828223, 130828, '城子乡', 130828223),
(130828224, 130828, '老窝铺乡', 130828224),
(130828225, 130828, '御道口乡', 130828225),
(130828226, 130828, '石桌子乡', 130828226),
(130828227, 130828, '大头山乡', 130828227),
(130828228, 130828, '南山嘴乡', 130828228),
(130828229, 130828, '西龙头乡', 130828229),
(130828450, 130828, '塞罕坝机械林场虚拟镇', 130828450),
(130828500, 130828, '国营御道口牧场虚拟乡', 130828500),
(130902001, 130902, '建设北街街道', 130902001),
(130902002, 130902, '车站街道', 130902002),
(130902003, 130902, '南大街街道', 130902003),
(130902004, 130902, '东环街道', 130902004),
(130902005, 130902, '道东街道', 130902005),
(130902200, 130902, '小赵庄乡', 130902200),
(130902400, 130902, '沧州开发区', 130902400),
(130903001, 130903, '水月寺街道', 130903001),
(130903002, 130903, '南环中路街道', 130903002),
(130903003, 130903, '南湖街道', 130903003),
(130903004, 130903, '市场街道', 130903004),
(130903005, 130903, '西环中街街道', 130903005),
(130903006, 130903, '公园街道', 130903006),
(130903100, 130903, '小王庄镇', 130903100),
(130903200, 130903, '南陈屯乡', 130903200),
(130921100, 130921, '旧州镇', 130921100),
(130921101, 130921, '兴济镇', 130921101),
(130921102, 130921, '杜生镇', 130921102),
(130921103, 130921, '崔尔庄镇', 130921103),
(130921200, 130921, '薛官屯乡', 130921200),
(130921201, 130921, '捷地回族乡', 130921201),
(130921202, 130921, '张官屯乡', 130921202),
(130921203, 130921, '李天木回族乡', 130921203),
(130921204, 130921, '风化店乡', 130921204),
(130921205, 130921, '姚官屯乡', 130921205),
(130921206, 130921, '杜林回族乡', 130921206),
(130921207, 130921, '汪家铺乡', 130921207),
(130921208, 130921, '刘家庙乡', 130921208),
(130921209, 130921, '仵龙堂乡', 130921209),
(130921210, 130921, '大官厅乡', 130921210),
(130921211, 130921, '高川乡', 130921211),
(130921212, 130921, '黄递铺乡', 130921212),
(130921213, 130921, '大褚村回族乡', 130921213),
(130921214, 130921, '纸房头乡', 130921214),
(130922100, 130922, '清州镇', 130922100),
(130922101, 130922, '金牛镇', 130922101),
(130922102, 130922, '新兴镇', 130922102),
(130922103, 130922, '流河镇', 130922103),
(130922104, 130922, '木门店镇', 130922104),
(130922105, 130922, '马厂镇', 130922105),
(130922200, 130922, '上伍乡', 130922200),
(130922201, 130922, '曹寺乡', 130922201),
(130922202, 130922, '盘古乡', 130922202),
(130922203, 130922, '陈嘴乡', 130922203),
(130922400, 130922, '农场虚拟乡', 130922400),
(130923100, 130923, '东光镇', 130923100),
(130923101, 130923, '连镇镇', 130923101),
(130923102, 130923, '找王镇', 130923102),
(130923103, 130923, '秦村镇', 130923103),
(130923104, 130923, '灯明寺镇', 130923104),
(130923105, 130923, '南霞口镇', 130923105),
(130923106, 130923, '大单镇', 130923106),
(130923200, 130923, '龙王李乡', 130923200),
(130923201, 130923, '于桥乡', 130923201),
(130924100, 130924, '苏基镇', 130924100),
(130924101, 130924, '辛集镇', 130924101),
(130924102, 130924, '高湾镇', 130924102),
(130924200, 130924, '赵毛陶乡', 130924200),
(130924201, 130924, '香坊乡', 130924201),
(130924202, 130924, '小山乡', 130924202),
(130924203, 130924, '张会亭乡', 130924203),
(130924400, 130924, '海兴县农场', 130924400),
(130924401, 130924, '青先农场', 130924401),
(130924402, 130924, '青锋农场', 130924402),
(130925100, 130925, '盐山镇', 130925100),
(130925101, 130925, '望树镇', 130925101),
(130925102, 130925, '庆云镇', 130925102),
(130925103, 130925, '韩集镇', 130925103),
(130925104, 130925, '千童镇', 130925104),
(130925105, 130925, '圣佛镇', 130925105),
(130925200, 130925, '边务乡', 130925200),
(130925201, 130925, '小营乡', 130925201),
(130925202, 130925, '杨集乡', 130925202),
(130925203, 130925, '孟店乡', 130925203),
(130925204, 130925, '常庄乡', 130925204),
(130925205, 130925, '小庄乡', 130925205),
(130926100, 130926, '肃宁镇', 130926100),
(130926101, 130926, '梁家村镇', 130926101),
(130926102, 130926, '窝北镇', 130926102),
(130926103, 130926, '尚村镇', 130926103),
(130926104, 130926, '万里镇', 130926104),
(130926201, 130926, '师素乡', 130926201),
(130926203, 130926, '河北留善寺乡', 130926203),
(130926204, 130926, '付家佐乡', 130926204),
(130926205, 130926, '邵庄乡', 130926205),
(130927100, 130927, '南皮镇', 130927100),
(130927101, 130927, '冯家口镇', 130927101),
(130927102, 130927, '寨子镇', 130927102),
(130927103, 130927, '鲍官屯镇', 130927103),
(130927104, 130927, '王寺镇', 130927104),
(130927105, 130927, '乌马营镇', 130927105),
(130927200, 130927, '大浪淀乡', 130927200),
(130927201, 130927, '刘八里乡', 130927201),
(130927202, 130927, '潞灌乡', 130927202),
(130928100, 130928, '桑园镇', 130928100),
(130928101, 130928, '铁城镇', 130928101),
(130928102, 130928, '于集镇', 130928102),
(130928103, 130928, '梁集镇', 130928103),
(130928104, 130928, '安陵镇', 130928104),
(130928200, 130928, '曹家洼乡', 130928200),
(130928201, 130928, '宋门乡', 130928201),
(130928202, 130928, '杨家寺乡', 130928202),
(130928203, 130928, '沟店铺乡', 130928203),
(130928204, 130928, '何庄乡', 130928204),
(130929100, 130929, '乐寿镇', 130929100),
(130929101, 130929, '淮镇镇', 130929101),
(130929102, 130929, '郭庄镇', 130929102),
(130929103, 130929, '河城街镇', 130929103),
(130929200, 130929, '韩村乡', 130929200),
(130929201, 130929, '陌南乡', 130929201),
(130929204, 130929, '陈庄乡', 130929204),
(130929205, 130929, '徐留高乡', 130929205),
(130929206, 130929, '商林乡', 130929206),
(130929207, 130929, '段村乡', 130929207),
(130929209, 130929, '张村乡', 130929209),
(130929210, 130929, '临河乡', 130929210),
(130929211, 130929, '小平王乡', 130929211),
(130929212, 130929, '十五级乡', 130929212),
(130929213, 130929, '垒头乡', 130929213),
(130929214, 130929, '南河头乡', 130929214),
(130929215, 130929, '西城乡', 130929215),
(130929216, 130929, '本斋回族乡', 130929216),
(130929400, 130929, '农场', 130929400),
(130930100, 130930, '孟村镇', 130930100),
(130930101, 130930, '新县镇', 130930101),
(130930102, 130930, '辛店镇', 130930102),
(130930103, 130930, '高寨镇', 130930103);
INSERT INTO `{pre}areas` VALUES
(130930200, 130930, '宋庄子乡', 130930200),
(130930201, 130930, '牛进庄乡', 130930201),
(130981001, 130981, '解放街道', 130981001),
(130981002, 130981, '河东街道', 130981002),
(130981003, 130981, '古楼街道', 130981003),
(130981100, 130981, '泊镇', 130981100),
(130981101, 130981, '交河镇', 130981101),
(130981102, 130981, '齐桥镇', 130981102),
(130981103, 130981, '寺门村镇', 130981103),
(130981104, 130981, '郝村镇', 130981104),
(130981105, 130981, '富镇镇', 130981105),
(130981106, 130981, '文庙镇', 130981106),
(130981107, 130981, '洼里王镇', 130981107),
(130981201, 130981, '王武庄乡', 130981201),
(130981202, 130981, '营子乡', 130981202),
(130981203, 130981, '四营乡', 130981203),
(130981204, 130981, '西辛店乡', 130981204),
(130982001, 130982, '新华路街道', 130982001),
(130982002, 130982, '西环路街道', 130982002),
(130982003, 130982, '永丰路街道', 130982003),
(130982100, 130982, '出岸镇', 130982100),
(130982101, 130982, '石门桥镇', 130982101),
(130982102, 130982, '吕公堡镇', 130982102),
(130982103, 130982, '长丰镇', 130982103),
(130982104, 130982, '莫州镇', 130982104),
(130982105, 130982, '苟各庄镇', 130982105),
(130982106, 130982, '梁召镇', 130982106),
(130982107, 130982, '辛中驿镇', 130982107),
(130982202, 130982, '麻家坞乡', 130982202),
(130982203, 130982, '议论堡乡', 130982203),
(130982204, 130982, '青塔乡', 130982204),
(130982205, 130982, '北辛庄乡', 130982205),
(130982206, 130982, '七间房乡', 130982206),
(130982207, 130982, '北汉乡', 130982207),
(130982208, 130982, '于村乡', 130982208),
(130982400, 130982, '华北石油管理局虚拟街道', 130982400),
(130982500, 130982, '开发区管理委员会', 130982500),
(130983001, 130983, '骅东街道', 130983001),
(130983002, 130983, '骅中街道', 130983002),
(130983003, 130983, '骅西街道', 130983003),
(130983100, 130983, '黄骅镇', 130983100),
(130983101, 130983, '南排河镇', 130983101),
(130983102, 130983, '吕桥镇', 130983102),
(130983103, 130983, '旧城镇', 130983103),
(130983200, 130983, '羊二庄回族乡', 130983200),
(130983202, 130983, '常郭乡', 130983202),
(130983203, 130983, '滕庄子乡', 130983203),
(130983204, 130983, '官庄乡', 130983204),
(130983205, 130983, '齐家务乡', 130983205),
(130983206, 130983, '港城开发区新村乡', 130983206),
(130983207, 130983, '羊三木乡', 130983207),
(130983400, 130983, '南大港管理区虚拟乡', 130983400),
(130983401, 130983, '国营中捷农场虚拟乡', 130983401),
(130983402, 130983, '黄骅港开发区虚拟乡', 130983402),
(130983403, 130983, '临港化工园区', 130983403),
(130984100, 130984, '瀛州镇', 130984100),
(130984101, 130984, '米各庄镇', 130984101),
(130984102, 130984, '景和镇', 130984102),
(130984103, 130984, '卧佛堂镇', 130984103),
(130984104, 130984, '束城镇', 130984104),
(130984105, 130984, '留古寺镇', 130984105),
(130984106, 130984, '沙河桥镇', 130984106),
(130984200, 130984, '故仙乡', 130984200),
(130984201, 130984, '黎民居乡', 130984201),
(130984202, 130984, '兴村乡', 130984202),
(130984203, 130984, '沙洼乡', 130984203),
(130984204, 130984, '西九吉乡', 130984204),
(130984205, 130984, '北石槽乡', 130984205),
(130984207, 130984, '诗经村乡', 130984207),
(130984208, 130984, '郭家村乡', 130984208),
(130984209, 130984, '时村乡', 130984209),
(130984210, 130984, '行别营乡', 130984210),
(130984211, 130984, '尊祖庄乡', 130984211),
(130984212, 130984, '龙华店乡', 130984212),
(130984213, 130984, '果子洼乡', 130984213),
(131002001, 131002, '银河南路街道', 131002001),
(131002002, 131002, '光明西道街道', 131002002),
(131002100, 131002, '落垡镇', 131002100),
(131002101, 131002, '码头镇', 131002101),
(131002102, 131002, '葛渔城镇', 131002102),
(131002103, 131002, '东沽港镇', 131002103),
(131002200, 131002, '杨税务乡', 131002200),
(131002201, 131002, '仇庄乡', 131002201),
(131002202, 131002, '调河头乡', 131002202),
(131002203, 131002, '北史家务乡', 131002203),
(131003001, 131003, '银河北路街道', 131003001),
(131003002, 131003, '爱民东道街道', 131003002),
(131003003, 131003, '解放道街道', 131003003),
(131003004, 131003, '新开路街道', 131003004),
(131003100, 131003, '南尖塔镇', 131003100),
(131003101, 131003, '万庄镇', 131003101),
(131003102, 131003, '九州镇', 131003102),
(131003200, 131003, '北旺乡', 131003200),
(131003450, 131003, '廊坊经济技术开发区', 131003450),
(131003500, 131003, '新世纪步行街管理委员会', 131003500),
(131022100, 131022, '固安镇', 131022100),
(131022101, 131022, '宫村镇', 131022101),
(131022102, 131022, '柳泉镇', 131022102),
(131022103, 131022, '牛驼镇', 131022103),
(131022104, 131022, '马庄镇', 131022104),
(131022200, 131022, '东湾乡', 131022200),
(131022201, 131022, '彭村乡', 131022201),
(131022202, 131022, '渠沟乡', 131022202),
(131022203, 131022, '礼让店乡', 131022203),
(131023001, 131023, '街道', 131023001),
(131023100, 131023, '永清镇', 131023100),
(131023101, 131023, '韩村镇', 131023101),
(131023102, 131023, '后奕镇', 131023102),
(131023103, 131023, '别古庄镇', 131023103),
(131023104, 131023, '里澜城镇', 131023104),
(131023200, 131023, '管家务回族乡', 131023200),
(131023201, 131023, '曹家务乡', 131023201),
(131023202, 131023, '龙虎庄乡', 131023202),
(131023203, 131023, '刘街乡', 131023203),
(131023204, 131023, '三圣口乡', 131023204),
(131024100, 131024, '淑阳镇', 131024100),
(131024101, 131024, '蒋辛屯镇', 131024101),
(131024102, 131024, '渠口镇', 131024102),
(131024103, 131024, '安头屯镇', 131024103),
(131024104, 131024, '安平镇', 131024104),
(131024105, 131024, '刘宋镇', 131024105),
(131024106, 131024, '五百户镇', 131024106),
(131024200, 131024, '钱旺乡', 131024200),
(131024201, 131024, '钳屯乡', 131024201),
(131024500, 131024, '香河开发区', 131024500),
(131025100, 131025, '平舒镇', 131025100),
(131025101, 131025, '旺村镇', 131025101),
(131025102, 131025, '大尚屯镇', 131025102),
(131025103, 131025, '南赵扶镇', 131025103),
(131025104, 131025, '留各庄镇', 131025104),
(131025105, 131025, '权村镇', 131025105),
(131025106, 131025, '里坦镇', 131025106),
(131025200, 131025, '北位乡', 131025200),
(131025201, 131025, '大广安乡', 131025201),
(131025202, 131025, '臧屯乡', 131025202),
(131025400, 131025, '摩配园区管委会', 131025400),
(131026100, 131026, '文安镇', 131026100),
(131026101, 131026, '新镇镇', 131026101),
(131026102, 131026, '苏桥镇', 131026102),
(131026103, 131026, '大柳河镇', 131026103),
(131026104, 131026, '左各庄镇', 131026104),
(131026105, 131026, '滩里镇', 131026105),
(131026106, 131026, '史各庄镇', 131026106),
(131026107, 131026, '赵各庄镇', 131026107),
(131026108, 131026, '兴隆宫镇', 131026108),
(131026109, 131026, '大留镇镇', 131026109),
(131026110, 131026, '孙氏镇', 131026110),
(131026111, 131026, '德归镇', 131026111),
(131026200, 131026, '大围河回族满族乡', 131026200),
(131028100, 131028, '大厂镇', 131028100),
(131028101, 131028, '夏垫镇', 131028101),
(131028102, 131028, '祁各庄镇', 131028102),
(131028201, 131028, '邵府乡', 131028201),
(131028202, 131028, '陈府乡', 131028202),
(131028400, 131028, '工业园区', 131028400),
(131081100, 131081, '霸州镇', 131081100),
(131081101, 131081, '南孟镇', 131081101),
(131081102, 131081, '信安镇', 131081102),
(131081103, 131081, '堂二里镇', 131081103),
(131081104, 131081, '煎茶铺镇', 131081104),
(131081105, 131081, '胜芳镇', 131081105),
(131081106, 131081, '杨芬港镇', 131081106),
(131081200, 131081, '岔河集乡', 131081200),
(131081201, 131081, '康仙庄乡', 131081201),
(131081202, 131081, '东杨庄乡', 131081202),
(131081203, 131081, '王庄子乡', 131081203),
(131081204, 131081, '东段乡', 131081204),
(131081450, 131081, '霸州经济技术开发区', 131081450),
(131082001, 131082, '南城街道', 131082001),
(131082002, 131082, '北城街道', 131082002),
(131082100, 131082, '泃阳镇', 131082100),
(131082101, 131082, '李旗庄镇', 131082101),
(131082102, 131082, '杨庄镇', 131082102),
(131082103, 131082, '皇庄镇', 131082103),
(131082104, 131082, '新集镇', 131082104),
(131082105, 131082, '段甲岭镇', 131082105),
(131082106, 131082, '黄土庄镇', 131082106),
(131082107, 131082, '高楼镇', 131082107),
(131082108, 131082, '齐心庄镇', 131082108),
(131082109, 131082, '燕郊镇', 131082109),
(131082450, 131082, '燕郊经济技术开发区', 131082450),
(131082451, 131082, '三河市农业高新技术园区', 131082451),
(131102001, 131102, '河西街道', 131102001),
(131102002, 131102, '河东街道', 131102002),
(131102003, 131102, '路北街道', 131102003),
(131102004, 131102, '中华街道', 131102004),
(131102100, 131102, '郑家河沿镇', 131102100),
(131102101, 131102, '赵家圈镇', 131102101),
(131102200, 131102, '何家庄乡', 131102200),
(131102201, 131102, '大麻森乡', 131102201),
(131102202, 131102, '邓家庄乡', 131102202),
(131102203, 131102, '彭杜村乡', 131102203),
(131102400, 131102, '衡水高新技术产业开发区', 131102400),
(131102401, 131102, '衡水湖自然保护区管理处', 131102401),
(131121100, 131121, '枣强镇', 131121100),
(131121101, 131121, '恩察镇', 131121101),
(131121102, 131121, '大营镇', 131121102),
(131121103, 131121, '嘉会镇', 131121103),
(131121104, 131121, '马屯镇', 131121104),
(131121105, 131121, '肖张镇', 131121105),
(131121200, 131121, '张秀屯乡', 131121200),
(131121201, 131121, '新屯乡', 131121201),
(131121202, 131121, '王均乡', 131121202),
(131121203, 131121, '唐林乡', 131121203),
(131121204, 131121, '王常乡', 131121204),
(131122100, 131122, '武邑镇', 131122100),
(131122101, 131122, '清凉店镇', 131122101),
(131122102, 131122, '审坡镇', 131122102),
(131122103, 131122, '赵桥镇', 131122103),
(131122104, 131122, '韩庄镇', 131122104),
(131122105, 131122, '肖桥头镇', 131122105),
(131122200, 131122, '龙店乡', 131122200),
(131122201, 131122, '圈头乡', 131122201),
(131122203, 131122, '大紫塔乡', 131122203),
(131123100, 131123, '武强镇', 131123100),
(131123101, 131123, '街关镇', 131123101),
(131123200, 131123, '豆村乡', 131123200),
(131123201, 131123, '北代乡', 131123201),
(131123202, 131123, '孙庄乡', 131123202),
(131123203, 131123, '周家窝乡', 131123203),
(131124100, 131124, '饶阳镇', 131124100),
(131124101, 131124, '大尹村镇', 131124101),
(131124102, 131124, '五公镇', 131124102),
(131124200, 131124, '王同岳乡', 131124200),
(131124201, 131124, '大官亭乡', 131124201),
(131124202, 131124, '留楚乡', 131124202),
(131124203, 131124, '东里满乡', 131124203),
(131125100, 131125, '安平镇', 131125100),
(131125101, 131125, '马店镇', 131125101),
(131125102, 131125, '南王庄镇', 131125102),
(131125200, 131125, '大何庄乡', 131125200),
(131125201, 131125, '程油子乡', 131125201),
(131125202, 131125, '西两洼乡', 131125202),
(131125203, 131125, '大子文乡', 131125203),
(131125204, 131125, '东黄城乡', 131125204),
(131126100, 131126, '郑口镇', 131126100),
(131126101, 131126, '夏庄镇', 131126101),
(131126102, 131126, '青罕镇', 131126102),
(131126103, 131126, '故城镇', 131126103),
(131126104, 131126, '武官寨镇', 131126104),
(131126105, 131126, '饶阳店镇', 131126105),
(131126106, 131126, '军屯镇', 131126106),
(131126107, 131126, '建国镇', 131126107),
(131126108, 131126, '西半屯镇', 131126108),
(131126200, 131126, '辛庄乡', 131126200),
(131126201, 131126, '里老乡', 131126201),
(131126202, 131126, '房庄乡', 131126202),
(131126203, 131126, '三朗乡', 131126203),
(131127100, 131127, '景州镇', 131127100),
(131127101, 131127, '龙华镇', 131127101),
(131127102, 131127, '广川镇', 131127102),
(131127103, 131127, '王瞳镇', 131127103),
(131127104, 131127, '洚河流镇', 131127104),
(131127105, 131127, '安陵镇', 131127105),
(131127106, 131127, '杜桥镇', 131127106),
(131127107, 131127, '王谦寺镇', 131127107),
(131127108, 131127, '北留智镇', 131127108),
(131127109, 131127, '留智庙镇', 131127109),
(131127200, 131127, '刘集乡', 131127200),
(131127201, 131127, '连镇乡', 131127201),
(131127202, 131127, '梁集乡', 131127202),
(131127203, 131127, '温城乡', 131127203),
(131127204, 131127, '后留名府乡', 131127204),
(131127205, 131127, '青兰乡', 131127205),
(131128100, 131128, '阜城镇', 131128100),
(131128101, 131128, '古城镇', 131128101),
(131128102, 131128, '码头镇', 131128102),
(131128103, 131128, '霞口镇', 131128103),
(131128104, 131128, '崔家庙镇', 131128104),
(131128200, 131128, '漫河乡', 131128200),
(131128201, 131128, '建桥乡', 131128201),
(131128202, 131128, '蒋坊乡', 131128202),
(131128203, 131128, '大白乡', 131128203),
(131128204, 131128, '王集乡', 131128204),
(131181100, 131181, '冀州镇', 131181100),
(131181101, 131181, '魏屯镇', 131181101),
(131181102, 131181, '官道李镇', 131181102),
(131181103, 131181, '南午村镇', 131181103),
(131181104, 131181, '周村镇', 131181104),
(131181105, 131181, '码头李镇', 131181105),
(131181106, 131181, '西王镇', 131181106),
(131181200, 131181, '门庄乡', 131181200),
(131181201, 131181, '徐家庄乡', 131181201),
(131181202, 131181, '北漳淮乡', 131181202),
(131181203, 131181, '小寨乡', 131181203),
(131182100, 131182, '唐奉镇', 131182100),
(131182101, 131182, '深州镇', 131182101),
(131182102, 131182, '辰时镇', 131182102),
(131182103, 131182, '榆科镇', 131182103),
(131182104, 131182, '魏桥镇', 131182104),
(131182105, 131182, '大堤镇', 131182105),
(131182106, 131182, '前磨头镇', 131182106),
(131182107, 131182, '王家井镇', 131182107),
(131182108, 131182, '护驾迟镇', 131182108),
(131182200, 131182, '兵曹乡', 131182200),
(131182201, 131182, '穆村乡', 131182201),
(131182202, 131182, '东安庄乡', 131182202),
(131182203, 131182, '北溪村乡', 131182203),
(131182204, 131182, '大冯营乡', 131182204),
(131182206, 131182, '乔屯乡', 131182206),
(131182207, 131182, '太古庄乡', 131182207),
(131182208, 131182, '大屯乡', 131182208),
(131182400, 131182, '河北省深州监狱', 131182400),
(140105001, 140105, '坞城街道', 140105001),
(140105002, 140105, '营盘街道', 140105002),
(140105003, 140105, '北营街道', 140105003),
(140105004, 140105, '平阳路街道', 140105004),
(140105005, 140105, '黄陵街道', 140105005),
(140105006, 140105, '小店街道', 140105006),
(140105100, 140105, '北格镇', 140105100),
(140105200, 140105, '西温庄乡', 140105200),
(140105201, 140105, '刘家堡乡', 140105201),
(140105401, 140105, '太原高新技术产业开发区', 140105401),
(140105501, 140105, '太原经济技术开发区', 140105501),
(140106001, 140106, '柳巷街道', 140106001),
(140106002, 140106, '文庙街道', 140106002),
(140106003, 140106, '庙前街道', 140106003),
(140106004, 140106, '迎泽街道', 140106004),
(140106005, 140106, '桥东街道', 140106005),
(140106006, 140106, '老军营街道', 140106006),
(140106100, 140106, '郝庄镇', 140106100),
(140106401, 140106, '民营区', 140106401),
(140107001, 140107, '巨轮街道', 140107001),
(140107002, 140107, '三桥街道', 140107002),
(140107003, 140107, '鼓楼街道', 140107003),
(140107004, 140107, '杏花岭街道', 140107004),
(140107005, 140107, '坝陵桥街道', 140107005),
(140107006, 140107, '大东关街道', 140107006),
(140107007, 140107, '职工新街街道', 140107007),
(140107008, 140107, '敦化坊街道', 140107008),
(140107009, 140107, '涧河街道', 140107009),
(140107010, 140107, '杨家峪街道', 140107010),
(140107200, 140107, '中涧河乡', 140107200),
(140107201, 140107, '小返乡', 140107201),
(140107401, 140107, '民营区', 140107401),
(140108001, 140108, '尖草坪街道', 140108001),
(140108002, 140108, '光社街道', 140108002),
(140108003, 140108, '上兰街道', 140108003),
(140108004, 140108, '南寨街道', 140108004),
(140108005, 140108, '迎新街道', 140108005),
(140108006, 140108, '古城街道', 140108006),
(140108007, 140108, '汇丰街道', 140108007),
(140108008, 140108, '柴村街道', 140108008),
(140108009, 140108, '新城街道', 140108009),
(140108100, 140108, '向阳镇', 140108100),
(140108101, 140108, '阳曲镇', 140108101),
(140108200, 140108, '马头水乡', 140108200),
(140108201, 140108, '柏板乡', 140108201),
(140108202, 140108, '西焉乡', 140108202),
(140109001, 140109, '千峰街道', 140109001),
(140109002, 140109, '下元街道', 140109002),
(140109003, 140109, '和平街道', 140109003),
(140109004, 140109, '兴华街道', 140109004),
(140109005, 140109, '万柏林街道', 140109005),
(140109006, 140109, '杜儿坪街道', 140109006),
(140109007, 140109, '白家庄街道', 140109007),
(140109008, 140109, '南寒街道', 140109008),
(140109009, 140109, '东社街道', 140109009),
(140109010, 140109, '化客头街道', 140109010),
(140109011, 140109, '小井峪街道', 140109011),
(140109012, 140109, '西铭街道', 140109012),
(140109013, 140109, '长风街道', 140109013),
(140109014, 140109, '神堂沟街道', 140109014),
(140109200, 140109, '王封乡', 140109200),
(140110001, 140110, '义井街道', 140110001),
(140110002, 140110, '罗城街道', 140110002),
(140110003, 140110, '晋源街道', 140110003),
(140110100, 140110, '金胜镇', 140110100),
(140110101, 140110, '晋祠镇', 140110101),
(140110102, 140110, '姚村镇', 140110102),
(140121100, 140121, '清源镇', 140121100),
(140121101, 140121, '徐沟镇', 140121101),
(140121102, 140121, '东于镇', 140121102),
(140121103, 140121, '孟封镇', 140121103),
(140121200, 140121, '马峪乡', 140121200),
(140121201, 140121, '柳杜乡', 140121201),
(140121202, 140121, '西谷乡', 140121202),
(140121203, 140121, '王答乡', 140121203),
(140121204, 140121, '集义乡', 140121204),
(140122100, 140122, '黄寨镇', 140122100),
(140122101, 140122, '大盂镇', 140122101),
(140122102, 140122, '东黄水镇', 140122102),
(140122103, 140122, '泥屯镇', 140122103),
(140122104, 140122, '阳曲县社区建设管理办公室', 140122104),
(140122200, 140122, '高村乡', 140122200),
(140122201, 140122, '侯村乡', 140122201),
(140122202, 140122, '凌井店乡', 140122202),
(140122203, 140122, '西凌井乡', 140122203),
(140122204, 140122, '北小店乡', 140122204),
(140122205, 140122, '杨兴乡', 140122205),
(140123100, 140123, '娄烦镇', 140123100),
(140123101, 140123, '静游镇', 140123101),
(140123102, 140123, '杜交曲镇', 140123102),
(140123200, 140123, '庙湾乡', 140123200),
(140123201, 140123, '马家庄乡', 140123201),
(140123202, 140123, '盖家庄乡', 140123202),
(140123203, 140123, '米峪镇乡', 140123203),
(140123204, 140123, '天池店乡', 140123204),
(140181001, 140181, '东曲街道', 140181001),
(140181002, 140181, '西曲街道', 140181002),
(140181003, 140181, '桃园街道', 140181003),
(140181004, 140181, '屯兰街道', 140181004),
(140181100, 140181, '河口镇', 140181100),
(140181101, 140181, '镇城底镇', 140181101),
(140181102, 140181, '马兰镇', 140181102),
(140181200, 140181, '阁上乡', 140181200),
(140181201, 140181, '加乐泉乡', 140181201),
(140181202, 140181, '梭峪乡', 140181202),
(140181203, 140181, '岔口乡', 140181203),
(140181204, 140181, '常安乡', 140181204),
(140181205, 140181, '原相乡', 140181205),
(140181206, 140181, '邢家社乡', 140181206),
(140202001, 140202, '南关街道', 140202001),
(140202002, 140202, '北关街道', 140202002),
(140202003, 140202, '东街街道', 140202003),
(140202004, 140202, '西街街道', 140202004),
(140202005, 140202, '南街街道', 140202005),
(140202006, 140202, '北街街道', 140202006),
(140202007, 140202, '新建南路街道', 140202007),
(140202008, 140202, '新建北路街道', 140202008),
(140202009, 140202, '大庆路街道', 140202009),
(140202010, 140202, '新华街街道', 140202010),
(140202011, 140202, '西花园街道', 140202011),
(140202012, 140202, '老平旺街道', 140202012),
(140202013, 140202, '向阳里街道', 140202013),
(140202014, 140202, '振华街街道', 140202014),
(140203001, 140203, '新胜街道', 140203001),
(140203002, 140203, '新平旺街道', 140203002),
(140203003, 140203, '煤峪口街道', 140203003),
(140203004, 140203, '永定庄街道', 140203004),
(140203005, 140203, '同家梁街道', 140203005),
(140203006, 140203, '四老沟街道', 140203006),
(140203007, 140203, '忻州窑街道', 140203007),
(140203008, 140203, '白洞街道', 140203008),
(140203009, 140203, '雁崖街道', 140203009),
(140203010, 140203, '挖金湾街道', 140203010),
(140203011, 140203, '晋华宫街道', 140203011),
(140203012, 140203, '马脊梁街道', 140203012),
(140203013, 140203, '大斗沟街道', 140203013),
(140203014, 140203, '王村街道', 140203014),
(140203015, 140203, '姜家湾街道', 140203015),
(140203016, 140203, '新泉路街道', 140203016),
(140203017, 140203, '民胜街道', 140203017),
(140203018, 140203, '口泉街道', 140203018),
(140203019, 140203, '马口街道', 140203019),
(140203020, 140203, '燕子山街道', 140203020),
(140203021, 140203, '杏儿沟街道', 140203021),
(140203022, 140203, '青磁窑街道', 140203022),
(140203023, 140203, '平泉路街道', 140203023),
(140203024, 140203, '四台沟街道', 140203024),
(140211100, 140211, '古店镇', 140211100),
(140211101, 140211, '高山镇', 140211101),
(140211102, 140211, '云冈镇', 140211102),
(140211200, 140211, '口泉乡', 140211200),
(140211201, 140211, '新旺乡', 140211201),
(140211202, 140211, '水泊寺乡', 140211202),
(140211205, 140211, '马军营乡', 140211205),
(140211206, 140211, '西韩岭乡', 140211206),
(140211207, 140211, '平旺乡', 140211207),
(140211210, 140211, '鸦儿崖乡', 140211210),
(140212001, 140212, '新荣区社区服务管理中心', 140212001),
(140212100, 140212, '新荣镇', 140212100),
(140212200, 140212, '破鲁堡乡', 140212200),
(140212202, 140212, '郭家窑乡', 140212202),
(140212203, 140212, '花元屯乡', 140212203),
(140212206, 140212, '西村乡', 140212206),
(140212207, 140212, '上深涧乡', 140212207),
(140212209, 140212, '堡子湾乡', 140212209),
(140221100, 140221, '龙泉镇', 140221100),
(140221101, 140221, '罗文皂镇', 140221101),
(140221102, 140221, '大白登镇', 140221102),
(140221103, 140221, '王官屯镇', 140221103),
(140221104, 140221, '古城镇', 140221104),
(140221105, 140221, '东小村镇', 140221105),
(140221106, 140221, '友宰镇', 140221106),
(140221201, 140221, '长城乡', 140221201),
(140221202, 140221, '北徐屯乡', 140221202),
(140221204, 140221, '狮子屯乡', 140221204),
(140221209, 140221, '下深井乡', 140221209),
(140221211, 140221, '马家皂乡', 140221211),
(140221212, 140221, '鳌石乡', 140221212),
(140222100, 140222, '玉泉镇', 140222100),
(140222101, 140222, '谷前堡镇', 140222101),
(140222102, 140222, '米薪关镇', 140222102),
(140222103, 140222, '逯家湾镇', 140222103),
(140222104, 140222, '新平镇', 140222104),
(140222200, 140222, '卅里铺乡', 140222200),
(140222202, 140222, '南河堡乡', 140222202),
(140222204, 140222, '贾家屯乡', 140222204),
(140222206, 140222, '赵家沟乡', 140222206),
(140222208, 140222, '南高崖乡', 140222208),
(140222209, 140222, '张西河乡', 140222209),
(140223100, 140223, '壶泉镇', 140223100),
(140223101, 140223, '南村镇', 140223101),
(140223200, 140223, '斗泉乡', 140223200),
(140223202, 140223, '蕉山乡', 140223202),
(140223203, 140223, '加斗乡', 140223203),
(140223206, 140223, '宜兴乡', 140223206),
(140223207, 140223, '作疃乡', 140223207),
(140223209, 140223, '梁庄乡', 140223209),
(140223211, 140223, '望狐乡', 140223211),
(140224100, 140224, '武灵镇', 140224100),
(140224101, 140224, '东河南镇', 140224101),
(140224102, 140224, '上寨镇', 140224102),
(140224200, 140224, '落水河乡', 140224200),
(140224203, 140224, '史庄乡', 140224203),
(140224205, 140224, '赵北乡', 140224205),
(140224206, 140224, '石家田乡', 140224206),
(140224207, 140224, '柳科乡', 140224207),
(140224208, 140224, '白崖台乡', 140224208),
(140224210, 140224, '红石塄乡', 140224210),
(140224212, 140224, '下关乡', 140224212),
(140224213, 140224, '独峪乡', 140224213),
(140225100, 140225, '永安镇', 140225100),
(140225101, 140225, '西坊城镇', 140225101),
(140225102, 140225, '蔡村镇', 140225102),
(140225103, 140225, '沙圪坨镇', 140225103),
(140225104, 140225, '王庄堡镇', 140225104),
(140225105, 140225, '大磁窑镇', 140225105),
(140225201, 140225, '东坊城乡', 140225201),
(140225203, 140225, '裴村乡', 140225203),
(140225204, 140225, '驼峰乡', 140225204),
(140225205, 140225, '西留村乡', 140225205),
(140225206, 140225, '下韩村乡', 140225206),
(140225208, 140225, '南榆林乡', 140225208),
(140225210, 140225, '吴城乡', 140225210),
(140225212, 140225, '黄花滩乡', 140225212),
(140225213, 140225, '大仁庄乡', 140225213),
(140225215, 140225, '千佛岭乡', 140225215),
(140225218, 140225, '官儿乡', 140225218),
(140225220, 140225, '青磁窑乡', 140225220),
(140226100, 140226, '云兴镇', 140226100),
(140226101, 140226, '鹊儿山镇', 140226101),
(140226102, 140226, '店湾镇', 140226102),
(140226200, 140226, '管家堡乡', 140226200),
(140226201, 140226, '张家场乡', 140226201),
(140226205, 140226, '三屯乡', 140226205),
(140226206, 140226, '马道头乡', 140226206),
(140226207, 140226, '小京庄乡', 140226207),
(140226209, 140226, '水窑乡', 140226209),
(140227001, 140227, '湖东街道', 140227001),
(140227002, 140227, '东街街道', 140227002),
(140227003, 140227, '西街街道', 140227003),
(140227100, 140227, '西坪镇', 140227100),
(140227101, 140227, '倍加造镇', 140227101),
(140227102, 140227, '周士庄镇', 140227102),
(140227201, 140227, '吉家庄乡', 140227201),
(140227202, 140227, '峰峪乡', 140227202),
(140227204, 140227, '杜庄乡', 140227204),
(140227205, 140227, '党留庄乡', 140227205),
(140227207, 140227, '瓜园乡', 140227207),
(140227209, 140227, '巨乐乡', 140227209),
(140227211, 140227, '许堡乡', 140227211),
(140227400, 140227, '经济技术开发区', 140227400),
(140302001, 140302, '上站街道', 140302001),
(140302002, 140302, '下站街道', 140302002),
(140302003, 140302, '北大街街道', 140302003),
(140302004, 140302, '南山路街道', 140302004),
(140302005, 140302, '义井街道', 140302005),
(140302006, 140302, '坡底街道', 140302006),
(140303001, 140303, '平潭街街道', 140303001),
(140303002, 140303, '桥头街道', 140303002),
(140303003, 140303, '蔡洼街道', 140303003),
(140303004, 140303, '赛鱼街道', 140303004),
(140303005, 140303, '沙坪街道', 140303005),
(140303006, 140303, '贵石沟街道', 140303006),
(140311100, 140311, '荫营镇', 140311100),
(140311101, 140311, '河底镇', 140311101),
(140311102, 140311, '义井镇', 140311102),
(140311103, 140311, '平坦镇', 140311103),
(140311200, 140311, '西南舁乡', 140311200),
(140311201, 140311, '杨家庄乡', 140311201),
(140311202, 140311, '李家庄乡', 140311202),
(140311203, 140311, '旧街乡', 140311203),
(140311450, 140311, '开发区', 140311450),
(140321100, 140321, '冠山镇', 140321100),
(140321101, 140321, '冶西镇', 140321101),
(140321102, 140321, '锁簧镇', 140321102),
(140321103, 140321, '张庄镇', 140321103),
(140321104, 140321, '东回镇', 140321104),
(140321105, 140321, '柏井镇', 140321105),
(140321106, 140321, '娘子关镇', 140321106),
(140321107, 140321, '巨城镇', 140321107),
(140321200, 140321, '石门口乡', 140321200),
(140321201, 140321, '岔口乡', 140321201),
(140322100, 140322, '秀水镇', 140322100),
(140322101, 140322, '孙家庄镇', 140322101),
(140322102, 140322, '路家村镇', 140322102),
(140322103, 140322, '南娄镇', 140322103),
(140322104, 140322, '牛村镇', 140322104),
(140322105, 140322, '长池镇', 140322105),
(140322106, 140322, '上社镇', 140322106),
(140322107, 140322, '西烟镇', 140322107),
(140322200, 140322, '仙人乡', 140322200),
(140322201, 140322, '北下庄乡', 140322201),
(140322202, 140322, '下社乡', 140322202),
(140322203, 140322, '梁家寨乡', 140322203),
(140322204, 140322, '西潘乡', 140322204),
(140322205, 140322, '东梁乡', 140322205),
(140402001, 140402, '东街街道', 140402001),
(140402002, 140402, '西街街道', 140402002),
(140402003, 140402, '英雄南路街道', 140402003),
(140402004, 140402, '英雄中路街道', 140402004),
(140402005, 140402, '紫金路街道', 140402005),
(140402006, 140402, '太东街道', 140402006),
(140402007, 140402, '太西街道', 140402007),
(140402008, 140402, '延安南路街道', 140402008),
(140402009, 140402, '常青街道', 140402009),
(140402010, 140402, '五马街道', 140402010),
(140402400, 140402, '长治市高新技术开发区', 140402400),
(140411001, 140411, '长北街道', 140411001),
(140411002, 140411, '故县街道', 140411002),
(140411100, 140411, '老顶山镇', 140411100),
(140411101, 140411, '堠北庄镇', 140411101),
(140411102, 140411, '大辛庄镇', 140411102),
(140411103, 140411, '马厂镇', 140411103),
(140411104, 140411, '黄碾镇', 140411104),
(140411200, 140411, '西白兔乡', 140411200),
(140421100, 140421, '韩店镇', 140421100),
(140421101, 140421, '苏店镇', 140421101),
(140421102, 140421, '荫城镇', 140421102),
(140421103, 140421, '西火镇', 140421103),
(140421104, 140421, '八义镇', 140421104),
(140421105, 140421, '贾掌镇', 140421105),
(140421200, 140421, '郝家庄乡', 140421200),
(140421201, 140421, '西池乡', 140421201),
(140421202, 140421, '北呈乡', 140421202),
(140421203, 140421, '东和乡', 140421203),
(140421204, 140421, '南宋乡', 140421204),
(140423100, 140423, '古韩镇', 140423100),
(140423101, 140423, '王桥镇', 140423101),
(140423102, 140423, '侯堡镇', 140423102),
(140423103, 140423, '夏店镇', 140423103),
(140423104, 140423, '虎（音si）亭镇', 140423104),
(140423105, 140423, '西营镇', 140423105),
(140423106, 140423, '王村镇', 140423106),
(140423107, 140423, '下良镇', 140423107),
(140423200, 140423, '善福乡', 140423200),
(140423201, 140423, '北底乡', 140423201),
(140423202, 140423, '上马乡', 140423202),
(140424100, 140424, '麟绛镇', 140424100),
(140424101, 140424, '上村镇', 140424101),
(140424102, 140424, '渔泽镇', 140424102),
(140424103, 140424, '余吾镇', 140424103),
(140424104, 140424, '吾元镇', 140424104),
(140424105, 140424, '张店镇', 140424105),
(140424106, 140424, '丰宜镇', 140424106),
(140424200, 140424, '李高乡', 140424200),
(140424201, 140424, '路村乡', 140424201),
(140424202, 140424, '河神庙乡', 140424202),
(140424203, 140424, '西贾乡', 140424203),
(140424400, 140424, '西流寨开发区', 140424400),
(140424401, 140424, '康庄工业园区', 140424401),
(140424402, 140424, '上莲开发区', 140424402),
(140425100, 140425, '青羊镇', 140425100),
(140425101, 140425, '龙溪镇', 140425101),
(140425102, 140425, '石城镇', 140425102),
(140425103, 140425, '苗庄镇', 140425103),
(140425104, 140425, '杏城镇', 140425104),
(140425200, 140425, '西沟乡', 140425200),
(140425201, 140425, '东寺头乡', 140425201),
(140425202, 140425, '虹梯关乡', 140425202),
(140425203, 140425, '阳高乡', 140425203),
(140425204, 140425, '北耽车乡', 140425204),
(140425205, 140425, '中五井乡', 140425205),
(140425206, 140425, '北社乡', 140425206),
(140426100, 140426, '黎侯镇', 140426100),
(140426101, 140426, '东阳关镇', 140426101),
(140426102, 140426, '上遥镇', 140426102),
(140426103, 140426, '西井镇', 140426103),
(140426104, 140426, '黄崖洞镇', 140426104),
(140426200, 140426, '西仵乡', 140426200),
(140426201, 140426, '停河铺乡', 140426201),
(140426202, 140426, '程家山乡', 140426202),
(140426203, 140426, '洪井乡', 140426203),
(140427100, 140427, '龙泉镇', 140427100),
(140427101, 140427, '百尺镇', 140427101),
(140427102, 140427, '店上镇', 140427102),
(140427103, 140427, '晋庄镇', 140427103),
(140427104, 140427, '树掌镇', 140427104),
(140427200, 140427, '集店乡', 140427200),
(140427201, 140427, '黄山乡', 140427201),
(140427202, 140427, '东井岭乡', 140427202),
(140427203, 140427, '石坡乡', 140427203),
(140427204, 140427, '五龙山乡', 140427204),
(140427205, 140427, '鹅屋乡', 140427205),
(140427206, 140427, '桥上乡', 140427206),
(140427400, 140427, '常平经济开发区', 140427400),
(140428100, 140428, '丹朱镇', 140428100),
(140428101, 140428, '鲍店镇', 140428101),
(140428102, 140428, '石哲镇', 140428102),
(140428103, 140428, '大堡头镇', 140428103),
(140428104, 140428, '慈林镇', 140428104),
(140428105, 140428, '色头镇', 140428105),
(140428106, 140428, '南漳镇', 140428106),
(140428200, 140428, '岚水乡', 140428200),
(140428201, 140428, '碾张乡', 140428201),
(140428202, 140428, '常张乡', 140428202),
(140428203, 140428, '南陈乡', 140428203),
(140428204, 140428, '宋村乡', 140428204),
(140429100, 140429, '丰州镇', 140429100),
(140429101, 140429, '洪水镇', 140429101),
(140429102, 140429, '蟠龙镇', 140429102),
(140429103, 140429, '监漳镇', 140429103),
(140429104, 140429, '故城镇', 140429104),
(140429200, 140429, '墨镫乡', 140429200),
(140429201, 140429, '韩北乡', 140429201),
(140429202, 140429, '大有乡', 140429202),
(140429203, 140429, '贾豁乡', 140429203),
(140429204, 140429, '故县乡', 140429204),
(140429205, 140429, '上司乡', 140429205),
(140429206, 140429, '石北乡', 140429206),
(140429207, 140429, '涌泉乡', 140429207),
(140429208, 140429, '分水岭乡', 140429208),
(140430100, 140430, '定昌镇', 140430100),
(140430101, 140430, '郭村镇', 140430101),
(140430102, 140430, '故县镇', 140430102),
(140430103, 140430, '新店镇', 140430103),
(140430104, 140430, '漳源镇', 140430104),
(140430105, 140430, '册村镇', 140430105),
(140430200, 140430, '段柳乡', 140430200),
(140430201, 140430, '松村乡', 140430201),
(140430202, 140430, '次村乡', 140430202),
(140430203, 140430, '牛寺乡', 140430203),
(140430204, 140430, '南里乡', 140430204),
(140430205, 140430, '南泉乡', 140430205),
(140430206, 140430, '杨安乡', 140430206),
(140431100, 140431, '沁河镇', 140431100),
(140431101, 140431, '郭道镇', 140431101),
(140431102, 140431, '灵空山镇', 140431102),
(140431103, 140431, '王和镇', 140431103),
(140431104, 140431, '李元镇', 140431104),
(140431200, 140431, '中峪乡', 140431200),
(140431201, 140431, '法中乡', 140431201),
(140431202, 140431, '交口乡', 140431202),
(140431203, 140431, '聪子峪乡', 140431203),
(140431204, 140431, '韩洪乡', 140431204),
(140431205, 140431, '官滩乡', 140431205),
(140431206, 140431, '景凤乡', 140431206),
(140431207, 140431, '赤石桥乡', 140431207),
(140431208, 140431, '王陶乡', 140431208),
(140481001, 140481, '潞华', 140481001),
(140481002, 140481, '成家川', 140481002),
(140481100, 140481, '店上镇', 140481100),
(140481101, 140481, '微子镇', 140481101),
(140481102, 140481, '辛安泉镇', 140481102),
(140481103, 140481, '翟店镇', 140481103),
(140481200, 140481, '合室乡', 140481200),
(140481201, 140481, '黄牛蹄乡', 140481201),
(140481202, 140481, '史回乡', 140481202),
(140502001, 140502, '东街街道', 140502001),
(140502002, 140502, '西街街道', 140502002),
(140502003, 140502, '南街街道', 140502003),
(140502004, 140502, '北街街道', 140502004),
(140502005, 140502, '矿区街道', 140502005),
(140502006, 140502, '钟家庄街道', 140502006),
(140502007, 140502, '西上庄街道', 140502007),
(140502100, 140502, '北石店镇', 140502100),
(140521100, 140521, '龙港镇', 140521100),
(140521101, 140521, '中村镇', 140521101),
(140521102, 140521, '郑庄镇', 140521102),
(140521103, 140521, '端氏镇', 140521103),
(140521104, 140521, '嘉峰镇', 140521104),
(140521105, 140521, '郑村镇', 140521105),
(140521106, 140521, '柿庄镇', 140521106),
(140521200, 140521, '樊村河乡', 140521200),
(140521201, 140521, '土沃乡', 140521201),
(140521202, 140521, '张村乡', 140521202),
(140521203, 140521, '苏庄乡', 140521203),
(140521204, 140521, '胡底乡', 140521204),
(140521205, 140521, '固县乡', 140521205),
(140521206, 140521, '十里乡', 140521206),
(140522001, 140522, '东城街道', 140522001),
(140522100, 140522, '凤城镇', 140522100),
(140522101, 140522, '北留镇', 140522101),
(140522102, 140522, '润城镇', 140522102),
(140522103, 140522, '町店镇', 140522103),
(140522104, 140522, '芹池镇', 140522104),
(140522105, 140522, '次营镇', 140522105),
(140522106, 140522, '横河镇', 140522106),
(140522107, 140522, '河北镇', 140522107),
(140522108, 140522, '蟒河镇', 140522108),
(140522109, 140522, '东冶镇', 140522109),
(140522200, 140522, '白桑乡', 140522200),
(140522201, 140522, '寺头乡', 140522201),
(140522202, 140522, '西河乡', 140522202),
(140522203, 140522, '演礼乡', 140522203),
(140522204, 140522, '固隆乡', 140522204),
(140522205, 140522, '董封乡', 140522205),
(140522206, 140522, '驾岭乡', 140522206),
(140524100, 140524, '崇文镇', 140524100),
(140524101, 140524, '礼义镇', 140524101),
(140524102, 140524, '附城镇', 140524102),
(140524103, 140524, '西河底镇', 140524103),
(140524104, 140524, '平城镇', 140524104),
(140524105, 140524, '杨村镇', 140524105),
(140524106, 140524, '潞城镇', 140524106),
(140524204, 140524, '夺火乡', 140524204),
(140524206, 140524, '马圪当乡', 140524206),
(140524207, 140524, '古郊乡', 140524207),
(140524209, 140524, '六泉乡', 140524209),
(140524212, 140524, '秦家庄乡', 140524212),
(140525100, 140525, '南村镇', 140525100),
(140525101, 140525, '下村镇', 140525101),
(140525102, 140525, '大东沟镇', 140525102),
(140525103, 140525, '周村镇', 140525103),
(140525104, 140525, '犁川镇', 140525104),
(140525105, 140525, '晋庙铺镇', 140525105),
(140525106, 140525, '金村镇', 140525106),
(140525107, 140525, '高都镇', 140525107),
(140525108, 140525, '巴公镇', 140525108),
(140525109, 140525, '大阳镇', 140525109),
(140525110, 140525, '山河镇', 140525110),
(140525111, 140525, '大箕镇', 140525111),
(140525112, 140525, '柳树口镇', 140525112),
(140525113, 140525, '北义城镇', 140525113),
(140525200, 140525, '川底乡', 140525200),
(140525201, 140525, '李寨乡', 140525201),
(140525202, 140525, '南岭乡', 140525202),
(140581001, 140581, '北城街道', 140581001),
(140581002, 140581, '东城街道', 140581002),
(140581003, 140581, '南城街道', 140581003),
(140581101, 140581, '米山镇', 140581101),
(140581102, 140581, '三甲镇', 140581102),
(140581103, 140581, '神农镇', 140581103),
(140581104, 140581, '陈区镇', 140581104),
(140581105, 140581, '北诗镇', 140581105),
(140581106, 140581, '河西镇', 140581106),
(140581107, 140581, '马村镇', 140581107),
(140581108, 140581, '野川镇', 140581108),
(140581109, 140581, '寺庄镇', 140581109),
(140581201, 140581, '建宁乡', 140581201),
(140581202, 140581, '石末乡', 140581202),
(140581203, 140581, '原村乡', 140581203),
(140581204, 140581, '永录乡', 140581204),
(140602001, 140602, '朔城区北城街道', 140602001),
(140602002, 140602, '朔城区南城街道', 140602002),
(140602003, 140602, '朔城区神头街道', 140602003),
(140602004, 140602, '朔城区北旺庄街道', 140602004),
(140602100, 140602, '朔城区神头镇', 140602100),
(140602101, 140602, '朔城区利民镇', 140602101),
(140602200, 140602, '朔城区下团堡乡', 140602200),
(140602201, 140602, '朔城区小平易乡', 140602201),
(140602202, 140602, '朔城区滋润乡', 140602202),
(140602203, 140602, '朔城区福善庄乡', 140602203),
(140602204, 140602, '朔城区南榆林乡', 140602204),
(140602205, 140602, '朔城区贾庄乡', 140602205),
(140602206, 140602, '朔城区沙塄河乡', 140602206),
(140602207, 140602, '朔城区窑子头乡', 140602207),
(140602208, 140602, '朔城区张蔡庄乡', 140602208),
(140602400, 140602, '朔州市开发区管委会', 140602400),
(140603100, 140603, '平鲁区井坪镇', 140603100),
(140603101, 140603, '平鲁区凤凰城镇', 140603101),
(140603200, 140603, '平鲁区白堂乡', 140603200),
(140603201, 140603, '平鲁区陶村乡', 140603201),
(140603202, 140603, '平鲁区下水头乡', 140603202),
(140603203, 140603, '平鲁区双碾乡', 140603203),
(140603204, 140603, '平鲁区阻虎乡', 140603204),
(140603205, 140603, '平鲁区高石庄乡', 140603205),
(140603206, 140603, '平鲁区西水界乡', 140603206),
(140603207, 140603, '平鲁区下面高乡', 140603207),
(140603208, 140603, '平鲁区下木角乡', 140603208),
(140603209, 140603, '平鲁区向阳堡乡', 140603209),
(140603210, 140603, '平鲁区榆岭乡', 140603210),
(140621001, 140621, '东城管委会', 140621001),
(140621002, 140621, '西城管委会', 140621002),
(140621100, 140621, '玉井镇', 140621100),
(140621101, 140621, '北周庄镇', 140621101),
(140621102, 140621, '古城镇', 140621102),
(140621200, 140621, '吴马营乡', 140621200),
(140621201, 140621, '马营乡', 140621201),
(140621202, 140621, '下喇叭乡', 140621202),
(140621203, 140621, '合盛堡乡', 140621203),
(140621204, 140621, '岱岳乡', 140621204),
(140621205, 140621, '安荣乡', 140621205),
(140621206, 140621, '薛OO乡', 140621206),
(140621207, 140621, '后所乡', 140621207),
(140621208, 140621, '张家庄乡', 140621208),
(140621209, 140621, '马营庄乡', 140621209),
(140622100, 140622, '金城镇', 140622100),
(140622101, 140622, '南河种镇', 140622101),
(140622102, 140622, '下社镇', 140622102),
(140622200, 140622, '镇子梁乡', 140622200),
(140622201, 140622, '义井乡', 140622201),
(140622202, 140622, '藏寨乡', 140622202),
(140622203, 140622, '大黄巍乡', 140622203),
(140622204, 140622, '杏寨乡', 140622204),
(140622205, 140622, '下马峪乡', 140622205),
(140622206, 140622, '南泉乡', 140622206),
(140622207, 140622, '大临河乡', 140622207),
(140622208, 140622, '白马石乡', 140622208),
(140623100, 140623, '新城镇', 140623100),
(140623101, 140623, '右卫镇', 140623101),
(140623102, 140623, '威远镇', 140623102),
(140623103, 140623, '元堡子镇', 140623103),
(140623200, 140623, '牛心堡乡', 140623200),
(140623201, 140623, '白头里乡', 140623201),
(140623202, 140623, '高家堡乡', 140623202),
(140623203, 140623, '丁家窑乡', 140623203),
(140623204, 140623, '杨千河乡', 140623204),
(140623205, 140623, '李达窑乡', 140623205),
(140624100, 140624, '云中镇', 140624100),
(140624101, 140624, '吴家窑镇', 140624101),
(140624102, 140624, '金沙滩镇', 140624102),
(140624103, 140624, '毛家皂镇', 140624103),
(140624200, 140624, '何家堡乡', 140624200),
(140624201, 140624, '新家园乡', 140624201),
(140624202, 140624, '亲和乡', 140624202),
(140624203, 140624, '海北头乡', 140624203),
(140624204, 140624, '马辛庄乡', 140624204),
(140624205, 140624, '河头乡', 140624205),
(140624500, 140624, '金沙滩农牧场', 140624500),
(140624501, 140624, '金沙滩林场', 140624501),
(140702001, 140702, '北关街道', 140702001),
(140702002, 140702, '锦纶街道', 140702002),
(140702003, 140702, '新华街道', 140702003),
(140702004, 140702, '西南街道', 140702004),
(140702005, 140702, '路西街道', 140702005),
(140702006, 140702, '经纬街道', 140702006),
(140702007, 140702, '安宁街道', 140702007),
(140702008, 140702, '新建街道', 140702008),
(140702009, 140702, '晋华街道', 140702009),
(140702100, 140702, '乌金山镇', 140702100),
(140702101, 140702, '东阳镇', 140702101),
(140702102, 140702, '什贴镇', 140702102),
(140702103, 140702, '长凝镇', 140702103),
(140702104, 140702, '北田镇', 140702104),
(140702105, 140702, '修文镇', 140702105),
(140702200, 140702, '郭家堡乡', 140702200),
(140702201, 140702, '张庆乡', 140702201),
(140702202, 140702, '庄子乡', 140702202),
(140702203, 140702, '东赵乡', 140702203),
(140702400, 140702, '晋中经济开发区', 140702400),
(140721001, 140721, '城区街道管理委员会', 140721001),
(140721100, 140721, '箕城镇', 140721100),
(140721101, 140721, '云竹镇', 140721101),
(140721102, 140721, '郝北镇', 140721102),
(140721103, 140721, '社城镇', 140721103),
(140721200, 140721, '河峪乡', 140721200),
(140721201, 140721, '北寨乡', 140721201),
(140721202, 140721, '西马乡', 140721202),
(140721203, 140721, '岚峪乡', 140721203),
(140721204, 140721, '讲堂乡', 140721204),
(140722001, 140722, '县城街道社区管理委员会', 140722001),
(140722100, 140722, '辽阳镇', 140722100),
(140722101, 140722, '桐峪镇', 140722101),
(140722102, 140722, '麻田镇', 140722102),
(140722103, 140722, '芹泉镇', 140722103),
(140722104, 140722, '拐儿镇', 140722104),
(140722200, 140722, '寒王乡', 140722200),
(140722201, 140722, '石匣乡', 140722201),
(140722202, 140722, '龙泉乡', 140722202),
(140722203, 140722, '粟城乡', 140722203),
(140722204, 140722, '羊角乡', 140722204),
(140723100, 140723, '义兴镇', 140723100),
(140723101, 140723, '李阳镇', 140723101),
(140723102, 140723, '松烟镇', 140723102),
(140723103, 140723, '青城镇', 140723103),
(140723104, 140723, '横岭镇', 140723104),
(140723200, 140723, '喂马乡', 140723200),
(140723201, 140723, '平松乡', 140723201),
(140723202, 140723, '牛川乡', 140723202),
(140723203, 140723, '马坊乡', 140723203),
(140723204, 140723, '阳光占乡', 140723204),
(140724100, 140724, '乐平镇', 140724100),
(140724101, 140724, '皋落镇', 140724101),
(140724102, 140724, '冶头镇', 140724102),
(140724103, 140724, '沾尚镇', 140724103),
(140724104, 140724, '大寨镇', 140724104),
(140724200, 140724, '李家庄乡', 140724200),
(140724201, 140724, '界都乡', 140724201),
(140724202, 140724, '三都乡', 140724202),
(140724203, 140724, '赵壁乡', 140724203),
(140724204, 140724, '孔氏乡', 140724204),
(140724205, 140724, '阎庄乡', 140724205),
(140724206, 140724, '西寨乡', 140724206),
(140725100, 140725, '朝阳镇', 140725100),
(140725101, 140725, '南燕竹镇', 140725101),
(140725102, 140725, '宗艾镇', 140725102),
(140725103, 140725, '平头镇', 140725103),
(140725104, 140725, '松塔镇', 140725104),
(140725105, 140725, '西洛镇', 140725105),
(140725106, 140725, '尹灵芝镇', 140725106),
(140725200, 140725, '平舒乡', 140725200),
(140725201, 140725, '解愁乡', 140725201),
(140725202, 140725, '温家庄乡', 140725202),
(140725203, 140725, '景尚乡', 140725203),
(140725204, 140725, '上湖乡', 140725204),
(140725205, 140725, '羊头崖乡', 140725205),
(140725206, 140725, '马首乡', 140725206),
(140726100, 140726, '明星镇', 140726100),
(140726101, 140726, '胡村镇', 140726101),
(140726102, 140726, '范村镇', 140726102),
(140726200, 140726, '侯城乡', 140726200),
(140726201, 140726, '北汪乡', 140726201),
(140726202, 140726, '水秀乡', 140726202),
(140726203, 140726, '阳邑乡', 140726203),
(140726204, 140726, '小白乡', 140726204),
(140726205, 140726, '任村乡', 140726205),
(140727100, 140727, '昭馀镇', 140727100),
(140727101, 140727, '东观镇', 140727101),
(140727102, 140727, '古县镇', 140727102),
(140727103, 140727, '贾令镇', 140727103),
(140727104, 140727, '城赵镇', 140727104),
(140727105, 140727, '来远镇', 140727105),
(140727200, 140727, '西六支乡', 140727200),
(140727201, 140727, '峪口乡', 140727201),
(140728100, 140728, '古陶镇', 140728100),
(140728101, 140728, '段村镇', 140728101),
(140728102, 140728, '东泉镇', 140728102),
(140728103, 140728, '洪善镇', 140728103),
(140728104, 140728, '宁固镇', 140728104),
(140728200, 140728, '南政乡', 140728200),
(140728201, 140728, '中都乡', 140728201),
(140728202, 140728, '岳壁乡', 140728202),
(140728203, 140728, '卜宜乡', 140728203),
(140728204, 140728, '孟山乡', 140728204),
(140728205, 140728, '朱坑乡', 140728205),
(140728206, 140728, '襄垣乡', 140728206),
(140728207, 140728, '杜家庄乡', 140728207),
(140728208, 140728, '香乐乡', 140728208),
(140729100, 140729, '翠峰镇', 140729100),
(140729101, 140729, '静升镇', 140729101),
(140729102, 140729, '两渡镇', 140729102),
(140729103, 140729, '夏门镇', 140729103),
(140729104, 140729, '南关镇', 140729104),
(140729105, 140729, '段纯镇', 140729105),
(140729200, 140729, '马和乡', 140729200),
(140729201, 140729, '英武乡', 140729201),
(140729202, 140729, '王禹乡', 140729202),
(140729203, 140729, '坛镇乡', 140729203),
(140729204, 140729, '梁家焉乡', 140729204),
(140729205, 140729, '交口乡', 140729205),
(140781001, 140781, '北关街道', 140781001),
(140781002, 140781, '西关街道', 140781002),
(140781003, 140781, '东南街道', 140781003),
(140781004, 140781, '西南街道', 140781004),
(140781005, 140781, '北坛街道', 140781005),
(140781100, 140781, '义安镇', 140781100),
(140781101, 140781, '张兰镇', 140781101),
(140781102, 140781, '连福镇', 140781102),
(140781103, 140781, '洪山镇', 140781103),
(140781104, 140781, '龙凤镇', 140781104),
(140781105, 140781, '绵山镇', 140781105),
(140781106, 140781, '义棠镇', 140781106),
(140781200, 140781, '城关乡', 140781200),
(140781201, 140781, '宋古乡', 140781201),
(140781202, 140781, '三佳乡', 140781202),
(140781400, 140781, '山西省种羊场', 140781400),
(140802001, 140802, '中城街道', 140802001),
(140802002, 140802, '东城街道', 140802002),
(140802003, 140802, '西城街道', 140802003),
(140802004, 140802, '南城街道', 140802004),
(140802005, 140802, '北城街道', 140802005),
(140802006, 140802, '安邑街道', 140802006),
(140802007, 140802, '大渠街道', 140802007),
(140802008, 140802, '姚孟街道', 140802008),
(140802100, 140802, '解州镇政府', 140802100),
(140802101, 140802, '龙居镇政府', 140802101),
(140802102, 140802, '北相镇政府', 140802102),
(140802103, 140802, '泓芝驿镇政府', 140802103),
(140802104, 140802, '三路里镇政府', 140802104),
(140802105, 140802, '陶村镇政府', 140802105),
(140802106, 140802, '东郭镇政府', 140802106),
(140802200, 140802, '席张乡政府', 140802200),
(140802201, 140802, '金井乡政府', 140802201),
(140802202, 140802, '王范乡政府', 140802202),
(140802203, 140802, '冯村乡政府', 140802203),
(140802204, 140802, '上郭乡政府', 140802204),
(140802205, 140802, '上王乡政府', 140802205),
(140802400, 140802, '禹都经济技术开发区', 140802400),
(140821100, 140821, '猗氏镇', 140821100),
(140821101, 140821, '嵋阳镇', 140821101),
(140821102, 140821, '临晋镇', 140821102),
(140821103, 140821, '七级镇', 140821103),
(140821104, 140821, '东张镇', 140821104),
(140821105, 140821, '孙吉镇', 140821105),
(140821106, 140821, '三管镇', 140821106),
(140821107, 140821, '耽子镇', 140821107),
(140821200, 140821, '楚候乡', 140821200),
(140821201, 140821, '庙上乡', 140821201),
(140821202, 140821, '角杯乡', 140821202),
(140821203, 140821, '北辛乡', 140821203),
(140821204, 140821, '北景乡', 140821204),
(140821400, 140821, '牛杜工贸区', 140821400),
(140821401, 140821, '卓里工贸区', 140821401),
(140821402, 140821, '闫家庄工贸区', 140821402),
(140822100, 140822, '解店镇', 140822100),
(140822101, 140822, '通化镇', 140822101),
(140822102, 140822, '汉薛镇', 140822102),
(140822103, 140822, '荣河镇', 140822103),
(140822200, 140822, '万泉乡', 140822200),
(140822201, 140822, '里望乡', 140822201),
(140822202, 140822, '西村乡', 140822202),
(140822203, 140822, '南张乡', 140822203),
(140822204, 140822, '高村乡', 140822204),
(140822205, 140822, '皇甫乡', 140822205),
(140822206, 140822, '贾村乡', 140822206),
(140822207, 140822, '王显乡', 140822207),
(140822208, 140822, '光华乡', 140822208),
(140822209, 140822, '裴庄乡', 140822209),
(140823100, 140823, '桐城镇', 140823100);
INSERT INTO `{pre}areas` VALUES
(140823101, 140823, '郭家庄镇', 140823101),
(140823102, 140823, '凹底镇', 140823102),
(140823103, 140823, '薛店镇', 140823103),
(140823104, 140823, '东镇镇', 140823104),
(140823105, 140823, '礼元镇', 140823105),
(140823106, 140823, '河底镇', 140823106),
(140823200, 140823, '神柏乡', 140823200),
(140823201, 140823, '阳隅乡', 140823201),
(140823202, 140823, '侯村乡', 140823202),
(140823203, 140823, '裴社乡', 140823203),
(140823204, 140823, '后宫乡', 140823204),
(140823205, 140823, '石门乡', 140823205),
(140824100, 140824, '稷峰镇', 140824100),
(140824101, 140824, '西社镇', 140824101),
(140824102, 140824, '化峪镇', 140824102),
(140824103, 140824, '翟店镇', 140824103),
(140824104, 140824, '清河镇', 140824104),
(140824200, 140824, '蔡村乡', 140824200),
(140824201, 140824, '太阳乡', 140824201),
(140825100, 140825, '龙兴镇', 140825100),
(140825101, 140825, '三泉镇', 140825101),
(140825102, 140825, '泽掌镇', 140825102),
(140825103, 140825, '北张镇', 140825103),
(140825104, 140825, '横桥镇', 140825104),
(140825105, 140825, '万安镇', 140825105),
(140825106, 140825, '阳王镇', 140825106),
(140825200, 140825, '古交乡', 140825200),
(140826100, 140826, '古绛镇', 140826100),
(140826101, 140826, '横水镇', 140826101),
(140826102, 140826, '陈村镇', 140826102),
(140826103, 140826, '卫庄镇', 140826103),
(140826104, 140826, '么里镇', 140826104),
(140826105, 140826, '南樊镇', 140826105),
(140826106, 140826, '安峪镇', 140826106),
(140826107, 140826, '大交镇', 140826107),
(140826200, 140826, '郝庄乡', 140826200),
(140826201, 140826, '冷口乡', 140826201),
(140827100, 140827, '新城镇', 140827100),
(140827101, 140827, '历山镇', 140827101),
(140827102, 140827, '古城镇', 140827102),
(140827103, 140827, '王茅镇', 140827103),
(140827104, 140827, '毛家镇', 140827104),
(140827200, 140827, '蒲掌乡', 140827200),
(140827201, 140827, '英言乡', 140827201),
(140827202, 140827, '解峪乡', 140827202),
(140827203, 140827, '华峰乡', 140827203),
(140827204, 140827, '长直乡', 140827204),
(140827205, 140827, '皋落乡', 140827205),
(140828100, 140828, '瑶峰镇', 140828100),
(140828101, 140828, '庙前镇', 140828101),
(140828102, 140828, '裴介镇', 140828102),
(140828103, 140828, '水头镇', 140828103),
(140828104, 140828, '埝掌镇', 140828104),
(140828105, 140828, '泗交镇', 140828105),
(140828200, 140828, '尉郭乡', 140828200),
(140828201, 140828, '禹王乡', 140828201),
(140828202, 140828, '胡张乡', 140828202),
(140828203, 140828, '南大里乡', 140828203),
(140828204, 140828, '祁家河乡', 140828204),
(140829100, 140829, '圣人涧镇', 140829100),
(140829101, 140829, '常乐镇', 140829101),
(140829102, 140829, '张店镇', 140829102),
(140829103, 140829, '张村镇', 140829103),
(140829104, 140829, '曹川镇', 140829104),
(140829105, 140829, '三门镇', 140829105),
(140829200, 140829, '洪池乡', 140829200),
(140829201, 140829, '杜马乡', 140829201),
(140829202, 140829, '部官乡', 140829202),
(140829203, 140829, '坡底乡', 140829203),
(140830100, 140830, '古巍镇', 140830100),
(140830101, 140830, '风陵渡镇', 140830101),
(140830102, 140830, '陌南镇', 140830102),
(140830103, 140830, '西陌镇', 140830103),
(140830104, 140830, '永乐镇', 140830104),
(140830105, 140830, '大王镇', 140830105),
(140830106, 140830, '阳城镇', 140830106),
(140830200, 140830, '东垆乡', 140830200),
(140830201, 140830, '南卫乡', 140830201),
(140830202, 140830, '学张乡', 140830202),
(140881001, 140881, '城西街道', 140881001),
(140881002, 140881, '城北街道', 140881002),
(140881003, 140881, '城东街道', 140881003),
(140881100, 140881, '于乡镇', 140881100),
(140881101, 140881, '卿头镇', 140881101),
(140881102, 140881, '开张镇', 140881102),
(140881103, 140881, '栲栳镇', 140881103),
(140881104, 140881, '蒲州镇', 140881104),
(140881105, 140881, '韩阳镇', 140881105),
(140881106, 140881, '张营镇', 140881106),
(140881400, 140881, '农场虚拟区', 140881400),
(140882001, 140882, '城区街道', 140882001),
(140882002, 140882, '清涧街道', 140882002),
(140882100, 140882, '樊村镇', 140882100),
(140882101, 140882, '僧楼镇', 140882101),
(140882200, 140882, '小梁乡', 140882200),
(140882201, 140882, '柴家乡', 140882201),
(140882202, 140882, '赵家庄乡', 140882202),
(140882203, 140882, '下化乡', 140882203),
(140882204, 140882, '阳村乡', 140882204),
(140882400, 140882, '山西铝厂虚拟镇', 140882400),
(140902001, 140902, '南城街道', 140902001),
(140902002, 140902, '长征街街道', 140902002),
(140902003, 140902, '新建路街道', 140902003),
(140902100, 140902, '播明镇', 140902100),
(140902101, 140902, '奇村镇', 140902101),
(140902102, 140902, '三交镇', 140902102),
(140902103, 140902, '庄磨镇', 140902103),
(140902104, 140902, '豆罗镇', 140902104),
(140902105, 140902, '董村镇', 140902105),
(140902200, 140902, '曹张乡', 140902200),
(140902201, 140902, '高城乡', 140902201),
(140902202, 140902, '秦城乡', 140902202),
(140902203, 140902, '解原乡', 140902203),
(140902204, 140902, '合索乡', 140902204),
(140902205, 140902, '阳坡乡', 140902205),
(140902206, 140902, '兰村乡', 140902206),
(140902207, 140902, '紫岩乡', 140902207),
(140902208, 140902, '西张乡', 140902208),
(140902209, 140902, '东楼乡', 140902209),
(140902210, 140902, '北义井乡', 140902210),
(140921100, 140921, '晋昌镇', 140921100),
(140921101, 140921, '河边镇', 140921101),
(140921102, 140921, '宏道镇', 140921102),
(140921200, 140921, '杨芳乡', 140921200),
(140921201, 140921, '南王乡', 140921201),
(140921202, 140921, '蒋村乡', 140921202),
(140921203, 140921, '神山乡', 140921203),
(140921204, 140921, '季庄乡', 140921204),
(140921205, 140921, '受录乡', 140921205),
(140922100, 140922, '台城镇', 140922100),
(140922101, 140922, '台怀镇', 140922101),
(140922102, 140922, '耿镇镇', 140922102),
(140922103, 140922, '豆村镇', 140922103),
(140922104, 140922, '白家庄镇', 140922104),
(140922105, 140922, '东冶镇', 140922105),
(140922200, 140922, '沟南乡', 140922200),
(140922201, 140922, '东雷乡', 140922201),
(140922202, 140922, '高洪口乡', 140922202),
(140922203, 140922, '门限石乡', 140922203),
(140922204, 140922, '陈家庄乡', 140922204),
(140922205, 140922, '建安乡', 140922205),
(140922206, 140922, '神西乡', 140922206),
(140922207, 140922, '蒋坊乡', 140922207),
(140922208, 140922, '灵境乡', 140922208),
(140922209, 140922, '阳白乡', 140922209),
(140922210, 140922, '茹村乡', 140922210),
(140922211, 140922, '石咀乡', 140922211),
(140922212, 140922, '金岗库乡', 140922212),
(140923100, 140923, '上馆镇', 140923100),
(140923101, 140923, '阳明堡镇', 140923101),
(140923102, 140923, '峨口镇', 140923102),
(140923103, 140923, '聂营镇', 140923103),
(140923104, 140923, '枣林镇', 140923104),
(140923105, 140923, '滩上镇', 140923105),
(140923200, 140923, '新高乡', 140923200),
(140923201, 140923, '峪口乡', 140923201),
(140923202, 140923, '磨坊乡', 140923202),
(140923203, 140923, '胡峪乡', 140923203),
(140923204, 140923, '雁门关乡', 140923204),
(140924100, 140924, '繁城镇', 140924100),
(140924101, 140924, '砂河镇', 140924101),
(140924102, 140924, '大营镇', 140924102),
(140924200, 140924, '下茹越乡', 140924200),
(140924201, 140924, '杏园乡', 140924201),
(140924202, 140924, '光裕堡乡', 140924202),
(140924203, 140924, '集义庄乡', 140924203),
(140924204, 140924, '东山乡', 140924204),
(140924205, 140924, '金山铺乡', 140924205),
(140924206, 140924, '柏家庄乡', 140924206),
(140924207, 140924, '横涧乡', 140924207),
(140924208, 140924, '神堂堡乡', 140924208),
(140924209, 140924, '岩头乡', 140924209),
(140925001, 140925, '街道', 140925001),
(140925100, 140925, '凤凰镇', 140925100),
(140925101, 140925, '阳方口镇', 140925101),
(140925102, 140925, '东寨镇', 140925102),
(140925103, 140925, '石家庄镇', 140925103),
(140925200, 140925, '薛家洼乡', 140925200),
(140925201, 140925, '余庄乡', 140925201),
(140925202, 140925, '涔山乡', 140925202),
(140925203, 140925, '化北屯乡', 140925203),
(140925204, 140925, '西马坊乡', 140925204),
(140925205, 140925, '新堡乡', 140925205),
(140925206, 140925, '迭台寺乡', 140925206),
(140925207, 140925, '圪廖乡', 140925207),
(140925208, 140925, '怀道乡', 140925208),
(140925209, 140925, '东马坊乡', 140925209),
(140925400, 140925, '阳方口煤矿生活区', 140925400),
(140926100, 140926, '鹅城镇', 140926100),
(140926101, 140926, '杜家村镇', 140926101),
(140926102, 140926, '康家会镇', 140926102),
(140926103, 140926, '丰润镇', 140926103),
(140926201, 140926, '堂尔上乡', 140926201),
(140926202, 140926, '中庄乡', 140926202),
(140926203, 140926, '双路乡', 140926203),
(140926204, 140926, '段家寨乡', 140926204),
(140926205, 140926, '辛村乡', 140926205),
(140926206, 140926, '王村乡', 140926206),
(140926207, 140926, '神峪沟乡', 140926207),
(140926208, 140926, '娘子神乡', 140926208),
(140926209, 140926, '娑婆乡', 140926209),
(140926210, 140926, '赤泥洼乡', 140926210),
(140927100, 140927, '龙泉镇', 140927100),
(140927101, 140927, '义井镇', 140927101),
(140927102, 140927, '八角镇', 140927102),
(140927200, 140927, '东湖乡', 140927200),
(140927201, 140927, '太平庄乡', 140927201),
(140927202, 140927, '虎北乡', 140927202),
(140927203, 140927, '贺职乡', 140927203),
(140927204, 140927, '长畛乡', 140927204),
(140927205, 140927, '烈堡乡', 140927205),
(140927206, 140927, '大严备乡', 140927206),
(140928100, 140928, '砚城镇', 140928100),
(140928101, 140928, '小河头镇', 140928101),
(140928102, 140928, '三岔镇', 140928102),
(140928200, 140928, '前所乡', 140928200),
(140928201, 140928, '李家坪乡', 140928201),
(140928202, 140928, '孙家坪乡', 140928202),
(140928203, 140928, '梁家坪乡', 140928203),
(140928204, 140928, '胡会乡', 140928204),
(140928205, 140928, '新寨乡', 140928205),
(140928206, 140928, '韩家楼乡', 140928206),
(140928207, 140928, '东秀庄乡', 140928207),
(140928208, 140928, '杏岭子乡', 140928208),
(140929100, 140929, '岚漪镇', 140929100),
(140929101, 140929, '三井镇', 140929101),
(140929200, 140929, '神堂坪乡', 140929200),
(140929201, 140929, '高家会乡', 140929201),
(140929202, 140929, '李家沟乡', 140929202),
(140929203, 140929, '水峪贯乡', 140929203),
(140929204, 140929, '西豹峪乡', 140929204),
(140929205, 140929, '温泉乡', 140929205),
(140929206, 140929, '阳坪乡', 140929206),
(140929207, 140929, '大涧乡', 140929207),
(140929208, 140929, '宋家沟乡', 140929208),
(140929209, 140929, '王家岔乡', 140929209),
(140930100, 140930, '文笔镇', 140930100),
(140930101, 140930, '楼子营镇', 140930101),
(140930102, 140930, '刘家塔镇', 140930102),
(140930103, 140930, '巡镇镇', 140930103),
(140930200, 140930, '鹿固乡', 140930200),
(140930201, 140930, '前川乡', 140930201),
(140930202, 140930, '单寨乡', 140930202),
(140930203, 140930, '土沟乡', 140930203),
(140930204, 140930, '旧县乡', 140930204),
(140930205, 140930, '沙坪乡', 140930205),
(140930206, 140930, '社梁乡', 140930206),
(140930207, 140930, '沙泉乡', 140930207),
(140930208, 140930, '赵家沟乡', 140930208),
(140931100, 140931, '东关镇', 140931100),
(140931101, 140931, '义门镇', 140931101),
(140931102, 140931, '桥头镇', 140931102),
(140931103, 140931, '杨家湾镇', 140931103),
(140931200, 140931, '腰庄乡', 140931200),
(140931201, 140931, '韩家川乡', 140931201),
(140931202, 140931, '林遮峪乡', 140931202),
(140931203, 140931, '冯家川乡', 140931203),
(140931204, 140931, '土崖塔乡', 140931204),
(140931205, 140931, '孙家沟乡', 140931205),
(140931206, 140931, '窑洼乡', 140931206),
(140931207, 140931, '尧圪台乡', 140931207),
(140931208, 140931, '南河沟乡', 140931208),
(140932100, 140932, '新关镇', 140932100),
(140932101, 140932, '天峰坪镇', 140932101),
(140932102, 140932, '老营镇', 140932102),
(140932103, 140932, '万家寨镇', 140932103),
(140932200, 140932, '窑头乡', 140932200),
(140932201, 140932, '楼沟乡', 140932201),
(140932202, 140932, '尚峪乡', 140932202),
(140932203, 140932, '南堡子乡', 140932203),
(140932204, 140932, '水泉乡', 140932204),
(140932205, 140932, '陈家营乡', 140932205),
(140981001, 140981, '北城街道', 140981001),
(140981002, 140981, '南城街道', 140981002),
(140981100, 140981, '东社镇', 140981100),
(140981101, 140981, '苏龙口镇', 140981101),
(140981102, 140981, '崞阳镇', 140981102),
(140981103, 140981, '大牛店镇', 140981103),
(140981104, 140981, '闫庄镇', 140981104),
(140981105, 140981, '长梁沟镇', 140981105),
(140981106, 140981, '轩岗镇', 140981106),
(140981200, 140981, '新原乡', 140981200),
(140981201, 140981, '南白乡', 140981201),
(140981202, 140981, '子干乡', 140981202),
(140981203, 140981, '中阳乡', 140981203),
(140981204, 140981, '沿沟乡', 140981204),
(140981205, 140981, '大林乡', 140981205),
(140981206, 140981, '西镇乡', 140981206),
(140981207, 140981, '解村乡', 140981207),
(140981208, 140981, '王家庄乡', 140981208),
(140981209, 140981, '楼板寨乡', 140981209),
(140981210, 140981, '段家堡乡', 140981210),
(140981400, 140981, '山西鲁能晋北铝业工矿区', 140981400),
(140981401, 140981, '原平市石豹沟煤矿工矿区', 140981401),
(140981402, 140981, '同煤集团轩岗煤电有限公司工矿区', 140981402),
(141002001, 141002, '解放路街道', 141002001),
(141002002, 141002, '鼓楼西街街道', 141002002),
(141002003, 141002, '水塔街街道', 141002003),
(141002004, 141002, '南街街道', 141002004),
(141002005, 141002, '乡贤街街道', 141002005),
(141002006, 141002, '辛寺街街道', 141002006),
(141002007, 141002, '铁路东街道', 141002007),
(141002008, 141002, '车站街街道', 141002008),
(141002009, 141002, '汾河街道', 141002009),
(141002100, 141002, '屯里镇', 141002100),
(141002101, 141002, '乔李镇', 141002101),
(141002102, 141002, '大阳镇', 141002102),
(141002103, 141002, '县底镇', 141002103),
(141002104, 141002, '刘村镇', 141002104),
(141002105, 141002, '金殿镇', 141002105),
(141002106, 141002, '吴村镇', 141002106),
(141002107, 141002, '土门镇', 141002107),
(141002108, 141002, '魏村镇', 141002108),
(141002109, 141002, '尧庙镇', 141002109),
(141002200, 141002, '段店乡', 141002200),
(141002201, 141002, '贾得乡', 141002201),
(141002202, 141002, '贺家庄乡', 141002202),
(141002203, 141002, '一平垣乡', 141002203),
(141002204, 141002, '枕头乡', 141002204),
(141002205, 141002, '河底乡', 141002205),
(141002400, 141002, '滨河办事处(临汾经济开发区)', 141002400),
(141021100, 141021, '乐昌镇', 141021100),
(141021101, 141021, '史村镇', 141021101),
(141021102, 141021, '曲村镇', 141021102),
(141021103, 141021, '高显镇', 141021103),
(141021104, 141021, '里村镇', 141021104),
(141021200, 141021, '北董乡', 141021200),
(141021201, 141021, '杨谈乡', 141021201),
(141022100, 141022, '唐兴镇', 141022100),
(141022101, 141022, '南梁镇', 141022101),
(141022102, 141022, '里寨镇', 141022102),
(141022103, 141022, '隆化镇', 141022103),
(141022104, 141022, '桥上镇', 141022104),
(141022105, 141022, '西闫镇', 141022105),
(141022200, 141022, '中卫乡', 141022200),
(141022201, 141022, '南唐乡', 141022201),
(141022202, 141022, '王庄乡', 141022202),
(141022203, 141022, '浇底乡', 141022203),
(141023100, 141023, '新城镇', 141023100),
(141023101, 141023, '赵康镇', 141023101),
(141023102, 141023, '汾城镇', 141023102),
(141023103, 141023, '南贾镇', 141023103),
(141023104, 141023, '古城镇', 141023104),
(141023105, 141023, '襄陵镇', 141023105),
(141023106, 141023, '邓庄镇', 141023106),
(141023200, 141023, '陶寺乡', 141023200),
(141023201, 141023, '永固乡', 141023201),
(141023202, 141023, '景毛乡', 141023202),
(141023203, 141023, '西贾乡', 141023203),
(141023204, 141023, '南辛店乡', 141023204),
(141023205, 141023, '大邓乡', 141023205),
(141024100, 141024, '大槐树镇', 141024100),
(141024101, 141024, '甘亭镇', 141024101),
(141024102, 141024, '曲亭镇', 141024102),
(141024103, 141024, '苏堡镇', 141024103),
(141024104, 141024, '广胜寺镇', 141024104),
(141024105, 141024, '明姜镇', 141024105),
(141024106, 141024, '赵城镇', 141024106),
(141024107, 141024, '万安镇', 141024107),
(141024108, 141024, '刘家垣镇', 141024108),
(141024200, 141024, '淹底乡', 141024200),
(141024201, 141024, '兴唐寺乡', 141024201),
(141024202, 141024, '堤村乡', 141024202),
(141024203, 141024, '辛村乡', 141024203),
(141024204, 141024, '龙马乡', 141024204),
(141024205, 141024, '山头乡', 141024205),
(141024206, 141024, '左木乡', 141024206),
(141025100, 141025, '岳阳镇', 141025100),
(141025101, 141025, '北平镇', 141025101),
(141025102, 141025, '古阳镇', 141025102),
(141025103, 141025, '旧县镇', 141025103),
(141025200, 141025, '石壁乡', 141025200),
(141025201, 141025, '永乐乡', 141025201),
(141025202, 141025, '南垣乡', 141025202),
(141026100, 141026, '府城镇', 141026100),
(141026101, 141026, '和川镇', 141026101),
(141026102, 141026, '唐城镇', 141026102),
(141026103, 141026, '冀氏镇', 141026103),
(141026200, 141026, '马必乡', 141026200),
(141026201, 141026, '杜村乡', 141026201),
(141026202, 141026, '良马乡', 141026202),
(141027100, 141027, '天坛镇', 141027100),
(141027101, 141027, '响水河镇', 141027101),
(141027200, 141027, '张庄乡', 141027200),
(141027201, 141027, '东张乡', 141027201),
(141027202, 141027, '槐埝乡', 141027202),
(141027203, 141027, '北王乡', 141027203),
(141027204, 141027, '北韩乡', 141027204),
(141027205, 141027, '米家垣乡', 141027205),
(141027206, 141027, '寨圪塔乡', 141027206),
(141028100, 141028, '吉昌镇', 141028100),
(141028101, 141028, '屯里镇', 141028101),
(141028102, 141028, '壶口镇', 141028102),
(141028200, 141028, '车城乡', 141028200),
(141028201, 141028, '文城乡', 141028201),
(141028202, 141028, '东城乡', 141028202),
(141028203, 141028, '柏山寺乡', 141028203),
(141028204, 141028, '中垛乡', 141028204),
(141029100, 141029, '昌宁镇', 141029100),
(141029101, 141029, '光华镇', 141029101),
(141029102, 141029, '台头镇', 141029102),
(141029103, 141029, '管头镇', 141029103),
(141029104, 141029, '西坡镇', 141029104),
(141029200, 141029, '双鹤乡', 141029200),
(141029201, 141029, '关王庙乡', 141029201),
(141029202, 141029, '尉庄乡', 141029202),
(141029203, 141029, '西交口乡', 141029203),
(141029204, 141029, '枣岭乡', 141029204),
(141030100, 141030, '昕水镇', 141030100),
(141030101, 141030, '曲峨镇', 141030101),
(141030200, 141030, '三多乡', 141030200),
(141030201, 141030, '太德乡', 141030201),
(141030202, 141030, '徐家垛乡', 141030202),
(141030203, 141030, '太古乡', 141030203),
(141031100, 141031, '龙泉镇', 141031100),
(141031101, 141031, '午城镇', 141031101),
(141031102, 141031, '黄土镇', 141031102),
(141031200, 141031, '阳头升乡', 141031200),
(141031201, 141031, '寨子乡', 141031201),
(141031202, 141031, '陡坡乡', 141031202),
(141031203, 141031, '下李乡', 141031203),
(141031204, 141031, '城南乡', 141031204),
(141032100, 141032, '芝河镇', 141032100),
(141032101, 141032, '桑壁镇', 141032101),
(141032200, 141032, '阁底乡', 141032200),
(141032201, 141032, '南庄乡', 141032201),
(141032202, 141032, '打石腰乡', 141032202),
(141032203, 141032, '坡头乡', 141032203),
(141032204, 141032, '交口乡', 141032204),
(141033100, 141033, '蒲城镇', 141033100),
(141033101, 141033, '薛关镇', 141033101),
(141033102, 141033, '黑龙关镇', 141033102),
(141033103, 141033, '克城镇', 141033103),
(141033200, 141033, '山中乡', 141033200),
(141033201, 141033, '古县乡', 141033201),
(141033202, 141033, '红道乡', 141033202),
(141033203, 141033, '乔家湾乡', 141033203),
(141033204, 141033, '太林乡', 141033204),
(141034100, 141034, '永安镇', 141034100),
(141034101, 141034, '对竹镇', 141034101),
(141034102, 141034, '勍香镇', 141034102),
(141034103, 141034, '和平镇', 141034103),
(141034104, 141034, '僧念镇', 141034104),
(141034200, 141034, '佃坪乡', 141034200),
(141034201, 141034, '团柏乡', 141034201),
(141034202, 141034, '邢家要乡', 141034202),
(141081001, 141081, '路东街道', 141081001),
(141081002, 141081, '路西街道', 141081002),
(141081003, 141081, '浍滨街道', 141081003),
(141081004, 141081, '上马街道', 141081004),
(141081005, 141081, '张村街道', 141081005),
(141081200, 141081, '新田乡', 141081200),
(141081201, 141081, '高村乡', 141081201),
(141081202, 141081, '凤城乡', 141081202),
(141082001, 141082, '鼓楼街道', 141082001),
(141082002, 141082, '北环路街道', 141082002),
(141082003, 141082, '南环路街道', 141082003),
(141082004, 141082, '开元街道办事', 141082004),
(141082005, 141082, '退沙街道', 141082005),
(141082100, 141082, '白龙镇', 141082100),
(141082101, 141082, '辛置镇', 141082101),
(141082102, 141082, '大张镇', 141082102),
(141082103, 141082, '李曹镇', 141082103),
(141082200, 141082, '陶唐峪乡', 141082200),
(141082201, 141082, '三教乡', 141082201),
(141082202, 141082, '师庄乡', 141082202),
(141102001, 141102, '滨河街道', 141102001),
(141102002, 141102, '凤山街道', 141102002),
(141102003, 141102, '莲花池街道', 141102003),
(141102004, 141102, '城北街道', 141102004),
(141102005, 141102, '田家会街道', 141102005),
(141102006, 141102, '交口街道', 141102006),
(141102007, 141102, '西属巴街道', 141102007),
(141102100, 141102, '吴城镇', 141102100),
(141102101, 141102, '信义镇', 141102101),
(141102200, 141102, '红眼川乡', 141102200),
(141102201, 141102, '枣林乡', 141102201),
(141102202, 141102, '坪头乡', 141102202),
(141121100, 141121, '凤城镇', 141121100),
(141121101, 141121, '开栅镇', 141121101),
(141121102, 141121, '南庄镇', 141121102),
(141121103, 141121, '南安镇', 141121103),
(141121104, 141121, '刘胡兰镇', 141121104),
(141121105, 141121, '下曲镇', 141121105),
(141121106, 141121, '孝义镇', 141121106),
(141121200, 141121, '南武乡', 141121200),
(141121201, 141121, '西城乡', 141121201),
(141121202, 141121, '北张乡', 141121202),
(141121203, 141121, '马西乡', 141121203),
(141121204, 141121, '西槽头乡', 141121204),
(141122100, 141122, '天宁镇', 141122100),
(141122101, 141122, '夏家营镇', 141122101),
(141122102, 141122, '西营镇', 141122102),
(141122103, 141122, '水峪贯镇', 141122103),
(141122104, 141122, '西社镇', 141122104),
(141122105, 141122, '庞泉沟镇', 141122105),
(141122200, 141122, '洪相乡', 141122200),
(141122201, 141122, '岭底乡', 141122201),
(141122202, 141122, '东坡底乡', 141122202),
(141122203, 141122, '会立乡', 141122203),
(141123100, 141123, '蔚汾镇', 141123100),
(141123101, 141123, '魏家滩镇', 141123101),
(141123102, 141123, '瓦塘镇', 141123102),
(141123103, 141123, '康宁镇', 141123103),
(141123104, 141123, '高家村镇', 141123104),
(141123105, 141123, '罗峪口镇', 141123105),
(141123106, 141123, '蔡家会镇', 141123106),
(141123200, 141123, '交楼申乡', 141123200),
(141123201, 141123, '恶虎滩乡', 141123201),
(141123202, 141123, '东会乡', 141123202),
(141123203, 141123, '固贤乡', 141123203),
(141123204, 141123, '奥家湾乡', 141123204),
(141123205, 141123, '蔡家崖乡', 141123205),
(141123206, 141123, '贺家会乡', 141123206),
(141123207, 141123, '孟家坪乡', 141123207),
(141123208, 141123, '赵家坪乡', 141123208),
(141123209, 141123, '圪垯上乡', 141123209),
(141124100, 141124, '临泉镇', 141124100),
(141124101, 141124, '白文镇', 141124101),
(141124102, 141124, '城庄镇', 141124102),
(141124103, 141124, '兔坂镇', 141124103),
(141124104, 141124, '克虎镇', 141124104),
(141124105, 141124, '三交镇', 141124105),
(141124106, 141124, '湍水头镇', 141124106),
(141124107, 141124, '林家坪镇', 141124107),
(141124108, 141124, '招贤镇', 141124108),
(141124109, 141124, '碛口镇', 141124109),
(141124110, 141124, '刘家会镇', 141124110),
(141124111, 141124, '丛罗峪镇', 141124111),
(141124112, 141124, '曲峪镇', 141124112),
(141124200, 141124, '木瓜坪乡', 141124200),
(141124201, 141124, '安业乡', 141124201),
(141124202, 141124, '玉坪乡', 141124202),
(141124203, 141124, '青凉寺乡', 141124203),
(141124204, 141124, '石白头乡', 141124204),
(141124205, 141124, '雷家碛乡', 141124205),
(141124206, 141124, '第八堡乡', 141124206),
(141124207, 141124, '大禹乡', 141124207),
(141124208, 141124, '车赶乡', 141124208),
(141124209, 141124, '安家庄乡', 141124209),
(141125100, 141125, '柳林镇', 141125100),
(141125101, 141125, '穆村镇', 141125101),
(141125102, 141125, '薛村镇', 141125102),
(141125103, 141125, '庄上镇', 141125103),
(141125104, 141125, '留誉镇', 141125104),
(141125105, 141125, '三交镇', 141125105),
(141125106, 141125, '成家庄镇', 141125106),
(141125107, 141125, '孟门镇', 141125107),
(141125200, 141125, '李家湾乡', 141125200),
(141125201, 141125, '贾家垣乡', 141125201),
(141125202, 141125, '陈家湾乡', 141125202),
(141125203, 141125, '金家庄乡', 141125203),
(141125204, 141125, '高家沟乡', 141125204),
(141125205, 141125, '石西乡', 141125205),
(141125206, 141125, '王家沟乡', 141125206),
(141126100, 141126, '灵泉镇', 141126100),
(141126101, 141126, '罗村镇', 141126101),
(141126102, 141126, '义牒镇', 141126102),
(141126103, 141126, '小蒜镇', 141126103),
(141126200, 141126, '龙交乡', 141126200),
(141126201, 141126, '和合乡', 141126201),
(141126202, 141126, '前山乡', 141126202),
(141126203, 141126, '曹家垣乡', 141126203),
(141126204, 141126, '裴沟乡', 141126204),
(141127100, 141127, '东村镇', 141127100),
(141127101, 141127, '岚城镇', 141127101),
(141127102, 141127, '普明镇', 141127102),
(141127103, 141127, '界河口镇', 141127103),
(141127200, 141127, '土峪乡', 141127200),
(141127201, 141127, '上明乡', 141127201),
(141127202, 141127, '王狮乡', 141127202),
(141127203, 141127, '梁家庄乡', 141127203),
(141127204, 141127, '顺会乡', 141127204),
(141127205, 141127, '河口乡', 141127205),
(141127206, 141127, '社科乡', 141127206),
(141127207, 141127, '大蛇头乡', 141127207),
(141128100, 141128, '圪洞镇', 141128100),
(141128101, 141128, '马坊镇', 141128101),
(141128102, 141128, '峪口镇', 141128102),
(141128103, 141128, '大武镇', 141128103),
(141128104, 141128, '北武当镇', 141128104),
(141128200, 141128, '积翠乡', 141128200),
(141128201, 141128, '麻地会乡', 141128201),
(141129100, 141129, '宁乡镇', 141129100),
(141129101, 141129, '金罗镇', 141129101),
(141129102, 141129, '枝柯镇', 141129102),
(141129103, 141129, '武家庄镇', 141129103),
(141129104, 141129, '暖泉镇', 141129104),
(141129200, 141129, '张子山乡', 141129200),
(141129201, 141129, '下枣林乡', 141129201),
(141130100, 141130, '水头镇', 141130100),
(141130101, 141130, '康城镇', 141130101),
(141130102, 141130, '双池镇', 141130102),
(141130103, 141130, '桃红坡镇', 141130103),
(141130200, 141130, '石口乡', 141130200),
(141130201, 141130, '回龙乡', 141130201),
(141130202, 141130, '温泉乡', 141130202),
(141181001, 141181, '新义街道', 141181001),
(141181002, 141181, '中阳楼街道', 141181002),
(141181003, 141181, '振兴街道', 141181003),
(141181004, 141181, '东许街道', 141181004),
(141181100, 141181, '兑镇镇', 141181100),
(141181101, 141181, '阳泉曲镇', 141181101),
(141181102, 141181, '下堡镇', 141181102),
(141181103, 141181, '西辛庄镇', 141181103),
(141181104, 141181, '高阳镇', 141181104),
(141181105, 141181, '梧桐镇', 141181105),
(141181106, 141181, '柱濮镇', 141181106),
(141181200, 141181, '大孝堡乡', 141181200),
(141181201, 141181, '下栅乡', 141181201),
(141181202, 141181, '驿马乡', 141181202),
(141181203, 141181, '南阳乡', 141181203),
(141181204, 141181, '杜村乡', 141181204),
(141182001, 141182, '文峰街道', 141182001),
(141182002, 141182, '太和桥街道', 141182002),
(141182100, 141182, '贾家庄镇', 141182100),
(141182101, 141182, '杏花村镇', 141182101),
(141182102, 141182, '冀村镇', 141182102),
(141182103, 141182, '肖家庄镇', 141182103),
(141182104, 141182, '演武镇', 141182104),
(141182105, 141182, '三泉镇', 141182105),
(141182106, 141182, '石庄镇', 141182106),
(141182107, 141182, '杨家庄镇', 141182107),
(141182108, 141182, '峪道河镇', 141182108),
(141182200, 141182, '西河乡', 141182200),
(141182201, 141182, '阳城乡', 141182201),
(141182202, 141182, '栗家庄乡', 141182202),
(150102001, 150102, '海拉尔东路街道', 150102001),
(150102002, 150102, '锡林路', 150102002),
(150102003, 150102, '中山东路街道', 150102003),
(150102004, 150102, '东街街道', 150102004),
(150102005, 150102, '西街街道', 150102005),
(150102006, 150102, '东风路街道', 150102006),
(150102007, 150102, '迎新路街道', 150102007),
(150102100, 150102, '毫沁营镇', 150102100),
(150102101, 150102, '保合少镇', 150102101),
(150102400, 150102, '新城区鸿盛高科技园区', 150102400),
(150103001, 150103, '新华西路', 150103001),
(150103002, 150103, '中山西路', 150103002),
(150103003, 150103, '光明路', 150103003),
(150103004, 150103, '海拉尔西路', 150103004),
(150103005, 150103, '环河街', 150103005),
(150103006, 150103, '通道街', 150103006),
(150103007, 150103, '钢铁路', 150103007),
(150103100, 150103, '攸攸板镇', 150103100),
(150104001, 150104, '小召前街', 150104001),
(150104002, 150104, '兴隆巷', 150104002),
(150104003, 150104, '长和廊', 150104003),
(150104004, 150104, '石东路', 150104004),
(150104005, 150104, '大南街', 150104005),
(150104006, 150104, '鄂尔多斯路', 150104006),
(150104007, 150104, '西菜园', 150104007),
(150104100, 150104, '小黑河镇', 150104100),
(150105001, 150105, '人民路街道', 150105001),
(150105002, 150105, '大学西路街道', 150105002),
(150105003, 150105, '乌兰察布路街道', 150105003),
(150105004, 150105, '大学东路街道', 150105004),
(150105005, 150105, '中专路街道', 150105005),
(150105100, 150105, '巧报镇', 150105100),
(150105101, 150105, '榆林镇', 150105101),
(150105102, 150105, '巴彦镇', 150105102),
(150105103, 150105, '黄合少镇', 150105103),
(150105104, 150105, '金河镇', 150105104),
(150105201, 150105, '西把栅乡', 150105201),
(150105400, 150105, '金桥经济技术开发区', 150105400),
(150121100, 150121, '察素齐镇', 150121100),
(150121101, 150121, '毕克齐镇', 150121101),
(150121102, 150121, '善岱镇', 150121102),
(150121103, 150121, '台阁牧镇', 150121103),
(150121104, 150121, '白庙子镇', 150121104),
(150121203, 150121, '沙尔沁乡', 150121203),
(150121207, 150121, '北什轴乡', 150121207),
(150121208, 150121, '塔布赛乡', 150121208),
(150121212, 150121, '只几梁乡', 150121212),
(150121400, 150121, '呼和浩特经济技术开发区金川区', 150121400),
(150121401, 150121, '呼和浩特金山经济技术开发区', 150121401),
(150122100, 150122, '双河镇', 150122100),
(150122101, 150122, '新营子镇', 150122101),
(150122102, 150122, '五申镇', 150122102),
(150122103, 150122, '伍什家镇', 150122103),
(150122104, 150122, '古城镇', 150122104),
(150123100, 150123, '城关镇', 150123100),
(150123101, 150123, '盛乐镇', 150123101),
(150123102, 150123, '新店子镇', 150123102),
(150123203, 150123, '舍必崖乡', 150123203),
(150123205, 150123, '大红城乡', 150123205),
(150123206, 150123, '羊群沟乡', 150123206),
(150123207, 150123, '黑老夭乡', 150123207),
(150123400, 150123, '盛乐经济工业园区', 150123400),
(150124100, 150124, '城关镇', 150124100),
(150124101, 150124, '宏河镇', 150124101),
(150124102, 150124, '喇嘛湾镇', 150124102),
(150124200, 150124, '窑沟乡', 150124200),
(150124201, 150124, '北堡乡', 150124201),
(150124202, 150124, '韮菜庄乡', 150124202),
(150125100, 150125, '可镇', 150125100),
(150125101, 150125, '哈乐镇', 150125101),
(150125102, 150125, '西乌兰不浪镇', 150125102),
(150125200, 150125, '大青山乡', 150125200),
(150125205, 150125, '上秃亥乡', 150125205),
(150125207, 150125, '德胜沟乡', 150125207),
(150125211, 150125, '二份子乡', 150125211),
(150125213, 150125, '哈拉合少乡', 150125213),
(150125400, 150125, '工业园区', 150125400),
(150202001, 150202, '和平街道', 150202001),
(150202002, 150202, '财神庙街道', 150202002),
(150202003, 150202, '西脑包街道', 150202003),
(150202004, 150202, '南门外街道', 150202004),
(150202005, 150202, '南圪洞街道', 150202005),
(150202006, 150202, '东站街道', 150202006),
(150202007, 150202, '回民街道', 150202007),
(150202008, 150202, '二里半街道', 150202008),
(150202009, 150202, '河东街道', 150202009),
(150202010, 150202, '铁西街道', 150202010),
(150202011, 150202, '东兴街道', 150202011),
(150202012, 150202, '杨圪楞街道', 150202012),
(150202100, 150202, '河东镇', 150202100),
(150203001, 150203, '少先路街道', 150203001),
(150203002, 150203, '张家营子街道', 150203002),
(150203003, 150203, '沼潭街道', 150203003),
(150203004, 150203, '林荫路街道', 150203004),
(150203005, 150203, '友谊大街街道', 150203005),
(150203006, 150203, '阿尔丁大街街道', 150203006),
(150203007, 150203, '团结大街街道', 150203007),
(150203008, 150203, '鞍山道街道', 150203008),
(150203009, 150203, '前进道街道', 150203009),
(150203010, 150203, '市府东路街道', 150203010),
(150203011, 150203, '白云路街道', 150203011),
(150203012, 150203, '黄河西路街道', 150203012),
(150203013, 150203, '昆工路街道', 150203013),
(150203100, 150203, '昆河镇', 150203100),
(150203400, 150203, '包钢厂区虚拟', 150203400),
(150204001, 150204, '先锋道街道', 150204001),
(150204002, 150204, '幸福路街道', 150204002),
(150204003, 150204, '万青路街道', 150204003),
(150204004, 150204, '富强路街道', 150204004),
(150204005, 150204, '科学路街道', 150204005),
(150204006, 150204, '青山路街道', 150204006),
(150204007, 150204, '自由路街道', 150204007),
(150204008, 150204, '乌素图街道', 150204008),
(150204100, 150204, '青福镇', 150204100),
(150204103, 150204, '万水泉镇', 150204103),
(150204400, 150204, '包头稀土高新区新建区虚拟', 150204400),
(150205001, 150205, '石拐街道', 150205001),
(150205002, 150205, '大发街道', 150205002),
(150205003, 150205, '大磁街道', 150205003),
(150205004, 150205, '五当沟街道', 150205004),
(150205005, 150205, '白狐沟街道', 150205005),
(150205101, 150205, '五当召镇', 150205101),
(150206001, 150206, '矿山路街道', 150206001),
(150206002, 150206, '通阳道街道', 150206002),
(150207001, 150207, '沙河街道', 150207001),
(150207103, 150207, '麻池镇', 150207103),
(150207105, 150207, '哈林格尔镇', 150207105),
(150207108, 150207, '沙尔沁镇', 150207108),
(150207109, 150207, '兴胜镇', 150207109),
(150207110, 150207, '哈业胡同镇', 150207110),
(150207202, 150207, '阿嘎如泰苏木乡', 150207202),
(150207500, 150207, '包头市国营青年农场', 150207500),
(150207501, 150207, '包头市奶业公司', 150207501),
(150221104, 150221, '萨拉齐镇', 150221104),
(150221105, 150221, '双龙镇', 150221105),
(150221106, 150221, '美岱召镇', 150221106),
(150221107, 150221, '沟门镇', 150221107),
(150221108, 150221, '将军尧镇', 150221108),
(150221213, 150221, '海子乡', 150221213),
(150221214, 150221, '明沙淖乡', 150221214),
(150221215, 150221, '苏波盖乡', 150221215),
(150221500, 150221, '九峰山生态管理委员会', 150221500),
(150222102, 150222, '金山镇', 150222102),
(150222103, 150222, '西斗铺镇', 150222103),
(150222104, 150222, '下湿壕镇', 150222104),
(150222105, 150222, '银号镇', 150222105),
(150222106, 150222, '怀朔镇', 150222106),
(150222107, 150222, '兴顺西镇', 150222107),
(150223102, 150223, '满都拉镇', 150223102),
(150223103, 150223, '希拉穆仁镇', 150223103),
(150223104, 150223, '百灵庙镇', 150223104),
(150223105, 150223, '石宝镇', 150223105),
(150223106, 150223, '乌克忽洞镇', 150223106),
(150223107, 150223, '明安镇', 150223107),
(150223108, 150223, '巴音花镇', 150223108),
(150223213, 150223, '达尔罕苏木乡', 150223213),
(150302001, 150302, '凤凰岭街道', 150302001),
(150302002, 150302, '海北街道', 150302002),
(150302003, 150302, '新华街道', 150302003),
(150302004, 150302, '新华西街道', 150302004),
(150302005, 150302, '卡布其街道', 150302005),
(150302007, 150302, '滨河街道', 150302007),
(150302101, 150302, '千里山镇', 150302101),
(150303001, 150303, '拉僧仲街道', 150303001),
(150303002, 150303, '西卓子山街道', 150303002),
(150303102, 150303, '公乌素镇', 150303102),
(150303103, 150303, '拉僧庙镇', 150303103),
(150303104, 150303, '巴音陶亥镇', 150303104),
(150304002, 150304, '三道坎街道', 150304002),
(150304003, 150304, '五虎山街道', 150304003),
(150304008, 150304, '新达街道', 150304008),
(150304009, 150304, '巴音赛街道', 150304009),
(150304010, 150304, '梁家沟街道', 150304010),
(150304011, 150304, '苏海图街道', 150304011),
(150304012, 150304, '滨海街道', 150304012),
(150304101, 150304, '乌兰淖尔镇', 150304101),
(150402001, 150402, '西屯街道', 150402001),
(150402002, 150402, '三中街街道', 150402002),
(150402003, 150402, '永巨街道', 150402003),
(150402004, 150402, '东城街道', 150402004),
(150402005, 150402, '南新街街道', 150402005),
(150402006, 150402, '站前街道', 150402006),
(150402007, 150402, '铁南街道', 150402007),
(150402008, 150402, '长青街道', 150402008),
(150402009, 150402, '哈达街道', 150402009),
(150402100, 150402, '红庙子镇', 150402100),
(150402102, 150402, '文钟镇', 150402102),
(150403001, 150403, '西露天街道', 150403001),
(150403002, 150403, '平庄城区街道', 150403002),
(150403100, 150403, '风水沟镇', 150403100),
(150403101, 150403, '元宝山镇', 150403101),
(150403102, 150403, '美丽河镇', 150403102),
(150403103, 150403, '平庄镇', 150403103),
(150403104, 150403, '五家镇', 150403104),
(150404001, 150404, '振兴街道', 150404001),
(150404002, 150404, '向阳街道', 150404002),
(150404003, 150404, '松州街道', 150404003),
(150404004, 150404, '铁东街道', 150404004),
(150404005, 150404, '玉龙街道', 150404005),
(150404006, 150404, '富河街道', 150404006),
(150404007, 150404, '兴安街道', 150404007),
(150404008, 150404, '全宁街道', 150404008),
(150404100, 150404, '穆家营子镇', 150404100),
(150404101, 150404, '初头朗镇', 150404101),
(150404102, 150404, '大庙镇', 150404102),
(150404103, 150404, '王府镇', 150404103),
(150404104, 150404, '老府镇', 150404104),
(150404105, 150404, '哈拉道口镇', 150404105),
(150404106, 150404, '上官地镇', 150404106),
(150404107, 150404, '安庆镇', 150404107),
(150404108, 150404, '太平地镇', 150404108),
(150404200, 150404, '当铺地满族乡', 150404200),
(150404201, 150404, '夏家店乡', 150404201),
(150404202, 150404, '城子乡', 150404202),
(150404203, 150404, '大夫营子乡', 150404203),
(150404204, 150404, '岗子乡', 150404204),
(150421001, 150421, '天山', 150421001),
(150421100, 150421, '天山镇', 150421100),
(150421101, 150421, '天山口镇', 150421101),
(150421102, 150421, '双胜镇', 150421102),
(150421103, 150421, '坤都镇', 150421103),
(150421104, 150421, '巴彦花镇', 150421104),
(150421105, 150421, '绍根镇', 150421105),
(150421200, 150421, '新民乡', 150421200),
(150421201, 150421, '先锋乡', 150421201),
(150421202, 150421, '罕苏木苏木乡', 150421202),
(150421203, 150421, '赛汉塔拉苏木乡', 150421203),
(150421204, 150421, '巴拉奇如德苏木乡', 150421204),
(150422001, 150422, '林东西城街道', 150422001),
(150422002, 150422, '林东东城街道', 150422002),
(150422100, 150422, '林东镇', 150422100),
(150422101, 150422, '隆昌镇', 150422101),
(150422102, 150422, '十三敖包镇', 150422102),
(150422103, 150422, '碧流台镇', 150422103),
(150422104, 150422, '富河镇', 150422104),
(150422105, 150422, '白音诺尔镇', 150422105),
(150422106, 150422, '哈拉哈达镇', 150422106),
(150422200, 150422, '查干哈达苏木乡', 150422200),
(150422201, 150422, '乌兰达坝苏木乡', 150422201),
(150423100, 150423, '大板镇', 150423100),
(150423101, 150423, '索博日嘎镇', 150423101),
(150423102, 150423, '宝日勿苏镇', 150423102),
(150423103, 150423, '查干诺尔镇', 150423103),
(150423104, 150423, '查干沐沦镇', 150423104),
(150423200, 150423, '西拉沐沦苏木乡', 150423200),
(150423201, 150423, '巴彦塔拉苏木乡', 150423201),
(150423202, 150423, '幸福之路苏木乡', 150423202),
(150424001, 150424, '林西街道', 150424001),
(150424100, 150424, '林西镇', 150424100),
(150424101, 150424, '新城子镇', 150424101),
(150424102, 150424, '新林镇', 150424102),
(150424103, 150424, '五十家子镇', 150424103),
(150424104, 150424, '官地镇', 150424104),
(150424105, 150424, '大井镇', 150424105),
(150424106, 150424, '统部镇', 150424106),
(150424200, 150424, '大营子乡', 150424200),
(150425100, 150425, '经棚镇', 150425100),
(150425101, 150425, '宇宙地镇', 150425101),
(150425102, 150425, '土城子镇', 150425102),
(150425103, 150425, '同兴镇', 150425103),
(150425104, 150425, '万合永镇', 150425104),
(150425105, 150425, '芝瑞镇', 150425105),
(150425106, 150425, '达来诺日镇', 150425106),
(150425200, 150425, '新开地乡', 150425200),
(150425201, 150425, '红山子乡', 150425201),
(150425202, 150425, '达日罕乌拉苏木乡', 150425202),
(150425203, 150425, '巴彦查干苏木乡', 150425203),
(150426100, 150426, '乌丹镇', 150426100),
(150426101, 150426, '乌敦套海镇', 150426101),
(150426102, 150426, '五分地镇', 150426102),
(150426103, 150426, '桥头镇', 150426103),
(150426104, 150426, '广德公镇', 150426104),
(150426105, 150426, '梧桐花镇', 150426105),
(150426106, 150426, '海日苏镇', 150426106),
(150426107, 150426, '亿合公镇', 150426107),
(150426200, 150426, '解放营子乡', 150426200),
(150426201, 150426, '阿什罕苏木乡', 150426201),
(150426202, 150426, '白音他拉苏木乡', 150426202),
(150426203, 150426, '白音套海苏木乡', 150426203),
(150428100, 150428, '锦山镇', 150428100),
(150428101, 150428, '美林镇', 150428101),
(150428102, 150428, '王爷府镇', 150428102),
(150428103, 150428, '小牛群镇', 150428103),
(150428104, 150428, '牛家营子镇', 150428104),
(150428105, 150428, '乃林镇', 150428105),
(150428106, 150428, '西桥镇', 150428106),
(150428200, 150428, '十家满族乡', 150428200),
(150428400, 150428, '乃林果树农场', 150428400),
(150428401, 150428, '马鞍山羊场', 150428401),
(150429100, 150429, '天义镇政府', 150429100),
(150429101, 150429, '小城子镇政府', 150429101),
(150429102, 150429, '大城子镇政府', 150429102),
(150429103, 150429, '八里罕镇政府', 150429103),
(150429104, 150429, '黑里河镇政府', 150429104),
(150429105, 150429, '甸子镇政府', 150429105),
(150429106, 150429, '大双庙镇政府', 150429106),
(150429107, 150429, '汐子镇政府', 150429107),
(150429108, 150429, '大明镇政府', 150429108),
(150429109, 150429, '忙农镇政府', 150429109),
(150429200, 150429, '三座店乡政府', 150429200),
(150429201, 150429, '必斯营子乡政府', 150429201),
(150429202, 150429, '五化乡政府', 150429202),
(150430100, 150430, '新惠镇', 150430100),
(150430101, 150430, '四家子镇', 150430101),
(150430102, 150430, '长胜镇', 150430102),
(150430103, 150430, '贝子府镇', 150430103),
(150430104, 150430, '四道湾子镇', 150430104),
(150430105, 150430, '下洼镇', 150430105),
(150430106, 150430, '金厂沟梁镇', 150430106),
(150430200, 150430, '宝国吐乡', 150430200),
(150430201, 150430, '牛古吐乡', 150430201),
(150430202, 150430, '木头营子乡', 150430202),
(150430203, 150430, '古鲁板蒿乡', 150430203),
(150430204, 150430, '丰收乡', 150430204),
(150430205, 150430, '玛尼罕乡', 150430205),
(150430206, 150430, '萨力巴乡', 150430206),
(150430207, 150430, '敖润苏莫苏木乡', 150430207),
(150502001, 150502, '科尔沁街道', 150502001),
(150502002, 150502, '西门街道', 150502002),
(150502003, 150502, '永清街道', 150502003),
(150502004, 150502, '明仁街道', 150502004),
(150502005, 150502, '施介街道', 150502005),
(150502006, 150502, '清真街道', 150502006),
(150502007, 150502, '东郊街道', 150502007),
(150502008, 150502, '铁路街道', 150502008),
(150502009, 150502, '红星街道', 150502009),
(150502010, 150502, '霍林街道', 150502010),
(150502011, 150502, '建国街道', 150502011),
(150502020, 150502, '河西街道', 150502020),
(150502021, 150502, '电厂街道', 150502021),
(150502100, 150502, '大林镇', 150502100),
(150502101, 150502, '钱家店镇', 150502101),
(150502102, 150502, '余粮堡镇', 150502102),
(150502103, 150502, '木里图镇', 150502103),
(150502104, 150502, '丰田镇', 150502104),
(150502105, 150502, '清河镇', 150502105),
(150502106, 150502, '育新镇', 150502106),
(150502107, 150502, '庆和镇', 150502107),
(150502108, 150502, '敖力布皋镇', 150502108),
(150502130, 150502, '辽河镇', 150502130),
(150502200, 150502, '莫力庙苏木乡', 150502200),
(150502400, 150502, '哲南农场', 150502400),
(150502401, 150502, '三义堂农场', 150502401),
(150502402, 150502, '高林屯种畜场', 150502402),
(150502403, 150502, '胡力海原种繁殖场', 150502403),
(150502404, 150502, '莫力庙羊场', 150502404),
(150502405, 150502, '半截店牧场', 150502405),
(150521100, 150521, '保康镇', 150521100),
(150521101, 150521, '宝龙山镇', 150521101),
(150521102, 150521, '舍伯吐镇', 150521102),
(150521103, 150521, '巴彦塔拉镇', 150521103),
(150521104, 150521, '门达镇', 150521104),
(150521105, 150521, '架玛吐镇', 150521105),
(150521106, 150521, '腰林毛都镇', 150521106),
(150521107, 150521, '希伯花镇', 150521107),
(150521108, 150521, '花吐古拉镇', 150521108),
(150521109, 150521, '代力吉镇', 150521109),
(150521110, 150521, '努日木镇', 150521110),
(150521200, 150521, '花胡硕苏木乡', 150521200),
(150521201, 150521, '协代苏木乡', 150521201),
(150521202, 150521, '白兴吐苏木乡', 150521202),
(150521203, 150521, '图布信苏木乡', 150521203),
(150521400, 150521, '东苏林场', 150521400),
(150522100, 150522, '甘旗卡镇', 150522100),
(150522101, 150522, '吉尔嘎朗镇', 150522101),
(150522102, 150522, '金宝屯镇', 150522102),
(150522103, 150522, '常胜镇', 150522103),
(150522104, 150522, '查日苏镇', 150522104),
(150522105, 150522, '双胜镇', 150522105),
(150522106, 150522, '阿古拉镇', 150522106),
(150522107, 150522, '朝鲁吐镇', 150522107),
(150522108, 150522, '努古斯台镇', 150522108),
(150522109, 150522, '海鲁吐镇', 150522109),
(150522200, 150522, '阿都沁苏木乡', 150522200),
(150522201, 150522, '茂道吐苏木乡', 150522201),
(150522400, 150522, '胜利农场', 150522400),
(150522401, 150522, '孟根达坝牧场', 150522401),
(150522402, 150522, '查金台牧场', 150522402),
(150522403, 150522, '原种场', 150522403),
(150522404, 150522, '大青沟管理局', 150522404),
(150522405, 150522, '哈日乌苏种畜场', 150522405),
(150522406, 150522, '乌兰敖道渔场', 150522406),
(150522407, 150522, '金宝屯林场', 150522407),
(150522408, 150522, '朝鲁吐林场', 150522408),
(150522409, 150522, '茂道吐林场', 150522409),
(150522410, 150522, '伊胡塔林场', 150522410),
(150522411, 150522, '乌旦塔拉林场', 150522411),
(150523100, 150523, '开鲁镇', 150523100),
(150523101, 150523, '大榆树镇', 150523101),
(150523102, 150523, '黑龙坝镇', 150523102),
(150523103, 150523, '麦新镇', 150523103),
(150523104, 150523, '义和塔拉镇', 150523104),
(150523105, 150523, '建华镇', 150523105),
(150523106, 150523, '小街基镇', 150523106),
(150523107, 150523, '东风镇', 150523107),
(150523108, 150523, '吉日嘎郎吐镇', 150523108),
(150523109, 150523, '东来镇', 150523109),
(150523400, 150523, '清河牧场', 150523400),
(150523401, 150523, '辽河农场', 150523401),
(150523402, 150523, '保安农场', 150523402),
(150524100, 150524, '库伦镇', 150524100),
(150524101, 150524, '扣河子镇', 150524101),
(150524102, 150524, '白音花镇', 150524102),
(150524103, 150524, '六家子镇', 150524103),
(150524104, 150524, '额勒顺镇', 150524104),
(150524200, 150524, '茫汗苏木乡', 150524200),
(150525100, 150525, '大沁他拉镇', 150525100),
(150525101, 150525, '八仙筒镇', 150525101),
(150525102, 150525, '青龙山镇', 150525102),
(150525103, 150525, '新镇', 150525103),
(150525104, 150525, '治安镇', 150525104),
(150525105, 150525, '东明镇', 150525105),
(150525106, 150525, '土城子镇', 150525106),
(150525107, 150525, '义隆永镇', 150525107),
(150525200, 150525, '固日班花苏木乡', 150525200),
(150525201, 150525, '苇莲苏苏木乡', 150525201),
(150525202, 150525, '明仁苏木乡', 150525202),
(150525203, 150525, '黄花塔拉苏木乡', 150525203),
(150525400, 150525, '国有六号农场', 150525400),
(150526100, 150526, '鲁北镇', 150526100),
(150526101, 150526, '黄花山镇', 150526101),
(150526102, 150526, '嘎亥图镇', 150526102),
(150526103, 150526, '巨日合镇', 150526103),
(150526104, 150526, '巴雅尔图胡硕镇', 150526104),
(150526105, 150526, '香山镇', 150526105),
(150526106, 150526, '阿日昆都冷镇', 150526106),
(150526200, 150526, '巴彦塔拉苏木乡', 150526200),
(150526201, 150526, '乌力吉木仁苏木乡', 150526201),
(150526202, 150526, '道老杜苏木乡', 150526202),
(150526203, 150526, '格日朝鲁苏木乡', 150526203),
(150526400, 150526, '乌额格其牧场', 150526400),
(150526401, 150526, '香山农场', 150526401),
(150526402, 150526, '乌日根塔拉农场', 150526402),
(150526403, 150526, '嘎达苏种畜场', 150526403),
(150581001, 150581, '珠斯花街道', 150581001),
(150581002, 150581, '莫斯台街道', 150581002),
(150581003, 150581, '宝日呼吉尔街道', 150581003),
(150581004, 150581, '沙尔呼热街道', 150581004),
(150581005, 150581, '达来胡硕街道', 150581005),
(150581400, 150581, '东蒙农牧业有限责任公司', 150581400),
(150602001, 150602, '交通街道', 150602001),
(150602002, 150602, '公园街道', 150602002),
(150602003, 150602, '林荫街道', 150602003),
(150602004, 150602, '建设街道', 150602004),
(150602005, 150602, '富兴街道', 150602005),
(150602006, 150602, '天骄街道', 150602006),
(150602007, 150602, '哈巴格希街道', 150602007),
(150602008, 150602, '诃额伦街道', 150602008),
(150602009, 150602, '巴音孟克街道', 150602009),
(150602100, 150602, '泊尔江海子镇', 150602100),
(150602101, 150602, '罕台镇', 150602101),
(150602102, 150602, '塔拉壕镇', 150602102),
(150621100, 150621, '树林召镇', 150621100),
(150621101, 150621, '吉格斯太镇', 150621101),
(150621102, 150621, '白泥井镇', 150621102),
(150621103, 150621, '王爱召镇', 150621103),
(150621104, 150621, '昭君镇', 150621104),
(150621105, 150621, '恩格贝镇', 150621105),
(150621106, 150621, '中和西镇', 150621106),
(150621200, 150621, '展旦召苏木乡', 150621200),
(150622100, 150622, '薛家湾镇', 150622100),
(150622101, 150622, '沙圪堵镇', 150622101),
(150622102, 150622, '大路镇', 150622102),
(150622103, 150622, '纳日松镇', 150622103),
(150622104, 150622, '龙口镇', 150622104),
(150622105, 150622, '准格尔召镇', 150622105),
(150622200, 150622, '暖水乡', 150622200);
INSERT INTO `{pre}areas` VALUES
(150622201, 150622, '十二连城乡', 150622201),
(150622202, 150622, '布尔陶亥苏木乡', 150622202),
(150623100, 150623, '敖勒召其镇', 150623100),
(150623101, 150623, '上海庙镇', 150623101),
(150623102, 150623, '城川镇', 150623102),
(150623103, 150623, '昂素镇', 150623103),
(150623400, 150623, '上海庙经济开发区', 150623400),
(150624100, 150624, '乌兰镇', 150624100),
(150624101, 150624, '棋盘井镇', 150624101),
(150624102, 150624, '蒙西镇', 150624102),
(150624103, 150624, '木凯淖尔镇', 150624103),
(150624200, 150624, '苏米图苏木乡', 150624200),
(150624201, 150624, '阿尔巴斯苏木乡', 150624201),
(150624400, 150624, '鄂托克旗赛乌素草籽场', 150624400),
(150624401, 150624, '内蒙古白绒山羊种羊场', 150624401),
(150625100, 150625, '锡尼镇', 150625100),
(150625101, 150625, '巴拉贡镇', 150625101),
(150625102, 150625, '吉日嘎朗图镇', 150625102),
(150625103, 150625, '独贵塔拉镇', 150625103),
(150625104, 150625, '呼和木都镇', 150625104),
(150625200, 150625, '杭锦淖尔乡', 150625200),
(150625201, 150625, '伊和乌素苏木乡', 150625201),
(150625400, 150625, '哈拉淖农场', 150625400),
(150626100, 150626, '嘎鲁图镇', 150626100),
(150626101, 150626, '乌审召镇', 150626101),
(150626102, 150626, '图克镇', 150626102),
(150626103, 150626, '乌兰陶勒盖镇', 150626103),
(150626104, 150626, '无定河镇', 150626104),
(150626200, 150626, '苏力德苏木乡', 150626200),
(150626400, 150626, '种羊场', 150626400),
(150626401, 150626, '五个林场', 150626401),
(150627100, 150627, '阿勒腾席热镇', 150627100),
(150627101, 150627, '札萨克镇', 150627101),
(150627102, 150627, '乌兰木伦镇', 150627102),
(150627103, 150627, '纳林陶亥镇', 150627103),
(150627104, 150627, '苏布尔嘎镇', 150627104),
(150627105, 150627, '红庆河镇', 150627105),
(150627106, 150627, '伊金霍洛镇', 150627106),
(150702001, 150702, '正阳', 150702001),
(150702002, 150702, '健康街道', 150702002),
(150702003, 150702, '靠山街道', 150702003),
(150702004, 150702, '胜利街道', 150702004),
(150702005, 150702, '呼伦街道', 150702005),
(150702006, 150702, '奋斗街道', 150702006),
(150702007, 150702, '建设街道', 150702007),
(150702100, 150702, '哈克镇', 150702100),
(150702400, 150702, '谢尔塔拉种牛场', 150702400),
(150702401, 150702, '哈克牧业有限公司', 150702401),
(150721100, 150721, '那吉镇', 150721100),
(150721101, 150721, '六合镇', 150721101),
(150721102, 150721, '亚东镇', 150721102),
(150721103, 150721, '霍尔奇镇', 150721103),
(150721104, 150721, '向阳峪镇', 150721104),
(150721200, 150721, '得力其鄂温克民族乡', 150721200),
(150721201, 150721, '查巴奇鄂温克民族乡', 150721201),
(150721202, 150721, '音河达斡尔鄂温克民族乡', 150721202),
(150721203, 150721, '新发朝鲜民族乡', 150721203),
(150721400, 150721, '那吉屯农场', 150721400),
(150721401, 150721, '格尼河农场', 150721401),
(150721402, 150721, '阿荣旗林业局', 150721402),
(150722100, 150722, '尼尔基镇', 150722100),
(150722101, 150722, '红彦镇', 150722101),
(150722102, 150722, '宝山镇', 150722102),
(150722103, 150722, '哈达阳镇', 150722103),
(150722104, 150722, '阿尔拉镇', 150722104),
(150722106, 150722, '西瓦尔图镇', 150722106),
(150722108, 150722, '腾克镇', 150722108),
(150722110, 150722, '塔温敖宝镇', 150722110),
(150722200, 150722, '巴彦鄂温克民族乡', 150722200),
(150722203, 150722, '杜拉尔鄂温克民族乡', 150722203),
(150722400, 150722, '国营甘河农场', 150722400),
(150722401, 150722, '国营巴彦农场', 150722401),
(150722402, 150722, '国营欧肯河农场', 150722402),
(150722403, 150722, '国营东方红农场', 150722403),
(150723100, 150723, '阿里河镇', 150723100),
(150723101, 150723, '大杨树镇', 150723101),
(150723102, 150723, '甘河镇', 150723102),
(150723103, 150723, '托扎敏镇', 150723103),
(150723104, 150723, '诺敏镇', 150723104),
(150723105, 150723, '乌鲁布铁镇', 150723105),
(150723200, 150723, '古里乡', 150723200),
(150723400, 150723, '大兴安岭管理局诺敏河农场', 150723400),
(150723401, 150723, '大兴安岭农场宜里农场', 150723401),
(150723402, 150723, '大兴安岭农场管理局扎赉河农场', 150723402),
(150723403, 150723, '大兴安岭农场管理局古里农场', 150723403),
(150723404, 150723, '加格达奇区', 150723404),
(150723405, 150723, '松岭地区', 150723405),
(150723406, 150723, '大杨树林业局', 150723406),
(150723407, 150723, '甘河林业局', 150723407),
(150723408, 150723, '克一河林业局', 150723408),
(150723409, 150723, '吉文林业局', 150723409),
(150723410, 150723, '阿里河林业局', 150723410),
(150723411, 150723, '大兴安岭农工商联合公司', 150723411),
(150723412, 150723, '大兴安岭农场管理局东方红农场', 150723412),
(150723413, 150723, '大兴安岭农场管理局欧肯河农场', 150723413),
(150723414, 150723, '大兴安岭林管局毕拉河林业局', 150723414),
(150723415, 150723, '大兴安岭林管局伊图里河林业局', 150723415),
(150723416, 150723, '大兴安岭林管局库都尔林业局', 150723416),
(150723417, 150723, '大兴安岭林管局乌尔其汗林业局', 150723417),
(150724100, 150724, '巴彦托海镇', 150724100),
(150724101, 150724, '巴雁镇', 150724101),
(150724102, 150724, '伊敏河镇', 150724102),
(150724103, 150724, '锡尼河镇', 150724103),
(150724200, 150724, '巴彦塔拉达斡尔民族乡', 150724200),
(150724201, 150724, '伊敏苏木乡', 150724201),
(150724202, 150724, '辉苏木乡', 150724202),
(150724400, 150724, '巴彦托海经济开发区', 150724400),
(150724401, 150724, '伊敏河高载能工业园区', 150724401),
(150724402, 150724, '大雁马铃薯高新技术示范园区', 150724402),
(150725100, 150725, '陈旗巴彦库仁镇', 150725100),
(150725101, 150725, '陈旗宝日希勒镇', 150725101),
(150725102, 150725, '陈旗呼和诺尔镇', 150725102),
(150725200, 150725, '陈旗乌珠尔苏木乡', 150725200),
(150725201, 150725, '陈旗鄂温克民族苏木乡', 150725201),
(150725400, 150725, '陈旗国营哈达图农牧场', 150725400),
(150725401, 150725, '陈旗国营浩特陶海农牧场', 150725401),
(150725402, 150725, '陈旗国营特泥河农牧场', 150725402),
(150726100, 150726, '阿木古郎镇', 150726100),
(150726101, 150726, '嵯岗镇', 150726101),
(150726200, 150726, '乌布尔宝力格苏木乡', 150726200),
(150726201, 150726, '吉布胡郎图苏木乡', 150726201),
(150726202, 150726, '新宝力格苏木乡', 150726202),
(150726400, 150726, '嵯岗镇双娃牧场', 150726400),
(150727100, 150727, '阿拉坦额莫勒镇', 150727100),
(150727101, 150727, '阿日哈沙特镇', 150727101),
(150727102, 150727, '新巴尔虎右旗呼伦镇', 150727102),
(150727200, 150727, '贝尔苏木乡', 150727200),
(150727201, 150727, '克尔伦苏木乡', 150727201),
(150727400, 150727, '敖尔金牧场', 150727400),
(150781001, 150781, '东山街道', 150781001),
(150781002, 150781, '道南街道', 150781002),
(150781003, 150781, '道北街道', 150781003),
(150781004, 150781, '兴华街道', 150781004),
(150781005, 150781, '满洲里市第一', 150781005),
(150781006, 150781, '满洲里市第二', 150781006),
(150781007, 150781, '满洲里市第三', 150781007),
(150781008, 150781, '满洲里市第四', 150781008),
(150781009, 150781, '满洲里市第五', 150781009),
(150781010, 150781, '满洲里市灵泉街道', 150781010),
(150781011, 150781, '新开河街道', 150781011),
(150781400, 150781, '满洲里市互市贸易区', 150781400),
(150781401, 150781, '满洲里市经济合作区', 150781401),
(150781402, 150781, '满洲里市东湖区', 150781402),
(150781403, 150781, '满洲里市扎煤公司', 150781403),
(150781404, 150781, '扎赉诺尔矿区', 150781404),
(150782001, 150782, '胜利街道', 150782001),
(150782002, 150782, '红旗街道', 150782002),
(150782003, 150782, '新工街道', 150782003),
(150782004, 150782, '永兴街道', 150782004),
(150782005, 150782, '建设街道', 150782005),
(150782006, 150782, '暖泉街道', 150782006),
(150782007, 150782, '牧原街道', 150782007),
(150782100, 150782, '免渡河镇', 150782100),
(150782101, 150782, '博克图镇', 150782101),
(150782102, 150782, '绰源镇', 150782102),
(150782103, 150782, '乌尔其汉镇', 150782103),
(150782104, 150782, '库都尔镇', 150782104),
(150782105, 150782, '图里河镇', 150782105),
(150782400, 150782, '莫拐农场', 150782400),
(150782401, 150782, '牙克石农场', 150782401),
(150782402, 150782, '免渡河农场', 150782402),
(150783001, 150783, '兴华街道', 150783001),
(150783002, 150783, '正阳街道', 150783002),
(150783003, 150783, '繁荣街道', 150783003),
(150783004, 150783, '向阳街道', 150783004),
(150783005, 150783, '高台子街道', 150783005),
(150783006, 150783, '铁东街道', 150783006),
(150783007, 150783, '河西街道', 150783007),
(150783100, 150783, '磨菇气镇', 150783100),
(150783101, 150783, '洼堤镇', 150783101),
(150783102, 150783, '卧牛河镇', 150783102),
(150783103, 150783, '成吉思汗镇', 150783103),
(150783104, 150783, '大河湾镇', 150783104),
(150783105, 150783, '浩饶山镇', 150783105),
(150783200, 150783, '达斡尔民族乡', 150783200),
(150783201, 150783, '南木鄂伦春民族乡', 150783201),
(150783202, 150783, '萨马街鄂温克民族乡', 150783202),
(150783400, 150783, '大河湾农场', 150783400),
(150783401, 150783, '绰尔河农场', 150783401),
(150783402, 150783, '扎兰屯马场', 150783402),
(150783403, 150783, '成吉思汗监狱农场', 150783403),
(150783404, 150783, '公安部后勤供应处农场', 150783404),
(150783405, 150783, '南木林业局', 150783405),
(150783406, 150783, '柴河林业局', 150783406),
(150783407, 150783, '扎兰屯市林业局', 150783407),
(150783408, 150783, '市原种场', 150783408),
(150784001, 150784, '拉布达林街道', 150784001),
(150784002, 150784, '上库力街道', 150784002),
(150784100, 150784, '莫尔道嘎镇', 150784100),
(150784101, 150784, '黑山头镇', 150784101),
(150784200, 150784, '三河回族乡', 150784200),
(150784201, 150784, '室韦俄罗斯族民族乡', 150784201),
(150784400, 150784, '海拉尔农垦集团有限公司拉布大林农场分公司', 150784400),
(150784401, 150784, '三河金騋农牧有限责任公司', 150784401),
(150784402, 150784, '海拉尔农垦集团有限责任公司上库力农场分公司', 150784402),
(150784403, 150784, '海拉尔农垦集团有限责任公司苏沁牧场分公司', 150784403),
(150784404, 150784, '海拉尔农垦集团有限责任公司恩和牧场分公司', 150784404),
(150784405, 150784, '室韦牧场', 150784405),
(150785001, 150785, '河东街道', 150785001),
(150785002, 150785, '河西街道', 150785002),
(150785003, 150785, '森工路街道', 150785003),
(150785101, 150785, '金河镇', 150785101),
(150785102, 150785, '阿龙山镇', 150785102),
(150785103, 150785, '满归镇', 150785103),
(150785200, 150785, '敖鲁古雅乡', 150785200),
(150802001, 150802, '团结', 150802001),
(150802002, 150802, '车站', 150802002),
(150802003, 150802, '先锋', 150802003),
(150802004, 150802, '解放', 150802004),
(150802005, 150802, '新华', 150802005),
(150802006, 150802, '东环', 150802006),
(150802007, 150802, '铁南', 150802007),
(150802008, 150802, '西环路', 150802008),
(150802009, 150802, '北环', 150802009),
(150802010, 150802, '曙光', 150802010),
(150802100, 150802, '狼山镇', 150802100),
(150802101, 150802, '新华镇', 150802101),
(150802102, 150802, '干召庙镇', 150802102),
(150802103, 150802, '乌兰图克镇', 150802103),
(150802104, 150802, '双河镇', 150802104),
(150802105, 150802, '城关镇', 150802105),
(150802106, 150802, '白脑包镇', 150802106),
(150802400, 150802, '狼山农场', 150802400),
(150802401, 150802, '临河农场', 150802401),
(150821100, 150821, '隆兴昌镇', 150821100),
(150821101, 150821, '塔尔湖镇', 150821101),
(150821102, 150821, '套海镇', 150821102),
(150821103, 150821, '新公中镇', 150821103),
(150821104, 150821, '天吉太镇', 150821104),
(150821105, 150821, '胜丰镇', 150821105),
(150821106, 150821, '银定图镇', 150821106),
(150821400, 150821, '巴盟国营建丰农场', 150821400),
(150821401, 150821, '内蒙古东土城劳动教养管理所', 150821401),
(150822100, 150822, '巴彦高勒镇', 150822100),
(150822101, 150822, '隆盛合镇', 150822101),
(150822102, 150822, '渡口镇', 150822102),
(150822200, 150822, '沙金套海苏木乡', 150822200),
(150822400, 150822, '乌兰布和农场', 150822400),
(150822401, 150822, '巴彦套海农场', 150822401),
(150822402, 150822, '哈腾套海农场', 150822402),
(150822403, 150822, '包尔盖农场', 150822403),
(150822404, 150822, '纳林套海农场', 150822404),
(150822405, 150822, '沙漠林业实验中心', 150822405),
(150823100, 150823, '乌拉山镇', 150823100),
(150823101, 150823, '白彦花镇', 150823101),
(150823102, 150823, '先锋镇', 150823102),
(150823103, 150823, '新安镇', 150823103),
(150823104, 150823, '西小召镇', 150823104),
(150823105, 150823, '大佘太镇', 150823105),
(150823106, 150823, '明安镇', 150823106),
(150823107, 150823, '小佘太镇', 150823107),
(150823200, 150823, '额尔登布拉格苏木乡', 150823200),
(150823400, 150823, '巴彦淖尔市中滩农场', 150823400),
(150823401, 150823, '巴彦淖尔市西山咀农场', 150823401),
(150823402, 150823, '巴彦淖尔市新安农场', 150823402),
(150823403, 150823, '巴彦淖尔市苏独仑农场', 150823403),
(150823404, 150823, '巴彦淖尔市大佘太牧场', 150823404),
(150823405, 150823, '巴彦淖尔市乌梁素海渔场', 150823405),
(150824100, 150824, '海流图镇', 150824100),
(150824101, 150824, '乌加河镇', 150824101),
(150824102, 150824, '德岭山镇', 150824102),
(150824103, 150824, '石哈河镇', 150824103),
(150824200, 150824, '呼鲁斯太苏木乡', 150824200),
(150824201, 150824, '川井苏木乡', 150824201),
(150824202, 150824, '巴音乌兰苏木乡', 150824202),
(150824203, 150824, '新忽热苏木乡', 150824203),
(150824400, 150824, '牧羊海牧场', 150824400),
(150824401, 150824, '同和太种畜场', 150824401),
(150824402, 150824, '巴盟乌北林场', 150824402),
(150825100, 150825, '巴音宝力格镇', 150825100),
(150825101, 150825, '呼和温都尔镇', 150825101),
(150825102, 150825, '潮格温都尔镇', 150825102),
(150825200, 150825, '获各琦苏木乡', 150825200),
(150825201, 150825, '巴音前达门苏木乡', 150825201),
(150826100, 150826, '陕坝镇', 150826100),
(150826101, 150826, '头道桥镇', 150826101),
(150826102, 150826, '二道桥镇', 150826102),
(150826103, 150826, '三道桥镇', 150826103),
(150826104, 150826, '蛮会镇', 150826104),
(150826105, 150826, '团结镇', 150826105),
(150826106, 150826, '双庙镇', 150826106),
(150826107, 150826, '沙海镇', 150826107),
(150826400, 150826, '巴市太阳庙农场', 150826400),
(150902001, 150902, '新体路街道', 150902001),
(150902002, 150902, '桥东街道', 150902002),
(150902003, 150902, '前进路街道', 150902003),
(150902004, 150902, '常青街道', 150902004),
(150902005, 150902, '虎山街道', 150902005),
(150902006, 150902, '桥西街道', 150902006),
(150902007, 150902, '新华街街道', 150902007),
(150902008, 150902, '泉山街道', 150902008),
(150902105, 150902, '白海子镇', 150902105),
(150902205, 150902, '马莲渠乡', 150902205),
(150921106, 150921, '卓资山镇', 150921106),
(150921107, 150921, '旗下营镇', 150921107),
(150921108, 150921, '十八台镇', 150921108),
(150921109, 150921, '巴音锡勒镇', 150921109),
(150921110, 150921, '梨花镇', 150921110),
(150921210, 150921, '大榆树乡', 150921210),
(150921211, 150921, '红召乡', 150921211),
(150922103, 150922, '长顺镇', 150922103),
(150922104, 150922, '朝阳镇', 150922104),
(150922105, 150922, '七号镇', 150922105),
(150922300, 150922, '德包图乡', 150922300),
(150922301, 150922, '公腊胡洞乡', 150922301),
(150923101, 150923, '七台镇', 150923101),
(150923102, 150923, '十八顷镇', 150923102),
(150923103, 150923, '大黑沙土镇', 150923103),
(150923104, 150923, '西井子镇', 150923104),
(150923105, 150923, '屯垦队镇', 150923105),
(150923106, 150923, '小海子镇', 150923106),
(150923300, 150923, '大库伦乡', 150923300),
(150923301, 150923, '卯都乡', 150923301),
(150923302, 150923, '玻璃忽镜乡', 150923302),
(150924106, 150924, '城关镇', 150924106),
(150924107, 150924, '张皋镇', 150924107),
(150924108, 150924, '赛乌素镇', 150924108),
(150924109, 150924, '鄂尔栋镇', 150924109),
(150924110, 150924, '店子镇', 150924110),
(150924209, 150924, '大库联乡', 150924209),
(150924210, 150924, '民族团结乡', 150924210),
(150924400, 150924, '南部矿区管委会', 150924400),
(150925103, 150925, '岱海镇', 150925103),
(150925104, 150925, '六苏木镇', 150925104),
(150925105, 150925, '麦胡图镇', 150925105),
(150925106, 150925, '永兴镇', 150925106),
(150925107, 150925, '蛮汉镇', 150925107),
(150925218, 150925, '天成乡', 150925218),
(150925219, 150925, '曹碾满族乡', 150925219),
(150925400, 150925, '岱海循环工业发展区', 150925400),
(150925401, 150925, '蛮汉山林场', 150925401),
(150925402, 150925, '岱海林场', 150925402),
(150926105, 150926, '土贵乌拉镇', 150926105),
(150926106, 150926, '平地泉镇', 150926106),
(150926107, 150926, '玫瑰营镇', 150926107),
(150926108, 150926, '巴音塔拉镇', 150926108),
(150926209, 150926, '乌拉哈乌拉乡', 150926209),
(150926210, 150926, '黄茂营乡', 150926210),
(150926211, 150926, '三岔口乡', 150926211),
(150926500, 150926, '移民区管委会', 150926500),
(150927103, 150927, '科布尔镇', 150927103),
(150927104, 150927, '铁沙盖镇', 150927104),
(150927105, 150927, '黄羊城镇', 150927105),
(150927106, 150927, '广益隆镇', 150927106),
(150927107, 150927, '乌素图镇', 150927107),
(150927216, 150927, '大滩乡', 150927216),
(150927217, 150927, '宏盘乡', 150927217),
(150927218, 150927, '巴音乡', 150927218),
(150927219, 150927, '库联苏木乡', 150927219),
(150927220, 150927, '乌兰哈页苏木乡', 150927220),
(150928105, 150928, '白音察干镇', 150928105),
(150928106, 150928, '察哈尔右翼后旗土牧尔台镇', 150928106),
(150928107, 150928, '察哈尔右翼后旗红格尔图镇', 150928107),
(150928108, 150928, '察哈尔右翼后旗贲红镇', 150928108),
(150928209, 150928, '察哈尔右翼后旗当郎忽洞苏木乡', 150928209),
(150928210, 150928, '察哈尔右翼后旗乌兰哈达苏木乡', 150928210),
(150928211, 150928, '察哈尔右翼后旗锡勒乡', 150928211),
(150929101, 150929, '四子王旗乌兰花镇', 150929101),
(150929102, 150929, '四子王旗吉生太镇', 150929102),
(150929103, 150929, '四子王旗库伦图镇', 150929103),
(150929104, 150929, '四子王旗供济堂镇', 150929104),
(150929105, 150929, '四子王旗白音朝克图镇', 150929105),
(150929225, 150929, '四子王旗红格尔苏木乡', 150929225),
(150929226, 150929, '四子王旗江岸苏木乡', 150929226),
(150929227, 150929, '四子王旗查干补力格苏木乡', 150929227),
(150929228, 150929, '四子王旗脑木更苏木乡', 150929228),
(150929229, 150929, '四子王旗东八号乡', 150929229),
(150929230, 150929, '四子王旗忽鸡图乡', 150929230),
(150929400, 150929, '四子王旗乌兰牧场', 150929400),
(150981005, 150981, '新城区街道', 150981005),
(150981006, 150981, '旧城区街道', 150981006),
(150981007, 150981, '北城区街道', 150981007),
(150981008, 150981, '工业区街道', 150981008),
(150981009, 150981, '南城区街道', 150981009),
(150981107, 150981, '隆盛庄镇', 150981107),
(150981108, 150981, '黑土台镇', 150981108),
(150981109, 150981, '红砂坝镇', 150981109),
(150981110, 150981, '巨宝庄镇', 150981110),
(150981111, 150981, '三义泉镇', 150981111),
(150981207, 150981, '浑源窑乡', 150981207),
(150981208, 150981, '官屯堡乡', 150981208),
(152201001, 152201, '爱国街道', 152201001),
(152201002, 152201, '和平街道', 152201002),
(152201003, 152201, '兴安街道', 152201003),
(152201004, 152201, '胜利街道', 152201004),
(152201005, 152201, '铁西街道', 152201005),
(152201006, 152201, '都林街道', 152201006),
(152201007, 152201, '五一街道', 152201007),
(152201008, 152201, '永联街道', 152201008),
(152201100, 152201, '乌兰哈达镇', 152201100),
(152201101, 152201, '居力很镇', 152201101),
(152201400, 152201, '乌兰哈达原种场', 152201400),
(152202001, 152202, '林海街道', 152202001),
(152202002, 152202, '新城街道', 152202002),
(152202003, 152202, '温泉街道', 152202003),
(152202100, 152202, '天池镇', 152202100),
(152202101, 152202, '白狼镇', 152202101),
(152202102, 152202, '五岔沟镇', 152202102),
(152221100, 152221, '科尔沁镇', 152221100),
(152221101, 152221, '索伦镇', 152221101),
(152221102, 152221, '德佰斯镇', 152221102),
(152221103, 152221, '大石寨镇', 152221103),
(152221104, 152221, '归流河镇', 152221104),
(152221105, 152221, '葛根庙镇', 152221105),
(152221106, 152221, '察尔森镇', 152221106),
(152221107, 152221, '额尔格图镇', 152221107),
(152221200, 152221, '满族屯满族乡', 152221200),
(152221201, 152221, '乌兰毛都苏木乡', 152221201),
(152221202, 152221, '阿力得尔苏木乡', 152221202),
(152221400, 152221, '跃进马场', 152221400),
(152221401, 152221, '索伦牧场', 152221401),
(152221402, 152221, '呼和马场', 152221402),
(152221403, 152221, '阿力得尔牧场', 152221403),
(152221404, 152221, '公主陵牧场', 152221404),
(152221405, 152221, '绿水种畜场', 152221405),
(152221500, 152221, '前旗驻乌兰浩特市虚拟区域', 152221500),
(152222100, 152222, '巴彦呼舒镇', 152222100),
(152222101, 152222, '巴仁哲里木镇', 152222101),
(152222102, 152222, '吐列毛都镇', 152222102),
(152222103, 152222, '杜尔基镇', 152222103),
(152222104, 152222, '高力板镇', 152222104),
(152222105, 152222, '好腰苏木镇', 152222105),
(152222200, 152222, '代钦塔拉苏木乡', 152222200),
(152222201, 152222, '新佳木苏木乡', 152222201),
(152222400, 152222, '布敦化牧场', 152222400),
(152222401, 152222, '吐列毛杜农场', 152222401),
(152222402, 152222, '铅矿管理区', 152222402),
(152222403, 152222, '铜矿管理区', 152222403),
(152222404, 152222, '红星林场', 152222404),
(152222405, 152222, '杜尔基林场', 152222405),
(152222406, 152222, '义和塔拉林场', 152222406),
(152222407, 152222, '代钦塔拉林场', 152222407),
(152222408, 152222, '好腰苏木林场', 152222408),
(152222409, 152222, '哈日努拉防火站', 152222409),
(152222410, 152222, '种畜场', 152222410),
(152222411, 152222, '良种繁殖场', 152222411),
(152222412, 152222, '草籽繁殖场', 152222412),
(152223100, 152223, '音德尔镇', 152223100),
(152223101, 152223, '新林镇', 152223101),
(152223102, 152223, '巴彦高勒镇', 152223102),
(152223103, 152223, '胡尔勒镇', 152223103),
(152223104, 152223, '阿尔本格勒镇', 152223104),
(152223105, 152223, '巴达尔胡镇', 152223105),
(152223106, 152223, '图牧吉镇', 152223106),
(152223200, 152223, '好力保乡', 152223200),
(152223201, 152223, '巴彦乌兰苏木乡', 152223201),
(152223400, 152223, '图牧吉劳管所', 152223400),
(152223401, 152223, '内蒙劳改局东部分局', 152223401),
(152223402, 152223, '种畜场', 152223402),
(152223403, 152223, '八一牧场', 152223403),
(152223404, 152223, '巴达尔胡农场', 152223404),
(152224100, 152224, '突泉镇', 152224100),
(152224101, 152224, '六户镇', 152224101),
(152224102, 152224, '东杜尔基镇', 152224102),
(152224103, 152224, '永安镇', 152224103),
(152224104, 152224, '水泉镇', 152224104),
(152224105, 152224, '宝石镇', 152224105),
(152224400, 152224, '东杜尔基国营农场', 152224400),
(152224401, 152224, '东杜尔基良种场', 152224401),
(152224402, 152224, '莲花山铜矿', 152224402),
(152501001, 152501, '乌兰街道', 152501001),
(152501002, 152501, '锡林街道', 152501002),
(152501003, 152501, '东城街道', 152501003),
(152501200, 152501, '格日勒敖都苏木乡', 152501200),
(152501400, 152501, '赛乌苏科技园区', 152501400),
(152502001, 152502, '希日塔拉街道', 152502001),
(152502002, 152502, '宝力根街道', 152502002),
(152502003, 152502, '杭盖街道', 152502003),
(152502004, 152502, '楚古兰街道', 152502004),
(152502005, 152502, '额尔敦街道', 152502005),
(152502006, 152502, '南郊街道', 152502006),
(152502100, 152502, '阿尔善宝拉格镇', 152502100),
(152502200, 152502, '宝力根苏木乡乡', 152502200),
(152502201, 152502, '朝克乌拉苏木乡乡', 152502201),
(152502400, 152502, '巴彦锡勒', 152502400),
(152502401, 152502, '白音库伦牧场', 152502401),
(152502402, 152502, '贝力克牧场', 152502402),
(152502403, 152502, '毛登牧场', 152502403),
(152522100, 152522, '别力古台镇', 152522100),
(152522101, 152522, '洪格尔高勒镇', 152522101),
(152522102, 152522, '查干淖尔镇', 152522102),
(152522200, 152522, '那仁宝拉格苏木乡', 152522200),
(152522201, 152522, '伊和高勒苏木乡乡', 152522201),
(152522202, 152522, '吉尔嘎郎图苏木乡', 152522202),
(152522400, 152522, '玛尼图煤矿', 152522400),
(152523100, 152523, '满都拉图镇', 152523100),
(152523101, 152523, '查干敖包中心镇', 152523101),
(152523102, 152523, '巴彦淖尔镇', 152523102),
(152523200, 152523, '巴彦乌拉苏木乡', 152523200),
(152523201, 152523, '赛罕高毕苏木乡', 152523201),
(152523400, 152523, '恩格尔河灌区', 152523400),
(152524100, 152524, '赛汉塔拉镇', 152524100),
(152524101, 152524, '朱日和镇', 152524101),
(152524102, 152524, '乌日根塔拉镇', 152524102),
(152524200, 152524, '桑宝力格苏木乡', 152524200),
(152524201, 152524, '额仁淖尔苏木乡', 152524201),
(152524202, 152524, '赛罕乌力吉苏木乡', 152524202),
(152525100, 152525, '乌里雅斯太镇', 152525100),
(152525101, 152525, '道特淖尔镇', 152525101),
(152525102, 152525, '嘎达布其镇', 152525102),
(152525103, 152525, '满都胡宝拉格镇', 152525103),
(152525104, 152525, '额吉淖尔镇', 152525104),
(152525105, 152525, '巴音胡硕镇', 152525105),
(152525200, 152525, '呼热图淖尔苏木乡', 152525200),
(152525201, 152525, '萨麦苏木乡', 152525201),
(152525400, 152525, '哈拉盖图农牧场', 152525400),
(152525401, 152525, '贺斯格乌拉农牧场', 152525401),
(152525402, 152525, '乌拉盖牧场', 152525402),
(152525403, 152525, '水库农牧业经营公司场', 152525403),
(152526100, 152526, '巴拉嘎尔高勒镇', 152526100),
(152526101, 152526, '巴彦花镇', 152526101),
(152526102, 152526, '吉仁高勒镇', 152526102),
(152526103, 152526, '浩勒图高勒镇', 152526103),
(152526104, 152526, '高日罕镇', 152526104),
(152526200, 152526, '巴彦胡舒苏木乡', 152526200),
(152526400, 152526, '林业总场', 152526400),
(152527100, 152527, '宝昌镇', 152527100),
(152527101, 152527, '千斤沟镇', 152527101),
(152527102, 152527, '红旗镇', 152527102),
(152527103, 152527, '骆驼山镇', 152527103),
(152527200, 152527, '幸福乡', 152527200),
(152527201, 152527, '贡宝拉格苏木乡', 152527201),
(152527400, 152527, '万寿滩良种场', 152527400),
(152528100, 152528, '新宝拉格镇', 152528100),
(152528101, 152528, '巴彦塔拉镇', 152528101),
(152528200, 152528, '翁贡乌拉苏木乡', 152528200),
(152529100, 152529, '明安图镇', 152529100),
(152529101, 152529, '星耀镇', 152529101),
(152529200, 152529, '伊和淖尔苏木乡', 152529200),
(152529201, 152529, '乌兰查布苏木乡', 152529201),
(152529400, 152529, '额里图种畜场', 152529400),
(152529401, 152529, '哲日根图林场', 152529401),
(152530100, 152530, '上都镇', 152530100),
(152530101, 152530, '桑根达来镇', 152530101),
(152530102, 152530, '哈毕日嘎镇', 152530102),
(152530200, 152530, '宝绍岱苏木乡', 152530200),
(152530201, 152530, '那日图苏木乡', 152530201),
(152530202, 152530, '赛音胡都嘎苏木乡', 152530202),
(152530400, 152530, '五一种畜场总场', 152530400),
(152530401, 152530, '黑城子示范区', 152530401),
(152531100, 152531, '大北沟镇', 152531100),
(152531101, 152531, '多伦淖尔镇', 152531101),
(152531200, 152531, '大河口乡', 152531200),
(152531201, 152531, '蔡木山乡', 152531201),
(152921102, 152921, '温都尔勒图镇', 152921102),
(152921104, 152921, '乌斯太镇', 152921104),
(152921105, 152921, '巴润别立镇', 152921105),
(152921110, 152921, '巴彦浩特镇', 152921110),
(152921111, 152921, '嘉尔嘎勒赛汉镇', 152921111),
(152921112, 152921, '吉兰泰镇', 152921112),
(152921113, 152921, '宗别立镇', 152921113),
(152921114, 152921, '敖伦布拉格镇', 152921114),
(152921203, 152921, '巴彦木仁苏木乡', 152921203),
(152921211, 152921, '腾格里苏木乡', 152921211),
(152921213, 152921, '乌力吉苏木乡', 152921213),
(152921214, 152921, '巴彦诺尔公苏木乡', 152921214),
(152921215, 152921, '额尔克哈什哈苏木乡', 152921215),
(152922103, 152922, '额肯呼都格镇', 152922103),
(152922104, 152922, '雅布赖镇', 152922104),
(152922105, 152922, '阿拉腾敖包镇', 152922105),
(152922211, 152922, '孟根布拉格苏木乡', 152922211),
(152922212, 152922, '阿拉腾朝克苏木乡', 152922212),
(152923100, 152923, '达来呼布镇', 152923100),
(152923101, 152923, '额济纳旗东风镇', 152923101),
(152923200, 152923, '额济纳旗赛汉陶来苏木乡', 152923200),
(152923201, 152923, '额济纳旗马鬃山苏木乡', 152923201),
(152923202, 152923, '额济纳旗苏泊淖尔苏木乡', 152923202),
(152923400, 152923, '额济纳旗巴彦陶来农场', 152923400),
(210102001, 210102, '砂山街道', 210102001),
(210102002, 210102, '新华街道', 210102002),
(210102006, 210102, '吴淞街道', 210102006),
(210102007, 210102, '西塔街道', 210102007),
(210102009, 210102, '北道口街道', 210102009),
(210102011, 210102, '遂川街道', 210102011),
(210102013, 210102, '八经街道', 210102013),
(210102016, 210102, '马路湾街道', 210102016),
(210102017, 210102, '集贤街道', 210102017),
(210102018, 210102, '新兴街道', 210102018),
(210102019, 210102, '南湖街道', 210102019),
(210102021, 210102, '长白街道', 210102021),
(210102022, 210102, '太原街街道', 210102022),
(210102023, 210102, '北市场街道', 210102023),
(210102025, 210102, '南市场街道', 210102025),
(210102026, 210102, '中山街道', 210102026),
(210102027, 210102, '沈水湾街道', 210102027),
(210103004, 210103, '大西街道', 210103004),
(210103005, 210103, '滨河街道', 210103005),
(210103006, 210103, '万莲街道', 210103006),
(210103010, 210103, '大南街道', 210103010),
(210103011, 210103, '山东庙街道', 210103011),
(210103013, 210103, '朱剪炉街道', 210103013),
(210103014, 210103, '新北站街道', 210103014),
(210103015, 210103, '风雨坛街道', 210103015),
(210103017, 210103, '皇城街道', 210103017),
(210103018, 210103, '五里河街道', 210103018),
(210104001, 210104, '小北街道', 210104001),
(210104002, 210104, '大北街道', 210104002),
(210104003, 210104, '万泉街道', 210104003),
(210104004, 210104, '洮昌街道', 210104004),
(210104006, 210104, '文官街道', 210104006),
(210104007, 210104, '二台子街道', 210104007),
(210104008, 210104, '津桥街道', 210104008),
(210104009, 210104, '东站街道', 210104009),
(210104010, 210104, '辽沈街道', 210104010),
(210104011, 210104, '珠林街道', 210104011),
(210104012, 210104, '长安街道', 210104012),
(210104014, 210104, '新东街道', 210104014),
(210104015, 210104, '东塔街道', 210104015),
(210105001, 210105, '三台子街道', 210105001),
(210105002, 210105, '陵北街道', 210105002),
(210105003, 210105, '辽河街道', 210105003),
(210105004, 210105, '黑龙江街道', 210105004),
(210105005, 210105, '泰山街道', 210105005),
(210105006, 210105, '祟山街道', 210105006),
(210105007, 210105, '长江街道', 210105007),
(210105008, 210105, '黄河街道', 210105008),
(210105009, 210105, '昆山街道', 210105009),
(210105010, 210105, '亚明街道', 210105010),
(210105011, 210105, '克俭街道', 210105011),
(210105012, 210105, '三洞桥街道', 210105012),
(210105013, 210105, '华山街道', 210105013),
(210105014, 210105, '寿泉街道', 210105014),
(210105015, 210105, '塔湾街道', 210105015),
(210105016, 210105, '怒江街道', 210105016),
(210105017, 210105, '明廉街道', 210105017),
(210105018, 210105, '向工街道', 210105018),
(210105019, 210105, '新乐街道', 210105019),
(210105020, 210105, '太平街道', 210105020),
(210106001, 210106, '卫工街道', 210106001),
(210106003, 210106, '工人村街道', 210106003),
(210106005, 210106, '七路街道', 210106005),
(210106007, 210106, '启工街道', 210106007),
(210106013, 210106, '笃工街道', 210106013),
(210106015, 210106, '兴华街道', 210106015),
(210106018, 210106, '兴工街道', 210106018),
(210106019, 210106, '霁虹街道', 210106019),
(210106020, 210106, '凌空街道', 210106020),
(210106021, 210106, '轻重工街道', 210106021),
(210106022, 210106, '艳粉路官街道', 210106022),
(210106023, 210106, '兴齐保工街道', 210106023),
(210106024, 210106, '齐贤兴顺街道', 210106024),
(210106025, 210106, '云峰贵和街道', 210106025),
(210111001, 210111, '解放街道', 210111001),
(210111002, 210111, '铁友街道', 210111002),
(210111003, 210111, '民主街道', 210111003),
(210111004, 210111, '临湖街道', 210111004),
(210111005, 210111, '中兴街道', 210111005),
(210111006, 210111, '湖西街道', 210111006),
(210111007, 210111, '城郊街道', 210111007),
(210111101, 210111, '八一镇', 210111101),
(210111102, 210111, '红菱堡镇', 210111102),
(210111103, 210111, '林盛堡镇', 210111103),
(210111104, 210111, '沙河铺镇', 210111104),
(210111105, 210111, '十里河镇', 210111105),
(210111106, 210111, '陈相屯镇', 210111106),
(210111107, 210111, '姚千户屯镇', 210111107),
(210111203, 210111, '王纲堡乡', 210111203),
(210111204, 210111, '永乐乡', 210111204),
(210111205, 210111, '大沟乡', 210111205),
(210111206, 210111, '白清寨乡', 210111206),
(210111207, 210111, '佟沟乡', 210111207),
(210111401, 210111, '市浑河农场', 210111401),
(210111402, 210111, '沈阳塔山农业科技发展有限公司', 210111402),
(210111404, 210111, '区示范农场', 210111404),
(210111405, 210111, '省稻作研究所', 210111405),
(210111406, 210111, '区塔山林场', 210111406),
(210112001, 210112, '南塔街道', 210112001),
(210112002, 210112, '泉园街道', 210112002),
(210112003, 210112, '丰乐街道', 210112003),
(210112004, 210112, '马官桥街道', 210112004),
(210112006, 210112, '东陵街道', 210112006),
(210112007, 210112, '英达街道', 210112007),
(210112008, 210112, '前进街道', 210112008),
(210112009, 210112, '东湖街道（浑南新区）', 210112009),
(210112010, 210112, '五三街道（浑南新区）', 210112010),
(210112012, 210112, '浑河站东街道', 210112012),
(210112013, 210112, '浑河站西街道', 210112013),
(210112014, 210112, '高坎街道（棋盘山开发区）', 210112014),
(210112015, 210112, '满堂街道（棋盘山）', 210112015),
(210112102, 210112, '深井子镇', 210112102),
(210112103, 210112, '祝家屯镇', 210112103),
(210112104, 210112, '白塔堡镇', 210112104),
(210112106, 210112, '桃仙镇', 210112106),
(210112109, 210112, '李相镇', 210112109),
(210112206, 210112, '王滨沟乡', 210112206),
(210113001, 210113, '新城子街道', 210113001),
(210113002, 210113, '清水台街道', 210113002),
(210113003, 210113, '辉山街道（农业高新区）', 210113003),
(210113101, 210113, '道义镇', 210113101),
(210113102, 210113, '兴隆台锡伯族镇', 210113102),
(210113103, 210113, '清水台镇', 210113103),
(210113104, 210113, '蒲河镇', 210113104),
(210113105, 210113, '虎石台镇', 210113105),
(210113106, 210113, '财落镇', 210113106),
(210113201, 210113, '新城子乡', 210113201),
(210113202, 210113, '黄家锡伯族乡', 210113202),
(210113203, 210113, '石佛寺朝鲜族锡伯族乡', 210113203),
(210113204, 210113, '尹家乡', 210113204),
(210113206, 210113, '马刚乡', 210113206),
(210113401, 210113, '青年农场', 210113401),
(210113402, 210113, '前进农场', 210113402),
(210113403, 210113, '育新农场', 210113403),
(210113404, 210113, '新城子区马刚林场', 210113404),
(210113405, 210113, '新城子区示范农场', 210113405),
(210113406, 210113, '新城子区种畜场', 210113406),
(210114001, 210114, '迎宾路街道', 210114001),
(210114002, 210114, '北塔街道', 210114002),
(210114003, 210114, '陵西街道', 210114003),
(210114005, 210114, '于洪街道', 210114005),
(210114006, 210114, '杨士街道', 210114006),
(210114007, 210114, '北陵街道', 210114007),
(210114008, 210114, '陵东街道', 210114008),
(210114009, 210114, '沙岭街道', 210114009),
(210114101, 210114, '平罗镇', 210114101),
(210114102, 210114, '马三家子镇', 210114102),
(210114104, 210114, '大潘镇', 210114104),
(210114105, 210114, '造化镇', 210114105),
(210114106, 210114, '翟家镇', 210114106),
(210114107, 210114, '彰驿站镇', 210114107),
(210114108, 210114, '高花镇', 210114108),
(210114207, 210114, '大兴朝鲜族乡', 210114207),
(210114209, 210114, '大青中朝友谊乡', 210114209),
(210114213, 210114, '光辉乡', 210114213),
(210114401, 210114, '马三家劳动教养院', 210114401),
(210114402, 210114, '光辉农场', 210114402),
(210114403, 210114, '北陵农场', 210114403),
(210114404, 210114, '监狱城', 210114404),
(210122100, 210122, '辽中镇', 210122100),
(210122101, 210122, '于家房镇', 210122101),
(210122102, 210122, '朱家房镇', 210122102),
(210122103, 210122, '冷子堡镇', 210122103),
(210122104, 210122, '刘二堡镇', 210122104),
(210122105, 210122, '茨榆坨镇', 210122105),
(210122106, 210122, '新民屯镇', 210122106),
(210122107, 210122, '满都户镇', 210122107),
(210122108, 210122, '杨士岗镇', 210122108),
(210122109, 210122, '肖寨门镇', 210122109),
(210122110, 210122, '长滩镇', 210122110),
(210122111, 210122, '四方台镇', 210122111),
(210122201, 210122, '城郊乡', 210122201),
(210122202, 210122, '六间房乡', 210122202),
(210122204, 210122, '养士堡乡', 210122204),
(210122205, 210122, '潘家堡乡', 210122205),
(210122206, 210122, '老观坨乡', 210122206),
(210122208, 210122, '老大房乡', 210122208),
(210122209, 210122, '大黑岗子乡', 210122209),
(210122210, 210122, '牛心坨乡', 210122210),
(210122401, 210122, '四方台子农场', 210122401),
(210123100, 210123, '康平镇', 210123100),
(210123101, 210123, '小城子镇', 210123101),
(210123102, 210123, '张强镇', 210123102),
(210123103, 210123, '方家屯镇', 210123103),
(210123104, 210123, '东关屯镇', 210123104),
(210123105, 210123, '郝官屯镇', 210123105),
(210123106, 210123, '二牛所口镇', 210123106),
(210123203, 210123, '北四家子乡', 210123203),
(210123204, 210123, '两家子乡', 210123204),
(210123205, 210123, '山东屯乡', 210123205),
(210123206, 210123, '海洲窝堡乡', 210123206),
(210123208, 210123, '沙金台蒙古族满族乡', 210123208),
(210123209, 210123, '柳树屯蒙古族满族乡', 210123209),
(210123210, 210123, '西关屯蒙古族满族乡', 210123210),
(210123211, 210123, '东升满族蒙古族乡', 210123211),
(210123403, 210123, '辽宁省康平监狱', 210123403),
(210123404, 210123, '三台子畜牧场', 210123404),
(210124100, 210124, '法库镇', 210124100),
(210124101, 210124, '大孤家子镇', 210124101),
(210124102, 210124, '三面船镇', 210124102),
(210124103, 210124, '秀水河子镇', 210124103),
(210124104, 210124, '叶茂台镇', 210124104),
(210124105, 210124, '登仕堡子镇', 210124105),
(210124106, 210124, '柏家沟镇', 210124106),
(210124107, 210124, '丁家房镇', 210124107),
(210124201, 210124, '慈恩寺乡', 210124201),
(210124202, 210124, '孟家乡', 210124202),
(210124203, 210124, '和平乡', 210124203),
(210124204, 210124, '十间房乡', 210124204),
(210124205, 210124, '冯贝堡乡', 210124205),
(210124206, 210124, '依牛堡子乡', 210124206),
(210124207, 210124, '五台子乡', 210124207),
(210124208, 210124, '四家子蒙古族乡', 210124208),
(210124209, 210124, '双台子乡', 210124209),
(210124210, 210124, '卧牛石乡', 210124210),
(210124211, 210124, '包家屯乡', 210124211),
(210181001, 210181, '东城街道', 210181001),
(210181002, 210181, '辽滨街道', 210181002),
(210181003, 210181, '西城街道', 210181003),
(210181004, 210181, '新柳街道', 210181004),
(210181005, 210181, '新城街道', 210181005),
(210181101, 210181, '大红旗镇', 210181101),
(210181102, 210181, '梁山镇', 210181102),
(210181103, 210181, '公主屯镇', 210181103),
(210181104, 210181, '兴隆镇', 210181104),
(210181105, 210181, '前当堡镇', 210181105),
(210181106, 210181, '大民屯镇', 210181106),
(210181107, 210181, '大柳屯镇', 210181107),
(210181108, 210181, '兴隆堡镇', 210181108),
(210181109, 210181, '胡台镇', 210181109),
(210181110, 210181, '法哈牛镇', 210181110),
(210181111, 210181, '柳河沟镇', 210181111),
(210181202, 210181, '高台子乡', 210181202),
(210181204, 210181, '金五台子乡', 210181204),
(210181205, 210181, '红旗乡', 210181205),
(210181206, 210181, '卢家屯乡', 210181206),
(210181207, 210181, '姚堡乡', 210181207),
(210181208, 210181, '周坨子乡', 210181208),
(210181209, 210181, '于家窝堡乡', 210181209),
(210181210, 210181, '新农乡', 210181210),
(210181211, 210181, '东蛇山子乡', 210181211),
(210181212, 210181, '陶家屯乡', 210181212),
(210181213, 210181, '罗家房乡', 210181213),
(210181214, 210181, '三道岗子乡', 210181214),
(210181216, 210181, '张家屯乡', 210181216),
(210202001, 210202, '海军广场街道', 210202001),
(210202003, 210202, '桂林街道', 210202003),
(210202005, 210202, '人民路街道', 210202005),
(210202008, 210202, '青泥洼桥街道', 210202008),
(210202009, 210202, '昆明街道', 210202009),
(210202010, 210202, '葵英街道', 210202010),
(210202011, 210202, '桃源街道', 210202011),
(210202012, 210202, '老虎滩街道', 210202012),
(210203001, 210203, '香炉礁街道', 210203001),
(210203002, 210203, '站北街道', 210203002),
(210203004, 210203, '日新街道', 210203004),
(210203005, 210203, '北京街道', 210203005),
(210203010, 210203, '八一路街道', 210203010),
(210203011, 210203, '人民广场街道', 210203011),
(210203013, 210203, '白云街道', 210203013),
(210204002, 210204, '中山公园街道', 210204002),
(210204004, 210204, '白山路街道', 210204004),
(210204005, 210204, '兴工街道', 210204005),
(210204006, 210204, '春柳街道', 210204006),
(210204008, 210204, '马栏街道', 210204008),
(210204009, 210204, '南沙河口街道', 210204009),
(210204010, 210204, '黑石礁街道', 210204010),
(210204011, 210204, '李家街道', 210204011),
(210204017, 210204, '星海湾街道', 210204017),
(210211001, 210211, '周水子街道', 210211001),
(210211002, 210211, '椒金山街道', 210211002),
(210211004, 210211, '甘井子街道', 210211004),
(210211006, 210211, '南关岭街道', 210211006),
(210211007, 210211, '泡崖街道', 210211007),
(210211008, 210211, '中华路街道', 210211008),
(210211009, 210211, '兴华街道', 210211009),
(210211010, 210211, '机场街道', 210211010),
(210211014, 210211, '辛寨子街道', 210211014),
(210211015, 210211, '红旗街道', 210211015),
(210211016, 210211, '凌水街道', 210211016),
(210211017, 210211, '大连湾街道', 210211017),
(210211018, 210211, '泉水街道', 210211018),
(210211101, 210211, '革镇堡镇', 210211101),
(210211102, 210211, '营城子镇', 210211102),
(210211400, 210211, '大连华侨果树农场', 210211400),
(210211401, 210211, '大连华侨兴达实业公司', 210211401),
(210211402, 210211, '大连华侨鑫山企业公司', 210211402),
(210211403, 210211, '大连南关岭农场', 210211403),
(210212001, 210212, '登峰街道', 210212001),
(210212002, 210212, '市场街道', 210212002),
(210212003, 210212, '得胜街道', 210212003),
(210212004, 210212, '光荣街道', 210212004),
(210212005, 210212, '水师营街道', 210212005),
(210212006, 210212, '龙王塘街道', 210212006),
(210212007, 210212, '铁山街道', 210212007),
(210212008, 210212, '江西街道', 210212008),
(210212009, 210212, '双岛湾街道', 210212009),
(210212010, 210212, '三涧堡街道', 210212010),
(210212011, 210212, '长城街道', 210212011),
(210212012, 210212, '龙头街道', 210212012),
(210212013, 210212, '北海街道', 210212013),
(210212400, 210212, '旅顺开发区', 210212400),
(210212401, 210212, '大连奶牛场', 210212401),
(210213001, 210213, '拥政街道', 210213001),
(210213002, 210213, '友谊街道', 210213002),
(210213003, 210213, '光明街道', 210213003),
(210213004, 210213, '马桥子街道', 210213004),
(210213005, 210213, '海青岛街道', 210213005),
(210213006, 210213, '大孤山街道', 210213006),
(210213007, 210213, '中长街道', 210213007),
(210213008, 210213, '站前街道', 210213008),
(210213009, 210213, '先进街道', 210213009),
(210213011, 210213, '董家沟街道', 210213011),
(210213012, 210213, '金满街道', 210213012),
(210213013, 210213, '湾里街道', 210213013),
(210213101, 210213, '大李家镇', 210213101),
(210213102, 210213, '得胜镇', 210213102),
(210213103, 210213, '华家屯镇', 210213103),
(210213105, 210213, '二十里堡镇', 210213105),
(210213106, 210213, '三十里堡镇', 210213106),
(210213107, 210213, '亮甲店镇', 210213107),
(210213108, 210213, '登沙河镇', 210213108),
(210213109, 210213, '杏树屯镇', 210213109),
(210213110, 210213, '石河满族镇', 210213110),
(210213111, 210213, '大魏家镇', 210213111),
(210213112, 210213, '向应镇', 210213112),
(210213202, 210213, '七顶山满族乡', 210213202),
(210224100, 210224, '大长山岛镇', 210224100),
(210224101, 210224, '獐子岛镇', 210224101),
(210224201, 210224, '小长山乡', 210224201),
(210224202, 210224, '广鹿乡', 210224202),
(210224203, 210224, '海洋乡', 210224203),
(210281001, 210281, '新华', 210281001),
(210281002, 210281, '文兰', 210281002),
(210281003, 210281, '岭东', 210281003),
(210281004, 210281, '共济', 210281004),
(210281005, 210281, '铁东', 210281005),
(210281006, 210281, '祝华', 210281006),
(210281007, 210281, '岗店', 210281007),
(210281008, 210281, '太阳街道', 210281008),
(210281009, 210281, '长兴岛', 210281009),
(210281101, 210281, '复州城镇', 210281101),
(210281102, 210281, '复州湾镇', 210281102),
(210281103, 210281, '松树镇', 210281103),
(210281105, 210281, '得利寺镇', 210281105),
(210281106, 210281, '万家岭镇', 210281106),
(210281107, 210281, '许屯镇', 210281107),
(210281108, 210281, '永宁镇', 210281108),
(210281109, 210281, '谢屯镇', 210281109),
(210281110, 210281, '炮台镇', 210281110),
(210281111, 210281, '李店镇', 210281111),
(210281112, 210281, '老虎屯镇', 210281112),
(210281113, 210281, '东岗镇', 210281113),
(210281115, 210281, '李官镇', 210281115),
(210281116, 210281, '仙浴湾镇', 210281116),
(210281201, 210281, '赵屯乡', 210281201),
(210281203, 210281, '土城乡', 210281203),
(210281204, 210281, '阎店乡', 210281204),
(210281205, 210281, '西杨乡', 210281205),
(210281206, 210281, '驼山乡', 210281206),
(210281208, 210281, '三台满族乡', 210281208),
(210281209, 210281, '交流岛乡', 210281209),
(210281210, 210281, '泡崖乡', 210281210),
(210281212, 210281, '杨家满族乡', 210281212),
(210282001, 210282, '丰荣街道', 210282001),
(210282002, 210282, '铁西街道', 210282002),
(210282003, 210282, '太平街道', 210282003),
(210282004, 210282, '南山街道', 210282004),
(210282101, 210282, '皮口镇', 210282101),
(210282102, 210282, '城子坦镇', 210282102),
(210282104, 210282, '大刘家镇', 210282104),
(210282105, 210282, '杨树房镇', 210282105),
(210282106, 210282, '双塔镇', 210282106),
(210282107, 210282, '安波镇', 210282107),
(210282108, 210282, '四平镇', 210282108),
(210282109, 210282, '沙包镇', 210282109),
(210282110, 210282, '瓦窝镇', 210282110),
(210282111, 210282, '元台镇', 210282111),
(210282113, 210282, '大谭镇', 210282113),
(210282114, 210282, '夹河庙镇', 210282114),
(210282116, 210282, '莲山镇', 210282116),
(210282117, 210282, '星台镇', 210282117),
(210282206, 210282, '墨盘乡', 210282206),
(210282208, 210282, '同益乡', 210282208),
(210282209, 210282, '乐甲满族乡', 210282209),
(210283001, 210283, '城关街道', 210283001),
(210283002, 210283, '新华街道', 210283002),
(210283003, 210283, '兴达街道', 210283003),
(210283004, 210283, '昌盛街道', 210283004),
(210283101, 210283, '青堆镇', 210283101),
(210283102, 210283, '徐岭镇', 210283102),
(210283104, 210283, '黑岛镇', 210283104),
(210283105, 210283, '栗子房镇', 210283105),
(210283107, 210283, '大营镇', 210283107),
(210283108, 210283, '塔岭满族镇', 210283108),
(210283109, 210283, '仙人洞镇', 210283109),
(210283110, 210283, '蓉花山镇', 210283110),
(210283111, 210283, '长岭镇', 210283111),
(210283112, 210283, '荷花山镇', 210283112),
(210283113, 210283, '城山镇', 210283113),
(210283114, 210283, '光明山镇', 210283114),
(210283115, 210283, '大郑镇', 210283115),
(210283117, 210283, '明阳镇', 210283117),
(210283118, 210283, '吴炉镇', 210283118),
(210283120, 210283, '王家镇', 210283120),
(210283204, 210283, '鞍子山乡', 210283204),
(210283208, 210283, '太平岭满族乡', 210283208),
(210283209, 210283, '步云山乡', 210283209),
(210283211, 210283, '桂云花满族乡', 210283211),
(210283214, 210283, '兰店乡', 210283214),
(210283216, 210283, '石城乡', 210283216),
(210302001, 210302, '长甸', 210302001),
(210302002, 210302, '解放', 210302002),
(210302003, 210302, '山南', 210302003),
(210302004, 210302, '园林', 210302004),
(210302005, 210302, '胜利', 210302005),
(210302006, 210302, '站前', 210302006),
(210302007, 210302, '钢城', 210302007),
(210302008, 210302, '和平', 210302008),
(210302009, 210302, '对炉', 210302009),
(210302010, 210302, '东长甸', 210302010),
(210302011, 210302, '湖南', 210302011),
(210302012, 210302, '常青', 210302012),
(210302013, 210302, '新兴', 210302013),
(210303001, 210303, '启明街道', 210303001),
(210303002, 210303, '繁荣街道', 210303002),
(210303003, 210303, '八家子街道', 210303003),
(210303004, 210303, '兴盛街道', 210303004),
(210303005, 210303, '共和街道', 210303005),
(210303006, 210303, '永乐街道', 210303006),
(210303007, 210303, '北陶官街道', 210303007),
(210303008, 210303, '南华街道', 210303008),
(210303009, 210303, '大陆街道', 210303009),
(210303010, 210303, '新陶官街道', 210303010),
(210304001, 210304, '友好', 210304001),
(210304004, 210304, '双山', 210304004),
(210304006, 210304, '立山', 210304006),
(210304008, 210304, '曙光', 210304008),
(210304009, 210304, '灵山', 210304009),
(210304013, 210304, '深南', 210304013),
(210304014, 210304, '深北', 210304014),
(210304015, 210304, '沙河', 210304015),
(210304100, 210304, '沙河镇', 210304100),
(210311001, 210311, '旧堡街道', 210311001),
(210311002, 210311, '大孤山街道', 210311002),
(210311101, 210311, '东鞍山镇', 210311101),
(210311102, 210311, '唐家房镇', 210311102),
(210311103, 210311, '大孤山镇', 210311103),
(210311104, 210311, '千山镇', 210311104),
(210311105, 210311, '齐大山镇', 210311105),
(210311106, 210311, '达道湾镇', 210311106),
(210311107, 210311, '宁远镇', 210311107),
(210311108, 210311, '汤岗子镇', 210311108),
(210311401, 210311, '鞍山高新区', 210311401);
INSERT INTO `{pre}areas` VALUES
(210311402, 210311, '千山风景区管理委员会', 210311402),
(210321100, 210321, '台安镇', 210321100),
(210321101, 210321, '西佛镇', 210321101),
(210321102, 210321, '新开河镇', 210321102),
(210321103, 210321, '黄沙坨镇', 210321103),
(210321104, 210321, '高力房镇', 210321104),
(210321105, 210321, '桑林镇', 210321105),
(210321106, 210321, '富家镇', 210321106),
(210321107, 210321, '达牛镇', 210321107),
(210321109, 210321, '韭菜台镇', 210321109),
(210321110, 210321, '新台镇', 210321110),
(210321111, 210321, '桓洞镇', 210321111),
(210321400, 210321, '新华农场', 210321400),
(210321401, 210321, '洪家农牧场', 210321401),
(210321402, 210321, '西平林场', 210321402),
(210323100, 210323, '岫岩镇', 210323100),
(210323101, 210323, '三家子镇', 210323101),
(210323102, 210323, '石庙子镇', 210323102),
(210323103, 210323, '黄花甸镇', 210323103),
(210323104, 210323, '大营子镇', 210323104),
(210323105, 210323, '苏子沟镇', 210323105),
(210323106, 210323, '偏岭镇', 210323106),
(210323107, 210323, '哈达碑镇', 210323107),
(210323108, 210323, '新甸镇', 210323108),
(210323109, 210323, '洋河镇', 210323109),
(210323111, 210323, '杨家堡镇', 210323111),
(210323112, 210323, '汤沟镇', 210323112),
(210323113, 210323, '石灰窑镇', 210323113),
(210323114, 210323, '前营子镇', 210323114),
(210323115, 210323, '龙潭镇', 210323115),
(210323201, 210323, '牧牛乡', 210323201),
(210323202, 210323, '韭菜沟乡', 210323202),
(210323204, 210323, '大房身乡', 210323204),
(210323205, 210323, '朝阳乡', 210323205),
(210323206, 210323, '红旗营子乡', 210323206),
(210323211, 210323, '岭沟乡', 210323211),
(210323212, 210323, '哨子河乡', 210323212),
(210381001, 210381, '海州街道', 210381001),
(210381002, 210381, '兴海街道', 210381002),
(210381003, 210381, '响堂街道', 210381003),
(210381004, 210381, '东四街道', 210381004),
(210381101, 210381, '孤山镇', 210381101),
(210381102, 210381, '岔沟镇', 210381102),
(210381103, 210381, '接文镇', 210381103),
(210381104, 210381, '析木镇', 210381104),
(210381105, 210381, '马风镇', 210381105),
(210381107, 210381, '牌楼镇', 210381107),
(210381108, 210381, '八里镇', 210381108),
(210381109, 210381, '毛祁镇', 210381109),
(210381110, 210381, '英落镇', 210381110),
(210381111, 210381, '感王镇', 210381111),
(210381112, 210381, '西柳镇', 210381112),
(210381113, 210381, '中小镇', 210381113),
(210381114, 210381, '王石镇', 210381114),
(210381115, 210381, '南台镇', 210381115),
(210381116, 210381, '甘泉镇', 210381116),
(210381117, 210381, '大屯镇', 210381117),
(210381118, 210381, '腾鳌镇', 210381118),
(210381120, 210381, '东四方台温泉管理区', 210381120),
(210381121, 210381, '耿庄镇', 210381121),
(210381123, 210381, '牛庄镇', 210381123),
(210381124, 210381, '西四镇', 210381124),
(210381125, 210381, '望台镇', 210381125),
(210381126, 210381, '温香镇', 210381126),
(210381127, 210381, '高坨镇', 210381127),
(210381400, 210381, '海城经济开发区', 210381400),
(210402001, 210402, '站前街道', 210402001),
(210402003, 210402, '东公园街道', 210402003),
(210402005, 210402, '福民街道', 210402005),
(210402007, 210402, '新抚街道', 210402007),
(210402009, 210402, '榆林街道', 210402009),
(210402011, 210402, '永安台街道', 210402011),
(210402013, 210402, '千金街道', 210402013),
(210402015, 210402, '南阳街道', 210402015),
(210403002, 210403, '东洲街道', 210403002),
(210403003, 210403, '张甸街道', 210403003),
(210403004, 210403, '搭连街道', 210403004),
(210403005, 210403, '龙凤街道', 210403005),
(210403006, 210403, '新屯街道', 210403006),
(210403007, 210403, '万新街道', 210403007),
(210403008, 210403, '老虎台街道', 210403008),
(210403009, 210403, '平山街道', 210403009),
(210403010, 210403, '南花园街道', 210403010),
(210403011, 210403, '刘山街道', 210403011),
(210403012, 210403, '章党街道', 210403012),
(210403201, 210403, '千金乡', 210403201),
(210403202, 210403, '碾盘乡', 210403202),
(210404001, 210404, '田屯街道', 210404001),
(210404002, 210404, '工农街道', 210404002),
(210404003, 210404, '建设街道', 210404003),
(210404004, 210404, '和平街道', 210404004),
(210404005, 210404, '光明街道', 210404005),
(210404006, 210404, '朴屯街道', 210404006),
(210404007, 210404, '演武街道', 210404007),
(210404008, 210404, '五老屯街道', 210404008),
(210404009, 210404, '古城子街道', 210404009),
(210404010, 210404, '新民街道', 210404010),
(210404011, 210404, '李石街道', 210404011),
(210404101, 210404, '塔峪镇', 210404101),
(210411001, 210411, '河东街道', 210411001),
(210411002, 210411, '长春街道', 210411002),
(210411003, 210411, '葛布街道', 210411003),
(210411004, 210411, '将军堡街道', 210411004),
(210411005, 210411, '新华街道', 210411005),
(210411007, 210411, '抚顺城街道', 210411007),
(210411102, 210411, '前甸镇', 210411102),
(210411201, 210411, '河北乡', 210411201),
(210411205, 210411, '会元乡', 210411205),
(210421101, 210421, '石文镇', 210421101),
(210421102, 210421, '后安镇', 210421102),
(210421103, 210421, '章党镇', 210421103),
(210421104, 210421, '哈达镇', 210421104),
(210421204, 210421, '马圈子乡', 210421204),
(210421205, 210421, '上马乡', 210421205),
(210421207, 210421, '救兵乡', 210421207),
(210421209, 210421, '峡河乡', 210421209),
(210421211, 210421, '海浪乡', 210421211),
(210421212, 210421, '拉古满族乡', 210421212),
(210421215, 210421, '兰山乡', 210421215),
(210421216, 210421, '汤图满族乡', 210421216),
(210422100, 210422, '新宾镇', 210422100),
(210422101, 210422, '旺清门镇', 210422101),
(210422102, 210422, '永陵镇', 210422102),
(210422103, 210422, '平顶山镇', 210422103),
(210422104, 210422, '大四平镇', 210422104),
(210422105, 210422, '苇子峪镇', 210422105),
(210422106, 210422, '木奇镇', 210422106),
(210422108, 210422, '上夹河镇', 210422108),
(210422109, 210422, '南杂木镇', 210422109),
(210422202, 210422, '红升乡', 210422202),
(210422203, 210422, '响水河子乡', 210422203),
(210422204, 210422, '红庙子乡', 210422204),
(210422205, 210422, '北四平乡', 210422205),
(210422207, 210422, '榆树乡', 210422207),
(210422208, 210422, '下夹河乡', 210422208),
(210423100, 210423, '清原镇', 210423100),
(210423101, 210423, '红透山镇', 210423101),
(210423103, 210423, '草市镇', 210423103),
(210423104, 210423, '英额门镇', 210423104),
(210423105, 210423, '南口前镇', 210423105),
(210423106, 210423, '南山城镇', 210423106),
(210423107, 210423, '湾甸子镇', 210423107),
(210423108, 210423, '大孤家镇', 210423108),
(210423109, 210423, '夏家堡镇', 210423109),
(210423203, 210423, '土口子乡', 210423203),
(210423204, 210423, '北三家乡', 210423204),
(210423206, 210423, '敖家堡乡', 210423206),
(210423207, 210423, '大苏河乡', 210423207),
(210423208, 210423, '枸乃甸乡', 210423208),
(210502001, 210502, '南地街道', 210502001),
(210502002, 210502, '工人街道', 210502002),
(210502003, 210502, '平山街道', 210502003),
(210502004, 210502, '东明街道', 210502004),
(210502005, 210502, '崔东街道', 210502005),
(210502007, 210502, '站前街道', 210502007),
(210502008, 210502, '千金街道', 210502008),
(210502010, 210502, '北台街道', 210502010),
(210502101, 210502, '桥头镇', 210502101),
(210503001, 210503, '河东街道', 210503001),
(210503003, 210503, '河西街道', 210503003),
(210503005, 210503, '彩屯街道', 210503005),
(210503006, 210503, '竖井街道', 210503006),
(210503007, 210503, '彩北街道', 210503007),
(210503009, 210503, '东风街道', 210503009),
(210503101, 210503, '火连寨镇', 210503101),
(210503102, 210503, '歪头山镇', 210503102),
(210503104, 210503, '石桥子镇', 210503104),
(210503201, 210503, '张其寨乡', 210503201),
(210504001, 210504, '金山街道', 210504001),
(210504002, 210504, '北地街道', 210504002),
(210504004, 210504, '高峪街道', 210504004),
(210504005, 210504, '明山街道', 210504005),
(210504007, 210504, '东兴街道', 210504007),
(210504008, 210504, '新明街道', 210504008),
(210504009, 210504, '牛心台街道', 210504009),
(210504010, 210504, '卧龙街道', 210504010),
(210504101, 210504, '高台子镇', 210504101),
(210505001, 210505, '南芬街道', 210505001),
(210505002, 210505, '铁山街道', 210505002),
(210505003, 210505, '郭家街道', 210505003),
(210505101, 210505, '下马塘镇', 210505101),
(210505202, 210505, '思山岭满族乡', 210505202),
(210521001, 210521, '观音阁街道', 210521001),
(210521100, 210521, '小市镇', 210521100),
(210521101, 210521, '草河掌镇', 210521101),
(210521102, 210521, '草河城镇', 210521102),
(210521103, 210521, '草河口镇', 210521103),
(210521104, 210521, '连山关镇', 210521104),
(210521106, 210521, '清河城镇', 210521106),
(210521109, 210521, '田师傅镇', 210521109),
(210521110, 210521, '南甸镇', 210521110),
(210521111, 210521, '碱厂镇', 210521111),
(210521112, 210521, '高官镇', 210521112),
(210521202, 210521, '东营房乡', 210521202),
(210522001, 210522, '江城街道', 210522001),
(210522100, 210522, '桓仁镇', 210522100),
(210522101, 210522, '普乐堡镇', 210522101),
(210522102, 210522, '二棚甸子镇', 210522102),
(210522103, 210522, '沙尖子镇', 210522103),
(210522104, 210522, '五里甸子镇', 210522104),
(210522108, 210522, '八里甸子镇', 210522108),
(210522110, 210522, '华来镇', 210522110),
(210522111, 210522, '古城镇', 210522111),
(210522201, 210522, '雅河朝鲜族乡', 210522201),
(210522202, 210522, '向阳乡', 210522202),
(210522206, 210522, '黑沟乡', 210522206),
(210522208, 210522, '北甸子乡', 210522208),
(210602001, 210602, '六道口街道', 210602001),
(210602002, 210602, '七道街道', 210602002),
(210602003, 210602, '八道街道', 210602003),
(210602004, 210602, '九道街道', 210602004),
(210602005, 210602, '广济街道', 210602005),
(210602006, 210602, '兴东街道', 210602006),
(210602101, 210602, '金山镇', 210602101),
(210603001, 210603, '头道桥街道', 210603001),
(210603002, 210603, '站前街道', 210603002),
(210603003, 210603, '临江街道', 210603003),
(210603004, 210603, '六道街道', 210603004),
(210603005, 210603, '帽盔山街道', 210603005),
(210603006, 210603, '纤维街道', 210603006),
(210603007, 210603, '永昌街道', 210603007),
(210603008, 210603, '花园街道', 210603008),
(210603101, 210603, '浪头镇', 210603101),
(210603102, 210603, '安民镇', 210603102),
(210604001, 210604, '鸭绿江街道', 210604001),
(210604003, 210604, '金矿街道', 210604003),
(210604004, 210604, '珍珠街道', 210604004),
(210604005, 210604, '太平湾街道', 210604005),
(210604102, 210604, '同兴镇', 210604102),
(210604104, 210604, '五龙背镇', 210604104),
(210604105, 210604, '楼房镇', 210604105),
(210604106, 210604, '九连城镇', 210604106),
(210604107, 210604, '汤山城镇', 210604107),
(210624100, 210624, '宽甸镇', 210624100),
(210624101, 210624, '灌水镇', 210624101),
(210624102, 210624, '硼海镇', 210624102),
(210624103, 210624, '红石镇', 210624103),
(210624104, 210624, '毛甸子镇', 210624104),
(210624105, 210624, '长甸镇', 210624105),
(210624106, 210624, '永甸镇', 210624106),
(210624108, 210624, '太平哨镇', 210624108),
(210624109, 210624, '青山沟镇', 210624109),
(210624110, 210624, '牛毛坞镇', 210624110),
(210624111, 210624, '大川头镇', 210624111),
(210624112, 210624, '青椅山镇', 210624112),
(210624113, 210624, '杨木川镇', 210624113),
(210624114, 210624, '虎山镇', 210624114),
(210624115, 210624, '振江镇', 210624115),
(210624116, 210624, '步达远镇', 210624116),
(210624117, 210624, '大西岔镇', 210624117),
(210624118, 210624, '八河川镇', 210624118),
(210624119, 210624, '双山子镇', 210624119),
(210624201, 210624, '石湖沟乡', 210624201),
(210624206, 210624, '古楼子乡', 210624206),
(210624212, 210624, '下露河朝鲜族乡', 210624212),
(210681001, 210681, '大东街道', 210681001),
(210681002, 210681, '新兴街道', 210681002),
(210681003, 210681, '新城街道', 210681003),
(210681101, 210681, '孤山镇', 210681101),
(210681103, 210681, '汤池镇', 210681103),
(210681104, 210681, '前阳镇', 210681104),
(210681105, 210681, '长安镇', 210681105),
(210681106, 210681, '十字街镇', 210681106),
(210681107, 210681, '长山镇', 210681107),
(210681108, 210681, '北井子镇', 210681108),
(210681109, 210681, '椅圈镇', 210681109),
(210681110, 210681, '黄土坎镇', 210681110),
(210681113, 210681, '马家店镇', 210681113),
(210681114, 210681, '龙王庙满族锡伯族镇', 210681114),
(210681115, 210681, '小甸子镇', 210681115),
(210681117, 210681, '菩萨庙镇', 210681117),
(210681118, 210681, '黑沟镇', 210681118),
(210681119, 210681, '新农镇', 210681119),
(210681206, 210681, '合隆乡', 210681206),
(210681401, 210681, '示范农场', 210681401),
(210681402, 210681, '黄土坎农场', 210681402),
(210681403, 210681, '海洋红农场', 210681403),
(210681404, 210681, '兴隆农场', 210681404),
(210681405, 210681, '五四农场', 210681405),
(210682001, 210682, '凤凰城街道', 210682001),
(210682002, 210682, '凤山街道', 210682002),
(210682003, 210682, '草河街道', 210682003),
(210682101, 210682, '宝山镇', 210682101),
(210682102, 210682, '白旗镇', 210682102),
(210682103, 210682, '沙里寨镇', 210682103),
(210682104, 210682, '红旗镇', 210682104),
(210682105, 210682, '蓝旗镇', 210682105),
(210682107, 210682, '边门镇', 210682107),
(210682109, 210682, '大堡蒙古族镇', 210682109),
(210682110, 210682, '东汤镇', 210682110),
(210682111, 210682, '石城镇', 210682111),
(210682112, 210682, '大兴镇', 210682112),
(210682113, 210682, '爱阳镇', 210682113),
(210682114, 210682, '赛马镇', 210682114),
(210682115, 210682, '弟兄山镇', 210682115),
(210682116, 210682, '鸡冠山镇', 210682116),
(210682117, 210682, '刘家河镇', 210682117),
(210682118, 210682, '通远堡镇', 210682118),
(210682119, 210682, '四门子镇', 210682119),
(210682120, 210682, '青城子镇', 210682120),
(210702001, 210702, '天安街道', 210702001),
(210702002, 210702, '石油街道', 210702002),
(210702003, 210702, '北街街道', 210702003),
(210702004, 210702, '敬业街道', 210702004),
(210702005, 210702, '保安街道', 210702005),
(210702006, 210702, '南街街道', 210702006),
(210702007, 210702, '饶阳街道', 210702007),
(210702008, 210702, '站前街道', 210702008),
(210702009, 210702, '士英街道', 210702009),
(210703001, 210703, '正大街道', 210703001),
(210703002, 210703, '石桥子街道', 210703002),
(210703003, 210703, '龙江街道', 210703003),
(210703004, 210703, '榴花街道', 210703004),
(210703005, 210703, '铁新街道', 210703005),
(210703006, 210703, '凌安街道', 210703006),
(210703007, 210703, '菊园街道', 210703007),
(210703008, 210703, '康宁街道', 210703008),
(210703009, 210703, '锦铁街道', 210703009),
(210703010, 210703, '马家街道', 210703010),
(210703011, 210703, '百股街道', 210703011),
(210703402, 210703, '锦州北山农工商总公司', 210703402),
(210711001, 210711, '太和街道', 210711001),
(210711002, 210711, '兴隆街道', 210711002),
(210711003, 210711, '汤河子街道', 210711003),
(210711004, 210711, '凌西街道', 210711004),
(210711006, 210711, '凌南街道', 210711006),
(210711007, 210711, '大薛街道', 210711007),
(210711070, 210711, '王家街道', 210711070),
(210711071, 210711, '天桥街道', 210711071),
(210711072, 210711, '杏山街道', 210711072),
(210711202, 210711, '女儿河乡', 210711202),
(210711203, 210711, '钟屯乡', 210711203),
(210711204, 210711, '营盘乡', 210711204),
(210711205, 210711, '新民乡', 210711205),
(210711401, 210711, '锦州市果树农场', 210711401),
(210726100, 210726, '黑山镇', 210726100),
(210726101, 210726, '芳山镇', 210726101),
(210726102, 210726, '白厂门镇', 210726102),
(210726103, 210726, '常兴镇', 210726103),
(210726104, 210726, '姜屯镇', 210726104),
(210726105, 210726, '励家镇', 210726105),
(210726106, 210726, '绕阳河镇', 210726106),
(210726107, 210726, '半拉门镇', 210726107),
(210726108, 210726, '无梁殿镇', 210726108),
(210726109, 210726, '胡家镇', 210726109),
(210726110, 210726, '新立屯镇', 210726110),
(210726111, 210726, '八道壕镇', 210726111),
(210726112, 210726, '大虎山镇', 210726112),
(210726113, 210726, '四家子镇', 210726113),
(210726114, 210726, '新兴镇', 210726114),
(210726116, 210726, '太和镇', 210726116),
(210726201, 210726, '英城子乡', 210726201),
(210726208, 210726, '镇安乡', 210726208),
(210726209, 210726, '段家乡', 210726209),
(210726210, 210726, '大兴乡', 210726210),
(210726212, 210726, '薛屯乡', 210726212),
(210726400, 210726, '辽宁省锦州市小东种畜场', 210726400),
(210727100, 210727, '义州镇', 210727100),
(210727101, 210727, '刘龙台镇', 210727101),
(210727102, 210727, '七里河镇', 210727102),
(210727103, 210727, '大榆树堡镇', 210727103),
(210727104, 210727, '稍户营子镇', 210727104),
(210727105, 210727, '九道岭镇', 210727105),
(210727106, 210727, '高台子镇', 210727106),
(210727108, 210727, '瓦子峪镇', 210727108),
(210727201, 210727, '城关满族乡', 210727201),
(210727202, 210727, '头道河满族乡', 210727202),
(210727203, 210727, '地藏寺满族乡', 210727203),
(210727204, 210727, '留龙沟满族乡', 210727204),
(210727205, 210727, '大定堡满族乡', 210727205),
(210727206, 210727, '前杨乡', 210727206),
(210727207, 210727, '白庙子乡', 210727207),
(210727208, 210727, '聚粮屯乡', 210727208),
(210727209, 210727, '张家堡乡', 210727209),
(210727215, 210727, '头台满族乡', 210727215),
(210781001, 210781, '大凌河街道', 210781001),
(210781002, 210781, '金城街道', 210781002),
(210781101, 210781, '石山镇', 210781101),
(210781102, 210781, '余积镇', 210781102),
(210781103, 210781, '双羊镇', 210781103),
(210781104, 210781, '班吉塔镇', 210781104),
(210781105, 210781, '沈家台镇', 210781105),
(210781106, 210781, '三台子镇', 210781106),
(210781107, 210781, '右卫满族镇', 210781107),
(210781108, 210781, '阎家镇', 210781108),
(210781109, 210781, '新庄子镇', 210781109),
(210781110, 210781, '娘娘宫镇', 210781110),
(210781112, 210781, '翠岩镇', 210781112),
(210781170, 210781, '松山镇', 210781170),
(210781202, 210781, '大业乡', 210781202),
(210781204, 210781, '西八千乡', 210781204),
(210781205, 210781, '建业乡', 210781205),
(210781210, 210781, '温滴楼满族乡', 210781210),
(210781212, 210781, '板石沟乡', 210781212),
(210781214, 210781, '白台子乡', 210781214),
(210781217, 210781, '谢屯乡', 210781217),
(210781219, 210781, '安屯乡', 210781219),
(210781401, 210781, '辽宁省金城原种场', 210781401),
(210781405, 210781, '大有农场', 210781405),
(210782004, 210782, '北镇街道', 210782004),
(210782005, 210782, '观音阁街道', 210782005),
(210782101, 210782, '大市镇', 210782101),
(210782102, 210782, '罗罗堡镇', 210782102),
(210782103, 210782, '常兴店镇', 210782103),
(210782104, 210782, '正安镇', 210782104),
(210782105, 210782, '闾阳镇', 210782105),
(210782106, 210782, '中安镇', 210782106),
(210782107, 210782, '廖屯镇', 210782107),
(210782109, 210782, '赵屯镇', 210782109),
(210782110, 210782, '青堆子镇', 210782110),
(210782111, 210782, '高山子镇', 210782111),
(210782112, 210782, '沟帮子镇', 210782112),
(210782201, 210782, '富屯乡', 210782201),
(210782203, 210782, '鲍家乡', 210782203),
(210782206, 210782, '大屯乡', 210782206),
(210782208, 210782, '吴家乡', 210782208),
(210782209, 210782, '柳家乡', 210782209),
(210782211, 210782, '广宁乡', 210782211),
(210782403, 210782, '新立农场', 210782403),
(210802001, 210802, '八田地街道', 210802001),
(210802002, 210802, '建丰街道', 210802002),
(210802003, 210802, '建设街道', 210802003),
(210802004, 210802, '跃进街道', 210802004),
(210802005, 210802, '东风街道', 210802005),
(210802006, 210802, '新兴街道', 210802006),
(210802007, 210802, '新建街道', 210802007),
(210803001, 210803, '胜利街道', 210803001),
(210803002, 210803, '清华街道', 210803002),
(210803003, 210803, '滨海街道', 210803003),
(210803004, 210803, '得胜街道', 210803004),
(210803005, 210803, '五台子街道', 210803005),
(210803006, 210803, '渔市街道', 210803006),
(210803007, 210803, '河北街道', 210803007),
(210804001, 210804, '红海街道', 210804001),
(210804002, 210804, '海星街道', 210804002),
(210804003, 210804, '望海街道', 210804003),
(210804004, 210804, '海东街道', 210804004),
(210804100, 210804, '熊岳镇', 210804100),
(210804101, 210804, '芦屯镇', 210804101),
(210804102, 210804, '红旗满族镇', 210804102),
(210811001, 210811, '老边街道', 210811001),
(210811002, 210811, '城东街道', 210811002),
(210811101, 210811, '路南镇', 210811101),
(210811102, 210811, '柳树镇', 210811102),
(210811103, 210811, '边城镇', 210811103),
(210811104, 210811, '二道镇', 210811104),
(210881001, 210881, '鼓楼街道', 210881001),
(210881002, 210881, '西城街道', 210881002),
(210881003, 210881, '东城街道', 210881003),
(210881004, 210881, '太阳升街道', 210881004),
(210881005, 210881, '团山街道', 210881005),
(210881006, 210881, '西海街道', 210881006),
(210881102, 210881, '高屯镇', 210881102),
(210881105, 210881, '沙岗镇', 210881105),
(210881108, 210881, '九垅地镇', 210881108),
(210881109, 210881, '九寨镇', 210881109),
(210881110, 210881, '万福镇', 210881110),
(210881111, 210881, '卧龙泉镇', 210881111),
(210881112, 210881, '青石岭镇', 210881112),
(210881113, 210881, '暖泉镇', 210881113),
(210881115, 210881, '归州满族镇', 210881115),
(210881116, 210881, '榜式堡镇', 210881116),
(210881117, 210881, '团甸镇', 210881117),
(210881118, 210881, '双台镇', 210881118),
(210881119, 210881, '杨运镇', 210881119),
(210881120, 210881, '徐屯镇', 210881120),
(210881121, 210881, '什字街镇', 210881121),
(210881122, 210881, '矿洞沟镇', 210881122),
(210881123, 210881, '陈屯镇', 210881123),
(210881124, 210881, '梁屯镇', 210881124),
(210881216, 210881, '小石棚乡', 210881216),
(210881217, 210881, '果园乡', 210881217),
(210881218, 210881, '二台乡', 210881218),
(210882001, 210882, '石桥街道', 210882001),
(210882002, 210882, '青花街道', 210882002),
(210882003, 210882, '金桥街道', 210882003),
(210882004, 210882, '钢都街道', 210882004),
(210882005, 210882, '南楼街道', 210882005),
(210882101, 210882, '水源镇', 210882101),
(210882102, 210882, '沟沿镇', 210882102),
(210882103, 210882, '石佛镇', 210882103),
(210882104, 210882, '高坎镇', 210882104),
(210882105, 210882, '旗口镇', 210882105),
(210882106, 210882, '虎庄镇', 210882106),
(210882107, 210882, '官屯镇', 210882107),
(210882112, 210882, '博洛铺镇', 210882112),
(210882113, 210882, '永安镇', 210882113),
(210882114, 210882, '汤池镇', 210882114),
(210882115, 210882, '建一镇', 210882115),
(210882116, 210882, '黄土岭镇', 210882116),
(210882117, 210882, '周家镇', 210882117),
(210902002, 210902, '新兴街道', 210902002),
(210902003, 210902, '和平街道', 210902003),
(210902004, 210902, '西山街道', 210902004),
(210902005, 210902, '河北街道', 210902005),
(210902006, 210902, '站前街道', 210902006),
(210902007, 210902, '西阜新街道', 210902007),
(210902008, 210902, '五龙街道', 210902008),
(210902009, 210902, '平安西部街道', 210902009),
(210902010, 210902, '工人村街道', 210902010),
(210902011, 210902, '东梁街道', 210902011),
(210902101, 210902, '韩家店镇', 210902101),
(210903001, 210903, '街基街道', 210903001),
(210903002, 210903, '中部街道', 210903002),
(210903003, 210903, '北部街道', 210903003),
(210903004, 210903, '南部街道', 210903004),
(210903101, 210903, '长营子蒙古族镇', 210903101),
(210904001, 210904, '红树街道', 210904001),
(210904002, 210904, '煤海街道', 210904002),
(210904003, 210904, '高德街道', 210904003),
(210904004, 210904, '孙家湾街道', 210904004),
(210904005, 210904, '城南街道', 210904005),
(210904101, 210904, '水泉镇', 210904101),
(210905001, 210905, '清河街道', 210905001),
(210905002, 210905, '六台街道', 210905002),
(210905003, 210905, '艾友街道', 210905003),
(210905004, 210905, '新北街道', 210905004),
(210905101, 210905, '河西镇', 210905101),
(210905102, 210905, '乌龙坝镇', 210905102),
(210911001, 210911, '西苑街道', 210911001),
(210911002, 210911, '北苑街道', 210911002),
(210911003, 210911, '东苑街道', 210911003),
(210911004, 210911, '学院街道', 210911004),
(210911005, 210911, '中苑街道', 210911005),
(210911006, 210911, '华东街道', 210911006),
(210911102, 210911, '四合镇', 210911102),
(210921100, 210921, '阜新镇', 210921100),
(210921102, 210921, '东梁镇', 210921102),
(210921103, 210921, '佛寺镇', 210921103),
(210921104, 210921, '伊吗图镇', 210921104),
(210921105, 210921, '旧庙镇', 210921105),
(210921106, 210921, '务欢池镇', 210921106),
(210921107, 210921, '建设镇', 210921107),
(210921108, 210921, '大巴镇', 210921108),
(210921109, 210921, '泡子镇', 210921109),
(210921110, 210921, '十家子镇', 210921110),
(210921111, 210921, '王府镇', 210921111),
(210921112, 210921, '于寺镇', 210921112),
(210921113, 210921, '富荣镇', 210921113),
(210921114, 210921, '新民镇', 210921114),
(210921115, 210921, '福兴地镇', 210921115),
(210921116, 210921, '平安地镇', 210921116),
(210921117, 210921, '沙拉镇', 210921117),
(210921118, 210921, '大固本镇', 210921118),
(210921119, 210921, '大五家子镇', 210921119),
(210921120, 210921, '大板镇', 210921120),
(210921201, 210921, '蜘蛛山乡', 210921201),
(210921203, 210921, '卧凤沟乡', 210921203),
(210921204, 210921, '八家子乡', 210921204),
(210921205, 210921, '哈达户稍乡', 210921205),
(210921207, 210921, '塔营子乡', 210921207),
(210921208, 210921, '扎兰营子乡', 210921208),
(210921210, 210921, '招束沟乡', 210921210),
(210921211, 210921, '苍土乡', 210921211),
(210921214, 210921, '老河土乡', 210921214),
(210921215, 210921, '七家子乡', 210921215),
(210921217, 210921, '红帽子乡', 210921217),
(210921218, 210921, '紫都台乡', 210921218),
(210921219, 210921, '化石戈乡', 210921219),
(210921220, 210921, '太平乡', 210921220),
(210921222, 210921, '国华乡', 210921222),
(210921401, 210921, '泡子', 210921401),
(210922100, 210922, '彰武镇', 210922100),
(210922101, 210922, '哈尔套镇', 210922101),
(210922102, 210922, '章古台镇', 210922102),
(210922103, 210922, '五峰镇', 210922103),
(210922104, 210922, '冯家镇', 210922104),
(210922105, 210922, '后新秋镇', 210922105),
(210922106, 210922, '东六家子镇', 210922106),
(210922107, 210922, '阿尔乡镇', 210922107),
(210922201, 210922, '苇子沟蒙古族乡', 210922201),
(210922202, 210922, '二道河子蒙古族乡', 210922202),
(210922203, 210922, '西六家子蒙古族满族乡', 210922203),
(210922204, 210922, '两家子乡', 210922204),
(210922205, 210922, '双庙乡', 210922205),
(210922206, 210922, '平安乡', 210922206),
(210922207, 210922, '满堂红乡', 210922207),
(210922208, 210922, '四堡子乡', 210922208),
(210922209, 210922, '丰田乡', 210922209),
(210922210, 210922, '大德乡', 210922210),
(210922211, 210922, '大冷蒙古族乡', 210922211),
(210922212, 210922, '前福兴地乡', 210922212),
(210922213, 210922, '兴隆堡乡', 210922213),
(210922214, 210922, '兴隆山乡', 210922214),
(210922215, 210922, '大四家子乡', 210922215),
(210922216, 210922, '四合城乡', 210922216),
(211002001, 211002, '星火街道', 211002001),
(211002002, 211002, '胜利街道', 211002002),
(211002003, 211002, '跃进街道', 211002003),
(211002005, 211002, '卫国路街道', 211002005),
(211002006, 211002, '站前街道', 211002006),
(211002009, 211002, '铁西街道', 211002009),
(211003001, 211003, '武圣街道', 211003001),
(211003002, 211003, '文圣街道', 211003002),
(211003003, 211003, '襄平街道', 211003003),
(211003004, 211003, '庆阳街道', 211003004),
(211003005, 211003, '南门街道', 211003005),
(211003007, 211003, '东兴街道', 211003007),
(211004001, 211004, '工农街道', 211004001),
(211004002, 211004, '光华街道', 211004002),
(211004003, 211004, '新村街道', 211004003),
(211004004, 211004, '长征街道', 211004004),
(211004101, 211004, '曙光镇', 211004101),
(211005001, 211005, '苏家街道', 211005001),
(211005002, 211005, '团山街道', 211005002),
(211005003, 211005, '安平街道', 211005003),
(211005101, 211005, '汤河镇', 211005101),
(211005201, 211005, '安平乡', 211005201),
(211011001, 211011, '新华街道', 211011001),
(211011002, 211011, '望水台街道', 211011002),
(211011101, 211011, '祁家镇', 211011101),
(211011202, 211011, '东京陵乡', 211011202),
(211011204, 211011, '东宁卫乡', 211011204),
(211021100, 211021, '首山镇', 211021100),
(211021101, 211021, '刘二堡镇', 211021101),
(211021102, 211021, '小屯镇', 211021102),
(211021103, 211021, '小北河镇', 211021103),
(211021104, 211021, '黄泥洼镇', 211021104),
(211021105, 211021, '沙岭镇', 211021105),
(211021106, 211021, '唐马寨镇', 211021106),
(211021107, 211021, '穆家镇', 211021107),
(211021108, 211021, '柳壕镇', 211021108),
(211021109, 211021, '兰家镇', 211021109),
(211021110, 211021, '河栏镇', 211021110),
(211021111, 211021, '隆昌镇', 211021111),
(211021112, 211021, '八会镇', 211021112),
(211021113, 211021, '寒岭镇', 211021113),
(211021201, 211021, '下达河乡', 211021201),
(211021202, 211021, '吉洞峪满族乡', 211021202),
(211021206, 211021, '甜水满族乡', 211021206),
(211081001, 211081, '烟台街道', 211081001),
(211081002, 211081, '万宝桥街道', 211081002),
(211081003, 211081, '古城子街道', 211081003),
(211081101, 211081, '佟二堡镇', 211081101),
(211081102, 211081, '铧子镇', 211081102),
(211081103, 211081, '张台子镇', 211081103),
(211081104, 211081, '西大窑镇', 211081104),
(211081105, 211081, '沈旦堡镇', 211081105),
(211081106, 211081, '西马峰镇', 211081106),
(211081107, 211081, '柳条寨镇', 211081107),
(211081108, 211081, '柳河子镇', 211081108),
(211081109, 211081, '罗大台镇', 211081109),
(211081110, 211081, '王家镇', 211081110),
(211081111, 211081, '大河南镇', 211081111),
(211081114, 211081, '五星镇', 211081114),
(211081205, 211081, '鸡冠山乡', 211081205),
(211102001, 211102, '东风街道', 211102001),
(211102002, 211102, '胜利街道', 211102002),
(211102003, 211102, '建设街道', 211102003),
(211102004, 211102, '红旗街道', 211102004),
(211102005, 211102, '辽河街道', 211102005),
(211102006, 211102, '石油街道', 211102006),
(211102007, 211102, '化工街道', 211102007),
(211102008, 211102, '铁东街道', 211102008),
(211102009, 211102, '双盛街道', 211102009),
(211103001, 211103, '振兴街道', 211103001),
(211103002, 211103, '兴隆街道', 211103002),
(211103003, 211103, '渤海街道', 211103003),
(211103004, 211103, '新工街道', 211103004),
(211103005, 211103, '于楼街道', 211103005),
(211103006, 211103, '友谊街道', 211103006),
(211103007, 211103, '曙光街道', 211103007),
(211103008, 211103, '欢喜街道', 211103008),
(211103009, 211103, '平安街道', 211103009),
(211103010, 211103, '新生街道', 211103010),
(211103011, 211103, '红村街道', 211103011),
(211103012, 211103, '高升街道', 211103012),
(211103013, 211103, '沈采街道', 211103013),
(211103014, 211103, '锦采街道', 211103014),
(211103015, 211103, '茨采街道', 211103015),
(211103016, 211103, '创新街道', 211103016),
(211103017, 211103, '兴盛街道', 211103017),
(211103018, 211103, '兴海街道', 211103018),
(211121100, 211121, '大洼镇', 211121100),
(211121101, 211121, '田庄台镇', 211121101),
(211121102, 211121, '二界沟镇', 211121102),
(211121103, 211121, '东风镇', 211121103),
(211121104, 211121, '新开镇', 211121104),
(211121105, 211121, '田家镇', 211121105),
(211121106, 211121, '清水镇', 211121106),
(211121107, 211121, '新兴镇', 211121107),
(211121108, 211121, '西安镇', 211121108),
(211121109, 211121, '新立镇', 211121109),
(211121201, 211121, '王家乡', 211121201),
(211121202, 211121, '唐家乡', 211121202),
(211121205, 211121, '荣兴乡', 211121205),
(211121207, 211121, '平安乡', 211121207),
(211121210, 211121, '赵圈河乡', 211121210),
(211121400, 211121, '辽滨开发区', 211121400),
(211122101, 211122, '沙岭镇', 211122101),
(211122102, 211122, '高升镇', 211122102),
(211122103, 211122, '胡家镇', 211122103),
(211122104, 211122, '石新镇', 211122104),
(211122105, 211122, '东郭镇', 211122105),
(211122106, 211122, '羊圈子镇', 211122106),
(211122107, 211122, '古城子镇', 211122107),
(211122108, 211122, '坝墙子镇', 211122108),
(211122109, 211122, '太平镇', 211122109),
(211122203, 211122, '陈家乡', 211122203),
(211122205, 211122, '吴家乡', 211122205),
(211122206, 211122, '陆家乡', 211122206),
(211122207, 211122, '甜水乡', 211122207),
(211122208, 211122, '大荒乡', 211122208),
(211122400, 211122, '盘山县林场', 211122400),
(211202001, 211202, '红旗街道', 211202001),
(211202002, 211202, '工人街道', 211202002),
(211202003, 211202, '铁西街道', 211202003),
(211202004, 211202, '铜钟街道', 211202004),
(211202005, 211202, '柴河街道', 211202005),
(211202006, 211202, '岭东街道', 211202006),
(211202201, 211202, '龙山乡', 211202201),
(211202401, 211202, '铁岭经济开发区', 211202401),
(211204001, 211204, '红旗街道', 211204001),
(211204002, 211204, '向阳街道', 211204002),
(211204101, 211204, '张相镇', 211204101),
(211204202, 211204, '杨木林子乡', 211204202),
(211204203, 211204, '聂家满族乡', 211204203),
(211221101, 211221, '新台子镇', 211221101),
(211221102, 211221, '阿吉镇', 211221102),
(211221103, 211221, '平顶堡镇', 211221103),
(211221104, 211221, '大甸子镇', 211221104),
(211221105, 211221, '凡河镇', 211221105),
(211221106, 211221, '腰堡镇', 211221106),
(211221107, 211221, '镇西堡镇', 211221107),
(211221201, 211221, '蔡牛乡', 211221201),
(211221203, 211221, '双井子乡', 211221203),
(211221204, 211221, '熊官屯乡', 211221204),
(211221205, 211221, '李千户乡', 211221205),
(211221206, 211221, '横道河子乡', 211221206),
(211221208, 211221, '鸡冠山乡', 211221208),
(211221209, 211221, '白旗寨满族乡', 211221209),
(211221401, 211221, '种畜场', 211221401),
(211223100, 211223, '西丰镇', 211223100),
(211223101, 211223, '平岗镇', 211223101),
(211223102, 211223, '郜家店镇', 211223102),
(211223103, 211223, '凉泉镇', 211223103),
(211223104, 211223, '振兴镇', 211223104),
(211223105, 211223, '安民镇', 211223105),
(211223106, 211223, '天德镇', 211223106),
(211223107, 211223, '房木镇', 211223107),
(211223201, 211223, '陶然乡', 211223201),
(211223203, 211223, '柏榆乡', 211223203),
(211223204, 211223, '德兴乡', 211223204),
(211223205, 211223, '钓鱼乡', 211223205),
(211223206, 211223, '明德乡', 211223206),
(211223209, 211223, '成平满族乡', 211223209),
(211223211, 211223, '和隆满族乡', 211223211),
(211223212, 211223, '营厂乡', 211223212),
(211223213, 211223, '金星乡', 211223213),
(211223214, 211223, '更刻乡', 211223214),
(211224100, 211224, '昌图镇', 211224100),
(211224101, 211224, '老城镇', 211224101),
(211224102, 211224, '八面城镇', 211224102),
(211224103, 211224, '三江口镇', 211224103),
(211224104, 211224, '金家镇', 211224104),
(211224105, 211224, '宝力镇', 211224105),
(211224106, 211224, '泉头满族镇', 211224106),
(211224107, 211224, '双庙子镇', 211224107),
(211224108, 211224, '亮中桥镇', 211224108),
(211224109, 211224, '马仲河镇', 211224109),
(211224110, 211224, '毛家店镇', 211224110),
(211224111, 211224, '老四平镇', 211224111),
(211224112, 211224, '大洼镇', 211224112),
(211224113, 211224, '头道镇', 211224113),
(211224114, 211224, '此路树镇', 211224114),
(211224115, 211224, '付家镇', 211224115),
(211224117, 211224, '四合镇', 211224117),
(211224118, 211224, '朝阳镇', 211224118),
(211224119, 211224, '古榆树镇', 211224119),
(211224120, 211224, '七家子镇', 211224120),
(211224121, 211224, '东嘎镇', 211224121),
(211224122, 211224, '四面城镇', 211224122),
(211224123, 211224, '前双井子镇', 211224123),
(211224204, 211224, '大兴乡', 211224204),
(211224205, 211224, '十八家子乡', 211224205),
(211224207, 211224, '通江口乡', 211224207),
(211224208, 211224, '大四家子乡', 211224208),
(211224209, 211224, '后窑乡', 211224209),
(211224211, 211224, '长发乡', 211224211),
(211224212, 211224, '太平乡', 211224212),
(211224213, 211224, '下二台乡', 211224213),
(211224216, 211224, '平安堡乡', 211224216),
(211224217, 211224, '曲家店乡', 211224217),
(211224401, 211224, '三江口农场', 211224401),
(211224402, 211224, '宝力农场', 211224402),
(211224403, 211224, '新乡农场', 211224403),
(211224404, 211224, '付家林场', 211224404),
(211224405, 211224, '忙牛马场', 211224405),
(211224406, 211224, '两家子农场', 211224406),
(211281001, 211281, '兀术街道', 211281001),
(211281002, 211281, '调兵山街道', 211281002),
(211281102, 211281, '晓明镇', 211281102),
(211281103, 211281, '大明镇', 211281103),
(211281105, 211281, '晓南镇', 211281105),
(211282001, 211282, '新城街道', 211282001),
(211282002, 211282, '老城街道', 211282002),
(211282003, 211282, '兴开街道', 211282003),
(211282102, 211282, '威远堡镇', 211282102),
(211282103, 211282, '庆云堡镇', 211282103),
(211282104, 211282, '中固镇', 211282104),
(211282105, 211282, '八棵树镇', 211282105),
(211282106, 211282, '金沟子镇', 211282106),
(211282107, 211282, '八宝镇', 211282107),
(211282108, 211282, '业民镇', 211282108),
(211282109, 211282, '莲花镇', 211282109),
(211282110, 211282, '靠山镇', 211282110),
(211282201, 211282, '城东乡', 211282201),
(211282206, 211282, '三家子乡', 211282206),
(211282207, 211282, '马家寨乡', 211282207),
(211282210, 211282, '上肥地乡', 211282210),
(211282211, 211282, '下肥地乡', 211282211),
(211282212, 211282, '黄旗寨乡', 211282212),
(211282213, 211282, '松山堡乡', 211282213),
(211282216, 211282, '李家台乡', 211282216),
(211282217, 211282, '林丰乡', 211282217),
(211302001, 211302, '南塔街道', 211302001),
(211302002, 211302, '北塔街道', 211302002),
(211302003, 211302, '前进街道', 211302003),
(211302004, 211302, '凌河街道', 211302004),
(211302005, 211302, '光明街道', 211302005),
(211302006, 211302, '凌凤街道', 211302006),
(211302007, 211302, '龙山街道', 211302007),
(211302008, 211302, '站南街道', 211302008),
(211302009, 211302, '红旗街道', 211302009),
(211302010, 211302, '燕北街道', 211302010),
(211302100, 211302, '桃花吐镇', 211302100),
(211302101, 211302, '他拉皋镇', 211302101),
(211302205, 211302, '长宝营子乡', 211302205),
(211302206, 211302, '孙家湾乡', 211302206),
(211303001, 211303, '向阳街道', 211303001),
(211303002, 211303, '半拉山街道', 211303002),
(211303003, 211303, '马山街道', 211303003),
(211303004, 211303, '新华街道', 211303004),
(211303005, 211303, '海龙街道', 211303005),
(211303070, 211303, '开发区龙泉街道', 211303070),
(211303101, 211303, '七道泉子镇', 211303101),
(211303102, 211303, '西大营子镇', 211303102),
(211303103, 211303, '召都巴镇', 211303103),
(211303105, 211303, '大平房镇', 211303105),
(211303201, 211303, '边杖子乡', 211303201),
(211303203, 211303, '联合乡', 211303203),
(211321102, 211321, '波罗赤镇', 211321102),
(211321103, 211321, '木头城子镇', 211321103),
(211321104, 211321, '二十家子镇', 211321104),
(211321105, 211321, '羊山镇', 211321105),
(211321106, 211321, '六家子镇', 211321106),
(211321107, 211321, '瓦房子镇', 211321107),
(211321108, 211321, '大庙镇', 211321108),
(211321109, 211321, '柳城镇', 211321109),
(211321204, 211321, '南双庙乡', 211321204),
(211321206, 211321, '古山子乡', 211321206),
(211321211, 211321, '西五家子乡', 211321211),
(211321212, 211321, '北沟门子乡', 211321212),
(211321213, 211321, '杨树湾乡', 211321213),
(211321214, 211321, '东大道乡', 211321214),
(211321215, 211321, '乌兰河硕蒙古族乡', 211321215),
(211321216, 211321, '台子乡', 211321216),
(211321218, 211321, '胜利乡', 211321218),
(211321220, 211321, '东大屯乡', 211321220),
(211321221, 211321, '松岭门乡', 211321221),
(211321222, 211321, '根德营子乡', 211321222),
(211321224, 211321, '西营子乡', 211321224),
(211321225, 211321, '七道岭乡', 211321225),
(211321228, 211321, '北四家子乡', 211321228),
(211321230, 211321, '王营子乡', 211321230),
(211321231, 211321, '黑牛营子乡', 211321231),
(211321232, 211321, '尚志乡', 211321232),
(211321233, 211321, '长在营子乡', 211321233),
(211321400, 211321, '国营贾家店农场', 211321400),
(211322001, 211322, '叶柏寿街道', 211322001),
(211322002, 211322, '红山街道', 211322002),
(211322003, 211322, '铁南街道', 211322003),
(211322004, 211322, '万寿街道', 211322004),
(211322005, 211322, '富山街道', 211322005),
(211322101, 211322, '朱碌科镇', 211322101),
(211322102, 211322, '建平镇', 211322102),
(211322103, 211322, '黑水镇', 211322103),
(211322104, 211322, '喀喇沁镇', 211322104),
(211322105, 211322, '北二十家子镇', 211322105),
(211322106, 211322, '沙海镇', 211322106),
(211322108, 211322, '哈拉道口镇', 211322108),
(211322109, 211322, '榆树林子镇', 211322109),
(211322110, 211322, '老官地镇', 211322110),
(211322111, 211322, '深井镇', 211322111),
(211322112, 211322, '奎德素镇', 211322112),
(211322113, 211322, '小塘镇', 211322113),
(211322114, 211322, '马场镇', 211322114),
(211322115, 211322, '昌隆镇', 211322115),
(211322117, 211322, '张家营子镇', 211322117),
(211322205, 211322, '青松岭乡', 211322205),
(211322206, 211322, '杨树岭乡', 211322206),
(211322209, 211322, '罗福沟乡', 211322209),
(211322211, 211322, '烧锅营子乡', 211322211),
(211322213, 211322, '太平庄乡', 211322213),
(211322214, 211322, '白山乡', 211322214),
(211322218, 211322, '三家蒙古族乡', 211322218),
(211322220, 211322, '义成功乡', 211322220),
(211322221, 211322, '青峰山乡', 211322221),
(211322400, 211322, '八家国营农场', 211322400),
(211322401, 211322, '热水国营畜牧农场', 211322401),
(211324100, 211324, '大城子镇', 211324100),
(211324101, 211324, '南公营子镇', 211324101),
(211324102, 211324, '山嘴子镇', 211324102),
(211324103, 211324, '南哨镇', 211324103),
(211324104, 211324, '公营子镇', 211324104),
(211324105, 211324, '白塔子镇', 211324105),
(211324106, 211324, '中三家镇', 211324106),
(211324107, 211324, '老爷庙镇', 211324107),
(211324108, 211324, '六官营子镇', 211324108),
(211324109, 211324, '平房子镇', 211324109),
(211324203, 211324, '十二德堡乡', 211324203),
(211324204, 211324, '尤杖子乡', 211324204),
(211324205, 211324, '东哨乡', 211324205),
(211324206, 211324, '羊角沟乡', 211324206),
(211324207, 211324, '草场乡', 211324207),
(211324210, 211324, '坤都营子乡', 211324210),
(211324211, 211324, '大营子乡', 211324211),
(211324212, 211324, '兴隆庄乡', 211324212),
(211324213, 211324, '甘招乡', 211324213),
(211324214, 211324, '卧虎沟乡', 211324214),
(211324215, 211324, '水泉乡', 211324215),
(211324400, 211324, '国营官大海农场', 211324400),
(211381001, 211381, '城关街道', 211381001),
(211381002, 211381, '南山街道', 211381002),
(211381003, 211381, '冠山街道', 211381003),
(211381004, 211381, '桥北街道', 211381004),
(211381005, 211381, '三宝街道', 211381005),
(211381006, 211381, '台吉街道', 211381006),
(211381008, 211381, '双河街道', 211381008),
(211381101, 211381, '西官营镇', 211381101),
(211381102, 211381, '大板镇', 211381102),
(211381103, 211381, '上园镇', 211381103),
(211381104, 211381, '宝国老镇', 211381104),
(211381105, 211381, '黑城子镇', 211381105),
(211381107, 211381, '五间房镇', 211381107),
(211381108, 211381, '台吉镇', 211381108),
(211381201, 211381, '长皋乡', 211381201),
(211381202, 211381, '常河营乡', 211381202),
(211381203, 211381, '小塔子乡', 211381203),
(211381204, 211381, '马友营蒙古族乡', 211381204),
(211381205, 211381, '蒙古营乡', 211381205),
(211381206, 211381, '泉巨永乡', 211381206),
(211381207, 211381, '大三家乡', 211381207),
(211381208, 211381, '东官营乡', 211381208),
(211381210, 211381, '龙潭乡', 211381210),
(211381212, 211381, '哈尔脑乡', 211381212),
(211381213, 211381, '南八家子乡', 211381213),
(211381214, 211381, '章吉营乡', 211381214),
(211381215, 211381, '三宝营乡', 211381215),
(211381216, 211381, '巴图营乡', 211381216),
(211381218, 211381, '台吉营乡', 211381218),
(211381219, 211381, '北塔子乡', 211381219),
(211381220, 211381, '娄家店乡', 211381220),
(211381221, 211381, '北四家乡', 211381221),
(211381223, 211381, '凉水河蒙古族乡', 211381223),
(211381228, 211381, '三宝乡', 211381228),
(211381270, 211381, '下府经济开发区', 211381270),
(211381271, 211381, '大黑山特别行政管理区', 211381271),
(211381400, 211381, '兴顺德国营农场', 211381400),
(211382001, 211382, '东城街道', 211382001),
(211382002, 211382, '北街街道', 211382002),
(211382003, 211382, '南街街道', 211382003),
(211382004, 211382, '红山街道', 211382004),
(211382006, 211382, '热水汤街道', 211382006),
(211382007, 211382, '工业园区街道', 211382007),
(211382101, 211382, '万元店镇', 211382101),
(211382102, 211382, '宋杖子镇', 211382102),
(211382103, 211382, '三十家子镇', 211382103),
(211382104, 211382, '杨杖子镇', 211382104),
(211382105, 211382, '刀尔登镇', 211382105),
(211382106, 211382, '松岭子镇', 211382106),
(211382107, 211382, '四官营子镇', 211382107),
(211382108, 211382, '沟门子镇', 211382108),
(211382109, 211382, '凌北镇', 211382109),
(211382110, 211382, '小城子镇', 211382110),
(211382111, 211382, '四合当镇', 211382111),
(211382112, 211382, '城关镇', 211382112),
(211382113, 211382, '乌兰白镇', 211382113),
(211382204, 211382, '大王杖子乡', 211382204),
(211382205, 211382, '刘杖子乡', 211382205),
(211382206, 211382, '前进乡', 211382206),
(211382207, 211382, '大河北乡', 211382207),
(211382208, 211382, '三道河子乡', 211382208),
(211382209, 211382, '牛营子乡', 211382209),
(211382210, 211382, '北炉乡', 211382210),
(211382211, 211382, '瓦房店乡', 211382211),
(211382217, 211382, '三家子乡', 211382217),
(211382219, 211382, '佛爷洞乡', 211382219),
(211382220, 211382, '河坎子乡', 211382220),
(211402001, 211402, '连山街道', 211402001),
(211402002, 211402, '站前街道', 211402002),
(211402003, 211402, '渤海街道', 211402003),
(211402004, 211402, '兴工街道', 211402004),
(211402005, 211402, '石油街道', 211402005),
(211402006, 211402, '化工街道', 211402006),
(211402007, 211402, '化机街道', 211402007),
(211402008, 211402, '水泥街道', 211402008),
(211402010, 211402, '杨家杖子街道', 211402010),
(211402011, 211402, '锦郊街道', 211402011),
(211402102, 211402, '虹螺岘镇', 211402102),
(211402103, 211402, '高桥镇', 211402103),
(211402104, 211402, '钢屯镇', 211402104),
(211402105, 211402, '寺儿堡镇', 211402105),
(211402106, 211402, '新台门蒙古族镇', 211402106),
(211402107, 211402, '金星镇', 211402107),
(211402108, 211402, '台集屯镇', 211402108),
(211402201, 211402, '沙河营乡', 211402201),
(211402202, 211402, '孤竹营子乡', 211402202),
(211402203, 211402, '白马石乡', 211402203),
(211402205, 211402, '山神庙子乡', 211402205),
(211402206, 211402, '塔山乡', 211402206),
(211402209, 211402, '张相公屯乡', 211402209),
(211402210, 211402, '杨郊乡', 211402210),
(211402212, 211402, '大兴乡', 211402212),
(211403001, 211403, '葫芦岛街道', 211403001),
(211403002, 211403, '东街道', 211403002),
(211403003, 211403, '西街道', 211403003),
(211403004, 211403, '望海寺街道', 211403004),
(211403005, 211403, '龙湾街道', 211403005),
(211403006, 211403, '滨海街道', 211403006),
(211403007, 211403, '双龙街道', 211403007),
(211403008, 211403, '玉皇街道', 211403008),
(211403009, 211403, '连湾街道', 211403009),
(211403010, 211403, '北港街道', 211403010),
(211403103, 211403, '双树镇', 211403103),
(211403400, 211403, '葫芦岛经济开发区', 211403400),
(211403401, 211403, '葫芦岛市专利技术园区', 211403401),
(211404001, 211404, '赵家屯街道', 211404001),
(211404002, 211404, '沙锅屯街道', 211404002),
(211404003, 211404, '邱皮沟街道', 211404003),
(211404005, 211404, '苇子沟街道', 211404005),
(211404006, 211404, '三家子街道', 211404006),
(211404007, 211404, '小凌河街道', 211404007),
(211404008, 211404, '九龙街道', 211404008),
(211404101, 211404, '缸窑岭镇', 211404101),
(211404102, 211404, '暖池塘镇', 211404102),
(211404201, 211404, '沙锅屯乡', 211404201),
(211404203, 211404, '黄土坎乡', 211404203),
(211404400, 211404, '乌金塘水库', 211404400),
(211421100, 211421, '绥中镇', 211421100),
(211421101, 211421, '西甸子镇', 211421101),
(211421102, 211421, '宽帮满族镇', 211421102),
(211421103, 211421, '大王庙满族镇', 211421103),
(211421104, 211421, '万家镇', 211421104),
(211421105, 211421, '前所镇', 211421105),
(211421106, 211421, '高岭镇', 211421106),
(211421107, 211421, '前卫镇', 211421107),
(211421108, 211421, '荒地满族镇', 211421108),
(211421109, 211421, '塔山屯镇', 211421109),
(211421113, 211421, '高台镇', 211421113),
(211421114, 211421, '王宝镇', 211421114),
(211421115, 211421, '沙河镇', 211421115),
(211421116, 211421, '小庄子镇', 211421116),
(211421201, 211421, '西平坡满族乡', 211421201),
(211421202, 211421, '葛家满族乡', 211421202),
(211421204, 211421, '高甸子满族乡', 211421204),
(211421206, 211421, '范家满族乡', 211421206),
(211421207, 211421, '明水满族乡', 211421207),
(211421208, 211421, '秋子沟乡', 211421208),
(211421210, 211421, '加碑岩乡', 211421210),
(211421211, 211421, '永安堡乡', 211421211),
(211421212, 211421, '李家堡乡', 211421212),
(211421214, 211421, '网户满族乡', 211421214),
(211421217, 211421, '城郊乡', 211421217),
(211421400, 211421, '大台山果树农场', 211421400),
(211421401, 211421, '前所果树农场', 211421401),
(211422100, 211422, '建昌镇', 211422100),
(211422101, 211422, '八家子镇', 211422101),
(211422102, 211422, '喇嘛洞镇', 211422102),
(211422103, 211422, '药王庙镇', 211422103),
(211422104, 211422, '汤神庙镇', 211422104),
(211422105, 211422, '玲珑塔镇', 211422105),
(211422106, 211422, '大屯镇', 211422106),
(211422201, 211422, '牛亡牛营子乡', 211422201),
(211422203, 211422, '素珠营子乡', 211422203),
(211422204, 211422, '石佛乡', 211422204),
(211422206, 211422, '王宝营子乡', 211422206),
(211422207, 211422, '老达杖子乡', 211422207),
(211422208, 211422, '要路沟乡', 211422208),
(211422209, 211422, '魏家岭乡', 211422209),
(211422210, 211422, '西碱厂乡', 211422210),
(211422211, 211422, '头道营子乡', 211422211),
(211422212, 211422, '新开岭乡', 211422212),
(211422213, 211422, '贺杖子乡', 211422213),
(211422214, 211422, '养马甸子乡', 211422214),
(211422215, 211422, '和尚房子乡', 211422215),
(211422218, 211422, '杨树湾子乡', 211422218),
(211422219, 211422, '黑山科乡', 211422219),
(211422220, 211422, '雷家店乡', 211422220),
(211422222, 211422, '小德营子乡', 211422222);
INSERT INTO `{pre}areas` VALUES
(211422223, 211422, '二道湾子蒙古族乡', 211422223),
(211422224, 211422, '巴什罕乡', 211422224),
(211422225, 211422, '娘娘庙乡', 211422225),
(211422226, 211422, '谷杖子乡', 211422226),
(211481001, 211481, '古城街道', 211481001),
(211481002, 211481, '宁远街道', 211481002),
(211481003, 211481, '城东街道', 211481003),
(211481004, 211481, '温泉街道', 211481004),
(211481005, 211481, '钓鱼台街道', 211481005),
(211481006, 211481, '华山街道', 211481006),
(211481007, 211481, '四家屯街道', 211481007),
(211481101, 211481, '曹庄镇', 211481101),
(211481103, 211481, '沙后所满族镇', 211481103),
(211481104, 211481, '东辛庄满族镇', 211481104),
(211481105, 211481, '郭家满族镇', 211481105),
(211481201, 211481, '羊安满族乡', 211481201),
(211481203, 211481, '元台子满族乡', 211481203),
(211481204, 211481, '白塔满族乡', 211481204),
(211481206, 211481, '望海满族乡', 211481206),
(211481207, 211481, '刘台子满族乡', 211481207),
(211481208, 211481, '大寨满族乡', 211481208),
(211481209, 211481, '南大山满族乡', 211481209),
(211481210, 211481, '围屏满族乡', 211481210),
(211481211, 211481, '高家岭满族乡', 211481211),
(211481212, 211481, '碱厂满族乡', 211481212),
(211481213, 211481, '三道沟满族乡', 211481213),
(211481214, 211481, '红崖子满族乡', 211481214),
(211481215, 211481, '旧门满族乡', 211481215),
(211481216, 211481, '药王满族乡', 211481216),
(211481218, 211481, '海滨满族乡', 211481218),
(211481219, 211481, '菊花岛乡', 211481219),
(220102001, 220102, '南岭街道', 220102001),
(220102002, 220102, '自强街道', 220102002),
(220102003, 220102, '民康街道', 220102003),
(220102004, 220102, '新春街道', 220102004),
(220102005, 220102, '长通街道', 220102005),
(220102006, 220102, '全安街道', 220102006),
(220102007, 220102, '曙光街道', 220102007),
(220102008, 220102, '永吉街道', 220102008),
(220102009, 220102, '桃源街道', 220102009),
(220102010, 220102, '鸿城街道', 220102010),
(220102070, 220102, '临河街道办事处（长春经济技术开发区）（国家级）', 220102070),
(220102071, 220102, '永兴街道办事处（净月潭旅游经济开发区）（省级）', 220102071),
(220102072, 220102, '净月街道办事处（净月潭旅游经济开发区）（省级）', 220102072),
(220102170, 220102, '新立城镇（净月潭旅游经济开发区）（省级）', 220102170),
(220102171, 220102, '新湖镇（净月潭旅游经济开发区）（省级）', 220102171),
(220102172, 220102, '玉潭镇（净月潭旅游经济开发区）（省级）', 220102172),
(220102200, 220102, '幸福乡', 220102200),
(220103001, 220103, '新发街道', 220103001),
(220103002, 220103, '站前街道', 220103002),
(220103003, 220103, '南广街道', 220103003),
(220103004, 220103, '东广街道', 220103004),
(220103005, 220103, '群英街道', 220103005),
(220103006, 220103, '兴业街道', 220103006),
(220103007, 220103, '凯旋街道', 220103007),
(220103008, 220103, '团山街道', 220103008),
(220103009, 220103, '柳影街道', 220103009),
(220103100, 220103, '兰家镇', 220103100),
(220103101, 220103, '米沙子镇', 220103101),
(220103102, 220103, '万宝镇', 220103102),
(220103170, 220103, '兴隆山镇（长春经济技术开发区）（国家级）', 220103170),
(220103171, 220103, '合隆镇（合隆经济开发区）（省级）', 220103171),
(220103200, 220103, '奋进乡', 220103200),
(220103400, 220103, '兴业农场', 220103400),
(220104001, 220104, '南站街道', 220104001),
(220104002, 220104, '桂林街道', 220104002),
(220104003, 220104, '南湖街道', 220104003),
(220104004, 220104, '永昌街道', 220104004),
(220104005, 220104, '重庆街道', 220104005),
(220104006, 220104, '清和街道', 220104006),
(220104007, 220104, '红旗街道', 220104007),
(220104008, 220104, '湖西街道', 220104008),
(220104009, 220104, '富锋街道', 220104009),
(220104100, 220104, '乐山镇', 220104100),
(220104101, 220104, '永春镇', 220104101),
(220104270, 220104, '双德乡（长春高新技术产业开发区）（国家级）', 220104270),
(220105001, 220105, '东盛街道', 220105001),
(220105002, 220105, '吉林街道', 220105002),
(220105003, 220105, '荣光街道', 220105003),
(220105004, 220105, '东站街道', 220105004),
(220105005, 220105, '远达街道', 220105005),
(220105006, 220105, '八里堡街道', 220105006),
(220105070, 220105, '东方广场街道办事处（长春经济技术开发区）（国家级）', 220105070),
(220105100, 220105, '英俊镇', 220105100),
(220105101, 220105, '劝农山镇', 220105101),
(220105102, 220105, '泉眼镇', 220105102),
(220105170, 220105, '龙嘉镇（东湖生态经济开发区）（省级）', 220105170),
(220105171, 220105, '卡伦湖镇（东湖生态经济开发区）（省级）', 220105171),
(220105172, 220105, '东湖镇（东湖生态经济开发区）（省级）', 220105172),
(220105200, 220105, '四家乡', 220105200),
(220106001, 220106, '正阳街道', 220106001),
(220106002, 220106, '普阳街道', 220106002),
(220106003, 220106, '春城街道', 220106003),
(220106004, 220106, '铁西街道', 220106004),
(220106005, 220106, '青年街道', 220106005),
(220106070, 220106, '锦程街道办事处（长春汽车产业开发区）（省级）', 220106070),
(220106071, 220106, '东风街道办事处（长春汽车产业开发区）（省级）', 220106071),
(220106100, 220106, '合心镇', 220106100),
(220106101, 220106, '西新镇', 220106101),
(220106102, 220106, '城西镇', 220106102),
(220106170, 220106, '长春汽车产业开发区（省级）', 220106170),
(220106171, 220106, '绿园经济开发区（省级）', 220106171),
(220112001, 220112, '云山街道', 220112001),
(220112002, 220112, '平湖街道', 220112002),
(220112003, 220112, '奢岭街道', 220112003),
(220112004, 220112, '山河街道', 220112004),
(220112100, 220112, '齐家镇', 220112100),
(220112101, 220112, '太平镇', 220112101),
(220112102, 220112, '鹿乡镇', 220112102),
(220112270, 220112, '双营乡（梅花鹿产业经济开发区）（省级）', 220112270),
(220122100, 220122, '农安镇', 220122100),
(220122101, 220122, '伏龙泉镇', 220122101),
(220122102, 220122, '哈拉海镇', 220122102),
(220122103, 220122, '靠山镇', 220122103),
(220122104, 220122, '开安镇', 220122104),
(220122105, 220122, '烧锅镇', 220122105),
(220122106, 220122, '高家店镇', 220122106),
(220122107, 220122, '华家镇', 220122107),
(220122108, 220122, '三盛玉镇', 220122108),
(220122109, 220122, '巴吉垒镇', 220122109),
(220122200, 220122, '前岗乡', 220122200),
(220122201, 220122, '龙王乡', 220122201),
(220122202, 220122, '三岗乡', 220122202),
(220122203, 220122, '万顺乡', 220122203),
(220122204, 220122, '杨树林乡', 220122204),
(220122205, 220122, '永安乡', 220122205),
(220122206, 220122, '青山口乡', 220122206),
(220122207, 220122, '黄鱼圈乡', 220122207),
(220122208, 220122, '新农乡', 220122208),
(220122209, 220122, '万金塔乡', 220122209),
(220122210, 220122, '小城子乡', 220122210),
(220122400, 220122, '洼中高农场', 220122400),
(220181001, 220181, '九台街道', 220181001),
(220181002, 220181, '营城街道', 220181002),
(220181003, 220181, '九郊街道', 220181003),
(220181100, 220181, '沐石河镇', 220181100),
(220181101, 220181, '城子街镇', 220181101),
(220181102, 220181, '其塔木镇', 220181102),
(220181103, 220181, '上河湾镇', 220181103),
(220181104, 220181, '西营城镇', 220181104),
(220181105, 220181, '土们岭镇', 220181105),
(220181106, 220181, '苇子沟镇', 220181106),
(220181107, 220181, '兴隆镇', 220181107),
(220181108, 220181, '纪家镇', 220181108),
(220181109, 220181, '波泥河镇', 220181109),
(220181200, 220181, '胡家回族乡', 220181200),
(220181201, 220181, '莽卡满族乡', 220181201),
(220182001, 220182, '华昌街道', 220182001),
(220182002, 220182, '正阳街道', 220182002),
(220182003, 220182, '培英街道', 220182003),
(220182004, 220182, '城郊街道', 220182004),
(220182100, 220182, '五棵树镇', 220182100),
(220182101, 220182, '弓棚镇', 220182101),
(220182102, 220182, '闵家镇', 220182102),
(220182103, 220182, '大坡镇', 220182103),
(220182104, 220182, '黑林镇', 220182104),
(220182105, 220182, '土桥镇', 220182105),
(220182106, 220182, '新立镇', 220182106),
(220182107, 220182, '大岭镇', 220182107),
(220182108, 220182, '向阳镇', 220182108),
(220182109, 220182, '泗河镇', 220182109),
(220182110, 220182, '八号镇', 220182110),
(220182111, 220182, '刘家镇', 220182111),
(220182112, 220182, '秀水镇', 220182112),
(220182113, 220182, '保寿镇', 220182113),
(220182114, 220182, '新庄镇', 220182114),
(220182200, 220182, '育民乡', 220182200),
(220182201, 220182, '红星乡', 220182201),
(220182202, 220182, '太安乡', 220182202),
(220182203, 220182, '先峰乡', 220182203),
(220182204, 220182, '青山乡', 220182204),
(220182205, 220182, '延和朝鲜族乡', 220182205),
(220182206, 220182, '恩育乡', 220182206),
(220182207, 220182, '城发乡', 220182207),
(220182208, 220182, '环城乡', 220182208),
(220183001, 220183, '胜利街道', 220183001),
(220183002, 220183, '建设街道', 220183002),
(220183003, 220183, '惠发街道', 220183003),
(220183004, 220183, '夏家店街道', 220183004),
(220183100, 220183, '大青嘴镇', 220183100),
(220183101, 220183, '郭家镇', 220183101),
(220183102, 220183, '松花江镇', 220183102),
(220183103, 220183, '达家沟镇', 220183103),
(220183104, 220183, '大房身镇', 220183104),
(220183105, 220183, '岔路口镇', 220183105),
(220183106, 220183, '朱城子镇', 220183106),
(220183107, 220183, '布海镇', 220183107),
(220183108, 220183, '天台镇', 220183108),
(220183109, 220183, '菜园子镇', 220183109),
(220183200, 220183, '同太乡', 220183200),
(220183201, 220183, '边岗乡', 220183201),
(220183202, 220183, '五台乡', 220183202),
(220183203, 220183, '朝阳乡', 220183203),
(220202001, 220202, '兴华街道', 220202001),
(220202002, 220202, '文庙街道', 220202002),
(220202003, 220202, '东局子街道', 220202003),
(220202004, 220202, '新地号街道', 220202004),
(220202005, 220202, '延安街道', 220202005),
(220202006, 220202, '站前街道', 220202006),
(220202007, 220202, '民主街道', 220202007),
(220202008, 220202, '莲花街道', 220202008),
(220202009, 220202, '通江街道', 220202009),
(220202010, 220202, '哈达湾街道', 220202010),
(220202011, 220202, '新建街道', 220202011),
(220202012, 220202, '延江街道', 220202012),
(220202013, 220202, '双吉街道', 220202013),
(220202070, 220202, '九站街道办事处(吉林经济技术开发区)（省级）', 220202070),
(220202071, 220202, '吉林东市商贸示范区（省级）', 220202071),
(220202100, 220202, '孤店子镇', 220202100),
(220202101, 220202, '桦皮厂镇', 220202101),
(220202102, 220202, '左家镇', 220202102),
(220202200, 220202, '两家子满族乡', 220202200),
(220202201, 220202, '土城子满族朝鲜族乡', 220202201),
(220202400, 220202, '吉林哈达湾工业开发区', 220202400),
(220202401, 220202, '吉林市昌邑区幸福经济管理区', 220202401),
(220203001, 220203, '龙华街道', 220203001),
(220203002, 220203, '湘潭街道', 220203002),
(220203003, 220203, '铁东街道', 220203003),
(220203004, 220203, '泡子沿街道', 220203004),
(220203005, 220203, '龙潭街道', 220203005),
(220203006, 220203, '新吉林街道', 220203006),
(220203007, 220203, '山前街道', 220203007),
(220203008, 220203, '新安街道', 220203008),
(220203009, 220203, '遵义街道', 220203009),
(220203010, 220203, '榆树街道', 220203010),
(220203011, 220203, '靠山街道', 220203011),
(220203012, 220203, '东城街道', 220203012),
(220203013, 220203, '承德街道', 220203013),
(220203070, 220203, '吉林龙潭经济开发区（省级）', 220203070),
(220203100, 220203, '乌拉街镇', 220203100),
(220203101, 220203, '缸窑镇', 220203101),
(220203102, 220203, '江密峰镇', 220203102),
(220203103, 220203, '大口钦镇', 220203103),
(220203200, 220203, '江北乡', 220203200),
(220203201, 220203, '金珠乡', 220203201),
(220204001, 220204, '德胜街道', 220204001),
(220204002, 220204, '南京街道', 220204002),
(220204003, 220204, '大东街道', 220204003),
(220204004, 220204, '青岛街道', 220204004),
(220204005, 220204, '向阳街道', 220204005),
(220204006, 220204, '北极街道', 220204006),
(220204007, 220204, '致和街道', 220204007),
(220204008, 220204, '长春路街道', 220204008),
(220204009, 220204, '临江街道', 220204009),
(220204010, 220204, '北山街道', 220204010),
(220204011, 220204, '黄旗屯街道', 220204011),
(220204100, 220204, '大绥河镇', 220204100),
(220204101, 220204, '搜登站镇', 220204101),
(220204102, 220204, '越北镇', 220204102),
(220204200, 220204, '欢喜乡', 220204200),
(220211001, 220211, '泰山街道', 220211001),
(220211002, 220211, '江南街道', 220211002),
(220211003, 220211, '石井街道', 220211003),
(220211004, 220211, '沿丰街道', 220211004),
(220211005, 220211, '丰满街道', 220211005),
(220211070, 220211, '高新开发区街道办事处（吉林高新技术产业开发区）（国家级）', 220211070),
(220211071, 220211, '红旗街道办事处（丰满经济开发区）（省级）', 220211071),
(220211100, 220211, '旺起镇', 220211100),
(220211200, 220211, '江南乡', 220211200),
(220211201, 220211, '前二道乡', 220211201),
(220211270, 220211, '小白山乡（丰满经济开发区）（省级）', 220211270),
(220211400, 220211, '朱雀山风景区', 220211400),
(220221100, 220221, '口前镇', 220221100),
(220221101, 220221, '双河镇', 220221101),
(220221102, 220221, '西阳镇', 220221102),
(220221103, 220221, '北大湖镇', 220221103),
(220221104, 220221, '一拉溪镇', 220221104),
(220221170, 220221, '岔路河镇（岔路河特色农业经济开发区）（省级）', 220221170),
(220221171, 220221, '万昌镇（岔路河特色农业经济开发区）（省级）', 220221171),
(220221172, 220221, '永吉经济开发区（省级）', 220221172),
(220221200, 220221, '金家乡', 220221200),
(220221201, 220221, '黄榆乡', 220221201),
(220281001, 220281, '民主街道', 220281001),
(220281002, 220281, '长安街道', 220281002),
(220281003, 220281, '河南街道', 220281003),
(220281004, 220281, '奶子山街道', 220281004),
(220281005, 220281, '拉法街道', 220281005),
(220281006, 220281, '河北街道', 220281006),
(220281007, 220281, '新农街道', 220281007),
(220281100, 220281, '新站镇', 220281100),
(220281101, 220281, '天岗镇', 220281101),
(220281102, 220281, '白石山镇', 220281102),
(220281103, 220281, '漂河镇', 220281103),
(220281104, 220281, '黄松甸镇', 220281104),
(220281105, 220281, '天北镇', 220281105),
(220281106, 220281, '松江镇', 220281106),
(220281107, 220281, '庆岭镇', 220281107),
(220281200, 220281, '乌林朝鲜族乡', 220281200),
(220281201, 220281, '前进乡', 220281201),
(220282001, 220282, '明桦街道', 220282001),
(220282002, 220282, '永吉街道', 220282002),
(220282003, 220282, '胜利街道', 220282003),
(220282004, 220282, '新华街道', 220282004),
(220282005, 220282, '启新街道', 220282005),
(220282070, 220282, '桦甸经济开发区（省级）', 220282070),
(220282100, 220282, '夹皮沟镇', 220282100),
(220282101, 220282, '二道甸子镇', 220282101),
(220282102, 220282, '红石砬子镇', 220282102),
(220282103, 220282, '八道河子镇', 220282103),
(220282104, 220282, '常山镇', 220282104),
(220282200, 220282, '桦郊乡', 220282200),
(220282201, 220282, '横道河子乡', 220282201),
(220282202, 220282, '金沙乡', 220282202),
(220282203, 220282, '桦树林子乡', 220282203),
(220282204, 220282, '公吉乡', 220282204),
(220282205, 220282, '苏密沟乡', 220282205),
(220283001, 220283, '北城街道', 220283001),
(220283002, 220283, '南城街道', 220283002),
(220283003, 220283, '环城街道', 220283003),
(220283004, 220283, '吉舒街道', 220283004),
(220283005, 220283, '铁东街道', 220283005),
(220283100, 220283, '法特镇', 220283100),
(220283101, 220283, '白旗镇', 220283101),
(220283102, 220283, '溪河镇', 220283102),
(220283103, 220283, '朝阳镇', 220283103),
(220283104, 220283, '小城镇', 220283104),
(220283105, 220283, '上营镇', 220283105),
(220283106, 220283, '水曲柳镇', 220283106),
(220283107, 220283, '平安镇', 220283107),
(220283108, 220283, '金马镇', 220283108),
(220283109, 220283, '开原镇', 220283109),
(220283200, 220283, '莲花乡', 220283200),
(220283201, 220283, '亮甲山乡', 220283201),
(220283202, 220283, '新安乡', 220283202),
(220283203, 220283, '七里乡', 220283203),
(220283204, 220283, '天德乡', 220283204),
(220284001, 220284, '福安街道', 220284001),
(220284002, 220284, '东宁街道', 220284002),
(220284003, 220284, '河南街道', 220284003),
(220284070, 220284, '磐石经济开发区（省级）', 220284070),
(220284100, 220284, '烟筒山镇', 220284100),
(220284101, 220284, '红旗岭镇', 220284101),
(220284102, 220284, '明城镇', 220284102),
(220284103, 220284, '石嘴镇', 220284103),
(220284104, 220284, '驿马镇', 220284104),
(220284105, 220284, '牛心镇', 220284105),
(220284106, 220284, '呼兰镇', 220284106),
(220284107, 220284, '吉昌镇', 220284107),
(220284108, 220284, '松山镇', 220284108),
(220284109, 220284, '黑石镇', 220284109),
(220284110, 220284, '朝阳山镇', 220284110),
(220284111, 220284, '富太镇', 220284111),
(220284112, 220284, '取柴河镇', 220284112),
(220284200, 220284, '宝山乡', 220284200),
(220302001, 220302, '仁兴街道', 220302001),
(220302002, 220302, '英雄街道', 220302002),
(220302003, 220302, '站前街道', 220302003),
(220302004, 220302, '北沟街道', 220302004),
(220302005, 220302, '地直街道', 220302005),
(220302070, 220302, '红嘴高新技术开发区（省级）', 220302070),
(220302200, 220302, '平西乡', 220302200),
(220303001, 220303, '平东街道', 220303001),
(220303002, 220303, '北市场街道', 220303002),
(220303003, 220303, '七马路街道', 220303003),
(220303004, 220303, '四马路街道', 220303004),
(220303005, 220303, '解放街道', 220303005),
(220303006, 220303, '北门街道', 220303006),
(220303007, 220303, '黄土坑街道', 220303007),
(220303008, 220303, '平南街道', 220303008),
(220303100, 220303, '山门镇', 220303100),
(220303101, 220303, '石岭镇', 220303101),
(220303102, 220303, '叶赫满族镇', 220303102),
(220303170, 220303, '四平经济开发区（省级）', 220303170),
(220303200, 220303, '城东乡', 220303200),
(220322100, 220322, '梨树镇', 220322100),
(220322101, 220322, '郭家店镇', 220322101),
(220322102, 220322, '榆树台镇', 220322102),
(220322103, 220322, '孤家子镇（四平辽河农垦管理区）', 220322103),
(220322104, 220322, '小城子镇', 220322104),
(220322105, 220322, '喇嘛甸镇', 220322105),
(220322106, 220322, '蔡家镇', 220322106),
(220322107, 220322, '刘家馆子镇', 220322107),
(220322108, 220322, '十家堡镇', 220322108),
(220322109, 220322, '孟家岭镇', 220322109),
(220322110, 220322, '万发镇', 220322110),
(220322111, 220322, '东河镇', 220322111),
(220322112, 220322, '沈洋镇', 220322112),
(220322113, 220322, '林海镇', 220322113),
(220322114, 220322, '小宽镇', 220322114),
(220322200, 220322, '白山乡', 220322200),
(220322201, 220322, '泉眼岭乡', 220322201),
(220322202, 220322, '胜利乡', 220322202),
(220322203, 220322, '四棵树乡', 220322203),
(220322204, 220322, '双河乡', 220322204),
(220322205, 220322, '金山乡', 220322205),
(220322400, 220322, '国营梨树农场（四平辽河农垦管理区）', 220322400),
(220322401, 220322, '梨树经济开发区', 220322401),
(220323100, 220323, '伊通镇', 220323100),
(220323101, 220323, '二道镇', 220323101),
(220323102, 220323, '伊丹镇', 220323102),
(220323103, 220323, '马鞍镇', 220323103),
(220323104, 220323, '景台镇', 220323104),
(220323105, 220323, '靠山镇', 220323105),
(220323106, 220323, '大孤山镇', 220323106),
(220323107, 220323, '小孤山镇', 220323107),
(220323108, 220323, '营城子镇', 220323108),
(220323109, 220323, '西苇镇', 220323109),
(220323110, 220323, '河源镇', 220323110),
(220323111, 220323, '黄岭子镇', 220323111),
(220323200, 220323, '新兴乡', 220323200),
(220323201, 220323, '莫里乡', 220323201),
(220323202, 220323, '三道乡', 220323202),
(220323400, 220323, '伊通经济开发区', 220323400),
(220381001, 220381, '河南街道', 220381001),
(220381002, 220381, '河北街道', 220381002),
(220381003, 220381, '东三街道', 220381003),
(220381004, 220381, '岭东街道', 220381004),
(220381005, 220381, '铁北街道', 220381005),
(220381006, 220381, '岭西街道', 220381006),
(220381007, 220381, '刘房子街道', 220381007),
(220381008, 220381, '南崴子街道', 220381008),
(220381009, 220381, '环岭街道', 220381009),
(220381010, 220381, '苇子沟街道', 220381010),
(220381100, 220381, '二十家子镇', 220381100),
(220381101, 220381, '黑林子镇', 220381101),
(220381102, 220381, '陶家屯镇', 220381102),
(220381103, 220381, '范家屯镇', 220381103),
(220381104, 220381, '响水镇', 220381104),
(220381105, 220381, '大岭镇', 220381105),
(220381106, 220381, '怀德镇', 220381106),
(220381107, 220381, '双城堡镇', 220381107),
(220381108, 220381, '双龙镇', 220381108),
(220381109, 220381, '杨大城子镇', 220381109),
(220381110, 220381, '毛城子镇', 220381110),
(220381111, 220381, '玻璃城子镇', 220381111),
(220381112, 220381, '朝阳坡镇', 220381112),
(220381113, 220381, '大榆树镇', 220381113),
(220381114, 220381, '秦家屯镇', 220381114),
(220381115, 220381, '八屋镇', 220381115),
(220381116, 220381, '十屋镇', 220381116),
(220381117, 220381, '桑树台镇', 220381117),
(220381200, 220381, '龙山乡', 220381200),
(220381201, 220381, '永发乡', 220381201),
(220382001, 220382, '郑家屯街道', 220382001),
(220382002, 220382, '辽西街道', 220382002),
(220382003, 220382, '辽南街道', 220382003),
(220382004, 220382, '辽北街道', 220382004),
(220382005, 220382, '辽东街道', 220382005),
(220382006, 220382, '红旗街道', 220382006),
(220382100, 220382, '茂林镇', 220382100),
(220382101, 220382, '双山镇', 220382101),
(220382102, 220382, '卧虎镇', 220382102),
(220382103, 220382, '服先镇', 220382103),
(220382104, 220382, '王奔镇', 220382104),
(220382105, 220382, '玻璃山镇', 220382105),
(220382106, 220382, '兴隆镇', 220382106),
(220382107, 220382, '东明镇', 220382107),
(220382200, 220382, '那木乡', 220382200),
(220382201, 220382, '柳条乡', 220382201),
(220382202, 220382, '新立乡', 220382202),
(220382203, 220382, '永加乡', 220382203),
(220382400, 220382, '双辽农场（四平辽河农垦管理区）', 220382400),
(220382401, 220382, '双辽种羊场（四平辽河农垦管理区）', 220382401),
(220382402, 220382, '双辽经济开发区', 220382402),
(220402001, 220402, '南康街道', 220402001),
(220402002, 220402, '北寿街道', 220402002),
(220402003, 220402, '东吉街道', 220402003),
(220402004, 220402, '西宁街道', 220402004),
(220402005, 220402, '站前街道', 220402005),
(220402006, 220402, '新兴街道', 220402006),
(220402007, 220402, '福镇街道', 220402007),
(220402008, 220402, '向阳街道', 220402008),
(220402070, 220402, '辽源民营经济开发区（省级）', 220402070),
(220402100, 220402, '寿山镇', 220402100),
(220402200, 220402, '工农乡', 220402200),
(220403001, 220403, '仙城街道', 220403001),
(220403002, 220403, '太安街道', 220403002),
(220403003, 220403, '东山街道', 220403003),
(220403004, 220403, '安家街道', 220403004),
(220403005, 220403, '先锋街道', 220403005),
(220403006, 220403, '富国街道', 220403006),
(220403200, 220403, '灯塔乡', 220403200),
(220421100, 220421, '东丰镇', 220421100),
(220421101, 220421, '大阳镇', 220421101),
(220421102, 220421, '横道河镇', 220421102),
(220421103, 220421, '那丹伯镇', 220421103),
(220421104, 220421, '猴石镇', 220421104),
(220421105, 220421, '杨木林镇', 220421105),
(220421106, 220421, '小四平镇', 220421106),
(220421107, 220421, '黄河镇', 220421107),
(220421108, 220421, '拉拉河镇', 220421108),
(220421109, 220421, '沙河镇', 220421109),
(220421110, 220421, '南屯基镇', 220421110),
(220421111, 220421, '大兴镇', 220421111),
(220421200, 220421, '三合满族朝鲜族乡', 220421200),
(220421201, 220421, '二龙山乡', 220421201),
(220422100, 220422, '白泉镇', 220422100),
(220422101, 220422, '渭津镇', 220422101),
(220422102, 220422, '安石镇', 220422102),
(220422103, 220422, '辽河源镇', 220422103),
(220422104, 220422, '泉太镇', 220422104),
(220422105, 220422, '建安镇', 220422105),
(220422106, 220422, '安恕镇', 220422106),
(220422107, 220422, '平岗镇', 220422107),
(220422108, 220422, '云顶镇', 220422108),
(220422200, 220422, '凌云乡', 220422200),
(220422201, 220422, '甲山乡', 220422201),
(220422202, 220422, '足民乡', 220422202),
(220422203, 220422, '金洲乡', 220422203),
(220502001, 220502, '东昌街道', 220502001),
(220502002, 220502, '民主街道', 220502002),
(220502003, 220502, '老站街道', 220502003),
(220502004, 220502, '团结街道', 220502004),
(220502005, 220502, '新站街道', 220502005),
(220502006, 220502, '光明街道', 220502006),
(220502007, 220502, '龙泉街道', 220502007),
(220502100, 220502, '金厂镇', 220502100),
(220502200, 220502, '环通乡', 220502200),
(220502201, 220502, '江东乡', 220502201),
(220502400, 220502, '通化市经济开发区管委会', 220502400),
(220503001, 220503, '桃园街道', 220503001),
(220503002, 220503, '东通化街道', 220503002),
(220503100, 220503, '鸭园镇', 220503100),
(220503101, 220503, '铁厂镇', 220503101),
(220503102, 220503, '五道江镇', 220503102),
(220503200, 220503, '二道江乡', 220503200),
(220521100, 220521, '快大茂镇', 220521100),
(220521101, 220521, '二密镇', 220521101),
(220521102, 220521, '果松镇', 220521102),
(220521103, 220521, '石湖镇', 220521103),
(220521104, 220521, '大安镇', 220521104),
(220521105, 220521, '光华镇', 220521105),
(220521106, 220521, '兴林镇', 220521106),
(220521107, 220521, '英额布镇', 220521107),
(220521108, 220521, '三棵榆树镇', 220521108),
(220521109, 220521, '江甸镇', 220521109),
(220521200, 220521, '富江乡', 220521200),
(220521201, 220521, '四棚乡', 220521201),
(220521202, 220521, '东来乡', 220521202),
(220521203, 220521, '大泉源满族朝鲜族乡', 220521203),
(220521204, 220521, '金斗朝鲜族满族乡', 220521204),
(220521400, 220521, '通化县工业集中区', 220521400),
(220521401, 220521, '东宝新村', 220521401),
(220523100, 220523, '朝阳镇', 220523100),
(220523101, 220523, '辉南镇', 220523101),
(220523102, 220523, '样子哨镇', 220523102),
(220523103, 220523, '杉松岗镇', 220523103),
(220523104, 220523, '石道河镇', 220523104),
(220523105, 220523, '辉发城镇', 220523105),
(220523106, 220523, '抚民镇', 220523106),
(220523107, 220523, '金川镇', 220523107),
(220523108, 220523, '团林镇', 220523108),
(220523109, 220523, '庆阳镇', 220523109),
(220523200, 220523, '楼街朝鲜族乡', 220523200),
(220524100, 220524, '柳河镇', 220524100),
(220524101, 220524, '三源浦朝鲜族镇', 220524101),
(220524102, 220524, '五道沟镇', 220524102),
(220524103, 220524, '驼腰岭镇', 220524103),
(220524104, 220524, '孤山子镇', 220524104),
(220524105, 220524, '圣水河子镇', 220524105),
(220524106, 220524, '罗通山镇', 220524106),
(220524107, 220524, '安口镇', 220524107),
(220524108, 220524, '向阳镇', 220524108),
(220524109, 220524, '红石镇', 220524109),
(220524110, 220524, '凉水河子镇', 220524110),
(220524111, 220524, '亨通镇', 220524111),
(220524200, 220524, '柳南乡', 220524200),
(220524201, 220524, '时家店乡', 220524201),
(220524202, 220524, '姜家店朝鲜族乡', 220524202),
(220581001, 220581, '新华街道', 220581001),
(220581002, 220581, '光明街道', 220581002),
(220581070, 220581, '和平街道办事处（梅河口市经济贸易开发区）（省级）', 220581070),
(220581071, 220581, '解放街道办事处（梅河口市经济贸易开发区）（省级）', 220581071),
(220581072, 220581, '福民街道办事处（梅河口市经济贸易开发区）（省级）', 220581072),
(220581100, 220581, '山城镇', 220581100),
(220581101, 220581, '红梅镇', 220581101),
(220581102, 220581, '海龙镇', 220581102),
(220581103, 220581, '新合镇', 220581103),
(220581104, 220581, '曙光镇', 220581104),
(220581105, 220581, '中和镇', 220581105),
(220581106, 220581, '黑山头镇', 220581106),
(220581107, 220581, '水道镇', 220581107),
(220581108, 220581, '进化镇', 220581108),
(220581109, 220581, '一座营镇', 220581109),
(220581110, 220581, '康大营镇', 220581110),
(220581111, 220581, '牛心顶镇', 220581111),
(220581200, 220581, '杏岭乡', 220581200),
(220581201, 220581, '李炉乡', 220581201),
(220581202, 220581, '湾龙乡', 220581202),
(220581203, 220581, '双兴乡', 220581203),
(220581204, 220581, '兴华乡', 220581204),
(220581205, 220581, '小杨满族朝鲜族乡', 220581205),
(220581206, 220581, '吉乐乡', 220581206),
(220582001, 220582, '团结街道', 220582001),
(220582002, 220582, '黎明街道', 220582002),
(220582003, 220582, '通胜街道', 220582003),
(220582100, 220582, '青石镇', 220582100),
(220582101, 220582, '榆林镇', 220582101),
(220582102, 220582, '花甸镇', 220582102),
(220582103, 220582, '头道镇', 220582103),
(220582104, 220582, '清河镇', 220582104),
(220582105, 220582, '台上镇', 220582105),
(220582106, 220582, '财源镇', 220582106),
(220582107, 220582, '大路镇', 220582107),
(220582108, 220582, '太王镇', 220582108),
(220582200, 220582, '麻线乡', 220582200),
(220582201, 220582, '凉水朝鲜族乡', 220582201),
(220602001, 220602, '新建街道', 220602001),
(220602002, 220602, '通沟街道', 220602002),
(220602003, 220602, '东兴街道', 220602003),
(220602004, 220602, '红旗街道', 220602004),
(220602005, 220602, '城南街道', 220602005),
(220602006, 220602, '江北街道', 220602006),
(220602007, 220602, '河口街道', 220602007),
(220602008, 220602, '板石街道', 220602008),
(220602100, 220602, '七道江镇', 220602100),
(220602101, 220602, '六道江镇', 220602101),
(220602102, 220602, '红土崖镇', 220602102),
(220602103, 220602, '三道沟镇', 220602103),
(220604100, 220604, '孙家堡子镇', 220604100),
(220604101, 220604, '三岔子镇', 220604101),
(220604102, 220604, '湾沟镇', 220604102),
(220604103, 220604, '松树镇', 220604103),
(220604104, 220604, '砟子镇', 220604104),
(220604105, 220604, '石人镇', 220604105),
(220604106, 220604, '大阳岔镇', 220604106),
(220604107, 220604, '大石人镇', 220604107),
(220621100, 220621, '抚松镇', 220621100),
(220621101, 220621, '松江河镇', 220621101),
(220621102, 220621, '泉阳镇', 220621102),
(220621103, 220621, '露水河镇', 220621103),
(220621104, 220621, '仙人桥镇', 220621104),
(220621105, 220621, '万良镇', 220621105),
(220621106, 220621, '新屯子镇', 220621106),
(220621107, 220621, '东岗镇', 220621107),
(220621108, 220621, '漫江镇', 220621108),
(220621109, 220621, '北岗镇', 220621109),
(220621110, 220621, '兴参镇', 220621110),
(220621200, 220621, '兴隆乡', 220621200),
(220621201, 220621, '抽水乡', 220621201),
(220621202, 220621, '沿江乡', 220621202),
(220622100, 220622, '靖宇镇', 220622100),
(220622101, 220622, '三道湖镇', 220622101),
(220622102, 220622, '龙泉镇', 220622102),
(220622103, 220622, '那尔轰镇', 220622103),
(220622104, 220622, '花园口镇', 220622104),
(220622105, 220622, '景山镇', 220622105),
(220622200, 220622, '赤松乡', 220622200),
(220622201, 220622, '蒙江乡', 220622201),
(220623100, 220623, '长白镇', 220623100),
(220623101, 220623, '八道沟镇', 220623101),
(220623102, 220623, '十四道沟镇', 220623102),
(220623103, 220623, '马鹿沟镇', 220623103),
(220623104, 220623, '宝泉山镇', 220623104),
(220623105, 220623, '新房子镇', 220623105),
(220623200, 220623, '金华乡', 220623200),
(220623201, 220623, '十二道沟乡', 220623201),
(220623270, 220623, '长白县南坡旅游开发区（长白山保护开发区管委会）（省级）', 220623270),
(220681001, 220681, '建国街道', 220681001),
(220681002, 220681, '新市街道', 220681002),
(220681003, 220681, '兴隆街道', 220681003),
(220681004, 220681, '大湖街道', 220681004),
(220681005, 220681, '森工街道', 220681005),
(220681006, 220681, '大栗子街道', 220681006),
(220681100, 220681, '桦树镇', 220681100),
(220681101, 220681, '六道沟镇', 220681101),
(220681102, 220681, '苇沙河镇', 220681102),
(220681103, 220681, '花山镇', 220681103),
(220681104, 220681, '闹枝镇', 220681104),
(220681105, 220681, '四道沟镇', 220681105),
(220681200, 220681, '蚂蚁河乡', 220681200),
(220702001, 220702, '团结街道', 220702001),
(220702002, 220702, '文化街道', 220702002),
(220702003, 220702, '民主街道', 220702003),
(220702004, 220702, '临江街道', 220702004),
(220702005, 220702, '新区街道', 220702005),
(220702006, 220702, '前进街道', 220702006),
(220702007, 220702, '和平街道', 220702007),
(220702008, 220702, '工农街道', 220702008),
(220702009, 220702, '沿江街道', 220702009),
(220702010, 220702, '铁西街道', 220702010),
(220702011, 220702, '繁荣街道', 220702011),
(220702012, 220702, '建设街道', 220702012),
(220702013, 220702, '石化街道', 220702013),
(220702100, 220702, '大洼镇', 220702100),
(220702101, 220702, '善友镇', 220702101),
(220702102, 220702, '毛都站镇', 220702102),
(220702103, 220702, '伯都纳镇', 220702103),
(220702200, 220702, '新城乡', 220702200),
(220702201, 220702, '兴原乡', 220702201),
(220702400, 220702, '华侨农场', 220702400),
(220721100, 220721, '前郭尔罗斯镇', 220721100),
(220721101, 220721, '长山镇', 220721101),
(220721102, 220721, '海渤日戈镇', 220721102),
(220721103, 220721, '乌兰图嘎镇', 220721103),
(220721104, 220721, '查干花镇', 220721104),
(220721105, 220721, '王府站镇', 220721105),
(220721106, 220721, '八郎镇', 220721106),
(220721107, 220721, '哈拉毛都镇', 220721107),
(220721200, 220721, '宝甸乡', 220721200),
(220721201, 220721, '平凤乡', 220721201),
(220721202, 220721, '蒙古艾里乡', 220721202),
(220721203, 220721, '达里巴乡', 220721203),
(220721204, 220721, '吉拉吐乡', 220721204),
(220721205, 220721, '白依拉嘎乡', 220721205),
(220721206, 220721, '洪泉乡', 220721206),
(220721207, 220721, '额如乡', 220721207),
(220721208, 220721, '套浩太乡', 220721208),
(220721209, 220721, '长龙乡', 220721209),
(220721210, 220721, '乌兰塔拉乡', 220721210),
(220721211, 220721, '东三家子乡', 220721211),
(220721212, 220721, '浩特芒哈乡', 220721212),
(220721213, 220721, '乌兰敖都乡', 220721213),
(220721400, 220721, '红旗农场', 220721400),
(220721401, 220721, '红光农场', 220721401),
(220721402, 220721, '红星牧场', 220721402),
(220721403, 220721, '查干花种畜场', 220721403),
(220722100, 220722, '长岭镇', 220722100),
(220722101, 220722, '太平川镇', 220722101),
(220722102, 220722, '巨宝镇', 220722102),
(220722103, 220722, '太平山镇', 220722103),
(220722104, 220722, '前七号镇', 220722104),
(220722105, 220722, '新安镇', 220722105),
(220722106, 220722, '三青山镇', 220722106),
(220722107, 220722, '大兴镇', 220722107),
(220722108, 220722, '北正镇', 220722108),
(220722109, 220722, '流水镇', 220722109),
(220722110, 220722, '永久镇', 220722110),
(220722111, 220722, '利发盛镇', 220722111),
(220722200, 220722, '集体乡', 220722200),
(220722201, 220722, '光明乡', 220722201),
(220722202, 220722, '三县堡乡', 220722202),
(220722203, 220722, '海青乡', 220722203),
(220722204, 220722, '前进乡', 220722204),
(220722205, 220722, '东岭乡', 220722205),
(220722206, 220722, '腰坨子乡', 220722206),
(220722207, 220722, '八十八乡', 220722207),
(220722208, 220722, '三团乡', 220722208),
(220722209, 220722, '三十号乡', 220722209),
(220722400, 220722, '长岭种马场', 220722400),
(220722401, 220722, '太平川（镇）农业园区', 220722401),
(220722402, 220722, '北正（镇）牧业园区', 220722402),
(220722403, 220722, '双龙工业园区', 220722403),
(220722404, 220722, '长岭经济开发区', 220722404),
(220722405, 220722, '太平川机械林场', 220722405),
(220722406, 220722, '三团机械林场', 220722406),
(220722407, 220722, '东岭机械林场', 220722407),
(220722408, 220722, '十四号种畜场', 220722408),
(220722409, 220722, '良种繁育场', 220722409),
(220722410, 220722, '前七号机械林场', 220722410),
(220723100, 220723, '乾安镇', 220723100),
(220723101, 220723, '大布苏镇', 220723101),
(220723102, 220723, '水字镇', 220723102),
(220723103, 220723, '让字镇', 220723103),
(220723104, 220723, '所字镇', 220723104),
(220723105, 220723, '安字镇', 220723105),
(220723200, 220723, '余字乡', 220723200),
(220723201, 220723, '道字乡', 220723201),
(220723202, 220723, '严字乡', 220723202),
(220723203, 220723, '赞字乡', 220723203),
(220724100, 220724, '三岔河镇', 220724100),
(220724101, 220724, '长春岭镇', 220724101),
(220724102, 220724, '五家站镇', 220724102),
(220724103, 220724, '陶赖昭镇', 220724103),
(220724104, 220724, '蔡家沟镇', 220724104),
(220724105, 220724, '弓棚子镇', 220724105),
(220724106, 220724, '三井子镇', 220724106),
(220724107, 220724, '增盛镇', 220724107),
(220724108, 220724, '新万发镇', 220724108),
(220724109, 220724, '大林子镇', 220724109),
(220724110, 220724, '新源镇', 220724110),
(220724200, 220724, '三骏满族蒙古族锡伯族乡', 220724200),
(220724201, 220724, '永平乡', 220724201),
(220724202, 220724, '社里乡', 220724202),
(220724203, 220724, '新站乡', 220724203),
(220724204, 220724, '更新乡', 220724204),
(220724205, 220724, '伊家店乡', 220724205),
(220724206, 220724, '肖家乡', 220724206),
(220724400, 220724, '伊家店农场', 220724400),
(220724401, 220724, '拉林灌区管理局', 220724401),
(220724402, 220724, '下岱吉灌区管理局', 220724402),
(220802001, 220802, '海明街道', 220802001),
(220802002, 220802, '长庆街道', 220802002),
(220802003, 220802, '瑞光街道', 220802003),
(220802004, 220802, '明仁街道', 220802004),
(220802005, 220802, '铁东街道', 220802005),
(220802006, 220802, '城南街道', 220802006),
(220802007, 220802, '新立街道', 220802007),
(220802008, 220802, '幸福街道', 220802008),
(220802009, 220802, '新华街道', 220802009),
(220802010, 220802, '保平街道', 220802010),
(220802070, 220802, '白城经济开发区（省级）', 220802070),
(220802100, 220802, '平安镇', 220802100),
(220802101, 220802, '青山镇', 220802101),
(220802102, 220802, '林海镇', 220802102),
(220802103, 220802, '洮河镇', 220802103),
(220802104, 220802, '平台镇', 220802104),
(220802105, 220802, '到保镇', 220802105),
(220802170, 220802, '岭下镇（查干浩特旅游经济开发区）（省级）', 220802170),
(220802200, 220802, '东风乡', 220802200),
(220802201, 220802, '三合乡', 220802201),
(220802202, 220802, '东胜乡', 220802202),
(220802203, 220802, '金祥乡', 220802203),
(220802204, 220802, '德顺蒙古族乡', 220802204),
(220802400, 220802, '民营经济发展区', 220802400),
(220802401, 220802, '白城市工业园区', 220802401),
(220802402, 220802, '镇南种羊场', 220802402),
(220821100, 220821, '镇赉镇', 220821100),
(220821101, 220821, '坦途镇', 220821101),
(220821102, 220821, '东屏镇', 220821102),
(220821103, 220821, '大屯镇', 220821103),
(220821104, 220821, '沿江镇', 220821104),
(220821105, 220821, '五棵树镇', 220821105),
(220821106, 220821, '黑鱼泡镇', 220821106),
(220821200, 220821, '哈吐气蒙古族乡', 220821200),
(220821201, 220821, '莫莫格蒙古族乡', 220821201),
(220821202, 220821, '建平乡', 220821202),
(220821203, 220821, '嘎什根乡', 220821203),
(220821400, 220821, '镇赉监狱分局', 220821400),
(220822100, 220822, '开通镇', 220822100),
(220822101, 220822, '瞻榆镇', 220822101),
(220822102, 220822, '双岗镇', 220822102),
(220822103, 220822, '兴隆山镇', 220822103),
(220822104, 220822, '边昭镇', 220822104),
(220822105, 220822, '鸿兴镇', 220822105),
(220822106, 220822, '新华镇', 220822106),
(220822107, 220822, '乌兰花镇', 220822107),
(220822200, 220822, '新发乡', 220822200),
(220822201, 220822, '新兴乡', 220822201),
(220822202, 220822, '向海蒙古族乡', 220822202),
(220822203, 220822, '包拉温都蒙古族乡', 220822203),
(220822204, 220822, '团结乡', 220822204),
(220822205, 220822, '十花道乡', 220822205),
(220822206, 220822, '八面乡', 220822206),
(220822207, 220822, '苏公坨乡', 220822207),
(220822400, 220822, '通榆经济开发区', 220822400),
(220881001, 220881, '团结街道', 220881001),
(220881002, 220881, '富文街道', 220881002),
(220881003, 220881, '光明街道', 220881003),
(220881004, 220881, '兴隆街道', 220881004),
(220881005, 220881, '永康街道', 220881005),
(220881006, 220881, '通达街道', 220881006),
(220881007, 220881, '洮府街道', 220881007),
(220881008, 220881, '向阳街道', 220881008),
(220881100, 220881, '瓦房镇', 220881100),
(220881101, 220881, '万宝镇', 220881101),
(220881102, 220881, '黑水镇', 220881102),
(220881103, 220881, '那金镇', 220881103),
(220881104, 220881, '安定镇', 220881104),
(220881200, 220881, '胡力吐蒙古族乡', 220881200),
(220881201, 220881, '万宝乡', 220881201),
(220881202, 220881, '聚宝乡', 220881202),
(220881203, 220881, '东升乡', 220881203),
(220881204, 220881, '野马乡', 220881204),
(220881205, 220881, '永茂乡', 220881205),
(220881206, 220881, '蛟流河乡', 220881206),
(220881207, 220881, '大通乡', 220881207),
(220881208, 220881, '福顺乡', 220881208),
(220881209, 220881, '二龙乡', 220881209),
(220881210, 220881, '呼和车力蒙古族乡', 220881210),
(220881400, 220881, '洮南市种雏场', 220881400),
(220881401, 220881, '洮南市甜菜育种研究所', 220881401),
(220882001, 220882, '慧阳街道', 220882001),
(220882002, 220882, '临江街道', 220882002),
(220882003, 220882, '长虹街道', 220882003),
(220882004, 220882, '锦华街道', 220882004),
(220882005, 220882, '安北街道', 220882005),
(220882070, 220882, '大安经济开发区（省级）', 220882070),
(220882100, 220882, '月亮泡镇', 220882100),
(220882101, 220882, '安广镇', 220882101),
(220882102, 220882, '丰收镇', 220882102),
(220882103, 220882, '新平安镇', 220882103),
(220882104, 220882, '两家子镇', 220882104),
(220882105, 220882, '舍力镇', 220882105),
(220882106, 220882, '大岗子镇', 220882106),
(220882107, 220882, '叉干镇', 220882107),
(220882108, 220882, '龙沼镇', 220882108),
(220882109, 220882, '太山镇', 220882109),
(220882110, 220882, '烧锅镇', 220882110),
(220882111, 220882, '乐胜镇', 220882111),
(220882200, 220882, '四棵树乡', 220882200),
(220882201, 220882, '联合乡', 220882201),
(220882202, 220882, '大赉乡', 220882202),
(220882203, 220882, '红岗子乡', 220882203),
(220882204, 220882, '海坨乡', 220882204),
(220882205, 220882, '新艾里蒙古族乡', 220882205),
(222401001, 222401, '朝阳街道', 222401001),
(222401002, 222401, '北山街道', 222401002),
(222401003, 222401, '新兴街道', 222401003),
(222401004, 222401, '公园街道', 222401004),
(222401005, 222401, '河南街道', 222401005),
(222401006, 222401, '建工街道', 222401006),
(222401100, 222401, '小营镇', 222401100),
(222401101, 222401, '依兰镇', 222401101),
(222401102, 222401, '三道湾镇', 222401102),
(222402001, 222402, '向上街道', 222402001),
(222402002, 222402, '新华街道', 222402002),
(222402003, 222402, '月宫街道', 222402003),
(222402100, 222402, '月晴镇', 222402100),
(222402101, 222402, '石岘镇', 222402101),
(222402102, 222402, '长安镇', 222402102),
(222402103, 222402, '凉水镇', 222402103),
(222403001, 222403, '渤海街道', 222403001),
(222403002, 222403, '胜利街道', 222403002),
(222403003, 222403, '民主街道', 222403003),
(222403004, 222403, '丹江街道', 222403004),
(222403100, 222403, '大石头镇', 222403100),
(222403101, 222403, '黄泥河镇', 222403101),
(222403102, 222403, '官地镇', 222403102),
(222403103, 222403, '沙河沿镇', 222403103),
(222403104, 222403, '秋梨沟镇', 222403104),
(222403105, 222403, '额穆镇', 222403105),
(222403106, 222403, '贤儒镇', 222403106),
(222403107, 222403, '大蒲柴河镇', 222403107),
(222403108, 222403, '雁鸣湖镇', 222403108),
(222403109, 222403, '江源镇', 222403109),
(222403110, 222403, '江南镇', 222403110),
(222403200, 222403, '大桥乡', 222403200),
(222403201, 222403, '黑石乡', 222403201),
(222403202, 222403, '青沟子乡', 222403202),
(222403203, 222403, '翰章乡', 222403203),
(222403204, 222403, '红石乡', 222403204),
(222403400, 222403, '丹峰林业有限公司', 222403400),
(222403401, 222403, '黄泥河林业局', 222403401),
(222403402, 222403, '延边林业集团亚光有限公司', 222403402),
(222403403, 222403, '敦化市林业局', 222403403),
(222404001, 222404, '靖和街道', 222404001),
(222404002, 222404, '新安街道', 222404002),
(222404003, 222404, '河南街道', 222404003),
(222404070, 222404, '近海街道办事处（珲春边境经济合作区）（国家级）', 222404070),
(222404100, 222404, '春化镇', 222404100),
(222404101, 222404, '敬信镇', 222404101),
(222404102, 222404, '板石镇', 222404102),
(222404103, 222404, '英安镇', 222404103),
(222404200, 222404, '马川子乡', 222404200),
(222404201, 222404, '杨泡满族乡', 222404201),
(222404202, 222404, '三家子满族乡', 222404202),
(222404203, 222404, '密江乡', 222404203),
(222404204, 222404, '哈达门乡', 222404204),
(222404400, 222404, '珲春林业局', 222404400),
(222405001, 222405, '安民街道', 222405001),
(222405002, 222405, '龙门街道', 222405002),
(222405100, 222405, '开山屯镇', 222405100),
(222405101, 222405, '朝阳川镇', 222405101),
(222405102, 222405, '老头沟镇', 222405102),
(222405103, 222405, '三合镇', 222405103),
(222405104, 222405, '东盛涌镇', 222405104),
(222405105, 222405, '智新镇', 222405105),
(222405200, 222405, '德新乡', 222405200),
(222405201, 222405, '白金乡', 222405201),
(222406001, 222406, '民慧街道', 222406001),
(222406002, 222406, '光明街道', 222406002),
(222406003, 222406, '文化街道', 222406003),
(222406100, 222406, '八家子镇', 222406100),
(222406101, 222406, '福洞镇', 222406101),
(222406102, 222406, '头道镇', 222406102),
(222406103, 222406, '西城镇', 222406103),
(222406104, 222406, '南坪镇', 222406104),
(222406105, 222406, '东城镇', 222406105),
(222406106, 222406, '崇善镇', 222406106),
(222406107, 222406, '龙城镇', 222406107),
(222406400, 222406, '和龙林业局', 222406400),
(222406401, 222406, '八家子林业局', 222406401),
(222406402, 222406, '和龙市林业局', 222406402),
(222424001, 222424, '东城街道', 222424001),
(222424002, 222424, '西城街道', 222424002),
(222424100, 222424, '汪清镇', 222424100),
(222424101, 222424, '大兴沟镇', 222424101),
(222424102, 222424, '天桥岭镇', 222424102),
(222424103, 222424, '罗子沟镇', 222424103),
(222424104, 222424, '百草沟镇', 222424104),
(222424105, 222424, '春阳镇', 222424105),
(222424106, 222424, '复兴镇', 222424106),
(222424107, 222424, '东光镇', 222424107),
(222424200, 222424, '鸡冠乡', 222424200),
(222424400, 222424, '汪清林业局', 222424400),
(222424401, 222424, '天桥岭林业局', 222424401),
(222424402, 222424, '大兴沟林业局', 222424402),
(222426100, 222426, '明月镇', 222426100),
(222426101, 222426, '松江镇', 222426101),
(222426102, 222426, '二道白河镇', 222426102),
(222426103, 222426, '两江镇', 222426103),
(222426104, 222426, '石门镇', 222426104),
(222426105, 222426, '万宝镇', 222426105),
(222426106, 222426, '亮兵镇', 222426106),
(222426200, 222426, '新合乡', 222426200),
(222426201, 222426, '永庆乡', 222426201),
(222426400, 222426, '白河林业局', 222426400),
(222426401, 222426, '安图林业有限公司', 222426401),
(222426402, 222426, '安图县林业局', 222426402),
(230102001, 230102, '兆麟街道', 230102001),
(230102002, 230102, '新阳路街道', 230102002),
(230102003, 230102, '抚顺街道', 230102003),
(230102004, 230102, '共乐街道', 230102004),
(230102005, 230102, '新华街道', 230102005),
(230102006, 230102, '城乡路街道', 230102006),
(230102007, 230102, '工农街道', 230102007),
(230102008, 230102, '尚志街道', 230102008),
(230102009, 230102, '斯大林街道', 230102009),
(230102010, 230102, '通江街道', 230102010),
(230102011, 230102, '经纬街道', 230102011),
(230102012, 230102, '工程街道', 230102012),
(230102013, 230102, '安静街道', 230102013),
(230102014, 230102, '安和街道', 230102014),
(230102015, 230102, '正阳河街道', 230102015),
(230102016, 230102, '建国街道', 230102016),
(230102017, 230102, '康安街道', 230102017),
(230102101, 230102, '太平镇', 230102101),
(230102102, 230102, '新发镇', 230102102),
(230102103, 230102, '新农镇', 230102103),
(230102104, 230102, '榆树镇', 230102104),
(230102200, 230102, '群力乡', 230102200),
(230102500, 230102, '阎家岗农场', 230102500),
(230103001, 230103, '花园街道', 230103001),
(230103002, 230103, '奋斗路街道', 230103002),
(230103003, 230103, '革新街道', 230103003),
(230103004, 230103, '文化街道', 230103004),
(230103005, 230103, '大成街道', 230103005),
(230103006, 230103, '芦家街道', 230103006),
(230103007, 230103, '荣市街道', 230103007),
(230103009, 230103, '燎原街道', 230103009),
(230103010, 230103, '松花江街道', 230103010),
(230103011, 230103, '曲线街道', 230103011),
(230103012, 230103, '通达街道', 230103012),
(230103013, 230103, '七政街道', 230103013),
(230103015, 230103, '和兴路街道', 230103015),
(230103016, 230103, '哈西街道', 230103016),
(230103017, 230103, '保健路街道', 230103017),
(230103018, 230103, '先锋路街道', 230103018),
(230103019, 230103, '新春街道', 230103019),
(230103101, 230103, '王岗镇', 230103101),
(230103201, 230103, '红旗满族乡', 230103201),
(230103202, 230103, '跃进乡', 230103202),
(230104001, 230104, '靖宇街道', 230104001),
(230104002, 230104, '太古街道', 230104002),
(230104003, 230104, '东莱街道', 230104003),
(230104004, 230104, '滨江街道', 230104004),
(230104005, 230104, '仁里街道', 230104005),
(230104007, 230104, '崇俭街道', 230104007),
(230104008, 230104, '振江街道', 230104008),
(230104009, 230104, '东原街道', 230104009),
(230104010, 230104, '大兴街道', 230104010),
(230104011, 230104, '胜利街道', 230104011),
(230104012, 230104, '南马街道', 230104012),
(230104021, 230104, '民强街道', 230104021),
(230104022, 230104, '大有坊街道', 230104022),
(230104023, 230104, '南直路街道', 230104023),
(230104024, 230104, '化工街道', 230104024),
(230104025, 230104, '火车头街道', 230104025),
(230104026, 230104, '新一街道', 230104026),
(230104027, 230104, '三棵树大街街道', 230104027),
(230104028, 230104, '水泥路街道', 230104028),
(230104029, 230104, '太平大街街道', 230104029),
(230104030, 230104, '黎华街道', 230104030),
(230104031, 230104, '新乐街道', 230104031),
(230104102, 230104, '永源镇', 230104102),
(230104109, 230104, '巨源镇', 230104109),
(230104111, 230104, '团结镇', 230104111),
(230104200, 230104, '民主乡', 230104200),
(230108001, 230108, '兴建街道', 230108001);
INSERT INTO `{pre}areas` VALUES
(230108002, 230108, '保国街道', 230108002),
(230108003, 230108, '联盟街道', 230108003),
(230108004, 230108, '友协街道', 230108004),
(230108005, 230108, '新疆街道', 230108005),
(230108006, 230108, '新伟街道', 230108006),
(230108101, 230108, '平房镇', 230108101),
(230108102, 230108, '平新镇', 230108102),
(230109001, 230109, '三电街道', 230109001),
(230109002, 230109, '太阳岛街道', 230109002),
(230109003, 230109, '松浦街道', 230109003),
(230109004, 230109, '万宝街道', 230109004),
(230109005, 230109, '松北街道', 230109005),
(230109101, 230109, '对青山镇', 230109101),
(230109102, 230109, '乐业镇', 230109102),
(230110001, 230110, '香坊大街街道', 230110001),
(230110002, 230110, '安埠街道', 230110002),
(230110003, 230110, '通天街道', 230110003),
(230110004, 230110, '新香坊街道', 230110004),
(230110005, 230110, '铁东街道', 230110005),
(230110006, 230110, '新成街道', 230110006),
(230110007, 230110, '红旗街道', 230110007),
(230110008, 230110, '六顺街道', 230110008),
(230110009, 230110, '建筑街道', 230110009),
(230110010, 230110, '哈平路街道', 230110010),
(230110011, 230110, '安乐街道', 230110011),
(230110012, 230110, '健康路街道', 230110012),
(230110013, 230110, '大庆路街道', 230110013),
(230110014, 230110, '进乡街道', 230110014),
(230110015, 230110, '通乡街道', 230110015),
(230110016, 230110, '和平路街道', 230110016),
(230110017, 230110, '民生路街道', 230110017),
(230110018, 230110, '文政街道', 230110018),
(230110019, 230110, '王兆街道', 230110019),
(230110020, 230110, '黎明街道', 230110020),
(230110101, 230110, '成高子镇', 230110101),
(230110102, 230110, '幸福镇', 230110102),
(230110103, 230110, '朝阳镇', 230110103),
(230110201, 230110, '向阳乡', 230110201),
(230110500, 230110, '香坊实验农场', 230110500),
(230111001, 230111, '呼兰街道', 230111001),
(230111002, 230111, '兰河街道', 230111002),
(230111003, 230111, '利民街道', 230111003),
(230111004, 230111, '腰卜街道', 230111004),
(230111101, 230111, '康金镇', 230111101),
(230111104, 230111, '沈家镇', 230111104),
(230111105, 230111, '二八镇', 230111105),
(230111106, 230111, '石人镇', 230111106),
(230111107, 230111, '白奎镇', 230111107),
(230111109, 230111, '方台镇', 230111109),
(230111110, 230111, '莲花镇', 230111110),
(230111111, 230111, '大用镇', 230111111),
(230111112, 230111, '双井镇', 230111112),
(230111113, 230111, '长岭镇', 230111113),
(230111201, 230111, '杨林乡', 230111201),
(230111203, 230111, '许卜乡', 230111203),
(230111205, 230111, '孟家乡', 230111205),
(230112001, 230112, '和平街道', 230112001),
(230112002, 230112, '胜利街道', 230112002),
(230112003, 230112, '通城街道', 230112003),
(230112004, 230112, '河东街道', 230112004),
(230112005, 230112, '阿什河街道', 230112005),
(230112101, 230112, '玉泉镇', 230112101),
(230112103, 230112, '蜚克图镇', 230112103),
(230112104, 230112, '亚沟镇', 230112104),
(230112105, 230112, '交界镇', 230112105),
(230112106, 230112, '小岭镇', 230112106),
(230112107, 230112, '平山镇', 230112107),
(230112108, 230112, '松峰山镇', 230112108),
(230112110, 230112, '新华镇', 230112110),
(230112111, 230112, '双丰镇', 230112111),
(230112202, 230112, '杨树乡', 230112202),
(230112204, 230112, '舍利乡', 230112204),
(230112205, 230112, '料甸满族乡', 230112205),
(230112206, 230112, '红星乡', 230112206),
(230112207, 230112, '大岭乡', 230112207),
(230123100, 230123, '依兰镇', 230123100),
(230123101, 230123, '达连河镇', 230123101),
(230123102, 230123, '江湾镇', 230123102),
(230123103, 230123, '三道岗镇', 230123103),
(230123104, 230123, '道台桥镇', 230123104),
(230123105, 230123, '宏克利镇', 230123105),
(230123200, 230123, '团山子乡', 230123200),
(230123201, 230123, '愚公乡', 230123201),
(230123202, 230123, '迎兰朝鲜族乡', 230123202),
(230123400, 230123, '依兰县林业局', 230123400),
(230123500, 230123, '依兰农场', 230123500),
(230123501, 230123, '松花江农场', 230123501),
(230123580, 230123, '红旗良种厂', 230123580),
(230123581, 230123, '依兰县农委', 230123581),
(230124100, 230124, '方正镇', 230124100),
(230124101, 230124, '会发镇', 230124101),
(230124102, 230124, '大罗密镇', 230124102),
(230124200, 230124, '天门乡', 230124200),
(230124201, 230124, '松南乡', 230124201),
(230124202, 230124, '德善乡', 230124202),
(230124204, 230124, '宝兴乡', 230124204),
(230124205, 230124, '伊汉通乡', 230124205),
(230124400, 230124, '方正林业局', 230124400),
(230124500, 230124, '沙河农场', 230124500),
(230125100, 230125, '宾州镇', 230125100),
(230125101, 230125, '居仁镇', 230125101),
(230125102, 230125, '宾西镇', 230125102),
(230125103, 230125, '糖坊镇', 230125103),
(230125104, 230125, '宾安镇', 230125104),
(230125105, 230125, '新甸镇', 230125105),
(230125106, 230125, '胜利镇', 230125106),
(230125107, 230125, '宁远镇', 230125107),
(230125109, 230125, '摆渡镇', 230125109),
(230125110, 230125, '平坊镇', 230125110),
(230125111, 230125, '满井镇', 230125111),
(230125112, 230125, '常安镇', 230125112),
(230125201, 230125, '永和乡', 230125201),
(230125203, 230125, '鸟河乡', 230125203),
(230125204, 230125, '民和乡', 230125204),
(230125205, 230125, '经建乡', 230125205),
(230125210, 230125, '三宝乡', 230125210),
(230126100, 230126, '巴彦镇', 230126100),
(230126101, 230126, '兴隆镇', 230126101),
(230126102, 230126, '西集镇', 230126102),
(230126103, 230126, '洼兴镇', 230126103),
(230126104, 230126, '龙泉镇', 230126104),
(230126105, 230126, '巴彦港镇', 230126105),
(230126106, 230126, '龙庙镇', 230126106),
(230126107, 230126, '万发镇', 230126107),
(230126108, 230126, '天增镇', 230126108),
(230126110, 230126, '黑山镇', 230126110),
(230126200, 230126, '松花江乡', 230126200),
(230126202, 230126, '富江乡', 230126202),
(230126204, 230126, '华山乡', 230126204),
(230126205, 230126, '丰乐乡', 230126205),
(230126209, 230126, '德祥乡', 230126209),
(230126210, 230126, '红光乡', 230126210),
(230126212, 230126, '山后乡', 230126212),
(230126214, 230126, '镇东乡', 230126214),
(230126400, 230126, '兴隆林业局', 230126400),
(230127100, 230127, '木兰镇', 230127100),
(230127101, 230127, '东兴镇', 230127101),
(230127102, 230127, '大贵镇', 230127102),
(230127103, 230127, '利东镇', 230127103),
(230127104, 230127, '柳河镇', 230127104),
(230127105, 230127, '新民镇', 230127105),
(230127200, 230127, '建国乡', 230127200),
(230127203, 230127, '吉兴乡', 230127203),
(230127400, 230127, '兴隆林业局', 230127400),
(230128100, 230128, '通河镇', 230128100),
(230128101, 230128, '乌鸦泡镇', 230128101),
(230128102, 230128, '清河镇', 230128102),
(230128103, 230128, '浓河镇', 230128103),
(230128104, 230128, '凤山镇', 230128104),
(230128105, 230128, '祥顺镇', 230128105),
(230128201, 230128, '三站乡', 230128201),
(230128202, 230128, '富林乡', 230128202),
(230128400, 230128, '清河林业局', 230128400),
(230128401, 230128, '兴隆林业局', 230128401),
(230128500, 230128, '岔林河农场', 230128500),
(230129100, 230129, '延寿镇', 230129100),
(230129101, 230129, '六团镇', 230129101),
(230129102, 230129, '中和镇', 230129102),
(230129103, 230129, '加信镇', 230129103),
(230129104, 230129, '延河镇', 230129104),
(230129204, 230129, '安山乡', 230129204),
(230129205, 230129, '寿山乡', 230129205),
(230129206, 230129, '玉河乡', 230129206),
(230129209, 230129, '青川乡', 230129209),
(230129400, 230129, '太平川', 230129400),
(230129500, 230129, '庆阳农场', 230129500),
(230182001, 230182, '双城市街道社区管委会', 230182001),
(230182100, 230182, '双城镇', 230182100),
(230182101, 230182, '兰棱镇', 230182101),
(230182102, 230182, '周家镇', 230182102),
(230182103, 230182, '五家镇', 230182103),
(230182104, 230182, '韩甸镇', 230182104),
(230182105, 230182, '单城镇', 230182105),
(230182106, 230182, '东官镇', 230182106),
(230182107, 230182, '农丰满族锡伯族镇', 230182107),
(230182108, 230182, '杏山镇', 230182108),
(230182200, 230182, '朝阳乡', 230182200),
(230182201, 230182, '金城乡', 230182201),
(230182203, 230182, '青岭满族乡', 230182203),
(230182204, 230182, '联兴满族乡', 230182204),
(230182205, 230182, '幸福满族乡', 230182205),
(230182206, 230182, '新兴满族乡', 230182206),
(230182207, 230182, '公正满族乡', 230182207),
(230182208, 230182, '永胜乡', 230182208),
(230182209, 230182, '临江乡', 230182209),
(230182210, 230182, '水泉乡', 230182210),
(230182211, 230182, '乐群满族乡', 230182211),
(230182213, 230182, '团结满族乡', 230182213),
(230182214, 230182, '万隆乡', 230182214),
(230182216, 230182, '希勤满族乡', 230182216),
(230182217, 230182, '同心满族乡', 230182217),
(230183100, 230183, '尚志镇', 230183100),
(230183101, 230183, '一面坡镇', 230183101),
(230183102, 230183, '苇河镇', 230183102),
(230183103, 230183, '亚布力镇', 230183103),
(230183104, 230183, '帽儿山镇', 230183104),
(230183105, 230183, '亮河镇', 230183105),
(230183106, 230183, '庆阳镇', 230183106),
(230183107, 230183, '石头河子镇', 230183107),
(230183108, 230183, '元宝镇', 230183108),
(230183109, 230183, '黑龙宫镇', 230183109),
(230183202, 230183, '长寿乡', 230183202),
(230183204, 230183, '乌吉密乡', 230183204),
(230183206, 230183, '鱼池乡', 230183206),
(230183207, 230183, '珍珠山乡', 230183207),
(230183208, 230183, '老街基乡', 230183208),
(230183209, 230183, '马延乡', 230183209),
(230183211, 230183, '河东乡', 230183211),
(230183400, 230183, '苇河林业局', 230183400),
(230183401, 230183, '亚布力林业局', 230183401),
(230184100, 230184, '五常镇', 230184100),
(230184101, 230184, '拉林满族镇', 230184101),
(230184102, 230184, '山河镇', 230184102),
(230184103, 230184, '小山子镇', 230184103),
(230184104, 230184, '安家镇', 230184104),
(230184105, 230184, '牛家满族镇', 230184105),
(230184106, 230184, '杜家镇', 230184106),
(230184107, 230184, '背荫河镇', 230184107),
(230184108, 230184, '冲河镇', 230184108),
(230184109, 230184, '沙河子镇', 230184109),
(230184110, 230184, '向阳镇', 230184110),
(230184200, 230184, '兴盛乡', 230184200),
(230184201, 230184, '志广乡', 230184201),
(230184202, 230184, '卫国乡', 230184202),
(230184203, 230184, '常堡乡', 230184203),
(230184206, 230184, '民意乡', 230184206),
(230184207, 230184, '龙凤山乡', 230184207),
(230184209, 230184, '红旗满族乡', 230184209),
(230184210, 230184, '八家子乡', 230184210),
(230184211, 230184, '民乐朝鲜族乡', 230184211),
(230184212, 230184, '营城子满族乡', 230184212),
(230184214, 230184, '长山乡', 230184214),
(230184215, 230184, '兴隆乡', 230184215),
(230184216, 230184, '二河乡', 230184216),
(230184400, 230184, '山河屯林业局', 230184400),
(230202001, 230202, '五龙街道', 230202001),
(230202002, 230202, '湖滨街道', 230202002),
(230202003, 230202, '江安街道', 230202003),
(230202004, 230202, '正阳街道', 230202004),
(230202005, 230202, '彩虹街道', 230202005),
(230202006, 230202, '南航街道', 230202006),
(230202198, 230202, '龙沙区直辖地域', 230202198),
(230203003, 230203, '中华街道', 230203003),
(230203004, 230203, '西大桥街道', 230203004),
(230203005, 230203, '卜奎街道', 230203005),
(230203006, 230203, '建设街道', 230203006),
(230203007, 230203, '文化街道', 230203007),
(230203198, 230203, '建华区直辖地域', 230203198),
(230204001, 230204, '站前街道', 230204001),
(230204002, 230204, '南浦街道', 230204002),
(230204003, 230204, '通东街道', 230204003),
(230204004, 230204, '光荣街道', 230204004),
(230204005, 230204, '龙华街道', 230204005),
(230204006, 230204, '北局宅街道', 230204006),
(230204008, 230204, '东湖街道', 230204008),
(230204200, 230204, '扎龙乡', 230204200),
(230204580, 230204, '齐齐哈尔种畜场', 230204580),
(230205001, 230205, '新兴街道', 230205001),
(230205002, 230205, '新建街道', 230205002),
(230205005, 230205, '林机街道', 230205005),
(230205006, 230205, '道北街道', 230205006),
(230205100, 230205, '水师营满族镇', 230205100),
(230205102, 230205, '三间房镇', 230205102),
(230206001, 230206, '红岸街道', 230206001),
(230206003, 230206, '沿江街道', 230206003),
(230206004, 230206, '电力街道', 230206004),
(230206005, 230206, '幸福街道', 230206005),
(230206006, 230206, '红宝石街道', 230206006),
(230206007, 230206, '北兴街道', 230206007),
(230206008, 230206, '铁北街道', 230206008),
(230206200, 230206, '长青乡', 230206200),
(230206202, 230206, '杜尔门沁达翰尔族乡', 230206202),
(230207001, 230207, '东安街道', 230207001),
(230207002, 230207, '富强街道', 230207002),
(230207003, 230207, '跃进街道', 230207003),
(230207004, 230207, '繁荣街道', 230207004),
(230207198, 230207, '碾子山区直辖地域', 230207198),
(230208001, 230208, '梅里斯街道', 230208001),
(230208101, 230208, '雅尔塞镇', 230208101),
(230208102, 230208, '卧牛吐镇', 230208102),
(230208103, 230208, '达呼店镇', 230208103),
(230208104, 230208, '共和镇', 230208104),
(230208200, 230208, '莽格吐乡', 230208200),
(230208201, 230208, '梅里斯乡', 230208201),
(230208501, 230208, '哈拉海农场', 230208501),
(230221100, 230221, '龙江镇', 230221100),
(230221101, 230221, '景星镇', 230221101),
(230221102, 230221, '龙兴镇', 230221102),
(230221103, 230221, '山泉镇', 230221103),
(230221104, 230221, '七棵树镇', 230221104),
(230221200, 230221, '白山乡', 230221200),
(230221201, 230221, '黑岗乡', 230221201),
(230221202, 230221, '广厚乡', 230221202),
(230221203, 230221, '华民乡', 230221203),
(230221204, 230221, '哈拉海乡', 230221204),
(230221211, 230221, '杏山乡', 230221211),
(230221214, 230221, '头站乡', 230221214),
(230221215, 230221, '鲁河乡', 230221215),
(230221217, 230221, '济沁河乡', 230221217),
(230223100, 230223, '依安镇', 230223100),
(230223101, 230223, '依龙镇', 230223101),
(230223102, 230223, '双阳镇', 230223102),
(230223103, 230223, '三兴镇', 230223103),
(230223104, 230223, '中心镇', 230223104),
(230223200, 230223, '富饶乡', 230223200),
(230223201, 230223, '解放乡', 230223201),
(230223202, 230223, '阳春乡', 230223202),
(230223203, 230223, '新发乡', 230223203),
(230223204, 230223, '太东乡', 230223204),
(230223205, 230223, '上游乡', 230223205),
(230223206, 230223, '红星乡', 230223206),
(230223207, 230223, '先锋乡', 230223207),
(230223208, 230223, '新屯乡', 230223208),
(230223210, 230223, '新兴乡', 230223210),
(230223500, 230223, '依安农场', 230223500),
(230223580, 230223, '黑龙江红旗马场', 230223580),
(230224100, 230224, '泰来镇', 230224100),
(230224101, 230224, '平洋镇', 230224101),
(230224102, 230224, '汤池镇', 230224102),
(230224103, 230224, '江桥蒙古族镇', 230224103),
(230224104, 230224, '塔子城镇', 230224104),
(230224105, 230224, '大兴镇', 230224105),
(230224106, 230224, '和平镇', 230224106),
(230224107, 230224, '克利镇', 230224107),
(230224200, 230224, '胜利蒙古族乡', 230224200),
(230224209, 230224, '宁姜蒙古族乡', 230224209),
(230224400, 230224, '葡萄场', 230224400),
(230224401, 230224, '果树场', 230224401),
(230224402, 230224, '泰来县一苗圃', 230224402),
(230224403, 230224, '泰来县二苗圃', 230224403),
(230224404, 230224, '东方红机械林场', 230224404),
(230224500, 230224, '泰来农场', 230224500),
(230224580, 230224, '第一良种场', 230224580),
(230224581, 230224, '第二良种场', 230224581),
(230224582, 230224, '宏胜种畜场', 230224582),
(230224583, 230224, '二龙涛农场', 230224583),
(230224584, 230224, '六三监狱', 230224584),
(230225100, 230225, '甘南镇', 230225100),
(230225101, 230225, '音河镇', 230225101),
(230225102, 230225, '平阳镇', 230225102),
(230225103, 230225, '东阳镇', 230225103),
(230225104, 230225, '巨宝镇', 230225104),
(230225201, 230225, '长山乡', 230225201),
(230225202, 230225, '中兴乡', 230225202),
(230225203, 230225, '兴隆乡', 230225203),
(230225204, 230225, '宝山乡', 230225204),
(230225206, 230225, '查哈阳乡', 230225206),
(230225500, 230225, '查哈阳农场', 230225500),
(230225580, 230225, '北京市双河农场', 230225580),
(230227100, 230227, '富裕镇', 230227100),
(230227101, 230227, '富路镇', 230227101),
(230227102, 230227, '富海镇', 230227102),
(230227103, 230227, '二道湾镇', 230227103),
(230227104, 230227, '龙安桥镇', 230227104),
(230227200, 230227, '繁荣乡', 230227200),
(230227201, 230227, '绍文乡', 230227201),
(230227202, 230227, '忠厚乡', 230227202),
(230227203, 230227, '友谊乡', 230227203),
(230227204, 230227, '塔哈乡', 230227204),
(230227500, 230227, '富裕牧场', 230227500),
(230227580, 230227, '繁荣种畜场', 230227580),
(230229100, 230229, '克山镇', 230229100),
(230229101, 230229, '北兴镇', 230229101),
(230229102, 230229, '西城镇', 230229102),
(230229103, 230229, '古城镇', 230229103),
(230229104, 230229, '北联镇', 230229104),
(230229105, 230229, '西河镇', 230229105),
(230229200, 230229, '河南乡', 230229200),
(230229201, 230229, '双河乡', 230229201),
(230229203, 230229, '河北乡', 230229203),
(230229204, 230229, '古北乡', 230229204),
(230229205, 230229, '西联乡', 230229205),
(230229206, 230229, '发展乡', 230229206),
(230229207, 230229, '西建乡', 230229207),
(230229208, 230229, '向华乡', 230229208),
(230229210, 230229, '曙光乡', 230229210),
(230229400, 230229, '克山县河北林场', 230229400),
(230229401, 230229, '克山县涌泉林场', 230229401),
(230229402, 230229, '克山县北联林场', 230229402),
(230229500, 230229, '克山农场', 230229500),
(230229580, 230229, '克山县第一良种场', 230229580),
(230229581, 230229, '克山县第二良种场', 230229581),
(230229582, 230229, '克山县种畜场', 230229582),
(230229583, 230229, '克山县种猪场', 230229583),
(230230100, 230230, '克东镇', 230230100),
(230230101, 230230, '宝泉镇', 230230101),
(230230102, 230230, '乾丰镇', 230230102),
(230230103, 230230, '玉岗镇', 230230103),
(230230200, 230230, '金城乡', 230230200),
(230230202, 230230, '润津乡', 230230202),
(230230204, 230230, '昌盛乡', 230230204),
(230230400, 230230, '第一苗圃', 230230400),
(230230401, 230230, '第二苗圃', 230230401),
(230230402, 230230, '爱华林场', 230230402),
(230230403, 230230, '发展林场', 230230403),
(230230404, 230230, '东兴林场', 230230404),
(230230580, 230230, '红旗奶山羊场', 230230580),
(230230581, 230230, '第一良种场', 230230581),
(230230582, 230230, '第二良种繁殖场', 230230582),
(230230583, 230230, '果树繁殖场', 230230583),
(230230584, 230230, '种猪场', 230230584),
(230230585, 230230, '建业农场', 230230585),
(230231100, 230231, '拜泉镇', 230231100),
(230231101, 230231, '三道镇', 230231101),
(230231102, 230231, '兴农镇', 230231102),
(230231103, 230231, '长春镇', 230231103),
(230231104, 230231, '龙泉镇', 230231104),
(230231105, 230231, '国富镇', 230231105),
(230231106, 230231, '富强镇', 230231106),
(230231200, 230231, '新生乡', 230231200),
(230231201, 230231, '兴国乡', 230231201),
(230231203, 230231, '上升乡', 230231203),
(230231204, 230231, '兴华乡', 230231204),
(230231206, 230231, '大众乡', 230231206),
(230231209, 230231, '丰产乡', 230231209),
(230231210, 230231, '永勤乡', 230231210),
(230231212, 230231, '爱农乡', 230231212),
(230231214, 230231, '时中乡', 230231214),
(230281100, 230281, '讷河镇', 230281100),
(230281101, 230281, '拉哈镇', 230281101),
(230281102, 230281, '二克浅镇', 230281102),
(230281103, 230281, '学田镇', 230281103),
(230281104, 230281, '龙河镇', 230281104),
(230281105, 230281, '讷南镇', 230281105),
(230281106, 230281, '六合镇', 230281106),
(230281107, 230281, '长发镇', 230281107),
(230281108, 230281, '通南镇', 230281108),
(230281109, 230281, '同义镇', 230281109),
(230281110, 230281, '九井镇', 230281110),
(230281111, 230281, '老莱镇', 230281111),
(230281201, 230281, '孔国乡', 230281201),
(230281207, 230281, '和盛乡', 230281207),
(230281208, 230281, '同心乡', 230281208),
(230281210, 230281, '兴旺鄂温克族乡', 230281210),
(230281400, 230281, '龙河镇保安林场', 230281400),
(230281401, 230281, '龙河镇茂山林场', 230281401),
(230281402, 230281, '龙河镇国庆林场', 230281402),
(230281403, 230281, '学田镇富源林场', 230281403),
(230281404, 230281, '老莱镇宽余林场', 230281404),
(230281405, 230281, '新江林场', 230281405),
(230281406, 230281, '讷河镇一良苗圃', 230281406),
(230281580, 230281, '黑龙江省老莱监狱', 230281580),
(230281581, 230281, '六合镇黎明奶牛场', 230281581),
(230281582, 230281, '孔国乡进化种猪场', 230281582),
(230281583, 230281, '二克浅镇二里种畜场', 230281583),
(230281584, 230281, '龙河镇青色草原种畜场', 230281584),
(230281585, 230281, '第一良种场', 230281585),
(230281586, 230281, '第二良种场', 230281586),
(230281587, 230281, '第三良种场', 230281587),
(230281588, 230281, '第四良种场', 230281588),
(230302001, 230302, '向阳街道', 230302001),
(230302002, 230302, '南山街道', 230302002),
(230302003, 230302, '立新街道', 230302003),
(230302004, 230302, '东风街道', 230302004),
(230302005, 230302, '红军路街道', 230302005),
(230302006, 230302, '西鸡西街道', 230302006),
(230302007, 230302, '西山街道', 230302007),
(230302200, 230302, '红星乡', 230302200),
(230302201, 230302, '西郊乡', 230302201),
(230303001, 230303, '桦木林街道', 230303001),
(230303002, 230303, '大恒山街道', 230303002),
(230303003, 230303, '小恒山街道', 230303003),
(230303004, 230303, '二道河子街道', 230303004),
(230303005, 230303, '张新街道', 230303005),
(230303006, 230303, '奋斗街道', 230303006),
(230303007, 230303, '柳毛街道', 230303007),
(230303200, 230303, '红旗乡', 230303200),
(230303201, 230303, '柳毛乡', 230303201),
(230304001, 230304, '东兴街道', 230304001),
(230304002, 230304, '矿里街道', 230304002),
(230304003, 230304, '洗煤街道', 230304003),
(230304004, 230304, '大通沟街道', 230304004),
(230304200, 230304, '滴道河乡', 230304200),
(230304201, 230304, '兰岭乡', 230304201),
(230305001, 230305, '街里街道', 230305001),
(230305002, 230305, '穆棱街道', 230305002),
(230305003, 230305, '平岗街道', 230305003),
(230305004, 230305, '碱场街道', 230305004),
(230305005, 230305, '石磷街道', 230305005),
(230305198, 230305, '梨树区直辖地域', 230305198),
(230306001, 230306, '城子河街道', 230306001),
(230306002, 230306, '正阳街道', 230306002),
(230306003, 230306, '东海街道', 230306003),
(230306004, 230306, '城西街道', 230306004),
(230306005, 230306, '杏花街道', 230306005),
(230306200, 230306, '长青乡', 230306200),
(230306201, 230306, '永丰乡', 230306201),
(230307001, 230307, '麻山街道', 230307001),
(230307198, 230307, '麻山区直辖地域', 230307198),
(230321100, 230321, '鸡东镇', 230321100),
(230321101, 230321, '平阳镇', 230321101),
(230321102, 230321, '向阳镇', 230321102),
(230321103, 230321, '哈达镇', 230321103),
(230321104, 230321, '永安镇', 230321104),
(230321105, 230321, '永和镇', 230321105),
(230321106, 230321, '东海镇', 230321106),
(230321107, 230321, '兴农镇', 230321107),
(230321200, 230321, '鸡林乡', 230321200),
(230321205, 230321, '明德乡', 230321205),
(230321206, 230321, '下亮子乡', 230321206),
(230321400, 230321, '林业局', 230321400),
(230321500, 230321, '八五一零农场', 230321500),
(230381100, 230381, '虎林镇', 230381100),
(230381101, 230381, '东方红镇', 230381101),
(230381102, 230381, '迎春镇', 230381102),
(230381103, 230381, '虎头镇', 230381103),
(230381104, 230381, '杨岗镇', 230381104),
(230381105, 230381, '东风镇', 230381105),
(230381106, 230381, '宝东镇', 230381106),
(230381203, 230381, '新乐乡', 230381203),
(230381204, 230381, '伟光乡', 230381204),
(230381205, 230381, '忠诚乡', 230381205),
(230381206, 230381, '珍宝岛乡', 230381206),
(230381207, 230381, '阿北乡', 230381207),
(230381400, 230381, '东方红林业局', 230381400),
(230381401, 230381, '迎春林业局', 230381401),
(230381500, 230381, '八五零农场', 230381500),
(230381501, 230381, '八五四农场', 230381501),
(230381502, 230381, '八五六农场', 230381502),
(230381503, 230381, '八五八农场', 230381503),
(230381504, 230381, '庆丰农场', 230381504),
(230381505, 230381, '云山农场', 230381505),
(230382001, 230382, '中心街道', 230382001),
(230382100, 230382, '密山镇', 230382100),
(230382101, 230382, '连珠山镇', 230382101),
(230382102, 230382, '当壁镇', 230382102),
(230382103, 230382, '知一镇', 230382103),
(230382104, 230382, '黑台镇', 230382104),
(230382105, 230382, '兴凯镇', 230382105),
(230382106, 230382, '裴德镇', 230382106),
(230382200, 230382, '柳毛乡', 230382200),
(230382201, 230382, '杨木乡', 230382201),
(230382202, 230382, '兴凯湖乡', 230382202),
(230382203, 230382, '承紫河乡', 230382203),
(230382204, 230382, '白泡子乡', 230382204),
(230382206, 230382, '二人班乡', 230382206),
(230382208, 230382, '太平乡', 230382208),
(230382210, 230382, '和平乡', 230382210),
(230382212, 230382, '富源乡', 230382212),
(230382501, 230382, '牡丹江分局局直', 230382501),
(230382502, 230382, '八五五农场', 230382502),
(230382503, 230382, '八五七农场', 230382503),
(230382504, 230382, '八五一一农场', 230382504),
(230382505, 230382, '兴凯湖农场', 230382505),
(230402001, 230402, '北山街道', 230402001),
(230402002, 230402, '红军街道', 230402002),
(230402003, 230402, '光明街道', 230402003),
(230402004, 230402, '胜利街道', 230402004),
(230402005, 230402, '南翼街道', 230402005),
(230403001, 230403, '育才街道', 230403001),
(230403002, 230403, '红旗街道', 230403002),
(230403003, 230403, '新南街道', 230403003),
(230403004, 230403, '湖滨街道', 230403004),
(230403005, 230403, '解放街道', 230403005),
(230403006, 230403, '团结街道', 230403006),
(230404001, 230404, '铁西街道', 230404001),
(230404002, 230404, '铁东街道', 230404002),
(230404003, 230404, '六号街道', 230404003),
(230404004, 230404, '大陆街道', 230404004),
(230404005, 230404, '富力街道', 230404005),
(230404006, 230404, '麓林山街道', 230404006),
(230405001, 230405, '兴安路街道', 230405001),
(230405002, 230405, '兴建路街道', 230405002),
(230405003, 230405, '兴长路街道', 230405003),
(230405004, 230405, '峻德路街道', 230405004),
(230405005, 230405, '河东路街道', 230405005),
(230406001, 230406, '工人村街道', 230406001),
(230406002, 230406, '新一街道', 230406002),
(230406003, 230406, '三街街道', 230406003),
(230406004, 230406, '东山街道', 230406004),
(230406100, 230406, '新华镇', 230406100),
(230406200, 230406, '红旗乡', 230406200),
(230406201, 230406, '蔬园乡', 230406201),
(230406202, 230406, '东方红乡', 230406202),
(230406400, 230406, '鹤岗市林业局', 230406400),
(230406500, 230406, '新华农场', 230406500),
(230407001, 230407, '岭北街道', 230407001),
(230407002, 230407, '岭南街道', 230407002),
(230407003, 230407, '沟北街道', 230407003),
(230407004, 230407, '沟南街道', 230407004),
(230421100, 230421, '凤翔镇', 230421100),
(230421101, 230421, '鹤北镇', 230421101),
(230421102, 230421, '名山镇', 230421102),
(230421103, 230421, '团结镇', 230421103),
(230421104, 230421, '肇兴镇', 230421104),
(230421200, 230421, '东明朝鲜族乡', 230421200),
(230421203, 230421, '太平沟乡', 230421203),
(230421204, 230421, '环山乡', 230421204),
(230421401, 230421, '鹤北林业局', 230421401),
(230421500, 230421, '宝泉岭分局局直', 230421500),
(230421501, 230421, '江滨农场', 230421501),
(230421502, 230421, '军川农场', 230421502),
(230421503, 230421, '名山农场', 230421503),
(230421504, 230421, '延军农场', 230421504),
(230421505, 230421, '共青农场', 230421505),
(230421506, 230421, '宝泉岭农场', 230421506),
(230422100, 230422, '绥滨镇', 230422100),
(230422101, 230422, '绥东镇', 230422101),
(230422102, 230422, '忠仁镇', 230422102),
(230422200, 230422, '连生乡', 230422200),
(230422201, 230422, '北岗乡', 230422201),
(230422202, 230422, '富强乡', 230422202),
(230422203, 230422, '北山乡', 230422203),
(230422204, 230422, '福兴乡', 230422204),
(230422205, 230422, '新富乡', 230422205),
(230422500, 230422, '二九０农场', 230422500),
(230422501, 230422, '绥滨农场', 230422501),
(230422503, 230422, '普阳农场', 230422503),
(230502001, 230502, '二马路街道', 230502001),
(230502002, 230502, '八马路街道', 230502002),
(230502003, 230502, '中心站街道', 230502003),
(230502004, 230502, '富安街道', 230502004),
(230502005, 230502, '窑地街道', 230502005),
(230502006, 230502, '长安街道', 230502006),
(230502007, 230502, '铁西街道', 230502007),
(230502200, 230502, '安邦乡', 230502200),
(230503001, 230503, '中山街道', 230503001),
(230503002, 230503, '北山街道', 230503002),
(230503003, 230503, '南山街道', 230503003),
(230503004, 230503, '东山街道', 230503004),
(230503005, 230503, '中心街道', 230503005),
(230503006, 230503, '西山街道', 230503006),
(230503200, 230503, '长胜乡', 230503200),
(230503400, 230503, '岭东区青山旅游公司', 230503400),
(230503401, 230503, '岭东区岭东经营所', 230503401),
(230505001, 230505, '振兴中路街道', 230505001),
(230505002, 230505, '振兴东路街道', 230505002),
(230505004, 230505, '集贤街道', 230505004),
(230505005, 230505, '东荣街道', 230505005),
(230505101, 230505, '太保镇', 230505101),
(230506001, 230506, '红旗街道', 230506001),
(230506002, 230506, '跃进街道', 230506002),
(230506003, 230506, '东保卫街道', 230506003),
(230506004, 230506, '七星街道', 230506004),
(230506005, 230506, '双阳街道', 230506005),
(230506006, 230506, '新安街道', 230506006),
(230506007, 230506, '电厂街道', 230506007),
(230506101, 230506, '七星镇', 230506101),
(230506401, 230506, '双鸭山林业局宝山经营所', 230506401),
(230506402, 230506, '双鸭山林业局大叶沟林场', 230506402),
(230506500, 230506, '双鸭山农场', 230506500),
(230521100, 230521, '福利镇', 230521100),
(230521101, 230521, '集贤镇', 230521101),
(230521102, 230521, '升昌镇', 230521102),
(230521103, 230521, '丰乐镇', 230521103),
(230521104, 230521, '太平镇', 230521104),
(230521201, 230521, '腰屯乡', 230521201),
(230521202, 230521, '兴安乡', 230521202),
(230521204, 230521, '永安乡', 230521204),
(230521401, 230521, '太平林场', 230521401),
(230521402, 230521, '丰乐林场', 230521402),
(230521403, 230521, '七星林场', 230521403),
(230521404, 230521, '峻山林场', 230521404),
(230521405, 230521, '爱林林场', 230521405),
(230521406, 230521, '腰屯林场', 230521406),
(230521407, 230521, '升平煤矿', 230521407),
(230521500, 230521, '二九一农场', 230521500),
(230521501, 230521, '良种场', 230521501),
(230521502, 230521, '种畜场', 230521502),
(230521503, 230521, '果树示范场', 230521503),
(230521580, 230521, '黑龙江省笔架山监狱', 230521580),
(230522100, 230522, '友谊镇', 230522100),
(230522101, 230522, '兴隆镇', 230522101),
(230522102, 230522, '龙山镇', 230522102),
(230522103, 230522, '凤岗镇', 230522103),
(230522200, 230522, '兴盛乡', 230522200),
(230522201, 230522, '东建乡', 230522201),
(230522202, 230522, '庆丰乡', 230522202),
(230522203, 230522, '建设乡', 230522203),
(230522204, 230522, '友邻乡', 230522204),
(230522205, 230522, '新镇乡', 230522205),
(230522206, 230522, '成富朝鲜族满族乡', 230522206),
(230522501, 230522, '红兴隆分局局直', 230522501),
(230522502, 230522, '友谊农场', 230522502),
(230523100, 230523, '宝清镇', 230523100),
(230523101, 230523, '七星泡镇', 230523101),
(230523102, 230523, '青原镇', 230523102),
(230523103, 230523, '夹信子镇', 230523103),
(230523104, 230523, '龙头镇', 230523104),
(230523105, 230523, '小城子镇', 230523105),
(230523202, 230523, '朝阳乡', 230523202),
(230523203, 230523, '万金山乡', 230523203),
(230523204, 230523, '尖山子乡', 230523204),
(230523209, 230523, '七星河乡', 230523209),
(230523400, 230523, '双鸭山林业局上游经营所', 230523400),
(230523401, 230523, '双鸭山林业局南瓮泉经营所', 230523401),
(230523402, 230523, '双鸭山林业局七一林场', 230523402),
(230523403, 230523, '双鸭山林业局七星河林场', 230523403),
(230523404, 230523, '双鸭山林业局红旗林场', 230523404),
(230523405, 230523, '双鸭山林业局三岔河林场', 230523405),
(230523406, 230523, '双鸭山林业局青龙林场', 230523406),
(230523407, 230523, '双鸭山林业局宝石经营所', 230523407),
(230523408, 230523, '双鸭山林业局七星河金矿', 230523408),
(230523500, 230523, '五九七农场', 230523500),
(230523501, 230523, '八五二农场', 230523501),
(230523502, 230523, '八五三农场', 230523502),
(230524100, 230524, '饶河镇', 230524100),
(230524101, 230524, '小佳河镇', 230524101),
(230524102, 230524, '西丰镇', 230524102),
(230524103, 230524, '五林洞镇', 230524103),
(230524200, 230524, '西林子乡', 230524200),
(230524201, 230524, '四排乡', 230524201),
(230524203, 230524, '大佳河乡', 230524203),
(230524204, 230524, '山里乡', 230524204),
(230524207, 230524, '大通河乡', 230524207),
(230524400, 230524, '小佳河林场', 230524400),
(230524401, 230524, '威山林场', 230524401),
(230524402, 230524, '西丰林场', 230524402),
(230524403, 230524, '大牙克林场', 230524403),
(230524404, 230524, '石场林场', 230524404),
(230524405, 230524, '宝马山林场', 230524405),
(230524406, 230524, '大岱林场', 230524406),
(230524407, 230524, '永幸林场', 230524407),
(230524408, 230524, '奇源林场', 230524408),
(230524409, 230524, '芦源林场', 230524409),
(230524410, 230524, '五林洞林场', 230524410),
(230524500, 230524, '饶河农场', 230524500),
(230524501, 230524, '红旗岭农场', 230524501),
(230524502, 230524, '八五九农场', 230524502),
(230524503, 230524, '胜利农场', 230524503),
(230524504, 230524, '红卫农场', 230524504),
(230602001, 230602, '萨尔图街道', 230602001),
(230602005, 230602, '铁人街道', 230602005),
(230602006, 230602, '友谊街道', 230602006),
(230602007, 230602, '富强街道', 230602007),
(230602008, 230602, '拥军街道', 230602008),
(230602009, 230602, '会战街道', 230602009),
(230602010, 230602, '火炬街道', 230602010),
(230602011, 230602, '东风街道', 230602011),
(230602012, 230602, '东安街道', 230602012),
(230603001, 230603, '龙凤街道', 230603001),
(230603002, 230603, '兴化街道', 230603002),
(230603007, 230603, '卧里屯街道', 230603007),
(230603008, 230603, '东光街道', 230603008),
(230603009, 230603, '三永街道', 230603009),
(230603010, 230603, '开发区黎明街道', 230603010),
(230603100, 230603, '龙凤镇', 230603100),
(230603580, 230603, '高新区农场', 230603580),
(230604001, 230604, '龙岗街道', 230604001),
(230604002, 230604, '银浪街道', 230604002),
(230604004, 230604, '奋斗街道', 230604004),
(230604005, 230604, '庆新街道', 230604005),
(230604007, 230604, '西宾街道', 230604007),
(230604009, 230604, '乘风街道', 230604009),
(230604101, 230604, '喇嘛甸镇', 230604101),
(230604580, 230604, '红骥牧场', 230604580),
(230604581, 230604, '星火牧场', 230604581),
(230604582, 230604, '银浪牧场', 230604582),
(230605001, 230605, '红岗街道', 230605001),
(230605004, 230605, '八百垧街道', 230605004),
(230605005, 230605, '杏南街道', 230605005),
(230605006, 230605, '解放街道', 230605006),
(230605007, 230605, '创业街道', 230605007),
(230605100, 230605, '杏树岗镇', 230605100),
(230606001, 230606, '庆葡街道', 230606001),
(230606002, 230606, '高台子镇街道', 230606002),
(230606004, 230606, '林源镇街道', 230606004),
(230606005, 230606, '立志街道', 230606005),
(230606006, 230606, '新华街道', 230606006),
(230606007, 230606, '大同镇街道', 230606007),
(230606100, 230606, '大同镇', 230606100),
(230606101, 230606, '高台子镇', 230606101),
(230606102, 230606, '太阳升镇', 230606102),
(230606103, 230606, '林源镇', 230606103),
(230606200, 230606, '祝三乡', 230606200),
(230606203, 230606, '老山头乡', 230606203),
(230606205, 230606, '八井子乡', 230606205),
(230606206, 230606, '双榆树乡', 230606206),
(230606500, 230606, '和平牧场', 230606500),
(230621100, 230621, '肇州镇', 230621100),
(230621101, 230621, '永乐镇', 230621101),
(230621102, 230621, '丰乐镇', 230621102),
(230621103, 230621, '朝阳沟镇', 230621103),
(230621104, 230621, '兴城镇', 230621104),
(230621105, 230621, '二井镇', 230621105),
(230621202, 230621, '双发乡', 230621202),
(230621203, 230621, '托古乡', 230621203),
(230621205, 230621, '朝阳乡', 230621205),
(230621206, 230621, '永胜乡', 230621206),
(230621208, 230621, '榆树乡', 230621208),
(230621211, 230621, '新福乡', 230621211),
(230621580, 230621, '乐园良种场', 230621580),
(230621581, 230621, '卫星种畜场', 230621581),
(230622100, 230622, '肇源镇', 230622100),
(230622101, 230622, '三站镇', 230622101),
(230622102, 230622, '二站镇', 230622102),
(230622103, 230622, '茂兴镇', 230622103),
(230622104, 230622, '古龙镇', 230622104),
(230622105, 230622, '新站镇', 230622105),
(230622106, 230622, '头台镇', 230622106),
(230622200, 230622, '福兴乡', 230622200),
(230622201, 230622, '薄荷台乡', 230622201),
(230622203, 230622, '和平乡', 230622203),
(230622206, 230622, '古恰乡', 230622206),
(230622207, 230622, '超等乡', 230622207),
(230622208, 230622, '民意乡', 230622208),
(230622210, 230622, '义顺乡', 230622210),
(230622211, 230622, '浩德乡', 230622211),
(230622212, 230622, '大兴乡', 230622212),
(230622500, 230622, '肇源农场', 230622500),
(230622581, 230622, '种畜场', 230622581),
(230622582, 230622, '茂兴湖渔场', 230622582),
(230622583, 230622, '新立良种繁育场', 230622583),
(230622584, 230622, '立陡山良种场', 230622584),
(230622585, 230622, '八家河渔场', 230622585),
(230622586, 230622, '果树示范场', 230622586),
(230622587, 230622, '经济作物示范场', 230622587),
(230623100, 230623, '林甸镇', 230623100),
(230623101, 230623, '红旗镇', 230623101),
(230623200, 230623, '东兴乡', 230623200),
(230623201, 230623, '宏伟乡', 230623201),
(230623202, 230623, '三合乡', 230623202),
(230623203, 230623, '花园乡', 230623203),
(230623204, 230623, '四合乡', 230623204),
(230623205, 230623, '黎明乡', 230623205),
(230623400, 230623, '林甸县长青林场', 230623400),
(230623500, 230623, '巨浪牧场', 230623500),
(230623581, 230623, '黑龙江省林甸县国营苇场', 230623581),
(230623582, 230623, '林甸县新兴马场', 230623582),
(230624100, 230624, '泰康镇', 230624100),
(230624101, 230624, '胡吉吐莫镇', 230624101),
(230624102, 230624, '烟筒屯镇', 230624102),
(230624103, 230624, '他拉哈镇', 230624103),
(230624200, 230624, '一心乡', 230624200),
(230624201, 230624, '克尔台乡', 230624201),
(230624202, 230624, '白音诺勒乡', 230624202),
(230624203, 230624, '敖林西伯乡', 230624203),
(230624204, 230624, '巴彦查干乡', 230624204),
(230624205, 230624, '腰新乡', 230624205),
(230624206, 230624, '江湾乡', 230624206),
(230624500, 230624, '绿色草原牧场', 230624500),
(230624581, 230624, '黑龙江省大山种羊场', 230624581),
(230624582, 230624, '靠山种畜场', 230624582),
(230624583, 230624, '对山奶牛场', 230624583),
(230624584, 230624, '红旗种畜场', 230624584),
(230624585, 230624, '连环湖渔业有限公司', 230624585),
(230624586, 230624, '石人沟渔业有限公司', 230624586),
(230624587, 230624, '齐家泡渔业有限公司', 230624587),
(230624588, 230624, '四家子林场', 230624588),
(230624589, 230624, '新店林场', 230624589),
(230624590, 230624, '野生饲养场', 230624590),
(230624591, 230624, '第一良种场', 230624591),
(230624592, 230624, '一心苗圃', 230624592),
(230624593, 230624, '一心果树场', 230624593),
(230702001, 230702, '旭日街道', 230702001),
(230702004, 230702, '红升街道', 230702004),
(230702006, 230702, '前进街道', 230702006),
(230702007, 230702, '朝阳街道', 230702007),
(230702008, 230702, '东升街道', 230702008),
(230703002, 230703, '西水街道', 230703002),
(230703004, 230703, '联合街道', 230703004),
(230703005, 230703, '东升街道', 230703005),
(230703101, 230703, '晨明镇', 230703101),
(230703102, 230703, '浩良河镇', 230703102),
(230703200, 230703, '迎春乡', 230703200),
(230703400, 230703, '三岔河林场', 230703400),
(230703401, 230703, '四合营林场', 230703401),
(230703402, 230703, '亮子河林场', 230703402),
(230703403, 230703, '石头河林场', 230703403),
(230703405, 230703, '岩石经营所', 230703405),
(230703406, 230703, '奋斗经营所', 230703406),
(230703407, 230703, '桦阳经营所', 230703407),
(230703408, 230703, '浩良河经营所', 230703408),
(230703409, 230703, '太平经营所', 230703409),
(230703410, 230703, '南岔经营所', 230703410),
(230703411, 230703, '威岭经营所', 230703411),
(230703413, 230703, '松青经营所', 230703413),
(230703414, 230703, '柳树经营所', 230703414),
(230704001, 230704, '友好街道', 230704001),
(230704003, 230704, '双子河街道', 230704003),
(230704004, 230704, '铁林街道', 230704004),
(230704400, 230704, '三合经营所', 230704400),
(230704401, 230704, '松园林场', 230704401),
(230704402, 230704, '中心经营所', 230704402),
(230704403, 230704, '永青经营所', 230704403),
(230704404, 230704, '碧云经营所', 230704404),
(230704405, 230704, '友谊经营所', 230704405),
(230704406, 230704, '青杨经营所', 230704406),
(230704407, 230704, '岭峰林场', 230704407),
(230704408, 230704, '奋斗林场', 230704408),
(230704409, 230704, '东卡林场', 230704409),
(230704410, 230704, '鸡爪河林场', 230704410),
(230704411, 230704, '绿源林场', 230704411),
(230704412, 230704, '广川经营所', 230704412),
(230704413, 230704, '朝阳经营所', 230704413),
(230705001, 230705, '西林街道', 230705001),
(230705003, 230705, '新兴街道', 230705003),
(230705005, 230705, '苔青街道', 230705005),
(230706001, 230706, '向阳街道', 230706001),
(230706002, 230706, '曙光街道', 230706002),
(230706400, 230706, '解放经营所', 230706400),
(230706401, 230706, '昆仑气林场', 230706401),
(230706402, 230706, '开源河林场', 230706402),
(230706403, 230706, '么河经营所', 230706403),
(230706404, 230706, '冲锋经营所', 230706404),
(230706405, 230706, '翠峦河经营所', 230706405),
(230706406, 230706, '抚育河经营所', 230706406),
(230706407, 230706, '尖山河经营所', 230706407),
(230707001, 230707, '新青街道', 230707001),
(230707003, 230707, '兴安街道', 230707003),
(230707400, 230707, '红林经营所', 230707400),
(230707401, 230707, '松林林场', 230707401),
(230707402, 230707, '泉林林场', 230707402),
(230707404, 230707, '水源林场', 230707404),
(230707405, 230707, '笑山林场', 230707405),
(230707406, 230707, '汤林林场', 230707406),
(230707407, 230707, '桦林经营所', 230707407),
(230707408, 230707, '青林林场', 230707408),
(230707409, 230707, '结源林场', 230707409),
(230707410, 230707, '北沟林场', 230707410),
(230707411, 230707, '南沟林场', 230707411),
(230707412, 230707, '乌拉嘎经营所', 230707412),
(230707413, 230707, '柳树河林场', 230707413),
(230707414, 230707, '北影林场', 230707414),
(230708001, 230708, '美溪街道', 230708001),
(230708400, 230708, '大西林林场', 230708400),
(230708401, 230708, '五道库经营所', 230708401),
(230708402, 230708, '缓岭经营所', 230708402),
(230708403, 230708, '对青山经营所', 230708403),
(230708404, 230708, '群峦经营所', 230708404),
(230708405, 230708, '兰新经营所', 230708405),
(230708406, 230708, '顺利河林场', 230708406),
(230708407, 230708, '松岭经营所', 230708407),
(230708408, 230708, '青山口林场', 230708408),
(230708409, 230708, '金沙河林场', 230708409),
(230708410, 230708, '桦皮羌子林场', 230708410),
(230708411, 230708, '碧仓库林场', 230708411),
(230708412, 230708, '三股流经营所', 230708412),
(230708413, 230708, '卧龙河林场', 230708413),
(230709002, 230709, '奋斗街道', 230709002),
(230709003, 230709, '金山街道', 230709003),
(230709401, 230709, '白山林场', 230709401),
(230709402, 230709, '丰岭林场', 230709402),
(230709403, 230709, '丰林林场', 230709403),
(230709404, 230709, '丰沟经营所', 230709404),
(230709405, 230709, '丰茂林场', 230709405),
(230709406, 230709, '横山经营所', 230709406),
(230709407, 230709, '丰丽林场', 230709407),
(230709408, 230709, '大昆仑经营所', 230709408),
(230709409, 230709, '小昆仑林场', 230709409),
(230709410, 230709, '育林经营所', 230709410),
(230710001, 230710, '五营街道', 230710001),
(230710011, 230710, '五星街道', 230710011),
(230710400, 230710, '翠北林场', 230710400),
(230710401, 230710, '前丰林场', 230710401),
(230710402, 230710, '永丰经营所', 230710402),
(230710403, 230710, '平原经营所', 230710403),
(230710404, 230710, '丽丰经营所', 230710404),
(230710405, 230710, '杨树河经营所', 230710405),
(230710406, 230710, '平山经营所', 230710406),
(230710407, 230710, '丽林经营所', 230710407),
(230711001, 230711, '乌马河街道', 230711001),
(230711400, 230711, '伊敏林场', 230711400),
(230711401, 230711, '伊东经营所', 230711401),
(230711402, 230711, '东方红经营所', 230711402),
(230711403, 230711, '翠岭经营所', 230711403),
(230711404, 230711, '河北经营所', 230711404),
(230711405, 230711, '青山林场', 230711405),
(230711406, 230711, '育苗经营所', 230711406),
(230711407, 230711, '安全经营所', 230711407),
(230711408, 230711, '伊青经营所', 230711408),
(230711409, 230711, '前进经营所', 230711409),
(230711410, 230711, '西岭林场', 230711410),
(230711411, 230711, '伊林经营所', 230711411),
(230712001, 230712, '河南街道', 230712001),
(230712002, 230712, '河北街道', 230712002),
(230712400, 230712, '日新林场', 230712400),
(230712401, 230712, '石林林场', 230712401),
(230712402, 230712, '东升林场', 230712402),
(230712403, 230712, '二龙山林场', 230712403),
(230712404, 230712, '高峰林场', 230712404),
(230712405, 230712, '二清河林场', 230712405),
(230712406, 230712, '守虎山林场', 230712406),
(230712407, 230712, '泉石林场', 230712407),
(230712408, 230712, '峻岭林场', 230712408),
(230712409, 230712, '育林经营所', 230712409),
(230712410, 230712, '团结经营所', 230712410),
(230712411, 230712, '磨石山经营所', 230712411),
(230712412, 230712, '中心苗卜', 230712412),
(230712413, 230712, '克林经营所', 230712413),
(230713001, 230713, '带岭街道', 230713001),
(230713400, 230713, '大青川林场', 230713400),
(230713401, 230713, '东方红林场', 230713401),
(230713402, 230713, '秀水林场', 230713402),
(230713403, 230713, '永翠林场', 230713403),
(230713404, 230713, '明月林场', 230713404),
(230713405, 230713, '红光林场', 230713405),
(230713406, 230713, '碧水林场', 230713406),
(230713407, 230713, '北列林场', 230713407),
(230713408, 230713, '南列林场', 230713408),
(230713409, 230713, '寒月林场', 230713409),
(230713410, 230713, '环山林场', 230713410),
(230714001, 230714, '乌伊岭街道', 230714001),
(230714400, 230714, '上游林场', 230714400),
(230714401, 230714, '美峰林场', 230714401),
(230714402, 230714, '翠峰林场', 230714402),
(230714403, 230714, '建新林场', 230714403),
(230714404, 230714, '移山林场', 230714404),
(230714405, 230714, '林海林场', 230714405),
(230714406, 230714, '桔源林场', 230714406),
(230714407, 230714, '东克林林场', 230714407),
(230714408, 230714, '福民林场', 230714408),
(230714409, 230714, '阿廷河林场', 230714409),
(230714410, 230714, '永胜经营所', 230714410),
(230714411, 230714, '前卫林场', 230714411),
(230715001, 230715, '红星街道', 230715001),
(230715400, 230715, '清水河经营所', 230715400),
(230715401, 230715, '五星河经营所', 230715401),
(230715402, 230715, '汤洪岭林场', 230715402),
(230715403, 230715, '汤北林场', 230715403),
(230715404, 230715, '霍吉河林场', 230715404),
(230715405, 230715, '二杨经营所', 230715405),
(230715406, 230715, '三杨林场', 230715406),
(230715407, 230715, '汤南林场', 230715407),
(230715408, 230715, '共青经营所', 230715408),
(230715409, 230715, '库斯特林场', 230715409),
(230715410, 230715, '二皮河经营所', 230715410),
(230716001, 230716, '红山街道', 230716001),
(230716400, 230716, '山峰林场', 230716400),
(230716401, 230716, '阳光林场', 230716401),
(230716402, 230716, '新风林场', 230716402),
(230716403, 230716, '卫国林场', 230716403),
(230716404, 230716, '查山经营所', 230716404),
(230716405, 230716, '长青经营所', 230716405),
(230716406, 230716, '青山农场', 230716406),
(230716407, 230716, '溪水经营所', 230716407),
(230716408, 230716, '蔚兰经营所', 230716408),
(230716409, 230716, '永绪经营所', 230716409),
(230716410, 230716, '美林经营所', 230716410),
(230716411, 230716, '红山经营所', 230716411),
(230722100, 230722, '朝阳镇', 230722100),
(230722101, 230722, '乌云镇', 230722101),
(230722102, 230722, '乌拉嘎镇', 230722102),
(230722200, 230722, '常胜乡', 230722200),
(230722201, 230722, '向阳乡', 230722201),
(230722202, 230722, '沪嘉乡', 230722202),
(230722203, 230722, '红光乡', 230722203),
(230722204, 230722, '保兴乡', 230722204),
(230722205, 230722, '青山乡', 230722205),
(230722400, 230722, '太平林场', 230722400),
(230722401, 230722, '红旗林场', 230722401),
(230722402, 230722, '清河林场', 230722402),
(230722403, 230722, '连江林场', 230722403),
(230722404, 230722, '马连林场', 230722404),
(230722500, 230722, '嘉荫农场', 230722500),
(230781100, 230781, '铁力镇', 230781100),
(230781101, 230781, '双丰镇', 230781101),
(230781102, 230781, '桃山镇', 230781102),
(230781104, 230781, '朗乡镇', 230781104),
(230781200, 230781, '年丰乡', 230781200),
(230781201, 230781, '工农乡', 230781201),
(230781202, 230781, '王杨乡', 230781202),
(230781400, 230781, '铁力林业局', 230781400),
(230781401, 230781, '双丰林业局', 230781401),
(230781402, 230781, '桃山林业局', 230781402),
(230781403, 230781, '朗乡林业局', 230781403),
(230781500, 230781, '铁力农场', 230781500),
(230803001, 230803, '西林街道', 230803001),
(230803002, 230803, '保卫街道', 230803002),
(230803003, 230803, '桥南街道', 230803003),
(230803004, 230803, '西南岗街道', 230803004),
(230803005, 230803, '建设街道', 230803005),
(230803006, 230803, '长安街道', 230803006),
(230803198, 230803, '向阳区直辖地域', 230803198),
(230804001, 230804, '站前街道', 230804001),
(230804002, 230804, '永安街道', 230804002),
(230804003, 230804, '奋斗街道', 230804003),
(230804004, 230804, '南岗街道', 230804004),
(230804005, 230804, '亮子河街道', 230804005),
(230804006, 230804, '田园街道', 230804006),
(230805001, 230805, '晓云街道', 230805001),
(230805002, 230805, '佳东街道', 230805002),
(230805003, 230805, '造纸街道', 230805003),
(230805004, 230805, '佳南街道', 230805004),
(230805005, 230805, '建国街道', 230805005),
(230805200, 230805, '松江乡', 230805200);
INSERT INTO `{pre}areas` VALUES
(230805201, 230805, '建国乡', 230805201),
(230811001, 230811, '佳西街道', 230811001),
(230811002, 230811, '友谊街道', 230811002),
(230811101, 230811, '大来镇', 230811101),
(230811102, 230811, '敖其镇', 230811102),
(230811103, 230811, '望江镇', 230811103),
(230811104, 230811, '长发镇', 230811104),
(230811105, 230811, '莲江口镇', 230811105),
(230811200, 230811, '长青乡', 230811200),
(230811201, 230811, '沿江乡', 230811201),
(230811202, 230811, '西格木乡', 230811202),
(230811208, 230811, '平安乡', 230811208),
(230811210, 230811, '四丰乡', 230811210),
(230811211, 230811, '群胜乡', 230811211),
(230811580, 230811, '莲江口监狱', 230811580),
(230822103, 230822, '驼腰子镇', 230822103),
(230822104, 230822, '石头河子镇', 230822104),
(230822106, 230822, '桦南镇', 230822106),
(230822107, 230822, '土龙山镇', 230822107),
(230822108, 230822, '孟家岗镇', 230822108),
(230822109, 230822, '闫家镇', 230822109),
(230822205, 230822, '金沙乡', 230822205),
(230822213, 230822, '梨树乡', 230822213),
(230822214, 230822, '明义乡', 230822214),
(230822215, 230822, '大八浪乡', 230822215),
(230822400, 230822, '桦南林业局', 230822400),
(230822500, 230822, '曙光农场', 230822500),
(230822580, 230822, '桦南种畜场', 230822580),
(230826101, 230826, '横头山镇', 230826101),
(230826103, 230826, '苏家店镇', 230826103),
(230826104, 230826, '悦来镇', 230826104),
(230826105, 230826, '新城镇', 230826105),
(230826201, 230826, '东河乡', 230826201),
(230826202, 230826, '梨丰乡', 230826202),
(230826205, 230826, '创业乡', 230826205),
(230826207, 230826, '星火乡', 230826207),
(230826208, 230826, '四马架乡', 230826208),
(230826500, 230826, '江川农场', 230826500),
(230826501, 230826, '宝山农场', 230826501),
(230828101, 230828, '香兰镇', 230828101),
(230828102, 230828, '鹤立镇', 230828102),
(230828103, 230828, '竹帘镇', 230828103),
(230828104, 230828, '汤原镇', 230828104),
(230828201, 230828, '汤旺乡', 230828201),
(230828203, 230828, '胜利乡', 230828203),
(230828208, 230828, '吉祥乡', 230828208),
(230828209, 230828, '振兴乡', 230828209),
(230828210, 230828, '太平川乡', 230828210),
(230828211, 230828, '永发乡', 230828211),
(230828400, 230828, '鹤立林业局', 230828400),
(230828401, 230828, '香兰监狱', 230828401),
(230828500, 230828, '汤原农场', 230828500),
(230828501, 230828, '梧桐河农场', 230828501),
(230833100, 230833, '抚远镇', 230833100),
(230833101, 230833, '寒葱沟镇', 230833101),
(230833102, 230833, '浓桥镇', 230833102),
(230833103, 230833, '抓吉镇', 230833103),
(230833200, 230833, '通江乡', 230833200),
(230833201, 230833, '浓江乡', 230833201),
(230833202, 230833, '海青乡', 230833202),
(230833203, 230833, '别拉洪乡', 230833203),
(230833204, 230833, '鸭南乡', 230833204),
(230833500, 230833, '前哨农场', 230833500),
(230833501, 230833, '前锋农场', 230833501),
(230833502, 230833, '二道河农场', 230833502),
(230881003, 230881, '杏林街道', 230881003),
(230881004, 230881, '和兴街道', 230881004),
(230881005, 230881, '安康街道', 230881005),
(230881006, 230881, '幸福街道', 230881006),
(230881100, 230881, '同江镇', 230881100),
(230881101, 230881, '乐业镇', 230881101),
(230881102, 230881, '三村镇', 230881102),
(230881103, 230881, '临江镇', 230881103),
(230881201, 230881, '向阳乡', 230881201),
(230881203, 230881, '青河乡', 230881203),
(230881204, 230881, '街津口乡', 230881204),
(230881205, 230881, '八岔乡', 230881205),
(230881206, 230881, '金川乡', 230881206),
(230881207, 230881, '银川乡', 230881207),
(230881400, 230881, '街津口林场', 230881400),
(230881401, 230881, '鸭北林场', 230881401),
(230881500, 230881, '勤得利农场', 230881500),
(230881501, 230881, '青龙山农场', 230881501),
(230881502, 230881, '前进农场', 230881502),
(230881503, 230881, '洪河农场', 230881503),
(230881504, 230881, '鸭绿河农场', 230881504),
(230881505, 230881, '浓江农场', 230881505),
(230881580, 230881, '良种场', 230881580),
(230881581, 230881, '果树场', 230881581),
(230881582, 230881, '马场', 230881582),
(230881583, 230881, '干校', 230881583),
(230881584, 230881, '知青农场', 230881584),
(230882001, 230882, '城市街道社区委员会', 230882001),
(230882002, 230882, '城关街道社区建设委员会', 230882002),
(230882103, 230882, '长安镇', 230882103),
(230882106, 230882, '砚山镇', 230882106),
(230882107, 230882, '头林镇', 230882107),
(230882108, 230882, '兴隆岗镇', 230882108),
(230882109, 230882, '宏胜镇', 230882109),
(230882110, 230882, '向阳川镇', 230882110),
(230882111, 230882, '二龙山镇', 230882111),
(230882112, 230882, '上街基镇', 230882112),
(230882113, 230882, '锦山镇', 230882113),
(230882114, 230882, '大榆树镇', 230882114),
(230882400, 230882, '石砬山林场', 230882400),
(230882401, 230882, '东风岗林场', 230882401),
(230882402, 230882, '太东林场', 230882402),
(230882403, 230882, '工农林场', 230882403),
(230882500, 230882, '建三江分局局直', 230882500),
(230882501, 230882, '七星农场', 230882501),
(230882502, 230882, '大兴农场', 230882502),
(230882503, 230882, '创业农场', 230882503),
(230882580, 230882, '种猪场', 230882580),
(230882581, 230882, '种蓄场', 230882581),
(230902001, 230902, '兴华街道', 230902001),
(230902002, 230902, '新城街道', 230902002),
(230902003, 230902, '新立街道', 230902003),
(230902004, 230902, '新建街道', 230902004),
(230902005, 230902, '北山街道', 230902005),
(230902006, 230902, '河南街道', 230902006),
(230902007, 230902, '新合街道', 230902007),
(230902008, 230902, '缸窑沟街道', 230902008),
(230902009, 230902, '新安街道', 230902009),
(230902010, 230902, '越秀街道', 230902010),
(230902100, 230902, '红旗镇', 230902100),
(230903001, 230903, '桃南街道', 230903001),
(230903002, 230903, '桃北街道', 230903002),
(230903003, 230903, '桃西街道', 230903003),
(230903004, 230903, '兴岗街道', 230903004),
(230903005, 230903, '桃东街道', 230903005),
(230903006, 230903, '桃山街道', 230903006),
(230903100, 230903, '万宝河镇', 230903100),
(230904001, 230904, '东风街道', 230904001),
(230904002, 230904, '向阳街道', 230904002),
(230904003, 230904, '富强街道', 230904003),
(230904004, 230904, '新富街道', 230904004),
(230904005, 230904, '龙湖街道', 230904005),
(230904100, 230904, '茄子河镇', 230904100),
(230904101, 230904, '宏伟镇', 230904101),
(230904200, 230904, '铁山乡', 230904200),
(230904201, 230904, '中心河乡', 230904201),
(230921001, 230921, '新起街道', 230921001),
(230921002, 230921, '新华街道', 230921002),
(230921003, 230921, '元明街道', 230921003),
(230921004, 230921, '铁西街道', 230921004),
(230921005, 230921, '城西街道', 230921005),
(230921100, 230921, '勃利镇', 230921100),
(230921101, 230921, '小五站镇', 230921101),
(230921102, 230921, '大四站镇', 230921102),
(230921103, 230921, '双河镇', 230921103),
(230921104, 230921, '倭肯镇', 230921104),
(230921200, 230921, '青山乡', 230921200),
(230921201, 230921, '长兴乡', 230921201),
(230921202, 230921, '永恒乡', 230921202),
(230921203, 230921, '抢垦乡', 230921203),
(230921204, 230921, '杏树朝鲜族乡', 230921204),
(230921205, 230921, '吉兴朝鲜族满族乡', 230921205),
(230921500, 230921, '北兴农场', 230921500),
(230921580, 230921, '种畜场', 230921580),
(231002001, 231002, '新安街道', 231002001),
(231002002, 231002, '长安街道', 231002002),
(231002003, 231002, '七星街道', 231002003),
(231002004, 231002, '五星街道', 231002004),
(231002100, 231002, '兴隆镇', 231002100),
(231003001, 231003, '阳明街道', 231003001),
(231003002, 231003, '前进街道', 231003002),
(231003003, 231003, '新兴街道', 231003003),
(231003004, 231003, '桦林橡胶厂街道', 231003004),
(231003100, 231003, '铁岭镇', 231003100),
(231003101, 231003, '桦林镇', 231003101),
(231004001, 231004, '向阳街道', 231004001),
(231004002, 231004, '黄花街道', 231004002),
(231004003, 231004, '铁北街道', 231004003),
(231004004, 231004, '新华街道', 231004004),
(231004005, 231004, '大庆街道', 231004005),
(231004006, 231004, '兴平街道', 231004006),
(231004007, 231004, '北山街道', 231004007),
(231004201, 231004, '北安乡', 231004201),
(231005001, 231005, '先锋街道', 231005001),
(231005002, 231005, '火炬街道', 231005002),
(231005003, 231005, '立新街道', 231005003),
(231005004, 231005, '牡丹街道', 231005004),
(231005005, 231005, '江滨街道', 231005005),
(231005006, 231005, '沿江街道', 231005006),
(231005100, 231005, '温春镇', 231005100),
(231005200, 231005, '沿江乡', 231005200),
(231024100, 231024, '东宁镇', 231024100),
(231024101, 231024, '三岔口镇', 231024101),
(231024102, 231024, '大肚川镇', 231024102),
(231024103, 231024, '老黑山镇', 231024103),
(231024104, 231024, '道河镇', 231024104),
(231024105, 231024, '绥阳镇', 231024105),
(231024400, 231024, '绥阳林业局', 231024400),
(231025100, 231025, '林口镇', 231025100),
(231025101, 231025, '古城镇', 231025101),
(231025102, 231025, '刁翎镇', 231025102),
(231025103, 231025, '五林镇', 231025103),
(231025104, 231025, '朱家镇', 231025104),
(231025105, 231025, '柳树镇', 231025105),
(231025106, 231025, '三道通镇', 231025106),
(231025107, 231025, '龙爪镇', 231025107),
(231025108, 231025, '莲花镇', 231025108),
(231025200, 231025, '奎山乡', 231025200),
(231025201, 231025, '青山乡', 231025201),
(231025202, 231025, '建堂乡', 231025202),
(231025400, 231025, '林口林业局', 231025400),
(231081100, 231081, '绥芬河镇', 231081100),
(231081101, 231081, '阜宁镇', 231081101),
(231083100, 231083, '海林镇', 231083100),
(231083101, 231083, '长汀镇', 231083101),
(231083102, 231083, '横道镇', 231083102),
(231083103, 231083, '山市镇', 231083103),
(231083104, 231083, '柴河镇', 231083104),
(231083105, 231083, '二道镇', 231083105),
(231083106, 231083, '新安朝鲜族镇', 231083106),
(231083107, 231083, '三道镇', 231083107),
(231083201, 231083, '海南朝鲜族乡', 231083201),
(231083400, 231083, '牡林工程公司街道', 231083400),
(231083401, 231083, '柴河林机厂街道', 231083401),
(231083402, 231083, '大海林林业局', 231083402),
(231083403, 231083, '海林林业局', 231083403),
(231083404, 231083, '柴河林业局', 231083404),
(231083500, 231083, '海林农场', 231083500),
(231083580, 231083, '山市种奶牛场', 231083580),
(231084001, 231084, '城区街道', 231084001),
(231084100, 231084, '宁安镇', 231084100),
(231084101, 231084, '东京城镇', 231084101),
(231084102, 231084, '渤海镇', 231084102),
(231084103, 231084, '石岩镇', 231084103),
(231084104, 231084, '沙兰镇', 231084104),
(231084105, 231084, '海浪镇', 231084105),
(231084106, 231084, '兰岗镇', 231084106),
(231084202, 231084, '江南朝鲜族满族乡', 231084202),
(231084206, 231084, '卧龙朝鲜族乡', 231084206),
(231084208, 231084, '马河乡', 231084208),
(231084210, 231084, '镜泊乡', 231084210),
(231084211, 231084, '三陵乡', 231084211),
(231084400, 231084, '东京城林业局', 231084400),
(231084500, 231084, '宁安农场', 231084500),
(231085100, 231085, '八面通镇', 231085100),
(231085101, 231085, '穆棱镇', 231085101),
(231085102, 231085, '下城子镇', 231085102),
(231085103, 231085, '马桥河镇', 231085103),
(231085104, 231085, '兴源镇', 231085104),
(231085105, 231085, '磨刀石镇', 231085105),
(231085200, 231085, '福录乡', 231085200),
(231085201, 231085, '河西乡', 231085201),
(231085202, 231085, '共和乡', 231085202),
(231085400, 231085, '八面通林业局', 231085400),
(231085401, 231085, '穆棱林业局', 231085401),
(231102001, 231102, '花园街道', 231102001),
(231102002, 231102, '兴安街道', 231102002),
(231102003, 231102, '海兰街道', 231102003),
(231102004, 231102, '西兴街道', 231102004),
(231102101, 231102, '西岗子镇', 231102101),
(231102102, 231102, '爱辉镇', 231102102),
(231102103, 231102, '罕达汽镇', 231102103),
(231102200, 231102, '幸福乡', 231102200),
(231102201, 231102, '四嘉子乡', 231102201),
(231102202, 231102, '坤河乡', 231102202),
(231102203, 231102, '上马厂乡', 231102203),
(231102204, 231102, '张地营子乡', 231102204),
(231102205, 231102, '西峰山乡', 231102205),
(231102206, 231102, '新生乡', 231102206),
(231102207, 231102, '二站乡', 231102207),
(231102400, 231102, '宋集屯煤矿', 231102400),
(231102401, 231102, '西岗子煤矿', 231102401),
(231102402, 231102, '东方红煤矿', 231102402),
(231102407, 231102, '大平林场', 231102407),
(231102408, 231102, '七二七林场', 231102408),
(231102409, 231102, '望峰林场', 231102409),
(231102410, 231102, '卡伦山林场', 231102410),
(231102411, 231102, '胜山林场', 231102411),
(231102412, 231102, '二站林场', 231102412),
(231102413, 231102, '三站林场', 231102413),
(231102414, 231102, '大岭林场', 231102414),
(231102415, 231102, '桦皮窑林场', 231102415),
(231102416, 231102, '滨南林场', 231102416),
(231102417, 231102, '江防林场', 231102417),
(231102421, 231102, '西岗子试验林场', 231102421),
(231102422, 231102, '种畜场', 231102422),
(231102423, 231102, '第二良种场', 231102423),
(231102424, 231102, '第一良种场', 231102424),
(231102425, 231102, '大新屯储木场', 231102425),
(231102500, 231102, '锦河农场', 231102500),
(231121100, 231121, '嫩江镇', 231121100),
(231121101, 231121, '伊拉哈镇', 231121101),
(231121102, 231121, '双山镇', 231121102),
(231121103, 231121, '多宝山镇', 231121103),
(231121104, 231121, '海江镇', 231121104),
(231121105, 231121, '前进镇', 231121105),
(231121106, 231121, '长福镇', 231121106),
(231121107, 231121, '科洛镇', 231121107),
(231121202, 231121, '临江乡', 231121202),
(231121206, 231121, '联兴乡', 231121206),
(231121207, 231121, '白云乡', 231121207),
(231121208, 231121, '塔溪乡', 231121208),
(231121210, 231121, '霍龙门乡', 231121210),
(231121400, 231121, '多宝山铜矿', 231121400),
(231121500, 231121, '九三分局局直', 231121500),
(231121501, 231121, '鹤山农场', 231121501),
(231121502, 231121, '大西江农场', 231121502),
(231121503, 231121, '尖山农场', 231121503),
(231121504, 231121, '荣军农场', 231121504),
(231121505, 231121, '红五月农场', 231121505),
(231121506, 231121, '七星泡农场', 231121506),
(231121507, 231121, '嫩江农场', 231121507),
(231121508, 231121, '山河农场', 231121508),
(231121509, 231121, '嫩北农场', 231121509),
(231121510, 231121, '建边农场', 231121510),
(231121580, 231121, '种畜场', 231121580),
(231121581, 231121, '马铃薯原种繁殖场', 231121581),
(231123001, 231123, '奇克街道', 231123001),
(231123100, 231123, '边疆镇', 231123100),
(231123101, 231123, '逊河镇', 231123101),
(231123201, 231123, '干岔子乡', 231123201),
(231123202, 231123, '松树沟乡', 231123202),
(231123203, 231123, '车陆乡', 231123203),
(231123204, 231123, '新鄂乡', 231123204),
(231123205, 231123, '新兴乡', 231123205),
(231123206, 231123, '克林乡', 231123206),
(231123207, 231123, '宝山乡', 231123207),
(231123402, 231123, '道干林场', 231123402),
(231123403, 231123, '干岔子林场', 231123403),
(231123404, 231123, '新立林场', 231123404),
(231123405, 231123, '三间房林场', 231123405),
(231123406, 231123, '良种场', 231123406),
(231123407, 231123, '种畜场', 231123407),
(231123500, 231123, '逊克农场', 231123500),
(231124001, 231124, '孙吴城区街道', 231124001),
(231124100, 231124, '孙吴镇', 231124100),
(231124101, 231124, '辰清镇', 231124101),
(231124201, 231124, '西兴乡', 231124201),
(231124202, 231124, '沿江满族乡', 231124202),
(231124203, 231124, '腰屯乡', 231124203),
(231124204, 231124, '卧牛河乡', 231124204),
(231124205, 231124, '群山乡', 231124205),
(231124206, 231124, '奋斗乡', 231124206),
(231124207, 231124, '红旗乡', 231124207),
(231124208, 231124, '正阳山乡', 231124208),
(231124210, 231124, '清溪乡', 231124210),
(231124402, 231124, '前进林场', 231124402),
(231124403, 231124, '大河口林场', 231124403),
(231124404, 231124, '正阳林场', 231124404),
(231124405, 231124, '平山林场', 231124405),
(231124406, 231124, '沿江林场', 231124406),
(231124407, 231124, '辰清林场', 231124407),
(231124408, 231124, '红旗林场', 231124408),
(231124409, 231124, '向阳林场', 231124409),
(231124410, 231124, '良种场', 231124410),
(231124411, 231124, '种畜场', 231124411),
(231124500, 231124, '红色边疆农场', 231124500),
(231181001, 231181, '兆麟街道', 231181001),
(231181002, 231181, '和平街道', 231181002),
(231181003, 231181, '北岗街道', 231181003),
(231181004, 231181, '庆华街道', 231181004),
(231181005, 231181, '铁西街道', 231181005),
(231181006, 231181, '铁南街道', 231181006),
(231181101, 231181, '通北镇', 231181101),
(231181102, 231181, '赵光镇', 231181102),
(231181103, 231181, '海星镇', 231181103),
(231181104, 231181, '石泉镇', 231181104),
(231181105, 231181, '二井镇', 231181105),
(231181200, 231181, '城郊乡', 231181200),
(231181201, 231181, '东胜乡', 231181201),
(231181203, 231181, '杨家乡', 231181203),
(231181207, 231181, '主星乡', 231181207),
(231181400, 231181, '通北林业局', 231181400),
(231181500, 231181, '北安分局局直', 231181500),
(231181501, 231181, '长水河农场', 231181501),
(231181502, 231181, '赵光农场', 231181502),
(231181503, 231181, '红星农场', 231181503),
(231181504, 231181, '建设农场', 231181504),
(231182001, 231182, '青山街道', 231182001),
(231182101, 231182, '龙镇', 231182101),
(231182102, 231182, '和平镇', 231182102),
(231182103, 231182, '五大连池镇', 231182103),
(231182201, 231182, '新发乡', 231182201),
(231182202, 231182, '兴隆乡', 231182202),
(231182203, 231182, '建设乡', 231182203),
(231182205, 231182, '太平乡', 231182205),
(231182206, 231182, '双泉乡', 231182206),
(231182207, 231182, '团结乡', 231182207),
(231182208, 231182, '兴安乡', 231182208),
(231182210, 231182, '朝阳乡', 231182210),
(231182400, 231182, '花园劳教所', 231182400),
(231182401, 231182, '永丰监狱', 231182401),
(231182402, 231182, '华山监狱', 231182402),
(231182403, 231182, '凤凰山监狱', 231182403),
(231182406, 231182, '元青山林场', 231182406),
(231182407, 231182, '三九六林场', 231182407),
(231182408, 231182, '小兴安林场', 231182408),
(231182409, 231182, '二龙山林场', 231182409),
(231182410, 231182, '朝阳林场', 231182410),
(231182411, 231182, '引龙河林场', 231182411),
(231182412, 231182, '焦得布林场', 231182412),
(231182417, 231182, '沾河林业局', 231182417),
(231182418, 231182, '莲花管理委员会', 231182418),
(231182427, 231182, '二龙山蚕种场', 231182427),
(231182428, 231182, '五大连池原种场', 231182428),
(231182429, 231182, '畜牧场', 231182429),
(231182430, 231182, '第二良种场', 231182430),
(231182501, 231182, '龙门农场', 231182501),
(231182502, 231182, '襄河农场', 231182502),
(231182503, 231182, '龙镇农场', 231182503),
(231182504, 231182, '二龙山农场', 231182504),
(231182505, 231182, '引龙河农场', 231182505),
(231182506, 231182, '尾山农场', 231182506),
(231182507, 231182, '格球山农场', 231182507),
(231182580, 231182, '大庆农场', 231182580),
(231202001, 231202, '紫来', 231202001),
(231202002, 231202, '爱路', 231202002),
(231202003, 231202, '大有', 231202003),
(231202004, 231202, '吉泰', 231202004),
(231202005, 231202, '东兴', 231202005),
(231202006, 231202, '北林办事处居民委员会', 231202006),
(231202101, 231202, '宝山镇', 231202101),
(231202102, 231202, '绥胜镇', 231202102),
(231202103, 231202, '西长发镇', 231202103),
(231202104, 231202, '永安镇', 231202104),
(231202105, 231202, '太平川镇', 231202105),
(231202106, 231202, '秦家镇', 231202106),
(231202107, 231202, '双河镇', 231202107),
(231202108, 231202, '三河镇', 231202108),
(231202109, 231202, '四方台镇', 231202109),
(231202110, 231202, '津河镇', 231202110),
(231202111, 231202, '张维镇', 231202111),
(231202113, 231202, '东津镇', 231202113),
(231202201, 231202, '红旗乡', 231202201),
(231202202, 231202, '连岗乡', 231202202),
(231202203, 231202, '新华乡', 231202203),
(231202204, 231202, '兴福乡', 231202204),
(231202205, 231202, '东富乡', 231202205),
(231202209, 231202, '三井乡', 231202209),
(231202212, 231202, '五营乡', 231202212),
(231202213, 231202, '兴和乡', 231202213),
(231221100, 231221, '望奎镇', 231221100),
(231221101, 231221, '通江镇', 231221101),
(231221102, 231221, '卫星镇', 231221102),
(231221103, 231221, '海丰镇', 231221103),
(231221104, 231221, '莲花镇', 231221104),
(231221105, 231221, '惠七满族镇', 231221105),
(231221106, 231221, '先锋镇', 231221106),
(231221201, 231221, '东郊乡', 231221201),
(231221202, 231221, '灵山满族乡', 231221202),
(231221203, 231221, '后三乡', 231221203),
(231221206, 231221, '火箭乡', 231221206),
(231221207, 231221, '灯塔乡', 231221207),
(231221209, 231221, '东升乡', 231221209),
(231221210, 231221, '恭六乡', 231221210),
(231221211, 231221, '厢白满族乡', 231221211),
(231221400, 231221, '白四林场', 231221400),
(231221580, 231221, '种畜场', 231221580),
(231221581, 231221, '第一良种场', 231221581),
(231221582, 231221, '第二良种场', 231221582),
(231222101, 231222, '兰西镇', 231222101),
(231222102, 231222, '榆林镇', 231222102),
(231222103, 231222, '临江镇', 231222103),
(231222104, 231222, '平山镇', 231222104),
(231222200, 231222, '康荣乡', 231222200),
(231222201, 231222, '燎原乡', 231222201),
(231222202, 231222, '北安乡', 231222202),
(231222203, 231222, '长江乡', 231222203),
(231222204, 231222, '兰河乡', 231222204),
(231222205, 231222, '红星乡', 231222205),
(231222206, 231222, '红光乡', 231222206),
(231222207, 231222, '长岗乡', 231222207),
(231222209, 231222, '远大乡', 231222209),
(231222210, 231222, '星火乡', 231222210),
(231222211, 231222, '奋斗乡', 231222211),
(231222580, 231222, '第一原种场', 231222580),
(231222581, 231222, '第二原种场', 231222581),
(231222582, 231222, '肉用种羊场', 231222582),
(231223100, 231223, '青冈镇', 231223100),
(231223101, 231223, '中和镇', 231223101),
(231223102, 231223, '祯祥镇', 231223102),
(231223103, 231223, '兴华镇', 231223103),
(231223104, 231223, '永丰镇', 231223104),
(231223105, 231223, '芦河镇', 231223105),
(231223201, 231223, '劳动乡', 231223201),
(231223202, 231223, '建设乡', 231223202),
(231223203, 231223, '新村乡', 231223203),
(231223206, 231223, '昌盛乡', 231223206),
(231223207, 231223, '柞岗乡', 231223207),
(231223208, 231223, '民政乡', 231223208),
(231223209, 231223, '德胜乡', 231223209),
(231223211, 231223, '迎春乡', 231223211),
(231223212, 231223, '连丰乡', 231223212),
(231223400, 231223, '青冈县林场', 231223400),
(231223401, 231223, '青冈县互利营林站', 231223401),
(231223402, 231223, '青冈县果树场', 231223402),
(231223580, 231223, '青冈县种马场', 231223580),
(231223581, 231223, '青冈县种羊场', 231223581),
(231223582, 231223, '青冈县原种场', 231223582),
(231224101, 231224, '庆安镇', 231224101),
(231224102, 231224, '民乐镇', 231224102),
(231224103, 231224, '大罗镇', 231224103),
(231224104, 231224, '平安镇', 231224104),
(231224105, 231224, '勤劳镇', 231224105),
(231224106, 231224, '久胜镇', 231224106),
(231224201, 231224, '建民乡', 231224201),
(231224202, 231224, '巨宝山乡', 231224202),
(231224204, 231224, '新胜乡', 231224204),
(231224206, 231224, '丰收乡', 231224206),
(231224208, 231224, '发展乡', 231224208),
(231224209, 231224, '同乐乡', 231224209),
(231224210, 231224, '致富乡', 231224210),
(231224211, 231224, '欢胜乡', 231224211),
(231224400, 231224, '国有林场管理局', 231224400),
(231224401, 231224, '柳河林校', 231224401),
(231224500, 231224, '柳河农场', 231224500),
(231225100, 231225, '明水镇', 231225100),
(231225101, 231225, '兴仁镇', 231225101),
(231225102, 231225, '永兴镇', 231225102),
(231225103, 231225, '崇德镇', 231225103),
(231225104, 231225, '通达镇', 231225104),
(231225201, 231225, '双兴乡', 231225201),
(231225203, 231225, '永久乡', 231225203),
(231225204, 231225, '树人乡', 231225204),
(231225205, 231225, '光荣乡', 231225205),
(231225206, 231225, '繁荣乡', 231225206),
(231225207, 231225, '通泉乡', 231225207),
(231225208, 231225, '育林乡', 231225208),
(231225400, 231225, '国营林场', 231225400),
(231225580, 231225, '县联社马场', 231225580),
(231225581, 231225, '明水种畜场', 231225581),
(231225582, 231225, '育林畜牧场', 231225582),
(231225583, 231225, '国营第一良种', 231225583),
(231225584, 231225, '国营第二良种', 231225584),
(231225585, 231225, '国营第三良种', 231225585),
(231226100, 231226, '绥棱镇', 231226100),
(231226101, 231226, '上集镇', 231226101),
(231226102, 231226, '四海店镇', 231226102),
(231226103, 231226, '双岔河镇', 231226103),
(231226200, 231226, '靠山乡', 231226200),
(231226201, 231226, '后头乡', 231226201),
(231226203, 231226, '长山乡', 231226203),
(231226205, 231226, '克音河乡', 231226205),
(231226206, 231226, '绥中乡', 231226206),
(231226207, 231226, '泥尔河乡', 231226207),
(231226210, 231226, '阁山乡', 231226210),
(231226400, 231226, '阁山林场', 231226400),
(231226401, 231226, '四海店林场', 231226401),
(231226402, 231226, '三吉台林场', 231226402),
(231226403, 231226, '半截河林场', 231226403),
(231226404, 231226, '绥棱林业局', 231226404),
(231226500, 231226, '绥棱农场', 231226500),
(231226580, 231226, '种马场', 231226580),
(231226581, 231226, '良种场', 231226581),
(231226582, 231226, '奶山羊场', 231226582),
(231281001, 231281, '铁西街道', 231281001),
(231281002, 231281, '新兴街道', 231281002),
(231281003, 231281, '安虹街道', 231281003),
(231281100, 231281, '安达镇', 231281100),
(231281101, 231281, '任民镇', 231281101),
(231281103, 231281, '万宝山镇', 231281103),
(231281104, 231281, '昌德镇', 231281104),
(231281105, 231281, '升平镇', 231281105),
(231281106, 231281, '羊草镇', 231281106),
(231281107, 231281, '老虎岗镇', 231281107),
(231281108, 231281, '中本镇', 231281108),
(231281109, 231281, '太平庄镇', 231281109),
(231281110, 231281, '吉兴岗镇', 231281110),
(231281202, 231281, '火石山乡', 231281202),
(231281204, 231281, '卧里屯乡', 231281204),
(231281205, 231281, '青肯泡乡', 231281205),
(231281209, 231281, '先源乡', 231281209),
(231281500, 231281, '安达畜牧场', 231281500),
(231281580, 231281, '种畜场', 231281580),
(231281581, 231281, '原种场', 231281581),
(231281582, 231281, '种牛场', 231281582),
(231281583, 231281, '红旗泡水库管理所', 231281583),
(231281584, 231281, '东湖水库管理站', 231281584),
(231282001, 231282, '朝阳区', 231282001),
(231282002, 231282, '东升区', 231282002),
(231282003, 231282, '西园区', 231282003),
(231282004, 231282, '正阳区', 231282004),
(231282100, 231282, '肇东镇', 231282100),
(231282101, 231282, '昌五镇', 231282101),
(231282102, 231282, '宋站镇', 231282102),
(231282103, 231282, '五站镇', 231282103),
(231282104, 231282, '尚家镇', 231282104),
(231282105, 231282, '姜家镇', 231282105),
(231282106, 231282, '里木店镇', 231282106),
(231282107, 231282, '四站镇', 231282107),
(231282108, 231282, '涝洲镇', 231282108),
(231282109, 231282, '五里明镇', 231282109),
(231282110, 231282, '黎明镇', 231282110),
(231282201, 231282, '太平乡', 231282201),
(231282203, 231282, '海城乡', 231282203),
(231282204, 231282, '向阳乡', 231282204),
(231282205, 231282, '洪河乡', 231282205),
(231282206, 231282, '跃进乡', 231282206),
(231282211, 231282, '西八里乡', 231282211),
(231282212, 231282, '德昌乡', 231282212),
(231282213, 231282, '宣化乡', 231282213),
(231282214, 231282, '安民乡', 231282214),
(231282215, 231282, '明久乡', 231282215),
(231282500, 231282, '四方山农场', 231282500),
(231283100, 231283, '海伦镇', 231283100),
(231283101, 231283, '海北镇', 231283101),
(231283102, 231283, '伦河镇', 231283102),
(231283103, 231283, '共合镇', 231283103),
(231283104, 231283, '海兴镇', 231283104),
(231283105, 231283, '祥富镇', 231283105),
(231283106, 231283, '东风镇', 231283106),
(231283202, 231283, '前进乡', 231283202),
(231283203, 231283, '向荣乡', 231283203),
(231283204, 231283, '长发乡', 231283204),
(231283205, 231283, '东林乡', 231283205),
(231283208, 231283, '海南乡', 231283208),
(231283209, 231283, '共荣乡', 231283209),
(231283210, 231283, '乐业乡', 231283210),
(231283211, 231283, '福民乡', 231283211),
(231283212, 231283, '丰山乡', 231283212),
(231283213, 231283, '永富乡', 231283213),
(231283215, 231283, '百祥乡', 231283215),
(231283216, 231283, '联发乡', 231283216),
(231283217, 231283, '永和乡', 231283217),
(231283218, 231283, '爱民乡', 231283218),
(231283220, 231283, '扎音河乡', 231283220),
(231283221, 231283, '双录乡', 231283221),
(231283400, 231283, '林场公司', 231283400),
(231283401, 231283, '东方红水库地区', 231283401),
(231283500, 231283, '海伦农场', 231283500),
(231283501, 231283, '红光农场', 231283501),
(231283580, 231283, '海伦绥化种畜场', 231283580),
(231283581, 231283, '海伦二粮种场', 231283581),
(231283582, 231283, '海伦市种畜场', 231283582),
(232701001, 232701, '街道东山社区', 232701001),
(232701002, 232701, '街道卫东社区', 232701002),
(232701003, 232701, '街道红旗社区', 232701003),
(232701004, 232701, '街道长虹社区', 232701004),
(232701005, 232701, '街道曙光社区', 232701005),
(232701006, 232701, '街道光明社区', 232701006),
(232701200, 232701, '加北乡', 232701200),
(232701201, 232701, '白桦乡', 232701201),
(232701400, 232701, '加格达奇林业局', 232701400),
(232701401, 232701, '林田农业开发区', 232701401),
(232702100, 232702, '小扬气镇', 232702100),
(232702101, 232702, '劲松镇', 232702101),
(232702102, 232702, '古源镇', 232702102),
(232702400, 232702, '松岭林业局', 232702400),
(232703100, 232703, '新林镇', 232703100),
(232703101, 232703, '翠岗镇', 232703101),
(232703102, 232703, '塔源镇', 232703102),
(232703103, 232703, '大乌苏镇', 232703103),
(232703104, 232703, '塔尔根镇', 232703104),
(232703105, 232703, '碧洲镇', 232703105),
(232703106, 232703, '宏图镇', 232703106),
(232703400, 232703, '新林林业局', 232703400),
(232704100, 232704, '呼中镇', 232704100),
(232704101, 232704, '碧水镇', 232704101),
(232704102, 232704, '呼源镇', 232704102),
(232704103, 232704, '宏伟镇', 232704103),
(232704400, 232704, '呼中林业局', 232704400),
(232721100, 232721, '呼玛镇', 232721100),
(232721101, 232721, '韩家园镇', 232721101),
(232721200, 232721, '三卡乡', 232721200),
(232721201, 232721, '金山乡', 232721201),
(232721202, 232721, '兴华乡', 232721202),
(232721203, 232721, '鸥浦乡', 232721203),
(232721204, 232721, '白银纳鄂伦春族民族乡', 232721204),
(232721205, 232721, '北疆乡', 232721205),
(232721400, 232721, '韩家园林业局', 232721400),
(232722100, 232722, '塔河镇', 232722100),
(232722101, 232722, '瓦拉干镇', 232722101),
(232722102, 232722, '盘古镇', 232722102),
(232722200, 232722, '十八站鄂伦春族民族乡', 232722200),
(232722201, 232722, '依西肯乡', 232722201),
(232722202, 232722, '开库康乡', 232722202),
(232722400, 232722, '十八站林业局', 232722400),
(232722401, 232722, '塔河林业局', 232722401),
(232723100, 232723, '西林吉镇', 232723100),
(232723101, 232723, '图强镇', 232723101),
(232723102, 232723, '劲涛镇', 232723102),
(232723103, 232723, '兴安镇', 232723103),
(232723200, 232723, '北极乡', 232723200),
(232723400, 232723, '西林吉林业局', 232723400),
(232723401, 232723, '图强林业局', 232723401),
(232723402, 232723, '阿木尔林业局', 232723402),
(310101002, 310101, '南京东路街道', 310101002),
(310101006, 310101, '金陵东路街道', 310101006),
(310101013, 310101, '外滩街道', 310101013),
(310101014, 310101, '人民广场街道', 310101014),
(310101015, 310101, '半淞园路街道', 310101015),
(310101016, 310101, '董家渡街道', 310101016),
(310101017, 310101, '小东门街道', 310101017),
(310101018, 310101, '豫园街道', 310101018),
(310101019, 310101, '老西门街道', 310101019),
(310103001, 310103, '五里桥街道', 310103001),
(310103002, 310103, '打浦桥街道', 310103002),
(310103008, 310103, '淮海中路街道', 310103008),
(310103009, 310103, '瑞金二路街道', 310103009),
(310104003, 310104, '天平路街道', 310104003),
(310104004, 310104, '湖南路街道', 310104004),
(310104007, 310104, '斜土路街道', 310104007),
(310104008, 310104, '枫林路街道', 310104008),
(310104010, 310104, '长桥街道', 310104010),
(310104011, 310104, '田林街道', 310104011),
(310104012, 310104, '虹梅路街道', 310104012),
(310104013, 310104, '康健新村街道', 310104013),
(310104014, 310104, '徐家汇街道', 310104014),
(310104015, 310104, '凌云路街道', 310104015),
(310104016, 310104, '龙华街道', 310104016),
(310104017, 310104, '漕河泾街道', 310104017),
(310104103, 310104, '华泾镇', 310104103),
(310104501, 310104, '漕河泾新兴技术开发区', 310104501),
(310105001, 310105, '华阳路街道', 310105001),
(310105002, 310105, '江苏路街道', 310105002),
(310105004, 310105, '新华路街道', 310105004),
(310105005, 310105, '周家桥街道', 310105005),
(310105006, 310105, '天山路街道', 310105006),
(310105008, 310105, '仙霞新村街道', 310105008),
(310105009, 310105, '虹桥街道', 310105009),
(310105010, 310105, '程家桥街道', 310105010),
(310105011, 310105, '北新泾街道', 310105011),
(310105102, 310105, '新泾镇', 310105102),
(310106006, 310106, '江宁路街道', 310106006),
(310106011, 310106, '石门二路街道', 310106011),
(310106012, 310106, '南京西路街道', 310106012),
(310106013, 310106, '静安寺街道', 310106013),
(310106014, 310106, '曹家渡街道', 310106014),
(310107005, 310107, '曹杨新村街道', 310107005),
(310107014, 310107, '长风新村街道', 310107014),
(310107015, 310107, '长寿路街道', 310107015),
(310107016, 310107, '甘泉路街道', 310107016),
(310107017, 310107, '石泉路街道', 310107017),
(310107020, 310107, '宜川路街道', 310107020),
(310107101, 310107, '真如镇', 310107101),
(310107102, 310107, '长征镇', 310107102),
(310107103, 310107, '桃浦镇', 310107103),
(310108001, 310108, '天目西路街道', 310108001),
(310108006, 310108, '北站街道', 310108006),
(310108007, 310108, '宝山路街道', 310108007),
(310108012, 310108, '共和新路街道', 310108012),
(310108013, 310108, '大宁路街道', 310108013),
(310108014, 310108, '彭浦新村街道', 310108014),
(310108015, 310108, '临汾路街道', 310108015),
(310108016, 310108, '芷江西路街道', 310108016),
(310108101, 310108, '彭浦镇', 310108101),
(310109002, 310109, '乍浦路街道', 310109002),
(310109008, 310109, '新港路街道', 310109008),
(310109009, 310109, '欧阳路街道', 310109009),
(310109010, 310109, '曲阳路街道', 310109010),
(310109011, 310109, '广中路街道', 310109011),
(310109014, 310109, '嘉兴路街道', 310109014),
(310109016, 310109, '凉城新村街道', 310109016),
(310109017, 310109, '四川北路街道', 310109017),
(310109018, 310109, '提篮桥街道', 310109018),
(310109101, 310109, '江湾镇', 310109101),
(310110001, 310110, '定海路街道', 310110001),
(310110006, 310110, '平凉路街道', 310110006),
(310110008, 310110, '江浦路街道', 310110008),
(310110009, 310110, '四平路街道', 310110009),
(310110012, 310110, '控江路街道', 310110012),
(310110013, 310110, '长白新村街道', 310110013),
(310110015, 310110, '延吉新村街道', 310110015),
(310110016, 310110, '殷行街道', 310110016),
(310110018, 310110, '大桥街道', 310110018),
(310110019, 310110, '五角场街道', 310110019),
(310110020, 310110, '新江湾城街道', 310110020),
(310110101, 310110, '五角场镇', 310110101),
(310112001, 310112, '江川路街道', 310112001),
(310112005, 310112, '龙柏街道', 310112005),
(310112006, 310112, '古美街道', 310112006),
(310112101, 310112, '莘庄镇', 310112101),
(310112102, 310112, '七宝镇', 310112102),
(310112103, 310112, '颛桥镇', 310112103),
(310112106, 310112, '华漕镇', 310112106),
(310112107, 310112, '虹桥镇', 310112107),
(310112108, 310112, '梅陇镇', 310112108),
(310112110, 310112, '吴泾镇', 310112110),
(310112112, 310112, '马桥镇', 310112112),
(310112114, 310112, '浦江镇', 310112114),
(310112501, 310112, '莘庄工业区', 310112501),
(310113003, 310113, '友谊路街道', 310113003),
(310113007, 310113, '吴淞街道', 310113007),
(310113008, 310113, '张庙街道', 310113008),
(310113101, 310113, '罗店镇', 310113101),
(310113102, 310113, '大场镇', 310113102),
(310113103, 310113, '杨行镇', 310113103),
(310113104, 310113, '月浦镇', 310113104),
(310113106, 310113, '罗泾镇', 310113106),
(310113109, 310113, '顾村镇', 310113109),
(310113111, 310113, '高境镇', 310113111),
(310113112, 310113, '庙行镇', 310113112),
(310113113, 310113, '淞南镇', 310113113),
(310113501, 310113, '宝山城市工业园区', 310113501),
(310114001, 310114, '新成路街道', 310114001),
(310114002, 310114, '真新新村街道', 310114002),
(310114003, 310114, '菊园新区', 310114003),
(310114004, 310114, '嘉定镇街道', 310114004),
(310114102, 310114, '南翔镇', 310114102),
(310114103, 310114, '安亭镇', 310114103),
(310114106, 310114, '马陆镇', 310114106),
(310114109, 310114, '徐行镇', 310114109),
(310114111, 310114, '华亭镇', 310114111),
(310114114, 310114, '外冈镇', 310114114),
(310114117, 310114, '黄渡镇', 310114117),
(310114118, 310114, '江桥镇', 310114118),
(310114501, 310114, '嘉定工业区', 310114501),
(310115004, 310115, '潍坊新村街道', 310115004),
(310115005, 310115, '陆家嘴街道', 310115005),
(310115007, 310115, '周家渡街道', 310115007),
(310115008, 310115, '塘桥街道', 310115008),
(310115009, 310115, '上钢新村街道', 310115009),
(310115010, 310115, '南码头路街道', 310115010),
(310115011, 310115, '沪东新村街道', 310115011),
(310115012, 310115, '金杨新村街道', 310115012),
(310115013, 310115, '洋泾街道', 310115013),
(310115014, 310115, '浦兴路街道', 310115014),
(310115015, 310115, '东明路街道', 310115015),
(310115016, 310115, '花木街道', 310115016),
(310115103, 310115, '川沙新镇', 310115103),
(310115104, 310115, '高桥镇', 310115104),
(310115105, 310115, '北蔡镇', 310115105),
(310115110, 310115, '合庆镇', 310115110),
(310115114, 310115, '唐镇', 310115114),
(310115117, 310115, '曹路镇', 310115117),
(310115120, 310115, '金桥镇', 310115120),
(310115121, 310115, '高行镇', 310115121),
(310115123, 310115, '高东镇', 310115123),
(310115125, 310115, '张江镇', 310115125),
(310115130, 310115, '三林镇', 310115130),
(310115501, 310115, '外高桥保税区', 310115501),
(310115502, 310115, '金桥出口加工区', 310115502),
(310116001, 310116, '石化街道', 310116001),
(310116101, 310116, '朱泾镇', 310116101),
(310116102, 310116, '枫泾镇', 310116102),
(310116103, 310116, '张堰镇', 310116103),
(310116104, 310116, '亭林镇', 310116104),
(310116105, 310116, '吕巷镇', 310116105),
(310116107, 310116, '廊下镇', 310116107),
(310116109, 310116, '金山卫镇', 310116109),
(310116112, 310116, '漕泾镇', 310116112),
(310116113, 310116, '山阳镇', 310116113),
(310117001, 310117, '岳阳街道', 310117001),
(310117002, 310117, '永丰街道', 310117002),
(310117003, 310117, '方松街道', 310117003),
(310117004, 310117, '中山街道', 310117004),
(310117102, 310117, '泗泾镇', 310117102),
(310117103, 310117, '佘山镇', 310117103),
(310117104, 310117, '车墩镇', 310117104),
(310117105, 310117, '新桥镇', 310117105),
(310117106, 310117, '洞泾镇', 310117106),
(310117107, 310117, '九亭镇', 310117107),
(310117109, 310117, '泖港镇', 310117109),
(310117116, 310117, '石湖荡镇', 310117116),
(310117117, 310117, '新浜镇', 310117117),
(310117120, 310117, '叶榭镇', 310117120),
(310117501, 310117, '松江工业区', 310117501),
(310117504, 310117, '佘山度假区', 310117504),
(310117505, 310117, '五厍农业园区', 310117505),
(310117506, 310117, '上海松江科技园区', 310117506),
(310117507, 310117, '上海松江出口加工区', 310117507),
(310118001, 310118, '夏阳街道', 310118001),
(310118002, 310118, '盈浦街道', 310118002),
(310118003, 310118, '香花桥街道', 310118003),
(310118102, 310118, '朱家角镇', 310118102),
(310118103, 310118, '练塘镇', 310118103),
(310118104, 310118, '金泽镇', 310118104),
(310118105, 310118, '赵巷镇', 310118105),
(310118106, 310118, '徐泾镇', 310118106),
(310118107, 310118, '华新镇', 310118107),
(310118109, 310118, '重固镇', 310118109),
(310118110, 310118, '白鹤镇', 310118110),
(310119101, 310119, '惠南镇', 310119101),
(310119102, 310119, '周浦镇', 310119102),
(310119103, 310119, '新场镇', 310119103),
(310119104, 310119, '大团镇', 310119104),
(310119106, 310119, '芦潮港镇', 310119106),
(310119109, 310119, '康桥镇', 310119109),
(310119110, 310119, '航头镇', 310119110),
(310119111, 310119, '六灶镇', 310119111),
(310119112, 310119, '祝桥镇', 310119112),
(310119114, 310119, '泥城镇', 310119114),
(310119115, 310119, '宣桥镇', 310119115),
(310119121, 310119, '书院镇', 310119121),
(310119122, 310119, '万祥镇', 310119122),
(310119124, 310119, '老港镇', 310119124),
(310119401, 310119, '芦潮港农场', 310119401),
(310119402, 310119, '东海农场', 310119402),
(310119403, 310119, '朝阳农场', 310119403),
(310120101, 310120, '南桥镇', 310120101),
(310120102, 310120, '奉城镇', 310120102),
(310120104, 310120, '庄行镇', 310120104),
(310120106, 310120, '金汇镇', 310120106),
(310120109, 310120, '四团镇', 310120109),
(310120111, 310120, '青村镇', 310120111),
(310120118, 310120, '柘林镇', 310120118),
(310120123, 310120, '海湾镇', 310120123),
(310120501, 310120, '上海工业综合开发区', 310120501),
(310120502, 310120, '上海化学工业区奉贤分区', 310120502),
(310120503, 310120, '海湾旅游区', 310120503),
(310120504, 310120, '奉贤区现代农业园区', 310120504),
(310120505, 310120, '上海海港综合经济开发区', 310120505),
(310230101, 310230, '城桥镇', 310230101),
(310230102, 310230, '堡镇', 310230102),
(310230103, 310230, '新河镇', 310230103),
(310230104, 310230, '庙镇', 310230104),
(310230106, 310230, '竖新镇', 310230106),
(310230107, 310230, '向化镇', 310230107),
(310230109, 310230, '三星镇', 310230109),
(310230113, 310230, '港沿镇', 310230113),
(310230114, 310230, '中兴镇', 310230114),
(310230115, 310230, '陈家镇', 310230115),
(310230116, 310230, '绿华镇', 310230116),
(310230118, 310230, '港西镇', 310230118),
(310230119, 310230, '建设镇', 310230119),
(310230201, 310230, '新村乡', 310230201),
(310230202, 310230, '长兴乡', 310230202),
(310230203, 310230, '横沙乡', 310230203),
(310230401, 310230, '跃进农场', 310230401),
(310230402, 310230, '新海农场', 310230402),
(310230403, 310230, '红星农场', 310230403),
(310230404, 310230, '长征农场', 310230404),
(310230405, 310230, '东风农场', 310230405),
(310230406, 310230, '长江农场', 310230406),
(310230407, 310230, '前进农场', 310230407),
(310230408, 310230, '前哨农场', 310230408),
(310230409, 310230, '前卫农场', 310230409),
(310230410, 310230, '东平林场', 310230410),
(310230501, 310230, '上实现代农业园区', 310230501),
(320102002, 320102, '梅园新村街道', 320102002),
(320102003, 320102, '新街口街道', 320102003),
(320102005, 320102, '玄武门街道', 320102005),
(320102006, 320102, '后宰门街道', 320102006),
(320102007, 320102, '锁金村街道', 320102007),
(320102008, 320102, '红山街道', 320102008),
(320102009, 320102, '孝陵卫街道', 320102009),
(320102010, 320102, '玄武湖街道', 320102010),
(320103001, 320103, '五老村街道', 320103001),
(320103002, 320103, '淮海路街道', 320103002),
(320103003, 320103, '建康路街道', 320103003),
(320103004, 320103, '洪武路街道', 320103004),
(320103005, 320103, '大光路街道', 320103005),
(320103006, 320103, '瑞金路街道', 320103006),
(320103007, 320103, '苜蓿园街道', 320103007),
(320103008, 320103, '光华路街道', 320103008),
(320103009, 320103, '朝天宫街道', 320103009),
(320103010, 320103, '止马营街道', 320103010),
(320104001, 320104, '秦虹街道', 320104001),
(320104002, 320104, '夫子庙街道', 320104002),
(320104003, 320104, '红花街道', 320104003),
(320104004, 320104, '双塘街道', 320104004),
(320104005, 320104, '中华门街道', 320104005),
(320105001, 320105, '滨湖街道', 320105001),
(320105002, 320105, '沙洲街道', 320105002),
(320105003, 320105, '双闸街道', 320105003),
(320105004, 320105, '江心洲街道', 320105004),
(320105005, 320105, '南湖街道', 320105005),
(320105006, 320105, '兴隆街道', 320105006),
(320105007, 320105, '南苑街道', 320105007),
(320106001, 320106, '宁海路街道', 320106001),
(320106002, 320106, '华侨路街道', 320106002),
(320106003, 320106, '湖南路街道', 320106003),
(320106004, 320106, '中央门街道', 320106004),
(320106005, 320106, '挹江门街道', 320106005),
(320106006, 320106, '江东街道', 320106006),
(320106007, 320106, '莫愁街道', 320106007),
(320107001, 320107, '阅江楼街道', 320107001),
(320107002, 320107, '热河南路街道', 320107002),
(320107003, 320107, '幕府山街道', 320107003),
(320107004, 320107, '建宁路街道', 320107004),
(320107005, 320107, '宝塔桥街道', 320107005),
(320107006, 320107, '小市街道', 320107006),
(320111001, 320111, '泰山街道', 320111001),
(320111002, 320111, '顶山街道', 320111002),
(320111003, 320111, '沿江街道', 320111003),
(320111004, 320111, '江浦街道', 320111004),
(320111050, 320111, '高新花苑虚拟街道', 320111050),
(320111101, 320111, '桥林镇', 320111101),
(320111102, 320111, '永宁镇', 320111102),
(320111103, 320111, '汤泉镇', 320111103),
(320111104, 320111, '星甸镇', 320111104),
(320111105, 320111, '石桥镇', 320111105),
(320111106, 320111, '乌江镇', 320111106),
(320111107, 320111, '盘城镇', 320111107),
(320111400, 320111, '老山林场', 320111400),
(320111401, 320111, '汤泉农场', 320111401),
(320111402, 320111, '珍珠泉管委会', 320111402),
(320113001, 320113, '尧化街道', 320113001),
(320113002, 320113, '马群街道', 320113002),
(320113003, 320113, '迈皋桥街道', 320113003),
(320113004, 320113, '燕子矶街道', 320113004),
(320113005, 320113, '栖霞街道', 320113005),
(320113006, 320113, '龙潭街道', 320113006),
(320113007, 320113, '仙林街道', 320113007),
(320113008, 320113, '靖安街道', 320113008),
(320113009, 320113, '八卦洲街道', 320113009),
(320113400, 320113, '龙潭监狱', 320113400),
(320113401, 320113, '栖霞区技术经济开发区', 320113401),
(320113402, 320113, '南京龙潭物流园', 320113402),
(320113403, 320113, '南京市靖安三江口工业园', 320113403),
(320113404, 320113, '南京迈皋桥创业园', 320113404),
(320113405, 320113, '南京市马群科技园', 320113405),
(320113406, 320113, '南京仙林大学城', 320113406),
(320113450, 320113, '南京经济技术开发区', 320113450),
(320114001, 320114, '宁南街道', 320114001),
(320114002, 320114, '赛虹桥街道', 320114002),
(320114003, 320114, '雨花新村街道', 320114003),
(320114004, 320114, '西善桥街道', 320114004),
(320114005, 320114, '板桥街道', 320114005),
(320114006, 320114, '铁心桥街道', 320114006),
(320114007, 320114, '梅山街道', 320114007),
(320114400, 320114, '雨花经济技术开发区', 320114400),
(320115001, 320115, '东山街道', 320115001),
(320115002, 320115, '秣陵街道', 320115002),
(320115003, 320115, '汤山街道', 320115003),
(320115004, 320115, '淳化街道', 320115004),
(320115005, 320115, '禄口街道', 320115005),
(320115006, 320115, '江宁街道', 320115006),
(320115007, 320115, '谷里街道', 320115007),
(320115100, 320115, '湖熟镇', 320115100),
(320115101, 320115, '横溪镇', 320115101),
(320115400, 320115, '江宁科学园', 320115400),
(320115401, 320115, '青龙山林场', 320115401),
(320115450, 320115, '江宁开发区', 320115450),
(320116001, 320116, '卸甲甸街道', 320116001),
(320116002, 320116, '西厂门街道', 320116002),
(320116003, 320116, '山潘街道', 320116003),
(320116004, 320116, '葛塘街道', 320116004),
(320116005, 320116, '长芦街道', 320116005),
(320116100, 320116, '雄州镇', 320116100),
(320116101, 320116, '冶山镇', 320116101),
(320116102, 320116, '八百桥镇', 320116102),
(320116103, 320116, '横梁镇', 320116103),
(320116104, 320116, '东沟镇', 320116104),
(320116105, 320116, '龙袍镇', 320116105),
(320116106, 320116, '玉带镇', 320116106),
(320116107, 320116, '瓜埠镇', 320116107),
(320116108, 320116, '新集镇', 320116108),
(320116109, 320116, '程桥镇', 320116109),
(320116110, 320116, '竹镇镇', 320116110),
(320116111, 320116, '马集镇', 320116111),
(320116112, 320116, '马鞍镇', 320116112),
(320116113, 320116, '新篁镇', 320116113),
(320116400, 320116, '六合开发区', 320116400),
(320124100, 320124, '永阳镇', 320124100),
(320124101, 320124, '白马镇', 320124101),
(320124102, 320124, '东屏镇', 320124102),
(320124103, 320124, '柘塘镇', 320124103),
(320124104, 320124, '石湫镇', 320124104),
(320124105, 320124, '洪蓝镇', 320124105),
(320124106, 320124, '晶桥镇', 320124106),
(320124107, 320124, '和凤镇', 320124107),
(320124400, 320124, '溧水县开发区', 320124400),
(320125100, 320125, '淳溪镇', 320125100),
(320125101, 320125, '阳江镇', 320125101),
(320125102, 320125, '砖墙镇', 320125102),
(320125103, 320125, '古柏镇', 320125103),
(320125104, 320125, '漆桥镇', 320125104),
(320125105, 320125, '固城镇', 320125105),
(320125106, 320125, '东坝镇', 320125106),
(320125108, 320125, '桠溪镇', 320125108),
(320125400, 320125, '高淳县团结圩良种繁育场', 320125400),
(320125401, 320125, '高淳县茶叶实验场', 320125401),
(320125402, 320125, '高淳监狱', 320125402),
(320125403, 320125, '高淳县傅家坛林场', 320125403),
(320202001, 320202, '崇安寺街道', 320202001),
(320202002, 320202, '通江街道', 320202002),
(320202003, 320202, '广瑞路街道', 320202003),
(320202004, 320202, '上马墩街道', 320202004),
(320202005, 320202, '江海街道', 320202005),
(320202006, 320202, '广益街道', 320202006),
(320203001, 320203, '迎龙桥街道', 320203001),
(320203002, 320203, '南禅寺街道', 320203002),
(320203003, 320203, '清名桥街道', 320203003),
(320203004, 320203, '金星街道', 320203004),
(320203005, 320203, '金匮街道', 320203005),
(320203006, 320203, '扬名街道', 320203006),
(320204001, 320204, '黄巷街道', 320204001),
(320204002, 320204, '山北街道', 320204002),
(320204003, 320204, '北大街街道', 320204003),
(320204004, 320204, '惠山街道', 320204004),
(320205001, 320205, '东亭街道', 320205001),
(320205101, 320205, '安镇镇', 320205101),
(320205102, 320205, '羊尖镇', 320205102),
(320205103, 320205, '鹅湖镇', 320205103),
(320205104, 320205, '东北塘镇', 320205104),
(320205105, 320205, '锡北镇', 320205105),
(320205106, 320205, '东港镇', 320205106),
(320205400, 320205, '无锡锡山开发区', 320205400),
(320206001, 320206, '堰桥街道', 320206001);
INSERT INTO `{pre}areas` VALUES
(320206002, 320206, '长安街道', 320206002),
(320206101, 320206, '前洲镇', 320206101),
(320206102, 320206, '玉祁镇', 320206102),
(320206103, 320206, '洛社镇', 320206103),
(320206104, 320206, '钱桥镇', 320206104),
(320206105, 320206, '阳山镇', 320206105),
(320206400, 320206, '无锡惠山经济开发区', 320206400),
(320211001, 320211, '河埒街道', 320211001),
(320211002, 320211, '荣巷街道', 320211002),
(320211003, 320211, '蠡园街道', 320211003),
(320211004, 320211, '蠡湖街道', 320211004),
(320211005, 320211, '滨湖街道', 320211005),
(320211006, 320211, '华庄街道', 320211006),
(320211007, 320211, '太湖街道', 320211007),
(320211008, 320211, '雪浪街道', 320211008),
(320211050, 320211, '旺庄街道', 320211050),
(320211051, 320211, '硕放街道', 320211051),
(320211052, 320211, '南站街道', 320211052),
(320211053, 320211, '坊前街道', 320211053),
(320211103, 320211, '马山镇', 320211103),
(320211104, 320211, '胡埭镇', 320211104),
(320211152, 320211, '梅村镇', 320211152),
(320211153, 320211, '鸿山镇', 320211153),
(320211450, 320211, '无锡新加坡工业园', 320211450),
(320211451, 320211, '无锡高新技术产业开发区', 320211451),
(320281100, 320281, '澄江镇', 320281100),
(320281101, 320281, '璜土镇', 320281101),
(320281102, 320281, '利港镇', 320281102),
(320281103, 320281, '申港镇', 320281103),
(320281104, 320281, '夏港镇', 320281104),
(320281105, 320281, '月城镇', 320281105),
(320281106, 320281, '青阳镇', 320281106),
(320281107, 320281, '霞客镇', 320281107),
(320281108, 320281, '南闸镇', 320281108),
(320281109, 320281, '云亭镇', 320281109),
(320281110, 320281, '华士镇', 320281110),
(320281111, 320281, '周庄镇', 320281111),
(320281112, 320281, '新桥镇', 320281112),
(320281113, 320281, '长泾镇', 320281113),
(320281114, 320281, '顾山镇', 320281114),
(320281115, 320281, '祝塘镇', 320281115),
(320281400, 320281, '江阴经济开发区新城东', 320281400),
(320281401, 320281, '江阴经济开发区港口', 320281401),
(320281402, 320281, '江阴经济开发区石庄', 320281402),
(320281403, 320281, '江阴经济开发区靖江园区', 320281403),
(320282001, 320282, '宜城街道', 320282001),
(320282002, 320282, '屺亭街道', 320282002),
(320282101, 320282, '张渚镇', 320282101),
(320282102, 320282, '西渚镇', 320282102),
(320282103, 320282, '太华镇', 320282103),
(320282104, 320282, '徐舍镇', 320282104),
(320282105, 320282, '鲸塘镇', 320282105),
(320282106, 320282, '芳庄镇', 320282106),
(320282107, 320282, '官林镇', 320282107),
(320282108, 320282, '杨巷镇', 320282108),
(320282109, 320282, '新建镇', 320282109),
(320282110, 320282, '和桥镇', 320282110),
(320282111, 320282, '高塍镇', 320282111),
(320282113, 320282, '万石镇', 320282113),
(320282114, 320282, '周铁镇', 320282114),
(320282115, 320282, '芳桥镇', 320282115),
(320282116, 320282, '新庄镇', 320282116),
(320282117, 320282, '丁蜀镇', 320282117),
(320282118, 320282, '大浦镇', 320282118),
(320282119, 320282, '湖父镇', 320282119),
(320282120, 320282, '新街镇', 320282120),
(320282400, 320282, '环科园', 320282400),
(320282401, 320282, '宜兴经济开发区', 320282401),
(320282402, 320282, '芙蓉茶场', 320282402),
(320282403, 320282, '宜兴市林场', 320282403),
(320282404, 320282, '宜兴市大贤岭林场', 320282404),
(320282405, 320282, '无锡市茶叶研究所', 320282405),
(320302001, 320302, '黄楼街道', 320302001),
(320302002, 320302, '丰财街道', 320302002),
(320302003, 320302, '琵琶街道', 320302003),
(320302004, 320302, '牌楼街道', 320302004),
(320302005, 320302, '铜沛街道', 320302005),
(320302006, 320302, '环城街道', 320302006),
(320302051, 320302, '金山桥街道', 320302051),
(320302052, 320302, '东环街道', 320302052),
(320302053, 320302, '大黄山街道', 320302053),
(320302151, 320302, '大庙镇', 320302151),
(320302152, 320302, '大黄山镇', 320302152),
(320303001, 320303, '彭城街道', 320303001),
(320303005, 320303, '子房街道', 320303005),
(320303007, 320303, '黄山街道', 320303007),
(320303008, 320303, '骆驼山街道', 320303008),
(320303010, 320303, '大郭庄街道', 320303010),
(320303011, 320303, '翠屏山街道', 320303011),
(320303012, 320303, '潘塘街道', 320303012),
(320304001, 320304, '庞庄街道', 320304001),
(320304003, 320304, '利国街道', 320304003),
(320304004, 320304, '桃园街道', 320304004),
(320304005, 320304, '三河尖街道', 320304005),
(320304006, 320304, '垞城街道', 320304006),
(320304007, 320304, '义安街道', 320304007),
(320304008, 320304, '张集街道', 320304008),
(320304009, 320304, '电厂街道', 320304009),
(320304010, 320304, '张双楼街道', 320304010),
(320304011, 320304, '九里街道', 320304011),
(320304012, 320304, '拾屯街道', 320304012),
(320304013, 320304, '苏山街道', 320304013),
(320304014, 320304, '火花街道', 320304014),
(320305001, 320305, '老矿街道', 320305001),
(320305002, 320305, '夏桥街道', 320305002),
(320305101, 320305, '贾汪镇', 320305101),
(320305102, 320305, '青山泉镇', 320305102),
(320305103, 320305, '大吴镇', 320305103),
(320305104, 320305, '紫庄镇', 320305104),
(320305105, 320305, '塔山镇', 320305105),
(320305106, 320305, '汴塘镇', 320305106),
(320305107, 320305, '江庄镇', 320305107),
(320305401, 320305, '工业园区管委会', 320305401),
(320305402, 320305, '鹿庄粮棉原种场', 320305402),
(320311001, 320311, '王陵街道', 320311001),
(320311003, 320311, '永安街道', 320311003),
(320311004, 320311, '湖滨街道', 320311004),
(320311005, 320311, '段庄街道', 320311005),
(320311006, 320311, '翟山街道', 320311006),
(320311007, 320311, '奎山街道', 320311007),
(320311008, 320311, '和平街道', 320311008),
(320311011, 320311, '泰山街道', 320311011),
(320311012, 320311, '金山街道', 320311012),
(320311014, 320311, '七里沟街道', 320311014),
(320321101, 320321, '凤城镇', 320321101),
(320321102, 320321, '首羡镇', 320321102),
(320321103, 320321, '顺河镇', 320321103),
(320321104, 320321, '常店镇', 320321104),
(320321105, 320321, '欢口镇', 320321105),
(320321106, 320321, '师寨镇', 320321106),
(320321107, 320321, '华山镇', 320321107),
(320321108, 320321, '梁寨镇', 320321108),
(320321109, 320321, '范楼镇', 320321109),
(320321110, 320321, '孙楼镇', 320321110),
(320321111, 320321, '宋楼镇', 320321111),
(320321112, 320321, '大沙河镇', 320321112),
(320321113, 320321, '王沟镇', 320321113),
(320321114, 320321, '赵庄镇', 320321114),
(320321401, 320321, '大沙河林场', 320321401),
(320322101, 320322, '龙固镇', 320322101),
(320322102, 320322, '杨屯镇', 320322102),
(320322103, 320322, '大屯镇', 320322103),
(320322104, 320322, '沛城镇', 320322104),
(320322105, 320322, '胡寨镇', 320322105),
(320322106, 320322, '魏庙镇', 320322106),
(320322107, 320322, '五段镇', 320322107),
(320322108, 320322, '张庄镇', 320322108),
(320322109, 320322, '张寨镇', 320322109),
(320322110, 320322, '敬安镇', 320322110),
(320322111, 320322, '河口镇', 320322111),
(320322112, 320322, '栖山镇', 320322112),
(320322113, 320322, '鹿楼镇', 320322113),
(320322114, 320322, '朱寨镇', 320322114),
(320322115, 320322, '安国镇', 320322115),
(320322403, 320322, '中煤集团大屯煤电(集团)公司', 320322403),
(320322451, 320322, '经济开发区', 320322451),
(320323101, 320323, '铜山镇', 320323101),
(320323102, 320323, '何桥镇', 320323102),
(320323103, 320323, '黄集镇', 320323103),
(320323104, 320323, '马坡镇', 320323104),
(320323105, 320323, '郑集镇', 320323105),
(320323106, 320323, '柳新镇', 320323106),
(320323107, 320323, '刘集镇', 320323107),
(320323108, 320323, '大彭镇', 320323108),
(320323109, 320323, '汉王镇', 320323109),
(320323110, 320323, '三堡镇', 320323110),
(320323111, 320323, '棠张镇', 320323111),
(320323112, 320323, '张集镇', 320323112),
(320323113, 320323, '房村镇', 320323113),
(320323114, 320323, '伊庄镇', 320323114),
(320323115, 320323, '单集镇', 320323115),
(320323117, 320323, '徐庄镇', 320323117),
(320323118, 320323, '大许镇', 320323118),
(320323119, 320323, '茅村镇', 320323119),
(320323120, 320323, '柳泉镇', 320323120),
(320323121, 320323, '利国镇', 320323121),
(320323401, 320323, '国营沿湖农', 320323401),
(320324101, 320324, '睢城镇', 320324101),
(320324102, 320324, '王集镇', 320324102),
(320324103, 320324, '双沟镇', 320324103),
(320324104, 320324, '岚山镇', 320324104),
(320324105, 320324, '李集镇', 320324105),
(320324106, 320324, '桃园镇', 320324106),
(320324107, 320324, '官山镇', 320324107),
(320324108, 320324, '高作镇', 320324108),
(320324109, 320324, '沙集镇', 320324109),
(320324110, 320324, '凌城镇', 320324110),
(320324111, 320324, '邱集镇', 320324111),
(320324112, 320324, '古邳镇', 320324112),
(320324113, 320324, '姚集镇', 320324113),
(320324114, 320324, '魏集镇', 320324114),
(320324115, 320324, '梁集镇', 320324115),
(320324116, 320324, '庆安镇', 320324116),
(320324451, 320324, '经济开发区', 320324451),
(320381101, 320381, '新安镇', 320381101),
(320381102, 320381, '瓦窑镇', 320381102),
(320381103, 320381, '港头镇', 320381103),
(320381104, 320381, '唐店镇', 320381104),
(320381105, 320381, '合沟镇', 320381105),
(320381106, 320381, '草桥镇', 320381106),
(320381107, 320381, '窑湾镇', 320381107),
(320381108, 320381, '棋盘镇', 320381108),
(320381110, 320381, '新店镇', 320381110),
(320381111, 320381, '邵店镇', 320381111),
(320381112, 320381, '北沟镇', 320381112),
(320381113, 320381, '时集镇', 320381113),
(320381114, 320381, '高流镇', 320381114),
(320381115, 320381, '阿湖镇', 320381115),
(320381116, 320381, '双塘镇', 320381116),
(320381117, 320381, '马岭山镇', 320381117),
(320381451, 320381, '经济开发区', 320381451),
(320382101, 320382, '运河镇', 320382101),
(320382102, 320382, '邳城镇', 320382102),
(320382103, 320382, '官湖镇', 320382103),
(320382104, 320382, '四户镇', 320382104),
(320382105, 320382, '宿羊山镇', 320382105),
(320382106, 320382, '八义集镇', 320382106),
(320382107, 320382, '土山镇', 320382107),
(320382108, 320382, '碾庄镇', 320382108),
(320382109, 320382, '港上镇', 320382109),
(320382110, 320382, '邹庄镇', 320382110),
(320382111, 320382, '占城镇', 320382111),
(320382112, 320382, '新河镇', 320382112),
(320382113, 320382, '八路镇', 320382113),
(320382114, 320382, '炮车镇', 320382114),
(320382115, 320382, '铁富镇', 320382115),
(320382116, 320382, '岔河镇', 320382116),
(320382117, 320382, '戴圩镇', 320382117),
(320382118, 320382, '陈楼镇', 320382118),
(320382119, 320382, '邢楼镇', 320382119),
(320382120, 320382, '戴庄镇', 320382120),
(320382121, 320382, '车辐山镇', 320382121),
(320382122, 320382, '燕子埠镇', 320382122),
(320382123, 320382, '赵墩镇', 320382123),
(320382124, 320382, '议堂镇', 320382124),
(320382401, 320382, '邳城农场', 320382401),
(320382402, 320382, '张楼农场', 320382402),
(320402001, 320402, '雕庄街道', 320402001),
(320402002, 320402, '青龙街道', 320402002),
(320402003, 320402, '茶山街道', 320402003),
(320402004, 320402, '红梅街道', 320402004),
(320402005, 320402, '天宁街道', 320402005),
(320402006, 320402, '兰陵街道', 320402006),
(320404001, 320404, '五星街道', 320404001),
(320404002, 320404, '永红街道', 320404002),
(320404003, 320404, '北港街道', 320404003),
(320404004, 320404, '西林街道', 320404004),
(320404005, 320404, '南大街街道', 320404005),
(320404006, 320404, '荷花池街道', 320404006),
(320404100, 320404, '新闸镇', 320404100),
(320405001, 320405, '戚墅堰街道', 320405001),
(320405100, 320405, '丁堰镇', 320405100),
(320405101, 320405, '潞城镇', 320405101),
(320411001, 320411, '河海街道', 320411001),
(320411002, 320411, '三井街道', 320411002),
(320411003, 320411, '龙虎塘街道', 320411003),
(320411100, 320411, '春江镇', 320411100),
(320411101, 320411, '孟河镇', 320411101),
(320411102, 320411, '新桥镇', 320411102),
(320411103, 320411, '薛家镇', 320411103),
(320411104, 320411, '罗溪镇', 320411104),
(320411105, 320411, '西夏墅镇', 320411105),
(320412100, 320412, '湖塘镇', 320412100),
(320412102, 320412, '牛塘镇', 320412102),
(320412103, 320412, '洛阳镇', 320412103),
(320412104, 320412, '遥观镇', 320412104),
(320412105, 320412, '横林镇', 320412105),
(320412106, 320412, '横山桥镇', 320412106),
(320412107, 320412, '芙蓉镇', 320412107),
(320412108, 320412, '焦溪镇', 320412108),
(320412109, 320412, '郑陆镇', 320412109),
(320412110, 320412, '雪堰镇', 320412110),
(320412111, 320412, '潘家镇', 320412111),
(320412112, 320412, '漕桥镇', 320412112),
(320412113, 320412, '前黄镇', 320412113),
(320412114, 320412, '礼嘉镇', 320412114),
(320412115, 320412, '寨桥镇', 320412115),
(320412116, 320412, '邹区镇', 320412116),
(320412117, 320412, '卜弋镇', 320412117),
(320412118, 320412, '夏溪镇', 320412118),
(320412119, 320412, '嘉泽镇', 320412119),
(320412120, 320412, '湟里镇', 320412120),
(320412121, 320412, '东安镇', 320412121),
(320412122, 320412, '奔牛镇', 320412122),
(320412400, 320412, '武进经济开发区', 320412400),
(320412401, 320412, '运村农科良种场', 320412401),
(320412402, 320412, '奔牛稻麦原种场', 320412402),
(320412403, 320412, '郑陆良种繁育场', 320412403),
(320412404, 320412, '夏溪良种繁育场', 320412404),
(320412405, 320412, '蚕种场', 320412405),
(320412406, 320412, '前黄苗圃', 320412406),
(320412407, 320412, '水产养殖场', 320412407),
(320412408, 320412, '种兔场', 320412408),
(320412409, 320412, '横山苗圃', 320412409),
(320412410, 320412, '公路苗圃', 320412410),
(320412411, 320412, '高新区', 320412411),
(320481100, 320481, '溧城镇', 320481100),
(320481101, 320481, '埭头镇', 320481101),
(320481102, 320481, '上黄镇', 320481102),
(320481103, 320481, '戴埠镇', 320481103),
(320481104, 320481, '横涧镇', 320481104),
(320481106, 320481, '天目湖镇', 320481106),
(320481107, 320481, '别桥镇', 320481107),
(320481108, 320481, '绸缪镇', 320481108),
(320481109, 320481, '上兴镇', 320481109),
(320481110, 320481, '上沛镇', 320481110),
(320481111, 320481, '竹箦镇', 320481111),
(320481112, 320481, '后周镇', 320481112),
(320481113, 320481, '前马镇', 320481113),
(320481114, 320481, '南渡镇', 320481114),
(320481115, 320481, '新昌镇', 320481115),
(320481116, 320481, '社渚镇', 320481116),
(320481117, 320481, '周城镇', 320481117),
(320481400, 320481, '常州监狱', 320481400),
(320481401, 320481, '溧阳监狱', 320481401),
(320482100, 320482, '金城镇', 320482100),
(320482101, 320482, '白塔镇', 320482101),
(320482102, 320482, '河头镇', 320482102),
(320482103, 320482, '水北镇', 320482103),
(320482104, 320482, '儒林镇', 320482104),
(320482105, 320482, '尧塘镇', 320482105),
(320482106, 320482, '直溪镇', 320482106),
(320482107, 320482, '建昌镇', 320482107),
(320482108, 320482, '朱林镇', 320482108),
(320482109, 320482, '薛埠镇', 320482109),
(320482110, 320482, '茅麓镇', 320482110),
(320482111, 320482, '社头镇', 320482111),
(320482112, 320482, '指前镇', 320482112),
(320482113, 320482, '洮西镇', 320482113),
(320482114, 320482, '西岗镇', 320482114),
(320482400, 320482, '开发区', 320482400),
(320502001, 320502, '双塔街道', 320502001),
(320502002, 320502, '南门街道', 320502002),
(320502003, 320502, '胥江街道', 320502003),
(320502004, 320502, '吴门桥街道', 320502004),
(320502005, 320502, '葑门街道', 320502005),
(320502006, 320502, '友新街道', 320502006),
(320503001, 320503, '观前街道', 320503001),
(320503002, 320503, '平江路街道', 320503002),
(320503003, 320503, '苏锦街道', 320503003),
(320503004, 320503, '娄门街道', 320503004),
(320503005, 320503, '城北街道', 320503005),
(320503006, 320503, '桃花坞街道', 320503006),
(320503150, 320503, '娄葑镇', 320503150),
(320503152, 320503, '唯亭镇', 320503152),
(320503153, 320503, '胜浦镇', 320503153),
(320503199, 320503, '虚拟镇', 320503199),
(320504001, 320504, '石路街道', 320504001),
(320504002, 320504, '彩香街道', 320504002),
(320504003, 320504, '留园街道', 320504003),
(320504004, 320504, '虎丘街道', 320504004),
(320504005, 320504, '白洋湾街道', 320504005),
(320505001, 320505, '横塘街道', 320505001),
(320505002, 320505, '狮山街道', 320505002),
(320505003, 320505, '枫桥街道', 320505003),
(320505004, 320505, '镇湖街道', 320505004),
(320505100, 320505, '浒墅关镇', 320505100),
(320505101, 320505, '通安镇', 320505101),
(320505102, 320505, '东渚镇', 320505102),
(320505400, 320505, '高新区浒墅关开发分区', 320505400),
(320505403, 320505, '苏州高新区出口加工区', 320505403),
(320505405, 320505, '苏州高新技术创业服务中心', 320505405),
(320505406, 320505, '苏州高新物流中心', 320505406),
(320505407, 320505, '苏州科技城', 320505407),
(320506001, 320506, '长桥街道', 320506001),
(320506003, 320506, '越溪街道', 320506003),
(320506004, 320506, '郭巷街道', 320506004),
(320506005, 320506, '横泾街道', 320506005),
(320506006, 320506, '香山街道', 320506006),
(320506007, 320506, '苏苑街道', 320506007),
(320506008, 320506, '龙西街道', 320506008),
(320506009, 320506, '城南街道', 320506009),
(320506100, 320506, '甪直镇', 320506100),
(320506101, 320506, '车坊镇', 320506101),
(320506102, 320506, '藏书镇', 320506102),
(320506103, 320506, '木渎镇', 320506103),
(320506104, 320506, '胥口镇', 320506104),
(320506105, 320506, '浦庄镇', 320506105),
(320506106, 320506, '渡村镇', 320506106),
(320506107, 320506, '东山镇', 320506107),
(320506108, 320506, '光福镇', 320506108),
(320506109, 320506, '西山镇', 320506109),
(320506400, 320506, '江苏省太湖采石公司', 320506400),
(320506401, 320506, '吴中区林场', 320506401),
(320506402, 320506, '西山农业园区', 320506402),
(320507001, 320507, '元和街道', 320507001),
(320507002, 320507, '太平街道', 320507002),
(320507003, 320507, '黄桥街道', 320507003),
(320507100, 320507, '望亭镇', 320507100),
(320507102, 320507, '黄埭镇', 320507102),
(320507105, 320507, '渭塘镇', 320507105),
(320507106, 320507, '北桥镇', 320507106),
(320507109, 320507, '阳澄湖镇', 320507109),
(320507400, 320507, '开发区', 320507400),
(320581100, 320581, '虞山镇', 320581100),
(320581101, 320581, '梅李镇', 320581101),
(320581102, 320581, '海虞镇', 320581102),
(320581103, 320581, '新港镇', 320581103),
(320581104, 320581, '古里镇', 320581104),
(320581105, 320581, '沙家浜镇', 320581105),
(320581106, 320581, '支塘镇', 320581106),
(320581107, 320581, '董浜镇', 320581107),
(320581110, 320581, '辛庄镇', 320581110),
(320581111, 320581, '尚湖镇', 320581111),
(320581400, 320581, '虞山林场', 320581400),
(320581401, 320581, '常熟经济开发区', 320581401),
(320581402, 320581, '常熟东南开发区', 320581402),
(320582100, 320582, '杨舍镇', 320582100),
(320582101, 320582, '塘桥镇', 320582101),
(320582102, 320582, '金港镇', 320582102),
(320582103, 320582, '锦丰镇', 320582103),
(320582104, 320582, '乐余镇', 320582104),
(320582105, 320582, '凤凰镇', 320582105),
(320582106, 320582, '南丰镇', 320582106),
(320582107, 320582, '大新镇', 320582107),
(320582400, 320582, '常阴沙管理区', 320582400),
(320582401, 320582, '江苏省张家港经济技术开发区', 320582401),
(320582402, 320582, '张家港市沿江开发办', 320582402),
(320582403, 320582, '张家港保税区', 320582403),
(320582404, 320582, '张家港市稻麦良种场', 320582404),
(320582405, 320582, '张家港市畜禽良种场', 320582405),
(320583100, 320583, '玉山镇', 320583100),
(320583101, 320583, '巴城镇', 320583101),
(320583102, 320583, '周市镇', 320583102),
(320583103, 320583, '陆家镇', 320583103),
(320583104, 320583, '花桥镇', 320583104),
(320583105, 320583, '淀山湖镇', 320583105),
(320583106, 320583, '张浦镇', 320583106),
(320583107, 320583, '周庄镇', 320583107),
(320583108, 320583, '千灯镇', 320583108),
(320583109, 320583, '锦溪镇', 320583109),
(320583400, 320583, '开发区', 320583400),
(320584100, 320584, '松陵镇', 320584100),
(320584101, 320584, '同里镇', 320584101),
(320584104, 320584, '平望镇', 320584104),
(320584105, 320584, '盛泽镇', 320584105),
(320584106, 320584, '横扇镇', 320584106),
(320584107, 320584, '七都镇', 320584107),
(320584108, 320584, '震泽镇', 320584108),
(320584109, 320584, '桃源镇', 320584109),
(320584110, 320584, '汾湖镇', 320584110),
(320584400, 320584, '经济开发区', 320584400),
(320584401, 320584, '东方丝绸市场', 320584401),
(320585100, 320585, '城厢镇', 320585100),
(320585101, 320585, '沙溪镇', 320585101),
(320585102, 320585, '浏河镇', 320585102),
(320585103, 320585, '浮桥镇', 320585103),
(320585104, 320585, '璜泾镇', 320585104),
(320585105, 320585, '双凤镇', 320585105),
(320585106, 320585, '陆渡镇', 320585106),
(320585400, 320585, '经济开发区', 320585400),
(320585401, 320585, '港区', 320585401),
(320602001, 320602, '城东街道', 320602001),
(320602002, 320602, '和平桥街道', 320602002),
(320602003, 320602, '任港街道', 320602003),
(320602004, 320602, '新城桥街道', 320602004),
(320602005, 320602, '虹桥街道', 320602005),
(320602006, 320602, '学田街道', 320602006),
(320602007, 320602, '钟秀街道', 320602007),
(320602008, 320602, '文峰街道', 320602008),
(320602050, 320602, '中兴街道', 320602050),
(320602100, 320602, '观音山镇', 320602100),
(320602101, 320602, '狼山镇', 320602101),
(320602150, 320602, '新开镇', 320602150),
(320602151, 320602, '竹行镇', 320602151),
(320602152, 320602, '小海镇', 320602152),
(320602450, 320602, '江苏省国营南通农场', 320602450),
(320602451, 320602, '南通市富民港良种场', 320602451),
(320602452, 320602, '南通市富民港种畜场', 320602452),
(320611001, 320611, '永兴街道', 320611001),
(320611002, 320611, '唐闸镇街道', 320611002),
(320611003, 320611, '天生港镇街道', 320611003),
(320611004, 320611, '秦灶街道', 320611004),
(320611202, 320611, '陈桥乡', 320611202),
(320611203, 320611, '幸福乡', 320611203),
(320611400, 320611, '港闸开发区', 320611400),
(320621100, 320621, '海安镇', 320621100),
(320621101, 320621, '城东镇', 320621101),
(320621102, 320621, '曲塘镇', 320621102),
(320621103, 320621, '李堡镇', 320621103),
(320621104, 320621, '老坝港镇', 320621104),
(320621105, 320621, '角斜镇', 320621105),
(320621106, 320621, '西场镇', 320621106),
(320621107, 320621, '大公镇', 320621107),
(320621108, 320621, '孙庄镇', 320621108),
(320621109, 320621, '雅周镇', 320621109),
(320621110, 320621, '胡集镇', 320621110),
(320621111, 320621, '白甸镇', 320621111),
(320621112, 320621, '南莫镇', 320621112),
(320621113, 320621, '墩头镇', 320621113),
(320621400, 320621, '海安县农场', 320621400),
(320623100, 320623, '栟茶镇', 320623100),
(320623101, 320623, '洋口镇', 320623101),
(320623102, 320623, '苴镇', 320623102),
(320623103, 320623, '长沙镇', 320623103),
(320623104, 320623, '大豫镇', 320623104),
(320623105, 320623, '掘港镇', 320623105),
(320623106, 320623, '兵房镇', 320623106),
(320623107, 320623, '马塘镇', 320623107),
(320623108, 320623, '丰利镇', 320623108),
(320623109, 320623, '曹埠镇', 320623109),
(320623110, 320623, '岔河镇', 320623110),
(320623111, 320623, '双甸镇', 320623111),
(320623112, 320623, '新店镇', 320623112),
(320623113, 320623, '河口镇', 320623113),
(320623114, 320623, '袁庄镇', 320623114),
(320681100, 320681, '汇龙镇', 320681100),
(320681101, 320681, '大兴镇', 320681101),
(320681102, 320681, '南阳镇', 320681102),
(320681103, 320681, '惠丰镇', 320681103),
(320681104, 320681, '民主镇', 320681104),
(320681105, 320681, '北新镇', 320681105),
(320681106, 320681, '久隆镇', 320681106),
(320681107, 320681, '王鲍镇', 320681107),
(320681108, 320681, '合作镇', 320681108),
(320681109, 320681, '志良镇', 320681109),
(320681110, 320681, '吕四港镇', 320681110),
(320681111, 320681, '天汾镇', 320681111),
(320681112, 320681, '兆民镇', 320681112),
(320681113, 320681, '海复镇', 320681113),
(320681114, 320681, '少直镇', 320681114),
(320681115, 320681, '向阳镇', 320681115),
(320681116, 320681, '东元镇', 320681116),
(320681117, 320681, '近海镇', 320681117),
(320681118, 320681, '寅阳镇', 320681118),
(320681119, 320681, '和合镇', 320681119),
(320681120, 320681, '惠萍镇', 320681120),
(320681121, 320681, '新安镇', 320681121),
(320681122, 320681, '东海镇', 320681122),
(320681200, 320681, '启隆乡', 320681200),
(320681400, 320681, '启东经济开发区', 320681400),
(320682100, 320682, '"如城镇', 320682100),
(320682101, 320682, '"柴湾镇', 320682101),
(320682102, 320682, '"雪岸镇', 320682102),
(320682103, 320682, '"东陈镇', 320682103),
(320682104, 320682, '"丁堰镇', 320682104),
(320682105, 320682, '"白蒲镇', 320682105),
(320682106, 320682, '"林梓镇', 320682106),
(320682107, 320682, '"下原镇', 320682107),
(320682108, 320682, '"九华镇', 320682108),
(320682109, 320682, '"郭园镇', 320682109),
(320682110, 320682, '"石庄镇', 320682110),
(320682111, 320682, '"长江镇', 320682111),
(320682112, 320682, '"吴窑镇', 320682112),
(320682113, 320682, '"江安镇', 320682113),
(320682114, 320682, '"高明镇', 320682114),
(320682115, 320682, '"常青镇', 320682115),
(320682116, 320682, '"搬经镇', 320682116),
(320682117, 320682, '"磨头镇', 320682117),
(320682118, 320682, '"桃园镇', 320682118),
(320682119, 320682, '"袁桥镇', 320682119),
(320682400, 320682, '如皋市经济开发区', 320682400),
(320682401, 320682, '"如皋港开发区', 320682401),
(320682402, 320682, '南通市粮棉原种场', 320682402),
(320682403, 320682, '"如皋市蚕种场', 320682403),
(320682404, 320682, '"如皋市良种场', 320682404),
(320682405, 320682, '如皋市棉花原种场', 320682405),
(320682406, 320682, '"如皋市种猪场', 320682406),
(320682407, 320682, '"如皋市农科所', 320682407),
(320682408, 320682, '如皋市江滨医院', 320682408),
(320682409, 320682, '如皋市中心沙水产养殖场', 320682409),
(320682410, 320682, '如皋市九华水产养殖场', 320682410),
(320683100, 320683, '金沙镇', 320683100),
(320683101, 320683, '西亭镇', 320683101),
(320683102, 320683, '二甲镇', 320683102),
(320683103, 320683, '东社镇', 320683103),
(320683104, 320683, '三余镇', 320683104),
(320683105, 320683, '北兴桥镇', 320683105),
(320683106, 320683, '海晏镇', 320683106),
(320683107, 320683, '十总镇', 320683107),
(320683108, 320683, '骑岸镇', 320683108),
(320683109, 320683, '五甲镇', 320683109),
(320683110, 320683, '石港镇', 320683110),
(320683111, 320683, '四安镇', 320683111),
(320683112, 320683, '刘桥镇', 320683112),
(320683113, 320683, '新联镇', 320683113),
(320683114, 320683, '平潮镇', 320683114),
(320683115, 320683, '平东镇', 320683115),
(320683116, 320683, '五接镇', 320683116),
(320683117, 320683, '兴仁镇', 320683117),
(320683118, 320683, '兴东镇', 320683118),
(320683119, 320683, '张芝山镇', 320683119),
(320683120, 320683, '川港镇', 320683120),
(320683121, 320683, '先锋镇', 320683121),
(320683122, 320683, '姜灶镇', 320683122),
(320683400, 320683, '通州市开发区', 320683400),
(320683401, 320683, '环本农场', 320683401),
(320683403, 320683, '通州港区管委会', 320683403),
(320684100, 320684, '海门镇', 320684100),
(320684101, 320684, '三星镇', 320684101),
(320684102, 320684, '天补镇', 320684102),
(320684103, 320684, '三和镇', 320684103),
(320684104, 320684, '德胜镇', 320684104),
(320684105, 320684, '三厂镇', 320684105),
(320684106, 320684, '常乐镇', 320684106),
(320684107, 320684, '麒麟镇', 320684107),
(320684108, 320684, '悦来镇', 320684108),
(320684109, 320684, '万年镇', 320684109),
(320684110, 320684, '三阳镇', 320684110),
(320684111, 320684, '四甲镇', 320684111),
(320684112, 320684, '货隆镇', 320684112),
(320684113, 320684, '余东镇', 320684113),
(320684114, 320684, '正余镇', 320684114),
(320684115, 320684, '包场镇', 320684115),
(320684116, 320684, '刘浩镇', 320684116),
(320684117, 320684, '东灶港镇', 320684117),
(320684118, 320684, '临江镇', 320684118),
(320684119, 320684, '王浩镇', 320684119),
(320684120, 320684, '树勋镇', 320684120),
(320684200, 320684, '海永乡', 320684200),
(320684400, 320684, '海门市经济技术开发区', 320684400),
(320684401, 320684, '海门市永隆沙农场', 320684401),
(320684403, 320684, '海门市大东农场', 320684403),
(320684404, 320684, '海门市畜禽良种场', 320684404),
(320684405, 320684, '海门市种羊场', 320684405),
(320684406, 320684, '海门市包场渔场', 320684406),
(320684407, 320684, '海门市长江芦荡养殖场', 320684407),
(320684408, 320684, '海门市沿江渔场', 320684408),
(320684409, 320684, '海门市三厂苗圃', 320684409),
(320684410, 320684, '海门市农科所', 320684410),
(320684411, 320684, '海门市海门盐场', 320684411),
(320684412, 320684, '海门市财政局芦荡管理所', 320684412),
(320684413, 320684, '江苏省国营江心沙农场', 320684413),
(320703001, 320703, '墟沟街道', 320703001),
(320703003, 320703, '连云街道', 320703003),
(320703004, 320703, '云山街道', 320703004),
(320703005, 320703, '板桥街道', 320703005),
(320703006, 320703, '连岛街道', 320703006),
(320703050, 320703, '中云街道', 320703050),
(320703051, 320703, '猴嘴街道', 320703051),
(320703150, 320703, '朝阳镇', 320703150),
(320703201, 320703, '宿城乡', 320703201),
(320703202, 320703, '高公岛乡', 320703202),
(320703203, 320703, '前三岛乡', 320703203),
(320703400, 320703, '连云港碱厂', 320703400),
(320705001, 320705, '浦东街道', 320705001),
(320705002, 320705, '浦西街道', 320705002),
(320705003, 320705, '新东街道', 320705003),
(320705004, 320705, '新南街道', 320705004),
(320705005, 320705, '路南街道', 320705005),
(320705006, 320705, '新海街道', 320705006),
(320705100, 320705, '南城镇', 320705100),
(320705200, 320705, '云台乡', 320705200),
(320705201, 320705, '花果山乡', 320705201),
(320705202, 320705, '宁海乡', 320705202),
(320705400, 320705, '云台农场', 320705400),
(320705401, 320705, '南云台林场', 320705401),
(320705402, 320705, '花果山风景区', 320705402),
(320706001, 320706, '海州街道', 320706001),
(320706002, 320706, '幸福路街道', 320706002),
(320706003, 320706, '朐阳街道', 320706003),
(320706004, 320706, '洪门街道', 320706004),
(320706100, 320706, '新坝镇', 320706100),
(320706101, 320706, '锦屏镇', 320706101),
(320721100, 320721, '青口镇', 320721100),
(320721101, 320721, '柘汪镇', 320721101),
(320721102, 320721, '石桥镇', 320721102),
(320721103, 320721, '金山镇', 320721103),
(320721104, 320721, '黑林镇', 320721104),
(320721105, 320721, '厉庄镇', 320721105),
(320721106, 320721, '海头镇', 320721106),
(320721107, 320721, '塔山镇', 320721107),
(320721108, 320721, '赣马镇', 320721108),
(320721109, 320721, '班庄镇', 320721109),
(320721110, 320721, '城头镇', 320721110),
(320721111, 320721, '门河镇', 320721111),
(320721112, 320721, '城西镇', 320721112),
(320721113, 320721, '欢墩镇', 320721113),
(320721114, 320721, '宋庄镇', 320721114),
(320721115, 320721, '沙河镇', 320721115),
(320721116, 320721, '墩尚镇', 320721116),
(320721117, 320721, '罗阳镇', 320721117),
(320721400, 320721, '沙河子园艺场', 320721400),
(320721401, 320721, '青口盐场', 320721401),
(320721402, 320721, '江苏省赣榆海洋经济开发区', 320721402),
(320721403, 320721, '江苏省赣榆经济开发区', 320721403),
(320722100, 320722, '牛山镇', 320722100),
(320722101, 320722, '白塔埠镇', 320722101),
(320722102, 320722, '浦南镇', 320722102),
(320722103, 320722, '黄川镇', 320722103),
(320722104, 320722, '石梁河镇', 320722104),
(320722105, 320722, '青湖镇', 320722105),
(320722106, 320722, '石榴镇', 320722106),
(320722107, 320722, '温泉镇', 320722107),
(320722108, 320722, '双店镇', 320722108),
(320722109, 320722, '桃林镇', 320722109),
(320722110, 320722, '洪庄镇', 320722110),
(320722111, 320722, '安峰镇', 320722111),
(320722112, 320722, '房山镇', 320722112),
(320722113, 320722, '平明镇', 320722113),
(320722200, 320722, '驼峰乡', 320722200),
(320722201, 320722, '南辰乡', 320722201),
(320722202, 320722, '横沟乡', 320722202),
(320722203, 320722, '李埝乡', 320722203),
(320722204, 320722, '山左口乡', 320722204),
(320722205, 320722, '石湖乡', 320722205),
(320722206, 320722, '曲阳乡', 320722206),
(320722207, 320722, '张湾乡', 320722207),
(320722400, 320722, '岗埠农场', 320722400),
(320722401, 320722, '江苏东海经济开发区', 320722401),
(320723100, 320723, '伊山镇', 320723100),
(320723101, 320723, '板浦镇', 320723101),
(320723102, 320723, '杨集镇', 320723102),
(320723103, 320723, '燕尾港镇', 320723103),
(320723104, 320723, '同兴镇', 320723104),
(320723105, 320723, '四队镇', 320723105),
(320723106, 320723, '圩丰镇', 320723106),
(320723107, 320723, '龙苴镇', 320723107),
(320723201, 320723, '伊芦乡', 320723201),
(320723202, 320723, '鲁河乡', 320723202),
(320723203, 320723, '图河乡', 320723203),
(320723204, 320723, '沂北乡', 320723204),
(320723205, 320723, '下车乡', 320723205),
(320723206, 320723, '白蚬乡', 320723206),
(320723207, 320723, '东王集乡', 320723207),
(320723208, 320723, '侍庄乡', 320723208),
(320723209, 320723, '小伊乡', 320723209),
(320723210, 320723, '穆圩乡', 320723210),
(320723211, 320723, '陡沟乡', 320723211),
(320723212, 320723, '南岗乡', 320723212),
(320723400, 320723, '东辛农场', 320723400),
(320723401, 320723, '五图河农场', 320723401),
(320723402, 320723, '灌西盐场', 320723402),
(320724100, 320724, '新安镇', 320724100),
(320724101, 320724, '堆沟港镇', 320724101),
(320724102, 320724, '长茂镇', 320724102),
(320724103, 320724, '北陈集镇', 320724103),
(320724104, 320724, '张店镇', 320724104),
(320724105, 320724, '三口镇', 320724105),
(320724106, 320724, '孟兴庄镇', 320724106),
(320724107, 320724, '汤沟镇', 320724107),
(320724108, 320724, '百禄镇', 320724108),
(320724200, 320724, '五队乡', 320724200),
(320724201, 320724, '田楼乡', 320724201),
(320724204, 320724, '李集乡', 320724204),
(320724206, 320724, '新集乡', 320724206),
(320724207, 320724, '花园乡', 320724207),
(320802001, 320802, '北京路街道', 320802001),
(320802002, 320802, '长西街道', 320802002),
(320802003, 320802, '淮海街道', 320802003),
(320802004, 320802, '长东街道', 320802004),
(320802005, 320802, '西安路街道', 320802005),
(320802006, 320802, '水渡口街道', 320802006),
(320802050, 320802, '东湖街道', 320802050),
(320802051, 320802, '新港街道', 320802051),
(320802052, 320802, '广州路街道', 320802052),
(320802350, 320802, '钵池乡', 320802350),
(320802351, 320802, '徐杨乡', 320802351),
(320802400, 320802, '京沪路', 320802400),
(320803100, 320803, '淮城镇', 320803100),
(320803101, 320803, '平桥镇', 320803101),
(320803102, 320803, '上河镇', 320803102),
(320803103, 320803, '马甸镇', 320803103),
(320803104, 320803, '朱桥镇', 320803104),
(320803105, 320803, '溪河镇', 320803105),
(320803106, 320803, '施河镇', 320803106),
(320803107, 320803, '车桥镇', 320803107),
(320803108, 320803, '泾口镇', 320803108),
(320803109, 320803, '流均镇', 320803109),
(320803110, 320803, '博里镇', 320803110),
(320803111, 320803, '仇桥镇', 320803111),
(320803112, 320803, '复兴镇', 320803112),
(320803113, 320803, '苏嘴镇', 320803113),
(320803114, 320803, '钦工镇', 320803114),
(320803115, 320803, '顺河镇', 320803115),
(320803116, 320803, '季桥镇', 320803116),
(320803117, 320803, '席桥镇', 320803117),
(320803118, 320803, '林集镇', 320803118),
(320803119, 320803, '南闸镇', 320803119),
(320803120, 320803, '范集镇', 320803120),
(320803200, 320803, '建淮乡', 320803200),
(320803201, 320803, '茭陵乡', 320803201),
(320803202, 320803, '宋集乡', 320803202),
(320803203, 320803, '城东乡', 320803203),
(320803204, 320803, '南马厂乡', 320803204),
(320803205, 320803, '三堡乡', 320803205),
(320803400, 320803, '白马湖农场', 320803400),
(320804100, 320804, '王营镇', 320804100),
(320804101, 320804, '赵集镇', 320804101),
(320804102, 320804, '吴城镇', 320804102),
(320804103, 320804, '南陈集镇', 320804103),
(320804104, 320804, '码头镇', 320804104),
(320804105, 320804, '王兴镇', 320804105),
(320804106, 320804, '棉花庄镇', 320804106),
(320804107, 320804, '丁集镇', 320804107),
(320804108, 320804, '五里镇', 320804108),
(320804109, 320804, '徐溜镇', 320804109),
(320804110, 320804, '渔沟镇', 320804110),
(320804111, 320804, '吴集镇', 320804111),
(320804112, 320804, '西宋集镇', 320804112),
(320804113, 320804, '三树镇', 320804113),
(320804200, 320804, '韩桥乡', 320804200),
(320804201, 320804, '新渡乡', 320804201),
(320804202, 320804, '老张集乡', 320804202),
(320804203, 320804, '凌桥乡', 320804203),
(320804204, 320804, '袁集乡', 320804204),
(320804205, 320804, '刘老庄乡', 320804205),
(320804206, 320804, '古寨乡', 320804206),
(320804400, 320804, '工业园管理委员会', 320804400),
(320811001, 320811, '清江街道', 320811001),
(320811002, 320811, '浦楼街道', 320811002),
(320811003, 320811, '闸口街道', 320811003),
(320811004, 320811, '清安街道', 320811004),
(320811100, 320811, '和平镇', 320811100),
(320811101, 320811, '武墩镇', 320811101),
(320811102, 320811, '盐河镇', 320811102),
(320811200, 320811, '城南乡', 320811200),
(320811201, 320811, '黄码乡', 320811201),
(320826100, 320826, '涟城镇', 320826100),
(320826101, 320826, '高沟镇', 320826101),
(320826102, 320826, '唐集镇', 320826102),
(320826103, 320826, '保滩镇', 320826103),
(320826104, 320826, '大东镇', 320826104),
(320826105, 320826, '五港镇', 320826105),
(320826106, 320826, '梁岔镇', 320826106),
(320826107, 320826, '石湖镇', 320826107),
(320826108, 320826, '朱码镇', 320826108),
(320826109, 320826, '岔庙镇', 320826109),
(320826110, 320826, '东胡集镇', 320826110),
(320826111, 320826, '南集镇', 320826111),
(320826112, 320826, '义兴镇', 320826112),
(320826113, 320826, '成集镇', 320826113),
(320826114, 320826, '红窑镇', 320826114),
(320826115, 320826, '陈师镇', 320826115),
(320826116, 320826, '前进镇', 320826116),
(320826200, 320826, '徐集乡', 320826200),
(320826201, 320826, '黄营乡', 320826201),
(320826400, 320826, '杨口', 320826400),
(320826401, 320826, '方渡', 320826401),
(320826402, 320826, '南禄', 320826402),
(320826403, 320826, '小李集', 320826403),
(320826404, 320826, '河网', 320826404),
(320826405, 320826, '时码', 320826405),
(320826406, 320826, '北集', 320826406),
(320826407, 320826, '灰墩', 320826407),
(320826408, 320826, '余圩', 320826408),
(320826409, 320826, '浅集', 320826409),
(320826410, 320826, '蒋庵', 320826410),
(320826411, 320826, '经济开发新区', 320826411),
(320826412, 320826, '经济开发区', 320826412),
(320829100, 320829, '高良涧镇', 320829100),
(320829101, 320829, '蒋坝镇', 320829101),
(320829102, 320829, '仁和镇', 320829102),
(320829103, 320829, '岔河镇', 320829103),
(320829104, 320829, '西顺河镇', 320829104),
(320829105, 320829, '老子山镇', 320829105),
(320829106, 320829, '三河镇', 320829106),
(320829107, 320829, '朱坝镇', 320829107),
(320829108, 320829, '黄集镇', 320829108),
(320829109, 320829, '万集镇', 320829109),
(320829110, 320829, '东双沟镇', 320829110),
(320829111, 320829, '共和镇', 320829111),
(320830100, 320830, '盱城镇', 320830100),
(320830101, 320830, '马坝镇', 320830101),
(320830102, 320830, '官滩镇', 320830102),
(320830103, 320830, '旧铺镇', 320830103),
(320830104, 320830, '桂五镇', 320830104),
(320830105, 320830, '管镇镇', 320830105),
(320830106, 320830, '河桥镇', 320830106),
(320830107, 320830, '鲍集镇', 320830107),
(320830108, 320830, '黄花塘镇', 320830108),
(320830109, 320830, '明祖陵镇', 320830109),
(320830110, 320830, '铁佛镇', 320830110),
(320830111, 320830, '淮河镇', 320830111),
(320830112, 320830, '仇集镇', 320830112),
(320830113, 320830, '观音寺镇', 320830113),
(320830200, 320830, '维桥乡', 320830200),
(320830201, 320830, '穆店乡', 320830201),
(320830202, 320830, '王店乡', 320830202),
(320830203, 320830, '古桑乡', 320830203),
(320830204, 320830, '兴隆乡', 320830204),
(320830400, 320830, '三河农场', 320830400),
(320830401, 320830, '淮化集团', 320830401),
(320831100, 320831, '黎城镇', 320831100),
(320831101, 320831, '金南镇', 320831101),
(320831102, 320831, '闵桥镇', 320831102),
(320831103, 320831, '塔集镇', 320831103),
(320831104, 320831, '银集镇', 320831104),
(320831105, 320831, '涂沟镇', 320831105),
(320831106, 320831, '前锋镇', 320831106),
(320831107, 320831, '吕良镇', 320831107),
(320831108, 320831, '陈桥镇', 320831108),
(320831109, 320831, '金北镇', 320831109),
(320831110, 320831, '戴楼镇', 320831110),
(320831400, 320831, '宝应湖农场', 320831400),
(320831401, 320831, '复兴圩农场', 320831401),
(320831402, 320831, '粮棉原种场', 320831402),
(320831403, 320831, '江苏金湖经济开发区', 320831403),
(320902001, 320902, '五星街道', 320902001),
(320902002, 320902, '文峰街道', 320902002),
(320902003, 320902, '先锋街道', 320902003),
(320902004, 320902, '毓龙街道', 320902004),
(320902005, 320902, '张庄街道', 320902005),
(320902006, 320902, '黄海街道', 320902006),
(320902007, 320902, '新洋街道', 320902007),
(320902008, 320902, '大洋街道', 320902008),
(320902100, 320902, '南洋镇', 320902100),
(320902101, 320902, '亭湖区青墩镇', 320902101),
(320902102, 320902, '新兴镇', 320902102),
(320902103, 320902, '永丰镇', 320902103),
(320902104, 320902, '便仓镇', 320902104),
(320902105, 320902, '伍佑镇', 320902105),
(320902106, 320902, '步凤镇', 320902106),
(320902400, 320902, '开发区', 320902400),
(320902401, 320902, '市开发区', 320902401),
(320903100, 320903, '大纵湖镇', 320903100),
(320903101, 320903, '北龙港镇', 320903101),
(320903102, 320903, '楼王镇', 320903102),
(320903103, 320903, '学富镇', 320903103),
(320903104, 320903, '义丰镇', 320903104),
(320903105, 320903, '尚庄镇', 320903105),
(320903106, 320903, '葛武镇', 320903106),
(320903107, 320903, '北蒋镇', 320903107),
(320903108, 320903, '秦南镇', 320903108),
(320903109, 320903, '龙冈镇', 320903109),
(320903110, 320903, '潘黄镇', 320903110),
(320903111, 320903, '郭猛镇', 320903111),
(320903112, 320903, '大冈镇', 320903112),
(320903550, 320903, '新区街道', 320903550),
(320921100, 320921, '响水镇', 320921100),
(320921101, 320921, '陈家港镇', 320921101),
(320921102, 320921, '小尖镇', 320921102),
(320921103, 320921, '黄圩镇', 320921103),
(320921104, 320921, '大有镇', 320921104),
(320921105, 320921, '双港镇', 320921105),
(320921106, 320921, '南河镇', 320921106),
(320921107, 320921, '运河镇', 320921107),
(320921200, 320921, '张集乡', 320921200),
(320921201, 320921, '六套乡', 320921201),
(320921202, 320921, '七套乡', 320921202),
(320921203, 320921, '老舍乡', 320921203),
(320921400, 320921, '县开发区', 320921400),
(320921401, 320921, '省属黄海农场', 320921401),
(320921402, 320921, '省属灌东盐场', 320921402),
(320922100, 320922, '东坎镇', 320922100),
(320922101, 320922, '五汛镇', 320922101),
(320922102, 320922, '蔡桥镇', 320922102),
(320922103, 320922, '正红镇', 320922103),
(320922104, 320922, '通榆镇', 320922104),
(320922105, 320922, '界牌镇', 320922105),
(320922106, 320922, '八巨镇', 320922106),
(320922107, 320922, '八滩镇', 320922107),
(320922108, 320922, '滨海港镇', 320922108),
(320922109, 320922, '滨淮镇', 320922109),
(320922200, 320922, '天场乡', 320922200),
(320922201, 320922, '大套乡', 320922201),
(320922202, 320922, '陈涛乡', 320922202),
(320922203, 320922, '振东乡', 320922203),
(320922204, 320922, '樊集乡', 320922204),
(320922400, 320922, '滨淮农场', 320922400),
(320922401, 320922, '新滩盐场', 320922401),
(320922402, 320922, '开发区工业园', 320922402),
(320923100, 320923, '阜城镇', 320923100),
(320923101, 320923, '沟墩镇', 320923101),
(320923102, 320923, '吴滩镇', 320923102),
(320923103, 320923, '合利镇', 320923103),
(320923104, 320923, '陈良镇', 320923104),
(320923105, 320923, '施庄镇', 320923105),
(320923106, 320923, '三灶镇', 320923106),
(320923107, 320923, '郭墅镇', 320923107),
(320923108, 320923, '新沟镇', 320923108),
(320923109, 320923, '陈集镇', 320923109),
(320923110, 320923, '羊寨镇', 320923110),
(320923111, 320923, '芦蒲镇', 320923111),
(320923112, 320923, '硕集镇', 320923112),
(320923113, 320923, '板湖镇', 320923113),
(320923114, 320923, '东沟镇', 320923114),
(320923115, 320923, '益林镇', 320923115),
(320923116, 320923, '公兴镇', 320923116),
(320923117, 320923, '杨集镇', 320923117),
(320923118, 320923, '古河镇', 320923118),
(320923119, 320923, '罗桥镇', 320923119),
(320923400, 320923, '开发区', 320923400),
(320923401, 320923, '化工园区', 320923401),
(320924100, 320924, '合德镇', 320924100),
(320924101, 320924, '临海镇', 320924101),
(320924102, 320924, '千秋镇', 320924102),
(320924103, 320924, '通洋镇', 320924103),
(320924104, 320924, '四明镇', 320924104),
(320924105, 320924, '阜余镇', 320924105),
(320924106, 320924, '海河镇', 320924106),
(320924107, 320924, '陈洋镇', 320924107),
(320924108, 320924, '海通镇', 320924108),
(320924109, 320924, '兴桥镇', 320924109),
(320924110, 320924, '新坍镇', 320924110),
(320924111, 320924, '长荡镇', 320924111),
(320924112, 320924, '盘湾镇', 320924112),
(320924113, 320924, '特庸镇', 320924113),
(320924114, 320924, '洋马镇', 320924114),
(320924115, 320924, '黄尖镇', 320924115),
(320924116, 320924, '盐东镇', 320924116),
(320924117, 320924, '黄沙港镇', 320924117),
(320924118, 320924, '耦耕镇', 320924118),
(320924400, 320924, '开发区', 320924400),
(320924401, 320924, '淮海农场', 320924401),
(320924402, 320924, '临海农场', 320924402),
(320924403, 320924, '新洋农场', 320924403),
(320924404, 320924, '射阳盐场', 320924404),
(320924405, 320924, '农业经济开发区', 320924405),
(320925100, 320925, '近湖镇', 320925100),
(320925101, 320925, '建阳镇', 320925101),
(320925102, 320925, '蒋营镇', 320925102),
(320925103, 320925, '恒济镇', 320925103),
(320925104, 320925, '颜单镇', 320925104),
(320925105, 320925, '沿河镇', 320925105),
(320925106, 320925, '芦沟镇', 320925106),
(320925107, 320925, '庆丰镇', 320925107),
(320925108, 320925, '上冈镇', 320925108),
(320925109, 320925, '冈东镇', 320925109),
(320925110, 320925, '草堰口镇', 320925110),
(320925111, 320925, '冈西镇', 320925111),
(320925112, 320925, '钟庄镇', 320925112),
(320925113, 320925, '宝塔镇', 320925113),
(320925114, 320925, '高作镇', 320925114),
(320925400, 320925, '经济开发区', 320925400),
(320981100, 320981, '溱东镇', 320981100),
(320981101, 320981, '时堰镇', 320981101),
(320981102, 320981, '后港镇', 320981102),
(320981103, 320981, '台南镇', 320981103),
(320981104, 320981, '广山镇', 320981104),
(320981105, 320981, '廉贻镇', 320981105),
(320981106, 320981, '五烈镇', 320981106),
(320981107, 320981, '梁垛镇', 320981107),
(320981108, 320981, '安丰镇', 320981108),
(320981109, 320981, '南沈灶镇', 320981109),
(320981110, 320981, '富安镇', 320981110),
(320981111, 320981, '富东镇', 320981111),
(320981112, 320981, '唐洋镇', 320981112),
(320981113, 320981, '新街镇', 320981113),
(320981114, 320981, '许河镇', 320981114),
(320981115, 320981, '三仓镇', 320981115),
(320981116, 320981, '新曹镇', 320981116),
(320981117, 320981, '曹丿镇', 320981117),
(320981118, 320981, '头灶镇', 320981118),
(320981119, 320981, '四灶镇', 320981119),
(320981120, 320981, '海丰镇', 320981120),
(320981121, 320981, '弶港镇', 320981121),
(320981122, 320981, '东台镇', 320981122),
(320981400, 320981, '国营新曹农场', 320981400),
(320981401, 320981, '国营弶港农场', 320981401),
(320981402, 320981, '蚕种场', 320981402),
(320981403, 320981, '林场', 320981403),
(320981404, 320981, '黄海原种场', 320981404),
(320981405, 320981, '渔舍农场', 320981405),
(320981406, 320981, '种畜场', 320981406),
(320981407, 320981, '金东台农场', 320981407),
(320981408, 320981, '原种场', 320981408),
(320981409, 320981, '开发区', 320981409),
(320982100, 320982, '大中镇', 320982100),
(320982101, 320982, '草堰镇', 320982101),
(320982102, 320982, '白驹镇', 320982102),
(320982103, 320982, '刘庄镇', 320982103),
(320982104, 320982, '西团镇', 320982104),
(320982105, 320982, '小海镇', 320982105),
(320982106, 320982, '大桥镇', 320982106),
(320982107, 320982, '草庙镇', 320982107),
(320982108, 320982, '万盈镇', 320982108),
(320982109, 320982, '南阳镇', 320982109),
(320982110, 320982, '裕华镇', 320982110),
(320982111, 320982, '新丰镇', 320982111),
(320982112, 320982, '三龙镇', 320982112),
(320982113, 320982, '方强镇', 320982113),
(320982400, 320982, '大中农场', 320982400),
(320982401, 320982, '方强农场', 320982401),
(320982402, 320982, '东坝头农场', 320982402),
(321002001, 321002, '东关街道', 321002001),
(321002002, 321002, '汶河街道', 321002002),
(321002003, 321002, '文峰街道', 321002003),
(321002004, 321002, '曲江街道', 321002004),
(321002100, 321002, '湾头镇', 321002100),
(321002200, 321002, '汤汪乡', 321002200),
(321003001, 321003, '邗上街道', 321003001),
(321003002, 321003, '蒋王街道', 321003002),
(321003003, 321003, '汊河街道', 321003003),
(321003100, 321003, '公道镇', 321003100),
(321003101, 321003, '方巷镇', 321003101),
(321003102, 321003, '槐泗镇', 321003102),
(321003103, 321003, '瓜洲镇', 321003103),
(321003104, 321003, '杭集镇', 321003104),
(321003105, 321003, '李典镇', 321003105),
(321003106, 321003, '沙头镇', 321003106),
(321003107, 321003, '头桥镇', 321003107),
(321003108, 321003, '甘泉镇', 321003108),
(321003109, 321003, '泰安镇', 321003109),
(321003110, 321003, '杨庙镇', 321003110),
(321003450, 321003, '邗江工业园', 321003450),
(321011001, 321011, '双桥街道', 321011001),
(321011002, 321011, '梅岭街道', 321011002),
(321011003, 321011, '瘦西湖街道', 321011003),
(321011050, 321011, '扬子津街道', 321011050),
(321011051, 321011, '文汇街道', 321011051),
(321011060, 321011, '新盛街道', 321011060),
(321011100, 321011, '西湖镇', 321011100),
(321011150, 321011, '施桥镇', 321011150),
(321011151, 321011, '八里镇', 321011151),
(321011200, 321011, '平山乡', 321011200),
(321011201, 321011, '双桥乡', 321011201),
(321011202, 321011, '城北乡', 321011202),
(321011400, 321011, '平山茶场', 321011400),
(321011401, 321011, '维扬经济开发区', 321011401),
(321023100, 321023, '安宜镇', 321023100),
(321023101, 321023, '范水镇', 321023101),
(321023102, 321023, '夏集镇', 321023102),
(321023103, 321023, '柳堡镇', 321023103),
(321023104, 321023, '射阳湖镇', 321023104),
(321023105, 321023, '广洋湖镇', 321023105),
(321023106, 321023, '鲁垛镇', 321023106),
(321023107, 321023, '小官庄镇', 321023107),
(321023108, 321023, '望直港镇', 321023108),
(321023109, 321023, '曹甸镇', 321023109),
(321023110, 321023, '西安丰镇', 321023110);
INSERT INTO `{pre}areas` VALUES
(321023111, 321023, '山阳镇', 321023111),
(321023112, 321023, '黄塍镇', 321023112),
(321023113, 321023, '泾河镇', 321023113),
(321023400, 321023, '开发区管委会', 321023400),
(321081100, 321081, '真州镇', 321081100),
(321081101, 321081, '青山镇', 321081101),
(321081102, 321081, '朴席镇', 321081102),
(321081103, 321081, '新集镇', 321081103),
(321081104, 321081, '新城镇', 321081104),
(321081105, 321081, '马集镇', 321081105),
(321081106, 321081, '刘集镇', 321081106),
(321081107, 321081, '陈集镇', 321081107),
(321081108, 321081, '大仪镇', 321081108),
(321081200, 321081, '谢集乡', 321081200),
(321081201, 321081, '月塘乡', 321081201),
(321081400, 321081, '开发区', 321081400),
(321081401, 321081, '原种场', 321081401),
(321081402, 321081, '蚕种场', 321081402),
(321081403, 321081, '园艺试验场', 321081403),
(321081404, 321081, '水产试验场', 321081404),
(321081405, 321081, '捺山茶场', 321081405),
(321081406, 321081, '蚕桑场', 321081406),
(321081450, 321081, '滨江', 321081450),
(321081451, 321081, '十二圩', 321081451),
(321084100, 321084, '高邮镇', 321084100),
(321084101, 321084, '龙虬镇', 321084101),
(321084102, 321084, '马棚镇', 321084102),
(321084103, 321084, '车逻镇', 321084103),
(321084104, 321084, '八桥镇', 321084104),
(321084105, 321084, '汉留镇', 321084105),
(321084106, 321084, '汤庄镇', 321084106),
(321084107, 321084, '卸甲镇', 321084107),
(321084108, 321084, '三垛镇', 321084108),
(321084109, 321084, '甘垛镇', 321084109),
(321084110, 321084, '司徒镇', 321084110),
(321084111, 321084, '横泾镇', 321084111),
(321084112, 321084, '界首镇', 321084112),
(321084113, 321084, '周山镇', 321084113),
(321084114, 321084, '周巷镇', 321084114),
(321084115, 321084, '临泽镇', 321084115),
(321084116, 321084, '送桥镇', 321084116),
(321084117, 321084, '郭集镇', 321084117),
(321084118, 321084, '天山镇', 321084118),
(321084200, 321084, '菱塘回族乡', 321084200),
(321084401, 321084, '鸭业园区', 321084401),
(321084406, 321084, '经济开发区', 321084406),
(321088100, 321088, '仙女镇', 321088100),
(321088101, 321088, '小纪镇', 321088101),
(321088103, 321088, '武坚镇', 321088103),
(321088106, 321088, '樊川镇', 321088106),
(321088108, 321088, '真武镇', 321088108),
(321088109, 321088, '宜陵镇', 321088109),
(321088110, 321088, '丁沟镇', 321088110),
(321088112, 321088, '郭村镇', 321088112),
(321088114, 321088, '邵伯镇', 321088114),
(321088116, 321088, '丁伙镇', 321088116),
(321088118, 321088, '大桥镇', 321088118),
(321088119, 321088, '吴桥镇', 321088119),
(321088120, 321088, '浦头镇', 321088120),
(321102001, 321102, '正东路街道', 321102001),
(321102002, 321102, '健康路街道', 321102002),
(321102003, 321102, '大市口街道', 321102003),
(321102004, 321102, '四牌楼街道', 321102004),
(321102050, 321102, '丁卯街道', 321102050),
(321102051, 321102, '大港街道', 321102051),
(321102100, 321102, '象山镇', 321102100),
(321102101, 321102, '谏壁镇', 321102101),
(321102150, 321102, '姚桥镇', 321102150),
(321102151, 321102, '大路镇', 321102151),
(321102152, 321102, '丁岗镇', 321102152),
(321102400, 321102, '京口科技工业园', 321102400),
(321102401, 321102, '江苏省共青团农场', 321102401),
(321111001, 321111, '宝塔路街道', 321111001),
(321111002, 321111, '和平路街道', 321111002),
(321111003, 321111, '金山街道', 321111003),
(321111004, 321111, '七里甸街道', 321111004),
(321111100, 321111, '蒋乔镇', 321111100),
(321111400, 321111, '民营经济管理委员会', 321111400),
(321111401, 321111, '润州工业园区', 321111401),
(321112100, 321112, '高桥镇', 321112100),
(321112101, 321112, '辛丰镇', 321112101),
(321112102, 321112, '谷阳镇', 321112102),
(321112103, 321112, '上党镇', 321112103),
(321112104, 321112, '宝堰镇', 321112104),
(321112105, 321112, '高资镇', 321112105),
(321112106, 321112, '世业镇', 321112106),
(321112400, 321112, '丹徒区长山林场', 321112400),
(321181100, 321181, '司徒镇', 321181100),
(321181101, 321181, '延陵镇', 321181101),
(321181102, 321181, '珥陵镇', 321181102),
(321181103, 321181, '导墅镇', 321181103),
(321181104, 321181, '皇塘镇', 321181104),
(321181105, 321181, '吕城镇', 321181105),
(321181106, 321181, '陵口镇', 321181106),
(321181107, 321181, '访仙镇', 321181107),
(321181108, 321181, '界牌镇', 321181108),
(321181109, 321181, '新桥镇', 321181109),
(321181110, 321181, '后巷镇', 321181110),
(321181111, 321181, '埤城镇', 321181111),
(321181112, 321181, '云阳镇', 321181112),
(321181400, 321181, '丹阳经济技术开发区', 321181400),
(321181401, 321181, '丹阳林场', 321181401),
(321181402, 321181, '茶叶实验场', 321181402),
(321181403, 321181, '江苏省练湖农场', 321181403),
(321182100, 321182, '三茅镇', 321182100),
(321182101, 321182, '新坝镇', 321182101),
(321182103, 321182, '油坊镇', 321182103),
(321182104, 321182, '八桥镇', 321182104),
(321182105, 321182, '西来桥镇', 321182105),
(321182400, 321182, '经济开发区', 321182400),
(321182401, 321182, '扬中市良种繁育场', 321182401),
(321182402, 321182, '扬中市种猪场', 321182402),
(321182403, 321182, '扬中市渔业社', 321182403),
(321182404, 321182, '雷公岛水产养殖场', 321182404),
(321182405, 321182, '扬中市西沙芦柳管理所', 321182405),
(321183100, 321183, '华阳镇', 321183100),
(321183101, 321183, '黄梅镇', 321183101),
(321183102, 321183, '下蜀镇', 321183102),
(321183103, 321183, '白兔镇', 321183103),
(321183104, 321183, '边城镇', 321183104),
(321183105, 321183, '茅山镇', 321183105),
(321183106, 321183, '后白镇', 321183106),
(321183107, 321183, '郭庄镇', 321183107),
(321183108, 321183, '天王镇', 321183108),
(321183109, 321183, '宝华镇', 321183109),
(321183400, 321183, '开发区', 321183400),
(321183401, 321183, '句容市东山良种场', 321183401),
(321183402, 321183, '句容市棉花原种场', 321183402),
(321183403, 321183, '句容市下蜀茶场', 321183403),
(321183404, 321183, '句容市林场', 321183404),
(321183405, 321183, '句容市赵庄林苗场', 321183405),
(321183406, 321183, '句容市九华茶场', 321183406),
(321183407, 321183, '句容市东进林场', 321183407),
(321183408, 321183, '句容市茅山茶场', 321183408),
(321183409, 321183, '句容市张庙茶场', 321183409),
(321183410, 321183, '句容市高庙茶场', 321183410),
(321183411, 321183, '句容市浮山果园', 321183411),
(321183412, 321183, '句容市方山茶场', 321183412),
(321183413, 321183, '句容市磨盘山林场', 321183413),
(321183414, 321183, '句容市后白良种场', 321183414),
(321183415, 321183, '句容市二圣种猪场', 321183415),
(321183416, 321183, '句容监狱', 321183416),
(321183417, 321183, '江苏省第一少年管教所', 321183417),
(321183418, 321183, '江苏省第二少年管教所', 321183418),
(321183428, 321183, '句东农场', 321183428),
(321202001, 321202, '城东街道', 321202001),
(321202002, 321202, '城西街道', 321202002),
(321202003, 321202, '城南街道', 321202003),
(321202004, 321202, '城中街道', 321202004),
(321202005, 321202, '城北街道', 321202005),
(321202006, 321202, '泰山街道', 321202006),
(321202007, 321202, '京泰路街道', 321202007),
(321202008, 321202, '凤凰路街道', 321202008),
(321202050, 321202, '农业开发区街道', 321202050),
(321202100, 321202, '九龙镇', 321202100),
(321202150, 321202, '寺巷镇', 321202150),
(321202402, 321202, '林场', 321202402),
(321202403, 321202, '水产养殖场', 321202403),
(321202404, 321202, '畜牧养殖试验场', 321202404),
(321202405, 321202, '迎春果场', 321202405),
(321202406, 321202, '海陵工业园区', 321202406),
(321203001, 321203, '口岸街道', 321203001),
(321203002, 321203, '刁铺街道', 321203002),
(321203003, 321203, '许庄街道', 321203003),
(321203100, 321203, '永安洲镇', 321203100),
(321203101, 321203, '白马镇', 321203101),
(321203102, 321203, '野徐镇', 321203102),
(321203450, 321203, '滨江工业园', 321203450),
(321281100, 321281, '戴窑镇', 321281100),
(321281101, 321281, '合陈镇', 321281101),
(321281102, 321281, '永丰镇', 321281102),
(321281103, 321281, '新垛镇', 321281103),
(321281104, 321281, '安丰镇', 321281104),
(321281105, 321281, '海南镇', 321281105),
(321281106, 321281, '钓鱼镇', 321281106),
(321281107, 321281, '大邹镇', 321281107),
(321281108, 321281, '沙沟镇', 321281108),
(321281109, 321281, '中堡镇', 321281109),
(321281110, 321281, '李中镇', 321281110),
(321281111, 321281, '西郊镇', 321281111),
(321281112, 321281, '临城镇', 321281112),
(321281113, 321281, '垛田镇', 321281113),
(321281114, 321281, '竹泓镇', 321281114),
(321281115, 321281, '沈沦镇', 321281115),
(321281116, 321281, '大垛镇', 321281116),
(321281117, 321281, '荻垛镇', 321281117),
(321281118, 321281, '陶庄镇', 321281118),
(321281119, 321281, '昌荣镇', 321281119),
(321281120, 321281, '茅山镇', 321281120),
(321281121, 321281, '周庄镇', 321281121),
(321281122, 321281, '陈堡镇', 321281122),
(321281123, 321281, '戴南镇', 321281123),
(321281124, 321281, '张郭镇', 321281124),
(321281125, 321281, '昭阳镇', 321281125),
(321281126, 321281, '大营镇', 321281126),
(321281127, 321281, '下圩镇', 321281127),
(321281128, 321281, '城东镇', 321281128),
(321281200, 321281, '老圩乡', 321281200),
(321281201, 321281, '周奋乡', 321281201),
(321281202, 321281, '缸顾乡', 321281202),
(321281203, 321281, '西鲍乡', 321281203),
(321281204, 321281, '林湖乡', 321281204),
(321281450, 321281, '开发区', 321281450),
(321281451, 321281, '良种场', 321281451),
(321282100, 321282, '靖城镇', 321282100),
(321282101, 321282, '新桥镇', 321282101),
(321282102, 321282, '东兴镇', 321282102),
(321282103, 321282, '斜桥镇', 321282103),
(321282104, 321282, '西来镇', 321282104),
(321282105, 321282, '季市镇', 321282105),
(321282106, 321282, '孤山镇', 321282106),
(321282107, 321282, '红光镇', 321282107),
(321282108, 321282, '生祠镇', 321282108),
(321282109, 321282, '马桥镇', 321282109),
(321282401, 321282, '城南', 321282401),
(321282402, 321282, '新港园区', 321282402),
(321282403, 321282, '城北园区', 321282403),
(321282404, 321282, '江阴园区', 321282404),
(321282405, 321282, '渔业公司', 321282405),
(321283100, 321283, '黄桥镇', 321283100),
(321283101, 321283, '分界镇', 321283101),
(321283102, 321283, '古溪镇', 321283102),
(321283103, 321283, '横垛镇', 321283103),
(321283104, 321283, '元竹镇', 321283104),
(321283105, 321283, '珊瑚镇', 321283105),
(321283106, 321283, '广陵镇', 321283106),
(321283107, 321283, '南沙镇', 321283107),
(321283108, 321283, '曲霞镇', 321283108),
(321283109, 321283, '张桥镇', 321283109),
(321283110, 321283, '溪桥镇', 321283110),
(321283111, 321283, '刘陈镇', 321283111),
(321283112, 321283, '河失镇', 321283112),
(321283113, 321283, '新街镇', 321283113),
(321283114, 321283, '姚王镇', 321283114),
(321283115, 321283, '宣堡镇', 321283115),
(321283116, 321283, '胡庄镇', 321283116),
(321283117, 321283, '马甸镇', 321283117),
(321283118, 321283, '泰兴镇', 321283118),
(321283119, 321283, '七圩镇', 321283119),
(321283120, 321283, '蒋华镇', 321283120),
(321283121, 321283, '大生镇', 321283121),
(321283122, 321283, '过船镇', 321283122),
(321283200, 321283, '根思乡', 321283200),
(321283400, 321283, '开发区虚拟镇', 321283400),
(321283401, 321283, '泰兴市农科所', 321283401),
(321284100, 321284, '姜堰镇', 321284100),
(321284101, 321284, '溱潼镇', 321284101),
(321284102, 321284, '蒋垛镇', 321284102),
(321284103, 321284, '顾高镇', 321284103),
(321284104, 321284, '大伦镇', 321284104),
(321284105, 321284, '张甸镇', 321284105),
(321284106, 321284, '大泗镇', 321284106),
(321284107, 321284, '梁徐镇', 321284107),
(321284108, 321284, '苏陈镇', 321284108),
(321284109, 321284, '桥头镇', 321284109),
(321284110, 321284, '淤溪镇', 321284110),
(321284111, 321284, '白米镇', 321284111),
(321284112, 321284, '娄庄镇', 321284112),
(321284113, 321284, '沈高镇', 321284113),
(321284114, 321284, '兴泰镇', 321284114),
(321284115, 321284, '俞垛镇', 321284115),
(321284116, 321284, '华港镇', 321284116),
(321284117, 321284, '罡杨镇', 321284117),
(321284400, 321284, '开发区', 321284400),
(321284401, 321284, '溱湖风景区', 321284401),
(321284403, 321284, '林场', 321284403),
(321284404, 321284, '种猪场', 321284404),
(321284405, 321284, '林业站', 321284405),
(321284406, 321284, '渔业社', 321284406),
(321302001, 321302, '幸福街道', 321302001),
(321302002, 321302, '项里街道', 321302002),
(321302003, 321302, '河滨街道', 321302003),
(321302004, 321302, '古城街道', 321302004),
(321302100, 321302, '双庄镇', 321302100),
(321302101, 321302, '耿车镇', 321302101),
(321302102, 321302, '埠子镇', 321302102),
(321302103, 321302, '龙河镇', 321302103),
(321302104, 321302, '洋北镇', 321302104),
(321302105, 321302, '仓集镇', 321302105),
(321302106, 321302, '洋河镇', 321302106),
(321302107, 321302, '中扬镇', 321302107),
(321302108, 321302, '郑楼镇', 321302108),
(321302109, 321302, '陈集镇', 321302109),
(321302201, 321302, '罗圩乡', 321302201),
(321302202, 321302, '南蔡乡', 321302202),
(321302203, 321302, '屠园乡', 321302203),
(321302350, 321302, '三棵树乡', 321302350),
(321311100, 321311, '顺河镇', 321311100),
(321311101, 321311, '晓店镇', 321311101),
(321311102, 321311, '蔡集镇', 321311102),
(321311103, 321311, '王官集镇', 321311103),
(321311104, 321311, '皂河镇', 321311104),
(321311105, 321311, '仰化镇', 321311105),
(321311106, 321311, '大兴镇', 321311106),
(321311107, 321311, '丁嘴镇', 321311107),
(321311108, 321311, '来龙镇', 321311108),
(321311109, 321311, '黄墩镇', 321311109),
(321311110, 321311, '陆集镇', 321311110),
(321311111, 321311, '关庙镇', 321311111),
(321311112, 321311, '侍岭镇', 321311112),
(321311113, 321311, '新庄镇', 321311113),
(321311200, 321311, '井头乡', 321311200),
(321311201, 321311, '曹集乡', 321311201),
(321311202, 321311, '保安乡', 321311202),
(321311500, 321311, '嶂山林场', 321311500),
(321322100, 321322, '沭城镇', 321322100),
(321322101, 321322, '陇集镇', 321322101),
(321322102, 321322, '胡集镇', 321322102),
(321322103, 321322, '钱集镇', 321322103),
(321322104, 321322, '塘沟镇', 321322104),
(321322105, 321322, '马厂镇', 321322105),
(321322106, 321322, '沂涛镇', 321322106),
(321322107, 321322, '庙头镇', 321322107),
(321322108, 321322, '韩山镇', 321322108),
(321322109, 321322, '华冲镇', 321322109),
(321322110, 321322, '桑墟镇', 321322110),
(321322111, 321322, '悦来镇', 321322111),
(321322112, 321322, '刘集镇', 321322112),
(321322114, 321322, '李恒镇', 321322114),
(321322115, 321322, '扎下镇', 321322115),
(321322116, 321322, '颜集镇', 321322116),
(321322117, 321322, '潼阳镇', 321322117),
(321322118, 321322, '龙庙镇', 321322118),
(321322119, 321322, '高墟镇', 321322119),
(321322120, 321322, '耿圩镇', 321322120),
(321322122, 321322, '汤涧镇', 321322122),
(321322124, 321322, '新河镇', 321322124),
(321322125, 321322, '贤官镇', 321322125),
(321322126, 321322, '吴集镇', 321322126),
(321322127, 321322, '湖东镇', 321322127),
(321322128, 321322, '青伊湖镇', 321322128),
(321322200, 321322, '北丁集乡', 321322200),
(321322201, 321322, '周集乡', 321322201),
(321322202, 321322, '东小店乡', 321322202),
(321322203, 321322, '张圩乡', 321322203),
(321322204, 321322, '茆圩乡', 321322204),
(321322205, 321322, '西圩乡', 321322205),
(321322206, 321322, '万匹乡', 321322206),
(321322207, 321322, '官墩乡', 321322207),
(321322400, 321322, '青伊湖农场', 321322400),
(321323100, 321323, '众兴镇', 321323100),
(321323101, 321323, '爱园镇', 321323101),
(321323102, 321323, '王集镇', 321323102),
(321323103, 321323, '裴圩镇', 321323103),
(321323104, 321323, '新袁镇', 321323104),
(321323105, 321323, '李口镇', 321323105),
(321323106, 321323, '临河镇', 321323106),
(321323107, 321323, '穿城镇', 321323107),
(321323108, 321323, '张家圩镇', 321323108),
(321323109, 321323, '高渡镇', 321323109),
(321323110, 321323, '卢集镇', 321323110),
(321323200, 321323, '庄圩乡', 321323200),
(321323201, 321323, '里仁乡', 321323201),
(321323202, 321323, '三庄乡', 321323202),
(321323203, 321323, '南刘集乡', 321323203),
(321323204, 321323, '八集乡', 321323204),
(321323400, 321323, '泗阳农场', 321323400),
(321323401, 321323, '棉花原种场', 321323401),
(321324100, 321324, '青阳镇', 321324100),
(321324101, 321324, '双沟镇', 321324101),
(321324102, 321324, '上塘镇', 321324102),
(321324103, 321324, '魏营镇', 321324103),
(321324104, 321324, '临淮镇', 321324104),
(321324105, 321324, '半城镇', 321324105),
(321324106, 321324, '孙园镇', 321324106),
(321324107, 321324, '梅花镇', 321324107),
(321324108, 321324, '归仁镇', 321324108),
(321324109, 321324, '金锁镇', 321324109),
(321324110, 321324, '朱湖镇', 321324110),
(321324111, 321324, '界集镇', 321324111),
(321324112, 321324, '太平镇', 321324112),
(321324113, 321324, '龙集镇', 321324113),
(321324200, 321324, '四河乡', 321324200),
(321324201, 321324, '峰山乡', 321324201),
(321324202, 321324, '天岗湖乡', 321324202),
(321324203, 321324, '车门乡', 321324203),
(321324204, 321324, '瑶沟乡', 321324204),
(321324205, 321324, '石集乡', 321324205),
(321324206, 321324, '城头乡', 321324206),
(321324207, 321324, '陈圩乡', 321324207),
(321324208, 321324, '曹庙乡', 321324208),
(321324400, 321324, '五里江农场', 321324400),
(321324401, 321324, '洪泽湖农场', 321324401),
(330102001, 330102, '清波街道', 330102001),
(330102003, 330102, '湖滨街道', 330102003),
(330102004, 330102, '小营街道', 330102004),
(330102008, 330102, '南星街道', 330102008),
(330102009, 330102, '紫阳街道', 330102009),
(330102010, 330102, '望江街道', 330102010),
(330103001, 330103, '长庆街道', 330103001),
(330103002, 330103, '武林街道', 330103002),
(330103003, 330103, '天水街道', 330103003),
(330103005, 330103, '潮鸣街道', 330103005),
(330103006, 330103, '朝晖街道', 330103006),
(330103007, 330103, '文晖街道', 330103007),
(330103008, 330103, '东新街道', 330103008),
(330103009, 330103, '石桥街道', 330103009),
(330104005, 330104, '凯旋街道', 330104005),
(330104006, 330104, '采荷街道', 330104006),
(330104007, 330104, '闸弄口街道', 330104007),
(330104008, 330104, '四季青街道', 330104008),
(330104009, 330104, '白杨街道', 330104009),
(330104010, 330104, '下沙街道', 330104010),
(330104102, 330104, '彭埠镇', 330104102),
(330104103, 330104, '笕桥镇', 330104103),
(330104104, 330104, '丁桥镇', 330104104),
(330104105, 330104, '九堡镇', 330104105),
(330105001, 330105, '米市巷街道', 330105001),
(330105002, 330105, '湖墅街道', 330105002),
(330105003, 330105, '小河街道', 330105003),
(330105004, 330105, '和睦街道', 330105004),
(330105005, 330105, '拱宸桥街道', 330105005),
(330105007, 330105, '大关街道', 330105007),
(330105008, 330105, '上塘街道', 330105008),
(330105102, 330105, '康桥镇', 330105102),
(330105103, 330105, '半山镇', 330105103),
(330105104, 330105, '祥符镇', 330105104),
(330106002, 330106, '北山街道', 330106002),
(330106003, 330106, '灵隐街道', 330106003),
(330106004, 330106, '西溪街道', 330106004),
(330106005, 330106, '翠苑街道', 330106005),
(330106006, 330106, '文新街道', 330106006),
(330106007, 330106, '古荡街道', 330106007),
(330106008, 330106, '西湖街道', 330106008),
(330106103, 330106, '留下镇', 330106103),
(330106104, 330106, '转塘镇', 330106104),
(330106105, 330106, '袁浦镇', 330106105),
(330106106, 330106, '龙坞镇', 330106106),
(330106109, 330106, '三墩镇', 330106109),
(330106202, 330106, '周浦乡', 330106202),
(330106203, 330106, '蒋村乡', 330106203),
(330108001, 330108, '西兴街道', 330108001),
(330108002, 330108, '长河街道', 330108002),
(330108003, 330108, '浦沿街道', 330108003),
(330109001, 330109, '城厢街道', 330109001),
(330109002, 330109, '北干街道', 330109002),
(330109003, 330109, '蜀山街道', 330109003),
(330109004, 330109, '新塘街道', 330109004),
(330109100, 330109, '楼塔镇', 330109100),
(330109101, 330109, '河上镇', 330109101),
(330109102, 330109, '戴村镇', 330109102),
(330109103, 330109, '浦阳镇', 330109103),
(330109104, 330109, '进化镇', 330109104),
(330109105, 330109, '临浦镇', 330109105),
(330109106, 330109, '义桥镇', 330109106),
(330109107, 330109, '所前镇', 330109107),
(330109108, 330109, '衙前镇', 330109108),
(330109109, 330109, '闻堰镇', 330109109),
(330109110, 330109, '宁围镇', 330109110),
(330109111, 330109, '新街镇', 330109111),
(330109112, 330109, '坎山镇', 330109112),
(330109113, 330109, '瓜沥镇', 330109113),
(330109114, 330109, '党山镇', 330109114),
(330109115, 330109, '益农镇', 330109115),
(330109116, 330109, '靖江镇', 330109116),
(330109117, 330109, '南阳镇', 330109117),
(330109118, 330109, '义蓬镇', 330109118),
(330109119, 330109, '河庄镇', 330109119),
(330109120, 330109, '党湾镇', 330109120),
(330109121, 330109, '新湾镇', 330109121),
(330109401, 330109, '萧山经济开发区', 330109401),
(330109501, 330109, '围垦区', 330109501),
(330110001, 330110, '临平街道', 330110001),
(330110002, 330110, '南苑街道', 330110002),
(330110003, 330110, '东湖街道', 330110003),
(330110004, 330110, '星桥街道', 330110004),
(330110100, 330110, '乔司镇', 330110100),
(330110101, 330110, '运河镇', 330110101),
(330110102, 330110, '塘栖镇', 330110102),
(330110103, 330110, '崇贤镇', 330110103),
(330110104, 330110, '仁和镇', 330110104),
(330110105, 330110, '良渚镇', 330110105),
(330110106, 330110, '闲林镇', 330110106),
(330110107, 330110, '仓前镇', 330110107),
(330110108, 330110, '余杭镇', 330110108),
(330110109, 330110, '径山镇', 330110109),
(330110110, 330110, '瓶窑镇', 330110110),
(330110111, 330110, '鸬鸟镇', 330110111),
(330110112, 330110, '百丈镇', 330110112),
(330110113, 330110, '黄湖镇', 330110113),
(330110200, 330110, '中泰乡', 330110200),
(330122001, 330122, '桐君街道', 330122001),
(330122002, 330122, '旧县街道', 330122002),
(330122101, 330122, '富春江镇', 330122101),
(330122102, 330122, '横村镇', 330122102),
(330122107, 330122, '凤川镇', 330122107),
(330122109, 330122, '分水镇', 330122109),
(330122110, 330122, '瑶琳镇', 330122110),
(330122112, 330122, '百江镇', 330122112),
(330122113, 330122, '江南镇', 330122113),
(330122201, 330122, '莪山畲族自治乡', 330122201),
(330122202, 330122, '钟山乡', 330122202),
(330122204, 330122, '新合乡', 330122204),
(330122210, 330122, '合村乡', 330122210),
(330127100, 330127, '千岛湖镇', 330127100),
(330127101, 330127, '文昌镇', 330127101),
(330127102, 330127, '石林镇', 330127102),
(330127103, 330127, '临岐镇', 330127103),
(330127104, 330127, '威坪镇', 330127104),
(330127106, 330127, '姜家镇', 330127106),
(330127107, 330127, '梓桐镇', 330127107),
(330127108, 330127, '汾口镇', 330127108),
(330127109, 330127, '中洲镇', 330127109),
(330127110, 330127, '大墅镇', 330127110),
(330127111, 330127, '枫树岭镇', 330127111),
(330127200, 330127, '里商乡', 330127200),
(330127201, 330127, '金峰乡', 330127201),
(330127202, 330127, '富文乡', 330127202),
(330127203, 330127, '左口乡', 330127203),
(330127205, 330127, '屏门乡', 330127205),
(330127206, 330127, '瑶山乡', 330127206),
(330127208, 330127, '王阜乡', 330127208),
(330127210, 330127, '宋村乡', 330127210),
(330127211, 330127, '鸠坑乡', 330127211),
(330127212, 330127, '浪川乡', 330127212),
(330127214, 330127, '界首乡', 330127214),
(330127216, 330127, '安阳乡', 330127216),
(330182001, 330182, '新安江街道', 330182001),
(330182002, 330182, '洋溪街道', 330182002),
(330182003, 330182, '更楼街道', 330182003),
(330182101, 330182, '莲花镇', 330182101),
(330182102, 330182, '乾潭镇', 330182102),
(330182104, 330182, '梅城镇', 330182104),
(330182105, 330182, '杨村桥镇', 330182105),
(330182106, 330182, '下涯镇', 330182106),
(330182107, 330182, '大洋镇', 330182107),
(330182108, 330182, '三都镇', 330182108),
(330182109, 330182, '寿昌镇', 330182109),
(330182110, 330182, '航头镇', 330182110),
(330182111, 330182, '大慈岩镇', 330182111),
(330182112, 330182, '大同镇', 330182112),
(330182113, 330182, '李家镇', 330182113),
(330182202, 330182, '钦堂乡', 330182202),
(330183001, 330183, '富春街道', 330183001),
(330183002, 330183, '春江街道', 330183002),
(330183003, 330183, '东洲街道', 330183003),
(330183004, 330183, '鹿山街道', 330183004),
(330183100, 330183, '万市镇', 330183100),
(330183101, 330183, '洞桥镇', 330183101),
(330183102, 330183, '新登镇', 330183102),
(330183103, 330183, '渌渚镇', 330183103),
(330183104, 330183, '胥口镇', 330183104),
(330183105, 330183, '永昌镇', 330183105),
(330183106, 330183, '大源镇', 330183106),
(330183107, 330183, '灵桥镇', 330183107),
(330183108, 330183, '里山镇', 330183108),
(330183109, 330183, '常绿镇', 330183109),
(330183110, 330183, '场口镇', 330183110),
(330183111, 330183, '常安镇', 330183111),
(330183112, 330183, '龙门镇', 330183112),
(330183113, 330183, '高桥镇', 330183113),
(330183114, 330183, '受降镇', 330183114),
(330183200, 330183, '新桐乡', 330183200),
(330183201, 330183, '上官乡', 330183201),
(330183202, 330183, '渔山乡', 330183202),
(330183204, 330183, '环山乡', 330183204),
(330183205, 330183, '湖源乡', 330183205),
(330183206, 330183, '春建乡', 330183206),
(330185001, 330185, '锦城街道', 330185001),
(330185002, 330185, '玲珑街道', 330185002),
(330185003, 330185, '青山湖街道', 330185003),
(330185004, 330185, '上甘街道', 330185004),
(330185100, 330185, '三口镇', 330185100),
(330185101, 330185, '横畈镇', 330185101),
(330185102, 330185, '高虹镇', 330185102),
(330185103, 330185, '太湖源镇', 330185103),
(330185104, 330185, '於潜镇', 330185104),
(330185105, 330185, '藻溪镇', 330185105),
(330185106, 330185, '太阳镇', 330185106),
(330185107, 330185, '潜川镇', 330185107),
(330185108, 330185, '昌化镇', 330185108),
(330185109, 330185, '河桥镇', 330185109),
(330185110, 330185, '龙岗镇', 330185110),
(330185111, 330185, '湍口镇', 330185111),
(330185112, 330185, '清凉峰镇', 330185112),
(330185113, 330185, '岛石镇', 330185113),
(330185114, 330185, '大峡谷镇', 330185114),
(330185200, 330185, '板桥乡', 330185200),
(330185201, 330185, '西天目乡', 330185201),
(330185202, 330185, '千洪乡', 330185202),
(330185203, 330185, '横路乡', 330185203),
(330185204, 330185, '乐平乡', 330185204),
(330185205, 330185, '马啸乡', 330185205),
(330185206, 330185, '新桥乡', 330185206),
(330203001, 330203, '南门街道', 330203001),
(330203002, 330203, '江厦街道', 330203002),
(330203003, 330203, '西门街道', 330203003),
(330203004, 330203, '月湖街道', 330203004),
(330203005, 330203, '鼓楼街道', 330203005),
(330203006, 330203, '白云街道', 330203006),
(330203007, 330203, '段塘街道', 330203007),
(330203008, 330203, '望春街道', 330203008),
(330204001, 330204, '百丈街道', 330204001),
(330204002, 330204, '东胜街道', 330204002),
(330204003, 330204, '明楼街道', 330204003),
(330204004, 330204, '白鹤街道', 330204004),
(330204005, 330204, '东柳街道', 330204005),
(330204006, 330204, '东郊街道', 330204006),
(330204007, 330204, '福明街道', 330204007),
(330205001, 330205, '中马街道', 330205001),
(330205002, 330205, '白沙街道', 330205002),
(330205003, 330205, '孔浦街道', 330205003),
(330205004, 330205, '文教街道', 330205004),
(330205005, 330205, '甬江街道', 330205005),
(330205006, 330205, '庄桥街道', 330205006),
(330205007, 330205, '洪塘街道', 330205007),
(330205103, 330205, '慈城镇', 330205103),
(330206001, 330206, '大榭街道', 330206001),
(330206002, 330206, '新碶街道', 330206002),
(330206003, 330206, '小港街道', 330206003),
(330206004, 330206, '大碶街道', 330206004),
(330206005, 330206, '霞浦街道', 330206005),
(330206006, 330206, '柴桥街道', 330206006),
(330206105, 330206, '白峰镇', 330206105),
(330206107, 330206, '春晓镇', 330206107),
(330206201, 330206, '梅山乡', 330206201),
(330211001, 330211, '招宝山街道', 330211001),
(330211002, 330211, '蛟川街道', 330211002),
(330211003, 330211, '骆驼街道', 330211003),
(330211004, 330211, '庄市街道', 330211004),
(330211100, 330211, '澥浦镇', 330211100),
(330211101, 330211, '九龙湖镇', 330211101),
(330212001, 330212, '下应街道', 330212001),
(330212002, 330212, '钟公庙街道', 330212002),
(330212003, 330212, '石碶街道', 330212003),
(330212004, 330212, '梅墟街道', 330212004),
(330212100, 330212, '瞻岐镇', 330212100),
(330212101, 330212, '咸祥镇', 330212101),
(330212102, 330212, '塘溪镇', 330212102),
(330212103, 330212, '东钱湖镇', 330212103),
(330212104, 330212, '东吴镇', 330212104),
(330212105, 330212, '五乡镇', 330212105),
(330212106, 330212, '邱隘镇', 330212106),
(330212108, 330212, '云龙镇', 330212108),
(330212109, 330212, '横溪镇', 330212109),
(330212110, 330212, '姜山镇', 330212110),
(330212113, 330212, '高桥镇', 330212113),
(330212114, 330212, '横街镇', 330212114),
(330212115, 330212, '集仕港镇', 330212115),
(330212116, 330212, '古林镇', 330212116),
(330212118, 330212, '洞桥镇', 330212118),
(330212119, 330212, '鄞江镇', 330212119),
(330212120, 330212, '章水镇', 330212120),
(330212200, 330212, '龙观乡', 330212200),
(330225001, 330225, '丹东街道', 330225001),
(330225002, 330225, '丹西街道', 330225002),
(330225003, 330225, '爵溪街道', 330225003),
(330225101, 330225, '石浦镇', 330225101),
(330225102, 330225, '西周镇', 330225102),
(330225103, 330225, '鹤浦镇', 330225103),
(330225104, 330225, '贤庠镇', 330225104),
(330225105, 330225, '墙头镇', 330225105),
(330225106, 330225, '泗洲头镇', 330225106),
(330225107, 330225, '定塘镇', 330225107),
(330225108, 330225, '涂茨镇', 330225108),
(330225109, 330225, '大徐镇', 330225109),
(330225110, 330225, '新桥镇', 330225110),
(330225200, 330225, '东陈乡', 330225200),
(330225201, 330225, '晓塘乡', 330225201),
(330225202, 330225, '黄避岙乡', 330225202),
(330225203, 330225, '茅洋乡', 330225203),
(330225204, 330225, '高塘岛乡', 330225204),
(330226001, 330226, '跃龙街道', 330226001),
(330226002, 330226, '桃源街道', 330226002),
(330226003, 330226, '梅林街道', 330226003),
(330226004, 330226, '桥头胡街道', 330226004),
(330226101, 330226, '长街镇', 330226101),
(330226102, 330226, '力洋镇', 330226102),
(330226104, 330226, '一市镇', 330226104),
(330226105, 330226, '岔路镇', 330226105),
(330226106, 330226, '前童镇', 330226106),
(330226107, 330226, '桑洲镇', 330226107),
(330226108, 330226, '黄坛镇', 330226108),
(330226109, 330226, '大佳何镇', 330226109),
(330226110, 330226, '强蛟镇', 330226110),
(330226111, 330226, '西店镇', 330226111),
(330226112, 330226, '深圳镇', 330226112),
(330226200, 330226, '胡陈乡', 330226200),
(330226201, 330226, '茶院乡', 330226201),
(330226202, 330226, '越溪乡', 330226202),
(330281001, 330281, '梨洲街道', 330281001),
(330281002, 330281, '凤山街道', 330281002),
(330281003, 330281, '兰江街道', 330281003),
(330281004, 330281, '阳明街道', 330281004),
(330281005, 330281, '低塘街道', 330281005),
(330281006, 330281, '朗霞街道', 330281006),
(330281100, 330281, '临山镇', 330281100),
(330281101, 330281, '黄家埠镇', 330281101),
(330281102, 330281, '小曹娥镇', 330281102),
(330281103, 330281, '泗门镇', 330281103),
(330281106, 330281, '马渚镇', 330281106),
(330281108, 330281, '牟山镇', 330281108),
(330281109, 330281, '丈亭镇', 330281109),
(330281110, 330281, '三七市镇', 330281110),
(330281111, 330281, '河姆渡镇', 330281111),
(330281112, 330281, '大隐镇', 330281112),
(330281113, 330281, '陆埠镇', 330281113),
(330281114, 330281, '梁弄镇', 330281114),
(330281115, 330281, '大岚镇', 330281115),
(330281116, 330281, '四明山镇', 330281116),
(330281201, 330281, '鹿亭乡', 330281201),
(330282001, 330282, '浒山街道', 330282001),
(330282002, 330282, '宗汉街道', 330282002),
(330282003, 330282, '坎墩街道', 330282003),
(330282101, 330282, '龙山镇', 330282101),
(330282102, 330282, '三北镇', 330282102),
(330282103, 330282, '范市镇', 330282103),
(330282104, 330282, '掌起镇', 330282104),
(330282107, 330282, '观海卫镇', 330282107),
(330282108, 330282, '附海镇', 330282108),
(330282109, 330282, '桥头镇', 330282109),
(330282110, 330282, '匡堰镇', 330282110),
(330282111, 330282, '逍林镇', 330282111),
(330282112, 330282, '新浦镇', 330282112),
(330282113, 330282, '胜山镇', 330282113),
(330282114, 330282, '横河镇', 330282114),
(330282116, 330282, '崇寿镇', 330282116),
(330282118, 330282, '庵东镇', 330282118),
(330282119, 330282, '天元镇', 330282119),
(330282120, 330282, '长河镇', 330282120),
(330282121, 330282, '周巷镇', 330282121),
(330283001, 330283, '锦屏街道', 330283001),
(330283002, 330283, '岳林街道', 330283002),
(330283003, 330283, '江口街道', 330283003),
(330283004, 330283, '西坞街道', 330283004),
(330283005, 330283, '萧王庙街道', 330283005),
(330283100, 330283, '溪口镇', 330283100),
(330283103, 330283, '尚田镇', 330283103),
(330283104, 330283, '莼湖镇', 330283104),
(330283106, 330283, '裘村镇', 330283106),
(330283107, 330283, '大堰镇', 330283107),
(330283108, 330283, '松岙镇', 330283108),
(330302002, 330302, '洪殿街道', 330302002),
(330302006, 330302, '五马街道', 330302006),
(330302007, 330302, '蒲鞋市街道', 330302007),
(330302013, 330302, '莲池街道', 330302013),
(330302014, 330302, '广化街道', 330302014),
(330302015, 330302, '水心街道', 330302015),
(330302016, 330302, '南浦街道', 330302016),
(330302018, 330302, '南门街道', 330302018),
(330302019, 330302, '江滨街道', 330302019),
(330302020, 330302, '黎明街道', 330302020),
(330302021, 330302, '绣山街道', 330302021),
(330302022, 330302, '黄龙街道', 330302022),
(330302101, 330302, '双屿镇', 330302101),
(330302102, 330302, '藤桥镇', 330302102),
(330302103, 330302, '临江镇', 330302103),
(330302104, 330302, '七都镇', 330302104),
(330302202, 330302, '南郊乡', 330302202),
(330302203, 330302, '仰义乡', 330302203),
(330302204, 330302, '双潮乡', 330302204),
(330302205, 330302, '上戍乡', 330302205),
(330302206, 330302, '岙底乡', 330302206),
(330303001, 330303, '永中街道', 330303001),
(330303002, 330303, '蒲州街道', 330303002),
(330303003, 330303, '海滨街道', 330303003),
(330303004, 330303, '永兴街道', 330303004),
(330303005, 330303, '海城街道', 330303005),
(330303101, 330303, '状元镇', 330303101),
(330303102, 330303, '瑶溪镇', 330303102),
(330303103, 330303, '沙城镇', 330303103),
(330303104, 330303, '天河镇', 330303104),
(330303105, 330303, '灵昆镇', 330303105),
(330304001, 330304, '景山街道', 330304001),
(330304002, 330304, '梧田街道', 330304002),
(330304003, 330304, '南白象街道', 330304003),
(330304004, 330304, '茶山街道', 330304004),
(330304005, 330304, '娄桥街道', 330304005),
(330304006, 330304, '新桥街道', 330304006),
(330304007, 330304, '三垟街道', 330304007),
(330304103, 330304, '瞿溪镇', 330304103),
(330304105, 330304, '郭溪镇', 330304105),
(330304106, 330304, '潘桥镇', 330304106),
(330304108, 330304, '泽雅镇', 330304108),
(330304109, 330304, '丽岙镇', 330304109),
(330304110, 330304, '仙岩镇', 330304110),
(330322100, 330322, '北岙镇', 330322100),
(330322101, 330322, '大门镇', 330322101),
(330322102, 330322, '东屏镇', 330322102),
(330322200, 330322, '元觉乡', 330322200),
(330322201, 330322, '霓屿乡', 330322201),
(330322202, 330322, '鹿西乡', 330322202),
(330324100, 330324, '上塘镇', 330324100),
(330324101, 330324, '瓯北镇', 330324101),
(330324102, 330324, '桥头镇', 330324102),
(330324103, 330324, '乌牛镇', 330324103),
(330324104, 330324, '桥下镇', 330324104),
(330324105, 330324, '大若岩镇', 330324105),
(330324106, 330324, '碧莲镇', 330324106),
(330324107, 330324, '巽宅镇', 330324107),
(330324108, 330324, '岩头镇', 330324108),
(330324109, 330324, '枫林镇', 330324109),
(330324110, 330324, '岩坦镇', 330324110),
(330324111, 330324, '沙头镇', 330324111),
(330324200, 330324, '西溪乡', 330324200),
(330324201, 330324, '徐岙乡', 330324201),
(330324202, 330324, '昆阳乡', 330324202),
(330324203, 330324, '茗岙乡', 330324203),
(330324204, 330324, '山坑乡', 330324204),
(330324205, 330324, '应坑乡', 330324205),
(330324206, 330324, '大岙乡', 330324206),
(330324207, 330324, '溪下乡', 330324207),
(330324208, 330324, '界坑乡', 330324208),
(330324209, 330324, '西岙乡', 330324209),
(330324210, 330324, '石染乡', 330324210),
(330324211, 330324, '五(氵束鸟）乡', 330324211),
(330324212, 330324, '表山乡', 330324212),
(330324213, 330324, '东皋乡', 330324213),
(330324214, 330324, '鹤盛乡', 330324214),
(330324215, 330324, '西源乡', 330324215),
(330324216, 330324, '岭头乡', 330324216),
(330324217, 330324, '溪口乡', 330324217),
(330324218, 330324, '鲤溪乡', 330324218),
(330324219, 330324, '张溪乡', 330324219),
(330324220, 330324, '黄南乡', 330324220),
(330324221, 330324, '潘坑乡', 330324221),
(330324222, 330324, '陡门乡', 330324222),
(330324223, 330324, '花坦乡', 330324223),
(330324224, 330324, '渠口乡', 330324224),
(330324225, 330324, '下寮乡', 330324225),
(330326100, 330326, '昆阳镇', 330326100),
(330326101, 330326, '鳌江镇', 330326101),
(330326102, 330326, '水头镇', 330326102),
(330326103, 330326, '萧江镇', 330326103),
(330326104, 330326, '麻步镇', 330326104),
(330326105, 330326, '腾蛟镇', 330326105),
(330326106, 330326, '钱仓镇', 330326106),
(330326107, 330326, '山门镇', 330326107),
(330326108, 330326, '顺溪镇', 330326108),
(330326109, 330326, '南雁镇', 330326109),
(330326110, 330326, '凤卧镇', 330326110),
(330326111, 330326, '鹤溪镇', 330326111),
(330326112, 330326, '宋桥镇', 330326112),
(330326113, 330326, '宋埠镇', 330326113),
(330326114, 330326, '榆垟镇', 330326114),
(330326115, 330326, '郑楼镇', 330326115),
(330326116, 330326, '南麂镇', 330326116),
(330326202, 330326, '西湾乡', 330326202),
(330326204, 330326, '梅溪乡', 330326204),
(330326205, 330326, '梅源乡', 330326205),
(330326206, 330326, '桃源乡', 330326206),
(330326207, 330326, '凤巢乡', 330326207),
(330326208, 330326, '龙尾乡', 330326208),
(330326209, 330326, '南湖乡', 330326209),
(330326210, 330326, '朝阳乡', 330326210),
(330326211, 330326, '闹村乡', 330326211),
(330326212, 330326, '晓坑乡', 330326212),
(330326213, 330326, '怀溪乡', 330326213),
(330326214, 330326, '青街畲族乡', 330326214),
(330326215, 330326, '维新乡', 330326215),
(330326216, 330326, '吴垟乡', 330326216),
(330327100, 330327, '灵溪镇', 330327100),
(330327101, 330327, '龙港镇', 330327101),
(330327103, 330327, '宜山镇', 330327103),
(330327104, 330327, '钱库镇', 330327104),
(330327105, 330327, '芦浦镇', 330327105),
(330327106, 330327, '望里镇', 330327106),
(330327107, 330327, '金乡镇', 330327107),
(330327108, 330327, '舥艚镇', 330327108),
(330327109, 330327, '炎亭镇', 330327109),
(330327110, 330327, '大渔镇', 330327110),
(330327112, 330327, '藻溪镇', 330327112),
(330327113, 330327, '桥墩镇', 330327113),
(330327114, 330327, '莒溪镇', 330327114),
(330327115, 330327, '观美镇', 330327115),
(330327116, 330327, '矾山镇', 330327116),
(330327117, 330327, '赤溪镇', 330327117),
(330327118, 330327, '马站镇', 330327118),
(330327119, 330327, '霞关镇', 330327119),
(330327120, 330327, '沿浦镇', 330327120),
(330327121, 330327, '南宋镇', 330327121),
(330327202, 330327, '云岩乡', 330327202),
(330327203, 330327, '仙居乡', 330327203),
(330327204, 330327, '新安乡', 330327204),
(330327205, 330327, '括山乡', 330327205),
(330327206, 330327, '石砰乡', 330327206),
(330327207, 330327, '凤池乡', 330327207),
(330327209, 330327, '浦亭乡', 330327209),
(330327210, 330327, '五凤乡', 330327210),
(330327211, 330327, '腾垟乡', 330327211),
(330327213, 330327, '昌禅乡', 330327213),
(330327214, 330327, '中墩乡', 330327214),
(330327215, 330327, '龙沙乡', 330327215),
(330327216, 330327, '凤阳畲族乡', 330327216),
(330327217, 330327, '蒲城乡', 330327217),
(330327218, 330327, '岱岭畲族乡', 330327218),
(330327219, 330327, '渔寮乡', 330327219),
(330328100, 330328, '大峃镇', 330328100),
(330328101, 330328, '百丈漈镇', 330328101),
(330328102, 330328, '南田镇', 330328102),
(330328103, 330328, '西坑畲族镇', 330328103),
(330328104, 330328, '黄坦镇', 330328104),
(330328105, 330328, '珊溪镇', 330328105),
(330328106, 330328, '巨屿镇', 330328106),
(330328107, 330328, '玉壶镇', 330328107),
(330328200, 330328, '樟台乡', 330328200),
(330328201, 330328, '金炉乡', 330328201),
(330328202, 330328, '龙川乡', 330328202),
(330328203, 330328, '里阳乡', 330328203),
(330328204, 330328, '二源乡', 330328204),
(330328205, 330328, '黄寮乡', 330328205),
(330328206, 330328, '十源乡', 330328206),
(330328207, 330328, '石垟乡', 330328207),
(330328208, 330328, '下垟乡', 330328208),
(330328209, 330328, '岭后乡', 330328209),
(330328210, 330328, '富岙乡', 330328210),
(330328211, 330328, '云湖乡', 330328211),
(330328212, 330328, '仰山乡', 330328212),
(330328213, 330328, '桂山乡', 330328213),
(330328214, 330328, '峃口乡', 330328214),
(330328215, 330328, '金垟乡', 330328215),
(330328216, 330328, '双桂乡', 330328216),
(330328217, 330328, '周山畲族乡', 330328217),
(330328218, 330328, '公阳乡', 330328218),
(330328219, 330328, '平和乡', 330328219),
(330328220, 330328, '周壤乡', 330328220),
(330328221, 330328, '上林乡', 330328221),
(330328222, 330328, '东溪乡', 330328222),
(330328223, 330328, '金星乡', 330328223),
(330328224, 330328, '朱雅乡', 330328224),
(330329100, 330329, '罗阳镇', 330329100),
(330329101, 330329, '司前畲族镇', 330329101),
(330329102, 330329, '百丈镇', 330329102),
(330329103, 330329, '筱村镇', 330329103),
(330329104, 330329, '泗溪镇', 330329104),
(330329105, 330329, '彭溪镇', 330329105),
(330329106, 330329, '雅阳镇', 330329106),
(330329107, 330329, '仕阳镇', 330329107),
(330329108, 330329, '龟湖镇', 330329108),
(330329109, 330329, '三魁镇', 330329109),
(330329110, 330329, '西旸镇', 330329110),
(330329200, 330329, '岭北乡', 330329200),
(330329201, 330329, '仙稔乡', 330329201),
(330329202, 330329, '南院乡', 330329202),
(330329203, 330329, '碑排乡', 330329203),
(330329204, 330329, '竹里畲族乡', 330329204),
(330329205, 330329, '黄桥乡', 330329205),
(330329206, 330329, '峰门乡', 330329206),
(330329207, 330329, '包垟乡', 330329207),
(330329208, 330329, '新浦乡', 330329208),
(330329209, 330329, '联云乡', 330329209),
(330329210, 330329, '翁山乡', 330329210),
(330329211, 330329, '凤垟乡', 330329211),
(330329212, 330329, '横坑乡', 330329212),
(330329213, 330329, '九峰乡', 330329213),
(330329214, 330329, '峰文乡', 330329214),
(330329215, 330329, '月湖乡', 330329215),
(330329216, 330329, '松垟乡', 330329216),
(330329217, 330329, '柳峰乡', 330329217),
(330329218, 330329, '雪溪乡', 330329218),
(330329219, 330329, '万排乡', 330329219),
(330329220, 330329, '东溪乡', 330329220),
(330329221, 330329, '大安乡', 330329221),
(330329222, 330329, '垟溪乡', 330329222),
(330329223, 330329, '洲岭乡', 330329223),
(330329224, 330329, '下洪乡', 330329224),
(330381001, 330381, '安阳街道', 330381001),
(330381002, 330381, '玉海街道', 330381002),
(330381003, 330381, '锦湖街道', 330381003),
(330381004, 330381, '东山街道', 330381004),
(330381005, 330381, '上望街道', 330381005),
(330381006, 330381, '潘岱街道', 330381006),
(330381101, 330381, '塘下镇', 330381101),
(330381109, 330381, '莘塍镇', 330381109),
(330381111, 330381, '汀田镇', 330381111),
(330381114, 330381, '飞云镇', 330381114),
(330381115, 330381, '仙降镇', 330381115),
(330381116, 330381, '马屿镇', 330381116),
(330381118, 330381, '曹村镇', 330381118),
(330381120, 330381, '陶山镇', 330381120),
(330381121, 330381, '碧山镇', 330381121),
(330381122, 330381, '湖岭镇', 330381122),
(330381123, 330381, '龙湖镇', 330381123),
(330381124, 330381, '平阳坑镇', 330381124),
(330381201, 330381, '荆谷乡', 330381201),
(330381202, 330381, '梅屿乡', 330381202),
(330381203, 330381, '顺泰乡', 330381203),
(330381204, 330381, '大南乡', 330381204),
(330381205, 330381, '桐浦乡', 330381205),
(330381207, 330381, '永安乡', 330381207),
(330381208, 330381, '桂峰乡', 330381208),
(330381209, 330381, '芳庄乡', 330381209),
(330381210, 330381, '林溪乡', 330381210),
(330381211, 330381, '金川乡', 330381211),
(330381212, 330381, '潮基乡', 330381212),
(330381213, 330381, '鹿木乡', 330381213),
(330381214, 330381, '高楼乡', 330381214),
(330381215, 330381, '营前乡', 330381215),
(330381216, 330381, '东岩乡', 330381216),
(330381217, 330381, '宁益乡', 330381217),
(330381218, 330381, '枫岭乡', 330381218),
(330381219, 330381, '北麂乡', 330381219),
(330381220, 330381, '北龙乡', 330381220),
(330381400, 330381, '飞云江农场', 330381400),
(330382100, 330382, '乐成镇', 330382100),
(330382101, 330382, '大荆镇', 330382101),
(330382102, 330382, '仙溪镇', 330382102),
(330382103, 330382, '湖雾镇', 330382103),
(330382104, 330382, '雁荡镇', 330382104),
(330382105, 330382, '芙蓉镇', 330382105),
(330382106, 330382, '清江镇', 330382106),
(330382107, 330382, '南塘镇', 330382107),
(330382108, 330382, '虹桥镇', 330382108),
(330382109, 330382, '南岳镇', 330382109),
(330382110, 330382, '蒲岐镇', 330382110),
(330382111, 330382, '淡溪镇', 330382111),
(330382112, 330382, '石帆镇', 330382112),
(330382113, 330382, '白石镇', 330382113),
(330382114, 330382, '柳市镇', 330382114),
(330382115, 330382, '北白象镇', 330382115),
(330382116, 330382, '象阳镇', 330382116),
(330382117, 330382, '翁垟镇', 330382117),
(330382118, 330382, '磐石镇', 330382118),
(330382119, 330382, '七里港镇', 330382119),
(330382120, 330382, '黄华镇', 330382120),
(330382200, 330382, '智仁乡', 330382200),
(330382201, 330382, '镇安乡', 330382201),
(330382202, 330382, '福溪乡', 330382202),
(330382203, 330382, '双峰乡', 330382203),
(330382204, 330382, '龙西乡', 330382204),
(330382205, 330382, '雁湖乡', 330382205),
(330382206, 330382, '岭底乡', 330382206),
(330382207, 330382, '四都乡', 330382207),
(330382208, 330382, '天成乡', 330382208),
(330382209, 330382, '城北乡', 330382209),
(330402007, 330402, '建设街道', 330402007),
(330402008, 330402, '解放街道', 330402008),
(330402009, 330402, '新嘉街道', 330402009),
(330402010, 330402, '南湖街道', 330402010),
(330402011, 330402, '新兴街道', 330402011),
(330402012, 330402, '城南街道', 330402012),
(330402013, 330402, '东栅街道', 330402013),
(330402100, 330402, '凤桥镇', 330402100),
(330402101, 330402, '余新镇', 330402101),
(330402103, 330402, '新丰镇', 330402103),
(330402104, 330402, '七星镇', 330402104),
(330402105, 330402, '大桥镇', 330402105),
(330411002, 330411, '新城街道', 330411002),
(330411003, 330411, '嘉北街道', 330411003),
(330411004, 330411, '塘汇街道', 330411004),
(330411101, 330411, '王江泾镇', 330411101),
(330411103, 330411, '油车港镇', 330411103),
(330411104, 330411, '新塍镇', 330411104),
(330411105, 330411, '王店镇', 330411105),
(330411106, 330411, '洪合镇', 330411106),
(330421100, 330421, '魏塘镇', 330421100),
(330421101, 330421, '惠民镇', 330421101),
(330421102, 330421, '大云镇', 330421102),
(330421103, 330421, '西塘镇', 330421103),
(330421104, 330421, '丁栅镇', 330421104),
(330421105, 330421, '干窑镇', 330421105),
(330421106, 330421, '姚庄镇', 330421106),
(330421107, 330421, '陶庄镇', 330421107),
(330421108, 330421, '天凝镇', 330421108),
(330421109, 330421, '洪溪镇', 330421109),
(330421110, 330421, '杨庙镇', 330421110),
(330424100, 330424, '武原镇', 330424100),
(330424101, 330424, '沈荡镇', 330424101),
(330424102, 330424, '百步镇', 330424102),
(330424103, 330424, '于城镇', 330424103),
(330424104, 330424, '秦山镇', 330424104),
(330424105, 330424, '澉浦镇', 330424105),
(330424106, 330424, '通元镇', 330424106),
(330424107, 330424, '西塘桥镇', 330424107),
(330481001, 330481, '硖石街道', 330481001),
(330481002, 330481, '海洲街道', 330481002),
(330481003, 330481, '海昌街道', 330481003),
(330481004, 330481, '马桥街道', 330481004),
(330481101, 330481, '许村镇', 330481101),
(330481103, 330481, '长安镇', 330481103),
(330481105, 330481, '周王庙镇', 330481105),
(330481106, 330481, '丁桥镇', 330481106),
(330481107, 330481, '斜桥镇', 330481107),
(330481108, 330481, '黄湾镇', 330481108),
(330481110, 330481, '盐官镇', 330481110),
(330481112, 330481, '袁花镇', 330481112),
(330481400, 330481, '尖山新区', 330481400),
(330482001, 330482, '当湖街道', 330482001),
(330482002, 330482, '钟埭街道', 330482002),
(330482003, 330482, '曹桥街道', 330482003),
(330482101, 330482, '乍浦镇', 330482101),
(330482102, 330482, '新埭镇', 330482102),
(330482103, 330482, '新仓镇', 330482103),
(330482104, 330482, '黄姑镇', 330482104),
(330482105, 330482, '全塘镇', 330482105),
(330482106, 330482, '广陈镇', 330482106),
(330482107, 330482, '林埭镇', 330482107),
(330483001, 330483, '梧桐街道', 330483001),
(330483002, 330483, '龙翔街道', 330483002),
(330483003, 330483, '凤鸣街道', 330483003),
(330483100, 330483, '乌镇镇', 330483100),
(330483101, 330483, '濮院镇', 330483101),
(330483102, 330483, '屠甸镇', 330483102),
(330483103, 330483, '石门镇', 330483103),
(330483104, 330483, '河山镇', 330483104),
(330483105, 330483, '洲泉镇', 330483105),
(330483106, 330483, '大麻镇', 330483106),
(330483107, 330483, '崇福镇', 330483107),
(330483108, 330483, '高桥镇', 330483108),
(330483200, 330483, '同福乡', 330483200),
(330502001, 330502, '月河街道', 330502001),
(330502002, 330502, '朝阳街道', 330502002),
(330502003, 330502, '爱山街道', 330502003),
(330502004, 330502, '飞英街道', 330502004),
(330502005, 330502, '龙泉街道', 330502005),
(330502006, 330502, '凤凰街道', 330502006),
(330502100, 330502, '织里镇', 330502100),
(330502101, 330502, '八里店镇', 330502101),
(330502102, 330502, '妙西镇', 330502102),
(330502103, 330502, '杨家埠镇', 330502103),
(330502104, 330502, '埭溪镇', 330502104),
(330502105, 330502, '东林镇', 330502105),
(330502200, 330502, '道场乡', 330502200),
(330502201, 330502, '环渚乡', 330502201),
(330502202, 330502, '白雀乡', 330502202),
(330503100, 330503, '南浔镇', 330503100),
(330503101, 330503, '双林镇', 330503101),
(330503102, 330503, '练市镇', 330503102),
(330503103, 330503, '善琏镇', 330503103),
(330503104, 330503, '旧馆镇', 330503104),
(330503105, 330503, '菱湖镇', 330503105),
(330503106, 330503, '和孚镇', 330503106),
(330503107, 330503, '千金镇', 330503107),
(330503108, 330503, '石淙镇', 330503108),
(330521100, 330521, '武康镇', 330521100),
(330521101, 330521, '乾元镇', 330521101),
(330521102, 330521, '新市镇', 330521102),
(330521103, 330521, '洛舍镇', 330521103);
INSERT INTO `{pre}areas` VALUES
(330521104, 330521, '钟管镇', 330521104),
(330521105, 330521, '莫干山镇', 330521105),
(330521110, 330521, '雷甸镇', 330521110),
(330521113, 330521, '禹越镇', 330521113),
(330521114, 330521, '新安镇', 330521114),
(330521201, 330521, '筏头乡', 330521201),
(330521202, 330521, '三合乡', 330521202),
(330522100, 330522, '雉城镇', 330522100),
(330522101, 330522, '洪桥镇', 330522101),
(330522102, 330522, '李家巷镇', 330522102),
(330522103, 330522, '夹浦镇', 330522103),
(330522104, 330522, '林城镇', 330522104),
(330522105, 330522, '泗安镇', 330522105),
(330522106, 330522, '虹星桥镇', 330522106),
(330522107, 330522, '和平镇', 330522107),
(330522108, 330522, '小浦镇', 330522108),
(330522109, 330522, '煤山镇', 330522109),
(330522200, 330522, '水口乡', 330522200),
(330522201, 330522, '二界岭乡', 330522201),
(330522202, 330522, '吕山乡', 330522202),
(330522203, 330522, '吴山乡', 330522203),
(330522204, 330522, '白岘乡', 330522204),
(330522205, 330522, '槐坎乡', 330522205),
(330523100, 330523, '递铺镇', 330523100),
(330523101, 330523, '梅溪镇', 330523101),
(330523102, 330523, '良朋镇', 330523102),
(330523103, 330523, '鄣吴镇', 330523103),
(330523104, 330523, '杭垓镇', 330523104),
(330523105, 330523, '孝丰镇', 330523105),
(330523106, 330523, '报福镇', 330523106),
(330523107, 330523, '章村镇', 330523107),
(330523108, 330523, '天荒坪镇', 330523108),
(330523109, 330523, '高禹镇', 330523109),
(330523200, 330523, '昆铜乡', 330523200),
(330523201, 330523, '溪龙乡', 330523201),
(330523204, 330523, '皈山乡', 330523204),
(330523205, 330523, '上墅乡', 330523205),
(330523206, 330523, '山川乡', 330523206),
(330602001, 330602, '塔山街道', 330602001),
(330602002, 330602, '府山街道', 330602002),
(330602003, 330602, '蕺山街道', 330602003),
(330602004, 330602, '北海街道', 330602004),
(330602005, 330602, '城南街道', 330602005),
(330602006, 330602, '稽山街道', 330602006),
(330602100, 330602, '东湖镇', 330602100),
(330602101, 330602, '灵芝镇', 330602101),
(330602102, 330602, '东浦镇', 330602102),
(330602103, 330602, '鉴湖镇', 330602103),
(330602104, 330602, '皋埠镇', 330602104),
(330602105, 330602, '马山镇', 330602105),
(330602106, 330602, '斗门镇', 330602106),
(330621001, 330621, '柯桥街道', 330621001),
(330621002, 330621, '柯岩街道', 330621002),
(330621003, 330621, '华舍街道', 330621003),
(330621004, 330621, '湖塘街道', 330621004),
(330621100, 330621, '齐贤镇', 330621100),
(330621101, 330621, '钱清镇', 330621101),
(330621102, 330621, '孙端镇', 330621102),
(330621103, 330621, '福全镇', 330621103),
(330621104, 330621, '马鞍镇', 330621104),
(330621105, 330621, '平水镇', 330621105),
(330621106, 330621, '安昌镇', 330621106),
(330621107, 330621, '王坛镇', 330621107),
(330621108, 330621, '兰亭镇', 330621108),
(330621109, 330621, '稽东镇', 330621109),
(330621110, 330621, '杨汛桥镇', 330621110),
(330621111, 330621, '漓渚镇', 330621111),
(330621112, 330621, '富盛镇', 330621112),
(330621113, 330621, '陶堰镇', 330621113),
(330621114, 330621, '夏履镇', 330621114),
(330624001, 330624, '羽林街道', 330624001),
(330624002, 330624, '南明街道', 330624002),
(330624003, 330624, '七星街道', 330624003),
(330624101, 330624, '澄潭镇', 330624101),
(330624102, 330624, '梅渚镇', 330624102),
(330624104, 330624, '回山镇', 330624104),
(330624106, 330624, '大市聚镇', 330624106),
(330624107, 330624, '小将镇', 330624107),
(330624108, 330624, '沙溪镇', 330624108),
(330624109, 330624, '镜岭镇', 330624109),
(330624110, 330624, '儒岙镇', 330624110),
(330624200, 330624, '城南乡', 330624200),
(330624201, 330624, '东茗乡', 330624201),
(330624203, 330624, '双彩乡', 330624203),
(330624205, 330624, '新林乡', 330624205),
(330624206, 330624, '巧英乡', 330624206),
(330681001, 330681, '暨阳街道', 330681001),
(330681002, 330681, '浣东街道', 330681002),
(330681003, 330681, '陶朱街道', 330681003),
(330681101, 330681, '大唐镇', 330681101),
(330681102, 330681, '应店街镇', 330681102),
(330681103, 330681, '次坞镇', 330681103),
(330681104, 330681, '店口镇', 330681104),
(330681105, 330681, '阮市镇', 330681105),
(330681106, 330681, '直埠镇', 330681106),
(330681107, 330681, '江藻镇', 330681107),
(330681108, 330681, '山下湖镇', 330681108),
(330681109, 330681, '枫桥镇', 330681109),
(330681110, 330681, '赵家镇', 330681110),
(330681111, 330681, '马剑镇', 330681111),
(330681112, 330681, '五泄镇', 330681112),
(330681113, 330681, '草塔镇', 330681113),
(330681114, 330681, '王家井镇', 330681114),
(330681115, 330681, '牌头镇', 330681115),
(330681116, 330681, '同山镇', 330681116),
(330681117, 330681, '安华镇', 330681117),
(330681118, 330681, '街亭镇', 330681118),
(330681119, 330681, '璜山镇', 330681119),
(330681120, 330681, '陈宅镇', 330681120),
(330681121, 330681, '岭北镇', 330681121),
(330681122, 330681, '浬浦镇', 330681122),
(330681124, 330681, '东白湖镇', 330681124),
(330681201, 330681, '东和乡', 330681201),
(330682001, 330682, '百官街道', 330682001),
(330682002, 330682, '曹娥街道', 330682002),
(330682003, 330682, '东关街道', 330682003),
(330682100, 330682, '道墟镇', 330682100),
(330682101, 330682, '长塘镇', 330682101),
(330682102, 330682, '上浦镇', 330682102),
(330682103, 330682, '汤浦镇', 330682103),
(330682104, 330682, '章镇镇', 330682104),
(330682105, 330682, '下管镇', 330682105),
(330682106, 330682, '丰惠镇', 330682106),
(330682107, 330682, '永和镇', 330682107),
(330682108, 330682, '梁湖镇', 330682108),
(330682109, 330682, '驿亭镇', 330682109),
(330682110, 330682, '小越镇', 330682110),
(330682111, 330682, '谢塘镇', 330682111),
(330682112, 330682, '盖北镇', 330682112),
(330682113, 330682, '崧厦镇', 330682113),
(330682114, 330682, '沥海镇', 330682114),
(330682200, 330682, '岭南乡', 330682200),
(330682201, 330682, '陈溪乡', 330682201),
(330682202, 330682, '丁宅乡', 330682202),
(330682500, 330682, '围垦场', 330682500),
(330682501, 330682, '农发场', 330682501),
(330683001, 330683, '剡湖街道', 330683001),
(330683002, 330683, '三江街道', 330683002),
(330683003, 330683, '鹿山街道', 330683003),
(330683004, 330683, '浦口街道', 330683004),
(330683100, 330683, '甘霖镇', 330683100),
(330683101, 330683, '长乐镇', 330683101),
(330683102, 330683, '崇仁镇', 330683102),
(330683103, 330683, '黄泽镇', 330683103),
(330683104, 330683, '三界镇', 330683104),
(330683105, 330683, '石璜镇', 330683105),
(330683106, 330683, '谷来镇', 330683106),
(330683107, 330683, '仙岩镇', 330683107),
(330683108, 330683, '金庭镇', 330683108),
(330683109, 330683, '北漳镇', 330683109),
(330683110, 330683, '下王镇', 330683110),
(330683200, 330683, '贵门乡', 330683200),
(330683201, 330683, '里南乡', 330683201),
(330683202, 330683, '竹溪乡', 330683202),
(330683203, 330683, '雅璜乡', 330683203),
(330683204, 330683, '王院乡', 330683204),
(330683205, 330683, '通源乡', 330683205),
(330702001, 330702, '城东街道', 330702001),
(330702002, 330702, '城中街道', 330702002),
(330702003, 330702, '城西街道', 330702003),
(330702004, 330702, '城北街道', 330702004),
(330702005, 330702, '江南街道', 330702005),
(330702006, 330702, '三江街道', 330702006),
(330702007, 330702, '西关街道', 330702007),
(330702008, 330702, '秋滨街道', 330702008),
(330702009, 330702, '新狮街道', 330702009),
(330702100, 330702, '罗店镇', 330702100),
(330702101, 330702, '雅畈镇', 330702101),
(330702102, 330702, '安地镇', 330702102),
(330702103, 330702, '白龙桥镇', 330702103),
(330702104, 330702, '琅琊镇', 330702104),
(330702105, 330702, '蒋堂镇', 330702105),
(330702106, 330702, '汤溪镇', 330702106),
(330702107, 330702, '罗埠镇', 330702107),
(330702108, 330702, '洋埠镇', 330702108),
(330702201, 330702, '乾西乡', 330702201),
(330702202, 330702, '竹马乡', 330702202),
(330702203, 330702, '长山乡', 330702203),
(330702204, 330702, '箬阳乡', 330702204),
(330702205, 330702, '沙畈乡', 330702205),
(330702206, 330702, '塔石乡', 330702206),
(330702207, 330702, '岭上乡', 330702207),
(330702208, 330702, '莘畈乡', 330702208),
(330702209, 330702, '苏孟乡', 330702209),
(330703001, 330703, '多湖街道', 330703001),
(330703002, 330703, '东孝街道', 330703002),
(330703101, 330703, '孝顺镇', 330703101),
(330703102, 330703, '傅村镇', 330703102),
(330703103, 330703, '曹宅镇', 330703103),
(330703104, 330703, '澧浦镇', 330703104),
(330703105, 330703, '岭下镇', 330703105),
(330703106, 330703, '江东镇', 330703106),
(330703107, 330703, '塘雅镇', 330703107),
(330703108, 330703, '赤松镇', 330703108),
(330703200, 330703, '源东乡', 330703200),
(330723001, 330723, '白洋街道', 330723001),
(330723002, 330723, '壶山街道', 330723002),
(330723003, 330723, '熟溪街道', 330723003),
(330723100, 330723, '柳城畲族镇', 330723100),
(330723101, 330723, '履坦镇', 330723101),
(330723102, 330723, '桐琴镇', 330723102),
(330723103, 330723, '泉溪镇', 330723103),
(330723104, 330723, '新宅镇', 330723104),
(330723105, 330723, '王宅镇', 330723105),
(330723106, 330723, '桃溪镇', 330723106),
(330723107, 330723, '茭道镇', 330723107),
(330723200, 330723, '大田乡', 330723200),
(330723201, 330723, '白姆乡', 330723201),
(330723202, 330723, '俞源乡', 330723202),
(330723203, 330723, '坦洪乡', 330723203),
(330723204, 330723, '西联乡', 330723204),
(330723205, 330723, '三港乡', 330723205),
(330723206, 330723, '大溪口乡', 330723206),
(330726001, 330726, '浦南街道', 330726001),
(330726002, 330726, '仙华街道', 330726002),
(330726003, 330726, '浦阳街道', 330726003),
(330726101, 330726, '黄宅镇', 330726101),
(330726102, 330726, '白马镇', 330726102),
(330726103, 330726, '郑家坞镇', 330726103),
(330726104, 330726, '郑宅镇', 330726104),
(330726105, 330726, '岩头镇', 330726105),
(330726106, 330726, '檀溪镇', 330726106),
(330726107, 330726, '杭坪镇', 330726107),
(330726200, 330726, '大畈乡', 330726200),
(330726201, 330726, '中余乡', 330726201),
(330726202, 330726, '前吴乡', 330726202),
(330726203, 330726, '花桥乡', 330726203),
(330726204, 330726, '虞宅乡', 330726204),
(330727100, 330727, '安文镇', 330727100),
(330727101, 330727, '新渥镇', 330727101),
(330727102, 330727, '尖山镇', 330727102),
(330727103, 330727, '仁川镇', 330727103),
(330727104, 330727, '大盘镇', 330727104),
(330727105, 330727, '方前镇', 330727105),
(330727106, 330727, '玉山镇', 330727106),
(330727107, 330727, '尚湖镇', 330727107),
(330727108, 330727, '冷水镇', 330727108),
(330727200, 330727, '深泽乡', 330727200),
(330727201, 330727, '双峰乡', 330727201),
(330727203, 330727, '双溪乡', 330727203),
(330727204, 330727, '墨林乡', 330727204),
(330727205, 330727, '窈川乡', 330727205),
(330727206, 330727, '盘峰乡', 330727206),
(330727207, 330727, '高二乡', 330727207),
(330727208, 330727, '维新乡', 330727208),
(330727209, 330727, '胡宅乡', 330727209),
(330727210, 330727, '万苍乡', 330727210),
(330727211, 330727, '九和乡', 330727211),
(330781001, 330781, '兰江街道', 330781001),
(330781002, 330781, '云山街道', 330781002),
(330781004, 330781, '永昌街道', 330781004),
(330781005, 330781, '赤溪街道', 330781005),
(330781006, 330781, '女埠街道', 330781006),
(330781007, 330781, '上华街道', 330781007),
(330781102, 330781, '游埠镇', 330781102),
(330781104, 330781, '诸葛镇', 330781104),
(330781106, 330781, '黄店镇', 330781106),
(330781108, 330781, '香溪镇', 330781108),
(330781109, 330781, '马涧镇', 330781109),
(330781111, 330781, '梅江镇', 330781111),
(330781200, 330781, '灵洞乡', 330781200),
(330781203, 330781, '水亭畲族乡', 330781203),
(330781209, 330781, '柏社乡', 330781209),
(330782001, 330782, '稠城街道', 330782001),
(330782002, 330782, '江东街道', 330782002),
(330782003, 330782, '稠江街道', 330782003),
(330782004, 330782, '北苑街道', 330782004),
(330782005, 330782, '后宅街道', 330782005),
(330782006, 330782, '城西街道', 330782006),
(330782007, 330782, '廿三里街道', 330782007),
(330782100, 330782, '佛堂镇', 330782100),
(330782101, 330782, '赤岸镇', 330782101),
(330782102, 330782, '义亭镇', 330782102),
(330782104, 330782, '上溪镇', 330782104),
(330782105, 330782, '苏溪镇', 330782105),
(330782106, 330782, '大陈镇', 330782106),
(330783001, 330783, '吴宁街道', 330783001),
(330783003, 330783, '南市街道', 330783003),
(330783004, 330783, '白云街道', 330783004),
(330783005, 330783, '江北街道', 330783005),
(330783006, 330783, '城东街道', 330783006),
(330783007, 330783, '六石街道', 330783007),
(330783106, 330783, '巍山镇', 330783106),
(330783107, 330783, '虎鹿镇', 330783107),
(330783108, 330783, '歌山镇', 330783108),
(330783109, 330783, '佐村镇', 330783109),
(330783110, 330783, '东阳江镇', 330783110),
(330783112, 330783, '湖溪镇', 330783112),
(330783114, 330783, '马宅镇', 330783114),
(330783116, 330783, '千祥镇', 330783116),
(330783118, 330783, '南马镇', 330783118),
(330783122, 330783, '画水镇', 330783122),
(330783123, 330783, '横店镇', 330783123),
(330783201, 330783, '三单乡', 330783201),
(330784001, 330784, '东城街道', 330784001),
(330784002, 330784, '西城街道', 330784002),
(330784003, 330784, '江南街道', 330784003),
(330784004, 330784, '芝英街道', 330784004),
(330784105, 330784, '石柱镇', 330784105),
(330784106, 330784, '前仓镇', 330784106),
(330784107, 330784, '舟山镇', 330784107),
(330784108, 330784, '古山镇', 330784108),
(330784109, 330784, '方岩镇', 330784109),
(330784110, 330784, '龙山镇', 330784110),
(330784111, 330784, '西溪镇', 330784111),
(330784112, 330784, '象珠镇', 330784112),
(330784113, 330784, '唐先镇', 330784113),
(330784114, 330784, '花街镇', 330784114),
(330802005, 330802, '新新街道', 330802005),
(330802006, 330802, '府山街道', 330802006),
(330802007, 330802, '荷花街道', 330802007),
(330802008, 330802, '信安街道', 330802008),
(330802009, 330802, '白云街道', 330802009),
(330802010, 330802, '双港街道', 330802010),
(330802011, 330802, '花园街道', 330802011),
(330802100, 330802, '石梁镇', 330802100),
(330802101, 330802, '航埠镇', 330802101),
(330802205, 330802, '黄家乡', 330802205),
(330802209, 330802, '七里乡', 330802209),
(330802210, 330802, '九华乡', 330802210),
(330802211, 330802, '沟溪乡', 330802211),
(330802212, 330802, '华墅乡', 330802212),
(330802213, 330802, '姜家山乡', 330802213),
(330802214, 330802, '万田乡', 330802214),
(330802215, 330802, '石室乡', 330802215),
(330803001, 330803, '樟潭街道', 330803001),
(330803002, 330803, '浮石街道', 330803002),
(330803100, 330803, '上方镇', 330803100),
(330803101, 330803, '峡川镇', 330803101),
(330803103, 330803, '莲花镇', 330803103),
(330803109, 330803, '全旺镇', 330803109),
(330803110, 330803, '大洲镇', 330803110),
(330803111, 330803, '后溪镇', 330803111),
(330803112, 330803, '廿里镇', 330803112),
(330803113, 330803, '湖南镇', 330803113),
(330803114, 330803, '高家镇', 330803114),
(330803115, 330803, '杜泽镇', 330803115),
(330803200, 330803, '灰坪乡', 330803200),
(330803202, 330803, '太真乡', 330803202),
(330803203, 330803, '双桥乡', 330803203),
(330803206, 330803, '周家乡', 330803206),
(330803207, 330803, '云溪乡', 330803207),
(330803209, 330803, '横路乡', 330803209),
(330803213, 330803, '举村乡', 330803213),
(330803218, 330803, '岭洋乡', 330803218),
(330803219, 330803, '黄坛口乡', 330803219),
(330822101, 330822, '辉埠镇', 330822101),
(330822104, 330822, '白石镇', 330822104),
(330822107, 330822, '天马镇', 330822107),
(330822108, 330822, '招贤镇', 330822108),
(330822109, 330822, '青石镇', 330822109),
(330822110, 330822, '芳村镇', 330822110),
(330822111, 330822, '球川镇', 330822111),
(330822200, 330822, '何家乡', 330822200),
(330822211, 330822, '同弓乡', 330822211),
(330822213, 330822, '大桥头乡', 330822213),
(330822217, 330822, '宋畈乡', 330822217),
(330822218, 330822, '东案乡', 330822218),
(330822219, 330822, '新昌乡', 330822219),
(330822220, 330822, '新桥乡', 330822220),
(330824106, 330824, '桐村镇', 330824106),
(330824107, 330824, '杨林镇', 330824107),
(330824108, 330824, '苏庄镇', 330824108),
(330824109, 330824, '齐溪镇', 330824109),
(330824110, 330824, '城关镇', 330824110),
(330824111, 330824, '华埠镇', 330824111),
(330824112, 330824, '马金镇', 330824112),
(330824113, 330824, '村头镇', 330824113),
(330824114, 330824, '池淮镇', 330824114),
(330824202, 330824, '中村乡', 330824202),
(330824205, 330824, '长虹乡', 330824205),
(330824206, 330824, '张湾乡', 330824206),
(330824208, 330824, '何田乡', 330824208),
(330824209, 330824, '塘坞乡', 330824209),
(330824216, 330824, '林山乡', 330824216),
(330824217, 330824, '音坑乡', 330824217),
(330824218, 330824, '大溪边乡', 330824218),
(330824219, 330824, '金村乡', 330824219),
(330825001, 330825, '龙洲街道', 330825001),
(330825002, 330825, '东华街道', 330825002),
(330825101, 330825, '湖镇镇', 330825101),
(330825102, 330825, '小南海镇', 330825102),
(330825106, 330825, '詹家镇', 330825106),
(330825109, 330825, '溪口镇', 330825109),
(330825110, 330825, '横山镇', 330825110),
(330825111, 330825, '塔石镇', 330825111),
(330825201, 330825, '罗家乡', 330825201),
(330825203, 330825, '庙下乡', 330825203),
(330825207, 330825, '石佛乡', 330825207),
(330825209, 330825, '社阳乡', 330825209),
(330825211, 330825, '大街乡', 330825211),
(330825212, 330825, '沐尘畲族乡', 330825212),
(330825213, 330825, '模环乡', 330825213),
(330881001, 330881, '双塔街道', 330881001),
(330881002, 330881, '虎山街道', 330881002),
(330881102, 330881, '四都镇', 330881102),
(330881104, 330881, '清湖镇', 330881104),
(330881105, 330881, '坛石镇', 330881105),
(330881106, 330881, '大桥镇', 330881106),
(330881108, 330881, '淤头镇', 330881108),
(330881109, 330881, '新塘边镇', 330881109),
(330881112, 330881, '廿八都镇', 330881112),
(330881113, 330881, '长台镇', 330881113),
(330881116, 330881, '上余镇', 330881116),
(330881117, 330881, '贺村镇', 330881117),
(330881118, 330881, '凤林镇', 330881118),
(330881119, 330881, '峡口镇', 330881119),
(330881120, 330881, '石门镇', 330881120),
(330881201, 330881, '大陈乡', 330881201),
(330881203, 330881, '碗窑乡', 330881203),
(330881207, 330881, '保安乡', 330881207),
(330881211, 330881, '双溪口乡', 330881211),
(330881212, 330881, '张村乡', 330881212),
(330881213, 330881, '塘源口乡', 330881213),
(330902001, 330902, '解放街道', 330902001),
(330902002, 330902, '昌国街道', 330902002),
(330902003, 330902, '环南街道', 330902003),
(330902004, 330902, '城东街道', 330902004),
(330902005, 330902, '盐仓街道', 330902005),
(330902006, 330902, '临城街道', 330902006),
(330902100, 330902, '金塘镇', 330902100),
(330902101, 330902, '小沙镇', 330902101),
(330902102, 330902, '岑港镇', 330902102),
(330902103, 330902, '双桥镇', 330902103),
(330902104, 330902, '白泉镇', 330902104),
(330902105, 330902, '干览镇', 330902105),
(330902106, 330902, '马岙镇', 330902106),
(330902200, 330902, '长白乡', 330902200),
(330902201, 330902, '册子乡', 330902201),
(330902202, 330902, '北蝉乡', 330902202),
(330903001, 330903, '沈家门街道', 330903001),
(330903002, 330903, '勾山街道', 330903002),
(330903003, 330903, '东港街道', 330903003),
(330903100, 330903, '六横镇', 330903100),
(330903101, 330903, '朱家尖镇', 330903101),
(330903102, 330903, '虾峙镇', 330903102),
(330903103, 330903, '展茅镇', 330903103),
(330903104, 330903, '桃花镇', 330903104),
(330903105, 330903, '东极镇', 330903105),
(330903106, 330903, '普陀山镇', 330903106),
(330903200, 330903, '蚂蚁岛乡', 330903200),
(330903201, 330903, '登步乡', 330903201),
(330903202, 330903, '白沙乡', 330903202),
(330903203, 330903, '佛渡乡', 330903203),
(330921100, 330921, '高亭镇', 330921100),
(330921101, 330921, '东沙镇', 330921101),
(330921102, 330921, '岱东镇', 330921102),
(330921103, 330921, '岱西镇', 330921103),
(330921105, 330921, '长涂镇', 330921105),
(330921106, 330921, '衢山镇', 330921106),
(330921200, 330921, '秀山乡', 330921200),
(330922100, 330922, '菜园镇', 330922100),
(330922101, 330922, '嵊山镇', 330922101),
(330922102, 330922, '洋山镇', 330922102),
(330922200, 330922, '五龙乡', 330922200),
(330922201, 330922, '黄龙乡', 330922201),
(330922202, 330922, '枸杞乡', 330922202),
(330922203, 330922, '花鸟乡', 330922203),
(331002001, 331002, '海门街道', 331002001),
(331002002, 331002, '白云街道', 331002002),
(331002003, 331002, '葭沚街道', 331002003),
(331002004, 331002, '洪家街道', 331002004),
(331002005, 331002, '三甲街道', 331002005),
(331002006, 331002, '下陈街道', 331002006),
(331002007, 331002, '前所街道', 331002007),
(331002008, 331002, '章安街道', 331002008),
(331002101, 331002, '大陈镇', 331002101),
(331002400, 331002, '椒江农场', 331002400),
(331003001, 331003, '东城街道', 331003001),
(331003002, 331003, '南城街道', 331003002),
(331003003, 331003, '西城街道', 331003003),
(331003004, 331003, '北城街道', 331003004),
(331003005, 331003, '新前街道', 331003005),
(331003006, 331003, '澄江街道', 331003006),
(331003007, 331003, '江口街道', 331003007),
(331003008, 331003, '高桥街道', 331003008),
(331003101, 331003, '宁溪镇', 331003101),
(331003102, 331003, '北洋镇', 331003102),
(331003103, 331003, '头陀镇', 331003103),
(331003107, 331003, '院桥镇', 331003107),
(331003108, 331003, '沙埠镇', 331003108),
(331003200, 331003, '屿头乡', 331003200),
(331003201, 331003, '上郑乡', 331003201),
(331003202, 331003, '富山乡', 331003202),
(331003203, 331003, '茅畲乡', 331003203),
(331003204, 331003, '上垟乡', 331003204),
(331003205, 331003, '平田乡', 331003205),
(331004001, 331004, '路南街道', 331004001),
(331004002, 331004, '路桥街道', 331004002),
(331004003, 331004, '路北街道', 331004003),
(331004004, 331004, '螺洋街道', 331004004),
(331004005, 331004, '桐屿街道', 331004005),
(331004006, 331004, '峰江街道', 331004006),
(331004103, 331004, '新桥镇', 331004103),
(331004104, 331004, '横街镇', 331004104),
(331004106, 331004, '金清镇', 331004106),
(331004107, 331004, '蓬街镇', 331004107),
(331021100, 331021, '珠港镇', 331021100),
(331021101, 331021, '清港镇', 331021101),
(331021102, 331021, '楚门镇', 331021102),
(331021103, 331021, '干江镇', 331021103),
(331021105, 331021, '沙门镇', 331021105),
(331021106, 331021, '芦浦镇', 331021106),
(331021200, 331021, '龙溪乡', 331021200),
(331021201, 331021, '鸡山乡', 331021201),
(331021202, 331021, '海山乡', 331021202),
(331022100, 331022, '海游镇', 331022100),
(331022101, 331022, '沙柳镇', 331022101),
(331022102, 331022, '珠岙镇', 331022102),
(331022103, 331022, '亭旁镇', 331022103),
(331022104, 331022, '六敖镇', 331022104),
(331022105, 331022, '健跳镇', 331022105),
(331022106, 331022, '横渡镇', 331022106),
(331022107, 331022, '浬浦镇', 331022107),
(331022108, 331022, '花桥镇', 331022108),
(331022109, 331022, '小雄镇', 331022109),
(331022200, 331022, '高枧乡', 331022200),
(331022203, 331022, '沿赤乡', 331022203),
(331022204, 331022, '泗淋乡', 331022204),
(331022205, 331022, '蛇蟠乡', 331022205),
(331023001, 331023, '赤城街道', 331023001),
(331023002, 331023, '始丰街道', 331023002),
(331023003, 331023, '福溪街道', 331023003),
(331023101, 331023, '白鹤镇', 331023101),
(331023102, 331023, '石梁镇', 331023102),
(331023104, 331023, '街头镇', 331023104),
(331023105, 331023, '平桥镇', 331023105),
(331023106, 331023, '坦头镇', 331023106),
(331023107, 331023, '三合镇', 331023107),
(331023108, 331023, '洪畴镇', 331023108),
(331023200, 331023, '三州乡', 331023200),
(331023203, 331023, '龙溪乡', 331023203),
(331023204, 331023, '雷峰乡', 331023204),
(331023207, 331023, '南屏乡', 331023207),
(331023209, 331023, '泳溪乡', 331023209),
(331024001, 331024, '安洲街道', 331024001),
(331024002, 331024, '南峰街道', 331024002),
(331024003, 331024, '福应街道', 331024003),
(331024101, 331024, '横溪镇', 331024101),
(331024102, 331024, '埠头镇', 331024102),
(331024103, 331024, '白塔镇', 331024103),
(331024104, 331024, '田市镇', 331024104),
(331024105, 331024, '官路镇', 331024105),
(331024106, 331024, '下各镇', 331024106),
(331024107, 331024, '朱溪镇', 331024107),
(331024200, 331024, '安岭乡', 331024200),
(331024201, 331024, '溪港乡', 331024201),
(331024202, 331024, '湫山乡', 331024202),
(331024203, 331024, '淡竹乡', 331024203),
(331024204, 331024, '皤滩乡', 331024204),
(331024205, 331024, '上张乡', 331024205),
(331024206, 331024, '步路乡', 331024206),
(331024207, 331024, '广度乡', 331024207),
(331024209, 331024, '大战乡', 331024209),
(331024210, 331024, '双庙乡', 331024210),
(331081001, 331081, '太平街道', 331081001),
(331081002, 331081, '城东街道', 331081002),
(331081003, 331081, '城西街道', 331081003),
(331081004, 331081, '城北街道', 331081004),
(331081005, 331081, '横峰街道', 331081005),
(331081100, 331081, '泽国镇', 331081100),
(331081101, 331081, '大溪镇', 331081101),
(331081102, 331081, '松门镇', 331081102),
(331081103, 331081, '箬横镇', 331081103),
(331081104, 331081, '新河镇', 331081104),
(331081105, 331081, '石塘镇', 331081105),
(331081106, 331081, '滨海镇', 331081106),
(331081107, 331081, '温峤镇', 331081107),
(331081108, 331081, '城南镇', 331081108),
(331081109, 331081, '石桥头镇', 331081109),
(331081110, 331081, '坞根镇', 331081110),
(331082001, 331082, '古城街道', 331082001),
(331082002, 331082, '大洋街道', 331082002),
(331082003, 331082, '江南街道', 331082003),
(331082004, 331082, '大田街道', 331082004),
(331082005, 331082, '邵家渡街道', 331082005),
(331082100, 331082, '汛桥镇', 331082100),
(331082101, 331082, '东塍镇', 331082101),
(331082103, 331082, '汇溪镇', 331082103),
(331082104, 331082, '小芝镇', 331082104),
(331082105, 331082, '河头镇', 331082105),
(331082106, 331082, '白水洋镇', 331082106),
(331082107, 331082, '括苍镇', 331082107),
(331082108, 331082, '永丰镇', 331082108),
(331082109, 331082, '尤溪镇', 331082109),
(331082110, 331082, '涌泉镇', 331082110),
(331082111, 331082, '沿江镇', 331082111),
(331082112, 331082, '杜桥镇', 331082112),
(331082113, 331082, '上盘镇', 331082113),
(331082114, 331082, '桃渚镇', 331082114),
(331102001, 331102, '紫金街道', 331102001),
(331102002, 331102, '岩泉街道', 331102002),
(331102003, 331102, '万象街道', 331102003),
(331102004, 331102, '白云街道', 331102004),
(331102005, 331102, '水阁街道', 331102005),
(331102006, 331102, '富岭街道', 331102006),
(331102100, 331102, '碧湖镇', 331102100),
(331102101, 331102, '联城镇', 331102101),
(331102102, 331102, '大港头镇', 331102102),
(331102103, 331102, '老竹畲族镇', 331102103),
(331102104, 331102, '雅溪镇', 331102104),
(331102200, 331102, '太平乡', 331102200),
(331102201, 331102, '仙渡乡', 331102201),
(331102202, 331102, '峰源乡', 331102202),
(331102203, 331102, '高溪乡', 331102203),
(331102204, 331102, '丽新畲族乡', 331102204),
(331102205, 331102, '双黄乡', 331102205),
(331102206, 331102, '黄村乡', 331102206),
(331121100, 331121, '鹤城镇', 331121100),
(331121101, 331121, '温溪镇', 331121101),
(331121102, 331121, '东源镇', 331121102),
(331121103, 331121, '高湖镇', 331121103),
(331121104, 331121, '船寮镇', 331121104),
(331121105, 331121, '海口镇', 331121105),
(331121106, 331121, '腊口镇', 331121106),
(331121107, 331121, '北山镇', 331121107),
(331121108, 331121, '山口镇', 331121108),
(331121109, 331121, '仁庄镇', 331121109),
(331121200, 331121, '万山乡', 331121200),
(331121201, 331121, '黄垟乡', 331121201),
(331121202, 331121, '季宅乡', 331121202),
(331121203, 331121, '高市乡', 331121203),
(331121204, 331121, '海溪乡', 331121204),
(331121205, 331121, '章村乡', 331121205),
(331121206, 331121, '祯旺乡', 331121206),
(331121207, 331121, '祯埠乡', 331121207),
(331121208, 331121, '舒桥乡', 331121208),
(331121209, 331121, '巨浦乡', 331121209),
(331121210, 331121, '岭根乡', 331121210),
(331121211, 331121, '万阜乡', 331121211),
(331121212, 331121, '方山乡', 331121212),
(331121213, 331121, '汤垟乡', 331121213),
(331121214, 331121, '贵岙乡', 331121214),
(331121215, 331121, '小舟山乡', 331121215),
(331121216, 331121, '吴坑乡', 331121216),
(331121217, 331121, '仁宫乡', 331121217),
(331121218, 331121, '章旦乡', 331121218),
(331121219, 331121, '阜山乡', 331121219),
(331121220, 331121, '石溪乡', 331121220),
(331122100, 331122, '五云镇', 331122100),
(331122101, 331122, '壶镇镇', 331122101),
(331122102, 331122, '新建镇', 331122102),
(331122103, 331122, '舒洪镇', 331122103),
(331122104, 331122, '新碧镇', 331122104),
(331122105, 331122, '大洋镇', 331122105),
(331122106, 331122, '东渡镇', 331122106),
(331122107, 331122, '东方镇', 331122107),
(331122108, 331122, '大源镇', 331122108),
(331122200, 331122, '新川乡', 331122200),
(331122201, 331122, '双川乡', 331122201),
(331122202, 331122, '城北乡', 331122202),
(331122203, 331122, '七里乡', 331122203),
(331122204, 331122, '白竹乡', 331122204),
(331122205, 331122, '雁岭乡', 331122205),
(331122206, 331122, '前路乡', 331122206),
(331122207, 331122, '三溪乡', 331122207),
(331122208, 331122, '溶江乡', 331122208),
(331122209, 331122, '双溪口乡', 331122209),
(331122210, 331122, '胡源乡', 331122210),
(331122211, 331122, '方溪乡', 331122211),
(331122212, 331122, '石笕乡', 331122212),
(331122213, 331122, '南溪乡', 331122213),
(331122214, 331122, '木栗乡', 331122214),
(331123100, 331123, '妙高镇', 331123100),
(331123101, 331123, '云峰镇', 331123101),
(331123102, 331123, '新路湾镇', 331123102),
(331123103, 331123, '北界镇', 331123103),
(331123104, 331123, '金竹镇', 331123104),
(331123105, 331123, '大柘镇', 331123105),
(331123106, 331123, '石练镇', 331123106),
(331123107, 331123, '王村口镇', 331123107),
(331123108, 331123, '黄沙腰镇', 331123108),
(331123200, 331123, '三仁畲族乡', 331123200),
(331123201, 331123, '濂竹乡', 331123201),
(331123202, 331123, '应村乡', 331123202),
(331123203, 331123, '高坪乡', 331123203),
(331123204, 331123, '湖山乡', 331123204),
(331123205, 331123, '蔡源乡', 331123205),
(331123206, 331123, '焦滩乡', 331123206),
(331123207, 331123, '龙洋乡', 331123207),
(331123208, 331123, '柘岱口乡', 331123208),
(331123209, 331123, '西畈乡', 331123209),
(331123210, 331123, '垵口乡', 331123210),
(331124100, 331124, '西屏镇', 331124100),
(331124101, 331124, '古市镇', 331124101),
(331124102, 331124, '玉岩镇', 331124102),
(331124103, 331124, '象溪镇', 331124103),
(331124104, 331124, '大东坝镇', 331124104),
(331124200, 331124, '望松乡', 331124200),
(331124201, 331124, '叶村乡', 331124201),
(331124202, 331124, '斋坛乡', 331124202),
(331124203, 331124, '三都乡', 331124203),
(331124204, 331124, '竹源乡', 331124204),
(331124205, 331124, '四都乡', 331124205),
(331124206, 331124, '赤寿乡', 331124206),
(331124207, 331124, '新兴乡', 331124207),
(331124208, 331124, '樟溪乡', 331124208),
(331124209, 331124, '谢村乡', 331124209),
(331124210, 331124, '新处乡', 331124210),
(331124211, 331124, '枫坪乡', 331124211),
(331124212, 331124, '板桥畲族乡', 331124212),
(331124213, 331124, '裕溪乡', 331124213),
(331124214, 331124, '安民乡', 331124214),
(331125100, 331125, '云和镇', 331125100),
(331125101, 331125, '石塘镇', 331125101),
(331125102, 331125, '紧水滩镇', 331125102),
(331125103, 331125, '崇头镇', 331125103),
(331125201, 331125, '雾溪畲族乡', 331125201),
(331125202, 331125, '安溪畲族乡', 331125202),
(331125203, 331125, '云坛乡', 331125203),
(331125204, 331125, '朱村乡', 331125204),
(331125205, 331125, '大源乡', 331125205),
(331125206, 331125, '赤石乡', 331125206),
(331125207, 331125, '黄源乡', 331125207),
(331125208, 331125, '大湾乡', 331125208),
(331125209, 331125, '沙铺乡', 331125209),
(331125210, 331125, '云丰乡', 331125210),
(331126100, 331126, '松源镇', 331126100),
(331126101, 331126, '黄田镇', 331126101),
(331126102, 331126, '竹口镇', 331126102),
(331126103, 331126, '屏都镇', 331126103),
(331126104, 331126, '荷地镇', 331126104),
(331126105, 331126, '左溪镇', 331126105),
(331126106, 331126, '贤良镇', 331126106),
(331126200, 331126, '岭头乡', 331126200),
(331126201, 331126, '五大堡乡', 331126201),
(331126202, 331126, '淤上乡', 331126202),
(331126203, 331126, '安南乡', 331126203),
(331126204, 331126, '张村乡', 331126204),
(331126205, 331126, '隆宫乡', 331126205),
(331126206, 331126, '举水乡', 331126206),
(331126207, 331126, '江根乡', 331126207),
(331126208, 331126, '合湖乡', 331126208),
(331126209, 331126, '龙溪乡', 331126209),
(331126210, 331126, '百山祖乡', 331126210),
(331126211, 331126, '官塘乡', 331126211),
(331126212, 331126, '四山乡', 331126212),
(331127100, 331127, '鹤溪镇', 331127100),
(331127101, 331127, '渤海镇', 331127101),
(331127102, 331127, '东坑镇', 331127102),
(331127103, 331127, '英川镇', 331127103),
(331127104, 331127, '沙湾镇', 331127104),
(331127200, 331127, '外舍乡', 331127200),
(331127201, 331127, '大均乡', 331127201),
(331127202, 331127, '澄照乡', 331127202),
(331127203, 331127, '梅岐乡', 331127203),
(331127204, 331127, '金钟乡', 331127204),
(331127205, 331127, '郑坑乡', 331127205),
(331127206, 331127, '大顺乡', 331127206),
(331127207, 331127, '陈村乡', 331127207),
(331127208, 331127, '大际乡', 331127208),
(331127209, 331127, '景南乡', 331127209),
(331127210, 331127, '雁溪乡', 331127210),
(331127211, 331127, '葛山乡', 331127211),
(331127212, 331127, '鸬鹚乡', 331127212),
(331127213, 331127, '梧桐乡', 331127213),
(331127214, 331127, '标溪乡', 331127214),
(331127215, 331127, '毛洋乡', 331127215),
(331127216, 331127, '秋炉乡', 331127216),
(331127217, 331127, '大地乡', 331127217),
(331127218, 331127, '家地乡', 331127218),
(331181001, 331181, '龙渊街道', 331181001),
(331181002, 331181, '西街街道', 331181002),
(331181003, 331181, '剑池街道', 331181003),
(331181100, 331181, '八都镇', 331181100),
(331181101, 331181, '上垟镇', 331181101),
(331181102, 331181, '小梅镇', 331181102),
(331181103, 331181, '查田镇', 331181103),
(331181104, 331181, '安仁镇', 331181104),
(331181105, 331181, '锦溪镇', 331181105),
(331181106, 331181, '住龙镇', 331181106),
(331181107, 331181, '屏南镇', 331181107),
(331181200, 331181, '兰巨乡', 331181200),
(331181201, 331181, '跶石乡', 331181201),
(331181202, 331181, '宝溪乡', 331181202),
(331181203, 331181, '竹垟畲族乡', 331181203),
(331181204, 331181, '道太乡', 331181204),
(331181205, 331181, '岩樟乡', 331181205),
(331181206, 331181, '城北乡', 331181206),
(331181207, 331181, '龙南乡', 331181207),
(340102001, 340102, '明光路街道', 340102001),
(340102002, 340102, '车站街道', 340102002),
(340102003, 340102, '胜利路街道', 340102003),
(340102004, 340102, '三里街街道', 340102004),
(340102005, 340102, '铜陵路街道', 340102005),
(340102006, 340102, '七里站街道', 340102006),
(340102007, 340102, '红光街道', 340102007),
(340102008, 340102, '和平路街道', 340102008),
(340102009, 340102, '大通路街道', 340102009),
(340102010, 340102, '城东街道', 340102010),
(340102011, 340102, '长淮街道', 340102011),
(340102012, 340102, '方庙街道', 340102012),
(340102013, 340102, '七里塘街道', 340102013),
(340102100, 340102, '大兴镇', 340102100),
(340102200, 340102, '磨店乡', 340102200),
(340102400, 340102, '瑶海区工业园', 340102400),
(340103001, 340103, '杏林街道', 340103001),
(340103002, 340103, '海棠街道', 340103002),
(340103003, 340103, '逍遥津街道', 340103003),
(340103004, 340103, '三牌楼街道', 340103004),
(340103005, 340103, '县桥街道', 340103005),
(340103006, 340103, '益民街道', 340103006),
(340103007, 340103, '安庆路街道', 340103007),
(340103008, 340103, '光明街道', 340103008),
(340103009, 340103, '亳州路街道', 340103009),
(340103010, 340103, '双岗街道', 340103010),
(340103011, 340103, '杏花村街道', 340103011),
(340103100, 340103, '大杨镇', 340103100),
(340103200, 340103, '三十岗乡', 340103200),
(340103400, 340103, '庐阳工业园区', 340103400),
(340104001, 340104, '稻香村街道', 340104001),
(340104002, 340104, '南七里站街道', 340104002),
(340104003, 340104, '三里庵街道', 340104003),
(340104004, 340104, '琥珀山庄街道', 340104004),
(340104005, 340104, '西园新村街道', 340104005),
(340104006, 340104, '五里墩街道', 340104006),
(340104007, 340104, '荷叶地街道', 340104007),
(340104008, 340104, '笔架山街道', 340104008),
(340104100, 340104, '井岗镇', 340104100),
(340104101, 340104, '南岗镇', 340104101),
(340104400, 340104, '蜀山新产业园区', 340104400),
(340104401, 340104, '高新技术产业开发区', 340104401),
(340104402, 340104, '莲花社区管理委员会', 340104402),
(340104403, 340104, '芙蓉社区管理委员会', 340104403),
(340104404, 340104, '锦绣社区管理委员会', 340104404),
(340104405, 340104, '海恒社区管理委员会', 340104405),
(340111001, 340111, '常青街道', 340111001),
(340111002, 340111, '宁国路街道', 340111002),
(340111003, 340111, '芜湖路街道', 340111003),
(340111004, 340111, '巢湖路街道', 340111004),
(340111005, 340111, '骆岗街道', 340111005),
(340111100, 340111, '义兴镇', 340111100),
(340111101, 340111, '义城镇', 340111101),
(340111200, 340111, '大圩乡', 340111200),
(340111201, 340111, '烟墩乡', 340111201),
(340111400, 340111, '包河工业区管委会', 340111400),
(340121100, 340121, '水湖镇', 340121100),
(340121101, 340121, '庄墓镇', 340121101),
(340121102, 340121, '杨庙镇', 340121102),
(340121103, 340121, '吴山镇', 340121103),
(340121104, 340121, '岗集镇', 340121104),
(340121105, 340121, '双墩镇', 340121105),
(340121106, 340121, '下塘镇', 340121106),
(340121107, 340121, '朱巷镇', 340121107),
(340121200, 340121, '罗塘乡', 340121200),
(340121201, 340121, '义井乡', 340121201),
(340121202, 340121, '三十头乡', 340121202),
(340121203, 340121, '陶楼乡', 340121203),
(340121204, 340121, '造甲乡', 340121204),
(340121205, 340121, '左店乡', 340121205),
(340121206, 340121, '杜集乡', 340121206),
(340121400, 340121, '双凤工业区', 340121400),
(340122100, 340122, '店埠镇', 340122100),
(340122101, 340122, '撮镇镇', 340122101),
(340122102, 340122, '梁园镇', 340122102),
(340122103, 340122, '桥头集镇', 340122103),
(340122104, 340122, '长临河镇', 340122104),
(340122105, 340122, '石塘镇', 340122105),
(340122106, 340122, '古城镇', 340122106),
(340122107, 340122, '八斗镇', 340122107),
(340122108, 340122, '元疃镇', 340122108),
(340122109, 340122, '白龙镇', 340122109),
(340122110, 340122, '包公镇', 340122110),
(340122200, 340122, '众兴乡', 340122200),
(340122201, 340122, '张集乡', 340122201),
(340122202, 340122, '马湖乡', 340122202),
(340122203, 340122, '陈集乡', 340122203),
(340122204, 340122, '响导乡', 340122204),
(340122205, 340122, '杨店乡', 340122205),
(340122206, 340122, '牌坊回族满族乡', 340122206),
(340122400, 340122, '合肥龙岗综合经济开发区', 340122400),
(340123100, 340123, '上派镇', 340123100),
(340123101, 340123, '三河镇', 340123101),
(340123102, 340123, '高刘镇', 340123102),
(340123103, 340123, '官亭镇', 340123103),
(340123104, 340123, '小庙镇', 340123104),
(340123105, 340123, '山南镇', 340123105),
(340123106, 340123, '花岗镇', 340123106),
(340123107, 340123, '紫蓬镇', 340123107),
(340123108, 340123, '桃花镇', 340123108),
(340123109, 340123, '丰乐镇', 340123109),
(340123200, 340123, '高店乡', 340123200),
(340123201, 340123, '铭传乡', 340123201),
(340123202, 340123, '柿树岗乡', 340123202),
(340123203, 340123, '严店乡', 340123203),
(340123400, 340123, '桃花工业园管委会', 340123400),
(340123401, 340123, '紫蓬山管委会', 340123401),
(340202001, 340202, '北京路街道', 340202001),
(340202002, 340202, '赭麓街道', 340202002),
(340202003, 340202, '镜湖街道', 340202003),
(340202004, 340202, '吉和街街道', 340202004),
(340202005, 340202, '赭山街道', 340202005),
(340202006, 340202, '弋矶山街道', 340202006),
(340202007, 340202, '汀棠街道', 340202007),
(340202008, 340202, '天门山街道', 340202008),
(340202009, 340202, '北门街道', 340202009),
(340202010, 340202, '东门街道', 340202010),
(340202011, 340202, '荆山街道', 340202011),
(340202400, 340202, '长江大桥综合经济开发区（虚拟）', 340202400),
(340203001, 340203, '弋江桥街道', 340203001),
(340203002, 340203, '中山南路街道', 340203002),
(340203003, 340203, '利民路街道', 340203003),
(340203100, 340203, '马塘街道', 340203100),
(340203101, 340203, '鲁港街道', 340203101),
(340203102, 340203, '火龙岗镇', 340203102),
(340203198, 340203, '虚拟街道', 340203198),
(340207001, 340207, '四褐山街道', 340207001),
(340207002, 340207, '裕溪口街道', 340207002),
(340207003, 340207, '官陡街道', 340207003),
(340207004, 340207, '湾里街道', 340207004),
(340207005, 340207, '清水街道', 340207005),
(340207400, 340207, '经济技术开发区', 340207400),
(340207401, 340207, '鸠江开发区', 340207401),
(340208001, 340208, '三山街道', 340208001),
(340208002, 340208, '保定街道', 340208002),
(340208003, 340208, '龙湖街道', 340208003),
(340208100, 340208, '峨桥镇', 340208100),
(340221100, 340221, '湾沚镇', 340221100),
(340221101, 340221, '六郎镇', 340221101),
(340221102, 340221, '陶辛镇', 340221102),
(340221103, 340221, '方村镇', 340221103),
(340221104, 340221, '红杨镇', 340221104),
(340221105, 340221, '花桥镇', 340221105),
(340222100, 340222, '繁阳镇', 340222100),
(340222101, 340222, '荻港镇', 340222101),
(340222102, 340222, '孙村镇', 340222102),
(340222103, 340222, '平铺镇', 340222103),
(340222104, 340222, '新港', 340222104),
(340222200, 340222, '峨山乡', 340222200),
(340223100, 340223, '籍山镇', 340223100),
(340223101, 340223, '许镇镇', 340223101),
(340223102, 340223, '弋江镇', 340223102),
(340223103, 340223, '三里镇', 340223103),
(340223104, 340223, '何湾镇', 340223104),
(340223105, 340223, '工山镇', 340223105),
(340223106, 340223, '烟墩镇', 340223106),
(340223107, 340223, '家发镇', 340223107),
(340302001, 340302, '东风街道', 340302001),
(340302002, 340302, '延安街道', 340302002),
(340302003, 340302, '治淮街道', 340302003),
(340302004, 340302, '东升街道', 340302004),
(340302005, 340302, '解放街道', 340302005),
(340302006, 340302, '曹山街道', 340302006),
(340302100, 340302, '长淮卫镇', 340302100),
(340302200, 340302, '李楼乡', 340302200),
(340302400, 340302, '新城综合开发区(龙子湖区)', 340302400),
(340303001, 340303, '天桥街道', 340303001),
(340303002, 340303, '青年街道', 340303002),
(340303003, 340303, '纬二路街道', 340303003),
(340303004, 340303, '黄庄街道', 340303004),
(340303005, 340303, '宏业村街道', 340303005),
(340303200, 340303, '燕山乡', 340303200),
(340303201, 340303, '雪华乡', 340303201),
(340303400, 340303, '胜利街道', 340303400),
(340303401, 340303, '龙湖街道', 340303401),
(340303402, 340303, '湖滨社区行政事务管理中心', 340303402),
(340303403, 340303, '淮河社区行政事务管理中心', 340303403),
(340304001, 340304, '朝阳街道', 340304001),
(340304002, 340304, '纬四街道', 340304002),
(340304003, 340304, '大庆街道', 340304003),
(340304004, 340304, '张公山街道', 340304004),
(340304005, 340304, '钓鱼台街道', 340304005),
(340304100, 340304, '秦集镇', 340304100),
(340304200, 340304, '长青乡', 340304200),
(340304400, 340304, '高新技术开发区', 340304400),
(340311001, 340311, '淮滨街道', 340311001),
(340311100, 340311, '小蚌埠镇', 340311100),
(340311101, 340311, '吴小街镇', 340311101),
(340311102, 340311, '曹老集镇', 340311102),
(340311200, 340311, '梅桥乡', 340311200),
(340321100, 340321, '城关镇', 340321100),
(340321101, 340321, '鲍集镇', 340321101),
(340321102, 340321, '龙亢镇', 340321102),
(340321103, 340321, '河溜镇', 340321103),
(340321104, 340321, '常坟镇', 340321104),
(340321105, 340321, '马城镇', 340321105),
(340321106, 340321, '双桥集镇', 340321106),
(340321107, 340321, '魏庄镇', 340321107),
(340321108, 340321, '万福镇', 340321108),
(340321109, 340321, '唐集镇', 340321109),
(340321200, 340321, '淝南乡', 340321200),
(340321201, 340321, '淝河乡', 340321201),
(340321202, 340321, '褚集乡', 340321202),
(340321203, 340321, '陈集乡', 340321203),
(340321204, 340321, '古城乡', 340321204),
(340321205, 340321, '徐圩乡', 340321205),
(340321206, 340321, '兰桥乡', 340321206),
(340321207, 340321, '荆芡乡', 340321207),
(340321208, 340321, '找郢乡', 340321208),
(340321400, 340321, '龙亢农场', 340321400),
(340321401, 340321, '经济开发区', 340321401),
(340322100, 340322, '城关镇', 340322100),
(340322101, 340322, '新集镇', 340322101),
(340322102, 340322, '沫河口镇', 340322102),
(340322103, 340322, '小溪镇', 340322103),
(340322104, 340322, '双忠庙镇', 340322104),
(340322105, 340322, '小圩镇', 340322105),
(340322106, 340322, '东刘集镇', 340322106),
(340322107, 340322, '头铺镇', 340322107),
(340322108, 340322, '大新镇', 340322108),
(340322109, 340322, '武桥镇', 340322109),
(340322110, 340322, '朱顶镇', 340322110),
(340322111, 340322, '浍南镇', 340322111),
(340322112, 340322, '申集镇', 340322112),
(340322200, 340322, '沱湖乡', 340322200),
(340322201, 340322, '临北回族乡', 340322201),
(340323100, 340323, '城关镇', 340323100),
(340323101, 340323, '王庄镇', 340323101),
(340323102, 340323, '新马桥镇', 340323102),
(340323103, 340323, '连城镇', 340323103),
(340323104, 340323, '刘集镇', 340323104),
(340323105, 340323, '任桥镇', 340323105),
(340323106, 340323, '湖沟镇', 340323106),
(340323107, 340323, '濠城镇', 340323107),
(340323200, 340323, '石湖乡', 340323200),
(340323201, 340323, '杨庙乡', 340323201),
(340323202, 340323, '仲兴乡', 340323202),
(340323400, 340323, '固镇开发区', 340323400),
(340402001, 340402, '大通街道', 340402001),
(340402100, 340402, '上窑镇', 340402100),
(340402101, 340402, '洛河镇', 340402101),
(340402102, 340402, '九龙岗镇', 340402102),
(340402200, 340402, '孔店乡', 340402200),
(340403001, 340403, '田东街道', 340403001),
(340403002, 340403, '新淮街道', 340403002),
(340403003, 340403, '国庆街道', 340403003),
(340403004, 340403, '淮滨街道', 340403004),
(340403005, 340403, '朝阳街道', 340403005),
(340403006, 340403, '公园街道', 340403006),
(340403007, 340403, '洞山街道', 340403007),
(340403008, 340403, '龙泉街道', 340403008),
(340403009, 340403, '泉山街道', 340403009),
(340403100, 340403, '舜耕镇', 340403100),
(340403101, 340403, '安成镇', 340403101),
(340403102, 340403, '曹庵镇', 340403102),
(340403200, 340403, '三和乡', 340403200),
(340403201, 340403, '史院乡', 340403201),
(340404001, 340404, '谢家集街道', 340404001),
(340404002, 340404, '蔡家岗街道', 340404002),
(340404003, 340404, '立新街道', 340404003),
(340404004, 340404, '谢三村街道', 340404004),
(340404005, 340404, '平山街道', 340404005),
(340404100, 340404, '望峰岗镇', 340404100),
(340404101, 340404, '李郢孜镇', 340404101),
(340404102, 340404, '唐山镇', 340404102),
(340404103, 340404, '杨公镇', 340404103),
(340404200, 340404, '孙庙乡', 340404200),
(340404201, 340404, '孤堆乡', 340404201),
(340405001, 340405, '新庄孜街道', 340405001),
(340405002, 340405, '土坝孜街道', 340405002),
(340405003, 340405, '毕家岗街道', 340405003),
(340405100, 340405, '八公山镇', 340405100),
(340405101, 340405, '山王镇', 340405101),
(340405400, 340405, '妙山林场', 340405400),
(340406001, 340406, '田集街道', 340406001),
(340406100, 340406, '高皇镇', 340406100),
(340406101, 340406, '平圩镇', 340406101),
(340406102, 340406, '泥河镇', 340406102),
(340406103, 340406, '潘集镇', 340406103),
(340406104, 340406, '芦集镇', 340406104),
(340406200, 340406, '夹沟乡', 340406200),
(340406201, 340406, '祁集乡', 340406201),
(340406202, 340406, '古沟回族乡', 340406202),
(340406203, 340406, '架河乡', 340406203),
(340406204, 340406, '贺疃乡', 340406204),
(340421100, 340421, '城关镇', 340421100),
(340421101, 340421, '大山镇', 340421101),
(340421102, 340421, '新集镇', 340421102),
(340421103, 340421, '朱马店镇', 340421103),
(340421104, 340421, '岳张集镇', 340421104),
(340421105, 340421, '顾桥镇', 340421105),
(340421106, 340421, '毛集区毛集镇', 340421106),
(340421107, 340421, '毛集区夏集镇', 340421107),
(340421200, 340421, '城北乡', 340421200),
(340421201, 340421, '李冲回族乡', 340421201),
(340421202, 340421, '刘集乡', 340421202),
(340421203, 340421, '桂集乡', 340421203),
(340421204, 340421, '古店乡', 340421204),
(340421205, 340421, '钱庙乡', 340421205),
(340421206, 340421, '杨村乡', 340421206),
(340421207, 340421, '尚塘乡', 340421207),
(340421208, 340421, '丁集乡', 340421208),
(340421209, 340421, '关店乡', 340421209),
(340421210, 340421, '大兴集乡', 340421210),
(340421211, 340421, '毛集区焦岗乡', 340421211),
(340502001, 340502, '金家庄街道', 340502001),
(340502002, 340502, '江边街道', 340502002),
(340502003, 340502, '塘西街道', 340502003),
(340502004, 340502, '慈湖街道', 340502004),
(340502200, 340502, '慈湖乡', 340502200),
(340503001, 340503, '沙塘路街道', 340503001),
(340503002, 340503, '解放路街道', 340503002),
(340503003, 340503, '湖东路街道', 340503003),
(340503004, 340503, '桃源路街道', 340503004),
(340503100, 340503, '霍里镇', 340503100),
(340504001, 340504, '平湖街道', 340504001),
(340504002, 340504, '雨山街道', 340504002),
(340504003, 340504, '安民街道', 340504003),
(340504004, 340504, '采石街道', 340504004),
(340504100, 340504, '向山镇', 340504100),
(340504101, 340504, '银塘镇', 340504101),
(340504200, 340504, '佳山乡', 340504200),
(340521100, 340521, '姑孰镇', 340521100),
(340521101, 340521, '黄池镇', 340521101),
(340521102, 340521, '乌溪镇', 340521102),
(340521103, 340521, '石桥镇', 340521103),
(340521104, 340521, '塘南镇', 340521104),
(340521105, 340521, '护河镇', 340521105),
(340521106, 340521, '太白镇', 340521106),
(340521107, 340521, '丹阳镇', 340521107),
(340521108, 340521, '博望镇', 340521108),
(340521109, 340521, '新市镇', 340521109),
(340521200, 340521, '大陇乡', 340521200),
(340521201, 340521, '年陡乡', 340521201),
(340521202, 340521, '江心乡', 340521202),
(340521203, 340521, '湖阳乡', 340521203),
(340602001, 340602, '高岳街道', 340602001),
(340602002, 340602, '矿山集街道', 340602002),
(340602100, 340602, '朔里镇', 340602100),
(340602101, 340602, '石台镇', 340602101),
(340602102, 340602, '段圆镇', 340602102),
(340603001, 340603, '相南街道', 340603001),
(340603002, 340603, '东街道', 340603002),
(340603003, 340603, '西街道', 340603003),
(340603004, 340603, '三堤口街道', 340603004);
INSERT INTO `{pre}areas` VALUES
(340603005, 340603, '东山街道', 340603005),
(340603006, 340603, '人民路街道', 340603006),
(340603007, 340603, '刘桥街道', 340603007),
(340603008, 340603, '任圩街道', 340603008),
(340603009, 340603, '南黎街道办事处筹备组', 340603009),
(340603010, 340603, '曲阳街道办事处筹备组', 340603010),
(340603100, 340603, '渠沟镇', 340603100),
(340604001, 340604, '临海童街道', 340604001),
(340604002, 340604, '前岭街道', 340604002),
(340604003, 340604, '百善街道', 340604003),
(340604004, 340604, '任楼街道', 340604004),
(340604005, 340604, '杨庄街道', 340604005),
(340604100, 340604, '烈山镇', 340604100),
(340604101, 340604, '宋疃镇', 340604101),
(340604102, 340604, '古饶镇', 340604102),
(340621100, 340621, '濉溪镇', 340621100),
(340621101, 340621, '韩村镇', 340621101),
(340621102, 340621, '刘桥镇', 340621102),
(340621103, 340621, '五沟镇', 340621103),
(340621104, 340621, '临涣镇', 340621104),
(340621105, 340621, '双堆集镇', 340621105),
(340621106, 340621, '铁佛镇', 340621106),
(340621107, 340621, '南坪镇', 340621107),
(340621108, 340621, '百善镇', 340621108),
(340621109, 340621, '孙町镇', 340621109),
(340621200, 340621, '四铺乡', 340621200),
(340702001, 340702, '长江路街道', 340702001),
(340702002, 340702, '铜官山街道', 340702002),
(340702003, 340702, '杨家山街道', 340702003),
(340702004, 340702, '石城路街道', 340702004),
(340702005, 340702, '扫把沟街道', 340702005),
(340702006, 340702, '横港街道', 340702006),
(340702400, 340702, '普济圩农场', 340702400),
(340703001, 340703, '狮子山街道', 340703001),
(340703002, 340703, '新庙街道', 340703002),
(340703003, 340703, '矶山街道', 340703003),
(340703004, 340703, '凤凰山街道', 340703004),
(340703005, 340703, '东郊街道', 340703005),
(340703100, 340703, '西湖镇', 340703100),
(340703400, 340703, '铜陵经济技术开发区', 340703400),
(340711001, 340711, '桥南', 340711001),
(340711100, 340711, '铜山镇', 340711100),
(340711101, 340711, '安矿', 340711101),
(340711102, 340711, '大通镇', 340711102),
(340711200, 340711, '灰河乡', 340711200),
(340711400, 340711, '“两矿一公司”专管办', 340711400),
(340721100, 340721, '五松镇', 340721100),
(340721101, 340721, '顺安镇', 340721101),
(340721102, 340721, '钟鸣镇', 340721102),
(340721103, 340721, '天门镇', 340721103),
(340721200, 340721, '老洲乡', 340721200),
(340721201, 340721, '东联乡', 340721201),
(340721202, 340721, '西联乡', 340721202),
(340721203, 340721, '胥坝乡', 340721203),
(340802001, 340802, '宜城路街道', 340802001),
(340802002, 340802, '新河路街道', 340802002),
(340802003, 340802, '华中路街道', 340802003),
(340802004, 340802, '人民路街道', 340802004),
(340802005, 340802, '孝肃路街道', 340802005),
(340802006, 340802, '建设路街道', 340802006),
(340802100, 340802, '老峰镇', 340802100),
(340802200, 340802, '龙狮桥乡', 340802200),
(340802201, 340802, '长风乡', 340802201),
(340802202, 340802, '新洲乡', 340802202),
(340803001, 340803, '德宽路街道', 340803001),
(340803002, 340803, '玉琳路街道', 340803002),
(340803003, 340803, '龙山路街道', 340803003),
(340803004, 340803, '菱湖街道', 340803004),
(340803005, 340803, '集贤路街道', 340803005),
(340803006, 340803, '石化路街道', 340803006),
(340803007, 340803, '花亭路街道', 340803007),
(340803100, 340803, '海口镇', 340803100),
(340803200, 340803, '十里乡', 340803200),
(340803201, 340803, '山口乡', 340803201),
(340803400, 340803, '皖河农场', 340803400),
(340811001, 340811, '大桥街道', 340811001),
(340811002, 340811, '菱北街道', 340811002),
(340811100, 340811, '大龙山镇', 340811100),
(340811101, 340811, '杨桥镇', 340811101),
(340811102, 340811, '罗岭镇', 340811102),
(340811200, 340811, '白泽湖乡', 340811200),
(340811201, 340811, '五横乡', 340811201),
(340822100, 340822, '高河镇', 340822100),
(340822101, 340822, '石牌镇', 340822101),
(340822102, 340822, '月山镇', 340822102),
(340822103, 340822, '马庙镇', 340822103),
(340822104, 340822, '金拱镇', 340822104),
(340822105, 340822, '茶岭镇', 340822105),
(340822106, 340822, '公岭镇', 340822106),
(340822107, 340822, '黄墩镇', 340822107),
(340822108, 340822, '三桥镇', 340822108),
(340822109, 340822, '小市镇', 340822109),
(340822110, 340822, '黄龙镇', 340822110),
(340822111, 340822, '平山镇', 340822111),
(340822112, 340822, '腊树镇', 340822112),
(340822113, 340822, '洪铺镇', 340822113),
(340822114, 340822, '江镇镇', 340822114),
(340822200, 340822, '凉亭乡', 340822200),
(340822201, 340822, '石镜乡', 340822201),
(340822202, 340822, '秀山乡', 340822202),
(340822203, 340822, '清河乡', 340822203),
(340822204, 340822, '雷埠乡', 340822204),
(340823100, 340823, '枞阳镇', 340823100),
(340823101, 340823, 'Ou山镇', 340823101),
(340823102, 340823, '汤沟镇', 340823102),
(340823103, 340823, '老洲镇', 340823103),
(340823104, 340823, '陈瑶湖镇', 340823104),
(340823105, 340823, '周潭镇', 340823105),
(340823106, 340823, '横埠镇', 340823106),
(340823107, 340823, '项铺镇', 340823107),
(340823108, 340823, '钱桥镇', 340823108),
(340823109, 340823, '麒麟镇', 340823109),
(340823110, 340823, '义津镇', 340823110),
(340823111, 340823, '浮山镇', 340823111),
(340823112, 340823, '官埠桥镇', 340823112),
(340823200, 340823, '铁铜乡', 340823200),
(340823201, 340823, '凤仪乡', 340823201),
(340823202, 340823, '长沙乡', 340823202),
(340823203, 340823, '钱铺乡', 340823203),
(340823204, 340823, '金社乡', 340823204),
(340823205, 340823, '白梅乡', 340823205),
(340823206, 340823, '白湖乡', 340823206),
(340823207, 340823, '会宫乡', 340823207),
(340823208, 340823, '雨坛乡', 340823208),
(340824100, 340824, '梅城镇', 340824100),
(340824101, 340824, '源潭镇', 340824101),
(340824102, 340824, '余井镇', 340824102),
(340824103, 340824, '王河镇', 340824103),
(340824104, 340824, '黄铺镇', 340824104),
(340824105, 340824, '槎水镇', 340824105),
(340824106, 340824, '水吼镇', 340824106),
(340824107, 340824, '官庄镇', 340824107),
(340824108, 340824, '黄泥镇', 340824108),
(340824109, 340824, '黄柏镇', 340824109),
(340824110, 340824, '天柱山镇', 340824110),
(340824200, 340824, '塔畈乡', 340824200),
(340824201, 340824, '油坝乡', 340824201),
(340824202, 340824, '龙潭乡', 340824202),
(340824203, 340824, '痘姆乡', 340824203),
(340824204, 340824, '五庙乡', 340824204),
(340824400, 340824, '开发区', 340824400),
(340825100, 340825, '晋熙镇', 340825100),
(340825101, 340825, '徐桥镇', 340825101),
(340825102, 340825, '新仓镇', 340825102),
(340825103, 340825, '小池镇', 340825103),
(340825104, 340825, '寺前镇', 340825104),
(340825105, 340825, '天华镇', 340825105),
(340825106, 340825, '牛镇镇', 340825106),
(340825107, 340825, '弥陀镇', 340825107),
(340825108, 340825, '北中镇', 340825108),
(340825109, 340825, '百里镇', 340825109),
(340825200, 340825, '大石乡', 340825200),
(340825201, 340825, '城西乡', 340825201),
(340825202, 340825, '江塘乡', 340825202),
(340825203, 340825, '汤泉乡', 340825203),
(340825204, 340825, '刘畈乡', 340825204),
(340826100, 340826, '孚玉镇', 340826100),
(340826101, 340826, '复兴镇', 340826101),
(340826102, 340826, '汇口镇', 340826102),
(340826103, 340826, '许岭镇', 340826103),
(340826104, 340826, '下仓镇', 340826104),
(340826105, 340826, '二郎镇', 340826105),
(340826106, 340826, '破凉镇', 340826106),
(340826107, 340826, '凉亭镇', 340826107),
(340826108, 340826, '长铺镇', 340826108),
(340826200, 340826, '高岭乡', 340826200),
(340826201, 340826, '程岭乡', 340826201),
(340826202, 340826, '九姑乡', 340826202),
(340826203, 340826, '千岭乡', 340826203),
(340826204, 340826, '洲头乡', 340826204),
(340826205, 340826, '佐坝乡', 340826205),
(340826206, 340826, '北浴乡', 340826206),
(340826207, 340826, '陈汉乡', 340826207),
(340826208, 340826, '隘口乡', 340826208),
(340826209, 340826, '柳坪乡', 340826209),
(340826210, 340826, '趾凤乡', 340826210),
(340826211, 340826, '河塌乡', 340826211),
(340826212, 340826, '五里乡', 340826212),
(340826400, 340826, '九成监狱管理分局', 340826400),
(340826401, 340826, '华阳河农场总场', 340826401),
(340827100, 340827, '华阳镇', 340827100),
(340827101, 340827, '杨湾镇', 340827101),
(340827102, 340827, '漳湖镇', 340827102),
(340827103, 340827, '赛口镇', 340827103),
(340827104, 340827, '高士镇', 340827104),
(340827105, 340827, '鸦滩镇', 340827105),
(340827106, 340827, '长岭镇', 340827106),
(340827107, 340827, '太慈镇', 340827107),
(340827200, 340827, '凉泉乡', 340827200),
(340827201, 340827, '雷池乡', 340827201),
(340828100, 340828, '天堂镇', 340828100),
(340828101, 340828, '店前镇', 340828101),
(340828102, 340828, '来榜镇', 340828102),
(340828103, 340828, '菖蒲镇', 340828103),
(340828104, 340828, '头陀镇', 340828104),
(340828105, 340828, '白帽镇', 340828105),
(340828106, 340828, '温泉镇', 340828106),
(340828107, 340828, '响肠镇', 340828107),
(340828108, 340828, '河图镇', 340828108),
(340828109, 340828, '五河镇', 340828109),
(340828110, 340828, '主簿镇', 340828110),
(340828111, 340828, '冶溪镇', 340828111),
(340828112, 340828, '黄尾镇', 340828112),
(340828200, 340828, '毛尖山乡', 340828200),
(340828201, 340828, '莲云乡', 340828201),
(340828202, 340828, '青天乡', 340828202),
(340828203, 340828, '包家乡', 340828203),
(340828204, 340828, '古坊乡', 340828204),
(340828205, 340828, '田头乡', 340828205),
(340828206, 340828, '中关乡', 340828206),
(340828207, 340828, '石关乡', 340828207),
(340828208, 340828, '姚河乡', 340828208),
(340828209, 340828, '和平乡', 340828209),
(340828210, 340828, '巍岭乡', 340828210),
(340881001, 340881, '碧峰街道', 340881001),
(340881002, 340881, '南演街道', 340881002),
(340881003, 340881, '文昌街道', 340881003),
(340881004, 340881, '太平街道', 340881004),
(340881100, 340881, '高桥镇', 340881100),
(340881101, 340881, '吕亭镇', 340881101),
(340881102, 340881, '范岗镇', 340881102),
(340881103, 340881, '孔城镇', 340881103),
(340881104, 340881, '新渡镇', 340881104),
(340881105, 340881, '双港镇', 340881105),
(340881106, 340881, '卅铺镇', 340881106),
(340881107, 340881, '大关镇', 340881107),
(340881108, 340881, '陶冲镇', 340881108),
(340881109, 340881, '金神镇', 340881109),
(340881110, 340881, '兴店镇', 340881110),
(340881111, 340881, '香铺镇', 340881111),
(340881112, 340881, '青草镇', 340881112),
(340881113, 340881, '挂车河镇', 340881113),
(340881114, 340881, '嬉子湖镇', 340881114),
(340881115, 340881, '老梅镇', 340881115),
(340881116, 340881, '唐湾镇', 340881116),
(340881117, 340881, '鲟鱼镇', 340881117),
(340881200, 340881, '黄铺乡', 340881200),
(340881201, 340881, '大塘乡', 340881201),
(340881202, 340881, '龙眠乡', 340881202),
(340881203, 340881, '中义乡', 340881203),
(340881400, 340881, '民营经济开发区', 340881400),
(341002001, 341002, '昱东街道', 341002001),
(341002002, 341002, '昱中街道', 341002002),
(341002003, 341002, '昱西街道', 341002003),
(341002004, 341002, '老街街道', 341002004),
(341002100, 341002, '屯光镇', 341002100),
(341002101, 341002, '阳湖镇', 341002101),
(341002102, 341002, '黎阳镇', 341002102),
(341002103, 341002, '新潭镇', 341002103),
(341002104, 341002, '奕棋镇', 341002104),
(341002500, 341002, '茶林场', 341002500),
(341003001, 341003, '新城街道', 341003001),
(341003100, 341003, '甘棠镇', 341003100),
(341003101, 341003, '仙源镇', 341003101),
(341003102, 341003, '汤口镇', 341003102),
(341003103, 341003, '谭家桥镇', 341003103),
(341003104, 341003, '太平湖镇', 341003104),
(341003105, 341003, '焦村镇', 341003105),
(341003106, 341003, '耿城镇', 341003106),
(341003107, 341003, '三口镇', 341003107),
(341003200, 341003, '新明乡', 341003200),
(341003201, 341003, '龙门乡', 341003201),
(341003202, 341003, '乌石乡', 341003202),
(341003203, 341003, '新华乡', 341003203),
(341003204, 341003, '新丰乡', 341003204),
(341003205, 341003, '永丰乡', 341003205),
(341003450, 341003, '黄山风景区', 341003450),
(341004001, 341004, '徽州区街道工委会', 341004001),
(341004100, 341004, '岩寺镇', 341004100),
(341004101, 341004, '西溪南镇', 341004101),
(341004102, 341004, '潜口镇', 341004102),
(341004103, 341004, '呈坎镇', 341004103),
(341004200, 341004, '洽舍乡', 341004200),
(341004201, 341004, '杨村乡', 341004201),
(341004202, 341004, '富溪乡', 341004202),
(341021100, 341021, '徽城镇', 341021100),
(341021101, 341021, '深渡镇', 341021101),
(341021102, 341021, '北岸镇', 341021102),
(341021103, 341021, '富堨镇', 341021103),
(341021104, 341021, '郑村镇', 341021104),
(341021105, 341021, '桂林镇', 341021105),
(341021106, 341021, '许村镇', 341021106),
(341021107, 341021, '溪头镇', 341021107),
(341021108, 341021, '杞梓里镇', 341021108),
(341021109, 341021, '霞坑镇', 341021109),
(341021110, 341021, '岔口镇', 341021110),
(341021111, 341021, '街口镇', 341021111),
(341021112, 341021, '王村镇', 341021112),
(341021200, 341021, '坑口乡', 341021200),
(341021201, 341021, '雄村乡', 341021201),
(341021202, 341021, '上丰乡', 341021202),
(341021203, 341021, '昌溪乡', 341021203),
(341021204, 341021, '武阳乡', 341021204),
(341021205, 341021, '三阳乡', 341021205),
(341021206, 341021, '金川乡', 341021206),
(341021207, 341021, '小川乡', 341021207),
(341021208, 341021, '新溪口乡', 341021208),
(341021209, 341021, '璜田乡', 341021209),
(341021210, 341021, '长陔乡', 341021210),
(341021211, 341021, '森村乡', 341021211),
(341021212, 341021, '绍濂乡', 341021212),
(341021213, 341021, '石门乡', 341021213),
(341021214, 341021, '狮石乡', 341021214),
(341022100, 341022, '海阳镇', 341022100),
(341022101, 341022, '齐云山镇', 341022101),
(341022102, 341022, '万安镇', 341022102),
(341022103, 341022, '五城镇', 341022103),
(341022104, 341022, '东临溪镇', 341022104),
(341022105, 341022, '兰田镇', 341022105),
(341022106, 341022, '溪口镇', 341022106),
(341022107, 341022, '流口镇', 341022107),
(341022108, 341022, '汪村镇', 341022108),
(341022200, 341022, '商山乡', 341022200),
(341022201, 341022, '山斗乡', 341022201),
(341022202, 341022, '岭南乡', 341022202),
(341022203, 341022, '渭桥乡', 341022203),
(341022204, 341022, '板桥乡', 341022204),
(341022205, 341022, '陈霞乡', 341022205),
(341022206, 341022, '鹤城乡', 341022206),
(341022207, 341022, '源芳乡', 341022207),
(341022208, 341022, '榆村乡', 341022208),
(341022209, 341022, '龙田乡', 341022209),
(341022210, 341022, '璜尖乡', 341022210),
(341022211, 341022, '白际乡', 341022211),
(341023100, 341023, '碧阳镇', 341023100),
(341023101, 341023, '宏村镇', 341023101),
(341023102, 341023, '渔亭镇', 341023102),
(341023103, 341023, '西递镇', 341023103),
(341023200, 341023, '柯村乡', 341023200),
(341023201, 341023, '美溪乡', 341023201),
(341023202, 341023, '宏潭乡', 341023202),
(341023203, 341023, '洪星乡', 341023203),
(341024100, 341024, '祁山镇', 341024100),
(341024101, 341024, '小路口镇', 341024101),
(341024102, 341024, '金字牌镇', 341024102),
(341024103, 341024, '平里镇', 341024103),
(341024104, 341024, '历口镇', 341024104),
(341024105, 341024, '闪里镇', 341024105),
(341024106, 341024, '安凌镇', 341024106),
(341024200, 341024, '大坦乡', 341024200),
(341024201, 341024, '凫峰乡', 341024201),
(341024202, 341024, '柏溪乡', 341024202),
(341024203, 341024, '塔坊乡', 341024203),
(341024204, 341024, '祁红乡', 341024204),
(341024205, 341024, '溶口乡', 341024205),
(341024206, 341024, '芦溪乡', 341024206),
(341024207, 341024, '渚口乡', 341024207),
(341024208, 341024, '古溪乡', 341024208),
(341024209, 341024, '新安乡', 341024209),
(341024210, 341024, '箬坑乡', 341024210),
(341102001, 341102, '琅琊街道', 341102001),
(341102002, 341102, '东门街道', 341102002),
(341102003, 341102, '西门街道', 341102003),
(341102004, 341102, '南门街道', 341102004),
(341102005, 341102, '北门街道', 341102005),
(341102006, 341102, '清流街道', 341102006),
(341102007, 341102, '扬子街道', 341102007),
(341102008, 341102, '凤凰街道办事处（滁州市开发区）', 341102008),
(341103001, 341103, '南谯街道', 341103001),
(341103100, 341103, '乌衣镇', 341103100),
(341103101, 341103, '沙河镇', 341103101),
(341103102, 341103, '章广镇', 341103102),
(341103103, 341103, '黄泥岗镇', 341103103),
(341103104, 341103, '珠龙镇', 341103104),
(341103105, 341103, '大柳镇', 341103105),
(341103106, 341103, '腰铺镇', 341103106),
(341103107, 341103, '大王镇', 341103107),
(341103200, 341103, '黄圩乡', 341103200),
(341103201, 341103, '汪郢乡', 341103201),
(341103202, 341103, '花山乡', 341103202),
(341103203, 341103, '城郊乡', 341103203),
(341103204, 341103, '施集乡', 341103204),
(341103205, 341103, '三官集乡', 341103205),
(341103206, 341103, '常山乡', 341103206),
(341103207, 341103, '皇甫乡', 341103207),
(341122100, 341122, '新安镇', 341122100),
(341122101, 341122, '半塔镇', 341122101),
(341122102, 341122, '水口镇', 341122102),
(341122103, 341122, '相官镇', 341122103),
(341122104, 341122, '汊河镇', 341122104),
(341122105, 341122, '大英镇', 341122105),
(341122106, 341122, '雷官镇', 341122106),
(341122107, 341122, '施官镇', 341122107),
(341122200, 341122, '三城乡', 341122200),
(341122201, 341122, '武集乡', 341122201),
(341122202, 341122, '独山乡', 341122202),
(341122203, 341122, '双塘乡', 341122203),
(341122204, 341122, '龙山乡', 341122204),
(341122205, 341122, '邵集乡', 341122205),
(341122206, 341122, '兴隆乡', 341122206),
(341122207, 341122, '杨郢乡', 341122207),
(341122208, 341122, '张山乡', 341122208),
(341122209, 341122, '舜山乡', 341122209),
(341124100, 341124, '襄河镇', 341124100),
(341124101, 341124, '古河镇', 341124101),
(341124102, 341124, '大墅镇', 341124102),
(341124103, 341124, '二郎口镇', 341124103),
(341124104, 341124, '武岗镇', 341124104),
(341124105, 341124, '马厂镇', 341124105),
(341124106, 341124, '石沛镇', 341124106),
(341124107, 341124, '章辉镇', 341124107),
(341124108, 341124, '西王镇', 341124108),
(341124109, 341124, '六镇镇', 341124109),
(341124200, 341124, '程家市乡', 341124200),
(341124201, 341124, '草庵乡', 341124201),
(341124202, 341124, '管坝乡', 341124202),
(341124203, 341124, '周岗乡', 341124203),
(341124204, 341124, '复兴乡', 341124204),
(341124205, 341124, '十字乡', 341124205),
(341124206, 341124, '陈浅乡', 341124206),
(341125100, 341125, '定城镇', 341125100),
(341125101, 341125, '炉桥镇', 341125101),
(341125102, 341125, '永康镇', 341125102),
(341125103, 341125, '吴圩镇', 341125103),
(341125104, 341125, '朱湾镇', 341125104),
(341125105, 341125, '张桥镇', 341125105),
(341125106, 341125, '藕塘镇', 341125106),
(341125107, 341125, '池河镇', 341125107),
(341125108, 341125, '连江镇', 341125108),
(341125109, 341125, '界牌集镇', 341125109),
(341125110, 341125, '仓镇', 341125110),
(341125111, 341125, '三和集镇', 341125111),
(341125112, 341125, '西卅店镇', 341125112),
(341125113, 341125, '岱山镇', 341125113),
(341125114, 341125, '桑涧镇', 341125114),
(341125115, 341125, '年家岗镇', 341125115),
(341125200, 341125, '程桥乡', 341125200),
(341125201, 341125, '东兴乡', 341125201),
(341125202, 341125, '斋朗乡', 341125202),
(341125203, 341125, '严桥乡', 341125203),
(341125204, 341125, '拂晓乡', 341125204),
(341125205, 341125, '天河乡', 341125205),
(341125206, 341125, '练铺乡', 341125206),
(341125207, 341125, '站岗乡', 341125207),
(341125208, 341125, '蒋集乡', 341125208),
(341125209, 341125, '九梓乡', 341125209),
(341125210, 341125, '能仁乡', 341125210),
(341125211, 341125, '靠山乡', 341125211),
(341125212, 341125, '青山乡', 341125212),
(341125213, 341125, '青洛乡', 341125213),
(341125214, 341125, '七里塘乡', 341125214),
(341125215, 341125, '二龙回族乡', 341125215),
(341125216, 341125, '仁和乡', 341125216),
(341125217, 341125, '朱马乡', 341125217),
(341125218, 341125, '大桥乡', 341125218),
(341125219, 341125, '范岗乡', 341125219),
(341125220, 341125, '高塘乡', 341125220),
(341126100, 341126, '府城镇', 341126100),
(341126101, 341126, '临淮镇', 341126101),
(341126102, 341126, '门台子镇', 341126102),
(341126103, 341126, '武店镇', 341126103),
(341126104, 341126, '西泉镇', 341126104),
(341126105, 341126, '刘府镇', 341126105),
(341126106, 341126, '大庙镇', 341126106),
(341126107, 341126, '殷涧镇', 341126107),
(341126108, 341126, '黄泥铺镇', 341126108),
(341126109, 341126, '总铺镇', 341126109),
(341126110, 341126, '红心镇', 341126110),
(341126111, 341126, '板桥镇', 341126111),
(341126112, 341126, '大溪河镇', 341126112),
(341126113, 341126, '石门山镇', 341126113),
(341126114, 341126, '小溪河镇', 341126114),
(341126200, 341126, '曹店乡', 341126200),
(341126201, 341126, '亮岗乡', 341126201),
(341126202, 341126, '周圩乡', 341126202),
(341126203, 341126, '城西乡', 341126203),
(341126204, 341126, '官塘乡', 341126204),
(341126205, 341126, '官沟乡', 341126205),
(341126206, 341126, '二铺乡', 341126206),
(341126207, 341126, '黄湾乡', 341126207),
(341126208, 341126, '枣巷渔业乡', 341126208),
(341126209, 341126, '燃灯乡', 341126209),
(341126210, 341126, '梅市乡', 341126210),
(341181001, 341181, '天长街道', 341181001),
(341181002, 341181, '城南街道', 341181002),
(341181003, 341181, '永丰街道', 341181003),
(341181004, 341181, '桥湾街道', 341181004),
(341181100, 341181, '铜城镇', 341181100),
(341181101, 341181, '汊涧镇', 341181101),
(341181102, 341181, '秦栏镇', 341181102),
(341181103, 341181, '大通镇', 341181103),
(341181104, 341181, '杨村镇', 341181104),
(341181105, 341181, '石梁镇', 341181105),
(341181106, 341181, '金集镇', 341181106),
(341181107, 341181, '安乐镇', 341181107),
(341181108, 341181, '仁和集镇', 341181108),
(341181109, 341181, '冶山镇', 341181109),
(341181110, 341181, '郑集镇', 341181110),
(341181111, 341181, '张铺镇', 341181111),
(341181112, 341181, '界牌镇', 341181112),
(341181113, 341181, '平安镇', 341181113),
(341181114, 341181, '釜山镇', 341181114),
(341181115, 341181, '高庙集镇', 341181115),
(341181200, 341181, '新街乡', 341181200),
(341181201, 341181, '龙集乡', 341181201),
(341181202, 341181, '谕兴乡', 341181202),
(341181203, 341181, '十八集乡', 341181203),
(341181204, 341181, '芦龙乡', 341181204),
(341181205, 341181, '万寿乡', 341181205),
(341181206, 341181, '便益乡', 341181206),
(341181207, 341181, '关塘集乡', 341181207),
(341181400, 341181, '城东新区', 341181400),
(341182001, 341182, '城西街道', 341182001),
(341182100, 341182, '招信镇', 341182100),
(341182101, 341182, '张八岭镇', 341182101),
(341182102, 341182, '三界镇', 341182102),
(341182103, 341182, '管店镇', 341182103),
(341182104, 341182, '自来桥镇', 341182104),
(341182105, 341182, '涧溪镇', 341182105),
(341182106, 341182, '石坝镇', 341182106),
(341182107, 341182, '津里镇', 341182107),
(341182108, 341182, '苏巷镇', 341182108),
(341182109, 341182, '桥头镇', 341182109),
(341182110, 341182, '女山湖镇', 341182110),
(341182111, 341182, '古沛镇', 341182111),
(341182112, 341182, '潘村镇', 341182112),
(341182200, 341182, '嘉山集乡', 341182200),
(341182201, 341182, '涝口乡', 341182201),
(341182202, 341182, '鲁山乡', 341182202),
(341182203, 341182, '横山乡', 341182203),
(341182204, 341182, '三关乡', 341182204),
(341182205, 341182, '马岗乡', 341182205),
(341182206, 341182, '明东乡', 341182206),
(341182207, 341182, '司巷乡', 341182207),
(341182208, 341182, '邵岗乡', 341182208),
(341182209, 341182, '紫阳乡', 341182209),
(341182210, 341182, '太平乡', 341182210),
(341182211, 341182, '柳巷乡', 341182211),
(341182212, 341182, '泊岗乡', 341182212),
(341202001, 341202, '鼓楼街道', 341202001),
(341202002, 341202, '文峰街道', 341202002),
(341202003, 341202, '清河街道', 341202003),
(341202004, 341202, '颍西街道', 341202004),
(341202005, 341202, '西湖景区街道', 341202005),
(341202006, 341202, '阜阳开发区京九', 341202006),
(341202100, 341202, '王店镇', 341202100),
(341202101, 341202, '程集镇', 341202101),
(341202102, 341202, '三合镇', 341202102),
(341202103, 341202, '西湖镇', 341202103),
(341202104, 341202, '九龙镇', 341202104),
(341202105, 341202, '三十里铺镇', 341202105),
(341202106, 341202, '袁集镇', 341202106),
(341202200, 341202, '马寨乡', 341202200),
(341203001, 341203, '河东街道', 341203001),
(341203002, 341203, '新华街道', 341203002),
(341203003, 341203, '向阳街道', 341203003),
(341203100, 341203, '口孜镇', 341203100),
(341203101, 341203, '插花镇', 341203101),
(341203102, 341203, '袁寨镇', 341203102),
(341203103, 341203, '枣庄镇', 341203103),
(341203104, 341203, '老庙镇', 341203104),
(341203105, 341203, '正午镇', 341203105),
(341203106, 341203, '杨楼孜镇', 341203106),
(341203107, 341203, '新乌江镇', 341203107),
(341203200, 341203, '冉庙乡', 341203200),
(341204001, 341204, '中市街道', 341204001),
(341204002, 341204, '周棚街道', 341204002),
(341204100, 341204, '伍明镇', 341204100),
(341204101, 341204, '宁老庄镇', 341204101),
(341204102, 341204, '闻集镇', 341204102),
(341204103, 341204, '行流镇', 341204103),
(341221100, 341221, '城关镇', 341221100),
(341221101, 341221, '杨桥镇', 341221101),
(341221102, 341221, '同城镇', 341221102),
(341221103, 341221, '谭棚镇', 341221103),
(341221104, 341221, '老集镇', 341221104),
(341221105, 341221, '滑集镇', 341221105),
(341221106, 341221, '吕寨镇', 341221106),
(341221107, 341221, '单桥镇', 341221107),
(341221108, 341221, '长官镇', 341221108),
(341221109, 341221, '宋集镇', 341221109),
(341221110, 341221, '张新镇', 341221110),
(341221111, 341221, '艾亭镇', 341221111),
(341221112, 341221, '陈集镇', 341221112),
(341221113, 341221, '韦寨镇', 341221113),
(341221114, 341221, '迎仙镇', 341221114),
(341221115, 341221, '瓦店镇', 341221115),
(341221116, 341221, '姜寨镇', 341221116),
(341221117, 341221, '庙岔镇', 341221117),
(341221118, 341221, '黄岭镇', 341221118),
(341221119, 341221, '白庙镇', 341221119),
(341221120, 341221, '关庙镇', 341221120),
(341221121, 341221, '临泉工业园区', 341221121),
(341221200, 341221, '牛庄乡', 341221200),
(341221201, 341221, '高塘乡', 341221201),
(341221202, 341221, '范兴集乡', 341221202),
(341221203, 341221, '土陂乡', 341221203),
(341221204, 341221, '谢集乡', 341221204),
(341221205, 341221, '杨小街乡', 341221205),
(341221206, 341221, '陶老乡', 341221206),
(341221207, 341221, '田桥乡', 341221207),
(341221208, 341221, '张营乡', 341221208),
(341221209, 341221, '庞营乡', 341221209),
(341222100, 341222, '城关镇', 341222100),
(341222101, 341222, '旧县镇', 341222101),
(341222102, 341222, '税镇镇', 341222102),
(341222103, 341222, '皮条孙镇', 341222103),
(341222104, 341222, '原墙镇', 341222104),
(341222105, 341222, '倪邱镇', 341222105),
(341222106, 341222, '李兴镇', 341222106),
(341222107, 341222, '大新镇', 341222107),
(341222108, 341222, '肖口镇', 341222108),
(341222109, 341222, '关集镇', 341222109),
(341222110, 341222, '三塔镇', 341222110),
(341222111, 341222, '双浮镇', 341222111),
(341222112, 341222, '蔡庙镇', 341222112),
(341222113, 341222, '三堂镇', 341222113),
(341222114, 341222, '苗老集镇', 341222114),
(341222115, 341222, '赵庙镇', 341222115),
(341222116, 341222, '宫集镇', 341222116),
(341222117, 341222, '坟台镇', 341222117),
(341222118, 341222, '洪山镇', 341222118),
(341222119, 341222, '清浅镇', 341222119),
(341222120, 341222, '五星镇', 341222120),
(341222121, 341222, '高庙镇', 341222121),
(341222122, 341222, '桑郢镇', 341222122),
(341222123, 341222, '大庙集镇', 341222123),
(341222124, 341222, '阮桥镇', 341222124),
(341222125, 341222, '双庙镇', 341222125),
(341222200, 341222, '胡总乡', 341222200),
(341222201, 341222, '赵集乡', 341222201),
(341222202, 341222, '郭庙乡', 341222202),
(341222203, 341222, '马集乡', 341222203),
(341222204, 341222, '二郎乡', 341222204),
(341225100, 341225, '城关镇', 341225100),
(341225101, 341225, '方集镇', 341225101),
(341225102, 341225, '中岗镇', 341225102),
(341225103, 341225, '柴集镇', 341225103),
(341225104, 341225, '新村镇', 341225104),
(341225105, 341225, '三塔镇', 341225105),
(341225106, 341225, '朱寨镇', 341225106),
(341225107, 341225, '柳沟镇', 341225107),
(341225108, 341225, '赵集镇', 341225108),
(341225109, 341225, '田集镇', 341225109),
(341225110, 341225, '苗集镇', 341225110),
(341225111, 341225, '黄岗镇', 341225111),
(341225112, 341225, '焦陂镇', 341225112),
(341225113, 341225, '张寨镇', 341225113),
(341225114, 341225, '王堰镇', 341225114),
(341225115, 341225, '地城镇', 341225115),
(341225116, 341225, '洪河桥镇', 341225116),
(341225117, 341225, '王家坝镇', 341225117),
(341225118, 341225, '王化镇', 341225118),
(341225119, 341225, '曹集镇', 341225119),
(341225200, 341225, '王店孜乡', 341225200),
(341225201, 341225, '许堂乡', 341225201),
(341225202, 341225, '会龙乡', 341225202),
(341225203, 341225, '城郊乡', 341225203),
(341225204, 341225, '段郢乡', 341225204),
(341225205, 341225, '公桥乡', 341225205),
(341225206, 341225, '龙王乡', 341225206),
(341225207, 341225, '于集乡', 341225207),
(341225208, 341225, '老观乡', 341225208),
(341225209, 341225, '郜台乡', 341225209),
(341225450, 341225, '阜蒙农场', 341225450),
(341226100, 341226, '慎城镇', 341226100),
(341226101, 341226, '谢桥镇', 341226101),
(341226102, 341226, '南照镇', 341226102),
(341226103, 341226, '杨湖镇', 341226103),
(341226104, 341226, '江口镇', 341226104),
(341226105, 341226, '润河镇', 341226105),
(341226106, 341226, '新集镇', 341226106),
(341226107, 341226, '六十铺镇', 341226107),
(341226108, 341226, '耿棚镇', 341226108),
(341226109, 341226, '半岗镇', 341226109),
(341226110, 341226, '王岗镇', 341226110),
(341226111, 341226, '夏桥镇', 341226111),
(341226112, 341226, '江店孜镇', 341226112),
(341226113, 341226, '陈桥镇', 341226113),
(341226114, 341226, '黄桥镇', 341226114),
(341226115, 341226, '八里河镇', 341226115),
(341226116, 341226, '汤店镇', 341226116),
(341226117, 341226, '西三十铺镇', 341226117),
(341226118, 341226, '红星镇', 341226118),
(341226119, 341226, '十八里铺镇', 341226119),
(341226120, 341226, '鲁口镇', 341226120),
(341226200, 341226, '建颍乡', 341226200),
(341226201, 341226, '五十铺乡', 341226201),
(341226202, 341226, '盛堂乡', 341226202),
(341226203, 341226, '关屯乡', 341226203),
(341226204, 341226, '垂岗乡', 341226204),
(341226205, 341226, '赛涧回族乡', 341226205),
(341226206, 341226, '刘集乡', 341226206),
(341226207, 341226, '黄坝乡', 341226207),
(341226208, 341226, '古城乡', 341226208),
(341282001, 341282, '东城', 341282001),
(341282002, 341282, '西城', 341282002),
(341282003, 341282, '颖南', 341282003),
(341282100, 341282, '光武镇', 341282100),
(341282101, 341282, '泉阳镇', 341282101),
(341282102, 341282, '芦村镇', 341282102),
(341282103, 341282, '新马集镇', 341282103),
(341282104, 341282, '大黄镇', 341282104),
(341282105, 341282, '田营镇', 341282105),
(341282106, 341282, '陶庙镇', 341282106),
(341282107, 341282, '王集镇', 341282107),
(341282108, 341282, '砖集镇', 341282108),
(341282109, 341282, '顾集镇', 341282109),
(341282110, 341282, '代桥镇', 341282110),
(341282111, 341282, '舒庄镇', 341282111),
(341282200, 341282, '邴集乡', 341282200),
(341282201, 341282, '靳寨乡', 341282201),
(341282202, 341282, '任寨乡', 341282202),
(341302001, 341302, '埇桥街道', 341302001),
(341302002, 341302, '沱河街道', 341302002),
(341302003, 341302, '道东街道', 341302003),
(341302004, 341302, '东关街道', 341302004),
(341302005, 341302, '三里湾街道', 341302005),
(341302006, 341302, '南关街道', 341302006),
(341302007, 341302, '西关街道', 341302007),
(341302008, 341302, '北关街道', 341302008),
(341302009, 341302, '汴河街道', 341302009),
(341302010, 341302, '三八街道', 341302010),
(341302011, 341302, '城东街道', 341302011),
(341302100, 341302, '符离镇', 341302100),
(341302101, 341302, '芦岭镇', 341302101),
(341302102, 341302, '朱仙庄镇', 341302102),
(341302103, 341302, '褚兰镇', 341302103),
(341302104, 341302, '曹村镇', 341302104),
(341302105, 341302, '夹沟镇', 341302105),
(341302106, 341302, '栏杆镇', 341302106),
(341302107, 341302, '时村镇', 341302107),
(341302108, 341302, '永安镇', 341302108),
(341302109, 341302, '灰古镇', 341302109),
(341302110, 341302, '大店镇', 341302110),
(341302111, 341302, '西寺坡镇', 341302111),
(341302112, 341302, '桃园镇', 341302112),
(341302113, 341302, '蕲县镇', 341302113),
(341302114, 341302, '大营镇', 341302114),
(341302200, 341302, '杨庄乡', 341302200),
(341302201, 341302, '支河乡', 341302201),
(341302202, 341302, '解集乡', 341302202),
(341302203, 341302, '桃沟乡', 341302203),
(341302204, 341302, '顺河乡', 341302204),
(341302205, 341302, '蒿沟乡', 341302205),
(341302206, 341302, '苗安乡', 341302206),
(341302207, 341302, '永镇乡', 341302207),
(341302208, 341302, '西二铺乡', 341302208),
(341302450, 341302, '宿州经济技术开发区', 341302450),
(341321100, 341321, '砀城镇', 341321100),
(341321101, 341321, '西南门镇', 341321101),
(341321102, 341321, '李庄镇', 341321102),
(341321103, 341321, '唐寨镇', 341321103),
(341321104, 341321, '葛集镇', 341321104),
(341321105, 341321, '周寨镇', 341321105),
(341321106, 341321, '玄庙镇', 341321106),
(341321107, 341321, '官庄坝镇', 341321107),
(341321108, 341321, '曹庄镇', 341321108),
(341321109, 341321, '关帝庙镇', 341321109),
(341321110, 341321, '朱楼镇', 341321110),
(341321111, 341321, '文庄镇', 341321111),
(341321112, 341321, '程庄镇', 341321112),
(341321113, 341321, '良梨镇', 341321113),
(341321200, 341321, '黄楼乡', 341321200),
(341321201, 341321, '权集乡', 341321201),
(341321202, 341321, '刘暗楼乡', 341321202),
(341321203, 341321, '赵屯乡', 341321203),
(341321400, 341321, '经济开发区', 341321400),
(341322100, 341322, '龙城镇', 341322100),
(341322101, 341322, '黄口镇', 341322101),
(341322102, 341322, '杨楼镇', 341322102),
(341322103, 341322, '闫集镇', 341322103),
(341322104, 341322, '新庄镇', 341322104),
(341322105, 341322, '刘套镇', 341322105),
(341322106, 341322, '马井镇', 341322106),
(341322107, 341322, '大屯镇', 341322107),
(341322108, 341322, '赵庄镇', 341322108),
(341322109, 341322, '杜楼镇', 341322109),
(341322110, 341322, '丁里镇', 341322110),
(341322111, 341322, '王寨镇', 341322111),
(341322112, 341322, '祖楼镇', 341322112),
(341322113, 341322, '青龙镇', 341322113),
(341322114, 341322, '张庄寨镇', 341322114),
(341322115, 341322, '永堌镇', 341322115),
(341322116, 341322, '白土镇', 341322116),
(341322117, 341322, '官桥镇', 341322117),
(341322200, 341322, '圣泉乡', 341322200),
(341322201, 341322, '酒店乡', 341322201),
(341322202, 341322, '孙圩孜乡', 341322202),
(341322203, 341322, '庄里乡', 341322203),
(341322204, 341322, '石林乡', 341322204),
(341323100, 341323, '灵城镇', 341323100),
(341323101, 341323, '韦集镇', 341323101),
(341323102, 341323, '黄湾镇', 341323102),
(341323103, 341323, '娄庄镇', 341323103),
(341323104, 341323, '杨疃镇', 341323104),
(341323105, 341323, '尹集镇', 341323105),
(341323106, 341323, '浍沟镇', 341323106),
(341323107, 341323, '尤集镇', 341323107),
(341323108, 341323, '夏楼镇', 341323108),
(341323109, 341323, '朝阳镇', 341323109),
(341323110, 341323, '渔沟镇', 341323110),
(341323111, 341323, '高楼镇', 341323111),
(341323112, 341323, '冯庙镇', 341323112),
(341323200, 341323, '向阳乡', 341323200),
(341323201, 341323, '朱集乡', 341323201),
(341323202, 341323, '大路乡', 341323202),
(341323203, 341323, '大庙乡', 341323203),
(341323204, 341323, '禅堂乡', 341323204),
(341323205, 341323, '虞姬乡', 341323205),
(341323400, 341323, '工业园区', 341323400),
(341324100, 341324, '泗城镇', 341324100),
(341324101, 341324, '墩集镇', 341324101),
(341324102, 341324, '丁湖镇', 341324102),
(341324103, 341324, '草沟镇', 341324103),
(341324104, 341324, '长沟镇', 341324104),
(341324105, 341324, '黄圩镇', 341324105),
(341324106, 341324, '大庄镇', 341324106),
(341324107, 341324, '山头镇', 341324107),
(341324108, 341324, '刘圩镇', 341324108),
(341324109, 341324, '黑塔镇', 341324109),
(341324110, 341324, '草庙镇', 341324110),
(341324111, 341324, '屏山镇', 341324111),
(341324200, 341324, '大路口乡', 341324200),
(341324201, 341324, '大杨乡', 341324201),
(341324202, 341324, '瓦坊乡', 341324202),
(341324400, 341324, '泗县开发区管委会', 341324400),
(341402001, 341402, '中庙街道', 341402001),
(341402002, 341402, '亚父街道', 341402002),
(341402003, 341402, '卧牛山街道', 341402003),
(341402004, 341402, '凤凰山街道', 341402004),
(341402005, 341402, '天河街道', 341402005),
(341402006, 341402, '半汤街道办事处市开发区', 341402006),
(341402100, 341402, '栏杆集镇', 341402100),
(341402101, 341402, '苏湾镇', 341402101),
(341402102, 341402, '柘皋镇', 341402102),
(341402103, 341402, '银屏镇', 341402103),
(341402104, 341402, '夏阁镇', 341402104),
(341402105, 341402, '中垾镇', 341402105),
(341402106, 341402, '散兵镇', 341402106),
(341402107, 341402, '烔炀镇', 341402107),
(341402108, 341402, '黄麓镇', 341402108),
(341402109, 341402, '槐林镇', 341402109),
(341402110, 341402, '坝镇镇', 341402110),
(341402200, 341402, '庙岗乡', 341402200),
(341421100, 341421, '庐城镇', 341421100),
(341421101, 341421, '冶父山镇', 341421101),
(341421102, 341421, '万山镇', 341421102),
(341421103, 341421, '汤池镇', 341421103),
(341421104, 341421, '郭河镇', 341421104),
(341421105, 341421, '金牛镇', 341421105),
(341421106, 341421, '石头镇', 341421106),
(341421107, 341421, '同大镇', 341421107),
(341421108, 341421, '白山镇', 341421108),
(341421109, 341421, '盛桥镇', 341421109),
(341421110, 341421, '白湖镇', 341421110),
(341421111, 341421, '龙桥镇', 341421111),
(341421112, 341421, '矾山镇', 341421112),
(341421113, 341421, '罗河镇', 341421113),
(341421114, 341421, '泥河镇', 341421114),
(341421115, 341421, '乐桥镇', 341421115),
(341421116, 341421, '柯坦镇', 341421116),
(341421400, 341421, '安徽庐江经济开发区', 341421400),
(341421401, 341421, '安徽省白湖监狱管理分局', 341421401),
(341421402, 341421, '安徽省白湖阀门厂有限公司', 341421402),
(341421403, 341421, '安徽省罪犯技术培训中心', 341421403),
(341422100, 341422, '无城镇', 341422100),
(341422101, 341422, '襄安镇', 341422101),
(341422102, 341422, '二坝镇', 341422102),
(341422103, 341422, '汤沟镇', 341422103),
(341422104, 341422, '陡沟镇', 341422104),
(341422105, 341422, '石涧镇', 341422105),
(341422106, 341422, '严桥镇', 341422106),
(341422107, 341422, '开城镇', 341422107),
(341422108, 341422, '蜀山镇', 341422108),
(341422109, 341422, '牛埠镇', 341422109),
(341422110, 341422, '刘渡镇', 341422110),
(341422111, 341422, '姚沟镇', 341422111),
(341422112, 341422, '泥汊镇', 341422112),
(341422113, 341422, '白茆镇', 341422113),
(341422114, 341422, '福渡镇', 341422114),
(341422115, 341422, '泉塘镇', 341422115),
(341422116, 341422, '赫店镇', 341422116),
(341422117, 341422, '红庙镇', 341422117),
(341422118, 341422, '高沟镇', 341422118),
(341422200, 341422, '鹤毛乡', 341422200),
(341422201, 341422, '十里墩乡', 341422201),
(341422202, 341422, '昆山乡', 341422202),
(341422203, 341422, '洪巷乡', 341422203),
(341423100, 341423, '环峰镇', 341423100),
(341423101, 341423, '运漕镇', 341423101),
(341423102, 341423, '铜闸镇', 341423102),
(341423103, 341423, '陶厂镇', 341423103),
(341423104, 341423, '林头镇', 341423104),
(341423105, 341423, '清溪镇', 341423105),
(341423106, 341423, '仙踪镇', 341423106),
(341423107, 341423, '昭关镇', 341423107),
(341424100, 341424, '历阳镇', 341424100),
(341424101, 341424, '沈巷镇', 341424101),
(341424102, 341424, '白桥镇', 341424102),
(341424103, 341424, '姥桥镇', 341424103),
(341424104, 341424, '功桥镇', 341424104),
(341424105, 341424, '西埠镇', 341424105),
(341424106, 341424, '香泉镇', 341424106),
(341424107, 341424, '乌江镇', 341424107),
(341424108, 341424, '善厚镇', 341424108),
(341424109, 341424, '石杨镇', 341424109),
(341502001, 341502, '中市街道', 341502001),
(341502002, 341502, '东市街道', 341502002),
(341502003, 341502, '三里桥街道', 341502003),
(341502004, 341502, '望城街道', 341502004),
(341502005, 341502, '清水河街道', 341502005),
(341502100, 341502, '木厂镇', 341502100),
(341502101, 341502, '马头镇', 341502101),
(341502102, 341502, '东桥镇', 341502102),
(341502103, 341502, '张店镇', 341502103),
(341502104, 341502, '毛坦厂镇', 341502104),
(341502105, 341502, '东河口镇', 341502105),
(341502106, 341502, '双河镇', 341502106),
(341502107, 341502, '施桥镇', 341502107),
(341502108, 341502, '孙岗镇', 341502108),
(341502109, 341502, '三十铺镇', 341502109),
(341502110, 341502, '椿树镇', 341502110),
(341502200, 341502, '城北乡', 341502200),
(341502201, 341502, '翁墩乡', 341502201),
(341502202, 341502, '淠东乡', 341502202),
(341502203, 341502, '中店乡', 341502203),
(341502204, 341502, '横塘岗乡', 341502204),
(341502205, 341502, '先生店乡', 341502205),
(341502400, 341502, '六安经济开发区', 341502400),
(341503001, 341503, '鼓楼街道', 341503001),
(341503002, 341503, '西市街道', 341503002),
(341503003, 341503, '小华山街道', 341503003),
(341503100, 341503, '苏埠镇', 341503100),
(341503101, 341503, '韩摆渡镇', 341503101),
(341503102, 341503, '新安镇', 341503102),
(341503103, 341503, '顺河镇', 341503103),
(341503104, 341503, '独山镇', 341503104),
(341503105, 341503, '石婆店镇', 341503105),
(341503106, 341503, '城南镇', 341503106),
(341503107, 341503, '丁集镇', 341503107),
(341503108, 341503, '固镇镇', 341503108),
(341503109, 341503, '徐集镇', 341503109),
(341503110, 341503, '分路口镇', 341503110),
(341503111, 341503, '江家店镇', 341503111),
(341503200, 341503, '单王乡', 341503200),
(341503201, 341503, '青山乡', 341503201),
(341503202, 341503, '石板冲乡', 341503202),
(341503203, 341503, '西河口乡', 341503203),
(341503204, 341503, '平桥乡', 341503204),
(341503205, 341503, '罗集乡', 341503205),
(341503206, 341503, '狮子岗乡', 341503206),
(341521100, 341521, '寿春镇', 341521100),
(341521101, 341521, '双桥镇', 341521101),
(341521102, 341521, '涧沟镇', 341521102),
(341521103, 341521, '丰庄镇', 341521103),
(341521104, 341521, '正阳关镇', 341521104),
(341521105, 341521, '迎河镇', 341521105),
(341521106, 341521, '板桥镇', 341521106),
(341521107, 341521, '安丰塘镇', 341521107),
(341521108, 341521, '堰口镇', 341521108),
(341521109, 341521, '保义镇', 341521109),
(341521110, 341521, '隐贤镇', 341521110),
(341521111, 341521, '安丰镇', 341521111),
(341521112, 341521, '众兴镇', 341521112),
(341521113, 341521, '茶庵镇', 341521113),
(341521114, 341521, '三觉镇', 341521114),
(341521115, 341521, '炎刘镇', 341521115),
(341521116, 341521, '刘岗镇', 341521116),
(341521117, 341521, '双庙集镇', 341521117),
(341521118, 341521, '小甸镇', 341521118),
(341521119, 341521, '瓦埠镇', 341521119),
(341521120, 341521, '大顺镇', 341521120),
(341521200, 341521, '八公山乡', 341521200),
(341521201, 341521, '张李乡', 341521201),
(341521202, 341521, '窑口乡', 341521202),
(341521203, 341521, '陶店回族乡', 341521203),
(341521400, 341521, '寿西湖农场', 341521400),
(341522100, 341522, '城关镇', 341522100),
(341522101, 341522, '河口镇', 341522101),
(341522102, 341522, '周集镇', 341522102),
(341522103, 341522, '临水镇', 341522103),
(341522104, 341522, '新店镇', 341522104),
(341522105, 341522, '石店镇', 341522105),
(341522106, 341522, '马店镇', 341522106),
(341522107, 341522, '孟集镇', 341522107),
(341522108, 341522, '花园镇', 341522108),
(341522109, 341522, '扈胡镇', 341522109),
(341522110, 341522, '长集镇', 341522110),
(341522111, 341522, '洪集镇', 341522111),
(341522112, 341522, '姚李镇', 341522112),
(341522113, 341522, '乌龙镇', 341522113),
(341522114, 341522, '高塘镇', 341522114),
(341522115, 341522, '龙潭镇', 341522115),
(341522116, 341522, '岔路镇', 341522116),
(341522117, 341522, '冯井镇', 341522117),
(341522118, 341522, '众兴集镇', 341522118),
(341522119, 341522, '夏店镇', 341522119),
(341522120, 341522, '曹庙镇', 341522120),
(341522121, 341522, '叶集区叶集镇', 341522121),
(341522200, 341522, '彭塔乡', 341522200),
(341522201, 341522, '王截流乡', 341522201),
(341522202, 341522, '范桥乡', 341522202),
(341522203, 341522, '临淮岗乡', 341522203),
(341522204, 341522, '城西湖乡', 341522204),
(341522205, 341522, '宋店乡', 341522205),
(341522206, 341522, '三流乡', 341522206),
(341522207, 341522, '邵岗乡', 341522207),
(341522208, 341522, '白莲乡', 341522208),
(341522209, 341522, '潘集乡', 341522209),
(341522210, 341522, '冯瓴乡', 341522210),
(341522211, 341522, '叶集区孙岗乡', 341522211),
(341522212, 341522, '叶集区三元乡', 341522212),
(341523100, 341523, '城关镇', 341523100),
(341523101, 341523, '晓天镇', 341523101),
(341523102, 341523, '桃溪镇', 341523102),
(341523103, 341523, '万佛湖镇', 341523103),
(341523104, 341523, '千人桥镇', 341523104),
(341523105, 341523, '百神庙镇', 341523105),
(341523106, 341523, '杭埠镇', 341523106),
(341523107, 341523, '舒茶镇', 341523107),
(341523108, 341523, '南港镇', 341523108),
(341523109, 341523, '干汊河镇', 341523109),
(341523110, 341523, '张母桥镇', 341523110),
(341523111, 341523, '五显镇', 341523111),
(341523112, 341523, '山七镇', 341523112),
(341523113, 341523, '河棚镇', 341523113),
(341523114, 341523, '汤池镇', 341523114),
(341523200, 341523, '春秋乡', 341523200),
(341523201, 341523, '柏林乡', 341523201),
(341523202, 341523, '棠树乡', 341523202),
(341523203, 341523, '阙店乡', 341523203),
(341523204, 341523, '高峰乡', 341523204),
(341523205, 341523, '庐镇乡', 341523205),
(341524100, 341524, '梅山镇', 341524100),
(341524101, 341524, '响洪甸镇(含响齐办事处)', 341524101),
(341524102, 341524, '青山镇', 341524102),
(341524103, 341524, '燕子河镇', 341524103),
(341524104, 341524, '天堂寨镇', 341524104),
(341524105, 341524, '古碑镇', 341524105),
(341524106, 341524, '吴家店镇', 341524106),
(341524107, 341524, '斑竹园镇', 341524107),
(341524108, 341524, '汤家汇镇', 341524108),
(341524109, 341524, '南溪镇', 341524109),
(341524110, 341524, '双河镇', 341524110),
(341524200, 341524, '白塔畈乡', 341524200),
(341524201, 341524, '张冲乡', 341524201),
(341524202, 341524, '油坊店乡', 341524202),
(341524203, 341524, '长岭乡', 341524203),
(341524204, 341524, '槐树湾乡', 341524204),
(341524205, 341524, '花石乡', 341524205),
(341524206, 341524, '沙河乡', 341524206),
(341524207, 341524, '桃岭乡', 341524207),
(341524208, 341524, '果子园乡', 341524208),
(341524209, 341524, '关庙乡', 341524209),
(341524210, 341524, '银山畈乡', 341524210),
(341524211, 341524, '全军乡', 341524211),
(341524212, 341524, '张畈乡', 341524212),
(341524213, 341524, '水竹坪乡', 341524213),
(341524214, 341524, '铁冲乡', 341524214),
(341525100, 341525, '衡山镇', 341525100),
(341525101, 341525, '佛子岭镇', 341525101),
(341525102, 341525, '下符桥镇', 341525102),
(341525103, 341525, '但家庙镇', 341525103),
(341525104, 341525, '与儿街镇', 341525104),
(341525105, 341525, '黑石渡镇', 341525105),
(341525106, 341525, '诸佛庵镇', 341525106),
(341525107, 341525, '落儿岭镇', 341525107),
(341525108, 341525, '磨子潭镇', 341525108),
(341525109, 341525, '大化坪镇', 341525109),
(341525110, 341525, '漫水河镇', 341525110),
(341525111, 341525, '上士市镇', 341525111),
(341525200, 341525, '单龙寺乡', 341525200),
(341525201, 341525, '东西溪乡', 341525201),
(341525202, 341525, '太平畈乡', 341525202),
(341525203, 341525, '太阳乡', 341525203),
(341602001, 341602, '花戏楼', 341602001),
(341602002, 341602, '薛阁', 341602002),
(341602003, 341602, '汤陵', 341602003),
(341602100, 341602, '古井镇', 341602100),
(341602101, 341602, '芦庙镇', 341602101),
(341602102, 341602, '华佗镇', 341602102),
(341602103, 341602, '魏岗镇', 341602103),
(341602104, 341602, '牛集镇', 341602104),
(341602105, 341602, '颜集镇', 341602105),
(341602106, 341602, '五马镇', 341602106),
(341602107, 341602, '十八里镇', 341602107),
(341602108, 341602, '谯东镇', 341602108),
(341602109, 341602, '十九里镇', 341602109),
(341602110, 341602, '沙土镇', 341602110),
(341602111, 341602, '观堂镇', 341602111),
(341602112, 341602, '大杨镇', 341602112),
(341602113, 341602, '城父镇', 341602113),
(341602114, 341602, '十河镇', 341602114),
(341602115, 341602, '双沟镇', 341602115),
(341602116, 341602, '淝河镇', 341602116),
(341602117, 341602, '古城镇', 341602117),
(341602118, 341602, '龙扬镇', 341602118),
(341602119, 341602, '立德镇', 341602119),
(341602200, 341602, '张店乡', 341602200),
(341602201, 341602, '赵桥乡', 341602201),
(341602400, 341602, '亳州市经济技术开发区', 341602400),
(341602500, 341602, '王大庄良种试验示范场', 341602500),
(341602501, 341602, '羊种改良站', 341602501),
(341621100, 341621, '城关镇', 341621100),
(341621101, 341621, '城西镇', 341621101),
(341621102, 341621, '城东镇', 341621102),
(341621103, 341621, '西阳镇', 341621103),
(341621104, 341621, '双庙镇', 341621104),
(341621105, 341621, '楚店镇', 341621105),
(341621106, 341621, '高公镇', 341621106),
(341621107, 341621, '闸北镇', 341621107),
(341621108, 341621, '高炉镇', 341621108),
(341621109, 341621, '曹市镇', 341621109),
(341621110, 341621, '青町镇', 341621110),
(341621111, 341621, '石弓镇', 341621111),
(341621112, 341621, '龙山镇', 341621112),
(341621113, 341621, '义门镇', 341621113),
(341621114, 341621, '新兴镇', 341621114),
(341621115, 341621, '临湖镇', 341621115),
(341621116, 341621, '丹城镇', 341621116),
(341621117, 341621, '马店集镇', 341621117),
(341621118, 341621, '花沟镇', 341621118),
(341621119, 341621, '店集镇', 341621119),
(341621120, 341621, '陈大镇', 341621120),
(341621121, 341621, '牌坊镇', 341621121),
(341621122, 341621, '公吉寺镇', 341621122),
(341621123, 341621, '标里镇', 341621123),
(341621200, 341621, '张老家乡', 341621200),
(341621201, 341621, '耿皇乡', 341621201),
(341621500, 341621, '单集林场', 341621500),
(341622100, 341622, '城关镇', 341622100),
(341622101, 341622, '双涧镇', 341622101),
(341622102, 341622, '小涧镇', 341622102),
(341622103, 341622, '漆园', 341622103),
(341622104, 341622, '坛城镇', 341622104),
(341622105, 341622, '范集工业园区', 341622105),
(341622106, 341622, '许町镇', 341622106),
(341622107, 341622, '板桥集镇', 341622107),
(341622108, 341622, '马集镇', 341622108),
(341622109, 341622, '岳坊镇', 341622109),
(341622110, 341622, '立仓镇', 341622110);
INSERT INTO `{pre}areas` VALUES
(341622111, 341622, '楚村镇', 341622111),
(341622112, 341622, '乐土镇', 341622112),
(341622113, 341622, '三义镇', 341622113),
(341622114, 341622, '篱笆镇', 341622114),
(341622200, 341622, '庄周', 341622200),
(341622201, 341622, '王集乡', 341622201),
(341622202, 341622, '小辛集乡', 341622202),
(341622500, 341622, '白杨林场', 341622500),
(341623100, 341623, '城关镇', 341623100),
(341623101, 341623, '阚疃镇', 341623101),
(341623102, 341623, '张村镇', 341623102),
(341623103, 341623, '江集镇', 341623103),
(341623104, 341623, '旧城镇', 341623104),
(341623105, 341623, '西潘楼镇', 341623105),
(341623106, 341623, '孙集镇', 341623106),
(341623107, 341623, '汝集镇', 341623107),
(341623108, 341623, '巩店镇', 341623108),
(341623109, 341623, '王人镇', 341623109),
(341623110, 341623, '王市镇', 341623110),
(341623111, 341623, '永兴镇', 341623111),
(341623112, 341623, '马店镇', 341623112),
(341623113, 341623, '大李集镇', 341623113),
(341623114, 341623, '胡集镇', 341623114),
(341623115, 341623, '展沟镇', 341623115),
(341623116, 341623, '程家集镇', 341623116),
(341623117, 341623, '中疃镇', 341623117),
(341623118, 341623, '望疃镇', 341623118),
(341623200, 341623, '双桥乡', 341623200),
(341623201, 341623, '春店乡', 341623201),
(341623202, 341623, '刘家集乡', 341623202),
(341623203, 341623, '纪王场乡', 341623203),
(341623204, 341623, '孙庙乡', 341623204),
(341623205, 341623, '新张集乡', 341623205),
(341623206, 341623, '丹凤乡', 341623206),
(341623500, 341623, '安徽省阜阳市柴湖良种繁殖场', 341623500),
(341702001, 341702, '池阳街道', 341702001),
(341702002, 341702, '秋浦街道', 341702002),
(341702003, 341702, '里山街道', 341702003),
(341702004, 341702, '江口街道', 341702004),
(341702100, 341702, '殷汇镇', 341702100),
(341702101, 341702, '牛头山镇', 341702101),
(341702102, 341702, '涓桥镇', 341702102),
(341702103, 341702, '马衙镇', 341702103),
(341702104, 341702, '墩上镇', 341702104),
(341702105, 341702, '梅龙镇', 341702105),
(341702106, 341702, '梅街镇', 341702106),
(341702107, 341702, '观前镇', 341702107),
(341702108, 341702, '梅村镇', 341702108),
(341702109, 341702, '唐田镇', 341702109),
(341702110, 341702, '牌楼镇', 341702110),
(341702111, 341702, '乌沙镇', 341702111),
(341702112, 341702, '晏塘镇', 341702112),
(341702200, 341702, '阮桥乡', 341702200),
(341702201, 341702, '高脊岭乡', 341702201),
(341702202, 341702, '木闸乡', 341702202),
(341702203, 341702, '高坦乡', 341702203),
(341702204, 341702, '棠溪乡', 341702204),
(341702205, 341702, '刘街乡', 341702205),
(341702206, 341702, '解放乡', 341702206),
(341702207, 341702, '茅坦乡', 341702207),
(341702400, 341702, '池州市开发区', 341702400),
(341721100, 341721, '尧渡镇', 341721100),
(341721101, 341721, '东流镇', 341721101),
(341721102, 341721, '大渡口镇', 341721102),
(341721103, 341721, '胜利镇', 341721103),
(341721104, 341721, '张溪镇', 341721104),
(341721105, 341721, '洋湖镇', 341721105),
(341721106, 341721, '葛公镇', 341721106),
(341721107, 341721, '香隅镇', 341721107),
(341721108, 341721, '官港镇', 341721108),
(341721109, 341721, '昭潭镇', 341721109),
(341721110, 341721, '龙泉镇', 341721110),
(341721200, 341721, '瓦垄乡', 341721200),
(341721201, 341721, '白笏乡', 341721201),
(341721202, 341721, '坦埠乡', 341721202),
(341721203, 341721, '汪坡乡', 341721203),
(341721204, 341721, '高山乡', 341721204),
(341721205, 341721, '洪方乡', 341721205),
(341721206, 341721, '查桥乡', 341721206),
(341721207, 341721, '七里湖乡', 341721207),
(341721208, 341721, '建新乡', 341721208),
(341721209, 341721, '花园里乡', 341721209),
(341721210, 341721, '马坑乡', 341721210),
(341721211, 341721, '利安乡', 341721211),
(341721212, 341721, '木塔乡', 341721212),
(341721213, 341721, '石城乡', 341721213),
(341721214, 341721, '泥溪乡', 341721214),
(341721215, 341721, '西湾乡', 341721215),
(341721216, 341721, '青山乡', 341721216),
(341721217, 341721, '铁炉乡', 341721217),
(341722100, 341722, '七里镇', 341722100),
(341722101, 341722, '七都镇', 341722101),
(341722102, 341722, '占大镇', 341722102),
(341722103, 341722, '丁香镇', 341722103),
(341722104, 341722, '小河镇', 341722104),
(341722105, 341722, '横渡镇', 341722105),
(341722200, 341722, '六都乡', 341722200),
(341722201, 341722, '七井乡', 341722201),
(341722202, 341722, '珂田乡', 341722202),
(341722203, 341722, '大演乡', 341722203),
(341722204, 341722, '贡溪乡', 341722204),
(341722205, 341722, '矶滩乡', 341722205),
(341722206, 341722, '莘田乡', 341722206),
(341723100, 341723, '蓉城镇', 341723100),
(341723101, 341723, '木镇镇', 341723101),
(341723102, 341723, '庙前镇　', 341723102),
(341723103, 341723, '陵阳镇', 341723103),
(341723104, 341723, '新河镇', 341723104),
(341723105, 341723, '丁桥镇', 341723105),
(341723106, 341723, '朱备镇', 341723106),
(341723107, 341723, '杨田镇　', 341723107),
(341723108, 341723, '九华镇', 341723108),
(341723200, 341723, '乔木乡', 341723200),
(341723201, 341723, '酉华乡', 341723201),
(341723202, 341723, '杜村乡', 341723202),
(341723203, 341723, '九华乡', 341723203),
(341802001, 341802, '西林街道', 341802001),
(341802002, 341802, '澄江街道', 341802002),
(341802003, 341802, '鳌峰街道', 341802003),
(341802004, 341802, '济川街道', 341802004),
(341802005, 341802, '敬亭山街道', 341802005),
(341802006, 341802, '飞彩街道', 341802006),
(341802007, 341802, '双桥街道', 341802007),
(341802100, 341802, '水阳镇', 341802100),
(341802101, 341802, '狸桥镇', 341802101),
(341802102, 341802, '沈村镇', 341802102),
(341802103, 341802, '古泉镇', 341802103),
(341802104, 341802, '洪林镇', 341802104),
(341802105, 341802, '寒亭镇', 341802105),
(341802106, 341802, '文昌镇', 341802106),
(341802107, 341802, '孙埠镇', 341802107),
(341802108, 341802, '向阳镇', 341802108),
(341802109, 341802, '杨柳镇', 341802109),
(341802110, 341802, '水东镇', 341802110),
(341802111, 341802, '新田镇', 341802111),
(341802112, 341802, '周王镇', 341802112),
(341802113, 341802, '溪口镇', 341802113),
(341802200, 341802, '朱桥乡', 341802200),
(341802201, 341802, '养贤乡', 341802201),
(341802202, 341802, '五星乡', 341802202),
(341802203, 341802, '金坝乡', 341802203),
(341802204, 341802, '黄渡乡', 341802204),
(341821100, 341821, '建平镇', 341821100),
(341821101, 341821, '十字镇', 341821101),
(341821102, 341821, '新发镇', 341821102),
(341821103, 341821, '涛城镇', 341821103),
(341821104, 341821, '南丰镇', 341821104),
(341821105, 341821, '梅渚镇', 341821105),
(341821106, 341821, '东夏镇', 341821106),
(341821107, 341821, '毕桥镇', 341821107),
(341821200, 341821, '凌笪乡', 341821200),
(341821201, 341821, '飞里乡', 341821201),
(341821202, 341821, '姚村乡', 341821202),
(341821203, 341821, '幸福乡', 341821203),
(341821500, 341821, '十字茶业总公司', 341821500),
(341822100, 341822, '桃州镇', 341822100),
(341822101, 341822, '柏垫镇', 341822101),
(341822102, 341822, '誓节镇', 341822102),
(341822103, 341822, '邱村镇', 341822103),
(341822104, 341822, '新杭镇', 341822104),
(341822200, 341822, '卢村乡', 341822200),
(341822201, 341822, '东亭乡', 341822201),
(341822202, 341822, '杨滩乡', 341822202),
(341822203, 341822, '四合乡', 341822203),
(341822400, 341822, '经济开发区', 341822400),
(341822500, 341822, '祠山岗茶场', 341822500),
(341823100, 341823, '泾川镇', 341823100),
(341823101, 341823, '茂林镇', 341823101),
(341823102, 341823, '榔桥镇', 341823102),
(341823103, 341823, '桃花潭镇', 341823103),
(341823104, 341823, '琴溪镇', 341823104),
(341823105, 341823, '蔡村镇', 341823105),
(341823106, 341823, '云岭镇', 341823106),
(341823107, 341823, '黄村镇', 341823107),
(341823108, 341823, '丁家桥镇', 341823108),
(341823200, 341823, '汀溪乡', 341823200),
(341823201, 341823, '昌桥乡', 341823201),
(341824100, 341824, '华阳镇', 341824100),
(341824101, 341824, '临溪镇', 341824101),
(341824102, 341824, '长安镇', 341824102),
(341824103, 341824, '上庄镇', 341824103),
(341824104, 341824, '扬溪镇', 341824104),
(341824105, 341824, '伏岭镇', 341824105),
(341824106, 341824, '金沙镇', 341824106),
(341824200, 341824, '瀛洲乡', 341824200),
(341824201, 341824, '板桥头乡', 341824201),
(341824202, 341824, '家朋乡', 341824202),
(341824203, 341824, '荆州乡', 341824203),
(341825100, 341825, '旌阳镇', 341825100),
(341825101, 341825, '蔡家桥镇', 341825101),
(341825102, 341825, '三溪镇', 341825102),
(341825103, 341825, '庙首镇', 341825103),
(341825104, 341825, '白地镇', 341825104),
(341825200, 341825, '版书乡', 341825200),
(341825201, 341825, '俞村乡', 341825201),
(341825202, 341825, '云乐乡', 341825202),
(341825203, 341825, '兴隆乡', 341825203),
(341825204, 341825, '孙村乡', 341825204),
(341881001, 341881, '西津街道', 341881001),
(341881002, 341881, '南山街道', 341881002),
(341881003, 341881, '河沥街道', 341881003),
(341881004, 341881, '汪溪街道', 341881004),
(341881005, 341881, '竹峰街道', 341881005),
(341881006, 341881, '天湖街道', 341881006),
(341881100, 341881, '港口镇', 341881100),
(341881101, 341881, '梅林镇', 341881101),
(341881102, 341881, '中溪镇', 341881102),
(341881103, 341881, '宁墩镇', 341881103),
(341881104, 341881, '仙霞镇', 341881104),
(341881105, 341881, '甲路镇', 341881105),
(341881106, 341881, '胡乐镇', 341881106),
(341881107, 341881, '霞西镇', 341881107),
(341881200, 341881, '云梯畲族乡', 341881200),
(341881201, 341881, '南极乡', 341881201),
(341881202, 341881, '万家乡', 341881202),
(341881203, 341881, '青龙乡', 341881203),
(341881204, 341881, '方塘乡', 341881204),
(350102001, 350102, '鼓东街道', 350102001),
(350102002, 350102, '鼓西街道', 350102002),
(350102003, 350102, '温泉街道', 350102003),
(350102004, 350102, '东街街道', 350102004),
(350102005, 350102, '南街街道', 350102005),
(350102006, 350102, '安泰街道', 350102006),
(350102007, 350102, '华大街道', 350102007),
(350102008, 350102, '水部街道', 350102008),
(350102009, 350102, '五凤街道', 350102009),
(350102100, 350102, '洪山镇', 350102100),
(350103001, 350103, '瀛洲街道', 350103001),
(350103002, 350103, '后洲街道', 350103002),
(350103003, 350103, '义洲街道', 350103003),
(350103004, 350103, '新港街道', 350103004),
(350103005, 350103, '上海街道', 350103005),
(350103007, 350103, '苍霞街道', 350103007),
(350103009, 350103, '茶亭街道', 350103009),
(350103010, 350103, '洋中街道', 350103010),
(350103011, 350103, '鳌峰街道', 350103011),
(350103012, 350103, '宁化街道', 350103012),
(350104001, 350104, '仓前街道', 350104001),
(350104002, 350104, '东升街道', 350104002),
(350104003, 350104, '对湖街道', 350104003),
(350104004, 350104, '临江街道', 350104004),
(350104005, 350104, '三叉街街道', 350104005),
(350104006, 350104, '上渡街道', 350104006),
(350104007, 350104, '下渡街道', 350104007),
(350104008, 350104, '金山街道', 350104008),
(350104100, 350104, '仓山镇', 350104100),
(350104101, 350104, '城门镇', 350104101),
(350104102, 350104, '盖山镇', 350104102),
(350104103, 350104, '建新镇', 350104103),
(350104104, 350104, '螺洲镇', 350104104),
(350104400, 350104, '红星农场', 350104400),
(350105001, 350105, '罗星街道', 350105001),
(350105100, 350105, '马尾镇', 350105100),
(350105101, 350105, '亭江镇', 350105101),
(350105102, 350105, '琅岐镇', 350105102),
(350111001, 350111, '茶园街道', 350111001),
(350111002, 350111, '王庄街道', 350111002),
(350111003, 350111, '象园街道', 350111003),
(350111100, 350111, '鼓山镇', 350111100),
(350111101, 350111, '新店镇', 350111101),
(350111102, 350111, '岳峰镇', 350111102),
(350111103, 350111, '宦溪镇', 350111103),
(350111201, 350111, '寿山乡', 350111201),
(350111202, 350111, '日溪乡', 350111202),
(350121001, 350121, '甘蔗街道', 350121001),
(350121101, 350121, '白沙镇', 350121101),
(350121102, 350121, '南屿镇', 350121102),
(350121103, 350121, '尚干镇', 350121103),
(350121104, 350121, '祥谦镇', 350121104),
(350121105, 350121, '青口镇', 350121105),
(350121106, 350121, '南通镇', 350121106),
(350121107, 350121, '上街镇', 350121107),
(350121108, 350121, '荆溪镇', 350121108),
(350121200, 350121, '竹岐乡', 350121200),
(350121201, 350121, '鸿尾乡', 350121201),
(350121202, 350121, '洋里乡', 350121202),
(350121203, 350121, '大湖乡', 350121203),
(350121204, 350121, '廷坪乡', 350121204),
(350121206, 350121, '小箬乡', 350121206),
(350121400, 350121, '江洋农场', 350121400),
(350122100, 350122, '凤城镇', 350122100),
(350122101, 350122, '敖江镇', 350122101),
(350122102, 350122, '东岱镇', 350122102),
(350122103, 350122, '琯头镇', 350122103),
(350122104, 350122, '晓澳镇', 350122104),
(350122105, 350122, '东湖镇', 350122105),
(350122106, 350122, '丹阳镇', 350122106),
(350122107, 350122, '长龙镇', 350122107),
(350122108, 350122, '透堡镇', 350122108),
(350122109, 350122, '马鼻镇', 350122109),
(350122110, 350122, '官坂镇', 350122110),
(350122111, 350122, '筱埕镇', 350122111),
(350122112, 350122, '黄岐镇', 350122112),
(350122113, 350122, '苔菉镇', 350122113),
(350122114, 350122, '浦口镇', 350122114),
(350122115, 350122, '坑园镇', 350122115),
(350122200, 350122, '潘渡乡', 350122200),
(350122201, 350122, '江南乡', 350122201),
(350122202, 350122, '蓼沿乡', 350122202),
(350122203, 350122, '安凯乡', 350122203),
(350122204, 350122, '下宫乡', 350122204),
(350122205, 350122, '小沧畲族乡', 350122205),
(350122206, 350122, '马祖乡', 350122206),
(350123100, 350123, '凤山镇', 350123100),
(350123101, 350123, '松山镇', 350123101),
(350123102, 350123, '起步镇', 350123102),
(350123103, 350123, '中房镇', 350123103),
(350123104, 350123, '飞竹镇', 350123104),
(350123105, 350123, '鉴江镇', 350123105),
(350123200, 350123, '白塔乡', 350123200),
(350123201, 350123, '洪洋乡', 350123201),
(350123202, 350123, '西兰乡', 350123202),
(350123203, 350123, '霍口畲族乡', 350123203),
(350123204, 350123, '碧里乡', 350123204),
(350123500, 350123, '罗源湾', 350123500),
(350124100, 350124, '梅城镇', 350124100),
(350124101, 350124, '梅溪镇', 350124101),
(350124102, 350124, '白樟镇', 350124102),
(350124103, 350124, '金沙镇', 350124103),
(350124104, 350124, '白中镇', 350124104),
(350124105, 350124, '池园镇', 350124105),
(350124106, 350124, '坂东镇', 350124106),
(350124107, 350124, '塔庄镇', 350124107),
(350124108, 350124, '省璜镇', 350124108),
(350124109, 350124, '雄江镇', 350124109),
(350124110, 350124, '东桥镇', 350124110),
(350124200, 350124, '云龙乡', 350124200),
(350124201, 350124, '上莲乡', 350124201),
(350124204, 350124, '三溪乡', 350124204),
(350124205, 350124, '桔林乡', 350124205),
(350124206, 350124, '下祝乡', 350124206),
(350125100, 350125, '樟城镇', 350125100),
(350125101, 350125, '嵩口镇', 350125101),
(350125102, 350125, '梧桐镇', 350125102),
(350125103, 350125, '葛岭镇', 350125103),
(350125104, 350125, '城峰镇', 350125104),
(350125105, 350125, '清凉镇', 350125105),
(350125106, 350125, '长庆镇', 350125106),
(350125107, 350125, '同安镇', 350125107),
(350125108, 350125, '大洋镇', 350125108),
(350125200, 350125, '塘前乡', 350125200),
(350125201, 350125, '富泉乡', 350125201),
(350125202, 350125, '岭路乡', 350125202),
(350125203, 350125, '赤锡乡', 350125203),
(350125204, 350125, '洑口乡', 350125204),
(350125205, 350125, '盖洋乡', 350125205),
(350125206, 350125, '东洋乡', 350125206),
(350125207, 350125, '霞拔乡', 350125207),
(350125208, 350125, '盘谷乡', 350125208),
(350125209, 350125, '红星乡', 350125209),
(350125210, 350125, '白云乡', 350125210),
(350125211, 350125, '丹云乡', 350125211),
(350128100, 350128, '潭城镇', 350128100),
(350128101, 350128, '苏澳镇', 350128101),
(350128102, 350128, '流水镇', 350128102),
(350128103, 350128, '澳前镇', 350128103),
(350128104, 350128, '北厝镇', 350128104),
(350128105, 350128, '平原镇', 350128105),
(350128106, 350128, '敖东镇', 350128106),
(350128200, 350128, '白青乡', 350128200),
(350128201, 350128, '屿头乡', 350128201),
(350128202, 350128, '大练乡', 350128202),
(350128203, 350128, '芦洋乡', 350128203),
(350128204, 350128, '中楼乡', 350128204),
(350128205, 350128, '东庠乡', 350128205),
(350128206, 350128, '岚城乡', 350128206),
(350128207, 350128, '南海乡', 350128207),
(350181002, 350181, '玉屏街道', 350181002),
(350181003, 350181, '龙山街道', 350181003),
(350181004, 350181, '龙江街道', 350181004),
(350181005, 350181, '宏路街道', 350181005),
(350181006, 350181, '石竹街道', 350181006),
(350181007, 350181, '音西街道', 350181007),
(350181008, 350181, '阳下街道', 350181008),
(350181103, 350181, '海口镇', 350181103),
(350181104, 350181, '城头镇', 350181104),
(350181105, 350181, '南岭镇', 350181105),
(350181106, 350181, '龙田镇', 350181106),
(350181107, 350181, '江镜镇', 350181107),
(350181108, 350181, '港头镇', 350181108),
(350181109, 350181, '高山镇', 350181109),
(350181110, 350181, '沙埔镇', 350181110),
(350181111, 350181, '三山镇', 350181111),
(350181112, 350181, '东瀚镇', 350181112),
(350181113, 350181, '渔溪镇', 350181113),
(350181114, 350181, '上迳镇', 350181114),
(350181115, 350181, '新厝镇', 350181115),
(350181116, 350181, '江阴镇', 350181116),
(350181117, 350181, '东张镇', 350181117),
(350181118, 350181, '镜洋镇', 350181118),
(350181119, 350181, '一都镇', 350181119),
(350181400, 350181, '*江镜华侨', 350181400),
(350181401, 350181, '*东阁华侨', 350181401),
(350182001, 350182, '吴航街道', 350182001),
(350182002, 350182, '航城街道', 350182002),
(350182003, 350182, '营前街道', 350182003),
(350182004, 350182, '漳港街道', 350182004),
(350182102, 350182, '首占镇', 350182102),
(350182103, 350182, '玉田镇', 350182103),
(350182104, 350182, '松下镇', 350182104),
(350182105, 350182, '江田镇', 350182105),
(350182106, 350182, '古槐镇', 350182106),
(350182107, 350182, '文武砂镇', 350182107),
(350182108, 350182, '鹤上镇', 350182108),
(350182110, 350182, '湖南镇', 350182110),
(350182111, 350182, '金峰镇', 350182111),
(350182112, 350182, '文岭镇', 350182112),
(350182113, 350182, '梅花镇', 350182113),
(350182114, 350182, '潭头镇', 350182114),
(350182200, 350182, '罗联乡', 350182200),
(350182201, 350182, '猴屿乡', 350182201),
(350203001, 350203, '厦港街道', 350203001),
(350203003, 350203, '中华街道', 350203003),
(350203005, 350203, '滨海街道', 350203005),
(350203006, 350203, '鹭江街道', 350203006),
(350203007, 350203, '开元街道', 350203007),
(350203008, 350203, '梧村街道', 350203008),
(350203009, 350203, '筼筜街道', 350203009),
(350203010, 350203, '莲前街道', 350203010),
(350203011, 350203, '嘉莲街道', 350203011),
(350203012, 350203, '鼓浪屿街道', 350203012),
(350203401, 350203, '*云顶岩', 350203401),
(350203402, 350203, '*农科所', 350203402),
(350203403, 350203, '*万石植物园', 350203403),
(350205001, 350205, '海沧街道', 350205001),
(350205002, 350205, '新阳街道', 350205002),
(350205103, 350205, '东孚镇', 350205103),
(350205401, 350205, '第一农场', 350205401),
(350205402, 350205, '海沧农场', 350205402),
(350205403, 350205, '天竺山林场', 350205403),
(350205405, 350205, '*新阳工业区', 350205405),
(350205406, 350205, '出口加工区', 350205406),
(350206001, 350206, '湖里街道', 350206001),
(350206002, 350206, '殿前街道', 350206002),
(350206003, 350206, '禾山街道', 350206003),
(350206004, 350206, '江头街道', 350206004),
(350206005, 350206, '金山街道', 350206005),
(350206401, 350206, '忠仑苗圃', 350206401),
(350206402, 350206, '湖边水库', 350206402),
(350206403, 350206, '高崎国际机场', 350206403),
(350206404, 350206, '前哨盐场', 350206404),
(350206405, 350206, '火炬高技术开发区', 350206405),
(350206406, 350206, '象屿保税区', 350206406),
(350211001, 350211, '集美街道', 350211001),
(350211002, 350211, '侨英街道', 350211002),
(350211003, 350211, '杏林街道', 350211003),
(350211004, 350211, '杏滨街道', 350211004),
(350211102, 350211, '灌口镇', 350211102),
(350211103, 350211, '后溪镇', 350211103),
(350211401, 350211, '第二农场', 350211401),
(350211402, 350211, '省天马种猪场', 350211402),
(350211403, 350211, '天马华侨农场', 350211403),
(350211404, 350211, '坂头防护林场', 350211404),
(350212001, 350212, '大同街道', 350212001),
(350212002, 350212, '祥平街道', 350212002),
(350212105, 350212, '莲花镇', 350212105),
(350212106, 350212, '新民镇', 350212106),
(350212107, 350212, '洪塘镇', 350212107),
(350212108, 350212, '西柯镇', 350212108),
(350212109, 350212, '汀溪镇', 350212109),
(350212110, 350212, '五显镇', 350212110),
(350212401, 350212, '*凤南农场', 350212401),
(350212402, 350212, '*白沙仑农场', 350212402),
(350212403, 350212, '*竹坝华侨农场', 350212403),
(350212404, 350212, '*汀溪水库', 350212404),
(350212405, 350212, '*祥溪林场', 350212405),
(350212406, 350212, '*汀溪防护林场', 350212406),
(350213001, 350213, '大嶝街道', 350213001),
(350213102, 350213, '马巷镇', 350213102),
(350213103, 350213, '新圩镇', 350213103),
(350213104, 350213, '新店镇', 350213104),
(350213111, 350213, '内厝镇', 350213111),
(350213404, 350213, '*大帽山农场', 350213404),
(350302001, 350302, '龙桥街道', 350302001),
(350302002, 350302, '凤凰山街道', 350302002),
(350302003, 350302, '霞林街道', 350302003),
(350302100, 350302, '常太镇', 350302100),
(350302101, 350302, '华亭镇', 350302101),
(350302102, 350302, '灵川镇', 350302102),
(350302103, 350302, '东海镇', 350302103),
(350303001, 350303, '涵东街道', 350303001),
(350303002, 350303, '涵西街道', 350303002),
(350303100, 350303, '三江口镇', 350303100),
(350303101, 350303, '白塘镇', 350303101),
(350303102, 350303, '国欢镇', 350303102),
(350303103, 350303, '梧塘镇', 350303103),
(350303104, 350303, '江口镇', 350303104),
(350303105, 350303, '萩芦镇', 350303105),
(350303106, 350303, '白沙镇', 350303106),
(350303107, 350303, '庄边镇', 350303107),
(350303108, 350303, '新县镇', 350303108),
(350303200, 350303, '大洋乡', 350303200),
(350303500, 350303, '赤港开发区', 350303500),
(350304001, 350304, '镇海街道', 350304001),
(350304002, 350304, '拱辰街道', 350304002),
(350304100, 350304, '西天尾镇', 350304100),
(350304101, 350304, '黄石镇', 350304101),
(350304102, 350304, '新度镇', 350304102),
(350304103, 350304, '北高镇', 350304103),
(350305100, 350305, '笏石镇', 350305100),
(350305101, 350305, '东庄镇', 350305101),
(350305102, 350305, '忠门镇', 350305102),
(350305103, 350305, '东埔镇', 350305103),
(350305104, 350305, '东峤镇', 350305104),
(350305105, 350305, '埭头镇', 350305105),
(350305106, 350305, '平海镇', 350305106),
(350305107, 350305, '南日镇', 350305107),
(350305108, 350305, '湄洲镇', 350305108),
(350305200, 350305, '月塘乡', 350305200),
(350305201, 350305, '山亭乡', 350305201),
(350305400, 350305, '前沁农场', 350305400),
(350305401, 350305, '莆田市后海管理局', 350305401),
(350322001, 350322, '鲤城街道', 350322001),
(350322100, 350322, '枫亭镇', 350322100),
(350322101, 350322, '榜头镇', 350322101),
(350322102, 350322, '郊尾镇', 350322102),
(350322103, 350322, '度尾镇', 350322103),
(350322104, 350322, '鲤南镇', 350322104),
(350322105, 350322, '赖店镇', 350322105),
(350322106, 350322, '盖尾镇', 350322106),
(350322107, 350322, '园庄镇', 350322107),
(350322108, 350322, '大济镇', 350322108),
(350322109, 350322, '龙华镇', 350322109),
(350322110, 350322, '钟山镇', 350322110),
(350322111, 350322, '游洋镇', 350322111),
(350322200, 350322, '西苑乡', 350322200),
(350322201, 350322, '石苍乡', 350322201),
(350322202, 350322, '社硎乡', 350322202),
(350322203, 350322, '书峰乡', 350322203),
(350322204, 350322, '象溪乡', 350322204),
(350402001, 350402, '列东街道', 350402001),
(350402002, 350402, '列西街道', 350402002),
(350402003, 350402, '徐碧街道', 350402003),
(350402100, 350402, '陈大镇', 350402100),
(350402200, 350402, '洋溪乡', 350402200),
(350402500, 350402, '福建梅列经济开发区', 350402500),
(350403001, 350403, '城关街道', 350403001),
(350403002, 350403, '白沙街道', 350403002),
(350403003, 350403, '富兴堡街道', 350403003),
(350403004, 350403, '荆西街道', 350403004),
(350403100, 350403, '莘口镇', 350403100),
(350403101, 350403, '岩前镇', 350403101),
(350403200, 350403, '城东乡', 350403200),
(350403201, 350403, '中村乡', 350403201),
(350421100, 350421, '雪峰镇', 350421100),
(350421101, 350421, '盖洋镇', 350421101),
(350421102, 350421, '胡坊镇', 350421102),
(350421103, 350421, '瀚仙镇', 350421103),
(350421200, 350421, '城关乡', 350421200),
(350421201, 350421, '沙溪乡', 350421201),
(350421202, 350421, '夏阳乡', 350421202),
(350421203, 350421, '枫溪乡', 350421203),
(350421204, 350421, '夏坊乡', 350421204),
(350423100, 350423, '龙津镇', 350423100),
(350423101, 350423, '嵩溪镇', 350423101),
(350423102, 350423, '嵩口镇', 350423102),
(350423103, 350423, '灵地镇', 350423103),
(350423104, 350423, '长校镇', 350423104),
(350423201, 350423, '温郊乡', 350423201),
(350423202, 350423, '林畲乡', 350423202),
(350423203, 350423, '田源乡', 350423203),
(350423204, 350423, '沙芜乡', 350423204),
(350423205, 350423, '赖坊乡', 350423205),
(350423206, 350423, '余朋乡', 350423206),
(350423207, 350423, '邓家乡', 350423207),
(350423208, 350423, '李家乡', 350423208),
(350423209, 350423, '里田乡', 350423209),
(350424100, 350424, '翠江镇', 350424100),
(350424101, 350424, '泉上镇', 350424101),
(350424102, 350424, '湖村镇', 350424102),
(350424103, 350424, '石壁镇', 350424103),
(350424200, 350424, '城郊乡', 350424200),
(350424201, 350424, '城南乡', 350424201),
(350424202, 350424, '济村乡', 350424202),
(350424203, 350424, '淮土乡', 350424203),
(350424204, 350424, '方田乡', 350424204),
(350424205, 350424, '安乐乡', 350424205),
(350424206, 350424, '曹坊乡', 350424206),
(350424207, 350424, '治平乡', 350424207),
(350424208, 350424, '中沙乡', 350424208),
(350424209, 350424, '河龙乡', 350424209),
(350424210, 350424, '水茜乡', 350424210),
(350424211, 350424, '安远乡', 350424211),
(350425100, 350425, '均溪镇', 350425100),
(350425101, 350425, '石牌镇', 350425101),
(350425102, 350425, '上京镇', 350425102),
(350425103, 350425, '广平镇', 350425103),
(350425104, 350425, '桃源镇', 350425104),
(350425105, 350425, '太华镇', 350425105),
(350425106, 350425, '建设镇', 350425106),
(350425107, 350425, '奇韬镇', 350425107),
(350425200, 350425, '华兴乡', 350425200),
(350425201, 350425, '屏山乡', 350425201),
(350425202, 350425, '吴山乡', 350425202),
(350425203, 350425, '济阳乡', 350425203),
(350425204, 350425, '武陵乡', 350425204),
(350425205, 350425, '谢洋乡', 350425205),
(350425206, 350425, '文江乡', 350425206),
(350425207, 350425, '梅山乡', 350425207),
(350425208, 350425, '湖美乡', 350425208),
(350425209, 350425, '前坪乡', 350425209),
(350425400, 350425, '东风农场', 350425400),
(350426100, 350426, '城关镇', 350426100),
(350426101, 350426, '梅仙镇', 350426101),
(350426102, 350426, '西滨镇', 350426102),
(350426103, 350426, '洋中镇', 350426103),
(350426104, 350426, '新阳镇', 350426104),
(350426105, 350426, '管前镇', 350426105),
(350426106, 350426, '西城镇', 350426106),
(350426107, 350426, '尤溪口镇', 350426107),
(350426200, 350426, '联合乡', 350426200),
(350426201, 350426, '汤川乡', 350426201),
(350426202, 350426, '溪尾乡', 350426202),
(350426203, 350426, '中仙乡', 350426203),
(350426204, 350426, '台溪乡', 350426204),
(350426205, 350426, '坂面乡', 350426205),
(350426206, 350426, '八字桥乡', 350426206),
(350427001, 350427, '凤岗街道', 350427001),
(350427002, 350427, '虬江街道　', 350427002),
(350427101, 350427, '青州镇', 350427101),
(350427102, 350427, '夏茂镇', 350427102),
(350427104, 350427, '高砂镇', 350427104),
(350427105, 350427, '高桥镇', 350427105),
(350427106, 350427, '富口镇', 350427106),
(350427107, 350427, '大洛镇', 350427107),
(350427201, 350427, '南霞乡', 350427201),
(350427203, 350427, '南阳乡', 350427203),
(350427204, 350427, '郑湖乡', 350427204),
(350427205, 350427, '湖源乡', 350427205),
(350428100, 350428, '古镛镇', 350428100),
(350428101, 350428, '万安镇', 350428101),
(350428102, 350428, '高唐镇', 350428102),
(350428103, 350428, '白莲镇', 350428103),
(350428104, 350428, '黄潭镇', 350428104),
(350428105, 350428, '水南镇', 350428105),
(350428200, 350428, '光明乡', 350428200),
(350428201, 350428, '漠源乡', 350428201),
(350428202, 350428, '南口乡', 350428202),
(350428203, 350428, '万全乡', 350428203),
(350428204, 350428, '安仁乡', 350428204),
(350428205, 350428, '大源乡', 350428205),
(350428206, 350428, '余坊乡', 350428206),
(350429100, 350429, '杉城镇', 350429100),
(350429101, 350429, '朱口镇', 350429101),
(350429200, 350429, '新桥乡', 350429200),
(350429201, 350429, '上青乡', 350429201),
(350429202, 350429, '大田乡', 350429202),
(350429203, 350429, '梅口乡', 350429203),
(350429204, 350429, '下渠乡', 350429204),
(350429205, 350429, '开善乡', 350429205),
(350429208, 350429, '大龙乡', 350429208),
(350430100, 350430, '濉城镇', 350430100),
(350430101, 350430, '里心镇', 350430101),
(350430102, 350430, '溪口镇', 350430102),
(350430103, 350430, '均口镇', 350430103),
(350430200, 350430, '金溪乡', 350430200),
(350430201, 350430, '伊家乡', 350430201),
(350430202, 350430, '黄坊乡', 350430202),
(350430203, 350430, '溪源乡', 350430203),
(350430204, 350430, '客坊乡', 350430204),
(350430205, 350430, '黄埠乡', 350430205),
(350481001, 350481, '燕东街道', 350481001),
(350481002, 350481, '燕西街道', 350481002),
(350481003, 350481, '燕南街道', 350481003),
(350481004, 350481, '燕北街道', 350481004),
(350481100, 350481, '西洋镇', 350481100),
(350481101, 350481, '贡川镇', 350481101),
(350481102, 350481, '安砂镇', 350481102),
(350481103, 350481, '小陶镇', 350481103),
(350481104, 350481, '大湖镇', 350481104),
(350481105, 350481, '曹远镇', 350481105),
(350481106, 350481, '洪田镇', 350481106),
(350481201, 350481, '槐南乡', 350481201),
(350481202, 350481, '上坪乡', 350481202),
(350481203, 350481, '罗坊乡', 350481203),
(350481204, 350481, '青水乡', 350481204),
(350502001, 350502, '海滨街道', 350502001),
(350502002, 350502, '临江街道', 350502002),
(350502003, 350502, '鲤中街道', 350502003),
(350502004, 350502, '开元街道', 350502004),
(350502005, 350502, '浮桥街道', 350502005),
(350502006, 350502, '江南街道', 350502006),
(350502007, 350502, '金龙街道', 350502007),
(350502008, 350502, '常泰街道', 350502008),
(350502500, 350502, '清濛经济开发区', 350502500),
(350503001, 350503, '东湖街道', 350503001),
(350503002, 350503, '丰泽街道', 350503002),
(350503003, 350503, '泉秀街道', 350503003),
(350503004, 350503, '清源街道', 350503004),
(350503005, 350503, '华大街道', 350503005),
(350503006, 350503, '城东街道', 350503006),
(350503007, 350503, '东海街道', 350503007),
(350503008, 350503, '北峰街道', 350503008),
(350504001, 350504, '万安街道', 350504001),
(350504002, 350504, '双阳街道', 350504002),
(350504100, 350504, '罗溪镇', 350504100),
(350504101, 350504, '马甲镇', 350504101),
(350504102, 350504, '河市镇', 350504102),
(350504200, 350504, '虹山乡', 350504200),
(350505001, 350505, '山腰街道', 350505001),
(350505100, 350505, '南埔镇', 350505100),
(350505101, 350505, '界山镇', 350505101),
(350505102, 350505, '后龙镇', 350505102),
(350505103, 350505, '峰尾镇', 350505103),
(350505105, 350505, '前黄镇', 350505105),
(350505106, 350505, '涂岭镇', 350505106),
(350521100, 350521, '螺城镇', 350521100),
(350521101, 350521, '螺阳镇', 350521101),
(350521102, 350521, '黄塘镇', 350521102),
(350521103, 350521, '紫山镇', 350521103),
(350521104, 350521, '洛阳镇', 350521104),
(350521105, 350521, '东园镇', 350521105),
(350521106, 350521, '张坂镇', 350521106),
(350521107, 350521, '崇武镇', 350521107),
(350521108, 350521, '山霞镇', 350521108),
(350521109, 350521, '涂寨镇', 350521109),
(350521110, 350521, '东岭镇', 350521110),
(350521111, 350521, '东桥镇', 350521111),
(350521112, 350521, '净峰镇', 350521112),
(350521113, 350521, '小岞镇', 350521113),
(350521114, 350521, '辋川镇', 350521114),
(350521200, 350521, '百崎回族乡', 350521200),
(350524100, 350524, '凤城镇', 350524100),
(350524101, 350524, '蓬莱镇', 350524101),
(350524102, 350524, '湖头镇', 350524102),
(350524103, 350524, '官桥镇', 350524103),
(350524104, 350524, '剑斗镇', 350524104),
(350524105, 350524, '城厢镇', 350524105),
(350524106, 350524, '金谷镇', 350524106),
(350524107, 350524, '龙门镇', 350524107),
(350524108, 350524, '虎邱镇', 350524108),
(350524109, 350524, '芦田镇', 350524109),
(350524110, 350524, '感德镇', 350524110),
(350524111, 350524, '魁斗镇', 350524111),
(350524112, 350524, '西坪镇', 350524112),
(350524200, 350524, '参内乡', 350524200),
(350524201, 350524, '白濑乡', 350524201),
(350524202, 350524, '湖上乡', 350524202),
(350524203, 350524, '尚卿乡', 350524203),
(350524204, 350524, '大坪乡', 350524204),
(350524205, 350524, '龙涓乡', 350524205),
(350524206, 350524, '长坑乡', 350524206),
(350524207, 350524, '蓝田乡', 350524207),
(350524208, 350524, '祥华乡', 350524208),
(350524209, 350524, '桃舟乡', 350524209),
(350524210, 350524, '福田乡', 350524210),
(350525100, 350525, '桃城镇', 350525100),
(350525101, 350525, '五里街镇', 350525101),
(350525102, 350525, '一都镇', 350525102),
(350525103, 350525, '下洋镇', 350525103),
(350525104, 350525, '蓬壶镇', 350525104),
(350525105, 350525, '达埔镇', 350525105),
(350525106, 350525, '吾峰镇', 350525106),
(350525107, 350525, '石鼓镇', 350525107),
(350525108, 350525, '岵山镇', 350525108),
(350525109, 350525, '东平镇', 350525109),
(350525110, 350525, '湖洋镇', 350525110),
(350525111, 350525, '坑仔口镇', 350525111),
(350525112, 350525, '玉斗镇', 350525112),
(350525113, 350525, '锦斗镇', 350525113),
(350525114, 350525, '东关镇', 350525114),
(350525115, 350525, '桂洋镇', 350525115),
(350525116, 350525, '苏坑镇', 350525116),
(350525117, 350525, '仙夹镇', 350525117),
(350525200, 350525, '横口乡', 350525200),
(350525201, 350525, '呈祥乡', 350525201),
(350525202, 350525, '介福乡', 350525202),
(350525204, 350525, '外山乡', 350525204),
(350526100, 350526, '浔中镇', 350526100),
(350526101, 350526, '龙浔镇', 350526101),
(350526102, 350526, '三班镇', 350526102),
(350526103, 350526, '龙门滩镇', 350526103),
(350526104, 350526, '雷峰镇', 350526104),
(350526105, 350526, '南埕镇', 350526105),
(350526106, 350526, '水口镇', 350526106),
(350526107, 350526, '赤水镇', 350526107),
(350526108, 350526, '上涌镇', 350526108),
(350526109, 350526, '葛坑镇', 350526109),
(350526200, 350526, '杨梅乡', 350526200),
(350526202, 350526, '汤头乡', 350526202),
(350526204, 350526, '桂阳乡', 350526204),
(350526205, 350526, '盖德乡', 350526205),
(350526206, 350526, '国宝乡', 350526206),
(350526207, 350526, '美湖乡', 350526207),
(350526208, 350526, '大铭乡', 350526208),
(350526209, 350526, '春美乡', 350526209),
(350581001, 350581, '湖滨街道', 350581001),
(350581002, 350581, '凤里街道', 350581002),
(350581100, 350581, '灵秀镇', 350581100),
(350581101, 350581, '宝盖镇', 350581101),
(350581102, 350581, '蚶江镇', 350581102),
(350581103, 350581, '祥芝镇', 350581103),
(350581104, 350581, '鸿山镇', 350581104),
(350581105, 350581, '锦尚镇', 350581105),
(350581106, 350581, '永宁镇', 350581106),
(350582001, 350582, '青阳街道', 350582001),
(350582002, 350582, '梅岭街道', 350582002),
(350582003, 350582, '西园街道', 350582003),
(350582004, 350582, '罗山街道', 350582004),
(350582005, 350582, '新塘街道', 350582005),
(350582006, 350582, '灵源街道', 350582006),
(350582101, 350582, '安海镇', 350582101),
(350582102, 350582, '磁灶镇', 350582102),
(350582103, 350582, '陈埭镇', 350582103),
(350582104, 350582, '东石镇', 350582104),
(350582105, 350582, '深沪镇', 350582105),
(350582106, 350582, '金井镇', 350582106),
(350582107, 350582, '池店镇', 350582107),
(350582109, 350582, '内坑镇', 350582109),
(350582110, 350582, '龙湖镇', 350582110),
(350582111, 350582, '永和镇', 350582111),
(350582112, 350582, '英林镇', 350582112),
(350582113, 350582, '紫帽镇', 350582113),
(350582114, 350582, '西滨镇', 350582114),
(350582498, 350582, '*晋江市国营良种繁殖场', 350582498),
(350582500, 350582, '*安平开发区', 350582500),
(350582501, 350582, '*五里工业区', 350582501),
(350583001, 350583, '溪美街道', 350583001),
(350583002, 350583, '柳城街道', 350583002),
(350583003, 350583, '美林街道', 350583003),
(350583100, 350583, '省新镇', 350583100),
(350583101, 350583, '仑苍镇', 350583101),
(350583102, 350583, '东田镇', 350583102),
(350583103, 350583, '英都镇', 350583103),
(350583104, 350583, '翔云镇', 350583104),
(350583105, 350583, '金淘镇', 350583105),
(350583106, 350583, '诗山镇', 350583106),
(350583107, 350583, '蓬华镇', 350583107),
(350583108, 350583, '码头镇', 350583108),
(350583109, 350583, '九都镇', 350583109),
(350583110, 350583, '乐峰镇', 350583110),
(350583111, 350583, '罗东镇', 350583111),
(350583112, 350583, '梅山镇', 350583112),
(350583113, 350583, '洪濑镇', 350583113),
(350583114, 350583, '洪梅镇', 350583114),
(350583115, 350583, '康美镇', 350583115),
(350583116, 350583, '丰州镇', 350583116),
(350583117, 350583, '霞美镇', 350583117),
(350583118, 350583, '官桥镇', 350583118),
(350583119, 350583, '水头镇', 350583119),
(350583120, 350583, '石井镇', 350583120),
(350583200, 350583, '眉山乡', 350583200),
(350583201, 350583, '向阳乡', 350583201),
(350583500, 350583, '雪峰管委会', 350583500),
(350602001, 350602, '东铺头街道', 350602001),
(350602002, 350602, '西桥街道', 350602002),
(350602003, 350602, '新桥街道', 350602003),
(350602004, 350602, '巷口街道', 350602004),
(350602005, 350602, '南坑街道', 350602005),
(350602006, 350602, '通北街道', 350602006),
(350602100, 350602, '浦南镇', 350602100),
(350602101, 350602, '天宝镇', 350602101),
(350602102, 350602, '芝山镇', 350602102),
(350602103, 350602, '石亭镇', 350602103),
(350602400, 350602, '*芗城区奶牛场', 350602400),
(350602401, 350602, '*后房农场', 350602401),
(350602402, 350602, '*天宝林场', 350602402),
(350602403, 350602, '*大房农场', 350602403),
(350602404, 350602, '*五峰农场', 350602404),
(350603100, 350603, '蓝田镇', 350603100),
(350603101, 350603, '步文镇', 350603101),
(350603102, 350603, '朝阳镇', 350603102),
(350603103, 350603, '郭坑镇', 350603103),
(350603500, 350603, '蓝田开发区管委会', 350603500),
(350622100, 350622, '云陵镇', 350622100),
(350622101, 350622, '陈岱镇', 350622101),
(350622102, 350622, '东厦镇', 350622102),
(350622103, 350622, '莆美镇', 350622103),
(350622104, 350622, '列屿镇', 350622104),
(350622105, 350622, '火田镇', 350622105),
(350622200, 350622, '下河乡', 350622200),
(350622201, 350622, '马铺乡', 350622201),
(350622202, 350622, '和平乡', 350622202),
(350622400, 350622, '*和平农场', 350622400),
(350622500, 350622, '*常山华侨经济开发区', 350622500),
(350623100, 350623, '绥安镇', 350623100),
(350623101, 350623, '旧镇镇', 350623101),
(350623102, 350623, '佛昙镇', 350623102),
(350623103, 350623, '赤湖镇', 350623103),
(350623104, 350623, '杜浔镇', 350623104),
(350623105, 350623, '霞美镇', 350623105),
(350623106, 350623, '官浔镇', 350623106),
(350623107, 350623, '石榴镇', 350623107),
(350623108, 350623, '盘陀镇', 350623108),
(350623109, 350623, '长桥镇', 350623109),
(350623110, 350623, '前亭镇', 350623110),
(350623111, 350623, '马坪镇', 350623111),
(350623112, 350623, '深土镇', 350623112),
(350623113, 350623, '六鳌镇', 350623113),
(350623114, 350623, '沙西镇', 350623114),
(350623115, 350623, '古雷镇', 350623115),
(350623116, 350623, '大南坂镇', 350623116),
(350623200, 350623, '南浦乡', 350623200),
(350623201, 350623, '赤岭畲族乡', 350623201),
(350623202, 350623, '湖西畲族乡', 350623202),
(350623203, 350623, '赤土乡', 350623203),
(350623400, 350623, '*漳浦盐场', 350623400),
(350623401, 350623, '*万安农场', 350623401),
(350623402, 350623, '石古农场', 350623402),
(350623403, 350623, '长桥农场', 350623403),
(350623404, 350623, '白竹湖农场', 350623404),
(350623405, 350623, '南山华侨茶果场', 350623405),
(350623406, 350623, '中西林场', 350623406),
(350623407, 350623, '玳瑁山茶场', 350623407),
(350623408, 350623, '下蔡林场', 350623408),
(350624100, 350624, '南诏镇', 350624100),
(350624101, 350624, '四都镇', 350624101),
(350624102, 350624, '梅岭镇', 350624102),
(350624103, 350624, '桥东镇', 350624103),
(350624104, 350624, '深桥镇', 350624104),
(350624105, 350624, '太平镇', 350624105),
(350624106, 350624, '霞葛镇', 350624106),
(350624107, 350624, '官陂镇', 350624107),
(350624108, 350624, '秀篆镇', 350624108),
(350624200, 350624, '金星乡', 350624200),
(350624201, 350624, '西潭乡', 350624201),
(350624202, 350624, '白洋乡', 350624202),
(350624203, 350624, '建设乡', 350624203),
(350624204, 350624, '红星乡', 350624204),
(350624205, 350624, '梅洲乡', 350624205),
(350624401, 350624, '国营西山农场', 350624401),
(350624402, 350624, '国营湖内林场', 350624402),
(350624403, 350624, '岭下溪国有防护林场', 350624403),
(350624500, 350624, '*边贸旅游区管委会', 350624500),
(350624501, 350624, '*闽粤边界开发区管委会', 350624501),
(350625100, 350625, '武安镇', 350625100),
(350625101, 350625, '岩溪镇', 350625101),
(350625102, 350625, '陈巷镇', 350625102),
(350625103, 350625, '枋洋镇', 350625103),
(350625200, 350625, '坂里乡', 350625200),
(350625400, 350625, '*古农农场', 350625400),
(350625500, 350625, '*长泰经济开发区', 350625500),
(350625501, 350625, '*马洋溪旅游区', 350625501),
(350625502, 350625, '*林墩民营经济区', 350625502),
(350626100, 350626, '西埔镇', 350626100),
(350626101, 350626, '樟塘镇', 350626101),
(350626102, 350626, '康美镇', 350626102),
(350626103, 350626, '杏陈镇', 350626103),
(350626104, 350626, '陈城镇', 350626104),
(350626105, 350626, '前楼镇', 350626105),
(350626450, 350626, '铜陵镇', 350626450),
(350627100, 350627, '山城镇', 350627100),
(350627101, 350627, '丰田镇', 350627101),
(350627102, 350627, '靖城镇', 350627102),
(350627103, 350627, '龙山镇', 350627103),
(350627104, 350627, '金山镇', 350627104),
(350627105, 350627, '和溪镇', 350627105),
(350627106, 350627, '奎洋镇', 350627106),
(350627107, 350627, '梅林镇', 350627107),
(350627108, 350627, '书洋镇', 350627108),
(350627109, 350627, '船场镇', 350627109),
(350627110, 350627, '南坑镇', 350627110),
(350628100, 350628, '小溪镇', 350628100),
(350628101, 350628, '山格镇', 350628101),
(350628102, 350628, '文峰镇', 350628102),
(350628103, 350628, '南胜镇', 350628103),
(350628104, 350628, '坂仔镇', 350628104),
(350628105, 350628, '安厚镇', 350628105),
(350628106, 350628, '大溪镇', 350628106),
(350628107, 350628, '霞寨镇', 350628107),
(350628108, 350628, '九峰镇', 350628108),
(350628109, 350628, '芦溪镇', 350628109),
(350628200, 350628, '五寨乡', 350628200),
(350628201, 350628, '国强乡', 350628201),
(350628202, 350628, '崎岭乡', 350628202),
(350628203, 350628, '长乐乡', 350628203),
(350628204, 350628, '秀峰乡', 350628204),
(350628400, 350628, '安厚农场', 350628400),
(350629100, 350629, '华丰镇', 350629100),
(350629101, 350629, '丰山镇', 350629101),
(350629102, 350629, '沙建镇', 350629102),
(350629103, 350629, '新圩镇', 350629103),
(350629104, 350629, '高安镇', 350629104),
(350629105, 350629, '仙都镇', 350629105),
(350629200, 350629, '高车乡', 350629200),
(350629201, 350629, '马坑乡', 350629201),
(350629203, 350629, '湖林乡', 350629203),
(350681100, 350681, '石码镇', 350681100),
(350681101, 350681, '海澄镇', 350681101),
(350681102, 350681, '角美镇', 350681102),
(350681103, 350681, '白水镇', 350681103),
(350681104, 350681, '浮宫镇', 350681104),
(350681105, 350681, '程溪镇', 350681105),
(350681106, 350681, '港尾镇', 350681106),
(350681107, 350681, '九湖镇', 350681107),
(350681108, 350681, '颜厝镇', 350681108),
(350681109, 350681, '榜山镇', 350681109),
(350681110, 350681, '紫泥镇', 350681110),
(350681111, 350681, '东园镇', 350681111),
(350681200, 350681, '东泗乡', 350681200),
(350681201, 350681, '隆教畲族乡', 350681201),
(350681400, 350681, '*双第华侨农场', 350681400),
(350681401, 350681, '*九龙岭林场', 350681401),
(350681402, 350681, '*程溪农场', 350681402),
(350681403, 350681, '*良种场', 350681403),
(350681404, 350681, '*苍坂农场', 350681404),
(350681405, 350681, '*林下林场', 350681405),
(350681500, 350681, '*角美工业开发区', 350681500),
(350681501, 350681, '*招商局漳州开发区', 350681501),
(350681502, 350681, '*东园开发区', 350681502),
(350681503, 350681, '*龙池开发区', 350681503),
(350702001, 350702, '梅山街道', 350702001),
(350702002, 350702, '黄墩街道', 350702002),
(350702003, 350702, '紫云街道', 350702003),
(350702004, 350702, '四鹤街道', 350702004),
(350702005, 350702, '水南街道', 350702005),
(350702006, 350702, '水东街道', 350702006),
(350702100, 350702, '来舟镇', 350702100),
(350702101, 350702, '樟湖镇', 350702101),
(350702102, 350702, '夏道镇', 350702102),
(350702103, 350702, '西芹镇', 350702103),
(350702104, 350702, '峡阳镇', 350702104),
(350702105, 350702, '南山镇', 350702105),
(350702106, 350702, '大横镇', 350702106),
(350702107, 350702, '王台镇', 350702107),
(350702108, 350702, '太平镇', 350702108),
(350702109, 350702, '塔前镇', 350702109),
(350702110, 350702, '茫荡镇', 350702110),
(350702111, 350702, '洋后镇', 350702111),
(350702112, 350702, '炉下镇', 350702112),
(350702200, 350702, '巨口乡', 350702200),
(350702202, 350702, '赤门乡', 350702202),
(350721001, 350721, '双溪街道', 350721001),
(350721100, 350721, '建西镇', 350721100),
(350721101, 350721, '洋口镇', 350721101),
(350721102, 350721, '元坑镇', 350721102),
(350721103, 350721, '埔上镇', 350721103),
(350721104, 350721, '大历镇', 350721104),
(350721105, 350721, '大干镇', 350721105),
(350721106, 350721, '仁寿镇', 350721106),
(350721200, 350721, '洋墩乡', 350721200),
(350721201, 350721, '郑坊乡', 350721201),
(350721202, 350721, '岚下乡', 350721202),
(350721203, 350721, '高阳乡', 350721203),
(350722001, 350722, '南浦街道', 350722001),
(350722002, 350722, '河滨街道', 350722002),
(350722101, 350722, '富岭镇', 350722101),
(350722102, 350722, '石陂镇', 350722102),
(350722103, 350722, '临江镇', 350722103),
(350722104, 350722, '仙阳镇', 350722104),
(350722105, 350722, '水北街镇', 350722105),
(350722106, 350722, '永兴镇', 350722106),
(350722107, 350722, '忠信镇', 350722107),
(350722108, 350722, '莲塘镇', 350722108),
(350722109, 350722, '九牧镇', 350722109),
(350722200, 350722, '万安乡', 350722200),
(350722201, 350722, '古楼乡', 350722201),
(350722202, 350722, '山下乡', 350722202),
(350722203, 350722, '枫溪乡', 350722203),
(350722204, 350722, '濠村乡', 350722204),
(350722205, 350722, '管厝乡', 350722205),
(350722206, 350722, '盘亭乡', 350722206),
(350722207, 350722, '官路乡', 350722207),
(350722400, 350722, '水南农场', 350722400),
(350723100, 350723, '杭川镇', 350723100),
(350723101, 350723, '寨里镇', 350723101),
(350723102, 350723, '止马镇', 350723102),
(350723200, 350723, '鸾风乡', 350723200),
(350723201, 350723, '崇仁乡', 350723201),
(350723202, 350723, '李坊乡', 350723202),
(350723203, 350723, '华桥乡', 350723203),
(350723204, 350723, '司前乡', 350723204),
(350724100, 350724, '松源镇', 350724100),
(350724101, 350724, '郑墩镇', 350724101),
(350724102, 350724, '渭田镇', 350724102),
(350724200, 350724, '河东乡', 350724200),
(350724201, 350724, '茶平乡', 350724201),
(350724202, 350724, '旧县乡', 350724202),
(350724203, 350724, '溪东乡', 350724203),
(350724204, 350724, '花桥乡', 350724204),
(350724205, 350724, '祖墩乡', 350724205),
(350725100, 350725, '熊山镇', 350725100),
(350725101, 350725, '东平镇', 350725101),
(350725102, 350725, '石屯镇', 350725102),
(350725103, 350725, '铁山镇', 350725103),
(350725104, 350725, '"镇前镇', 350725104),
(350725200, 350725, '星溪乡', 350725200),
(350725201, 350725, '外屯乡', 350725201),
(350725202, 350725, '"杨源乡', 350725202),
(350725203, 350725, '"澄源乡', 350725203),
(350725204, 350725, '"岭腰乡', 350725204),
(350781001, 350781, '昭阳街道', 350781001),
(350781002, 350781, '通泰街道', 350781002),
(350781003, 350781, '水北街道', 350781003),
(350781004, 350781, '晒口街道', 350781004),
(350781100, 350781, '城郊镇', 350781100),
(350781101, 350781, '水北镇', 350781101),
(350781102, 350781, '下沙镇', 350781102),
(350781103, 350781, '卫闽镇', 350781103),
(350781104, 350781, '沿山镇', 350781104),
(350781105, 350781, '拿口镇', 350781105),
(350781106, 350781, '洪墩镇', 350781106),
(350781107, 350781, '大埠岗镇', 350781107),
(350781108, 350781, '和平镇', 350781108),
(350781109, 350781, '肖家坊镇', 350781109),
(350781110, 350781, '大竹镇', 350781110),
(350781111, 350781, '吴家塘镇', 350781111),
(350781200, 350781, '桂林乡', 350781200),
(350781201, 350781, '张厝乡', 350781201),
(350781202, 350781, '金坑乡', 350781202),
(350781400, 350781, '综合农场', 350781400),
(350782001, 350782, '崇安街道', 350782001),
(350782002, 350782, '新丰街道', 350782002),
(350782003, 350782, '武夷街道', 350782003),
(350782100, 350782, '星村镇', 350782100),
(350782101, 350782, '兴田镇', 350782101),
(350782102, 350782, '五夫镇', 350782102),
(350782200, 350782, '上梅乡', 350782200),
(350782201, 350782, '吴屯乡', 350782201),
(350782202, 350782, '岚谷乡', 350782202),
(350782203, 350782, '洋庄乡', 350782203),
(350783001, 350783, '建安街道', 350783001),
(350783002, 350783, '通济街道', 350783002),
(350783003, 350783, '瓯宁街道', 350783003),
(350783004, 350783, '芝山街道', 350783004),
(350783100, 350783, '徐墩镇', 350783100),
(350783101, 350783, '吉阳镇', 350783101),
(350783102, 350783, '房道镇', 350783102),
(350783103, 350783, '南雅镇', 350783103),
(350783104, 350783, '迪口镇', 350783104),
(350783105, 350783, '小桥镇', 350783105),
(350783106, 350783, '玉山镇', 350783106),
(350783107, 350783, '东游镇', 350783107),
(350783108, 350783, '东峰镇', 350783108),
(350783109, 350783, '小松镇', 350783109),
(350783200, 350783, '顺阳乡', 350783200),
(350783201, 350783, '水源乡', 350783201),
(350783202, 350783, '川石乡', 350783202),
(350783203, 350783, '龙村乡', 350783203),
(350784001, 350784, '潭城街道', 350784001),
(350784002, 350784, '童游街道', 350784002),
(350784102, 350784, '将口镇', 350784102);
INSERT INTO `{pre}areas` VALUES
(350784103, 350784, '徐市镇', 350784103),
(350784104, 350784, '莒口镇', 350784104),
(350784105, 350784, '麻沙镇', 350784105),
(350784106, 350784, '黄坑镇', 350784106),
(350784107, 350784, '水吉镇', 350784107),
(350784108, 350784, '漳墩镇', 350784108),
(350784109, 350784, '小湖镇', 350784109),
(350784200, 350784, '崇雒乡', 350784200),
(350784201, 350784, '书坊乡', 350784201),
(350784202, 350784, '回龙乡', 350784202),
(350802001, 350802, '东城街道', 350802001),
(350802002, 350802, '南城街道', 350802002),
(350802003, 350802, '西城街道', 350802003),
(350802004, 350802, '中城街道', 350802004),
(350802005, 350802, '西陂街道', 350802005),
(350802006, 350802, '曹溪街道', 350802006),
(350802007, 350802, '东肖街道', 350802007),
(350802008, 350802, '龙门街道', 350802008),
(350802009, 350802, '铁山街道', 350802009),
(350802100, 350802, '红坊镇', 350802100),
(350802101, 350802, '适中镇', 350802101),
(350802102, 350802, '雁石镇', 350802102),
(350802103, 350802, '白沙镇', 350802103),
(350802104, 350802, '万安镇', 350802104),
(350802105, 350802, '大池镇', 350802105),
(350802106, 350802, '小池镇', 350802106),
(350802200, 350802, '江山乡', 350802200),
(350802201, 350802, '岩山乡', 350802201),
(350802202, 350802, '苏坂乡', 350802202),
(350821100, 350821, '汀州镇', 350821100),
(350821101, 350821, '大同镇', 350821101),
(350821102, 350821, '古城镇', 350821102),
(350821103, 350821, '新桥镇', 350821103),
(350821104, 350821, '馆前镇', 350821104),
(350821105, 350821, '童坊镇', 350821105),
(350821106, 350821, '河田镇', 350821106),
(350821107, 350821, '南山镇', 350821107),
(350821108, 350821, '濯田镇', 350821108),
(350821109, 350821, '四都镇', 350821109),
(350821110, 350821, '涂坊镇', 350821110),
(350821200, 350821, '策武乡', 350821200),
(350821201, 350821, '铁长乡', 350821201),
(350821202, 350821, '庵杰乡', 350821202),
(350821203, 350821, '三洲乡', 350821203),
(350821204, 350821, '宣成乡', 350821204),
(350821205, 350821, '红山乡', 350821205),
(350821206, 350821, '羊牯乡', 350821206),
(350822100, 350822, '凤城镇', 350822100),
(350822101, 350822, '坎市镇', 350822101),
(350822102, 350822, '下洋镇', 350822102),
(350822103, 350822, '湖雷镇', 350822103),
(350822104, 350822, '高陂镇', 350822104),
(350822105, 350822, '抚市镇', 350822105),
(350822106, 350822, '湖坑镇', 350822106),
(350822107, 350822, '培丰镇', 350822107),
(350822108, 350822, '龙潭镇', 350822108),
(350822109, 350822, '峰市镇', 350822109),
(350822200, 350822, '城郊乡', 350822200),
(350822201, 350822, '西溪乡', 350822201),
(350822202, 350822, '金砂乡', 350822202),
(350822203, 350822, '仙师乡', 350822203),
(350822204, 350822, '洪山乡', 350822204),
(350822205, 350822, '湖山乡', 350822205),
(350822206, 350822, '岐岭乡', 350822206),
(350822207, 350822, '古竹乡', 350822207),
(350822208, 350822, '堂堡乡', 350822208),
(350822209, 350822, '合溪乡', 350822209),
(350822210, 350822, '虎岗乡', 350822210),
(350822211, 350822, '大溪乡', 350822211),
(350822212, 350822, '陈东乡', 350822212),
(350822213, 350822, '高头乡', 350822213),
(350823100, 350823, '临江镇', 350823100),
(350823101, 350823, '临城镇', 350823101),
(350823102, 350823, '中都镇', 350823102),
(350823103, 350823, '蓝溪镇', 350823103),
(350823104, 350823, '稔田镇', 350823104),
(350823105, 350823, '白砂镇', 350823105),
(350823106, 350823, '古田镇', 350823106),
(350823107, 350823, '才溪镇', 350823107),
(350823108, 350823, '南阳镇', 350823108),
(350823200, 350823, '湖洋乡', 350823200),
(350823201, 350823, '下都乡', 350823201),
(350823202, 350823, '庐丰畲族乡', 350823202),
(350823203, 350823, '太拔乡', 350823203),
(350823204, 350823, '溪口乡', 350823204),
(350823205, 350823, '茶地乡', 350823205),
(350823206, 350823, '泮境乡', 350823206),
(350823207, 350823, '蛟洋乡', 350823207),
(350823208, 350823, '步云乡', 350823208),
(350823209, 350823, '旧县乡', 350823209),
(350823210, 350823, '通贤乡', 350823210),
(350823211, 350823, '官庄畲族乡', 350823211),
(350823212, 350823, '珊瑚乡', 350823212),
(350824100, 350824, '平川镇', 350824100),
(350824101, 350824, '中山镇', 350824101),
(350824102, 350824, '岩前镇', 350824102),
(350824103, 350824, '十方镇', 350824103),
(350824104, 350824, '中堡镇', 350824104),
(350824105, 350824, '桃溪镇', 350824105),
(350824200, 350824, '城厢乡', 350824200),
(350824201, 350824, '万安乡', 350824201),
(350824202, 350824, '东留乡', 350824202),
(350824203, 350824, '民主乡', 350824203),
(350824204, 350824, '下坝乡', 350824204),
(350824205, 350824, '中赤乡', 350824205),
(350824206, 350824, '象洞乡', 350824206),
(350824207, 350824, '武东乡', 350824207),
(350824208, 350824, '永平乡', 350824208),
(350824209, 350824, '湘店乡', 350824209),
(350824210, 350824, '大禾乡', 350824210),
(350825100, 350825, '莲峰镇', 350825100),
(350825101, 350825, '北团镇', 350825101),
(350825102, 350825, '姑田镇', 350825102),
(350825103, 350825, '朋口镇', 350825103),
(350825104, 350825, '莒溪镇', 350825104),
(350825105, 350825, '新泉镇', 350825105),
(350825106, 350825, '庙前镇', 350825106),
(350825200, 350825, '揭乐乡', 350825200),
(350825201, 350825, '塘前乡', 350825201),
(350825202, 350825, '隔川乡', 350825202),
(350825203, 350825, '四堡乡', 350825203),
(350825204, 350825, '罗坊乡', 350825204),
(350825205, 350825, '林坊乡', 350825205),
(350825206, 350825, '文亨乡', 350825206),
(350825208, 350825, '曲溪乡', 350825208),
(350825209, 350825, '赖源乡', 350825209),
(350825210, 350825, '宣和乡', 350825210),
(350881001, 350881, '菁城街道', 350881001),
(350881002, 350881, '桂林街道', 350881002),
(350881100, 350881, '新桥镇', 350881100),
(350881101, 350881, '双洋镇', 350881101),
(350881102, 350881, '永福镇', 350881102),
(350881103, 350881, '溪南镇', 350881103),
(350881104, 350881, '和平镇', 350881104),
(350881105, 350881, '拱桥镇', 350881105),
(350881106, 350881, '象湖镇', 350881106),
(350881107, 350881, '赤水镇', 350881107),
(350881200, 350881, '芦芝乡', 350881200),
(350881201, 350881, '西园乡', 350881201),
(350881202, 350881, '南洋乡', 350881202),
(350881203, 350881, '官田乡', 350881203),
(350881204, 350881, '吾祠乡', 350881204),
(350881205, 350881, '灵地乡', 350881205),
(350902001, 350902, '蕉南街道', 350902001),
(350902002, 350902, '蕉北街道', 350902002),
(350902100, 350902, '城南镇', 350902100),
(350902101, 350902, '漳湾镇', 350902101),
(350902102, 350902, '七都镇', 350902102),
(350902103, 350902, '八都镇', 350902103),
(350902104, 350902, '九都镇', 350902104),
(350902105, 350902, '霍童镇', 350902105),
(350902106, 350902, '赤溪镇', 350902106),
(350902107, 350902, '洋中镇', 350902107),
(350902108, 350902, '飞鸾镇', 350902108),
(350902109, 350902, '三都镇', 350902109),
(350902200, 350902, '金涵畲族乡', 350902200),
(350902201, 350902, '洪口乡', 350902201),
(350902202, 350902, '石后乡', 350902202),
(350902203, 350902, '虎贝乡', 350902203),
(350902500, 350902, '*东侨开发区', 350902500),
(350921001, 350921, '松城街道', 350921001),
(350921002, 350921, '松港街道', 350921002),
(350921101, 350921, '长春镇', 350921101),
(350921102, 350921, '牙城镇', 350921102),
(350921103, 350921, '溪南镇', 350921103),
(350921104, 350921, '沙江镇', 350921104),
(350921105, 350921, '下浒镇', 350921105),
(350921106, 350921, '三沙镇', 350921106),
(350921200, 350921, '盐田畲族乡', 350921200),
(350921201, 350921, '水门畲族乡', 350921201),
(350921202, 350921, '崇儒畲族乡', 350921202),
(350921203, 350921, '柏洋乡', 350921203),
(350921204, 350921, '北壁乡', 350921204),
(350921205, 350921, '海岛乡', 350921205),
(350922001, 350922, '城东街道', 350922001),
(350922002, 350922, '城西街道', 350922002),
(350922101, 350922, '平湖镇', 350922101),
(350922102, 350922, '大桥镇', 350922102),
(350922103, 350922, '黄田镇', 350922103),
(350922104, 350922, '鹤塘镇', 350922104),
(350922105, 350922, '杉洋镇', 350922105),
(350922106, 350922, '凤都镇', 350922106),
(350922107, 350922, '水口镇', 350922107),
(350922201, 350922, '吉巷乡', 350922201),
(350922203, 350922, '泮洋乡', 350922203),
(350922204, 350922, '凤埔乡', 350922204),
(350922205, 350922, '卓洋乡', 350922205),
(350922206, 350922, '大甲乡', 350922206),
(350923100, 350923, '古峰镇', 350923100),
(350923101, 350923, '双溪镇', 350923101),
(350923102, 350923, '黛溪镇', 350923102),
(350923103, 350923, '长桥镇', 350923103),
(350923200, 350923, '屏城乡', 350923200),
(350923201, 350923, '棠口乡', 350923201),
(350923202, 350923, '甘棠乡', 350923202),
(350923203, 350923, '熙岭乡', 350923203),
(350923204, 350923, '路下乡', 350923204),
(350923205, 350923, '寿山乡', 350923205),
(350923206, 350923, '岭下乡', 350923206),
(350924100, 350924, '鳌阳镇', 350924100),
(350924101, 350924, '斜滩镇', 350924101),
(350924102, 350924, '南阳镇', 350924102),
(350924103, 350924, '武曲镇', 350924103),
(350924200, 350924, '大安乡', 350924200),
(350924201, 350924, '坑底乡', 350924201),
(350924202, 350924, '清源乡', 350924202),
(350924203, 350924, '竹管垅乡', 350924203),
(350924204, 350924, '犀溪乡', 350924204),
(350924205, 350924, '芹洋乡', 350924205),
(350924206, 350924, '托溪乡', 350924206),
(350924207, 350924, '平溪乡', 350924207),
(350924208, 350924, '凤阳乡', 350924208),
(350924209, 350924, '下党乡', 350924209),
(350925100, 350925, '狮城镇', 350925100),
(350925101, 350925, '咸村镇', 350925101),
(350925102, 350925, '浦源镇', 350925102),
(350925103, 350925, '七步镇', 350925103),
(350925104, 350925, '李墩镇', 350925104),
(350925105, 350925, '纯池镇', 350925105),
(350925200, 350925, '泗桥乡', 350925200),
(350925201, 350925, '礼门乡', 350925201),
(350925202, 350925, '玛坑乡', 350925202),
(350926100, 350926, '双城镇', 350926100),
(350926101, 350926, '富溪镇', 350926101),
(350926200, 350926, '城郊乡', 350926200),
(350926201, 350926, '乍洋乡', 350926201),
(350926202, 350926, '东源乡', 350926202),
(350926203, 350926, '黄柏乡', 350926203),
(350926204, 350926, '宅中乡', 350926204),
(350926205, 350926, '楮坪乡', 350926205),
(350926206, 350926, '英山乡', 350926206),
(350981001, 350981, '城南街道', 350981001),
(350981002, 350981, '城北街道', 350981002),
(350981003, 350981, '阳头街道', 350981003),
(350981100, 350981, '赛岐镇', 350981100),
(350981101, 350981, '穆阳镇', 350981101),
(350981102, 350981, '上白石镇', 350981102),
(350981103, 350981, '潭头镇', 350981103),
(350981104, 350981, '社口镇', 350981104),
(350981105, 350981, '晓阳镇', 350981105),
(350981106, 350981, '溪潭镇', 350981106),
(350981107, 350981, '甘棠镇', 350981107),
(350981108, 350981, '下白石镇', 350981108),
(350981109, 350981, '溪尾镇', 350981109),
(350981110, 350981, '溪柄镇', 350981110),
(350981200, 350981, '城阳乡', 350981200),
(350981201, 350981, '坂中畲族乡', 350981201),
(350981202, 350981, '范坑乡', 350981202),
(350981203, 350981, '穆云畲族乡', 350981203),
(350981204, 350981, '康厝畲族乡', 350981204),
(350981205, 350981, '湾坞乡', 350981205),
(350981206, 350981, '松罗乡', 350981206),
(350981500, 350981, '*赛岐开发区', 350981500),
(350981501, 350981, '*福安畲族开发区', 350981501),
(350981502, 350981, '*湾坞工业集中区', 350981502),
(350982001, 350982, '桐山街道', 350982001),
(350982002, 350982, '桐城街道', 350982002),
(350982003, 350982, '山前街道', 350982003),
(350982100, 350982, '贯岭镇', 350982100),
(350982101, 350982, '前岐镇', 350982101),
(350982102, 350982, '沙埕镇', 350982102),
(350982103, 350982, '店下镇', 350982103),
(350982104, 350982, '秦屿镇', 350982104),
(350982105, 350982, '磻溪镇', 350982105),
(350982106, 350982, '白琳镇', 350982106),
(350982107, 350982, '点头镇', 350982107),
(350982108, 350982, '管阳镇', 350982108),
(350982109, 350982, '嵛山镇', 350982109),
(350982200, 350982, '硖门畲族乡', 350982200),
(350982201, 350982, '叠石乡', 350982201),
(350982202, 350982, '佳阳乡', 350982202),
(350982500, 350982, '*龙安开发区', 350982500),
(360102001, 360102, '公园街道', 360102001),
(360102002, 360102, '滕王阁街道', 360102002),
(360102003, 360102, '八一桥街道', 360102003),
(360102004, 360102, '百花洲街道', 360102004),
(360102005, 360102, '墩子塘街道', 360102005),
(360102006, 360102, '大院街道', 360102006),
(360102007, 360102, '豫章街道', 360102007),
(360102008, 360102, '董家窑街道', 360102008),
(360102009, 360102, '彭家桥街道', 360102009),
(360102050, 360102, '沙井街道居委会(红谷滩新区)', 360102050),
(360102400, 360102, '贤士湖管委会', 360102400),
(360103001, 360103, '南浦街道', 360103001),
(360103002, 360103, '朝阳洲街道', 360103002),
(360103004, 360103, '广润门街道', 360103004),
(360103005, 360103, '西湖街道', 360103005),
(360103006, 360103, '系马桩街道', 360103006),
(360103007, 360103, '绳金塔街道', 360103007),
(360103009, 360103, '丁公路街道', 360103009),
(360103010, 360103, '南站街道', 360103010),
(360103011, 360103, '桃源街道', 360103011),
(360103012, 360103, '十字街街道', 360103012),
(360103101, 360103, '桃花镇', 360103101),
(360103400, 360103, '南昌市朝阳农场', 360103400),
(360104002, 360104, '洪都街道', 360104002),
(360104006, 360104, '京山街道', 360104006),
(360104007, 360104, '三家店街道', 360104007),
(360104008, 360104, '岱山街道', 360104008),
(360104009, 360104, '徐家坊街道', 360104009),
(360104100, 360104, '青云谱镇', 360104100),
(360104500, 360104, '南昌昌南工业园', 360104500),
(360105001, 360105, '站前街道', 360105001),
(360105002, 360105, '幸福街道', 360105002),
(360105100, 360105, '招贤镇', 360105100),
(360105101, 360105, '梅岭镇', 360105101),
(360105102, 360105, '罗亭镇', 360105102),
(360105200, 360105, '太平乡', 360105200),
(360111001, 360111, '青山路街道', 360111001),
(360111003, 360111, '上海路街道', 360111003),
(360111100, 360111, '京东镇', 360111100),
(360111103, 360111, '罗家镇', 360111103),
(360111104, 360111, '湖坊镇', 360111104),
(360111105, 360111, '"塘山镇', 360111105),
(360111180, 360111, '蛟桥镇(南昌经济技术开发区)', 360111180),
(360111200, 360111, '扬子洲乡', 360111200),
(360111400, 360111, '扬子洲农场', 360111400),
(360111401, 360111, '罗家地区省市单位', 360111401),
(360111481, 360111, '白水湖管理处(南昌经济技术开发区)', 360111481),
(360111490, 360111, '艾溪湖管理处(南昌高新开发区)', 360111490),
(360111500, 360111, '南昌京东旅游经济开发区', 360111500),
(360111501, 360111, '南昌昌东工业区', 360111501),
(360111502, 360111, '南昌民营科技园', 360111502),
(360111570, 360111, '江西金牛集团(英雄开发区)', 360111570),
(360111593, 360111, '湖西新建区(南昌高新开发区)', 360111593),
(360121100, 360121, '莲塘镇', 360121100),
(360121101, 360121, '向塘镇', 360121101),
(360121102, 360121, '三江镇', 360121102),
(360121103, 360121, '塘南镇', 360121103),
(360121104, 360121, '幽兰镇', 360121104),
(360121105, 360121, '蒋巷镇', 360121105),
(360121106, 360121, '武阳镇', 360121106),
(360121107, 360121, '冈上镇', 360121107),
(360121108, 360121, '广福镇', 360121108),
(360121191, 360121, '昌东镇(南昌高新开发区)', 360121191),
(360121192, 360121, '麻丘镇(南昌高新开发区)', 360121192),
(360121200, 360121, '泾口乡', 360121200),
(360121201, 360121, '南新乡', 360121201),
(360121202, 360121, '塔城乡', 360121202),
(360121203, 360121, '黄马乡', 360121203),
(360121204, 360121, '富山乡', 360121204),
(360121205, 360121, '东新乡', 360121205),
(360121206, 360121, '八一乡', 360121206),
(360121402, 360121, '南昌市五星垦殖场', 360121402),
(360121471, 360121, '南昌英雄开发区社会事务管理处(英雄开发区)', 360121471),
(360121472, 360121, '江西省良种繁殖场(英雄开发区)', 360121472),
(360121500, 360121, '小蓝经济开发区', 360121500),
(360122100, 360122, '长堎镇', 360122100),
(360122101, 360122, '望城镇', 360122101),
(360122102, 360122, '生米镇', 360122102),
(360122103, 360122, '西山镇', 360122103),
(360122104, 360122, '石岗镇', 360122104),
(360122105, 360122, '松湖镇', 360122105),
(360122106, 360122, '樵舍镇', 360122106),
(360122107, 360122, '乐化镇', 360122107),
(360122108, 360122, '溪霞镇', 360122108),
(360122109, 360122, '象山镇', 360122109),
(360122200, 360122, '石埠乡', 360122200),
(360122201, 360122, '流湖乡', 360122201),
(360122202, 360122, '厚田乡', 360122202),
(360122203, 360122, '联圩乡', 360122203),
(360122204, 360122, '金桥乡', 360122204),
(360122205, 360122, '铁河乡', 360122205),
(360122206, 360122, '大塘坪乡', 360122206),
(360122207, 360122, '昌邑乡', 360122207),
(360122208, 360122, '南矶乡', 360122208),
(360122400, 360122, '恒湖垦殖场', 360122400),
(360122401, 360122, '新丰垦殖场', 360122401),
(360122402, 360122, '成新实业有限公司', 360122402),
(360122403, 360122, '朱港实业有限公司', 360122403),
(360122450, 360122, '红角洲管理处(红谷滩新区)', 360122450),
(360122500, 360122, '江西长堎外商投资工业区', 360122500),
(360122560, 360122, '江西桑海集团有限公司（江西桑海经济开发区）', 360122560),
(360122561, 360122, '新祺周管理处(江西桑海经济技术开发区)', 360122561),
(360123100, 360123, '龙津镇', 360123100),
(360123101, 360123, '万埠镇', 360123101),
(360123102, 360123, '石鼻镇', 360123102),
(360123103, 360123, '鼎湖镇', 360123103),
(360123104, 360123, '长埠镇', 360123104),
(360123105, 360123, '"东阳镇', 360123105),
(360123106, 360123, '黄洲镇', 360123106),
(360123200, 360123, '乔乐乡', 360123200),
(360123201, 360123, '长均乡', 360123201),
(360123202, 360123, '新民乡', 360123202),
(360123400, 360123, '国营万埠垦殖场', 360123400),
(360123401, 360123, '国营峤岭垦殖场', 360123401),
(360123500, 360123, '江西安义工业园区', 360123500),
(360124100, 360124, '民和镇', 360124100),
(360124101, 360124, '李渡镇', 360124101),
(360124102, 360124, '温圳镇', 360124102),
(360124103, 360124, '文港镇', 360124103),
(360124104, 360124, '梅庄镇', 360124104),
(360124105, 360124, '张公镇', 360124105),
(360124106, 360124, '罗溪镇', 360124106),
(360124107, 360124, '架桥镇', 360124107),
(360124108, 360124, '前坊镇', 360124108),
(360124200, 360124, '三里乡', 360124200),
(360124201, 360124, '二塘乡', 360124201),
(360124202, 360124, '钟陵乡', 360124202),
(360124203, 360124, '池溪乡', 360124203),
(360124204, 360124, '南台乡', 360124204),
(360124205, 360124, '三阳集乡', 360124205),
(360124206, 360124, '七里乡', 360124206),
(360124207, 360124, '下埠集乡', 360124207),
(360124208, 360124, '衙前乡', 360124208),
(360124209, 360124, '白圩乡', 360124209),
(360124210, 360124, '长山晏乡', 360124210),
(360124211, 360124, '泉岭乡', 360124211),
(360124400, 360124, '五里垦殖场', 360124400),
(360202001, 360202, '西郊街道', 360202001),
(360202100, 360202, '竟成镇', 360202100),
(360202101, 360202, '鲇鱼山镇', 360202101),
(360202201, 360202, '丽阳乡', 360202201),
(360202202, 360202, '荷塘乡', 360202202),
(360202290, 360202, '吕蒙乡(景德镇高新区管委会)', 360202290),
(360202400, 360202, '西郊垦殖场', 360202400),
(360202450, 360202, '枫树山总场', 360202450),
(360202451, 360202, '浮东分场', 360202451),
(360202452, 360202, '柏树下分场', 360202452),
(360202453, 360202, '浮南分场', 360202453),
(360202454, 360202, '浮西分场', 360202454),
(360202455, 360202, '南山分场', 360202455),
(360202456, 360202, '三宝分场', 360202456),
(360202457, 360202, '黄岭分场', 360202457),
(360202458, 360202, '塘坞分场', 360202458),
(360202459, 360202, '樟树坑分场', 360202459),
(360202460, 360202, '磨刀港分场', 360202460),
(360202461, 360202, '双桥分场', 360202461),
(360202462, 360202, '昌江化工园区', 360202462),
(360202463, 360202, '六0二所高科技园', 360202463),
(360202464, 360202, '森林公园', 360202464),
(360202500, 360202, '昌江开发区', 360202500),
(360203001, 360203, '石狮埠街道', 360203001),
(360203002, 360203, '新厂街道', 360203002),
(360203003, 360203, '里村街道', 360203003),
(360203004, 360203, '周路口街道', 360203004),
(360203005, 360203, '昌江街道', 360203005),
(360203006, 360203, '新村街道', 360203006),
(360203007, 360203, '珠山街道', 360203007),
(360203008, 360203, '太白园街道', 360203008),
(360203009, 360203, '昌河街道', 360203009),
(360203500, 360203, '高新技术开发区', 360203500),
(360222100, 360222, '浮梁镇', 360222100),
(360222101, 360222, '鹅湖镇', 360222101),
(360222102, 360222, '经公桥镇', 360222102),
(360222103, 360222, '蛟潭镇', 360222103),
(360222104, 360222, '湘湖镇', 360222104),
(360222105, 360222, '瑶里镇', 360222105),
(360222106, 360222, '洪源镇', 360222106),
(360222107, 360222, '寿安镇', 360222107),
(360222200, 360222, '王港乡', 360222200),
(360222201, 360222, '庄湾乡', 360222201),
(360222202, 360222, '三龙乡', 360222202),
(360222203, 360222, '黄坛乡', 360222203),
(360222204, 360222, '兴田乡', 360222204),
(360222205, 360222, '江村乡', 360222205),
(360222206, 360222, '峙滩乡', 360222206),
(360222207, 360222, '勒功乡', 360222207),
(360222208, 360222, '西湖乡', 360222208),
(360222400, 360222, '罗家垦殖场', 360222400),
(360222401, 360222, '庄湾垦殖场', 360222401),
(360222402, 360222, '九龙山垦殖场', 360222402),
(360222403, 360222, '万寿山垦殖场', 360222403),
(360222500, 360222, '浮梁工业园区', 360222500),
(360281001, 360281, '洎阳街道', 360281001),
(360281002, 360281, '塔山街道', 360281002),
(360281100, 360281, '镇桥镇', 360281100),
(360281101, 360281, '乐港镇', 360281101),
(360281102, 360281, '涌山镇', 360281102),
(360281103, 360281, '众埠镇', 360281103),
(360281104, 360281, '接渡镇', 360281104),
(360281105, 360281, '洪岩镇', 360281105),
(360281106, 360281, '礼林镇', 360281106),
(360281107, 360281, '后港镇', 360281107),
(360281108, 360281, '塔前镇', 360281108),
(360281109, 360281, '双田镇', 360281109),
(360281110, 360281, '临港镇', 360281110),
(360281111, 360281, '高家镇', 360281111),
(360281112, 360281, '洺口镇', 360281112),
(360281113, 360281, '浯口镇', 360281113),
(360281200, 360281, '鸬鹚乡', 360281200),
(360281201, 360281, '十里岗乡', 360281201),
(360281400, 360281, '农业高新园', 360281400),
(360281500, 360281, '江西乐平工业园区', 360281500),
(360302001, 360302, '东大街街道', 360302001),
(360302002, 360302, '凤凰街街道', 360302002),
(360302003, 360302, '八一街街道', 360302003),
(360302004, 360302, '后埠街街道', 360302004),
(360302005, 360302, '丹江街街道', 360302005),
(360302006, 360302, '白源街街道', 360302006),
(360302100, 360302, '安源镇', 360302100),
(360302101, 360302, '高坑镇', 360302101),
(360302102, 360302, '五陂镇', 360302102),
(360302103, 360302, '青山镇', 360302103),
(360302104, 360302, '城郊管委会', 360302104),
(360302400, 360302, '五陂下垦殖场', 360302400),
(360313001, 360313, '峡山口街道', 360313001),
(360313101, 360313, '湘东镇', 360313101),
(360313102, 360313, '荷尧镇', 360313102),
(360313103, 360313, '老关镇', 360313103),
(360313104, 360313, '腊市镇', 360313104),
(360313105, 360313, '下埠镇', 360313105),
(360313106, 360313, '排上镇', 360313106),
(360313107, 360313, '东桥镇', 360313107),
(360313108, 360313, '麻山镇', 360313108),
(360313200, 360313, '广寒寨乡', 360313200),
(360313201, 360313, '白竺乡', 360313201),
(360321101, 360321, '琴亭镇', 360321101),
(360321102, 360321, '路口镇', 360321102),
(360321103, 360321, '良坊镇', 360321103),
(360321104, 360321, '升坊镇', 360321104),
(360321105, 360321, '坊楼镇', 360321105),
(360321200, 360321, '闪石乡', 360321200),
(360321201, 360321, '湖上乡', 360321201),
(360321202, 360321, '三板桥乡', 360321202),
(360321203, 360321, '神泉乡', 360321203),
(360321204, 360321, '六市乡', 360321204),
(360321205, 360321, '高洲乡', 360321205),
(360321206, 360321, '荷塘乡', 360321206),
(360321207, 360321, '南岭乡', 360321207),
(360322101, 360322, '上栗镇', 360322101),
(360322102, 360322, '桐木镇', 360322102),
(360322103, 360322, '金山镇', 360322103),
(360322104, 360322, '福田镇', 360322104),
(360322105, 360322, '彭高镇', 360322105),
(360322106, 360322, '赤山镇', 360322106),
(360322200, 360322, '鸡冠山乡', 360322200),
(360322201, 360322, '长平乡', 360322201),
(360322202, 360322, '东源乡', 360322202),
(360323101, 360323, '芦溪镇', 360323101),
(360323102, 360323, '宣风镇', 360323102),
(360323103, 360323, '上埠镇', 360323103),
(360323104, 360323, '南坑镇', 360323104),
(360323105, 360323, '银河镇', 360323105),
(360323200, 360323, '源南乡', 360323200),
(360323201, 360323, '长丰乡', 360323201),
(360323202, 360323, '张佳坊乡', 360323202),
(360323203, 360323, '新泉乡', 360323203),
(360323204, 360323, '万龙山乡', 360323204),
(360402001, 360402, '十里街道', 360402001),
(360402002, 360402, '五里街道', 360402002),
(360402090, 360402, '七里湖街道办事处(九江经济开发区)', 360402090),
(360402100, 360402, '姑塘镇', 360402100),
(360402101, 360402, '威家镇', 360402101),
(360402102, 360402, '新港镇', 360402102),
(360402103, 360402, '莲花镇', 360402103),
(360402104, 360402, '海会镇', 360402104),
(360402105, 360402, '赛阳镇', 360402105),
(360402176, 360402, '牯岭镇', 360402176),
(360402200, 360402, '虞家河乡', 360402200),
(360402470, 360402, '庐山茶科所', 360402470),
(360402471, 360402, '庐山林科所', 360402471),
(360403001, 360403, '甘棠街道', 360403001),
(360403002, 360403, '湓浦街道', 360403002),
(360403003, 360403, '人民路街道', 360403003),
(360403004, 360403, '白水湖街道', 360403004),
(360403005, 360403, '金鸡坡街道', 360403005),
(360403091, 360403, '向阳街道办事处(九江经济开发区)', 360403091),
(360403092, 360403, '滨兴街道办事处(九江经济开发区)', 360403092),
(360403400, 360403, '茅山头企业集团', 360403400),
(360421100, 360421, '沙河街镇', 360421100),
(360421101, 360421, '马回岭镇', 360421101),
(360421102, 360421, '江洲镇', 360421102),
(360421103, 360421, '城子镇', 360421103),
(360421104, 360421, '港口街镇', 360421104),
(360421105, 360421, '新合镇', 360421105),
(360421106, 360421, '狮子镇', 360421106),
(360421200, 360421, '永安乡', 360421200),
(360421201, 360421, '涌泉乡', 360421201),
(360421202, 360421, '新塘乡', 360421202),
(360421203, 360421, '城门乡', 360421203),
(360421204, 360421, '岷山乡', 360421204),
(360421400, 360421, '新洲垦殖场', 360421400),
(360421401, 360421, '赛城湖水产场', 360421401),
(360421402, 360421, '岷山林场', 360421402),
(360421500, 360421, '沙河经济技术开发区', 360421500),
(360423100, 360423, '新宁镇', 360423100),
(360423101, 360423, '泉口镇', 360423101),
(360423102, 360423, '鲁溪镇', 360423102),
(360423103, 360423, '船滩镇', 360423103),
(360423104, 360423, '澧溪镇', 360423104),
(360423105, 360423, '罗坪镇', 360423105),
(360423106, 360423, '石门楼镇', 360423106),
(360423107, 360423, '宋溪镇', 360423107),
(360423200, 360423, '大洞乡', 360423200),
(360423201, 360423, '横路乡', 360423201),
(360423202, 360423, '官莲乡', 360423202),
(360423203, 360423, '巾口乡', 360423203),
(360423204, 360423, '东林乡', 360423204),
(360423205, 360423, '上汤乡', 360423205),
(360423206, 360423, '甫田乡', 360423206),
(360423207, 360423, '清江乡', 360423207),
(360423208, 360423, '石渡乡', 360423208),
(360423209, 360423, '杨洲乡', 360423209),
(360423210, 360423, '罗溪乡', 360423210),
(360423500, 360423, '万福经济技术开发区管委会', 360423500),
(360424100, 360424, '义宁镇', 360424100),
(360424101, 360424, '白岭镇', 360424101),
(360424102, 360424, '全丰镇', 360424102),
(360424103, 360424, '古市镇', 360424103),
(360424104, 360424, '大桥镇', 360424104),
(360424105, 360424, '渣津镇', 360424105),
(360424106, 360424, '马坳镇', 360424106),
(360424107, 360424, '杭口镇', 360424107),
(360424108, 360424, '港口镇', 360424108),
(360424109, 360424, '溪口镇', 360424109),
(360424110, 360424, '西港镇', 360424110),
(360424111, 360424, '山口镇', 360424111),
(360424112, 360424, '黄沙镇', 360424112),
(360424113, 360424, '黄港镇', 360424113),
(360424114, 360424, '何市镇', 360424114),
(360424115, 360424, '上奉镇', 360424115),
(360424116, 360424, '四都镇', 360424116),
(360424117, 360424, '三都镇', 360424117),
(360424200, 360424, '路口乡', 360424200),
(360424201, 360424, '黄龙乡', 360424201),
(360424202, 360424, '上衫乡', 360424202),
(360424203, 360424, '余段乡', 360424203),
(360424204, 360424, '水源乡', 360424204),
(360424205, 360424, '石坳乡', 360424205),
(360424206, 360424, '东港乡', 360424206),
(360424207, 360424, '上杭乡', 360424207),
(360424208, 360424, '程坊乡', 360424208),
(360424209, 360424, '新湾乡', 360424209),
(360424210, 360424, '布甲乡', 360424210),
(360424211, 360424, '漫江乡', 360424211),
(360424212, 360424, '复源乡', 360424212),
(360424213, 360424, '竹坪乡', 360424213),
(360424214, 360424, '征村乡', 360424214),
(360424215, 360424, '庙岭乡', 360424215),
(360424216, 360424, '黄坳乡', 360424216),
(360424217, 360424, '大椿乡', 360424217),
(360425100, 360425, '涂埠镇', 360425100),
(360425101, 360425, '吴城镇', 360425101),
(360425102, 360425, '柘林镇', 360425102),
(360425103, 360425, '虬津镇', 360425103),
(360425104, 360425, '艾城镇', 360425104),
(360425105, 360425, '滩溪镇', 360425105),
(360425106, 360425, '白槎镇', 360425106),
(360425107, 360425, '梅棠镇', 360425107),
(360425108, 360425, '燕坊镇', 360425108),
(360425109, 360425, '马口镇', 360425109),
(360425180, 360425, '江益镇(共青开放开发区)', 360425180),
(360425200, 360425, '三角乡', 360425200),
(360425201, 360425, '九合乡', 360425201),
(360425202, 360425, '立新乡', 360425202),
(360425203, 360425, '江上乡', 360425203),
(360425400, 360425, '云山企业集团', 360425400),
(360425401, 360425, '恒丰企业集团', 360425401),
(360425402, 360425, '八角岭垦殖场', 360425402),
(360425403, 360425, '永丰垦殖场', 360425403),
(360425404, 360425, '柘林管理局', 360425404),
(360425405, 360425, '县农科所', 360425405),
(360426084, 360426, '茶山街道办事处(共青开放开发区)', 360426084),
(360426100, 360426, '蒲亭镇', 360426100),
(360426101, 360426, '聂桥镇', 360426101),
(360426102, 360426, '车桥镇', 360426102),
(360426103, 360426, '丰林镇', 360426103),
(360426182, 360426, '甘露镇(共青开放开发区)', 360426182),
(360426183, 360426, '金湖镇(共青开放开发区)', 360426183),
(360426200, 360426, '宝塔乡', 360426200),
(360426201, 360426, '河东乡', 360426201),
(360426202, 360426, '高塘乡', 360426202),
(360426203, 360426, '林泉乡', 360426203),
(360426204, 360426, '吴山乡', 360426204),
(360426205, 360426, '磨溪乡', 360426205),
(360426206, 360426, '爱民乡', 360426206),
(360426207, 360426, '邹桥乡', 360426207),
(360426208, 360426, '塘山乡', 360426208),
(360426400, 360426, '彭山林场', 360426400),
(360426401, 360426, '园艺场', 360426401),
(360427100, 360427, '南康镇', 360427100),
(360427101, 360427, '白鹿镇', 360427101),
(360427102, 360427, '温泉镇', 360427102),
(360427103, 360427, '蓼花镇', 360427103),
(360427104, 360427, '华林镇', 360427104),
(360427105, 360427, '蛟塘镇', 360427105),
(360427106, 360427, '横塘镇', 360427106),
(360427200, 360427, '蓼南乡', 360427200),
(360427201, 360427, '苏家当乡', 360427201),
(360427202, 360427, '泽泉乡', 360427202),
(360427400, 360427, '沙湖山管理处', 360427400),
(360427401, 360427, '东牯山林场', 360427401),
(360427402, 360427, '农科所', 360427402),
(360427403, 360427, '水稻良种场', 360427403),
(360428100, 360428, '都昌镇', 360428100),
(360428101, 360428, '周溪镇', 360428101),
(360428102, 360428, '三汊港镇', 360428102),
(360428103, 360428, '中馆镇', 360428103),
(360428104, 360428, '大沙镇', 360428104),
(360428105, 360428, '万户镇', 360428105),
(360428106, 360428, '南峰镇', 360428106),
(360428107, 360428, '土塘镇', 360428107),
(360428108, 360428, '大港镇', 360428108),
(360428109, 360428, '蔡岭镇', 360428109),
(360428110, 360428, '徐埠镇', 360428110),
(360428111, 360428, '左里镇', 360428111),
(360428200, 360428, '和合乡', 360428200),
(360428201, 360428, '阳峰乡', 360428201),
(360428202, 360428, '西源乡', 360428202),
(360428203, 360428, '芗溪乡', 360428203),
(360428204, 360428, '狮山乡', 360428204),
(360428205, 360428, '鸣山乡', 360428205),
(360428206, 360428, '春桥乡', 360428206),
(360428207, 360428, '苏山乡', 360428207),
(360428208, 360428, '多宝乡', 360428208),
(360428209, 360428, '汪墩乡', 360428209),
(360428210, 360428, '北山乡', 360428210),
(360428211, 360428, '大树乡', 360428211),
(360428400, 360428, '江西省对外经济技术合作蔡岭示范区', 360428400),
(360428401, 360428, '都昌县良种场', 360428401),
(360429100, 360429, '双钟镇', 360429100),
(360429101, 360429, '流泗镇', 360429101),
(360429102, 360429, '马影镇', 360429102),
(360429103, 360429, '武山镇', 360429103),
(360429104, 360429, '城山镇', 360429104),
(360429200, 360429, '大垅乡', 360429200),
(360429201, 360429, '凰村乡', 360429201),
(360429202, 360429, '张青乡', 360429202),
(360429203, 360429, '文桥乡', 360429203),
(360429204, 360429, '付垅乡', 360429204),
(360429205, 360429, '舜德乡', 360429205),
(360429206, 360429, '流芳乡', 360429206),
(360429400, 360429, '南北港水产场', 360429400),
(360429401, 360429, '武山垦殖场', 360429401),
(360430100, 360430, '龙城镇', 360430100),
(360430101, 360430, '棉船镇', 360430101),
(360430102, 360430, '马垱镇', 360430102),
(360430103, 360430, '芙蓉墩镇', 360430103),
(360430104, 360430, '定山镇', 360430104),
(360430105, 360430, '天红镇', 360430105),
(360430106, 360430, '杨梓镇', 360430106),
(360430107, 360430, '东升镇', 360430107),
(360430108, 360430, '浪溪镇', 360430108),
(360430109, 360430, '黄花镇', 360430109),
(360430200, 360430, '太平关乡', 360430200),
(360430201, 360430, '黄岭乡', 360430201),
(360430202, 360430, '浩山乡', 360430202),
(360430400, 360430, '太泊湖农业综合开发区', 360430400),
(360430401, 360430, '上十岭综合垦殖场', 360430401),
(360430402, 360430, '芙蓉农场', 360430402),
(360430403, 360430, '建筑材料厂', 360430403),
(360430404, 360430, '水产养殖场', 360430404),
(360430405, 360430, '棉科所', 360430405),
(360430406, 360430, '棉花原种场国营分场', 360430406),
(360430407, 360430, '太泊湖水产养殖场', 360430407),
(360430408, 360430, '黄乐林场', 360430408),
(360481001, 360481, '湓城街道', 360481001),
(360481002, 360481, '桂林街道', 360481002),
(360481100, 360481, '码头镇', 360481100),
(360481101, 360481, '白杨镇', 360481101),
(360481102, 360481, '南义镇', 360481102),
(360481103, 360481, '横港镇', 360481103),
(360481104, 360481, '范镇', 360481104),
(360481105, 360481, '肇陈镇', 360481105),
(360481106, 360481, '高丰镇', 360481106),
(360481107, 360481, '夏畈镇', 360481107),
(360481200, 360481, '乐园乡', 360481200),
(360481201, 360481, '洪一乡', 360481201),
(360481202, 360481, '花园乡', 360481202),
(360481203, 360481, '洪下乡', 360481203),
(360481204, 360481, '武蛟乡', 360481204),
(360481205, 360481, '横立山乡', 360481205),
(360481206, 360481, '黄金乡', 360481206),
(360481207, 360481, '南阳乡', 360481207),
(360481400, 360481, '赛湖农场', 360481400),
(360481401, 360481, '青山林场', 360481401),
(360481402, 360481, '瑞昌市大德山林场', 360481402),
(360502001, 360502, '城南街道', 360502001),
(360502002, 360502, '城北街道', 360502002),
(360502003, 360502, '袁河街道', 360502003),
(360502100, 360502, '水北镇', 360502100),
(360502101, 360502, '下村镇', 360502101),
(360502102, 360502, '良山镇', 360502102),
(360502103, 360502, '罗坊镇', 360502103),
(360502104, 360502, '姚圩镇', 360502104),
(360502105, 360502, '珠珊镇', 360502105),
(360502106, 360502, '观巢镇', 360502106),
(360502107, 360502, '欧里镇', 360502107),
(360502170, 360502, '河下镇(仙女湖管理区）', 360502170),
(360502190, 360502, '水西镇（经济技术开发区)', 360502190),
(360502200, 360502, '鹄山乡', 360502200),
(360502201, 360502, '人和乡', 360502201),
(360502202, 360502, '界水乡', 360502202),
(360502203, 360502, '南安乡', 360502203),
(360502204, 360502, '新溪乡', 360502204),
(360502271, 360502, '九龙山乡（仙女湖管理区）', 360502271),
(360502400, 360502, '新钢街道', 360502400),
(360521100, 360521, '分宜镇', 360521100),
(360521101, 360521, '杨桥镇', 360521101),
(360521102, 360521, '湖泽镇', 360521102),
(360521103, 360521, '双林镇', 360521103),
(360521104, 360521, '钤山镇', 360521104),
(360521200, 360521, '凤阳乡', 360521200),
(360521201, 360521, '洞村乡', 360521201),
(360521202, 360521, '高岚乡', 360521202),
(360521203, 360521, '操场乡', 360521203),
(360521204, 360521, '洋江乡', 360521204),
(360521400, 360521, '分宜县芳山林场', 360521400),
(360521402, 360521, '山下林场', 360521402),
(360521403, 360521, '上村林场', 360521403),
(360521404, 360521, '长埠林场', 360521404),
(360521473, 360521, '东坑林场（仙女湖管理区）', 360521473),
(360521500, 360521, '城西工业园管理委员会（乡级开发区）', 360521500),
(360602001, 360602, '江边街道', 360602001),
(360602002, 360602, '交通街道', 360602002),
(360602003, 360602, '东湖街道', 360602003),
(360602004, 360602, '梅园街道', 360602004),
(360602005, 360602, '四青街道', 360602005),
(360602006, 360602, '白露街道', 360602006),
(360602100, 360602, '童家镇', 360602100),
(360602200, 360602, '夏埠乡', 360602200),
(360622100, 360622, '邓埠镇', 360622100),
(360622101, 360622, '锦江镇', 360622101),
(360622102, 360622, '潢溪镇', 360622102),
(360622103, 360622, '中童镇', 360622103),
(360622104, 360622, '马荃镇', 360622104),
(360622105, 360622, '画桥镇', 360622105),
(360622200, 360622, '平定乡', 360622200),
(360622201, 360622, '春涛乡', 360622201),
(360622202, 360622, '杨溪乡', 360622202),
(360622203, 360622, '洪湖乡', 360622203),
(360622204, 360622, '黄庄乡', 360622204),
(360622400, 360622, '高公寨营林场', 360622400),
(360622401, 360622, '刘家站垦殖场', 360622401),
(360622402, 360622, '邓家埠水稻原种场', 360622402),
(360622403, 360622, '余江县水产场', 360622403),
(360622404, 360622, '塘潮源林场', 360622404),
(360622405, 360622, '张公桥农场', 360622405),
(360622406, 360622, '青年综合垦殖场', 360622406),
(360622407, 360622, '大桥农场', 360622407),
(360622500, 360622, '余江县工业园区', 360622500),
(360681001, 360681, '花园街道', 360681001),
(360681002, 360681, '雄石街道', 360681002),
(360681003, 360681, '东门街道', 360681003),
(360681100, 360681, '泗沥镇', 360681100),
(360681101, 360681, '河潭镇', 360681101),
(360681102, 360681, '周坊镇', 360681102),
(360681103, 360681, '鸿塘镇', 360681103),
(360681104, 360681, '志光镇', 360681104),
(360681105, 360681, '流口镇', 360681105),
(360681106, 360681, '罗河镇', 360681106),
(360681107, 360681, '金屯镇', 360681107),
(360681108, 360681, '塘湾镇', 360681108),
(360681109, 360681, '文坊镇', 360681109),
(360681110, 360681, '冷水镇', 360681110),
(360681190, 360681, '龙虎山镇（龙虎山风景旅游区管委会）', 360681190),
(360681191, 360681, '上清镇(龙虎山风景旅游区管委会)', 360681191),
(360681200, 360681, '滨江乡', 360681200),
(360681201, 360681, '白田乡', 360681201),
(360681202, 360681, '雷溪乡', 360681202),
(360681203, 360681, '彭湾乡', 360681203),
(360681204, 360681, '樟坪畲族乡', 360681204),
(360681205, 360681, '耳口乡', 360681205),
(360681206, 360681, '余家乡', 360681206),
(360681400, 360681, '塔桥园艺场', 360681400),
(360681401, 360681, '河潭埠垦殖场', 360681401),
(360681402, 360681, '西窑林场', 360681402),
(360681403, 360681, '双圳林场', 360681403),
(360681404, 360681, '耳口林场', 360681404),
(360681405, 360681, '冷水林场', 360681405),
(360681406, 360681, '三县岭林场', 360681406),
(360681492, 360681, '上清林场(龙虎山风景旅游区管委会)', 360681492),
(360681500, 360681, '贵溪市工业园区', 360681500),
(360702001, 360702, '解放街道', 360702001),
(360702002, 360702, '赣江街道', 360702002),
(360702003, 360702, '南外街道', 360702003),
(360702004, 360702, '东外街道', 360702004),
(360702091, 360702, '黄金岭街道办事处(黄金开发区）', 360702091),
(360702100, 360702, '沙石镇', 360702100),
(360702101, 360702, '水东镇', 360702101),
(360702102, 360702, '水南镇', 360702102),
(360702103, 360702, '湖边镇', 360702103),
(360702104, 360702, '沙河镇', 360702104),
(360702105, 360702, '水西镇', 360702105),
(360702190, 360702, '蟠龙镇(黄金开发区）', 360702190),
(360702500, 360702, '赣南工业园', 360702500),
(360702501, 360702, '沙河工业园', 360702501),
(360721100, 360721, '梅林镇', 360721100),
(360721101, 360721, '王母渡镇', 360721101),
(360721102, 360721, '沙地镇', 360721102),
(360721103, 360721, '江口镇', 360721103),
(360721104, 360721, '田村镇', 360721104),
(360721105, 360721, '南塘镇', 360721105),
(360721106, 360721, '茅店镇', 360721106),
(360721107, 360721, '吉埠镇', 360721107),
(360721108, 360721, '五云镇', 360721108),
(360721200, 360721, '韩坊乡', 360721200),
(360721201, 360721, '阳埠乡', 360721201),
(360721202, 360721, '大埠乡', 360721202),
(360721203, 360721, '长洛乡', 360721203),
(360721204, 360721, '大田乡', 360721204),
(360721205, 360721, '湖江乡', 360721205),
(360721206, 360721, '储潭乡', 360721206),
(360721207, 360721, '石芫乡', 360721207),
(360721208, 360721, '三溪乡', 360721208),
(360721209, 360721, '白鹭乡', 360721209),
(360721500, 360721, '赣县工业园', 360721500),
(360722100, 360722, '嘉定镇', 360722100),
(360722101, 360722, '大塘埠镇', 360722101),
(360722102, 360722, '古陂镇', 360722102),
(360722103, 360722, '大桥镇', 360722103),
(360722104, 360722, '新田镇', 360722104),
(360722105, 360722, '安西镇', 360722105),
(360722106, 360722, '小江镇', 360722106),
(360722107, 360722, '铁石口镇', 360722107),
(360722108, 360722, '大阿镇', 360722108),
(360722109, 360722, '油山镇', 360722109),
(360722110, 360722, '小河镇', 360722110),
(360722111, 360722, '西牛镇', 360722111),
(360722112, 360722, '正平镇', 360722112),
(360722200, 360722, '虎山乡', 360722200),
(360722201, 360722, '崇仙乡', 360722201),
(360722202, 360722, '万隆乡', 360722202),
(360722500, 360722, '信丰县工业园', 360722500),
(360723100, 360723, '南安镇', 360723100),
(360723101, 360723, '新城镇', 360723101),
(360723102, 360723, '樟斗镇', 360723102),
(360723103, 360723, '池江镇', 360723103),
(360723104, 360723, '青龙镇', 360723104),
(360723105, 360723, '左拔镇', 360723105),
(360723106, 360723, '黄龙镇', 360723106),
(360723107, 360723, '吉村镇', 360723107),
(360723200, 360723, '浮江乡', 360723200),
(360723201, 360723, '河洞乡', 360723201),
(360723202, 360723, '内良乡', 360723202),
(360723500, 360723, '新世纪工业园', 360723500),
(360724100, 360724, '东山镇', 360724100),
(360724101, 360724, '陡水镇', 360724101),
(360724102, 360724, '社溪镇', 360724102),
(360724103, 360724, '营前镇', 360724103),
(360724104, 360724, '黄埠镇', 360724104),
(360724200, 360724, '梅水乡', 360724200),
(360724201, 360724, '油石乡', 360724201),
(360724202, 360724, '安和乡', 360724202),
(360724203, 360724, '寺下乡', 360724203),
(360724204, 360724, '双溪乡', 360724204),
(360724205, 360724, '水岩乡', 360724205),
(360724206, 360724, '平富乡', 360724206),
(360724207, 360724, '五指峰乡', 360724207),
(360724208, 360724, '紫阳乡', 360724208),
(360724500, 360724, '上犹县黄埠工业区', 360724500),
(360725100, 360725, '横水镇', 360725100),
(360725101, 360725, '扬眉镇', 360725101),
(360725102, 360725, '过埠镇', 360725102),
(360725103, 360725, '铅厂镇', 360725103),
(360725104, 360725, '长龙镇', 360725104),
(360725105, 360725, '关田镇', 360725105),
(360725200, 360725, '龙勾乡', 360725200),
(360725201, 360725, '杰坝乡', 360725201),
(360725202, 360725, '金坑乡', 360725202),
(360725203, 360725, '思顺乡', 360725203),
(360725204, 360725, '麟潭乡', 360725204),
(360725205, 360725, '上堡乡', 360725205),
(360725206, 360725, '聂都乡', 360725206),
(360725207, 360725, '文英乡', 360725207),
(360725208, 360725, '乐洞乡', 360725208),
(360725209, 360725, '丰州乡', 360725209),
(360725400, 360725, '天台山林场', 360725400),
(360726100, 360726, '欣山镇', 360726100),
(360726101, 360726, '孔田镇', 360726101),
(360726102, 360726, '版石镇', 360726102),
(360726103, 360726, '天心镇', 360726103),
(360726104, 360726, '龙布镇', 360726104),
(360726105, 360726, '鹤子镇', 360726105),
(360726106, 360726, '三百山镇', 360726106),
(360726107, 360726, '车头镇', 360726107),
(360726200, 360726, '镇岗乡', 360726200),
(360726201, 360726, '凤山乡', 360726201),
(360726202, 360726, '新龙乡', 360726202),
(360726203, 360726, '蔡坊乡', 360726203),
(360726204, 360726, '重石乡', 360726204),
(360726205, 360726, '长沙乡', 360726205),
(360726206, 360726, '浮槎乡', 360726206),
(360726207, 360726, '双芫乡', 360726207),
(360726208, 360726, '塘村乡', 360726208),
(360726209, 360726, '高云山乡', 360726209),
(360726500, 360726, '九龙工业园', 360726500),
(360727100, 360727, '龙南镇', 360727100),
(360727101, 360727, '武当镇', 360727101),
(360727102, 360727, '杨村镇', 360727102),
(360727103, 360727, '汶龙镇', 360727103),
(360727104, 360727, '程龙镇', 360727104),
(360727105, 360727, '关西镇', 360727105),
(360727106, 360727, '里仁镇', 360727106),
(360727107, 360727, '渡江镇', 360727107),
(360727200, 360727, '桃江乡', 360727200),
(360727201, 360727, '东江乡', 360727201),
(360727202, 360727, '临塘乡', 360727202),
(360727203, 360727, '南亨乡', 360727203),
(360727204, 360727, '夹湖乡', 360727204),
(360727400, 360727, '安基山林场', 360727400),
(360727401, 360727, '九连山林场', 360727401),
(360727500, 360727, '金塘开发区', 360727500),
(360728100, 360728, '历市镇', 360728100),
(360728101, 360728, '岿美山镇', 360728101),
(360728102, 360728, '老城镇', 360728102),
(360728103, 360728, '天九镇', 360728103),
(360728104, 360728, '龙塘镇', 360728104),
(360728105, 360728, '岭北镇', 360728105),
(360728106, 360728, '鹅公镇', 360728106),
(360728500, 360728, '定南县工业园', 360728500),
(360729100, 360729, '城厢镇', 360729100),
(360729101, 360729, '大吉山镇', 360729101),
(360729102, 360729, '陂头镇', 360729102),
(360729103, 360729, '金龙镇', 360729103),
(360729104, 360729, '南迳镇', 360729104),
(360729105, 360729, '龙源坝镇', 360729105),
(360729200, 360729, '中寨乡', 360729200),
(360729201, 360729, '社迳乡', 360729201),
(360729202, 360729, '龙下乡', 360729202),
(360729400, 360729, '大吉山矿社区管理委员会', 360729400),
(360729401, 360729, '茅山林场', 360729401),
(360729500, 360729, '全南县工业园', 360729500),
(360730100, 360730, '梅江镇', 360730100),
(360730101, 360730, '青塘镇', 360730101),
(360730102, 360730, '长胜镇　', 360730102),
(360730103, 360730, '黄陂镇　　', 360730103),
(360730104, 360730, '固村镇　　', 360730104),
(360730105, 360730, '赖村镇　', 360730105),
(360730106, 360730, '石上镇', 360730106),
(360730107, 360730, '东山坝镇', 360730107),
(360730108, 360730, '洛口镇', 360730108),
(360730109, 360730, '小布镇', 360730109),
(360730110, 360730, '黄石镇', 360730110),
(360730111, 360730, '田头镇', 360730111),
(360730200, 360730, '竹笮乡　　', 360730200),
(360730201, 360730, '对坊乡', 360730201),
(360730202, 360730, '固厚乡', 360730202),
(360730203, 360730, '田埠乡', 360730203),
(360730204, 360730, '会同乡　', 360730204),
(360730205, 360730, '湛田乡', 360730205),
(360730206, 360730, '安福乡　', 360730206),
(360730207, 360730, '东韶乡', 360730207),
(360730208, 360730, '肖田乡　', 360730208),
(360730209, 360730, '钓峰乡　', 360730209),
(360730210, 360730, '大沽乡', 360730210),
(360730211, 360730, '蔡江乡　　', 360730211),
(360730500, 360730, '宁都县水东工业园', 360730500),
(360731100, 360731, '贡江镇', 360731100),
(360731101, 360731, '铁山垅镇', 360731101),
(360731102, 360731, '盘古山镇', 360731102),
(360731103, 360731, '禾丰镇', 360731103),
(360731104, 360731, '祁禄山镇', 360731104),
(360731105, 360731, '梓山镇', 360731105),
(360731106, 360731, '银坑镇', 360731106),
(360731107, 360731, '岭背镇', 360731107),
(360731108, 360731, '罗坳镇', 360731108),
(360731200, 360731, '罗江乡', 360731200),
(360731201, 360731, '小溪乡', 360731201),
(360731202, 360731, '利村乡', 360731202),
(360731203, 360731, '新陂乡', 360731203),
(360731204, 360731, '靖石乡', 360731204),
(360731205, 360731, '黄麟乡', 360731205),
(360731206, 360731, '沙心乡', 360731206),
(360731207, 360731, '宽田乡', 360731207),
(360731208, 360731, '葛坳乡', 360731208),
(360731209, 360731, '桥头乡', 360731209),
(360731210, 360731, '马安乡', 360731210),
(360731211, 360731, '仙下乡', 360731211),
(360731212, 360731, '车溪乡', 360731212),
(360731213, 360731, '段屋乡', 360731213),
(360731500, 360731, '于都工业园', 360731500),
(360732100, 360732, '潋江镇', 360732100),
(360732101, 360732, '江背镇', 360732101),
(360732102, 360732, '古龙冈镇', 360732102),
(360732103, 360732, '梅窖镇', 360732103),
(360732104, 360732, '高兴镇', 360732104),
(360732105, 360732, '良村镇', 360732105),
(360732106, 360732, '龙口镇', 360732106),
(360732200, 360732, '兴江乡', 360732200),
(360732201, 360732, '樟木乡', 360732201),
(360732202, 360732, '东村乡', 360732202),
(360732203, 360732, '兴莲乡', 360732203),
(360732204, 360732, '杰村乡', 360732204),
(360732205, 360732, '社富乡', 360732205),
(360732206, 360732, '埠头乡', 360732206),
(360732207, 360732, '永丰乡', 360732207),
(360732208, 360732, '隆坪乡', 360732208),
(360732209, 360732, '均村乡', 360732209),
(360732210, 360732, '茶园乡', 360732210),
(360732211, 360732, '崇贤乡', 360732211),
(360732212, 360732, '枫边乡', 360732212),
(360732213, 360732, '南坑乡', 360732213),
(360732214, 360732, '城岗乡', 360732214),
(360732215, 360732, '方太乡', 360732215),
(360732216, 360732, '鼎龙乡', 360732216),
(360732217, 360732, '长冈乡', 360732217),
(360732500, 360732, '兴国县工业园', 360732500),
(360733100, 360733, '文武坝镇', 360733100),
(360733101, 360733, '筠门岭镇', 360733101),
(360733102, 360733, '西江镇', 360733102),
(360733103, 360733, '周田镇', 360733103),
(360733104, 360733, '麻州镇', 360733104),
(360733105, 360733, '庄口镇', 360733105),
(360733200, 360733, '清溪乡', 360733200),
(360733201, 360733, '右水乡', 360733201),
(360733202, 360733, '高排乡', 360733202),
(360733203, 360733, '晓龙乡', 360733203);
INSERT INTO `{pre}areas` VALUES
(360733204, 360733, '珠兰乡', 360733204),
(360733205, 360733, '洞头乡', 360733205),
(360733206, 360733, '中村乡', 360733206),
(360733207, 360733, '站塘乡', 360733207),
(360733208, 360733, '永隆乡', 360733208),
(360733209, 360733, '富城乡', 360733209),
(360733210, 360733, '小密乡', 360733210),
(360733211, 360733, '庄埠乡', 360733211),
(360733212, 360733, '白鹅乡', 360733212),
(360733500, 360733, '会昌县燕子窝工业园', 360733500),
(360734100, 360734, '长宁镇', 360734100),
(360734101, 360734, '晨光镇', 360734101),
(360734102, 360734, '留车镇', 360734102),
(360734103, 360734, '南桥镇', 360734103),
(360734104, 360734, '吉潭镇', 360734104),
(360734105, 360734, '澄江镇', 360734105),
(360734106, 360734, '桂竹帽镇', 360734106),
(360734200, 360734, '文峰乡', 360734200),
(360734201, 360734, '三标乡', 360734201),
(360734202, 360734, '菖蒲乡', 360734202),
(360734203, 360734, '龙廷乡', 360734203),
(360734204, 360734, '丹溪乡', 360734204),
(360734205, 360734, '项山乡', 360734205),
(360734206, 360734, '水源乡', 360734206),
(360734207, 360734, '罗珊乡', 360734207),
(360735100, 360735, '琴江镇', 360735100),
(360735101, 360735, '小松镇', 360735101),
(360735102, 360735, '屏山镇', 360735102),
(360735103, 360735, '横江镇', 360735103),
(360735104, 360735, '高田镇', 360735104),
(360735200, 360735, '木兰乡', 360735200),
(360735201, 360735, '丰山乡', 360735201),
(360735202, 360735, '大由乡', 360735202),
(360735203, 360735, '龙岗乡', 360735203),
(360735204, 360735, '珠坑乡', 360735204),
(360781100, 360781, '象湖镇', 360781100),
(360781101, 360781, '瑞林镇', 360781101),
(360781102, 360781, '壬田镇', 360781102),
(360781103, 360781, '九堡镇', 360781103),
(360781104, 360781, '沙洲坝镇', 360781104),
(360781105, 360781, '谢坊镇', 360781105),
(360781106, 360781, '武阳镇', 360781106),
(360781200, 360781, '叶坪乡', 360781200),
(360781201, 360781, '丁陂乡', 360781201),
(360781202, 360781, '大柏地乡', 360781202),
(360781203, 360781, '岗面乡', 360781203),
(360781204, 360781, '日东乡', 360781204),
(360781205, 360781, '万田乡', 360781205),
(360781206, 360781, '黄柏乡', 360781206),
(360781207, 360781, '云石山乡', 360781207),
(360781208, 360781, '泽覃乡', 360781208),
(360781209, 360781, '拔英乡', 360781209),
(360781500, 360781, '瑞金市工业园', 360781500),
(360782001, 360782, '蓉江街道', 360782001),
(360782002, 360782, '东山街道', 360782002),
(360782100, 360782, '唐江镇', 360782100),
(360782101, 360782, '凤岗镇', 360782101),
(360782102, 360782, '潭口镇', 360782102),
(360782103, 360782, '龙岭镇', 360782103),
(360782104, 360782, '龙回镇', 360782104),
(360782105, 360782, '镜坝镇', 360782105),
(360782106, 360782, '横市镇', 360782106),
(360782192, 360782, '潭东镇(黄金开发区）', 360782192),
(360782200, 360782, '浮石乡', 360782200),
(360782201, 360782, '赤土畲族乡', 360782201),
(360782202, 360782, '横寨乡', 360782202),
(360782203, 360782, '朱坊乡', 360782203),
(360782204, 360782, '太窝乡', 360782204),
(360782205, 360782, '三江乡', 360782205),
(360782206, 360782, '龙华乡', 360782206),
(360782207, 360782, '十八塘乡', 360782207),
(360782208, 360782, '麻双乡', 360782208),
(360782209, 360782, '大坪乡', 360782209),
(360782210, 360782, '坪市乡', 360782210),
(360782211, 360782, '隆木乡', 360782211),
(360782500, 360782, '南康市工业园', 360782500),
(360802001, 360802, '古南街道', 360802001),
(360802002, 360802, '永叔街道', 360802002),
(360802003, 360802, '文山街道', 360802003),
(360802004, 360802, '习溪桥街道', 360802004),
(360802005, 360802, '北门街道', 360802005),
(360802006, 360802, '白塘街道', 360802006),
(360802100, 360802, '兴桥镇', 360802100),
(360802101, 360802, '樟山镇', 360802101),
(360802102, 360802, '长塘镇', 360802102),
(360802200, 360802, '禾埠乡', 360802200),
(360802202, 360802, '曲濑乡', 360802202),
(360802500, 360802, '吉州区工业园小区', 360802500),
(360803001, 360803, '河东街道', 360803001),
(360803100, 360803, '天玉镇', 360803100),
(360803101, 360803, '值夏镇', 360803101),
(360803102, 360803, '新圩镇', 360803102),
(360803103, 360803, '富滩镇', 360803103),
(360803104, 360803, '富田镇', 360803104),
(360803200, 360803, '文陂乡', 360803200),
(360803201, 360803, '东固畲族少数民族乡', 360803201),
(360803400, 360803, '东固垦殖场', 360803400),
(360803500, 360803, '青原区河东经济开发区', 360803500),
(360821100, 360821, '敦厚镇', 360821100),
(360821101, 360821, '永阳镇', 360821101),
(360821102, 360821, '天河镇', 360821102),
(360821103, 360821, '横江镇', 360821103),
(360821104, 360821, '固江镇', 360821104),
(360821105, 360821, '万福镇', 360821105),
(360821106, 360821, '永和镇', 360821106),
(360821107, 360821, '桐坪镇', 360821107),
(360821108, 360821, '凤凰镇', 360821108),
(360821109, 360821, '油田镇', 360821109),
(360821110, 360821, '敖城镇', 360821110),
(360821200, 360821, '北源乡', 360821200),
(360821201, 360821, '大冲乡', 360821201),
(360821202, 360821, '里田乡', 360821202),
(360821203, 360821, '梅塘乡', 360821203),
(360821204, 360821, '登龙乡', 360821204),
(360821205, 360821, '安塘乡', 360821205),
(360821206, 360821, '官田乡', 360821206),
(360821207, 360821, '指阳乡', 360821207),
(360821500, 360821, '吉安市高新技术开发区', 360821500),
(360821501, 360821, '吉安县工业园区', 360821501),
(360822100, 360822, '文峰镇', 360822100),
(360822101, 360822, '阜田镇', 360822101),
(360822102, 360822, '盘谷镇', 360822102),
(360822103, 360822, '枫江镇', 360822103),
(360822104, 360822, '黄桥镇', 360822104),
(360822105, 360822, '金滩镇', 360822105),
(360822106, 360822, '八都镇', 360822106),
(360822107, 360822, '双村镇', 360822107),
(360822108, 360822, '醪桥镇', 360822108),
(360822109, 360822, '螺田镇', 360822109),
(360822110, 360822, '白沙镇', 360822110),
(360822111, 360822, '白水镇', 360822111),
(360822112, 360822, '丁江镇', 360822112),
(360822113, 360822, '乌江镇', 360822113),
(360822114, 360822, '水南镇', 360822114),
(360822200, 360822, '尚贤乡', 360822200),
(360822201, 360822, '水田乡', 360822201),
(360822202, 360822, '冠山乡', 360822202),
(360822500, 360822, '吉水县工业园区', 360822500),
(360823100, 360823, '水边镇', 360823100),
(360823101, 360823, '马埠镇', 360823101),
(360823102, 360823, '巴邱镇', 360823102),
(360823103, 360823, '仁和镇', 360823103),
(360823104, 360823, '砚溪镇', 360823104),
(360823105, 360823, '罗田镇', 360823105),
(360823200, 360823, '桐林乡', 360823200),
(360823201, 360823, '福民乡', 360823201),
(360823202, 360823, '戈坪乡', 360823202),
(360823203, 360823, '金江乡', 360823203),
(360823400, 360823, '金坪华侨农场', 360823400),
(360823500, 360823, '峡江县工业园区', 360823500),
(360824100, 360824, '金川镇', 360824100),
(360824101, 360824, '三湖镇', 360824101),
(360824102, 360824, '大洋洲镇', 360824102),
(360824103, 360824, '七琴镇', 360824103),
(360824104, 360824, '麦斜镇', 360824104),
(360824200, 360824, '溧江乡', 360824200),
(360824201, 360824, '桃溪乡', 360824201),
(360824202, 360824, '城上乡', 360824202),
(360824203, 360824, '潭丘乡', 360824203),
(360824204, 360824, '神政桥乡', 360824204),
(360824205, 360824, '沂江乡', 360824205),
(360824206, 360824, '界埠乡', 360824206),
(360824207, 360824, '荷浦乡', 360824207),
(360824400, 360824, '洋峰农场', 360824400),
(360824401, 360824, '黎山林场', 360824401),
(360824403, 360824, '263地质大队', 360824403),
(360824500, 360824, '新干工业园区', 360824500),
(360825100, 360825, '恩江镇', 360825100),
(360825101, 360825, '坑田镇', 360825101),
(360825102, 360825, '沿陂镇', 360825102),
(360825103, 360825, '古县镇', 360825103),
(360825104, 360825, '瑶田镇', 360825104),
(360825105, 360825, '藤田镇', 360825105),
(360825106, 360825, '石马镇', 360825106),
(360825107, 360825, '沙溪镇', 360825107),
(360825200, 360825, '佐龙乡', 360825200),
(360825201, 360825, '八江乡', 360825201),
(360825202, 360825, '潭城乡', 360825202),
(360825203, 360825, '鹿冈乡', 360825203),
(360825204, 360825, '七都乡', 360825204),
(360825205, 360825, '陶塘乡', 360825205),
(360825206, 360825, '中村乡', 360825206),
(360825207, 360825, '上溪乡', 360825207),
(360825208, 360825, '潭头乡', 360825208),
(360825209, 360825, '三坊乡', 360825209),
(360825210, 360825, '上固乡', 360825210),
(360825211, 360825, '君埠乡', 360825211),
(360825212, 360825, '龙冈畲族乡', 360825212),
(360825400, 360825, '罗铺垦殖场', 360825400),
(360825402, 360825, '官山林场', 360825402),
(360825500, 360825, '永丰县工业园区', 360825500),
(360826100, 360826, '澄江镇', 360826100),
(360826101, 360826, '碧溪镇', 360826101),
(360826102, 360826, '桥头镇', 360826102),
(360826103, 360826, '禾市镇', 360826103),
(360826104, 360826, '螺溪镇', 360826104),
(360826105, 360826, '苏溪镇', 360826105),
(360826106, 360826, '马市镇', 360826106),
(360826107, 360826, '塘洲镇', 360826107),
(360826108, 360826, '冠朝镇', 360826108),
(360826109, 360826, '沙村镇', 360826109),
(360826110, 360826, '老营盘镇', 360826110),
(360826111, 360826, '小龙镇', 360826111),
(360826112, 360826, '灌溪镇', 360826112),
(360826113, 360826, '苑前镇', 360826113),
(360826114, 360826, '万合镇', 360826114),
(360826115, 360826, '沿溪镇', 360826115),
(360826200, 360826, '石山乡', 360826200),
(360826201, 360826, '南溪乡', 360826201),
(360826202, 360826, '上模乡', 360826202),
(360826203, 360826, '水槎乡', 360826203),
(360826204, 360826, '上圯乡', 360826204),
(360826205, 360826, '中龙乡', 360826205),
(360826400, 360826, '武山垦殖场', 360826400),
(360826401, 360826, '综合垦殖场', 360826401),
(360826402, 360826, '小龙矿区管委会', 360826402),
(360826403, 360826, '八一八矿区', 360826403),
(360826404, 360826, '井冈山机场', 360826404),
(360826500, 360826, '泰和县工业园区', 360826500),
(360827100, 360827, '泉江镇', 360827100),
(360827101, 360827, '雩田镇', 360827101),
(360827102, 360827, '碧洲镇', 360827102),
(360827103, 360827, '草林镇', 360827103),
(360827104, 360827, '堆子前镇', 360827104),
(360827105, 360827, '左安镇', 360827105),
(360827106, 360827, '高坪镇', 360827106),
(360827107, 360827, '大汾镇', 360827107),
(360827108, 360827, '衙前镇', 360827108),
(360827109, 360827, '禾源镇', 360827109),
(360827110, 360827, '汤湖镇', 360827110),
(360827200, 360827, '珠田乡', 360827200),
(360827201, 360827, '巾石乡', 360827201),
(360827202, 360827, '大坑乡', 360827202),
(360827203, 360827, '枚江乡', 360827203),
(360827204, 360827, '双桥乡', 360827204),
(360827205, 360827, '新江乡', 360827205),
(360827206, 360827, '五斗江乡', 360827206),
(360827207, 360827, '西溪乡', 360827207),
(360827208, 360827, '南江乡', 360827208),
(360827209, 360827, '黄坑乡', 360827209),
(360827210, 360827, '戴家埔乡', 360827210),
(360827211, 360827, '营盘圩乡', 360827211),
(360827400, 360827, '五指峰林场', 360827400),
(360827401, 360827, '云岭林场', 360827401),
(360827500, 360827, '遂川县工业园区', 360827500),
(360828100, 360828, '芙蓉镇', 360828100),
(360828101, 360828, '五丰镇', 360828101),
(360828102, 360828, '枧头镇', 360828102),
(360828103, 360828, '窑头镇', 360828103),
(360828104, 360828, '百加镇', 360828104),
(360828105, 360828, '高陂镇', 360828105),
(360828106, 360828, '潞田镇', 360828106),
(360828107, 360828, '沙坪镇', 360828107),
(360828108, 360828, '夏造镇', 360828108),
(360828200, 360828, '罗塘乡', 360828200),
(360828201, 360828, '弹前乡', 360828201),
(360828202, 360828, '武术乡', 360828202),
(360828203, 360828, '宝山乡', 360828203),
(360828204, 360828, '涧田乡', 360828204),
(360828205, 360828, '顺峰乡', 360828205),
(360828206, 360828, '韶口乡', 360828206),
(360828400, 360828, '万安县麻源垦殖场', 360828400),
(360828500, 360828, '万安县工业园', 360828500),
(360829100, 360829, '平都镇', 360829100),
(360829101, 360829, '浒坑镇', 360829101),
(360829102, 360829, '洲湖镇', 360829102),
(360829103, 360829, '横龙镇', 360829103),
(360829104, 360829, '洋溪镇', 360829104),
(360829105, 360829, '严田镇', 360829105),
(360829106, 360829, '枫田镇', 360829106),
(360829200, 360829, '竹江乡', 360829200),
(360829201, 360829, '瓜畲乡', 360829201),
(360829202, 360829, '钱山乡', 360829202),
(360829203, 360829, '赤谷乡', 360829203),
(360829204, 360829, '山庄乡', 360829204),
(360829205, 360829, '洋门乡', 360829205),
(360829206, 360829, '金田乡', 360829206),
(360829207, 360829, '彭坊乡', 360829207),
(360829208, 360829, '泰山乡', 360829208),
(360829209, 360829, '寮塘乡', 360829209),
(360829210, 360829, '甘洛乡', 360829210),
(360829211, 360829, '章庄乡', 360829211),
(360829500, 360829, '安福县工业园', 360829500),
(360830100, 360830, '禾川镇', 360830100),
(360830101, 360830, '石桥镇', 360830101),
(360830102, 360830, '龙源口镇', 360830102),
(360830103, 360830, '里田镇', 360830103),
(360830104, 360830, '龙门镇', 360830104),
(360830105, 360830, '沙市镇', 360830105),
(360830106, 360830, '文竹镇', 360830106),
(360830107, 360830, '埠前镇', 360830107),
(360830108, 360830, '怀忠镇', 360830108),
(360830109, 360830, '高桥楼镇', 360830109),
(360830200, 360830, '坳南乡', 360830200),
(360830201, 360830, '曲白乡', 360830201),
(360830202, 360830, '才丰乡', 360830202),
(360830203, 360830, '烟阁乡', 360830203),
(360830204, 360830, '在中乡', 360830204),
(360830205, 360830, '三湾乡', 360830205),
(360830206, 360830, '台岭乡', 360830206),
(360830207, 360830, '龙田乡', 360830207),
(360830208, 360830, '高溪乡', 360830208),
(360830209, 360830, '莲洲乡', 360830209),
(360830210, 360830, '高市乡', 360830210),
(360830211, 360830, '象形乡', 360830211),
(360830212, 360830, '芦溪乡', 360830212),
(360830500, 360830, '永新县工业园区', 360830500),
(360881001, 360881, '茨坪街道', 360881001),
(360881100, 360881, '厦坪镇', 360881100),
(360881101, 360881, '龙市镇', 360881101),
(360881102, 360881, '古城镇', 360881102),
(360881103, 360881, '新城镇', 360881103),
(360881104, 360881, '大陇镇', 360881104),
(360881200, 360881, '拿山乡', 360881200),
(360881201, 360881, '黄坳乡', 360881201),
(360881202, 360881, '下七乡', 360881202),
(360881203, 360881, '长坪乡', 360881203),
(360881204, 360881, '坳里乡', 360881204),
(360881205, 360881, '鹅岭乡', 360881205),
(360881206, 360881, '柏露乡', 360881206),
(360881207, 360881, '茅坪乡', 360881207),
(360881208, 360881, '葛田乡', 360881208),
(360881209, 360881, '荷花乡', 360881209),
(360881210, 360881, '睦村乡', 360881210),
(360881211, 360881, '东上乡', 360881211),
(360881400, 360881, '井企集团', 360881400),
(360881401, 360881, '井冈山自然保护区', 360881401),
(360881402, 360881, '白石垦殖场', 360881402),
(360881500, 360881, '井冈山市工业园区', 360881500),
(360902001, 360902, '灵泉街道', 360902001),
(360902002, 360902, '秀江街道', 360902002),
(360902004, 360902, '湛郎街道', 360902004),
(360902005, 360902, '珠泉街道', 360902005),
(360902006, 360902, '化成街道', 360902006),
(360902007, 360902, '官园街道', 360902007),
(360902008, 360902, '下浦街道', 360902008),
(360902009, 360902, '凤凰街道', 360902009),
(360902010, 360902, '金园街道', 360902010),
(360902100, 360902, '彬江镇', 360902100),
(360902101, 360902, '西村镇', 360902101),
(360902102, 360902, '金瑞镇', 360902102),
(360902103, 360902, '温汤镇', 360902103),
(360902104, 360902, '三阳镇', 360902104),
(360902105, 360902, '慈化镇', 360902105),
(360902106, 360902, '天台镇', 360902106),
(360902107, 360902, '洪塘镇', 360902107),
(360902200, 360902, '渥江乡', 360902200),
(360902201, 360902, '新坊乡', 360902201),
(360902202, 360902, '洪江乡', 360902202),
(360902203, 360902, '南庙乡', 360902203),
(360902204, 360902, '竹亭乡', 360902204),
(360902205, 360902, '水江乡', 360902205),
(360902206, 360902, '楠木乡', 360902206),
(360902207, 360902, '辽市乡', 360902207),
(360902208, 360902, '寨下乡', 360902208),
(360902209, 360902, '芦村乡', 360902209),
(360902210, 360902, '柏木乡', 360902210),
(360902211, 360902, '湖田乡', 360902211),
(360902212, 360902, '新田乡', 360902212),
(360902213, 360902, '飞剑潭乡', 360902213),
(360902400, 360902, '农牧实验场', 360902400),
(360902401, 360902, '西岭布果园场', 360902401),
(360902402, 360902, '明月山采育林场', 360902402),
(360902403, 360902, '新坊采育林场', 360902403),
(360902404, 360902, '油茶林场', 360902404),
(360902500, 360902, '宜春经济枝术开发区', 360902500),
(360902501, 360902, '袁州区医药工业园', 360902501),
(360921100, 360921, '冯川镇', 360921100),
(360921101, 360921, '赤岸镇', 360921101),
(360921102, 360921, '赤田镇', 360921102),
(360921103, 360921, '宋埠镇', 360921103),
(360921104, 360921, '干洲镇', 360921104),
(360921105, 360921, '澡下镇', 360921105),
(360921106, 360921, '会埠镇', 360921106),
(360921107, 360921, '罗市镇', 360921107),
(360921108, 360921, '上富镇', 360921108),
(360921109, 360921, '甘坊镇', 360921109),
(360921200, 360921, '仰山乡', 360921200),
(360921201, 360921, '澡溪乡', 360921201),
(360921202, 360921, '柳溪乡', 360921202),
(360921400, 360921, '石溪', 360921400),
(360921401, 360921, '百丈山名胜风景区', 360921401),
(360921402, 360921, '干洲垦殖场', 360921402),
(360921403, 360921, '东风垦殖场', 360921403),
(360921404, 360921, '农牧渔良种场', 360921404),
(360921500, 360921, '奉新工业园区', 360921500),
(360922001, 360922, '康乐街道', 360922001),
(360922100, 360922, '株潭镇', 360922100),
(360922101, 360922, '黄茅镇', 360922101),
(360922102, 360922, '潭埠镇', 360922102),
(360922103, 360922, '双桥镇', 360922103),
(360922104, 360922, '高村镇', 360922104),
(360922105, 360922, '罗城镇', 360922105),
(360922106, 360922, '三兴镇', 360922106),
(360922200, 360922, '鹅峰乡', 360922200),
(360922201, 360922, '马步乡', 360922201),
(360922202, 360922, '高城乡', 360922202),
(360922203, 360922, '赤兴乡', 360922203),
(360922204, 360922, '岭东乡', 360922204),
(360922205, 360922, '白水乡', 360922205),
(360922206, 360922, '仙源乡', 360922206),
(360922207, 360922, '白良乡', 360922207),
(360922208, 360922, '茭湖乡', 360922208),
(360922500, 360922, '万载县工业园', 360922500),
(360923001, 360923, '敖阳街道', 360923001),
(360923100, 360923, '田心镇', 360923100),
(360923101, 360923, '徐家渡镇', 360923101),
(360923102, 360923, '锦江镇', 360923102),
(360923103, 360923, '泗溪镇', 360923103),
(360923104, 360923, '翰堂镇', 360923104),
(360923105, 360923, '南港镇', 360923105),
(360923200, 360923, '芦洲乡', 360923200),
(360923201, 360923, '塔下乡', 360923201),
(360923202, 360923, '蒙山乡', 360923202),
(360923203, 360923, '镇渡乡', 360923203),
(360923204, 360923, '野市乡', 360923204),
(360923205, 360923, '新界埠乡', 360923205),
(360923400, 360923, '墨山垦殖场', 360923400),
(360923401, 360923, '上甘山林场', 360923401),
(360923402, 360923, '敖山华侨农场', 360923402),
(360923500, 360923, '上高县工业园区', 360923500),
(360924100, 360924, '新昌镇', 360924100),
(360924101, 360924, '澄塘镇', 360924101),
(360924102, 360924, '棠浦镇', 360924102),
(360924103, 360924, '新庄镇', 360924103),
(360924104, 360924, '潭山镇', 360924104),
(360924105, 360924, '芳溪镇', 360924105),
(360924106, 360924, '石市镇', 360924106),
(360924200, 360924, '花桥乡', 360924200),
(360924201, 360924, '同安乡', 360924201),
(360924202, 360924, '天宝乡', 360924202),
(360924203, 360924, '黄岗乡', 360924203),
(360924204, 360924, '桥西乡', 360924204),
(360924400, 360924, '车上林场', 360924400),
(360924401, 360924, '双峰林场', 360924401),
(360924402, 360924, '石花尖垦殖场', 360924402),
(360924403, 360924, '黄岗山垦殖场', 360924403),
(360924500, 360924, '宜丰县工业园区', 360924500),
(360925100, 360925, '双溪镇', 360925100),
(360925101, 360925, '仁首镇', 360925101),
(360925102, 360925, '宝峰镇', 360925102),
(360925103, 360925, '高湖镇', 360925103),
(360925104, 360925, '躁都镇', 360925104),
(360925200, 360925, '香田乡', 360925200),
(360925201, 360925, '水口乡', 360925201),
(360925202, 360925, '中源乡', 360925202),
(360925203, 360925, '罗湾乡', 360925203),
(360925205, 360925, '三爪仑乡', 360925205),
(360925400, 360925, '雷公尖垦殖场', 360925400),
(360925500, 360925, '靖安县工业园区', 360925500),
(360926100, 360926, '永宁镇', 360926100),
(360926101, 360926, '温泉镇', 360926101),
(360926102, 360926, '棋坪镇', 360926102),
(360926103, 360926, '排埠镇', 360926103),
(360926104, 360926, '三都镇', 360926104),
(360926105, 360926, '大段镇', 360926105),
(360926200, 360926, '高桥乡', 360926200),
(360926201, 360926, '港口乡', 360926201),
(360926202, 360926, '带溪乡', 360926202),
(360926400, 360926, '花山林场', 360926400),
(360926401, 360926, '大沩山林场', 360926401),
(360926402, 360926, '茶山林场', 360926402),
(360926403, 360926, '龙门林场', 360926403),
(360981002, 360981, '剑光街道', 360981002),
(360981006, 360981, '河洲街道', 360981006),
(360981007, 360981, '剑南街道', 360981007),
(360981008, 360981, '孙渡街道', 360981008),
(360981009, 360981, '尚庄街道', 360981009),
(360981101, 360981, '白土镇', 360981101),
(360981102, 360981, '袁渡镇', 360981102),
(360981104, 360981, '张巷镇', 360981104),
(360981105, 360981, '杜市镇', 360981105),
(360981106, 360981, '淘沙镇', 360981106),
(360981107, 360981, '秀市镇', 360981107),
(360981109, 360981, '洛市镇', 360981109),
(360981110, 360981, '铁路镇', 360981110),
(360981111, 360981, '丽村镇', 360981111),
(360981115, 360981, '董家镇', 360981115),
(360981116, 360981, '隍城镇', 360981116),
(360981119, 360981, '小港镇', 360981119),
(360981120, 360981, '石滩镇', 360981120),
(360981121, 360981, '桥东镇', 360981121),
(360981122, 360981, '荣塘镇', 360981122),
(360981123, 360981, '拖船镇', 360981123),
(360981124, 360981, '泉港镇', 360981124),
(360981125, 360981, '梅林镇', 360981125),
(360981126, 360981, '曲江镇', 360981126),
(360981127, 360981, '上塘镇', 360981127),
(360981201, 360981, '筱塘乡', 360981201),
(360981202, 360981, '段潭乡', 360981202),
(360981203, 360981, '蕉坑乡', 360981203),
(360981204, 360981, '石江乡', 360981204),
(360981205, 360981, '荷湖乡', 360981205),
(360981206, 360981, '湖塘乡', 360981206),
(360981207, 360981, '同田乡', 360981207),
(360981400, 360981, '丰城矿务局', 360981400),
(360981401, 360981, '江西省新洛煤电有限责任公司', 360981401),
(360981402, 360981, '丰城市工业园', 360981402),
(360982001, 360982, '淦阳街道', 360982001),
(360982002, 360982, '鹿江街道', 360982002),
(360982003, 360982, '福城街道', 360982003),
(360982004, 360982, '大桥街道', 360982004),
(360982005, 360982, '城北街道', 360982005),
(360982100, 360982, '临江镇', 360982100),
(360982101, 360982, '永泰镇', 360982101),
(360982102, 360982, '黄土岗镇', 360982102),
(360982103, 360982, '经楼镇', 360982103),
(360982104, 360982, '昌付镇', 360982104),
(360982105, 360982, '店下镇', 360982105),
(360982106, 360982, '阁山镇', 360982106),
(360982107, 360982, '刘公庙镇', 360982107),
(360982108, 360982, '观上镇', 360982108),
(360982109, 360982, '义成镇', 360982109),
(360982200, 360982, '中洲乡', 360982200),
(360982201, 360982, '洲上乡', 360982201),
(360982202, 360982, '洋湖乡', 360982202),
(360982203, 360982, '吴城乡', 360982203),
(360982400, 360982, '省双金园艺场', 360982400),
(360982500, 360982, '樟树市工业园', 360982500),
(360983001, 360983, '瑞州街道', 360983001),
(360983002, 360983, '筠阳街道', 360983002),
(360983100, 360983, '蓝坊镇', 360983100),
(360983101, 360983, '荷岭镇', 360983101),
(360983102, 360983, '黄沙岗镇', 360983102),
(360983103, 360983, '新街镇', 360983103),
(360983104, 360983, '八景镇', 360983104),
(360983105, 360983, '独城镇', 360983105),
(360983106, 360983, '太阳镇', 360983106),
(360983107, 360983, '建山镇', 360983107),
(360983108, 360983, '田南镇', 360983108),
(360983109, 360983, '相城镇', 360983109),
(360983110, 360983, '灰埠镇', 360983110),
(360983111, 360983, '石脑镇', 360983111),
(360983112, 360983, '龙潭镇', 360983112),
(360983113, 360983, '杨圩镇', 360983113),
(360983114, 360983, '村前镇', 360983114),
(360983115, 360983, '伍桥镇', 360983115),
(360983116, 360983, '祥符镇', 360983116),
(360983117, 360983, '大城镇', 360983117),
(360983200, 360983, '上湖乡', 360983200),
(360983201, 360983, '汪家圩乡', 360983201),
(360983401, 360983, '相城垦殖场', 360983401),
(360983402, 360983, '上游水库工程管理局', 360983402),
(360983403, 360983, '英岗岭矿务局', 360983403),
(360983404, 360983, '八景煤矿', 360983404),
(360983405, 360983, '江西新茂实业公司', 360983405),
(360983406, 360983, '江西省瑞州监狱', 360983406),
(360983500, 360983, '高安市新世纪工业城管委会', 360983500),
(361002001, 361002, '青云街道', 361002001),
(361002002, 361002, '西大街街道', 361002002),
(361002003, 361002, '荆公路街道', 361002003),
(361002004, 361002, '六水桥街道', 361002004),
(361002005, 361002, '文昌街道', 361002005),
(361002091, 361002, '城西街道办事处(金巢开发区)', 361002091),
(361002092, 361002, '钟岭街道办事处(金巢开发区)', 361002092),
(361002100, 361002, '上顿渡镇', 361002100),
(361002101, 361002, '温泉镇', 361002101),
(361002102, 361002, '高坪镇', 361002102),
(361002103, 361002, '秋溪镇', 361002103),
(361002104, 361002, '荣山镇', 361002104),
(361002105, 361002, '龙溪镇', 361002105),
(361002107, 361002, '大岗镇', 361002107),
(361002108, 361002, '云山镇', 361002108),
(361002109, 361002, '唱凯镇', 361002109),
(361002110, 361002, '罗针镇', 361002110),
(361002111, 361002, '罗湖镇', 361002111),
(361002112, 361002, '太阳镇', 361002112),
(361002113, 361002, '东馆镇', 361002113),
(361002114, 361002, '腾桥镇', 361002114),
(361002115, 361002, '青泥镇', 361002115),
(361002116, 361002, '孝桥镇', 361002116),
(361002117, 361002, '抚北镇', 361002117),
(361002190, 361002, '崇岗镇(金巢开发区)', 361002190),
(361002200, 361002, '展坪乡', 361002200),
(361002201, 361002, '连城乡', 361002201),
(361002202, 361002, '桐源乡', 361002202),
(361002203, 361002, '湖南乡', 361002203),
(361002204, 361002, '七里岗乡', 361002204),
(361002205, 361002, '嵩湖乡', 361002205),
(361002206, 361002, '鹏田乡', 361002206),
(361002207, 361002, '茅排乡', 361002207),
(361002208, 361002, '河埠乡', 361002208),
(361002400, 361002, '荣山垦殖场', 361002400),
(361002401, 361002, '七里岗垦殖场', 361002401),
(361002500, 361002, '开发区管理委员会', 361002500),
(361021100, 361021, '建昌镇', 361021100),
(361021101, 361021, '株良镇', 361021101),
(361021102, 361021, '上唐镇', 361021102),
(361021103, 361021, '里塔镇', 361021103),
(361021104, 361021, '洪门镇', 361021104),
(361021105, 361021, '沙洲镇', 361021105),
(361021106, 361021, '龙湖镇', 361021106),
(361021107, 361021, '新丰街镇', 361021107),
(361021108, 361021, '万坊镇', 361021108),
(361021200, 361021, '徐家乡', 361021200),
(361021201, 361021, '天井源乡', 361021201),
(361021203, 361021, '浔溪乡', 361021203),
(361022100, 361022, '日峰镇', 361022100),
(361022101, 361022, '宏村镇', 361022101),
(361022102, 361022, '洵口镇', 361022102),
(361022103, 361022, '熊村镇', 361022103),
(361022104, 361022, '龙安镇', 361022104),
(361022105, 361022, '德胜镇', 361022105),
(361022200, 361022, '潭溪乡', 361022200),
(361022201, 361022, '湖坊乡', 361022201),
(361022202, 361022, '荷源乡', 361022202),
(361022203, 361022, '厚村乡', 361022203),
(361022204, 361022, '社苹乡', 361022204),
(361022205, 361022, '樟溪乡', 361022205),
(361022206, 361022, '西城乡', 361022206),
(361022207, 361022, '中田乡', 361022207),
(361022400, 361022, '华山垦殖场', 361022400),
(361022500, 361022, '德胜企业集团', 361022500),
(361022501, 361022, '工业园区管委会', 361022501),
(361023100, 361023, '琴城镇', 361023100),
(361023101, 361023, '太和镇', 361023101),
(361023102, 361023, '白舍镇', 361023102),
(361023103, 361023, '市山镇', 361023103),
(361023104, 361023, '洽湾镇', 361023104),
(361023105, 361023, '桑田镇', 361023105),
(361023106, 361023, '紫霄镇', 361023106),
(361023200, 361023, '三溪乡', 361023200),
(361023201, 361023, '东坪乡', 361023201),
(361023202, 361023, '莱溪乡', 361023202),
(361023203, 361023, '太源乡', 361023203),
(361023204, 361023, '付坊乡', 361023204),
(361023400, 361023, '南丰县长红垦殖场', 361023400),
(361023500, 361023, '南丰工业园区', 361023500),
(361024100, 361024, '巴山镇', 361024100),
(361024101, 361024, '相山镇', 361024101),
(361024102, 361024, '航埠镇', 361024102),
(361024103, 361024, '孙坊镇', 361024103),
(361024104, 361024, '河上镇', 361024104),
(361024105, 361024, '礼陂镇', 361024105),
(361024106, 361024, '马鞍镇', 361024106),
(361024200, 361024, '石庄乡', 361024200),
(361024201, 361024, '六家桥乡', 361024201),
(361024202, 361024, '白鹭乡', 361024202),
(361024203, 361024, '三山乡', 361024203),
(361024204, 361024, '白陂乡', 361024204),
(361024205, 361024, '桃源乡', 361024205),
(361024206, 361024, '许坊乡', 361024206),
(361024207, 361024, '郭圩乡', 361024207),
(361025100, 361025, '鳌溪镇', 361025100),
(361025101, 361025, '公溪镇', 361025101),
(361025102, 361025, '山砀镇', 361025102),
(361025103, 361025, '龚坊镇', 361025103),
(361025104, 361025, '戴坊镇', 361025104),
(361025105, 361025, '牛田镇', 361025105),
(361025106, 361025, '万崇镇', 361025106),
(361025107, 361025, '增田镇', 361025107),
(361025108, 361025, '招携镇', 361025108),
(361025200, 361025, '湖溪乡', 361025200),
(361025201, 361025, '罗陂乡', 361025201),
(361025202, 361025, '湖坪乡', 361025202),
(361025203, 361025, '南村乡', 361025203),
(361025204, 361025, '谷岗乡', 361025204),
(361025205, 361025, '金竹畲族乡', 361025205),
(361025400, 361025, '大马头垦殖场', 361025400),
(361025401, 361025, '流坑管理局', 361025401),
(361026100, 361026, '凤冈镇', 361026100),
(361026101, 361026, '棠阴镇', 361026101),
(361026102, 361026, '黄陂镇', 361026102),
(361026103, 361026, '东陂镇', 361026103),
(361026104, 361026, '梨溪镇', 361026104),
(361026105, 361026, '二都镇', 361026105),
(361026200, 361026, '中港乡', 361026200),
(361026201, 361026, '新丰乡', 361026201),
(361026202, 361026, '神冈乡', 361026202),
(361026203, 361026, '圳口乡', 361026203),
(361026204, 361026, '南源乡', 361026204),
(361026205, 361026, '桃陂乡', 361026205),
(361026400, 361026, '黄柏岭垦殖场', 361026400),
(361026401, 361026, '青年垦殖场', 361026401),
(361026500, 361026, '宜黄县工业园区', 361026500),
(361027100, 361027, '秀谷镇', 361027100),
(361027101, 361027, '浒湾镇', 361027101),
(361027102, 361027, '双塘镇', 361027102),
(361027103, 361027, '何源镇', 361027103),
(361027104, 361027, '合市镇', 361027104),
(361027105, 361027, '琅琚镇', 361027105),
(361027106, 361027, '左坊镇', 361027106),
(361027200, 361027, '黄通乡', 361027200),
(361027201, 361027, '对桥乡', 361027201),
(361027202, 361027, '陆坊乡', 361027202),
(361027203, 361027, '陈坊积乡', 361027203),
(361027204, 361027, '琉璃乡', 361027204),
(361027205, 361027, '石门乡', 361027205),
(361027400, 361027, '华侨农场', 361027400),
(361028100, 361028, '鹤城镇', 361028100),
(361028101, 361028, '马头山镇', 361028101),
(361028102, 361028, '高埠镇', 361028102),
(361028103, 361028, '嵩市镇', 361028103),
(361028104, 361028, '乌石镇', 361028104),
(361028200, 361028, '高田乡', 361028200),
(361028201, 361028, '石峡乡', 361028201),
(361029100, 361029, '孝岗镇', 361029100),
(361029101, 361029, '小璜镇', 361029101),
(361029102, 361029, '圩上桥镇', 361029102),
(361029103, 361029, '马圩镇', 361029103),
(361029104, 361029, '詹圩镇', 361029104),
(361029105, 361029, '岗上积镇', 361029105),
(361029106, 361029, '杨桥殿镇', 361029106),
(361029107, 361029, '黎圩镇', 361029107),
(361029108, 361029, '王桥镇', 361029108),
(361029200, 361029, '珀玕乡', 361029200),
(361029201, 361029, '邓家乡', 361029201),
(361029202, 361029, '虎圩乡', 361029202),
(361029203, 361029, '瑶圩乡', 361029203),
(361029400, 361029, '红星企业集团', 361029400),
(361029401, 361029, '红光垦殖场', 361029401),
(361029402, 361029, '红亮垦殖场', 361029402),
(361029403, 361029, '甘坑林场', 361029403),
(361029404, 361029, '江西铜业集团公司东同矿业有限责任公司', 361029404),
(361029405, 361029, '江西磷肥厂', 361029405),
(361029500, 361029, '江西红星工业园区', 361029500),
(361029501, 361029, '大富工业园区', 361029501),
(361030100, 361030, '盱江镇', 361030100),
(361030101, 361030, '头陂镇', 361030101),
(361030103, 361030, '赤水镇', 361030103),
(361030104, 361030, '驿前镇', 361030104),
(361030105, 361030, '甘竹镇', 361030105),
(361030200, 361030, '千善乡', 361030200),
(361030201, 361030, '水南圩乡', 361030201),
(361030202, 361030, '长桥乡', 361030202),
(361030203, 361030, '杨溪乡', 361030203),
(361030204, 361030, '尖峰乡', 361030204),
(361030205, 361030, '塘坊乡', 361030205),
(361030400, 361030, '翠雷山垦殖场', 361030400),
(361030500, 361030, '广昌县工业园区', 361030500),
(361102001, 361102, '水南街道', 361102001),
(361102002, 361102, '东市街道', 361102002),
(361102003, 361102, '西市街道', 361102003),
(361102004, 361102, '北门街道', 361102004),
(361102005, 361102, '茅家岭街道', 361102005),
(361102100, 361102, '沙溪镇', 361102100),
(361102101, 361102, '灵溪镇', 361102101),
(361102201, 361102, '秦峰乡', 361102201),
(361102202, 361102, '朝阳乡', 361102202),
(361102570, 361102, '凤凰工业园区(上饶经济开发区)', 361102570),
(361102571, 361102, '三江工业基地(上饶经济开发区)', 361102571),
(361121001, 361121, '旭日街道', 361121001),
(361121002, 361121, '罗桥街道', 361121002),
(361121101, 361121, '田墩镇', 361121101),
(361121102, 361121, '上泸镇', 361121102),
(361121103, 361121, '华坛山镇', 361121103),
(361121104, 361121, '茶亭镇', 361121104),
(361121105, 361121, '皂头镇', 361121105),
(361121106, 361121, '四十八镇', 361121106),
(361121107, 361121, '枫岭头镇', 361121107),
(361121108, 361121, '煌固镇', 361121108),
(361121109, 361121, '花厅镇', 361121109),
(361121110, 361121, '五府山镇', 361121110),
(361121111, 361121, '郑坊镇', 361121111),
(361121200, 361121, '望仙乡', 361121200),
(361121201, 361121, '石人乡', 361121201),
(361121202, 361121, '清水乡', 361121202),
(361121203, 361121, '石狮乡', 361121203),
(361121204, 361121, '湖村乡', 361121204),
(361121207, 361121, '尊桥乡', 361121207),
(361121209, 361121, '应家乡', 361121209),
(361121210, 361121, '黄沙岭乡', 361121210),
(361121211, 361121, '铁山乡', 361121211),
(361121270, 361121, '董团乡(上饶经济开发区）', 361121270),
(361122001, 361122, '永丰街道', 361122001),
(361122002, 361122, '芦林街道', 361122002),
(361122003, 361122, '丰溪街道', 361122003),
(361122101, 361122, '五都镇', 361122101),
(361122102, 361122, '洋口镇', 361122102),
(361122103, 361122, '横山镇', 361122103),
(361122104, 361122, '桐畈镇', 361122104),
(361122105, 361122, '湖丰镇', 361122105),
(361122106, 361122, '大南镇', 361122106),
(361122107, 361122, '排山镇', 361122107),
(361122108, 361122, '毛村镇', 361122108),
(361122109, 361122, '枧底镇', 361122109),
(361122110, 361122, '泉波镇', 361122110),
(361122111, 361122, '壶峤镇', 361122111),
(361122112, 361122, '霞峰镇', 361122112),
(361122113, 361122, '下溪镇', 361122113),
(361122114, 361122, '吴村镇', 361122114),
(361122115, 361122, '沙田镇', 361122115),
(361122116, 361122, '铜拔山镇', 361122116),
(361122200, 361122, '大石乡', 361122200),
(361122202, 361122, '东阳乡', 361122202),
(361122204, 361122, '嵩峰乡', 361122204),
(361122206, 361122, '少阳乡', 361122206),
(361122400, 361122, '铜钹山垦殖场', 361122400),
(361122500, 361122, '芦林工业园区管理委员会', 361122500),
(361123100, 361123, '冰溪镇', 361123100),
(361123101, 361123, '临湖镇', 361123101),
(361123102, 361123, '必姆镇', 361123102),
(361123103, 361123, '横街镇', 361123103),
(361123104, 361123, '文成镇', 361123104),
(361123105, 361123, '下镇镇', 361123105),
(361123107, 361123, '岩瑞镇', 361123107),
(361123108, 361123, '双明镇', 361123108),
(361123109, 361123, '紫湖镇', 361123109),
(361123110, 361123, '仙岩镇', 361123110),
(361123111, 361123, '樟村镇', 361123111),
(361123198, 361123, '枫林镇', 361123198),
(361123200, 361123, '南山乡', 361123200),
(361123201, 361123, '怀玉乡', 361123201),
(361123202, 361123, '下塘乡', 361123202),
(361123203, 361123, '四股桥乡', 361123203),
(361123204, 361123, '六都乡', 361123204),
(361123290, 361123, '三清乡', 361123290),
(361123500, 361123, '金山工业园', 361123500),
(361124100, 361124, '河口镇', 361124100),
(361124101, 361124, '永平镇', 361124101),
(361124102, 361124, '石塘镇', 361124102),
(361124103, 361124, '鹅湖镇', 361124103),
(361124105, 361124, '湖坊镇', 361124105),
(361124106, 361124, '武夷山镇', 361124106),
(361124108, 361124, '汪二镇', 361124108),
(361124200, 361124, '陈坊乡', 361124200),
(361124201, 361124, '虹桥乡', 361124201),
(361124202, 361124, '新滩乡', 361124202),
(361124203, 361124, '葛仙山乡', 361124203),
(361124205, 361124, '稼轩乡', 361124205),
(361124206, 361124, '英将乡', 361124206),
(361124207, 361124, '紫溪乡', 361124207),
(361124208, 361124, '太源畲族乡', 361124208),
(361124209, 361124, '天柱山乡', 361124209),
(361124210, 361124, '篁碧畲族乡', 361124210),
(361124400, 361124, '国营铅山县河口茶叶实验场', 361124400),
(361124401, 361124, '国营铅山县畜牧良种繁殖场', 361124401),
(361124402, 361124, '国营铅山县鱼种场', 361124402),
(361124403, 361124, '铅山县水稻良种场', 361124403),
(361124404, 361124, '铅山县农业科学研究所', 361124404),
(361124405, 361124, '铅山县国营森林苗圃', 361124405),
(361124500, 361124, '江西铜业集团公司永铜分公司', 361124500),
(361124501, 361124, '江西武夷山国家级自然保护区管理局', 361124501),
(361124502, 361124, '鹅湖书院文物管理保护所', 361124502),
(361124503, 361124, '铅山县工业园区开发管理委员会', 361124503),
(361125100, 361125, '岑阳镇', 361125100),
(361125101, 361125, '葛源镇', 361125101),
(361125200, 361125, '姚家乡', 361125200),
(361125201, 361125, '莲荷乡', 361125201),
(361125202, 361125, '司铺乡', 361125202),
(361125203, 361125, '港边乡', 361125203),
(361125204, 361125, '龙门畈乡', 361125204),
(361125205, 361125, '青板乡', 361125205),
(361125206, 361125, '新篁乡（办事处）', 361125206),
(361125400, 361125, '红桥垦殖场', 361125400),
(361125500, 361125, '兴安工业园区', 361125500),
(361125501, 361125, '铺前煤矿', 361125501),
(361125502, 361125, '上坑源林场', 361125502),
(361125503, 361125, '山黄林场', 361125503),
(361126101, 361126, '曹溪镇', 361126101),
(361126102, 361126, '漆工镇', 361126102),
(361126103, 361126, '樟树墩镇', 361126103),
(361126104, 361126, '南岩镇', 361126104),
(361126105, 361126, '朱坑镇', 361126105),
(361126106, 361126, '圭峰镇', 361126106),
(361126107, 361126, '叠山镇', 361126107),
(361126108, 361126, '港口镇', 361126108),
(361126109, 361126, '弋江镇', 361126109),
(361126200, 361126, '三县岭乡', 361126200),
(361126202, 361126, '中畈乡', 361126202),
(361126203, 361126, '葛溪乡', 361126203),
(361126204, 361126, '湾里乡', 361126204),
(361126205, 361126, '花亭乡', 361126205),
(361126206, 361126, '清湖乡', 361126206),
(361126208, 361126, '旭光乡', 361126208),
(361126500, 361126, '圭峰风景管理区', 361126500),
(361126501, 361126, '连胜工业园', 361126501),
(361126502, 361126, '城南工业园', 361126502),
(361127100, 361127, '玉亭镇', 361127100),
(361127101, 361127, '瑞洪镇', 361127101),
(361127102, 361127, '黄金埠镇', 361127102),
(361127104, 361127, '古埠镇', 361127104),
(361127105, 361127, '乌泥镇', 361127105),
(361127106, 361127, '石口镇', 361127106),
(361127107, 361127, '杨埠镇', 361127107),
(361127108, 361127, '九龙镇', 361127108),
(361127200, 361127, '康山乡', 361127200),
(361127202, 361127, '东塘乡', 361127202),
(361127204, 361127, '大塘乡', 361127204),
(361127206, 361127, '鹭鸶港乡', 361127206),
(361127207, 361127, '三塘乡', 361127207),
(361127209, 361127, '洪家嘴乡', 361127209),
(361127210, 361127, '白马桥乡', 361127210),
(361127211, 361127, '江埠乡', 361127211),
(361127213, 361127, '枫港乡', 361127213),
(361127214, 361127, '大溪乡', 361127214),
(361127217, 361127, '梅港乡', 361127217),
(361127218, 361127, '社赓乡', 361127218),
(361127402, 361127, '渔池湖水产场', 361127402),
(361127403, 361127, '县良种场', 361127403),
(361127404, 361127, '李梅林场', 361127404),
(361127405, 361127, '康山垦总场', 361127405),
(361127406, 361127, '禾斛岭垦殖场', 361127406),
(361127407, 361127, '峡山林场', 361127407),
(361127408, 361127, '信丰垦殖场', 361127408),
(361127500, 361127, '马背嘴工业园区', 361127500),
(361127501, 361127, '城西工业园区', 361127501),
(361127502, 361127, '城北开发区', 361127502),
(361128100, 361128, '鄱阳镇', 361128100),
(361128101, 361128, '谢家滩镇', 361128101),
(361128102, 361128, '石门街镇', 361128102),
(361128103, 361128, '四十里街镇', 361128103),
(361128104, 361128, '油墩街镇', 361128104),
(361128105, 361128, '田畈街镇', 361128105),
(361128106, 361128, '金盘岭镇', 361128106),
(361128107, 361128, '高家岭镇', 361128107),
(361128108, 361128, '凰岗镇', 361128108),
(361128109, 361128, '双港镇', 361128109),
(361128110, 361128, '古县渡镇', 361128110),
(361128111, 361128, '饶丰镇', 361128111),
(361128112, 361128, '乐丰镇', 361128112),
(361128113, 361128, '饶埠镇', 361128113),
(361128201, 361128, '侯家岗乡', 361128201),
(361128202, 361128, '莲花山乡', 361128202),
(361128203, 361128, '响水滩乡', 361128203),
(361128206, 361128, '枧田街乡', 361128206),
(361128207, 361128, '柘港乡', 361128207),
(361128208, 361128, '鸦鹊湖乡', 361128208),
(361128209, 361128, '银宝湖乡', 361128209),
(361128210, 361128, '游城乡', 361128210),
(361128211, 361128, '珠湖乡', 361128211),
(361128212, 361128, '白沙洲乡', 361128212),
(361128213, 361128, '团林乡', 361128213),
(361128215, 361128, '昌洲乡', 361128215),
(361128216, 361128, '庙前乡', 361128216),
(361128217, 361128, '莲湖乡', 361128217),
(361128218, 361128, '芦田乡', 361128218),
(361128401, 361128, '农科所', 361128401),
(361128402, 361128, '饶洲监狱', 361128402),
(361129100, 361129, '陈营镇', 361129100),
(361129101, 361129, '石镇镇', 361129101),
(361129102, 361129, '青云镇', 361129102),
(361129103, 361129, '梓埠镇', 361129103),
(361129104, 361129, '大源镇', 361129104),
(361129105, 361129, '裴梅镇', 361129105),
(361129200, 361129, '湖云乡', 361129200),
(361129201, 361129, '齐埠乡', 361129201),
(361129203, 361129, '汪家乡', 361129203),
(361129205, 361129, '上坊乡', 361129205),
(361129206, 361129, '苏桥乡', 361129206),
(361129208, 361129, '珠田乡', 361129208),
(361129400, 361129, '林科所', 361129400),
(361130100, 361130, '紫阳镇', 361130100),
(361130101, 361130, '清华镇', 361130101),
(361130102, 361130, '秋口镇', 361130102),
(361130103, 361130, '江湾镇', 361130103),
(361130104, 361130, '思口镇', 361130104),
(361130106, 361130, '赋春镇', 361130106),
(361130107, 361130, '镇头镇', 361130107),
(361130109, 361130, '太白镇', 361130109),
(361130110, 361130, '中云镇', 361130110),
(361130111, 361130, '许村镇', 361130111),
(361130200, 361130, '溪头乡', 361130200),
(361130201, 361130, '段莘乡', 361130201),
(361130204, 361130, '浙源乡', 361130204),
(361130205, 361130, '沱川乡', 361130205),
(361130206, 361130, '大鄣山乡', 361130206),
(361130208, 361130, '珍珠山乡', 361130208),
(361181001, 361181, '银城街道', 361181001),
(361181103, 361181, '绕二镇', 361181103),
(361181105, 361181, '海口镇', 361181105),
(361181106, 361181, '新岗山镇', 361181106),
(361181107, 361181, '泗洲镇', 361181107),
(361181190, 361181, '花桥镇(大茅山经济开发区)', 361181190),
(361181200, 361181, '黄柏乡', 361181200),
(361181201, 361181, '万村乡', 361181201),
(361181202, 361181, '张村乡', 361181202),
(361181203, 361181, '皈大乡', 361181203),
(361181204, 361181, '李宅乡', 361181204),
(361181205, 361181, '龙头山乡', 361181205),
(361181401, 361181, '江西省德兴铜矿', 361181401),
(361181490, 361181, '大茅山集团公司(大茅山经济开发区)', 361181490),
(370102001, 370102, '解放路街道', 370102001),
(370102002, 370102, '千佛山街道', 370102002),
(370102003, 370102, '趵突泉街道', 370102003),
(370102004, 370102, '泉城路街道', 370102004),
(370102005, 370102, '大明湖街道', 370102005),
(370102006, 370102, '东关街道', 370102006),
(370102007, 370102, '文东街道', 370102007),
(370102008, 370102, '建新街道', 370102008),
(370102009, 370102, '甸柳街道', 370102009),
(370102010, 370102, '燕山街道', 370102010),
(370102100, 370102, '姚家镇', 370102100),
(370103002, 370103, '大观园街道', 370103002),
(370103003, 370103, '杆石桥街道', 370103003),
(370103004, 370103, '四里村街道', 370103004),
(370103006, 370103, '魏家庄街道', 370103006),
(370103008, 370103, '二七街道', 370103008),
(370103009, 370103, '七里山街道', 370103009),
(370103010, 370103, '六里山街道', 370103010),
(370103012, 370103, '舜玉路街道', 370103012),
(370103014, 370103, '泺源街道', 370103014),
(370103015, 370103, '王官庄街道', 370103015),
(370103016, 370103, '舜耕街道', 370103016),
(370103017, 370103, '白马山街道', 370103017),
(370103018, 370103, '七贤街道', 370103018),
(370103101, 370103, '党家庄镇', 370103101),
(370103102, 370103, '十六里河镇', 370103102),
(370104001, 370104, '振兴街街道', 370104001),
(370104002, 370104, '中大槐树街道', 370104002),
(370104003, 370104, '道德街街道', 370104003),
(370104004, 370104, '西市场街道', 370104004),
(370104005, 370104, '五里沟街道', 370104005),
(370104006, 370104, '营市街街道', 370104006),
(370104007, 370104, '青年公园街道', 370104007),
(370104008, 370104, '南辛庄街道', 370104008),
(370104009, 370104, '段店北路街道', 370104009),
(370104010, 370104, '张庄路街道', 370104010),
(370104011, 370104, '匡山街道', 370104011),
(370104012, 370104, '美里湖街道', 370104012),
(370104100, 370104, '吴家堡镇', 370104100),
(370104101, 370104, '段店镇', 370104101),
(370105001, 370105, '无影山街道', 370105001),
(370105003, 370105, '天桥东街街道', 370105003),
(370105004, 370105, '北村街道', 370105004),
(370105005, 370105, '南村街道', 370105005),
(370105006, 370105, '堤口路街道', 370105006),
(370105007, 370105, '北坦街道', 370105007),
(370105009, 370105, '制锦市街道', 370105009),
(370105010, 370105, '宝华街道', 370105010),
(370105011, 370105, '官扎营街道', 370105011),
(370105012, 370105, '纬北路街道', 370105012),
(370105013, 370105, '药山街道', 370105013),
(370105014, 370105, '北园街道', 370105014),
(370105015, 370105, '泺口街道', 370105015),
(370105101, 370105, '桑梓店镇', 370105101),
(370105102, 370105, '大桥镇', 370105102),
(370112001, 370112, '山大路街道', 370112001),
(370112002, 370112, '洪家楼街道', 370112002),
(370112003, 370112, '东风街道', 370112003),
(370112004, 370112, '全福街道', 370112004),
(370112101, 370112, '仲宫镇', 370112101),
(370112102, 370112, '港沟镇', 370112102),
(370112103, 370112, '柳埠镇', 370112103),
(370112104, 370112, '孙村镇', 370112104),
(370112105, 370112, '郭店镇', 370112105),
(370112106, 370112, '董家镇', 370112106),
(370112107, 370112, '唐王镇', 370112107),
(370112108, 370112, '遥墙镇', 370112108),
(370112109, 370112, '王舍人镇', 370112109),
(370112110, 370112, '华山镇', 370112110),
(370112111, 370112, '西营镇', 370112111),
(370112112, 370112, '彩石镇', 370112112),
(370113001, 370113, '文昌街街道', 370113001),
(370113002, 370113, '崮云湖街道', 370113002),
(370113003, 370113, '平安街道', 370113003),
(370113004, 370113, '五峰山街道', 370113004),
(370113101, 370113, '归德镇', 370113101),
(370113102, 370113, '孝里镇', 370113102),
(370113103, 370113, '万德镇', 370113103),
(370113106, 370113, '张夏镇', 370113106),
(370113107, 370113, '马山镇', 370113107),
(370113200, 370113, '双泉乡', 370113200),
(370124100, 370124, '平阴镇', 370124100),
(370124102, 370124, '东阿镇', 370124102),
(370124103, 370124, '孝直镇', 370124103),
(370124104, 370124, '孔村镇', 370124104),
(370124105, 370124, '洪范池镇', 370124105),
(370124106, 370124, '玫瑰镇', 370124106),
(370124201, 370124, '安城乡', 370124201),
(370125100, 370125, '济阳镇', 370125100),
(370125101, 370125, '垛石镇', 370125101),
(370125102, 370125, '孙耿镇', 370125102),
(370125103, 370125, '曲堤镇', 370125103),
(370125104, 370125, '仁风镇', 370125104),
(370125107, 370125, '崔寨镇', 370125107),
(370125108, 370125, '太平镇', 370125108),
(370125206, 370125, '新市乡', 370125206),
(370126001, 370126, '1、许商街道', 370126001),
(370126002, 370126, '2、玉皇庙街道', 370126002),
(370126101, 370126, '3、殷巷镇', 370126101),
(370126102, 370126, '4、怀仁镇', 370126102),
(370126104, 370126, '5、龙桑寺镇', 370126104),
(370126105, 370126, '6、郑路镇', 370126105),
(370126106, 370126, '7、贾庄镇', 370126106),
(370126201, 370126, '8、孙集乡', 370126201),
(370126204, 370126, '9、沙河乡', 370126204),
(370126205, 370126, '10、韩庙乡', 370126205),
(370126207, 370126, '11、张坊乡', 370126207),
(370126212, 370126, '12、白桥乡', 370126212),
(370181001, 370181, '明水街道', 370181001),
(370181002, 370181, '双山街道', 370181002),
(370181003, 370181, '枣园街道', 370181003),
(370181004, 370181, '龙山街道', 370181004),
(370181005, 370181, '埠村街道', 370181005),
(370181006, 370181, '圣井街道', 370181006),
(370181101, 370181, '普集镇', 370181101),
(370181103, 370181, '绣惠镇', 370181103),
(370181104, 370181, '相公庄镇', 370181104),
(370181105, 370181, '垛庄镇', 370181105),
(370181106, 370181, '水寨镇', 370181106),
(370181109, 370181, '文祖镇', 370181109),
(370181110, 370181, '刁镇', 370181110),
(370181111, 370181, '曹范镇', 370181111),
(370181113, 370181, '白云湖镇', 370181113),
(370181114, 370181, '高官寨镇', 370181114),
(370181115, 370181, '宁家埠镇', 370181115),
(370181201, 370181, '官庄乡', 370181201),
(370181203, 370181, '辛寨乡', 370181203),
(370181204, 370181, '黄河乡', 370181204),
(370202001, 370202, '香港中路街道', 370202001),
(370202002, 370202, '八大峡街道', 370202002),
(370202003, 370202, '台西街道', 370202003),
(370202004, 370202, '云南路街道', 370202004);
INSERT INTO `{pre}areas` VALUES
(370202005, 370202, '中山街道', 370202005),
(370202006, 370202, '观海路街道', 370202006),
(370202007, 370202, '江苏路街道', 370202007),
(370202008, 370202, '金口路街道', 370202008),
(370202009, 370202, '八大关街道', 370202009),
(370202010, 370202, '湛山街道', 370202010),
(370202011, 370202, '金湖路街道', 370202011),
(370202012, 370202, '八大湖街道', 370202012),
(370202013, 370202, '金门路街道', 370202013),
(370202014, 370202, '珠海路街道', 370202014),
(370203001, 370203, '冠县路街道', 370203001),
(370203002, 370203, '胶州路街道', 370203002),
(370203003, 370203, '黄台路街道', 370203003),
(370203004, 370203, '热河路街道', 370203004),
(370203005, 370203, '辽宁路街道', 370203005),
(370203006, 370203, '北仲路街道', 370203006),
(370203007, 370203, '威海路街道', 370203007),
(370203008, 370203, '延安路街道', 370203008),
(370203009, 370203, '泰山路街道', 370203009),
(370203010, 370203, '华阳路街道', 370203010),
(370203011, 370203, '登州路街道', 370203011),
(370203012, 370203, '利津路街道', 370203012),
(370203013, 370203, '宁夏路街道', 370203013),
(370203014, 370203, '敦化路街道', 370203014),
(370203015, 370203, '辽源路街道', 370203015),
(370203016, 370203, '合肥路街道', 370203016),
(370203017, 370203, '浮山后社区事务受理中心街道', 370203017),
(370205001, 370205, '阜新路街道', 370205001),
(370205002, 370205, '海伦路街道', 370205002),
(370205003, 370205, '嘉兴路街道', 370205003),
(370205004, 370205, '兴隆路街道', 370205004),
(370205005, 370205, '水清沟街道', 370205005),
(370205006, 370205, '洛阳路街道', 370205006),
(370205007, 370205, '河西街道', 370205007),
(370211001, 370211, '黄岛街道', 370211001),
(370211002, 370211, '辛安街道', 370211002),
(370211003, 370211, '薛家岛街道', 370211003),
(370211004, 370211, '柳花泊街道', 370211004),
(370211005, 370211, '长江路街道', 370211005),
(370211006, 370211, '红石崖街道', 370211006),
(370212001, 370212, '中韩街道', 370212001),
(370212002, 370212, '沙子口街道', 370212002),
(370212003, 370212, '王哥庄街道', 370212003),
(370212004, 370212, '北宅街道', 370212004),
(370213001, 370213, '振华路街道', 370213001),
(370213002, 370213, '永清路街道', 370213002),
(370213003, 370213, '永安路街道', 370213003),
(370213004, 370213, '兴华路街道', 370213004),
(370213005, 370213, '兴城路街道', 370213005),
(370213006, 370213, '李村街道', 370213006),
(370213007, 370213, '虎山路街道', 370213007),
(370213008, 370213, '浮山路街道', 370213008),
(370213009, 370213, '九水路街道', 370213009),
(370213010, 370213, '湘潭路街道', 370213010),
(370213011, 370213, '楼山街道', 370213011),
(370214001, 370214, '城阳街道', 370214001),
(370214002, 370214, '夏庄街道', 370214002),
(370214003, 370214, '流亭街道', 370214003),
(370214004, 370214, '棘洪滩街道', 370214004),
(370214005, 370214, '上马街道', 370214005),
(370214006, 370214, '红岛街道', 370214006),
(370214007, 370214, '河套街道', 370214007),
(370214008, 370214, '惜福镇街道', 370214008),
(370281001, 370281, '阜安街道', 370281001),
(370281002, 370281, '中云街道', 370281002),
(370281003, 370281, '北关街道', 370281003),
(370281004, 370281, '南关街道', 370281004),
(370281005, 370281, '云溪街道', 370281005),
(370281100, 370281, '胶莱镇', 370281100),
(370281101, 370281, '马店镇', 370281101),
(370281102, 370281, '李哥庄镇', 370281102),
(370281104, 370281, '营海镇', 370281104),
(370281105, 370281, '铺集镇', 370281105),
(370281106, 370281, '张应镇', 370281106),
(370281108, 370281, '里岔镇', 370281108),
(370281109, 370281, '胶东镇', 370281109),
(370281110, 370281, '胶西镇', 370281110),
(370281111, 370281, '洋河镇', 370281111),
(370281112, 370281, '九龙镇', 370281112),
(370281113, 370281, '杜村镇', 370281113),
(370281114, 370281, '胶北镇', 370281114),
(370282001, 370282, '环秀街道', 370282001),
(370282002, 370282, '潮海街道', 370282002),
(370282003, 370282, '通济街道', 370282003),
(370282004, 370282, '北安街道', 370282004),
(370282005, 370282, '龙山街道', 370282005),
(370282101, 370282, '鳌山卫镇', 370282101),
(370282102, 370282, '温泉镇', 370282102),
(370282103, 370282, '龙泉镇', 370282103),
(370282104, 370282, '刘家庄镇', 370282104),
(370282105, 370282, '蓝村镇', 370282105),
(370282106, 370282, '店集镇', 370282106),
(370282107, 370282, '灵山镇', 370282107),
(370282108, 370282, '七级镇', 370282108),
(370282110, 370282, '王村镇', 370282110),
(370282112, 370282, '丰城镇', 370282112),
(370282115, 370282, '段泊岚镇', 370282115),
(370282117, 370282, '移风店镇', 370282117),
(370282118, 370282, '普东镇', 370282118),
(370282119, 370282, '大信镇', 370282119),
(370282121, 370282, '田横镇', 370282121),
(370282122, 370282, '金口镇', 370282122),
(370282123, 370282, '华山镇', 370282123),
(370282124, 370282, '南泉镇', 370282124),
(370283001, 370283, '城关街道', 370283001),
(370283002, 370283, '李园街道', 370283002),
(370283003, 370283, '同和街道', 370283003),
(370283004, 370283, '香店街道', 370283004),
(370283100, 370283, '麻兰镇', 370283100),
(370283101, 370283, '古岘镇', 370283101),
(370283102, 370283, '仁兆镇', 370283102),
(370283103, 370283, '张戈庄镇', 370283103),
(370283104, 370283, '郭庄镇', 370283104),
(370283105, 370283, '南村镇', 370283105),
(370283106, 370283, '兰底镇', 370283106),
(370283107, 370283, '万家镇', 370283107),
(370283108, 370283, '蓼兰镇', 370283108),
(370283109, 370283, '崔家集镇', 370283109),
(370283110, 370283, '明村镇', 370283110),
(370283111, 370283, '白埠镇', 370283111),
(370283112, 370283, '门村镇', 370283112),
(370283113, 370283, '田庄镇', 370283113),
(370283114, 370283, '马戈庄镇', 370283114),
(370283115, 370283, '张舍镇', 370283115),
(370283116, 370283, '新河镇', 370283116),
(370283117, 370283, '灰埠镇', 370283117),
(370283118, 370283, '长乐镇', 370283118),
(370283119, 370283, '店子镇', 370283119),
(370283120, 370283, '大泽山镇', 370283120),
(370283121, 370283, '大田镇', 370283121),
(370283122, 370283, '旧店镇', 370283122),
(370283123, 370283, '祝沟镇', 370283123),
(370283124, 370283, '云山镇', 370283124),
(370283125, 370283, '崔召镇', 370283125),
(370283400, 370283, '平度外向型工业加工', 370283400),
(370284001, 370284, '珠山街道', 370284001),
(370284002, 370284, '珠海街道', 370284002),
(370284003, 370284, '隐珠街道', 370284003),
(370284004, 370284, '灵山卫街道', 370284004),
(370284005, 370284, '铁山街道', 370284005),
(370284006, 370284, '滨海街道', 370284006),
(370284102, 370284, '琅琊镇', 370284102),
(370284103, 370284, '泊里镇', 370284103),
(370284104, 370284, '大场镇', 370284104),
(370284105, 370284, '大村镇', 370284105),
(370284106, 370284, '六汪镇', 370284106),
(370284107, 370284, '王台镇', 370284107),
(370284110, 370284, '张家楼镇', 370284110),
(370284112, 370284, '海青镇', 370284112),
(370284113, 370284, '宝山镇', 370284113),
(370284115, 370284, '藏南镇', 370284115),
(370284116, 370284, '理务关镇（乡改镇）', 370284116),
(370285001, 370285, '水集街道', 370285001),
(370285002, 370285, '望城街道', 370285002),
(370285004, 370285, '龙水街道', 370285004),
(370285005, 370285, '梅花山街道', 370285005),
(370285006, 370285, '滨河路街道', 370285006),
(370285007, 370285, '沽河街道', 370285007),
(370285100, 370285, '孙受镇', 370285100),
(370285101, 370285, '姜山镇', 370285101),
(370285102, 370285, '夏格庄镇', 370285102),
(370285104, 370285, '院上镇', 370285104),
(370285105, 370285, '日庄镇', 370285105),
(370285106, 370285, '南墅镇', 370285106),
(370285107, 370285, '河头店镇', 370285107),
(370285108, 370285, '店埠镇', 370285108),
(370285109, 370285, '李权庄镇', 370285109),
(370285112, 370285, '武备镇', 370285112),
(370285116, 370285, '马连庄镇', 370285116),
(370302001, 370302, '般阳路街道', 370302001),
(370302002, 370302, '松龄路街道', 370302002),
(370302003, 370302, '商城路街道', 370302003),
(370302004, 370302, '钟楼街道', 370302004),
(370302101, 370302, '城南镇', 370302101),
(370302102, 370302, '昆仑镇', 370302102),
(370302103, 370302, '磁村镇', 370302103),
(370302104, 370302, '岭子镇', 370302104),
(370302105, 370302, '商家镇', 370302105),
(370302108, 370302, '黑旺镇', 370302108),
(370302109, 370302, '淄河镇', 370302109),
(370302110, 370302, '东坪镇', 370302110),
(370302111, 370302, '西河镇', 370302111),
(370302112, 370302, '龙泉镇', 370302112),
(370302113, 370302, '寨里镇', 370302113),
(370302114, 370302, '罗村镇', 370302114),
(370302115, 370302, '洪山镇', 370302115),
(370302116, 370302, '双杨镇', 370302116),
(370302200, 370302, '太河乡', 370302200),
(370302201, 370302, '峨庄乡', 370302201),
(370302202, 370302, '张庄乡', 370302202),
(370303001, 370303, '车站街道', 370303001),
(370303002, 370303, '公园街道', 370303002),
(370303003, 370303, '杏园街道', 370303003),
(370303004, 370303, '和平街道', 370303004),
(370303005, 370303, '科苑街道', 370303005),
(370303006, 370303, '体育场街道', 370303006),
(370303007, 370303, '石桥街道', 370303007),
(370303008, 370303, '四宝山街道', 370303008),
(370303100, 370303, '马尚镇', 370303100),
(370303101, 370303, '南定镇', 370303101),
(370303102, 370303, '沣水镇', 370303102),
(370303103, 370303, '湖田镇', 370303103),
(370303104, 370303, '傅家镇', 370303104),
(370303105, 370303, '中埠镇', 370303105),
(370303106, 370303, '卫固镇', 370303106),
(370303107, 370303, '房镇镇', 370303107),
(370304001, 370304, '城东街道', 370304001),
(370304002, 370304, '城西街道', 370304002),
(370304102, 370304, '域城镇', 370304102),
(370304103, 370304, '白塔镇', 370304103),
(370304104, 370304, '夏家庄镇', 370304104),
(370304105, 370304, '山头镇', 370304105),
(370304106, 370304, '八陡镇', 370304106),
(370304107, 370304, '崮山镇', 370304107),
(370304108, 370304, '石马镇', 370304108),
(370304109, 370304, '北博山镇', 370304109),
(370304110, 370304, '南博山镇', 370304110),
(370304111, 370304, '源泉镇', 370304111),
(370304112, 370304, '池上镇', 370304112),
(370305001, 370305, '闻韶街道', 370305001),
(370305002, 370305, '雪宫街道', 370305002),
(370305003, 370305, '辛店街道', 370305003),
(370305004, 370305, '稷下街道', 370305004),
(370305005, 370305, '齐陵街道', 370305005),
(370305100, 370305, '齐都镇', 370305100),
(370305102, 370305, '皇城镇', 370305102),
(370305103, 370305, '敬仲镇', 370305103),
(370305104, 370305, '朱台镇', 370305104),
(370305106, 370305, '梧台镇', 370305106),
(370305107, 370305, '金岭镇', 370305107),
(370305108, 370305, '南王镇', 370305108),
(370305109, 370305, '凤凰镇', 370305109),
(370305201, 370305, '边河乡', 370305201),
(370306001, 370306, '丝绸路街道', 370306001),
(370306002, 370306, '大街街道', 370306002),
(370306003, 370306, '青年路街道', 370306003),
(370306004, 370306, '永安街道', 370306004),
(370306005, 370306, '城北路街道', 370306005),
(370306100, 370306, '北郊镇', 370306100),
(370306101, 370306, '南郊镇', 370306101),
(370306102, 370306, '王村镇', 370306102),
(370306103, 370306, '萌水镇', 370306103),
(370321100, 370321, '索镇镇', 370321100),
(370321101, 370321, '起凤镇', 370321101),
(370321102, 370321, '邢家镇', 370321102),
(370321103, 370321, '田庄镇', 370321103),
(370321104, 370321, '荆家镇', 370321104),
(370321105, 370321, '马桥镇', 370321105),
(370321106, 370321, '陈庄镇', 370321106),
(370321107, 370321, '新城镇', 370321107),
(370321108, 370321, '周家镇', 370321108),
(370321109, 370321, '唐山镇', 370321109),
(370321110, 370321, '果里镇', 370321110),
(370322100, 370322, '田镇', 370322100),
(370322101, 370322, '青城镇', 370322101),
(370322102, 370322, '高城镇', 370322102),
(370322103, 370322, '黑里寨镇', 370322103),
(370322104, 370322, '唐坊镇', 370322104),
(370322105, 370322, '常家镇', 370322105),
(370322106, 370322, '花沟镇', 370322106),
(370322107, 370322, '赵店镇', 370322107),
(370322108, 370322, '木李镇', 370322108),
(370323100, 370323, '南麻镇', 370323100),
(370323101, 370323, '土门镇', 370323101),
(370323102, 370323, '鲁村镇', 370323102),
(370323103, 370323, '东里镇', 370323103),
(370323104, 370323, '悦庄镇', 370323104),
(370323105, 370323, '西里镇', 370323105),
(370323106, 370323, '大张庄镇', 370323106),
(370323107, 370323, '中庄镇', 370323107),
(370323108, 370323, '张家坡镇', 370323108),
(370323200, 370323, '徐家庄乡', 370323200),
(370323202, 370323, '燕崖乡', 370323202),
(370323205, 370323, '石桥乡', 370323205),
(370323206, 370323, '三岔乡', 370323206),
(370402001, 370402, '中心街街道', 370402001),
(370402002, 370402, '各塔埠街道', 370402002),
(370402003, 370402, '矿区街道', 370402003),
(370402004, 370402, '文化路街道办事', 370402004),
(370402005, 370402, '龙山路街道', 370402005),
(370402006, 370402, '光明路街道办事', 370402006),
(370402101, 370402, '税郭镇', 370402101),
(370402102, 370402, '孟庄镇', 370402102),
(370402103, 370402, '齐村镇', 370402103),
(370402201, 370402, '永安乡', 370402201),
(370402202, 370402, '西王庄乡', 370402202),
(370403001, 370403, '临城街道', 370403001),
(370403002, 370403, '兴仁街道', 370403002),
(370403003, 370403, '兴城街道', 370403003),
(370403101, 370403, '沙沟镇', 370403101),
(370403102, 370403, '周营镇', 370403102),
(370403103, 370403, '邹坞镇', 370403103),
(370403104, 370403, '陶庄镇', 370403104),
(370403106, 370403, '常庄镇', 370403106),
(370403107, 370403, '张范镇', 370403107),
(370404001, 370404, '坛山街道', 370404001),
(370404002, 370404, '吴林街道', 370404002),
(370404100, 370404, '古邵镇', 370404100),
(370404101, 370404, '阴平镇', 370404101),
(370404102, 370404, '底阁镇', 370404102),
(370404103, 370404, '榴园镇', 370404103),
(370404104, 370404, '峨山镇', 370404104),
(370405001, 370405, '运河街道', 370405001),
(370405100, 370405, '邳庄镇', 370405100),
(370405101, 370405, '张山子镇', 370405101),
(370405102, 370405, '泥沟镇', 370405102),
(370405103, 370405, '涧头集镇', 370405103),
(370405104, 370405, '马兰屯镇', 370405104),
(370406001, 370406, '山城街道', 370406001),
(370406101, 370406, '店子镇', 370406101),
(370406102, 370406, '西集镇', 370406102),
(370406103, 370406, '桑村镇', 370406103),
(370406104, 370406, '北庄镇', 370406104),
(370406105, 370406, '城头镇', 370406105),
(370406106, 370406, '徐庄镇', 370406106),
(370406107, 370406, '水泉镇', 370406107),
(370406108, 370406, '冯卯镇', 370406108),
(370406200, 370406, '凫城乡', 370406200),
(370481001, 370481, '荆河街道', 370481001),
(370481002, 370481, '龙泉街道', 370481002),
(370481003, 370481, '北辛街道', 370481003),
(370481004, 370481, '善南街道', 370481004),
(370481100, 370481, '东沙河镇', 370481100),
(370481101, 370481, '洪绪镇', 370481101),
(370481102, 370481, '南沙河镇', 370481102),
(370481103, 370481, '大坞镇', 370481103),
(370481104, 370481, '滨湖镇', 370481104),
(370481105, 370481, '级索镇', 370481105),
(370481106, 370481, '西岗镇', 370481106),
(370481107, 370481, '姜屯镇', 370481107),
(370481108, 370481, '鲍沟镇', 370481108),
(370481109, 370481, '张汪镇', 370481109),
(370481110, 370481, '官桥镇', 370481110),
(370481111, 370481, '柴胡店镇', 370481111),
(370481112, 370481, '羊庄镇', 370481112),
(370481113, 370481, '木石镇', 370481113),
(370481114, 370481, '界河镇', 370481114),
(370481115, 370481, '龙阳镇', 370481115),
(370481116, 370481, '东郭镇', 370481116),
(370502001, 370502, '文汇街道', 370502001),
(370502002, 370502, '黄河路街道', 370502002),
(370502003, 370502, '东城街道', 370502003),
(370502004, 370502, '辛店街道', 370502004),
(370502005, 370502, '胜利街道', 370502005),
(370502006, 370502, '胜园街道', 370502006),
(370502102, 370502, '牛庄镇', 370502102),
(370502103, 370502, '六户镇', 370502103),
(370502104, 370502, '史口镇', 370502104),
(370502105, 370502, '龙居镇', 370502105),
(370503001, 370503, '河口街道', 370503001),
(370503100, 370503, '义和镇', 370503100),
(370503101, 370503, '仙河镇', 370503101),
(370503102, 370503, '孤岛镇', 370503102),
(370503200, 370503, '新户乡', 370503200),
(370503201, 370503, '　太平乡', 370503201),
(370503203, 370503, '　六合乡', 370503203),
(370521100, 370521, '垦利镇', 370521100),
(370521101, 370521, '胜坨镇', 370521101),
(370521102, 370521, '郝家镇', 370521102),
(370521104, 370521, '永安镇', 370521104),
(370521105, 370521, '黄河口镇', 370521105),
(370521204, 370521, '西宋乡', 370521204),
(370521207, 370521, '董集乡', 370521207),
(370522100, 370522, '利津镇', 370522100),
(370522101, 370522, '北宋镇', 370522101),
(370522102, 370522, '盐窝镇', 370522102),
(370522103, 370522, '陈庄镇', 370522103),
(370522104, 370522, '汀罗镇', 370522104),
(370522201, 370522, '明集乡', 370522201),
(370522202, 370522, '北岭乡', 370522202),
(370522203, 370522, '虎滩乡', 370522203),
(370522206, 370522, '刁口乡', 370522206),
(370523100, 370523, '广饶镇', 370523100),
(370523101, 370523, '大王镇', 370523101),
(370523102, 370523, '稻庄镇', 370523102),
(370523103, 370523, '石村镇', 370523103),
(370523104, 370523, '丁庄镇', 370523104),
(370523106, 370523, '李鹊镇', 370523106),
(370523204, 370523, '大码头乡', 370523204),
(370523205, 370523, '西刘桥乡', 370523205),
(370523207, 370523, '花官乡', 370523207),
(370523208, 370523, '陈官乡', 370523208),
(370602001, 370602, '向阳街道', 370602001),
(370602002, 370602, '东山街道', 370602002),
(370602003, 370602, '毓璜顶街道', 370602003),
(370602004, 370602, '通伸街道', 370602004),
(370602005, 370602, '凤凰台街道', 370602005),
(370602006, 370602, '奇山街道', 370602006),
(370602007, 370602, '白石街道', 370602007),
(370602008, 370602, '芝罘岛街道', 370602008),
(370602009, 370602, '黄务街道', 370602009),
(370602010, 370602, '只楚街道', 370602010),
(370602011, 370602, '世回尧街道', 370602011),
(370602012, 370602, '幸福街道', 370602012),
(370611001, 370611, '清洋街道', 370611001),
(370611002, 370611, '福新街道', 370611002),
(370611003, 370611, '古现街道(烟台开发区)', 370611003),
(370611004, 370611, '大季家街道(烟台开发区)', 370611004),
(370611102, 370611, '高疃镇', 370611102),
(370611103, 370611, '张格庄镇', 370611103),
(370611104, 370611, '回里镇', 370611104),
(370611105, 370611, '门楼镇', 370611105),
(370611400, 370611, '海河社区管理处(烟台开发区)', 370611400),
(370611401, 370611, '长江社区管理处(烟台开发区)', 370611401),
(370611402, 370611, '八角街道(烟台开发区)', 370611402),
(370612001, 370612, '宁海街道', 370612001),
(370612002, 370612, '文化街道', 370612002),
(370612003, 370612, '养马岛街道', 370612003),
(370612101, 370612, '观水镇', 370612101),
(370612102, 370612, '武宁镇', 370612102),
(370612103, 370612, '大窑镇', 370612103),
(370612104, 370612, '姜格庄镇', 370612104),
(370612105, 370612, '龙泉镇', 370612105),
(370612106, 370612, '玉林店镇', 370612106),
(370612107, 370612, '水道镇', 370612107),
(370612108, 370612, '莒格庄镇', 370612108),
(370612109, 370612, '高陵镇', 370612109),
(370612110, 370612, '王格庄镇', 370612110),
(370613001, 370613, '黄海路街道', 370613001),
(370613002, 370613, '初家街道', 370613002),
(370613003, 370613, '滨海路街道', 370613003),
(370613101, 370613, '解甲庄镇', 370613101),
(370613102, 370613, '莱山镇', 370613102),
(370634100, 370634, '南长山镇', 370634100),
(370634101, 370634, '砣矶镇', 370634101),
(370634201, 370634, '北长山乡', 370634201),
(370634202, 370634, '黑山乡', 370634202),
(370634203, 370634, '大钦岛乡', 370634203),
(370634204, 370634, '小钦岛乡', 370634204),
(370634205, 370634, '南隍城乡', 370634205),
(370634206, 370634, '北隍城乡', 370634206),
(370681001, 370681, '东莱街道', 370681001),
(370681002, 370681, '龙港街道', 370681002),
(370681003, 370681, '新嘉街道', 370681003),
(370681101, 370681, '徐福镇', 370681101),
(370681102, 370681, '黄山馆镇', 370681102),
(370681103, 370681, '北马镇', 370681103),
(370681104, 370681, '芦头镇', 370681104),
(370681105, 370681, '东江镇', 370681105),
(370681106, 370681, '下丁家镇', 370681106),
(370681107, 370681, '七甲镇', 370681107),
(370681108, 370681, '石良镇', 370681108),
(370681109, 370681, '兰高镇', 370681109),
(370681110, 370681, '诸由观镇', 370681110),
(370682001, 370682, '城厢街道', 370682001),
(370682002, 370682, '古柳街道', 370682002),
(370682003, 370682, '龙旺庄街道', 370682003),
(370682004, 370682, '冯格庄街道', 370682004),
(370682101, 370682, '沐浴店镇', 370682101),
(370682102, 370682, '团旺镇', 370682102),
(370682103, 370682, '穴坊镇', 370682103),
(370682104, 370682, '羊郡镇', 370682104),
(370682105, 370682, '姜疃镇', 370682105),
(370682106, 370682, '万第镇', 370682106),
(370682107, 370682, '照旺庄镇', 370682107),
(370682108, 370682, '谭格庄镇', 370682108),
(370682109, 370682, '柏林庄镇', 370682109),
(370682110, 370682, '河洛镇', 370682110),
(370682111, 370682, '吕格庄镇', 370682111),
(370682112, 370682, '高格庄镇', 370682112),
(370682113, 370682, '大夼镇', 370682113),
(370682114, 370682, '山前店镇', 370682114),
(370683001, 370683, '文昌路街道', 370683001),
(370683002, 370683, '永安路街道', 370683002),
(370683003, 370683, '三山岛街道', 370683003),
(370683004, 370683, '城港路街道', 370683004),
(370683005, 370683, '文峰路街道', 370683005),
(370683101, 370683, '沙河镇', 370683101),
(370683102, 370683, '朱桥镇', 370683102),
(370683103, 370683, '郭家店镇', 370683103),
(370683104, 370683, '金城镇', 370683104),
(370683105, 370683, '平里店镇', 370683105),
(370683106, 370683, '驿道镇', 370683106),
(370683107, 370683, '程郭镇', 370683107),
(370683108, 370683, '虎头崖镇', 370683108),
(370683109, 370683, '柞村镇', 370683109),
(370683110, 370683, '夏邱镇', 370683110),
(370683111, 370683, '土山镇', 370683111),
(370684001, 370684, '登州街道', 370684001),
(370684002, 370684, '紫荆山街道', 370684002),
(370684003, 370684, '新港街道', 370684003),
(370684004, 370684, '蓬莱阁街道', 370684004),
(370684005, 370684, '南王街道', 370684005),
(370684102, 370684, '刘家沟镇', 370684102),
(370684103, 370684, '潮水镇', 370684103),
(370684105, 370684, '大柳行镇', 370684105),
(370684106, 370684, '小门家镇', 370684106),
(370684107, 370684, '大辛店镇', 370684107),
(370684108, 370684, '村里集镇', 370684108),
(370684109, 370684, '北沟镇', 370684109),
(370685001, 370685, '罗峰街道', 370685001),
(370685002, 370685, '泉山街道', 370685002),
(370685003, 370685, '梦芝街道', 370685003),
(370685004, 370685, '温泉街道', 370685004),
(370685101, 370685, '辛庄镇', 370685101),
(370685102, 370685, '蚕庄镇', 370685102),
(370685103, 370685, '金岭镇', 370685103),
(370685104, 370685, '毕郭镇', 370685104),
(370685105, 370685, '玲珑镇', 370685105),
(370685106, 370685, '张星镇', 370685106),
(370685107, 370685, '大秦家镇', 370685107),
(370685108, 370685, '夏甸镇', 370685108),
(370685109, 370685, '阜山镇', 370685109),
(370685110, 370685, '齐山镇', 370685110),
(370686001, 370686, '翠屏街道', 370686001),
(370686002, 370686, '庄园街道', 370686002),
(370686003, 370686, '松山街道', 370686003),
(370686101, 370686, '观里镇', 370686101),
(370686102, 370686, '蛇窝泊镇', 370686102),
(370686103, 370686, '唐家泊镇', 370686103),
(370686104, 370686, '桃村镇', 370686104),
(370686105, 370686, '亭口镇', 370686105),
(370686106, 370686, '臧家庄镇', 370686106),
(370686107, 370686, '寺口镇', 370686107),
(370686108, 370686, '苏家店镇', 370686108),
(370686109, 370686, '杨础镇', 370686109),
(370686110, 370686, '西城镇', 370686110),
(370686111, 370686, '官道镇', 370686111),
(370686113, 370686, '庙后镇', 370686113),
(370687001, 370687, '方圆街道', 370687001),
(370687002, 370687, '东村街道', 370687002),
(370687003, 370687, '凤城街道', 370687003),
(370687102, 370687, '留格庄镇', 370687102),
(370687103, 370687, '盘石店镇', 370687103),
(370687104, 370687, '郭城镇', 370687104),
(370687105, 370687, '徐家店镇', 370687105),
(370687106, 370687, '发城镇', 370687106),
(370687107, 370687, '小纪镇', 370687107),
(370687108, 370687, '行村镇', 370687108),
(370687109, 370687, '辛安镇', 370687109),
(370687110, 370687, '二十里店镇', 370687110),
(370687111, 370687, '大阎家镇', 370687111),
(370687112, 370687, '朱吴镇', 370687112),
(370687401, 370687, '外向型工业加工区', 370687401),
(370702001, 370702, '城关街道', 370702001),
(370702002, 370702, '南关街道', 370702002),
(370702003, 370702, '西关街道', 370702003),
(370702004, 370702, '北关街道', 370702004),
(370702101, 370702, '军埠口镇', 370702101),
(370702102, 370702, '符山镇', 370702102),
(370702103, 370702, '于河镇', 370702103),
(370702104, 370702, '望留镇', 370702104),
(370703001, 370703, '寒亭街道', 370703001),
(370703002, 370703, '开元街道', 370703002),
(370703100, 370703, '固堤镇', 370703100),
(370703101, 370703, '央子镇', 370703101),
(370703102, 370703, '高里镇', 370703102),
(370703103, 370703, '双杨店镇', 370703103),
(370703104, 370703, '朱里镇', 370703104),
(370703105, 370703, '河滩镇', 370703105),
(370703200, 370703, '泊子乡', 370703200),
(370703201, 370703, '南孙乡', 370703201),
(370704001, 370704, '长宁街道', 370704001),
(370704002, 370704, '恒安街道', 370704002),
(370704003, 370704, '凤凰街道', 370704003),
(370704004, 370704, '坊安街道', 370704004),
(370704103, 370704, '穆村镇', 370704103),
(370704104, 370704, '眉村镇', 370704104),
(370704105, 370704, '荆山洼镇', 370704105),
(370704106, 370704, '南流镇', 370704106),
(370705001, 370705, '东关街道', 370705001),
(370705002, 370705, '大虞街道', 370705002),
(370705003, 370705, '梨园街道', 370705003),
(370705004, 370705, '廿里堡街道', 370705004),
(370705005, 370705, '潍州路街道', 370705005),
(370705006, 370705, '北苑街道', 370705006),
(370705007, 370705, '广文街道', 370705007),
(370705008, 370705, '南苑街道', 370705008),
(370705009, 370705, '新城街道', 370705009),
(370705010, 370705, '清池街道', 370705010),
(370705011, 370705, '钢城街道', 370705011),
(370724001, 370724, '城关街道', 370724001),
(370724002, 370724, '东城街道', 370724002),
(370724101, 370724, '五井镇', 370724101),
(370724102, 370724, '杨善镇', 370724102),
(370724103, 370724, '冶源镇', 370724103),
(370724104, 370724, '寺头镇', 370724104),
(370724105, 370724, '九山镇', 370724105),
(370724106, 370724, '七贤镇', 370724106),
(370724107, 370724, '辛寨镇', 370724107),
(370724108, 370724, '卧龙镇', 370724108),
(370724109, 370724, '蒋峪镇', 370724109),
(370724110, 370724, '大关镇', 370724110),
(370724111, 370724, '营子镇', 370724111),
(370724112, 370724, '龙岗镇', 370724112),
(370724113, 370724, '柳山镇', 370724113),
(370724114, 370724, '上林镇', 370724114),
(370724115, 370724, '纸坊镇', 370724115),
(370724200, 370724, '石家河乡', 370724200),
(370725001, 370725, '城关街道', 370725001),
(370725002, 370725, '宝城街道', 370725002),
(370725003, 370725, '朱刘街道', 370725003),
(370725004, 370725, '城南街道', 370725004),
(370725102, 370725, '尧沟镇', 370725102),
(370725104, 370725, '五图镇', 370725104),
(370725106, 370725, '北岩镇', 370725106),
(370725107, 370725, '乔官镇', 370725107),
(370725108, 370725, '唐吾镇', 370725108),
(370725109, 370725, '高崖镇', 370725109),
(370725110, 370725, '红河镇', 370725110),
(370725111, 370725, '马宋镇', 370725111),
(370725112, 370725, '阿陀镇', 370725112),
(370725113, 370725, '崔家庄镇', 370725113),
(370725114, 370725, '白塔镇', 370725114),
(370725115, 370725, '朱汉镇', 370725115),
(370781001, 370781, '王府街道', 370781001),
(370781002, 370781, '益都街道', 370781002),
(370781003, 370781, '昭德街道', 370781003),
(370781004, 370781, '东坝街道', 370781004),
(370781005, 370781, '王母宫街道', 370781005),
(370781006, 370781, '云门山街道', 370781006),
(370781100, 370781, '弥河镇', 370781100),
(370781101, 370781, '王坟镇', 370781101),
(370781102, 370781, '五里镇', 370781102),
(370781103, 370781, '庙子镇', 370781103),
(370781105, 370781, '邵庄镇', 370781105),
(370781106, 370781, '普通镇', 370781106),
(370781107, 370781, '东高镇', 370781107),
(370781109, 370781, '高柳镇', 370781109),
(370781110, 370781, '朱良镇', 370781110),
(370781111, 370781, '何官镇', 370781111),
(370781112, 370781, '口埠镇', 370781112),
(370781113, 370781, '东夏镇', 370781113),
(370781115, 370781, '谭坊镇', 370781115),
(370781116, 370781, '郑母镇', 370781116),
(370781117, 370781, '黄楼镇', 370781117),
(370782001, 370782, '密州街道', 370782001),
(370782002, 370782, '龙都街道', 370782002),
(370782003, 370782, '舜王街道', 370782003),
(370782100, 370782, '吕标镇', 370782100),
(370782101, 370782, '枳沟镇', 370782101),
(370782102, 370782, '贾悦镇', 370782102),
(370782103, 370782, '孟疃镇', 370782103),
(370782104, 370782, '马庄镇', 370782104),
(370782105, 370782, '石桥子镇', 370782105),
(370782106, 370782, '程戈庄镇', 370782106),
(370782107, 370782, '九台镇', 370782107),
(370782108, 370782, '相州镇', 370782108),
(370782109, 370782, '郭家屯镇', 370782109),
(370782110, 370782, '昌城镇', 370782110),
(370782111, 370782, '百尺河镇', 370782111),
(370782112, 370782, '辛兴镇', 370782112),
(370782113, 370782, '朱解镇', 370782113),
(370782114, 370782, '林家村镇', 370782114),
(370782115, 370782, '瓦店镇', 370782115),
(370782116, 370782, '郝戈庄镇', 370782116),
(370782117, 370782, '皇华镇', 370782117),
(370782200, 370782, '桃园乡', 370782200),
(370782201, 370782, '桃林乡', 370782201),
(370783001, 370783, '圣城街道', 370783001),
(370783003, 370783, '文家街道', 370783003),
(370783004, 370783, '古城街道', 370783004),
(370783005, 370783, '洛城街道', 370783005),
(370783006, 370783, '孙家集街道', 370783006),
(370783007, 370783, '大家洼街道', 370783007),
(370783100, 370783, '化龙镇', 370783100),
(370783103, 370783, '营里镇', 370783103),
(370783104, 370783, '台头镇', 370783104),
(370783106, 370783, '田柳镇', 370783106),
(370783108, 370783, '上口镇', 370783108),
(370783109, 370783, '侯镇镇', 370783109),
(370783111, 370783, '纪台镇', 370783111),
(370783112, 370783, '稻田镇', 370783112),
(370783113, 370783, '田马镇', 370783113),
(370783114, 370783, '留吕镇', 370783114),
(370783115, 370783, '羊口镇', 370783115),
(370784001, 370784, '兴安街道', 370784001),
(370784002, 370784, '贾戈街道', 370784002),
(370784100, 370784, '景芝镇', 370784100),
(370784101, 370784, '黄旗堡镇', 370784101),
(370784103, 370784, '凌河镇', 370784103),
(370784104, 370784, '官庄镇', 370784104),
(370784105, 370784, '雹泉镇', 370784105),
(370784106, 370784, '红沙沟镇', 370784106),
(370784107, 370784, '大盛镇', 370784107),
(370784108, 370784, '庵上镇', 370784108),
(370784109, 370784, '赵戈镇', 370784109),
(370784110, 370784, '刘家尧镇', 370784110),
(370784111, 370784, '石埠子镇', 370784111),
(370784112, 370784, '石堆镇', 370784112),
(370784113, 370784, '关王镇', 370784113),
(370784114, 370784, '王家庄镇', 370784114),
(370784115, 370784, '临浯镇', 370784115),
(370784116, 370784, '白芬子镇', 370784116),
(370784117, 370784, '管公镇', 370784117),
(370784118, 370784, '柘山镇', 370784118),
(370784119, 370784, '辉渠镇', 370784119),
(370784120, 370784, '吾山镇', 370784120),
(370784121, 370784, '金冢子镇', 370784121),
(370785001, 370785, '朝阳街道', 370785001),
(370785002, 370785, '醴泉街道', 370785002),
(370785003, 370785, '密水街道', 370785003),
(370785100, 370785, '柏城镇', 370785100),
(370785101, 370785, '姚哥庄镇', 370785101),
(370785102, 370785, '河崖镇', 370785102),
(370785103, 370785, '夏庄镇', 370785103),
(370785104, 370785, '姜庄镇', 370785104),
(370785105, 370785, '仁和镇', 370785105),
(370785106, 370785, '大牟家镇', 370785106),
(370785107, 370785, '周戈庄镇', 370785107),
(370785108, 370785, '康庄镇', 370785108),
(370785109, 370785, '阚家镇', 370785109),
(370785110, 370785, '双羊镇', 370785110),
(370785111, 370785, '井沟镇', 370785111),
(370785112, 370785, '呼家庄镇', 370785112),
(370785113, 370785, '注沟镇', 370785113),
(370785114, 370785, '柴沟镇', 370785114),
(370785115, 370785, '拒城河镇', 370785115),
(370785116, 370785, '李家营镇', 370785116),
(370786001, 370786, '奎聚街道', 370786001),
(370786002, 370786, '都昌街道', 370786002),
(370786101, 370786, '柳疃镇', 370786101),
(370786102, 370786, '龙池镇', 370786102),
(370786103, 370786, '夏店镇', 370786103),
(370786104, 370786, '卜庄镇', 370786104),
(370786105, 370786, '围子镇', 370786105),
(370786106, 370786, '宋庄镇', 370786106),
(370786107, 370786, '石埠镇', 370786107),
(370786108, 370786, '饮马镇', 370786108),
(370786109, 370786, '北孟镇', 370786109),
(370786110, 370786, '岞山镇', 370786110),
(370786111, 370786, '丈岭镇', 370786111),
(370786201, 370786, '双台乡', 370786201),
(370786202, 370786, '太保庄乡', 370786202),
(370802001, 370802, '古槐街道', 370802001),
(370802002, 370802, '济阳街道', 370802002),
(370802003, 370802, '阜桥街道', 370802003),
(370802004, 370802, '越河街道', 370802004),
(370802005, 370802, '仙营街道', 370802005),
(370802006, 370802, '"观音阁街道办事处', 370802006),
(370802007, 370802, '金城街道', 370802007),
(370802008, 370802, '南苑街道', 370802008),
(370811001, 370811, '三贾街道', 370811001),
(370811002, 370811, '许庄街道', 370811002),
(370811003, 370811, '柳行街道', 370811003),
(370811100, 370811, '李营镇', 370811100),
(370811101, 370811, '廿里铺镇', 370811101),
(370811102, 370811, '长沟镇', 370811102),
(370811103, 370811, '安居镇', 370811103),
(370811104, 370811, '唐口镇', 370811104),
(370811105, 370811, '接庄镇', 370811105),
(370811108, 370811, '南张镇', 370811108),
(370811109, 370811, '石桥镇', 370811109),
(370811110, 370811, '喻屯镇', 370811110),
(370811400, 370811, '兖矿集团济东新村', 370811400),
(370826001, 370826, '夏镇街道', 370826001),
(370826002, 370826, '昭阳街道', 370826002),
(370826101, 370826, '"韩庄镇', 370826101),
(370826102, 370826, '"欢城镇', 370826102),
(370826103, 370826, '"南阳镇', 370826103),
(370826104, 370826, '鲁桥镇', 370826104),
(370826105, 370826, '"傅村镇', 370826105),
(370826106, 370826, '留庄镇', 370826106),
(370826200, 370826, '微山岛乡', 370826200),
(370826204, 370826, '两城乡', 370826204),
(370826205, 370826, '"马坡乡', 370826205),
(370826206, 370826, '"高楼乡', 370826206),
(370826207, 370826, '张楼乡', 370826207),
(370826209, 370826, '赵庙乡', 370826209),
(370826210, 370826, '"西平乡', 370826210),
(370827100, 370827, '谷亭镇', 370827100),
(370827101, 370827, '清河镇', 370827101),
(370827102, 370827, '鱼城镇', 370827102),
(370827103, 370827, '王鲁镇', 370827103),
(370827104, 370827, '张黄镇', 370827104),
(370827105, 370827, '王庙镇', 370827105),
(370827106, 370827, '李阁镇', 370827106),
(370827200, 370827, '唐马乡', 370827200),
(370827201, 370827, '老砦乡', 370827201),
(370827204, 370827, '罗屯乡', 370827204),
(370828100, 370828, '金乡镇', 370828100),
(370828101, 370828, '羊山镇', 370828101),
(370828102, 370828, '胡集镇', 370828102),
(370828103, 370828, '肖云镇', 370828103),
(370828104, 370828, '鸡黍镇', 370828104),
(370828106, 370828, '王丕镇', 370828106),
(370828107, 370828, '司马镇', 370828107),
(370828108, 370828, '鱼山镇', 370828108),
(370828109, 370828, '马庙镇', 370828109),
(370828200, 370828, '化雨乡', 370828200),
(370828201, 370828, '卜集乡', 370828201),
(370828202, 370828, '高河乡', 370828202),
(370828203, 370828, '兴隆乡', 370828203),
(370829100, 370829, '嘉祥镇', 370829100),
(370829101, 370829, '纸坊镇', 370829101),
(370829102, 370829, '梁宝寺镇', 370829102),
(370829103, 370829, '卧龙山镇', 370829103),
(370829104, 370829, '疃里镇', 370829104),
(370829105, 370829, '马村镇', 370829105),
(370829106, 370829, '金屯镇', 370829106),
(370829107, 370829, '大张楼镇', 370829107),
(370829200, 370829, '老僧堂乡', 370829200),
(370829201, 370829, '黄垓乡', 370829201),
(370829204, 370829, '万张乡', 370829204),
(370829207, 370829, '马集乡', 370829207),
(370829208, 370829, '满硐乡', 370829208),
(370829209, 370829, '仲山乡', 370829209),
(370829210, 370829, '孟姑集乡', 370829210),
(370830100, 370830, '汶上镇', 370830100),
(370830101, 370830, '南站镇', 370830101),
(370830102, 370830, '南旺镇', 370830102),
(370830103, 370830, '次丘镇', 370830103),
(370830104, 370830, '寅寺镇', 370830104),
(370830105, 370830, '郭楼镇', 370830105),
(370830106, 370830, '康驿镇', 370830106),
(370830107, 370830, '苑庄镇', 370830107),
(370830201, 370830, '义桥乡', 370830201),
(370830202, 370830, '刘楼乡', 370830202),
(370830203, 370830, '郭仓乡', 370830203),
(370830204, 370830, '杨店乡', 370830204),
(370830205, 370830, '军屯乡', 370830205),
(370830206, 370830, '白石乡', 370830206),
(370831001, 370831, '泗河街道', 370831001),
(370831002, 370831, '济河街道', 370831002),
(370831101, 370831, '泉林镇', 370831101),
(370831102, 370831, '星村镇', 370831102),
(370831103, 370831, '柘沟镇', 370831103),
(370831104, 370831, '金庄镇', 370831104),
(370831105, 370831, '苗馆镇', 370831105),
(370831106, 370831, '中册镇', 370831106),
(370831107, 370831, '杨柳镇', 370831107),
(370831108, 370831, '泗张镇', 370831108),
(370831200, 370831, '圣水峪乡', 370831200),
(370831205, 370831, '大黄沟乡', 370831205),
(370831206, 370831, '高峪乡', 370831206),
(370832100, 370832, '梁山镇', 370832100),
(370832101, 370832, '小路口镇', 370832101),
(370832102, 370832, '韩岗镇', 370832102),
(370832103, 370832, '徐集镇', 370832103),
(370832104, 370832, '拳铺镇', 370832104),
(370832105, 370832, '杨营镇', 370832105),
(370832106, 370832, '韩垓镇', 370832106),
(370832107, 370832, '馆驿镇', 370832107),
(370832108, 370832, '小安山镇', 370832108),
(370832211, 370832, '马营乡', 370832211),
(370832213, 370832, '寿张集乡', 370832213),
(370832214, 370832, '黑虎庙乡', 370832214),
(370832215, 370832, '赵堌堆乡', 370832215),
(370832217, 370832, '大路口乡', 370832217),
(370881001, 370881, '鲁城街道', 370881001),
(370881002, 370881, '书院街道', 370881002),
(370881101, 370881, '吴村镇', 370881101),
(370881102, 370881, '姚村镇', 370881102),
(370881103, 370881, '陵城镇', 370881103),
(370881104, 370881, '小雪镇', 370881104),
(370881105, 370881, '南辛镇', 370881105),
(370881107, 370881, '时庄镇', 370881107),
(370881200, 370881, '王庄乡', 370881200),
(370881201, 370881, '董庄乡', 370881201),
(370881202, 370881, '息陬乡', 370881202),
(370881204, 370881, '防山乡', 370881204),
(370882001, 370882, '鼓楼街道', 370882001),
(370882002, 370882, '永安街道', 370882002),
(370882101, 370882, '大安镇', 370882101),
(370882102, 370882, '新驿镇', 370882102),
(370882103, 370882, '颜店镇', 370882103),
(370882104, 370882, '王因镇', 370882104),
(370882105, 370882, '新兖镇', 370882105),
(370882106, 370882, '谷村镇', 370882106),
(370882107, 370882, '漕河镇', 370882107),
(370882109, 370882, '黄屯镇', 370882109),
(370882110, 370882, '兴隆庄镇', 370882110),
(370882111, 370882, '小孟镇', 370882111),
(370883001, 370883, '钢山街道', 370883001),
(370883002, 370883, '千泉街道', 370883002),
(370883003, 370883, '凫山街道', 370883003),
(370883101, 370883, '香城镇', 370883101),
(370883102, 370883, '城前镇', 370883102),
(370883103, 370883, '大束镇', 370883103),
(370883104, 370883, '北宿镇', 370883104),
(370883105, 370883, '中心店镇', 370883105),
(370883106, 370883, '唐村镇', 370883106),
(370883107, 370883, '太平镇', 370883107),
(370883108, 370883, '平阳寺镇', 370883108),
(370883109, 370883, '石墙镇', 370883109),
(370883110, 370883, '峄山镇', 370883110),
(370883111, 370883, '看庄镇', 370883111),
(370883112, 370883, '张庄镇', 370883112),
(370883113, 370883, '田黄镇', 370883113),
(370883114, 370883, '郭里镇', 370883114),
(370902001, 370902, '岱庙街道', 370902001),
(370902002, 370902, '财源街道', 370902002),
(370902003, 370902, '泰前街道', 370902003),
(370902004, 370902, '上高街道', 370902004),
(370902005, 370902, '徐家楼街道', 370902005),
(370902100, 370902, '省庄镇', 370902100),
(370902101, 370902, '邱家店镇', 370902101),
(370902202, 370902, '大津口乡', 370902202),
(370903001, 370903, '粥店街道', 370903001),
(370903002, 370903, '天平街道', 370903002),
(370903100, 370903, '山口镇', 370903100),
(370903101, 370903, '祝阳镇', 370903101),
(370903102, 370903, '范镇', 370903102),
(370903103, 370903, '角峪镇', 370903103),
(370903104, 370903, '徂徕镇', 370903104),
(370903105, 370903, '北集坡镇', 370903105),
(370903106, 370903, '满庄镇', 370903106),
(370903107, 370903, '夏张镇', 370903107),
(370903108, 370903, '道朗镇', 370903108),
(370903109, 370903, '黄前镇', 370903109),
(370903110, 370903, '大汶口镇', 370903110),
(370903111, 370903, '马庄镇', 370903111),
(370903112, 370903, '房村镇', 370903112),
(370903113, 370903, '良庄镇', 370903113),
(370903200, 370903, '下港乡', 370903200),
(370903201, 370903, '化马湾乡', 370903201),
(370921100, 370921, '宁阳镇', 370921100),
(370921101, 370921, '泗店镇', 370921101),
(370921102, 370921, '东疏镇', 370921102),
(370921103, 370921, '伏山镇', 370921103),
(370921105, 370921, '堽城镇', 370921105),
(370921107, 370921, '蒋集镇', 370921107),
(370921109, 370921, '磁窑镇', 370921109),
(370921110, 370921, '华丰镇', 370921110),
(370921111, 370921, '葛石镇', 370921111),
(370921201, 370921, '鹤山乡', 370921201),
(370921204, 370921, '东庄乡', 370921204),
(370921206, 370921, '乡饮乡', 370921206),
(370923100, 370923, '州城镇', 370923100),
(370923101, 370923, '沙河站镇', 370923101),
(370923102, 370923, '彭集镇', 370923102),
(370923104, 370923, '东平镇', 370923104),
(370923106, 370923, '老湖镇', 370923106),
(370923107, 370923, '银山镇', 370923107),
(370923108, 370923, '斑鸠店镇', 370923108),
(370923200, 370923, '接山乡', 370923200),
(370923202, 370923, '大羊乡', 370923202),
(370923203, 370923, '梯门乡', 370923203),
(370923204, 370923, '新湖乡', 370923204),
(370923206, 370923, '商老庄乡', 370923206),
(370923207, 370923, '戴庙乡', 370923207),
(370923208, 370923, '旧县乡', 370923208),
(370982001, 370982, '青云街道', 370982001),
(370982002, 370982, '新汶街道', 370982002),
(370982101, 370982, '东都镇', 370982101),
(370982102, 370982, '小协镇', 370982102),
(370982103, 370982, '翟镇', 370982103),
(370982104, 370982, '泉沟镇', 370982104),
(370982105, 370982, '羊流镇', 370982105),
(370982106, 370982, '果都镇', 370982106),
(370982107, 370982, '西张庄镇', 370982107),
(370982108, 370982, '天宝镇', 370982108),
(370982110, 370982, '楼德镇', 370982110),
(370982111, 370982, '禹村镇', 370982111),
(370982112, 370982, '宫里镇', 370982112),
(370982113, 370982, '谷里镇', 370982113),
(370982114, 370982, '石莱镇', 370982114),
(370982115, 370982, '放城镇', 370982115),
(370982116, 370982, '刘杜镇', 370982116),
(370982117, 370982, '汶南镇', 370982117),
(370982119, 370982, '龙廷镇', 370982119),
(370982203, 370982, '岳家庄乡', 370982203),
(370983001, 370983, '新城街道', 370983001),
(370983100, 370983, '老城镇', 370983100),
(370983101, 370983, '潮泉镇', 370983101),
(370983102, 370983, '王瓜店镇', 370983102),
(370983103, 370983, '桃园镇', 370983103),
(370983104, 370983, '王庄镇', 370983104),
(370983105, 370983, '湖屯镇', 370983105),
(370983106, 370983, '石横镇', 370983106),
(370983107, 370983, '安临站镇', 370983107),
(370983108, 370983, '孙伯镇', 370983108),
(370983109, 370983, '安驾庄镇', 370983109),
(370983110, 370983, '汶阳镇', 370983110),
(370983111, 370983, '边院镇', 370983111),
(370983200, 370983, '仪阳乡', 370983200),
(371002001, 371002, '环翠楼街道', 371002001),
(371002002, 371002, '鲸园街道', 371002002),
(371002003, 371002, '竹岛街道', 371002003),
(371002004, 371002, '怡园街道', 371002004),
(371002007, 371002, '田和街道', 371002007),
(371002008, 371002, '皇冠街道', 371002008),
(371002009, 371002, '凤林街道', 371002009),
(371002010, 371002, '西苑街道', 371002010),
(371002100, 371002, '张村镇', 371002100),
(371002101, 371002, '羊亭镇', 371002101),
(371002102, 371002, '温泉镇', 371002102),
(371002103, 371002, '崮山镇', 371002103),
(371002104, 371002, '孙家疃镇', 371002104),
(371002105, 371002, '泊于镇', 371002105),
(371002106, 371002, '桥头镇', 371002106),
(371002107, 371002, '草庙子镇', 371002107),
(371002108, 371002, '初村镇', 371002108),
(371081001, 371081, '龙山路街道', 371081001),
(371081002, 371081, '天福路街道', 371081002),
(371081003, 371081, '环山路街道', 371081003),
(371081100, 371081, '文登营镇', 371081100),
(371081101, 371081, '大水泊镇', 371081101),
(371081102, 371081, '张家产镇', 371081102),
(371081103, 371081, '高村镇', 371081103),
(371081104, 371081, '泽库镇', 371081104),
(371081105, 371081, '侯家镇', 371081105),
(371081106, 371081, '宋村镇', 371081106),
(371081107, 371081, '泽头镇', 371081107),
(371081108, 371081, '小观镇', 371081108),
(371081109, 371081, '葛家镇', 371081109),
(371081110, 371081, '米山镇', 371081110),
(371081111, 371081, '界石镇', 371081111),
(371081112, 371081, '汪疃镇', 371081112),
(371081113, 371081, '苘山镇', 371081113),
(371081400, 371081, '开发区', 371081400),
(371082001, 371082, '宁津街道', 371082001),
(371082002, 371082, '港湾街道', 371082002),
(371082003, 371082, '桃园街道', 371082003),
(371082004, 371082, '王连街道', 371082004),
(371082005, 371082, '东山街道', 371082005),
(371082006, 371082, '斥山街道', 371082006),
(371082007, 371082, '崖头街道', 371082007),
(371082008, 371082, '城西街道', 371082008),
(371082009, 371082, '寻山街道', 371082009),
(371082010, 371082, '崂山街道', 371082010),
(371082101, 371082, '俚岛镇', 371082101),
(371082102, 371082, '成山镇', 371082102),
(371082103, 371082, '埠柳镇', 371082103),
(371082104, 371082, '港西镇', 371082104),
(371082105, 371082, '夏庄镇', 371082105),
(371082106, 371082, '崖西镇', 371082106),
(371082107, 371082, '荫子镇', 371082107),
(371082108, 371082, '滕家镇', 371082108),
(371082109, 371082, '大疃镇', 371082109),
(371082110, 371082, '上庄镇', 371082110),
(371082111, 371082, '虎山镇', 371082111),
(371082112, 371082, '人和镇', 371082112),
(371083001, 371083, '城区街道', 371083001),
(371083100, 371083, '夏村镇', 371083100),
(371083101, 371083, '乳山口镇', 371083101),
(371083102, 371083, '海阳所镇', 371083102),
(371083103, 371083, '白沙滩镇', 371083103),
(371083104, 371083, '大孤山镇', 371083104),
(371083105, 371083, '南黄镇', 371083105),
(371083106, 371083, '冯家镇', 371083106),
(371083107, 371083, '下初镇', 371083107),
(371083108, 371083, '午极镇', 371083108),
(371083109, 371083, '育黎镇', 371083109),
(371083110, 371083, '崖子镇', 371083110),
(371083111, 371083, '诸往镇', 371083111),
(371083112, 371083, '乳山寨镇', 371083112),
(371083114, 371083, '徐家镇', 371083114),
(371102001, 371102, '日照街道', 371102001),
(371102002, 371102, '石臼街道', 371102002),
(371102003, 371102, '奎山街道', 371102003),
(371102004, 371102, '秦楼街道', 371102004),
(371102007, 371102, '北京路街道', 371102007),
(371102100, 371102, '河山镇', 371102100),
(371102101, 371102, '两城镇', 371102101),
(371102102, 371102, '涛雒镇', 371102102),
(371102106, 371102, '西湖镇', 371102106),
(371102107, 371102, '陈疃镇', 371102107),
(371102108, 371102, '南湖镇', 371102108),
(371102109, 371102, '三庄镇', 371102109),
(371103001, 371103, '岚山头街道', 371103001),
(371103002, 371103, '安东卫街道', 371103002),
(371103100, 371103, '碑廓镇', 371103100),
(371103101, 371103, '虎山镇', 371103101),
(371103102, 371103, '巨峰镇', 371103102),
(371103103, 371103, '高兴镇', 371103103),
(371103104, 371103, '后村镇', 371103104),
(371103105, 371103, '黄墩镇', 371103105),
(371103200, 371103, '前三岛乡', 371103200),
(371121101, 371121, '洪凝镇', 371121101),
(371121102, 371121, '街头镇', 371121102),
(371121103, 371121, '潮河镇', 371121103),
(371121104, 371121, '许孟镇', 371121104),
(371121105, 371121, '于里镇', 371121105),
(371121106, 371121, '汪湖镇', 371121106),
(371121107, 371121, '叩官镇', 371121107),
(371121108, 371121, '中至镇', 371121108),
(371121109, 371121, '高泽镇', 371121109),
(371121201, 371121, '石场乡', 371121201),
(371121202, 371121, '户部乡', 371121202),
(371121203, 371121, '松柏乡', 371121203),
(371122101, 371122, '城阳镇', 371122101),
(371122102, 371122, '招贤镇', 371122102),
(371122103, 371122, '阎庄镇', 371122103),
(371122104, 371122, '夏庄镇', 371122104),
(371122105, 371122, '刘官庄镇', 371122105),
(371122106, 371122, '峤山镇', 371122106),
(371122107, 371122, '小店镇', 371122107),
(371122108, 371122, '中楼镇', 371122108),
(371122109, 371122, '龙山镇', 371122109),
(371122110, 371122, '东莞镇', 371122110),
(371122111, 371122, '浮来山镇', 371122111),
(371122112, 371122, '陵阳镇', 371122112),
(371122113, 371122, '店子集镇', 371122113),
(371122114, 371122, '长岭镇', 371122114),
(371122115, 371122, '安庄镇', 371122115),
(371122116, 371122, '棋山镇', 371122116),
(371122117, 371122, '洛河镇', 371122117),
(371122201, 371122, '寨里河乡', 371122201),
(371122204, 371122, '果庄乡', 371122204),
(371122205, 371122, '桑园乡', 371122205),
(371122206, 371122, '库山乡', 371122206),
(371202001, 371202, '凤城街道', 371202001),
(371202002, 371202, '张家洼街道', 371202002),
(371202003, 371202, '高庄街道', 371202003),
(371202004, 371202, '鹏泉街道', 371202004),
(371202100, 371202, '口镇', 371202100),
(371202101, 371202, '羊里镇', 371202101),
(371202102, 371202, '方下镇', 371202102),
(371202103, 371202, '牛泉镇', 371202103),
(371202105, 371202, '苗山镇', 371202105),
(371202106, 371202, '雪野镇', 371202106),
(371202107, 371202, '大王庄镇', 371202107),
(371202108, 371202, '寨里镇', 371202108),
(371202109, 371202, '杨庄镇', 371202109),
(371202110, 371202, '茶业口镇', 371202110),
(371202200, 371202, '和庄乡', 371202200),
(371203001, 371203, '艾山街道', 371203001),
(371203100, 371203, '颜庄镇', 371203100),
(371203101, 371203, '黄庄镇', 371203101),
(371203102, 371203, '里辛镇', 371203102),
(371203103, 371203, '辛庄镇', 371203103),
(371302001, 371302, '兰山街道', 371302001),
(371302002, 371302, '银雀山街道', 371302002),
(371302003, 371302, '金雀山街道', 371302003),
(371302004, 371302, '南坊街道', 371302004),
(371302101, 371302, '白沙埠镇', 371302101),
(371302102, 371302, '枣沟头镇', 371302102);
INSERT INTO `{pre}areas` VALUES
(371302103, 371302, '半程镇', 371302103),
(371302105, 371302, '义堂镇', 371302105),
(371302106, 371302, '马厂湖镇', 371302106),
(371302107, 371302, '李官镇', 371302107),
(371302108, 371302, '朱保镇', 371302108),
(371311001, 371311, '罗庄街道', 371311001),
(371311002, 371311, '付庄街道', 371311002),
(371311003, 371311, '盛庄街道', 371311003),
(371311004, 371311, '汤庄街道', 371311004),
(371311005, 371311, '双月街道湖', 371311005),
(371311006, 371311, '册山街道', 371311006),
(371311007, 371311, '高都街道', 371311007),
(371311008, 371311, '罗西街道', 371311008),
(371312001, 371312, '九曲街道', 371312001),
(371312002, 371312, '芝麻墩街道', 371312002),
(371312003, 371312, '梅埠街道', 371312003),
(371312004, 371312, '相公街道', 371312004),
(371312005, 371312, '太平街道', 371312005),
(371312006, 371312, '汤头街道', 371312006),
(371312007, 371312, '凤凰岭街道', 371312007),
(371312103, 371312, '重沟镇', 371312103),
(371312104, 371312, '汤河镇', 371312104),
(371312107, 371312, '八湖镇', 371312107),
(371312108, 371312, '郑旺镇', 371312108),
(371312201, 371312, '刘店子乡', 371312201),
(371321100, 371321, '界湖镇', 371321100),
(371321101, 371321, '岸堤镇', 371321101),
(371321102, 371321, '孙祖镇', 371321102),
(371321103, 371321, '双堠镇', 371321103),
(371321104, 371321, '青驼镇', 371321104),
(371321105, 371321, '张庄镇', 371321105),
(371321106, 371321, '砖埠镇', 371321106),
(371321107, 371321, '葛沟镇', 371321107),
(371321108, 371321, '杨家坡镇', 371321108),
(371321109, 371321, '大庄镇', 371321109),
(371321110, 371321, '辛集镇', 371321110),
(371321111, 371321, '蒲汪镇', 371321111),
(371321112, 371321, '湖头镇', 371321112),
(371321113, 371321, '苏村镇', 371321113),
(371321114, 371321, '铜井镇', 371321114),
(371321115, 371321, '依汶镇', 371321115),
(371321201, 371321, '马牧池乡', 371321201),
(371322100, 371322, '郯城镇', 371322100),
(371322101, 371322, '马头镇', 371322101),
(371322102, 371322, '重坊镇', 371322102),
(371322103, 371322, '李庄镇', 371322103),
(371322104, 371322, '褚墩镇', 371322104),
(371322105, 371322, '杨集镇', 371322105),
(371322106, 371322, '黄山镇', 371322106),
(371322107, 371322, '港上镇', 371322107),
(371322108, 371322, '高峰头镇', 371322108),
(371322109, 371322, '庙山镇', 371322109),
(371322110, 371322, '沙墩镇', 371322110),
(371322200, 371322, '胜利乡', 371322200),
(371322201, 371322, '新村乡', 371322201),
(371322202, 371322, '花园乡', 371322202),
(371322203, 371322, '归昌乡', 371322203),
(371322204, 371322, '红花乡', 371322204),
(371322205, 371322, '泉源乡', 371322205),
(371323100, 371323, '沂水镇', 371323100),
(371323101, 371323, '马站镇', 371323101),
(371323102, 371323, '高桥镇', 371323102),
(371323103, 371323, '许家湖镇', 371323103),
(371323104, 371323, '黄山铺镇', 371323104),
(371323105, 371323, '姚店子镇', 371323105),
(371323106, 371323, '诸葛镇', 371323106),
(371323107, 371323, '崔家峪镇', 371323107),
(371323108, 371323, '四十里堡镇', 371323108),
(371323109, 371323, '杨庄镇', 371323109),
(371323110, 371323, '夏蔚镇', 371323110),
(371323111, 371323, '沙沟镇', 371323111),
(371323112, 371323, '高庄镇', 371323112),
(371323200, 371323, '道托乡', 371323200),
(371323201, 371323, '圈里乡', 371323201),
(371323202, 371323, '龙家圈乡', 371323202),
(371323203, 371323, '泉庄乡', 371323203),
(371323204, 371323, '富官庄乡', 371323204),
(371323205, 371323, '院东头乡', 371323205),
(371324100, 371324, '卞庄镇', 371324100),
(371324101, 371324, '大仲村镇', 371324101),
(371324102, 371324, '兰陵镇', 371324102),
(371324103, 371324, '长城镇', 371324103),
(371324104, 371324, '磨山镇', 371324104),
(371324105, 371324, '神山镇', 371324105),
(371324106, 371324, '车辋镇', 371324106),
(371324107, 371324, '尚岩镇', 371324107),
(371324108, 371324, '向城镇', 371324108),
(371324109, 371324, '新兴镇', 371324109),
(371324110, 371324, '南桥镇', 371324110),
(371324111, 371324, '层山镇', 371324111),
(371324112, 371324, '庄坞镇', 371324112),
(371324113, 371324, '沂堂镇', 371324113),
(371324200, 371324, '贾庄乡', 371324200),
(371324201, 371324, '矿坑乡', 371324201),
(371324202, 371324, '下村乡', 371324202),
(371324203, 371324, '鲁城乡', 371324203),
(371324204, 371324, '三合乡', 371324204),
(371324205, 371324, '兴明乡', 371324205),
(371324206, 371324, '二庙乡', 371324206),
(371325100, 371325, '费城镇', 371325100),
(371325101, 371325, '上冶镇', 371325101),
(371325102, 371325, '薛庄镇', 371325102),
(371325103, 371325, '方城镇', 371325103),
(371325104, 371325, '汪沟镇', 371325104),
(371325105, 371325, '探沂镇', 371325105),
(371325106, 371325, '朱田镇', 371325106),
(371325107, 371325, '梁邱镇', 371325107),
(371325108, 371325, '新庄镇', 371325108),
(371325109, 371325, '马庄镇', 371325109),
(371325110, 371325, '新桥镇', 371325110),
(371325111, 371325, '刘庄镇', 371325111),
(371325112, 371325, '胡阳镇', 371325112),
(371325113, 371325, '石井镇', 371325113),
(371325200, 371325, '大田庄乡', 371325200),
(371325201, 371325, '南张庄乡', 371325201),
(371325202, 371325, '城北乡', 371325202),
(371325204, 371325, '芍药山乡', 371325204),
(371326100, 371326, '平邑镇', 371326100),
(371326101, 371326, '仲村镇', 371326101),
(371326102, 371326, '武台镇', 371326102),
(371326103, 371326, '保太镇', 371326103),
(371326104, 371326, '柏林镇', 371326104),
(371326105, 371326, '卞桥镇', 371326105),
(371326106, 371326, '地方镇', 371326106),
(371326107, 371326, '铜石镇', 371326107),
(371326108, 371326, '温水镇', 371326108),
(371326109, 371326, '流峪镇', 371326109),
(371326110, 371326, '郑城镇', 371326110),
(371326111, 371326, '白彦镇', 371326111),
(371326112, 371326, '临涧镇', 371326112),
(371326113, 371326, '丰阳镇', 371326113),
(371326200, 371326, '资邱乡', 371326200),
(371326201, 371326, '魏庄乡', 371326201),
(371327100, 371327, '十字路镇', 371327100),
(371327101, 371327, '团林镇', 371327101),
(371327102, 371327, '大店镇', 371327102),
(371327103, 371327, '坊前镇', 371327103),
(371327104, 371327, '坪上镇', 371327104),
(371327105, 371327, '相邸镇', 371327105),
(371327106, 371327, '板泉镇', 371327106),
(371327107, 371327, '洙边镇', 371327107),
(371327108, 371327, '文疃镇', 371327108),
(371327109, 371327, '壮岗镇', 371327109),
(371327110, 371327, '汀水镇', 371327110),
(371327111, 371327, '石莲子镇', 371327111),
(371327112, 371327, '岭泉镇', 371327112),
(371327113, 371327, '筵宾镇', 371327113),
(371327114, 371327, '涝坡镇', 371327114),
(371327115, 371327, '朱芦镇', 371327115),
(371327200, 371327, '道口乡', 371327200),
(371327201, 371327, '相沟乡', 371327201),
(371328100, 371328, '蒙阴镇', 371328100),
(371328101, 371328, '常路镇', 371328101),
(371328102, 371328, '岱崮镇', 371328102),
(371328103, 371328, '坦埠镇', 371328103),
(371328104, 371328, '垛庄镇', 371328104),
(371328105, 371328, '高都镇', 371328105),
(371328106, 371328, '野店镇', 371328106),
(371328107, 371328, '桃墟镇', 371328107),
(371328108, 371328, '界牌镇', 371328108),
(371328200, 371328, '联城乡', 371328200),
(371328201, 371328, '旧寨乡', 371328201),
(371329100, 371329, '临沭镇', 371329100),
(371329101, 371329, '蛟龙镇', 371329101),
(371329102, 371329, '大兴镇', 371329102),
(371329103, 371329, '石门镇', 371329103),
(371329104, 371329, '曹庄镇', 371329104),
(371329105, 371329, '南古镇', 371329105),
(371329106, 371329, '郑山镇', 371329106),
(371329107, 371329, '白旄镇', 371329107),
(371329108, 371329, '青云镇', 371329108),
(371329109, 371329, '玉山镇', 371329109),
(371329110, 371329, '店头镇', 371329110),
(371329200, 371329, '朱仓乡', 371329200),
(371402001, 371402, '新湖街道', 371402001),
(371402002, 371402, '新华街道', 371402002),
(371402003, 371402, '天衢街道', 371402003),
(371402004, 371402, '东地街道', 371402004),
(371402005, 371402, '运河街道', 371402005),
(371402100, 371402, '二屯镇', 371402100),
(371402101, 371402, '黄河涯镇', 371402101),
(371402103, 371402, '宋官屯镇', 371402103),
(371402106, 371402, '赵虎镇', 371402106),
(371402200, 371402, '抬头寺乡', 371402200),
(371402201, 371402, '袁桥乡', 371402201),
(371421001, 371421, '安德街道', 371421001),
(371421100, 371421, '陵城镇', 371421100),
(371421101, 371421, '郑家寨镇', 371421101),
(371421102, 371421, '糜镇', 371421102),
(371421103, 371421, '宋家镇', 371421103),
(371421104, 371421, '徽王庄镇', 371421104),
(371421105, 371421, '神头镇', 371421105),
(371421106, 371421, '滋镇', 371421106),
(371421107, 371421, '前孙镇', 371421107),
(371421108, 371421, '边临镇', 371421108),
(371421200, 371421, '义渡口乡', 371421200),
(371421201, 371421, '丁庄乡', 371421201),
(371421202, 371421, '于集乡', 371421202),
(371422100, 371422, '宁津镇', 371422100),
(371422101, 371422, '柴胡店镇', 371422101),
(371422102, 371422, '长官镇', 371422102),
(371422103, 371422, '杜集镇', 371422103),
(371422104, 371422, '保店镇', 371422104),
(371422105, 371422, '大柳镇', 371422105),
(371422106, 371422, '大曹镇', 371422106),
(371422107, 371422, '相衙镇', 371422107),
(371422108, 371422, '时集镇', 371422108),
(371422200, 371422, '张大庄乡', 371422200),
(371422201, 371422, '刘营伍乡', 371422201),
(371423001, 371423, '渤海路街道', 371423001),
(371423100, 371423, '庆云镇', 371423100),
(371423101, 371423, '常家镇', 371423101),
(371423102, 371423, '尚堂镇', 371423102),
(371423103, 371423, '崔口镇', 371423103),
(371423200, 371423, '严务乡', 371423200),
(371423201, 371423, '东辛店乡', 371423201),
(371423202, 371423, '中丁乡', 371423202),
(371423203, 371423, '徐园子乡', 371423203),
(371424001, 371424, '邢侗街道', 371424001),
(371424002, 371424, '恒源街道', 371424002),
(371424003, 371424, '临盘街道', 371424003),
(371424100, 371424, '临邑镇', 371424100),
(371424102, 371424, '临南镇', 371424102),
(371424103, 371424, '德平镇', 371424103),
(371424104, 371424, '林子镇', 371424104),
(371424105, 371424, '兴隆镇', 371424105),
(371424106, 371424, '孟寺镇', 371424106),
(371424200, 371424, '翟家乡', 371424200),
(371424201, 371424, '理合务乡', 371424201),
(371424202, 371424, '宿安乡', 371424202),
(371425100, 371425, '晏城镇', 371425100),
(371425101, 371425, '表白寺镇', 371425101),
(371425102, 371425, '焦庙镇', 371425102),
(371425103, 371425, '赵官镇', 371425103),
(371425104, 371425, '祝阿镇', 371425104),
(371425105, 371425, '仁里集镇', 371425105),
(371425106, 371425, '潘店镇', 371425106),
(371425107, 371425, '胡官屯镇', 371425107),
(371425108, 371425, '宣章屯镇', 371425108),
(371425200, 371425, '华店乡', 371425200),
(371425201, 371425, '安头乡', 371425201),
(371425202, 371425, '马集乡', 371425202),
(371425203, 371425, '刘桥乡', 371425203),
(371425204, 371425, '大黄乡', 371425204),
(371426001, 371426, '龙门街道', 371426001),
(371426002, 371426, '桃园街道', 371426002),
(371426101, 371426, '王凤楼镇', 371426101),
(371426102, 371426, '前曹镇', 371426102),
(371426103, 371426, '恩城镇', 371426103),
(371426104, 371426, '王庙镇', 371426104),
(371426105, 371426, '王杲铺镇', 371426105),
(371426106, 371426, '张华镇', 371426106),
(371426107, 371426, '腰站镇', 371426107),
(371426200, 371426, '坊子乡', 371426200),
(371426201, 371426, '王打卦乡', 371426201),
(371426202, 371426, '三唐乡', 371426202),
(371427001, 371427, '银城街道', 371427001),
(371427002, 371427, '北城街道', 371427002),
(371427100, 371427, '南城镇', 371427100),
(371427101, 371427, '苏留庄镇', 371427101),
(371427102, 371427, '新盛店镇', 371427102),
(371427103, 371427, '雷集镇', 371427103),
(371427104, 371427, '郑保屯镇', 371427104),
(371427105, 371427, '白马湖镇', 371427105),
(371427106, 371427, '东李官屯镇', 371427106),
(371427107, 371427, '宋楼镇', 371427107),
(371427108, 371427, '香赵庄镇', 371427108),
(371427109, 371427, '双庙镇', 371427109),
(371427200, 371427, '渡口驿乡', 371427200),
(371427204, 371427, '田庄乡', 371427204),
(371428001, 371428, '广运街道', 371428001),
(371428100, 371428, '武城镇', 371428100),
(371428101, 371428, '老城镇', 371428101),
(371428102, 371428, '滕庄镇', 371428102),
(371428103, 371428, '鲁权屯镇', 371428103),
(371428104, 371428, '郝王庄镇', 371428104),
(371428200, 371428, '杨庄乡', 371428200),
(371428201, 371428, '李家户乡', 371428201),
(371428202, 371428, '甲马营乡', 371428202),
(371481001, 371481, '市中街道', 371481001),
(371481002, 371481, '胡家街道', 371481002),
(371481003, 371481, '云红街道', 371481003),
(371481004, 371481, '郭家街道', 371481004),
(371481100, 371481, '杨安镇', 371481100),
(371481101, 371481, '朱集镇', 371481101),
(371481102, 371481, '黄夹镇', 371481102),
(371481103, 371481, '丁坞镇', 371481103),
(371481104, 371481, '花园镇', 371481104),
(371481105, 371481, '郑店镇', 371481105),
(371481106, 371481, '化楼镇', 371481106),
(371481107, 371481, '孔镇', 371481107),
(371481200, 371481, '西段乡', 371481200),
(371481201, 371481, '大孙乡', 371481201),
(371481202, 371481, '铁营乡', 371481202),
(371481203, 371481, '寨头堡乡', 371481203),
(371482001, 371482, '市中街道', 371482001),
(371482100, 371482, '伦镇', 371482100),
(371482101, 371482, '房寺镇', 371482101),
(371482102, 371482, '张庄镇', 371482102),
(371482103, 371482, '辛店镇', 371482103),
(371482104, 371482, '安仁镇', 371482104),
(371482105, 371482, '辛寨镇', 371482105),
(371482106, 371482, '梁家镇', 371482106),
(371482200, 371482, '李屯乡', 371482200),
(371482201, 371482, '十里望乡', 371482201),
(371482202, 371482, '莒镇乡', 371482202),
(371502001, 371502, '古楼街道', 371502001),
(371502002, 371502, '柳园街道', 371502002),
(371502003, 371502, '新区街道', 371502003),
(371502004, 371502, '湖西街道', 371502004),
(371502005, 371502, '道口铺街道办事', 371502005),
(371502006, 371502, '阎寺街道', 371502006),
(371502007, 371502, '凤凰街道', 371502007),
(371502008, 371502, '北城街道', 371502008),
(371502009, 371502, '东城街道', 371502009),
(371502010, 371502, '蒋官屯街道办事', 371502010),
(371502100, 371502, '侯营镇', 371502100),
(371502101, 371502, '沙镇镇', 371502101),
(371502102, 371502, '堂邑镇', 371502102),
(371502103, 371502, '梁水镇', 371502103),
(371502104, 371502, '斗虎屯镇', 371502104),
(371502105, 371502, '郑家镇', 371502105),
(371502106, 371502, '张炉集镇', 371502106),
(371502107, 371502, '于集镇', 371502107),
(371502200, 371502, '许营乡', 371502200),
(371502201, 371502, '朱老庄乡', 371502201),
(371521001, 371521, '博济桥街道办事', 371521001),
(371521002, 371521, '侨润街道', 371521002),
(371521003, 371521, '狮子楼街道办事', 371521003),
(371521101, 371521, '阎楼镇', 371521101),
(371521103, 371521, '阿城镇', 371521103),
(371521104, 371521, '七级镇', 371521104),
(371521105, 371521, '安乐镇', 371521105),
(371521106, 371521, '定水镇', 371521106),
(371521107, 371521, '石佛镇', 371521107),
(371521108, 371521, '李台镇', 371521108),
(371521109, 371521, '寿张镇', 371521109),
(371521111, 371521, '十五里园镇', 371521111),
(371521112, 371521, '张秋镇', 371521112),
(371521201, 371521, '郭店屯乡', 371521201),
(371521203, 371521, '大布乡', 371521203),
(371521205, 371521, '西湖乡', 371521205),
(371521206, 371521, '高庙王乡', 371521206),
(371521207, 371521, '金斗营乡', 371521207),
(371522100, 371522, '莘城镇', 371522100),
(371522101, 371522, '张鲁镇', 371522101),
(371522102, 371522, '朝城镇', 371522102),
(371522103, 371522, '观城镇', 371522103),
(371522104, 371522, '古城镇', 371522104),
(371522105, 371522, '大张家镇', 371522105),
(371522106, 371522, '古云镇', 371522106),
(371522107, 371522, '十八里铺镇', 371522107),
(371522108, 371522, '莘亭镇', 371522108),
(371522109, 371522, '燕店镇', 371522109),
(371522110, 371522, '董杜庄镇', 371522110),
(371522111, 371522, '王奉镇', 371522111),
(371522112, 371522, '樱桃园镇', 371522112),
(371522113, 371522, '河店镇', 371522113),
(371522114, 371522, '妹冢镇', 371522114),
(371522202, 371522, '魏庄乡', 371522202),
(371522203, 371522, '大王寨乡', 371522203),
(371522207, 371522, '俎店乡', 371522207),
(371522209, 371522, '张寨乡', 371522209),
(371522210, 371522, '徐庄乡', 371522210),
(371522212, 371522, '王庄集乡', 371522212),
(371522214, 371522, '柿子园乡', 371522214),
(371523001, 371523, '振兴街道', 371523001),
(371523002, 371523, '信发街道', 371523002),
(371523101, 371523, '乐平铺镇', 371523101),
(371523102, 371523, '冯官屯镇', 371523102),
(371523103, 371523, '菜屯镇', 371523103),
(371523104, 371523, '博平镇', 371523104),
(371523105, 371523, '杜郎口镇', 371523105),
(371523106, 371523, '韩屯镇', 371523106),
(371523201, 371523, '韩集乡', 371523201),
(371523202, 371523, '广平乡', 371523202),
(371523205, 371523, '胡屯乡', 371523205),
(371523206, 371523, '温陈乡', 371523206),
(371523207, 371523, '贾寨乡', 371523207),
(371523208, 371523, '杨官屯乡', 371523208),
(371523209, 371523, '洪官屯乡', 371523209),
(371523210, 371523, '肖庄乡', 371523210),
(371524001, 371524, '铜城街道', 371524001),
(371524002, 371524, '新城街道', 371524002),
(371524101, 371524, '刘集镇', 371524101),
(371524102, 371524, '牛角店镇', 371524102),
(371524103, 371524, '大桥镇', 371524103),
(371524104, 371524, '高集镇', 371524104),
(371524105, 371524, '姜楼镇', 371524105),
(371524106, 371524, '顾官屯镇', 371524106),
(371524107, 371524, '姚寨镇', 371524107),
(371524201, 371524, '鱼山乡', 371524201),
(371524205, 371524, '陈集乡', 371524205),
(371525100, 371525, '冠城镇', 371525100),
(371525101, 371525, '贾镇', 371525101),
(371525102, 371525, '桑阿镇', 371525102),
(371525103, 371525, '柳林镇', 371525103),
(371525104, 371525, '清水镇', 371525104),
(371525105, 371525, '东古城镇', 371525105),
(371525106, 371525, '北馆陶镇', 371525106),
(371525200, 371525, '斜店乡', 371525200),
(371525201, 371525, '梁堂乡', 371525201),
(371525202, 371525, '定远寨乡', 371525202),
(371525203, 371525, '辛集乡', 371525203),
(371525204, 371525, '范寨乡', 371525204),
(371525205, 371525, '甘官屯乡', 371525205),
(371525206, 371525, '兰沃乡', 371525206),
(371525207, 371525, '店子乡', 371525207),
(371525208, 371525, '烟庄乡', 371525208),
(371525209, 371525, '万善乡', 371525209),
(371526001, 371526, '鱼邱湖街道办', 371526001),
(371526002, 371526, '汇鑫街道办事', 371526002),
(371526003, 371526, '人和街道办事', 371526003),
(371526101, 371526, '梁村镇', 371526101),
(371526102, 371526, '尹集镇', 371526102),
(371526103, 371526, '清平镇', 371526103),
(371526104, 371526, '固河镇', 371526104),
(371526105, 371526, '三十里铺镇', 371526105),
(371526106, 371526, '琉璃寺镇', 371526106),
(371526203, 371526, '杨屯乡', 371526203),
(371526204, 371526, '赵寨子乡', 371526204),
(371526205, 371526, '姜店乡', 371526205),
(371581001, 371581, '青年路街道', 371581001),
(371581002, 371581, '新华路街道', 371581002),
(371581003, 371581, '先锋路街道', 371581003),
(371581004, 371581, '大辛庄街道', 371581004),
(371581101, 371581, '松林镇', 371581101),
(371581102, 371581, '老赵庄镇', 371581102),
(371581103, 371581, '康庄镇', 371581103),
(371581104, 371581, '魏湾镇', 371581104),
(371581105, 371581, '刘垓子镇', 371581105),
(371581107, 371581, '八岔路镇', 371581107),
(371581108, 371581, '潘庄镇', 371581108),
(371581109, 371581, '烟店镇', 371581109),
(371581110, 371581, '唐园镇', 371581110),
(371581201, 371581, '金郝庄乡', 371581201),
(371581202, 371581, '戴湾乡', 371581202),
(371581203, 371581, '尚店乡', 371581203),
(371602001, 371602, '市中街道', 371602001),
(371602002, 371602, '市西街道', 371602002),
(371602003, 371602, '北镇街道', 371602003),
(371602004, 371602, '市东街道', 371602004),
(371602005, 371602, '彭李街道', 371602005),
(371602007, 371602, '小营街道', 371602007),
(371602008, 371602, '滨北街道', 371602008),
(371602009, 371602, '梁才街道', 371602009),
(371602010, 371602, '杜店街道', 371602010),
(371602011, 371602, '沙河街道', 371602011),
(371602012, 371602, '里则街道', 371602012),
(371602104, 371602, '旧镇镇', 371602104),
(371602105, 371602, '堡集镇', 371602105),
(371602201, 371602, '尚集乡', 371602201),
(371602203, 371602, '秦皇台乡', 371602203),
(371621100, 371621, '孙武镇', 371621100),
(371621101, 371621, '石庙镇', 371621101),
(371621102, 371621, '桑落墅镇', 371621102),
(371621103, 371621, '淄角镇', 371621103),
(371621104, 371621, '胡集镇', 371621104),
(371621105, 371621, '李庄镇', 371621105),
(371621107, 371621, '麻店镇', 371621107),
(371621108, 371621, '魏集镇', 371621108),
(371621109, 371621, '清河镇', 371621109),
(371621111, 371621, '姜楼镇', 371621111),
(371621200, 371621, '何坊乡', 371621200),
(371621204, 371621, '皂户李乡', 371621204),
(371621205, 371621, '辛店乡', 371621205),
(371621208, 371621, '大年陈乡', 371621208),
(371622100, 371622, '阳信镇', 371622100),
(371622101, 371622, '商店镇', 371622101),
(371622102, 371622, '温店镇', 371622102),
(371622103, 371622, '河流镇', 371622103),
(371622104, 371622, '翟王镇', 371622104),
(371622105, 371622, '流坡坞镇', 371622105),
(371622200, 371622, '劳店乡', 371622200),
(371622201, 371622, '水落坡乡', 371622201),
(371622204, 371622, '洋湖乡', 371622204),
(371623100, 371623, '无棣镇', 371623100),
(371623101, 371623, '水湾镇', 371623101),
(371623102, 371623, '碣石山镇', 371623102),
(371623103, 371623, '小泊头镇', 371623103),
(371623104, 371623, '埕口镇', 371623104),
(371623105, 371623, '马山子镇', 371623105),
(371623200, 371623, '信阳乡', 371623200),
(371623201, 371623, '车镇乡', 371623201),
(371623202, 371623, '柳堡乡', 371623202),
(371623203, 371623, '西小王乡', 371623203),
(371623204, 371623, '佘家巷乡', 371623204),
(371624100, 371624, '富国镇', 371624100),
(371624101, 371624, '下洼镇', 371624101),
(371624102, 371624, '古城镇', 371624102),
(371624103, 371624, '冯家镇', 371624103),
(371624104, 371624, '泊头镇', 371624104),
(371624105, 371624, '大高镇', 371624105),
(371624201, 371624, '黄升乡', 371624201),
(371624202, 371624, '滨海乡', 371624202),
(371624203, 371624, '下河乡', 371624203),
(371624204, 371624, '利国乡', 371624204),
(371624205, 371624, '海防办事处乡', 371624205),
(371625100, 371625, '博兴镇', 371625100),
(371625101, 371625, '曹王镇', 371625101),
(371625102, 371625, '兴福镇', 371625102),
(371625103, 371625, '陈户镇', 371625103),
(371625104, 371625, '湖滨镇', 371625104),
(371625106, 371625, '店子镇', 371625106),
(371625107, 371625, '吕艺镇', 371625107),
(371625108, 371625, '纯化镇', 371625108),
(371625109, 371625, '庞家镇', 371625109),
(371625110, 371625, '乔庄镇', 371625110),
(371626001, 371626, '黛溪街道', 371626001),
(371626002, 371626, '黄山街道', 371626002),
(371626003, 371626, '高新街道', 371626003),
(371626101, 371626, '长山镇', 371626101),
(371626102, 371626, '魏桥镇', 371626102),
(371626103, 371626, '西董镇', 371626103),
(371626104, 371626, '好生镇', 371626104),
(371626105, 371626, '临池镇', 371626105),
(371626108, 371626, '焦桥镇', 371626108),
(371626109, 371626, '韩店镇', 371626109),
(371626110, 371626, '孙镇镇', 371626110),
(371626111, 371626, '九户镇', 371626111),
(371626112, 371626, '青阳镇', 371626112),
(371626113, 371626, '明集镇', 371626113),
(371626114, 371626, '台子镇', 371626114),
(371626115, 371626, '码头镇', 371626115),
(371702001, 371702, '东城街道', 371702001),
(371702002, 371702, '西城街道', 371702002),
(371702003, 371702, '南城街道', 371702003),
(371702004, 371702, '北城街道', 371702004),
(371702005, 371702, '牡丹街道', 371702005),
(371702006, 371702, '丹阳街道(属开', 371702006),
(371702007, 371702, '岳程街道(属开', 371702007),
(371702008, 371702, '佃户屯街道办', 371702008),
(371702009, 371702, '何楼街道', 371702009),
(371702010, 371702, '万福街道', 371702010),
(371702100, 371702, '沙土镇', 371702100),
(371702101, 371702, '吴店镇', 371702101),
(371702102, 371702, '王浩屯镇', 371702102),
(371702103, 371702, '黄堽镇', 371702103),
(371702104, 371702, '都司镇', 371702104),
(371702105, 371702, '高庄镇', 371702105),
(371702106, 371702, '小留镇', 371702106),
(371702107, 371702, '李村镇', 371702107),
(371702108, 371702, '马岭岗镇', 371702108),
(371702109, 371702, '安兴镇', 371702109),
(371702110, 371702, '大黄集镇', 371702110),
(371702111, 371702, '吕陵镇', 371702111),
(371702201, 371702, '胡集乡', 371702201),
(371702202, 371702, '皇镇乡', 371702202),
(371721100, 371721, '曹城镇', 371721100),
(371721101, 371721, '庄寨镇', 371721101),
(371721102, 371721, '普连集镇', 371721102),
(371721103, 371721, '青固集镇', 371721103),
(371721104, 371721, '桃源集镇', 371721104),
(371721105, 371721, '韩集镇', 371721105),
(371721106, 371721, '砖庙镇', 371721106),
(371721107, 371721, '古营集镇', 371721107),
(371721108, 371721, '魏湾镇', 371721108),
(371721109, 371721, '侯集回族镇', 371721109),
(371721110, 371721, '苏集镇', 371721110),
(371721111, 371721, '孙老家镇', 371721111),
(371721112, 371721, '阎店楼镇', 371721112),
(371721113, 371721, '梁堤头镇', 371721113),
(371721114, 371721, '安才楼镇', 371721114),
(371721115, 371721, '邵庄镇', 371721115),
(371721116, 371721, '王集镇', 371721116),
(371721200, 371721, '青岗集乡', 371721200),
(371721201, 371721, '常乐集乡', 371721201),
(371721202, 371721, '倪集乡', 371721202),
(371721203, 371721, '楼庄乡', 371721203),
(371721205, 371721, '郑庄乡', 371721205),
(371721206, 371721, '大集乡', 371721206),
(371721207, 371721, '朱洪庙乡', 371721207),
(371721208, 371721, '仵楼乡', 371721208),
(371722100, 371722, '单城镇', 371722100),
(371722101, 371722, '郭村镇', 371722101),
(371722102, 371722, '黄岗镇', 371722102),
(371722103, 371722, '终兴镇', 371722103),
(371722104, 371722, '孙溜镇', 371722104),
(371722105, 371722, '高韦庄镇', 371722105),
(371722106, 371722, '徐寨镇', 371722106),
(371722107, 371722, '蔡堂镇', 371722107),
(371722108, 371722, '朱集镇', 371722108),
(371722109, 371722, '李新庄镇', 371722109),
(371722110, 371722, '浮岗镇', 371722110),
(371722111, 371722, '莱河镇', 371722111),
(371722112, 371722, '时楼镇', 371722112),
(371722113, 371722, '杨楼镇', 371722113),
(371722114, 371722, '张集镇', 371722114),
(371722115, 371722, '龙王庙镇', 371722115),
(371722200, 371722, '谢集乡', 371722200),
(371722201, 371722, '高老家乡', 371722201),
(371722202, 371722, '曹庄乡', 371722202),
(371722204, 371722, '李田楼乡', 371722204),
(371723100, 371723, '成武镇', 371723100),
(371723101, 371723, '大田集镇', 371723101),
(371723102, 371723, '天宫庙镇', 371723102),
(371723103, 371723, '汶上集镇', 371723103),
(371723104, 371723, '南鲁集镇', 371723104),
(371723105, 371723, '伯乐集镇', 371723105),
(371723106, 371723, '苟村集镇', 371723106),
(371723107, 371723, '白浮图镇', 371723107),
(371723108, 371723, '孙寺镇', 371723108),
(371723109, 371723, '九女镇', 371723109),
(371723200, 371723, '党集乡', 371723200),
(371723201, 371723, '张楼乡', 371723201),
(371724100, 371724, '巨野镇', 371724100),
(371724101, 371724, '龙固镇', 371724101),
(371724102, 371724, '大义镇', 371724102),
(371724103, 371724, '柳林镇', 371724103),
(371724104, 371724, '章缝镇', 371724104),
(371724105, 371724, '大谢集镇', 371724105),
(371724106, 371724, '独山镇', 371724106),
(371724107, 371724, '麒麟镇', 371724107),
(371724108, 371724, '核桃园镇', 371724108),
(371724109, 371724, '田庄镇', 371724109),
(371724110, 371724, '太平镇', 371724110),
(371724111, 371724, '万丰镇', 371724111),
(371724112, 371724, '陶庙镇', 371724112),
(371724113, 371724, '董官屯镇', 371724113),
(371724114, 371724, '田桥镇', 371724114),
(371724115, 371724, '营里镇', 371724115),
(371725100, 371725, '郓城镇', 371725100),
(371725101, 371725, '黄安镇', 371725101),
(371725102, 371725, '杨庄集镇', 371725102),
(371725103, 371725, '侯咽集镇', 371725103),
(371725104, 371725, '武安镇', 371725104),
(371725105, 371725, '郭屯镇', 371725105),
(371725106, 371725, '丁里长镇', 371725106),
(371725107, 371725, '玉皇庙镇', 371725107),
(371725108, 371725, '程屯镇', 371725108),
(371725109, 371725, '随官屯镇', 371725109),
(371725110, 371725, '张营镇', 371725110),
(371725111, 371725, '潘渡镇', 371725111),
(371725200, 371725, '双桥乡', 371725200),
(371725201, 371725, '唐庙乡', 371725201),
(371725202, 371725, '南赵楼乡', 371725202),
(371725203, 371725, '黄堆集乡', 371725203),
(371725205, 371725, '黄集乡', 371725205),
(371725206, 371725, '李集乡', 371725206),
(371725207, 371725, '张鲁集乡', 371725207),
(371725208, 371725, '水堡乡', 371725208),
(371725209, 371725, '陈坡乡', 371725209),
(371726100, 371726, '鄄城镇', 371726100),
(371726101, 371726, '什集镇', 371726101),
(371726102, 371726, '红船镇', 371726102),
(371726103, 371726, '旧城镇', 371726103),
(371726104, 371726, '闫什镇', 371726104),
(371726105, 371726, '箕山镇', 371726105),
(371726106, 371726, '李进士堂镇', 371726106),
(371726107, 371726, '董口镇', 371726107),
(371726108, 371726, '临濮镇', 371726108),
(371726109, 371726, '彭楼镇', 371726109),
(371726200, 371726, '左营乡', 371726200),
(371726201, 371726, '大埝乡', 371726201),
(371726202, 371726, '引马乡', 371726202),
(371726205, 371726, '凤凰乡', 371726205),
(371726207, 371726, '富春乡', 371726207),
(371726208, 371726, '郑营乡', 371726208),
(371727100, 371727, '定陶镇', 371727100),
(371727101, 371727, '陈集镇', 371727101),
(371727102, 371727, '冉固镇', 371727102),
(371727103, 371727, '张湾镇', 371727103),
(371727104, 371727, '黄店镇', 371727104),
(371727105, 371727, '孟海镇', 371727105),
(371727106, 371727, '马集镇', 371727106),
(371727200, 371727, '仿山乡', 371727200),
(371727202, 371727, '南王店乡', 371727202),
(371727203, 371727, '半堤乡', 371727203),
(371727204, 371727, '杜堂乡', 371727204),
(371728100, 371728, '城关镇', 371728100),
(371728101, 371728, '东明集镇', 371728101),
(371728102, 371728, '刘楼镇', 371728102),
(371728103, 371728, '陆圈镇', 371728103),
(371728104, 371728, '马头镇', 371728104),
(371728105, 371728, '三春集镇', 371728105),
(371728106, 371728, '大屯镇', 371728106),
(371728200, 371728, '武胜桥乡', 371728200),
(371728201, 371728, '菜园集乡', 371728201),
(371728202, 371728, '小井乡', 371728202),
(371728203, 371728, '沙窝乡', 371728203),
(371728204, 371728, '长兴集乡', 371728204),
(371728205, 371728, '焦园乡', 371728205),
(410102001, 410102, '林山寨街道', 410102001),
(410102002, 410102, '建设路街道', 410102002),
(410102003, 410102, '棉纺路街道', 410102003),
(410102004, 410102, '秦岭路街道', 410102004),
(410102005, 410102, '桐柏路街道', 410102005),
(410102006, 410102, '三官庙街道', 410102006),
(410102007, 410102, '绿东村街道', 410102007),
(410102008, 410102, '汝河路街道', 410102008),
(410102009, 410102, '航海西路街道', 410102009),
(410102010, 410102, '中原西路街道', 410102010),
(410102100, 410102, '须水镇', 410102100),
(410102160, 410102, '石佛镇', 410102160),
(410102360, 410102, '沟赵乡', 410102360),
(410103001, 410103, '淮河路街道', 410103001),
(410103002, 410103, '解放路街道', 410103002),
(410103003, 410103, '铭功路街道', 410103003),
(410103004, 410103, '一马路街道', 410103004),
(410103005, 410103, '蜜蜂张街道', 410103005),
(410103006, 410103, '五里堡街道', 410103006),
(410103007, 410103, '大学路街道', 410103007),
(410103008, 410103, '建中街街道', 410103008),
(410103009, 410103, '福华街街道', 410103009),
(410103010, 410103, '德华街街道', 410103010),
(410103011, 410103, '嵩山路街道', 410103011),
(410103012, 410103, '京广路街道', 410103012),
(410103013, 410103, '长江路街道', 410103013),
(410103100, 410103, '马寨镇', 410103100),
(410103201, 410103, '侯寨乡', 410103201),
(410104001, 410104, '北下街街道', 410104001),
(410104002, 410104, '西大街街道', 410104002),
(410104003, 410104, '南关街道', 410104003),
(410104004, 410104, '城东路街道', 410104004),
(410104005, 410104, '东大街街道', 410104005),
(410104006, 410104, '二里岗街道', 410104006),
(410104007, 410104, '陇海路街道', 410104007),
(410104008, 410104, '紫荆山南路街道', 410104008),
(410104009, 410104, '航海东路街道', 410104009),
(410104100, 410104, '十八里河镇', 410104100),
(410104201, 410104, '南曹乡', 410104201),
(410104202, 410104, '圃田乡', 410104202),
(410104560, 410104, '经济开发区明湖街道', 410104560),
(410104561, 410104, '经济开发区潮河街道', 410104561),
(410105001, 410105, '经八路街道', 410105001),
(410105002, 410105, '花园路街道', 410105002),
(410105003, 410105, '人民路街道', 410105003),
(410105004, 410105, '杜岭街街道', 410105004),
(410105005, 410105, '大石桥街道', 410105005),
(410105006, 410105, '南阳路街道', 410105006),
(410105007, 410105, '南阳新村街道', 410105007),
(410105008, 410105, '文化路街道', 410105008),
(410105009, 410105, '丰产路街道', 410105009),
(410105010, 410105, '东风路街道', 410105010),
(410105011, 410105, '北林路街道', 410105011),
(410105012, 410105, '未来路街道', 410105012),
(410105013, 410105, '凤凰台街道', 410105013),
(410105014, 410105, '龙子湖街道', 410105014),
(410105015, 410105, '祭城路街道', 410105015),
(410105101, 410105, '柳林镇', 410105101),
(410105102, 410105, '庙李镇', 410105102),
(410106001, 410106, '济源路街道', 410106001),
(410106002, 410106, '中心路街道', 410106002),
(410106003, 410106, '新安路街道', 410106003),
(410106004, 410106, '工业路街道', 410106004),
(410106005, 410106, '矿山街道', 410106005),
(410106100, 410106, '峡窝镇', 410106100),
(410108001, 410108, '新城街道', 410108001),
(410108002, 410108, '刘寨街道', 410108002),
(410108003, 410108, '老鸦陈街道', 410108003),
(410108004, 410108, '长兴路街道', 410108004),
(410108005, 410108, '迎宾路街道', 410108005),
(410108006, 410108, '大河路街道', 410108006),
(410108100, 410108, '花园口镇', 410108100),
(410108101, 410108, '古荥镇', 410108101),
(410122100, 410122, '城关镇', 410122100),
(410122101, 410122, '韩寺镇', 410122101),
(410122102, 410122, '官渡镇', 410122102),
(410122103, 410122, '狼城岗镇', 410122103),
(410122104, 410122, '万滩镇', 410122104),
(410122105, 410122, '白沙镇', 410122105),
(410122106, 410122, '郑庵镇', 410122106),
(410122108, 410122, '张庄镇', 410122108),
(410122109, 410122, '黄店镇', 410122109),
(410122110, 410122, '大孟镇', 410122110),
(410122111, 410122, '九龙镇', 410122111),
(410122202, 410122, '雁鸣湖乡', 410122202),
(410122203, 410122, '刘集乡', 410122203),
(410122205, 410122, '八岗乡', 410122205),
(410122206, 410122, '三官庙乡', 410122206),
(410122208, 410122, '刁家乡', 410122208),
(410122209, 410122, '姚家乡', 410122209),
(410181001, 410181, '新华路街道', 410181001),
(410181002, 410181, '杜甫路街道', 410181002),
(410181003, 410181, '永安路街道', 410181003),
(410181004, 410181, '孝义街道', 410181004),
(410181005, 410181, '紫荆路街道', 410181005),
(410181100, 410181, '米河镇', 410181100),
(410181101, 410181, '新中镇', 410181101),
(410181102, 410181, '小关镇', 410181102),
(410181103, 410181, '竹林镇', 410181103),
(410181104, 410181, '大峪沟镇', 410181104),
(410181105, 410181, '河洛镇', 410181105),
(410181106, 410181, '站街镇', 410181106),
(410181108, 410181, '康店镇', 410181108),
(410181110, 410181, '北山口镇', 410181110),
(410181111, 410181, '西村镇', 410181111),
(410181112, 410181, '芝田镇', 410181112),
(410181113, 410181, '回郭镇', 410181113),
(410181114, 410181, '鲁庄镇', 410181114),
(410181115, 410181, '夹津口镇', 410181115),
(410181116, 410181, '涉村镇', 410181116),
(410182001, 410182, '索河街道', 410182001),
(410182002, 410182, '京城街道', 410182002),
(410182101, 410182, '乔楼镇', 410182101),
(410182102, 410182, '豫龙镇', 410182102),
(410182103, 410182, '广武镇', 410182103),
(410182104, 410182, '王村镇', 410182104),
(410182105, 410182, '汜水镇', 410182105),
(410182106, 410182, '高山镇', 410182106),
(410182108, 410182, '刘河镇', 410182108),
(410182109, 410182, '崔庙镇', 410182109),
(410182110, 410182, '贾峪镇', 410182110),
(410182200, 410182, '城关乡', 410182200),
(410182201, 410182, '高村乡', 410182201),
(410182204, 410182, '金寨回族乡', 410182204),
(410183001, 410183, '青屏街街道', 410183001),
(410183002, 410183, '新华路街道', 410183002),
(410183003, 410183, '西大街街道', 410183003),
(410183100, 410183, '城关镇', 410183100),
(410183101, 410183, '米村镇', 410183101),
(410183102, 410183, '牛店镇', 410183102),
(410183103, 410183, '平陌镇', 410183103),
(410183104, 410183, '超化镇', 410183104),
(410183105, 410183, '苟堂镇', 410183105),
(410183106, 410183, '大隗镇', 410183106),
(410183107, 410183, '刘寨镇', 410183107),
(410183108, 410183, '白寨镇', 410183108),
(410183109, 410183, '岳村镇', 410183109),
(410183110, 410183, '来集镇', 410183110),
(410183200, 410183, '袁庄乡', 410183200),
(410183202, 410183, '曲梁乡', 410183202),
(410183400, 410183, '矿区街道', 410183400),
(410183401, 410183, '尖山风景区管理委员会', 410183401),
(410184001, 410184, '新建路街道', 410184001),
(410184002, 410184, '新华路街道', 410184002),
(410184003, 410184, '新烟街道', 410184003),
(410184101, 410184, '新村镇', 410184101),
(410184102, 410184, '辛店镇', 410184102),
(410184103, 410184, '观音寺镇', 410184103),
(410184104, 410184, '梨河镇', 410184104),
(410184105, 410184, '和庄镇', 410184105),
(410184106, 410184, '薛店镇', 410184106),
(410184107, 410184, '孟庄镇', 410184107),
(410184108, 410184, '郭店镇', 410184108),
(410184109, 410184, '龙湖镇', 410184109),
(410184200, 410184, '城关乡', 410184200),
(410184202, 410184, '八千乡', 410184202),
(410184203, 410184, '龙王乡', 410184203),
(410185001, 410185, '嵩阳街道', 410185001),
(410185002, 410185, '少林街道', 410185002),
(410185003, 410185, '中岳街道', 410185003),
(410185100, 410185, '大金店镇', 410185100),
(410185101, 410185, '颖阳镇', 410185101),
(410185102, 410185, '卢店镇', 410185102),
(410185103, 410185, '告成镇', 410185103),
(410185104, 410185, '阳城区镇', 410185104),
(410185105, 410185, '大冶镇', 410185105),
(410185106, 410185, '宣化镇', 410185106),
(410185201, 410185, '东金店乡', 410185201),
(410185202, 410185, '白坪乡', 410185202),
(410185203, 410185, '君召乡', 410185203),
(410185204, 410185, '石道乡', 410185204),
(410185205, 410185, '唐庄乡', 410185205),
(410185206, 410185, '徐庄乡', 410185206),
(410202001, 410202, '北书店街道', 410202001),
(410202002, 410202, '午朝门街道', 410202002),
(410202003, 410202, '大兴街道', 410202003),
(410202005, 410202, '北道门街道', 410202005),
(410202201, 410202, '北郊乡', 410202201),
(410202202, 410202, '柳园口乡', 410202202),
(410203001, 410203, '清平街道', 410203001),
(410203002, 410203, '铁塔街道', 410203002),
(410203003, 410203, '曹门街道', 410203003),
(410203004, 410203, '宋门街道', 410203004),
(410203005, 410203, '工业街道', 410203005),
(410203006, 410203, '苹果园街道', 410203006),
(410203200, 410203, '东郊乡', 410203200),
(410203201, 410203, '土柏岗乡', 410203201),
(410204001, 410204, '相国寺街道', 410204001),
(410204002, 410204, '新华街道', 410204002),
(410204003, 410204, '卧龙街道', 410204003),
(410204004, 410204, '州桥街道', 410204004),
(410204005, 410204, '西司门街道', 410204005),
(410204006, 410204, '九村街道', 410204006),
(410204007, 410204, '五一街道', 410204007),
(410204008, 410204, '仙人庄街道', 410204008),
(410205001, 410205, '三里堡街道', 410205001),
(410205002, 410205, '新门关街道', 410205002),
(410205003, 410205, '繁塔街道', 410205003),
(410205004, 410205, '官坊街道', 410205004),
(410205005, 410205, '菜市街道', 410205005),
(410205200, 410205, '南郊乡', 410205200),
(410205201, 410205, '汪屯乡', 410205201),
(410211001, 410211, '城西街道', 410211001),
(410211002, 410211, '梁苑街道', 410211002),
(410211100, 410211, '杏花营镇', 410211100),
(410211201, 410211, '西郊乡', 410211201),
(410211207, 410211, '水稻乡', 410211207),
(410211400, 410211, '杏花营农场', 410211400),
(410211560, 410211, '开发区', 410211560),
(410221100, 410221, '城关镇', 410221100),
(410221101, 410221, '五里河镇', 410221101),
(410221102, 410221, '付集镇', 410221102),
(410221103, 410221, '于镇镇', 410221103),
(410221104, 410221, '高阳镇', 410221104),
(410221105, 410221, '葛岗镇', 410221105),
(410221106, 410221, '阳固镇', 410221106),
(410221107, 410221, '邢口镇', 410221107),
(410221200, 410221, '裴村店乡', 410221200),
(410221202, 410221, '宗店乡', 410221202),
(410221203, 410221, '板木乡', 410221203),
(410221204, 410221, '竹林乡', 410221204),
(410221205, 410221, '官庄乡', 410221205),
(410221206, 410221, '湖岗乡', 410221206),
(410221207, 410221, '苏木乡', 410221207),
(410221208, 410221, '沙沃乡', 410221208),
(410221209, 410221, '平城乡', 410221209),
(410221210, 410221, '泥沟乡', 410221210),
(410221211, 410221, '柿元乡', 410221211),
(410221212, 410221, '西寨乡', 410221212),
(410221213, 410221, '城郊乡', 410221213),
(410222100, 410222, '城关镇', 410222100),
(410222101, 410222, '竖岗镇', 410222101),
(410222102, 410222, '玉皇庙镇', 410222102),
(410222103, 410222, '四所楼镇', 410222103),
(410222104, 410222, '朱砂镇', 410222104),
(410222105, 410222, '长智镇', 410222105),
(410222200, 410222, '冯庄乡', 410222200),
(410222201, 410222, '孙营乡', 410222201),
(410222202, 410222, '大岗李乡', 410222202),
(410222203, 410222, '邸阁乡', 410222203),
(410222204, 410222, '练城乡', 410222204),
(410222205, 410222, '厉庄乡', 410222205),
(410223100, 410223, '城关镇', 410223100),
(410223101, 410223, '洧川镇', 410223101),
(410223102, 410223, '朱曲镇', 410223102),
(410223103, 410223, '蔡庄镇', 410223103),
(410223104, 410223, '永兴镇', 410223104),
(410223105, 410223, '张市镇', 410223105),
(410223106, 410223, '十八里镇', 410223106),
(410223107, 410223, '水坡镇', 410223107),
(410223200, 410223, '邢庄乡', 410223200),
(410223201, 410223, '庄头乡', 410223201),
(410223202, 410223, '大营乡', 410223202),
(410223203, 410223, '大马乡', 410223203),
(410223204, 410223, '岗李乡', 410223204),
(410223205, 410223, '门楼任乡', 410223205),
(410223206, 410223, '大桥乡', 410223206),
(410223207, 410223, '南曹乡', 410223207),
(410223208, 410223, '小陈乡', 410223208),
(410224100, 410224, '城关镇', 410224100),
(410224101, 410224, '陈留镇', 410224101),
(410224102, 410224, '仇楼镇', 410224102),
(410224103, 410224, '八里湾镇', 410224103),
(410224104, 410224, '曲兴镇', 410224104),
(410224106, 410224, '朱仙镇', 410224106),
(410224200, 410224, '半坡店乡', 410224200),
(410224202, 410224, '罗王乡', 410224202),
(410224203, 410224, '刘店乡', 410224203),
(410224204, 410224, '袁坊乡', 410224204),
(410224205, 410224, '杜良乡', 410224205),
(410224206, 410224, '兴隆乡', 410224206),
(410224208, 410224, '西姜寨乡', 410224208),
(410224210, 410224, '万隆乡', 410224210),
(410224211, 410224, '范村乡', 410224211),
(410225100, 410225, '城关镇', 410225100),
(410225101, 410225, '固阳镇', 410225101),
(410225102, 410225, '南彰镇', 410225102),
(410225103, 410225, '张君墓镇', 410225103),
(410225104, 410225, '红庙镇', 410225104),
(410225200, 410225, '城关乡', 410225200),
(410225201, 410225, '三义寨乡', 410225201),
(410225202, 410225, '坝头乡', 410225202),
(410225203, 410225, '爪营乡', 410225203),
(410225204, 410225, '谷营乡', 410225204),
(410225205, 410225, '小宋乡', 410225205),
(410225206, 410225, '孟寨乡', 410225206),
(410225207, 410225, '许河乡', 410225207),
(410225208, 410225, '葡萄架乡', 410225208),
(410225209, 410225, '闫楼乡', 410225209),
(410225210, 410225, '仪封乡', 410225210),
(410225400, 410225, '中原油田', 410225400),
(410225401, 410225, '仪封园艺场', 410225401),
(410225402, 410225, '造纸林场', 410225402),
(410225403, 410225, '柳林林场', 410225403),
(410225404, 410225, '西关农场', 410225404),
(410225405, 410225, '畜牧良种场', 410225405),
(410225406, 410225, '固阳农科所', 410225406),
(410302001, 410302, '西关街道', 410302001),
(410302002, 410302, '西南隅街道', 410302002),
(410302003, 410302, '西北隅街道', 410302003),
(410302004, 410302, '东南隅街道', 410302004),
(410302005, 410302, '东北隅街道', 410302005),
(410302006, 410302, '南关街道', 410302006),
(410302007, 410302, '洛浦街道', 410302007),
(410302100, 410302, '邙山镇', 410302100),
(410303001, 410303, '王城路街道', 410303001),
(410303002, 410303, '金谷园街道', 410303002),
(410303003, 410303, '西工街道', 410303003),
(410303004, 410303, '邙岭路街道', 410303004),
(410303005, 410303, '道北路街道', 410303005),
(410303006, 410303, '唐宫路街道', 410303006),
(410303007, 410303, '汉屯路街道', 410303007),
(410303008, 410303, '凯旋东路街道', 410303008),
(410303200, 410303, '洛北乡', 410303200),
(410303201, 410303, '红山乡', 410303201),
(410304001, 410304, '东关街道', 410304001),
(410304002, 410304, '廛西街道', 410304002),
(410304003, 410304, '五股路街道', 410304003),
(410304004, 410304, '北窑街道', 410304004),
(410304005, 410304, '塔湾街道', 410304005),
(410304006, 410304, '杨文街道', 410304006),
(410304007, 410304, '华林新村街道', 410304007),
(410304200, 410304, '廛河回族乡', 410304200),
(410305001, 410305, '湖北路街道', 410305001),
(410305002, 410305, '天津路街道', 410305002),
(410305003, 410305, '长春路街道', 410305003),
(410305004, 410305, '南昌路街道', 410305004),
(410305005, 410305, '长安路街道', 410305005),
(410305006, 410305, '重庆路街道', 410305006),
(410305007, 410305, '郑州路街道', 410305007),
(410305008, 410305, '武汉路街道', 410305008),
(410305009, 410305, '徐家营街道', 410305009),
(410305010, 410305, '珠江路街道', 410305010),
(410305011, 410305, '周山路街道', 410305011),
(410305160, 410305, '辛店镇', 410305160),
(410305200, 410305, '工农乡', 410305200),
(410305360, 410305, '孙旗屯乡', 410305360),
(410305560, 410305, '创业路街道', 410305560),
(410306001, 410306, '大庆路街道', 410306001),
(410306200, 410306, '吉利乡', 410306200),
(410307001, 410307, '安乐街道', 410307001),
(410307100, 410307, '关林镇', 410307100),
(410307101, 410307, '龙门镇', 410307101),
(410307102, 410307, '安乐镇', 410307102),
(410307103, 410307, '白马寺镇', 410307103),
(410307200, 410307, 