<?php 
namespace wstshop\admin\model;
use think\Db;
/**
 * ============================================================================
 * WSTShop网上商店
 * 版权所有 2016-2066 广州商淘信息科技有限公司，并保留所有权利。
 * 官网地址:http://www.wstshop.net
 * 交流社区:http://bbs.shangtao.net
 * 联系QQ:153289970
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经本公司授权您只能在不用于商业目的的前提下对程序代码进行修改和使用；
 * 不允许对程序代码以任何形式任何目的的再发布。
 * ============================================================================
 * 系统业务处理
 */
class Index extends Base{
	/**
	 * 获取基础统计信息
	 */
	public function summary(){
		$cache = cache('index-summary');
		if(!$cache){
			$data = [];
			//今日统计
			//会员
			$data['tody']['newUser'] = Db::name('users')->where(['dataFlag'=>1,'createTime'=>['like',date('Y-m-d').'%']])->count();
			$data['tody']['loginUser'] = Db::name('log_user_logins')->where(['loginTime'=>['like',date('Y-m-d').'%']])->distinct(true)->field('userId')->count();
			$data['tody']['order'] = Db::name('orders')->where(['dataFlag'=>1,'createTime'=>['like',date('Y-m-d').'%']])->count();
			// 待发货”、“待付款”、   “取消/拒收”、“待退款”、   "待提现"以及“新增评价”统计展示。取消/拒收订单”直接查订单日志
			// 订单相关
			$data['tody']['waitDelivery'] = Db::name('orders')->where(['orderStatus'=>0,'dataFlag'=>1])->count();
			$data['tody']['waitPay'] = Db::name('orders')->where(['orderStatus'=>-2,'dataFlag'=>1])->count();
			$data['tody']['cancel'] = Db::name('log_orders')->where(['orderStatus'=>['in',[-2,-3]],'logTime'=>['like',date('Y-m-d').'%']])->count();
			$data['tody']['refund'] = Db::name('orders')->alias('o')->join('order_refunds orf','orf.orderId=o.orderId')->where(['refundStatus'=>0,'o.dataFlag'=>1,'orf.createTime'=>['like',date('Y-m-d').'%']])->count();
			$data['tody']['drawscash'] = Db::name('cash_draws')->where(['cashSatus'=>0,'createTime'=>['like',date('Y-m-d').'%']])->count();
			//商城统计
			$data['totalGoods'] = Db::name('goods')->where(['dataFlag'=>1])->count();
			$data['saleGoods'] = Db::name('goods')->where(['dataFlag'=>1,'isSale'=>1])->count();
			$data['storeGoods'] = Db::name('goods')->where(['dataFlag'=>1,'isSale'=>0])->count();
			$data['order'] = Db::name('orders')->where(['dataFlag'=>1])->count();
			$data['brands'] = Db::name('brands')->where(['dataFlag'=>1])->count();
			$rs = Db::query('select VERSION() as sqlversion');
			$data['MySQL_Version'] = $rs[0]['sqlversion'];
			// 最新评价
			$data['appraises'] = Db::name('goods_appraises')->field('content,goodsId')->where(['dataFlag'=>1])->limit(10)->select();
			//获取库存预警数量
		    $goodsn = Db::name('goods')->where('dataFlag = 1 and goodsStock <= warnStock and isSpec = 0 and warnStock>0')->count();
		    $specsn = Db::name('goods_specs')->where('dataFlag = 1 and specStock <= warnStock and warnStock>0')->count();
			$data['warnStock'] = $goodsn+$specsn;
			// 最近7天销售订单
			$data['orderList'] = $this->getLatelyOders();
			// 最近7天商品销售排行
			$data['goodsList'] = $this->getLatelyGoodsTop();
			cache('index-summary',$data,3600);
			$cache = $data;
		}
		return $cache;
	}
	
    /**
	 * 保存授权码
	 */
	public function saveLicense(){
		$data = [];
		$data['fieldValue'] = input('license');
	    $result = model('SysConfigs')->where('fieldCode','shopLicense')->update($data);
		if(false !== $result){
			cache('WST_CONF',null);
			return WSTReturn("操作成功",1);
		}
		return WSTReturn("操作失败");
	}

	/**
	* 获取各订单状态数
	*/
	public function getSysMsg(){
		$task = input('task');
		$data = [];
		if($task=='order'){
			// 待发货
			$data['order']['waitDelivery'] = Db::name('orders')->where(['orderStatus'=>0,'dataFlag'=>1])->count();
			// 待支付
			$data['order']['waitPay'] = Db::name('orders')->where(['orderStatus'=>-2,'dataFlag'=>1])->count();
			// 用户拒收并且未退款
			$data['order']['refund'] = Db::name('orders')->alias('o')->join('order_refunds orf','orf.orderId=o.orderId')->where(['refundStatus'=>0,'o.dataFlag'=>1])->count();
		}elseif($task=='warnStock'){
			//获取库存预警数量
		    $goodsn = Db::name('goods')->where('dataFlag = 1 and goodsStock <= warnStock and isSpec = 0 and warnStock>0')->count();
		    $specsn = Db::name('goods_specs')->where('dataFlag = 1 and specStock <= warnStock and warnStock>0')->count();
			$data['warnStock'] = $goodsn+$specsn;
		}
		return $data;
	}
	/**
	* 获取最近7天订单信息
	*/
	public function getLatelyOders(){
		$rs = cache('admin-order-count');
		if(!$rs){
			$start = date('Y-m-d 00:00:00',strtotime('-6 day'));
	        $end = date('Y-m-d 23:59:59');
			$rs = Db::name('orders')->field('left(createTime,10) createTime,count(*) orderNum,sum(totalMoney) totalMoney')->whereTime('createTime','between',[$start,$end])
					                ->where('(payType=0 or (payType=1 and isPay=1) and dataFlag=1)')
					                ->order('createTime asc')
					                ->group('left(createTime,10)')->select();
			// 缓存一天
			cache('admin-order-count',$rs,3600);
		}
		return $rs;
	}
	/**
	* 获取最近7天商品销售排行
	*/
	public function getLatelyGoodsTop(){
		$rs = cache('admin-top-goods');
		if(!$rs){
			$start = date('Y-m-d 00:00:00',strtotime('-6 day'));
	        $end = date('Y-m-d 23:59:59');
	    	$rs =  Db::name('order_goods')->field('og.goodsId,g.goodsName,sum(og.goodsNum) goodsNum')->alias('og')
								    	  ->join('__ORDERS__ o','og.orderId=o.orderId')
								    	  ->join('__GOODS__ g','og.goodsId=g.goodsId')
								    	  ->order('goodsNum desc')
								    	  ->whereTime('o.createTime','between',[$start,$end])
								          ->where('payType=0 or (payType=1 and isPay=1) and o.dataFlag=1')->group('og.goodsId,g.goodsName,goodsSn,og.goodsImg')
								          ->limit(10)
								          ->select();
			// 缓存一天
			cache('admin-top-goods',$rs,3600);
		}
		return $rs;
	}
}