<?php
namespace wstshop\common\model;
/**
 * ============================================================================
 * wstshop单用户商城
 * 版权所有 2016-2066 广州商淘信息科技有限公司，并保留所有权利。
 * 官网地址:http://www.wstshop.net
 * 交流社区:http://bbs.shangtao.net
 * 联系QQ:153289970
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经本公司授权您只能在不用于商业目的的前提下对程序代码进行修改和使用；
 * 不允许对程序代码以任何形式任何目的的再发布。
 * ============================================================================
 * 商品咨询类
 */
class GoodsConsult extends Base{
	/**
	* 根据商品id获取商品咨询
	*/
	public function listQuery(){
		$goodsId = (int)input('goodsId');
		$type = (int)input('type');
		$consultKey = input('consultKey');
		$where = [];
		$where['gc.dataFlag'] = 1;
		$where['gc.isShow'] = 1;
		$where['gc.goodsId'] = $goodsId;
		// 筛选类别
		if($type>0){$where['gc.consultType'] = $type;}
		// 关键字搜索
		if($consultKey!=''){$where['gc.consultContent'] = ['like',"%$consultKey%"];}
        $rs = $this->alias('gc')
        		   ->join('__USERS__ u','u.userId=gc.userId','left')
        		   ->field('gc.*,u.loginName')
        		   ->where($where)
        		   ->order('gc.createTime desc')
        		   ->paginate(input('pagesize/d',5))->toArray();
        if(!empty($rs['Rows'])){
        	foreach($rs['Rows'] as $k=>&$v){
        		// 解义
        		$v['consultContent'] = htmlspecialchars_decode($v['consultContent']);
        		// 处理匿名
        		if($v['userId']>0){
        			// 替换中间两个字符
        			$start = floor((strlen($v['loginName'])/2))-1;
					$v['loginName'] = substr_replace($v['loginName'],'**',$start,2);
        		}
        	}
        }
        return WSTReturn('', 1,$rs);
    }
    /**
    * 添加
    */
    public function add($uId=0){
    	$userId = ($uId==0)?(int)session('WST_USER.userId'):$uId;
    	$data = input('param.');
    	$data['userId'] = $userId;
    	// 检测是否含有系统禁用关键字
    	if(!WSTCheckFilterWords($data['consultContent'],WSTConf("CONF.limitWords"))){
				return WSTReturn("咨询内容包含非法字符");
		}
        if(empty(WSTConf("CONF.isConsult"))){
            $data['isShow'] = 0;
        };
    	// 转义,防止xss攻击
    	$data['consultContent'] = htmlspecialchars($data['consultContent']);
    	$rs = $this->validate('GoodsConsult.add')->allowField(true)->save($data);
    	if($rs===false){
    		return WSTReturn($this->getError(),-1);
    	}
    	return WSTReturn('提交成功', 1);
    }
    /**
    * 根据用户id获取商品咨询
    */
    public function myConsultByPage(){
        $userId = (int)session('WST_USER.userId');
        $where = [];
        $where['gc.userId'] = $userId;
        $where['gc.dataFlag'] = 1;
        $where['gc.isShow'] = 1;
        $rs = $this->alias('gc')
                   ->join('__GOODS__ g','g.goodsId=gc.goodsId')
                   ->field('gc.*,g.goodsName,g.goodsImg')
                   ->where($where)
                   ->order('gc.createTime desc')
                   ->paginate(input('pagesize/d'))->toArray();
        if(!empty($rs['Rows'])){
            foreach($rs['Rows'] as $k=>&$v){
                // 解义
                $v['consultContent'] = htmlspecialchars_decode($v['consultContent']);
            }
        }
        return WSTReturn('', 1,$rs);
    }
    /**
     * 根据商品id获取一条最新商品咨询
     */
    public function firstQuery($id){
    	$where = [];
    	$where['gc.dataFlag'] = 1;
    	$where['gc.isShow'] = 1;
    	$where['gc.goodsId'] = $id;
    	$rs = $this->alias('gc')->join('__USERS__ u','u.userId=gc.userId','left')
    	->where($where)->field('gc.*,u.loginName')->order('gc.createTime desc')->find();
    	if(!empty($rs)){
    		// 解义
    		$rs['consultContent'] = htmlspecialchars_decode($rs['consultContent']);
    		// 处理匿名
    		if($rs['userId']>0){
    			// 替换中间两个字符
    			$start = floor((strlen($rs['loginName'])/2))-1;
    			$rs['loginName'] = substr_replace($rs['loginName'],'**',$start,2);
    		}
    	}
    	return $rs;
    }
}





