<?php
namespace wstshop\common\model;
use Think\Db;
/**
 * ============================================================================
 * WSTShop网上商店
 * 版权所有 2016-2066 广州商淘信息科技有限公司，并保留所有权利。
 * 官网地址:http://www.wstshop.net
 * 交流社区:http://bbs.shangtao.net
 * 联系QQ:153289970
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经本公司授权您只能在不用于商业目的的前提下对程序代码进行修改和使用；
 * 不允许对程序代码以任何形式任何目的的再发布。
 * ============================================================================
 * 用户类
 */
class Users extends Base{
    /**
     * 用户登录验证
     */
    public function checkLogin($loginSrc = 0){
    	$loginName = input("post.loginName");
    	$loginPwd = input("post.loginPwd");
    	$code = input("post.verifyCode");
    	$rememberPwd = input("post.rememberPwd",1);
    	if(!WSTVerifyCheck($code) && strpos(WSTConf("CONF.captcha_model"),"4")>=0){
    		return WSTReturn('验证码错误!');
    	}
    	$rs = $this->where("loginName|userEmail|userPhone",$loginName)
    				->where(["dataFlag"=>1, "userStatus"=>1])
    				->find();
        hook("beforeUserLogin",["user"=>&$rs,'loginType'=>'account']);
    	if(!empty($rs)){
    		$userId = $rs['userId'];
    		//获取用户等级
	    	$rrs = WSTUserRank($rs['userTotalScore']);
	    	$rs['rankId'] = $rrs['rankId'];
	    	$rs['rankName'] = $rrs['rankName'];
	    	$rs['userrankImg'] = $rrs['userrankImg'];
    		if($rs['loginPwd']!=md5($loginPwd.$rs['loginSecret']))return WSTReturn("密码错误");
    		$ip = request()->ip();
    		$update = [];
    		$update = ["lastTime"=>date('Y-m-d H:i:s'),"lastIP"=>$ip];
    		$wxOpenId = session('WST_WX_OPENID');
    		if($wxOpenId){
    			$update['wxOpenId'] = session('WST_WX_OPENID');
                $userinfo = session('WST_WX_USERINFO');
                if($rs['userPhoto']==''){
                    $update['userPhoto'] = $userinfo['headimgurl'];
                    $rs['userPhoto'] = $userinfo['headimgurl'];
                }
    		}
    		$this->where(["userId"=>$userId])->update($update);
    		//签到时间
    		if(WSTConf('CONF.signScoreSwitch')==1){
    			$rs['signScoreTime'] = 0;
    			$userscores = Db::name('user_scores')->where(["userId"=>$userId,"dataSrc"=>5,])->order('createTime desc')->find();
    			if($userscores)$rs['signScoreTime'] = date("Y-m-d",strtotime($userscores['createTime']));
    		}
    		//记录登录日志
    		$data = array();
    		$data["userId"] = $userId;
    		$data["loginTime"] = date('Y-m-d H:i:s');
    		$data["loginIp"] = $ip;
            $data['loginSrc'] = $loginSrc;
    		Db::name('log_user_logins')->insert($data);
    
    		$rd = $rs;
    		//记住密码
    		cookie("loginName", $loginName, 3600*24*90);
    		if($rememberPwd == "on"){
    			$datakey = md5($rs['loginName'])."_".md5($rs['loginPwd']);
    			$key = $rs['loginSecret'];
    			//加密
    			$base64 = new \org\Base64();
    			$loginKey = $base64->encrypt($datakey, $key);
    			cookie("loginPwd", $loginKey, 3600*24*90);
    		}else{
    			cookie("loginPwd", null);
    		}
    		session('WST_USER',$rs);
    		hook('afterUserLogin',['user'=>$rs]);
    		return WSTReturn("登录成功","1");
    	}
    	return WSTReturn("用户不存在");
    }

    /**
     * 用户手机登录验证
     */
    public function checkLoginByPhone($loginSrc = 0){
        $loginName = input("post.loginNamea");
        $phoneVerify = input("post.mobileCode");
        $timeVerify = session('VerifyCode_userPhone_Time2');
        if($loginName!=session('VerifyCode_userPhone2')){
            return WSTReturn("登录手机号与校验手机号不一致，请重新输入！",-1);
        }
        if(!session('VerifyCode_userPhone_Verify2') || time()>floatval($timeVerify)+10*60){
            return WSTReturn("短信验证码已失效，请重新发送！",-1);
        }
        if($phoneVerify==session('VerifyCode_userPhone_Verify2')){
            session('VerifyCode_userPhone_Verify2',null);
            session('VerifyCode_userPhone_Time2',null);
            session('VerifyCode_userPhone2');
            $rs = $this->where("userPhone",$loginName)
                ->where(["dataFlag"=>1, "userStatus"=>1])
                ->find();
            hook("beforeUserLogin",["user"=>&$rs,'loginType'=>'phone']);
            if(!empty($rs)){
                $userId = $rs['userId'];
                //获取用户等级
                $rrs = WSTUserRank($rs['userTotalScore']);
                $rs['rankId'] = $rrs['rankId'];
                $rs['rankName'] = $rrs['rankName'];
                $rs['userrankImg'] = $rrs['userrankImg'];
                $ip = request()->ip();
                $update = [];
                $update = ["lastTime"=>date('Y-m-d H:i:s'),"lastIP"=>$ip];
                $wxOpenId = session('WST_WX_OPENID');
                if($wxOpenId){
                    $update['wxOpenId'] = session('WST_WX_OPENID');
                    $userinfo = session('WST_WX_USERINFO');
                    if($rs['userPhoto']==''){
                        $update['userPhoto'] = $userinfo['headimgurl'];
                        $rs['userPhoto'] = $userinfo['headimgurl'];
                    }
                }
                $this->where(["userId"=>$userId])->update($update);
                //签到时间
                if(WSTConf('CONF.signScoreSwitch')==1){
                    $rs['signScoreTime'] = 0;
                    $userscores = Db::name('user_scores')->where(["userId"=>$userId,"dataSrc"=>5,])->order('createTime desc')->find();
                    if($userscores)$rs['signScoreTime'] = date("Y-m-d",strtotime($userscores['createTime']));
                }
                //记录登录日志
                $data = array();
                $data["userId"] = $userId;
                $data["loginTime"] = date('Y-m-d H:i:s');
                $data["loginIp"] = $ip;
                $data['loginSrc'] = $loginSrc;
                Db::name('log_user_logins')->insert($data);

                $rd = $rs;
                cookie("loginName", $loginName, 3600*24*90);
                session('WST_USER',$rs);
                hook('afterUserLogin',['user'=>$rs]);
                return WSTReturn("登录成功","1");
            }
            return WSTReturn("用户不存在");
        }else{
            return WSTReturn("短信验证码不一致，请重新输入！",-1);
        }
    }
    
    /**
     * 会员注册
     * 注册方式$registerType,账号注册:1,手机注册:2
     * 登录来源$loginSrc,pc:0,mobile:2,wechat:1,app-android:3,app-ios:4,weapp:5
     */
    public function regist($registerType=1,$loginSrc = 0){
    	$data = array();
    	$data['loginName'] = input("post.loginName");
    	$data['loginPwd'] = input("post.loginPwd");
    	$data['reUserPwd'] = input("post.reUserPwd");
    	// app端的用户名、密码、确认密码经过base64位加密传过来，需解密处理
    	if($loginSrc==3 || $loginSrc==4){
            $registerKey = input('registerKey');
            $registerKey = base64_decode($registerKey);
            $registerKey = explode('_',$registerKey);
            $data['loginName'] = base64_decode($registerKey[0]);
            $data['loginPwd'] = base64_decode($registerKey[1]);
    	    $data['reUserPwd'] = base64_decode($registerKey[2]);
        }
        $loginName = '';
        if($registerType==1){
            // 账号注册
            $code = input("post.verifyCode");
            if(!WSTVerifyCheck($code)){
                return WSTReturn('验证码错误!');
            }
            if (!preg_match('/^[A-Za-z0-9_]+$/', $data['loginName'])) {
                return WSTReturn("用户名必须是数字、字母或下划线!");
            }
            $loginName = $data['loginName'];
        }else{
            // 手机注册
            $startTime = (int)session('VerifyCode_userPhone_Time');
            if((time()-$startTime)>120){
                return WSTReturn("验证码已超过有效期!");
            }
            $loginName = session('VerifyCode_userPhone');
            if($data['loginName']!=$loginName){
                return WSTReturn("注册手机号与验证手机号不一致!");
            }
            $mobileCode = input("post.mobileCode");

            $data['userPhone'] = $loginName;
            $verify = session('VerifyCode_userPhone_Verify');
            if($mobileCode=="" || $verify != $mobileCode){
                return WSTReturn("验证码错误!");
            }
            $loginName = WSTRandomLoginName($loginName);
            session('VerifyCode_userPhone_Verify',null);
            session('VerifyCode_userPhone',null);
            session('VerifyCode_userPhone_Time',null);
        }

    	//检测账号是否存在
    	$crs = WSTCheckLoginKey($loginName);
    	if($crs['status']!=1)return $crs;
    	if($data['loginPwd']!=$data['reUserPwd']){
    		return WSTReturn("两次输入的密码不一致!");
    	}
    	foreach ($data as $v){
    		if($v ==''){
    			return WSTReturn("注册信息不完整!");
    		}
    	}
    	if($loginName=='')return WSTReturn("注册失败!");//分派不了登录名
    	$data['loginName'] = $loginName;
    	unset($data['reUserPwd']);
    	unset($data['protocol']);
    	//检测账号，邮箱，手机是否存在
    	$data["loginSecret"] = rand(1000,9999);
    	$data['loginPwd'] = md5($data['loginPwd'].$data['loginSecret']);
    	$data['userName'] = ($registerType==2)?'手机用户'.substr($data['userPhone'],-4):$loginName;
    	$data['userQQ'] = "";
    	$data['userScore'] = 0;
    	$data['createTime'] = date('Y-m-d H:i:s');
    	$data['dataFlag'] = 1;
    	// 微信端参数
        if($loginSrc==1){
            $wxOpenId = session('WST_WX_OPENID');
            if($wxOpenId){
                $data['wxOpenId'] = session('WST_WX_OPENID');
                $userinfo = session('WST_WX_USERINFO');
                if($userinfo){
                    $nickname = json_encode($userinfo['nickname']);
                    $nickname = preg_replace("/\\\u[ed][0-9a-f]{3}\\\u[ed][0-9a-f]{3}/","*",$nickname);//替换成*
                    $nickname = json_decode($nickname);
                    if($nickname=="") $nickname = "微信用户";
                    $data['userName'] = $nickname;
                    $data['userSex'] = $userinfo['sex'];
                    $data['userPhoto'] = $userinfo['headimgurl'];
                }
            }
        }
    	// 小程序端参数
        // 解码小程序端传递的参数
        if($loginSrc==5){
            $openId = $session_key = $unionId = [];
            $sessionKey = input("sessionKey");
            if(!$sessionKey)return WSTReturn('注册失败,请重试',-1);
            $sessionKey = base64_decode($sessionKey);
            $sessionKey = explode('_',$sessionKey);
            if(isset($sessionKey[0]))$openId = base64_decode($sessionKey[0]);
            if(isset($sessionKey[1]))$session_key = base64_decode($sessionKey[1]);
            $unionKey = input("unionKey");
            if($unionKey){
                $unionKey = base64_decode($unionKey);
                $unionKey = explode('_',$unionKey);
                if(isset($unionKey[0]))$unionId = base64_decode($unionKey[0]);
            }
            if($session_key){
                $nickname = json_encode(input('nickName',''));
                $nickname = preg_replace("/\\\u[ed][0-9a-f]{3}\\\u[ed][0-9a-f]{3}/","*",$nickname);//替换成*
                $nickname = json_decode($nickname);
                if($nickname=="") $nickname = $data['userName'];
                $data['userName'] = $nickname;
                $data['userPhoto'] = input('avatarUrl','');
                $data['userSex'] = (int)input('gender',0);
                $data['weOpenId'] = $openId;
            }
            if($unionId){
                $data['wxUnionId'] = $unionId;
            }
        }
        // app端参数
        //【微信注册】判断是否有传unionId
        if($loginSrc==3 || $loginSrc==4){
            $unionId = input('unionId');
            if($unionId!=''){
                // 判断该unionId是否已经绑定其他账号
                $has = $this->where(['wxUnionId'=>$unionId,'dataFlag'=>1,'userStatus'=>1])->find();
                if(!empty($has)){
                    return WSTReturn('该微信已绑定其他账号',-1);
                }
                $data['wxUnionId'] = $unionId;
            }

            //【QQ绑定】判断是否有传qqOpenId
            $qqOpenId = input('qqOpenId');
            if($qqOpenId!=''){
                // 判断该qqOpenId是否已经绑定其他账号
                $has = $this->alias('u')
                    ->join('third_users tu','tu.userId=u.userId','inner')
                    ->where(['tu.thirdOpenId'=>$qqOpenId,'u.dataFlag'=>1])
                    ->find();
                if(!empty($has)){
                    return WSTReturn('该QQ已绑定其他账号',-1);
                }
            }
            //【支付宝绑定】判断是否有传支付宝user_di
            $alipayId = input('alipayId');
            if($alipayId!=''){
                // 判断该alipayId是否已经绑定其他账号
                $has = $this->alias('u')
                    ->join('third_users tu','tu.userId=u.userId','inner')
                    ->where(['tu.thirdOpenId'=>$alipayId,'u.dataFlag'=>1])
                    ->find();
                if(!empty($has)){
                    return WSTReturn('该支付宝用户已绑定其他账号',-1);
                }
            }
        }
    	Db::startTrans();
        try{
	    	$userId = $this->data($data)->save();
	    	if(false !== $userId){
	    		$data = array();
	    		$ip = request()->ip();
	    		$data['lastTime'] = date('Y-m-d H:i:s');
	    		$data['lastIP'] = $ip;
	    		$userId = $this->userId;
	    		$this->where(["userId"=>$userId])->update($data);
	    		//记录登录日志
	    		$data = array();
	    		$data["userId"] = $userId;
	    		$data["loginTime"] = date('Y-m-d H:i:s');
	    		$data["loginIp"] = $ip;
                $data['loginSrc'] = $loginSrc;
                $data["loginRemark"] = (input('loginRemark')!='')?input('loginRemark'):'';
	    		Db::name('log_user_logins')->insert($data);
                $user = $this->get($userId);
                //获取用户等级
                $rrs = WSTUserRank($user['userTotalScore']);
                $user['rankId'] = $rrs['rankId'];
                $user['rankName'] = $rrs['rankName'];
                $user['userrankImg'] = $rrs['userrankImg'];
                session('WST_USER',$user);
                //注册成功后执行钩子
                hook('afterUserRegist',['user'=>$user]);
	    		//发送消息
                $tpl = WSTMsgTemplates('USER_REGISTER');
                if($tpl['tplContent']!='' && $tpl['status']=='1'){
                    $find = ['${LOGIN_NAME}','${SHOP_NAME}'];
                    $replace = [$user['loginName'],WSTConf('CONF.shopName')];
                    WSTSendMsg($userId,str_replace($find,$replace,$tpl['tplContent']),['from'=>0,'dataId'=>0]);
                }
                // app端与小程序端记录tokenId，app端执行QQ绑定或支付宝绑定
                $tokenId = '';
                if($loginSrc==3 || $loginSrc==4 || $loginSrc==5){
                    $data = array();
                    $key = sprintf('%011d',$userId);
                    $tokenId = $this->to_guid_string($key.time());
                    $data['userId'] = $userId;
                    $data['tokenId'] = $tokenId;
                    $data['startTime'] = date('Y-m-d H:i:s');
                    $data['deviceId'] = input('deviceId');
                    if($loginSrc == 5){
                        Db::name('weapp_session')->insert($data);
                    }else{
                        Db::name('app_session')->insert($data);
                        // 执行【QQ绑定】
                        if($qqOpenId!=''){
                            $tuModel = Db::name('third_users');
                            $bindQqData = [];
                            $bindQqData['userId'] = $this->userId;
                            $bindQqData['thirdCode'] = 'qq';
                            $bindQqData['thirdOpenId'] = $qqOpenId;
                            $bindQqData['createTime'] = date('Y-m-d H:i:s');
                            // 绑定qqOpenId
                            $bindRs = $tuModel->insert($bindQqData);
                        }
                        // 执行【支付宝账号绑定】
                        if($alipayId!=''){
                            $tuModel = Db::name('third_users');
                            $bindAlipayData = [];
                            $bindAlipayData['userId'] = $this->userId;
                            $bindAlipayData['thirdCode'] = 'alipay';
                            $bindAlipayData['thirdOpenId'] = $alipayId;
                            $bindAlipayData['createTime'] = date('Y-m-d H:i:s');
                            // 绑定alipayId
                            $bindRs = $tuModel->insert($bindAlipayData);
                        }
                    }
                }
	    		Db::commit();
	    		return WSTReturn("注册成功!",1,$tokenId);
	    	}
        }catch (\Exception $e) {
        	Db::rollback();
        }
    	return WSTReturn("注册失败!".$e->getMessage());
    }

    /**
     * 根据PHP各种类型变量生成唯一标识号
     * @param mixed $mix 变量
     * @return string
     */
    private function to_guid_string($mix) {
        if (is_object($mix)) {
            return spl_object_hash($mix);
        } elseif (is_resource($mix)) {
            $mix = get_resource_type($mix) . strval($mix);
        } else {
            $mix = serialize($mix);
        }
        return md5($mix);
    }

    /**
     * 查询用户手机是否存在
     * 
     */
    public function checkUserPhone($userPhone,$userId = 0){
    	$dbo = $this->where(["dataFlag"=>1, "userPhone"=>$userPhone]);
    	if($userId>0){
    		$dbo->where("userId","<>",$userId);
    	}
    	$rs = $dbo->count();
    	if($rs>0){
    		return WSTReturn("手机号已存在!");
    	}else{
    		return WSTReturn("",1);
    	}
    }

    /**
     * 修改用户密码
     */
    public function editPass($id){
    	$data = array();
    	$data["loginPwd"] = input("post.newPass");
    	if(!$data["loginPwd"]){
    		return WSTReturn('密码不能为空',-1);
    	}
    	$rs = $this->where('userId='.$id)->find();
    	//核对密码
    	if($rs['loginPwd']){
    		if($rs['loginPwd']==md5(input("post.oldPass").$rs['loginSecret'])){
    			$data["loginPwd"] = md5(input("post.newPass").$rs['loginSecret']);
    			$rs = $this->update($data,['userId'=>$id]);
    			if(false !== $rs){
                    hook("afterEditPass",["userId"=>$id]);
    				return WSTReturn("密码修改成功", 1);
    			}else{
    				return WSTReturn($this->getError(),-1);
    			}
    		}else{
    			return WSTReturn('原始密码错误',-1);
    		}
    	}else{
    		$data["loginPwd"] = md5(input("post.newPass").$rs['loginSecret']);
    		$rs = $this->update($data,['userId'=>$id]);
    		if(false !== $rs){
                hook("afterEditPass",["userId"=>$id]);
    			return WSTReturn("密码修改成功", 1);
    		}else{
    			return WSTReturn($this->getError(),-1);
    		}
    	}
    }
    /**
     * 修改用户支付密码
     */
    public function editPayPass($id){
        $data = array();
        $data["payPwd"] = input("post.newPass");
        if(!$data["payPwd"]){
            return WSTReturn('支付密码不能为空',-1);
        }
        $rs = $this->where('userId='.$id)->find();
        //核对密码
        if($rs['payPwd']){
            if($rs['payPwd']==md5(input("post.oldPass").$rs['loginSecret'])){
                $data["payPwd"] = md5($data["payPwd"].$rs['loginSecret']);
                $rs = $this->update($data,['userId'=>$id]);
                if(false !== $rs){
                    return WSTReturn("支付密码修改成功", 1);
                }else{
                    return WSTReturn("支付密码修改失败",-1);
                }
            }else{
                return WSTReturn('原始支付密码错误',-1);
            }
        }else{
            $data["payPwd"] = md5($data["payPwd"].$rs['loginSecret']);
            $rs = $this->update($data,['userId'=>$id]);
            if(false !== $rs){
                return WSTReturn("支付密码设置成功", 1);
            }else{
                return WSTReturn("支付密码修改失败",-1);
            }
        }
    }
    /**
     * 重置用户支付密码
     */
    public function resetbackPay($uId=0){
    	$timeVerify = session('Verify_backPaypwd_Time');
    	if(time()>floatval($timeVerify)+10*60){
    		session('Type_backPaypwd',null);
    		return WSTReturn("校验码已失效，请重新验证！");
    		exit();
    	}
    	$data = array();
    	$data["payPwd"] = input("post.newPass");
    	if(!$data["payPwd"]){
    		return WSTReturn('支付密码不能为空',-1);
    	}
    	$userId = ($uId==0)?(int)session('WST_USER.userId'):$uId;
    	$rs = $this->where('userId='.$userId)->find();
    	$data["payPwd"] = md5($data["payPwd"].$rs['loginSecret']);
    	$rs = $this->update($data,['userId'=>$userId]);
    	if(false !== $rs){
    		session('Type_backPaypwd',null);
    		session('Verify_backPaypwd_info',null);
    		session('Verify_backPaypwd_Time',null);
    		return WSTReturn("支付密码设置成功", 1);
    	}else{
    		return WSTReturn("支付密码修改失败",-1);
    	}
    }
   /**
    *  获取用户信息
    */
    public function getById($id){
    	$rs = $this->get(['userId'=>(int)$id]);
    	$rs['ranks'] = WSTUserRank($rs['userTotalScore']);
    	return $rs;
    }
    /**
     * 编辑资料
    */
    public function edit(){
    	$Id = (int)session('WST_USER.userId');
    	$data = input('post.');
        if(isset($data['brithday']))$data['brithday'] = ($data['brithday']=='')?date('Y-m-d'):$data['brithday'];
    	WSTAllow($data,'brithday,trueName,userName,userPhoto,userQQ,userSex');
    	Db::startTrans();
		try{
            if(isset($data['userPhoto'])){
            	WSTUseResources(0, $Id, $data['userPhoto'],'users','userPhoto');
            	session('WST_USER.userPhoto',$data['userPhoto']);
            }
	    	$result = $this->allowField(true)->save($data,['userId'=>$Id]);
	    	if(false !== $result){
	    		Db::commit();
	    		return WSTReturn("编辑成功", 1);
	    	}
		}catch (\Exception $e) {
            Db::rollback();
            return WSTReturn('编辑失败',-1);
        }	
    }
    /**
    * 保存上传头像
    */
    public function saveUserPhoto($imgSrc){
        $userId = (int)session('WST_USER.userId');
        $has = $this->where(['userId'=>$userId])->value('userPhoto');
        // 启用图片
        empty($has)?WSTUseResources(0, $userId, $imgSrc):WSTUseResources(0, $userId, $imgSrc,'users','userPhoto');
        $data['userPhoto'] = $imgSrc;
        return $this->save($data,['userId'=>$userId]);
    }
    /**
    * 绑定邮箱
     */
    public function editEmail($userId,$userEmail){
    
        $data = array();
        $data["userEmail"] = $userEmail;
        Db::startTrans();
        try{
            $user = Db::name('users')->where(["userId"=>$userId])->field(["userId","loginName,userEmail"])->find();
            $rs = $this->update($data,['userId'=>$userId]);
            if(false !== $rs){
                hook("afterEditEmail",["user"=>$user]);
                Db::commit();
                return WSTReturn("绑定成功",1);
            }else{
                Db::rollback();
                return WSTReturn("",-1);
            }
        }catch (\Exception $e) {
            Db::rollback();
            return WSTReturn('编辑失败',-1);
        }
    }
    /**
     * 绑定手机
     */
    public function editPhone($userId,$userPhone){
    	$data = array();
    	$data["userPhone"] = $userPhone;
    	$rs = $this->update($data,['userId'=>$userId]);
    	if(false !== $rs){
            session('Verify_info',null);
            session('Verify_userPhone_Time',null);
    		return WSTReturn("绑定成功", 1);
    	}else{
    		return WSTReturn($this->getError(),-1);
    	}
    }
    /**
     * 查询并加载用户资料
     */
    public function checkAndGetLoginInfo($key){
    	if($key=='')return array();
    	$rs = $this->where(["loginName|userEmail|userPhone"=>['=',$key],'dataFlag'=>1])->find();
    	return $rs;
    }
    /**
     * 重置用户密码
     */
    public function resetPass(){
    	if(time()>floatval(session('REST_Time'))+30*60){
    		return WSTReturn("连接已失效！", -1);
    	}
    	$reset_userId = (int)session('REST_userId');
    	if($reset_userId==0){
    		return WSTReturn("无效的用户！", -1);
    	}
    	$user = $this->where(["dataFlag"=>1,"userStatus"=>1,"userId"=>$reset_userId])->find();
    	if(empty($user)){
    		return WSTReturn("无效的用户！", -1);
    	}
    	$loginPwd = input("post.loginPwd");
    	if(trim($loginPwd)==''){
    		return WSTReturn("无效的密码！", -1);
    	}
    	$data['loginPwd'] = md5($loginPwd.$user["loginSecret"]);
    	$rc = $this->update($data,['userId'=>$reset_userId]);
    	if(false !== $rc){
    		return WSTReturn("修改成功", 1);
    	}
        session('findPhone',$USER);
    	session('REST_userId',null);
    	session('REST_Time',null);
    	session('REST_success',null);
    	session('findPass',null);
    	return $rs;
    }
    
    /**
     * 获取用户可用积分
     */
    public function getFieldsById($userId,$fields){
    	return $this->where(['userId'=>$userId,'dataFlag'=>1])->field($fields)->find();
    }
}
