<?php
namespace wstshop\home\controller;
use wstshop\common\model\Orders as OM;
use wstshop\common\model\Users as UM;
/**
 * ============================================================================
 * wstshop多用户商城
 * 版权所有 2016-2066 广州商淘信息科技有限公司，并保留所有权利。
 * 官网地址:http://www.wstshop.net
 * 交流社区:http://bbs.shangtao.net
 * 联系QQ:153289970
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经本公司授权您只能在不用于商业目的的前提下对程序代码进行修改和使用；
 * 不允许对程序代码以任何形式任何目的的再发布。
 * ============================================================================
 * 余额控制器
 */
class Wallets extends Base{
	/**
	 * 生成支付代码
	 */
	function getWalletsUrl(){
		$pkey = input('pkey');
        $data = [];
        $data['status'] = 1;
        $data['url'] = url('home/wallets/payment','pkey='.$pkey,'html',true);
		return $data;
	}
	
	/**
	 * 跳去支付页面
	 */
	public function payment(){
		$userId = (int)session('WST_USER.userId');
		if($userId==0){
			$this->assign('message',"对不起，您尚未登录，请先登录!");
            return $this->fetch('error_msg');
		}
		$pkey = input('pkey');
		$orderId = (int)WSTBase64urlDecode($pkey);
		$m = new OM();
		$rs = $m->checkOrderPay($userId,$orderId);
		if($rs["status"]==1){
			$um = new UM();
			$user = $um->getFieldsById($userId,["payPwd"]);
			$this->assign('hasPayPwd',($user['payPwd']!="")?1:0);
			$obj = array();
			$obj["userId"] = $userId;
			$obj["orderId"] = $orderId;
			$order = $m->getPayOrders($obj);
			$needPay = $order["needPay"];
			
			$this->assign('pkey',$pkey);
			$this->assign('needPay',$order["needPay"]);
			//获取用户钱包
			$user = model('users')->getFieldsById($obj['userId'],'userMoney');
			$this->assign('userMoney',$user['userMoney']);
			return $this->fetch('order_pay_wallets');
		}else{
			$this->assign('message',"您的订单已支付，请勿重复支付~");
            return $this->fetch('error_msg');
	    }
	}

	/**
	 * 钱包支付
	 */
	public function payByWallet(){
		$m = new OM();
        return $m->payByWallet();
	}

}
