<div class="page-home row-content am-cf">
    <!-- 商城统计 -->
    <div class="row">
        <div class="am-u-sm-12 am-u-md-12 am-u-lg-12 am-margin-bottom">
            <div class="widget am-cf">
                <div class="widget-head">
                    <div class="widget-title">商城统计</div>
                </div>
                <div class="widget-body am-cf">
                    <div class="am-u-sm-12 am-u-md-6 am-u-lg-3">
                        <div class="widget-card card__blue am-cf">
                            <div class="card-header">商品总量</div>
                            <div class="card-body">
                                <div class="card-value"><?=$count['goods']?></div>
                                <div class="card-description">当前商品总数量</div>
                                <span class="card-icon iconfont icon-goods"></span>
                            </div>
                        </div>
                    </div>

                    <div class="am-u-sm-12 am-u-md-6 am-u-lg-3">
                        <div class="widget-card card__red am-cf">
                            <div class="card-header">用户总量</div>
                            <div class="card-body">
                                <div class="card-value"><?=$count['user'][0]?></div>
                                <div class="card-description">当前用户总数量</div>
                                <span class="card-icon iconfont icon-user"></span>
                            </div>
                        </div>
                    </div>

                    <div class="am-u-sm-12 am-u-md-6 am-u-lg-3">
                        <div class="widget-card card__violet am-cf">
                            <div class="card-header">订单总量</div>
                            <div class="card-body">
                                <div class="card-value"><?=$count['order'][0][0]?></div>
                                <div class="card-description">付款订单总数量</div>
                                <span class="card-icon iconfont icon-order"></span>
                            </div>
                        </div>
                    </div>

                    <div class="am-u-sm-12 am-u-md-6 am-u-lg-3">
                        <div class="widget-card card__primary am-cf">
                            <div class="card-header">评价总量</div>
                            <div class="card-body">
                                <div class="card-value"><?=$count['comment'][0]?></div>
                                <div class="card-description">订单评价总数量</div>
                                <span class="card-icon iconfont icon-haoping2"></span>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>

    <!-- 实时概况 -->
    <div class="row">
        <div class="am-u-sm-12 am-u-md-12 am-u-lg-12 am-margin-bottom">
            <div class="widget am-cf">
                <div class="widget-head">
                    <div class="widget-title">实时概况</div>
                </div>
                <div class="widget-body am-cf">
                    <div class="am-u-sm-6 am-u-md-12 am-u-lg-3">
                        <div class="widget-outline dis-flex flex-y-center">
                            <div class="outline-left">
                                <img src="data:image/png;base64,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">
                            </div>
                            <div class="outline-right dis-flex flex-dir-column flex-x-between">
                                <div style="color: rgb(102, 102, 102); font-size: 1.2rem;">今日销售额(元)</div>
                                <div style="color: rgb(51, 51, 51); font-size: 2.4rem;"><?=$count['order'][1][1]?></div>
                                <div style="color: rgb(153, 153, 153); font-size: 1.2rem;">
                                    昨日：<?=$count['order'][1][2]?></div>
                            </div>
                        </div>
                    </div>
                    <div class="am-u-sm-6 am-u-md-12 am-u-lg-3">
						<div class="widget-outline dis-flex flex-y-center">
                            <div class="outline-left">
                                <img src="data:image/png;base64,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">
                            </div>
							<div class="outline-right dis-flex flex-dir-column flex-x-between">
								<div style="color: rgb(102, 102, 102); font-size: 1.2rem;">今日付款订单</div>
								<div style="color: rgb(51, 51, 51); font-size: 2.4rem;"><?=$count['order'][0][1]?></div>
								<div style="color: rgb(153, 153, 153); font-size: 1.2rem;">
									昨日：<?=$count['order'][0][2]?></div>
							</div>
						</div>
                    </div>
                    <div class="am-u-sm-6 am-u-md-12 am-u-lg-3">
                        <div class="widget-outline dis-flex flex-y-center">
                            <div class="outline-left">
                                <img src="data:image/png;base64,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">
                            </div>
                            <div class="outline-right dis-flex flex-dir-column flex-x-between">
                                <div style="color: rgb(102, 102, 102); font-size: 1.2rem;">今日新增用户</div>
                                <div style="color: rgb(51, 51, 51); font-size: 2.4rem;"><?=$count['user'][1]?></div>
                                <div style="color: rgb(153, 153, 153); font-size: 1.2rem;">
                                    昨日：<?=$count['user'][2]?></div>
                            </div>
                        </div>
                    </div>
                    <div class="am-u-sm-6 am-u-md-12 am-u-lg-3">
						<div class="widget-outline dis-flex flex-y-center">
                            <div class="outline-left">
                                <img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAI4AAACMCAMAAACd62ExAAAABGdBTUEAALGPC/xhBQAAAAFzUkdCAK7OHOkAAAAzUExURUdwTPn///D4/+/2//T6//D3//H3//D3//D3//H5/2aq/7DT/5HC/3az/8Ld/9zs/53I/+kzVBAAAAAKdFJOUwAOY/8hooXE4kIJnP2wAAADmUlEQVR42u2ca3fCIAyGLeFqW+j//7XTOWedbUkgYHaO784+6p6FJNxCTqdyDVpZY5zz3gN475wzVoXh1F9DsO7CsCnvjNJ9USAn3wdpUHmUu5xtTBQM0ORUM1carIcCmdACRlsolWMH0gZqxAtUCcMMpIBDhifMggcmKYZwMsCn6hHjM81NtorGArdcuQdpB/zyQchA1Q2YglZygwS3qeEx0FJevy/bVPMMDlqLEmDtaSj2MQCCeCz0ES6+etHgeBT0k8nPU9BT6v0h/qQgIahW4TVIcZy8+2joL/XebPwiLWeovrPPXlT5t+DsRRciqmIcqYqxLLpCFmY8F2lOJYvnrB/P50LNBd6cNc50LtZITz4548Tv/3NakHqCX8jmQRkn6wV3peUxUpffiZybUZ6DpIm/ppnHFDE4f82TD6vrt6MMM/66/BR/BjmPY6nTAw5nZZgl/fpcHgcG4tyJwfljGAqOIq6Pszgr913Sc0ROxJnLV+PE+eG+LwkCgbN25gCVOFujRMSxtL3MEc70iOvN9InB8aSxOsIZdwxDwnmsMzBjdYQzreK6HMeQ9p0HOIcJG43jSUvk5jj32BpABo4iuE4HHEM5smiP4ym7q/Y4P84DUnAUYSc8t8exeE++pt6xMY6hHL6lBI1xHM+RDhcO8BxbsOFo5HTeCSeg47wLjsLOWN1w9AfnIA+GD85BWv7gfHBKXVl/cP7PJCFsCpW2wBC2/EIuTuM8xx6LU4s2wdxj6Y7Mgx22fYaw7Tt32vYJ2xRLOzIQdqAi7LhJ2GGcsKNKaQe5QQSO4boE4MEJXFckLDiedoF08DdZcCztem3a/1oWHE27fLxd6y9bVR9nBhxHLWs6LnpIu6u2gqtZTCZMMxknLbfPUC+ucalnoeE87tQjyZHRE0WK47Lxs4WTDm5rM45MWKIiI+thmPOSSBmZoSruL864d6eONk6VeZ5wVsUGmFHaMU6NeVY4T7Uy6C/QRaVoOZx7XFMMsxVWleWvN5zXWhmkdspgi8sYrziFhnleWfAUea6nD5phXmYrDm9O1LjO+nFdgXC8GSaWfFY1KJ9Ol6kiFX3S/KPicmml98IeJkh7tiHtUYu0Jz/SHkRJey4m7TGdsKeG0h5iinumKu0Rr7QnztIegEt7Hi+ueQBLC4yVaRiaYYhqPCGuLYe4piXSWrqIa3gjrh2QuGZJ5FZS3nZpbiWo0Za8NmQbTdqAq0nbF7i46IS8tSAEAAAAAElFTkSuQmCC">
                            </div>
							<div class="widget-outline dis-flex flex-dir-column flex-x-between">
								<div style="color: rgb(102, 102, 102); font-size: 1.2rem;">今日好评</div>
								<div style="color: rgb(51, 51, 51); font-size: 2.4rem;"><?=$count['comment'][1]?></div>
								<div style="color: rgb(153, 153, 153); font-size: 1.2rem;">
									昨日：<?=$count['comment'][2]?></div>
							</div>
						</div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- 近七日交易走势 -->
    <div class="row">
        <div class="am-u-sm-12 am-u-md-12 am-u-lg-12 am-margin-bottom">
            <div class="widget am-cf">
                <div class="widget-head">
                    <div class="widget-title">近七日交易走势</div>
                </div>
                <div class="widget-body am-cf">
                    <div id="echarts-trade" class="widget-echarts" _echarts_instance_="ec_1544710141874" style="-webkit-tap-highlight-color: transparent; user-select: none; position: relative; background: rgba(252, 252, 252, 0);"><div style="position: relative; overflow: hidden; width: 1204px; height: 400px; cursor: default;"><canvas width="1204" height="400" data-zr-dom-id="zr_0" style="position: absolute; left: 0px; top: 0px; width: 1204px; height: 400px; user-select: none; -webkit-tap-highlight-color: rgba(0, 0, 0, 0);"></canvas></div><div style="position: absolute; display: none; border-style: solid; white-space: nowrap; z-index: 9999999; transition: left 0.4s cubic-bezier(0.23, 1, 0.32, 1) 0s, top 0.4s cubic-bezier(0.23, 1, 0.32, 1) 0s; background-color: rgba(50, 50, 50, 0.7); border-width: 0px; border-color: rgb(51, 51, 51); border-radius: 4px; color: rgb(255, 255, 255); font: 14px/21px &quot;Microsoft YaHei&quot;; padding: 5px; left: 300.933px; top: 160.625px;">2018-12-08<br><span style="display:inline-block;margin-right:5px;border-radius:10px;width:9px;height:9px;background-color:#3fb1e3"></span>成交额 : 778.00<br><span style="display:inline-block;margin-right:5px;border-radius:10px;width:9px;height:9px;background-color:#6be6c1"></span>成交量 : 26</div></div>
                </div>
            </div>
        </div>
    </div>

	<div class="row">
        <div class="am-u-sm-12 am-u-md-12 am-u-lg-12">
            <div class="help-block am-text-center">
                <small>河马科技版权所有，技术交流QQ群：916181349，官方微信：fxtc08</small>
            </div>
        </div>

    </div>

</div>
<script src="assets/store/js/echarts.min.js"></script>
<script src="assets/store/js/echarts-walden.js"></script>
<script type="text/javascript">

    /**
     * 近七日交易走势
     * @type {HTMLElement}
     */
    var dom = document.getElementById('echarts-trade');
    echarts.init(dom, 'walden').setOption({
        tooltip: {
            trigger: 'axis'
        },
        legend: {
            data: ['订单量', '成交额']
        },
        toolbox: {
            show: true,
            showTitle: false,
            feature: {
                mark: {show: true},
                magicType: {show: true, type: ['line', 'bar']}
            }
        },
        calculable: true,
        xAxis: {
            type: 'category',
            boundaryGap: false,
            data: ["<?= date("Y-m-d",strtotime("-6 day"))?>","<?= date("Y-m-d",strtotime("-5 day"))?>","<?= date("Y-m-d",strtotime("-4 day"))?>","<?= date("Y-m-d",strtotime("-3 day"))?>","<?= date("Y-m-d",strtotime("-2 day"))?>","<?= date("Y-m-d",strtotime("-1 day"))?>","<?= date("Y-m-d")?>"]        
		},
        yAxis: {
            type: 'value'
        },
        series: [
            {
                name: '成交额',
                type: 'line',
                data: [<?= $count['order'][1][1] ?>,<?= $count['order'][1][2] ?>,<?= $count['order'][1][3] ?>,<?= $count['order'][1][4] ?>,<?= $count['order'][1][5] ?>,<?= $count['order'][1][6] ?>,<?= $count['order'][1][7] ?>]
			},
            {
                name: '订单量',
                type: 'line',
                data: [<?= $count['order'][0][1] ?>,<?= $count['order'][0][2] ?>,<?= $count['order'][0][3] ?>,<?= $count['order'][0][4] ?>,<?= $count['order'][0][5] ?>,<?= $count['order'][0][6] ?>,<?= $count['order'][0][7] ?>]
			}
        ]
    }, true);

</script>