<?php
/**
 * ShopEx licence
 *
 * @copyright  Copyright (c) 2005-2010 ShopEx Technologies Inc. (http://www.shopex.cn)
 * @license  http://ecos.shopex.cn/ ShopEx License
 */


class b2c_deposit_pay implements b2c_deposit_interface
{
    /**
     * 构造方法
     * @param object app
     */
    public function __construct($app)
    {
        $this->app = $app;
    }

    /**
     * 得到支付对象类别 - 当前为预存款
     * @param null
     * @param string - 消费卡类别
     */
    public function get_type()
    {
        return 'recharge';
    }

    /**
     * 预存款充值处理
     * @param array sdf 预存款的标准数据结构
     * @param array 支付单和支付对象关联表
     * @param string type 在线或者线下
     * @param string 操作员id
     * @param string 操作员name
     * @param array errorMsg error message
	 * @param boolean 前台操作还是后台操作
     * @return boolean
     */
    public function generate_bills($sdf, $arr_bills, $type='online', &$op_id, &$op_name, &$errorMsg,$is_frontend=true)
    {
        $app_b2c = app::get('b2c');
        $objAdvance = $this->app->model("member_advance");
        foreach ($sdf['orders'] as $key=>$str_sdf)
        {
            if ($key != '')
            {
                $member_id = $key;
                break;
            }
        }
        $status = $objAdvance->add($member_id, $arr_bills['money'], app::get('b2c')->_('前台预存款充值'), $msg, $sdf['payment_id'], 0, $sdf['pay_app_id'], '',$is_frontend);

        if ($arr_bills['rel_id'])
        {
            $obj_members = $app_b2c->model('members');
            $arr_members = $obj_members->getList('name', array('member_id'=>$arr_bills['rel_id']));
            $op_id = $arr_bills['rel_id'];
            $op_name = $arr_members['name'];
        }
        else
        {
            $op_id = '0';
            $op_name = '';
        }

        if ($type == 'online')
        {
            $payment_cfgs = app::get('ectools')->model('payment_cfgs');
            $arrPayments = $payment_cfgs->getPaymentInfo($sdf['pay_app_id']);

            $errorMsg[] = ($status == 'succ' || $status === true) ? ($arrPayments['app_display_name'] . app::get('b2c')->_('支付交易号:'). $sdf['trade_no'] . app::get('b2c')->_('前台预存款充值成功！')) : app::get('b2c')->_('订单号：') . $arr_bills['rel_id'] . ' ' . $arrPayments['app_display_name'] . ' ' . $msg;
        }
        else
            $errorMsg[] = ($status == 'succ' || $status === true) ? (app::get('b2c')->_(" 线下支付交易号: ") . $sdf['trade_no'] . app::get('b2c')->_("前台预存款充值成功！")) : app::get('b2c')->_("订单号：") . $arr_bills['rel_id'] . app::get('b2c')->_(' 线下支付交易 ') . $msg;
    }
}