<?php
/**
 * 网站联盟商表
 * 
 * @author gujun<gujun@shopex.cn>
 * @copyright 2003-2011 ShopEx
 * @license Commercial
 * @version $Id:users Jun 20, 2011  10:14:09 AM ever $
 */
$db['users'] = array(
    'columns' => array(
        'u_id' => array (
            'type' => 'table:account@pam',
            'required' => true,
            'pkey' => true,
            'width' => 100,
            'label' => app::get('cps')->_('ID'),
            'editable' => false,
            'in_list' => true,
            'default_in_list' => false,
        ),
        'u_name' => array(
            'type' => 'varchar(50)',
            'required' => true,
            'default' => '',
            'width' => 100,
            'label' => app::get('cps')->_('用户名'),
            'editable' => false,
            'searchtype' => 'has',
            'filtertype' => 'string',
            'filterdefault' => true,
            'in_list' => true,
            'default_in_list' => true,
        ),
        'realname' => array(
            'type' => 'varchar(100)',
            'required' => true,
            'default' => '',
            'width' => 100,
            'label' => app::get('cps')->_('联系人姓名'),
            'editable' => false,
        	'searchtype' => 'has',
            'filtertype' => 'string',
            'filterdefault' => true,
            'in_list' => true,
            'default_in_list' => true,
        ),
        'mobile' => array(
            'type' => 'varchar(30)',
            'required' => true,
            'default' => '',
            'width' => 120,
            'label' => app::get('cps')->_('手机号码'),
            'editable' => false,
            'in_list' => true,
            'default_in_list' => true,
        ),
        'tel' => array (
            'type' => 'varchar(30)',
            'required' => true,
            'default' => '',
            'width' => 120,
            'label' => app::get('cps')->_('电话号码'),
            'editable' => false,
            'in_list' => true,
            'default_in_list' => true,
        ),
        'email' => array(
            'type' => 'varchar(200)',
            'sdfpath' => 'contact/email',
            'required' => true,
            'default' => '',
            'width' => 120,
            'label' => app::get('cps')->_('邮箱'),
            'editable' => false,
            'searchtype' => 'has',
            'filtertype' => 'string',
            'filterdefault' => true,
            'in_list' => true,
            'default_in_list' => false,
        ),
        'regtime' => array(
            'type' => 'time',
            'required' => true,
            'default' => 0,
            'width' => 120,
            'label' => app::get('cps')->_('注册时间'),
            'editable' => false,
            'filtertype' => 'time',
            'filterdefault' => true,
            'in_list' => true,
            'default_in_list' => true,
        ),
        'reg_ip' => array(
            'type' => 'varchar(16)',
            'required' => true,
            'default' => '',
            'width' => 120,
            'label' => app::get('cps')->_('注册IP'),
            'editable' => false,
            'in_list' => true,
            'default_in_list' => false,
        ),
        'history_profit' => array(
            'type' => 'money',
            'required' => true,
            'default' => 0,
            'width' => 100,
            'label' => app::get('cps')->_('历史佣金总额'),
            'editable' => false,
            'in_list' => true,
            'default_in_list' => false,
        ),
        'profit' => array(
            'type' => 'money',
            'required' => true,
            'default' => 0,
            'width' => 100,
            'label' => app::get('cps')->_('尚未发放佣金'),
            'editable' => false,
            'in_list' => true,
            'default_in_list' => false,
        ),
        'u_type' => array(
            'type' => array(
                '0' => '个人',
                '1' => '企业',
            ),
            'required' => true,
            'default' => '0',
            'width' => 100,
            'label' => app::get('cps')->_('用户类型'),
            'editable' => false,
            'filtertype' => 'has',
            'filterdefault' => true,
            'in_list' => true,
            'default_in_list' => false,
        ),
        'union_id' => array (
            'type' => 'varchar(10)',
            'required' => true,
            'default' => '',
            'width' => 100,
            'label' => app::get('cps')->_('联盟商推广ID'),
            'editable' => false,
            'in_list' => false,
            'default_in_list' => false,
        ),
        'question' => array(
            'type' => 'varchar(200)',
            'required' => true,
            'default' => '',
            'width' => 120,
            'label' => app::get('cps')->_('安全问题'),
            'editable' => false,
            'in_list' => false,
            'default_in_list' => false,
        ),
        'answer' => array(
            'type' => 'varchar(200)',
            'required' => true,
            'default' => '',
            'width' => 120,
            'label' => app::get('cps')->_('安全答案'),
            'editable' => false,
            'in_list' => false,
            'default_in_list' => false,
        ),
        'qq' => array(
            'type' => 'varchar(100)',
            'required' => true,
            'default' => '',
            'width' => 120,
            'label' => app::get('cps')->_('QQ'),
            'editable' => false,
            'in_list' => false,
            'default_in_list' => false,
        ),
        'msn' => array(
            'type' => 'varchar(100)',
            'required' => true,
            'default' => '',
            'width' => 120,
            'label' => app::get('cps')->_('MSN'),
            'editable' => false,
            'in_list' => false,
            'default_in_list' => false,
        ),
        'addr' => array(
            'type' => 'varchar(200)',
            'required' => true,
            'default' => '',
            'width' => 120,
            'label' => app::get('cps')->_('地址'),
            'editable' => false,
            'in_list' => false,
            'default_in_list' => false,
        ),
        'zipcode' => array(
            'type' => 'varchar(10)',
            'required' => true,
            'default' => '',
            'width' => 120,
            'label' => app::get('cps')->_('邮编'),
            'editable' => false,
            'in_list' => false,
            'default_in_list' => false,
        ),
        'identity_card' => array(
            'type' => 'varchar(20)',
            'required' => true,
            'default' => '',
            'width' => 120,
            'label' => app::get('cps')->_('身份证号码'),
            'editable' => false,
            'in_list' => false,
            'default_in_list' => false,
        ),
        'state' => array(
            'type' => array(
                '0' => '审核中',
                '1' => '已通过',
                '2' => '已拒绝',
            ),
            'required' => true,
            'default' => '1',
            'width' => 100,
            'label' => app::get('cps')->_('审核状态'),
            'filtertype' => 'has',
            'filterdefault' => true,
            'editable' => false,
            'in_list' => false,
            'default_in_list' => false,
        ),
        'disabled' => array (
            'type' => array(
                'false' => '有效',
                'true' => '无效',
            ),
            'required' => true,
            'default' => 'false',
            'width' => 100,
            'label' => app::get('cps')->_('是否有效'),
            'editable' => false,
            'in_list' => false,
            'default_in_list' => false,
        ),
    ),
    'index' => array(
        'ind_disabled' => array(
            'columns' => array('disabled'),
        ),
        'ind_email' => array(
            'columns' => array('email'),
        ),
        'ind_regtime' => array(
            'columns' => array('regtime'),
        ),
        'ind_u_name' => array(
            'columns' => array('u_name'),
        ),
        'ind_state' => array(
            'columns' => array('state'),
        ),
    ),
    'engine' => 'innodb',
    'version' => '$Rev: 1 $',
);