<?php
/**
 * ShopEx licence
 *
 * @copyright  Copyright (c) 2005-2010 ShopEx Technologies Inc. (http://www.shopex.cn)
 * @license  http://ecos.shopex.cn/ ShopEx License
 */


class wap_ctl_admin_explorer_theme extends desktop_controller
{
    /*
     * workground
     * @var string
     */
    var $workground = 'wap.wrokground.theme';

    /*
     * @param object $app
     */
    function __construct($app)
    {
        parent::__construct($app);
        $this->_request = kernel::single('base_component_request');
        $this->_response = kernel::single('base_component_response');
    }//End Function

    private function get_theme_dir($theme, $open_path='')
    {
        return kernel::single('wap_theme_file')->get_theme_dir($theme, $open_path);
    }//End Function

    /*
     * 目录浏览
     */
    public function directory()
    {
        $theme = $this->_request->get_get('theme');
        $open_path = $this->_request->get_get('open_path');
        $is_part = $this->_request->get_get('part');

        $this->get_directory_body($theme,$open_path,'');

        $this->pagedata['theme'] = $theme;
        $this->pagedata['list'] = kernel::single('wap_theme_tmpl')->get_edit_list($theme);
        foreach ((array)$this->pagedata['list'] as $k=>$list){
            foreach ($list as $key=>$li){
                if (!$li||!$li['tmpl_name']) continue;
                $file_name = WAP_THEME_DIR. '/' . $theme . '/'.$li['tmpl_name'];

                if (filesize($file_name)) continue;
                unset($this->pagedata['list'][$k][$key]);
            }
        }
        $this->pagedata['types'] = kernel::single('wap_theme_tmpl')->get_name();
        $this->pagedata['open_path'] = $open_path;
        $this->pagedata['last_path'] = strrpos($open_path, '-') ? substr($open_path, 0, strrpos($open_path, '-')) : ($open_path ? ' ' : '');
        $this->pagedata['pagehead_active'] = 'source';
        if (!$open_path&&!$is_part){
            $this->singlepage('admin/explorer/theme/directory.html');
        }else{
             echo $this->fetch('admin/explorer/theme/theme_directory_body.html');exit;
         }
    }//End Function

    /**
     * 获取目录树的主题
     */
    private function get_directory_body($theme='',$open_path='',$msg='',$act='')
    {
        /** 加入目录限制 **/
        if(!$this->check($theme,$msg))   $this->_error($msg);

        $fileObj = kernel::single('wap_explorer_file');
        $fileObj->set_theme($theme);
        $dir = $this->get_theme_dir($theme, $open_path);
        $filter=array(
                 'id' => $atheme,
                 'dir' => $dir,
                 'show_bak' => false,
                 'type' => 'all'
             );
        $file = $fileObj->file_list($filter);

        $file = $fileObj->parse_filter($file);
        $this->pagedata['file'] = array_reverse($file);
        $this->pagedata['url'] = sprintf('index.php?app=%s&ctl=%s&act=%s&theme=%s',
            $this->_request->get_get('app'),
            $this->_request->get_get('ctl'),
            $act?$act:$this->_request->get_get('act'),
            $this->_request->get_get('theme')
        );
    }

    /*
     * 文件详情
     */
    public function detail()
    {
        $theme = $this->_request->get_get('theme');
        $open_path = $this->_request->get_get('open_path');
        $file_name = $this->_request->get_get('file_name');
        if(!$this->check($theme,$msg))   $this->_error($msg);

        $fileObj = kernel::single('wap_explorer_file');
        $fileObj->set_theme($theme);
        $dir = $this->get_theme_dir($theme, $open_path);
        $file_name = trim($file_name);
        $get_file = kernel::single('wap_theme_file')->get_file($dir, $file_name);


        $filter=array(
                 'id' => $theme,
                 'dir' => $dir,
                 'show_bak' => true,
                 'type' => 'all'
             );
        $filenameInfo = pathinfo($file_name);
        $this->pagedata['file_baklist'] = $fileObj->get_file_baklist($filter, $file_name);
        $this->pagedata['theme'] = $theme;
        $this->pagedata['open_path'] = $open_path;
        $this->pagedata['file_name'] = $file_name;
        $file_content = $fileObj->get_file($get_file);
        if(in_array($filenameInfo['extension'], array('css', 'html', 'js', 'xml'))){
            if($filenameInfo['extension'] == 'css'){
                $file_content = kernel::single('wap_theme_file')->get_content($file_content);
            }
            $this->pagedata['file_content']  = $file_content;
            if($filenameInfo['extension']=='js'){
                $filenameInfo['extension'] = 'javascript';
            }
            $this->pagedata['mode'] = 'text/'.$filenameInfo['extension'];/*php mode: application/x-httpd-php */
            $this->display('admin/explorer/theme/tpl_source.html');
        }else{
            $this->pagedata['file_url'] = kernel::single('wap_theme_file')->get_full_file_url($theme, $file_content, $open_path, $file_name);
            $this->display('admin/explorer/theme/tpl_image.html');
        }
    }//End Function

    /*
     * 保存文件
     */
    public function svae_source()
    {
        $this->begin();
        $theme = $this->_request->get_post('theme');
        $open_path = $this->_request->get_post('open_path');
        $file_name = $this->_request->get_post('file_name');

        if(!$this->check($theme,$msg))   $this->_error($msg);

        $has_bak = ($this->_request->get_post('has_bak')) ? true : false;
        $has_clearcache = ($this->_request->get_post('has_clearcache')) ? true : false;
        $file_source = $this->_request->get_post('file_source');

        $fileObj = kernel::single('wap_explorer_file',$theme);
        $fileObj->set_theme($theme);
        $dir = $this->get_theme_dir($theme, $open_path);

        $get_file = kernel::single('wap_theme_file')->get_file($dir, $file_name);

        if($has_bak){
            $fileObj->backup_file($get_file);
        }
        $fileObj->save_source($get_file, $file_source);
        if($has_clearcache){
            if(!ECAE_MODE) @touch($dir . '/' . $file_name);
            kernel::single('wap_theme_base')->set_theme_cache_version($theme);
        }
        $this->end(true, app::get('wap')->_('保存成功'));
    }//End Function

    /*
     * 保存图片文件
     */
    public function save_image()
    {
        $this->begin();
        $theme = $this->_request->get_post('theme');
        $open_path = $this->_request->get_post('open_path');
        $file_name = $this->_request->get_post('file_name');

        if(!$this->check($theme,$msg))   $this->_error($msg);

        $has_bak = ($this->_request->get_post('has_bak')) ? true : false;

        $fileObj = kernel::single('wap_explorer_file',$theme);
        $dir = $this->get_theme_dir($theme, $open_path);

        $get_file = kernel::single('wap_theme_file')->get_file($dir, $file_name);

        if($has_bak){
            $fileObj->backup_file($get_file);
        }
        $file_name = kernel::single('wap_theme_file')->get_file($dir, $file_name);
        $fileObj->save_image($file_name, $_FILES['upfile']);

        $this->end(true, app::get('wap')->_('保存成功'));
    }//End Function

    /*
     * 删除文件
     */
    public function delete_file()
    {
        $this->begin();
        $theme = $this->_request->get_get('theme');
        $open_path = $this->_request->get_get('open_path');
        $file_name = $this->_request->get_get('file_name');

        if(!$this->check($theme,$msg))   $this->_error($msg);

        $dir = $this->get_theme_dir($theme, $open_path);
        $fileObj = kernel::single('wap_explorer_file',$theme);
        $file_name = trim($file_name);
        $file_name = kernel::single('wap_theme_file')->get_file($dir, $file_name);
        $fileObj->delete_file($file_name);

        $this->end(true, app::get('wap')->_('删除成功'));
    }//End Function

    /*
     * 恢复文件
     */
    public function recover_file()
    {
        $this->begin();
        $theme = $this->_request->get_get('theme');
        $open_path = $this->_request->get_get('open_path');
        $file_name = $this->_request->get_get('file_name');

        if(!$this->check($theme,$msg))   $this->_error($msg);

        $dir = $this->get_theme_dir($theme, $open_path);
        $fileObj = kernel::single('wap_explorer_file',$theme);

        $file_name = kernel::single('wap_theme_file')->get_file($dir, $file_name);
        $fileObj->recover_file($file_name);
        $this->end(true, app::get('wap')->_('恢复成功'));
    }//End Function

    protected function check($theme,&$msg='')
    {
        if(empty($theme)){
            $msg = app::get('wap')->_('缺少参数');
            return false;
        }
        /** 权限校验 **/
        if($theme && preg_match('/(\..\/){1,}/', $theme)){
            $msg = app::get('wap')->_('非法操作');
            return false;
        }
        return true;
    }//End Function

}//End Class
