SET FOREIGN_KEY_CHECKS=0;

DROP TABLE IF EXISTS `wst_areas`;
CREATE TABLE `wst_areas` (
  `areaId` int(11) NOT NULL AUTO_INCREMENT,
  `parentId` int(11) NOT NULL,
  `areaName` varchar(100) NOT NULL,
  `isShow` tinyint(4) NOT NULL DEFAULT '1',
  `areaSort` int(11) NOT NULL DEFAULT '0',
  `areaKey` char(10) NOT NULL,
  `areaType` tinyint(4) NOT NULL DEFAULT '1',
  `dataFlag` tinyint(4) NOT NULL DEFAULT '1',
  `createTime` datetime DEFAULT NULL,
  PRIMARY KEY (`areaId`),
  KEY `isShow` (`isShow`,`dataFlag`),
  KEY `areaType` (`areaType`),
  KEY `parentId` (`parentId`)
) ENGINE=InnoDB AUTO_INCREMENT=820305 DEFAULT CHARSET=utf8;

INSERT INTO `wst_areas` VALUES ('110000', '0', '北京市', '1', '0', 'B', '0', '1', null),
('110100', '110000', '北京市', '1', '0', 'B', '1', '1', null),
('110101', '110100', '东城区', '1', '0', '', '2', '1', null),
('110102', '110100', '西城区', '1', '0', '', '2', '1', null),
('110105', '110100', '朝阳区', '1', '0', '', '2', '1', null),
('110106', '110100', '丰台区', '1', '0', '', '2', '1', null),
('110107', '110100', '石景山区', '1', '0', '', '2', '1', null),
('110108', '110100', '海淀区', '1', '0', '', '2', '1', null),
('110109', '110100', '门头沟区', '1', '0', '', '2', '1', null),
('110111', '110100', '房山区', '1', '0', '', '2', '1', null),
('110112', '110100', '通州区', '1', '0', '', '2', '1', null),
('110113', '110100', '顺义区', '1', '0', '', '2', '1', null),
('110114', '110100', '昌平区', '1', '0', '', '2', '1', null),
('110115', '110100', '大兴区', '1', '0', '', '2', '1', null),
('110116', '110100', '怀柔区', '1', '0', '', '2', '1', null),
('110117', '110100', '平谷区', '1', '0', '', '2', '1', null),
('110228', '110200', '密云县', '1', '0', '', '2', '-1', null),
('110229', '110200', '延庆县', '1', '0', '', '2', '-1', null),
('120000', '0', '天津市', '0', '0', '', '0', '1', null),
('120100', '120000', '天津市', '0', '0', '', '1', '1', null),
('120101', '120100', '和平区', '0', '0', '', '2', '1', null),
('120102', '120100', '河东区', '0', '0', '', '2', '1', null),
('120103', '120100', '河西区', '0', '0', '', '2', '1', null),
('120104', '120100', '南开区', '0', '0', '', '2', '1', null),
('120105', '120100', '河北区', '0', '0', '', '2', '1', null),
('120106', '120100', '红桥区', '0', '0', '', '2', '1', null),
('120110', '120100', '东丽区', '0', '0', '', '2', '1', null),
('120111', '120100', '西青区', '0', '0', '', '2', '1', null),
('120112', '120100', '津南区', '0', '0', '', '2', '1', null),
('120113', '120100', '北辰区', '0', '0', '', '2', '1', null),
('120114', '120100', '武清区', '0', '0', '', '2', '1', null),
('120115', '120100', '宝坻区', '0', '0', '', '2', '1', null),
('120116', '120100', '滨海新区', '0', '0', '', '2', '1', null),
('120221', '120200', '宁河县', '0', '0', '', '2', '1', null),
('120223', '120200', '静海县', '0', '0', '', '2', '1', null),
('120225', '120200', '蓟县', '0', '0', '', '2', '1', null),
('130000', '0', '河北省', '0', '0', '', '0', '1', null),
('130100', '130000', '石家庄市', '0', '0', 'S', '1', '1', null),
('130102', '130100', '长安区', '0', '0', '', '2', '1', null),
('130104', '130100', '桥西区', '0', '0', '', '2', '1', null),
('130105', '130100', '新华区', '0', '0', '', '2', '1', null),
('130107', '130100', '井陉矿区', '0', '0', '', '2', '1', null),
('130108', '130100', '裕华区', '0', '0', '', '2', '1', null),
('130109', '130100', '藁城区', '0', '0', '', '2', '1', null),
('130110', '130100', '鹿泉区', '0', '0', '', '2', '1', null),
('130111', '130100', '栾城区', '0', '0', '', '2', '1', null),
('130121', '130100', '井陉县', '0', '0', '', '2', '1', null),
('130123', '130100', '正定县', '0', '0', '', '2', '1', null),
('130125', '130100', '行唐县', '0', '0', '', '2', '1', null),
('130126', '130100', '灵寿县', '0', '0', '', '2', '1', null),
('130127', '130100', '高邑县', '0', '0', '', '2', '1', null),
('130128', '130100', '深泽县', '0', '0', '', '2', '1', null),
('130129', '130100', '赞皇县', '0', '0', '', '2', '1', null),
('130130', '130100', '无极县', '0', '0', '', '2', '1', null),
('130131', '130100', '平山县', '0', '0', '', '2', '1', null),
('130132', '130100', '元氏县', '0', '0', '', '2', '1', null),
('130133', '130100', '赵县', '0', '0', '', '2', '1', null),
('130181', '130100', '辛集市', '0', '0', '', '2', '1', null),
('130183', '130100', '晋州市', '0', '0', '', '2', '1', null),
('130184', '130100', '新乐市', '0', '0', '', '2', '1', null),
('130200', '130000', '唐山市', '0', '0', 'T', '1', '1', null),
('130202', '130200', '路南区', '0', '0', '', '2', '1', null),
('130203', '130200', '路北区', '0', '0', '', '2', '1', null),
('130204', '130200', '古冶区', '0', '0', '', '2', '1', null),
('130205', '130200', '开平区', '0', '0', '', '2', '1', null),
('130207', '130200', '丰南区', '0', '0', '', '2', '1', null),
('130208', '130200', '丰润区', '0', '0', '', '2', '1', null),
('130209', '130200', '曹妃甸区', '0', '0', '', '2', '1', null),
('130223', '130200', '滦县', '0', '0', '', '2', '1', null),
('130224', '130200', '滦南县', '0', '0', '', '2', '1', null),
('130225', '130200', '乐亭县', '0', '0', '', '2', '1', null),
('130227', '130200', '迁西县', '0', '0', '', '2', '1', null),
('130229', '130200', '玉田县', '0', '0', '', '2', '1', null),
('130281', '130200', '遵化市', '0', '0', '', '2', '1', null),
('130283', '130200', '迁安市', '0', '0', '', '2', '1', null),
('130300', '130000', '秦皇岛市', '0', '0', 'Q', '1', '1', null),
('130302', '130300', '海港区', '0', '0', '', '2', '1', null),
('130303', '130300', '山海关区', '0', '0', '', '2', '1', null),
('130304', '130300', '北戴河区', '0', '0', '', '2', '1', null),
('130321', '130300', '青龙满族自治县', '0', '0', '', '2', '1', null),
('130322', '130300', '昌黎县', '0', '0', '', '2', '1', null),
('130323', '130300', '抚宁县', '0', '0', '', '2', '1', null),
('130324', '130300', '卢龙县', '0', '0', '', '2', '1', null),
('130400', '130000', '邯郸市', '0', '0', 'H', '1', '1', null),
('130402', '130400', '邯山区', '0', '0', '', '2', '1', null),
('130403', '130400', '丛台区', '0', '0', '', '2', '1', null),
('130404', '130400', '复兴区', '0', '0', '', '2', '1', null),
('130406', '130400', '峰峰矿区', '0', '0', '', '2', '1', null),
('130421', '130400', '邯郸县', '0', '0', '', '2', '1', null),
('130423', '130400', '临漳县', '0', '0', '', '2', '1', null),
('130424', '130400', '成安县', '0', '0', '', '2', '1', null),
('130425', '130400', '大名县', '0', '0', '', '2', '1', null),
('130426', '130400', '涉县', '0', '0', '', '2', '1', null),
('130427', '130400', '磁县', '0', '0', '', '2', '1', null),
('130428', '130400', '肥乡县', '0', '0', '', '2', '1', null),
('130429', '130400', '永年县', '0', '0', '', '2', '1', null),
('130430', '130400', '邱县', '0', '0', '', '2', '1', null),
('130431', '130400', '鸡泽县', '0', '0', '', '2', '1', null),
('130432', '130400', '广平县', '0', '0', '', '2', '1', null),
('130433', '130400', '馆陶县', '0', '0', '', '2', '1', null),
('130434', '130400', '魏县', '0', '0', '', '2', '1', null),
('130435', '130400', '曲周县', '0', '0', '', '2', '1', null),
('130481', '130400', '武安市', '0', '0', '', '2', '1', null),
('130500', '130000', '邢台市', '0', '0', 'X', '1', '1', null),
('130502', '130500', '桥东区', '0', '0', '', '2', '1', null),
('130503', '130500', '桥西区', '0', '0', '', '2', '1', null),
('130521', '130500', '邢台县', '0', '0', '', '2', '1', null),
('130522', '130500', '临城县', '0', '0', '', '2', '1', null),
('130523', '130500', '内丘县', '0', '0', '', '2', '1', null),
('130524', '130500', '柏乡县', '0', '0', '', '2', '1', null),
('130525', '130500', '隆尧县', '0', '0', '', '2', '1', null),
('130526', '130500', '任县', '0', '0', '', '2', '1', null),
('130527', '130500', '南和县', '0', '0', '', '2', '1', null),
('130528', '130500', '宁晋县', '0', '0', '', '2', '1', null),
('130529', '130500', '巨鹿县', '0', '0', '', '2', '1', null),
('130530', '130500', '新河县', '0', '0', '', '2', '1', null),
('130531', '130500', '广宗县', '0', '0', '', '2', '1', null),
('130532', '130500', '平乡县', '0', '0', '', '2', '1', null),
('130533', '130500', '威县', '0', '0', '', '2', '1', null),
('130534', '130500', '清河县', '0', '0', '', '2', '1', null),
('130535', '130500', '临西县', '0', '0', '', '2', '1', null),
('130581', '130500', '南宫市', '0', '0', '', '2', '1', null),
('130582', '130500', '沙河市', '0', '0', '', '2', '1', null),
('130600', '130000', '保定市', '0', '0', 'B', '1', '1', null),
('130602', '130600', '新市区', '0', '0', '', '2', '1', null),
('130603', '130600', '北市区', '0', '0', '', '2', '1', null),
('130604', '130600', '南市区', '0', '0', '', '2', '1', null),
('130621', '130600', '满城县', '0', '0', '', '2', '1', null),
('130622', '130600', '清苑县', '0', '0', '', '2', '1', null),
('130623', '130600', '涞水县', '0', '0', '', '2', '1', null),
('130624', '130600', '阜平县', '0', '0', '', '2', '1', null),
('130625', '130600', '徐水县', '0', '0', '', '2', '1', null),
('130626', '130600', '定兴县', '0', '0', '', '2', '1', null),
('130627', '130600', '唐县', '0', '0', '', '2', '1', null),
('130628', '130600', '高阳县', '0', '0', '', '2', '1', null),
('130629', '130600', '容城县', '0', '0', '', '2', '1', null),
('130630', '130600', '涞源县', '0', '0', '', '2', '1', null),
('130631', '130600', '望都县', '0', '0', '', '2', '1', null),
('130632', '130600', '安新县', '0', '0', '', '2', '1', null),
('130633', '130600', '易县', '0', '0', '', '2', '1', null),
('130634', '130600', '曲阳县', '0', '0', '', '2', '1', null),
('130635', '130600', '蠡县', '0', '0', '', '2', '1', null),
('130636', '130600', '顺平县', '0', '0', '', '2', '1', null),
('130637', '130600', '博野县', '0', '0', '', '2', '1', null),
('130638', '130600', '雄县', '0', '0', '', '2', '1', null),
('130681', '130600', '涿州市', '0', '0', '', '2', '1', null),
('130682', '130600', '定州市', '0', '0', '', '2', '1', null),
('130683', '130600', '安国市', '0', '0', '', '2', '1', null),
('130684', '130600', '高碑店市', '0', '0', '', '2', '1', null),
('130700', '130000', '张家口市', '0', '0', 'Z', '1', '1', null),
('130702', '130700', '桥东区', '0', '0', '', '2', '1', null),
('130703', '130700', '桥西区', '0', '0', '', '2', '1', null),
('130705', '130700', '宣化区', '0', '0', '', '2', '1', null),
('130706', '130700', '下花园区', '0', '0', '', '2', '1', null),
('130721', '130700', '宣化县', '0', '0', '', '2', '1', null),
('130722', '130700', '张北县', '0', '0', '', '2', '1', null),
('130723', '130700', '康保县', '0', '0', '', '2', '1', null),
('130724', '130700', '沽源县', '0', '0', '', '2', '1', null),
('130725', '130700', '尚义县', '0', '0', '', '2', '1', null),
('130726', '130700', '蔚县', '0', '0', '', '2', '1', null),
('130727', '130700', '阳原县', '0', '0', '', '2', '1', null),
('130728', '130700', '怀安县', '0', '0', '', '2', '1', null),
('130729', '130700', '万全县', '0', '0', '', '2', '1', null),
('130730', '130700', '怀来县', '0', '0', '', '2', '1', null),
('130731', '130700', '涿鹿县', '0', '0', '', '2', '1', null),
('130732', '130700', '赤城县', '0', '0', '', '2', '1', null),
('130733', '130700', '崇礼县', '0', '0', '', '2', '1', null),
('130800', '130000', '承德市', '0', '0', 'C', '1', '1', null),
('130802', '130800', '双桥区', '0', '0', '', '2', '1', null),
('130803', '130800', '双滦区', '0', '0', '', '2', '1', null),
('130804', '130800', '鹰手营子矿区', '0', '0', '', '2', '1', null),
('130821', '130800', '承德县', '0', '0', '', '2', '1', null),
('130822', '130800', '兴隆县', '0', '0', '', '2', '1', null),
('130823', '130800', '平泉县', '0', '0', '', '2', '1', null),
('130824', '130800', '滦平县', '0', '0', '', '2', '1', null),
('130825', '130800', '隆化县', '0', '0', '', '2', '1', null),
('130826', '130800', '丰宁满族自治县', '0', '0', '', '2', '1', null),
('130827', '130800', '宽城满族自治县', '0', '0', '', '2', '1', null),
('130828', '130800', '围场满族蒙古族自治县', '0', '0', '', '2', '1', null),
('130900', '130000', '沧州市', '0', '0', 'C', '1', '1', null),
('130902', '130900', '新华区', '0', '0', '', '2', '1', null),
('130903', '130900', '运河区', '0', '0', '', '2', '1', null),
('130921', '130900', '沧县', '0', '0', '', '2', '1', null),
('130922', '130900', '青县', '0', '0', '', '2', '1', null),
('130923', '130900', '东光县', '0', '0', '', '2', '1', null),
('130924', '130900', '海兴县', '0', '0', '', '2', '1', null),
('130925', '130900', '盐山县', '0', '0', '', '2', '1', null),
('130926', '130900', '肃宁县', '0', '0', '', '2', '1', null),
('130927', '130900', '南皮县', '0', '0', '', '2', '1', null),
('130928', '130900', '吴桥县', '0', '0', '', '2', '1', null),
('130929', '130900', '献县', '0', '0', '', '2', '1', null),
('130930', '130900', '孟村回族自治县', '0', '0', '', '2', '1', null),
('130981', '130900', '泊头市', '0', '0', '', '2', '1', null),
('130982', '130900', '任丘市', '0', '0', '', '2', '1', null),
('130983', '130900', '黄骅市', '0', '0', '', '2', '1', null),
('130984', '130900', '河间市', '0', '0', '', '2', '1', null),
('131000', '130000', '廊坊市', '0', '0', 'L', '1', '1', null),
('131002', '131000', '安次区', '0', '0', '', '2', '1', null),
('131003', '131000', '广阳区', '0', '0', '', '2', '1', null),
('131022', '131000', '固安县', '0', '0', '', '2', '1', null),
('131023', '131000', '永清县', '0', '0', '', '2', '1', null),
('131024', '131000', '香河县', '0', '0', '', '2', '1', null),
('131025', '131000', '大城县', '0', '0', '', '2', '1', null),
('131026', '131000', '文安县', '0', '0', '', '2', '1', null),
('131028', '131000', '大厂回族自治县', '0', '0', '', '2', '1', null),
('131081', '131000', '霸州市', '0', '0', '', '2', '1', null),
('131082', '131000', '三河市', '0', '0', '', '2', '1', null),
('131100', '130000', '衡水市', '0', '0', 'H', '1', '1', null),
('131102', '131100', '桃城区', '0', '0', '', '2', '1', null),
('131121', '131100', '枣强县', '0', '0', '', '2', '1', null),
('131122', '131100', '武邑县', '0', '0', '', '2', '1', null),
('131123', '131100', '武强县', '0', '0', '', '2', '1', null),
('131124', '131100', '饶阳县', '0', '0', '', '2', '1', null),
('131125', '131100', '安平县', '0', '0', '', '2', '1', null),
('131126', '131100', '故城县', '0', '0', '', '2', '1', null),
('131127', '131100', '景县', '0', '0', '', '2', '1', null),
('131128', '131100', '阜城县', '0', '0', '', '2', '1', null),
('131181', '131100', '冀州市', '0', '0', '', '2', '1', null),
('131182', '131100', '深州市', '0', '0', '', '2', '1', null),
('140000', '0', '山西省', '0', '0', '', '0', '1', null),
('140100', '140000', '太原市', '0', '0', 'T', '1', '1', null),
('140105', '140100', '小店区', '0', '0', '', '2', '1', null),
('140106', '140100', '迎泽区', '0', '0', '', '2', '1', null),
('140107', '140100', '杏花岭区', '0', '0', '', '2', '1', null),
('140108', '140100', '尖草坪区', '0', '0', '', '2', '1', null),
('140109', '140100', '万柏林区', '0', '0', '', '2', '1', null),
('140110', '140100', '晋源区', '0', '0', '', '2', '1', null),
('140121', '140100', '清徐县', '0', '0', '', '2', '1', null),
('140122', '140100', '阳曲县', '0', '0', '', '2', '1', null),
('140123', '140100', '娄烦县', '0', '0', '', '2', '1', null),
('140181', '140100', '古交市', '0', '0', '', '2', '1', null),
('140200', '140000', '大同市', '0', '0', 'D', '1', '1', null),
('140202', '140200', '城区', '0', '0', '', '2', '1', null),
('140203', '140200', '矿区', '0', '0', '', '2', '1', null),
('140211', '140200', '南郊区', '0', '0', '', '2', '1', null),
('140212', '140200', '新荣区', '0', '0', '', '2', '1', null),
('140221', '140200', '阳高县', '0', '0', '', '2', '1', null),
('140222', '140200', '天镇县', '0', '0', '', '2', '1', null),
('140223', '140200', '广灵县', '0', '0', '', '2', '1', null),
('140224', '140200', '灵丘县', '0', '0', '', '2', '1', null),
('140225', '140200', '浑源县', '0', '0', '', '2', '1', null),
('140226', '140200', '左云县', '0', '0', '', '2', '1', null),
('140227', '140200', '大同县', '0', '0', '', '2', '1', null),
('140300', '140000', '阳泉市', '0', '0', 'Y', '1', '1', null),
('140302', '140300', '城区', '0', '0', '', '2', '1', null),
('140303', '140300', '矿区', '0', '0', '', '2', '1', null),
('140311', '140300', '郊区', '0', '0', '', '2', '1', null),
('140321', '140300', '平定县', '0', '0', '', '2', '1', null),
('140322', '140300', '盂县', '0', '0', '', '2', '1', null),
('140400', '140000', '长治市', '0', '0', 'C', '1', '1', null),
('140402', '140400', '城区', '0', '0', '', '2', '1', null),
('140411', '140400', '郊区', '0', '0', '', '2', '1', null),
('140421', '140400', '长治县', '0', '0', '', '2', '1', null),
('140423', '140400', '襄垣县', '0', '0', '', '2', '1', null),
('140424', '140400', '屯留县', '0', '0', '', '2', '1', null),
('140425', '140400', '平顺县', '0', '0', '', '2', '1', null),
('140426', '140400', '黎城县', '0', '0', '', '2', '1', null),
('140427', '140400', '壶关县', '0', '0', '', '2', '1', null),
('140428', '140400', '长子县', '0', '0', '', '2', '1', null),
('140429', '140400', '武乡县', '0', '0', '', '2', '1', null),
('140430', '140400', '沁县', '0', '0', '', '2', '1', null),
('140431', '140400', '沁源县', '0', '0', '', '2', '1', null),
('140481', '140400', '潞城市', '0', '0', '', '2', '1', null),
('140500', '140000', '晋城市', '0', '0', 'J', '1', '1', null),
('140502', '140500', '城区', '0', '0', '', '2', '1', null),
('140521', '140500', '沁水县', '0', '0', '', '2', '1', null),
('140522', '140500', '阳城县', '0', '0', '', '2', '1', null),
('140524', '140500', '陵川县', '0', '0', '', '2', '1', null),
('140525', '140500', '泽州县', '0', '0', '', '2', '1', null),
('140581', '140500', '高平市', '0', '0', '', '2', '1', null),
('140600', '140000', '朔州市', '0', '0', 'S', '1', '1', null),
('140602', '140600', '朔城区', '0', '0', '', '2', '1', null),
('140603', '140600', '平鲁区', '0', '0', '', '2', '1', null),
('140621', '140600', '山阴县', '0', '0', '', '2', '1', null),
('140622', '140600', '应县', '0', '0', '', '2', '1', null),
('140623', '140600', '右玉县', '0', '0', '', '2', '1', null),
('140624', '140600', '怀仁县', '0', '0', '', '2', '1', null),
('140700', '140000', '晋中市', '0', '0', 'J', '1', '1', null),
('140702', '140700', '榆次区', '0', '0', '', '2', '1', null),
('140721', '140700', '榆社县', '0', '0', '', '2', '1', null),
('140722', '140700', '左权县', '0', '0', '', '2', '1', null),
('140723', '140700', '和顺县', '0', '0', '', '2', '1', null),
('140724', '140700', '昔阳县', '0', '0', '', '2', '1', null),
('140725', '140700', '寿阳县', '0', '0', '', '2', '1', null),
('140726', '140700', '太谷县', '0', '0', '', '2', '1', null),
('140727', '140700', '祁县', '0', '0', '', '2', '1', null),
('140728', '140700', '平遥县', '0', '0', '', '2', '1', null),
('140729', '140700', '灵石县', '0', '0', '', '2', '1', null),
('140781', '140700', '介休市', '0', '0', '', '2', '1', null),
('140800', '140000', '运城市', '0', '0', 'Y', '1', '1', null),
('140802', '140800', '盐湖区', '0', '0', '', '2', '1', null),
('140821', '140800', '临猗县', '0', '0', '', '2', '1', null),
('140822', '140800', '万荣县', '0', '0', '', '2', '1', null),
('140823', '140800', '闻喜县', '0', '0', '', '2', '1', null);
INSERT INTO `wst_areas` VALUES ('140824', '140800', '稷山县', '0', '0', '', '2', '1', null),
('140825', '140800', '新绛县', '0', '0', '', '2', '1', null),
('140826', '140800', '绛县', '0', '0', '', '2', '1', null),
('140827', '140800', '垣曲县', '0', '0', '', '2', '1', null),
('140828', '140800', '夏县', '0', '0', '', '2', '1', null),
('140829', '140800', '平陆县', '0', '0', '', '2', '1', null),
('140830', '140800', '芮城县', '0', '0', '', '2', '1', null),
('140881', '140800', '永济市', '0', '0', '', '2', '1', null),
('140882', '140800', '河津市', '0', '0', '', '2', '1', null),
('140900', '140000', '忻州市', '0', '0', 'X', '1', '1', null),
('140902', '140900', '忻府区', '0', '0', '', '2', '1', null),
('140921', '140900', '定襄县', '0', '0', '', '2', '1', null),
('140922', '140900', '五台县', '0', '0', '', '2', '1', null),
('140923', '140900', '代县', '0', '0', '', '2', '1', null),
('140924', '140900', '繁峙县', '0', '0', '', '2', '1', null),
('140925', '140900', '宁武县', '0', '0', '', '2', '1', null),
('140926', '140900', '静乐县', '0', '0', '', '2', '1', null),
('140927', '140900', '神池县', '0', '0', '', '2', '1', null),
('140928', '140900', '五寨县', '0', '0', '', '2', '1', null),
('140929', '140900', '岢岚县', '0', '0', '', '2', '1', null),
('140930', '140900', '河曲县', '0', '0', '', '2', '1', null),
('140931', '140900', '保德县', '0', '0', '', '2', '1', null),
('140932', '140900', '偏关县', '0', '0', '', '2', '1', null),
('140981', '140900', '原平市', '0', '0', '', '2', '1', null),
('141000', '140000', '临汾市', '0', '0', 'L', '1', '1', null),
('141002', '141000', '尧都区', '0', '0', '', '2', '1', null),
('141021', '141000', '曲沃县', '0', '0', '', '2', '1', null),
('141022', '141000', '翼城县', '0', '0', '', '2', '1', null),
('141023', '141000', '襄汾县', '0', '0', '', '2', '1', null),
('141024', '141000', '洪洞县', '0', '0', '', '2', '1', null),
('141025', '141000', '古县', '0', '0', '', '2', '1', null),
('141026', '141000', '安泽县', '0', '0', '', '2', '1', null),
('141027', '141000', '浮山县', '0', '0', '', '2', '1', null),
('141028', '141000', '吉县', '0', '0', '', '2', '1', null),
('141029', '141000', '乡宁县', '0', '0', '', '2', '1', null),
('141030', '141000', '大宁县', '0', '0', '', '2', '1', null),
('141031', '141000', '隰县', '0', '0', '', '2', '1', null),
('141032', '141000', '永和县', '0', '0', '', '2', '1', null),
('141033', '141000', '蒲县', '0', '0', '', '2', '1', null),
('141034', '141000', '汾西县', '0', '0', '', '2', '1', null),
('141081', '141000', '侯马市', '0', '0', '', '2', '1', null),
('141082', '141000', '霍州市', '0', '0', '', '2', '1', null),
('141100', '140000', '吕梁市', '0', '0', 'L', '1', '1', null),
('141102', '141100', '离石区', '0', '0', '', '2', '1', null),
('141121', '141100', '文水县', '0', '0', '', '2', '1', null),
('141122', '141100', '交城县', '0', '0', '', '2', '1', null),
('141123', '141100', '兴县', '0', '0', '', '2', '1', null),
('141124', '141100', '临县', '0', '0', '', '2', '1', null),
('141125', '141100', '柳林县', '0', '0', '', '2', '1', null),
('141126', '141100', '石楼县', '0', '0', '', '2', '1', null),
('141127', '141100', '岚县', '0', '0', '', '2', '1', null),
('141128', '141100', '方山县', '0', '0', '', '2', '1', null),
('141129', '141100', '中阳县', '0', '0', '', '2', '1', null),
('141130', '141100', '交口县', '0', '0', '', '2', '1', null),
('141181', '141100', '孝义市', '0', '0', '', '2', '1', null),
('141182', '141100', '汾阳市', '0', '0', '', '2', '1', null),
('150000', '0', '内蒙古自治区', '0', '0', '', '0', '1', null),
('150100', '150000', '呼和浩特市', '0', '0', 'H', '1', '1', null),
('150102', '150100', '新城区', '0', '0', '', '2', '1', null),
('150103', '150100', '回民区', '0', '0', '', '2', '1', null),
('150104', '150100', '玉泉区', '0', '0', '', '2', '1', null),
('150105', '150100', '赛罕区', '0', '0', '', '2', '1', null),
('150121', '150100', '土默特左旗', '0', '0', '', '2', '1', null),
('150122', '150100', '托克托县', '0', '0', '', '2', '1', null),
('150123', '150100', '和林格尔县', '0', '0', '', '2', '1', null),
('150124', '150100', '清水河县', '0', '0', '', '2', '1', null),
('150125', '150100', '武川县', '0', '0', '', '2', '1', null),
('150200', '150000', '包头市', '0', '0', 'B', '1', '1', null),
('150202', '150200', '东河区', '0', '0', '', '2', '1', null),
('150203', '150200', '昆都仑区', '0', '0', '', '2', '1', null),
('150204', '150200', '青山区', '0', '0', '', '2', '1', null),
('150205', '150200', '石拐区', '0', '0', '', '2', '1', null),
('150206', '150200', '白云鄂博矿区', '0', '0', '', '2', '1', null),
('150207', '150200', '九原区', '0', '0', '', '2', '1', null),
('150221', '150200', '土默特右旗', '0', '0', '', '2', '1', null),
('150222', '150200', '固阳县', '0', '0', '', '2', '1', null),
('150223', '150200', '达尔罕茂明安联合旗', '0', '0', '', '2', '1', null),
('150300', '150000', '乌海市', '0', '0', 'W', '1', '1', null),
('150302', '150300', '海勃湾区', '0', '0', '', '2', '1', null),
('150303', '150300', '海南区', '0', '0', '', '2', '1', null),
('150304', '150300', '乌达区', '0', '0', '', '2', '1', null),
('150400', '150000', '赤峰市', '0', '0', 'C', '1', '1', null),
('150402', '150400', '红山区', '0', '0', '', '2', '1', null),
('150403', '150400', '元宝山区', '0', '0', '', '2', '1', null),
('150404', '150400', '松山区', '0', '0', '', '2', '1', null),
('150421', '150400', '阿鲁科尔沁旗', '0', '0', '', '2', '1', null),
('150422', '150400', '巴林左旗', '0', '0', '', '2', '1', null),
('150423', '150400', '巴林右旗', '0', '0', '', '2', '1', null),
('150424', '150400', '林西县', '0', '0', '', '2', '1', null),
('150425', '150400', '克什克腾旗', '0', '0', '', '2', '1', null),
('150426', '150400', '翁牛特旗', '0', '0', '', '2', '1', null),
('150428', '150400', '喀喇沁旗', '0', '0', '', '2', '1', null),
('150429', '150400', '宁城县', '0', '0', '', '2', '1', null),
('150430', '150400', '敖汉旗', '0', '0', '', '2', '1', null),
('150500', '150000', '通辽市', '0', '0', 'T', '1', '1', null),
('150502', '150500', '科尔沁区', '0', '0', '', '2', '1', null),
('150521', '150500', '科尔沁左翼中旗', '0', '0', '', '2', '1', null),
('150522', '150500', '科尔沁左翼后旗', '0', '0', '', '2', '1', null),
('150523', '150500', '开鲁县', '0', '0', '', '2', '1', null),
('150524', '150500', '库伦旗', '0', '0', '', '2', '1', null),
('150525', '150500', '奈曼旗', '0', '0', '', '2', '1', null),
('150526', '150500', '扎鲁特旗', '0', '0', '', '2', '1', null),
('150581', '150500', '霍林郭勒市', '0', '0', '', '2', '1', null),
('150600', '150000', '鄂尔多斯市', '0', '0', 'E', '1', '1', null),
('150602', '150600', '东胜区', '0', '0', '', '2', '1', null),
('150621', '150600', '达拉特旗', '0', '0', '', '2', '1', null),
('150622', '150600', '准格尔旗', '0', '0', '', '2', '1', null),
('150623', '150600', '鄂托克前旗', '0', '0', '', '2', '1', null),
('150624', '150600', '鄂托克旗', '0', '0', '', '2', '1', null),
('150625', '150600', '杭锦旗', '0', '0', '', '2', '1', null),
('150626', '150600', '乌审旗', '0', '0', '', '2', '1', null),
('150627', '150600', '伊金霍洛旗', '0', '0', '', '2', '1', null),
('150700', '150000', '呼伦贝尔市', '0', '0', 'H', '1', '1', null),
('150702', '150700', '海拉尔区', '0', '0', '', '2', '1', null),
('150703', '150700', '扎赉诺尔区', '0', '0', '', '2', '1', null),
('150721', '150700', '阿荣旗', '0', '0', '', '2', '1', null),
('150722', '150700', '莫力达瓦达斡尔族自治旗', '0', '0', '', '2', '1', null),
('150723', '150700', '鄂伦春自治旗', '0', '0', '', '2', '1', null),
('150724', '150700', '鄂温克族自治旗', '0', '0', '', '2', '1', null),
('150725', '150700', '陈巴尔虎旗', '0', '0', '', '2', '1', null),
('150726', '150700', '新巴尔虎左旗', '0', '0', '', '2', '1', null),
('150727', '150700', '新巴尔虎右旗', '0', '0', '', '2', '1', null),
('150781', '150700', '满洲里市', '0', '0', '', '2', '1', null),
('150782', '150700', '牙克石市', '0', '0', '', '2', '1', null),
('150783', '150700', '扎兰屯市', '0', '0', '', '2', '1', null),
('150784', '150700', '额尔古纳市', '0', '0', '', '2', '1', null),
('150785', '150700', '根河市', '0', '0', '', '2', '1', null),
('150800', '150000', '巴彦淖尔市', '0', '0', 'B', '1', '1', null),
('150802', '150800', '临河区', '0', '0', '', '2', '1', null),
('150821', '150800', '五原县', '0', '0', '', '2', '1', null),
('150822', '150800', '磴口县', '0', '0', '', '2', '1', null),
('150823', '150800', '乌拉特前旗', '0', '0', '', '2', '1', null),
('150824', '150800', '乌拉特中旗', '0', '0', '', '2', '1', null),
('150825', '150800', '乌拉特后旗', '0', '0', '', '2', '1', null),
('150826', '150800', '杭锦后旗', '0', '0', '', '2', '1', null),
('150900', '150000', '乌兰察布市', '0', '0', 'W', '1', '1', null),
('150902', '150900', '集宁区', '0', '0', '', '2', '1', null),
('150921', '150900', '卓资县', '0', '0', '', '2', '1', null),
('150922', '150900', '化德县', '0', '0', '', '2', '1', null),
('150923', '150900', '商都县', '0', '0', '', '2', '1', null),
('150924', '150900', '兴和县', '0', '0', '', '2', '1', null),
('150925', '150900', '凉城县', '0', '0', '', '2', '1', null),
('150926', '150900', '察哈尔右翼前旗', '0', '0', '', '2', '1', null),
('150927', '150900', '察哈尔右翼中旗', '0', '0', '', '2', '1', null),
('150928', '150900', '察哈尔右翼后旗', '0', '0', '', '2', '1', null),
('150929', '150900', '四子王旗', '0', '0', '', '2', '1', null),
('150981', '150900', '丰镇市', '0', '0', '', '2', '1', null),
('152200', '150000', '兴安盟', '0', '0', 'X', '1', '1', null),
('152201', '152200', '乌兰浩特市', '0', '0', '', '2', '1', null),
('152202', '152200', '阿尔山市', '0', '0', '', '2', '1', null),
('152221', '152200', '科尔沁右翼前旗', '0', '0', '', '2', '1', null),
('152222', '152200', '科尔沁右翼中旗', '0', '0', '', '2', '1', null),
('152223', '152200', '扎赉特旗', '0', '0', '', '2', '1', null),
('152224', '152200', '突泉县', '0', '0', '', '2', '1', null),
('152500', '150000', '锡林郭勒盟', '0', '0', 'X', '1', '1', null),
('152501', '152500', '二连浩特市', '0', '0', '', '2', '1', null),
('152502', '152500', '锡林浩特市', '0', '0', '', '2', '1', null),
('152522', '152500', '阿巴嘎旗', '0', '0', '', '2', '1', null),
('152523', '152500', '苏尼特左旗', '0', '0', '', '2', '1', null),
('152524', '152500', '苏尼特右旗', '0', '0', '', '2', '1', null),
('152525', '152500', '东乌珠穆沁旗', '0', '0', '', '2', '1', null),
('152526', '152500', '西乌珠穆沁旗', '0', '0', '', '2', '1', null),
('152527', '152500', '太仆寺旗', '0', '0', '', '2', '1', null),
('152528', '152500', '镶黄旗', '0', '0', '', '2', '1', null),
('152529', '152500', '正镶白旗', '0', '0', '', '2', '1', null),
('152530', '152500', '正蓝旗', '0', '0', '', '2', '1', null),
('152531', '152500', '多伦县', '0', '0', '', '2', '1', null),
('152900', '150000', '阿拉善盟', '0', '0', 'A', '1', '1', null),
('152921', '152900', '阿拉善左旗', '0', '0', '', '2', '1', null),
('152922', '152900', '阿拉善右旗', '0', '0', '', '2', '1', null),
('152923', '152900', '额济纳旗', '0', '0', '', '2', '1', null),
('210000', '0', '辽宁省', '0', '0', '', '0', '1', null),
('210100', '210000', '沈阳市', '0', '0', 'S', '1', '1', null),
('210102', '210100', '和平区', '0', '0', '', '2', '1', null),
('210103', '210100', '沈河区', '0', '0', '', '2', '1', null),
('210104', '210100', '大东区', '0', '0', '', '2', '1', null),
('210105', '210100', '皇姑区', '0', '0', '', '2', '1', null),
('210106', '210100', '铁西区', '0', '0', '', '2', '1', null),
('210111', '210100', '苏家屯区', '0', '0', '', '2', '1', null),
('210112', '210100', '浑南区', '0', '0', '', '2', '1', null),
('210113', '210100', '沈北新区', '0', '0', '', '2', '1', null),
('210114', '210100', '于洪区', '0', '0', '', '2', '1', null),
('210122', '210100', '辽中县', '0', '0', '', '2', '1', null),
('210123', '210100', '康平县', '0', '0', '', '2', '1', null),
('210124', '210100', '法库县', '0', '0', '', '2', '1', null),
('210181', '210100', '新民市', '0', '0', '', '2', '1', null),
('210200', '210000', '大连市', '0', '0', 'D', '1', '1', null),
('210202', '210200', '中山区', '0', '0', '', '2', '1', null),
('210203', '210200', '西岗区', '0', '0', '', '2', '1', null),
('210204', '210200', '沙河口区', '0', '0', '', '2', '1', null),
('210211', '210200', '甘井子区', '0', '0', '', '2', '1', null),
('210212', '210200', '旅顺口区', '0', '0', '', '2', '1', null),
('210213', '210200', '金州区', '0', '0', '', '2', '1', null),
('210224', '210200', '长海县', '0', '0', '', '2', '1', null),
('210281', '210200', '瓦房店市', '0', '0', '', '2', '1', null),
('210282', '210200', '普兰店市', '0', '0', '', '2', '1', null),
('210283', '210200', '庄河市', '0', '0', '', '2', '1', null),
('210300', '210000', '鞍山市', '0', '0', 'A', '1', '1', null),
('210302', '210300', '铁东区', '0', '0', '', '2', '1', null),
('210303', '210300', '铁西区', '0', '0', '', '2', '1', null),
('210304', '210300', '立山区', '0', '0', '', '2', '1', null),
('210311', '210300', '千山区', '0', '0', '', '2', '1', null),
('210321', '210300', '台安县', '0', '0', '', '2', '1', null),
('210323', '210300', '岫岩满族自治县', '0', '0', '', '2', '1', null),
('210381', '210300', '海城市', '0', '0', '', '2', '1', null),
('210400', '210000', '抚顺市', '0', '0', 'F', '1', '1', null),
('210402', '210400', '新抚区', '0', '0', '', '2', '1', null),
('210403', '210400', '东洲区', '0', '0', '', '2', '1', null),
('210404', '210400', '望花区', '0', '0', '', '2', '1', null),
('210411', '210400', '顺城区', '0', '0', '', '2', '1', null),
('210421', '210400', '抚顺县', '0', '0', '', '2', '1', null),
('210422', '210400', '新宾满族自治县', '0', '0', '', '2', '1', null),
('210423', '210400', '清原满族自治县', '0', '0', '', '2', '1', null),
('210500', '210000', '本溪市', '0', '0', 'B', '1', '1', null),
('210502', '210500', '平山区', '0', '0', '', '2', '1', null),
('210503', '210500', '溪湖区', '0', '0', '', '2', '1', null),
('210504', '210500', '明山区', '0', '0', '', '2', '1', null),
('210505', '210500', '南芬区', '0', '0', '', '2', '1', null),
('210521', '210500', '本溪满族自治县', '0', '0', '', '2', '1', null),
('210522', '210500', '桓仁满族自治县', '0', '0', '', '2', '1', null),
('210600', '210000', '丹东市', '0', '0', 'D', '1', '1', null),
('210602', '210600', '元宝区', '0', '0', '', '2', '1', null),
('210603', '210600', '振兴区', '0', '0', '', '2', '1', null),
('210604', '210600', '振安区', '0', '0', '', '2', '1', null),
('210624', '210600', '宽甸满族自治县', '0', '0', '', '2', '1', null),
('210681', '210600', '东港市', '0', '0', '', '2', '1', null),
('210682', '210600', '凤城市', '0', '0', '', '2', '1', null),
('210700', '210000', '锦州市', '0', '0', 'M', '1', '1', null),
('210702', '210700', '古塔区', '0', '0', '', '2', '1', null),
('210703', '210700', '凌河区', '0', '0', '', '2', '1', null),
('210711', '210700', '太和区', '0', '0', '', '2', '1', null),
('210726', '210700', '黑山县', '0', '0', '', '2', '1', null),
('210727', '210700', '义县', '0', '0', '', '2', '1', null),
('210781', '210700', '凌海市', '0', '0', '', '2', '1', null),
('210782', '210700', '北镇市', '0', '0', '', '2', '1', null),
('210800', '210000', '营口市', '0', '0', 'Y', '1', '1', null),
('210802', '210800', '站前区', '0', '0', '', '2', '1', null),
('210803', '210800', '西市区', '0', '0', '', '2', '1', null),
('210804', '210800', '鲅鱼圈区', '0', '0', '', '2', '1', null),
('210811', '210800', '老边区', '0', '0', '', '2', '1', null),
('210881', '210800', '盖州市', '0', '0', '', '2', '1', null),
('210882', '210800', '大石桥市', '0', '0', '', '2', '1', null),
('210900', '210000', '阜新市', '0', '0', 'F', '1', '1', null),
('210902', '210900', '海州区', '0', '0', '', '2', '1', null),
('210903', '210900', '新邱区', '0', '0', '', '2', '1', null),
('210904', '210900', '太平区', '0', '0', '', '2', '1', null),
('210905', '210900', '清河门区', '0', '0', '', '2', '1', null),
('210911', '210900', '细河区', '0', '0', '', '2', '1', null),
('210921', '210900', '阜新蒙古族自治县', '0', '0', '', '2', '1', null),
('210922', '210900', '彰武县', '0', '0', '', '2', '1', null),
('211000', '210000', '辽阳市', '0', '0', 'L', '1', '1', null),
('211002', '211000', '白塔区', '0', '0', '', '2', '1', null),
('211003', '211000', '文圣区', '0', '0', '', '2', '1', null),
('211004', '211000', '宏伟区', '0', '0', '', '2', '1', null),
('211005', '211000', '弓长岭区', '0', '0', '', '2', '1', null),
('211011', '211000', '太子河区', '0', '0', '', '2', '1', null),
('211021', '211000', '辽阳县', '0', '0', '', '2', '1', null),
('211081', '211000', '灯塔市', '0', '0', '', '2', '1', null),
('211100', '210000', '盘锦市', '0', '0', 'P', '1', '1', null),
('211102', '211100', '双台子区', '0', '0', '', '2', '1', null),
('211103', '211100', '兴隆台区', '0', '0', '', '2', '1', null),
('211121', '211100', '大洼县', '0', '0', '', '2', '1', null),
('211122', '211100', '盘山县', '0', '0', '', '2', '1', null),
('211200', '210000', '铁岭市', '0', '0', 'T', '1', '1', null),
('211202', '211200', '银州区', '0', '0', '', '2', '1', null),
('211204', '211200', '清河区', '0', '0', '', '2', '1', null),
('211221', '211200', '铁岭县', '0', '0', '', '2', '1', null),
('211223', '211200', '西丰县', '0', '0', '', '2', '1', null),
('211224', '211200', '昌图县', '0', '0', '', '2', '1', null),
('211281', '211200', '调兵山市', '0', '0', '', '2', '1', null),
('211282', '211200', '开原市', '0', '0', '', '2', '1', null),
('211300', '210000', '朝阳市', '0', '0', 'C', '1', '1', null),
('211302', '211300', '双塔区', '0', '0', '', '2', '1', null),
('211303', '211300', '龙城区', '0', '0', '', '2', '1', null),
('211321', '211300', '朝阳县', '0', '0', '', '2', '1', null),
('211322', '211300', '建平县', '0', '0', '', '2', '1', null),
('211324', '211300', '喀喇沁左翼蒙古族自治县', '0', '0', '', '2', '1', null),
('211381', '211300', '北票市', '0', '0', '', '2', '1', null),
('211382', '211300', '凌源市', '0', '0', '', '2', '1', null),
('211400', '210000', '葫芦岛市', '0', '0', 'H', '1', '1', null),
('211402', '211400', '连山区', '0', '0', '', '2', '1', null),
('211403', '211400', '龙港区', '0', '0', '', '2', '1', null),
('211404', '211400', '南票区', '0', '0', '', '2', '1', null),
('211421', '211400', '绥中县', '0', '0', '', '2', '1', null),
('211422', '211400', '建昌县', '0', '0', '', '2', '1', null),
('211481', '211400', '兴城市', '0', '0', '', '2', '1', null),
('220000', '0', '吉林省', '0', '0', '', '0', '1', null),
('220100', '220000', '长春市', '0', '0', 'C', '1', '1', null),
('220102', '220100', '南关区', '0', '0', '', '2', '1', null),
('220103', '220100', '宽城区', '0', '0', '', '2', '1', null),
('220104', '220100', '朝阳区', '0', '0', '', '2', '1', null),
('220105', '220100', '二道区', '0', '0', '', '2', '1', null),
('220106', '220100', '绿园区', '0', '0', '', '2', '1', null),
('220112', '220100', '双阳区', '0', '0', '', '2', '1', null),
('220113', '220100', '九台区', '0', '0', '', '2', '1', null),
('220122', '220100', '农安县', '0', '0', '', '2', '1', null),
('220182', '220100', '榆树市', '0', '0', '', '2', '1', null),
('220183', '220100', '德惠市', '0', '0', '', '2', '1', null),
('220200', '220000', '吉林市', '0', '0', 'J', '1', '1', null),
('220202', '220200', '昌邑区', '0', '0', '', '2', '1', null),
('220203', '220200', '龙潭区', '0', '0', '', '2', '1', null),
('220204', '220200', '船营区', '0', '0', '', '2', '1', null),
('220211', '220200', '丰满区', '0', '0', '', '2', '1', null),
('220221', '220200', '永吉县', '0', '0', '', '2', '1', null),
('220281', '220200', '蛟河市', '0', '0', '', '2', '1', null),
('220282', '220200', '桦甸市', '0', '0', '', '2', '1', null),
('220283', '220200', '舒兰市', '0', '0', '', '2', '1', null),
('220284', '220200', '磐石市', '0', '0', '', '2', '1', null),
('220300', '220000', '四平市', '0', '0', 'S', '1', '1', null),
('220302', '220300', '铁西区', '0', '0', '', '2', '1', null),
('220303', '220300', '铁东区', '0', '0', '', '2', '1', null),
('220322', '220300', '梨树县', '0', '0', '', '2', '1', null),
('220323', '220300', '伊通满族自治县', '0', '0', '', '2', '1', null),
('220381', '220300', '公主岭市', '0', '0', '', '2', '1', null);
INSERT INTO `wst_areas` VALUES ('220382', '220300', '双辽市', '0', '0', '', '2', '1', null),
('220400', '220000', '辽源市', '0', '0', 'L', '1', '1', null),
('220402', '220400', '龙山区', '0', '0', '', '2', '1', null),
('220403', '220400', '西安区', '0', '0', '', '2', '1', null),
('220421', '220400', '东丰县', '0', '0', '', '2', '1', null),
('220422', '220400', '东辽县', '0', '0', '', '2', '1', null),
('220500', '220000', '通化市', '0', '0', 'T', '1', '1', null),
('220502', '220500', '东昌区', '0', '0', '', '2', '1', null),
('220503', '220500', '二道江区', '0', '0', '', '2', '1', null),
('220521', '220500', '通化县', '0', '0', '', '2', '1', null),
('220523', '220500', '辉南县', '0', '0', '', '2', '1', null),
('220524', '220500', '柳河县', '0', '0', '', '2', '1', null),
('220581', '220500', '梅河口市', '0', '0', '', '2', '1', null),
('220582', '220500', '集安市', '0', '0', '', '2', '1', null),
('220600', '220000', '白山市', '0', '0', 'B', '1', '1', null),
('220602', '220600', '浑江区', '0', '0', '', '2', '1', null),
('220605', '220600', '江源区', '0', '0', '', '2', '1', null),
('220621', '220600', '抚松县', '0', '0', '', '2', '1', null),
('220622', '220600', '靖宇县', '0', '0', '', '2', '1', null),
('220623', '220600', '长白朝鲜族自治县', '0', '0', '', '2', '1', null),
('220681', '220600', '临江市', '0', '0', '', '2', '1', null),
('220700', '220000', '松原市', '0', '0', 'S', '1', '1', null),
('220702', '220700', '宁江区', '0', '0', '', '2', '1', null),
('220721', '220700', '前郭尔罗斯蒙古族自治县', '0', '0', '', '2', '1', null),
('220722', '220700', '长岭县', '0', '0', '', '2', '1', null),
('220723', '220700', '乾安县', '0', '0', '', '2', '1', null),
('220781', '220700', '扶余市', '0', '0', '', '2', '1', null),
('220800', '220000', '白城市', '0', '0', 'B', '1', '1', null),
('220802', '220800', '洮北区', '0', '0', '', '2', '1', null),
('220821', '220800', '镇赉县', '0', '0', '', '2', '1', null),
('220822', '220800', '通榆县', '0', '0', '', '2', '1', null),
('220881', '220800', '洮南市', '0', '0', '', '2', '1', null),
('220882', '220800', '大安市', '0', '0', '', '2', '1', null),
('222400', '220000', '延边朝鲜族自治州', '0', '0', 'Y', '1', '1', null),
('222401', '222400', '延吉市', '0', '0', '', '2', '1', null),
('222402', '222400', '图们市', '0', '0', '', '2', '1', null),
('222403', '222400', '敦化市', '0', '0', '', '2', '1', null),
('222404', '222400', '珲春市', '0', '0', '', '2', '1', null),
('222405', '222400', '龙井市', '0', '0', '', '2', '1', null),
('222406', '222400', '和龙市', '0', '0', '', '2', '1', null),
('222424', '222400', '汪清县', '0', '0', '', '2', '1', null),
('222426', '222400', '安图县', '0', '0', '', '2', '1', null),
('230000', '0', '黑龙江省', '0', '0', '', '0', '1', null),
('230100', '230000', '哈尔滨市', '0', '0', 'H', '1', '1', null),
('230102', '230100', '道里区', '0', '0', '', '2', '1', null),
('230103', '230100', '南岗区', '0', '0', '', '2', '1', null),
('230104', '230100', '道外区', '0', '0', '', '2', '1', null),
('230108', '230100', '平房区', '0', '0', '', '2', '1', null),
('230109', '230100', '松北区', '0', '0', '', '2', '1', null),
('230110', '230100', '香坊区', '0', '0', '', '2', '1', null),
('230111', '230100', '呼兰区', '0', '0', '', '2', '1', null),
('230112', '230100', '阿城区', '0', '0', '', '2', '1', null),
('230113', '230100', '双城区', '0', '0', '', '2', '1', null),
('230123', '230100', '依兰县', '0', '0', '', '2', '1', null),
('230124', '230100', '方正县', '0', '0', '', '2', '1', null),
('230125', '230100', '宾县', '0', '0', '', '2', '1', null),
('230126', '230100', '巴彦县', '0', '0', '', '2', '1', null),
('230127', '230100', '木兰县', '0', '0', '', '2', '1', null),
('230128', '230100', '通河县', '0', '0', '', '2', '1', null),
('230129', '230100', '延寿县', '0', '0', '', '2', '1', null),
('230183', '230100', '尚志市', '0', '0', '', '2', '1', null),
('230184', '230100', '五常市', '0', '0', '', '2', '1', null),
('230200', '230000', '齐齐哈尔市', '0', '0', 'Q', '1', '1', null),
('230202', '230200', '龙沙区', '0', '0', '', '2', '1', null),
('230203', '230200', '建华区', '0', '0', '', '2', '1', null),
('230204', '230200', '铁锋区', '0', '0', '', '2', '1', null),
('230205', '230200', '昂昂溪区', '0', '0', '', '2', '1', null),
('230206', '230200', '富拉尔基区', '0', '0', '', '2', '1', null),
('230207', '230200', '碾子山区', '0', '0', '', '2', '1', null),
('230208', '230200', '梅里斯达斡尔族区', '0', '0', '', '2', '1', null),
('230221', '230200', '龙江县', '0', '0', '', '2', '1', null),
('230223', '230200', '依安县', '0', '0', '', '2', '1', null),
('230224', '230200', '泰来县', '0', '0', '', '2', '1', null),
('230225', '230200', '甘南县', '0', '0', '', '2', '1', null),
('230227', '230200', '富裕县', '0', '0', '', '2', '1', null),
('230229', '230200', '克山县', '0', '0', '', '2', '1', null),
('230230', '230200', '克东县', '0', '0', '', '2', '1', null),
('230231', '230200', '拜泉县', '0', '0', '', '2', '1', null),
('230281', '230200', '讷河市', '0', '0', '', '2', '1', null),
('230300', '230000', '鸡西市', '0', '0', 'J', '1', '1', null),
('230302', '230300', '鸡冠区', '0', '0', '', '2', '1', null),
('230303', '230300', '恒山区', '0', '0', '', '2', '1', null),
('230304', '230300', '滴道区', '0', '0', '', '2', '1', null),
('230305', '230300', '梨树区', '0', '0', '', '2', '1', null),
('230306', '230300', '城子河区', '0', '0', '', '2', '1', null),
('230307', '230300', '麻山区', '0', '0', '', '2', '1', null),
('230321', '230300', '鸡东县', '0', '0', '', '2', '1', null),
('230381', '230300', '虎林市', '0', '0', '', '2', '1', null),
('230382', '230300', '密山市', '0', '0', '', '2', '1', null),
('230400', '230000', '鹤岗市', '0', '0', 'H', '1', '1', null),
('230402', '230400', '向阳区', '0', '0', '', '2', '1', null),
('230403', '230400', '工农区', '0', '0', '', '2', '1', null),
('230404', '230400', '南山区', '0', '0', '', '2', '1', null),
('230405', '230400', '兴安区', '0', '0', '', '2', '1', null),
('230406', '230400', '东山区', '0', '0', '', '2', '1', null),
('230407', '230400', '兴山区', '0', '0', '', '2', '1', null),
('230421', '230400', '萝北县', '0', '0', '', '2', '1', null),
('230422', '230400', '绥滨县', '0', '0', '', '2', '1', null),
('230500', '230000', '双鸭山市', '0', '0', 'S', '1', '1', null),
('230502', '230500', '尖山区', '0', '0', '', '2', '1', null),
('230503', '230500', '岭东区', '0', '0', '', '2', '1', null),
('230505', '230500', '四方台区', '0', '0', '', '2', '1', null),
('230506', '230500', '宝山区', '0', '0', '', '2', '1', null),
('230521', '230500', '集贤县', '0', '0', '', '2', '1', null),
('230522', '230500', '友谊县', '0', '0', '', '2', '1', null),
('230523', '230500', '宝清县', '0', '0', '', '2', '1', null),
('230524', '230500', '饶河县', '0', '0', '', '2', '1', null),
('230600', '230000', '大庆市', '0', '0', 'D', '1', '1', null),
('230602', '230600', '萨尔图区', '0', '0', '', '2', '1', null),
('230603', '230600', '龙凤区', '0', '0', '', '2', '1', null),
('230604', '230600', '让胡路区', '0', '0', '', '2', '1', null),
('230605', '230600', '红岗区', '0', '0', '', '2', '1', null),
('230606', '230600', '大同区', '0', '0', '', '2', '1', null),
('230621', '230600', '肇州县', '0', '0', '', '2', '1', null),
('230622', '230600', '肇源县', '0', '0', '', '2', '1', null),
('230623', '230600', '林甸县', '0', '0', '', '2', '1', null),
('230624', '230600', '杜尔伯特蒙古族自治县', '0', '0', '', '2', '1', null),
('230700', '230000', '伊春市', '0', '0', 'Y', '1', '1', null),
('230702', '230700', '伊春区', '0', '0', '', '2', '1', null),
('230703', '230700', '南岔区', '0', '0', '', '2', '1', null),
('230704', '230700', '友好区', '0', '0', '', '2', '1', null),
('230705', '230700', '西林区', '0', '0', '', '2', '1', null),
('230706', '230700', '翠峦区', '0', '0', '', '2', '1', null),
('230707', '230700', '新青区', '0', '0', '', '2', '1', null),
('230708', '230700', '美溪区', '0', '0', '', '2', '1', null),
('230709', '230700', '金山屯区', '0', '0', '', '2', '1', null),
('230710', '230700', '五营区', '0', '0', '', '2', '1', null),
('230711', '230700', '乌马河区', '0', '0', '', '2', '1', null),
('230712', '230700', '汤旺河区', '0', '0', '', '2', '1', null),
('230713', '230700', '带岭区', '0', '0', '', '2', '1', null),
('230714', '230700', '乌伊岭区', '0', '0', '', '2', '1', null),
('230715', '230700', '红星区', '0', '0', '', '2', '1', null),
('230716', '230700', '上甘岭区', '0', '0', '', '2', '1', null),
('230722', '230700', '嘉荫县', '0', '0', '', '2', '1', null),
('230781', '230700', '铁力市', '0', '0', '', '2', '1', null),
('230800', '230000', '佳木斯市', '0', '0', 'J', '1', '1', null),
('230803', '230800', '向阳区', '0', '0', '', '2', '1', null),
('230804', '230800', '前进区', '0', '0', '', '2', '1', null),
('230805', '230800', '东风区', '0', '0', '', '2', '1', null),
('230811', '230800', '郊区', '0', '0', '', '2', '1', null),
('230822', '230800', '桦南县', '0', '0', '', '2', '1', null),
('230826', '230800', '桦川县', '0', '0', '', '2', '1', null),
('230828', '230800', '汤原县', '0', '0', '', '2', '1', null),
('230833', '230800', '抚远县', '0', '0', '', '2', '1', null),
('230881', '230800', '同江市', '0', '0', '', '2', '1', null),
('230882', '230800', '富锦市', '0', '0', '', '2', '1', null),
('230900', '230000', '七台河市', '0', '0', 'Q', '1', '1', null),
('230902', '230900', '新兴区', '0', '0', '', '2', '1', null),
('230903', '230900', '桃山区', '0', '0', '', '2', '1', null),
('230904', '230900', '茄子河区', '0', '0', '', '2', '1', null),
('230921', '230900', '勃利县', '0', '0', '', '2', '1', null),
('231000', '230000', '牡丹江市', '0', '0', 'M', '1', '1', null),
('231002', '231000', '东安区', '0', '0', '', '2', '1', null),
('231003', '231000', '阳明区', '0', '0', '', '2', '1', null),
('231004', '231000', '爱民区', '0', '0', '', '2', '1', null),
('231005', '231000', '西安区', '0', '0', '', '2', '1', null),
('231024', '231000', '东宁县', '0', '0', '', '2', '1', null),
('231025', '231000', '林口县', '0', '0', '', '2', '1', null),
('231081', '231000', '绥芬河市', '0', '0', '', '2', '1', null),
('231083', '231000', '海林市', '0', '0', '', '2', '1', null),
('231084', '231000', '宁安市', '0', '0', '', '2', '1', null),
('231085', '231000', '穆棱市', '0', '0', '', '2', '1', null),
('231100', '230000', '黑河市', '0', '0', 'H', '1', '1', null),
('231102', '231100', '爱辉区', '0', '0', '', '2', '1', null),
('231121', '231100', '嫩江县', '0', '0', '', '2', '1', null),
('231123', '231100', '逊克县', '0', '0', '', '2', '1', null),
('231124', '231100', '孙吴县', '0', '0', '', '2', '1', null),
('231181', '231100', '北安市', '0', '0', '', '2', '1', null),
('231182', '231100', '五大连池市', '0', '0', '', '2', '1', null),
('231200', '230000', '绥化市', '0', '0', 'S', '1', '1', null),
('231202', '231200', '北林区', '0', '0', '', '2', '1', null),
('231221', '231200', '望奎县', '0', '0', '', '2', '1', null),
('231222', '231200', '兰西县', '0', '0', '', '2', '1', null),
('231223', '231200', '青冈县', '0', '0', '', '2', '1', null),
('231224', '231200', '庆安县', '0', '0', '', '2', '1', null),
('231225', '231200', '明水县', '0', '0', '', '2', '1', null),
('231226', '231200', '绥棱县', '0', '0', '', '2', '1', null),
('231281', '231200', '安达市', '0', '0', '', '2', '1', null),
('231282', '231200', '肇东市', '0', '0', '', '2', '1', null),
('231283', '231200', '海伦市', '0', '0', '', '2', '1', null),
('232700', '230000', '大兴安岭地区', '0', '0', 'D', '1', '1', null),
('232721', '232700', '呼玛县', '0', '0', '', '2', '1', null),
('232722', '232700', '塔河县', '0', '0', '', '2', '1', null),
('232723', '232700', '漠河县', '0', '0', '', '2', '1', null),
('310000', '0', '上海市', '0', '0', '', '0', '1', null),
('310100', '310000', '上海市', '0', '0', '', '1', '1', null),
('310101', '310100', '黄浦区', '0', '0', '', '2', '1', null),
('310104', '310100', '徐汇区', '0', '0', '', '2', '1', null),
('310105', '310100', '长宁区', '0', '0', '', '2', '1', null),
('310106', '310100', '静安区', '0', '0', '', '2', '1', null),
('310107', '310100', '普陀区', '0', '0', '', '2', '1', null),
('310108', '310100', '闸北区', '0', '0', '', '2', '1', null),
('310109', '310100', '虹口区', '0', '0', '', '2', '1', null),
('310110', '310100', '杨浦区', '0', '0', '', '2', '1', null),
('310112', '310100', '闵行区', '0', '0', '', '2', '1', null),
('310113', '310100', '宝山区', '0', '0', '', '2', '1', null),
('310114', '310100', '嘉定区', '0', '0', '', '2', '1', null),
('310115', '310100', '浦东新区', '0', '0', '', '2', '1', null),
('310116', '310100', '金山区', '0', '0', '', '2', '1', null),
('310117', '310100', '松江区', '0', '0', '', '2', '1', null),
('310118', '310100', '青浦区', '0', '0', '', '2', '1', null),
('310120', '310100', '奉贤区', '0', '0', '', '2', '1', null),
('310230', '310200', '崇明县', '0', '0', '', '2', '1', null),
('320000', '0', '江苏省', '0', '0', '', '0', '1', null),
('320100', '320000', '南京市', '0', '0', 'N', '1', '1', null),
('320102', '320100', '玄武区', '0', '0', '', '2', '1', null),
('320104', '320100', '秦淮区', '0', '0', '', '2', '1', null),
('320105', '320100', '建邺区', '0', '0', '', '2', '1', null),
('320106', '320100', '鼓楼区', '0', '0', '', '2', '1', null),
('320111', '320100', '浦口区', '0', '0', '', '2', '1', null),
('320113', '320100', '栖霞区', '0', '0', '', '2', '1', null),
('320114', '320100', '雨花台区', '0', '0', '', '2', '1', null),
('320115', '320100', '江宁区', '0', '0', '', '2', '1', null),
('320116', '320100', '六合区', '0', '0', '', '2', '1', null),
('320117', '320100', '溧水区', '0', '0', '', '2', '1', null),
('320118', '320100', '高淳区', '0', '0', '', '2', '1', null),
('320200', '320000', '无锡市', '0', '0', 'W', '1', '1', null),
('320202', '320200', '崇安区', '0', '0', '', '2', '1', null),
('320203', '320200', '南长区', '0', '0', '', '2', '1', null),
('320204', '320200', '北塘区', '0', '0', '', '2', '1', null),
('320205', '320200', '锡山区', '0', '0', '', '2', '1', null),
('320206', '320200', '惠山区', '0', '0', '', '2', '1', null),
('320211', '320200', '滨湖区', '0', '0', '', '2', '1', null),
('320281', '320200', '江阴市', '0', '0', '', '2', '1', null),
('320282', '320200', '宜兴市', '0', '0', '', '2', '1', null),
('320300', '320000', '徐州市', '0', '0', 'X', '1', '1', null),
('320302', '320300', '鼓楼区', '0', '0', '', '2', '1', null),
('320303', '320300', '云龙区', '0', '0', '', '2', '1', null),
('320305', '320300', '贾汪区', '0', '0', '', '2', '1', null),
('320311', '320300', '泉山区', '0', '0', '', '2', '1', null),
('320312', '320300', '铜山区', '0', '0', '', '2', '1', null),
('320321', '320300', '丰县', '0', '0', '', '2', '1', null),
('320322', '320300', '沛县', '0', '0', '', '2', '1', null),
('320324', '320300', '睢宁县', '0', '0', '', '2', '1', null),
('320381', '320300', '新沂市', '0', '0', '', '2', '1', null),
('320382', '320300', '邳州市', '0', '0', '', '2', '1', null),
('320400', '320000', '常州市', '0', '0', 'C', '1', '1', null),
('320402', '320400', '天宁区', '0', '0', '', '2', '1', null),
('320404', '320400', '钟楼区', '0', '0', '', '2', '1', null),
('320405', '320400', '戚墅堰区', '0', '0', '', '2', '1', null),
('320411', '320400', '新北区', '0', '0', '', '2', '1', null),
('320412', '320400', '武进区', '0', '0', '', '2', '1', null),
('320481', '320400', '溧阳市', '0', '0', '', '2', '1', null),
('320482', '320400', '金坛市', '0', '0', '', '2', '1', null),
('320500', '320000', '苏州市', '0', '0', 'S', '1', '1', null),
('320505', '320500', '虎丘区', '0', '0', '', '2', '1', null),
('320506', '320500', '吴中区', '0', '0', '', '2', '1', null),
('320507', '320500', '相城区', '0', '0', '', '2', '1', null),
('320508', '320500', '姑苏区', '0', '0', '', '2', '1', null),
('320509', '320500', '吴江区', '0', '0', '', '2', '1', null),
('320581', '320500', '常熟市', '0', '0', '', '2', '1', null),
('320582', '320500', '张家港市', '0', '0', '', '2', '1', null),
('320583', '320500', '昆山市', '0', '0', '', '2', '1', null),
('320585', '320500', '太仓市', '0', '0', '', '2', '1', null),
('320600', '320000', '南通市', '0', '0', 'N', '1', '1', null),
('320602', '320600', '崇川区', '0', '0', '', '2', '1', null),
('320611', '320600', '港闸区', '0', '0', '', '2', '1', null),
('320612', '320600', '通州区', '0', '0', '', '2', '1', null),
('320621', '320600', '海安县', '0', '0', '', '2', '1', null),
('320623', '320600', '如东县', '0', '0', '', '2', '1', null),
('320681', '320600', '启东市', '0', '0', '', '2', '1', null),
('320682', '320600', '如皋市', '0', '0', '', '2', '1', null),
('320684', '320600', '海门市', '0', '0', '', '2', '1', null),
('320700', '320000', '连云港市', '0', '0', 'L', '1', '1', null),
('320703', '320700', '连云区', '0', '0', '', '2', '1', null),
('320706', '320700', '海州区', '0', '0', '', '2', '1', null),
('320707', '320700', '赣榆区', '0', '0', '', '2', '1', null),
('320722', '320700', '东海县', '0', '0', '', '2', '1', null),
('320723', '320700', '灌云县', '0', '0', '', '2', '1', null),
('320724', '320700', '灌南县', '0', '0', '', '2', '1', null),
('320800', '320000', '淮安市', '0', '0', 'H', '1', '1', null),
('320802', '320800', '清河区', '0', '0', '', '2', '1', null),
('320803', '320800', '淮安区', '0', '0', '', '2', '1', null),
('320804', '320800', '淮阴区', '0', '0', '', '2', '1', null),
('320811', '320800', '清浦区', '0', '0', '', '2', '1', null),
('320826', '320800', '涟水县', '0', '0', '', '2', '1', null),
('320829', '320800', '洪泽县', '0', '0', '', '2', '1', null),
('320830', '320800', '盱眙县', '0', '0', '', '2', '1', null),
('320831', '320800', '金湖县', '0', '0', '', '2', '1', null),
('320900', '320000', '盐城市', '0', '0', 'Y', '1', '1', null),
('320902', '320900', '亭湖区', '0', '0', '', '2', '1', null),
('320903', '320900', '盐都区', '0', '0', '', '2', '1', null),
('320921', '320900', '响水县', '0', '0', '', '2', '1', null),
('320922', '320900', '滨海县', '0', '0', '', '2', '1', null),
('320923', '320900', '阜宁县', '0', '0', '', '2', '1', null),
('320924', '320900', '射阳县', '0', '0', '', '2', '1', null),
('320925', '320900', '建湖县', '0', '0', '', '2', '1', null),
('320981', '320900', '东台市', '0', '0', '', '2', '1', null),
('320982', '320900', '大丰市', '0', '0', '', '2', '1', null),
('321000', '320000', '扬州市', '0', '0', 'Y', '1', '1', null),
('321002', '321000', '广陵区', '0', '0', '', '2', '1', null),
('321003', '321000', '邗江区', '0', '0', '', '2', '1', null),
('321012', '321000', '江都区', '0', '0', '', '2', '1', null),
('321023', '321000', '宝应县', '0', '0', '', '2', '1', null),
('321081', '321000', '仪征市', '0', '0', '', '2', '1', null),
('321084', '321000', '高邮市', '0', '0', '', '2', '1', null),
('321100', '320000', '镇江市', '0', '0', 'Z', '1', '1', null),
('321102', '321100', '京口区', '0', '0', '', '2', '1', null),
('321111', '321100', '润州区', '0', '0', '', '2', '1', null),
('321112', '321100', '丹徒区', '0', '0', '', '2', '1', null),
('321181', '321100', '丹阳市', '0', '0', '', '2', '1', null),
('321182', '321100', '扬中市', '0', '0', '', '2', '1', null),
('321183', '321100', '句容市', '0', '0', '', '2', '1', null),
('321200', '320000', '泰州市', '0', '0', 'T', '1', '1', null),
('321202', '321200', '海陵区', '0', '0', '', '2', '1', null),
('321203', '321200', '高港区', '0', '0', '', '2', '1', null),
('321204', '321200', '姜堰区', '0', '0', '', '2', '1', null),
('321281', '321200', '兴化市', '0', '0', '', '2', '1', null),
('321282', '321200', '靖江市', '0', '0', '', '2', '1', null),
('321283', '321200', '泰兴市', '0', '0', '', '2', '1', null),
('321300', '320000', '宿迁市', '0', '0', 'S', '1', '1', null),
('321302', '321300', '宿城区', '0', '0', '', '2', '1', null),
('321311', '321300', '宿豫区', '0', '0', '', '2', '1', null),
('321322', '321300', '沭阳县', '0', '0', '', '2', '1', null),
('321323', '321300', '泗阳县', '0', '0', '', '2', '1', null),
('321324', '321300', '泗洪县', '0', '0', '', '2', '1', null),
('330000', '0', '浙江省', '0', '0', '', '0', '1', null),
('330100', '330000', '杭州市', '0', '0', 'H', '1', '1', null),
('330102', '330100', '上城区', '0', '0', '', '2', '1', null),
('330103', '330100', '下城区', '0', '0', '', '2', '1', null),
('330104', '330100', '江干区', '0', '0', '', '2', '1', null),
('330105', '330100', '拱墅区', '0', '0', '', '2', '1', null),
('330106', '330100', '西湖区', '0', '0', '', '2', '1', null),
('330108', '330100', '滨江区', '0', '0', '', '2', '1', null),
('330109', '330100', '萧山区', '0', '0', '', '2', '1', null),
('330110', '330100', '余杭区', '0', '0', '', '2', '1', null),
('330111', '330100', '富阳区', '0', '0', '', '2', '1', null),
('330122', '330100', '桐庐县', '0', '0', '', '2', '1', null),
('330127', '330100', '淳安县', '0', '0', '', '2', '1', null),
('330182', '330100', '建德市', '0', '0', '', '2', '1', null),
('330185', '330100', '临安市', '0', '0', '', '2', '1', null),
('330200', '330000', '宁波市', '0', '0', 'L', '1', '1', null),
('330203', '330200', '海曙区', '0', '0', '', '2', '1', null),
('330204', '330200', '江东区', '0', '0', '', '2', '1', null),
('330205', '330200', '江北区', '0', '0', '', '2', '1', null),
('330206', '330200', '北仑区', '0', '0', '', '2', '1', null);
INSERT INTO `wst_areas` VALUES ('330211', '330200', '镇海区', '0', '0', '', '2', '1', null),
('330212', '330200', '鄞州区', '0', '0', '', '2', '1', null),
('330225', '330200', '象山县', '0', '0', '', '2', '1', null),
('330226', '330200', '宁海县', '0', '0', '', '2', '1', null),
('330281', '330200', '余姚市', '0', '0', '', '2', '1', null),
('330282', '330200', '慈溪市', '0', '0', '', '2', '1', null),
('330283', '330200', '奉化市', '0', '0', '', '2', '1', null),
('330300', '330000', '温州市', '0', '0', 'W', '1', '1', null),
('330302', '330300', '鹿城区', '0', '0', '', '2', '1', null),
('330303', '330300', '龙湾区', '0', '0', '', '2', '1', null),
('330304', '330300', '瓯海区', '0', '0', '', '2', '1', null),
('330322', '330300', '洞头县', '0', '0', '', '2', '1', null),
('330324', '330300', '永嘉县', '0', '0', '', '2', '1', null),
('330326', '330300', '平阳县', '0', '0', '', '2', '1', null),
('330327', '330300', '苍南县', '0', '0', '', '2', '1', null),
('330328', '330300', '文成县', '0', '0', '', '2', '1', null),
('330329', '330300', '泰顺县', '0', '0', '', '2', '1', null),
('330381', '330300', '瑞安市', '0', '0', '', '2', '1', null),
('330382', '330300', '乐清市', '0', '0', '', '2', '1', null),
('330400', '330000', '嘉兴市', '0', '0', 'J', '1', '1', null),
('330402', '330400', '南湖区', '0', '0', '', '2', '1', null),
('330411', '330400', '秀洲区', '0', '0', '', '2', '1', null),
('330421', '330400', '嘉善县', '0', '0', '', '2', '1', null),
('330424', '330400', '海盐县', '0', '0', '', '2', '1', null),
('330481', '330400', '海宁市', '0', '0', '', '2', '1', null),
('330482', '330400', '平湖市', '0', '0', '', '2', '1', null),
('330483', '330400', '桐乡市', '0', '0', '', '2', '1', null),
('330500', '330000', '湖州市', '0', '0', 'H', '1', '1', null),
('330502', '330500', '吴兴区', '0', '0', '', '2', '1', null),
('330503', '330500', '南浔区', '0', '0', '', '2', '1', null),
('330521', '330500', '德清县', '0', '0', '', '2', '1', null),
('330522', '330500', '长兴县', '0', '0', '', '2', '1', null),
('330523', '330500', '安吉县', '0', '0', '', '2', '1', null),
('330600', '330000', '绍兴市', '0', '0', 'S', '1', '1', null),
('330602', '330600', '越城区', '0', '0', '', '2', '1', null),
('330603', '330600', '柯桥区', '0', '0', '', '2', '1', null),
('330604', '330600', '上虞区', '0', '0', '', '2', '1', null),
('330624', '330600', '新昌县', '0', '0', '', '2', '1', null),
('330681', '330600', '诸暨市', '0', '0', '', '2', '1', null),
('330683', '330600', '嵊州市', '0', '0', '', '2', '1', null),
('330700', '330000', '金华市', '0', '0', 'J', '1', '1', null),
('330702', '330700', '婺城区', '0', '0', '', '2', '1', null),
('330703', '330700', '金东区', '0', '0', '', '2', '1', null),
('330723', '330700', '武义县', '0', '0', '', '2', '1', null),
('330726', '330700', '浦江县', '0', '0', '', '2', '1', null),
('330727', '330700', '磐安县', '0', '0', '', '2', '1', null),
('330781', '330700', '兰溪市', '0', '0', '', '2', '1', null),
('330782', '330700', '义乌市', '0', '0', '', '2', '1', null),
('330783', '330700', '东阳市', '0', '0', '', '2', '1', null),
('330784', '330700', '永康市', '0', '0', '', '2', '1', null),
('330800', '330000', '衢州市', '0', '0', 'Q', '1', '1', null),
('330802', '330800', '柯城区', '0', '0', '', '2', '1', null),
('330803', '330800', '衢江区', '0', '0', '', '2', '1', null),
('330822', '330800', '常山县', '0', '0', '', '2', '1', null),
('330824', '330800', '开化县', '0', '0', '', '2', '1', null),
('330825', '330800', '龙游县', '0', '0', '', '2', '1', null),
('330881', '330800', '江山市', '0', '0', '', '2', '1', null),
('330900', '330000', '舟山市', '0', '0', 'Z', '1', '1', null),
('330902', '330900', '定海区', '0', '0', '', '2', '1', null),
('330903', '330900', '普陀区', '0', '0', '', '2', '1', null),
('330921', '330900', '岱山县', '0', '0', '', '2', '1', null),
('330922', '330900', '嵊泗县', '0', '0', '', '2', '1', null),
('331000', '330000', '台州市', '0', '0', 'T', '1', '1', null),
('331002', '331000', '椒江区', '0', '0', '', '2', '1', null),
('331003', '331000', '黄岩区', '0', '0', '', '2', '1', null),
('331004', '331000', '路桥区', '0', '0', '', '2', '1', null),
('331021', '331000', '玉环县', '0', '0', '', '2', '1', null),
('331022', '331000', '三门县', '0', '0', '', '2', '1', null),
('331023', '331000', '天台县', '0', '0', '', '2', '1', null),
('331024', '331000', '仙居县', '0', '0', '', '2', '1', null),
('331081', '331000', '温岭市', '0', '0', '', '2', '1', null),
('331082', '331000', '临海市', '0', '0', '', '2', '1', null),
('331100', '330000', '丽水市', '0', '0', 'L', '1', '1', null),
('331102', '331100', '莲都区', '0', '0', '', '2', '1', null),
('331121', '331100', '青田县', '0', '0', '', '2', '1', null),
('331122', '331100', '缙云县', '0', '0', '', '2', '1', null),
('331123', '331100', '遂昌县', '0', '0', '', '2', '1', null),
('331124', '331100', '松阳县', '0', '0', '', '2', '1', null),
('331125', '331100', '云和县', '0', '0', '', '2', '1', null),
('331126', '331100', '庆元县', '0', '0', '', '2', '1', null),
('331127', '331100', '景宁畲族自治县', '0', '0', '', '2', '1', null),
('331181', '331100', '龙泉市', '0', '0', '', '2', '1', null),
('340000', '0', '安徽省', '0', '0', '', '0', '1', null),
('340100', '340000', '合肥市', '0', '0', 'H', '1', '1', null),
('340102', '340100', '瑶海区', '0', '0', '', '2', '1', null),
('340103', '340100', '庐阳区', '0', '0', '', '2', '1', null),
('340104', '340100', '蜀山区', '0', '0', '', '2', '1', null),
('340111', '340100', '包河区', '0', '0', '', '2', '1', null),
('340121', '340100', '长丰县', '0', '0', '', '2', '1', null),
('340122', '340100', '肥东县', '0', '0', '', '2', '1', null),
('340123', '340100', '肥西县', '0', '0', '', '2', '1', null),
('340124', '340100', '庐江县', '0', '0', '', '2', '1', null),
('340181', '340100', '巢湖市', '0', '0', '', '2', '1', null),
('340200', '340000', '芜湖市', '0', '0', 'W', '1', '1', null),
('340202', '340200', '镜湖区', '0', '0', '', '2', '1', null),
('340203', '340200', '弋江区', '0', '0', '', '2', '1', null),
('340207', '340200', '鸠江区', '0', '0', '', '2', '1', null),
('340208', '340200', '三山区', '0', '0', '', '2', '1', null),
('340221', '340200', '芜湖县', '0', '0', '', '2', '1', null),
('340222', '340200', '繁昌县', '0', '0', '', '2', '1', null),
('340223', '340200', '南陵县', '0', '0', '', '2', '1', null),
('340225', '340200', '无为县', '0', '0', '', '2', '1', null),
('340300', '340000', '蚌埠市', '0', '0', 'B', '1', '1', null),
('340302', '340300', '龙子湖区', '0', '0', '', '2', '1', null),
('340303', '340300', '蚌山区', '0', '0', '', '2', '1', null),
('340304', '340300', '禹会区', '0', '0', '', '2', '1', null),
('340311', '340300', '淮上区', '0', '0', '', '2', '1', null),
('340321', '340300', '怀远县', '0', '0', '', '2', '1', null),
('340322', '340300', '五河县', '0', '0', '', '2', '1', null),
('340323', '340300', '固镇县', '0', '0', '', '2', '1', null),
('340400', '340000', '淮南市', '0', '0', 'H', '1', '1', null),
('340402', '340400', '大通区', '0', '0', '', '2', '1', null),
('340403', '340400', '田家庵区', '0', '0', '', '2', '1', null),
('340404', '340400', '谢家集区', '0', '0', '', '2', '1', null),
('340405', '340400', '八公山区', '0', '0', '', '2', '1', null),
('340406', '340400', '潘集区', '0', '0', '', '2', '1', null),
('340421', '340400', '凤台县', '0', '0', '', '2', '1', null),
('340500', '340000', '马鞍山市', '0', '0', 'M', '1', '1', null),
('340503', '340500', '花山区', '0', '0', '', '2', '1', null),
('340504', '340500', '雨山区', '0', '0', '', '2', '1', null),
('340506', '340500', '博望区', '0', '0', '', '2', '1', null),
('340521', '340500', '当涂县', '0', '0', '', '2', '1', null),
('340522', '340500', '含山县', '0', '0', '', '2', '1', null),
('340523', '340500', '和县', '0', '0', '', '2', '1', null),
('340600', '340000', '淮北市', '0', '0', 'H', '1', '1', null),
('340602', '340600', '杜集区', '0', '0', '', '2', '1', null),
('340603', '340600', '相山区', '0', '0', '', '2', '1', null),
('340604', '340600', '烈山区', '0', '0', '', '2', '1', null),
('340621', '340600', '濉溪县', '0', '0', '', '2', '1', null),
('340700', '340000', '铜陵市', '0', '0', 'T', '1', '1', null),
('340702', '340700', '铜官山区', '0', '0', '', '2', '1', null),
('340703', '340700', '狮子山区', '0', '0', '', '2', '1', null),
('340711', '340700', '郊区', '0', '0', '', '2', '1', null),
('340721', '340700', '铜陵县', '0', '0', '', '2', '1', null),
('340800', '340000', '安庆市', '0', '0', 'A', '1', '1', null),
('340802', '340800', '迎江区', '0', '0', '', '2', '1', null),
('340803', '340800', '大观区', '0', '0', '', '2', '1', null),
('340811', '340800', '宜秀区', '0', '0', '', '2', '1', null),
('340822', '340800', '怀宁县', '0', '0', '', '2', '1', null),
('340823', '340800', '枞阳县', '0', '0', '', '2', '1', null),
('340824', '340800', '潜山县', '0', '0', '', '2', '1', null),
('340825', '340800', '太湖县', '0', '0', '', '2', '1', null),
('340826', '340800', '宿松县', '0', '0', '', '2', '1', null),
('340827', '340800', '望江县', '0', '0', '', '2', '1', null),
('340828', '340800', '岳西县', '0', '0', '', '2', '1', null),
('340881', '340800', '桐城市', '0', '0', '', '2', '1', null),
('341000', '340000', '黄山市', '0', '0', 'H', '1', '1', null),
('341002', '341000', '屯溪区', '0', '0', '', '2', '1', null),
('341003', '341000', '黄山区', '0', '0', '', '2', '1', null),
('341004', '341000', '徽州区', '0', '0', '', '2', '1', null),
('341021', '341000', '歙县', '0', '0', '', '2', '1', null),
('341022', '341000', '休宁县', '0', '0', '', '2', '1', null),
('341023', '341000', '黟县', '0', '0', '', '2', '1', null),
('341024', '341000', '祁门县', '0', '0', '', '2', '1', null),
('341100', '340000', '滁州市', '0', '0', 'C', '1', '1', null),
('341102', '341100', '琅琊区', '0', '0', '', '2', '1', null),
('341103', '341100', '南谯区', '0', '0', '', '2', '1', null),
('341122', '341100', '来安县', '0', '0', '', '2', '1', null),
('341124', '341100', '全椒县', '0', '0', '', '2', '1', null),
('341125', '341100', '定远县', '0', '0', '', '2', '1', null),
('341126', '341100', '凤阳县', '0', '0', '', '2', '1', null),
('341181', '341100', '天长市', '0', '0', '', '2', '1', null),
('341182', '341100', '明光市', '0', '0', '', '2', '1', null),
('341200', '340000', '阜阳市', '0', '0', 'F', '1', '1', null),
('341202', '341200', '颍州区', '0', '0', '', '2', '1', null),
('341203', '341200', '颍东区', '0', '0', '', '2', '1', null),
('341204', '341200', '颍泉区', '0', '0', '', '2', '1', null),
('341221', '341200', '临泉县', '0', '0', '', '2', '1', null),
('341222', '341200', '太和县', '0', '0', '', '2', '1', null),
('341225', '341200', '阜南县', '0', '0', '', '2', '1', null),
('341226', '341200', '颍上县', '0', '0', '', '2', '1', null),
('341282', '341200', '界首市', '0', '0', '', '2', '1', null),
('341300', '340000', '宿州市', '0', '0', 'S', '1', '1', null),
('341302', '341300', '埇桥区', '0', '0', '', '2', '1', null),
('341321', '341300', '砀山县', '0', '0', '', '2', '1', null),
('341322', '341300', '萧县', '0', '0', '', '2', '1', null),
('341323', '341300', '灵璧县', '0', '0', '', '2', '1', null),
('341324', '341300', '泗县', '0', '0', '', '2', '1', null),
('341500', '340000', '六安市', '0', '0', 'L', '1', '1', null),
('341502', '341500', '金安区', '0', '0', '', '2', '1', null),
('341503', '341500', '裕安区', '0', '0', '', '2', '1', null),
('341521', '341500', '寿县', '0', '0', '', '2', '1', null),
('341522', '341500', '霍邱县', '0', '0', '', '2', '1', null),
('341523', '341500', '舒城县', '0', '0', '', '2', '1', null),
('341524', '341500', '金寨县', '0', '0', '', '2', '1', null),
('341525', '341500', '霍山县', '0', '0', '', '2', '1', null),
('341600', '340000', '亳州市', '0', '0', 'H', '1', '1', null),
('341602', '341600', '谯城区', '0', '0', '', '2', '1', null),
('341621', '341600', '涡阳县', '0', '0', '', '2', '1', null),
('341622', '341600', '蒙城县', '0', '0', '', '2', '1', null),
('341623', '341600', '利辛县', '0', '0', '', '2', '1', null),
('341700', '340000', '池州市', '0', '0', 'C', '1', '1', null),
('341702', '341700', '贵池区', '0', '0', '', '2', '1', null),
('341721', '341700', '东至县', '0', '0', '', '2', '1', null),
('341722', '341700', '石台县', '0', '0', '', '2', '1', null),
('341723', '341700', '青阳县', '0', '0', '', '2', '1', null),
('341800', '340000', '宣城市', '0', '0', 'X', '1', '1', null),
('341802', '341800', '宣州区', '0', '0', '', '2', '1', null),
('341821', '341800', '郎溪县', '0', '0', '', '2', '1', null),
('341822', '341800', '广德县', '0', '0', '', '2', '1', null),
('341823', '341800', '泾县', '0', '0', '', '2', '1', null),
('341824', '341800', '绩溪县', '0', '0', '', '2', '1', null),
('341825', '341800', '旌德县', '0', '0', '', '2', '1', null),
('341881', '341800', '宁国市', '0', '0', '', '2', '1', null),
('350000', '0', '福建省', '0', '0', '', '0', '1', null),
('350100', '350000', '福州市', '0', '0', 'F', '1', '1', null),
('350102', '350100', '鼓楼区', '0', '0', '', '2', '1', null),
('350103', '350100', '台江区', '0', '0', '', '2', '1', null),
('350104', '350100', '仓山区', '0', '0', '', '2', '1', null),
('350105', '350100', '马尾区', '0', '0', '', '2', '1', null),
('350111', '350100', '晋安区', '0', '0', '', '2', '1', null),
('350121', '350100', '闽侯县', '0', '0', '', '2', '1', null),
('350122', '350100', '连江县', '0', '0', '', '2', '1', null),
('350123', '350100', '罗源县', '0', '0', '', '2', '1', null),
('350124', '350100', '闽清县', '0', '0', '', '2', '1', null),
('350125', '350100', '永泰县', '0', '0', '', '2', '1', null),
('350128', '350100', '平潭县', '0', '0', '', '2', '1', null),
('350181', '350100', '福清市', '0', '0', '', '2', '1', null),
('350182', '350100', '长乐市', '0', '0', '', '2', '1', null),
('350200', '350000', '厦门市', '0', '0', 'X', '1', '1', null),
('350203', '350200', '思明区', '0', '0', '', '2', '1', null),
('350205', '350200', '海沧区', '0', '0', '', '2', '1', null),
('350206', '350200', '湖里区', '0', '0', '', '2', '1', null),
('350211', '350200', '集美区', '0', '0', '', '2', '1', null),
('350212', '350200', '同安区', '0', '0', '', '2', '1', null),
('350213', '350200', '翔安区', '0', '0', '', '2', '1', null),
('350300', '350000', '莆田市', '0', '0', 'P', '1', '1', null),
('350302', '350300', '城厢区', '0', '0', '', '2', '1', null),
('350303', '350300', '涵江区', '0', '0', '', '2', '1', null),
('350304', '350300', '荔城区', '0', '0', '', '2', '1', null),
('350305', '350300', '秀屿区', '0', '0', '', '2', '1', null),
('350322', '350300', '仙游县', '0', '0', '', '2', '1', null),
('350400', '350000', '三明市', '0', '0', 'S', '1', '1', null),
('350402', '350400', '梅列区', '0', '0', '', '2', '1', null),
('350403', '350400', '三元区', '0', '0', '', '2', '1', null),
('350421', '350400', '明溪县', '0', '0', '', '2', '1', null),
('350423', '350400', '清流县', '0', '0', '', '2', '1', null),
('350424', '350400', '宁化县', '0', '0', '', '2', '1', null),
('350425', '350400', '大田县', '0', '0', '', '2', '1', null),
('350426', '350400', '尤溪县', '0', '0', '', '2', '1', null),
('350427', '350400', '沙县', '0', '0', '', '2', '1', null),
('350428', '350400', '将乐县', '0', '0', '', '2', '1', null),
('350429', '350400', '泰宁县', '0', '0', '', '2', '1', null),
('350430', '350400', '建宁县', '0', '0', '', '2', '1', null),
('350481', '350400', '永安市', '0', '0', '', '2', '1', null),
('350500', '350000', '泉州市', '0', '0', 'Q', '1', '1', null),
('350502', '350500', '鲤城区', '0', '0', '', '2', '1', null),
('350503', '350500', '丰泽区', '0', '0', '', '2', '1', null),
('350504', '350500', '洛江区', '0', '0', '', '2', '1', null),
('350505', '350500', '泉港区', '0', '0', '', '2', '1', null),
('350521', '350500', '惠安县', '0', '0', '', '2', '1', null),
('350524', '350500', '安溪县', '0', '0', '', '2', '1', null),
('350525', '350500', '永春县', '0', '0', '', '2', '1', null),
('350526', '350500', '德化县', '0', '0', '', '2', '1', null),
('350527', '350500', '金门县', '0', '0', '', '2', '1', null),
('350581', '350500', '石狮市', '0', '0', '', '2', '1', null),
('350582', '350500', '晋江市', '0', '0', '', '2', '1', null),
('350583', '350500', '南安市', '0', '0', '', '2', '1', null),
('350600', '350000', '漳州市', '0', '0', 'Z', '1', '1', null),
('350602', '350600', '芗城区', '0', '0', '', '2', '1', null),
('350603', '350600', '龙文区', '0', '0', '', '2', '1', null),
('350622', '350600', '云霄县', '0', '0', '', '2', '1', null),
('350623', '350600', '漳浦县', '0', '0', '', '2', '1', null),
('350624', '350600', '诏安县', '0', '0', '', '2', '1', null),
('350625', '350600', '长泰县', '0', '0', '', '2', '1', null),
('350626', '350600', '东山县', '0', '0', '', '2', '1', null),
('350627', '350600', '南靖县', '0', '0', '', '2', '1', null),
('350628', '350600', '平和县', '0', '0', '', '2', '1', null),
('350629', '350600', '华安县', '0', '0', '', '2', '1', null),
('350681', '350600', '龙海市', '0', '0', '', '2', '1', null),
('350700', '350000', '南平市', '0', '0', 'N', '1', '1', null),
('350702', '350700', '延平区', '0', '0', '', '2', '1', null),
('350703', '350700', '建阳区', '0', '0', '', '2', '1', null),
('350721', '350700', '顺昌县', '0', '0', '', '2', '1', null),
('350722', '350700', '浦城县', '0', '0', '', '2', '1', null),
('350723', '350700', '光泽县', '0', '0', '', '2', '1', null),
('350724', '350700', '松溪县', '0', '0', '', '2', '1', null),
('350725', '350700', '政和县', '0', '0', '', '2', '1', null),
('350781', '350700', '邵武市', '0', '0', '', '2', '1', null),
('350782', '350700', '武夷山市', '0', '0', '', '2', '1', null),
('350783', '350700', '建瓯市', '0', '0', '', '2', '1', null),
('350800', '350000', '龙岩市', '0', '0', 'L', '1', '1', null);
INSERT INTO `wst_areas` VALUES ('350802', '350800', '新罗区', '0', '0', '', '2', '1', null),
('350803', '350800', '永定区', '0', '0', '', '2', '1', null),
('350821', '350800', '长汀县', '0', '0', '', '2', '1', null),
('350823', '350800', '上杭县', '0', '0', '', '2', '1', null),
('350824', '350800', '武平县', '0', '0', '', '2', '1', null),
('350825', '350800', '连城县', '0', '0', '', '2', '1', null),
('350881', '350800', '漳平市', '0', '0', '', '2', '1', null),
('350900', '350000', '宁德市', '0', '0', 'L', '1', '1', null),
('350902', '350900', '蕉城区', '0', '0', '', '2', '1', null),
('350921', '350900', '霞浦县', '0', '0', '', '2', '1', null),
('350922', '350900', '古田县', '0', '0', '', '2', '1', null),
('350923', '350900', '屏南县', '0', '0', '', '2', '1', null),
('350924', '350900', '寿宁县', '0', '0', '', '2', '1', null),
('350925', '350900', '周宁县', '0', '0', '', '2', '1', null),
('350926', '350900', '柘荣县', '0', '0', '', '2', '1', null),
('350981', '350900', '福安市', '0', '0', '', '2', '1', null),
('350982', '350900', '福鼎市', '0', '0', '', '2', '1', null),
('360000', '0', '江西省', '1', '0', '', '0', '1', null),
('360100', '360000', '南昌市', '1', '0', 'N', '1', '1', null),
('360102', '360100', '东湖区', '1', '0', '', '2', '1', null),
('360103', '360100', '西湖区', '1', '0', '', '2', '1', null),
('360104', '360100', '青云谱区', '1', '0', '', '2', '1', null),
('360105', '360100', '湾里区', '1', '0', '', '2', '1', null),
('360111', '360100', '青山湖区', '1', '0', '', '2', '1', null),
('360121', '360100', '南昌县', '1', '0', '', '2', '1', null),
('360122', '360100', '新建县', '1', '0', '', '2', '1', null),
('360123', '360100', '安义县', '1', '0', '', '2', '1', null),
('360124', '360100', '进贤县', '1', '0', '', '2', '1', null),
('360200', '360000', '景德镇市', '1', '0', 'J', '1', '1', null),
('360202', '360200', '昌江区', '1', '0', '', '2', '1', null),
('360203', '360200', '珠山区', '1', '0', '', '2', '1', null),
('360222', '360200', '浮梁县', '1', '0', '', '2', '1', null),
('360281', '360200', '乐平市', '1', '0', '', '2', '1', null),
('360300', '360000', '萍乡市', '1', '0', 'P', '1', '1', null),
('360302', '360300', '安源区', '1', '0', '', '2', '1', null),
('360313', '360300', '湘东区', '1', '0', '', '2', '1', null),
('360321', '360300', '莲花县', '1', '0', '', '2', '1', null),
('360322', '360300', '上栗县', '1', '0', '', '2', '1', null),
('360323', '360300', '芦溪县', '1', '0', '', '2', '1', null),
('360400', '360000', '九江市', '1', '0', 'J', '1', '1', null),
('360402', '360400', '庐山区', '1', '0', '', '2', '1', null),
('360403', '360400', '浔阳区', '1', '0', '', '2', '1', null),
('360421', '360400', '九江县', '1', '0', '', '2', '1', null),
('360423', '360400', '武宁县', '1', '0', '', '2', '1', null),
('360424', '360400', '修水县', '1', '0', '', '2', '1', null),
('360425', '360400', '永修县', '1', '0', '', '2', '1', null),
('360426', '360400', '德安县', '1', '0', '', '2', '1', null),
('360427', '360400', '星子县', '1', '0', '', '2', '1', null),
('360428', '360400', '都昌县', '1', '0', '', '2', '1', null),
('360429', '360400', '湖口县', '1', '0', '', '2', '1', null),
('360430', '360400', '彭泽县', '1', '0', '', '2', '1', null),
('360481', '360400', '瑞昌市', '1', '0', '', '2', '1', null),
('360482', '360400', '共青城市', '1', '0', '', '2', '1', null),
('360500', '360000', '新余市', '1', '0', 'X', '1', '1', null),
('360502', '360500', '渝水区', '1', '0', '', '2', '1', null),
('360521', '360500', '分宜县', '1', '0', '', '2', '1', null),
('360600', '360000', '鹰潭市', '1', '0', 'Y', '1', '1', null),
('360602', '360600', '月湖区', '1', '0', '', '2', '1', null),
('360622', '360600', '余江县', '1', '0', '', '2', '1', null),
('360681', '360600', '贵溪市', '1', '0', '', '2', '1', null),
('360700', '360000', '赣州市', '1', '0', 'G', '1', '1', null),
('360702', '360700', '章贡区', '1', '0', '', '2', '1', null),
('360703', '360700', '南康区', '1', '0', '', '2', '1', null),
('360721', '360700', '赣县', '1', '0', '', '2', '1', null),
('360722', '360700', '信丰县', '1', '0', '', '2', '1', null),
('360723', '360700', '大余县', '1', '0', '', '2', '1', null),
('360724', '360700', '上犹县', '1', '0', '', '2', '1', null),
('360725', '360700', '崇义县', '1', '0', '', '2', '1', null),
('360726', '360700', '安远县', '1', '0', '', '2', '1', null),
('360727', '360700', '龙南县', '1', '0', '', '2', '1', null),
('360728', '360700', '定南县', '1', '0', '', '2', '1', null),
('360729', '360700', '全南县', '1', '0', '', '2', '1', null),
('360730', '360700', '宁都县', '1', '0', '', '2', '1', null),
('360731', '360700', '于都县', '1', '0', '', '2', '1', null),
('360732', '360700', '兴国县', '1', '0', '', '2', '1', null),
('360733', '360700', '会昌县', '1', '0', '', '2', '1', null),
('360734', '360700', '寻乌县', '1', '0', '', '2', '1', null),
('360735', '360700', '石城县', '1', '0', '', '2', '1', null),
('360781', '360700', '瑞金市', '1', '0', '', '2', '1', null),
('360800', '360000', '吉安市', '1', '0', 'J', '1', '1', null),
('360802', '360800', '吉州区', '1', '0', '', '2', '1', null),
('360803', '360800', '青原区', '1', '0', '', '2', '1', null),
('360821', '360800', '吉安县', '1', '0', '', '2', '1', null),
('360822', '360800', '吉水县', '1', '0', '', '2', '1', null),
('360823', '360800', '峡江县', '1', '0', '', '2', '1', null),
('360824', '360800', '新干县', '1', '0', '', '2', '1', null),
('360825', '360800', '永丰县', '1', '0', '', '2', '1', null),
('360826', '360800', '泰和县', '1', '0', '', '2', '1', null),
('360827', '360800', '遂川县', '1', '0', '', '2', '1', null),
('360828', '360800', '万安县', '1', '0', '', '2', '1', null),
('360829', '360800', '安福县', '1', '0', '', '2', '1', null),
('360830', '360800', '永新县', '1', '0', '', '2', '1', null),
('360881', '360800', '井冈山市', '1', '0', '', '2', '1', null),
('360900', '360000', '宜春市', '1', '0', 'Y', '1', '1', null),
('360902', '360900', '袁州区', '1', '0', '', '2', '1', null),
('360921', '360900', '奉新县', '1', '0', '', '2', '1', null),
('360922', '360900', '万载县', '1', '0', '', '2', '1', null),
('360923', '360900', '上高县', '1', '0', '', '2', '1', null),
('360924', '360900', '宜丰县', '1', '0', '', '2', '1', null),
('360925', '360900', '靖安县', '1', '0', '', '2', '1', null),
('360926', '360900', '铜鼓县', '1', '0', '', '2', '1', null),
('360981', '360900', '丰城市', '1', '0', '', '2', '1', null),
('360982', '360900', '樟树市', '1', '0', '', '2', '1', null),
('360983', '360900', '高安市', '1', '0', '', '2', '1', null),
('361000', '360000', '抚州市', '1', '0', 'F', '1', '1', null),
('361002', '361000', '临川区', '1', '0', '', '2', '1', null),
('361021', '361000', '南城县', '1', '0', '', '2', '1', null),
('361022', '361000', '黎川县', '1', '0', '', '2', '1', null),
('361023', '361000', '南丰县', '1', '0', '', '2', '1', null),
('361024', '361000', '崇仁县', '1', '0', '', '2', '1', null),
('361025', '361000', '乐安县', '1', '0', '', '2', '1', null),
('361026', '361000', '宜黄县', '1', '0', '', '2', '1', null),
('361027', '361000', '金溪县', '1', '0', '', '2', '1', null),
('361028', '361000', '资溪县', '1', '0', '', '2', '1', null),
('361029', '361000', '东乡县', '1', '0', '', '2', '1', null),
('361030', '361000', '广昌县', '1', '0', '', '2', '1', null),
('361100', '360000', '上饶市', '1', '0', 'S', '1', '1', null),
('361102', '361100', '信州区', '1', '0', '', '2', '1', null),
('361103', '361100', '广丰区', '1', '0', '', '2', '1', null),
('361121', '361100', '上饶县', '1', '0', '', '2', '1', null),
('361123', '361100', '玉山县', '1', '0', '', '2', '1', null),
('361124', '361100', '铅山县', '1', '0', '', '2', '1', null),
('361125', '361100', '横峰县', '1', '0', '', '2', '1', null),
('361126', '361100', '弋阳县', '1', '0', '', '2', '1', null),
('361127', '361100', '余干县', '1', '0', '', '2', '1', null),
('361128', '361100', '鄱阳县', '1', '0', '', '2', '1', null),
('361129', '361100', '万年县', '1', '0', '', '2', '1', null),
('361130', '361100', '婺源县', '1', '0', '', '2', '1', null),
('361181', '361100', '德兴市', '1', '0', '', '2', '1', null),
('370000', '0', '山东省', '0', '0', '', '0', '1', null),
('370100', '370000', '济南市', '0', '0', 'J', '1', '1', null),
('370102', '370100', '历下区', '0', '0', '', '2', '1', null),
('370103', '370100', '市中区', '0', '0', '', '2', '1', null),
('370104', '370100', '槐荫区', '0', '0', '', '2', '1', null),
('370105', '370100', '天桥区', '0', '0', '', '2', '1', null),
('370112', '370100', '历城区', '0', '0', '', '2', '1', null),
('370113', '370100', '长清区', '0', '0', '', '2', '1', null),
('370124', '370100', '平阴县', '0', '0', '', '2', '1', null),
('370125', '370100', '济阳县', '0', '0', '', '2', '1', null),
('370126', '370100', '商河县', '0', '0', '', '2', '1', null),
('370181', '370100', '章丘市', '0', '0', '', '2', '1', null),
('370200', '370000', '青岛市', '0', '0', 'Q', '1', '1', null),
('370202', '370200', '市南区', '0', '0', '', '2', '1', null),
('370203', '370200', '市北区', '0', '0', '', '2', '1', null),
('370211', '370200', '黄岛区', '0', '0', '', '2', '1', null),
('370212', '370200', '崂山区', '0', '0', '', '2', '1', null),
('370213', '370200', '李沧区', '0', '0', '', '2', '1', null),
('370214', '370200', '城阳区', '0', '0', '', '2', '1', null),
('370281', '370200', '胶州市', '0', '0', '', '2', '1', null),
('370282', '370200', '即墨市', '0', '0', '', '2', '1', null),
('370283', '370200', '平度市', '0', '0', '', '2', '1', null),
('370285', '370200', '莱西市', '0', '0', '', '2', '1', null),
('370300', '370000', '淄博市', '0', '0', 'Z', '1', '1', null),
('370302', '370300', '淄川区', '0', '0', '', '2', '1', null),
('370303', '370300', '张店区', '0', '0', '', '2', '1', null),
('370304', '370300', '博山区', '0', '0', '', '2', '1', null),
('370305', '370300', '临淄区', '0', '0', '', '2', '1', null),
('370306', '370300', '周村区', '0', '0', '', '2', '1', null),
('370321', '370300', '桓台县', '0', '0', '', '2', '1', null),
('370322', '370300', '高青县', '0', '0', '', '2', '1', null),
('370323', '370300', '沂源县', '0', '0', '', '2', '1', null),
('370400', '370000', '枣庄市', '0', '0', 'Z', '1', '1', null),
('370402', '370400', '市中区', '0', '0', '', '2', '1', null),
('370403', '370400', '薛城区', '0', '0', '', '2', '1', null),
('370404', '370400', '峄城区', '0', '0', '', '2', '1', null),
('370405', '370400', '台儿庄区', '0', '0', '', '2', '1', null),
('370406', '370400', '山亭区', '0', '0', '', '2', '1', null),
('370481', '370400', '滕州市', '0', '0', '', '2', '1', null),
('370500', '370000', '东营市', '0', '0', 'D', '1', '1', null),
('370502', '370500', '东营区', '0', '0', '', '2', '1', null),
('370503', '370500', '河口区', '0', '0', '', '2', '1', null),
('370521', '370500', '垦利县', '0', '0', '', '2', '1', null),
('370522', '370500', '利津县', '0', '0', '', '2', '1', null),
('370523', '370500', '广饶县', '0', '0', '', '2', '1', null),
('370600', '370000', '烟台市', '0', '0', 'Y', '1', '1', null),
('370602', '370600', '芝罘区', '0', '0', '', '2', '1', null),
('370611', '370600', '福山区', '0', '0', '', '2', '1', null),
('370612', '370600', '牟平区', '0', '0', '', '2', '1', null),
('370613', '370600', '莱山区', '0', '0', '', '2', '1', null),
('370634', '370600', '长岛县', '0', '0', '', '2', '1', null),
('370681', '370600', '龙口市', '0', '0', '', '2', '1', null),
('370682', '370600', '莱阳市', '0', '0', '', '2', '1', null),
('370683', '370600', '莱州市', '0', '0', '', '2', '1', null),
('370684', '370600', '蓬莱市', '0', '0', '', '2', '1', null),
('370685', '370600', '招远市', '0', '0', '', '2', '1', null),
('370686', '370600', '栖霞市', '0', '0', '', '2', '1', null),
('370687', '370600', '海阳市', '0', '0', '', '2', '1', null),
('370700', '370000', '潍坊市', '0', '0', 'W', '1', '1', null),
('370702', '370700', '潍城区', '0', '0', '', '2', '1', null),
('370703', '370700', '寒亭区', '0', '0', '', '2', '1', null),
('370704', '370700', '坊子区', '0', '0', '', '2', '1', null),
('370705', '370700', '奎文区', '0', '0', '', '2', '1', null),
('370724', '370700', '临朐县', '0', '0', '', '2', '1', null),
('370725', '370700', '昌乐县', '0', '0', '', '2', '1', null),
('370781', '370700', '青州市', '0', '0', '', '2', '1', null),
('370782', '370700', '诸城市', '0', '0', '', '2', '1', null),
('370783', '370700', '寿光市', '0', '0', '', '2', '1', null),
('370784', '370700', '安丘市', '0', '0', '', '2', '1', null),
('370785', '370700', '高密市', '0', '0', '', '2', '1', null),
('370786', '370700', '昌邑市', '0', '0', '', '2', '1', null),
('370800', '370000', '济宁市', '0', '0', 'J', '1', '1', null),
('370811', '370800', '任城区', '0', '0', '', '2', '1', null),
('370812', '370800', '兖州区', '0', '0', '', '2', '1', null),
('370826', '370800', '微山县', '0', '0', '', '2', '1', null),
('370827', '370800', '鱼台县', '0', '0', '', '2', '1', null),
('370828', '370800', '金乡县', '0', '0', '', '2', '1', null),
('370829', '370800', '嘉祥县', '0', '0', '', '2', '1', null),
('370830', '370800', '汶上县', '0', '0', '', '2', '1', null),
('370831', '370800', '泗水县', '0', '0', '', '2', '1', null),
('370832', '370800', '梁山县', '0', '0', '', '2', '1', null),
('370881', '370800', '曲阜市', '0', '0', '', '2', '1', null),
('370883', '370800', '邹城市', '0', '0', '', '2', '1', null),
('370900', '370000', '泰安市', '0', '0', 'T', '1', '1', null),
('370902', '370900', '泰山区', '0', '0', '', '2', '1', null),
('370911', '370900', '岱岳区', '0', '0', '', '2', '1', null),
('370921', '370900', '宁阳县', '0', '0', '', '2', '1', null),
('370923', '370900', '东平县', '0', '0', '', '2', '1', null),
('370982', '370900', '新泰市', '0', '0', '', '2', '1', null),
('370983', '370900', '肥城市', '0', '0', '', '2', '1', null),
('371000', '370000', '威海市', '0', '0', 'W', '1', '1', null),
('371002', '371000', '环翠区', '0', '0', '', '2', '1', null),
('371081', '371000', '文登市', '0', '0', '', '2', '1', null),
('371082', '371000', '荣成市', '0', '0', '', '2', '1', null),
('371083', '371000', '乳山市', '0', '0', '', '2', '1', null),
('371100', '370000', '日照市', '0', '0', 'R', '1', '1', null),
('371102', '371100', '东港区', '0', '0', '', '2', '1', null),
('371103', '371100', '岚山区', '0', '0', '', '2', '1', null),
('371121', '371100', '五莲县', '0', '0', '', '2', '1', null),
('371122', '371100', '莒县', '0', '0', '', '2', '1', null),
('371200', '370000', '莱芜市', '0', '0', 'C', '1', '1', null),
('371202', '371200', '莱城区', '0', '0', '', '2', '1', null),
('371203', '371200', '钢城区', '0', '0', '', '2', '1', null),
('371300', '370000', '临沂市', '0', '0', 'L', '1', '1', null),
('371302', '371300', '兰山区', '0', '0', '', '2', '1', null),
('371311', '371300', '罗庄区', '0', '0', '', '2', '1', null),
('371312', '371300', '河东区', '0', '0', '', '2', '1', null),
('371321', '371300', '沂南县', '0', '0', '', '2', '1', null),
('371322', '371300', '郯城县', '0', '0', '', '2', '1', null),
('371323', '371300', '沂水县', '0', '0', '', '2', '1', null),
('371324', '371300', '兰陵县', '0', '0', '', '2', '1', null),
('371325', '371300', '费县', '0', '0', '', '2', '1', null),
('371326', '371300', '平邑县', '0', '0', '', '2', '1', null),
('371327', '371300', '莒南县', '0', '0', '', '2', '1', null),
('371328', '371300', '蒙阴县', '0', '0', '', '2', '1', null),
('371329', '371300', '临沭县', '0', '0', '', '2', '1', null),
('371400', '370000', '德州市', '0', '0', 'D', '1', '1', null),
('371402', '371400', '德城区', '0', '0', '', '2', '1', null),
('371403', '371400', '陵城区', '0', '0', '', '2', '1', null),
('371422', '371400', '宁津县', '0', '0', '', '2', '1', null),
('371423', '371400', '庆云县', '0', '0', '', '2', '1', null),
('371424', '371400', '临邑县', '0', '0', '', '2', '1', null),
('371425', '371400', '齐河县', '0', '0', '', '2', '1', null),
('371426', '371400', '平原县', '0', '0', '', '2', '1', null),
('371427', '371400', '夏津县', '0', '0', '', '2', '1', null),
('371428', '371400', '武城县', '0', '0', '', '2', '1', null),
('371481', '371400', '乐陵市', '0', '0', '', '2', '1', null),
('371482', '371400', '禹城市', '0', '0', '', '2', '1', null),
('371500', '370000', '聊城市', '0', '0', 'L', '1', '1', null),
('371502', '371500', '东昌府区', '0', '0', '', '2', '1', null),
('371521', '371500', '阳谷县', '0', '0', '', '2', '1', null),
('371522', '371500', '莘县', '0', '0', '', '2', '1', null),
('371523', '371500', '茌平县', '0', '0', '', '2', '1', null),
('371524', '371500', '东阿县', '0', '0', '', '2', '1', null),
('371525', '371500', '冠县', '0', '0', '', '2', '1', null),
('371526', '371500', '高唐县', '0', '0', '', '2', '1', null),
('371581', '371500', '临清市', '0', '0', '', '2', '1', null),
('371600', '370000', '滨州市', '0', '0', 'B', '1', '1', null),
('371602', '371600', '滨城区', '0', '0', '', '2', '1', null),
('371603', '371600', '沾化区', '0', '0', '', '2', '1', null),
('371621', '371600', '惠民县', '0', '0', '', '2', '1', null),
('371622', '371600', '阳信县', '0', '0', '', '2', '1', null),
('371623', '371600', '无棣县', '0', '0', '', '2', '1', null),
('371625', '371600', '博兴县', '0', '0', '', '2', '1', null),
('371626', '371600', '邹平县', '0', '0', '', '2', '1', null),
('371700', '370000', '菏泽市', '0', '0', 'H', '1', '1', null),
('371702', '371700', '牡丹区', '0', '0', '', '2', '1', null),
('371721', '371700', '曹县', '0', '0', '', '2', '1', null),
('371722', '371700', '单县', '0', '0', '', '2', '1', null),
('371723', '371700', '成武县', '0', '0', '', '2', '1', null),
('371724', '371700', '巨野县', '0', '0', '', '2', '1', null),
('371725', '371700', '郓城县', '0', '0', '', '2', '1', null),
('371726', '371700', '鄄城县', '0', '0', '', '2', '1', null),
('371727', '371700', '定陶县', '0', '0', '', '2', '1', null),
('371728', '371700', '东明县', '0', '0', '', '2', '1', null),
('410000', '0', '河南省', '0', '0', '', '0', '1', null),
('410100', '410000', '郑州市', '0', '0', 'Z', '1', '1', null),
('410102', '410100', '中原区', '0', '0', '', '2', '1', null),
('410103', '410100', '二七区', '0', '0', '', '2', '1', null),
('410104', '410100', '管城回族区', '0', '0', '', '2', '1', null),
('410105', '410100', '金水区', '0', '0', '', '2', '1', null),
('410106', '410100', '上街区', '0', '0', '', '2', '1', null),
('410108', '410100', '惠济区', '0', '0', '', '2', '1', null),
('410122', '410100', '中牟县', '0', '0', '', '2', '1', null),
('410181', '410100', '巩义市', '0', '0', '', '2', '1', null),
('410182', '410100', '荥阳市', '0', '0', '', '2', '1', null),
('410183', '410100', '新密市', '0', '0', '', '2', '1', null),
('410184', '410100', '新郑市', '0', '0', '', '2', '1', null),
('410185', '410100', '登封市', '0', '0', '', '2', '1', null),
('410200', '410000', '开封市', '0', '0', 'K', '1', '1', null),
('410202', '410200', '龙亭区', '0', '0', '', '2', '1', null),
('410203', '410200', '顺河回族区', '0', '0', '', '2', '1', null),
('410204', '410200', '鼓楼区', '0', '0', '', '2', '1', null),
('410205', '410200', '禹王台区', '0', '0', '', '2', '1', null),
('410212', '410200', '祥符区', '0', '0', '', '2', '1', null),
('410221', '410200', '杞县', '0', '0', '', '2', '1', null),
('410222', '410200', '通许县', '0', '0', '', '2', '1', null),
('410223', '410200', '尉氏县', '0', '0', '', '2', '1', null),
('410225', '410200', '兰考县', '0', '0', '', '2', '1', null),
('410300', '410000', '洛阳市', '0', '0', 'L', '1', '1', null),
('410302', '410300', '老城区', '0', '0', '', '2', '1', null),
('410303', '410300', '西工区', '0', '0', '', '2', '1', null),
('410304', '410300', '瀍河回族区', '0', '0', '', '2', '1', null),
('410305', '410300', '涧西区', '0', '0', '', '2', '1', null),
('410306', '410300', '吉利区', '0', '0', '', '2', '1', null),
('410311', '410300', '洛龙区', '0', '0', '', '2', '1', null),
('410322', '410300', '孟津县', '0', '0', '', '2', '1', null),
('410323', '410300', '新安县', '0', '0', '', '2', '1', null),
('410324', '410300', '栾川县', '0', '0', '', '2', '1', null),
('410325', '410300', '嵩县', '0', '0', '', '2', '1', null),
('410326', '410300', '汝阳县', '0', '0', '', '2', '1', null),
('410327', '410300', '宜阳县', '0', '0', '', '2', '1', null),
('410328', '410300', '洛宁县', '0', '0', '', '2', '1', null),
('410329', '410300', '伊川县', '0', '0', '', '2', '1', null),
('410381', '410300', '偃师市', '0', '0', '', '2', '1', null),
('410400', '410000', '平顶山市', '0', '0', 'P', '1', '1', null),
('410402', '410400', '新华区', '0', '0', '', '2', '1', null),
('410403', '410400', '卫东区', '0', '0', '', '2', '1', null),
('410404', '410400', '石龙区', '0', '0', '', '2', '1', null),
('410411', '410400', '湛河区', '0', '0', '', '2', '1', null),
('410421', '410400', '宝丰县', '0', '0', '', '2', '1', null),
('410422', '410400', '叶县', '0', '0', '', '2', '1', null),
('410423', '410400', '鲁山县', '0', '0', '', '2', '1', null),
('410425', '410400', '郏县', '0', '0', '', '2', '1', null),
('410481', '410400', '舞钢市', '0', '0', '', '2', '1', null),
('410482', '410400', '汝州市', '0', '0', '', '2', '1', null),
('410500', '410000', '安阳市', '0', '0', 'A', '1', '1', null),
('410502', '410500', '文峰区', '0', '0', '', '2', '1', null),
('410503', '410500', '北关区', '0', '0', '', '2', '1', null),
('410505', '410500', '殷都区', '0', '0', '', '2', '1', null),
('410506', '410500', '龙安区', '0', '0', '', '2', '1', null),
('410522', '410500', '安阳县', '0', '0', '', '2', '1', null),
('410523', '410500', '汤阴县', '0', '0', '', '2', '1', null),
('410526', '410500', '滑县', '0', '0', '', '2', '1', null),
('410527', '410500', '内黄县', '0', '0', '', '2', '1', null),
('410581', '410500', '林州市', '0', '0', '', '2', '1', null),
('410600', '410000', '鹤壁市', '0', '0', 'H', '1', '1', null),
('410602', '410600', '鹤山区', '0', '0', '', '2', '1', null),
('410603', '410600', '山城区', '0', '0', '', '2', '1', null),
('410611', '410600', '淇滨区', '0', '0', '', '2', '1', null),
('410621', '410600', '浚县', '0', '0', '', '2', '1', null),
('410622', '410600', '淇县', '0', '0', '', '2', '1', null),
('410700', '410000', '新乡市', '0', '0', 'X', '1', '1', null),
('410702', '410700', '红旗区', '0', '0', '', '2', '1', null),
('410703', '410700', '卫滨区', '0', '0', '', '2', '1', null),
('410704', '410700', '凤泉区', '0', '0', '', '2', '1', null),
('410711', '410700', '牧野区', '0', '0', '', '2', '1', null),
('410721', '410700', '新乡县', '0', '0', '', '2', '1', null),
('410724', '410700', '获嘉县', '0', '0', '', '2', '1', null),
('410725', '410700', '原阳县', '0', '0', '', '2', '1', null),
('410726', '410700', '延津县', '0', '0', '', '2', '1', null),
('410727', '410700', '封丘县', '0', '0', '', '2', '1', null),
('410728', '410700', '长垣县', '0', '0', '', '2', '1', null),
('410781', '410700', '卫辉市', '0', '0', '', '2', '1', null),
('410782', '410700', '辉县市', '0', '0', '', '2', '1', null),
('410800', '410000', '焦作市', '0', '0', 'J', '1', '1', null),
('410802', '410800', '解放区', '0', '0', '', '2', '1', null),
('410803', '410800', '中站区', '0', '0', '', '2', '1', null),
('410804', '410800', '马村区', '0', '0', '', '2', '1', null),
('410811', '410800', '山阳区', '0', '0', '', '2', '1', null),
('410821', '410800', '修武县', '0', '0', '', '2', '1', null),
('410822', '410800', '博爱县', '0', '0', '', '2', '1', null),
('410823', '410800', '武陟县', '0', '0', '', '2', '1', null),
('410825', '410800', '温县', '0', '0', '', '2', '1', null),
('410882', '410800', '沁阳市', '0', '0', '', '2', '1', null),
('410883', '410800', '孟州市', '0', '0', '', '2', '1', null),
('410900', '410000', '濮阳市', '0', '0', 'P', '1', '1', null),
('410902', '410900', '华龙区', '0', '0', '', '2', '1', null),
('410922', '410900', '清丰县', '0', '0', '', '2', '1', null),
('410923', '410900', '南乐县', '0', '0', '', '2', '1', null),
('410926', '410900', '范县', '0', '0', '', '2', '1', null),
('410927', '410900', '台前县', '0', '0', '', '2', '1', null),
('410928', '410900', '濮阳县', '0', '0', '', '2', '1', null),
('411000', '410000', '许昌市', '0', '0', 'X', '1', '1', null),
('411002', '411000', '魏都区', '0', '0', '', '2', '1', null),
('411023', '411000', '许昌县', '0', '0', '', '2', '1', null),
('411024', '411000', '鄢陵县', '0', '0', '', '2', '1', null),
('411025', '411000', '襄城县', '0', '0', '', '2', '1', null),
('411081', '411000', '禹州市', '0', '0', '', '2', '1', null),
('411082', '411000', '长葛市', '0', '0', '', '2', '1', null),
('411100', '410000', '漯河市', '0', '0', 'L', '1', '1', null),
('411102', '411100', '源汇区', '0', '0', '', '2', '1', null),
('411103', '411100', '郾城区', '0', '0', '', '2', '1', null),
('411104', '411100', '召陵区', '0', '0', '', '2', '1', null),
('411121', '411100', '舞阳县', '0', '0', '', '2', '1', null),
('411122', '411100', '临颍县', '0', '0', '', '2', '1', null),
('411200', '410000', '三门峡市', '0', '0', 'S', '1', '1', null),
('411202', '411200', '湖滨区', '0', '0', '', '2', '1', null),
('411203', '411200', '陕州区', '0', '0', '', '2', '1', null),
('411221', '411200', '渑池县', '0', '0', '', '2', '1', null),
('411224', '411200', '卢氏县', '0', '0', '', '2', '1', null),
('411281', '411200', '义马市', '0', '0', '', '2', '1', null),
('411282', '411200', '灵宝市', '0', '0', '', '2', '1', null),
('411300', '410000', '南阳市', '0', '0', 'N', '1', '1', null),
('411302', '411300', '宛城区', '0', '0', '', '2', '1', null),
('411303', '411300', '卧龙区', '0', '0', '', '2', '1', null),
('411321', '411300', '南召县', '0', '0', '', '2', '1', null),
('411322', '411300', '方城县', '0', '0', '', '2', '1', null),
('411323', '411300', '西峡县', '0', '0', '', '2', '1', null),
('411324', '411300', '镇平县', '0', '0', '', '2', '1', null),
('411325', '411300', '内乡县', '0', '0', '', '2', '1', null),
('411326', '411300', '淅川县', '0', '0', '', '2', '1', null),
('411327', '411300', '社旗县', '0', '0', '', '2', '1', null),
('411328', '411300', '唐河县', '0', '0', '', '2', '1', null),
('411329', '411300', '新野县', '0', '0', '', '2', '1', null),
('411330', '411300', '桐柏县', '0', '0', '', '2', '1', null),
('411381', '411300', '邓州市', '0', '0', '', '2', '1', null),
('411400', '410000', '商丘市', '0', '0', 'N', '1', '1', null),
('411402', '411400', '梁园区', '0', '0', '', '2', '1', null),
('411403', '411400', '睢阳区', '0', '0', '', '2', '1', null),
('411421', '411400', '民权县', '0', '0', '', '2', '1', null),
('411422', '411400', '睢县', '0', '0', '', '2', '1', null),
('411423', '411400', '宁陵县', '0', '0', '', '2', '1', null),
('411424', '411400', '柘城县', '0', '0', '', '2', '1', null),
('411425', '411400', '虞城县', '0', '0', '', '2', '1', null),
('411426', '411400', '夏邑县', '0', '0', '', '2', '1', null),
('411481', '411400', '永城市', '0', '0', '', '2', '1', null),
('411500', '410000', '信阳市', '0', '0', 'X', '1', '1', null),
('411502', '411500', '浉河区', '0', '0', '', '2', '1', null),
('411503', '411500', '平桥区', '0', '0', '', '2', '1', null),
('411521', '411500', '罗山县', '0', '0', '', '2', '1', null),
('411522', '411500', '光山县', '0', '0', '', '2', '1', null),
('411523', '411500', '新县', '0', '0', '', '2', '1', null),
('411524', '411500', '商城县', '0', '0', '', '2', '1', null),
('411525', '411500', '固始县', '0', '0', '', '2', '1', null),
('411526', '411500', '潢川县', '0', '0', '', '2', '1', null),
('411527', '411500', '淮滨县', '0', '0', '', '2', '1', null),
('411528', '411500', '息县', '0', '0', '', '2', '1', null),
('411600', '410000', '周口市', '0', '0', 'Z', '1', '1', null),
('411602', '411600', '川汇区', '0', '0', '', '2', '1', null),
('411621', '411600', '扶沟县', '0', '0', '', '2', '1', null),
('411622', '411600', '西华县', '0', '0', '', '2', '1', null),
('411623', '411600', '商水县', '0', '0', '', '2', '1', null),
('411624', '411600', '沈丘县', '0', '0', '', '2', '1', null),
('411625', '411600', '郸城县', '0', '0', '', '2', '1', null),
('411626', '411600', '淮阳县', '0', '0', '', '2', '1', null),
('411627', '411600', '太康县', '0', '0', '', '2', '1', null),
('411628', '411600', '鹿邑县', '0', '0', '', '2', '1', null),
('411681', '411600', '项城市', '0', '0', '', '2', '1', null),
('411700', '410000', '驻马店市', '0', '0', 'Z', '1', '1', null),
('411702', '411700', '驿城区', '0', '0', '', '2', '1', null),
('411721', '411700', '西平县', '0', '0', '', '2', '1', null),
('411722', '411700', '上蔡县', '0', '0', '', '2', '1', null),
('411723', '411700', '平舆县', '0', '0', '', '2', '1', null),
('411724', '411700', '正阳县', '0', '0', '', '2', '1', null),
('411725', '411700', '确山县', '0', '0', '', '2', '1', null),
('411726', '411700', '泌阳县', '0', '0', '', '2', '1', null),
('411727', '411700', '汝南县', '0', '0', '', '2', '1', null),
('411728', '411700', '遂平县', '0', '0', '', '2', '1', null),
('411729', '411700', '新蔡县', '0', '0', '', '2', '1', null),
('419000', '410000', '省直辖县级行政区划', '0', '0', 'S', '1', '1', null),
('419001', '419000', '济源市', '0', '0', '', '2', '1', null),
('420000', '0', '湖北省', '0', '0', '', '0', '1', null),
('420100', '420000', '武汉市', '0', '0', 'W', '1', '1', null),
('420102', '420100', '江岸区', '0', '0', '', '2', '1', null),
('420103', '420100', '江汉区', '0', '0', '', '2', '1', null),
('420104', '420100', '硚口区', '0', '0', '', '2', '1', null),
('420105', '420100', '汉阳区', '0', '0', '', '2', '1', null),
('420106', '420100', '武昌区', '0', '0', '', '2', '1', null),
('420107', '420100', '青山区', '0', '0', '', '2', '1', null),
('420111', '420100', '洪山区', '0', '0', '', '2', '1', null),
('420112', '420100', '东西湖区', '0', '0', '', '2', '1', null),
('420113', '420100', '汉南区', '0', '0', '', '2', '1', null),
('420114', '420100', '蔡甸区', '0', '0', '', '2', '1', null),
('420115', '420100', '江夏区', '0', '0', '', '2', '1', null),
('420116', '420100', '黄陂区', '0', '0', '', '2', '1', null),
('420117', '420100', '新洲区', '0', '0', '', '2', '1', null),
('420200', '420000', '黄石市', '0', '0', 'H', '1', '1', null),
('420202', '420200', '黄石港区', '0', '0', '', '2', '1', null),
('420203', '420200', '西塞山区', '0', '0', '', '2', '1', null),
('420204', '420200', '下陆区', '0', '0', '', '2', '1', null),
('420205', '420200', '铁山区', '0', '0', '', '2', '1', null),
('420222', '420200', '阳新县', '0', '0', '', '2', '1', null),
('420281', '420200', '大冶市', '0', '0', '', '2', '1', null),
('420300', '420000', '十堰市', '0', '0', 'S', '1', '1', null),
('420302', '420300', '茅箭区', '0', '0', '', '2', '1', null),
('420303', '420300', '张湾区', '0', '0', '', '2', '1', null),
('420304', '420300', '郧阳区', '0', '0', '', '2', '1', null),
('420322', '420300', '郧西县', '0', '0', '', '2', '1', null),
('420323', '420300', '竹山县', '0', '0', '', '2', '1', null),
('420324', '420300', '竹溪县', '0', '0', '', '2', '1', null),
('420325', '420300', '房县', '0', '0', '', '2', '1', null),
('420381', '420300', '丹江口市', '0', '0', '', '2', '1', null),
('420500', '420000', '宜昌市', '0', '0', 'Y', '1', '1', null),
('420502', '420500', '西陵区', '0', '0', '', '2', '1', null),
('420503', '420500', '伍家岗区', '0', '0', '', '2', '1', null),
('420504', '420500', '点军区', '0', '0', '', '2', '1', null),
('420505', '420500', '猇亭区', '0', '0', '', '2', '1', null),
('420506', '420500', '夷陵区', '0', '0', '', '2', '1', null),
('420525', '420500', '远安县', '0', '0', '', '2', '1', null),
('420526', '420500', '兴山县', '0', '0', '', '2', '1', null),
('420527', '420500', '秭归县', '0', '0', '', '2', '1', null);
INSERT INTO `wst_areas` VALUES ('420528', '420500', '长阳土家族自治县', '0', '0', '', '2', '1', null),
('420529', '420500', '五峰土家族自治县', '0', '0', '', '2', '1', null),
('420581', '420500', '宜都市', '0', '0', '', '2', '1', null),
('420582', '420500', '当阳市', '0', '0', '', '2', '1', null),
('420583', '420500', '枝江市', '0', '0', '', '2', '1', null),
('420600', '420000', '襄阳市', '0', '0', 'X', '1', '1', null),
('420602', '420600', '襄城区', '0', '0', '', '2', '1', null),
('420606', '420600', '樊城区', '0', '0', '', '2', '1', null),
('420607', '420600', '襄州区', '0', '0', '', '2', '1', null),
('420624', '420600', '南漳县', '0', '0', '', '2', '1', null),
('420625', '420600', '谷城县', '0', '0', '', '2', '1', null),
('420626', '420600', '保康县', '0', '0', '', '2', '1', null),
('420682', '420600', '老河口市', '0', '0', '', '2', '1', null),
('420683', '420600', '枣阳市', '0', '0', '', '2', '1', null),
('420684', '420600', '宜城市', '0', '0', '', '2', '1', null),
('420700', '420000', '鄂州市', '0', '0', 'E', '1', '1', null),
('420702', '420700', '梁子湖区', '0', '0', '', '2', '1', null),
('420703', '420700', '华容区', '0', '0', '', '2', '1', null),
('420704', '420700', '鄂城区', '0', '0', '', '2', '1', null),
('420800', '420000', '荆门市', '0', '0', 'X', '1', '1', null),
('420802', '420800', '东宝区', '0', '0', '', '2', '1', null),
('420804', '420800', '掇刀区', '0', '0', '', '2', '1', null),
('420821', '420800', '京山县', '0', '0', '', '2', '1', null),
('420822', '420800', '沙洋县', '0', '0', '', '2', '1', null),
('420881', '420800', '钟祥市', '0', '0', '', '2', '1', null),
('420900', '420000', '孝感市', '0', '0', 'X', '1', '1', null),
('420902', '420900', '孝南区', '0', '0', '', '2', '1', null),
('420921', '420900', '孝昌县', '0', '0', '', '2', '1', null),
('420922', '420900', '大悟县', '0', '0', '', '2', '1', null),
('420923', '420900', '云梦县', '0', '0', '', '2', '1', null),
('420981', '420900', '应城市', '0', '0', '', '2', '1', null),
('420982', '420900', '安陆市', '0', '0', '', '2', '1', null),
('420984', '420900', '汉川市', '0', '0', '', '2', '1', null),
('421000', '420000', '荆州市', '0', '0', 'X', '1', '1', null),
('421002', '421000', '沙市区', '0', '0', '', '2', '1', null),
('421003', '421000', '荆州区', '0', '0', '', '2', '1', null),
('421022', '421000', '公安县', '0', '0', '', '2', '1', null),
('421023', '421000', '监利县', '0', '0', '', '2', '1', null),
('421024', '421000', '江陵县', '0', '0', '', '2', '1', null),
('421081', '421000', '石首市', '0', '0', '', '2', '1', null),
('421083', '421000', '洪湖市', '0', '0', '', '2', '1', null),
('421087', '421000', '松滋市', '0', '0', '', '2', '1', null),
('421100', '420000', '黄冈市', '0', '0', 'H', '1', '1', null),
('421102', '421100', '黄州区', '0', '0', '', '2', '1', null),
('421121', '421100', '团风县', '0', '0', '', '2', '1', null),
('421122', '421100', '红安县', '0', '0', '', '2', '1', null),
('421123', '421100', '罗田县', '0', '0', '', '2', '1', null),
('421124', '421100', '英山县', '0', '0', '', '2', '1', null),
('421125', '421100', '浠水县', '0', '0', '', '2', '1', null),
('421126', '421100', '蕲春县', '0', '0', '', '2', '1', null),
('421127', '421100', '黄梅县', '0', '0', '', '2', '1', null),
('421181', '421100', '麻城市', '0', '0', '', '2', '1', null),
('421182', '421100', '武穴市', '0', '0', '', '2', '1', null),
('421200', '420000', '咸宁市', '0', '0', 'X', '1', '1', null),
('421202', '421200', '咸安区', '0', '0', '', '2', '1', null),
('421221', '421200', '嘉鱼县', '0', '0', '', '2', '1', null),
('421222', '421200', '通城县', '0', '0', '', '2', '1', null),
('421223', '421200', '崇阳县', '0', '0', '', '2', '1', null),
('421224', '421200', '通山县', '0', '0', '', '2', '1', null),
('421281', '421200', '赤壁市', '0', '0', '', '2', '1', null),
('421300', '420000', '随州市', '0', '0', 'S', '1', '1', null),
('421303', '421300', '曾都区', '0', '0', '', '2', '1', null),
('421321', '421300', '随县', '0', '0', '', '2', '1', null),
('421381', '421300', '广水市', '0', '0', '', '2', '1', null),
('422800', '420000', '恩施土家族苗族自治州', '0', '0', 'E', '1', '1', null),
('422801', '422800', '恩施市', '0', '0', '', '2', '1', null),
('422802', '422800', '利川市', '0', '0', '', '2', '1', null),
('422822', '422800', '建始县', '0', '0', '', '2', '1', null),
('422823', '422800', '巴东县', '0', '0', '', '2', '1', null),
('422825', '422800', '宣恩县', '0', '0', '', '2', '1', null),
('422826', '422800', '咸丰县', '0', '0', '', '2', '1', null),
('422827', '422800', '来凤县', '0', '0', '', '2', '1', null),
('422828', '422800', '鹤峰县', '0', '0', '', '2', '1', null),
('429000', '420000', '省直辖县级行政区划', '0', '0', 'S', '1', '1', null),
('429004', '429000', '仙桃市', '0', '0', '', '2', '1', null),
('429005', '429000', '潜江市', '0', '0', '', '2', '1', null),
('429006', '429000', '天门市', '0', '0', '', '2', '1', null),
('429021', '429000', '神农架林区', '0', '0', '', '2', '1', null),
('430000', '0', '湖南省', '0', '0', '', '0', '1', null),
('430100', '430000', '长沙市', '0', '0', 'C', '1', '1', null),
('430102', '430100', '芙蓉区', '0', '0', '', '2', '1', null),
('430103', '430100', '天心区', '0', '0', '', '2', '1', null),
('430104', '430100', '岳麓区', '0', '0', '', '2', '1', null),
('430105', '430100', '开福区', '0', '0', '', '2', '1', null),
('430111', '430100', '雨花区', '0', '0', '', '2', '1', null),
('430112', '430100', '望城区', '0', '0', '', '2', '1', null),
('430121', '430100', '长沙县', '0', '0', '', '2', '1', null),
('430124', '430100', '宁乡县', '0', '0', '', '2', '1', null),
('430181', '430100', '浏阳市', '0', '0', '', '2', '1', null),
('430200', '430000', '株洲市', '0', '0', 'Z', '1', '1', null),
('430202', '430200', '荷塘区', '0', '0', '', '2', '1', null),
('430203', '430200', '芦淞区', '0', '0', '', '2', '1', null),
('430204', '430200', '石峰区', '0', '0', '', '2', '1', null),
('430211', '430200', '天元区', '0', '0', '', '2', '1', null),
('430221', '430200', '株洲县', '0', '0', '', '2', '1', null),
('430223', '430200', '攸县', '0', '0', '', '2', '1', null),
('430224', '430200', '茶陵县', '0', '0', '', '2', '1', null),
('430225', '430200', '炎陵县', '0', '0', '', '2', '1', null),
('430281', '430200', '醴陵市', '0', '0', '', '2', '1', null),
('430300', '430000', '湘潭市', '0', '0', 'X', '1', '1', null),
('430302', '430300', '雨湖区', '0', '0', '', '2', '1', null),
('430304', '430300', '岳塘区', '0', '0', '', '2', '1', null),
('430321', '430300', '湘潭县', '0', '0', '', '2', '1', null),
('430381', '430300', '湘乡市', '0', '0', '', '2', '1', null),
('430382', '430300', '韶山市', '0', '0', '', '2', '1', null),
('430400', '430000', '衡阳市', '0', '0', 'H', '1', '1', null),
('430405', '430400', '珠晖区', '0', '0', '', '2', '1', null),
('430406', '430400', '雁峰区', '0', '0', '', '2', '1', null),
('430407', '430400', '石鼓区', '0', '0', '', '2', '1', null),
('430408', '430400', '蒸湘区', '0', '0', '', '2', '1', null),
('430412', '430400', '南岳区', '0', '0', '', '2', '1', null),
('430421', '430400', '衡阳县', '0', '0', '', '2', '1', null),
('430422', '430400', '衡南县', '0', '0', '', '2', '1', null),
('430423', '430400', '衡山县', '0', '0', '', '2', '1', null),
('430424', '430400', '衡东县', '0', '0', '', '2', '1', null),
('430426', '430400', '祁东县', '0', '0', '', '2', '1', null),
('430481', '430400', '耒阳市', '0', '0', '', '2', '1', null),
('430482', '430400', '常宁市', '0', '0', '', '2', '1', null),
('430500', '430000', '邵阳市', '0', '0', 'S', '1', '1', null),
('430502', '430500', '双清区', '0', '0', '', '2', '1', null),
('430503', '430500', '大祥区', '0', '0', '', '2', '1', null),
('430511', '430500', '北塔区', '0', '0', '', '2', '1', null),
('430521', '430500', '邵东县', '0', '0', '', '2', '1', null),
('430522', '430500', '新邵县', '0', '0', '', '2', '1', null),
('430523', '430500', '邵阳县', '0', '0', '', '2', '1', null),
('430524', '430500', '隆回县', '0', '0', '', '2', '1', null),
('430525', '430500', '洞口县', '0', '0', '', '2', '1', null),
('430527', '430500', '绥宁县', '0', '0', '', '2', '1', null),
('430528', '430500', '新宁县', '0', '0', '', '2', '1', null),
('430529', '430500', '城步苗族自治县', '0', '0', '', '2', '1', null),
('430581', '430500', '武冈市', '0', '0', '', '2', '1', null),
('430600', '430000', '岳阳市', '0', '0', 'Y', '1', '1', null),
('430602', '430600', '岳阳楼区', '0', '0', '', '2', '1', null),
('430603', '430600', '云溪区', '0', '0', '', '2', '1', null),
('430611', '430600', '君山区', '0', '0', '', '2', '1', null),
('430621', '430600', '岳阳县', '0', '0', '', '2', '1', null),
('430623', '430600', '华容县', '0', '0', '', '2', '1', null),
('430624', '430600', '湘阴县', '0', '0', '', '2', '1', null),
('430626', '430600', '平江县', '0', '0', '', '2', '1', null),
('430681', '430600', '汨罗市', '0', '0', '', '2', '1', null),
('430682', '430600', '临湘市', '0', '0', '', '2', '1', null),
('430700', '430000', '常德市', '0', '0', 'C', '1', '1', null),
('430702', '430700', '武陵区', '0', '0', '', '2', '1', null),
('430703', '430700', '鼎城区', '0', '0', '', '2', '1', null),
('430721', '430700', '安乡县', '0', '0', '', '2', '1', null),
('430722', '430700', '汉寿县', '0', '0', '', '2', '1', null),
('430723', '430700', '澧县', '0', '0', '', '2', '1', null),
('430724', '430700', '临澧县', '0', '0', '', '2', '1', null),
('430725', '430700', '桃源县', '0', '0', '', '2', '1', null),
('430726', '430700', '石门县', '0', '0', '', '2', '1', null),
('430781', '430700', '津市市', '0', '0', '', '2', '1', null),
('430800', '430000', '张家界市', '0', '0', 'Z', '1', '1', null),
('430802', '430800', '永定区', '0', '0', '', '2', '1', null),
('430811', '430800', '武陵源区', '0', '0', '', '2', '1', null),
('430821', '430800', '慈利县', '0', '0', '', '2', '1', null),
('430822', '430800', '桑植县', '0', '0', '', '2', '1', null),
('430900', '430000', '益阳市', '0', '0', 'Y', '1', '1', null),
('430902', '430900', '资阳区', '0', '0', '', '2', '1', null),
('430903', '430900', '赫山区', '0', '0', '', '2', '1', null),
('430921', '430900', '南县', '0', '0', '', '2', '1', null),
('430922', '430900', '桃江县', '0', '0', '', '2', '1', null),
('430923', '430900', '安化县', '0', '0', '', '2', '1', null),
('430981', '430900', '沅江市', '0', '0', '', '2', '1', null),
('431000', '430000', '郴州市', '0', '0', 'C', '1', '1', null),
('431002', '431000', '北湖区', '0', '0', '', '2', '1', null),
('431003', '431000', '苏仙区', '0', '0', '', '2', '1', null),
('431021', '431000', '桂阳县', '0', '0', '', '2', '1', null),
('431022', '431000', '宜章县', '0', '0', '', '2', '1', null),
('431023', '431000', '永兴县', '0', '0', '', '2', '1', null),
('431024', '431000', '嘉禾县', '0', '0', '', '2', '1', null),
('431025', '431000', '临武县', '0', '0', '', '2', '1', null),
('431026', '431000', '汝城县', '0', '0', '', '2', '1', null),
('431027', '431000', '桂东县', '0', '0', '', '2', '1', null),
('431028', '431000', '安仁县', '0', '0', '', '2', '1', null),
('431081', '431000', '资兴市', '0', '0', '', '2', '1', null),
('431100', '430000', '永州市', '0', '0', 'Y', '1', '1', null),
('431102', '431100', '零陵区', '0', '0', '', '2', '1', null),
('431103', '431100', '冷水滩区', '0', '0', '', '2', '1', null),
('431121', '431100', '祁阳县', '0', '0', '', '2', '1', null),
('431122', '431100', '东安县', '0', '0', '', '2', '1', null),
('431123', '431100', '双牌县', '0', '0', '', '2', '1', null),
('431124', '431100', '道县', '0', '0', '', '2', '1', null),
('431125', '431100', '江永县', '0', '0', '', '2', '1', null),
('431126', '431100', '宁远县', '0', '0', '', '2', '1', null),
('431127', '431100', '蓝山县', '0', '0', '', '2', '1', null),
('431128', '431100', '新田县', '0', '0', '', '2', '1', null),
('431129', '431100', '江华瑶族自治县', '0', '0', '', '2', '1', null),
('431200', '430000', '怀化市', '0', '0', 'H', '1', '1', null),
('431202', '431200', '鹤城区', '0', '0', '', '2', '1', null),
('431221', '431200', '中方县', '0', '0', '', '2', '1', null),
('431222', '431200', '沅陵县', '0', '0', '', '2', '1', null),
('431223', '431200', '辰溪县', '0', '0', '', '2', '1', null),
('431224', '431200', '溆浦县', '0', '0', '', '2', '1', null),
('431225', '431200', '会同县', '0', '0', '', '2', '1', null),
('431226', '431200', '麻阳苗族自治县', '0', '0', '', '2', '1', null),
('431227', '431200', '新晃侗族自治县', '0', '0', '', '2', '1', null),
('431228', '431200', '芷江侗族自治县', '0', '0', '', '2', '1', null),
('431229', '431200', '靖州苗族侗族自治县', '0', '0', '', '2', '1', null),
('431230', '431200', '通道侗族自治县', '0', '0', '', '2', '1', null),
('431281', '431200', '洪江市', '0', '0', '', '2', '1', null),
('431300', '430000', '娄底市', '0', '0', 'L', '1', '1', null),
('431302', '431300', '娄星区', '0', '0', '', '2', '1', null),
('431321', '431300', '双峰县', '0', '0', '', '2', '1', null),
('431322', '431300', '新化县', '0', '0', '', '2', '1', null),
('431381', '431300', '冷水江市', '0', '0', '', '2', '1', null),
('431382', '431300', '涟源市', '0', '0', '', '2', '1', null),
('433100', '430000', '湘西土家族苗族自治州', '0', '0', 'X', '1', '1', null),
('433101', '433100', '吉首市', '0', '0', '', '2', '1', null),
('433122', '433100', '泸溪县', '0', '0', '', '2', '1', null),
('433123', '433100', '凤凰县', '0', '0', '', '2', '1', null);
INSERT INTO `wst_areas` VALUES ('433124', '433100', '花垣县', '0', '0', '', '2', '1', null),
('433125', '433100', '保靖县', '0', '0', '', '2', '1', null),
('433126', '433100', '古丈县', '0', '0', '', '2', '1', null),
('433127', '433100', '永顺县', '0', '0', '', '2', '1', null),
('433130', '433100', '龙山县', '0', '0', '', '2', '1', null),
('440000', '0', '广东省', '1', '0', '', '0', '1', null),
('440100', '440000', '广州市', '1', '0', 'G', '1', '1', null),
('440103', '440100', '荔湾区', '1', '1', '', '2', '1', null),
('440104', '440100', '越秀区', '1', '2', '', '2', '1', null),
('440105', '440100', '海珠区', '1', '3', '', '2', '1', null),
('440106', '440100', '天河区', '1', '0', '', '2', '1', null),
('440111', '440100', '白云区', '1', '0', '', '2', '1', null),
('440112', '440100', '黄埔区', '1', '4', '', '2', '1', null),
('440113', '440100', '番禺区', '1', '5', '', '2', '1', null),
('440114', '440100', '花都区', '1', '6', '', '2', '1', null),
('440115', '440100', '南沙区', '1', '7', '', '2', '1', null),
('440117', '440100', '从化区', '1', '8', '', '2', '1', null),
('440118', '440100', '增城区', '1', '9', '', '2', '1', null),
('440200', '440000', '韶关市', '1', '0', 'S', '1', '1', null),
('440203', '440200', '武江区', '1', '0', '', '2', '1', null),
('440204', '440200', '浈江区', '1', '0', '', '2', '1', null),
('440205', '440200', '曲江区', '1', '0', '', '2', '1', null),
('440222', '440200', '始兴县', '1', '0', '', '2', '1', null),
('440224', '440200', '仁化县', '1', '0', '', '2', '1', null),
('440229', '440200', '翁源县', '1', '0', '', '2', '1', null),
('440232', '440200', '乳源瑶族自治县', '1', '0', '', '2', '1', null),
('440233', '440200', '新丰县', '1', '0', '', '2', '1', null),
('440281', '440200', '乐昌市', '1', '0', '', '2', '1', null),
('440282', '440200', '南雄市', '1', '0', '', '2', '1', null),
('440300', '440000', '深圳市', '1', '0', 'S', '1', '1', null),
('440303', '440300', '罗湖区', '1', '0', '', '2', '1', null),
('440304', '440300', '福田区', '1', '0', '', '2', '1', null),
('440305', '440300', '南山区', '1', '0', '', '2', '1', null),
('440306', '440300', '宝安区', '1', '0', '', '2', '1', null),
('440307', '440300', '龙岗区', '1', '0', '', '2', '1', null),
('440308', '440300', '盐田区', '1', '0', '', '2', '1', null),
('440400', '440000', '珠海市', '1', '0', 'Z', '1', '1', null),
('440402', '440400', '香洲区', '1', '0', '', '2', '1', null),
('440403', '440400', '斗门区', '1', '0', '', '2', '1', null),
('440404', '440400', '金湾区', '1', '0', '', '2', '1', null),
('440500', '440000', '汕头市', '1', '0', 'S', '1', '1', null),
('440507', '440500', '龙湖区', '1', '0', '', '2', '1', null),
('440511', '440500', '金平区', '1', '0', '', '2', '1', null),
('440512', '440500', '濠江区', '1', '0', '', '2', '1', null),
('440513', '440500', '潮阳区', '1', '0', '', '2', '1', null),
('440514', '440500', '潮南区', '1', '0', '', '2', '1', null),
('440515', '440500', '澄海区', '1', '0', '', '2', '1', null),
('440523', '440500', '南澳县', '1', '0', '', '2', '1', null),
('440600', '440000', '佛山市', '1', '0', 'F', '1', '1', null),
('440604', '440600', '禅城区', '1', '0', '', '2', '1', null),
('440605', '440600', '南海区', '1', '0', '', '2', '1', null),
('440606', '440600', '顺德区', '1', '0', '', '2', '1', null),
('440607', '440600', '三水区', '1', '0', '', '2', '1', null),
('440608', '440600', '高明区', '1', '0', '', '2', '1', null),
('440700', '440000', '江门市', '1', '0', 'J', '1', '1', null),
('440703', '440700', '蓬江区', '1', '0', '', '2', '1', null),
('440704', '440700', '江海区', '1', '0', '', '2', '1', null),
('440705', '440700', '新会区', '1', '0', '', '2', '1', null),
('440781', '440700', '台山市', '1', '0', '', '2', '1', null),
('440783', '440700', '开平市', '1', '0', '', '2', '1', null),
('440784', '440700', '鹤山市', '1', '0', '', '2', '1', null),
('440785', '440700', '恩平市', '1', '0', '', '2', '1', null),
('440800', '440000', '湛江市', '1', '0', 'Z', '1', '1', null),
('440802', '440800', '赤坎区', '1', '0', '', '2', '1', null),
('440803', '440800', '霞山区', '1', '0', '', '2', '1', null),
('440804', '440800', '坡头区', '1', '0', '', '2', '1', null),
('440811', '440800', '麻章区', '1', '0', '', '2', '1', null),
('440823', '440800', '遂溪县', '1', '0', '', '2', '1', null),
('440825', '440800', '徐闻县', '1', '0', '', '2', '1', null),
('440881', '440800', '廉江市', '1', '0', '', '2', '1', null),
('440882', '440800', '雷州市', '1', '0', '', '2', '1', null),
('440883', '440800', '吴川市', '1', '0', '', '2', '1', null),
('440900', '440000', '茂名市', '1', '0', 'M', '1', '1', null),
('440902', '440900', '茂南区', '1', '0', '', '2', '1', null),
('440904', '440900', '电白区', '1', '0', '', '2', '1', null),
('440981', '440900', '高州市', '1', '0', '', '2', '1', null),
('440982', '440900', '化州市', '1', '0', '', '2', '1', null),
('440983', '440900', '信宜市', '1', '0', '', '2', '1', null),
('441200', '440000', '肇庆市', '1', '0', 'Z', '1', '1', null),
('441202', '441200', '端州区', '1', '0', '', '2', '1', null),
('441203', '441200', '鼎湖区', '1', '0', '', '2', '1', null),
('441223', '441200', '广宁县', '1', '0', '', '2', '1', null),
('441224', '441200', '怀集县', '1', '0', '', '2', '1', null),
('441225', '441200', '封开县', '1', '0', '', '2', '1', null),
('441226', '441200', '德庆县', '1', '0', '', '2', '1', null),
('441283', '441200', '高要市', '1', '0', '', '2', '1', null),
('441284', '441200', '四会市', '1', '0', '', '2', '1', null),
('441300', '440000', '惠州市', '1', '0', 'H', '1', '1', null),
('441302', '441300', '惠城区', '1', '0', '', '2', '1', null),
('441303', '441300', '惠阳区', '1', '0', '', '2', '1', null),
('441322', '441300', '博罗县', '1', '0', '', '2', '1', null),
('441323', '441300', '惠东县', '1', '0', '', '2', '1', null),
('441324', '441300', '龙门县', '1', '0', '', '2', '1', null),
('441400', '440000', '梅州市', '1', '0', 'M', '1', '1', null),
('441402', '441400', '梅江区', '1', '0', '', '2', '1', null),
('441403', '441400', '梅县区', '1', '0', '', '2', '1', null),
('441422', '441400', '大埔县', '1', '0', '', '2', '1', null),
('441423', '441400', '丰顺县', '1', '0', '', '2', '1', null),
('441424', '441400', '五华县', '1', '0', '', '2', '1', null),
('441426', '441400', '平远县', '1', '0', '', '2', '1', null),
('441427', '441400', '蕉岭县', '1', '0', '', '2', '1', null),
('441481', '441400', '兴宁市', '1', '0', '', '2', '1', null),
('441500', '440000', '汕尾市', '1', '0', 'S', '1', '1', null),
('441502', '441500', '城区', '1', '0', '', '2', '1', null),
('441521', '441500', '海丰县', '1', '0', '', '2', '1', null),
('441523', '441500', '陆河县', '1', '0', '', '2', '1', null),
('441581', '441500', '陆丰市', '1', '0', '', '2', '1', null),
('441600', '440000', '河源市', '1', '0', 'H', '1', '1', null),
('441602', '441600', '源城区', '1', '0', '', '2', '1', null),
('441621', '441600', '紫金县', '1', '0', '', '2', '1', null),
('441622', '441600', '龙川县', '1', '0', '', '2', '1', null),
('441623', '441600', '连平县', '1', '0', '', '2', '1', null),
('441624', '441600', '和平县', '1', '0', '', '2', '1', null),
('441625', '441600', '东源县', '1', '0', '', '2', '1', null),
('441700', '440000', '阳江市', '1', '0', 'Y', '1', '1', null),
('441702', '441700', '江城区', '1', '0', '', '2', '1', null),
('441704', '441700', '阳东区', '1', '0', '', '2', '1', null),
('441721', '441700', '阳西县', '1', '0', '', '2', '1', null),
('441781', '441700', '阳春市', '1', '0', '', '2', '1', null),
('441800', '440000', '清远市', '1', '0', 'Q', '1', '1', null),
('441802', '441800', '清城区', '1', '0', '', '2', '1', null),
('441803', '441800', '清新区', '1', '0', '', '2', '1', null),
('441821', '441800', '佛冈县', '1', '0', '', '2', '1', null),
('441823', '441800', '阳山县', '1', '0', '', '2', '1', null),
('441825', '441800', '连山壮族瑶族自治县', '1', '0', '', '2', '1', null),
('441826', '441800', '连南瑶族自治县', '1', '0', '', '2', '1', null),
('441881', '441800', '英德市', '1', '0', '', '2', '1', null),
('441882', '441800', '连州市', '1', '0', '', '2', '1', null),
('441900', '440000', '东莞市', '1', '0', 'D', '1', '1', null),
('442000', '440000', '中山市', '1', '0', 'Z', '1', '1', null),
('445100', '440000', '潮州市', '1', '0', 'C', '1', '1', null),
('445102', '445100', '湘桥区', '1', '0', '', '2', '1', null),
('445103', '445100', '潮安区', '1', '0', '', '2', '1', null),
('445122', '445100', '饶平县', '1', '0', '', '2', '1', null),
('445200', '440000', '揭阳市', '1', '0', 'J', '1', '1', null),
('445202', '445200', '榕城区', '1', '0', '', '2', '1', null),
('445203', '445200', '揭东区', '1', '0', '', '2', '1', null),
('445222', '445200', '揭西县', '1', '0', '', '2', '1', null),
('445224', '445200', '惠来县', '1', '0', '', '2', '1', null),
('445281', '445200', '普宁市', '1', '0', '', '2', '1', null),
('445300', '440000', '云浮市', '1', '0', 'Y', '1', '1', null),
('445302', '445300', '云城区', '1', '0', '', '2', '1', null),
('445303', '445300', '云安区', '1', '0', '', '2', '1', null),
('445321', '445300', '新兴县', '1', '0', '', '2', '1', null),
('445322', '445300', '郁南县', '1', '0', '', '2', '1', null),
('445381', '445300', '罗定市', '1', '0', '', '2', '1', null),
('450000', '0', '广西壮族自治区', '1', '0', '', '0', '1', null),
('450100', '450000', '南宁市', '1', '0', 'N', '1', '1', null),
('450102', '450100', '兴宁区', '1', '0', '', '2', '1', null),
('450103', '450100', '青秀区', '1', '0', '', '2', '1', null),
('450105', '450100', '江南区', '1', '0', '', '2', '1', null),
('450107', '450100', '西乡塘区', '1', '0', '', '2', '1', null),
('450108', '450100', '良庆区', '1', '0', '', '2', '1', null),
('450109', '450100', '邕宁区', '1', '0', '', '2', '1', null),
('450110', '450100', '武鸣区', '1', '0', '', '2', '1', null),
('450123', '450100', '隆安县', '1', '0', '', '2', '1', null),
('450124', '450100', '马山县', '1', '0', '', '2', '1', null),
('450125', '450100', '上林县', '1', '0', '', '2', '1', null),
('450126', '450100', '宾阳县', '1', '0', '', '2', '1', null),
('450127', '450100', '横县', '1', '0', '', '2', '1', null),
('450200', '450000', '柳州市', '1', '0', 'L', '1', '1', null),
('450202', '450200', '城中区', '1', '0', '', '2', '1', null),
('450203', '450200', '鱼峰区', '1', '0', '', '2', '1', null),
('450204', '450200', '柳南区', '1', '0', '', '2', '1', null),
('450205', '450200', '柳北区', '1', '0', '', '2', '1', null),
('450221', '450200', '柳江县', '1', '0', '', '2', '1', null),
('450222', '450200', '柳城县', '1', '0', '', '2', '1', null),
('450223', '450200', '鹿寨县', '1', '0', '', '2', '1', null),
('450224', '450200', '融安县', '1', '0', '', '2', '1', null),
('450225', '450200', '融水苗族自治县', '1', '0', '', '2', '1', null),
('450226', '450200', '三江侗族自治县', '1', '0', '', '2', '1', null),
('450300', '450000', '桂林市', '1', '0', 'G', '1', '1', null),
('450302', '450300', '秀峰区', '1', '0', '', '2', '1', null),
('450303', '450300', '叠彩区', '1', '0', '', '2', '1', null),
('450304', '450300', '象山区', '1', '0', '', '2', '1', null),
('450305', '450300', '七星区', '1', '0', '', '2', '1', null),
('450311', '450300', '雁山区', '1', '0', '', '2', '1', null),
('450312', '450300', '临桂区', '1', '0', '', '2', '1', null),
('450321', '450300', '阳朔县', '1', '0', '', '2', '1', null),
('450323', '450300', '灵川县', '1', '0', '', '2', '1', null),
('450324', '450300', '全州县', '1', '0', '', '2', '1', null),
('450325', '450300', '兴安县', '1', '0', '', '2', '1', null),
('450326', '450300', '永福县', '1', '0', '', '2', '1', null),
('450327', '450300', '灌阳县', '1', '0', '', '2', '1', null),
('450328', '450300', '龙胜各族自治县', '1', '0', '', '2', '1', null),
('450329', '450300', '资源县', '1', '0', '', '2', '1', null),
('450330', '450300', '平乐县', '1', '0', '', '2', '1', null),
('450331', '450300', '荔浦县', '1', '0', '', '2', '1', null),
('450332', '450300', '恭城瑶族自治县', '1', '0', '', '2', '1', null),
('450400', '450000', '梧州市', '1', '0', 'W', '1', '1', null),
('450403', '450400', '万秀区', '1', '0', '', '2', '1', null),
('450405', '450400', '长洲区', '1', '0', '', '2', '1', null),
('450406', '450400', '龙圩区', '1', '0', '', '2', '1', null),
('450421', '450400', '苍梧县', '1', '0', '', '2', '1', null),
('450422', '450400', '藤县', '1', '0', '', '2', '1', null),
('450423', '450400', '蒙山县', '1', '0', '', '2', '1', null),
('450481', '450400', '岑溪市', '1', '0', '', '2', '1', null),
('450500', '450000', '北海市', '1', '0', 'B', '1', '1', null),
('450502', '450500', '海城区', '1', '0', '', '2', '1', null),
('450503', '450500', '银海区', '1', '0', '', '2', '1', null),
('450512', '450500', '铁山港区', '1', '0', '', '2', '1', null),
('450521', '450500', '合浦县', '1', '0', '', '2', '1', null),
('450600', '450000', '防城港市', '1', '0', 'F', '1', '1', null),
('450602', '450600', '港口区', '1', '0', '', '2', '1', null),
('450603', '450600', '防城区', '1', '0', '', '2', '1', null),
('450621', '450600', '上思县', '1', '0', '', '2', '1', null),
('450681', '450600', '东兴市', '1', '0', '', '2', '1', null),
('450700', '450000', '钦州市', '1', '0', 'Q', '1', '1', null),
('450702', '450700', '钦南区', '1', '0', '', '2', '1', null),
('450703', '450700', '钦北区', '1', '0', '', '2', '1', null),
('450721', '450700', '灵山县', '1', '0', '', '2', '1', null),
('450722', '450700', '浦北县', '1', '0', '', '2', '1', null),
('450800', '450000', '贵港市', '1', '0', 'G', '1', '1', null),
('450802', '450800', '港北区', '1', '0', '', '2', '1', null),
('450803', '450800', '港南区', '1', '0', '', '2', '1', null),
('450804', '450800', '覃塘区', '1', '0', '', '2', '1', null),
('450821', '450800', '平南县', '1', '0', '', '2', '1', null),
('450881', '450800', '桂平市', '1', '0', '', '2', '1', null),
('450900', '450000', '玉林市', '1', '0', 'Y', '1', '1', null),
('450902', '450900', '玉州区', '1', '0', '', '2', '1', null),
('450903', '450900', '福绵区', '1', '0', '', '2', '1', null),
('450921', '450900', '容县', '1', '0', '', '2', '1', null),
('450922', '450900', '陆川县', '1', '0', '', '2', '1', null),
('450923', '450900', '博白县', '1', '0', '', '2', '1', null),
('450924', '450900', '兴业县', '1', '0', '', '2', '1', null),
('450981', '450900', '北流市', '1', '0', '', '2', '1', null),
('451000', '450000', '百色市', '1', '0', 'B', '1', '1', null),
('451002', '451000', '右江区', '1', '0', '', '2', '1', null),
('451021', '451000', '田阳县', '1', '0', '', '2', '1', null),
('451022', '451000', '田东县', '1', '0', '', '2', '1', null),
('451023', '451000', '平果县', '1', '0', '', '2', '1', null),
('451024', '451000', '德保县', '1', '0', '', '2', '1', null),
('451025', '451000', '靖西县', '1', '0', '', '2', '1', null),
('451026', '451000', '那坡县', '1', '0', '', '2', '1', null),
('451027', '451000', '凌云县', '1', '0', '', '2', '1', null),
('451028', '451000', '乐业县', '1', '0', '', '2', '1', null),
('451029', '451000', '田林县', '1', '0', '', '2', '1', null),
('451030', '451000', '西林县', '1', '0', '', '2', '1', null),
('451031', '451000', '隆林各族自治县', '1', '0', '', '2', '1', null),
('451100', '450000', '贺州市', '1', '0', 'H', '1', '1', null),
('451102', '451100', '八步区', '1', '0', '', '2', '1', null),
('451119', '451100', '平桂管理区', '1', '0', '', '2', '1', null),
('451121', '451100', '昭平县', '1', '0', '', '2', '1', null),
('451122', '451100', '钟山县', '1', '0', '', '2', '1', null),
('451123', '451100', '富川瑶族自治县', '1', '0', '', '2', '1', null),
('451200', '450000', '河池市', '1', '0', 'H', '1', '1', null),
('451202', '451200', '金城江区', '1', '0', '', '2', '1', null),
('451221', '451200', '南丹县', '1', '0', '', '2', '1', null),
('451222', '451200', '天峨县', '1', '0', '', '2', '1', null),
('451223', '451200', '凤山县', '1', '0', '', '2', '1', null),
('451224', '451200', '东兰县', '1', '0', '', '2', '1', null),
('451225', '451200', '罗城仫佬族自治县', '1', '0', '', '2', '1', null),
('451226', '451200', '环江毛南族自治县', '1', '0', '', '2', '1', null),
('451227', '451200', '巴马瑶族自治县', '1', '0', '', '2', '1', null),
('451228', '451200', '都安瑶族自治县', '1', '0', '', '2', '1', null),
('451229', '451200', '大化瑶族自治县', '1', '0', '', '2', '1', null),
('451281', '451200', '宜州市', '1', '0', '', '2', '1', null),
('451300', '450000', '来宾市', '1', '0', 'L', '1', '1', null),
('451302', '451300', '兴宾区', '1', '0', '', '2', '1', null),
('451321', '451300', '忻城县', '1', '0', '', '2', '1', null),
('451322', '451300', '象州县', '1', '0', '', '2', '1', null),
('451323', '451300', '武宣县', '1', '0', '', '2', '1', null),
('451324', '451300', '金秀瑶族自治县', '1', '0', '', '2', '1', null),
('451381', '451300', '合山市', '1', '0', '', '2', '1', null),
('451400', '450000', '崇左市', '1', '0', 'C', '1', '1', null),
('451402', '451400', '江州区', '1', '0', '', '2', '1', null),
('451421', '451400', '扶绥县', '1', '0', '', '2', '1', null),
('451422', '451400', '宁明县', '1', '0', '', '2', '1', null),
('451423', '451400', '龙州县', '1', '0', '', '2', '1', null),
('451424', '451400', '大新县', '1', '0', '', '2', '1', null),
('451425', '451400', '天等县', '1', '0', '', '2', '1', null),
('451481', '451400', '凭祥市', '1', '0', '', '2', '1', null),
('460000', '0', '海南省', '0', '0', '', '0', '1', null),
('460100', '460000', '海口市', '0', '0', 'H', '1', '1', null),
('460105', '460100', '秀英区', '0', '0', '', '2', '1', null),
('460106', '460100', '龙华区', '0', '0', '', '2', '1', null),
('460107', '460100', '琼山区', '0', '0', '', '2', '1', null),
('460108', '460100', '美兰区', '0', '0', '', '2', '1', null),
('460200', '460000', '三亚市', '0', '0', 'S', '1', '1', null),
('460202', '460200', '海棠区', '0', '0', '', '2', '1', null),
('460203', '460200', '吉阳区', '0', '0', '', '2', '1', null),
('460204', '460200', '天涯区', '0', '0', '', '2', '1', null),
('460205', '460200', '崖州区', '0', '0', '', '2', '1', null),
('460300', '460000', '三沙市', '0', '0', 'S', '1', '1', null),
('460400', '460000', '儋州市', '0', '0', 'D', '1', '1', null);
INSERT INTO `wst_areas` VALUES ('469000', '460000', '省直辖县级行政区划', '0', '0', 'S', '1', '1', null),
('469001', '469000', '五指山市', '0', '0', '', '2', '1', null),
('469002', '469000', '琼海市', '0', '0', '', '2', '1', null),
('469005', '469000', '文昌市', '0', '0', '', '2', '1', null),
('469006', '469000', '万宁市', '0', '0', '', '2', '1', null),
('469007', '469000', '东方市', '0', '0', '', '2', '1', null),
('469021', '469000', '定安县', '0', '0', '', '2', '1', null),
('469022', '469000', '屯昌县', '0', '0', '', '2', '1', null),
('469023', '469000', '澄迈县', '0', '0', '', '2', '1', null),
('469024', '469000', '临高县', '0', '0', '', '2', '1', null),
('469025', '469000', '白沙黎族自治县', '0', '0', '', '2', '1', null),
('469026', '469000', '昌江黎族自治县', '0', '0', '', '2', '1', null),
('469027', '469000', '乐东黎族自治县', '0', '0', '', '2', '1', null),
('469028', '469000', '陵水黎族自治县', '0', '0', '', '2', '1', null),
('469029', '469000', '保亭黎族苗族自治县', '0', '0', '', '2', '1', null),
('469030', '469000', '琼中黎族苗族自治县', '0', '0', '', '2', '1', null),
('500000', '0', '重庆市', '0', '0', '', '0', '1', null),
('500100', '500000', '重庆市', '0', '0', '', '1', '1', null),
('500101', '500100', '万州区', '0', '0', '', '2', '1', null),
('500102', '500100', '涪陵区', '0', '0', '', '2', '1', null),
('500103', '500100', '渝中区', '0', '0', '', '2', '1', null),
('500104', '500100', '大渡口区', '0', '0', '', '2', '1', null),
('500105', '500100', '江北区', '0', '0', '', '2', '1', null),
('500106', '500100', '沙坪坝区', '0', '0', '', '2', '1', null),
('500107', '500100', '九龙坡区', '0', '0', '', '2', '1', null),
('500108', '500100', '南岸区', '0', '0', '', '2', '1', null),
('500109', '500100', '北碚区', '0', '0', '', '2', '1', null),
('500110', '500100', '綦江区', '0', '0', '', '2', '1', null),
('500111', '500100', '大足区', '0', '0', '', '2', '1', null),
('500112', '500100', '渝北区', '0', '0', '', '2', '1', null),
('500113', '500100', '巴南区', '0', '0', '', '2', '1', null),
('500114', '500100', '黔江区', '0', '0', '', '2', '1', null),
('500115', '500100', '长寿区', '0', '0', '', '2', '1', null),
('500116', '500100', '江津区', '0', '0', '', '2', '1', null),
('500117', '500100', '合川区', '0', '0', '', '2', '1', null),
('500118', '500100', '永川区', '0', '0', '', '2', '1', null),
('500119', '500100', '南川区', '0', '0', '', '2', '1', null),
('500120', '500100', '璧山区', '0', '0', '', '2', '1', null),
('500151', '500100', '铜梁区', '0', '0', '', '2', '1', null),
('500223', '500200', '潼南县', '0', '0', '', '2', '1', null),
('500226', '500200', '荣昌县', '0', '0', '', '2', '1', null),
('500228', '500200', '梁平县', '0', '0', '', '2', '1', null),
('500229', '500200', '城口县', '0', '0', '', '2', '1', null),
('500230', '500200', '丰都县', '0', '0', '', '2', '1', null),
('500231', '500200', '垫江县', '0', '0', '', '2', '1', null),
('500232', '500200', '武隆县', '0', '0', '', '2', '1', null),
('500233', '500200', '忠县', '0', '0', '', '2', '1', null),
('500234', '500200', '开县', '0', '0', '', '2', '1', null),
('500235', '500200', '云阳县', '0', '0', '', '2', '1', null),
('500236', '500200', '奉节县', '0', '0', '', '2', '1', null),
('500237', '500200', '巫山县', '0', '0', '', '2', '1', null),
('500238', '500200', '巫溪县', '0', '0', '', '2', '1', null),
('500240', '500200', '石柱土家族自治县', '0', '0', '', '2', '1', null),
('500241', '500200', '秀山土家族苗族自治县', '0', '0', '', '2', '1', null),
('500242', '500200', '酉阳土家族苗族自治县', '0', '0', '', '2', '1', null),
('500243', '500200', '彭水苗族土家族自治县', '0', '0', '', '2', '1', null),
('510000', '0', '四川省', '1', '0', '', '0', '1', null),
('510100', '510000', '成都市', '1', '0', 'C', '1', '1', null),
('510104', '510100', '锦江区', '1', '0', '', '2', '1', null),
('510105', '510100', '青羊区', '1', '0', '', '2', '1', null),
('510106', '510100', '金牛区', '1', '0', '', '2', '1', null),
('510107', '510100', '武侯区', '1', '0', '', '2', '1', null),
('510108', '510100', '成华区', '1', '0', '', '2', '1', null),
('510112', '510100', '龙泉驿区', '1', '0', '', '2', '1', null),
('510113', '510100', '青白江区', '1', '0', '', '2', '1', null),
('510114', '510100', '新都区', '1', '0', '', '2', '1', null),
('510115', '510100', '温江区', '1', '0', '', '2', '1', null),
('510121', '510100', '金堂县', '1', '0', '', '2', '1', null),
('510122', '510100', '双流县', '1', '0', '', '2', '1', null),
('510124', '510100', '郫县', '1', '0', '', '2', '1', null),
('510129', '510100', '大邑县', '1', '0', '', '2', '1', null),
('510131', '510100', '蒲江县', '1', '0', '', '2', '1', null),
('510132', '510100', '新津县', '1', '0', '', '2', '1', null),
('510181', '510100', '都江堰市', '1', '0', '', '2', '1', null),
('510182', '510100', '彭州市', '1', '0', '', '2', '1', null),
('510183', '510100', '邛崃市', '1', '0', '', '2', '1', null),
('510184', '510100', '崇州市', '1', '0', '', '2', '1', null),
('510300', '510000', '自贡市', '1', '0', 'Z', '1', '1', null),
('510302', '510300', '自流井区', '1', '0', '', '2', '1', null),
('510303', '510300', '贡井区', '1', '0', '', '2', '1', null),
('510304', '510300', '大安区', '1', '0', '', '2', '1', null),
('510311', '510300', '沿滩区', '1', '0', '', '2', '1', null),
('510321', '510300', '荣县', '1', '0', '', '2', '1', null),
('510322', '510300', '富顺县', '1', '0', '', '2', '1', null),
('510400', '510000', '攀枝花市', '1', '0', 'P', '1', '1', null),
('510402', '510400', '东区', '1', '0', '', '2', '1', null),
('510403', '510400', '西区', '1', '0', '', '2', '1', null),
('510411', '510400', '仁和区', '1', '0', '', '2', '1', null),
('510421', '510400', '米易县', '1', '0', '', '2', '1', null),
('510422', '510400', '盐边县', '1', '0', '', '2', '1', null),
('510500', '510000', '泸州市', '1', '0', 'L', '1', '1', null),
('510502', '510500', '江阳区', '1', '0', '', '2', '1', null),
('510503', '510500', '纳溪区', '1', '0', '', '2', '1', null),
('510504', '510500', '龙马潭区', '1', '0', '', '2', '1', null),
('510521', '510500', '泸县', '1', '0', '', '2', '1', null),
('510522', '510500', '合江县', '1', '0', '', '2', '1', null),
('510524', '510500', '叙永县', '1', '0', '', '2', '1', null),
('510525', '510500', '古蔺县', '1', '0', '', '2', '1', null),
('510600', '510000', '德阳市', '1', '0', 'D', '1', '1', null),
('510603', '510600', '旌阳区', '1', '0', '', '2', '1', null),
('510623', '510600', '中江县', '1', '0', '', '2', '1', null),
('510626', '510600', '罗江县', '1', '0', '', '2', '1', null),
('510681', '510600', '广汉市', '1', '0', '', '2', '1', null),
('510682', '510600', '什邡市', '1', '0', '', '2', '1', null),
('510683', '510600', '绵竹市', '1', '0', '', '2', '1', null),
('510700', '510000', '绵阳市', '1', '0', 'M', '1', '1', null),
('510703', '510700', '涪城区', '1', '0', '', '2', '1', null),
('510704', '510700', '游仙区', '1', '0', '', '2', '1', null),
('510722', '510700', '三台县', '1', '0', '', '2', '1', null),
('510723', '510700', '盐亭县', '1', '0', '', '2', '1', null),
('510724', '510700', '安县', '1', '0', '', '2', '1', null),
('510725', '510700', '梓潼县', '1', '0', '', '2', '1', null),
('510726', '510700', '北川羌族自治县', '1', '0', '', '2', '1', null),
('510727', '510700', '平武县', '1', '0', '', '2', '1', null),
('510781', '510700', '江油市', '1', '0', '', '2', '1', null),
('510800', '510000', '广元市', '1', '0', 'G', '1', '1', null),
('510802', '510800', '利州区', '1', '0', '', '2', '1', null),
('510811', '510800', '昭化区', '1', '0', '', '2', '1', null),
('510812', '510800', '朝天区', '1', '0', '', '2', '1', null),
('510821', '510800', '旺苍县', '1', '0', '', '2', '1', null),
('510822', '510800', '青川县', '1', '0', '', '2', '1', null),
('510823', '510800', '剑阁县', '1', '0', '', '2', '1', null),
('510824', '510800', '苍溪县', '1', '0', '', '2', '1', null),
('510900', '510000', '遂宁市', '1', '0', 'S', '1', '1', null),
('510903', '510900', '船山区', '1', '0', '', '2', '1', null),
('510904', '510900', '安居区', '1', '0', '', '2', '1', null),
('510921', '510900', '蓬溪县', '1', '0', '', '2', '1', null),
('510922', '510900', '射洪县', '1', '0', '', '2', '1', null),
('510923', '510900', '大英县', '1', '0', '', '2', '1', null),
('511000', '510000', '内江市', '1', '0', 'N', '1', '1', null),
('511002', '511000', '市中区', '1', '0', '', '2', '1', null),
('511011', '511000', '东兴区', '1', '0', '', '2', '1', null),
('511024', '511000', '威远县', '1', '0', '', '2', '1', null),
('511025', '511000', '资中县', '1', '0', '', '2', '1', null),
('511028', '511000', '隆昌县', '1', '0', '', '2', '1', null),
('511100', '510000', '乐山市', '1', '0', 'L', '1', '1', null),
('511102', '511100', '市中区', '1', '0', '', '2', '1', null),
('511111', '511100', '沙湾区', '1', '0', '', '2', '1', null),
('511112', '511100', '五通桥区', '1', '0', '', '2', '1', null),
('511113', '511100', '金口河区', '1', '0', '', '2', '1', null),
('511123', '511100', '犍为县', '1', '0', '', '2', '1', null),
('511124', '511100', '井研县', '1', '0', '', '2', '1', null),
('511126', '511100', '夹江县', '1', '0', '', '2', '1', null),
('511129', '511100', '沐川县', '1', '0', '', '2', '1', null),
('511132', '511100', '峨边彝族自治县', '1', '0', '', '2', '1', null),
('511133', '511100', '马边彝族自治县', '1', '0', '', '2', '1', null),
('511181', '511100', '峨眉山市', '1', '0', '', '2', '1', null),
('511300', '510000', '南充市', '1', '0', 'N', '1', '1', null),
('511302', '511300', '顺庆区', '1', '0', '', '2', '1', null),
('511303', '511300', '高坪区', '1', '0', '', '2', '1', null),
('511304', '511300', '嘉陵区', '1', '0', '', '2', '1', null),
('511321', '511300', '南部县', '1', '0', '', '2', '1', null),
('511322', '511300', '营山县', '1', '0', '', '2', '1', null),
('511323', '511300', '蓬安县', '1', '0', '', '2', '1', null),
('511324', '511300', '仪陇县', '1', '0', '', '2', '1', null),
('511325', '511300', '西充县', '1', '0', '', '2', '1', null),
('511381', '511300', '阆中市', '1', '0', '', '2', '1', null),
('511400', '510000', '眉山市', '1', '0', 'M', '1', '1', null),
('511402', '511400', '东坡区', '1', '0', '', '2', '1', null),
('511403', '511400', '彭山区', '1', '0', '', '2', '1', null),
('511421', '511400', '仁寿县', '1', '0', '', '2', '1', null),
('511423', '511400', '洪雅县', '1', '0', '', '2', '1', null),
('511424', '511400', '丹棱县', '1', '0', '', '2', '1', null),
('511425', '511400', '青神县', '1', '0', '', '2', '1', null),
('511500', '510000', '宜宾市', '1', '0', 'Y', '1', '1', null),
('511502', '511500', '翠屏区', '1', '0', '', '2', '1', null),
('511503', '511500', '南溪区', '1', '0', '', '2', '1', null),
('511521', '511500', '宜宾县', '1', '0', '', '2', '1', null),
('511523', '511500', '江安县', '1', '0', '', '2', '1', null),
('511524', '511500', '长宁县', '1', '0', '', '2', '1', null),
('511525', '511500', '高县', '1', '0', '', '2', '1', null),
('511526', '511500', '珙县', '1', '0', '', '2', '1', null),
('511527', '511500', '筠连县', '1', '0', '', '2', '1', null),
('511528', '511500', '兴文县', '1', '0', '', '2', '1', null),
('511529', '511500', '屏山县', '1', '0', '', '2', '1', null),
('511600', '510000', '广安市', '1', '0', 'G', '1', '1', null),
('511602', '511600', '广安区', '1', '0', '', '2', '1', null),
('511603', '511600', '前锋区', '1', '0', '', '2', '1', null),
('511621', '511600', '岳池县', '1', '0', '', '2', '1', null),
('511622', '511600', '武胜县', '1', '0', '', '2', '1', null),
('511623', '511600', '邻水县', '1', '0', '', '2', '1', null),
('511681', '511600', '华蓥市', '1', '0', '', '2', '1', null),
('511700', '510000', '达州市', '1', '0', 'D', '1', '1', null),
('511702', '511700', '通川区', '1', '0', '', '2', '1', null),
('511703', '511700', '达川区', '1', '0', '', '2', '1', null),
('511722', '511700', '宣汉县', '1', '0', '', '2', '1', null),
('511723', '511700', '开江县', '1', '0', '', '2', '1', null),
('511724', '511700', '大竹县', '1', '0', '', '2', '1', null),
('511725', '511700', '渠县', '1', '0', '', '2', '1', null),
('511781', '511700', '万源市', '1', '0', '', '2', '1', null),
('511800', '510000', '雅安市', '1', '0', 'Y', '1', '1', null),
('511802', '511800', '雨城区', '1', '0', '', '2', '1', null),
('511803', '511800', '名山区', '1', '0', '', '2', '1', null),
('511822', '511800', '荥经县', '1', '0', '', '2', '1', null),
('511823', '511800', '汉源县', '1', '0', '', '2', '1', null),
('511824', '511800', '石棉县', '1', '0', '', '2', '1', null),
('511825', '511800', '天全县', '1', '0', '', '2', '1', null),
('511826', '511800', '芦山县', '1', '0', '', '2', '1', null),
('511827', '511800', '宝兴县', '1', '0', '', '2', '1', null),
('511900', '510000', '巴中市', '1', '0', 'B', '1', '1', null),
('511902', '511900', '巴州区', '1', '0', '', '2', '1', null),
('511903', '511900', '恩阳区', '1', '0', '', '2', '1', null),
('511921', '511900', '通江县', '1', '0', '', '2', '1', null),
('511922', '511900', '南江县', '1', '0', '', '2', '1', null),
('511923', '511900', '平昌县', '1', '0', '', '2', '1', null),
('512000', '510000', '资阳市', '1', '0', 'Z', '1', '1', null),
('512002', '512000', '雁江区', '1', '0', '', '2', '1', null),
('512021', '512000', '安岳县', '1', '0', '', '2', '1', null),
('512022', '512000', '乐至县', '1', '0', '', '2', '1', null),
('512081', '512000', '简阳市', '1', '0', '', '2', '1', null),
('513200', '510000', '阿坝藏族羌族自治州', '1', '0', 'A', '1', '1', null),
('513221', '513200', '汶川县', '1', '0', '', '2', '1', null),
('513222', '513200', '理县', '1', '0', '', '2', '1', null),
('513223', '513200', '茂县', '1', '0', '', '2', '1', null),
('513224', '513200', '松潘县', '1', '0', '', '2', '1', null),
('513225', '513200', '九寨沟县', '1', '0', '', '2', '1', null),
('513226', '513200', '金川县', '1', '0', '', '2', '1', null),
('513227', '513200', '小金县', '1', '0', '', '2', '1', null),
('513228', '513200', '黑水县', '1', '0', '', '2', '1', null),
('513229', '513200', '马尔康县', '1', '0', '', '2', '1', null),
('513230', '513200', '壤塘县', '1', '0', '', '2', '1', null),
('513231', '513200', '阿坝县', '1', '0', '', '2', '1', null),
('513232', '513200', '若尔盖县', '1', '0', '', '2', '1', null),
('513233', '513200', '红原县', '1', '0', '', '2', '1', null),
('513300', '510000', '甘孜藏族自治州', '1', '0', 'G', '1', '1', null),
('513301', '513300', '康定市', '1', '0', '', '2', '1', null),
('513322', '513300', '泸定县', '1', '0', '', '2', '1', null),
('513323', '513300', '丹巴县', '1', '0', '', '2', '1', null),
('513324', '513300', '九龙县', '1', '0', '', '2', '1', null),
('513325', '513300', '雅江县', '1', '0', '', '2', '1', null),
('513326', '513300', '道孚县', '1', '0', '', '2', '1', null),
('513327', '513300', '炉霍县', '1', '0', '', '2', '1', null),
('513328', '513300', '甘孜县', '1', '0', '', '2', '1', null),
('513329', '513300', '新龙县', '1', '0', '', '2', '1', null),
('513330', '513300', '德格县', '1', '0', '', '2', '1', null),
('513331', '513300', '白玉县', '1', '0', '', '2', '1', null),
('513332', '513300', '石渠县', '1', '0', '', '2', '1', null),
('513333', '513300', '色达县', '1', '0', '', '2', '1', null),
('513334', '513300', '理塘县', '1', '0', '', '2', '1', null),
('513335', '513300', '巴塘县', '1', '0', '', '2', '1', null),
('513336', '513300', '乡城县', '1', '0', '', '2', '1', null),
('513337', '513300', '稻城县', '1', '0', '', '2', '1', null),
('513338', '513300', '得荣县', '1', '0', '', '2', '1', null),
('513400', '510000', '凉山彝族自治州', '1', '0', 'L', '1', '1', null),
('513401', '513400', '西昌市', '1', '0', '', '2', '1', null),
('513422', '513400', '木里藏族自治县', '1', '0', '', '2', '1', null),
('513423', '513400', '盐源县', '1', '0', '', '2', '1', null),
('513424', '513400', '德昌县', '1', '0', '', '2', '1', null),
('513425', '513400', '会理县', '1', '0', '', '2', '1', null),
('513426', '513400', '会东县', '1', '0', '', '2', '1', null),
('513427', '513400', '宁南县', '1', '0', '', '2', '1', null),
('513428', '513400', '普格县', '1', '0', '', '2', '1', null),
('513429', '513400', '布拖县', '1', '0', '', '2', '1', null),
('513430', '513400', '金阳县', '1', '0', '', '2', '1', null),
('513431', '513400', '昭觉县', '1', '0', '', '2', '1', null),
('513432', '513400', '喜德县', '1', '0', '', '2', '1', null),
('513433', '513400', '冕宁县', '1', '0', '', '2', '1', null),
('513434', '513400', '越西县', '1', '0', '', '2', '1', null),
('513435', '513400', '甘洛县', '1', '0', '', '2', '1', null),
('513436', '513400', '美姑县', '1', '0', '', '2', '1', null),
('513437', '513400', '雷波县', '1', '0', '', '2', '1', null),
('520000', '0', '贵州省', '0', '0', '', '0', '1', null),
('520100', '520000', '贵阳市', '0', '0', 'G', '1', '1', null),
('520102', '520100', '南明区', '0', '0', '', '2', '1', null),
('520103', '520100', '云岩区', '0', '0', '', '2', '1', null),
('520111', '520100', '花溪区', '0', '0', '', '2', '1', null),
('520112', '520100', '乌当区', '0', '0', '', '2', '1', null),
('520113', '520100', '白云区', '0', '0', '', '2', '1', null),
('520115', '520100', '观山湖区', '0', '0', '', '2', '1', null),
('520121', '520100', '开阳县', '0', '0', '', '2', '1', null),
('520122', '520100', '息烽县', '0', '0', '', '2', '1', null),
('520123', '520100', '修文县', '0', '0', '', '2', '1', null),
('520181', '520100', '清镇市', '0', '0', '', '2', '1', null),
('520200', '520000', '六盘水市', '0', '0', 'L', '1', '1', null),
('520201', '520200', '钟山区', '0', '0', '', '2', '1', null),
('520203', '520200', '六枝特区', '0', '0', '', '2', '1', null),
('520221', '520200', '水城县', '0', '0', '', '2', '1', null),
('520222', '520200', '盘县', '0', '0', '', '2', '1', null),
('520300', '520000', '遵义市', '0', '0', 'Z', '1', '1', null),
('520302', '520300', '红花岗区', '0', '0', '', '2', '1', null),
('520303', '520300', '汇川区', '0', '0', '', '2', '1', null),
('520321', '520300', '遵义县', '0', '0', '', '2', '1', null),
('520322', '520300', '桐梓县', '0', '0', '', '2', '1', null),
('520323', '520300', '绥阳县', '0', '0', '', '2', '1', null),
('520324', '520300', '正安县', '0', '0', '', '2', '1', null),
('520325', '520300', '道真仡佬族苗族自治县', '0', '0', '', '2', '1', null),
('520326', '520300', '务川仡佬族苗族自治县', '0', '0', '', '2', '1', null),
('520327', '520300', '凤冈县', '0', '0', '', '2', '1', null),
('520328', '520300', '湄潭县', '0', '0', '', '2', '1', null),
('520329', '520300', '余庆县', '0', '0', '', '2', '1', null),
('520330', '520300', '习水县', '0', '0', '', '2', '1', null),
('520381', '520300', '赤水市', '0', '0', '', '2', '1', null),
('520382', '520300', '仁怀市', '0', '0', '', '2', '1', null),
('520400', '520000', '安顺市', '0', '0', 'A', '1', '1', null),
('520402', '520400', '西秀区', '0', '0', '', '2', '1', null),
('520403', '520400', '平坝区', '0', '0', '', '2', '1', null),
('520422', '520400', '普定县', '0', '0', '', '2', '1', null);
INSERT INTO `wst_areas` VALUES ('520423', '520400', '镇宁布依族苗族自治县', '0', '0', '', '2', '1', null),
('520424', '520400', '关岭布依族苗族自治县', '0', '0', '', '2', '1', null),
('520425', '520400', '紫云苗族布依族自治县', '0', '0', '', '2', '1', null),
('520500', '520000', '毕节市', '0', '0', 'B', '1', '1', null),
('520502', '520500', '七星关区', '0', '0', '', '2', '1', null),
('520521', '520500', '大方县', '0', '0', '', '2', '1', null),
('520522', '520500', '黔西县', '0', '0', '', '2', '1', null),
('520523', '520500', '金沙县', '0', '0', '', '2', '1', null),
('520524', '520500', '织金县', '0', '0', '', '2', '1', null),
('520525', '520500', '纳雍县', '0', '0', '', '2', '1', null),
('520526', '520500', '威宁彝族回族苗族自治县', '0', '0', '', '2', '1', null),
('520527', '520500', '赫章县', '0', '0', '', '2', '1', null),
('520600', '520000', '铜仁市', '0', '0', 'T', '1', '1', null),
('520602', '520600', '碧江区', '0', '0', '', '2', '1', null),
('520603', '520600', '万山区', '0', '0', '', '2', '1', null),
('520621', '520600', '江口县', '0', '0', '', '2', '1', null),
('520622', '520600', '玉屏侗族自治县', '0', '0', '', '2', '1', null),
('520623', '520600', '石阡县', '0', '0', '', '2', '1', null),
('520624', '520600', '思南县', '0', '0', '', '2', '1', null),
('520625', '520600', '印江土家族苗族自治县', '0', '0', '', '2', '1', null),
('520626', '520600', '德江县', '0', '0', '', '2', '1', null),
('520627', '520600', '沿河土家族自治县', '0', '0', '', '2', '1', null),
('520628', '520600', '松桃苗族自治县', '0', '0', '', '2', '1', null),
('522300', '520000', '黔西南布依族苗族自治州', '0', '0', 'Q', '1', '1', null),
('522301', '522300', '兴义市', '0', '0', '', '2', '1', null),
('522322', '522300', '兴仁县', '0', '0', '', '2', '1', null),
('522323', '522300', '普安县', '0', '0', '', '2', '1', null),
('522324', '522300', '晴隆县', '0', '0', '', '2', '1', null),
('522325', '522300', '贞丰县', '0', '0', '', '2', '1', null),
('522326', '522300', '望谟县', '0', '0', '', '2', '1', null),
('522327', '522300', '册亨县', '0', '0', '', '2', '1', null),
('522328', '522300', '安龙县', '0', '0', '', '2', '1', null),
('522600', '520000', '黔东南苗族侗族自治州', '0', '0', 'Q', '1', '1', null),
('522601', '522600', '凯里市', '0', '0', '', '2', '1', null),
('522622', '522600', '黄平县', '0', '0', '', '2', '1', null),
('522623', '522600', '施秉县', '0', '0', '', '2', '1', null),
('522624', '522600', '三穗县', '0', '0', '', '2', '1', null),
('522625', '522600', '镇远县', '0', '0', '', '2', '1', null),
('522626', '522600', '岑巩县', '0', '0', '', '2', '1', null),
('522627', '522600', '天柱县', '0', '0', '', '2', '1', null),
('522628', '522600', '锦屏县', '0', '0', '', '2', '1', null),
('522629', '522600', '剑河县', '0', '0', '', '2', '1', null),
('522630', '522600', '台江县', '0', '0', '', '2', '1', null),
('522631', '522600', '黎平县', '0', '0', '', '2', '1', null),
('522632', '522600', '榕江县', '0', '0', '', '2', '1', null),
('522633', '522600', '从江县', '0', '0', '', '2', '1', null),
('522634', '522600', '雷山县', '0', '0', '', '2', '1', null),
('522635', '522600', '麻江县', '0', '0', '', '2', '1', null),
('522636', '522600', '丹寨县', '0', '0', '', '2', '1', null),
('522700', '520000', '黔南布依族苗族自治州', '0', '0', 'Q', '1', '1', null),
('522701', '522700', '都匀市', '0', '0', '', '2', '1', null),
('522702', '522700', '福泉市', '0', '0', '', '2', '1', null),
('522722', '522700', '荔波县', '0', '0', '', '2', '1', null),
('522723', '522700', '贵定县', '0', '0', '', '2', '1', null),
('522725', '522700', '瓮安县', '0', '0', '', '2', '1', null),
('522726', '522700', '独山县', '0', '0', '', '2', '1', null),
('522727', '522700', '平塘县', '0', '0', '', '2', '1', null),
('522728', '522700', '罗甸县', '0', '0', '', '2', '1', null),
('522729', '522700', '长顺县', '0', '0', '', '2', '1', null),
('522730', '522700', '龙里县', '0', '0', '', '2', '1', null),
('522731', '522700', '惠水县', '0', '0', '', '2', '1', null),
('522732', '522700', '三都水族自治县', '0', '0', '', '2', '1', null),
('530000', '0', '云南省', '0', '0', '', '0', '1', null),
('530100', '530000', '昆明市', '0', '0', 'K', '1', '1', null),
('530102', '530100', '五华区', '0', '0', '', '2', '1', null),
('530103', '530100', '盘龙区', '0', '0', '', '2', '1', null),
('530111', '530100', '官渡区', '0', '0', '', '2', '1', null),
('530112', '530100', '西山区', '0', '0', '', '2', '1', null),
('530113', '530100', '东川区', '0', '0', '', '2', '1', null),
('530114', '530100', '呈贡区', '0', '0', '', '2', '1', null),
('530122', '530100', '晋宁县', '0', '0', '', '2', '1', null),
('530124', '530100', '富民县', '0', '0', '', '2', '1', null),
('530125', '530100', '宜良县', '0', '0', '', '2', '1', null),
('530126', '530100', '石林彝族自治县', '0', '0', '', '2', '1', null),
('530127', '530100', '嵩明县', '0', '0', '', '2', '1', null),
('530128', '530100', '禄劝彝族苗族自治县', '0', '0', '', '2', '1', null),
('530129', '530100', '寻甸回族彝族自治县', '0', '0', '', '2', '1', null),
('530181', '530100', '安宁市', '0', '0', '', '2', '1', null),
('530300', '530000', '曲靖市', '0', '0', 'Q', '1', '1', null),
('530302', '530300', '麒麟区', '0', '0', '', '2', '1', null),
('530321', '530300', '马龙县', '0', '0', '', '2', '1', null),
('530322', '530300', '陆良县', '0', '0', '', '2', '1', null),
('530323', '530300', '师宗县', '0', '0', '', '2', '1', null),
('530324', '530300', '罗平县', '0', '0', '', '2', '1', null),
('530325', '530300', '富源县', '0', '0', '', '2', '1', null),
('530326', '530300', '会泽县', '0', '0', '', '2', '1', null),
('530328', '530300', '沾益县', '0', '0', '', '2', '1', null),
('530381', '530300', '宣威市', '0', '0', '', '2', '1', null),
('530400', '530000', '玉溪市', '0', '0', 'Y', '1', '1', null),
('530402', '530400', '红塔区', '0', '0', '', '2', '1', null),
('530421', '530400', '江川县', '0', '0', '', '2', '1', null),
('530422', '530400', '澄江县', '0', '0', '', '2', '1', null),
('530423', '530400', '通海县', '0', '0', '', '2', '1', null),
('530424', '530400', '华宁县', '0', '0', '', '2', '1', null),
('530425', '530400', '易门县', '0', '0', '', '2', '1', null),
('530426', '530400', '峨山彝族自治县', '0', '0', '', '2', '1', null),
('530427', '530400', '新平彝族傣族自治县', '0', '0', '', '2', '1', null),
('530428', '530400', '元江哈尼族彝族傣族自治县', '0', '0', '', '2', '1', null),
('530500', '530000', '保山市', '0', '0', 'B', '1', '1', null),
('530502', '530500', '隆阳区', '0', '0', '', '2', '1', null),
('530521', '530500', '施甸县', '0', '0', '', '2', '1', null),
('530522', '530500', '腾冲县', '0', '0', '', '2', '1', null),
('530523', '530500', '龙陵县', '0', '0', '', '2', '1', null),
('530524', '530500', '昌宁县', '0', '0', '', '2', '1', null),
('530600', '530000', '昭通市', '0', '0', 'Z', '1', '1', null),
('530602', '530600', '昭阳区', '0', '0', '', '2', '1', null),
('530621', '530600', '鲁甸县', '0', '0', '', '2', '1', null),
('530622', '530600', '巧家县', '0', '0', '', '2', '1', null),
('530623', '530600', '盐津县', '0', '0', '', '2', '1', null),
('530624', '530600', '大关县', '0', '0', '', '2', '1', null),
('530625', '530600', '永善县', '0', '0', '', '2', '1', null),
('530626', '530600', '绥江县', '0', '0', '', '2', '1', null),
('530627', '530600', '镇雄县', '0', '0', '', '2', '1', null),
('530628', '530600', '彝良县', '0', '0', '', '2', '1', null),
('530629', '530600', '威信县', '0', '0', '', '2', '1', null),
('530630', '530600', '水富县', '0', '0', '', '2', '1', null),
('530700', '530000', '丽江市', '0', '0', 'L', '1', '1', null),
('530702', '530700', '古城区', '0', '0', '', '2', '1', null),
('530721', '530700', '玉龙纳西族自治县', '0', '0', '', '2', '1', null),
('530722', '530700', '永胜县', '0', '0', '', '2', '1', null),
('530723', '530700', '华坪县', '0', '0', '', '2', '1', null),
('530724', '530700', '宁蒗彝族自治县', '0', '0', '', '2', '1', null),
('530800', '530000', '普洱市', '0', '0', 'P', '1', '1', null),
('530802', '530800', '思茅区', '0', '0', '', '2', '1', null),
('530821', '530800', '宁洱哈尼族彝族自治县', '0', '0', '', '2', '1', null),
('530822', '530800', '墨江哈尼族自治县', '0', '0', '', '2', '1', null),
('530823', '530800', '景东彝族自治县', '0', '0', '', '2', '1', null),
('530824', '530800', '景谷傣族彝族自治县', '0', '0', '', '2', '1', null),
('530825', '530800', '镇沅彝族哈尼族拉祜族自治县', '0', '0', '', '2', '1', null),
('530826', '530800', '江城哈尼族彝族自治县', '0', '0', '', '2', '1', null),
('530827', '530800', '孟连傣族拉祜族佤族自治县', '0', '0', '', '2', '1', null),
('530828', '530800', '澜沧拉祜族自治县', '0', '0', '', '2', '1', null),
('530829', '530800', '西盟佤族自治县', '0', '0', '', '2', '1', null),
('530900', '530000', '临沧市', '0', '0', 'L', '1', '1', null),
('530902', '530900', '临翔区', '0', '0', '', '2', '1', null),
('530921', '530900', '凤庆县', '0', '0', '', '2', '1', null),
('530922', '530900', '云县', '0', '0', '', '2', '1', null),
('530923', '530900', '永德县', '0', '0', '', '2', '1', null),
('530924', '530900', '镇康县', '0', '0', '', '2', '1', null),
('530925', '530900', '双江拉祜族佤族布朗族傣族自治县', '0', '0', '', '2', '1', null),
('530926', '530900', '耿马傣族佤族自治县', '0', '0', '', '2', '1', null),
('530927', '530900', '沧源佤族自治县', '0', '0', '', '2', '1', null),
('532300', '530000', '楚雄彝族自治州', '0', '0', 'C', '1', '1', null),
('532301', '532300', '楚雄市', '0', '0', '', '2', '1', null),
('532322', '532300', '双柏县', '0', '0', '', '2', '1', null),
('532323', '532300', '牟定县', '0', '0', '', '2', '1', null),
('532324', '532300', '南华县', '0', '0', '', '2', '1', null),
('532325', '532300', '姚安县', '0', '0', '', '2', '1', null),
('532326', '532300', '大姚县', '0', '0', '', '2', '1', null),
('532327', '532300', '永仁县', '0', '0', '', '2', '1', null),
('532328', '532300', '元谋县', '0', '0', '', '2', '1', null),
('532329', '532300', '武定县', '0', '0', '', '2', '1', null),
('532331', '532300', '禄丰县', '0', '0', '', '2', '1', null),
('532500', '530000', '红河哈尼族彝族自治州', '0', '0', 'H', '1', '1', null),
('532501', '532500', '个旧市', '0', '0', '', '2', '1', null),
('532502', '532500', '开远市', '0', '0', '', '2', '1', null),
('532503', '532500', '蒙自市', '0', '0', '', '2', '1', null),
('532504', '532500', '弥勒市', '0', '0', '', '2', '1', null),
('532523', '532500', '屏边苗族自治县', '0', '0', '', '2', '1', null),
('532524', '532500', '建水县', '0', '0', '', '2', '1', null),
('532525', '532500', '石屏县', '0', '0', '', '2', '1', null),
('532527', '532500', '泸西县', '0', '0', '', '2', '1', null),
('532528', '532500', '元阳县', '0', '0', '', '2', '1', null),
('532529', '532500', '红河县', '0', '0', '', '2', '1', null),
('532530', '532500', '金平苗族瑶族傣族自治县', '0', '0', '', '2', '1', null),
('532531', '532500', '绿春县', '0', '0', '', '2', '1', null),
('532532', '532500', '河口瑶族自治县', '0', '0', '', '2', '1', null),
('532600', '530000', '文山壮族苗族自治州', '0', '0', 'W', '1', '1', null),
('532601', '532600', '文山市', '0', '0', '', '2', '1', null),
('532622', '532600', '砚山县', '0', '0', '', '2', '1', null),
('532623', '532600', '西畴县', '0', '0', '', '2', '1', null),
('532624', '532600', '麻栗坡县', '0', '0', '', '2', '1', null),
('532625', '532600', '马关县', '0', '0', '', '2', '1', null),
('532626', '532600', '丘北县', '0', '0', '', '2', '1', null),
('532627', '532600', '广南县', '0', '0', '', '2', '1', null),
('532628', '532600', '富宁县', '0', '0', '', '2', '1', null),
('532800', '530000', '西双版纳傣族自治州', '0', '0', 'X', '1', '1', null),
('532801', '532800', '景洪市', '0', '0', '', '2', '1', null),
('532822', '532800', '勐海县', '0', '0', '', '2', '1', null),
('532823', '532800', '勐腊县', '0', '0', '', '2', '1', null),
('532900', '530000', '大理白族自治州', '0', '0', 'D', '1', '1', null),
('532901', '532900', '大理市', '0', '0', '', '2', '1', null),
('532922', '532900', '漾濞彝族自治县', '0', '0', '', '2', '1', null),
('532923', '532900', '祥云县', '0', '0', '', '2', '1', null),
('532924', '532900', '宾川县', '0', '0', '', '2', '1', null),
('532925', '532900', '弥渡县', '0', '0', '', '2', '1', null),
('532926', '532900', '南涧彝族自治县', '0', '0', '', '2', '1', null),
('532927', '532900', '巍山彝族回族自治县', '0', '0', '', '2', '1', null),
('532928', '532900', '永平县', '0', '0', '', '2', '1', null),
('532929', '532900', '云龙县', '0', '0', '', '2', '1', null),
('532930', '532900', '洱源县', '0', '0', '', '2', '1', null),
('532931', '532900', '剑川县', '0', '0', '', '2', '1', null),
('532932', '532900', '鹤庆县', '0', '0', '', '2', '1', null),
('533100', '530000', '德宏傣族景颇族自治州', '0', '0', 'D', '1', '1', null),
('533102', '533100', '瑞丽市', '0', '0', '', '2', '1', null),
('533103', '533100', '芒市', '0', '0', '', '2', '1', null),
('533122', '533100', '梁河县', '0', '0', '', '2', '1', null),
('533123', '533100', '盈江县', '0', '0', '', '2', '1', null),
('533124', '533100', '陇川县', '0', '0', '', '2', '1', null),
('533300', '530000', '怒江傈僳族自治州', '0', '0', 'N', '1', '1', null),
('533321', '533300', '泸水县', '0', '0', '', '2', '1', null),
('533323', '533300', '福贡县', '0', '0', '', '2', '1', null),
('533324', '533300', '贡山独龙族怒族自治县', '0', '0', '', '2', '1', null),
('533325', '533300', '兰坪白族普米族自治县', '0', '0', '', '2', '1', null),
('533400', '530000', '迪庆藏族自治州', '0', '0', 'D', '1', '1', null),
('533401', '533400', '香格里拉市', '0', '0', '', '2', '1', null),
('533422', '533400', '德钦县', '0', '0', '', '2', '1', null),
('533423', '533400', '维西傈僳族自治县', '0', '0', '', '2', '1', null),
('540000', '0', '西藏自治区', '0', '0', '', '0', '1', null),
('540100', '540000', '拉萨市', '0', '0', 'L', '1', '1', null),
('540102', '540100', '城关区', '0', '0', '', '2', '1', null),
('540121', '540100', '林周县', '0', '0', '', '2', '1', null),
('540122', '540100', '当雄县', '0', '0', '', '2', '1', null),
('540123', '540100', '尼木县', '0', '0', '', '2', '1', null),
('540124', '540100', '曲水县', '0', '0', '', '2', '1', null),
('540125', '540100', '堆龙德庆县', '0', '0', '', '2', '1', null),
('540126', '540100', '达孜县', '0', '0', '', '2', '1', null),
('540127', '540100', '墨竹工卡县', '0', '0', '', '2', '1', null),
('540200', '540000', '日喀则市', '0', '0', 'R', '1', '1', null),
('540202', '540200', '桑珠孜区', '0', '0', '', '2', '1', null),
('540221', '540200', '南木林县', '0', '0', '', '2', '1', null),
('540222', '540200', '江孜县', '0', '0', '', '2', '1', null),
('540223', '540200', '定日县', '0', '0', '', '2', '1', null),
('540224', '540200', '萨迦县', '0', '0', '', '2', '1', null),
('540225', '540200', '拉孜县', '0', '0', '', '2', '1', null),
('540226', '540200', '昂仁县', '0', '0', '', '2', '1', null),
('540227', '540200', '谢通门县', '0', '0', '', '2', '1', null),
('540228', '540200', '白朗县', '0', '0', '', '2', '1', null),
('540229', '540200', '仁布县', '0', '0', '', '2', '1', null),
('540230', '540200', '康马县', '0', '0', '', '2', '1', null),
('540231', '540200', '定结县', '0', '0', '', '2', '1', null),
('540232', '540200', '仲巴县', '0', '0', '', '2', '1', null),
('540233', '540200', '亚东县', '0', '0', '', '2', '1', null),
('540234', '540200', '吉隆县', '0', '0', '', '2', '1', null),
('540235', '540200', '聂拉木县', '0', '0', '', '2', '1', null),
('540236', '540200', '萨嘎县', '0', '0', '', '2', '1', null),
('540237', '540200', '岗巴县', '0', '0', '', '2', '1', null),
('540300', '540000', '昌都市', '0', '0', 'C', '1', '1', null),
('540302', '540300', '卡若区', '0', '0', '', '2', '1', null),
('540321', '540300', '江达县', '0', '0', '', '2', '1', null),
('540322', '540300', '贡觉县', '0', '0', '', '2', '1', null),
('540323', '540300', '类乌齐县', '0', '0', '', '2', '1', null),
('540324', '540300', '丁青县', '0', '0', '', '2', '1', null),
('540325', '540300', '察雅县', '0', '0', '', '2', '1', null),
('540326', '540300', '八宿县', '0', '0', '', '2', '1', null),
('540327', '540300', '左贡县', '0', '0', '', '2', '1', null),
('540328', '540300', '芒康县', '0', '0', '', '2', '1', null),
('540329', '540300', '洛隆县', '0', '0', '', '2', '1', null),
('540330', '540300', '边坝县', '0', '0', '', '2', '1', null),
('540400', '540000', '林芝市', '0', '0', 'L', '1', '1', null),
('540402', '540400', '巴宜区', '0', '0', '', '2', '1', null),
('540421', '540400', '工布江达县', '0', '0', '', '2', '1', null),
('540422', '540400', '米林县', '0', '0', '', '2', '1', null),
('540423', '540400', '墨脱县', '0', '0', '', '2', '1', null),
('540424', '540400', '波密县', '0', '0', '', '2', '1', null),
('540425', '540400', '察隅县', '0', '0', '', '2', '1', null),
('540426', '540400', '朗县', '0', '0', '', '2', '1', null),
('542200', '540000', '山南地区', '0', '0', 'S', '1', '1', null),
('542221', '542200', '乃东县', '0', '0', '', '2', '1', null),
('542222', '542200', '扎囊县', '0', '0', '', '2', '1', null),
('542223', '542200', '贡嘎县', '0', '0', '', '2', '1', null),
('542224', '542200', '桑日县', '0', '0', '', '2', '1', null),
('542225', '542200', '琼结县', '0', '0', '', '2', '1', null),
('542226', '542200', '曲松县', '0', '0', '', '2', '1', null),
('542227', '542200', '措美县', '0', '0', '', '2', '1', null),
('542228', '542200', '洛扎县', '0', '0', '', '2', '1', null),
('542229', '542200', '加查县', '0', '0', '', '2', '1', null),
('542231', '542200', '隆子县', '0', '0', '', '2', '1', null),
('542232', '542200', '错那县', '0', '0', '', '2', '1', null),
('542233', '542200', '浪卡子县', '0', '0', '', '2', '1', null),
('542400', '540000', '那曲地区', '0', '0', 'N', '1', '1', null),
('542421', '542400', '那曲县', '0', '0', '', '2', '1', null),
('542422', '542400', '嘉黎县', '0', '0', '', '2', '1', null),
('542423', '542400', '比如县', '0', '0', '', '2', '1', null),
('542424', '542400', '聂荣县', '0', '0', '', '2', '1', null),
('542425', '542400', '安多县', '0', '0', '', '2', '1', null),
('542426', '542400', '申扎县', '0', '0', '', '2', '1', null),
('542427', '542400', '索县', '0', '0', '', '2', '1', null),
('542428', '542400', '班戈县', '0', '0', '', '2', '1', null),
('542429', '542400', '巴青县', '0', '0', '', '2', '1', null),
('542430', '542400', '尼玛县', '0', '0', '', '2', '1', null),
('542431', '542400', '双湖县', '0', '0', '', '2', '1', null),
('542500', '540000', '阿里地区', '0', '0', 'A', '1', '1', null),
('542521', '542500', '普兰县', '0', '0', '', '2', '1', null),
('542522', '542500', '札达县', '0', '0', '', '2', '1', null),
('542523', '542500', '噶尔县', '0', '0', '', '2', '1', null),
('542524', '542500', '日土县', '0', '0', '', '2', '1', null),
('542525', '542500', '革吉县', '0', '0', '', '2', '1', null),
('542526', '542500', '改则县', '0', '0', '', '2', '1', null),
('542527', '542500', '措勤县', '0', '0', '', '2', '1', null),
('610000', '0', '陕西省', '0', '0', '', '0', '1', null),
('610100', '610000', '西安市', '0', '0', 'X', '1', '1', null),
('610102', '610100', '新城区', '0', '0', '', '2', '1', null),
('610103', '610100', '碑林区', '0', '0', '', '2', '1', null),
('610104', '610100', '莲湖区', '0', '0', '', '2', '1', null),
('610111', '610100', '灞桥区', '0', '0', '', '2', '1', null),
('610112', '610100', '未央区', '0', '0', '', '2', '1', null),
('610113', '610100', '雁塔区', '0', '0', '', '2', '1', null),
('610114', '610100', '阎良区', '0', '0', '', '2', '1', null),
('610115', '610100', '临潼区', '0', '0', '', '2', '1', null),
('610116', '610100', '长安区', '0', '0', '', '2', '1', null),
('610117', '610100', '高陵区', '0', '0', '', '2', '1', null),
('610122', '610100', '蓝田县', '0', '0', '', '2', '1', null),
('610124', '610100', '周至县', '0', '0', '', '2', '1', null),
('610125', '610100', '户县', '0', '0', '', '2', '1', null),
('610200', '610000', '铜川市', '0', '0', 'T', '1', '1', null),
('610202', '610200', '王益区', '0', '0', '', '2', '1', null),
('610203', '610200', '印台区', '0', '0', '', '2', '1', null),
('610204', '610200', '耀州区', '0', '0', '', '2', '1', null),
('610222', '610200', '宜君县', '0', '0', '', '2', '1', null),
('610300', '610000', '宝鸡市', '0', '0', 'B', '1', '1', null),
('610302', '610300', '渭滨区', '0', '0', '', '2', '1', null),
('610303', '610300', '金台区', '0', '0', '', '2', '1', null),
('610304', '610300', '陈仓区', '0', '0', '', '2', '1', null),
('610322', '610300', '凤翔县', '0', '0', '', '2', '1', null),
('610323', '610300', '岐山县', '0', '0', '', '2', '1', null),
('610324', '610300', '扶风县', '0', '0', '', '2', '1', null),
('610326', '610300', '眉县', '0', '0', '', '2', '1', null),
('610327', '610300', '陇县', '0', '0', '', '2', '1', null),
('610328', '610300', '千阳县', '0', '0', '', '2', '1', null),
('610329', '610300', '麟游县', '0', '0', '', '2', '1', null),
('610330', '610300', '凤县', '0', '0', '', '2', '1', null),
('610331', '610300', '太白县', '0', '0', '', '2', '1', null),
('610400', '610000', '咸阳市', '0', '0', 'X', '1', '1', null),
('610402', '610400', '秦都区', '0', '0', '', '2', '1', null),
('610403', '610400', '杨陵区', '0', '0', '', '2', '1', null),
('610404', '610400', '渭城区', '0', '0', '', '2', '1', null),
('610422', '610400', '三原县', '0', '0', '', '2', '1', null),
('610423', '610400', '泾阳县', '0', '0', '', '2', '1', null),
('610424', '610400', '乾县', '0', '0', '', '2', '1', null),
('610425', '610400', '礼泉县', '0', '0', '', '2', '1', null),
('610426', '610400', '永寿县', '0', '0', '', '2', '1', null),
('610427', '610400', '彬县', '0', '0', '', '2', '1', null),
('610428', '610400', '长武县', '0', '0', '', '2', '1', null),
('610429', '610400', '旬邑县', '0', '0', '', '2', '1', null),
('610430', '610400', '淳化县', '0', '0', '', '2', '1', null),
('610431', '610400', '武功县', '0', '0', '', '2', '1', null),
('610481', '610400', '兴平市', '0', '0', '', '2', '1', null),
('610500', '610000', '渭南市', '0', '0', 'W', '1', '1', null),
('610502', '610500', '临渭区', '0', '0', '', '2', '1', null),
('610521', '610500', '华县', '0', '0', '', '2', '1', null),
('610522', '610500', '潼关县', '0', '0', '', '2', '1', null),
('610523', '610500', '大荔县', '0', '0', '', '2', '1', null),
('610524', '610500', '合阳县', '0', '0', '', '2', '1', null),
('610525', '610500', '澄城县', '0', '0', '', '2', '1', null),
('610526', '610500', '蒲城县', '0', '0', '', '2', '1', null),
('610527', '610500', '白水县', '0', '0', '', '2', '1', null),
('610528', '610500', '富平县', '0', '0', '', '2', '1', null),
('610581', '610500', '韩城市', '0', '0', '', '2', '1', null),
('610582', '610500', '华阴市', '0', '0', '', '2', '1', null),
('610600', '610000', '延安市', '0', '0', 'Y', '1', '1', null),
('610602', '610600', '宝塔区', '0', '0', '', '2', '1', null),
('610621', '610600', '延长县', '0', '0', '', '2', '1', null),
('610622', '610600', '延川县', '0', '0', '', '2', '1', null),
('610623', '610600', '子长县', '0', '0', '', '2', '1', null),
('610624', '610600', '安塞县', '0', '0', '', '2', '1', null),
('610625', '610600', '志丹县', '0', '0', '', '2', '1', null),
('610626', '610600', '吴起县', '0', '0', '', '2', '1', null),
('610627', '610600', '甘泉县', '0', '0', '', '2', '1', null),
('610628', '610600', '富县', '0', '0', '', '2', '1', null),
('610629', '610600', '洛川县', '0', '0', '', '2', '1', null),
('610630', '610600', '宜川县', '0', '0', '', '2', '1', null),
('610631', '610600', '黄龙县', '0', '0', '', '2', '1', null),
('610632', '610600', '黄陵县', '0', '0', '', '2', '1', null),
('610700', '610000', '汉中市', '0', '0', 'H', '1', '1', null),
('610702', '610700', '汉台区', '0', '0', '', '2', '1', null),
('610721', '610700', '南郑县', '0', '0', '', '2', '1', null),
('610722', '610700', '城固县', '0', '0', '', '2', '1', null),
('610723', '610700', '洋县', '0', '0', '', '2', '1', null),
('610724', '610700', '西乡县', '0', '0', '', '2', '1', null),
('610725', '610700', '勉县', '0', '0', '', '2', '1', null),
('610726', '610700', '宁强县', '0', '0', '', '2', '1', null),
('610727', '610700', '略阳县', '0', '0', '', '2', '1', null),
('610728', '610700', '镇巴县', '0', '0', '', '2', '1', null),
('610729', '610700', '留坝县', '0', '0', '', '2', '1', null),
('610730', '610700', '佛坪县', '0', '0', '', '2', '1', null),
('610800', '610000', '榆林市', '0', '0', 'Y', '1', '1', null),
('610802', '610800', '榆阳区', '0', '0', '', '2', '1', null),
('610821', '610800', '神木县', '0', '0', '', '2', '1', null),
('610822', '610800', '府谷县', '0', '0', '', '2', '1', null),
('610823', '610800', '横山县', '0', '0', '', '2', '1', null),
('610824', '610800', '靖边县', '0', '0', '', '2', '1', null),
('610825', '610800', '定边县', '0', '0', '', '2', '1', null),
('610826', '610800', '绥德县', '0', '0', '', '2', '1', null),
('610827', '610800', '米脂县', '0', '0', '', '2', '1', null),
('610828', '610800', '佳县', '0', '0', '', '2', '1', null),
('610829', '610800', '吴堡县', '0', '0', '', '2', '1', null),
('610830', '610800', '清涧县', '0', '0', '', '2', '1', null),
('610831', '610800', '子洲县', '0', '0', '', '2', '1', null),
('610900', '610000', '安康市', '0', '0', 'A', '1', '1', null),
('610902', '610900', '汉滨区', '0', '0', '', '2', '1', null),
('610921', '610900', '汉阴县', '0', '0', '', '2', '1', null),
('610922', '610900', '石泉县', '0', '0', '', '2', '1', null),
('610923', '610900', '宁陕县', '0', '0', '', '2', '1', null),
('610924', '610900', '紫阳县', '0', '0', '', '2', '1', null),
('610925', '610900', '岚皋县', '0', '0', '', '2', '1', null),
('610926', '610900', '平利县', '0', '0', '', '2', '1', null),
('610927', '610900', '镇坪县', '0', '0', '', '2', '1', null),
('610928', '610900', '旬阳县', '0', '0', '', '2', '1', null),
('610929', '610900', '白河县', '0', '0', '', '2', '1', null),
('611000', '610000', '商洛市', '0', '0', 'S', '1', '1', null),
('611002', '611000', '商州区', '0', '0', '', '2', '1', null),
('611021', '611000', '洛南县', '0', '0', '', '2', '1', null),
('611022', '611000', '丹凤县', '0', '0', '', '2', '1', null),
('611023', '611000', '商南县', '0', '0', '', '2', '1', null),
('611024', '611000', '山阳县', '0', '0', '', '2', '1', null),
('611025', '611000', '镇安县', '0', '0', '', '2', '1', null),
('611026', '611000', '柞水县', '0', '0', '', '2', '1', null),
('620000', '0', '甘肃省', '1', '0', '', '0', '1', null),
('620100', '620000', '兰州市', '1', '0', 'L', '1', '1', null),
('620102', '620100', '城关区', '1', '0', '', '2', '1', null),
('620103', '620100', '七里河区', '1', '0', '', '2', '1', null),
('620104', '620100', '西固区', '1', '0', '', '2', '1', null),
('620105', '620100', '安宁区', '1', '0', '', '2', '1', null),
('620111', '620100', '红古区', '1', '0', '', '2', '1', null),
('620121', '620100', '永登县', '1', '0', '', '2', '1', null),
('620122', '620100', '皋兰县', '1', '0', '', '2', '1', null),
('620123', '620100', '榆中县', '1', '0', '', '2', '1', null),
('620200', '620000', '嘉峪关市', '1', '0', 'J', '1', '1', null),
('620300', '620000', '金昌市', '1', '0', 'J', '1', '1', null),
('620302', '620300', '金川区', '1', '0', '', '2', '1', null),
('620321', '620300', '永昌县', '1', '0', '', '2', '1', null),
('620400', '620000', '白银市', '1', '0', 'B', '1', '1', null),
('620402', '620400', '白银区', '1', '0', '', '2', '1', null),
('620403', '620400', '平川区', '1', '0', '', '2', '1', null),
('620421', '620400', '靖远县', '1', '0', '', '2', '1', null),
('620422', '620400', '会宁县', '1', '0', '', '2', '1', null),
('620423', '620400', '景泰县', '1', '0', '', '2', '1', null),
('620500', '620000', '天水市', '1', '0', 'T', '1', '1', null),
('620502', '620500', '秦州区', '1', '0', '', '2', '1', null),
('620503', '620500', '麦积区', '1', '0', '', '2', '1', null),
('620521', '620500', '清水县', '1', '0', '', '2', '1', null),
('620522', '620500', '秦安县', '1', '0', '', '2', '1', null),
('620523', '620500', '甘谷县', '1', '0', '', '2', '1', null),
('620524', '620500', '武山县', '1', '0', '', '2', '1', null);
INSERT INTO `wst_areas` VALUES ('620525', '620500', '张家川回族自治县', '1', '0', '', '2', '1', null),
('620600', '620000', '武威市', '1', '0', 'W', '1', '1', null),
('620602', '620600', '凉州区', '1', '0', '', '2', '1', null),
('620621', '620600', '民勤县', '1', '0', '', '2', '1', null),
('620622', '620600', '古浪县', '1', '0', '', '2', '1', null),
('620623', '620600', '天祝藏族自治县', '1', '0', '', '2', '1', null),
('620700', '620000', '张掖市', '1', '0', 'Z', '1', '1', null),
('620702', '620700', '甘州区', '1', '0', '', '2', '1', null),
('620721', '620700', '肃南裕固族自治县', '1', '0', '', '2', '1', null),
('620722', '620700', '民乐县', '1', '0', '', '2', '1', null),
('620723', '620700', '临泽县', '1', '0', '', '2', '1', null),
('620724', '620700', '高台县', '1', '0', '', '2', '1', null),
('620725', '620700', '山丹县', '1', '0', '', '2', '1', null),
('620800', '620000', '平凉市', '1', '0', 'P', '1', '1', null),
('620802', '620800', '崆峒区', '1', '0', '', '2', '1', null),
('620821', '620800', '泾川县', '1', '0', '', '2', '1', null),
('620822', '620800', '灵台县', '1', '0', '', '2', '1', null),
('620823', '620800', '崇信县', '1', '0', '', '2', '1', null),
('620824', '620800', '华亭县', '1', '0', '', '2', '1', null),
('620825', '620800', '庄浪县', '1', '0', '', '2', '1', null),
('620826', '620800', '静宁县', '1', '0', '', '2', '1', null),
('620900', '620000', '酒泉市', '1', '0', 'J', '1', '1', null),
('620902', '620900', '肃州区', '1', '0', '', '2', '1', null),
('620921', '620900', '金塔县', '1', '0', '', '2', '1', null),
('620922', '620900', '瓜州县', '1', '0', '', '2', '1', null),
('620923', '620900', '肃北蒙古族自治县', '1', '0', '', '2', '1', null),
('620924', '620900', '阿克塞哈萨克族自治县', '1', '0', '', '2', '1', null),
('620981', '620900', '玉门市', '1', '0', '', '2', '1', null),
('620982', '620900', '敦煌市', '1', '0', '', '2', '1', null),
('621000', '620000', '庆阳市', '1', '0', 'Q', '1', '1', null),
('621002', '621000', '西峰区', '1', '0', '', '2', '1', null),
('621021', '621000', '庆城县', '1', '0', '', '2', '1', null),
('621022', '621000', '环县', '1', '0', '', '2', '1', null),
('621023', '621000', '华池县', '1', '0', '', '2', '1', null),
('621024', '621000', '合水县', '1', '0', '', '2', '1', null),
('621025', '621000', '正宁县', '1', '0', '', '2', '1', null),
('621026', '621000', '宁县', '1', '0', '', '2', '1', null),
('621027', '621000', '镇原县', '1', '0', '', '2', '1', null),
('621100', '620000', '定西市', '1', '0', 'D', '1', '1', null),
('621102', '621100', '安定区', '1', '0', '', '2', '1', null),
('621121', '621100', '通渭县', '1', '0', '', '2', '1', null),
('621122', '621100', '陇西县', '1', '0', '', '2', '1', null),
('621123', '621100', '渭源县', '1', '0', '', '2', '1', null),
('621124', '621100', '临洮县', '1', '0', '', '2', '1', null),
('621125', '621100', '漳县', '1', '0', '', '2', '1', null),
('621126', '621100', '岷县', '1', '0', '', '2', '1', null),
('621200', '620000', '陇南市', '1', '0', 'L', '1', '1', null),
('621202', '621200', '武都区', '1', '0', '', '2', '1', null),
('621221', '621200', '成县', '1', '0', '', '2', '1', null),
('621222', '621200', '文县', '1', '0', '', '2', '1', null),
('621223', '621200', '宕昌县', '1', '0', '', '2', '1', null),
('621224', '621200', '康县', '1', '0', '', '2', '1', null),
('621225', '621200', '西和县', '1', '0', '', '2', '1', null),
('621226', '621200', '礼县', '1', '0', '', '2', '1', null),
('621227', '621200', '徽县', '1', '0', '', '2', '1', null),
('621228', '621200', '两当县', '1', '0', '', '2', '1', null),
('622900', '620000', '临夏回族自治州', '1', '0', 'L', '1', '1', null),
('622901', '622900', '临夏市', '1', '0', '', '2', '1', null),
('622921', '622900', '临夏县', '1', '0', '', '2', '1', null),
('622922', '622900', '康乐县', '1', '0', '', '2', '1', null),
('622923', '622900', '永靖县', '1', '0', '', '2', '1', null),
('622924', '622900', '广河县', '1', '0', '', '2', '1', null),
('622925', '622900', '和政县', '1', '0', '', '2', '1', null),
('622926', '622900', '东乡族自治县', '1', '0', '', '2', '1', null),
('622927', '622900', '积石山保安族东乡族撒拉族自治县', '1', '0', '', '2', '1', null),
('623000', '620000', '甘南藏族自治州', '1', '0', 'G', '1', '1', null),
('623001', '623000', '合作市', '1', '0', '', '2', '1', null),
('623021', '623000', '临潭县', '1', '0', '', '2', '1', null),
('623022', '623000', '卓尼县', '1', '0', '', '2', '1', null),
('623023', '623000', '舟曲县', '1', '0', '', '2', '1', null),
('623024', '623000', '迭部县', '1', '0', '', '2', '1', null),
('623025', '623000', '玛曲县', '1', '0', '', '2', '1', null),
('623026', '623000', '碌曲县', '1', '0', '', '2', '1', null),
('623027', '623000', '夏河县', '1', '0', '', '2', '1', null),
('630000', '0', '青海省', '0', '0', '', '0', '1', null),
('630100', '630000', '西宁市', '0', '0', 'X', '1', '1', null),
('630102', '630100', '城东区', '0', '0', '', '2', '1', null),
('630103', '630100', '城中区', '0', '0', '', '2', '1', null),
('630104', '630100', '城西区', '0', '0', '', '2', '1', null),
('630105', '630100', '城北区', '0', '0', '', '2', '1', null),
('630121', '630100', '大通回族土族自治县', '0', '0', '', '2', '1', null),
('630122', '630100', '湟中县', '0', '0', '', '2', '1', null),
('630123', '630100', '湟源县', '0', '0', '', '2', '1', null),
('630200', '630000', '海东市', '0', '0', 'H', '1', '1', null),
('630202', '630200', '乐都区', '0', '0', '', '2', '1', null),
('630203', '630200', '平安区', '0', '0', '', '2', '1', null),
('630222', '630200', '民和回族土族自治县', '0', '0', '', '2', '1', null),
('630223', '630200', '互助土族自治县', '0', '0', '', '2', '1', null),
('630224', '630200', '化隆回族自治县', '0', '0', '', '2', '1', null),
('630225', '630200', '循化撒拉族自治县', '0', '0', '', '2', '1', null),
('632200', '630000', '海北藏族自治州', '0', '0', 'H', '1', '1', null),
('632221', '632200', '门源回族自治县', '0', '0', '', '2', '1', null),
('632222', '632200', '祁连县', '0', '0', '', '2', '1', null),
('632223', '632200', '海晏县', '0', '0', '', '2', '1', null),
('632224', '632200', '刚察县', '0', '0', '', '2', '1', null),
('632300', '630000', '黄南藏族自治州', '0', '0', 'H', '1', '1', null),
('632321', '632300', '同仁县', '0', '0', '', '2', '1', null),
('632322', '632300', '尖扎县', '0', '0', '', '2', '1', null),
('632323', '632300', '泽库县', '0', '0', '', '2', '1', null),
('632324', '632300', '河南蒙古族自治县', '0', '0', '', '2', '1', null),
('632500', '630000', '海南藏族自治州', '0', '0', 'H', '1', '1', null),
('632521', '632500', '共和县', '0', '0', '', '2', '1', null),
('632522', '632500', '同德县', '0', '0', '', '2', '1', null),
('632523', '632500', '贵德县', '0', '0', '', '2', '1', null),
('632524', '632500', '兴海县', '0', '0', '', '2', '1', null),
('632525', '632500', '贵南县', '0', '0', '', '2', '1', null),
('632600', '630000', '果洛藏族自治州', '0', '0', 'G', '1', '1', null),
('632621', '632600', '玛沁县', '0', '0', '', '2', '1', null),
('632622', '632600', '班玛县', '0', '0', '', '2', '1', null),
('632623', '632600', '甘德县', '0', '0', '', '2', '1', null),
('632624', '632600', '达日县', '0', '0', '', '2', '1', null),
('632625', '632600', '久治县', '0', '0', '', '2', '1', null),
('632626', '632600', '玛多县', '0', '0', '', '2', '1', null),
('632700', '630000', '玉树藏族自治州', '0', '0', 'Y', '1', '1', null),
('632701', '632700', '玉树市', '0', '0', '', '2', '1', null),
('632722', '632700', '杂多县', '0', '0', '', '2', '1', null),
('632723', '632700', '称多县', '0', '0', '', '2', '1', null),
('632724', '632700', '治多县', '0', '0', '', '2', '1', null),
('632725', '632700', '囊谦县', '0', '0', '', '2', '1', null),
('632726', '632700', '曲麻莱县', '0', '0', '', '2', '1', null),
('632800', '630000', '海西蒙古族藏族自治州', '0', '0', 'H', '1', '1', null),
('632801', '632800', '格尔木市', '0', '0', '', '2', '1', null),
('632802', '632800', '德令哈市', '0', '0', '', '2', '1', null),
('632821', '632800', '乌兰县', '0', '0', '', '2', '1', null),
('632822', '632800', '都兰县', '0', '0', '', '2', '1', null),
('632823', '632800', '天峻县', '0', '0', '', '2', '1', null),
('640000', '0', '宁夏回族自治区', '0', '0', '', '0', '1', null),
('640100', '640000', '银川市', '0', '0', 'Y', '1', '1', null),
('640104', '640100', '兴庆区', '0', '0', '', '2', '1', null),
('640105', '640100', '西夏区', '0', '0', '', '2', '1', null),
('640106', '640100', '金凤区', '0', '0', '', '2', '1', null),
('640121', '640100', '永宁县', '0', '0', '', '2', '1', null),
('640122', '640100', '贺兰县', '0', '0', '', '2', '1', null),
('640181', '640100', '灵武市', '0', '0', '', '2', '1', null),
('640200', '640000', '石嘴山市', '0', '0', 'S', '1', '1', null),
('640202', '640200', '大武口区', '0', '0', '', '2', '1', null),
('640205', '640200', '惠农区', '0', '0', '', '2', '1', null),
('640221', '640200', '平罗县', '0', '0', '', '2', '1', null),
('640300', '640000', '吴忠市', '0', '0', 'W', '1', '1', null),
('640302', '640300', '利通区', '0', '0', '', '2', '1', null),
('640303', '640300', '红寺堡区', '0', '0', '', '2', '1', null),
('640323', '640300', '盐池县', '0', '0', '', '2', '1', null),
('640324', '640300', '同心县', '0', '0', '', '2', '1', null),
('640381', '640300', '青铜峡市', '0', '0', '', '2', '1', null),
('640400', '640000', '固原市', '0', '0', 'G', '1', '1', null),
('640402', '640400', '原州区', '0', '0', '', '2', '1', null),
('640422', '640400', '西吉县', '0', '0', '', '2', '1', null),
('640423', '640400', '隆德县', '0', '0', '', '2', '1', null),
('640424', '640400', '泾源县', '0', '0', '', '2', '1', null),
('640425', '640400', '彭阳县', '0', '0', '', '2', '1', null),
('640500', '640000', '中卫市', '0', '0', 'Z', '1', '1', null),
('640502', '640500', '沙坡头区', '0', '0', '', '2', '1', null),
('640521', '640500', '中宁县', '0', '0', '', '2', '1', null),
('640522', '640500', '海原县', '0', '0', '', '2', '1', null),
('650000', '0', '新疆维吾尔自治区', '0', '0', '', '0', '1', null),
('650100', '650000', '乌鲁木齐市', '0', '0', 'W', '1', '1', null),
('650102', '650100', '天山区', '0', '0', '', '2', '1', null),
('650103', '650100', '沙依巴克区', '0', '0', '', '2', '1', null),
('650104', '650100', '新市区', '0', '0', '', '2', '1', null),
('650105', '650100', '水磨沟区', '0', '0', '', '2', '1', null),
('650106', '650100', '头屯河区', '0', '0', '', '2', '1', null),
('650107', '650100', '达坂城区', '0', '0', '', '2', '1', null),
('650109', '650100', '米东区', '0', '0', '', '2', '1', null),
('650121', '650100', '乌鲁木齐县', '0', '0', '', '2', '1', null),
('650200', '650000', '克拉玛依市', '0', '0', 'K', '1', '1', null),
('650202', '650200', '独山子区', '0', '0', '', '2', '1', null),
('650203', '650200', '克拉玛依区', '0', '0', '', '2', '1', null),
('650204', '650200', '白碱滩区', '0', '0', '', '2', '1', null),
('650205', '650200', '乌尔禾区', '0', '0', '', '2', '1', null),
('650400', '650000', '吐鲁番市', '0', '0', 'T', '1', '1', null),
('650402', '650400', '高昌区', '0', '0', '', '2', '1', null),
('650421', '650400', '鄯善县', '0', '0', '', '2', '1', null),
('650422', '650400', '托克逊县', '0', '0', '', '2', '1', null),
('652200', '650000', '哈密地区', '0', '0', 'H', '1', '1', null),
('652201', '652200', '哈密市', '0', '0', '', '2', '1', null),
('652222', '652200', '巴里坤哈萨克自治县', '0', '0', '', '2', '1', null),
('652223', '652200', '伊吾县', '0', '0', '', '2', '1', null),
('652300', '650000', '昌吉回族自治州', '0', '0', 'C', '1', '1', null),
('652301', '652300', '昌吉市', '0', '0', '', '2', '1', null),
('652302', '652300', '阜康市', '0', '0', '', '2', '1', null),
('652323', '652300', '呼图壁县', '0', '0', '', '2', '1', null),
('652324', '652300', '玛纳斯县', '0', '0', '', '2', '1', null),
('652325', '652300', '奇台县', '0', '0', '', '2', '1', null),
('652327', '652300', '吉木萨尔县', '0', '0', '', '2', '1', null),
('652328', '652300', '木垒哈萨克自治县', '0', '0', '', '2', '1', null),
('652700', '650000', '博尔塔拉蒙古自治州', '0', '0', 'B', '1', '1', null),
('652701', '652700', '博乐市', '0', '0', '', '2', '1', null),
('652702', '652700', '阿拉山口市', '0', '0', '', '2', '1', null),
('652722', '652700', '精河县', '0', '0', '', '2', '1', null),
('652723', '652700', '温泉县', '0', '0', '', '2', '1', null),
('652800', '650000', '巴音郭楞蒙古自治州', '0', '0', 'B', '1', '1', null),
('652801', '652800', '库尔勒市', '0', '0', '', '2', '1', null),
('652822', '652800', '轮台县', '0', '0', '', '2', '1', null),
('652823', '652800', '尉犁县', '0', '0', '', '2', '1', null),
('652824', '652800', '若羌县', '0', '0', '', '2', '1', null),
('652825', '652800', '且末县', '0', '0', '', '2', '1', null),
('652826', '652800', '焉耆回族自治县', '0', '0', '', '2', '1', null),
('652827', '652800', '和静县', '0', '0', '', '2', '1', null),
('652828', '652800', '和硕县', '0', '0', '', '2', '1', null),
('652829', '652800', '博湖县', '0', '0', '', '2', '1', null),
('652900', '650000', '阿克苏地区', '0', '0', 'A', '1', '1', null),
('652901', '652900', '阿克苏市', '0', '0', '', '2', '1', null),
('652922', '652900', '温宿县', '0', '0', '', '2', '1', null),
('652923', '652900', '库车县', '0', '0', '', '2', '1', null),
('652924', '652900', '沙雅县', '0', '0', '', '2', '1', null),
('652925', '652900', '新和县', '0', '0', '', '2', '1', null),
('652926', '652900', '拜城县', '0', '0', '', '2', '1', null),
('652927', '652900', '乌什县', '0', '0', '', '2', '1', null),
('652928', '652900', '阿瓦提县', '0', '0', '', '2', '1', null),
('652929', '652900', '柯坪县', '0', '0', '', '2', '1', null),
('653000', '650000', '克孜勒苏柯尔克孜自治州', '0', '0', 'K', '1', '1', null),
('653001', '653000', '阿图什市', '0', '0', '', '2', '1', null),
('653022', '653000', '阿克陶县', '0', '0', '', '2', '1', null),
('653023', '653000', '阿合奇县', '0', '0', '', '2', '1', null),
('653024', '653000', '乌恰县', '0', '0', '', '2', '1', null),
('653100', '650000', '喀什地区', '0', '0', 'K', '1', '1', null),
('653101', '653100', '喀什市', '0', '0', '', '2', '1', null),
('653121', '653100', '疏附县', '0', '0', '', '2', '1', null),
('653122', '653100', '疏勒县', '0', '0', '', '2', '1', null),
('653123', '653100', '英吉沙县', '0', '0', '', '2', '1', null),
('653124', '653100', '泽普县', '0', '0', '', '2', '1', null),
('653125', '653100', '莎车县', '0', '0', '', '2', '1', null),
('653126', '653100', '叶城县', '0', '0', '', '2', '1', null),
('653127', '653100', '麦盖提县', '0', '0', '', '2', '1', null),
('653128', '653100', '岳普湖县', '0', '0', '', '2', '1', null),
('653129', '653100', '伽师县', '0', '0', '', '2', '1', null),
('653130', '653100', '巴楚县', '0', '0', '', '2', '1', null),
('653131', '653100', '塔什库尔干塔吉克自治县', '0', '0', '', '2', '1', null),
('653200', '650000', '和田地区', '0', '0', 'H', '1', '1', null),
('653201', '653200', '和田市', '0', '0', '', '2', '1', null),
('653221', '653200', '和田县', '0', '0', '', '2', '1', null),
('653222', '653200', '墨玉县', '0', '0', '', '2', '1', null),
('653223', '653200', '皮山县', '0', '0', '', '2', '1', null),
('653224', '653200', '洛浦县', '0', '0', '', '2', '1', null),
('653225', '653200', '策勒县', '0', '0', '', '2', '1', null),
('653226', '653200', '于田县', '0', '0', '', '2', '1', null),
('653227', '653200', '民丰县', '0', '0', '', '2', '1', null),
('654000', '650000', '伊犁哈萨克自治州', '0', '0', 'Y', '1', '1', null),
('654002', '654000', '伊宁市', '0', '0', '', '2', '1', null),
('654003', '654000', '奎屯市', '0', '0', '', '2', '1', null),
('654004', '654000', '霍尔果斯市', '0', '0', '', '2', '1', null),
('654005', '654000', '(新源市)', '0', '0', '', '2', '1', null),
('654021', '654000', '伊宁县', '0', '0', '', '2', '1', null),
('654022', '654000', '察布查尔锡伯自治县', '0', '0', '', '2', '1', null),
('654023', '654000', '霍城县', '0', '0', '', '2', '1', null),
('654024', '654000', '巩留县', '0', '0', '', '2', '1', null),
('654025', '654000', '新源县', '0', '0', '', '2', '1', null),
('654026', '654000', '昭苏县', '0', '0', '', '2', '1', null),
('654027', '654000', '特克斯县', '0', '0', '', '2', '1', null),
('654028', '654000', '尼勒克县', '0', '0', '', '2', '1', null),
('654200', '650000', '塔城地区', '0', '0', 'T', '1', '1', null),
('654201', '654200', '塔城市', '0', '0', '', '2', '1', null),
('654202', '654200', '乌苏市', '0', '0', '', '2', '1', null),
('654221', '654200', '额敏县', '0', '0', '', '2', '1', null),
('654223', '654200', '沙湾县', '0', '0', '', '2', '1', null),
('654224', '654200', '托里县', '0', '0', '', '2', '1', null),
('654225', '654200', '裕民县', '0', '0', '', '2', '1', null),
('654226', '654200', '和布克赛尔蒙古自治县', '0', '0', '', '2', '1', null),
('654300', '650000', '阿勒泰地区', '0', '0', 'A', '1', '1', null),
('654301', '654300', '阿勒泰市', '0', '0', '', '2', '1', null),
('654321', '654300', '布尔津县', '0', '0', '', '2', '1', null),
('654322', '654300', '富蕴县', '0', '0', '', '2', '1', null),
('654323', '654300', '福海县', '0', '0', '', '2', '1', null),
('654324', '654300', '哈巴河县', '0', '0', '', '2', '1', null),
('654325', '654300', '青河县', '0', '0', '', '2', '1', null),
('654326', '654300', '吉木乃县', '0', '0', '', '2', '1', null),
('659000', '650000', '自治区直辖县级行政区划', '0', '0', 'Z', '1', '1', null),
('659001', '659000', '石河子市', '0', '0', '', '2', '1', null),
('659002', '659000', '阿拉尔市', '0', '0', '', '2', '1', null),
('659003', '659000', '图木舒克市', '0', '0', '', '2', '1', null),
('659004', '659000', '五家渠市', '0', '0', '', '2', '1', null),
('659005', '659000', '北屯市', '0', '0', '', '2', '1', null),
('659006', '659000', '铁门关市', '0', '0', '', '2', '1', null),
('659007', '659000', '双河市', '0', '0', '', '2', '1', null),
('659008', '659000', '可克达拉市', '0', '0', '', '2', '1', null),
('659009', '659000', '(胡杨河市)', '0', '0', '', '2', '1', null),
('710000', '0', '台湾省', '0', '0', '', '0', '1', null),
('710100', '710000', '台北市', '0', '0', 'T', '1', '1', null),
('710101', '710100', '松山区', '0', '0', '', '2', '1', null),
('710102', '710100', '信义区', '0', '0', '', '2', '1', null),
('710103', '710100', '大安区', '0', '0', '', '2', '1', null),
('710104', '710100', '中山区', '0', '0', '', '2', '1', null),
('710105', '710100', '中正区', '0', '0', '', '2', '1', null),
('710106', '710100', '大同区', '0', '0', '', '2', '1', null),
('710107', '710100', '万华区', '0', '0', '', '2', '1', null),
('710108', '710100', '文山区', '0', '0', '', '2', '1', null),
('710109', '710100', '南港区', '0', '0', '', '2', '1', null),
('710110', '710100', '内湖区', '0', '0', '', '2', '1', null),
('710111', '710100', '士林区', '0', '0', '', '2', '1', null),
('710112', '710100', '北投区', '0', '0', '', '2', '1', null),
('710200', '710000', '高雄市', '0', '0', 'G', '1', '1', null),
('710201', '710200', '盐埕区', '0', '0', '', '2', '1', null),
('710202', '710200', '鼓山区', '0', '0', '', '2', '1', null),
('710203', '710200', '左营区', '0', '0', '', '2', '1', null),
('710204', '710200', '楠梓区', '0', '0', '', '2', '1', null),
('710205', '710200', '三民区', '0', '0', '', '2', '1', null),
('710206', '710200', '新兴区', '0', '0', '', '2', '1', null),
('710207', '710200', '前金区', '0', '0', '', '2', '1', null),
('710208', '710200', '苓雅区', '0', '0', '', '2', '1', null),
('710209', '710200', '前镇区', '0', '0', '', '2', '1', null),
('710210', '710200', '旗津区', '0', '0', '', '2', '1', null),
('710211', '710200', '小港区', '0', '0', '', '2', '1', null),
('710212', '710200', '凤山区', '0', '0', '', '2', '1', null),
('710213', '710200', '林园区', '0', '0', '', '2', '1', null),
('710214', '710200', '大寮区', '0', '0', '', '2', '1', null),
('710215', '710200', '大树区', '0', '0', '', '2', '1', null),
('710216', '710200', '大社区', '0', '0', '', '2', '1', null),
('710217', '710200', '仁武区', '0', '0', '', '2', '1', null),
('710218', '710200', '鸟松区', '0', '0', '', '2', '1', null),
('710219', '710200', '冈山区', '0', '0', '', '2', '1', null),
('710220', '710200', '桥头区', '0', '0', '', '2', '1', null),
('710221', '710200', '燕巢区', '0', '0', '', '2', '1', null),
('710222', '710200', '田寮区', '0', '0', '', '2', '1', null),
('710223', '710200', '阿莲区', '0', '0', '', '2', '1', null),
('710224', '710200', '路竹区', '0', '0', '', '2', '1', null),
('710225', '710200', '湖内区', '0', '0', '', '2', '1', null),
('710226', '710200', '茄萣区', '0', '0', '', '2', '1', null),
('710227', '710200', '永安区', '0', '0', '', '2', '1', null),
('710228', '710200', '弥陀区', '0', '0', '', '2', '1', null),
('710229', '710200', '梓官区', '0', '0', '', '2', '1', null),
('710230', '710200', '旗山区', '0', '0', '', '2', '1', null),
('710231', '710200', '美浓区', '0', '0', '', '2', '1', null),
('710232', '710200', '六龟区', '0', '0', '', '2', '1', null),
('710233', '710200', '甲仙区', '0', '0', '', '2', '1', null),
('710234', '710200', '杉林区', '0', '0', '', '2', '1', null),
('710235', '710200', '内门区', '0', '0', '', '2', '1', null),
('710236', '710200', '茂林区', '0', '0', '', '2', '1', null),
('710237', '710200', '桃源区', '0', '0', '', '2', '1', null);
INSERT INTO `wst_areas` VALUES ('710238', '710200', '那玛夏区', '0', '0', '', '2', '1', null),
('710300', '710000', '基隆市', '0', '0', 'J', '1', '1', null),
('710301', '710300', '中正区', '0', '0', '', '2', '1', null),
('710302', '710300', '七堵区', '0', '0', '', '2', '1', null),
('710303', '710300', '暖暖区', '0', '0', '', '2', '1', null),
('710304', '710300', '仁爱区', '0', '0', '', '2', '1', null),
('710305', '710300', '中山区', '0', '0', '', '2', '1', null),
('710306', '710300', '安乐区', '0', '0', '', '2', '1', null),
('710307', '710300', '信义区', '0', '0', '', '2', '1', null),
('710400', '710000', '台中市', '0', '0', 'T', '1', '1', null),
('710401', '710400', '中区', '0', '0', '', '2', '1', null),
('710402', '710400', '东区', '0', '0', '', '2', '1', null),
('710403', '710400', '南区', '0', '0', '', '2', '1', null),
('710404', '710400', '西区', '0', '0', '', '2', '1', null),
('710405', '710400', '北区', '0', '0', '', '2', '1', null),
('710406', '710400', '西屯区', '0', '0', '', '2', '1', null),
('710407', '710400', '南屯区', '0', '0', '', '2', '1', null),
('710408', '710400', '北屯区', '0', '0', '', '2', '1', null),
('710409', '710400', '丰原区', '0', '0', '', '2', '1', null),
('710410', '710400', '东势区', '0', '0', '', '2', '1', null),
('710411', '710400', '大甲区', '0', '0', '', '2', '1', null),
('710412', '710400', '清水区', '0', '0', '', '2', '1', null),
('710413', '710400', '沙鹿区', '0', '0', '', '2', '1', null),
('710414', '710400', '梧栖区', '0', '0', '', '2', '1', null),
('710415', '710400', '后里区', '0', '0', '', '2', '1', null),
('710416', '710400', '神冈区', '0', '0', '', '2', '1', null),
('710417', '710400', '潭子区', '0', '0', '', '2', '1', null),
('710418', '710400', '大雅区', '0', '0', '', '2', '1', null),
('710419', '710400', '新社区', '0', '0', '', '2', '1', null),
('710420', '710400', '石冈区', '0', '0', '', '2', '1', null),
('710421', '710400', '外埔区', '0', '0', '', '2', '1', null),
('710422', '710400', '大安区', '0', '0', '', '2', '1', null),
('710423', '710400', '乌日区', '0', '0', '', '2', '1', null),
('710424', '710400', '大肚区', '0', '0', '', '2', '1', null),
('710425', '710400', '龙井区', '0', '0', '', '2', '1', null),
('710426', '710400', '雾峰区', '0', '0', '', '2', '1', null),
('710427', '710400', '太平区', '0', '0', '', '2', '1', null),
('710428', '710400', '大里区', '0', '0', '', '2', '1', null),
('710429', '710400', '和平区', '0', '0', '', '2', '1', null),
('710500', '710000', '台南市', '0', '0', 'T', '1', '1', null),
('710501', '710500', '东区', '0', '0', '', '2', '1', null),
('710502', '710500', '南区', '0', '0', '', '2', '1', null),
('710504', '710500', '北区', '0', '0', '', '2', '1', null),
('710506', '710500', '安南区', '0', '0', '', '2', '1', null),
('710507', '710500', '安平区', '0', '0', '', '2', '1', null),
('710508', '710500', '中西区', '0', '0', '', '2', '1', null),
('710509', '710500', '新营区', '0', '0', '', '2', '1', null),
('710510', '710500', '盐水区', '0', '0', '', '2', '1', null),
('710511', '710500', '白河区', '0', '0', '', '2', '1', null),
('710512', '710500', '柳营区', '0', '0', '', '2', '1', null),
('710513', '710500', '后壁区', '0', '0', '', '2', '1', null),
('710514', '710500', '东山区', '0', '0', '', '2', '1', null),
('710515', '710500', '麻豆区', '0', '0', '', '2', '1', null),
('710516', '710500', '下营区', '0', '0', '', '2', '1', null),
('710517', '710500', '六甲区', '0', '0', '', '2', '1', null),
('710518', '710500', '官田区', '0', '0', '', '2', '1', null),
('710519', '710500', '大内区', '0', '0', '', '2', '1', null),
('710520', '710500', '佳里区', '0', '0', '', '2', '1', null),
('710521', '710500', '学甲区', '0', '0', '', '2', '1', null),
('710522', '710500', '西港区', '0', '0', '', '2', '1', null),
('710523', '710500', '七股区', '0', '0', '', '2', '1', null),
('710524', '710500', '将军区', '0', '0', '', '2', '1', null),
('710525', '710500', '北门区', '0', '0', '', '2', '1', null),
('710526', '710500', '新化区', '0', '0', '', '2', '1', null),
('710527', '710500', '善化区', '0', '0', '', '2', '1', null),
('710528', '710500', '新市区', '0', '0', '', '2', '1', null),
('710529', '710500', '安定区', '0', '0', '', '2', '1', null),
('710530', '710500', '山上区', '0', '0', '', '2', '1', null),
('710531', '710500', '玉井区', '0', '0', '', '2', '1', null),
('710532', '710500', '楠西区', '0', '0', '', '2', '1', null),
('710533', '710500', '南化区', '0', '0', '', '2', '1', null),
('710534', '710500', '左镇区', '0', '0', '', '2', '1', null),
('710535', '710500', '仁德区', '0', '0', '', '2', '1', null),
('710536', '710500', '归仁区', '0', '0', '', '2', '1', null),
('710537', '710500', '关庙区', '0', '0', '', '2', '1', null),
('710538', '710500', '龙崎区', '0', '0', '', '2', '1', null),
('710539', '710500', '永康区', '0', '0', '', '2', '1', null),
('710600', '710000', '新竹市', '0', '0', 'X', '1', '1', null),
('710601', '710600', '东区', '0', '0', '', '2', '1', null),
('710602', '710600', '北区', '0', '0', '', '2', '1', null),
('710603', '710600', '香山区', '0', '0', '', '2', '1', null),
('710700', '710000', '嘉义市', '0', '0', 'J', '1', '1', null),
('710701', '710700', '东区', '0', '0', '', '2', '1', null),
('710702', '710700', '西区', '0', '0', '', '2', '1', null),
('710800', '710000', '新北市', '0', '0', 'X', '1', '1', null),
('710801', '710800', '板桥区', '0', '0', '', '2', '1', null),
('710802', '710800', '三重区', '0', '0', '', '2', '1', null),
('710803', '710800', '中和区', '0', '0', '', '2', '1', null),
('710804', '710800', '永和区', '0', '0', '', '2', '1', null),
('710805', '710800', '新庄区', '0', '0', '', '2', '1', null),
('710806', '710800', '新店区', '0', '0', '', '2', '1', null),
('710807', '710800', '树林区', '0', '0', '', '2', '1', null),
('710808', '710800', '莺歌区', '0', '0', '', '2', '1', null),
('710809', '710800', '三峡区', '0', '0', '', '2', '1', null),
('710810', '710800', '淡水区', '0', '0', '', '2', '1', null),
('710811', '710800', '汐止区', '0', '0', '', '2', '1', null),
('710812', '710800', '瑞芳区', '0', '0', '', '2', '1', null),
('710813', '710800', '土城区', '0', '0', '', '2', '1', null),
('710814', '710800', '芦洲区', '0', '0', '', '2', '1', null),
('710815', '710800', '五股区', '0', '0', '', '2', '1', null),
('710816', '710800', '泰山区', '0', '0', '', '2', '1', null),
('710817', '710800', '林口区', '0', '0', '', '2', '1', null),
('710818', '710800', '深坑区', '0', '0', '', '2', '1', null),
('710819', '710800', '石碇区', '0', '0', '', '2', '1', null),
('710820', '710800', '坪林区', '0', '0', '', '2', '1', null),
('710821', '710800', '三芝区', '0', '0', '', '2', '1', null),
('710822', '710800', '石门区', '0', '0', '', '2', '1', null),
('710823', '710800', '八里区', '0', '0', '', '2', '1', null),
('710824', '710800', '平溪区', '0', '0', '', '2', '1', null),
('710825', '710800', '双溪区', '0', '0', '', '2', '1', null),
('710826', '710800', '贡寮区', '0', '0', '', '2', '1', null),
('710827', '710800', '金山区', '0', '0', '', '2', '1', null),
('710828', '710800', '万里区', '0', '0', '', '2', '1', null),
('710829', '710800', '乌来区', '0', '0', '', '2', '1', null),
('710900', '710000', '桃园市', '0', '0', 'T', '1', '1', null),
('710901', '710900', '桃园区', '0', '0', '', '2', '1', null),
('710902', '710900', '中坜区', '0', '0', '', '2', '1', null),
('710903', '710900', '平镇区', '0', '0', '', '2', '1', null),
('710904', '710900', '八德区', '0', '0', '', '2', '1', null),
('710905', '710900', '杨梅区', '0', '0', '', '2', '1', null),
('710906', '710900', '大溪区', '0', '0', '', '2', '1', null);
INSERT INTO `wst_areas` VALUES ('710907', '710900', '芦竹区', '0', '0', '', '2', '1', null),
('710908', '710900', '大园区', '0', '0', '', '2', '1', null),
('710909', '710900', '龟山区', '0', '0', '', '2', '1', null),
('710910', '710900', '龙潭区', '0', '0', '', '2', '1', null),
('710911', '710900', '新屋区', '0', '0', '', '2', '1', null),
('710912', '710900', '观音区', '0', '0', '', '2', '1', null),
('710913', '710900', '复兴区', '0', '0', '', '2', '1', null),
('712200', '710000', '宜兰县', '0', '0', 'Y', '1', '1', null),
('712201', '712200', '宜兰市', '0', '0', '', '2', '1', null),
('712221', '712200', '罗东镇', '0', '0', '', '2', '1', null),
('712222', '712200', '苏澳镇', '0', '0', '', '2', '1', null),
('712223', '712200', '头城镇', '0', '0', '', '2', '1', null),
('712224', '712200', '礁溪乡', '0', '0', '', '2', '1', null),
('712225', '712200', '壮围乡', '0', '0', '', '2', '1', null),
('712226', '712200', '员山乡', '0', '0', '', '2', '1', null),
('712227', '712200', '冬山乡', '0', '0', '', '2', '1', null),
('712228', '712200', '五结乡', '0', '0', '', '2', '1', null),
('712229', '712200', '三星乡', '0', '0', '', '2', '1', null),
('712230', '712200', '大同乡', '0', '0', '', '2', '1', null),
('712231', '712200', '南澳乡', '0', '0', '', '2', '1', null),
('712400', '710000', '新竹县', '0', '0', 'X', '1', '1', null),
('712401', '712400', '竹北市', '0', '0', '', '2', '1', null),
('712421', '712400', '竹东镇', '0', '0', '', '2', '1', null),
('712422', '712400', '新埔镇', '0', '0', '', '2', '1', null),
('712423', '712400', '关西镇', '0', '0', '', '2', '1', null),
('712424', '712400', '湖口乡', '0', '0', '', '2', '1', null),
('712425', '712400', '新丰乡', '0', '0', '', '2', '1', null),
('712426', '712400', '芎林乡', '0', '0', '', '2', '1', null),
('712427', '712400', '橫山乡', '0', '0', '', '2', '1', null),
('712428', '712400', '北埔乡', '0', '0', '', '2', '1', null),
('712429', '712400', '宝山乡', '0', '0', '', '2', '1', null),
('712430', '712400', '峨眉乡', '0', '0', '', '2', '1', null),
('712431', '712400', '尖石乡', '0', '0', '', '2', '1', null),
('712432', '712400', '五峰乡', '0', '0', '', '2', '1', null),
('712500', '710000', '苗栗县', '0', '0', 'M', '1', '1', null),
('712501', '712500', '苗栗市', '0', '0', '', '2', '1', null),
('712521', '712500', '苑里镇', '0', '0', '', '2', '1', null),
('712522', '712500', '通霄镇', '0', '0', '', '2', '1', null),
('712523', '712500', '竹南镇', '0', '0', '', '2', '1', null),
('712524', '712500', '头份镇', '0', '0', '', '2', '1', null),
('712525', '712500', '后龙镇', '0', '0', '', '2', '1', null),
('712526', '712500', '卓兰镇', '0', '0', '', '2', '1', null),
('712527', '712500', '大湖乡', '0', '0', '', '2', '1', null),
('712528', '712500', '公馆乡', '0', '0', '', '2', '1', null),
('712529', '712500', '铜锣乡', '0', '0', '', '2', '1', null),
('712530', '712500', '南庄乡', '0', '0', '', '2', '1', null),
('712531', '712500', '头屋乡', '0', '0', '', '2', '1', null),
('712532', '712500', '三义乡', '0', '0', '', '2', '1', null),
('712533', '712500', '西湖乡', '0', '0', '', '2', '1', null),
('712534', '712500', '造桥乡', '0', '0', '', '2', '1', null),
('712535', '712500', '三湾乡', '0', '0', '', '2', '1', null),
('712536', '712500', '狮潭乡', '0', '0', '', '2', '1', null),
('712537', '712500', '泰安乡', '0', '0', '', '2', '1', null),
('712700', '710000', '彰化县', '0', '0', 'Z', '1', '1', null),
('712701', '712700', '彰化市', '0', '0', '', '2', '1', null),
('712721', '712700', '鹿港镇', '0', '0', '', '2', '1', null),
('712722', '712700', '和美镇', '0', '0', '', '2', '1', null),
('712723', '712700', '线西乡', '0', '0', '', '2', '1', null),
('712724', '712700', '伸港乡', '0', '0', '', '2', '1', null),
('712725', '712700', '福兴乡', '0', '0', '', '2', '1', null),
('712726', '712700', '秀水乡', '0', '0', '', '2', '1', null),
('712727', '712700', '花坛乡', '0', '0', '', '2', '1', null),
('712728', '712700', '芬园乡', '0', '0', '', '2', '1', null),
('712729', '712700', '员林镇', '0', '0', '', '2', '1', null),
('712730', '712700', '溪湖镇', '0', '0', '', '2', '1', null),
('712731', '712700', '田中镇', '0', '0', '', '2', '1', null),
('712732', '712700', '大村乡', '0', '0', '', '2', '1', null),
('712733', '712700', '埔盐乡', '0', '0', '', '2', '1', null),
('712734', '712700', '埔心乡', '0', '0', '', '2', '1', null),
('712735', '712700', '永靖乡', '0', '0', '', '2', '1', null),
('712736', '712700', '社头乡', '0', '0', '', '2', '1', null),
('712737', '712700', '二水乡', '0', '0', '', '2', '1', null),
('712738', '712700', '北斗镇', '0', '0', '', '2', '1', null),
('712739', '712700', '二林镇', '0', '0', '', '2', '1', null),
('712740', '712700', '田尾乡', '0', '0', '', '2', '1', null),
('712741', '712700', '埤头乡', '0', '0', '', '2', '1', null),
('712742', '712700', '芳苑乡', '0', '0', '', '2', '1', null),
('712743', '712700', '大城乡', '0', '0', '', '2', '1', null),
('712744', '712700', '竹塘乡', '0', '0', '', '2', '1', null),
('712745', '712700', '溪州乡', '0', '0', '', '2', '1', null),
('712800', '710000', '南投县', '0', '0', 'N', '1', '1', null),
('712801', '712800', '南投市', '0', '0', '', '2', '1', null),
('712821', '712800', '埔里镇', '0', '0', '', '2', '1', null),
('712822', '712800', '草屯镇', '0', '0', '', '2', '1', null),
('712823', '712800', '竹山镇', '0', '0', '', '2', '1', null),
('712824', '712800', '集集镇', '0', '0', '', '2', '1', null),
('712825', '712800', '名间乡', '0', '0', '', '2', '1', null),
('712826', '712800', '鹿谷乡', '0', '0', '', '2', '1', null),
('712827', '712800', '中寮乡', '0', '0', '', '2', '1', null),
('712828', '712800', '鱼池乡', '0', '0', '', '2', '1', null),
('712829', '712800', '国姓乡', '0', '0', '', '2', '1', null),
('712830', '712800', '水里乡', '0', '0', '', '2', '1', null),
('712831', '712800', '信义乡', '0', '0', '', '2', '1', null),
('712832', '712800', '仁爱乡', '0', '0', '', '2', '1', null),
('712900', '710000', '云林县', '0', '0', 'Y', '1', '1', null),
('712901', '712900', '斗六市', '0', '0', '', '2', '1', null),
('712921', '712900', '斗南镇', '0', '0', '', '2', '1', null),
('712922', '712900', '虎尾镇', '0', '0', '', '2', '1', null),
('712923', '712900', '西螺镇', '0', '0', '', '2', '1', null),
('712924', '712900', '土库镇', '0', '0', '', '2', '1', null),
('712925', '712900', '北港镇', '0', '0', '', '2', '1', null),
('712926', '712900', '古坑乡', '0', '0', '', '2', '1', null),
('712927', '712900', '大埤乡', '0', '0', '', '2', '1', null),
('712928', '712900', '莿桐乡', '0', '0', '', '2', '1', null),
('712929', '712900', '林内乡', '0', '0', '', '2', '1', null),
('712930', '712900', '二仑乡', '0', '0', '', '2', '1', null),
('712931', '712900', '仑背乡', '0', '0', '', '2', '1', null),
('712932', '712900', '麦寮乡', '0', '0', '', '2', '1', null),
('712933', '712900', '东势乡', '0', '0', '', '2', '1', null),
('712934', '712900', '褒忠乡', '0', '0', '', '2', '1', null),
('712935', '712900', '台西乡', '0', '0', '', '2', '1', null),
('712936', '712900', '元长乡', '0', '0', '', '2', '1', null),
('712937', '712900', '四湖乡', '0', '0', '', '2', '1', null),
('712938', '712900', '口湖乡', '0', '0', '', '2', '1', null),
('712939', '712900', '水林乡', '0', '0', '', '2', '1', null),
('713000', '710000', '嘉义县', '0', '0', 'J', '1', '1', null),
('713001', '713000', '太保市', '0', '0', '', '2', '1', null),
('713002', '713000', '朴子市', '0', '0', '', '2', '1', null),
('713023', '713000', '布袋镇', '0', '0', '', '2', '1', null),
('713024', '713000', '大林镇', '0', '0', '', '2', '1', null),
('713025', '713000', '民雄乡', '0', '0', '', '2', '1', null),
('713026', '713000', '溪口乡', '0', '0', '', '2', '1', null),
('713027', '713000', '新港乡', '0', '0', '', '2', '1', null),
('713028', '713000', '六脚乡', '0', '0', '', '2', '1', null),
('713029', '713000', '东石乡', '0', '0', '', '2', '1', null),
('713030', '713000', '义竹乡', '0', '0', '', '2', '1', null),
('713031', '713000', '鹿草乡', '0', '0', '', '2', '1', null),
('713032', '713000', '水上乡', '0', '0', '', '2', '1', null),
('713033', '713000', '中埔乡', '0', '0', '', '2', '1', null),
('713034', '713000', '竹崎乡', '0', '0', '', '2', '1', null),
('713035', '713000', '梅山乡', '0', '0', '', '2', '1', null),
('713036', '713000', '番路乡', '0', '0', '', '2', '1', null),
('713037', '713000', '大埔乡', '0', '0', '', '2', '1', null),
('713038', '713000', '阿里山乡', '0', '0', '', '2', '1', null),
('713300', '710000', '屏东县', '0', '0', 'P', '1', '1', null),
('713301', '713300', '屏东市', '0', '0', '', '2', '1', null),
('713321', '713300', '潮州镇', '0', '0', '', '2', '1', null),
('713322', '713300', '东港镇', '0', '0', '', '2', '1', null),
('713323', '713300', '恒春镇', '0', '0', '', '2', '1', null),
('713324', '713300', '万丹乡', '0', '0', '', '2', '1', null),
('713325', '713300', '长治乡', '0', '0', '', '2', '1', null),
('713326', '713300', '麟洛乡', '0', '0', '', '2', '1', null),
('713327', '713300', '九如乡', '0', '0', '', '2', '1', null),
('713328', '713300', '里港乡', '0', '0', '', '2', '1', null),
('713329', '713300', '盐埔乡', '0', '0', '', '2', '1', null),
('713330', '713300', '高树乡', '0', '0', '', '2', '1', null),
('713331', '713300', '万峦乡', '0', '0', '', '2', '1', null),
('713332', '713300', '内埔乡', '0', '0', '', '2', '1', null),
('713333', '713300', '竹田乡', '0', '0', '', '2', '1', null),
('713334', '713300', '新埤乡', '0', '0', '', '2', '1', null),
('713335', '713300', '枋寮乡', '0', '0', '', '2', '1', null),
('713336', '713300', '新园乡', '0', '0', '', '2', '1', null),
('713337', '713300', '崁顶乡', '0', '0', '', '2', '1', null),
('713338', '713300', '林边乡', '0', '0', '', '2', '1', null),
('713339', '713300', '南州乡', '0', '0', '', '2', '1', null),
('713340', '713300', '佳冬乡', '0', '0', '', '2', '1', null),
('713341', '713300', '琉球乡', '0', '0', '', '2', '1', null),
('713342', '713300', '车城乡', '0', '0', '', '2', '1', null),
('713343', '713300', '满州乡', '0', '0', '', '2', '1', null),
('713344', '713300', '枋山乡', '0', '0', '', '2', '1', null),
('713345', '713300', '三地门乡', '0', '0', '', '2', '1', null),
('713346', '713300', '雾台乡', '0', '0', '', '2', '1', null),
('713347', '713300', '玛家乡', '0', '0', '', '2', '1', null),
('713348', '713300', '泰武乡', '0', '0', '', '2', '1', null),
('713349', '713300', '来义乡', '0', '0', '', '2', '1', null),
('713350', '713300', '春日乡', '0', '0', '', '2', '1', null),
('713351', '713300', '狮子乡', '0', '0', '', '2', '1', null),
('713352', '713300', '牡丹乡', '0', '0', '', '2', '1', null),
('713400', '710000', '台东县', '0', '0', 'T', '1', '1', null),
('713401', '713400', '台东市', '0', '0', '', '2', '1', null),
('713421', '713400', '成功镇', '0', '0', '', '2', '1', null),
('713422', '713400', '关山镇', '0', '0', '', '2', '1', null),
('713423', '713400', '卑南乡', '0', '0', '', '2', '1', null),
('713424', '713400', '鹿野乡', '0', '0', '', '2', '1', null),
('713425', '713400', '池上乡', '0', '0', '', '2', '1', null),
('713426', '713400', '东河乡', '0', '0', '', '2', '1', null),
('713427', '713400', '长滨乡', '0', '0', '', '2', '1', null),
('713428', '713400', '太麻里乡', '0', '0', '', '2', '1', null),
('713429', '713400', '大武乡', '0', '0', '', '2', '1', null),
('713430', '713400', '绿岛乡', '0', '0', '', '2', '1', null),
('713431', '713400', '海端乡', '0', '0', '', '2', '1', null),
('713432', '713400', '延平乡', '0', '0', '', '2', '1', null),
('713433', '713400', '金峰乡', '0', '0', '', '2', '1', null),
('713434', '713400', '达仁乡', '0', '0', '', '2', '1', null),
('713435', '713400', '兰屿乡', '0', '0', '', '2', '1', null),
('713500', '710000', '花莲县', '0', '0', 'H', '1', '1', null),
('713501', '713500', '花莲市', '0', '0', '', '2', '1', null),
('713521', '713500', '凤林镇', '0', '0', '', '2', '1', null),
('713522', '713500', '玉里镇', '0', '0', '', '2', '1', null),
('713523', '713500', '新城乡', '0', '0', '', '2', '1', null),
('713524', '713500', '吉安乡', '0', '0', '', '2', '1', null),
('713525', '713500', '寿丰乡', '0', '0', '', '2', '1', null),
('713526', '713500', '光复乡', '0', '0', '', '2', '1', null),
('713527', '713500', '丰滨乡', '0', '0', '', '2', '1', null),
('713528', '713500', '瑞穗乡', '0', '0', '', '2', '1', null),
('713529', '713500', '富里乡', '0', '0', '', '2', '1', null),
('713530', '713500', '秀林乡', '0', '0', '', '2', '1', null),
('713531', '713500', '万荣乡', '0', '0', '', '2', '1', null),
('713532', '713500', '卓溪乡', '0', '0', '', '2', '1', null),
('713600', '710000', '澎湖县', '0', '0', 'P', '1', '1', null),
('713601', '713600', '马公市', '0', '0', '', '2', '1', null),
('713621', '713600', '湖西乡', '0', '0', '', '2', '1', null),
('713622', '713600', '白沙乡', '0', '0', '', '2', '1', null),
('713623', '713600', '西屿乡', '0', '0', '', '2', '1', null),
('713624', '713600', '望安乡', '0', '0', '', '2', '1', null),
('713625', '713600', '七美乡', '0', '0', '', '2', '1', null),
('810000', '0', '香港特别行政区', '0', '0', '', '0', '1', null),
('810100', '810000', '香港岛', '0', '0', 'X', '1', '1', null),
('810101', '810100', '中西区', '0', '0', '', '2', '1', null),
('810102', '810100', '湾仔区', '0', '0', '', '2', '1', null),
('810103', '810100', '东区', '0', '0', '', '2', '1', null),
('810104', '810100', '南区', '0', '0', '', '2', '1', null),
('810200', '810000', '九龙', '0', '0', 'J', '1', '1', null),
('810201', '810200', '油尖旺区', '0', '0', '', '2', '1', null),
('810202', '810200', '深水埗区', '0', '0', '', '2', '1', null),
('810203', '810200', '九龙城区', '0', '0', '', '2', '1', null),
('810204', '810200', '黄大仙区', '0', '0', '', '2', '1', null),
('810205', '810200', '观塘区', '0', '0', '', '2', '1', null),
('810300', '810000', '新界', '0', '0', 'X', '1', '1', null),
('810301', '810300', '荃湾区', '0', '0', '', '2', '1', null),
('810302', '810300', '屯门区', '0', '0', '', '2', '1', null),
('810303', '810300', '元朗区', '0', '0', '', '2', '1', null),
('810304', '810300', '北区', '0', '0', '', '2', '1', null),
('810305', '810300', '大埔区', '0', '0', '', '2', '1', null),
('810306', '810300', '西贡区', '0', '0', '', '2', '1', null),
('810307', '810300', '沙田区', '0', '0', '', '2', '1', null),
('810308', '810300', '葵青区', '0', '0', '', '2', '1', null),
('810309', '810300', '离岛区', '0', '0', '', '2', '1', null),
('820000', '0', '澳门特别行政区', '0', '0', '', '0', '1', null),
('820100', '820000', '澳门半岛', '0', '0', 'A', '1', '1', null),
('820101', '820100', '花地玛堂区', '0', '0', '', '2', '1', null),
('820102', '820100', '圣安多尼堂区', '0', '0', '', '2', '1', null),
('820103', '820100', '大堂区', '0', '0', '', '2', '1', null),
('820104', '820100', '望德堂区', '0', '0', '', '2', '1', null),
('820105', '820100', '风顺堂区', '0', '0', '', '2', '1', null),
('820200', '820000', '氹仔岛', '0', '0', 'D', '1', '1', null),
('820201', '820200', '嘉模堂区', '0', '0', '', '2', '1', null),
('820300', '820000', '路环岛', '0', '0', 'L', '1', '1', null),
('820301', '820300', '圣方济各堂区 ', '0', '0', '', '2', '1', null);
