// JavaScript Document 
var editor; 
$(function(){ 
	$("form").submit(function(){ 
		var goods_cats = $("#goods_cats option:selected").val();
		if(goods_cats == 0){
			$.alert('请选择分类');	return false;
		}
		
		var title = $("#title").val();
		if(title == ''){
			$.alert('请填写商品标题'); return false;
		}
		
		var price = $("#price").val();
		if(price == ''){
			$.alert('价格不能为空'); return false;
		}
		 
		var mark_price = $("#market_price").val();
		if(mark_price == ''){
			$.alert('市场价格不能为空');return false;
		}
		if(mark_price != ''){
			if(parseFloat(mark_price) <= parseFloat(price)){
				$.alert('市场价格不能低于或者等于原价格');return false;
			} 
		} 
		var stock = $("#stock").val();
		if(stock == ''){
			$.alert('库存不能为空');return false;
		}
		
		var goods_img = $('#goods_img').val(); 
		if(goods_img == '' || typeof(goods_img) == 'undefined'){
			$.alert('请最少上传一张主图'); return false; 
		}
		
		var status = $('input[name="status"]:checked').val(); 
		if(typeof(status) =='undefined'){ 
			$.alert('请选择商品状态'); return false; 
		}
		$('.add_goods_submit').attr("disabled", true).val('正在提交..');
	 	$.ajax({
			type:'POST',
			url:'member.php?m=goods&a=save&jq_time='+new Date().getTime(),
			data:$("#form").serialize(),
			success:function(result){ 
				var data = jQuery.parseJSON(result); 
				if(data.error == 0){
					$.alert('保存成功', function(){
						$('.add_goods_submit').attr("disabled", false).val('保存');
						history.back(-1);						 
					}); 
				}else{ 
					$('.add_goods_submit').attr("disabled", false).val('保存');
					$.alert(data.msg); 
				}
			},error:function(){
				$('.add_goods_submit').attr("disabled", false).val('保存');
				$.alert('错误');
			}
		}); 
		return false;
 	}); 
	
	// 打折促销
	$(document).on('click', ".act_status", function(){ 
		sku_list();
		var act_status = $("input[name='act_status']:checked").val(); 
		if(act_status){
			$(".act_con").show();
			$(".act_price").show();
		}else{
			$(".act_con").hide();
			$(".act_price").hide();
		}
	});
	$(document).on('blur', ".sku_remark", function(){ 
		html = $(this).val();
		data_id = $(this).attr('data-id');
		$(".sku_img_"+data_id).html(html);
		
	});
	
	// ---------SKU点击显示---------------  
	$(document).on('click',".sku_checkbox",function(){ 
		sku_list();
	}); 
	function sku_list(){
		var goods_id = $("#goods_id").val(); 
		var ids = '';
		$(".sku_con input[name='sku_val']:checkbox").each(function(){
			if(this.checked){ 
				ids += $(this).val()+','; 
			}  		
		}); 
		var ids = ids.substring(0,ids.length-1); 
		$.post('?m=goods&a=sku_img',{val:ids, goods_id:goods_id},function(data){ 
			$("#sku_color_img").html(data); 
		}); 
		var act_status = $("input[name='act_status']:checked").val();  
		if(act_status == 1){
			$.post('?m=goods&a=sku_list',{val:ids, goods_id:goods_id, act_status:'1'},function(data){ 
				$("#sku_list").html(data); 
			}); 
		}else{
			$.post('?m=goods&a=sku_list',{val:ids, goods_id:goods_id},function(data){ 
				$("#sku_list").html(data); 
			});
		}
	}
	
	// 填充价格 
	$(document).on('dblclick',".fill_price",function(){ 
		price = $(this).val();
		if(price){
			$(".fill_price").val(price);
			$("#price").val(price);
		}  
	});
	
	// 填充库存
	$(document).on('dblclick',".fill_stock",function(){
		stock = $(this).val();
		if(stock){
			var sum=0;
			$("input.fill_stock").each(function(){ 
				 sum+=+stock; 
			});
			$(".fill_stock").val(stock);
			$("#stock").val(sum);	
		} 
	});
	
	// 删除一个小图 
	$(document).on('click',".show_img span img",function(){ 
		$(this).parents('.show_img').remove();
		if($('.show_img').length == 0){ 
			$(".show_hd_img").html('<div class="no_img"><img src="'+PUBLIC_PATH+'images/img_main.png"/></div>');
		} 
	});
	
});  

/*编辑器异步加载*/ 
$.getScript(PUBLIC_PATH+'plug/kindeditor/kindeditor-min.js', function(){
	KindEditor.plugin('multiimage2', function(K) {
		var self = this, name = 'multiimage2';
		self.clickToolbar(name, function() {
			upload_manage('img_goods_content', '', true);
		});
	});
	KindEditor.basePath = PUBLIC_PATH+'plug/kindeditor/';
	editor = KindEditor.create('textarea[name="content"]',{
		items : ['source' , 'formatblock', 'fontname', 'fontsize', '|', 'forecolor', 'hilitecolor', 'bold', 'italic', 'underline', 'strikethrough', 'lineheight', '|', 'justifyleft', 'justifycenter', 'justifyright', 'justifyfull', '|',  'multiimage2', 'emoticons', 'link', 'unlink', '|', 'clearhtml', 'quickformat' ],			// 换行用 '/',  
		afterCreate : function() {
			var self = this;
			K.ctrl(document, 13, function(){
				self.sync();
				K('form[name=example]')[0].submit();
			});
			K.ctrl(self.edit.doc, 13, function() {
				self.sync();
				K('form[name=example]')[0].submit();
			});
		},
		afterBlur:function(){ 	// 输完更新
			this.sync(); 
		}
	}); 
}); 

/*添加图片*/
function upload_insert(postion, file_id){ 
	if(postion == 'head_img'){ 					// 主图添加
		$(".ajax_album_ck_value").each(function(){ 
			ck_img_url = $(this).attr('data-url');
			ck_img_name = $(this).attr('data-name'); 
			
			var img_box = '<div class="show_img">'+ 
							'<img src="'+ck_img_url+'">'+
							'<span><img src="'+PUBLIC_PATH+'images/icon/del.png" /></span>'+
							'<input type="hidden" value="'+ck_img_name+'" id="goods_img" name="goods_img[]">'+ 
							'<input type="hidden" value="0" name="goods_img_px[]" class="goods_img_px">'+
						'</div>';
			if($('.show_img').length == 0){ 
				$('.show_hd_img').html(img_box);
			}else{
				if($('.show_img').length <= 5){
					$('.show_img:last').after(img_box);
				}
			} 
		});
	}else if(postion == 'sku_img'){				// 规格图片添加
		ck_img_url = $(".ajax_album_ck_value").attr('data-url');
		ck_img_name = $(".ajax_album_ck_value").attr('data-name');
		if(ck_img_url){
			$('.sku_show_'+file_id).html('<img src="'+ck_img_url+'" width="28">');
			$('.sku_img_value_'+file_id).val(ck_img_name); 	
		}else{
			$.alert('没有选中图片');
		} 
	}else if(postion == 'img_goods_content'){	// 内容的添加  
		$(".ajax_album_ck_value").each(function(v){
			ck_img_url = $(this).attr('data-url');
			ck_img_name = $(this).attr('data-name'); 
			if(ck_img_url.indexOf("?") == '' || ck_img_url.indexOf("?") == undefined){
				ck_img_url = ck_img_url.substring(0, ck_img_url.indexOf("?"));
			}
			editor.insertHtml('<p><img src="'+ck_img_url+'"/></p>');
		});	
	}
	img_close();
}

/*主图添加*/
function hd_img_insert(ck_img_url, ck_img_name){
	var img_box = '<div class="show_img">'+ 
					'<img src="'+ck_img_url+'">'+
					'<span><img src="'+PUBLIC_PATH+'images/icon/del.png" /></span>'+
					'<input type="hidden" value="'+ck_img_name+'" id="goods_img" name="goods_img[]">'+ 
					'<input type="hidden" value="0" name="goods_img_px[]" class="goods_img_px">'+
				'</div>';
	if($('.show_img').length == 0){ 
		$('.show_hd_img').html(img_box);
	}else{
		if($('.show_img').length <= 5){
			$('.show_img:last').after(img_box);
		}
	} 
}

function edit_cats(){ 
	if(!confirm('当前页面编辑的将清除')) {
		return false;
	}
}
