<?php

require_once $_SERVER['DOCUMENT_ROOT']."/data/config.php";
set_time_limit(0);
function create_pages($params)
{
    extract($params);

    $str = '';
    $len = 10;

    if (empty($page))
    {
        $page = 1;
    }

    if (!empty($count))
    {
        $step = 1;
        $str .= "<option value='1'>1</option>";

        for ($i = 2; $i < $count; $i += $step)
        {
            $step = ($i >= $page + $len - 1 || $i <= $page - $len + 1) ? $len : 1;
            $str .= "<option value='$i'";
            $str .= $page == $i ? " selected='true'" : '';
            $str .= ">$i</option>";
        }

        if ($count > 1)
        {
            $str .= "<option value='$count'";
            $str .= $page == $count ? " selected='true'" : '';
            $str .= ">$count</option>";
        }
    }

    return $str;
}

/**
 * option 列表信息
 *
 * @param       string      $conditions
 * @return      array
 */
function option_list_info($conditions = '',$table,$userid=0)
{
    $where = '';
    if (!empty($conditions))
    {
        $where .= 'WHERE ';
        $where .= $conditions;
    }

    /* 查询 */
	if ($table == 'Designer')
	{
		if ($userid==0)
		  $sql = "SELECT a.UserID,b.TrueName
            FROM Designer a, user b ".
           " where a.UserID=b.ID ";
		else
		  $sql = "SELECT a.UserID,b.TrueName
            FROM Designer a, user b ".
           " where a.UserID=b.ID and a.UserID=".$userid; 
	}
	else if ($table == 'houseestate')
	{
		$sql = "SELECT *
            FROM houseestate ";
	}
	else if ($table == 'WorkTechnology')
	{
		$sql = "SELECT ID, 
		 CASE TecType
            WHEN 1 THEN CONCAT('开工--',Name)
            WHEN 2 THEN CONCAT('水电--',Name)
            WHEN 3 THEN CONCAT('泥木--',Name)
            WHEN 4 THEN CONCAT('油漆--',Name)
            WHEN 5 THEN CONCAT('竣工--',Name)
            ELSE Name
         END  as Name
            FROM   ".$table."  order by  TecType,ID ASC";
	}
	else
	{
      $sql = "SELECT *
            FROM " . ' ecs_'.$table . "
            $where";
	}

    $conn = new mysqli($GLOBALS['db_host'], $GLOBALS['db_user'], $GLOBALS['db_pass'], $GLOBALS['db_name']);
	$result = $conn->query($sql); 
	$arr = array();
		if ($result)
		{
		  while ($row = mysqli_fetch_assoc($result))
          {
             $arr[] = $row;
          }
          $result->close();
		}
	$conn->close();
	if ($table == 'houseestate')
	{
	  $count = count($arr);
	  $arr[$count]['ID'] = -1;
	  $arr[$count]['HouseEstate'] = "其他";
	}
    return $arr;
}

/**
 * option名
 *
 * @return  array
 */
function option_list_name($table,$userid=0)
{
    /* 查询 */
    $option_list = option_list_info('',$table,$userid);
        switch ($table)
            {
            case 'moshi':
              $id = 'moshi_id';
              $name = 'moshi_name';
              break;
            case 'fengge':
              $id = 'fengge_id';
              $name = 'fengge_name';
              break;
            case 'huxing':
              $id = 'huxing_id';
              $name = 'huxing_name';
              break;
			case 'Designer':
              $id = 'UserID';
              $name = 'TrueName';
              break;
			case 'houseestate':
              $id = 'ID';
              $name = 'HouseEstate';
              break;
			case 'WorkTechnology':
              $id = 'ID';
              $name = 'Name';
              break;
            default:
             $id = 'loupan_id';
              $name = 'loupan_name';
            }

    $option_name = array();
    if (count($option_list) > 0)
    {
        foreach ($option_list as $options)
        {
            $option_name[$options[$id]] = $options[$name];
        }
    }
    return $option_name;
}


/**
 * 获得系统是否启用了 gzip
 *
 * @access  public
 *
 * @return  boolean
 */
function gzip_enabled()
{
    static $enabled_gzip = NULL;

    if ($enabled_gzip === NULL)
    {
        $enabled_gzip = function_exists('ob_gzhandler');
    }

    return $enabled_gzip;
}

/**
 * 取得上次的过滤条件
 * @param   string  $param_str  参数字符串，由list函数的参数组成
 * @return  如果有，返回array('filter' => $filter, 'sql' => $sql)；否则返回false
 */
function get_filter($param_str = '')
{
    $filterfile = basename(PHP_SELF, '.php');
    if ($param_str)
    {
        $filterfile .= $param_str;
    }
    if (isset($_GET['uselastfilter']) && isset($_COOKIE['ECSCP']['lastfilterfile'])
        && $_COOKIE['ECSCP']['lastfilterfile'] == sprintf('%X', crc32($filterfile)))
    {
        return array(
            'filter' => unserialize(urldecode($_COOKIE['ECSCP']['lastfilter'])),
            'sql'    => base64_decode($_COOKIE['ECSCP']['lastfiltersql'])
        );
    }
    else
    {
        return false;
    }
}

/**
 * 将JSON传递的参数转码
 *
 * @param string $str
 * @return string
 */
function json_str_iconv($str)
{
    if (EC_CHARSET != 'utf-8')
    {
        if (is_string($str))
        {
            return addslashes(stripslashes(ecs_iconv('utf-8', EC_CHARSET, $str)));
        }
        elseif (is_array($str))
        {
            foreach ($str as $key => $value)
            {
                $str[$key] = json_str_iconv($value);
            }
            return $str;
        }
        elseif (is_object($str))
        {
            foreach ($str as $key => $value)
            {
                $str->$key = json_str_iconv($value);
            }
            return $str;
        }
        else
        {
            return $str;
        }
    }
    return $str;
}

/**
 * 分页的信息加入条件的数组
 *
 * @access  public
 * @return  array
 */
function page_and_size($filter)
{
    if (isset($_REQUEST['page_size']) && intval($_REQUEST['page_size']) > 0)
    {
        $filter['page_size'] = intval($_REQUEST['page_size']);
    }
    elseif (isset($_COOKIE['ECSCP']['page_size']) && intval($_COOKIE['ECSCP']['page_size']) > 0)
    {
        $filter['page_size'] = intval($_COOKIE['ECSCP']['page_size']);
    }
    else
    {
        $filter['page_size'] = 15;
    }

    /* 每页显示 */
    $filter['page'] = (empty($_REQUEST['page']) || intval($_REQUEST['page']) <= 0) ? 1 : intval($_REQUEST['page']);

    /* page 总数 */
    $filter['page_count'] = (!empty($filter['record_count']) && $filter['record_count'] > 0) ? ceil($filter['record_count'] / $filter['page_size']) : 1;

    /* 边界处理 */
    if ($filter['page'] > $filter['page_count'])
    {
        $filter['page'] = $filter['page_count'];
    }

    $filter['start'] = ($filter['page'] - 1) * $filter['page_size'];

    return $filter;
}

/**
 * 保存过滤条件
 * @param   array   $filter     过滤条件
 * @param   string  $sql        查询语句
 * @param   string  $param_str  参数字符串，由list函数的参数组成
 */
function set_filter($filter, $sql, $param_str = '')
{
    $filterfile = basename(PHP_SELF, '.php');
    if ($param_str)
    {
        $filterfile .= $param_str;
    }
    setcookie('ECSCP[lastfilterfile]', sprintf('%X', crc32($filterfile)), time() + 600);
    setcookie('ECSCP[lastfilter]',     urlencode(serialize($filter)), time() + 600);
    setcookie('ECSCP[lastfiltersql]',  base64_encode($sql), time() + 600);
}

/**
 * 根据过滤条件获得排序的标记
 *
 * @access  public
 * @param   array   $filter
 * @return  array
 */
function sort_flag($filter)
{
    $flag['tag']    = 'sort_' . preg_replace('/^.*\./', '', $filter['sort_by']);
    $flag['img']    = '<img src="images/' . ($filter['sort_order'] == "DESC" ? 'sort_desc.gif' : 'sort_asc.gif') . '"/>';

    return $flag;
}
/**
 * 创建一个JSON格式的数据
 *
 * @access  public
 * @param   string      $content
 * @param   integer     $error
 * @param   string      $message
 * @param   array       $append
 * @return  void
 */
function make_json_response($content="", $error="0", $message="", $append=array())
{
    include_once($_SERVER['DOCUMENT_ROOT'] . '/Manage/cls_json.php');

    $json = new JSON;

    $res = array("error" => $error, "message" => $message, "content" => $content);

    if (!empty($append))
    {
        foreach ($append AS $key => $val)
        {
            $res[$key] = $val;
        }
    }

    $val = $json->encode($res);
    exit($val);
}

/**
 *
 *
 * @access  public
 * @param
 * @return  void
 */
function make_json_result($content, $message='', $append=array())
{
    make_json_response($content, 0, $message, $append);
}

/**
 * 对 MYSQL LIKE 的内容进行转义
 *
 * @access      public
 * @param       string      string  内容
 * @return      string
 */
function mysql_like_quote($str)
{
    return strtr($str, array("\\\\" => "\\\\\\\\", '_' => '\_', '%' => '\%', "\'" => "\\\\\'"));
}

?>