<?php
define('IN_MANLM', true);

define('ROOT_PATH', $_SERVER['DOCUMENT_ROOT']);
require_once $_SERVER['DOCUMENT_ROOT']."/CheckDeLogin.php";
require_once ROOT_PATH."/data/config.php";
require_once $_SERVER['DOCUMENT_ROOT']."/comn/GetSpaceType.php";
require_once $_SERVER['DOCUMENT_ROOT']."/comn/Comn.php";

if (isset($_SERVER['PHP_SELF']))
{
    define('PHP_SELF', $_SERVER['PHP_SELF']);
}
else
{
    define('PHP_SELF', $_SERVER['SCRIPT_NAME']);
}
require(ROOT_PATH . '/lib_main.php');
require(ROOT_PATH . '/Manage/lib_main.php');

/* 对路径进行安全处理 */
if (strpos(PHP_SELF, '.php/') !== false)
{
    ecs_header("Location:" . substr(PHP_SELF, 0, strpos(PHP_SELF, '.php/') + 4) . "\n");
    exit();
}

    $TecID = 1;
	$SpaceType = 1;
	$Price = NULL;
	$ID = 0;
	if (isset($_REQUEST['ID'])) $ID = $_REQUEST['ID'];
	if (isset($_REQUEST['utype'])) 
	   $utype = $_REQUEST['utype'];
	else  
	    exit;
	
    $WorkTechnology_list_name  = option_list_name('WorkTechnology');
	$SpaceType_list_name = array(1 => "客厅、饭厅、过道", 2 => "主卧", 3 => "次卧",4 => "厨房", 5 => "主卫", 6 => "次卫",7 => "阳台", 8 => "水电改造", 9 => "安装", 10 => "其他", 0 => "所有空间");
    $conn = new mysqli($GLOBALS['db_host'], $GLOBALS['db_user'], $GLOBALS['db_pass'], $GLOBALS['db_name']);
	if (isset($_POST['SaveSubmit']))
	{
		 if ($ID > 0)
		 {
			$result = $conn->prepare("update WorkPrice set SpaceType = ?, TecID = ?,Price=? where ID = ?");
			$result->bind_param("iiii", $_POST['SpaceType'], $_POST['TecID'], $_POST['Price'], $ID);
			$result->execute();
			if ($result->errno)
	            {
	               $inputstr = "修改价格信息失败<br>";
	            }
		    else
				$inputstr = "修改价格信息成功<br>";
			$result->close();
			$ID = 0;
		 }
		 else
		 {
			$result = $conn->prepare("insert into WorkPrice (UserID,UserType, SpaceType,TecID,Price) values (?,?, ?, ?,?)");
			$result->bind_param("iiiii", $_SESSION['userid'],$utype,$_POST['SpaceType'], $_POST['TecID'], $_POST['Price']);
			$result->execute();
			if ($result->errno)
	            {
	               $inputstr = "添加价格信息失败<br>";
	            }
		    else
				$inputstr = "添加价格信息成功<br>";
			$result->close();
		 }
		 echo $inputstr;
		 href("ManagePrice.php?utype=".$utype);
	}
	$DID = 0;
	if (isset($_REQUEST['DID'])) $DID = $_REQUEST['DID'];
	if ($DID > 0) {
		$result = $conn->prepare("delete from WorkPrice where ID = ?");
		$result->bind_param("i", $DID);
		$result->execute();
		if ($result->errno)
	     {
	        $inputstr ='删除价格信息失败<br>';
	     }
		 else
		   $inputstr = "删除价格信息成功<br>";
		$result->close();
		echo $inputstr;
		href("ManagePrice.php?utype=".$utype);
	}
	if ($ID > 0)
	{
		$result = $conn->prepare("select ID,UserID,UserType,SpaceType,TecID,Price  from WorkPrice  where ID=? ");
	     $result->bind_param("i", $ID);
	     $result->execute();
	     if ($result)
	     {
	    	$result->bind_result($ID,$UserID,$UserType,$SpaceType,$TecID,$Price);
			$result->fetch();
		    $result->close();
	     }
	}
	
    $list = get_list($utype);
    

/* 获得列表 */
function get_list($utype)
{ 
        /* 获取数据 */
        $sql = 'SELECT a.ID,a.SpaceType,a.Price,b.Name,b.Standard,b.Unit  FROM ' .'WorkPrice'. ' AS a '.
		'LEFT JOIN ' .'WorkTechnology as b'. '  ON b.ID = a.TecID '.
               ' where a.UserID = ? and a.UserType=? ORDER by a.SpaceType,a.ID  ASC';
     
    $result = $GLOBALS['conn']->prepare($sql); 
	$result->bind_param("ii", $_SESSION['userid'],$utype);
	$result->execute();
    $arr = array();
	if ($result)
	     {
	    	$result->bind_result($IDF,$SpaceTypeF,$PriceF,$NameF,$StandardF,$UnitF);
			$num = 0; $subnum = 0; 
			while ($result->fetch())
			{	
			 if ($num == 0)
			 {
               $arr[$num][0] = $SpaceTypeF;
			   $arr[$num][1][$subnum]['ID'] = $IDF; $arr[$num][1][$subnum]['Price'] = $PriceF; 
			   $arr[$num][1][$subnum]['Name'] = $NameF; $arr[$num][1][$subnum]['Standard'] = $StandardF;
			   $arr[$num][1][$subnum]['Unit'] = $UnitF;
			   $num = $num + 1;
			   $subnum = $subnum+1;
			 }
			 else
			 {
				 for ($i=0; $i<=$num-1; $i++)
				 {
				   if ($arr[$i][0] == $SpaceTypeF)
				   {
					  $arr[$i][1][$subnum]['ID'] = $IDF; $arr[$i][1][$subnum]['Price'] = $PriceF; 
			          $arr[$i][1][$subnum]['Name'] = $NameF; $arr[$i][1][$subnum]['Standard'] = $StandardF;
					  $arr[$i][1][$subnum]['Unit'] = $UnitF;
					  $subnum = $subnum+1;
					  break;
				   }
				 }
				  
				  if ($i>$num-1) 
				  {
					  $arr[$num][0] = $SpaceTypeF;
			          $arr[$num][1][0]['ID'] = $IDF; $arr[$num][1][0]['Price'] = $PriceF; 
			          $arr[$num][1][0]['Name'] = $NameF; $arr[$num][1][0]['Standard'] = $StandardF;
					  $arr[$num][1][0]['Unit'] = $UnitF;
					  $num = $num+1;
					  $subnum = 1;
				  }
			 }
			}
		    $result->close();
	     }
	
    return $arr;
}

function href($url){
  echo "<script type=text/javascript>window.location.href=\"$url\"</script>";
} 
?>
<!doctype html>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0, minimum-scale=1.0, maximum-scale=1.0, user-scalable=no">
<meta name="Keywords" content="asfsdfsdfsvsdfsdfgsdgdfgdfgdfh    sgdgdegdfgdfghfdhg"         />
<meta name="Description" content="asfsdfsdfsvsdfsdfgsdgdfgdfgdfh    sgdgdegdfgdfghfdhg"         />
<meta name="robots" content="all" />
<meta name="author" content="www.manlm.com" />
<link href="/css/main.css" rel="stylesheet">
<link href="/css/user.css" rel="stylesheet">
<script src="/js/jquery-2.1.4.min.js"></script>
<script src="/js/transport.js"></script>
<script src="/js/utils.js"></script>
<script src="/js/validator.js"></script>
<title>硬汉联盟 价格信息</title>
</head>
<body>
<div class="tit-all">
  <h3><i></i>我的报价模板</h3>
</div>
<div class="user-mine">
  <div class="mg-price">
    <div class="work-gongyi">
      <form action="" method="post" id="ManageForm" name="ManageForm" onsubmit="return validate();">
        <div class="work-gongyi1 work-gongyi2 clearfix">
          <label>施工空间分类：</label>
          <select class="work-input" name="SpaceType">
            <?php echo html_options(array('options'=>$SpaceType_list_name,'selected'=>$SpaceType)); ?>
          </select>
          <label>工艺流程：</label>
          <select class="work-input" name="TecID" onChange="SelTecID(this.value)">
            <?php echo html_options(array('options'=>$WorkTechnology_list_name,'selected'=>$TecID)); ?>
          </select>
          <label>报价：</label>
          <input class="work-input" style="width:120px !important;" type="text" name="Price" value="<?php echo $Price ?>">
          元/<em id="Unit"></em>
          <input type="hidden" name="ID" id="ID" value="<?php echo $ID ?>">
          <input type="hidden" name="utype" id="utype" value="<?php echo $utype ?>">
          <input type="submit" class="btnsubmit" style="padding:8px 20px !important; margin-left:10px; " name="SaveSubmit" value="<?php if ($ID > 0) echo '修改'; else echo '添加'; ?>" />
        </div>
      </form>
    </div>
    <div class="mg-pricelist">
      <?php  if (count($list)):
    foreach ($list as $row):
?>
      <b><?php echo getSpaceType($row[0]); ?></b>
      <table width="100%" cellpadding="0" cellspacing="0" border="0">
        <tr class="mg-tit">
          <td width="50%" class="mg-bd-left">工艺名称</td>
          <td width="40%">施工单价</td>
          <td width="10%">操作</td>
        </tr>
        <?php foreach ($row[1] as $subrow): ?>
        <tr>
          <td width="50%" class="mg-bd-left"><?php echo $subrow['Name']?></td>
          <td width="40%"><?php echo $subrow['Price']?> 元 / <?php echo getUnit($subrow['Unit']); ?></td>
          <td rowspan="2" width="10%" class="mg-bd-bt"><a href="ManagePrice.php?ID=<?php echo $subrow['ID']?>&utype=<?php echo $utype?>">修改</a>　<a href="ManagePrice.php?DID=<?php echo $subrow['ID']?>&utype=<?php echo $utype?>">删除</a></td>
        </tr>
        <tr>
          <td colspan="2" class="mg-conten"><div class="mg-bz"><?php echo $subrow['Standard']?></div></td>
        </tr>
        <?php endforeach; ?>
      </table>
      <br>
      <?php endforeach; else: ?>
      <table width="100%">
        <tr>
          <td class="no-records" colspan="10">没有价格信息</td>
        </tr>
      </table>
      <?php endif; ?>
    </div>
    <script  type="text/javascript">
 function validate()
{
  var validator = new Validator('ManageForm');
  validator.required('Price', "没有填写价格");
 

  return validator.passed();
}
 function  SelTecID(id)
 {
	GetUnitName(id); 
 }
 
 GetUnitName("<?php echo $TecID ?>");
 function GetUnitName(id)
 {
		var args = "id="+id;
		var url ="GetUnitName.php";
        Ajax.call(url, args, listCallback, "POST", "JSON", true, true);
 }
 
function  listCallback(result)
{	
  if (result.error > 0)
  {
    alert(result.message);
  }
  else
  {
    try
    {
	  document.getElementById('Unit').innerText = result.content;
    }
    catch (e)
    {
      alert(e.message);
    }
  }
}
</script> 
  </div>
</div>
</body>
</html>