<!DOCTYPE html>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0, minimum-scale=1.0, maximum-scale=1.0, user-scalable=no">
<meta name="Keywords" content="硬汉联盟　设计师、工长、监理、工人雇佣平台　省钱省力省心的互联网家装模式 贵阳装修公司  我的装修订单"            />
<meta name="Description" content="硬汉联盟　设计师、工长、监理、工人雇佣平台　省钱省力省心的互联网家装模式 贵阳装修公司  我的装修订单"            />
<meta id="robots" content="all" />
<meta id="author" content="www.manlm.com" />
<link rel="shortcut icon" href="favicon.ico" />
<link href="/css/main.css" rel="stylesheet">
<link href="/css/user.css" rel="stylesheet">
<link rel="stylesheet" href="/js/jquery-ui/jquery-ui.min.css">
<script src="/js/jquery-2.1.4.min.js"></script>
<script src="/js/jquery-ui/jquery-ui.min.js"></script>
<script src="/js/DataDict.js"></script>
<script>
$(document).ready(function(){
	$("#dc-pay").hide();
	$("#dc-nodesign1").hide();
	$("#dc-nodesign2").hide();
	$("#payurl").click(function() {
		$( "#dc-pay" ).dialog({
		  resizable: false,
		  height: 220,
		  width: 480,
		  hide: 'blind',
		  modal: true,
		  buttons: {
			"已成功完成支付": function() {
			  $(this).dialog("close");
			  window.location.reload();
			},
			"支付遇到问题，重新发起支付": function() {
			  window.open($("#payurl").attr("href"));
			}
		  }
		});
	});
	
	$("#nodesign1url").click(function() {
		$("#dc-nodesign1").dialog({
		  resizable: false,
		  height: 180,
		  width: 400,
		  hide: 'blind',
		  position: ['center', 'top'],
		  buttons: {
			"重新设计": function() {
				$.get("/Projects/UpdatePBStatus.php?usertype=1&status=3&pbid=" + $("#nodesign1url").attr("value"), function(data, status){
					window.location.reload();
				});
				$(this).dialog("close");
		   },
			"退出": function() {
				$(this).dialog("close");
			}
		  }
		});
	});

	$("#nodesign2url").click(function() {
		$("#dc-nodesign2").dialog({
		  resizable: false,
		  height: 180,
		  width: 400,
		  hide: 'blind',
		  position: ['center', 'top'],
		  buttons: {
			"结束订单": function() {
				$.get("/Projects/UpdatePBStatus.php?usertype=1&status=0&pbid=" + $("#nodesign1url").attr("value"), function(data, status){
					window.location.reload();
				});
				$(this).dialog("close");
			},
			"退出": function() {
				$(this).dialog("close");
			}
		  }
		});
	});
});
</script>
<title>硬汉联盟 我的装修订单</title>
</head>
<body>
<div class="tit-all">
  <h3><i></i>我的装修订单</h3>
</div>
<div class="user-md">
  <?php
	$DOCUMENT_ROOT = $_SERVER['DOCUMENT_ROOT'];
	require_once $DOCUMENT_ROOT . "/CheckLogin.php";
	require_once $DOCUMENT_ROOT . "/data/config.php";
	include $DOCUMENT_ROOT . "/pay/getBillInfo.php";
	$conn = new mysqli($db_host, $db_user, $db_pass, $db_name);
	$result = $conn->prepare("select a.id, b.userid, b.id, b.bill, c.houseestate, a.area, d.username, d.truename, b.createtime, b.updatetime, b.state, a.wscount, a.ktcount, a.wsjcount, b.billrate from Projects a inner join ProjectBooking b on a.id = b.pid inner join UserProject c on a.upid = c.id inner join User d on b.userid = d.id where c.userid = ? and b.usertype = 1 order by b.updatetime desc");
	$result->bind_param("i", $_SESSION['userid']);
	$result->execute();
	$result->store_result();
	if ($result->num_rows > 0) {
?>
  <ul id="tabs" class="user-tabs clearfix">
    <li><a href="javascript:;" name="#tab1">设计订单</a></li>
    <li><a href="javascript:;" name="#tab2">工长订单</a></li>
    <li><a href="javascript:;" name="#tab3">工人订单</a></li>
    <li><a href="javascript:;" name="#tab4">监理订单</a></li>
  </ul>
  <div id="content">
    <div id="tab1">
      <div class="booking-list">
        <b>我的装修设计订单</b>
		<?php
		$result->bind_result($pid, $uid, $pbid, $bill, $houseestate, $area, $yzusername, $truename, $createtime, $updatetime, $state, $wscount, $ktcount, $wsjcount, $billrate);
		while ($result->fetch()) {
			$bill = round($bill, 2);
			$paydjbill = getNeedPayBill($bill, $billrate, 1, $paybillinfo, $pbid);
			$truename = trim($truename);
			if ($truename == '') $showname = $yzusername;
			else $showname = $truename;
			switch ($state) {
			case 2:
				$payurlparam = "pbid=PBD" . $pbid . "-1&pbname=" . urlencode($houseestate . round($area, 2)) . "平方米-设计费定金&body=业主：" . urlencode($_SESSION['truename'] ). ";项目名称：" . urlencode($houseestate . round($area, 2)) . "平方米;设计师：" .urlencode($truename) . "。&showurl=" . urlencode("/Projects/BookingList.php");
				$_SESSION['bill'] = $paydjbill;
				$operstr = "<a id='payurl' href='/Pay/alipayapi.php?" . $payurlparam . "' class='btnsubmit btn-booking' title='支付定金' target='_blank'>支付定金</a>";
				break;
			case 5:
				$paidbill = getBillPaid($pbid);
				$payurlparam = "pbid=PBD" . $pbid . "-2&pbname=" . urlencode($houseestate . round($area, 2)) . "平方米-设计费尾款&body=业主：" . urlencode($_SESSION['truename'] ). ";项目名称：" . urlencode($houseestate . round($area, 2)) . "平方米;设计师：" .urlencode($truename) . "。&showurl=" . urlencode("/Projects/BookingList.php");
				$_SESSION['bill'] = $bill - $paidbill;
				$operstr = "<a id='payurl' href='/Pay/alipayapi.php?" . $payurlparam . "' class='btnsubmit btn-booking' title='确认设计并支付尾款' target='_blank'>确认设计并支付尾款</a>　<a id='nodesign2url' href='#' title='不满意设计，结束订单' class='btnsubmit btn-booking'>不满意设计,结束订单</a>　<a id='nodesign1url' href='#' title='不满意设计，重新设计' value='" . $pbid . "' class='btnsubmit btn-booking'>不满意设计,重新设计</a>";
				break;
			case 5:
				$operstr = "<a href='/Eva/Eva.php?pbid=" . $pbid . "' class='btnsubmit btn-booking' title='评价订单'>评价订单</a>";
				break;
			case 0:
				$operstr = "<a href='/Eva/Eva.php?pbid=" . $pbid . "' class='btnsubmit btn-booking' title='评价订单'>评价订单</a>";
				break;
			default:
				$operstr = "";
			}
?>
        <table width="100%" border="0" cellspacing="0" cellpadding="0">
          <thead>
          	<tr>
            	<th colspan="4"><span>项目名称：<?php echo $houseestate . round($area, 2); ?>平方米</span><span>户型：<?php echo $wscount; ?>室<?php echo $ktcount; ?>厅<?php echo $wsjcount; ?>卫</span></th>
            </tr>
          </thead>
          <tbody>
            <tr>
              <td>设计师：<a href="/User/Show.php?id=<?php echo($uid); ?>"  onclick="parent.window.showDiv()" target="UserInfo" title="设计师<?php echo $truename; ?>"><?php echo $truename; ?></a></td>
              <td>设计费用：￥<?php echo $bill; ?>（<?php echo($paybillinfo); ?>）</td>
              <td>创建时间：<?php echo $createtime; ?></td>
              <td>更新时间：<?php echo $updatetime; ?></td>
            </tr>
            <tr>
              <td colspan="4" style="padding:10px;">订单流程：<img src="/images/flow/designbookingstate<?php echo $state; ?>.png"></td>
            </tr>
            <tr>
              <td colspan="4" style="text-align:right"><a href="ShowBooking.php?utype=1&pbid=<?php echo $pbid; ?>" class="btnsubmit btn-booking" title"查看订单" target="MyMainFrame">查看订单</a><?php echo $operstr; ?></td>
            </tr>
          </tbody>
        </table>
        <?php
		}
	}
	$result->close();
	
	$result = $conn->prepare("select a.id, b.userid, b.id, b.bill, c.houseestate, a.area, d.truename, b.createtime, b.updatetime, b.state, a.wscount, a.ktcount, a.wsjcount, b.billrate from Projects a inner join ProjectBooking b on a.id = b.pid inner join UserProject c on a.upid = c.id inner join User d on b.userid = d.id where c.userid = ? and b.usertype = 2 order by b.updatetime desc");
	$result->bind_param("i", $_SESSION['userid']);
	$result->execute();
	$result->store_result();
	if ($result->num_rows > 0) {
?>
      </div>
    </div>
    <div id="tab2">
      <div class="booking-list">
        <b>我的装修工长订单</b>
        <?php
		$result->bind_result($pid, $uid, $pbid, $bill, $houseestate, $area, $truename, $createtime, $updatetime, $state, $wscount, $ktcount, $wsjcount, $billrate);
		while ($result->fetch()) {
			$bill = round($bill, 2);
			$paydjbill = getNeedPayBill($bill, $billrate, 1, $paybillinfo, $pbid);
			switch ($state) {
			case 2:
				$paystepname = getPayStepName($billrate, 1);
				$payurlparam = "pbid=PBP" . $pbid . "-1&pbname=" . urlencode($houseestate . round($area, 2)) . "平方米-施工费" . $paystepname . "&body=业主：" . urlencode($_SESSION['truename'] ). ";项目名称：" . urlencode($houseestate . round($area, 2)) . "平方米;工长：" .urlencode($truename) . "。&showurl=" . urlencode("/Projects/BookingList.php");
				$_SESSION['bill'] = $paydjbill;
				$operstr = "<a id='payurl' href='/Pay/alipayapi.php?" . $payurlparam . "' class='btnsubmit btn-booking' title='支付" . $paystepname . "' target='_blank'>支付" . $paystepname . "</a>";
				break;
			case 4:
				$paidbill = getBillPaid($pbid);
				$paystepname = getPayStepName($billrate, 2);
				$payurlparam = "pbid=PBP" . $pbid . "-2&pbname=" . urlencode($houseestate . round($area, 2)) . "平方米-施工费" . $paystepname . "&body=业主：" . urlencode($_SESSION['truename'] ). ";项目名称：" . urlencode($houseestate . round($area, 2)) . "平方米;工长：" .urlencode($truename) . "。&showurl=" . urlencode("/Projects/BookingList.php");
				$_SESSION['bill'] = getNeedPayBill($bill, $billrate, 2, $paybillinfo, $pbid);
				$operstr = "<a id='payurl' href='/Pay/alipayapi.php?" . $payurlparam . "' class='btnsubmit btn-booking' title='支付" . $paystepname .  "' target='_blank'>支付" . $paystepname . "</a>";
				break;
			case 6:
				$paidbill = getBillPaid($pbid);
				$paystepname = getPayStepName($billrate, 3);
				$payurlparam = "pbid=PBP" . $pbid . "-3&pbname=" . urlencode($houseestate . round($area, 2)) . "平方米-施工费" . $paystepname . "&body=业主：" . urlencode($_SESSION['truename'] ). ";项目名称：" . urlencode($houseestate . round($area, 2)) . "平方米;工长：" .urlencode($truename) . "。&showurl=" . urlencode("/Projects/BookingList.php");
				$_SESSION['bill'] = getNeedPayBill($bill, $billrate, 3, $paybillinfo, $pbid);
				$operstr = "<a id='payurl' href='/Pay/alipayapi.php?" . $payurlparam . "' class='btnsubmit btn-booking' title='支付" . $paystepname .  "' target='_blank'>支付" . $paystepname . "</a>";
				break;
			case 7:
				$operstr = "<a href='/Eva/Eva.php?pbid=" . $pbid . "' class='btnsubmit btn-booking' title='评价订单'>评价订单</a>";
				break;
			default:
				$operstr = "";
			}
			if ($state > 2) $operstr = "<a href='/projects/ConstructProgress.php?pbid=" . $pbid . "' class='btnsubmit btn-booking' title='施工进度' target='_blank'>施工进度</a>" . $operstr;
?>
        <table width="100%" border="0" cellspacing="0" cellpadding="0">
          <thead>
          	<tr>
            	<th colspan="4"><span>项目名称：<?php echo $houseestate . round($area, 2); ?>平方米</span><span>户型：<?php echo $wscount; ?>室<?php echo $ktcount; ?>厅<?php echo $wsjcount; ?>卫</span></th>
            </tr>
          </thead>
          <tbody>
            <tr>
              <td>工长：<a href="/User/Show.php?id=<?php echo($uid); ?>" onClick="parent.window.showDiv()" target="UserInfo" title="工长<?php echo $truename; ?>"><?php echo $truename; ?></a></td>
              <td>施工费用：￥<?php echo $bill; ?>（<?php echo($paybillinfo); ?>）</td>
              <td>创建时间：<?php echo $createtime; ?></td>
              <td>更新时间：<?php echo $updatetime; ?></td>
            </tr>
            <tr>
              <td colspan="4" style="padding:10px;">订单流程：<img src="/images/flow/pmbookingstate<?php echo $state; ?>.png"></td>
            </tr>
            <tr>
              <td colspan="4" style="text-align:right"><a href="ShowBooking.php?utype=2&pbid=<?php echo $pbid; ?>"  class="btnsubmit btn-booking" title"查看订单" target="MyMainFrame">查看订单</a><?php echo $operstr; ?></td>
            </tr>
          </tbody>
        </table>
        <?php
		}
	}
	$result->close();
	
	$result = $conn->prepare("select a.id, b.userid, b.id, b.bill, c.houseestate, a.area, d.truename, b.createtime, b.updatetime, b.state, a.wscount, a.ktcount, a.wsjcount, b.billrate from Projects a inner join ProjectBooking b on a.id = b.pid inner join UserProject c on a.upid = c.id inner join User d on b.userid = d.id where c.userid = ? and b.usertype = 3 order by b.updatetime desc");
	$result->bind_param("i", $_SESSION['userid']);
	$result->execute();
	$result->store_result();
	if ($result->num_rows > 0) {
?>
      </div>
    </div>
    <div id="tab3">
      <div class="booking-list">
        <p class="booking-tit">我的装修工人订单</p>
        <?php
		$result->bind_result($pid, $uid, $pbid, $bill, $houseestate, $area, $truename, $createtime, $updatetime, $state, $wscount, $ktcount, $wsjcount, $billrate);
		while ($result->fetch()) {
			$bill = round($bill, 2);
			$paydjbill = getNeedPayBill($bill, $billrate, 1, $paybillinfo, $pbid);
			switch ($state) {
			case 2:
				$paystepname = getPayStepName($billrate, 1);
				$payurlparam = "pbid=PBW" . $pbid . "-1&pbname=" . urlencode($houseestate . round($area, 2)) . "平方米-施工费" . $paystepname . "&body=业主：" . urlencode($_SESSION['truename'] ). ";项目名称：" . urlencode($houseestate . round($area, 2)) . "平方米;工人：" .urlencode($truename) . "。&showurl=" . urlencode("/Projects/BookingList.php");
				$_SESSION['bill'] = $paydjbill;
				$operstr = "<a id='payurl' href='/Pay/alipayapi.php?" . $payurlparam . "' class='btnsubmit btn-booking' title='支付" . $paystepname . "' target='_blank'>支付" . $paystepname . "</a>";
				break;
			case 4:
				$paidbill = getBillPaid($pbid);
				$paystepname = getPayStepName($billrate, 2);
				$payurlparam = "pbid=PBW" . $pbid . "-2&pbname=" . urlencode($houseestate . round($area, 2)) . "平方米-施工费" . $paystepname . "&body=业主：" . urlencode($_SESSION['truename'] ). ";项目名称：" . urlencode($houseestate . round($area, 2)) . "平方米;工人：" .urlencode($truename) . "。&showurl=" . urlencode("/Projects/BookingList.php");
				$_SESSION['bill'] = getNeedPayBill($bill, $billrate, 2, $paybillinfo, $pbid);
				$operstr = "<a id='payurl' href='/Pay/alipayapi.php?" . $payurlparam . "' class='btnsubmit btn-booking' title='支付" . $paystepname .  "' target='_blank'>支付" . $paystepname . "</a>";
				break;
			case 5:
				$operstr = "<a href='/Eva/Eva.php?pbid=" . $pbid . "' class='btnsubmit btn-booking' title='评价订单'>评价订单</a>";
				break;
			default:
				$operstr = "";
			}
?>
        <table width="100%" border="0" cellspacing="0" cellpadding="0">
          <thead>
          	<tr>
            	<th colspan="4"><span>项目名称：<?php echo $houseestate . round($area, 2); ?>平方米</span><span>户型：<?php echo $wscount; ?>室<?php echo $ktcount; ?>厅<?php echo $wsjcount; ?>卫</span></th>
            </tr>
          </thead>
          <tbody>
            <tr>
              <td>工人：<a href="/User/Show.php?id=<?php echo($uid); ?>" onClick="parent.window.showDiv()" target="UserInfo" title="工人<?php echo $truename; ?>"><?php echo $truename; ?></a></td>
              <td>施工费用：￥<?php echo $bill; ?>（<?php echo($paybillinfo); ?>）</td>
              <td>创建时间：<?php echo $createtime; ?></td>
              <td>更新时间：<?php echo $updatetime; ?></td>
            </tr>
            <tr>
              <td colspan="4" style="padding:10px;">订单流程：<img src="/images/flow/workerbookingstate<?php echo $state; ?>.png"></td>
            </tr>
            <tr>
              <td colspan="4" style="text-align:right"><a href="ShowBooking2.php?utype=3&pbid=<?php echo $pbid; ?>" class="btnsubmit btn-booking" title"查看订单" target="MyMainFrame">查看订单</a><?php echo $operstr; ?></td>
            </tr>
          </tbody>
        </table>
        <?php
		}
	}
	$result->close();
	
	$result = $conn->prepare("select a.id, b.userid, b.id, b.bill, c.houseestate, a.area, d.truename, b.createtime, b.updatetime, b.state, a.wscount, a.ktcount, a.wsjcount, b.billrate from Projects a inner join ProjectBooking b on a.id = b.pid inner join UserProject c on a.upid = c.id inner join User d on b.userid = d.id where c.userid = ? and b.usertype = 4 order by b.updatetime desc");
	$result->bind_param("i", $_SESSION['userid']);
	$result->execute();
	$result->store_result();
	if ($result->num_rows > 0) {
?>
      </div>
    </div>
    <div id="tab4">
      <div class="booking-list">
        <p class="booking-tit">我的装修监理订单</p>
        <?php
		$result->bind_result($pid, $uid, $pbid, $bill, $houseestate, $area, $truename, $createtime, $updatetime, $state, $wscount, $ktcount, $wsjcount, $billrate);
		while ($result->fetch()) {
			$bill = round($bill, 2);
			$paydjbill = getNeedPayBill($bill, $billrate, 1, $paybillinfo, $pbid);
			switch ($state) {
			case 2:
				$paystepname = getPayStepName($billrate, 1);
				$payurlparam = "pbid=PBS" . $pbid . "-1&pbname=" . urlencode($houseestate . round($area, 2)) . "平方米-监理费" . $paystepname . "&body=业主：" . urlencode($_SESSION['truename'] ). ";项目名称：" . urlencode($houseestate . round($area, 2)) . "平方米;监理：" .urlencode($truename) . "。&showurl=" . urlencode("/Projects/BookingList.php");
				$_SESSION['bill'] = $paydjbill;
				$operstr = "<a id='payurl' href='/Pay/alipayapi.php?" . $payurlparam . "' class='btnsubmit btn-booking' title='支付" . $paystepname . "' target='_blank'>支付" . $paystepname . "</a>";
				break;
			case 4:
				$paidbill = getBillPaid($pbid);
				$paystepname = getPayStepName($billrate, 2);
				$payurlparam = "pbid=PBS" . $pbid . "-2&pbname=" . urlencode($houseestate . round($area, 2)) . "平方米-监理费" . $paystepname . "&body=业主：" . urlencode($_SESSION['truename'] ). ";项目名称：" . urlencode($houseestate . round($area, 2)) . "平方米;监理：" .urlencode($truename) . "。&showurl=" . urlencode("/Projects/BookingList.php");
				$_SESSION['bill'] = getNeedPayBill($bill, $billrate, 2, $paybillinfo, $pbid);
				$operstr = "<a id='payurl' href='/Pay/alipayapi.php?" . $payurlparam . "' class='btnsubmit btn-booking' title='支付" . $paystepname .  "' target='_blank'>支付" . $paystepname . "</a>";
				break;
			case 5:
				$operstr = "<a href='/Eva/Eva.php?pbid=" . $pbid . "' class='btnsubmit btn-booking' title='评价订单'>评价订单</a>";
				break;
			default:
				$operstr = "";
			}
			if (($state > 2) && ($state < 5)) $operstr = "<a href='/project/ConstructProgress.php?pbid=" . $pbid . "' class='btnsubmit btn-booking' title='监理进度' target='_blank'>监理进度</a>" . $operstr;

?>
        <table width="100%" border="0" cellspacing="0" cellpadding="0">
          <thead>
          	<tr>
            	<th colspan="4"><span>项目名称：<?php echo $houseestate . round($area, 2); ?>平方米</span><span>户型：<?php echo $wscount; ?>室<?php echo $ktcount; ?>厅<?php echo $wsjcount; ?>卫</span></th>
            </tr>
          </thead>
          <tbody>
            <tr>
              <td>监理：<a href="/User/Show.php?id=<?php echo($uid); ?>" onClick="parent.window.showDiv()" target="UserInfo" title="监理<?php echo $truename; ?>"><?php echo $truename; ?></a></td>
              <td>监理费用：￥<?php echo $bill; ?>（其中<?php echo($paybillinfo); ?>）</td>
              <td>创建时间：<?php echo $createtime; ?></td>
              <td>更新时间：<?php echo $updatetime; ?></td>
            </tr>
            <tr>
              <td></td>
              <td colspan="4" style="padding:10px;">订单流程：<img src="/images/flow/supervisbookingstate<?php echo $state; ?>.png"></td>
            </tr>
            <tr>
              <td colspan="4" style="text-align:right"><a href="ShowBooking.php?utype=4&pbid=<?php echo $pbid; ?>" class="btnsubmit btn-booking" title"查看订单" target="MyMainFrame">查看订单</a><?php echo $operstr; ?></td>
            </tr>
          </tbody>
        </table>
        <?php
		}
	}
	$result->close();
	$conn->close();
?>
      </div>
    </div>
  </div>
  <br>
  <br>
  <div id="dc-pay" title="支付">
    <p><span class="ui-icon ui-icon-alert" style="float:left; margin:0 7px 20px 0;"></span>支付是否已成功完成，或遇到了支付问题？</p>
  </div>
  <div id="dc-nodesign1" title="不满意设计">
    <p><span class="ui-icon ui-icon-alert" style="float:left; margin:0 7px 20px 0;"></span>您对设计方案不满意，请问是否确认让设计师重新设计方案？</p>
  </div>
  <div id="dc-nodesign2" title="不满意设计">
    <p><span class="ui-icon ui-icon-alert" style="float:left; margin:0 7px 20px 0;"></span>您对设计方案不满意，请问是否结束该设计订单？<br>
      结束设计订单，将不用再支付剩余的设计尾款，但已支付的设计定金将不能退还。</p>
  </div>
</div>
<script type="text/javascript">	
    function resetTabs(){
	    $("#content > div").hide(); //Hide all content
	    $("#tabs a").attr("id",""); //Reset id's      
	}
	var myUrl = window.location.href; //get URL
	var myUrlTab = myUrl.substring(myUrl.indexOf("#")); 
	var myUrlTabName = myUrlTab.substring(0,4); 
	(function(){
	    $("#content > div").hide(); // Initially hide all content
	    $("#tabs li:first a").attr("id","current"); // Activate first tab
	    $("#content > div:first").fadeIn(); // Show first tab content
	    
	    $("#tabs a").on("click",function(e) {
	        e.preventDefault();
	        if ($(this).attr("id") == "current"){ //detection for current tab
	         return       
	        }
	        else{             
	        resetTabs();
	        $(this).attr("id","current"); // Activate this
	        $($(this).attr('name')).fadeIn(); // Show content for current tab
	        }
	    });
	    for (i = 1; i <= $("#tabs li").length; i++) {
	     	 if (myUrlTab == myUrlTabName + i) {
		          resetTabs();
		          $("a[name='"+myUrlTab+"']").attr("id","current"); // Activate url tab
		          $(myUrlTab).fadeIn(); // Show url tab content        
	      	}
	    }
	})()  
</script>
</body>
</html>