<?php
    function inject_check($sql_str) {
		return preg_match('/select|insert|update|delete|\'|\\*|\*|\.\.\/|\.\/|union|into|load_file|outfile/i', $sql_str);
	}
	//用于检查字符串中是否有可能产生sql注入的内容，返回大于0表示有，等于0表示没有
	
    function inject_check2($sql_str) {
		return preg_match('/insert|update|delete|load_file|outfile/i', $sql_str);
	}
	//更弱的注入检测
	
	function getIP() { 
		if (getenv('HTTP_CLIENT_IP')) { 
			$ip = getenv('HTTP_CLIENT_IP'); 
		} 
		elseif (getenv('HTTP_X_FORWARDED_FOR')) { 
			$ip = getenv('HTTP_X_FORWARDED_FOR'); 
		} 
		elseif (getenv('HTTP_X_FORWARDED')) { 
			$ip = getenv('HTTP_X_FORWARDED'); 
		} 
		elseif (getenv('HTTP_FORWARDED_FOR')) { 
			$ip = getenv('HTTP_FORWARDED_FOR'); 
		} 
		elseif (getenv('HTTP_FORWARDED')) { 
			$ip = getenv('HTTP_FORWARDED'); 
		} 
		else { 
			$ip = $_SERVER['REMOTE_ADDR']; 
		} 
		return $ip; 
	}
	//获得访客的IP
	
	function calcAge($birth) {
		$birtharray = explode('-', $birth);
		if (count($birtharray) == 3) {
			$by = $birtharray[0];
			$bm = $birtharray[1];
			$bd = $birtharray[2];
		} else {
			$by = $birtharray[0];
			$bm = 1;
		}
		$cm = date('n');
		$cd = date('j');
		$age = date('Y') - $by - 1;
		if ($cm > $bm || $cm == $bm && $cd > $bd) $age++;
		return $age;
	}
	//根据出生日期计算年龄
	
	function getUrl($url) {
    	if ($url == '') return false;
		$file = "";   
    	$fp = fopen($url, 'r') or exit('Open url faild!');    
    	if ($fp) {  
			while(!feof($fp)) {    
				$file .= fgets($fp) ."";  
			}  
			fclose($fp);    
    	}  
    	return $file;  
	}
	//访问某个网址并获得内容
	
	function getUnit($Unit) { 
	    $Unitstr = '';
		if (strpos($Unit, "1") > -1) $Unitstr = "平方米 ";
		if (strpos($Unit, "2") > -1) $Unitstr .= "米 ";
		if (strpos($Unit, "3") > -1) $Unitstr .= "个 ";
		if (strpos($Unit, "4") > -1) $Unitstr .= "套";
		if (strpos($Unit, "5") > -1) $Unitstr .= "根 ";
		if (strpos($Unit, "6") > -1) $Unitstr .= "公里";
		if (strpos($Unit, "7") > -1) $Unitstr .= "桶";
		return $Unitstr;
	}
	//获得单位类型
	
	function substr_cut($user_name) {
		$strlen = mb_strlen($user_name, 'utf-8');
		$firstStr = mb_substr($user_name, 0, 1, 'utf-8');
		for ($i=1;$i<$strlen;$i++){
			$firstStr = $firstStr."*";
		}
		return $firstStr;
	}
	//隐藏人名
	
	/*$sourcestr 变量， $cutlength 长度； 超出长度则以省略号代替被截掉的部分 */
	function cut_str($sourcestr,$cutlength){  
		$returnstr='';  
		$i=0;  
		$n=0;  
		$str_length=strlen($sourcestr);//字符串的字节数  
		while (($n<$cutlength) and ($i<=$str_length)){  
		  $temp_str=substr($sourcestr,$i,1);  
		  $ascnum=Ord($temp_str);//得到字符串中第$i位字符的ascii码  
		  if ($ascnum>=224){  
			 $returnstr=$returnstr.substr($sourcestr,$i,3); 
			 $i=$i+3;            
			 $n++;            
		  }elseif($ascnum>=192){  
			 $returnstr=$returnstr.substr($sourcestr,$i,2); 
			 $i=$i+2;            
			 $n++;           
		  }elseif ($ascnum>=65 && $ascnum<=90){  
			 $returnstr=$returnstr.substr($sourcestr,$i,1);  
			 $i=$i+1;            //实际的Byte数仍计1个  
			 $n++;            //但考虑整体美观，大写字母计成一个高位字符  
		  }else{  
			 $returnstr=$returnstr.substr($sourcestr,$i,1);  
			 $i=$i+1;            
			 $n=$n+0.5;          
		  }  
		}  
		if ($str_length>$i){  
		  $returnstr = $returnstr . "...";//超过长度时在尾处加上省略号  
		}  
		return $returnstr;  
	}
?>