<?php


class ImageTool {
    // imageInfo 分析图片的信息
    // return array()
    public static function imageInfo($image) {
        // 判断图片是否存在
        if(!file_exists($image)) {
            return false;
        }

        $info = getimagesize($image);
        
        if($info == false) {
            return false;
        }

        // 此时info分析出来,是一个数组
        $img['width'] = $info[0];
        $img['height'] = $info[1];
        $img['ext'] = substr($info['mime'],strpos($info['mime'],'/')+1);

        return $img;
    }
    /**
        thumb 生成缩略图
        等比例缩放,两边留白
    **/
    public static function thumb($dst,$save=NULL,$width=300,$height=100000) {
        // 首先判断待处理的图片存不存在
        $dinfo = self::imageInfo($dst);
        if($dinfo == false) {
            return false;
        }
		$srcWidth = $dinfo['width'];
        $srcHeight = $dinfo['height'];

        $scale = min($width / $srcWidth, $height / $srcHeight); // 计算缩放比例
        if ($scale >= 1) {
            // 超过原图大小不再缩略
            $width = $srcWidth;
            $height = $srcHeight;
        } else {
            // 缩略图尺寸
            $width = (int) ($srcWidth * $scale);
            $height = (int) ($srcHeight * $scale);
        }

        // 载入原图
        // 创建原始图的画布
        $dfunc = 'imagecreatefrom' . $dinfo['ext'];
        $dim = $dfunc($dst);
      
        // 创建缩略画布
        $tim = imagecreatetruecolor($width,$height);

        // 创建白色填充缩略画布
        $white = imagecolorallocate($tim,255,255,255);

        // 填充缩略画布
        imagefill($tim,0,0,$red);
        imagecopyresampled($tim,$dim,0,0,0,0,$width,$height,$dinfo['width'],$dinfo['height']);

        // 保存图片
        if(!$save) {
            $save = $dst;
            unlink($dst);
        }

        $createfunc = 'image' . $dinfo['ext'];
        $createfunc($tim,$save);

        imagedestroy($dim);
        imagedestroy($tim);

        return true;

    }


  
    


}