<?php
class UpTool {
	protected $saveDir = '/pic/';
	protected $saveSubDir = '';
	protected $fileName = '';
    protected $allowExt = 'jpg,jpeg,gif,bmp,png';
    protected $maxSize = 5; //1M,M为单位
    protected $errno = 0; // 错误代码
    protected $error = array(
        0=>'无错',
        1=>'上传照片超出系统限制',
        2=>'上传照片大小超出网页表单页面',
        3=>'照片只有部分被上传',
        4=>'没有照片被上传',
        6=>'找不到临时文件夹',
        7=>'照片写入失败',
        8=>'不允许的照片后缀',
        9=>'照片大小超出的类的允许范围',
        10=>'创建目录失败',
        11=>'移动失败'   
    );
    function __construct()
	{ //定义构造函数
         if (!defined("IN_MANLM_SHOP"))
	       $this->saveDir = '/pic/';
	     else
	       $this->saveDir = '/pic/shop/';
     }
    public function up($key) {
        if(!isset($_FILES[$key])) {
            return false;
        }
        $f = $_FILES[$key];


        // 检验上传有没有成功
        if($f['error']) {
            $this->errno = $f['error'];
            return false;
        }

        // 获取后缀
        $ext = $this->getExt($f['name']);
        
        // 检查后缀
        if(!$this->isAllowExt($ext)) {
            $this->errno = 8;
            return false;
        }

        // 检查大小
        if(!$this->isAllowSize($f['size'])) {
            $this->errno = 9;
			
            return false;
        }
        // 通过

        //创建目录
		
        $dir = $this->mk_dir();

        if($dir == false) {
            $this->error = 10;
            return false;
        }
    
        // 生成随机图片名
		if ($this->fileName == '') {
        	$newname = $this->randName() . '.' . $ext;
		} else {
			$newname = $this->fileName. '.jpg';	//如果指定了文件名称，则无论上传的图片是什么图片类型的，保存的时候都统一存为jpg后缀。
		}
        $dir = $dir . $newname;

        // 移动
        if(!move_uploaded_file($f['tmp_name'],$dir)) {
            $this->errno = 11;
            return false;
        }
        return str_replace($_SERVER['DOCUMENT_ROOT'],'',$dir);
    
    }
    
    public function getErr() {
        return $this->error[$this->errno];
    }
    /*
        parm string $exts 允许的后缀
    */
    public function setExt($exts) {
        $this->allowExt = $exts;
    }
    public function setSize($num) {
        $this->maxSize = $num;
    }
	public function setFileName($fileName) {
		$this->fileName = $fileName;
	}
	public function createFileNamebyUserID($userID) {
		$this->saveSubDir = floor($userID / 10000) . '/';
		$this->saveSubDir .= floor($userID % 10000 / 100) . '/';
		$this->fileName = (string)floor($userID % 10000 % 100);
		$saveinfo = array("path"=>$this->saveSubDir,"name"=>$this->fileName);
		return $saveinfo;
	}
	public function getFileNameByUserID($userID) {
		$returnFileName = $this->saveDir . floor($userID / 10000) . '/';
		$returnFileName .= floor($userID % 10000 / 100) . '/';
		$returnFileName .= (string)floor($userID % 10000 % 100) . '.jpg';
		return $returnFileName;
	}
    /*
        parm String $file
        return String $ext 后缀
    */
    protected function getExt($file) {
        $tmp = explode('.',$file);
        return end($tmp);
    }
    /*
        防止大小写的问题 JPG
    */
    protected function isAllowExt($ext) {
        return in_array(strtolower($ext),explode(',',strtolower($this->allowExt)));
    }
    // 检查照片的大小 
    protected function isAllowSize($size) {
        return $size <= $this->maxSize * 1024 * 1024;
    }
    /*
        按日期创建目录的方法
    */
    protected function mk_dir() {
		$dir = $_SERVER['DOCUMENT_ROOT'] . $this->saveDir . $this->saveSubDir;
		if ($this->fileName == '') {
        	$dir = $dir . date('Y/m/d') . "/";
		}
        if(is_dir($dir) || mkdir($dir, 0777, true)) {
            return $dir;
        } else {
            return false;
        }
    }
    /*
        生成随机文件名
    */
    protected function randName($length = 8) {
        $str = 'abcdefghijkmnpqrstuvwxyz23456789';
        return substr(str_shuffle($str), 0, $length);
    }
}
?>