<?php
require_once $_SERVER['DOCUMENT_ROOT']."/comn/ImageTool.class.php";
class UpTool {
	protected $saveDir = '/pic/';
	protected $saveSubDir = '';
	protected $fileName = '';
    protected $allowExt = 'jpg,jpeg,gif,bmp,png';
    protected $maxSize = 5; //1M,M为单位
    protected $errno = 0; // 错误代码
    protected $error = array(
        0=>'无错',
        1=>'上传照片超出系统限制',
        2=>'上传照片大小超出网页表单页面',
        3=>'照片只有部分被上传',
        4=>'没有照片被上传',
        6=>'找不到临时文件夹',
        7=>'照片写入失败',
        8=>'不允许的照片后缀',
        9=>'照片大小超出的类的允许范围',
        10=>'创建目录失败',
        11=>'移动失败'   
    );
    protected  $goods_img;
	  
    public function up($key,$maxWidth='',$maxHeight='') {

        if(!isset($_FILES[$key])) {
            return false;
        }
        //$f = $_FILES[$key];
        $name = $_FILES[$key]['name'];       
		$tmp_name = $_FILES[$key]['tmp_name'];       
		$size = $_FILES[$key]['size'];       
		$error = $_FILES[$key]['error']; 
        $IsCover = 0;  $errstr = '';
		
        for($i = 0; $i < count($name); $i++)
		{
        // 检验上传有没有成功
        if($error[$i]) {
            $this->errno = $error[$i];
            return false;
        }
		
       // $this->createFileNamebyUserID($uidf);
        // 获取后缀
        $ext = $this->getExt($name[$i]);
        
        // 检查后缀
        if(!$this->isAllowExt($ext)) {
            $this->errno = 8;
            return false;
        }

        // 检查大小
        if(!$this->isAllowSize($size[$i])) {
            $this->errno = 9;
			
            return false;
        }
        // 通过

        //创建目录
		
        $dir = $this->mk_dir();

        if($dir == false) {
            $this->error = 10;
            return false;
        }
    
        // 生成随机图片名
		if ($this->fileName == '') {
        	$newname = $this->randName() . '.' . $ext;
		} else {
			$newname = $this->fileName. '.jpg';	//如果指定了文件名称，则无论上传的图片是什么图片类型的，保存的时候都统一存为jpg后缀。
		}
        $dir = $dir . $newname;

        // 移动
        if(!move_uploaded_file($tmp_name[$i],$dir)) {
            $this->errno = 11;
            return false;
        }
		
		
		//如果宽高没有值的话就不进行裁剪处理
		if($maxWidth == null AND $maxHeight == null){
			 $SaveImg[] = str_replace(ROOT,'',$dir);
			 return $SaveImg;
			
		}else{
			//调用thumb进行裁剪
			$UrlImage = str_replace(ROOT,'',$dir);
			$info = UpTool::thumb($UrlImage,$UrlImage,'',$maxWidth,$maxHeight);
			$SaveImg[] = str_replace($_SERVER['DOCUMENT_ROOT'],'',$info);//替换掉绝对路径后保存为数组返回
			return $SaveImg;
		}
        /*$res = str_replace($_SERVER['DOCUMENT_ROOT'],'',$dir);
		ImageTool::thumb($res, $this->goods_img, 160, 120);
		$img_path = $res;
				$sqlstr = "insert into materialgallery(MatID, ImgUrl) values(?,?)";
			    $stmt = $GLOBALS['conn']->prepare($sqlstr);
			    $stmt->bind_param("is", $MatID, $img_path);
				$stmt->execute();
				 if ($stmt->errno)
	             {   
		            $errstr = '  '.$name[$i];
	             }
				 $stmt->close();*/
				 
		}

		  print_r($SaveImg);
		  
		  
    }
    
    public function getErr() {
        return $this->error[$this->errno];
    }
    /*
        parm string $exts 允许的后缀
    */
    public function setExt($exts) {
        $this->allowExt = $exts;
    }
    public function setSize($num) {
        $this->maxSize = $num;
    }
	public function setFileName($fileName) {
		$this->fileName = $fileName;
	}
	public function createFileNamebyUserID($userID) {
		$this->saveSubDir = floor($userID / 10000) . '/';
		$this->saveSubDir .= floor($userID % 10000 / 100) . '/';
		$this->fileName = (string)floor($userID % 10000 % 100);
	}
	public function getFileNameByUserID($userID) {
		$returnFileName = $this->saveDir . floor($userID / 10000) . '/';
		$returnFileName .= floor($userID % 10000 / 100) . '/';
		$returnFileName .= (string)floor($userID % 10000 % 100) . '.jpg';
		return $returnFileName;
	}
    /*
        parm String $file
        return String $ext 后缀
    */
    protected function getExt($file) {
        $tmp = explode('.',$file);
        return end($tmp);
    }
    /*
        防止大小写的问题 JPG
    */
    protected function isAllowExt($ext) {
        return in_array(strtolower($ext),explode(',',strtolower($this->allowExt)));
    }
    // 检查照片的大小 
    protected function isAllowSize($size) {
        return $size <= $this->maxSize * 1024 * 1024;
    }
    /*
        按日期创建目录的方法
    */
    protected function mk_dir() {
		$dir = $_SERVER['DOCUMENT_ROOT'] . $this->saveDir . $this->saveSubDir;
		if ($this->fileName == '') {
        	$dir = $dir . date('Y/m/d') . "/";
		}
        if(is_dir($dir) || mkdir($dir, 0777, true)) {
            return $dir;
        } else {
            return false;
        }
    }
    /*
        生成随机文件名
    */
    protected function randName($length = 8) {
        $str = 'abcdefghijkmnpqrstuvwxyz23456789';
        return substr(str_shuffle($str), 0, $length);
    }
	
	//王朝忠————
	/**
     * 取得图像信息
     * @static
     * @access public
     * @param string $image 图像文件名
     * @return mixed
     */

    static function getImageInfo($img) {
        $imageInfo = getimagesize($img);
        if ($imageInfo !== false) {
            $imageType = strtolower(substr(image_type_to_extension($imageInfo[2]), 1));
            $imageSize = filesize($img);
            $info = array(
                "width" => $imageInfo[0],
                "height" => $imageInfo[1],
                "type" => $imageType,
                "size" => $imageSize,
                "mime" => $imageInfo['mime']
            );
            return $info;
        } else {
            return false;
        }
    }
	
	/**
     * 裁剪压缩图片
     * @static
     * @access public
     * @param string $image  原图
     * @param string $type 图像格式
     * @param string $thumbname 缩略图文件名
     * @param string $maxWidth  宽度
     * @param string $maxHeight  高度
     * @param string $position 缩略图保存目录
     * @param boolean $interlace 启用隔行扫描
     * @return void
     */
    static function thumb($image, $thumbname, $type, $maxWidth, $maxHeight, $interlace=true) {

  		// 获取原图信息
        $info = UpTool::getImageInfo($image);
        if ($info !== false) {
            $srcWidth = $info['width'];
            $srcHeight = $info['height'];
            $type = empty($type) ? $info['type'] : $type;
            $type = strtolower($type);
            $interlace = $interlace ? 1 : 0;
            unset($info);
            $scale = min($maxWidth / $srcWidth, $maxHeight / $srcHeight); // 计算缩放比例
            if ($scale >= 1) {
                // 超过原图大小不再缩略
                $width = $srcWidth;
                $height = $srcHeight;
            } else {
                // 缩略图尺寸
                $width = (int) ($srcWidth * $scale);
                $height = (int) ($srcHeight * $scale);
            }

            // 载入原图
            $createFun = 'ImageCreateFrom' . ($type == 'jpg' ? 'jpeg' : $type);
            if(!function_exists($createFun)) {
                return false;
            }
            $srcImg = $createFun($image);

            //创建缩略图
            if ($type != 'gif' && function_exists('imagecreatetruecolor'))
                $thumbImg = imagecreatetruecolor($width, $height);
            else
                $thumbImg = imagecreate($width, $height);
              //png和gif的透明处理 by luofei614
            if('png'==$type){
                imagealphablending($thumbImg, false);//取消默认的混色模式（为解决阴影为绿色的问题）
                imagesavealpha($thumbImg,true);//设定保存完整的 alpha 通道信息（为解决阴影为绿色的问题）    
            }elseif('gif'==$type){
                $trnprt_indx = imagecolortransparent($srcImg);
                 if ($trnprt_indx >= 0) {
                        //its transparent
                       $trnprt_color = imagecolorsforindex($srcImg , $trnprt_indx);
                       $trnprt_indx = imagecolorallocate($thumbImg, $trnprt_color['red'], $trnprt_color['green'], $trnprt_color['blue']);
                       imagefill($thumbImg, 0, 0, $trnprt_indx);
                       imagecolortransparent($thumbImg, $trnprt_indx);
              }
            }
            // 复制图片
            if (function_exists("ImageCopyResampled"))
                imagecopyresampled($thumbImg, $srcImg, 0, 0, 0, 0, $width, $height, $srcWidth, $srcHeight);
            else
                imagecopyresized($thumbImg, $srcImg, 0, 0, 0, 0, $width, $height, $srcWidth, $srcHeight);
			
            // 对jpeg图形设置隔行扫描
            if ('jpg' == $type || 'jpeg' == $type)
                imageinterlace($thumbImg, $interlace);

            // 生成图片
            $imageFun = 'image' . ($type == 'jpg' ? 'jpeg' : $type);
            $imageFun($thumbImg, $thumbname);
		
            imagedestroy($thumbImg);
            imagedestroy($srcImg);

            return $thumbname;
        }
        return false;
    }
}
?>