<?php
	$DOCUMENT_ROOT = $_SERVER['DOCUMENT_ROOT'];
	require_once $_SERVER['DOCUMENT_ROOT']."/data/config.php";
	require_once $_SERVER['DOCUMENT_ROOT']."/CheckLogin.php";	
	$conn = new mysqli($db_host, $db_user, $db_pass, $db_name);
	if($_GET['act']=='into'){
		if($_POST['shop']>0){
			$id = $_POST['id'];
			$sql = "SELECT StockCount FROM goods WHERE ID=? and IsDel=0 and StockCount>0";
			$result = $conn->prepare($sql);
			$result->bind_param("i",$id);
			$result->execute();
			$result->bind_result($StockCount);
			$result->fetch();			
			$result->close();
			if(isset($StockCount)){
				$UserID = $_SESSION['userid'];
				$num = intval(@$_POST['num'])>1?@$_POST['num']:1;
				$AddTime = date('Y-m-d H:i:s');
				$result = $conn->prepare("SELECT ID,BuyCount FROM shoppingcart WHERE UserID=? and GoodsID=?");
				$result->bind_param("ii",$UserID,$id);
				$result->execute();
				$result->bind_result($shoppingcartid,$BuyCount);
				$result->fetch();
				$result->close();
				if(empty($shoppingcartid)){
					$sql = "insert into shoppingcart (UserID, GoodsID, BuyCount, AddTime) values (?,?,?,?)";
					$result = $conn->prepare($sql);
					$result->bind_param("iiis",$UserID,$id,$num,$AddTime);
					$result->execute();
					if(!$result->errno){
						$result->close();
						$arr = array('info'=>'加入购物车成功！','status'=>1,'data'=>'');
						echo json_encode($arr);	
					}else{
						$arr = array('info'=>'加入购物车失败！','status'=>0,'data'=>'');
						echo json_encode($arr);
					}
				}else{
					if($StockCount>=($BuyCount+$num)){
						$result = $conn->prepare("update shoppingcart set BuyCount=?+BuyCount where UserID=? and GoodsID=?");
						$result->bind_param("iii",$num,$UserID,$id);
						$result->execute();
						if(!$result->errno){
							$arr = array('info'=>'购物车已有该商品，数量增加！','status'=>1,'data'=>'');
						}
						$result->close();
					}else{
							$arr = array('info'=>'购物车已有该商品，但库存不足不能给你增加数量了！','status'=>2,'data'=>'');
					}
					echo json_encode($arr);	
				}
			}
		}else{
			$arr = array('info'=>'该商品有改动，暂时不能购买！','status'=>0,'data'=>'');
			echo json_encode($arr);
		}
	}
	if($_GET['act']=='update_number'){
		if(isset($_SESSION['userid'])){
			if($_GET['is_ajax']==1){
				$uid = $_SESSION['userid'];
				$id =  $_POST['id'];
				$cartid = $_POST['cartid'];
				$nums = $_POST['num'];
				$sql = "SELECT StockCount FROM goods WHERE ID=? and IsDel=0 and StockCount>0";
				$result = $conn->prepare($sql);
				$result->bind_param("i",$id);
				$result->execute();
				$result->bind_result($StockCount);
				while ($result->fetch()) {
					
				}
				$result->close();
				if(isset($StockCount)){
					if($cartid>0 and $nums>0){
							if(($StockCount-$nums)>=0){
								$result = $conn->prepare("update shoppingcart set BuyCount=? where ID=? and userid=?");
								$result->bind_param("iii",$nums,$cartid,$uid);
								$result->execute();
								if(!$result->errno){
									$result->close();
									$conn->close();
									}else{
										$arr = array('info'=>'修改数量失败！','status'=>0,'data'=>$StockCount);
										echo json_encode($arr);
									}
							}else{
								$result = $conn->prepare("update shoppingcart set BuyCount=? where ID=? and userid=?");
								$result->bind_param("iii",$StockCount,$cartid,$uid);
								$result->execute();
								if(!$result->errno){
									$result->close();
									$conn->close();
									$arr = array('info'=>'当前数量大与库存的实时数量，请重新选择！','status'=>1,'data'=>$StockCount);
									echo json_encode($arr);
								}else{
									$arr = array('info'=>'修改数量失败！','status'=>0,'data'=>$StockCount);
									echo json_encode($arr);
								}
							}
			
					}
				}
				exit;
			}
		}
		
	}

	if($_GET['act']=='del'){
		$id =  $_POST['id'];
		$uid = $_SESSION['userid'];
		$result = $conn->prepare("delete from shoppingcart where ID=? and userid=?");
		$result->bind_param("ii",$id,$uid);
		$result->execute();
		if(!$result->errno){
			if($result->affected_rows>0){
			    $arr = array('info'=>'删除成功！','status'=>1);
				echo json_encode($arr);
			}
			$result->close();
		}
	}
	
	if($_GET['act']=='query'){
		$uid = $_SESSION['userid'];
		$result = $conn->prepare("SELECT a.id,a.goodsid,a.buycount,b.name,b.model,b.color,b.brand,b.price,b.stockcount,(a.buycount*b.price) AS totalPrice,c.imgurl FROM((SELECT * FROM shoppingcart WHERE UserID=? ORDER BY id) AS a INNER JOIN goods b ON a.goodsid=b.id) INNER JOIN goodsgallery c ON a.goodsid=c.goodsid GROUP BY a.goodsid");
		$result->bind_param("i",$uid);
		$result->execute();
		$result->bind_result($id,$goodsid,$buycount,$name,$model,$color,$brand,$price,$stockcount,$totalprice,$imgurl);
		$i=0;
		$goodsArr = array();
		while ($result->fetch()){
			$i++;
			$goodsArr[$i]['id'] = $id; 
			$goodsArr[$i]['goodsid'] = $goodsid;
			$goodsArr[$i]['buycount'] = $buycount;
			$goodsArr[$i]['name'] = $name;
			$goodsArr[$i]['model'] = $model;
			$goodsArr[$i]['color'] = $color;
			$goodsArr[$i]['brand'] = $brand;
			$goodsArr[$i]['price'] = $price;
			$goodsArr[$i]['stockcount'] = $stockcount;
			$goodsArr[$i]['totalprice'] = $totalprice;
			$goodsArr[$i]['imgurl'] = $imgurl;
		}
		if(!$result->errno){
			$result->close();
			if(isset($goodsArr)){
				$arr = array('info'=>'查询成功！','status'=>1,'data'=>$goodsArr);
				echo json_encode($arr);
			}else{
				$arr = array('info'=>'查询成功！','status'=>1);
				echo json_encode($arr);
			}
			
		}		
	}
	$conn->close();
  ?>
  