<?php
require_once $_SERVER['DOCUMENT_ROOT']."/comn/ImageTool.class.php";
class UpTool {
	protected $saveDir = '/pic/';
	protected $saveSubDir = '';
	protected $fileName = '';
    protected $allowExt = 'jpg,jpeg,gif,bmp,png';
    protected $maxSize = 5; //1M,M为单位
    protected $errno = 0; // 错误代码
    protected $error = array(
        0=>'无错',
        1=>'上传照片超出系统限制',
        2=>'上传照片大小超出网页表单页面',
        3=>'照片只有部分被上传',
        4=>'没有照片被上传',
        6=>'找不到临时文件夹',
        7=>'照片写入失败',
        8=>'不允许的照片后缀',
        9=>'照片大小超出的类的允许范围',
        10=>'创建目录失败',
        11=>'移动失败'   
    );
    protected  $goods_img;
	  
    public function up($key,$MatID) {
        if(!isset($_FILES[$key])) { 
            return false;
        }
        //$f = $_FILES[$key];
        $name = $_FILES[$key]['name'];       
		$tmp_name = $_FILES[$key]['tmp_name'];       
		$size = $_FILES[$key]['size'];       
		$error = $_FILES[$key]['error']; 
        $IsCover = 0;  $errstr = '';
		
        for($i = 0; $i < count($name); $i++)
		{
        // 检验上传有没有成功
        if($error[$i]) {
            $this->errno = $error[$i];
            return false;
        }
		
       // $this->createFileNamebyUserID($uidf);
        // 获取后缀
        $ext = $this->getExt($name[$i]);
        
        // 检查后缀
        if(!$this->isAllowExt($ext)) {
            $this->errno = 8;
            return false;
        }

        // 检查大小
        if(!$this->isAllowSize($size[$i])) {
            $this->errno = 9;
			
            return false;
        }
        // 通过

        //创建目录
		
        $dir = $this->mk_dir();

        if($dir == false) {
            $this->error = 10;
            return false;
        }
    
        // 生成随机图片名
		if ($this->fileName == '') {
            $newname = $this->randName(); 
            $newname_m = $newname . '_m.' . $ext;
            $newname_s = $newname . '_s.' . $ext;
        	$newname = $newname . '.' . $ext;
		} else {
			$newname = $this->fileName. '.jpg';	//如果指定了文件名称，则无论上传的图片是什么图片类型的，保存的时候都统一存为jpg后缀。
		}
        $this->syt_imgm = $dir . $newname_m;
		$this->syt_imgs = $dir . $newname_s;
        $dir = $dir . $newname;

        // 移动
        if(!move_uploaded_file($tmp_name[$i],$dir)) {
            $this->errno = 11;
            return false;
        }
        $res = str_replace($_SERVER['DOCUMENT_ROOT'],'',$dir);
		ImageTool::thumb($dir, $this->syt_imgs, 217, 217);
		ImageTool::thumb($dir, $this->syt_imgm, 450, 450);
        ImageTool::thumb($dir, $dir, 900, 900);
		$img_path = $res;
				$sqlstr = "insert into goodsgallery(GoodsID, ImgUrl) values(?,?)";
			    $stmt = $GLOBALS['conn']->prepare($sqlstr);
			    $stmt->bind_param("is", $MatID, $img_path);
				$stmt->execute();
				 if ($stmt->errno)
	             {   
		            $errstr = '  '.$name[$i];
	             }
				 $stmt->close();
		}
		if ($errstr!='')
		  echo $errstr.' <script>alert("图片未能上传!");';
		  //echo $MatID. " ".$img_path;
		return true;
    }
    
    public function getErr() {
        return $this->error[$this->errno];
    }
    /*
        parm string $exts 允许的后缀
    */
    public function setExt($exts) {
        $this->allowExt = $exts;
    }
    public function setSize($num) {
        $this->maxSize = $num;
    }
	public function setFileName($fileName) {
		$this->fileName = $fileName;
	}
	public function createFileNamebyUserID($userID) {
		$this->saveSubDir = floor($userID / 10000) . '/';
		$this->saveSubDir .= floor($userID % 10000 / 100) . '/';
		$this->fileName = (string)floor($userID % 10000 % 100);
	}
	public function getFileNameByUserID($userID) {
		$returnFileName = $this->saveDir . floor($userID / 10000) . '/';
		$returnFileName .= floor($userID % 10000 / 100) . '/';
		$returnFileName .= (string)floor($userID % 10000 % 100) . '.jpg';
		return $returnFileName;
	}
    /*
        parm String $file
        return String $ext 后缀
    */
    protected function getExt($file) {
        $tmp = explode('.',$file);
        return end($tmp);
    }
    /*
        防止大小写的问题 JPG
    */
    protected function isAllowExt($ext) {
        return in_array(strtolower($ext),explode(',',strtolower($this->allowExt)));
    }
    // 检查照片的大小 
    protected function isAllowSize($size) {
        return $size <= $this->maxSize * 1024 * 1024;
    }
    /*
        按日期创建目录的方法
    */
    protected function mk_dir() {
		$dir = $_SERVER['DOCUMENT_ROOT'] . $this->saveDir . $this->saveSubDir;
		if ($this->fileName == '') {
        	$dir = $dir . date('Y/m/d') . "/";
		}
        if(is_dir($dir) || mkdir($dir, 0777, true)) {
            return $dir;
        } else {
            return false;
        }
    }
    /*
        生成随机文件名
    */
    protected function randName($length = 8) {
        $str = 'abcdefghijkmnpqrstuvwxyz23456789';
        return substr(str_shuffle($str), 0, $length);
    }
}
?>