/*
Navicat MySQL Data Transfer

Source Server         : localhost
Source Server Version : 50547
Source Host           : localhost:3306
Source Database       : manlm

Target Server Type    : MYSQL
Target Server Version : 50547
File Encoding         : 65001

Date: 2016-08-19 15:29:43
*/

SET FOREIGN_KEY_CHECKS=0;

-- ----------------------------
-- Table structure for advert
-- ----------------------------
DROP TABLE IF EXISTS `advert`;
CREATE TABLE `advert` (
  `ID` mediumint(9) NOT NULL AUTO_INCREMENT COMMENT '标识码',
  `Title` varchar(90) NOT NULL COMMENT '广告标题',
  `AdType` smallint(4) NOT NULL COMMENT '广告类型',
  `BackColor` varchar(6) DEFAULT NULL,
  `ImgUrl` varchar(100) NOT NULL COMMENT '广告图片地址',
  `LinkUrl` varchar(100) DEFAULT NULL COMMENT '广告内容链接地址',
  `OrderNum` tinyint(4) DEFAULT NULL COMMENT '排序码',
  `IsUse` tinyint(4) NOT NULL DEFAULT '1' COMMENT '是否有效',
  `AddTime` datetime NOT NULL COMMENT '上架时间',
  PRIMARY KEY (`ID`),
  KEY `OrderNum` (`OrderNum`),
  KEY `IsUse` (`IsUse`),
  KEY `AdType` (`AdType`)
) ENGINE=InnoDB AUTO_INCREMENT=26 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of advert
-- ----------------------------
INSERT INTO `advert` VALUES ('10', 'headerlogo', '3', '', '/pic/2016/07/15/yvhuq5tm.png', '', '1', '1', '2016-06-16 11:30:45');
INSERT INTO `advert` VALUES ('11', 'headertopright', '4', '', '/pic/2016/06/16/jbt2m765.gif', '', '1', '1', '2016-06-16 11:38:53');
INSERT INTO `advert` VALUES ('12', 'indexbanner1', '5', '38bbab', '/pic/2016/07/15/sxgqeihw.jpg', '', '1', '1', '2016-06-16 11:40:15');
INSERT INTO `advert` VALUES ('13', 'indexbanner2', '5', '4faaff', '/pic/2016/06/16/72v3w4bz.jpg', '', '1', '1', '2016-06-16 11:44:36');
INSERT INTO `advert` VALUES ('14', 'indexbanner3', '5', 'd66e22', '/pic/2016/07/14/hf7s6ecx.jpg', '', '1', '1', '2016-06-16 11:45:16');
INSERT INTO `advert` VALUES ('15', 'indexrightsidebar1', '6', '', '/pic/2016/06/16/ujk7mrid.gif', '', '1', '1', '2016-06-16 11:47:06');
INSERT INTO `advert` VALUES ('16', 'indexrightsidebar2', '6', '', '/pic/2016/06/16/daxw4gic.gif', '', '1', '1', '2016-06-16 11:47:34');
INSERT INTO `advert` VALUES ('17', 'indexrightzsrz', '7', '', '/pic/2016/06/16/bhaes28t.png', '', '1', '1', '2016-06-16 11:50:05');
INSERT INTO `advert` VALUES ('18', 'indexktjjleftad', '8', '', '/pic/2016/06/16/p2ubrctk.gif', '/mall/List.php?term_id=45,73,87,89,90,91,88,71,75,77,76,78,82,81,80,72,83,84,86,85,74,92,95,94,93', '1', '1', '2016-06-16 11:51:29');
INSERT INTO `advert` VALUES ('19', 'indexwsjjleftad', '8', '', '/pic/2016/06/16/vtspm5dj.jpg', '/mall/List.php?term_id=44,51,56,79,55,54,60,59,58,57,52,61,62,63,64,53,66,65,67,69,70,68', '1', '1', '2016-06-16 11:52:45');
INSERT INTO `advert` VALUES ('20', 'indexctjjleftad', '8', '', '/pic/2016/06/16/raux2c5z.jpg', '/mall/List.php?term_id=46,96,102,101,103,100,99,98,119,118,97,105,117,104', '1', '1', '2016-06-16 11:53:30');
INSERT INTO `advert` VALUES ('21', 'indexjcdsleftad', '8', '', '/pic/2016/06/16/4kwrge82.jpg', '/mall/List.php?term_id=41,25,145,156,155,154,144,153,150,151,173,174,152,148,166,167,168,149,169,147', '1', '1', '2016-06-16 11:54:19');
INSERT INTO `advert` VALUES ('22', 'indexhf1', '11', '', '/pic/2016/06/16/whfnuejs.gif', '', '1', '1', '2016-06-16 11:57:24');
INSERT INTO `advert` VALUES ('23', 'indexhf2', '11', '', '/pic/2016/06/16/s2n7x5va.gif', '', '1', '1', '2016-06-16 11:57:41');
INSERT INTO `advert` VALUES ('24', 'zhaoshangruzhu', '7', '', '/pic/2016/06/20/grtebjw2.jpg', '', '1', '1', '2016-06-20 14:31:34');
INSERT INTO `advert` VALUES ('25', 'xx锁', '24', '', '/pic/2016/07/19/ectrsx85.jpg', 'http://wellhouse.manlm.com/Mall/InfoGoods.php?id=609', '1', '1', '2016-07-19 17:00:40');

-- ----------------------------
-- Table structure for adverttype
-- ----------------------------
DROP TABLE IF EXISTS `adverttype`;
CREATE TABLE `adverttype` (
  `ID` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `Name` varchar(30) NOT NULL,
  `Width` smallint(6) NOT NULL,
  `Height` smallint(6) NOT NULL,
  `Description` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of adverttype
-- ----------------------------
INSERT INTO `adverttype` VALUES ('3', 'headerlogo', '201', '73', '');
INSERT INTO `adverttype` VALUES ('4', 'header顶部右侧', '163', '60', '');
INSERT INTO `adverttype` VALUES ('5', '首页banner', '795', '460', '');
INSERT INTO `adverttype` VALUES ('6', '首页右边sidebar', '170', '170', '');
INSERT INTO `adverttype` VALUES ('7', '首页右边招商入驻', '236', '106', '');
INSERT INTO `adverttype` VALUES ('8', '首页分类左侧', '339', '489', '');
INSERT INTO `adverttype` VALUES ('11', '首页横幅', '1220', '110', '');
INSERT INTO `adverttype` VALUES ('12', 'App幻灯片', '1212', '508', '');
INSERT INTO `adverttype` VALUES ('13', 'App体验馆', '1440', '633', '');
INSERT INTO `adverttype` VALUES ('14', 'APP热门推荐', '310', '300', 'APP热门推荐');
INSERT INTO `adverttype` VALUES ('15', 'APP客厅/卧室-小', '718', '337', '');
INSERT INTO `adverttype` VALUES ('16', 'APP客厅/卧室-大', '718', '763', '');
INSERT INTO `adverttype` VALUES ('18', 'APP餐厅/书房-小', '718', '337', '');
INSERT INTO `adverttype` VALUES ('19', 'APP餐厅/书房-大', '718', '763', '');
INSERT INTO `adverttype` VALUES ('20', 'APP厨房/卫浴-小', '718', '337', '');
INSERT INTO `adverttype` VALUES ('21', 'APP厨房/卫浴-大', '718', '763', '');
INSERT INTO `adverttype` VALUES ('22', 'APP建材/五金小', '718', '337', '');
INSERT INTO `adverttype` VALUES ('23', 'APP建材/五金大', '718', '763', '');
INSERT INTO `adverttype` VALUES ('24', 'APP首页通栏广告', '1440', '311', '');

-- ----------------------------
-- Table structure for appgoodspush
-- ----------------------------
DROP TABLE IF EXISTS `appgoodspush`;
CREATE TABLE `appgoodspush` (
  `ID` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `GoodsID` mediumint(8) unsigned NOT NULL,
  `Title` varchar(45) NOT NULL,
  `Intro` varchar(60) NOT NULL,
  `AdType` smallint(6) NOT NULL,
  `ImgUrl` varchar(100) NOT NULL,
  `IsUse` tinyint(4) NOT NULL DEFAULT '1',
  `AddTime` datetime NOT NULL,
  PRIMARY KEY (`ID`),
  KEY `GoodsID` (`GoodsID`),
  KEY `AdvertType` (`AdType`),
  KEY `IsUse` (`IsUse`)
) ENGINE=InnoDB AUTO_INCREMENT=26 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of appgoodspush
-- ----------------------------
INSERT INTO `appgoodspush` VALUES ('1', '557', '幻灯片1', '', '12', '/pic/2016/06/23/wnbjc2ik.jpg', '1', '2016-06-23 15:00:27');
INSERT INTO `appgoodspush` VALUES ('2', '557', '幻灯片2', '', '12', '/pic/2016/06/23/6suhd2iy.jpg', '1', '2016-06-23 15:01:06');
INSERT INTO `appgoodspush` VALUES ('3', '557', '幻灯片3', '', '12', '/pic/2016/06/23/ua9x2tyh.jpg', '1', '2016-06-23 15:01:32');
INSERT INTO `appgoodspush` VALUES ('4', '557', '幻灯片4', '', '12', '/pic/2016/06/23/t3qb6hfn.jpg', '1', '2016-06-23 15:01:59');
INSERT INTO `appgoodspush` VALUES ('5', '557', '体验馆1', '', '13', '/pic/2016/06/23/s7gpbn9r.jpg', '1', '2016-06-23 15:02:50');
INSERT INTO `appgoodspush` VALUES ('6', '557', '体验馆2', '', '13', '/pic/2016/06/23/9sy7mkgf.jpg', '1', '2016-06-23 15:03:59');
INSERT INTO `appgoodspush` VALUES ('7', '578', '转角沙发', '地中海风格', '14', '/pic/2016/06/24/dihkfxt6.jpg', '1', '2016-06-24 13:57:59');
INSERT INTO `appgoodspush` VALUES ('8', '581', '餐厅五套装', '英式风格', '14', '/pic/2016/06/24/nswvg4jr.jpg', '1', '2016-06-24 14:00:40');
INSERT INTO `appgoodspush` VALUES ('11', '587', '花洒套装', '全铜纯白', '14', '/pic/2016/06/24/jxfn4ark.jpg', '1', '2016-06-24 14:11:24');
INSERT INTO `appgoodspush` VALUES ('12', '592', '软床双人床', '真皮实木床', '14', '/pic/2016/06/24/vu6kmitf.jpg', '1', '2016-06-24 14:12:15');
INSERT INTO `appgoodspush` VALUES ('13', '597', '首页通栏广告', '首页通栏广告', '24', '/pic/2016/06/24/twq3dsnu.jpg', '1', '2016-06-24 14:15:47');
INSERT INTO `appgoodspush` VALUES ('14', '599', '布艺沙发', '都市中的田园风', '16', '/pic/2016/06/27/2pjkcihy.jpg', '1', '2016-06-27 09:59:53');
INSERT INTO `appgoodspush` VALUES ('15', '598', '小户型布艺沙发', '简约现代沙发', '15', '/pic/2016/06/27/kyqfjvhi.jpg', '1', '2016-06-27 10:03:44');
INSERT INTO `appgoodspush` VALUES ('16', '575', '1.5米纯色环保床板床', '欧式简约 店长力荐', '15', '/pic/2016/06/27/wvzb479i.jpg', '1', '2016-06-27 10:06:39');
INSERT INTO `appgoodspush` VALUES ('17', '603', 'GERGO吉歌马赛克陶瓷砖', '腰线地脚线建材', '23', '/pic/2016/06/27/4p9b5wvt.jpg', '1', '2016-06-27 10:11:49');
INSERT INTO `appgoodspush` VALUES ('18', '604', '五金静音铰链柜门', '铰链冷轧钢铰链', '22', '/pic/2016/06/27/r9d52efg.jpg', '1', '2016-06-27 10:14:00');
INSERT INTO `appgoodspush` VALUES ('19', '605', '百强 防腐木地板', '木材木方90*18', '22', '/pic/2016/06/27/6y3hstd2.jpg', '1', '2016-06-27 10:16:06');
INSERT INTO `appgoodspush` VALUES ('20', '602', '水龙头', '科勒卫浴 凯迪厨房', '21', '/pic/2016/06/27/3vw2syd9.jpg', '1', '2016-06-27 10:18:20');
INSERT INTO `appgoodspush` VALUES ('21', '587', '升降花洒套装', '全铜纯白8寸大顶喷', '20', '/pic/2016/06/27/rtnkgx8m.jpg', '1', '2016-06-27 10:21:55');
INSERT INTO `appgoodspush` VALUES ('22', '590', '花浴室柜', '进口橡木实木雕', '20', '/pic/2016/06/27/sxnuw8bz.jpg', '1', '2016-06-27 10:25:45');
INSERT INTO `appgoodspush` VALUES ('23', '583', '白色转角旋转书桌', '现代风格时尚个性书桌', '19', '/pic/2016/06/27/8yisucjn.jpg', '1', '2016-06-27 10:29:09');
INSERT INTO `appgoodspush` VALUES ('24', '582', '实用的木质餐边柜', '韩式田园', '18', '/pic/2016/06/27/varsbnyi.jpg', '1', '2016-06-27 10:30:06');
INSERT INTO `appgoodspush` VALUES ('25', '601', '可折叠拉伸餐桌', '黑白双色拼接功能型1.43米餐桌', '18', '/pic/2016/06/27/aeqm74fn.jpg', '1', '2016-06-27 10:31:47');

-- ----------------------------
-- Table structure for article
-- ----------------------------
DROP TABLE IF EXISTS `article`;
CREATE TABLE `article` (
  `ID` mediumint(9) NOT NULL AUTO_INCREMENT COMMENT '标识码',
  `Title` varchar(50) NOT NULL COMMENT '标题',
  `Content` text NOT NULL COMMENT '内容',
  `Author` varchar(100) DEFAULT NULL COMMENT '作者',
  `CatID` smallint(6) NOT NULL COMMENT '文章分类ID',
  `AppPush` tinyint(4) NOT NULL DEFAULT '0',
  `AddTime` datetime NOT NULL COMMENT '添加时间',
  `IsShow` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `CatID` (`CatID`)
) ENGINE=MyISAM AUTO_INCREMENT=94 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of article
-- ----------------------------
INSERT INTO `article` VALUES ('85', '贵州纳斯科技有限公司简介', '<p>	&nbsp; &nbsp; &nbsp;</p><p>	&nbsp; &nbsp; &nbsp;</p><p><img src=\\\"/pic/upload/image/20160616/1466043629103883507650233391568370.png\\\" title=\\\"1466043629103883507650233391568370.png\\\" alt=\\\"507650233391568370.png\\\"/></p><p style=\\\"text-align: center;\\\">公司LOGO&nbsp;</p><p>公司简介：贵州纳斯科技有限公司，成立于2015年5月12日，主营经营<span style=\\\"font-family: 宋体; font-size: 14px; line-height: 24px; color: rgb(0, 0, 0); background-color: rgb(255, 255, 255);\\\">(计算机软件开发；家用电器、制冷设备、空调设备、计算机配件、二三类机电设备及配件的销售和维修服务。</span></p><p><span style=\\\"font-family: 宋体; font-size: 14px; line-height: 24px; color: rgb(0, 0, 0); background-color: rgb(255, 255, 255);\\\">注册地址：<span style=\\\"margin: 0px; padding: 0px; list-style-type: none; font-size: 14px; line-height: 24px; font-family: 宋体; background-color: rgb(255, 255, 255);\\\">贵州省贵阳市南明区花果园彭家湾花果园项目C区第9（贵阳国际中心3号）栋2单元7层12号房</span></span></p><p>公司法人代表：胡腾</p><p>公司规模：10-50人</p><p>公司口号：让一切更简单</p><p>公司年营业额：<span style=\\\"font-family: SimSun, Arial; font-size: 12px; line-height: 19px; background-color: rgb(255, 255, 255);\\\">200万--500万</span></p><p><span style=\\\"font-family: SimSun, Arial; font-size: 12px; line-height: 19px; background-color: rgb(255, 255, 255);\\\">公司性质：有限责任公司<br/></span></p><p><span style=\\\"font-family:SimSun, Arial\\\"><span style=\\\"line-height: 19px; background-color: rgb(255, 255, 255);\\\">推出项目：硬汉联盟装修平台<a href=\\\"http://www.manlm.com\\\" _src=\\\"http://www.manlm.com\\\">www.manlm.com</a> </span></span></p><p><span style=\\\"font-family:SimSun, Arial\\\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;<span style=\\\"font-family: Arial, SimSun; font-size: 14px; line-height: 24px; text-indent: 28px; background-color: rgb(255, 255, 255);\\\">贵州纳斯科技有限公司与<span style=\\\"font-family: Arial, SimSun; font-size: 18.018px; line-height: 24px; text-indent: 28px; background-color: rgb(255, 255, 255);\\\">贵州物资集团储运总公司推出了威尔豪斯电商平台www.willhs.com、为威尔豪斯家居体验中心提供项目策划、技术软件开发、项目运营等。</span></span></span></p><p><span style=\\\"font-family:SimSun, Arial\\\"><span style=\\\"line-height: 19px; background-color: rgb(255, 255, 255);\\\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;</span></span></p><p><span style=\\\"font-family: SimSun, Arial; font-size: 12px; line-height: 19px; background-color: rgb(255, 255, 255);\\\"><br/></span></p>', '纳斯科技策划部', '31', '0', '2016-06-16 10:29:49', '1');
INSERT INTO `article` VALUES ('60', '拒绝危害 装修材料就要环保的', '<p>	&nbsp; &nbsp; &nbsp;</p><p>	&nbsp; &nbsp; &nbsp;</p><p>&nbsp; &nbsp; &nbsp; &nbsp;便宜无好货，这句话用在装修上来说在合适不过了。便宜的装修材料含的有害物质大大超过环保材料，长期接触会对人体造成或多或少的伤害，千万不能拿家人的健康开玩笑。因此，在选择装修材料的时候一定要选择对人体危害较小的。</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;<img src=\\\"/pic/upload/image/z9xhkecaum5vfdwby32i.jpg\\\" width=\\\"550\\\" height=\\\"410\\\" alt=\\\"\\\"/></p><p>普通装修材料的危害：</p><p>&nbsp;&nbsp;&nbsp;&nbsp;相信大家都听说过新居综合征，就是眼睛、鼻子以及咽喉会感觉到刺痛，有时皮肤也会觉得刺痛或者出现呼吸困难等。这都是可以直接感受到的危害。</p><p>&nbsp;&nbsp;&nbsp;&nbsp;更有一些有毒气体或者放射性污染物会影响到人的神经系统，记忆力会下降，上呼吸道感染，以及免疫能力下降等都是常见的病症。有时人们只会觉得自己是生病了，却不知道污染源就在装修材料上。更严重的就是会引起突变，导致肿瘤的产生。</p><p>&nbsp;&nbsp;&nbsp;&nbsp;上面只是普通装修材料危害的一部分，看到这些，大家还敢再拿健康不当回事吗?接下来就让我们认识一下装修环保材料。</p><p><br/></p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;<img src=\\\"/pic/upload/image/7ypcgxei8mqkr2az9u4b.jpg\\\" width=\\\"550\\\" height=\\\"400\\\" alt=\\\"\\\"/></p><p>&nbsp;&nbsp;&nbsp;&nbsp;装修环保材料的类型：</p><p>&nbsp;&nbsp;&nbsp;&nbsp;基本上无毒无害的材料。这些材料一般都是纯天然的，并未经过过多加工，基本卡上也就是一些纯物理性的加工，比如粉碎，切板或者打磨等。这些材料包括木材、石膏、砂石、大理石等等。</p><p>&nbsp;&nbsp;&nbsp;&nbsp;其次是低毒、低排放的才来哦。这些材料是经过加工的，但是它的有毒性气体等比较小，经过国家的质量检验，不会对人体造成危害。如一些质量好的人造木材等。</p><p>&nbsp;&nbsp;&nbsp;&nbsp;未知的材料</p><p>&nbsp;&nbsp;&nbsp;&nbsp;未知是说明现在的科学发展难以鉴定它是否具有危害性，危害性又有多大。比如一些环保型油漆、乳胶漆等合成材料。在目前的科学水平看来，这些物质是没有害的，但是随着科学技术的发展，人们难以保证不会发现其他的问题。</p><p>&nbsp;&nbsp;&nbsp;&nbsp;装修环保材料的选择也是一门学问，比如墙面的装饰材料就尽量不要使用大面积的人造木板，而是可以选择环保型墙纸。或者将墙面抹平以后，直接使用水溶性的环保涂料。资金充裕者也可以使用环保的织物，这些都是基本上很少危害的材料，并且装饰效果也丝毫不逊色。</p><p><span style=\\\"color: rgb(51, 51, 51); font-size: 16px; line-height: 30px;\\\">&nbsp; &nbsp;&nbsp;</span></p>', '', '21', '0', '2015-12-22 16:38:10', '1');
INSERT INTO `article` VALUES ('61', '圣诞来临之际装饰属于自己的圣诞味', '<p>	&nbsp; &nbsp; &nbsp;</p><p><span style=\\\"font-size: medium;\\\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 一年一度的圣诞节就快到了，赶快来将你的家布置一下，在家里和亲人过一个温馨愉快的圣诞节吧！</span></p><p><span style=\\\"font-size: medium;\\\"><br/></span></p><p><span style=\\\"font-size: medium;\\\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;<img src=\\\"/pic/upload/image/3hz86ajqbtuevmkgyd9r.jpg\\\" width=\\\"550\\\" height=\\\"400\\\" alt=\\\"\\\"/></span></p><p><span style=\\\"font-size: medium;\\\"><br/></span></p><p><span style=\\\"font-size: medium;\\\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 圣诞节当然少不了圣诞树，放一棵圣诞树在客厅就会让你的爱居圣诞气氛up up up。</span></p><p>&nbsp;</p><p><span style=\\\"font-size: medium;\\\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;<img src=\\\"/pic/upload/image/j6s8wutv74zfnprekacb.jpg\\\" width=\\\"550\\\" height=\\\"400\\\" style=\\\"font-size: medium;\\\" alt=\\\"\\\"/></span></p><p><span style=\\\"font-size: medium;\\\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 红绿相间的色彩搭配，再加上长筒袜，这些都是圣诞节不可缺少的元素。</span></p><p>&nbsp;</p><p><span style=\\\"font-size: medium;\\\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;<img src=\\\"/pic/upload/image/i3k87vbtg2yusnqrpzmc.jpg\\\" width=\\\"550\\\" height=\\\"410\\\" alt=\\\"\\\"/><br type=\\\"_moz\\\"/></span></p><p><span style=\\\"font-size: medium;\\\"><br/></span></p><p><span style=\\\"font-size: medium;\\\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;在儿童房间的床边挂上几双长筒袜，半夜悄悄塞满礼物，第二天再告诉ta圣诞老人来过哦。</span></p><p>&nbsp;</p>', '', '27', '0', '2015-12-23 15:35:02', '1');
INSERT INTO `article` VALUES ('63', '卧室灯具怎样摆放 这些风水不要错过', '<p>	&nbsp; &nbsp; &nbsp;</p><p>	&nbsp; &nbsp; &nbsp;</p><p>	&nbsp; &nbsp; &nbsp;</p><p>	&nbsp; &nbsp; &nbsp;</p><p style=\\\"text-align: center;\\\"><span style=\\\"font-size: medium;\\\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;卧室安装灯具应该怎样选择，位置怎样摆放，下面小编就来告诉你。</span></p><p><span style=\\\"font-size: medium; text-align: center;\\\"><br/></span></p><p style=\\\"text-align: center;\\\"><span style=\\\"font-size: medium; text-align: center;\\\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;</span><img src=\\\"/pic/upload/image/zkfam56ng7t8ipu4jwyr.jpg\\\" width=\\\"550\\\" height=\\\"400\\\" alt=\\\"\\\" style=\\\"font-size: medium; text-align: center;\\\"/></p><p><br/></p><p><span style=\\\"font-size: medium;\\\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;(1)我们要根据卧室的空间形状和大小来选择。对于小户型卧室空间选用灯具适合就好，较大卧室空间可选择水晶灯或大型吊灯，而且我们要知道的是水晶灯光线柔和，才能适合卧室的安装。 有的人会通过打造书房，衣帽间等等来加大或缩小原有卧室面积形状，这时我们在在选择灯具时，就要注意卧室形状和整体</span><a href=\\\"http://www.525j.com.cn/\\\" target=\\\"_blank\\\" style=\\\"color: rgb(0, 0, 0); text-decoration: none;\\\"><span style=\\\"font-size: medium;\\\">装修</span></a><span style=\\\"font-size: medium;\\\">风格的统一了。那么在卧室灯安装位置风水中，我们只要避免卧室床顶的安装就不会产生坏的风水。</span></p><p><span style=\\\"font-size: medium;\\\">&nbsp;&nbsp;&nbsp;&nbsp;　 &nbsp; &nbsp; (2)在卧室灯安装风水中，我们可以依据不同卧室装修风格来选择我们的灯具，古典风格的装饰我们就可以用欧式水晶灯，这样才显得古典高雅，如果是现代简约风格的卧室，选用时尚创意的灯具就比较符合我们的审美了。选择好卧室灯之后，我们就可以在卧室灯的安装位置上进行选择了。</span></p><p style=\\\"text-align: center;\\\"><span style=\\\"font-size: medium; text-align: center;\\\"><img src=\\\"/pic/upload/image/20160615/14659763891250333.jpg\\\" title=\\\"14659763891250333.jpg\\\" alt=\\\"3.jpg\\\"/>&nbsp;</span></p><p><span style=\\\"font-size: medium; text-align: center;\\\"><br/></span></p><p><span style=\\\"font-size: medium;\\\">&nbsp;　　 &nbsp; &nbsp; &nbsp;(3)灯具色彩及厚薄的参照元素，卧室灯具占有空间的厚薄也是选择灯具需要注意的地方，卧室层高小于2.8cm的适合选择薄型或匀称类型的吊顶;卧室层高大于2.8m并且小于5m的卧室，适合选用厚型吊灯;灯罩色彩的选择需要考虑卧室墙面及家具的搭配，力求和谐温馨。灯具选择好了那么在卧室灯安装位置风水中，我们就可以根据相关性来确定了。</span></p><p><span style=\\\"font-size: medium;\\\"><span style=\\\"color: rgb(51, 51, 51); line-height: 30px;\\\">&nbsp; &nbsp; 　 &nbsp;</span><span style=\\\"font-size: medium; color: rgb(0, 0, 0);\\\"><span style=\\\"line-height: 30px;\\\"> 　(4)在卧室灯安装位置风水中，床头灯是一个比较浪漫的设计位置，床头灯具有普通照明、局部照明及装饰照明的功能，光照效果应尽量柔和，以免刺眼的灯光打消主人睡意，这个是夜间的最佳灯具。像一些鹅黄色、橙色等这些颜色的光线的灯具就适合安装在床头</span>&nbsp;</span></span></p>', '', '25', '0', '2015-12-28 10:09:02', '1');
INSERT INTO `article` VALUES ('81', '身体不舒服可能是床的摆位出了错', '			<p>	&nbsp; &nbsp; &nbsp;</p><p>	&nbsp; &nbsp; &nbsp;</p><p>	&nbsp; &nbsp; &nbsp;</p><p>	&nbsp; &nbsp;</p><p style=\"white-space: normal;\">&nbsp; &nbsp; &nbsp;1、卧室门不可对床头――主神经痛、头痛。</p><p style=\"white-space: normal;\">&nbsp;&nbsp;&nbsp;&nbsp; 2、室床头不可对明镜――主疑心病重、恶梦、神经痛。</p><p style=\"white-space: normal;\">&nbsp;&nbsp;&nbsp;&nbsp; 3、浴室门不可对床头――主痛风、风湿、头痛。</p><p style=\"white-space: normal;\">&nbsp;&nbsp;&nbsp;&nbsp; 4、床头不可靠在浴室墙――主腰背痛、风湿痛。</p><p style=\"white-space: normal;\">&nbsp;&nbsp;&nbsp;&nbsp; 5、床头不可被梁压――主精神不振、神经质。</p><p style=\"white-space: normal;\">&nbsp;&nbsp;&nbsp;&nbsp; 6、床头不可靠窗，床头放置在窗下或靠窗一侧的墙壁。</p><p>&nbsp;&nbsp;</p><p style=\"text-align: center;\"><img style=\"width: 675px; height: 513px;\" src=\"http://www.manlm.com/pic/upload/image/zkfam56ng7t8ipu4jwyr.jpg\" title=\"146597462297368012.jpg\" alt=\"146597462297368012.jpg\" border=\"0\" height=\"513\" vspace=\"0\" width=\"675\"/></p><p>&nbsp;&nbsp;</p><p>&nbsp;&nbsp;&nbsp;&nbsp; 窗户为理气进出之所，所以床头贴近窗口容易犯冲。在睡床上的人因看不见头前的窗口，容易缺乏安全感，造成精神紧张，影响健康。</p><p>&nbsp;&nbsp;&nbsp;&nbsp; 小知识：不管床的任何一边靠墙，墙上最好不宜有开向室外的窗，尤其是床头所靠的墙上不能有窗。从使用角度讲，一是开关窗户不方便，二是窗上易积尘土，三是容易造成家人受风受寒。从视觉和心理感受角度讲，床的位置应尽量稳固有安全感，以保证休息质量。</p><p>&nbsp;&nbsp;&nbsp;&nbsp; 破解床位法：床应该略高于膝盖。床头不靠门。南北朝向，顺合地磁引力、血液循环系统中主动脉和大静脉的朝向，人易入眠，睡觉质量高。床头不可朝西，地球由东向西自转，血冲头，不安稳。床头宜实靠墙。切忌：横梁压床（空调机挂枕头上方，床正上方悬吊灯）有压抑感，有损身心健康。床不对镜，夜半易被惊吓，不安宁。</p><p>&nbsp;</p>', '', '25', '0', '2016-01-15 16:03:23', '1');
INSERT INTO `article` VALUES ('89', '商城公告', '<p>	&nbsp; &nbsp; &nbsp;</p><p style=\\\"text-align: center;\\\"><span style=\\\"font-size: 24px;\\\"><strong>威尔豪斯家居体验中心</strong></span><strong style=\\\"font-size: 24px;\\\">&nbsp;</strong></p><p>威尔豪斯家居体验中心系贵州省物资集团有限责任公司下属全资子公司贵州省物资储运总公司携手贵州纳斯科技有限公司全力打造的现代家居体验中心，位于贵州省贵阳市富源南路1号。</p><p><br/></p><p><strong><span style=\\\"font-size: 18px;\\\">我们是</span></strong>一站式家庭体验中心：一站式场景家居购物体验，涵盖设计、建材、装修、家具、家电、配送一站式服务，让装修更简单。</p><p><br/></p><p><strong style=\\\"white-space: normal;\\\"><span style=\\\"font-size: 18px;\\\">我们是</span></strong>深度互联网综合体：除场景式营销外，项目还包含电子商城，VR视觉交互系统，3D实景营销APP。管理方面深度融合互联网工具推出智能物流管理系统，大数据采集分析系统。</p><p><br/></p><p><span style=\\\"font-size: 20px;\\\"><strong style=\\\"white-space: normal;\\\">加入我们会员专享</strong></span> 入驻即送商城展示样板间</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;入驻即送电子商城展示店，后台接收系统，直接面向全国</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;入驻即送杂志推广、网络推广、自媒体推广</p><p><br/></p><p><span style=\\\"font-size: 18px;\\\"><strong>关于我们</strong></span></p><p>省物资储运总公司占地面积80万平方米，拥有各类库房20万平方米，货场30万平方米，与贵阳南站相连接长8.41公里的铁路专用线直达库区，主要业务有铁路、公路货物到达、发运、货物装卸、货场、库房出租、陶瓷建材、家具生产、质押监管、现代物流信息等业务，经过五十多年的发展，现已具备成熟物流配置，集收费管理、电子商务、金融、商务办公、信息网络、住宿餐饮、休闲娱乐等为一体的国有现代物流企业。</p><p><br/></p>', '金香', '38', '1', '2016-06-20 16:26:33', '1');
INSERT INTO `article` VALUES ('91', '招商入驻', '<p>	&nbsp; &nbsp; &nbsp;</p><p>	&nbsp; &nbsp; &nbsp;</p><p style=\\\"text-align: center;\\\"><span style=\\\"font-family: 宋体, SimSun;\\\"><strong><span style=\\\"font-size: 24px;\\\">我们的服务</span></strong></span></p><p><span style=\\\"font-size: 20px; font-family: 宋体, SimSun;\\\"><strong><br/></strong></span></p><p><span style=\\\"font-size: 20px; font-family: 宋体, SimSun;\\\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;<span style=\\\"font-family: 宋体, SimSun; font-size: 18px;\\\"> 采取统一规划，统一推广、统一管理和统一形象</span></span></p><p><span style=\\\"font-size: 18px; font-family: 宋体, SimSun;\\\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 统一规划：商业业态，商业规模，商业形象。</span></p><p><span style=\\\"font-size: 18px; font-family: 宋体, SimSun;\\\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 统一推广：统一推广主题、形象、合理配置内外广告位、新品推广。</span></p><p><span style=\\\"font-size: 18px; font-family: 宋体, SimSun;\\\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 统一管理：水电管理、消防管理、安保管理、车辆管理。</span></p><p><span style=\\\"font-size: 18px; font-family: 宋体, SimSun;\\\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 统一形象：不断优化商场档次、保证经营统一性、统一促销管理、统一人员管理。</span></p>', '金香', '39', '1', '2016-06-20 16:59:40', '1');
INSERT INTO `article` VALUES ('92', '招商看这里', '<p>	&nbsp; &nbsp; &nbsp;</p><p style=\\\"margin-top: 0px; margin-bottom: 0px; padding: 0px; outline: none; color: rgb(102, 102, 102); font-family: &#39;Microsoft Yahei&#39;, Arial, Verdana, 宋体; font-size: 14px; line-height: 26px; white-space: normal;\\\"><strong style=\\\"margin: 0px; padding: 0px;\\\"><span style=\\\"margin: 0px; padding: 0px; font-size: 18px;\\\">我们是</span></strong>一站式家庭体验中心：一站式场景家居购物体验，涵盖设计、建材、装修、家具、家电、配送一站式服务，让装修更简单。</p><p style=\\\"margin-top: 0px; margin-bottom: 0px; padding: 0px; outline: none; color: rgb(102, 102, 102); font-family: &#39;Microsoft Yahei&#39;, Arial, Verdana, 宋体; font-size: 14px; line-height: 26px; white-space: normal;\\\"><br style=\\\"margin: 0px; padding: 0px;\\\"/></p><p style=\\\"margin-top: 0px; margin-bottom: 0px; padding: 0px; outline: none; color: rgb(102, 102, 102); font-family: &#39;Microsoft Yahei&#39;, Arial, Verdana, 宋体; font-size: 14px; line-height: 26px; white-space: normal;\\\"><strong style=\\\"margin: 0px; padding: 0px;\\\"><span style=\\\"margin: 0px; padding: 0px; font-size: 18px;\\\">我们是</span></strong>深度互联网综合体：除场景式营销外，项目还包含电子商城，VR视觉交互系统，3D实景营销APP。管理方面深度融合互联网工具推出智能物流管理系统，大数据采集分析系统。</p><p style=\\\"margin-top: 0px; margin-bottom: 0px; padding: 0px; outline: none; color: rgb(102, 102, 102); font-family: &#39;Microsoft Yahei&#39;, Arial, Verdana, 宋体; font-size: 14px; line-height: 26px; white-space: normal;\\\"><br style=\\\"margin: 0px; padding: 0px;\\\"/></p><p style=\\\"margin-top: 0px; margin-bottom: 0px; padding: 0px; outline: none; color: rgb(102, 102, 102); font-family: &#39;Microsoft Yahei&#39;, Arial, Verdana, 宋体; font-size: 14px; line-height: 26px; white-space: normal;\\\"><span style=\\\"margin: 0px; padding: 0px; font-size: 20px;\\\"><strong style=\\\"margin: 0px; padding: 0px;\\\">加入我们会员专享</strong></span>&nbsp;入驻即送商城展示样板间</p><p style=\\\"margin-top: 0px; margin-bottom: 0px; padding: 0px; outline: none; color: rgb(102, 102, 102); font-family: &#39;Microsoft Yahei&#39;, Arial, Verdana, 宋体; font-size: 14px; line-height: 26px; white-space: normal;\\\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;入驻即送电子商城展示店，后台接收系统，直接面向全国</p><p style=\\\"margin-top: 0px; margin-bottom: 0px; padding: 0px; outline: none; color: rgb(102, 102, 102); font-family: &#39;Microsoft Yahei&#39;, Arial, Verdana, 宋体; font-size: 14px; line-height: 26px; white-space: normal;\\\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;入驻即送杂志推广、网络推广、自媒体推广</p><p style=\\\"text-align:center\\\"><img src=\\\"/pic/upload/image/20160621/146649910612768332222222.jpg\\\" title=\\\"146649910612768332222222.jpg\\\" alt=\\\"32222222.jpg\\\"/></p><p style=\\\"margin-top: 0px; margin-bottom: 0px; padding: 0px; outline: none; color: rgb(102, 102, 102); font-family: &#39;Microsoft Yahei&#39;, Arial, Verdana, 宋体; font-size: 14px; line-height: 26px; white-space: normal; text-align: center;\\\"><span style=\\\"margin: 0px; padding: 0px; font-family: 宋体, SimSun;\\\"><strong style=\\\"margin: 0px; padding: 0px;\\\"><span style=\\\"margin: 0px; padding: 0px; font-size: 18px;\\\">新型购物 &nbsp;炫酷没商量</span></strong><br style=\\\"margin: 0px; padding: 0px;\\\"/></span></p><p style=\\\"margin-top: 0px; margin-bottom: 0px; padding: 0px; outline: none; color: rgb(102, 102, 102); font-family: &#39;Microsoft Yahei&#39;, Arial, Verdana, 宋体; font-size: 14px; line-height: 26px; white-space: normal;\\\"><span style=\\\"margin: 0px; padding: 0px; font-family: 宋体, SimSun;\\\"><strong style=\\\"margin: 0px; padding: 0px;\\\"><span style=\\\"margin: 0px; padding: 0px; font-size: 18px;\\\"><br style=\\\"margin: 0px; padding: 0px;\\\"/></span></strong></span></p><p style=\\\"margin-top: 0px; margin-bottom: 0px; padding: 0px; outline: none; color: rgb(102, 102, 102); font-family: &#39;Microsoft Yahei&#39;, Arial, Verdana, 宋体; font-size: 14px; line-height: 26px; white-space: normal; text-align: justify;\\\"><span style=\\\"margin: 0px; padding: 0px; font-family: 宋体, SimSun;\\\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;1.在成品样板间，您可以通过手机扫码查看所有商品信息（包含设计、施工方）。</span></p><p style=\\\"margin-top: 0px; margin-bottom: 0px; padding: 0px; outline: none; color: rgb(102, 102, 102); font-family: &#39;Microsoft Yahei&#39;, Arial, Verdana, 宋体; font-size: 14px; line-height: 26px; white-space: normal; text-align: justify;\\\"><span style=\\\"margin: 0px; padding: 0px; font-family: 宋体, SimSun;\\\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;2.选择您喜欢样板间或商品，通过手机支付、为您省时省心，我们送货上门。</span></p><p style=\\\"margin-top: 0px; margin-bottom: 0px; padding: 0px; outline: none; color: rgb(102, 102, 102); font-family: &#39;Microsoft Yahei&#39;, Arial, Verdana, 宋体; font-size: 14px; line-height: 26px; white-space: normal; text-align: justify;\\\"><span style=\\\"margin: 0px; padding: 0px; font-family: 宋体, SimSun;\\\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;3.选择您喜欢的设计师或施工队，通过手机扫码，实时沟通定制您的家。</span></p><p style=\\\"margin-top: 0px; margin-bottom: 0px; padding: 0px; outline: none; color: rgb(102, 102, 102); font-family: &#39;Microsoft Yahei&#39;, Arial, Verdana, 宋体; font-size: 14px; line-height: 26px; white-space: normal; text-align: justify;\\\"><span style=\\\"margin: 0px; padding: 0px; font-family: 宋体, SimSun;\\\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;4.选择您喜欢是样板间或商品，自行取货。</span></p><p style=\\\"text-align:center\\\"><span style=\\\"margin: 0px; padding: 0px; font-family: 宋体, SimSun;\\\"><img src=\\\"/pic/upload/image/20160621/14665001439114563123123.jpg\\\" title=\\\"14665001439114563123123.jpg\\\" alt=\\\"3123123.jpg\\\"/></span></p><p><br/></p><p style=\\\"margin-top: 0px; margin-bottom: 0px; padding: 0px; outline: none; color: rgb(102, 102, 102); font-family: &#39;Microsoft Yahei&#39;, Arial, Verdana, 宋体; font-size: 14px; line-height: 26px; white-space: normal; text-align: center;\\\"><span style=\\\"margin: 0px; padding: 0px; font-size: 24px; font-family: 宋体, SimSun;\\\"><strong style=\\\"margin: 0px; padding: 0px;\\\">合作理念</strong></span></p><p style=\\\"margin-top: 0px; margin-bottom: 0px; padding: 0px; outline: none; color: rgb(102, 102, 102); font-family: &#39;Microsoft Yahei&#39;, Arial, Verdana, 宋体; font-size: 14px; line-height: 26px; white-space: normal; text-align: center;\\\"><span style=\\\"margin: 0px; padding: 0px; font-size: 16px; font-family: 宋体, SimSun;\\\">威尔豪斯提供商城展示样板间，设计师根据样板间设计效果图，</span></p><p style=\\\"margin-top: 0px; margin-bottom: 0px; padding: 0px; outline: none; color: rgb(102, 102, 102); font-family: &#39;Microsoft Yahei&#39;, Arial, Verdana, 宋体; font-size: 14px; line-height: 26px; white-space: normal; text-align: center;\\\"><span style=\\\"margin: 0px; padding: 0px; font-size: 16px; font-family: 宋体, SimSun;\\\">建材厂家根据效果图提供建材，家具厂家按照效果图制作家具，</span></p><p style=\\\"margin-top: 0px; margin-bottom: 0px; padding: 0px; outline: none; color: rgb(102, 102, 102); font-family: &#39;Microsoft Yahei&#39;, Arial, Verdana, 宋体; font-size: 14px; line-height: 26px; white-space: normal; text-align: center;\\\"><span style=\\\"margin: 0px; padding: 0px; font-family: 宋体, SimSun;\\\"><span style=\\\"margin: 0px; padding: 0px; font-size: 16px;\\\">装修公司进行施工组装。</span><span style=\\\"margin: 0px; padding: 0px;\\\"><span style=\\\"margin: 0px; padding: 0px; font-size: 12px;\\\"></span><span style=\\\"margin: 0px; padding: 0px; font-size: 20px;\\\"><strong style=\\\"margin: 0px; padding: 0px;\\\"><br style=\\\"margin: 0px; padding: 0px;\\\"/></strong></span></span></span></p><p style=\\\"margin-top: 0px; margin-bottom: 0px; padding: 0px; outline: none; color: rgb(102, 102, 102); font-family: &#39;Microsoft Yahei&#39;, Arial, Verdana, 宋体; font-size: 14px; line-height: 26px; white-space: normal;\\\"><span style=\\\"margin: 0px; padding: 0px; font-size: 12px; font-family: 宋体, SimSun;\\\"><br style=\\\"margin: 0px; padding: 0px;\\\"/></span></p><p style=\\\"margin-top: 0px; margin-bottom: 0px; padding: 0px; outline: none; color: rgb(102, 102, 102); font-family: &#39;Microsoft Yahei&#39;, Arial, Verdana, 宋体; font-size: 14px; line-height: 26px; white-space: normal; text-align: center;\\\"><span style=\\\"margin: 0px; padding: 0px; font-size: 18px; font-family: 宋体, SimSun;\\\"><strong style=\\\"margin: 0px; padding: 0px;\\\">合作优势之设计师</strong></span></p><p style=\\\"margin-top: 0px; margin-bottom: 0px; padding: 0px; outline: none; color: rgb(102, 102, 102); font-family: &#39;Microsoft Yahei&#39;, Arial, Verdana, 宋体; font-size: 14px; line-height: 26px; white-space: normal; text-align: center;\\\"><span style=\\\"margin: 0px; padding: 0px; font-family: 宋体, SimSun;\\\">1.设计属于自己的专属样板间，告别纸上谈兵，集中网络营销推广，放大客户成单率。<br style=\\\"margin: 0px; padding: 0px;\\\"/></span></p><p style=\\\"margin-top: 0px; margin-bottom: 0px; padding: 0px; outline: none; color: rgb(102, 102, 102); font-family: &#39;Microsoft Yahei&#39;, Arial, Verdana, 宋体; font-size: 14px; line-height: 26px; white-space: normal; text-align: center;\\\"><span style=\\\"margin: 0px; padding: 0px; font-size: 16px; font-family: 宋体, SimSun;\\\">2.提供免费办公场地，大牌设计师的创业孵化园。</span></p><p style=\\\"margin-top: 0px; margin-bottom: 0px; padding: 0px; outline: none; color: rgb(102, 102, 102); font-family: &#39;Microsoft Yahei&#39;, Arial, Verdana, 宋体; font-size: 14px; line-height: 26px; white-space: normal; text-align: center;\\\"><span style=\\\"margin: 0px; padding: 0px; font-size: 16px; font-family: 宋体, SimSun;\\\">3.培养体验中心专属大牌设计师，让爱设计的你成为设计大咖。</span></p><p style=\\\"margin-top: 0px; margin-bottom: 0px; padding: 0px; outline: none; color: rgb(102, 102, 102); font-family: &#39;Microsoft Yahei&#39;, Arial, Verdana, 宋体; font-size: 14px; line-height: 26px; white-space: normal; text-align: center;\\\"><span style=\\\"margin: 0px; padding: 0px; font-family: 宋体, SimSun;\\\"><br style=\\\"margin: 0px; padding: 0px;\\\"/></span></p><p style=\\\"margin-top: 0px; margin-bottom: 0px; padding: 0px; outline: none; color: rgb(102, 102, 102); font-family: &#39;Microsoft Yahei&#39;, Arial, Verdana, 宋体; font-size: 14px; line-height: 26px; white-space: normal; text-align: center;\\\"><span style=\\\"margin: 0px; padding: 0px; font-family: 宋体, SimSun;\\\"><span style=\\\"margin: 0px; padding: 0px; font-size: 18px;\\\"><strong style=\\\"margin: 0px; padding: 0px;\\\"><strong style=\\\"margin: 0px; padding: 0px;\\\">合作优势之建材商</strong></strong></span><span style=\\\"margin: 0px; padding: 0px;\\\"><strong style=\\\"margin: 0px; padding: 0px;\\\"><span style=\\\"margin: 0px; padding: 0px; font-size: 16px;\\\"><strong style=\\\"margin: 0px; padding: 0px;\\\"></strong></span></strong><br style=\\\"margin: 0px; padding: 0px;\\\"/></span></span></p><p style=\\\"margin-top: 0px; margin-bottom: 0px; padding: 0px; outline: none; color: rgb(102, 102, 102); font-family: &#39;Microsoft Yahei&#39;, Arial, Verdana, 宋体; font-size: 14px; line-height: 26px; white-space: normal; text-align: center;\\\"><span style=\\\"margin: 0px; padding: 0px; font-size: 16px; font-family: 宋体, SimSun;\\\">1.实体商城加电子商城展示，覆盖全国，集中网络营销推广，拓宽营销渠道。</span></p><p style=\\\"margin-top: 0px; margin-bottom: 0px; padding: 0px; outline: none; color: rgb(102, 102, 102); font-family: &#39;Microsoft Yahei&#39;, Arial, Verdana, 宋体; font-size: 14px; line-height: 26px; white-space: normal; text-align: center;\\\"><span style=\\\"margin: 0px; padding: 0px; font-size: 16px; font-family: 宋体, SimSun;\\\">2.建材样板直装实景样板间，告别传统陈列式展示，让产品更加深入人心。</span></p><p style=\\\"margin-top: 0px; margin-bottom: 0px; padding: 0px; outline: none; color: rgb(102, 102, 102); font-family: &#39;Microsoft Yahei&#39;, Arial, Verdana, 宋体; font-size: 14px; line-height: 26px; white-space: normal; text-align: center;\\\"><span style=\\\"margin: 0px; padding: 0px; font-size: 16px; font-family: 宋体, SimSun;\\\">3.统一管理的现代仓储配送管理，不仅省心，更省成本。</span></p><p style=\\\"margin-top: 0px; margin-bottom: 0px; padding: 0px; outline: none; color: rgb(102, 102, 102); font-family: &#39;Microsoft Yahei&#39;, Arial, Verdana, 宋体; font-size: 14px; line-height: 26px; white-space: normal; text-align: center;\\\"><span style=\\\"margin: 0px; padding: 0px; font-family: 宋体, SimSun;\\\"><br style=\\\"margin: 0px; padding: 0px;\\\"/></span></p><p style=\\\"margin-top: 0px; margin-bottom: 0px; padding: 0px; outline: none; color: rgb(102, 102, 102); font-family: &#39;Microsoft Yahei&#39;, Arial, Verdana, 宋体; font-size: 14px; line-height: 26px; white-space: normal; text-align: center;\\\"><span style=\\\"margin: 0px; padding: 0px; font-size: 18px; font-family: 宋体, SimSun;\\\"><strong style=\\\"margin: 0px; padding: 0px;\\\">合作优势之家具厂</strong></span></p><p style=\\\"margin-top: 0px; margin-bottom: 0px; padding: 0px; outline: none; color: rgb(102, 102, 102); font-family: &#39;Microsoft Yahei&#39;, Arial, Verdana, 宋体; font-size: 14px; line-height: 26px; white-space: normal; text-align: center;\\\"><span style=\\\"margin: 0px; padding: 0px; font-size: 16px; font-family: 宋体, SimSun;\\\">1.实体商城加电子商城展示，覆盖全国，集中网络营销推广，设计师辅助销售，放大销售力量。</span></p><p style=\\\"margin-top: 0px; margin-bottom: 0px; padding: 0px; outline: none; color: rgb(102, 102, 102); font-family: &#39;Microsoft Yahei&#39;, Arial, Verdana, 宋体; font-size: 14px; line-height: 26px; white-space: normal; text-align: center;\\\"><span style=\\\"margin: 0px; padding: 0px; font-size: 16px; font-family: 宋体, SimSun;\\\">2.去除中间繁杂环节，提高利润率，三方均获利。</span></p><p style=\\\"margin-top: 0px; margin-bottom: 0px; padding: 0px; outline: none; color: rgb(102, 102, 102); font-family: &#39;Microsoft Yahei&#39;, Arial, Verdana, 宋体; font-size: 14px; line-height: 26px; white-space: normal; text-align: center;\\\"><span style=\\\"margin: 0px; padding: 0px; font-size: 16px; font-family: 宋体, SimSun;\\\">3.场景式营销，按风格搭配销售，让成单率飞。</span></p><p style=\\\"margin-top: 0px; margin-bottom: 0px; padding: 0px; outline: none; color: rgb(102, 102, 102); font-family: &#39;Microsoft Yahei&#39;, Arial, Verdana, 宋体; font-size: 14px; line-height: 26px; white-space: normal; text-align: center;\\\"><span style=\\\"margin: 0px; padding: 0px; font-size: 16px; font-family: 宋体, SimSun;\\\">4.反向定制，降低库存率，成本大为下降。</span></p><p style=\\\"margin-top: 0px; margin-bottom: 0px; padding: 0px; outline: none; color: rgb(102, 102, 102); font-family: &#39;Microsoft Yahei&#39;, Arial, Verdana, 宋体; font-size: 14px; line-height: 26px; white-space: normal; text-align: center;\\\"><span style=\\\"margin: 0px; padding: 0px; font-family: 宋体, SimSun;\\\"><br style=\\\"margin: 0px; padding: 0px;\\\"/></span></p><p style=\\\"margin-top: 0px; margin-bottom: 0px; padding: 0px; outline: none; color: rgb(102, 102, 102); font-family: &#39;Microsoft Yahei&#39;, Arial, Verdana, 宋体; font-size: 14px; line-height: 26px; white-space: normal; text-align: center;\\\"><span style=\\\"margin: 0px; padding: 0px; font-size: 18px; font-family: 宋体, SimSun;\\\"><strong style=\\\"margin: 0px; padding: 0px;\\\">合作优势之施工方</strong></span></p><p style=\\\"margin-top: 0px; margin-bottom: 0px; padding: 0px; outline: none; color: rgb(102, 102, 102); font-family: &#39;Microsoft Yahei&#39;, Arial, Verdana, 宋体; font-size: 14px; line-height: 26px; white-space: normal; text-align: center;\\\"><span style=\\\"margin: 0px; padding: 0px; font-size: 16px; font-family: 宋体, SimSun;\\\">1.组合属于自己的专属样板间，告别纸上谈兵，集中网络营销推广，放大客户成单率。</span></p><p style=\\\"margin-top: 0px; margin-bottom: 0px; padding: 0px; outline: none; color: rgb(102, 102, 102); font-family: &#39;Microsoft Yahei&#39;, Arial, Verdana, 宋体; font-size: 14px; line-height: 26px; white-space: normal; text-align: center;\\\"><span style=\\\"margin: 0px; padding: 0px; font-size: 16px; font-family: 宋体, SimSun;\\\">2.施工质量实景展示，让客户看得见更放心。</span></p><p style=\\\"margin-top: 0px; margin-bottom: 0px; padding: 0px; outline: none; color: rgb(102, 102, 102); font-family: &#39;Microsoft Yahei&#39;, Arial, Verdana, 宋体; font-size: 14px; line-height: 26px; white-space: normal; text-align: center;\\\"><span style=\\\"margin: 0px; padding: 0px; font-size: 16px; font-family: 宋体, SimSun;\\\">3.提供免费办公场地，明星队伍的聚集地。</span></p><p style=\\\"margin-top: 0px; margin-bottom: 0px; padding: 0px; outline: none; color: rgb(102, 102, 102); font-family: &#39;Microsoft Yahei&#39;, Arial, Verdana, 宋体; font-size: 14px; line-height: 26px; white-space: normal; text-align: center;\\\"><span style=\\\"margin: 0px; padding: 0px; font-family: 宋体, SimSun;\\\"><br style=\\\"margin: 0px; padding: 0px;\\\"/></span></p><p style=\\\"margin-top: 0px; margin-bottom: 0px; padding: 0px; outline: none; color: rgb(102, 102, 102); font-family: &#39;Microsoft Yahei&#39;, Arial, Verdana, 宋体; font-size: 14px; line-height: 26px; white-space: normal;\\\"><span style=\\\"margin: 0px; padding: 0px; font-family: 宋体, SimSun;\\\"><br style=\\\"margin: 0px; padding: 0px;\\\"/></span></p><p style=\\\"margin-top: 0px; margin-bottom: 0px; padding: 0px; outline: none; color: rgb(102, 102, 102); font-family: &#39;Microsoft Yahei&#39;, Arial, Verdana, 宋体; font-size: 14px; line-height: 26px; white-space: normal;\\\"><span style=\\\"margin: 0px; padding: 0px; font-family: 宋体, SimSun;\\\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;</span></p><p style=\\\"margin-top: 0px; margin-bottom: 0px; padding: 0px; outline: none; color: rgb(102, 102, 102); font-family: &#39;Microsoft Yahei&#39;, Arial, Verdana, 宋体; font-size: 14px; line-height: 26px; white-space: normal;\\\"><span style=\\\"margin: 0px; padding: 0px; font-family: 宋体, SimSun;\\\"><strong style=\\\"margin: 0px; padding: 0px; text-align: center;\\\"><span style=\\\"margin: 0px; padding: 0px; font-size: 24px;\\\"><br/></span></strong></span></p><p style=\\\"margin-top: 0px; margin-bottom: 0px; padding: 0px; outline: none; color: rgb(102, 102, 102); font-family: &#39;Microsoft Yahei&#39;, Arial, Verdana, 宋体; font-size: 14px; line-height: 26px; white-space: normal;\\\"><span style=\\\"margin: 0px; padding: 0px; font-family: 宋体, SimSun;\\\"><strong style=\\\"margin: 0px; padding: 0px; text-align: center;\\\"><span style=\\\"margin: 0px; padding: 0px; font-size: 24px;\\\"><br/></span></strong></span></p><p style=\\\"margin-top: 0px; margin-bottom: 0px; padding: 0px; outline: none; color: rgb(102, 102, 102); font-family: &#39;Microsoft Yahei&#39;, Arial, Verdana, 宋体; font-size: 14px; line-height: 26px; white-space: normal;\\\"><span style=\\\"margin: 0px; padding: 0px; font-family: 宋体, SimSun;\\\"><strong style=\\\"margin: 0px; padding: 0px; text-align: center;\\\"><span style=\\\"margin: 0px; padding: 0px; font-size: 24px;\\\"><br/></span></strong></span></p><p style=\\\"margin-top: 0px; margin-bottom: 0px; padding: 0px; outline: none; color: rgb(102, 102, 102); font-family: &#39;Microsoft Yahei&#39;, Arial, Verdana, 宋体; font-size: 14px; line-height: 26px; white-space: normal;\\\"><span style=\\\"margin: 0px; padding: 0px; font-family: 宋体, SimSun;\\\"><strong style=\\\"margin: 0px; padding: 0px; text-align: center;\\\"><span style=\\\"margin: 0px; padding: 0px; font-size: 24px;\\\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;宣传造势</span></strong></span></p><p style=\\\"margin-top: 0px; margin-bottom: 0px; padding: 0px; outline: none; color: rgb(102, 102, 102); font-family: &#39;Microsoft Yahei&#39;, Arial, Verdana, 宋体; font-size: 14px; line-height: 26px; white-space: normal;\\\"><span style=\\\"margin: 0px; padding: 0px; font-family: 宋体, SimSun;\\\"><strong style=\\\"margin: 0px; padding: 0px;\\\"><span style=\\\"margin: 0px; padding: 0px; font-size: 24px;\\\"><br style=\\\"margin: 0px; padding: 0px;\\\"/></span></strong></span></p><p style=\\\"margin-top: 0px; margin-bottom: 0px; padding: 0px; outline: none; color: rgb(102, 102, 102); font-family: &#39;Microsoft Yahei&#39;, Arial, Verdana, 宋体; font-size: 14px; line-height: 26px; white-space: normal;\\\"><span style=\\\"margin: 0px; padding: 0px; font-size: 18px; font-family: 宋体, SimSun;\\\"><strong style=\\\"margin: 0px; padding: 0px;\\\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;网络推广</strong></span></p><p style=\\\"margin-top: 0px; margin-bottom: 0px; padding: 0px; outline: none; color: rgb(102, 102, 102); font-family: &#39;Microsoft Yahei&#39;, Arial, Verdana, 宋体; font-size: 14px; line-height: 26px; white-space: normal;\\\"><span style=\\\"margin: 0px; padding: 0px; font-size: 16px; font-family: 宋体, SimSun;\\\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 低成本、高回报、打通网上各个平台，先声夺人。</span></p><p style=\\\"margin-top: 0px; margin-bottom: 0px; padding: 0px; outline: none; color: rgb(102, 102, 102); font-family: &#39;Microsoft Yahei&#39;, Arial, Verdana, 宋体; font-size: 14px; line-height: 26px; white-space: normal;\\\"><span style=\\\"margin: 0px; padding: 0px; font-size: 16px; font-family: 宋体, SimSun;\\\"><br style=\\\"margin: 0px; padding: 0px;\\\"/></span></p><p style=\\\"margin-top: 0px; margin-bottom: 0px; padding: 0px; outline: none; color: rgb(102, 102, 102); font-family: &#39;Microsoft Yahei&#39;, Arial, Verdana, 宋体; font-size: 14px; line-height: 26px; white-space: normal;\\\"><span style=\\\"margin: 0px; padding: 0px; font-size: 18px; font-family: 宋体, SimSun;\\\"><strong style=\\\"margin: 0px; padding: 0px;\\\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;电视广告投放</strong></span></p><p style=\\\"margin-top: 0px; margin-bottom: 0px; padding: 0px; outline: none; color: rgb(102, 102, 102); font-family: &#39;Microsoft Yahei&#39;, Arial, Verdana, 宋体; font-size: 14px; line-height: 26px; white-space: normal;\\\"><span style=\\\"margin: 0px; padding: 0px; font-size: 16px; font-family: 宋体, SimSun;\\\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 定期电视广告投放推广，覆盖人群广，突出项目优势进行有影响力的社会宣传。</span></p><p style=\\\"margin-top: 0px; margin-bottom: 0px; padding: 0px; outline: none; color: rgb(102, 102, 102); font-family: &#39;Microsoft Yahei&#39;, Arial, Verdana, 宋体; font-size: 14px; line-height: 26px; white-space: normal;\\\"><span style=\\\"margin: 0px; padding: 0px; font-size: 16px; font-family: 宋体, SimSun;\\\"><br style=\\\"margin: 0px; padding: 0px;\\\"/></span></p><p style=\\\"margin-top: 0px; margin-bottom: 0px; padding: 0px; outline: none; color: rgb(102, 102, 102); font-family: &#39;Microsoft Yahei&#39;, Arial, Verdana, 宋体; font-size: 14px; line-height: 26px; white-space: normal;\\\"><span style=\\\"margin: 0px; padding: 0px; font-size: 18px; font-family: 宋体, SimSun;\\\"><strong style=\\\"margin: 0px; padding: 0px;\\\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;事件炒作营销</strong></span></p><p style=\\\"margin-top: 0px; margin-bottom: 0px; padding: 0px; outline: none; color: rgb(102, 102, 102); font-family: &#39;Microsoft Yahei&#39;, Arial, Verdana, 宋体; font-size: 14px; line-height: 26px; white-space: normal;\\\"><span style=\\\"margin: 0px; padding: 0px; font-size: 16px; font-family: 宋体, SimSun;\\\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 大量精心的市场炒作、专业的行销事件策划，保证项目长期处于高热度。</span></p><p style=\\\"margin-top: 0px; margin-bottom: 0px; padding: 0px; outline: none; color: rgb(102, 102, 102); font-family: &#39;Microsoft Yahei&#39;, Arial, Verdana, 宋体; font-size: 14px; line-height: 26px; white-space: normal;\\\"><span style=\\\"margin: 0px; padding: 0px; font-size: 16px; font-family: 宋体, SimSun;\\\"><br style=\\\"margin: 0px; padding: 0px;\\\"/></span></p><p style=\\\"margin-top: 0px; margin-bottom: 0px; padding: 0px; outline: none; color: rgb(102, 102, 102); font-family: &#39;Microsoft Yahei&#39;, Arial, Verdana, 宋体; font-size: 14px; line-height: 26px; white-space: normal;\\\"><span style=\\\"margin: 0px; padding: 0px; font-size: 18px; font-family: 宋体, SimSun;\\\"><strong style=\\\"margin: 0px; padding: 0px;\\\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;丰富的地面推广</strong></span></p><p style=\\\"margin-top: 0px; margin-bottom: 0px; padding: 0px; outline: none; color: rgb(102, 102, 102); font-family: &#39;Microsoft Yahei&#39;, Arial, Verdana, 宋体; font-size: 14px; line-height: 26px; white-space: normal;\\\"><span style=\\\"margin: 0px; padding: 0px; font-size: 16px; font-family: 宋体, SimSun;\\\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 定期地面活动策划，深入受众，无死角的宣传理念。</span></p><p style=\\\"margin-top: 0px; margin-bottom: 0px; padding: 0px; outline: none; color: rgb(102, 102, 102); font-family: &#39;Microsoft Yahei&#39;, Arial, Verdana, 宋体; font-size: 14px; line-height: 26px; white-space: normal;\\\"><br style=\\\"margin: 0px; padding: 0px;\\\"/></p><p style=\\\"margin-top: 0px; margin-bottom: 0px; padding: 0px; outline: none; color: rgb(102, 102, 102); font-family: &#39;Microsoft Yahei&#39;, Arial, Verdana, 宋体; font-size: 14px; line-height: 26px; white-space: normal;\\\"><span style=\\\"margin: 0px; padding: 0px; font-size: 18px; font-family: 宋体, SimSun;\\\"><strong style=\\\"margin: 0px; padding: 0px;\\\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;自制精美杂志宣传</strong></span></p><p style=\\\"margin-top: 0px; margin-bottom: 0px; padding: 0px; outline: none; color: rgb(102, 102, 102); font-family: &#39;Microsoft Yahei&#39;, Arial, Verdana, 宋体; font-size: 14px; line-height: 26px; white-space: normal;\\\"><span style=\\\"margin: 0px; padding: 0px; font-size: 16px; font-family: 宋体, SimSun;\\\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 威尔豪斯定期制作精美的杂志，加入威尔豪斯即送宣传页面，真正的宣传是一种品牌的输出。</span></p><p style=\\\"margin-top: 0px; margin-bottom: 0px; padding: 0px; outline: none; color: rgb(102, 102, 102); font-family: &#39;Microsoft Yahei&#39;, Arial, Verdana, 宋体; font-size: 14px; line-height: 26px; white-space: normal;\\\"><span style=\\\"margin: 0px; padding: 0px; font-size: 16px; font-family: 宋体, SimSun;\\\"><br style=\\\"margin: 0px; padding: 0px;\\\"/></span></p><p style=\\\"margin-top: 0px; margin-bottom: 0px; padding: 0px; outline: none; color: rgb(102, 102, 102); font-family: &#39;Microsoft Yahei&#39;, Arial, Verdana, 宋体; font-size: 14px; line-height: 26px; white-space: normal;\\\"><span style=\\\"margin: 0px; padding: 0px; font-size: 18px; font-family: 宋体, SimSun;\\\"><strong style=\\\"margin: 0px; padding: 0px;\\\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;丰富的项目自由广告位宣传</strong></span></p><p style=\\\"margin-top: 0px; margin-bottom: 0px; padding: 0px; outline: none; color: rgb(102, 102, 102); font-family: &#39;Microsoft Yahei&#39;, Arial, Verdana, 宋体; font-size: 14px; line-height: 26px; white-space: normal;\\\"><span style=\\\"margin: 0px; padding: 0px; font-size: 16px; font-family: 宋体, SimSun;\\\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 威尔豪斯内有丰富醒目的广告位，充分的突出您的店铺信息，让销量飞。</span></p><p style=\\\"margin-top: 0px; margin-bottom: 0px; padding: 0px; outline: none; color: rgb(102, 102, 102); font-family: &#39;Microsoft Yahei&#39;, Arial, Verdana, 宋体; font-size: 14px; line-height: 26px; white-space: normal;\\\"><span style=\\\"margin: 0px; padding: 0px; font-size: 16px; font-family: 宋体, SimSun;\\\"><br/></span></p><p style=\\\"margin-top: 0px; margin-bottom: 0px; padding: 0px; outline: none; color: rgb(102, 102, 102); font-family: &#39;Microsoft Yahei&#39;, Arial, Verdana, 宋体; font-size: 14px; line-height: 26px; white-space: normal;\\\"><br/></p><p style=\\\"margin-top: 0px; margin-bottom: 0px; padding: 0px; outline: none; color: rgb(102, 102, 102); font-family: &#39;Microsoft Yahei&#39;, Arial, Verdana, 宋体; font-size: 14px; line-height: 26px; white-space: normal; text-align: center;\\\"><span style=\\\"margin: 0px; padding: 0px; font-family: 宋体, SimSun;\\\"><strong style=\\\"margin: 0px; padding: 0px;\\\"><span style=\\\"margin: 0px; padding: 0px; font-size: 24px;\\\">我们的服务</span></strong></span></p><p style=\\\"margin-top: 0px; margin-bottom: 0px; padding: 0px; outline: none; color: rgb(102, 102, 102); font-family: &#39;Microsoft Yahei&#39;, Arial, Verdana, 宋体; font-size: 14px; line-height: 26px; white-space: normal;\\\"><span style=\\\"margin: 0px; padding: 0px; font-size: 20px; font-family: 宋体, SimSun;\\\"><strong style=\\\"margin: 0px; padding: 0px;\\\"><br style=\\\"margin: 0px; padding: 0px;\\\"/></strong></span></p><p style=\\\"margin-top: 0px; margin-bottom: 0px; padding: 0px; outline: none; color: rgb(102, 102, 102); font-family: &#39;Microsoft Yahei&#39;, Arial, Verdana, 宋体; font-size: 14px; line-height: 26px; white-space: normal;\\\"><span style=\\\"margin: 0px; padding: 0px; font-size: 20px; font-family: 宋体, SimSun;\\\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;<span style=\\\"margin: 0px; padding: 0px; font-size: 18px;\\\">&nbsp;采取统一规划，统一推广、统一管理和统一形象</span></span></p><p style=\\\"margin-top: 0px; margin-bottom: 0px; padding: 0px; outline: none; color: rgb(102, 102, 102); font-family: &#39;Microsoft Yahei&#39;, Arial, Verdana, 宋体; font-size: 14px; line-height: 26px; white-space: normal;\\\"><span style=\\\"margin: 0px; padding: 0px; font-size: 18px; font-family: 宋体, SimSun;\\\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 统一规划：商业业态，商业规模，商业形象。</span></p><p style=\\\"margin-top: 0px; margin-bottom: 0px; padding: 0px; outline: none; color: rgb(102, 102, 102); font-family: &#39;Microsoft Yahei&#39;, Arial, Verdana, 宋体; font-size: 14px; line-height: 26px; white-space: normal;\\\"><span style=\\\"margin: 0px; padding: 0px; font-size: 18px; font-family: 宋体, SimSun;\\\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 统一推广：统一推广主题、形象、合理配置内外广告位、新品推广。</span></p><p style=\\\"margin-top: 0px; margin-bottom: 0px; padding: 0px; outline: none; color: rgb(102, 102, 102); font-family: &#39;Microsoft Yahei&#39;, Arial, Verdana, 宋体; font-size: 14px; line-height: 26px; white-space: normal;\\\"><span style=\\\"margin: 0px; padding: 0px; font-size: 18px; font-family: 宋体, SimSun;\\\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 统一管理：水电管理、消防管理、安保管理、车辆管理。</span></p><p style=\\\"margin-top: 0px; margin-bottom: 0px; padding: 0px; outline: none; color: rgb(102, 102, 102); font-family: &#39;Microsoft Yahei&#39;, Arial, Verdana, 宋体; font-size: 14px; line-height: 26px; white-space: normal;\\\"><span style=\\\"margin: 0px; padding: 0px; font-size: 18px; font-family: 宋体, SimSun;\\\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 统一形象：不断优化商场档次、保证经营统一性、统一促销管理、统一人员管理。</span></p><p style=\\\"margin-top: 0px; margin-bottom: 0px; padding: 0px; outline: none; color: rgb(102, 102, 102); font-family: &#39;Microsoft Yahei&#39;, Arial, Verdana, 宋体; font-size: 14px; line-height: 26px; white-space: normal;\\\"><span style=\\\"margin: 0px; padding: 0px; font-size: 16px; font-family: 宋体, SimSun;\\\"><br/></span></p><p style=\\\"margin-top: 0px; margin-bottom: 0px; padding: 0px; outline: none; color: rgb(102, 102, 102); font-family: &#39;Microsoft Yahei&#39;, Arial, Verdana, 宋体; font-size: 14px; line-height: 26px; white-space: normal; text-align: left;\\\"><span style=\\\"margin: 0px; padding: 0px; font-family: 宋体, SimSun;\\\"><strong style=\\\"margin: 0px; padding: 0px; font-size: 20px;\\\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;</strong><strong style=\\\"margin: 0px; padding: 0px; font-size: 20px;\\\">建材商入驻</strong><br style=\\\"margin: 0px; padding: 0px;\\\"/></span></p><p style=\\\"margin-top: 0px; margin-bottom: 0px; padding: 0px; outline: none; color: rgb(102, 102, 102); font-family: &#39;Microsoft Yahei&#39;, Arial, Verdana, 宋体; font-size: 14px; line-height: 26px; white-space: normal; text-align: left;\\\"><span style=\\\"margin: 0px; padding: 0px; font-family: 宋体, SimSun;\\\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;在威尔豪斯，你可以找到各类装修建材。</span></p><p style=\\\"margin-top: 0px; margin-bottom: 0px; padding: 0px; outline: none; color: rgb(102, 102, 102); font-family: &#39;Microsoft Yahei&#39;, Arial, Verdana, 宋体; font-size: 14px; line-height: 26px; white-space: normal; text-align: left;\\\"><span style=\\\"margin: 0px; padding: 0px; font-size: 20px; font-family: 宋体, SimSun;\\\"><strong style=\\\"margin: 0px; padding: 0px;\\\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 家具厂入驻</strong></span></p><p style=\\\"margin-top: 0px; margin-bottom: 0px; padding: 0px; outline: none; color: rgb(102, 102, 102); font-family: &#39;Microsoft Yahei&#39;, Arial, Verdana, 宋体; font-size: 14px; line-height: 26px; white-space: normal; text-align: left;\\\"><span style=\\\"margin: 0px; padding: 0px; font-family: 宋体, SimSun;\\\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;在威尔豪斯，你可以挑选到各类厂家直销的家居。</span></p><p style=\\\"margin-top: 0px; margin-bottom: 0px; padding: 0px; outline: none; color: rgb(102, 102, 102); font-family: &#39;Microsoft Yahei&#39;, Arial, Verdana, 宋体; font-size: 14px; line-height: 26px; white-space: normal; text-align: left;\\\"><span style=\\\"margin: 0px; padding: 0px; font-family: 宋体, SimSun;\\\"><strong style=\\\"margin: 0px; padding: 0px; font-size: 20px;\\\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 样板间入驻</strong><strong style=\\\"margin: 0px; padding: 0px; font-size: 20px;\\\"></strong></span></p><p style=\\\"margin-top: 0px; margin-bottom: 0px; padding: 0px; outline: none; color: rgb(102, 102, 102); font-family: &#39;Microsoft Yahei&#39;, Arial, Verdana, 宋体; font-size: 14px; line-height: 26px; white-space: normal; text-align: left;\\\"><span style=\\\"margin: 0px; padding: 0px; font-family: 宋体, SimSun;\\\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;在威尔豪斯，您可以感受装修完成的成品样板间，并可整体或分件购买。</span></p><p style=\\\"margin-top: 0px; margin-bottom: 0px; padding: 0px; outline: none; color: rgb(102, 102, 102); font-family: &#39;Microsoft Yahei&#39;, Arial, Verdana, 宋体; font-size: 14px; line-height: 26px; white-space: normal; text-align: left;\\\"><span style=\\\"margin: 0px; padding: 0px; font-family: 宋体, SimSun;\\\"><strong style=\\\"margin: 0px; padding: 0px; font-size: 20px;\\\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 设计师入驻</strong><strong style=\\\"margin: 0px; padding: 0px; font-size: 20px;\\\"></strong></span></p><p style=\\\"margin-top: 0px; margin-bottom: 0px; padding: 0px; outline: none; color: rgb(102, 102, 102); font-family: &#39;Microsoft Yahei&#39;, Arial, Verdana, 宋体; font-size: 14px; line-height: 26px; white-space: normal; text-align: left;\\\"><span style=\\\"margin: 0px; padding: 0px; font-family: 宋体, SimSun;\\\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;在威尔豪斯，您可以根据您喜爱的样板间找到设计师，对您的新家定制设计。</span></p><p style=\\\"margin-top: 0px; margin-bottom: 0px; padding: 0px; outline: none; color: rgb(102, 102, 102); font-family: &#39;Microsoft Yahei&#39;, Arial, Verdana, 宋体; font-size: 14px; line-height: 26px; white-space: normal; text-align: left;\\\"><span style=\\\"margin: 0px; padding: 0px; font-family: 宋体, SimSun;\\\"><strong style=\\\"margin: 0px; padding: 0px; font-size: 20px;\\\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 装修队入驻</strong><strong style=\\\"margin: 0px; padding: 0px; font-size: 20px;\\\"></strong></span></p><p style=\\\"margin-top: 0px; margin-bottom: 0px; padding: 0px; outline: none; color: rgb(102, 102, 102); font-family: &#39;Microsoft Yahei&#39;, Arial, Verdana, 宋体; font-size: 14px; line-height: 26px; white-space: normal; text-align: left;\\\"><span style=\\\"margin: 0px; padding: 0px; font-family: 宋体, SimSun;\\\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;在威尔豪斯，您可以根据您喜爱的样板间找到施工队，对您的新家定制施工。</span></p><p><br/></p>', '白', '39', '0', '2016-06-21 17:10:54', '1');
INSERT INTO `article` VALUES ('93', '威尔豪斯简介', '<p>&nbsp; &nbsp;	&nbsp; &nbsp; &nbsp;</p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160704/1467613505133635logointr@2x.png\\\" title=\\\"1467613505133635logointr@2x.png\\\" alt=\\\"logointr@2x.png\\\" width=\\\"345\\\" height=\\\"78\\\" style=\\\"width: 345px; height: 78px;\\\"/></p><p><br/></p><p>贵阳威尔豪斯家局体验中心系省物质集团下属全资子公司省物质储运总公司携手贵州纳斯科技有限公司公司全力打造的现代家局体验配送中心，建筑面积约39000平方米，位于贵阳市南明区富源南路1号。</p><p><br/></p><p>中心拥有陶瓷建材销售、实装实体体验馆和一站式采购区。现有19000平方米的瓷砖、洁具、木地板、墙纸自主经营区；10000平方米的家装基础材料销售区；10000平方米以中国、欧美、现代和设计为主体的家居实体体验馆以待入驻。</p><p><br/></p><p>中心主要引进先进的电子信息技术和成熟的互联网营销推广平台，建立线上线下两种营销模式，将传统装修建材产业进行重组和升级。线上开发互联网电商平台、网上商城、360度网上漫游综合体、VR视觉交互系统、APP移动端口平台、物流管理系统；线下打造产品卖场直销店和家居装修主体体验馆、家装业者服务及孵化中心。</p><p><br/></p><p>中心提供涵盖设计、建材、装修、家具、家电、配送等一站式服务，旨在让装修更为简单便捷。将设计、装修、厂商等现有资源进行整合，形成“互联网+供应链金融+大数据+智慧家居+电商平台”的互联网+综合体，打造集实体展示、集采、集供与体验为一体的新型家居体验配送中心，志在将整个威尔豪斯家居体验中心打造成为全省范围内首家互联网家居产业综合体。</p><p><br/></p>', '', '31', '0', '2016-07-04 13:54:24', '1');

-- ----------------------------
-- Table structure for articlecatalog
-- ----------------------------
DROP TABLE IF EXISTS `articlecatalog`;
CREATE TABLE `articlecatalog` (
  `ID` smallint(6) NOT NULL AUTO_INCREMENT COMMENT '标识码',
  `Name` varchar(50) NOT NULL COMMENT '分类名称',
  `ParentID` smallint(6) DEFAULT NULL COMMENT '父类ID',
  PRIMARY KEY (`ID`),
  KEY `ParentID` (`ParentID`)
) ENGINE=MyISAM AUTO_INCREMENT=42 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of articlecatalog
-- ----------------------------
INSERT INTO `articlecatalog` VALUES ('9', '装修大学', '0');
INSERT INTO `articlecatalog` VALUES ('10', '新闻中心', '0');
INSERT INTO `articlecatalog` VALUES ('11', '新手帮助', '0');
INSERT INTO `articlecatalog` VALUES ('12', '装修流程', '0');
INSERT INTO `articlecatalog` VALUES ('13', '基础工程', '12');
INSERT INTO `articlecatalog` VALUES ('14', '水电工程', '12');
INSERT INTO `articlecatalog` VALUES ('15', '泥工工程', '12');
INSERT INTO `articlecatalog` VALUES ('16', '木工工程', '12');
INSERT INTO `articlecatalog` VALUES ('17', '漆工工程', '12');
INSERT INTO `articlecatalog` VALUES ('18', '安装工程', '12');
INSERT INTO `articlecatalog` VALUES ('19', '收尾工程', '12');
INSERT INTO `articlecatalog` VALUES ('38', '商城公告', '0');
INSERT INTO `articlecatalog` VALUES ('21', '家装建材', '9');
INSERT INTO `articlecatalog` VALUES ('28', '软装选购', '9');
INSERT INTO `articlecatalog` VALUES ('31', '企业简介', '40');
INSERT INTO `articlecatalog` VALUES ('25', '家装风水', '9');
INSERT INTO `articlecatalog` VALUES ('32', '企业文化', '40');
INSERT INTO `articlecatalog` VALUES ('27', '家装风格', '9');
INSERT INTO `articlecatalog` VALUES ('33', '员工风采', '40');
INSERT INTO `articlecatalog` VALUES ('41', '招商入驻', '0');
INSERT INTO `articlecatalog` VALUES ('39', '招商入驻', '41');
INSERT INTO `articlecatalog` VALUES ('40', '关于威尔豪斯', '0');

-- ----------------------------
-- Table structure for authentication
-- ----------------------------
DROP TABLE IF EXISTS `authentication`;
CREATE TABLE `authentication` (
  `ID` mediumint(9) NOT NULL AUTO_INCREMENT COMMENT '标识码',
  `UserID` mediumint(9) NOT NULL COMMENT '用户ID',
  `UserType` tinyint(4) NOT NULL COMMENT '用户身份',
  `AuthedItem` varchar(10) DEFAULT NULL COMMENT '认证项目',
  `AuthTime` datetime DEFAULT NULL COMMENT '认证时间',
  PRIMARY KEY (`ID`),
  KEY `UserID` (`UserID`),
  KEY `UserType` (`UserType`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of authentication
-- ----------------------------

-- ----------------------------
-- Table structure for balance
-- ----------------------------
DROP TABLE IF EXISTS `balance`;
CREATE TABLE `balance` (
  `ID` mediumint(9) NOT NULL AUTO_INCREMENT COMMENT '标识码',
  `PBID` mediumint(9) NOT NULL COMMENT '项目订单号',
  `Bill` decimal(10,2) NOT NULL COMMENT '结算金额',
  `CreateTime` datetime NOT NULL COMMENT '结算时间',
  `BalanceUID` mediumint(9) NOT NULL COMMENT '结算用户ID',
  PRIMARY KEY (`ID`),
  KEY `PBID` (`PBID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of balance
-- ----------------------------

-- ----------------------------
-- Table structure for bankaccount
-- ----------------------------
DROP TABLE IF EXISTS `bankaccount`;
CREATE TABLE `bankaccount` (
  `ID` mediumint(9) NOT NULL AUTO_INCREMENT COMMENT '标识码',
  `UserID` mediumint(9) NOT NULL COMMENT '用户ID',
  `OpenName` varchar(24) NOT NULL COMMENT '开户人姓名',
  `Account` varchar(30) NOT NULL COMMENT '银行帐号',
  `Bank` varchar(45) NOT NULL COMMENT '开户银行',
  `OpenPlace` mediumint(9) NOT NULL COMMENT '开户地',
  `AddTime` datetime NOT NULL COMMENT '添加时间',
  PRIMARY KEY (`ID`),
  UNIQUE KEY `UserID` (`UserID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of bankaccount
-- ----------------------------

-- ----------------------------
-- Table structure for bigtosmallgoods
-- ----------------------------
DROP TABLE IF EXISTS `bigtosmallgoods`;
CREATE TABLE `bigtosmallgoods` (
  `ID` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `SmallGoodsID` mediumint(9) NOT NULL,
  `BigGoodsID` mediumint(9) NOT NULL,
  `TransCount` mediumint(6) unsigned NOT NULL,
  `ShopID` mediumint(9) DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `SmallGoodsID` (`SmallGoodsID`),
  KEY `BigGoodsID` (`BigGoodsID`),
  KEY `ShopID` (`ShopID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of bigtosmallgoods
-- ----------------------------

-- ----------------------------
-- Table structure for bookingpay
-- ----------------------------
DROP TABLE IF EXISTS `bookingpay`;
CREATE TABLE `bookingpay` (
  `ID` mediumint(9) NOT NULL AUTO_INCREMENT COMMENT '标识码',
  `out_trade_no` varchar(30) DEFAULT NULL COMMENT '商品订单号',
  `Bill` decimal(10,2) NOT NULL COMMENT '交易金额',
  `buyer_email` varchar(100) DEFAULT NULL COMMENT '支付者的支付宝账号',
  `trade_no` varchar(64) DEFAULT NULL COMMENT '支付宝交易流水号',
  `gmt_create` datetime DEFAULT NULL COMMENT '交易创建时间',
  `gmt_payment` datetime DEFAULT NULL COMMENT '交易付款时间',
  `gmt_close` datetime DEFAULT NULL COMMENT '交易关闭时间',
  `trade_status` tinyint(4) NOT NULL COMMENT '交易状态',
  PRIMARY KEY (`ID`),
  UNIQUE KEY `out_trade_no` (`out_trade_no`),
  KEY `buyer_email` (`buyer_email`),
  KEY `gmt_payment` (`gmt_payment`),
  KEY `trade_status` (`trade_status`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of bookingpay
-- ----------------------------

-- ----------------------------
-- Table structure for camera
-- ----------------------------
DROP TABLE IF EXISTS `camera`;
CREATE TABLE `camera` (
  `ID` smallint(6) NOT NULL AUTO_INCREMENT COMMENT '标识码',
  `Name` varchar(45) NOT NULL COMMENT '摄像头名称',
  `Appkey` varchar(32) NOT NULL,
  `Secret` varchar(32) NOT NULL,
  `AddTime` datetime NOT NULL COMMENT '加入时间',
  PRIMARY KEY (`ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of camera
-- ----------------------------

-- ----------------------------
-- Table structure for carriagesetting
-- ----------------------------
DROP TABLE IF EXISTS `carriagesetting`;
CREATE TABLE `carriagesetting` (
  `ID` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `ShopID` mediumint(9) NOT NULL,
  `FirstWeight` decimal(6,2) NOT NULL,
  `FirstPrice` decimal(6,2) NOT NULL,
  `SecondWeight` decimal(6,2) NOT NULL,
  `SecondPrice` decimal(6,2) NOT NULL,
  PRIMARY KEY (`ID`),
  KEY `ShopID` (`ShopID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of carriagesetting
-- ----------------------------

-- ----------------------------
-- Table structure for casegallery
-- ----------------------------
DROP TABLE IF EXISTS `casegallery`;
CREATE TABLE `casegallery` (
  `ID` mediumint(9) NOT NULL AUTO_INCREMENT COMMENT '标识码',
  `CaseID` mediumint(9) NOT NULL COMMENT '案例ID',
  `KJType` tinyint(4) DEFAULT NULL COMMENT '效果图所属空间分类',
  `ImgUrl` varchar(100) DEFAULT NULL COMMENT '图片在服务器上的存放地址',
  `IsCover` tinyint(4) DEFAULT NULL COMMENT '是否是封面图',
  PRIMARY KEY (`ID`),
  KEY `CaseID` (`CaseID`),
  KEY `KJType` (`KJType`),
  KEY `IsCover` (`IsCover`)
) ENGINE=MyISAM AUTO_INCREMENT=151 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of casegallery
-- ----------------------------
INSERT INTO `casegallery` VALUES ('68', '36', '2', '/pic/2015/11/30/busdpqjg.png', '0');
INSERT INTO `casegallery` VALUES ('67', '35', '1', '/pic/2015/11/30/ntfs5zij.jpg', '0');
INSERT INTO `casegallery` VALUES ('65', '34', '1', '/pic/2015/11/30/khcjz43n.jpg', '1');
INSERT INTO `casegallery` VALUES ('66', '35', '1', '/pic/2015/11/30/sa3gwu26.jpg', '1');
INSERT INTO `casegallery` VALUES ('71', '36', '3', '/pic/2015/11/30/t9gcjykp.png', '0');
INSERT INTO `casegallery` VALUES ('70', '36', '1', '/pic/2015/11/30/adyhz5kf.png', '1');
INSERT INTO `casegallery` VALUES ('69', '36', '3', '/pic/2015/11/30/q8nc2bzy.png', '0');
INSERT INTO `casegallery` VALUES ('59', '29', '1', '/pic/2015/11/27/f5w76zh9.png', '1');
INSERT INTO `casegallery` VALUES ('60', '29', '1', '/pic/2015/11/27/z4cehvnf.jpg', '0');
INSERT INTO `casegallery` VALUES ('72', '36', '9', '/pic/2015/11/30/cebtm96i.png', '0');
INSERT INTO `casegallery` VALUES ('73', '37', '3', '/pic/2015/11/30/q7ikemzf.png', '0');
INSERT INTO `casegallery` VALUES ('75', '37', '3', '/pic/2015/11/30/xcqg5mka.png', '0');
INSERT INTO `casegallery` VALUES ('76', '37', '3', '/pic/2015/11/30/mrjs3iwb.png', '1');
INSERT INTO `casegallery` VALUES ('77', '38', '1', '/pic/2015/11/30/mbgeihrt.png', '1');
INSERT INTO `casegallery` VALUES ('78', '39', '1', '/pic/2015/12/01/ymg8f42q.jpg', '1');
INSERT INTO `casegallery` VALUES ('79', '39', '1', '/pic/2015/12/01/yb2n594e.jpg', '0');
INSERT INTO `casegallery` VALUES ('80', '40', '1', '/pic/2015/12/01/p53uwc2x.jpg', '1');
INSERT INTO `casegallery` VALUES ('81', '41', '1', '/pic/2015/12/01/yx4t76kv.jpg', '1');
INSERT INTO `casegallery` VALUES ('82', '42', '1', '/pic/2015/12/01/bcxnq28v.jpg', '1');
INSERT INTO `casegallery` VALUES ('90', '49', '1', '/pic/2015/12/01/c7upkzty.jpg', '1');
INSERT INTO `casegallery` VALUES ('91', '50', '1', '/pic/2015/12/01/hmk3efbp.jpg', '1');
INSERT INTO `casegallery` VALUES ('92', '51', '1', '/pic/2015/12/01/9xzg4fi6.jpg', '1');
INSERT INTO `casegallery` VALUES ('147', '71', '2', '/pic/2016/02/25/dngv4rat.jpg', '1');

-- ----------------------------
-- Table structure for complaint
-- ----------------------------
DROP TABLE IF EXISTS `complaint`;
CREATE TABLE `complaint` (
  `ID` mediumint(9) NOT NULL AUTO_INCREMENT COMMENT '标识码',
  `IsComplaint` tinyint(4) NOT NULL DEFAULT '0' COMMENT '投诉还是建议',
  `CUID` mediumint(9) NOT NULL COMMENT '投诉人ID',
  `BCUID` mediumint(9) DEFAULT NULL COMMENT '被投诉人ID',
  `ComplaintOther` varchar(20) DEFAULT NULL COMMENT '被投诉人为其他人',
  `Content` text NOT NULL COMMENT '投诉内容',
  `ComplaintTime` datetime NOT NULL COMMENT '投诉时间',
  `HUID` mediumint(9) NOT NULL COMMENT '处理人ID',
  `HandleContent` text COMMENT '处理结果',
  `HandleUpdateTime` datetime DEFAULT NULL COMMENT '处理更新时间',
  `Status` tinyint(4) NOT NULL DEFAULT '0' COMMENT '投诉状态',
  PRIMARY KEY (`ID`),
  KEY `CUID` (`CUID`),
  KEY `HUID` (`HUID`),
  KEY `Status` (`Status`),
  KEY `IsComplaint` (`IsComplaint`)
) ENGINE=MyISAM AUTO_INCREMENT=32 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of complaint
-- ----------------------------
INSERT INTO `complaint` VALUES ('31', '0', '1', null, null, 'dsfsdf', '2016-08-19 10:20:03', '0', null, null, '0');

-- ----------------------------
-- Table structure for constructionscene
-- ----------------------------
DROP TABLE IF EXISTS `constructionscene`;
CREATE TABLE `constructionscene` (
  `ID` mediumint(9) NOT NULL AUTO_INCREMENT,
  `PBID` mediumint(9) NOT NULL COMMENT '项目订单号',
  `TecType` tinyint(4) NOT NULL COMMENT '工艺分类',
  `ImgUrl` varchar(100) NOT NULL COMMENT '图片在服务器上的存放地址',
  `Description` text COMMENT '图片描述',
  `UploadTime` datetime NOT NULL COMMENT '上传时间',
  PRIMARY KEY (`ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of constructionscene
-- ----------------------------

-- ----------------------------
-- Table structure for customer
-- ----------------------------
DROP TABLE IF EXISTS `customer`;
CREATE TABLE `customer` (
  `ID` mediumint(9) NOT NULL AUTO_INCREMENT COMMENT '标识码',
  `Name` varchar(24) NOT NULL COMMENT '客户称呼',
  `Sex` tinyint(4) NOT NULL COMMENT '性别',
  `Age` tinyint(4) NOT NULL COMMENT '年龄',
  `Tel` varchar(11) NOT NULL COMMENT '联系电话',
  `ComeFrom` tinyint(4) NOT NULL COMMENT '来源渠道',
  `ContactPerson` varchar(24) NOT NULL COMMENT '公司内部该客户对接人',
  `FirstContactTime` datetime NOT NULL COMMENT '首次接触时间',
  `LastContactTime` datetime NOT NULL COMMENT '最后一次接触时间',
  `VisitorType` tinyint(4) NOT NULL COMMENT '客户来访类型',
  `HouseArea` mediumint(8) NOT NULL COMMENT '房屋所在行政区',
  `HouseEstate` varchar(30) NOT NULL COMMENT '所在小区',
  `Area` decimal(7,2) NOT NULL COMMENT '房屋套内面积',
  `ktcount` tinyint(4) DEFAULT NULL COMMENT '客厅数量',
  `wscount` tinyint(4) DEFAULT NULL COMMENT '卧室数量',
  `wsjcount` tinyint(4) DEFAULT NULL COMMENT '卫生间数量',
  `HouseType` tinyint(4) NOT NULL COMMENT '房屋类型',
  `DecorationStyle` varchar(15) DEFAULT NULL COMMENT '想要装修的风格',
  `DecorationType` tinyint(4) NOT NULL COMMENT '装修类型',
  `DecorationTime` datetime DEFAULT NULL COMMENT '期望装修时间',
  `UseType` tinyint(4) NOT NULL COMMENT '装修用途',
  `Attention` varchar(10) DEFAULT NULL COMMENT '客户较为关注',
  `Budget` int(11) DEFAULT NULL COMMENT '客户预算',
  `Desire` tinyint(4) NOT NULL COMMENT '装修意愿类型',
  `Progress` text COMMENT '进展',
  `FailReason` text COMMENT '谈单失败原因',
  `Remarks` text COMMENT '备注',
  `AddTime` datetime NOT NULL COMMENT '加入时间',
  `UpdateTime` datetime NOT NULL COMMENT '更新时间',
  PRIMARY KEY (`ID`),
  KEY `Name` (`Name`),
  KEY `Tel` (`Tel`),
  KEY `ComeFrom` (`ComeFrom`),
  KEY `ContactPerson` (`ContactPerson`),
  KEY `VisitorType` (`VisitorType`),
  KEY `Desire` (`Desire`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of customer
-- ----------------------------

-- ----------------------------
-- Table structure for customereliminate
-- ----------------------------
DROP TABLE IF EXISTS `customereliminate`;
CREATE TABLE `customereliminate` (
  `Tel` varchar(11) NOT NULL COMMENT '电话',
  PRIMARY KEY (`Tel`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of customereliminate
-- ----------------------------

-- ----------------------------
-- Table structure for datadict
-- ----------------------------
DROP TABLE IF EXISTS `datadict`;
CREATE TABLE `datadict` (
  `ID` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `Type` varchar(45) NOT NULL,
  `Name` varchar(45) NOT NULL,
  `DictValue` varchar(150) NOT NULL,
  PRIMARY KEY (`ID`),
  KEY `Type` (`Type`),
  KEY `Name` (`Name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of datadict
-- ----------------------------

-- ----------------------------
-- Table structure for designcase
-- ----------------------------
DROP TABLE IF EXISTS `designcase`;
CREATE TABLE `designcase` (
  `ID` mediumint(9) NOT NULL AUTO_INCREMENT COMMENT 'æ ‡è¯†ç ',
  `UserID` mediumint(9) DEFAULT NULL COMMENT 'æ¡ˆä¾‹æ‰€å±žè®¾è®¡å¸ˆçš„ç™»å½•ç”¨æˆ·ID',
  `Area` decimal(7,2) DEFAULT NULL COMMENT 'å¥—å†…é¢ç§¯',
  `HouseArea` tinyint(4) DEFAULT NULL COMMENT 'æˆ¿å±‹æ‰€åœ¨è¡Œæ”¿åŒº',
  `HouseEstate` varchar(30) DEFAULT NULL COMMENT 'æ‰€åœ¨å°åŒº',
  `HouseType` tinyint(4) DEFAULT NULL COMMENT 'æˆ¿å±‹ç±»åž‹',
  `Style` tinyint(4) DEFAULT NULL COMMENT 'è£…ä¿®é£Žæ ¼',
  `Price` mediumint(9) DEFAULT NULL COMMENT 'é€ ä»·',
  `DecorationType` tinyint(4) DEFAULT NULL COMMENT 'è£…ä¿®ç±»åž‹',
  `DecorationLevel` tinyint(4) DEFAULT NULL COMMENT 'è£…ä¿®æ¡£æ¬¡',
  `CaseComment` text COMMENT 'æ¡ˆä¾‹ç‚¹è¯„',
  `AddTime` datetime DEFAULT NULL COMMENT 'æ¡ˆä¾‹ä¸Šä¼ æ—¶é—´',
  `Hits` mediumint(9) DEFAULT NULL COMMENT 'æµè§ˆæ¬¡æ•°',
  PRIMARY KEY (`ID`),
  KEY `UserID` (`UserID`),
  KEY `Area` (`Area`),
  KEY `HouseEstate` (`HouseEstate`),
  KEY `HouseType` (`HouseType`),
  KEY `Style` (`Style`),
  KEY `Price` (`Price`),
  KEY `DecorationType` (`DecorationType`),
  KEY `DecorationLevel` (`DecorationLevel`)
) ENGINE=MyISAM AUTO_INCREMENT=109 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of designcase
-- ----------------------------
INSERT INTO `designcase` VALUES ('87', '1', '555.00', '2', '1', '1', '1', '1', '3', '2', '1', '2016-07-27 18:19:19', '0');
INSERT INTO `designcase` VALUES ('36', '84', '78.00', '2', '18', '1', '1', '130000', '1', '1', '', '2015-11-30 16:17:54', '0');
INSERT INTO `designcase` VALUES ('37', '84', '103.80', '3', '88', '1', '1', '167000', '1', '1', '', '2015-11-30 16:20:37', '0');
INSERT INTO `designcase` VALUES ('38', '84', '110.30', '3', '42', '1', '4', '170000', '1', '2', '', '2015-11-30 16:28:30', '0');
INSERT INTO `designcase` VALUES ('35', '96', '106.00', '2', '9', '1', '1', '83000', '1', '1', '', '2015-11-30 16:08:11', '0');
INSERT INTO `designcase` VALUES ('34', '96', '95.50', '1', '9', '1', '1', '91000', '1', '1', '', '2015-11-30 16:04:54', '0');
INSERT INTO `designcase` VALUES ('39', '85', '126.00', '4', '161', '1', '1', '110000', '1', '2', '', '2015-12-01 13:18:06', '0');
INSERT INTO `designcase` VALUES ('40', '85', '99.60', '2', '3', '1', '1', '98000', '1', '2', '', '2015-12-01 13:19:15', '0');
INSERT INTO `designcase` VALUES ('41', '85', '105.50', '1', '29', '1', '1', '68000', '2', '2', '', '2015-12-01 13:20:34', '0');
INSERT INTO `designcase` VALUES ('42', '1', '130.30', '1', '1', '1', '1', '235600', '3', '3', '1', '2015-12-01 13:22:33', '0');
INSERT INTO `designcase` VALUES ('49', '91', '86.00', '1', '1', '1', '1', '110000', '1', '2', '', '2015-12-01 15:09:57', '0');
INSERT INTO `designcase` VALUES ('50', '91', '100.50', '1', '32', '1', '1', '100000', '1', '2', '', '2015-12-01 15:11:06', '0');
INSERT INTO `designcase` VALUES ('51', '131', '107.30', '1', '118', '1', '1', '93600', '1', '2', '', '2015-12-01 15:41:56', '0');
INSERT INTO `designcase` VALUES ('81', '1', '555.00', '2', '1', '1', '1', '1', '1', '2', '1', '2016-07-27 18:19:16', '0');
INSERT INTO `designcase` VALUES ('84', '1', '555.00', '2', '1', '1', '1', '1', '1', '3', '1', '2016-07-27 18:19:18', '0');
INSERT INTO `designcase` VALUES ('88', '1', '555.00', '2', '1', '1', '1', '1', '1', '1', '1', '2016-07-27 18:19:20', '0');
INSERT INTO `designcase` VALUES ('90', '1', '555.00', '2', '1', '1', '1', '1', '3', '3', '1', '2016-07-27 18:19:20', '0');
INSERT INTO `designcase` VALUES ('91', '1', '555.00', '3', '1', '1', '1', '1', '1', '2', '1', '2016-07-27 18:19:21', '0');
INSERT INTO `designcase` VALUES ('93', '1', '555.00', '3', '1', '1', '1', '1', '1', '3', '1', '2016-07-27 18:19:22', '0');
INSERT INTO `designcase` VALUES ('97', '1', '555.00', '3', '1', '1', '1', '1', '3', '1', '1', '2016-07-27 18:19:23', '0');
INSERT INTO `designcase` VALUES ('98', '1', '555.00', '3', '1', '1', '1', '1', '3', '3', '1', '2016-07-27 18:19:23', '0');
INSERT INTO `designcase` VALUES ('99', '1', '555.00', '1', '2', '1', '1', '1', '1', '1', '1', '2016-07-27 18:19:24', '0');
INSERT INTO `designcase` VALUES ('100', '1', '555.00', '1', '2', '1', '1', '1', '1', '2', '1', '2016-07-27 18:19:24', '0');
INSERT INTO `designcase` VALUES ('101', '1', '555.00', '1', '2', '1', '1', '1', '1', '3', '1', '2016-07-27 18:19:25', '0');
INSERT INTO `designcase` VALUES ('102', '1', '555.00', '1', '2', '1', '1', '1', '2', '1', '1', '2016-07-27 18:19:25', '0');
INSERT INTO `designcase` VALUES ('103', '1', '555.00', '1', '2', '1', '1', '1', '2', '3', '1', '2016-07-27 18:19:25', '0');
INSERT INTO `designcase` VALUES ('104', '1', '555.00', '1', '2', '1', '1', '1', '3', '1', '1', '2016-07-27 18:19:26', '0');
INSERT INTO `designcase` VALUES ('106', '1', '555.00', '1', '2', '1', '1', '1', '3', '3', '1', '2016-07-27 18:19:27', '0');
INSERT INTO `designcase` VALUES ('107', '1', '555.00', '1', '2', '1', '1', '1', '2', '2', '1', '2016-07-27 18:19:29', '0');

-- ----------------------------
-- Table structure for designer
-- ----------------------------
DROP TABLE IF EXISTS `designer`;
CREATE TABLE `designer` (
  `ID` mediumint(9) NOT NULL AUTO_INCREMENT COMMENT '标识码',
  `UserID` mediumint(9) NOT NULL COMMENT '登录用户ID',
  `Origin` mediumint(9) DEFAULT NULL COMMENT '籍贯',
  `Graduate` varchar(100) DEFAULT NULL COMMENT '毕业院校',
  `WorkingYear` smallint(6) DEFAULT NULL COMMENT '从业开始时间',
  `GoodStyle` varchar(15) DEFAULT NULL COMMENT '擅长装修风格',
  `DesignWork` text COMMENT '代表作品',
  `Price` smallint(6) DEFAULT NULL COMMENT '收费',
  `Intro` text COMMENT '个人简介',
  `DesignIdea` varchar(200) DEFAULT NULL COMMENT '施工理念',
  `HonoraryTitle` varchar(200) DEFAULT NULL COMMENT '所获荣誉',
  `IsShow` tinyint(4) NOT NULL DEFAULT '1' COMMENT '前台是否可见',
  `Hits` mediumint(9) NOT NULL DEFAULT '0' COMMENT '浏览次数',
  PRIMARY KEY (`ID`),
  UNIQUE KEY `UserID` (`UserID`),
  KEY `WorkingYear` (`WorkingYear`),
  KEY `GoodStyle` (`GoodStyle`),
  KEY `Price` (`Price`),
  KEY `IsShow` (`IsShow`),
  KEY `Hits` (`Hits`)
) ENGINE=InnoDB AUTO_INCREMENT=76 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of designer
-- ----------------------------
INSERT INTO `designer` VALUES ('75', '589', '520103', '星浩设计师培训学校', '2014', '1', '只出平面图', '1', '现在在一家单位上班，每天时间都很充裕，所找个兼职做', '', '', '1', '0');

-- ----------------------------
-- Table structure for evaluation
-- ----------------------------
DROP TABLE IF EXISTS `evaluation`;
CREATE TABLE `evaluation` (
  `ID` mediumint(9) NOT NULL AUTO_INCREMENT COMMENT '标识码',
  `PBID` mediumint(9) NOT NULL COMMENT '项目订单表ID',
  `Comment` text COMMENT '评价内容',
  `EvaTime` datetime DEFAULT NULL COMMENT '评价时间',
  PRIMARY KEY (`ID`),
  KEY `PBID` (`PBID`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of evaluation
-- ----------------------------

-- ----------------------------
-- Table structure for evascore
-- ----------------------------
DROP TABLE IF EXISTS `evascore`;
CREATE TABLE `evascore` (
  `ID` mediumint(9) NOT NULL AUTO_INCREMENT COMMENT '???',
  `EvaID` mediumint(9) DEFAULT NULL COMMENT '??ID',
  `ScoreItem` tinyint(4) DEFAULT NULL COMMENT '???',
  `Score` tinyint(4) DEFAULT NULL COMMENT '??',
  PRIMARY KEY (`ID`),
  KEY `EvaID` (`EvaID`),
  KEY `ScoreItem` (`ScoreItem`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of evascore
-- ----------------------------

-- ----------------------------
-- Table structure for goods
-- ----------------------------
DROP TABLE IF EXISTS `goods`;
CREATE TABLE `goods` (
  `ID` mediumint(9) NOT NULL AUTO_INCREMENT COMMENT '标识码',
  `ShopID` mediumint(9) NOT NULL,
  `Name` varchar(150) NOT NULL COMMENT '产品名称',
  `Model` varchar(50) DEFAULT NULL COMMENT '型号',
  `Brand` varchar(30) NOT NULL COMMENT '品牌',
  `Manufactor` varchar(60) NOT NULL COMMENT '生产厂家',
  `Material` varchar(45) DEFAULT NULL COMMENT '材质',
  `Color` varchar(60) DEFAULT NULL COMMENT '颜色',
  `Description` text,
  `Unit` tinyint(4) NOT NULL COMMENT '计量单位',
  `Weight` smallint(5) unsigned NOT NULL DEFAULT '1',
  `Price` decimal(10,2) NOT NULL COMMENT '价格',
  `IsSelf` tinyint(4) DEFAULT '0',
  `DiscountPrice` decimal(10,2) DEFAULT NULL,
  `CatID` smallint(5) unsigned NOT NULL COMMENT '分类ID',
  `StockCount` mediumint(8) unsigned NOT NULL,
  `IsRecommend` tinyint(4) NOT NULL DEFAULT '0',
  `Hits` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `IsDel` tinyint(4) NOT NULL DEFAULT '0' COMMENT '是否可用',
  `AddTime` datetime NOT NULL COMMENT '添加时间',
  PRIMARY KEY (`ID`),
  KEY `Name` (`Name`),
  KEY `Brand` (`Brand`),
  KEY `Price` (`Price`),
  KEY `CatID` (`CatID`),
  KEY `StockCount` (`StockCount`),
  KEY `IsDel` (`IsDel`) USING BTREE,
  KEY `Hits` (`Hits`),
  KEY `DiscountPrice` (`DiscountPrice`),
  KEY `IsRecommend` (`IsRecommend`)
) ENGINE=InnoDB AUTO_INCREMENT=606 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of goods
-- ----------------------------
INSERT INTO `goods` VALUES ('24', '1', '立邦乳胶漆', '时时丽', '立邦', '立邦漆', '乳胶漆', '白色', null, '1', '1', '140.00', '0', null, '25', '0', '0', '0', '1', '2015-12-08 11:00:13');
INSERT INTO `goods` VALUES ('28', '1', '全铜单用地漏', 'XDL0101', 'TEP', '', '不锈钢', '银色', null, '3', '1', '10.00', '0', null, '26', '0', '0', '0', '1', '2015-12-08 11:22:57');
INSERT INTO `goods` VALUES ('29', '1', '全铜防臭地漏', '5801', 'Cobbe/卡贝', '', '铜镀铬', '银色', null, '3', '1', '49.00', '0', null, '26', '0', '0', '0', '1', '2015-12-08 11:27:20');
INSERT INTO `goods` VALUES ('30', '1', '丽涂白', '18L', '立邦', '立邦', '', '', null, '3', '1', '260.00', '0', null, '25', '0', '0', '0', '1', '2015-12-08 14:37:52');
INSERT INTO `goods` VALUES ('31', '1', '绮得丽', '22KG', '立邦', '立邦', '', '', null, '3', '1', '240.00', '0', null, '25', '0', '0', '0', '1', '2015-12-08 14:40:21');
INSERT INTO `goods` VALUES ('32', '1', '净味120（2合1）', '18L', '立邦', '立邦', '', '', null, '3', '1', '360.00', '0', null, '25', '0', '0', '0', '1', '2015-12-08 14:41:40');
INSERT INTO `goods` VALUES ('33', '1', '120竹炭（2合1）', '18L', '立邦', '立邦', '', '', null, '3', '1', '400.00', '0', null, '25', '0', '0', '0', '1', '2015-12-08 14:42:31');
INSERT INTO `goods` VALUES ('34', '1', '120竹炭（3合1）无添加', '15L', '立邦', '立邦', '', '', null, '3', '1', '680.00', '0', null, '25', '0', '0', '0', '1', '2015-12-08 14:43:26');
INSERT INTO `goods` VALUES ('35', '1', '荷净净味(5合1）', '15L', '立邦', '立邦', '', '', null, '3', '1', '1080.00', '0', null, '25', '0', '0', '0', '1', '2015-12-08 14:44:12');
INSERT INTO `goods` VALUES ('36', '1', '抗甲醛净味（5合1）', '15L', '立邦', '立邦', '', '', null, '3', '1', '1050.00', '0', null, '25', '0', '0', '0', '1', '2015-12-08 14:44:48');
INSERT INTO `goods` VALUES ('37', '1', '荷净净味全效', '18L', '立邦', '立邦', '', '', null, '3', '1', '1580.00', '0', null, '25', '0', '0', '0', '1', '2015-12-08 14:45:24');
INSERT INTO `goods` VALUES ('38', '1', '美得丽耐久外墙面漆', '15L', '立邦', '立邦', '', '', null, '3', '1', '450.00', '0', null, '25', '0', '0', '0', '1', '2015-12-08 14:46:08');
INSERT INTO `goods` VALUES ('39', '1', '美得丽耐久外墙底漆', '22KG', '立邦', '立邦', '', '', null, '3', '1', '360.00', '0', null, '25', '0', '0', '0', '1', '2015-12-08 14:46:49');
INSERT INTO `goods` VALUES ('40', '1', '梦幻千色', '16L', '立邦', '立邦', '', '', null, '3', '1', '960.00', '0', null, '25', '0', '0', '0', '1', '2015-12-08 14:47:26');
INSERT INTO `goods` VALUES ('41', '1', '净味120硅藻', '5L', '立邦', '立邦', '', '', null, '3', '1', '580.00', '0', null, '25', '0', '0', '0', '1', '2015-12-08 14:47:54');
INSERT INTO `goods` VALUES ('42', '1', '儿童漆', '5L', '立邦', '立邦', '', '', null, '3', '1', '800.00', '0', null, '25', '0', '0', '0', '1', '2015-12-08 14:48:23');
INSERT INTO `goods` VALUES ('43', '1', '美得丽内墙漆', '18L', '立邦', '立邦', '', '', null, '3', '1', '360.00', '0', null, '25', '0', '0', '0', '1', '2015-12-08 14:49:01');
INSERT INTO `goods` VALUES ('44', '1', '瓷净净味全效', '5L', '立邦', '立邦', '', '', null, '3', '1', '798.00', '0', null, '25', '0', '0', '0', '1', '2015-12-08 14:49:30');
INSERT INTO `goods` VALUES ('45', '1', '金装抗甲醛全效', '5L', '立邦', '立邦', '', '', null, '3', '1', '818.00', '0', null, '25', '0', '0', '0', '1', '2015-12-08 14:49:58');
INSERT INTO `goods` VALUES ('47', '1', '净味120竹炭5合1', '5L', '立邦', '立邦', '', '', null, '3', '1', '428.00', '0', null, '25', '0', '0', '0', '1', '2015-12-08 14:52:35');
INSERT INTO `goods` VALUES ('48', '1', '净味120竹炭5合1', '18L', '立邦', '立邦', '', '', null, '3', '1', '1080.00', '0', null, '25', '0', '0', '0', '1', '2015-12-08 14:52:54');
INSERT INTO `goods` VALUES ('49', '1', '净味120（2合1）', '5L', '立邦', '立邦', '', '', null, '3', '1', '198.00', '0', null, '25', '0', '0', '0', '1', '2015-12-08 14:53:26');
INSERT INTO `goods` VALUES ('50', '1', '净味120竹炭（2合1）', '5L', '立邦', '立邦', '', '', null, '3', '1', '238.00', '0', null, '25', '0', '0', '0', '1', '2015-12-08 14:54:25');
INSERT INTO `goods` VALUES ('54', '1', '简约现代西皮沙发', '66S015', '美达', '美达家具厂', '西皮/电镀脚', '黑色', null, '3', '1', '3907.00', '0', null, '0', '0', '0', '0', '0', '2015-12-21 13:52:22');
INSERT INTO `goods` VALUES ('83', '1', '办公休闲 沙发套装 皮沙发', '66S043', '', '', '', '', null, '1', '1', '0.00', '0', null, '0', '0', '0', '0', '0', '2015-12-23 10:59:35');
INSERT INTO `goods` VALUES ('84', '1', '办公休闲 沙发套装 皮沙发', '66S043', '帝豪', '帝豪家具厂', '进口皮/弯曲木扶手/实木架', '黑色/红木', null, '4', '1', '9679.00', '0', null, '0', '0', '0', '0', '0', '2015-12-23 11:00:25');
INSERT INTO `goods` VALUES ('96', '1', '西门子16A空调电源插座', '', '西门子', '西门子', '', '', null, '3', '1', '17.00', '0', null, '6', '0', '0', '0', '1', '2016-01-12 10:16:10');
INSERT INTO `goods` VALUES ('99', '1', '西门子带开关五孔插座', '', '西门子', '西门子', '', '', null, '3', '1', '21.00', '0', null, '6', '0', '0', '0', '1', '2016-01-12 10:17:34');
INSERT INTO `goods` VALUES ('100', '1', '西门子二开单控带荧光', '', '西门子', '西门子', '', '', null, '3', '1', '13.00', '0', null, '6', '0', '0', '0', '1', '2016-01-12 10:18:57');
INSERT INTO `goods` VALUES ('101', '1', '西门子双电脑接口', '', '西门子', '西门子', '', '', null, '3', '1', '13.00', '0', null, '6', '0', '0', '0', '1', '2016-01-12 10:19:57');
INSERT INTO `goods` VALUES ('102', '1', '西门子四开双控', '', '西门子', '西门子', '', '', null, '3', '1', '25.00', '0', null, '6', '0', '0', '0', '1', '2016-01-12 10:20:52');
INSERT INTO `goods` VALUES ('103', '1', '西门子五孔插座', '', '西门子', '西门子', '', '', null, '3', '1', '10.00', '0', null, '0', '0', '0', '0', '0', '2016-01-12 10:21:42');
INSERT INTO `goods` VALUES ('104', '1', '西门子五孔插座', '', '西门子', '西门子', '', '', null, '3', '1', '10.00', '0', null, '0', '0', '0', '0', '0', '2016-01-12 10:22:19');
INSERT INTO `goods` VALUES ('105', '1', '西门子五孔插座', '', '西门子', '西门子', '', '', null, '3', '1', '10.00', '0', null, '0', '0', '0', '0', '0', '2016-01-12 10:22:47');
INSERT INTO `goods` VALUES ('106', '1', '西门子五孔插座', '', '西门子', '西门子', '', '', null, '3', '1', '10.00', '0', null, '0', '0', '0', '0', '0', '2016-01-12 10:22:49');
INSERT INTO `goods` VALUES ('107', '1', '西门子五孔插座', '', '西门子', '西门子', '', '', null, '3', '1', '10.00', '0', null, '0', '0', '0', '0', '0', '2016-01-12 10:24:44');
INSERT INTO `goods` VALUES ('108', '1', '西门子五孔插座', '', '西门子', '西门子', '', '', null, '3', '1', '10.00', '0', null, '0', '0', '0', '0', '0', '2016-01-12 10:24:47');
INSERT INTO `goods` VALUES ('109', '1', '西门子五孔插座', '', '西门子', '西门子', '', '', null, '3', '1', '10.00', '0', null, '7', '0', '0', '0', '1', '2016-01-12 10:29:07');
INSERT INTO `goods` VALUES ('110', '1', '西门子一开双控带荧光', '', '西门子', '西门子', '', '', null, '3', '1', '14.00', '0', null, '7', '0', '0', '0', '1', '2016-01-12 10:30:06');
INSERT INTO `goods` VALUES ('111', '1', '伯盾卫浴五金套装', '', '伯盾', '伯盾', '', '', null, '4', '1', '179.00', '0', null, '33', '0', '0', '0', '1', '2016-01-12 10:32:15');
INSERT INTO `goods` VALUES ('113', '1', '美的顶吸式烟灶消套餐', '', '美的', '美的', '', '', null, '4', '1', '2499.00', '0', null, '0', '0', '0', '0', '0', '2016-01-12 10:41:45');
INSERT INTO `goods` VALUES ('115', '1', '欧睿宇邦现代烤漆橱柜', '', '欧睿宇邦', '欧睿宇邦', '', '', null, '2', '1', '1680.00', '0', null, '35', '0', '0', '0', '1', '2016-01-12 11:58:32');
INSERT INTO `goods` VALUES ('116', '1', '欧睿宇邦环保石英石台面橱柜', '', '欧睿宇邦', '欧睿宇邦', '', '', null, '2', '1', '2180.00', '0', null, '35', '0', '0', '0', '1', '2016-01-12 12:43:21');
INSERT INTO `goods` VALUES ('117', '1', '欧睿宇邦简约橱柜', '', '欧睿宇邦', '欧睿宇邦', '', '', null, '2', '1', '1880.00', '0', null, '35', '0', '0', '0', '1', '2016-01-12 15:52:14');
INSERT INTO `goods` VALUES ('118', '1', '马桶', 'W1341', '东鹏', '东鹏洁具', 'PP板', '白色', null, '3', '1', '768.00', '0', null, '37', '0', '0', '0', '1', '2016-01-12 16:24:38');
INSERT INTO `goods` VALUES ('119', '1', '马桶', 'W1191', '东鹏', '东鹏洁具', 'PP板', '白色', null, '3', '1', '1498.00', '0', null, '37', '0', '0', '0', '1', '2016-01-12 16:26:56');
INSERT INTO `goods` VALUES ('120', '1', '400孔距PP板马桶', 'JGMT16061', '东鹏', '东鹏', 'PP板', '白色', null, '3', '1', '0.00', '0', null, '37', '0', '0', '0', '1', '2016-01-12 16:29:35');
INSERT INTO `goods` VALUES ('121', '1', '诺贝尔瓷砖', 'RS80798', '诺贝尔', '诺贝尔瓷砖', '全抛釉', '', null, '1', '1', '188.00', '0', null, '31', '0', '0', '0', '1', '2016-01-12 16:35:55');
INSERT INTO `goods` VALUES ('124', '1', '东鹏浴室柜', '40802', '东鹏', '东鹏洁具', '其他', '白色/木质', null, '4', '1', '1700.00', '0', null, '38', '0', '0', '0', '1', '2016-01-12 16:59:59');
INSERT INTO `goods` VALUES ('125', '1', '东鹏组合柜', '3241', '东鹏', '东鹏洁具', '像木', '黑/白', null, '4', '1', '1530.00', '0', null, '38', '0', '0', '0', '1', '2016-01-12 17:02:57');
INSERT INTO `goods` VALUES ('126', '1', '花洒', '其他', 'ARROW/箭牌', '箭牌卫浴', '铜', '银', null, '4', '1', '400.00', '0', null, '39', '0', '0', '0', '1', '2016-01-13 09:37:53');
INSERT INTO `goods` VALUES ('127', '1', '花洒', ' DM706CMF', 'TOTO', 'TOTO', '其他', '银', null, '4', '1', '249.00', '0', null, '39', '0', '0', '0', '1', '2016-01-13 09:43:33');
INSERT INTO `goods` VALUES ('128', '1', '浴室镜', 'L-2', ' Francisc/法兰棋', '法兰棋', '其他', '其他', null, '3', '1', '578.00', '0', null, '40', '0', '0', '0', '1', '2016-01-13 09:50:05');
INSERT INTO `goods` VALUES ('129', '1', '浴室镜', ' NL-1197', '那澜多好', '那澜多好', '其他', '其他', null, '3', '1', '239.00', '0', null, '40', '0', '0', '0', '1', '2016-01-13 09:56:50');
INSERT INTO `goods` VALUES ('130', '1', '澳洲彩纹石（300*600）', 'L93102', 'LD', 'LD', '高清石', '', null, '1', '1', '128.00', '0', null, '31', '0', '0', '0', '1', '2016-01-13 12:41:44');
INSERT INTO `goods` VALUES ('131', '1', '运安金米黄（300*600）', 'L93028', 'LD', 'LD', '高清石', '', null, '1', '1', '128.00', '0', null, '31', '0', '0', '0', '1', '2016-01-13 12:43:07');
INSERT INTO `goods` VALUES ('132', '1', '米诺石（300*600）', 'L93032', 'LD', 'LD', '高清石', '', null, '1', '1', '128.00', '0', null, '31', '0', '0', '0', '1', '2016-01-13 12:43:58');
INSERT INTO `goods` VALUES ('134', '1', '帝王灰（300*300）', ' LM3632', 'LD', 'LD', '高清石', '', null, '1', '1', '133.00', '0', null, '31', '0', '0', '0', '1', '2016-01-13 12:46:38');
INSERT INTO `goods` VALUES ('135', '1', 'LM3322（300*300）', 'LM3322', 'LD', 'LD', '高清石', '', null, '1', '1', '133.00', '0', null, '0', '0', '0', '0', '0', '2016-01-13 12:48:37');
INSERT INTO `goods` VALUES ('136', '1', 'LM3322（300*300）', 'LM3322', 'LD', 'LD', '高清石', '', null, '1', '1', '133.00', '0', null, '31', '0', '0', '0', '1', '2016-01-13 12:50:20');
INSERT INTO `goods` VALUES ('137', '1', '自然石(300*600)', ' LSH5218', 'LD', 'LD', '瓷质哑光砖', '', null, '1', '1', '161.00', '0', null, '31', '0', '0', '0', '1', '2016-01-13 12:51:48');
INSERT INTO `goods` VALUES ('138', '1', '莫钛 （300*600）', ' LSI5019', 'LD', 'LD', '瓷质哑光砖', '', null, '1', '1', '178.00', '0', null, '31', '0', '0', '0', '1', '2016-01-13 12:52:43');
INSERT INTO `goods` VALUES ('139', '1', '科摩石（300*600）', ' LSH5720', 'LD', 'LD', '瓷质哑光砖', '', null, '1', '1', '217.00', '0', null, '31', '0', '0', '0', '1', '2016-01-13 12:53:43');
INSERT INTO `goods` VALUES ('140', '1', '皮纹砖（浅）（300*600）', 'LSZ5012B1', 'LD', 'LD', '瓷质哑光砖', '', null, '1', '1', '311.00', '0', null, '31', '0', '0', '0', '1', '2016-01-13 12:54:41');
INSERT INTO `goods` VALUES ('141', '1', '皮纹砖（深）（300*600）', 'LSZ5016B1', 'LD', 'LD', '瓷质哑光砖', '', null, '1', '1', '311.00', '0', null, '31', '0', '0', '0', '1', '2016-01-13 12:56:01');
INSERT INTO `goods` VALUES ('142', '1', '巴厘石（600*600）', 'LSZ6862AS', 'LD', 'LD', '高清全抛釉', '', null, '1', '1', '275.00', '0', null, '31', '0', '0', '0', '1', '2016-01-13 12:57:26');
INSERT INTO `goods` VALUES ('143', '1', 'LSZ5522AS（300*600）', 'LSZ5522AS', 'LD', 'LD', '高清全抛釉', '', null, '1', '1', '161.00', '0', null, '31', '0', '0', '0', '1', '2016-01-13 12:58:38');
INSERT INTO `goods` VALUES ('144', '1', '冰川岩（300*600）', 'LSZ5528AS', 'LD', 'LD', '高清全抛釉', '', null, '1', '1', '289.00', '0', null, '31', '0', '0', '0', '1', '2016-01-13 12:59:45');
INSERT INTO `goods` VALUES ('145', '1', '欧珀玉石（600*600）', 'LSZ6558AS', 'LD', 'LD', '高清全抛釉', '', null, '1', '1', '275.00', '0', null, '31', '0', '0', '0', '1', '2016-01-13 13:00:56');
INSERT INTO `goods` VALUES ('146', '1', '墙地砖皇米石(600*600)', ' LSZ6902AS', 'LD', 'LD', '高清全抛釉', '', null, '1', '1', '397.00', '0', null, '31', '0', '0', '0', '1', '2016-01-13 13:02:03');
INSERT INTO `goods` VALUES ('147', '1', 'PK石（330*330）', ' LS3302', 'LD', 'LD', '瓷质阳台砖', '', null, '1', '1', '156.00', '0', null, '31', '0', '0', '0', '1', '2016-01-13 13:06:16');
INSERT INTO `goods` VALUES ('148', '1', '木纹砖 （150*600）', ' LS6026', 'LD', 'LD', '木纹砖', '', null, '1', '1', '189.00', '0', null, '31', '0', '0', '0', '1', '2016-01-13 13:09:44');
INSERT INTO `goods` VALUES ('149', '1', '木纹砖（150*600）', ' LS6930', 'LD', 'LD', '木纹砖', '', null, '1', '1', '189.00', '0', null, '31', '0', '0', '0', '1', '2016-01-13 13:16:46');
INSERT INTO `goods` VALUES ('150', '1', '木纹砖（150*900）', 'LS9016', 'LD', 'LD', '木纹砖', '', null, '1', '1', '215.00', '0', null, '31', '0', '0', '0', '1', '2016-01-13 13:19:12');
INSERT INTO `goods` VALUES ('151', '1', '木纹砖（150*900）', ' LS9022', 'LD', 'LD', '木纹砖', '', null, '1', '1', '215.00', '0', null, '31', '0', '0', '0', '1', '2016-01-13 13:20:12');
INSERT INTO `goods` VALUES ('152', '1', '自然石（800*800）', ' LSH8218', 'LD', 'LD', '瓷质哑光砖', '', null, '1', '1', '200.00', '0', null, '31', '0', '0', '0', '1', '2016-01-13 13:21:43');
INSERT INTO `goods` VALUES ('153', '1', 'LSZ8063AS（800*800）', 'LSZ8063AS', 'LD', 'LD', '高清全抛釉', '', null, '1', '1', '263.00', '0', null, '31', '0', '0', '0', '1', '2016-01-13 13:22:49');
INSERT INTO `goods` VALUES ('154', '1', '欧珀玉石（800*800）', ' LSZ8508AS', 'LD', 'LD', '高清全抛釉', '', null, '1', '1', '263.00', '0', null, '31', '0', '0', '0', '1', '2016-01-13 13:23:45');
INSERT INTO `goods` VALUES ('155', '1', 'LSZ8068AS（800*800）', 'LSZ8068AS', 'LD', 'LD', '高清全抛釉', '', null, '1', '1', '294.00', '0', null, '31', '0', '0', '0', '1', '2016-01-13 13:24:53');
INSERT INTO `goods` VALUES ('156', '1', '巴厘石墙地砖（800*800）', ' LSZ6862AS', 'LD', 'LD', '高清全抛釉', '', null, '1', '1', '309.00', '0', null, '31', '0', '0', '0', '1', '2016-01-13 13:26:15');
INSERT INTO `goods` VALUES ('157', '1', 'LSZ8062AS（800*800）', 'LSZ8062AS', 'LD', 'LD', '高清全抛釉', '', null, '1', '1', '375.00', '0', null, '31', '0', '0', '0', '1', '2016-01-13 13:27:26');
INSERT INTO `goods` VALUES ('158', '1', '墙地砖皇米石（800*800）', ' LSZ8902AS', 'LD', 'LD', '高清全抛釉', '', null, '1', '1', '403.00', '0', null, '31', '0', '0', '0', '1', '2016-01-13 13:28:34');
INSERT INTO `goods` VALUES ('159', '1', 'LSZ8678AS（800*800）', 'LSZ8678AS', 'LD', 'LD', '高清全抛釉', '', null, '1', '1', '403.00', '0', null, '31', '0', '0', '0', '1', '2016-01-13 13:29:24');
INSERT INTO `goods` VALUES ('160', '1', 'LSZ8942AS（800*800）', 'LSZ8942AS', 'LD', 'LD', '高清全抛釉', '', null, '1', '1', '403.00', '0', null, '31', '0', '0', '0', '1', '2016-01-13 13:30:10');
INSERT INTO `goods` VALUES ('161', '1', 'LSZ8508YH1AS（800*800）', 'LSZ8508YH1AS', 'LD', 'LD', '高清全抛釉', '', null, '1', '1', '247.00', '0', null, '31', '0', '0', '0', '1', '2016-01-13 13:31:03');
INSERT INTO `goods` VALUES ('162', '1', '卡布奇诺大地砖（800*800）', ' LSZ8822AS', 'LD', 'LD', '高清全抛釉', '', null, '1', '1', '403.00', '0', null, '31', '0', '0', '0', '1', '2016-01-13 13:32:49');
INSERT INTO `goods` VALUES ('163', '1', 'LZS8053YS(黄）（800*800）', 'LZS8053YS(黄）', 'LD', 'LD', '高清全抛釉', '', null, '1', '1', '403.00', '0', null, '31', '0', '0', '0', '1', '2016-01-13 13:33:31');
INSERT INTO `goods` VALUES ('164', '1', 'LSZ8524AS（800*800）', 'LSZ8524AS', 'LD', 'LD', '高清全抛釉', '', null, '1', '1', '419.00', '0', null, '31', '0', '0', '0', '1', '2016-01-13 13:34:24');
INSERT INTO `goods` VALUES ('165', '1', '啡网（深色）（800*800）', 'LSZ8416AS', 'LD', 'LD', '高清全抛釉', '', null, '1', '1', '419.00', '0', null, '31', '87', '0', '0', '1', '2016-01-13 13:35:40');
INSERT INTO `goods` VALUES ('166', '1', 'LSZ8093AS（800*800）', 'LSZ8093AS', 'LD', 'LD', '高清全抛釉', '', null, '1', '1', '466.00', '0', null, '31', '45', '0', '0', '1', '2016-01-13 13:36:27');
INSERT INTO `goods` VALUES ('167', '2', '美的顶吸式抽油烟机套餐', '', '美的', '美的', '', '', null, '4', '1', '2499.00', '0', null, '34', '45', '0', '0', '1', '2016-01-13 15:38:21');
INSERT INTO `goods` VALUES ('168', '2', '美的侧吸式抽油烟机套装', '', '美的', '美的', '', '', null, '4', '1', '2588.00', '0', null, '34', '21', '0', '0', '1', '2016-01-13 15:40:14');
INSERT INTO `goods` VALUES ('169', '1', '0.1元测试货品', 'asdf', 'asdf', 'asdf', 'asdf', 'asdf', null, '3', '1', '0.10', '0', null, '26', '10', '0', '0', '1', '2016-03-12 14:27:33');
INSERT INTO `goods` VALUES ('170', '1', '0.1元测试货品', 'asdf', 'asdf', 'asdf', 'asdf', 'asdf', null, '3', '1', '0.10', '0', null, '26', '10', '0', '0', '1', '2016-03-12 14:27:37');
INSERT INTO `goods` VALUES ('171', '1', '0.1元测试货品', 'asdf', 'asdf', 'asdf', 'asdf', 'asdf', null, '3', '1', '0.10', '0', null, '26', '10', '0', '0', '1', '2016-03-12 14:27:38');
INSERT INTO `goods` VALUES ('172', '8', '0.1元测试货品', 'asdf', 'asdf', 'asdf', 'asdf', 'asdf', null, '3', '1', '0.10', '0', null, '26', '10', '0', '0', '1', '2016-03-12 14:27:39');
INSERT INTO `goods` VALUES ('173', '1', '台灯', '台灯', 'TCL', 'TCL', '塑料', '白色', null, '1', '1', '0.01', '0', null, '35', '90', '0', '0', '1', '2016-03-14 09:05:53');
INSERT INTO `goods` VALUES ('174', '1', '234234', '', '', '', '', '', null, '1', '1', '0.10', '0', null, '0', '0', '0', '0', '0', '2016-03-14 09:06:49');
INSERT INTO `goods` VALUES ('175', '6', '175', '大地瓷砖', '阿波罗', '浙江阿波罗', '54', '45', null, '1', '1', '456.00', '0', null, '31', '789', '0', '0', '1', '2016-03-14 11:22:22');
INSERT INTO `goods` VALUES ('176', '1', '123（测试）', '', '123', '123', '', '', '', '1', '123', '123.00', '0', null, '26', '123', '0', '0', '1', '2016-03-16 15:20:41');
INSERT INTO `goods` VALUES ('177', '1', '123（测试）', '', '123', '123', '', '', '', '1', '123', '123.00', '0', null, '26', '123', '0', '0', '1', '2016-03-16 15:20:42');
INSERT INTO `goods` VALUES ('178', '1', '324324', '324', '324', '324', '324', '324', '324324', '2', '324', '324324.00', '0', null, '35', '11', '0', '0', '1', '2016-03-16 15:23:00');
INSERT INTO `goods` VALUES ('179', '1', '新禧台灯', 'XX10111', '新禧', '新禧', '塑料', '白色', '好东西', '3', '1', '0.01', '0', null, '35', '100', '0', '0', '1', '2016-03-16 16:07:34');
INSERT INTO `goods` VALUES ('180', '1', '123（测试）', '', '123', '123', '', '', '', '1', '123', '123.00', '0', null, '26', '123', '0', '0', '1', '2016-03-16 16:14:12');
INSERT INTO `goods` VALUES ('181', '1', '测试商品01', '123', '123', '123', '123', '123', '123', '1', '123', '0.10', '0', null, '26', '123', '0', '0', '1', '2016-03-16 16:16:17');
INSERT INTO `goods` VALUES ('182', '1', '好台灯', '121', '213', '213', '213', '', '', '3', '1', '0.01', '0', null, '35', '11', '0', '0', '1', '2016-03-17 09:10:19');
INSERT INTO `goods` VALUES ('183', '1', '123（测试）', '', '123', '123', '', '', '', '1', '1', '0.10', '0', null, '26', '123', '0', '0', '1', '2016-03-17 16:37:04');
INSERT INTO `goods` VALUES ('184', '1', '好美丽台灯', '22', '好美丽', '好美丽灯具生产厂', '塑料', '红色', '<p style=\\\"\\\\&quot;margin:\\\"><span style=\\\"\\\\&quot;font-size:\\\">这是一款铁夹子台灯，造型时尚</span><span style=\\\"\\\\&quot;font-size:\\\">简约，杆长38CM,灯罩长32CM。线长</span><span style=\\\"\\\\&quot;font-size:\\\">1.5米哦。</span></p>\r\n<p style=\\\"\\\\&quot;margin:\\\">&nbsp;<span style=\\\"\\\\&quot;font-size:\\\">线上开关，两档光（一开弱光，再开</span><span style=\\\"\\\\&quot;font-size:\\\">强光）。</span></p>\r\n<p style=\\\"\\\\&quot;margin:\\\">&nbsp;</p>\r\n<p style=\\\"\\\\&quot;margin:\\\"><span style=\\\"\\\\&quot;font-size:\\\">人性化USB多端接口设计，可通过USB</span><span style=\\\"\\\\&quot;font-size:\\\">电源器（手机充电器通用）与插座连</span><span style=\\\"\\\\&quot;font-size:\\\">接；可直接插入电脑USB端口使用；也</span><span style=\\\"\\\\&quot;font-size:\\\">可当做充电灯用（只需与充电宝连即</span></p>\r\n<p style=\\\"\\\\&quot;margin:\\\"><span style=\\\"\\\\&quot;font-size:\\\">可）。想怎么用就怎么用，就是这么</span><span style=\\\"\\\\&quot;font-size:\\\">任性！</span></p>\r\n<p style=\\\"\\\\&quot;margin:\\\"><span style=\\\"\\\\&quot;font-size:\\\"><img src=\\\"/pic/upload/image/ne4kwfyaziqvbru5mc73.jpg\\\" width=\\\"750\\\" height=\\\"1062\\\" alt=\\\"\\\" /></span></p>', '1', '1', '0.01', '0', null, '35', '10', '0', '0', '0', '2016-03-21 08:42:21');
INSERT INTO `goods` VALUES ('185', '0', '到店', '收到', '我的', '斯蒂芬', '', '', '<p>						</p><p>斯蒂芬斯蒂芬森防<br/></p>', '1', '10', '300.00', '0', null, '1', '25', '0', '0', '1', '2016-04-07 11:44:33');
INSERT INTO `goods` VALUES ('186', '1', '全实木床板式床现代简约双人床', 'DC02', '奔斯', '广东佛山卡伊莲家具生产厂', '其他', '原木', '<p>						</p><p><br/></p><p><br/></p><p><img src=\\\"/pic/upload/image/20160615/14659552361060812.jpg\\\" style=\\\"\\\" title=\\\"14659552361060812.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160615/14659552418382161.jpg\\\" style=\\\"\\\" title=\\\"14659552418382161.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160615/14659552412017763.jpg\\\" style=\\\"\\\" title=\\\"14659552412017763.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160615/14659552459222145.jpg\\\" style=\\\"\\\" title=\\\"14659552459222145.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160615/14659552478555574.jpg\\\" style=\\\"\\\" title=\\\"14659552478555574.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160615/14659552502809976.jpg\\\" style=\\\"\\\" title=\\\"14659552502809976.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160615/14659552605862647.jpg\\\" style=\\\"\\\" title=\\\"14659552605862647.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160615/14659552633737319.jpg\\\" style=\\\"\\\" title=\\\"14659552633737319.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160615/146595526412814410.jpg\\\" style=\\\"\\\" title=\\\"146595526412814410.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160615/146595526520599311.jpg\\\" style=\\\"\\\" title=\\\"146595526520599311.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160615/146595527064483112.jpg\\\" style=\\\"\\\" title=\\\"146595527064483112.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160615/146595527112328113.jpg\\\" style=\\\"\\\" title=\\\"146595527112328113.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160615/14659552822956288.jpg\\\" style=\\\"\\\" title=\\\"14659552822956288.jpg\\\"/></p><p><br/></p>', '1', '150', '0.01', '0', '0.01', '54', '3', '1', '0', '0', '2016-05-28 16:24:02');
INSERT INTO `goods` VALUES ('187', '1', ' 中式风格 简约大气 环保实用实木书桌 ', '', '梵达思', '广东惠州', '', '', null, '1', '10', '0.01', '0', null, '120', '1', '0', '0', '1', '2016-05-30 16:56:20');
INSERT INTO `goods` VALUES ('188', '1', ' 中式风格 简约大气 环保实用实木书桌 ', '', '梵达思', '广东惠州', '', '', null, '1', '10', '0.01', '0', null, '120', '1', '0', '0', '1', '2016-05-30 16:56:23');
INSERT INTO `goods` VALUES ('189', '1', ' 中式风格 简约大气 环保实用实木书桌 ', '', '梵达思', '广东惠州', '', '', null, '1', '10', '0.01', '0', null, '120', '1', '0', '0', '1', '2016-05-30 16:56:28');
INSERT INTO `goods` VALUES ('190', '1', ' 中式风格 简约大气 环保实用实木书桌 ', '', '梵达思', '广东惠州', '', '', null, '1', '10', '0.01', '0', null, '120', '1', '0', '0', '0', '2016-05-30 16:56:29');
INSERT INTO `goods` VALUES ('191', '1', ' 中式风格 简约大气 环保实用实木书桌 ', '', '梵达思', '广东惠州', '', '', null, '1', '10', '0.01', '0', null, '120', '1', '0', '0', '1', '2016-05-30 16:56:32');
INSERT INTO `goods` VALUES ('192', '1', ' 中式风格 简约大气 环保实用实木书桌 ', '', '梵达思', '广东惠州', '', '', null, '1', '10', '0.01', '0', null, '120', '1', '0', '0', '1', '2016-05-30 16:56:33');
INSERT INTO `goods` VALUES ('193', '1', ' 中式风格 简约大气 环保实用实木书桌 ', '', '梵达思', '广东惠州', '', '', null, '1', '10', '0.01', '0', null, '120', '1', '0', '0', '1', '2016-05-30 16:56:47');
INSERT INTO `goods` VALUES ('194', '1', ' 中式风格 简约大气 环保实用实木书桌 ', '', '梵达思', '广东惠州', '', '', '<p><img src=\\\"/pic/upload/image/20160530/1464598516139698QQ截图20160530165116.jpg\\\" style=\\\"\\\" title=\\\"1464598516139698QQ截图20160530165116.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160530/1464598519328203QQ截图20160530165019.jpg\\\" style=\\\"\\\" title=\\\"1464598519328203QQ截图20160530165019.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160530/1464598520118599QQ截图20160530165102.jpg\\\" style=\\\"\\\" title=\\\"1464598520118599QQ截图20160530165102.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160530/1464598525636784QQ截图20160530165142.jpg\\\" style=\\\"\\\" title=\\\"1464598525636784QQ截图20160530165142.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160530/1464598528113986QQ截图20160530165130.jpg\\\" style=\\\"\\\" title=\\\"1464598528113986QQ截图20160530165130.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160530/1464598533115458QQ截图20160530165153.jpg\\\" style=\\\"\\\" title=\\\"1464598533115458QQ截图20160530165153.jpg\\\"/></p><p><br/></p>', '1', '10', '0.01', '0', null, '120', '1', '0', '0', '1', '2016-05-30 16:57:24');
INSERT INTO `goods` VALUES ('195', '1', ' 中式风格 简约大气 环保实用实木书桌 ', '', '梵达思', '广东惠州', '', '', null, '1', '10', '0.01', '0', null, '120', '1', '0', '0', '1', '2016-05-30 16:57:29');
INSERT INTO `goods` VALUES ('196', '1', ' 中式风格 简约大气 环保实用实木书桌 ', '', '梵达思', '广东惠州', '', '', null, '1', '10', '0.01', '0', null, '120', '1', '0', '0', '1', '2016-05-30 16:57:53');
INSERT INTO `goods` VALUES ('197', '1', ' 中式风格 简约大气 环保实用实木书桌 ', '', '梵达思', '广东惠州', '', '', '<p><img src=\\\"/pic/upload/image/20160530/1464598516139698QQ截图20160530165116.jpg\\\" style=\\\"\\\" title=\\\"1464598516139698QQ截图20160530165116.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160530/1464598519328203QQ截图20160530165019.jpg\\\" style=\\\"\\\" title=\\\"1464598519328203QQ截图20160530165019.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160530/1464598520118599QQ截图20160530165102.jpg\\\" style=\\\"\\\" title=\\\"1464598520118599QQ截图20160530165102.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160530/1464598525636784QQ截图20160530165142.jpg\\\" style=\\\"\\\" title=\\\"1464598525636784QQ截图20160530165142.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160530/1464598528113986QQ截图20160530165130.jpg\\\" style=\\\"\\\" title=\\\"1464598528113986QQ截图20160530165130.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160530/1464598533115458QQ截图20160530165153.jpg\\\" style=\\\"\\\" title=\\\"1464598533115458QQ截图20160530165153.jpg\\\"/></p><p><br/></p>', '1', '10', '0.01', '0', null, '120', '1', '0', '0', '1', '2016-05-30 16:58:25');
INSERT INTO `goods` VALUES ('198', '1', '简约现代纯实木小书桌子', '', '爱家佳', '广东惠州', '', '', '<p>						</p><p><img src=\\\"/pic/upload/image/20160615/14659547734889703.jpg\\\" style=\\\"\\\" title=\\\"14659547734889703.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160615/14659547756366551.jpg\\\" style=\\\"\\\" title=\\\"14659547756366551.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160615/14659547781153985.jpg\\\" style=\\\"\\\" title=\\\"14659547781153985.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160615/14659547785703434.jpg\\\" style=\\\"\\\" title=\\\"14659547785703434.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160615/14659547824368156.jpg\\\" style=\\\"\\\" title=\\\"14659547824368156.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160615/14659547831219527.jpg\\\" style=\\\"\\\" title=\\\"14659547831219527.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160615/14659547857746589.jpg\\\" style=\\\"\\\" title=\\\"14659547857746589.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160615/14659547859815112.jpg\\\" style=\\\"\\\" title=\\\"14659547859815112.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160615/14659547868811618.jpg\\\" style=\\\"\\\" title=\\\"14659547868811618.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160615/146595479021997810.jpg\\\" style=\\\"\\\" title=\\\"146595479021997810.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160615/146595479125625411.jpg\\\" style=\\\"\\\" title=\\\"146595479125625411.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160615/146595479248191212.jpg\\\" style=\\\"\\\" title=\\\"146595479248191212.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160615/146595479612099215.jpg\\\" style=\\\"\\\" title=\\\"146595479612099215.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160615/146595480172844114.jpg\\\" style=\\\"\\\" title=\\\"146595480172844114.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160615/146595480375852116.jpg\\\" style=\\\"\\\" title=\\\"146595480375852116.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160615/146595480512224813.jpg\\\" style=\\\"\\\" title=\\\"146595480512224813.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160615/146595480813132418.jpg\\\" style=\\\"\\\" title=\\\"146595480813132418.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160615/146595480912956817.jpg\\\" style=\\\"\\\" title=\\\"146595480912956817.jpg\\\"/></p><p><br/></p>', '1', '10', '0.02', '0', '0.01', '120', '1', '1', '0', '0', '2016-05-30 17:06:15');
INSERT INTO `goods` VALUES ('199', '1', '简约现代金属用时尚钢木组合台 书桌', '', '蔓菲', '广东', '', '', '<p><img src=\\\"/pic/upload/image/20160614/14658931681178853.jpg\\\" style=\\\"\\\" title=\\\"14658931681178853.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658931711292501.jpg\\\" style=\\\"\\\" title=\\\"14658931711292501.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658931726395812.jpg\\\" style=\\\"\\\" title=\\\"14658931726395812.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658931791196845.jpg\\\" style=\\\"\\\" title=\\\"14658931791196845.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658931797122624.jpg\\\" style=\\\"\\\" title=\\\"14658931797122624.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658931799314226.jpg\\\" style=\\\"\\\" title=\\\"14658931799314226.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658931861147527.jpg\\\" style=\\\"\\\" title=\\\"14658931861147527.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658931898011229.jpg\\\" style=\\\"\\\" title=\\\"14658931898011229.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/146589319250816210.jpg\\\" style=\\\"\\\" title=\\\"146589319250816210.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/146589319468239711.jpg\\\" style=\\\"\\\" title=\\\"146589319468239711.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658931952459268.jpg\\\" style=\\\"\\\" title=\\\"14658931952459268.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/146589319957692714.jpg\\\" style=\\\"\\\" title=\\\"146589319957692714.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/146589319910137812.jpg\\\" style=\\\"\\\" title=\\\"146589319910137812.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/146589320120655215.jpg\\\" style=\\\"\\\" title=\\\"146589320120655215.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/146589320212517916.jpg\\\" style=\\\"\\\" title=\\\"146589320212517916.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/146589320754680413.jpg\\\" style=\\\"\\\" title=\\\"146589320754680413.jpg\\\"/></p><p><br/></p>', '1', '10', '0.01', '0', '0.01', '121', '2', '0', '0', '0', '2016-05-30 17:15:04');
INSERT INTO `goods` VALUES ('200', '1', '台式家用办公桌书桌现代简约简易钢木', '', '亿家达', '广东', '', '', '<p><img src=\\\"/pic/upload/image/20160614/14658927459423522.jpg\\\" style=\\\"\\\" title=\\\"14658927459423522.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658927486024871.jpg\\\" style=\\\"\\\" title=\\\"14658927486024871.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658927488207454.jpg\\\" style=\\\"\\\" title=\\\"14658927488207454.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658927512662803.jpg\\\" style=\\\"\\\" title=\\\"14658927512662803.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658927541400036.jpg\\\" style=\\\"\\\" title=\\\"14658927541400036.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658927556984485.jpg\\\" style=\\\"\\\" title=\\\"14658927556984485.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658927551327877.jpg\\\" style=\\\"\\\" title=\\\"14658927551327877.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658927581423928.jpg\\\" style=\\\"\\\" title=\\\"14658927581423928.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658927591222109.jpg\\\" style=\\\"\\\" title=\\\"14658927591222109.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/146589276124958410.jpg\\\" style=\\\"\\\" title=\\\"146589276124958410.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/146589276321300712.jpg\\\" style=\\\"\\\" title=\\\"146589276321300712.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/146589276512965914.jpg\\\" style=\\\"\\\" title=\\\"146589276512965914.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/146589276552438511.jpg\\\" style=\\\"\\\" title=\\\"146589276552438511.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/146589276612492113.jpg\\\" style=\\\"\\\" title=\\\"146589276612492113.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/146589276971346617.jpg\\\" style=\\\"\\\" title=\\\"146589276971346617.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/146589276912018715.jpg\\\" style=\\\"\\\" title=\\\"146589276912018715.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/146589276915134216.jpg\\\" style=\\\"\\\" title=\\\"146589276915134216.jpg\\\"/></p><p><br/></p>', '1', '8', '0.01', '0', '0.01', '122', '2', '0', '0', '0', '2016-05-30 17:21:23');
INSERT INTO `goods` VALUES ('201', '1', '简约现代人造板台式电脑桌可伸缩书桌', '', '搭瓦屋', '佛山市', '', '', '<p><img src=\\\"/pic/upload/image/20160614/14658918734137932.jpg\\\" style=\\\"\\\" title=\\\"14658918734137932.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658918763365944.jpg\\\" style=\\\"\\\" title=\\\"14658918763365944.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658918796092001.jpg\\\" style=\\\"\\\" title=\\\"14658918796092001.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658918861477713.jpg\\\" style=\\\"\\\" title=\\\"14658918861477713.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658918921182515.jpg\\\" style=\\\"\\\" title=\\\"14658918921182515.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658918952541888.jpg\\\" style=\\\"\\\" title=\\\"14658918952541888.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658918962704977.jpg\\\" style=\\\"\\\" title=\\\"14658918962704977.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658918967781436.jpg\\\" style=\\\"\\\" title=\\\"14658918967781436.jpg\\\"/></p><p><br/></p>', '1', '15', '0.02', '0', '0.01', '123', '1', '0', '0', '0', '2016-05-30 17:28:47');
INSERT INTO `goods` VALUES ('202', '1', '', '', ' 搭瓦屋', '江苏徐州', '', '', '<p><img src=\\\"/pic/upload/image/20160614/14658921312379652.jpg\\\" style=\\\"\\\" title=\\\"14658921312379652.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658921346609684.jpg\\\" style=\\\"\\\" title=\\\"14658921346609684.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658921361358123.jpg\\\" style=\\\"\\\" title=\\\"14658921361358123.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658921402284121.jpg\\\" style=\\\"\\\" title=\\\"14658921402284121.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658921431920506.jpg\\\" style=\\\"\\\" title=\\\"14658921431920506.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658921453326358.jpg\\\" style=\\\"\\\" title=\\\"14658921453326358.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658921465562285.jpg\\\" style=\\\"\\\" title=\\\"14658921465562285.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658921481002127.jpg\\\" style=\\\"\\\" title=\\\"14658921481002127.jpg\\\"/></p><p><br/></p>', '1', '20', '0.02', '0', '0.01', '124', '1', '0', '0', '1', '2016-05-30 17:35:35');
INSERT INTO `goods` VALUES ('203', '1', '简约现代小书桌 楠竹实木电脑桌多功能学习桌', '', ' Ruichang', '山东', '', '', '<p><img src=\\\"/pic/upload/image/20160614/14658913678769443.jpg\\\" style=\\\"\\\" title=\\\"14658913678769443.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658913671714382.jpg\\\" style=\\\"\\\" title=\\\"14658913671714382.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658913697100241.jpg\\\" style=\\\"\\\" title=\\\"14658913697100241.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658913794631945.jpg\\\" style=\\\"\\\" title=\\\"14658913794631945.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658913791355714.jpg\\\" style=\\\"\\\" title=\\\"14658913791355714.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658913797078726.jpg\\\" style=\\\"\\\" title=\\\"14658913797078726.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658913818203147.jpg\\\" style=\\\"\\\" title=\\\"14658913818203147.jpg\\\"/></p><p><br/></p>', '1', '10', '0.01', '0', '0.01', '125', '1', '0', '0', '0', '2016-05-30 17:42:31');
INSERT INTO `goods` VALUES ('204', '1', '高档竹家具书桌', '', 'H-Flying', '山东', '', '', '<p><img src=\\\"/pic/upload/image/20160530/146460127813788223.jpg\\\" style=\\\"\\\" title=\\\"146460127813788223.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160530/146460128045527622.jpg\\\" style=\\\"\\\" title=\\\"146460128045527622.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160530/146460133619768824.jpg\\\" title=\\\"146460133619768824.jpg\\\" alt=\\\"24.jpg\\\"/></p>', '1', '10', '0.01', '0', null, '125', '1', '0', '0', '1', '2016-05-30 17:42:33');
INSERT INTO `goods` VALUES ('205', '1', '现代简约书架书柜组合置物架', '', '杰瑞家具馆', '浙江', '', '', '<p>						</p><p><img src=\\\"/pic/upload/image/20160614/14658908671232433.jpg\\\" style=\\\"\\\" title=\\\"14658908671232433.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658908687616622.jpg\\\" style=\\\"\\\" title=\\\"14658908687616622.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658908731156261.jpg\\\" style=\\\"\\\" title=\\\"14658908731156261.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658908742892594.jpg\\\" style=\\\"\\\" title=\\\"14658908742892594.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658908831219606.jpg\\\" style=\\\"\\\" title=\\\"14658908831219606.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658908848216057.jpg\\\" style=\\\"\\\" title=\\\"14658908848216057.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658908861356538.jpg\\\" style=\\\"\\\" title=\\\"14658908861356538.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658908886319645.jpg\\\" style=\\\"\\\" title=\\\"14658908886319645.jpg\\\"/></p><p><br/></p>', '1', '10', '0.01', '0', '0.01', '126', '1', '1', '0', '0', '2016-05-30 17:45:56');
INSERT INTO `goods` VALUES ('206', '1', ' 现代简约书柜书架自由组合带门', '', ' OLOMA澳洛玛', '广东', '', '', '<p><img src=\\\"/pic/upload/image/20160614/14658905196997821.jpg\\\" style=\\\"\\\" title=\\\"14658905196997821.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658905191225372.jpg\\\" style=\\\"\\\" title=\\\"14658905191225372.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658905228603775.jpg\\\" style=\\\"\\\" title=\\\"14658905228603775.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658905251022993.jpg\\\" style=\\\"\\\" title=\\\"14658905251022993.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658905267398026.jpg\\\" style=\\\"\\\" title=\\\"14658905267398026.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658905293430067.jpg\\\" style=\\\"\\\" title=\\\"14658905293430067.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658905305496878.jpg\\\" style=\\\"\\\" title=\\\"14658905305496878.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658905327100244.jpg\\\" style=\\\"\\\" title=\\\"14658905327100244.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658905321266649.jpg\\\" style=\\\"\\\" title=\\\"14658905321266649.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/146589053667684610.jpg\\\" style=\\\"\\\" title=\\\"146589053667684610.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/146589054011660312.jpg\\\" style=\\\"\\\" title=\\\"146589054011660312.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/146589054174733213.jpg\\\" style=\\\"\\\" title=\\\"146589054174733213.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/146589054486003311.jpg\\\" style=\\\"\\\" title=\\\"146589054486003311.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/146589054511658114.jpg\\\" style=\\\"\\\" title=\\\"146589054511658114.jpg\\\"/></p><p><br/></p>', '1', '6', '0.01', '0', '0.01', '127', '1', '0', '0', '0', '2016-05-30 17:49:44');
INSERT INTO `goods` VALUES ('207', '1', '简易钢木书架书柜', '', ' 馨雨鑫佟', '北京', '', '', '<p>						</p><p><br/></p><p><br/></p><p><img src=\\\"/pic/upload/image/20160614/14658901146154831.jpg\\\" style=\\\"\\\" title=\\\"14658901146154831.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658901161323873.jpg\\\" style=\\\"\\\" title=\\\"14658901161323873.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658901221351542.jpg\\\" style=\\\"\\\" title=\\\"14658901221351542.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658901224291555.jpg\\\" style=\\\"\\\" title=\\\"14658901224291555.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658901261266294.jpg\\\" style=\\\"\\\" title=\\\"14658901261266294.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658901318006496.jpg\\\" style=\\\"\\\" title=\\\"14658901318006496.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658901321558187.jpg\\\" style=\\\"\\\" title=\\\"14658901321558187.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658901374149559.jpg\\\" style=\\\"\\\" title=\\\"14658901374149559.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/146589014411296710.jpg\\\" style=\\\"\\\" title=\\\"146589014411296710.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/146589014511415911.jpg\\\" style=\\\"\\\" title=\\\"146589014511415911.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/146589015010345713.jpg\\\" style=\\\"\\\" title=\\\"146589015010345713.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658901521169478.jpg\\\" style=\\\"\\\" title=\\\"14658901521169478.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/146589015519674112.jpg\\\" style=\\\"\\\" title=\\\"146589015519674112.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/146589016072405215.jpg\\\" style=\\\"\\\" title=\\\"146589016072405215.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/146589016212506314.jpg\\\" style=\\\"\\\" title=\\\"146589016212506314.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/146589016482960916.jpg\\\" style=\\\"\\\" title=\\\"146589016482960916.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/146589016912313918.jpg\\\" style=\\\"\\\" title=\\\"146589016912313918.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/146589017010516917.jpg\\\" style=\\\"\\\" title=\\\"146589017010516917.jpg\\\"/></p><p><br/></p><p><br/></p><p><br/></p><p><br/></p>', '1', '7', '0.01', '0', '0.01', '128', '3', '0', '0', '0', '2016-05-30 17:56:54');
INSERT INTO `goods` VALUES ('208', '1', '时尚简约吧椅吧凳升降 ', '', '屋の宝', '浙江', '', '', '<p><img src=\\\"/pic/upload/image/20160614/14658894975971082.jpg\\\" style=\\\"\\\" title=\\\"14658894975971082.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658894993524301.jpg\\\" style=\\\"\\\" title=\\\"14658894993524301.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658895012844404.jpg\\\" style=\\\"\\\" title=\\\"14658895012844404.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658895042248415.jpg\\\" style=\\\"\\\" title=\\\"14658895042248415.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658895041105743.jpg\\\" style=\\\"\\\" title=\\\"14658895041105743.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658895096859266.jpg\\\" style=\\\"\\\" title=\\\"14658895096859266.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658895191790128.jpg\\\" style=\\\"\\\" title=\\\"14658895191790128.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/146588952512307010.jpg\\\" style=\\\"\\\" title=\\\"146588952512307010.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658895279234629.jpg\\\" style=\\\"\\\" title=\\\"14658895279234629.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658895283476537.jpg\\\" style=\\\"\\\" title=\\\"14658895283476537.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/146588953420569111.jpg\\\" style=\\\"\\\" title=\\\"146588953420569111.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/146588953412111212.jpg\\\" style=\\\"\\\" title=\\\"146588953412111212.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/146588954244438913.jpg\\\" style=\\\"\\\" title=\\\"146588954244438913.jpg\\\"/></p><p><br/></p>', '1', '7', '0.01', '0', '0.01', '112', '1', '0', '0', '0', '2016-05-31 09:47:42');
INSERT INTO `goods` VALUES ('209', '1', '实木折叠椅简约现代家用布艺餐椅', '', ' sd/简域', '杭州', '', '', '<p>						</p><p><img src=\\\"/pic/upload/image/20160614/14658890691262503.jpg\\\" style=\\\"\\\" title=\\\"14658890691262503.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658890741049971.jpg\\\" style=\\\"\\\" title=\\\"14658890741049971.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658890758753092.jpg\\\" style=\\\"\\\" title=\\\"14658890758753092.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658890788732865.jpg\\\" style=\\\"\\\" title=\\\"14658890788732865.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658890835793364.jpg\\\" style=\\\"\\\" title=\\\"14658890835793364.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658890869481196.jpg\\\" style=\\\"\\\" title=\\\"14658890869481196.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658890871392728.jpg\\\" style=\\\"\\\" title=\\\"14658890871392728.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658890881605087.jpg\\\" style=\\\"\\\" title=\\\"14658890881605087.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658890923245889.jpg\\\" style=\\\"\\\" title=\\\"14658890923245889.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/146588909617053410.jpg\\\" style=\\\"\\\" title=\\\"146588909617053410.jpg\\\"/></p><p><br/></p>', '1', '3', '0.01', '0', '0.01', '113', '1', '1', '0', '0', '2016-05-31 09:52:08');
INSERT INTO `goods` VALUES ('210', '1', '人体工学椅椅子休闲椅转椅座椅 电脑椅', '', 'Hbada/黑白调', '越南', '', '', '<p><img src=\\\"/pic/upload/image/20160614/14658886933572491.jpg\\\" style=\\\"\\\" title=\\\"14658886933572491.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658886948068453.jpg\\\" style=\\\"\\\" title=\\\"14658886948068453.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658886991719544.jpg\\\" style=\\\"\\\" title=\\\"14658886991719544.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658887001199895.jpg\\\" style=\\\"\\\" title=\\\"14658887001199895.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658887059664506.jpg\\\" style=\\\"\\\" title=\\\"14658887059664506.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658887059284532.jpg\\\" style=\\\"\\\" title=\\\"14658887059284532.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658887086531367.jpg\\\" style=\\\"\\\" title=\\\"14658887086531367.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658887101322198.jpg\\\" style=\\\"\\\" title=\\\"14658887101322198.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/146588871217836610.jpg\\\" style=\\\"\\\" title=\\\"146588871217836610.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/146588871512002411.jpg\\\" style=\\\"\\\" title=\\\"146588871512002411.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658887151362819.jpg\\\" style=\\\"\\\" title=\\\"14658887151362819.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/146588871994162112.jpg\\\" style=\\\"\\\" title=\\\"146588871994162112.jpg\\\"/></p><p><br/></p>', '1', '5', '0.01', '0', '0.01', '114', '1', '0', '0', '0', '2016-05-31 09:57:17');
INSERT INTO `goods` VALUES ('211', '1', '老板椅可躺牛皮大班椅现代简约电脑椅座椅转椅办公椅', '', ' 施洛菲迪', '浙江', '', '', '<p><img src=\\\"/pic/upload/image/20160614/14658881571085133.jpg\\\" style=\\\"\\\" title=\\\"14658881571085133.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658881622578034.jpg\\\" style=\\\"\\\" title=\\\"14658881622578034.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658881662906792.jpg\\\" style=\\\"\\\" title=\\\"14658881662906792.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658881664157305.jpg\\\" style=\\\"\\\" title=\\\"14658881664157305.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658881697382106.jpg\\\" style=\\\"\\\" title=\\\"14658881697382106.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658881763132717.jpg\\\" style=\\\"\\\" title=\\\"14658881763132717.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658881761311998.jpg\\\" style=\\\"\\\" title=\\\"14658881761311998.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658881808560319.jpg\\\" style=\\\"\\\" title=\\\"14658881808560319.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658881841258331.jpg\\\" style=\\\"\\\" title=\\\"14658881841258331.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/146588818510655010.jpg\\\" style=\\\"\\\" title=\\\"146588818510655010.jpg\\\"/></p><p><br/></p>', '1', '50', '0.02', '0', '0.01', '115', '1', '0', '0', '0', '2016-05-31 10:03:45');
INSERT INTO `goods` VALUES ('212', '1', ' 象牙白书台 实木书台', '', '韩菲尔', '广东', '', '', null, '1', '10', '0.01', '0', null, '132', '2', '0', '0', '1', '2016-05-31 10:09:04');
INSERT INTO `goods` VALUES ('213', '1', '现代北欧实木书桌书房简约仿古办公台', '', '和购', '广东', '', '', '<p><img src=\\\"/pic/upload/image/20160614/14658877212124472.jpg\\\" style=\\\"\\\" title=\\\"14658877212124472.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658877268723403.jpg\\\" style=\\\"\\\" title=\\\"14658877268723403.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658877311418751.jpg\\\" style=\\\"\\\" title=\\\"14658877311418751.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658877421246805.jpg\\\" style=\\\"\\\" title=\\\"14658877421246805.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658877456254666.jpg\\\" style=\\\"\\\" title=\\\"14658877456254666.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658877519369304.jpg\\\" style=\\\"\\\" title=\\\"14658877519369304.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658877521161478.jpg\\\" style=\\\"\\\" title=\\\"14658877521161478.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658877535107017.jpg\\\" style=\\\"\\\" title=\\\"14658877535107017.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/146588776324360210.jpg\\\" style=\\\"\\\" title=\\\"146588776324360210.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/146588776388813211.jpg\\\" style=\\\"\\\" title=\\\"146588776388813211.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/146588776629765013.jpg\\\" style=\\\"\\\" title=\\\"146588776629765013.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658877668242739.jpg\\\" style=\\\"\\\" title=\\\"14658877668242739.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/146588776750170712.jpg\\\" style=\\\"\\\" title=\\\"146588776750170712.jpg\\\"/></p><p><br/></p>', '1', '10', '0.01', '0', '0.01', '132', '2', '0', '0', '0', '2016-05-31 10:09:47');
INSERT INTO `goods` VALUES ('214', '1', ' 象牙白书台 实木书台', '', '韩菲尔', '广东', '', '', null, '1', '10', '0.01', '0', null, '132', '2', '0', '0', '1', '2016-05-31 10:10:05');
INSERT INTO `goods` VALUES ('215', '1', '现代简约钢木书桌双人办公桌', '', ' 爱特屋', '广州', '', '', '<p><img src=\\\"/pic/upload/image/20160614/14658872098236283.jpg\\\" style=\\\"\\\" title=\\\"14658872098236283.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658872201297752.jpg\\\" style=\\\"\\\" title=\\\"14658872201297752.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658872223796691.jpg\\\" style=\\\"\\\" title=\\\"14658872223796691.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658872256699614.jpg\\\" style=\\\"\\\" title=\\\"14658872256699614.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658872328735886.jpg\\\" style=\\\"\\\" title=\\\"14658872328735886.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658872369251835.jpg\\\" style=\\\"\\\" title=\\\"14658872369251835.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658872407294317.jpg\\\" style=\\\"\\\" title=\\\"14658872407294317.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658872443618979.jpg\\\" style=\\\"\\\" title=\\\"14658872443618979.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/146588724645037010.jpg\\\" style=\\\"\\\" title=\\\"146588724645037010.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658872481223608.jpg\\\" style=\\\"\\\" title=\\\"14658872481223608.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/146588725157180611.jpg\\\" style=\\\"\\\" title=\\\"146588725157180611.jpg\\\"/></p><p><br/></p>', '1', '8', '0.01', '0', '0.01', '133', '2', '0', '0', '0', '2016-05-31 11:28:03');
INSERT INTO `goods` VALUES ('216', '1', '便携式小餐桌宜家电脑桌塑料小书桌', '', ' 方杰', '浙江杭州', '', '', '<p><img src=\\\"/pic/upload/image/20160531/146466594859263371.jpg\\\" style=\\\"\\\" title=\\\"146466594859263371.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160531/146466595910483470.jpg\\\" style=\\\"\\\" title=\\\"146466595910483470.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160531/146466596035819673.jpg\\\" style=\\\"\\\" title=\\\"146466596035819673.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160531/146466596799016172.jpg\\\" style=\\\"\\\" title=\\\"146466596799016172.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160531/146466597510874974.jpg\\\" style=\\\"\\\" title=\\\"146466597510874974.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160531/146466597974866677.jpg\\\" style=\\\"\\\" title=\\\"146466597974866677.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160531/146466598048393576.jpg\\\" style=\\\"\\\" title=\\\"146466598048393576.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160531/146466598993232675.jpg\\\" style=\\\"\\\" title=\\\"146466598993232675.jpg\\\"/></p><p><br/></p>', '1', '3', '0.01', '0', null, '135', '3', '0', '0', '0', '2016-05-31 11:40:46');
INSERT INTO `goods` VALUES ('217', '1', '实木框架现代六斗柜五斗橱卧室储物柜收纳柜', '', ' baymak', '北京', '', '', null, '1', '8', '0.02', '0', null, '129', '2', '0', '0', '1', '2016-05-31 11:47:22');
INSERT INTO `goods` VALUES ('218', '1', '实木框架现代六斗柜五斗橱卧室储物柜收纳柜', '', ' baymak', '北京', '', '', '<p><img src=\\\"/pic/upload/image/20160531/146466638045247978.jpg\\\" style=\\\"\\\" title=\\\"146466638045247978.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160531/146466638310276480.jpg\\\" style=\\\"\\\" title=\\\"146466638310276480.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160531/146466638578335081.jpg\\\" style=\\\"\\\" title=\\\"146466638578335081.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160531/146466638713248182.jpg\\\" style=\\\"\\\" title=\\\"146466638713248182.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160531/146466638812601479.jpg\\\" style=\\\"\\\" title=\\\"146466638812601479.jpg\\\"/></p><p><br/></p>', '1', '8', '0.02', '0', null, '129', '2', '0', '0', '1', '2016-05-31 11:47:53');
INSERT INTO `goods` VALUES ('219', '1', '实木框架现代六斗柜五斗橱卧室储物柜收纳柜', '', ' baymak', '北京', '', '', '<p><img src=\\\"/pic/upload/image/20160531/146466638045247978.jpg\\\" style=\\\"\\\" title=\\\"146466638045247978.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160531/146466638310276480.jpg\\\" style=\\\"\\\" title=\\\"146466638310276480.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160531/146466638578335081.jpg\\\" style=\\\"\\\" title=\\\"146466638578335081.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160531/146466638713248182.jpg\\\" style=\\\"\\\" title=\\\"146466638713248182.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160531/146466638812601479.jpg\\\" style=\\\"\\\" title=\\\"146466638812601479.jpg\\\"/></p><p><br/></p>', '1', '8', '0.02', '0', null, '129', '2', '0', '0', '0', '2016-05-31 11:48:14');
INSERT INTO `goods` VALUES ('220', '1', '日本大号4层衣物可叠加塑料组合收纳柜', '', 'IRIS/爱丽思', '江苏苏州', '', '', '<p>						</p><p><img src=\\\"/pic/upload/image/20160531/146466676274285783.jpg\\\" style=\\\"\\\" title=\\\"146466676274285783.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160531/146466676712780885.jpg\\\" style=\\\"\\\" title=\\\"146466676712780885.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160531/146466676849710387.jpg\\\" style=\\\"\\\" title=\\\"146466676849710387.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160531/146466677597621889.jpg\\\" style=\\\"\\\" title=\\\"146466677597621889.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160531/146466677645725584.jpg\\\" style=\\\"\\\" title=\\\"146466677645725584.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160531/146466677951272388.jpg\\\" style=\\\"\\\" title=\\\"146466677951272388.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160531/146466678155295890.jpg\\\" style=\\\"\\\" title=\\\"146466678155295890.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160531/146466678613582591.jpg\\\" style=\\\"\\\" title=\\\"146466678613582591.jpg\\\"/></p><p><br/></p>', '1', '4', '0.20', '0', '0.01', '130', '3', '0', '0', '0', '2016-05-31 11:53:43');
INSERT INTO `goods` VALUES ('221', '1', '现代简约床头柜日式床边柜小户型布艺储物简易收纳柜', '', '林氏', '浙江', '', '', '<p><img src=\\\"/pic/upload/image/20160614/14658867456527921.jpg\\\" style=\\\"\\\" title=\\\"14658867456527921.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658867499092613.jpg\\\" style=\\\"\\\" title=\\\"14658867499092613.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658867521237462.jpg\\\" style=\\\"\\\" title=\\\"14658867521237462.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658867571289925.jpg\\\" style=\\\"\\\" title=\\\"14658867571289925.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658867572500574.jpg\\\" style=\\\"\\\" title=\\\"14658867572500574.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658867631354686.jpg\\\" style=\\\"\\\" title=\\\"14658867631354686.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658867648301267.jpg\\\" style=\\\"\\\" title=\\\"14658867648301267.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658867682100389.jpg\\\" style=\\\"\\\" title=\\\"14658867682100389.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658867731469108.jpg\\\" style=\\\"\\\" title=\\\"14658867731469108.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/146588677521933210.jpg\\\" style=\\\"\\\" title=\\\"146588677521933210.jpg\\\"/></p><p><br/></p>', '1', '10', '0.01', '0', '0.01', '131', '4', '0', '0', '0', '2016-05-31 12:00:10');
INSERT INTO `goods` VALUES ('222', '1', '雅思洛子母床实木双层床女孩地中海高低床', '', '雅思洛', ' 广东省', '', '', '<p>						</p><p><img src=\\\"/pic/upload/image/20160531/146466767524097899.jpg\\\" style=\\\"\\\" title=\\\"146466767524097899.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160531/146466767633861798.jpg\\\" style=\\\"\\\" title=\\\"146466767633861798.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160531/1464667686248293100.jpg\\\" style=\\\"\\\" title=\\\"1464667686248293100.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160531/1464667690102957101.jpg\\\" style=\\\"\\\" title=\\\"1464667690102957101.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160531/1464667701101133104.jpg\\\" style=\\\"\\\" title=\\\"1464667701101133104.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160531/1464667702110174102.jpg\\\" style=\\\"\\\" title=\\\"1464667702110174102.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160531/1464667732321146103.jpg\\\" style=\\\"\\\" title=\\\"1464667732321146103.jpg\\\"/></p><p><br/></p>', '1', '20', '0.02', '0', '0.01', '142', '2', '1', '0', '0', '2016-05-31 12:09:39');
INSERT INTO `goods` VALUES ('223', '1', '实木儿童床上下铺双层床', '', '彬飞纯', '江苏徐州', '', '', '<p>						</p><p><img src=\\\"/pic/upload/image/20160531/1464668102121039107.jpg\\\" style=\\\"\\\" title=\\\"1464668102121039107.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160531/1464668106163951106.jpg\\\" style=\\\"\\\" title=\\\"1464668106163951106.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160531/1464668110114447105.jpg\\\" style=\\\"\\\" title=\\\"1464668110114447105.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160531/1464668117100255110.jpg\\\" style=\\\"\\\" title=\\\"1464668117100255110.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160531/1464668118113870108.jpg\\\" style=\\\"\\\" title=\\\"1464668118113870108.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160531/1464668119470208109.jpg\\\" style=\\\"\\\" title=\\\"1464668119470208109.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160531/1464668127103848112.jpg\\\" style=\\\"\\\" title=\\\"1464668127103848112.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160531/1464668129333926111.jpg\\\" style=\\\"\\\" title=\\\"1464668129333926111.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160531/1464668129254446113.jpg\\\" style=\\\"\\\" title=\\\"1464668129254446113.jpg\\\"/></p><p><br/></p>', '1', '30', '0.02', '0', '0.01', '143', '3', '0', '0', '0', '2016-05-31 12:16:23');
INSERT INTO `goods` VALUES ('224', '1', '卡通衣柜儿童宝宝婴儿收纳柜', '', '麦田', '浙江', '', '', '<p><img src=\\\"/pic/upload/image/20160531/1464673554478298116.jpg\\\" style=\\\"\\\" title=\\\"1464673554478298116.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160531/1464673556680332114.jpg\\\" style=\\\"\\\" title=\\\"1464673556680332114.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160531/1464673556135890115.jpg\\\" style=\\\"\\\" title=\\\"1464673556135890115.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160531/1464673563342188118.jpg\\\" style=\\\"\\\" title=\\\"1464673563342188118.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160531/1464673566742255117.jpg\\\" style=\\\"\\\" title=\\\"1464673566742255117.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160531/1464673584127847120.jpg\\\" style=\\\"\\\" title=\\\"1464673584127847120.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160531/1464673605311033119.jpg\\\" style=\\\"\\\" title=\\\"1464673605311033119.jpg\\\"/></p><p><br/></p>', '1', '10', '0.01', '0', null, '372', '2', '0', '0', '0', '2016-05-31 13:47:23');
INSERT INTO `goods` VALUES ('225', '1', '北欧宜家全实木学习桌 电脑桌简约书桌', '', '聚新', '上海', '', '', '<p><img src=\\\"/pic/upload/image/20160614/14658863891085041.jpg\\\" style=\\\"\\\" title=\\\"14658863891085041.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658863966463373.jpg\\\" style=\\\"\\\" title=\\\"14658863966463373.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658863981123642.jpg\\\" style=\\\"\\\" title=\\\"14658863981123642.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658863991357524.jpg\\\" style=\\\"\\\" title=\\\"14658863991357524.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658864011195167.jpg\\\" style=\\\"\\\" title=\\\"14658864011195167.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658864071085995.jpg\\\" style=\\\"\\\" title=\\\"14658864071085995.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658864093491168.jpg\\\" style=\\\"\\\" title=\\\"14658864093491168.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/146588641317724710.jpg\\\" style=\\\"\\\" title=\\\"146588641317724710.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658864144362999.jpg\\\" style=\\\"\\\" title=\\\"14658864144362999.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658864161081476.jpg\\\" style=\\\"\\\" title=\\\"14658864161081476.jpg\\\"/></p><p><br/></p>', '1', '10', '0.01', '0', '0.01', '373', '3', '0', '0', '0', '2016-05-31 13:53:08');
INSERT INTO `goods` VALUES ('226', '1', '儿童学习椅 学生靠背椅子矫姿椅可升降', '', '爱果乐', '江苏苏州', '', '', '<p><img src=\\\"/pic/upload/image/20160531/1464674257439526125.jpg\\\" style=\\\"\\\" title=\\\"1464674257439526125.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160531/1464674263508592124.jpg\\\" style=\\\"\\\" title=\\\"1464674263508592124.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160531/1464674263125820127.jpg\\\" style=\\\"\\\" title=\\\"1464674263125820127.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160531/1464674269879397126.jpg\\\" style=\\\"\\\" title=\\\"1464674269879397126.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160531/1464674277556400129.jpg\\\" style=\\\"\\\" title=\\\"1464674277556400129.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160531/1464674277101839128.jpg\\\" style=\\\"\\\" title=\\\"1464674277101839128.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160531/1464674277110303130.jpg\\\" style=\\\"\\\" title=\\\"1464674277110303130.jpg\\\"/></p><p><br/></p>', '1', '10', '0.01', '0', null, '374', '5', '0', '0', '0', '2016-05-31 13:58:48');
INSERT INTO `goods` VALUES ('227', '1', '床垫组合 真皮床 双人床 椰棕床垫 现代简约床', '', '七思', '广东', '', '', '<p><img src=\\\"/pic/upload/image/20160614/14658859238338691.jpg\\\" style=\\\"\\\" title=\\\"14658859238338691.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658859268496622.jpg\\\" style=\\\"\\\" title=\\\"14658859268496622.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658859281114913.jpg\\\" style=\\\"\\\" title=\\\"14658859281114913.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658859368099874.jpg\\\" style=\\\"\\\" title=\\\"14658859368099874.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658859412096076.jpg\\\" style=\\\"\\\" title=\\\"14658859412096076.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658859441287387.jpg\\\" style=\\\"\\\" title=\\\"14658859441287387.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658859452904218.jpg\\\" style=\\\"\\\" title=\\\"14658859452904218.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658859491312429.jpg\\\" style=\\\"\\\" title=\\\"14658859491312429.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658859566003795.jpg\\\" style=\\\"\\\" title=\\\"14658859566003795.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/146588595820354011.jpg\\\" style=\\\"\\\" title=\\\"146588595820354011.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/146588596297643410.jpg\\\" style=\\\"\\\" title=\\\"146588596297643410.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/146588596412447312.jpg\\\" style=\\\"\\\" title=\\\"146588596412447312.jpg\\\"/></p><p><br/></p>', '1', '10', '0.01', '0', '0.01', '375', '4', '0', '0', '0', '2016-05-31 14:04:30');
INSERT INTO `goods` VALUES ('228', '1', '意大利原装进口天然乳胶床垫', '', 'LEPOZE/利普兹·寝具', '广东', '', '', '<p><img src=\\\"/pic/upload/image/20160614/14658853242100811.jpg\\\" style=\\\"\\\" title=\\\"14658853242100811.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658853284202052.jpg\\\" style=\\\"\\\" title=\\\"14658853284202052.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658853303871993.jpg\\\" style=\\\"\\\" title=\\\"14658853303871993.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658853316706074.jpg\\\" style=\\\"\\\" title=\\\"14658853316706074.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658853321025366.jpg\\\" style=\\\"\\\" title=\\\"14658853321025366.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658853411384377.jpg\\\" style=\\\"\\\" title=\\\"14658853411384377.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658853428633038.jpg\\\" style=\\\"\\\" title=\\\"14658853428633038.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658853451405979.jpg\\\" style=\\\"\\\" title=\\\"14658853451405979.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658853487826625.jpg\\\" style=\\\"\\\" title=\\\"14658853487826625.jpg\\\"/></p><p><br/></p>', '1', '10', '0.02', '0', '0.01', '376', '2', '0', '0', '0', '2016-05-31 14:09:26');
INSERT INTO `goods` VALUES ('229', '1', '现代简约推拉门衣柜', '', '克莱屋klive', '广东', '', '', '<p><img src=\\\"/pic/upload/image/20160614/14658846581131641.jpg\\\" style=\\\"\\\" title=\\\"14658846581131641.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658846598142043.jpg\\\" style=\\\"\\\" title=\\\"14658846598142043.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658846653997652.jpg\\\" style=\\\"\\\" title=\\\"14658846653997652.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658846664892284.jpg\\\" style=\\\"\\\" title=\\\"14658846664892284.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658846673170585.jpg\\\" style=\\\"\\\" title=\\\"14658846673170585.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658846691879196.jpg\\\" style=\\\"\\\" title=\\\"14658846691879196.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658846733045358.jpg\\\" style=\\\"\\\" title=\\\"14658846733045358.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658846755786057.jpg\\\" style=\\\"\\\" title=\\\"14658846755786057.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/146588467951960811.jpg\\\" style=\\\"\\\" title=\\\"146588467951960811.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/146588467767697510.jpg\\\" style=\\\"\\\" title=\\\"146588467767697510.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658846861317079.jpg\\\" style=\\\"\\\" title=\\\"14658846861317079.jpg\\\"/></p><p><br/></p>', '1', '30', '0.02', '0', '0.01', '65', '3', '0', '0', '0', '2016-05-31 14:13:46');
INSERT INTO `goods` VALUES ('230', '1', '现代简约烤漆五斗柜', '', '红宝石鞋柜', '山东', '', '', '<p>						</p><p><img src=\\\"/pic/upload/image/20160614/14658765901078803.jpg\\\" style=\\\"\\\" title=\\\"14658765901078803.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658765911039082.jpg\\\" style=\\\"\\\" title=\\\"14658765911039082.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658765936699614.jpg\\\" style=\\\"\\\" title=\\\"14658765936699614.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658765977294315.jpg\\\" style=\\\"\\\" title=\\\"14658765977294315.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658766009369301.jpg\\\" style=\\\"\\\" title=\\\"14658766009369301.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658766051201966.jpg\\\" style=\\\"\\\" title=\\\"14658766051201966.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658766064128037.jpg\\\" style=\\\"\\\" title=\\\"14658766064128037.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658766088242738.jpg\\\" style=\\\"\\\" title=\\\"14658766088242738.jpg\\\"/></p><p><br/></p>', '1', '15', '0.01', '0', '0.01', '66', '3', '1', '0', '0', '2016-05-31 14:18:32');
INSERT INTO `goods` VALUES ('231', '1', '北欧客厅角柜现代简约小户型边角柜', '', '林氏木业', '广东', '', '', '<p><img src=\\\"/pic/upload/image/20160614/14658761388179053.jpg\\\" style=\\\"\\\" title=\\\"14658761388179053.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658761411164002.jpg\\\" style=\\\"\\\" title=\\\"14658761411164002.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658761454195594.jpg\\\" style=\\\"\\\" title=\\\"14658761454195594.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658761521250506.jpg\\\" style=\\\"\\\" title=\\\"14658761521250506.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658761618730717.jpg\\\" style=\\\"\\\" title=\\\"14658761618730717.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658761614182255.jpg\\\" style=\\\"\\\" title=\\\"14658761614182255.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658761724303211.jpg\\\" style=\\\"\\\" title=\\\"14658761724303211.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658761725524858.jpg\\\" style=\\\"\\\" title=\\\"14658761725524858.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658761751237469.jpg\\\" style=\\\"\\\" title=\\\"14658761751237469.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/146587617883012612.jpg\\\" style=\\\"\\\" title=\\\"146587617883012612.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/146587618133586310.jpg\\\" style=\\\"\\\" title=\\\"146587618133586310.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/146587618415018011.jpg\\\" style=\\\"\\\" title=\\\"146587618415018011.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/146587619410195513.jpg\\\" style=\\\"\\\" title=\\\"146587619410195513.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/146587619753871414.jpg\\\" style=\\\"\\\" title=\\\"146587619753871414.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/146587619881256916.jpg\\\" style=\\\"\\\" title=\\\"146587619881256916.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/146587620137386015.jpg\\\" style=\\\"\\\" title=\\\"146587620137386015.jpg\\\"/></p><p><br/></p>', '1', '10', '0.01', '0', '0.01', '67', '3', '0', '0', '0', '2016-05-31 14:23:19');
INSERT INTO `goods` VALUES ('232', '1', '北欧胡桃木风格床头柜 现代简约 ', '', ' 思纳博', '广东', '', '', '<p><img src=\\\"/pic/upload/image/20160614/14658756691514283.jpg\\\" style=\\\"\\\" title=\\\"14658756691514283.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658756766584291.jpg\\\" style=\\\"\\\" title=\\\"14658756766584291.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658756739136072.jpg\\\" style=\\\"\\\" title=\\\"14658756739136072.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658756813506654.jpg\\\" style=\\\"\\\" title=\\\"14658756813506654.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658756911299865.jpg\\\" style=\\\"\\\" title=\\\"14658756911299865.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658756943116797.jpg\\\" style=\\\"\\\" title=\\\"14658756943116797.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658757037805538.jpg\\\" style=\\\"\\\" title=\\\"14658757037805538.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658757071080489.jpg\\\" style=\\\"\\\" title=\\\"14658757071080489.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/146587571110632711.jpg\\\" style=\\\"\\\" title=\\\"146587571110632711.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/146587571512680112.jpg\\\" style=\\\"\\\" title=\\\"146587571512680112.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/146587571751823113.jpg\\\" style=\\\"\\\" title=\\\"146587571751823113.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658757221105096.jpg\\\" style=\\\"\\\" title=\\\"14658757221105096.jpg\\\"/></p><p><br/></p>', '1', '5', '0.01', '0', '0.01', '68', '6', '0', '0', '0', '2016-05-31 14:28:43');
INSERT INTO `goods` VALUES ('233', '1', '简约现代穿衣镜子卧室试衣镜简约现代穿衣镜子卧室试衣镜', '', '众想', '浙江', '', '', '<p>						</p><p><img src=\\\"/pic/upload/image/20160614/14658750417691931.jpg\\\" style=\\\"\\\" title=\\\"14658750417691931.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658750434690462.jpg\\\" style=\\\"\\\" title=\\\"14658750434690462.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658750482547914.jpg\\\" style=\\\"\\\" title=\\\"14658750482547914.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658750548649383.jpg\\\" style=\\\"\\\" title=\\\"14658750548649383.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658750572334905.jpg\\\" style=\\\"\\\" title=\\\"14658750572334905.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658750583273426.jpg\\\" style=\\\"\\\" title=\\\"14658750583273426.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658750634410327.jpg\\\" style=\\\"\\\" title=\\\"14658750634410327.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/146587506912010610.jpg\\\" style=\\\"\\\" title=\\\"146587506912010610.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658750721013488.jpg\\\" style=\\\"\\\" title=\\\"14658750721013488.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/146587507811917612.jpg\\\" style=\\\"\\\" title=\\\"146587507811917612.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/146587508048066511.jpg\\\" style=\\\"\\\" title=\\\"146587508048066511.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/146587508291033713.jpg\\\" style=\\\"\\\" title=\\\"146587508291033713.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/146587508710297514.jpg\\\" style=\\\"\\\" title=\\\"146587508710297514.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658751139087459.jpg\\\" style=\\\"\\\" title=\\\"14658751139087459.jpg\\\"/></p><p><br/></p>', '1', '8', '0.02', '0', '0.01', '69', '5', '1', '0', '0', '2016-05-31 14:37:15');
INSERT INTO `goods` VALUES ('234', '1', '现代简约小户型梳妆台', '', '睿酷空间', '广东', '', '', '<p><img src=\\\"/pic/upload/image/20160614/14658745361378863.jpg\\\" style=\\\"\\\" title=\\\"14658745361378863.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658745361013091.jpg\\\" style=\\\"\\\" title=\\\"14658745361013091.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658745391110435.jpg\\\" style=\\\"\\\" title=\\\"14658745391110435.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658745428276304.jpg\\\" style=\\\"\\\" title=\\\"14658745428276304.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658745468792682.jpg\\\" style=\\\"\\\" title=\\\"14658745468792682.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658745485684067.jpg\\\" style=\\\"\\\" title=\\\"14658745485684067.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658745531455768.jpg\\\" style=\\\"\\\" title=\\\"14658745531455768.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658745597113586.jpg\\\" style=\\\"\\\" title=\\\"14658745597113586.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/146587456326494611.jpg\\\" style=\\\"\\\" title=\\\"146587456326494611.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658745648627879.jpg\\\" style=\\\"\\\" title=\\\"14658745648627879.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/146587456571635010.jpg\\\" style=\\\"\\\" title=\\\"146587456571635010.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/146587456711585412.jpg\\\" style=\\\"\\\" title=\\\"146587456711585412.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/146587456912211913.jpg\\\" style=\\\"\\\" title=\\\"146587456912211913.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/146587457584071115.jpg\\\" style=\\\"\\\" title=\\\"146587457584071115.jpg\\\"/></p><p><br/></p>', '1', '12', '0.01', '0', '0.01', '70', '6', '0', '0', '0', '2016-05-31 14:42:02');
INSERT INTO `goods` VALUES ('235', '1', '现代简约时尚海绵床垫弹簧床垫', '', ' 法丽莎', '四川成都 ', '', '', '<p><img src=\\\"/pic/upload/image/20160614/14658741195920741.jpg\\\" style=\\\"\\\" title=\\\"14658741195920741.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658741207940652.jpg\\\" style=\\\"\\\" title=\\\"14658741207940652.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658741211223393.jpg\\\" style=\\\"\\\" title=\\\"14658741211223393.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658741221678234.jpg\\\" style=\\\"\\\" title=\\\"14658741221678234.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658741241212896.jpg\\\" style=\\\"\\\" title=\\\"14658741241212896.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658741255865665.jpg\\\" style=\\\"\\\" title=\\\"14658741255865665.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658741278053399.jpg\\\" style=\\\"\\\" title=\\\"14658741278053399.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658741289179968.jpg\\\" style=\\\"\\\" title=\\\"14658741289179968.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/146587413688753010.jpg\\\" style=\\\"\\\" title=\\\"146587413688753010.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/146587413710893411.jpg\\\" style=\\\"\\\" title=\\\"146587413710893411.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658741391127567.jpg\\\" style=\\\"\\\" title=\\\"14658741391127567.jpg\\\"/></p><p><br/></p>', '1', '15', '0.01', '0', '0.01', '61', '6', '0', '0', '0', '2016-05-31 14:46:42');
INSERT INTO `goods` VALUES ('236', '1', '进口天然乳胶床垫', '', 'bell land/珀兰', '广东', '', '', '<p><img src=\\\"/pic/upload/image/20160531/1464677385972303184.jpg\\\" style=\\\"\\\" title=\\\"1464677385972303184.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160531/1464677389909261182.jpg\\\" style=\\\"\\\" title=\\\"1464677389909261182.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160531/1464677397210984186.jpg\\\" style=\\\"\\\" title=\\\"1464677397210984186.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160531/1464677400420850183.jpg\\\" style=\\\"\\\" title=\\\"1464677400420850183.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160531/1464677401264086185.jpg\\\" style=\\\"\\\" title=\\\"1464677401264086185.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160531/1464677406107695187.jpg\\\" style=\\\"\\\" title=\\\"1464677406107695187.jpg\\\"/></p><p><br/></p>', '1', '13', '0.01', '0', null, '62', '5', '0', '0', '0', '2016-05-31 14:50:49');
INSERT INTO `goods` VALUES ('237', '1', ' 天然山棕床垫现代简约独立袋装弹簧', '', ' 康博皇朝', '四川', '', '', '<p><img src=\\\"/pic/upload/image/20160614/14658736361169173.jpg\\\" style=\\\"\\\" title=\\\"14658736361169173.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658736379647722.jpg\\\" style=\\\"\\\" title=\\\"14658736379647722.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658736491080261.jpg\\\" style=\\\"\\\" title=\\\"14658736491080261.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658736502466154.jpg\\\" style=\\\"\\\" title=\\\"14658736502466154.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658736559154157.jpg\\\" style=\\\"\\\" title=\\\"14658736559154157.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658736597672136.jpg\\\" style=\\\"\\\" title=\\\"14658736597672136.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658736601130225.jpg\\\" style=\\\"\\\" title=\\\"14658736601130225.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658736626325678.jpg\\\" style=\\\"\\\" title=\\\"14658736626325678.jpg\\\"/></p><p><br/></p>', '1', '15', '0.01', '0', '0.01', '63', '3', '0', '0', '0', '2016-05-31 14:55:03');
INSERT INTO `goods` VALUES ('238', '1', '加厚海绵床垫', '', ' MLILY', '江苏南通', '', '', '<p><img src=\\\"/pic/upload/image/20160531/1464677932138222195.jpg\\\" style=\\\"\\\" title=\\\"1464677932138222195.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160531/1464677935124611194.jpg\\\" style=\\\"\\\" title=\\\"1464677935124611194.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160531/1464677940959737196.jpg\\\" style=\\\"\\\" title=\\\"1464677940959737196.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160531/1464677940647327193.jpg\\\" style=\\\"\\\" title=\\\"1464677940647327193.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160531/1464677942498394197.jpg\\\" style=\\\"\\\" title=\\\"1464677942498394197.jpg\\\"/></p><p><br/></p>', '1', '13', '0.01', '0', null, '64', '6', '0', '0', '0', '2016-05-31 14:59:42');
INSERT INTO `goods` VALUES ('239', '1', '全实木床板式床现代简约双人床', '', ' 奔斯', '广东', '', '', '<p>						</p><p><img src=\\\"/pic/upload/image/20160614/14658732331287981.jpg\\\" style=\\\"\\\" title=\\\"14658732331287981.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658732431155363.jpg\\\" style=\\\"\\\" title=\\\"14658732431155363.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658732446320934.jpg\\\" style=\\\"\\\" title=\\\"14658732446320934.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658732481229845.jpg\\\" style=\\\"\\\" title=\\\"14658732481229845.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658732561036206.jpg\\\" style=\\\"\\\" title=\\\"14658732561036206.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658732621238718.jpg\\\" style=\\\"\\\" title=\\\"14658732621238718.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658732668268127.jpg\\\" style=\\\"\\\" title=\\\"14658732668268127.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658732678069319.jpg\\\" style=\\\"\\\" title=\\\"14658732678069319.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/146587327237170811.jpg\\\" style=\\\"\\\" title=\\\"146587327237170811.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/146587327412864310.jpg\\\" style=\\\"\\\" title=\\\"146587327412864310.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/146587327682879212.jpg\\\" style=\\\"\\\" title=\\\"146587327682879212.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/146587327913360014.jpg\\\" style=\\\"\\\" title=\\\"146587327913360014.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/146587327955205413.jpg\\\" style=\\\"\\\" title=\\\"146587327955205413.jpg\\\"/></p><p><br/></p>', '1', '20', '0.01', '0', '0.01', '54', '6', '0', '0', '1', '2016-05-31 15:08:01');
INSERT INTO `goods` VALUES ('240', '1', ' 北欧韩式简约现代1.8米双人皮艺床储物小户型', '', ' 简欧宫庭', '广东', '', '', '<p>						</p><p><img src=\\\"/pic/upload/image/20160614/14658728385443953.jpg\\\" style=\\\"\\\" title=\\\"14658728385443953.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658728404676261.jpg\\\" style=\\\"\\\" title=\\\"14658728404676261.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658728431364884.jpg\\\" style=\\\"\\\" title=\\\"14658728431364884.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658728485029982.jpg\\\" style=\\\"\\\" title=\\\"14658728485029982.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658728531235015.jpg\\\" style=\\\"\\\" title=\\\"14658728531235015.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658728541352877.jpg\\\" style=\\\"\\\" title=\\\"14658728541352877.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658728622059508.jpg\\\" style=\\\"\\\" title=\\\"14658728622059508.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658728644807519.jpg\\\" style=\\\"\\\" title=\\\"14658728644807519.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/146587286913593311.jpg\\\" style=\\\"\\\" title=\\\"146587286913593311.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/146587287494187910.jpg\\\" style=\\\"\\\" title=\\\"146587287494187910.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/146587287640492912.jpg\\\" style=\\\"\\\" title=\\\"146587287640492912.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658728767472036.jpg\\\" style=\\\"\\\" title=\\\"14658728767472036.jpg\\\"/></p><p><br/></p>', '1', '13', '0.02', '0', '0.01', '55', '5', '1', '0', '0', '2016-05-31 15:13:07');
INSERT INTO `goods` VALUES ('241', '1', '全实木儿童床上下床双层床女孩公主床', '', '豆丁森邻', '东莞市', '', '', '<p><img src=\\\"/pic/upload/image/20160531/1464679165654255209.jpg\\\" style=\\\"\\\" title=\\\"1464679165654255209.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160531/1464679168104971207.jpg\\\" style=\\\"\\\" title=\\\"1464679168104971207.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160531/1464679177933273301.jpg\\\" style=\\\"\\\" title=\\\"1464679177933273301.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160531/1464679184292013302.jpg\\\" style=\\\"\\\" title=\\\"1464679184292013302.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160531/1464679187861539304.jpg\\\" style=\\\"\\\" title=\\\"1464679187861539304.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160531/1464679189527053303.jpg\\\" style=\\\"\\\" title=\\\"1464679189527053303.jpg\\\"/></p><p><br/></p>', '1', '50', '0.01', '0', null, '57', '2', '0', '0', '0', '2016-05-31 15:20:40');
INSERT INTO `goods` VALUES ('242', '1', '板式床现代简约双人床', '', '奔斯', '广东', '', '', '<p>						</p><p><img src=\\\"/pic/upload/image/20160614/14658723021213532.jpg\\\" style=\\\"\\\" title=\\\"14658723021213532.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658723041971281.jpg\\\" style=\\\"\\\" title=\\\"14658723041971281.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658723091582703.jpg\\\" style=\\\"\\\" title=\\\"14658723091582703.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658723141345605.jpg\\\" style=\\\"\\\" title=\\\"14658723141345605.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658723151226194.jpg\\\" style=\\\"\\\" title=\\\"14658723151226194.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658723177762936.jpg\\\" style=\\\"\\\" title=\\\"14658723177762936.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658723251330549.jpg\\\" style=\\\"\\\" title=\\\"14658723251330549.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658723297479357.jpg\\\" style=\\\"\\\" title=\\\"14658723297479357.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/146587233552236211.jpg\\\" style=\\\"\\\" title=\\\"146587233552236211.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/146587233555536810.jpg\\\" style=\\\"\\\" title=\\\"146587233555536810.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/146587233811388312.jpg\\\" style=\\\"\\\" title=\\\"146587233811388312.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/146587234552008213.jpg\\\" style=\\\"\\\" title=\\\"146587234552008213.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/146587234687784814.jpg\\\" style=\\\"\\\" title=\\\"146587234687784814.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658723554049298.jpg\\\" style=\\\"\\\" title=\\\"14658723554049298.jpg\\\"/></p><p><br/></p>', '1', '40', '0.02', '0', '0.01', '58', '6', '1', '0', '0', '2016-05-31 15:24:59');
INSERT INTO `goods` VALUES ('243', '1', '豪华植绒立柱靠背充气床垫 双人加厚加大气垫床户外折叠床', '', ' 阿尔法', '江苏苏州', '', '', '<p><img src=\\\"/pic/upload/image/20160614/14658718768736311.jpg\\\" style=\\\"\\\" title=\\\"14658718768736311.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658718765230512.jpg\\\" style=\\\"\\\" title=\\\"14658718765230512.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658718791044815.jpg\\\" style=\\\"\\\" title=\\\"14658718791044815.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658718801535804.jpg\\\" style=\\\"\\\" title=\\\"14658718801535804.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658718861382003.jpg\\\" style=\\\"\\\" title=\\\"14658718861382003.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658718872021636.jpg\\\" style=\\\"\\\" title=\\\"14658718872021636.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658718909578447.jpg\\\" style=\\\"\\\" title=\\\"14658718909578447.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658718919151138.jpg\\\" style=\\\"\\\" title=\\\"14658718919151138.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658718961015249.jpg\\\" style=\\\"\\\" title=\\\"14658718961015249.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/146587190272052410.jpg\\\" style=\\\"\\\" title=\\\"146587190272052410.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/146587190313756311.jpg\\\" style=\\\"\\\" title=\\\"146587190313756311.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/146587190414660912.jpg\\\" style=\\\"\\\" title=\\\"146587190414660912.jpg\\\"/></p><p><br/></p>', '1', '15', '0.01', '0', '0.01', '59', '5', '0', '0', '0', '2016-05-31 15:29:05');
INSERT INTO `goods` VALUES ('244', '1', '户外露营充气床', '', 'Decathlon/迪卡侬', '江苏苏州', '', '', null, '1', '15', '0.01', '0', null, '59', '5', '0', '0', '1', '2016-05-31 15:29:12');
INSERT INTO `goods` VALUES ('245', '1', '户外露营充气床', '', 'Decathlon/迪卡侬', '江苏苏州', '', '', '<p><img src=\\\"/pic/upload/image/20160531/1464679708104037313.jpg\\\" style=\\\"\\\" title=\\\"1464679708104037313.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160531/1464679709483677312.jpg\\\" style=\\\"\\\" title=\\\"1464679709483677312.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160531/1464679716102234315.jpg\\\" style=\\\"\\\" title=\\\"1464679716102234315.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160531/1464679717846478314.jpg\\\" style=\\\"\\\" title=\\\"1464679717846478314.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160531/1464679724150180311.jpg\\\" style=\\\"\\\" title=\\\"1464679724150180311.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160531/1464679725209134316.jpg\\\" style=\\\"\\\" title=\\\"1464679725209134316.jpg\\\"/></p><p><br/></p>', '1', '15', '0.01', '0', null, '59', '5', '0', '0', '1', '2016-05-31 15:29:18');
INSERT INTO `goods` VALUES ('246', '1', '美式沙发床法式复古欧式现代简约布艺沙发客厅两样布艺折叠床', '', '舒戈', '江苏常州', '', '', '<p><img src=\\\"/pic/upload/image/20160614/14658709181078373.jpg\\\" style=\\\"\\\" title=\\\"14658709181078373.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658709196126862.jpg\\\" style=\\\"\\\" title=\\\"14658709196126862.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658709304266171.jpg\\\" style=\\\"\\\" title=\\\"14658709304266171.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658709371259105.jpg\\\" style=\\\"\\\" title=\\\"14658709371259105.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658709371112714.jpg\\\" style=\\\"\\\" title=\\\"14658709371112714.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658709451143916.jpg\\\" style=\\\"\\\" title=\\\"14658709451143916.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658709535250738.jpg\\\" style=\\\"\\\" title=\\\"14658709535250738.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658709531022099.jpg\\\" style=\\\"\\\" title=\\\"14658709531022099.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658709556203467.jpg\\\" style=\\\"\\\" title=\\\"14658709556203467.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/146587095866290410.jpg\\\" style=\\\"\\\" title=\\\"146587095866290410.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/146587096312836311.jpg\\\" style=\\\"\\\" title=\\\"146587096312836311.jpg\\\"/></p><p><br/></p>', '1', '20', '0.01', '0', '0.01', '60', '3', '0', '0', '0', '2016-05-31 15:32:52');
INSERT INTO `goods` VALUES ('247', '1', '休闲椅时尚办公椅简约现代', '', '小工匠家具', '北京', '', '', '<p>						</p><p><img src=\\\"/pic/upload/image/20160614/14658703771250113.jpg\\\" style=\\\"\\\" title=\\\"14658703771250113.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658703839581882.jpg\\\" style=\\\"\\\" title=\\\"14658703839581882.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658703936528351.jpg\\\" style=\\\"\\\" title=\\\"14658703936528351.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658703961165906.jpg\\\" style=\\\"\\\" title=\\\"14658703961165906.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658703974699935.jpg\\\" style=\\\"\\\" title=\\\"14658703974699935.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658703993518704.jpg\\\" style=\\\"\\\" title=\\\"14658703993518704.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658704006528787.jpg\\\" style=\\\"\\\" title=\\\"14658704006528787.jpg\\\"/></p><p><br/></p>', '1', '10', '0.01', '0', '0.01', '79', '2', '1', '0', '0', '2016-05-31 15:36:15');
INSERT INTO `goods` VALUES ('248', '1', ' 简约现代真皮沙发头层牛皮', '', ' kfunghome', '浙江杭州', '', '', '<p>						</p><p><img src=\\\"/pic/upload/image/20160614/14658700037190182.jpg\\\" style=\\\"\\\" title=\\\"14658700037190182.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658700056885083.jpg\\\" style=\\\"\\\" title=\\\"14658700056885083.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658700051033234.jpg\\\" style=\\\"\\\" title=\\\"14658700051033234.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658700076278335.jpg\\\" style=\\\"\\\" title=\\\"14658700076278335.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658700113703316.jpg\\\" style=\\\"\\\" title=\\\"14658700113703316.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658700134930157.jpg\\\" style=\\\"\\\" title=\\\"14658700134930157.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658700141193018.jpg\\\" style=\\\"\\\" title=\\\"14658700141193018.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658700141012061.jpg\\\" style=\\\"\\\" title=\\\"14658700141012061.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658700167344669.jpg\\\" style=\\\"\\\" title=\\\"14658700167344669.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/146587002111350911.jpg\\\" style=\\\"\\\" title=\\\"146587002111350911.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/146587002263523512.jpg\\\" style=\\\"\\\" title=\\\"146587002263523512.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/146587002312836310.jpg\\\" style=\\\"\\\" title=\\\"146587002312836310.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/146587002410310413.jpg\\\" style=\\\"\\\" title=\\\"146587002410310413.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/146587002892522615.jpg\\\" style=\\\"\\\" title=\\\"146587002892522615.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/146587002811782516.jpg\\\" style=\\\"\\\" title=\\\"146587002811782516.jpg\\\"/></p><p><br/></p>', '1', '50', '0.02', '0', '0.01', '75', '1', '1', '0', '0', '2016-05-31 15:39:31');
INSERT INTO `goods` VALUES ('249', '1', '北欧宜家布艺沙发组合小户型客厅转角羽绒布艺沙发现代简约', '', '汤森', '广东', '', '', '<p><img src=\\\"/pic/upload/image/20160614/14658695501185653.jpg\\\" style=\\\"\\\" title=\\\"14658695501185653.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658695532920561.jpg\\\" style=\\\"\\\" title=\\\"14658695532920561.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658695542371484.jpg\\\" style=\\\"\\\" title=\\\"14658695542371484.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658695559619752.jpg\\\" style=\\\"\\\" title=\\\"14658695559619752.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658695703620267.jpg\\\" style=\\\"\\\" title=\\\"14658695703620267.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658695749422665.jpg\\\" style=\\\"\\\" title=\\\"14658695749422665.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658695797515506.jpg\\\" style=\\\"\\\" title=\\\"14658695797515506.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658695831556028.jpg\\\" style=\\\"\\\" title=\\\"14658695831556028.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658695853455459.jpg\\\" style=\\\"\\\" title=\\\"14658695853455459.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/146586959323886910.jpg\\\" style=\\\"\\\" title=\\\"146586959323886910.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/146586959584097011.jpg\\\" style=\\\"\\\" title=\\\"146586959584097011.jpg\\\"/></p><p><br/></p>', '1', '50', '0.02', '0', '0.01', '76', '2', '0', '0', '0', '2016-05-31 15:45:45');
INSERT INTO `goods` VALUES ('250', '1', '现代简约棉麻布艺沙发北欧宜家L组合可拆洗沙发宝马仕BMS功能沙发', '', 'LEAUP领昂', '浙江杭州', '', '', '<p>						</p><p><img src=\\\"/pic/upload/image/20160614/14658690057442342.jpg\\\" style=\\\"\\\" title=\\\"14658690057442342.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658690118949313.jpg\\\" style=\\\"\\\" title=\\\"14658690118949313.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658690248517281.jpg\\\" style=\\\"\\\" title=\\\"14658690248517281.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658690279049155.jpg\\\" style=\\\"\\\" title=\\\"14658690279049155.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658690324036386.jpg\\\" style=\\\"\\\" title=\\\"14658690324036386.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658690361004878.jpg\\\" style=\\\"\\\" title=\\\"14658690361004878.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658690381065037.jpg\\\" style=\\\"\\\" title=\\\"14658690381065037.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658690425338529.jpg\\\" style=\\\"\\\" title=\\\"14658690425338529.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/146586904673971610.jpg\\\" style=\\\"\\\" title=\\\"146586904673971610.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/146586905212068211.jpg\\\" style=\\\"\\\" title=\\\"146586905212068211.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658690531351714.jpg\\\" style=\\\"\\\" title=\\\"14658690531351714.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/146586905655433512.jpg\\\" style=\\\"\\\" title=\\\"146586905655433512.jpg\\\"/></p><p><br/></p>', '1', '20', '0.02', '0', '0.01', '77', '1', '1', '0', '0', '2016-05-31 15:49:44');
INSERT INTO `goods` VALUES ('251', '1', '布艺沙发现代简约大小户型客厅家具', '', ' 雅琼', '广东', '', '', null, '1', '20', '0.01', '0', null, '78', '1', '0', '0', '1', '2016-05-31 15:53:34');
INSERT INTO `goods` VALUES ('252', '1', '简约现代棉麻布艺沙发', '', '福美家', '广东', '', '', '<p>						</p><p><br/></p><p><img src=\\\"/pic/upload/image/20160614/14658686711309841.jpg\\\" style=\\\"\\\" title=\\\"14658686711309841.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658686769845672.jpg\\\" style=\\\"\\\" title=\\\"14658686769845672.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658686762689053.jpg\\\" style=\\\"\\\" title=\\\"14658686762689053.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658686793627575.jpg\\\" style=\\\"\\\" title=\\\"14658686793627575.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658686828440686.jpg\\\" style=\\\"\\\" title=\\\"14658686828440686.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658686837503027.jpg\\\" style=\\\"\\\" title=\\\"14658686837503027.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658686901035259.jpg\\\" style=\\\"\\\" title=\\\"14658686901035259.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658686931331108.jpg\\\" style=\\\"\\\" title=\\\"14658686931331108.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/146586869566441010.jpg\\\" style=\\\"\\\" title=\\\"146586869566441010.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658686964594504.jpg\\\" style=\\\"\\\" title=\\\"14658686964594504.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/146586870079156911.jpg\\\" style=\\\"\\\" title=\\\"146586870079156911.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/146586870210550512.jpg\\\" style=\\\"\\\" title=\\\"146586870210550512.jpg\\\"/></p><p><br/></p>', '1', '20', '0.01', '0', '0.01', '78', '1', '1', '0', '0', '2016-05-31 15:53:55');
INSERT INTO `goods` VALUES ('253', '1', '北欧棉麻简约现代客厅转角组合沙发', '', '艾千', '广东', '', '', '<p><img src=\\\"/pic/upload/image/20160614/14658681774767921.jpg\\\" style=\\\"\\\" title=\\\"14658681774767921.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658681783429632.jpg\\\" style=\\\"\\\" title=\\\"14658681783429632.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658681874298874.jpg\\\" style=\\\"\\\" title=\\\"14658681874298874.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658681898745345.jpg\\\" style=\\\"\\\" title=\\\"14658681898745345.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658681925723226.jpg\\\" style=\\\"\\\" title=\\\"14658681925723226.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658681955739147.jpg\\\" style=\\\"\\\" title=\\\"14658681955739147.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658682011136858.jpg\\\" style=\\\"\\\" title=\\\"14658682011136858.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658682061396259.jpg\\\" style=\\\"\\\" title=\\\"14658682061396259.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/146586820850200810.jpg\\\" style=\\\"\\\" title=\\\"146586820850200810.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/146586821056027311.jpg\\\" style=\\\"\\\" title=\\\"146586821056027311.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/146586821230156612.jpg\\\" style=\\\"\\\" title=\\\"146586821230156612.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/14658682189474303.jpg\\\" style=\\\"\\\" title=\\\"14658682189474303.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/146586821811513513.jpg\\\" style=\\\"\\\" title=\\\"146586821811513513.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/146586821818581114.jpg\\\" style=\\\"\\\" title=\\\"146586821818581114.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160614/146586822310204515.jpg\\\" style=\\\"\\\" title=\\\"146586822310204515.jpg\\\"/></p><p><br/></p>', '1', '30', '0.01', '0', '0.01', '80', '2', '0', '0', '0', '2016-05-31 15:58:06');
INSERT INTO `goods` VALUES ('254', '1', '实木沙发中式全实木家具', '', 'Ailun/艾伦往事', '广东', '', '', '<p>						</p><p><img src=\\\"/pic/upload/image/20160531/1464681697805124356.jpg\\\" style=\\\"\\\" title=\\\"1464681697805124356.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160531/1464681699882366355.jpg\\\" style=\\\"\\\" title=\\\"1464681699882366355.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160531/1464681704395160358.jpg\\\" style=\\\"\\\" title=\\\"1464681704395160358.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160531/1464681705125661357.jpg\\\" style=\\\"\\\" title=\\\"1464681705125661357.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160531/1464681706117089359.jpg\\\" style=\\\"\\\" title=\\\"1464681706117089359.jpg\\\"/></p><p><br/></p>', '1', '20', '0.02', '0', '0.01', '81', '1', '0', '0', '0', '2016-05-31 16:02:15');
INSERT INTO `goods` VALUES ('255', '1', '欧式进口头层真皮沙发实木雕花 皮布结合沙发客厅组合', '', '泰洛萨斯', '上海', '', '', '<p>						</p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14658090493392623.jpg\\\" style=\\\"\\\" title=\\\"14658090493392623.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14658090501387302.jpg\\\" style=\\\"\\\" title=\\\"14658090501387302.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14658090521235614.jpg\\\" style=\\\"\\\" title=\\\"14658090521235614.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14658090564415495.jpg\\\" style=\\\"\\\" title=\\\"14658090564415495.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14658090571010386.jpg\\\" style=\\\"\\\" title=\\\"14658090571010386.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14658090574656891.jpg\\\" style=\\\"\\\" title=\\\"14658090574656891.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14658090614528237.jpg\\\" style=\\\"\\\" title=\\\"14658090614528237.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14658090621013828.jpg\\\" style=\\\"\\\" title=\\\"14658090621013828.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14658090684056179.jpg\\\" style=\\\"\\\" title=\\\"14658090684056179.jpg\\\"/></p><p><br/></p>', '1', '20', '0.01', '0', '0.01', '82', '1', '0', '0', '0', '2016-05-31 16:05:40');
INSERT INTO `goods` VALUES ('256', '1', '现代简约欧式大理石电视柜', '', ' LKWD/洛克威登', '广东', '', '', '<p><img src=\\\"/pic/upload/image/20160531/1464682124332119364.jpg\\\" style=\\\"\\\" title=\\\"1464682124332119364.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160531/1464682126934521365.jpg\\\" style=\\\"\\\" title=\\\"1464682126934521365.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160531/1464682129104786367.jpg\\\" style=\\\"\\\" title=\\\"1464682129104786367.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160531/1464682129424723368.jpg\\\" style=\\\"\\\" title=\\\"1464682129424723368.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160531/1464682135882151366.jpg\\\" style=\\\"\\\" title=\\\"1464682135882151366.jpg\\\"/></p><p><br/></p>', '1', '15', '0.01', '0', null, '83', '1', '0', '0', '0', '2016-05-31 16:09:25');
INSERT INTO `goods` VALUES ('257', '1', '中式实木鞋柜', '', ' 尚善国韵', '四川成都', '', '', null, '1', '10', '0.01', '0', null, '84', '1', '0', '0', '1', '2016-05-31 16:13:59');
INSERT INTO `goods` VALUES ('258', '1', '中式实木鞋柜', '', ' 尚善国韵', '四川成都', '', '', '<p><img src=\\\"/pic/upload/image/20160531/1464682372116017370.jpg\\\" style=\\\"\\\" title=\\\"1464682372116017370.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160531/1464682377779908371.jpg\\\" style=\\\"\\\" title=\\\"1464682377779908371.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160531/1464682382971227373.jpg\\\" style=\\\"\\\" title=\\\"1464682382971227373.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160531/1464682382130756369.jpg\\\" style=\\\"\\\" title=\\\"1464682382130756369.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160531/1464682391299070372.jpg\\\" style=\\\"\\\" title=\\\"1464682391299070372.jpg\\\"/></p><p><br/></p>', '1', '10', '0.01', '0', null, '84', '1', '0', '0', '0', '2016-05-31 16:14:20');
INSERT INTO `goods` VALUES ('259', '1', '美式玄关柜', '', '思图加特', '广东', '', '', '<p>						</p><p><img src=\\\"/pic/upload/image/20160531/1464682673409662375.jpg\\\" style=\\\"\\\" title=\\\"1464682673409662375.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160531/1464682679985944374.jpg\\\" style=\\\"\\\" title=\\\"1464682679985944374.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160531/1464682682847812377.jpg\\\" style=\\\"\\\" title=\\\"1464682682847812377.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160531/1464682684837140378.jpg\\\" style=\\\"\\\" title=\\\"1464682684837140378.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160531/1464682685134964376.jpg\\\" style=\\\"\\\" title=\\\"1464682685134964376.jpg\\\"/></p><p><br/></p>', '1', '10', '0.01', '0', '0.01', '85', '2', '1', '0', '0', '2016-05-31 16:21:17');
INSERT INTO `goods` VALUES ('260', '1', '简约现代酒柜黑色钢琴烤漆时尚客厅储物餐厅家具钢化玻璃', '', 'NANXI HOME FURNITU', '广东', '', '', '<p>						</p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14658083475249872.jpg\\\" style=\\\"\\\" title=\\\"14658083475249872.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14658083491396163.jpg\\\" style=\\\"\\\" title=\\\"14658083491396163.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14658083512712724.jpg\\\" style=\\\"\\\" title=\\\"14658083512712724.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14658083584905625.jpg\\\" style=\\\"\\\" title=\\\"14658083584905625.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14658083631235096.jpg\\\" style=\\\"\\\" title=\\\"14658083631235096.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14658083631275507.jpg\\\" style=\\\"\\\" title=\\\"14658083631275507.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14658083737670841.jpg\\\" style=\\\"\\\" title=\\\"14658083737670841.jpg\\\"/></p><p><br/></p>', '1', '180', '0.01', '0', '0.01', '86', '1', '1', '0', '0', '2016-05-31 16:27:16');
INSERT INTO `goods` VALUES ('261', '1', '简直衣帽架实木挂衣架落地衣架', '', ' 简直', '上海', '', '', '<p>						</p><p style=\\\"text-align: left;\\\"><img src=\\\"/pic/upload/image/20160613/146580794310267301.jpg\\\" style=\\\"\\\" title=\\\"146580794310267301.jpg\\\"/></p><p style=\\\"text-align: left;\\\"><img src=\\\"/pic/upload/image/20160613/14658079481036461.jpg\\\" style=\\\"\\\" title=\\\"14658079481036461.jpg\\\"/></p><p style=\\\"text-align: left;\\\"><img src=\\\"/pic/upload/image/20160613/14658079532734233.jpg\\\" style=\\\"\\\" title=\\\"14658079532734233.jpg\\\"/></p><p style=\\\"text-align: left;\\\"><img src=\\\"/pic/upload/image/20160613/14658079551162374.jpg\\\" style=\\\"\\\" title=\\\"14658079551162374.jpg\\\"/></p><p style=\\\"text-align: left;\\\"><img src=\\\"/pic/upload/image/20160613/14658079611073386.jpg\\\" style=\\\"\\\" title=\\\"14658079611073386.jpg\\\"/></p><p style=\\\"text-align: left;\\\"><img src=\\\"/pic/upload/image/20160613/14658079629256135.jpg\\\" style=\\\"\\\" title=\\\"14658079629256135.jpg\\\"/></p><p style=\\\"text-align: left;\\\"><img src=\\\"/pic/upload/image/20160613/14658079622874522.jpg\\\" style=\\\"\\\" title=\\\"14658079622874522.jpg\\\"/></p><p><br/></p>', '1', '5', '0.02', '0', '0.01', '87', '3', '1', '0', '0', '2016-05-31 16:31:16');
INSERT INTO `goods` VALUES ('262', '1', '简直衣帽架实木挂衣架', '', ' 简直', '上海', '', '', '<p><img src=\\\"/pic/upload/image/20160531/1464683430975960386.jpg\\\" style=\\\"\\\" title=\\\"1464683430975960386.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160531/1464683431196224384.jpg\\\" style=\\\"\\\" title=\\\"1464683431196224384.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160531/1464683442873416385.jpg\\\" style=\\\"\\\" title=\\\"1464683442873416385.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160531/1464683444102269388.jpg\\\" style=\\\"\\\" title=\\\"1464683444102269388.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160531/1464683445529290387.jpg\\\" style=\\\"\\\" title=\\\"1464683445529290387.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160531/1464683448598572389.jpg\\\" style=\\\"\\\" title=\\\"1464683448598572389.jpg\\\"/></p><p><br/></p>', '1', '5', '0.01', '0', null, '87', '3', '0', '0', '1', '2016-05-31 16:31:28');
INSERT INTO `goods` VALUES ('263', '1', '北欧实木板墙上置物架一字隔板书架铁艺创意', '', '威斯雅', '福州', '', '', '<p><img src=\\\"/pic/upload/image/20160531/1464683686112657390.jpg\\\" style=\\\"\\\" title=\\\"1464683686112657390.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160531/1464683690253586392.jpg\\\" style=\\\"\\\" title=\\\"1464683690253586392.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160531/1464683690135481391.jpg\\\" style=\\\"\\\" title=\\\"1464683690135481391.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160531/1464683697350881394.jpg\\\" style=\\\"\\\" title=\\\"1464683697350881394.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160531/1464683697123802393.jpg\\\" style=\\\"\\\" title=\\\"1464683697123802393.jpg\\\"/></p><p><br/></p>', '1', '5', '0.01', '0', null, '88', '5', '0', '0', '0', '2016-05-31 16:35:34');
INSERT INTO `goods` VALUES ('264', '1', '简易鞋柜实木多层鞋架', '', '飘兰轩', '福州', '', '', '<p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14658076201402833.jpg\\\" style=\\\"\\\" title=\\\"14658076201402833.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14658076267225034.jpg\\\" style=\\\"\\\" title=\\\"14658076267225034.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14658076281226621.jpg\\\" style=\\\"\\\" title=\\\"14658076281226621.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14658076293021692.jpg\\\" style=\\\"\\\" title=\\\"14658076293021692.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14658076298371835.jpg\\\" style=\\\"\\\" title=\\\"14658076298371835.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14658076336280916.jpg\\\" style=\\\"\\\" title=\\\"14658076336280916.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14658076332757477.jpg\\\" style=\\\"\\\" title=\\\"14658076332757477.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14658076361070028.jpg\\\" style=\\\"\\\" title=\\\"14658076361070028.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14658076404711989.jpg\\\" style=\\\"\\\" title=\\\"14658076404711989.jpg\\\"/></p><p><br/></p>', '1', '5', '0.01', '0', '0.01', '89', '10', '0', '0', '0', '2016-05-31 16:40:35');
INSERT INTO `goods` VALUES ('265', '1', '花架铁艺多层特价欧式阳台客厅落地花盆架子室内绿萝吊兰简约花几', '', '绿莹', '浙江金华', '', '', '<p>						</p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14658071778001751.jpg\\\" style=\\\"\\\" title=\\\"14658071778001751.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14658071771155832.jpg\\\" style=\\\"\\\" title=\\\"14658071771155832.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14658071846602794.jpg\\\" style=\\\"\\\" title=\\\"14658071846602794.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14658071845192215.jpg\\\" style=\\\"\\\" title=\\\"14658071845192215.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14658071861051356.jpg\\\" style=\\\"\\\" title=\\\"14658071861051356.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14658071881314197.jpg\\\" style=\\\"\\\" title=\\\"14658071881314197.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14658071944308348.jpg\\\" style=\\\"\\\" title=\\\"14658071944308348.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14658071972565559.jpg\\\" style=\\\"\\\" title=\\\"14658071972565559.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14658071981118393.jpg\\\" style=\\\"\\\" title=\\\"14658071981118393.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/146580720013326910.jpg\\\" style=\\\"\\\" title=\\\"146580720013326910.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/146580720043892411.jpg\\\" style=\\\"\\\" title=\\\"146580720043892411.jpg\\\"/></p><p><br/></p>', '1', '4', '0.02', '0', '0.01', '90', '5', '0', '0', '0', '2016-05-31 16:46:50');
INSERT INTO `goods` VALUES ('266', '1', '万饰得欧式花架', '', '万饰得', '浙江金华', '', '', '<p><img src=\\\"/pic/upload/image/20160531/1464684269109614401.jpg\\\" style=\\\"\\\" title=\\\"1464684269109614401.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160531/1464684271117618400.jpg\\\" style=\\\"\\\" title=\\\"1464684271117618400.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160531/1464684271115277399.jpg\\\" style=\\\"\\\" title=\\\"1464684271115277399.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160531/1464684276750947403.jpg\\\" style=\\\"\\\" title=\\\"1464684276750947403.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160531/1464684279443227402.jpg\\\" style=\\\"\\\" title=\\\"1464684279443227402.jpg\\\"/></p><p><br/></p>', '1', '4', '0.01', '0', null, '90', '5', '0', '0', '1', '2016-05-31 16:47:11');
INSERT INTO `goods` VALUES ('267', '1', '曼时光博古架全实木中式隔断仿古家具多宝阁', '', ' 曼时光', '浙江杭州', '', '', '<p><img src=\\\"/pic/upload/image/20160531/1464684675116913406.jpg\\\" style=\\\"\\\" title=\\\"1464684675116913406.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160531/1464684679952379404.jpg\\\" style=\\\"\\\" title=\\\"1464684679952379404.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160531/1464684679109382405.jpg\\\" style=\\\"\\\" title=\\\"1464684679109382405.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160531/1464684681132223407.jpg\\\" style=\\\"\\\" title=\\\"1464684681132223407.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160531/1464684683926129408.jpg\\\" style=\\\"\\\" title=\\\"1464684683926129408.jpg\\\"/></p><p><br/></p>', '1', '20', '0.01', '0', null, '91', '2', '0', '0', '0', '2016-05-31 16:53:16');
INSERT INTO `goods` VALUES ('268', '1', '欧式大理石茶几', '', ' 和购', '广东', '', '', '<p><img src=\\\"/pic/upload/image/20160531/1464685047237707410.jpg\\\" style=\\\"\\\" title=\\\"1464685047237707410.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160531/1464685051112226411.jpg\\\" style=\\\"\\\" title=\\\"1464685051112226411.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160531/1464685053121457409.jpg\\\" style=\\\"\\\" title=\\\"1464685053121457409.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160531/1464685054147082412.jpg\\\" style=\\\"\\\" title=\\\"1464685054147082412.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160531/1464685055132408413.jpg\\\" style=\\\"\\\" title=\\\"1464685055132408413.jpg\\\"/></p><p><br/></p>', '1', '10', '0.01', '0', null, '92', '2', '0', '0', '0', '2016-05-31 16:58:08');
INSERT INTO `goods` VALUES ('269', '1', '沙发边柜黑色橡木角几', '', ' 依卡斯', '江苏苏州', '', '', '<p><img src=\\\"/pic/upload/image/20160531/1464685255983448415.jpg\\\" style=\\\"\\\" title=\\\"1464685255983448415.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160531/1464685256131092416.jpg\\\" style=\\\"\\\" title=\\\"1464685256131092416.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160531/1464685257345545414.jpg\\\" style=\\\"\\\" title=\\\"1464685257345545414.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160531/1464685257883528417.jpg\\\" style=\\\"\\\" title=\\\"1464685257883528417.jpg\\\"/></p><p><br/></p>', '1', '5', '0.01', '0', null, '93', '3', '0', '0', '0', '2016-05-31 17:01:27');
INSERT INTO `goods` VALUES ('270', '1', ' 飘窗桌炕几茶几', '', ' 传承华夏', '北京', '', '', '<p><img src=\\\"/pic/upload/image/20160531/1464685475747117419.jpg\\\" style=\\\"\\\" title=\\\"1464685475747117419.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160531/1464685476111805418.jpg\\\" style=\\\"\\\" title=\\\"1464685476111805418.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160531/1464685476629253420.jpg\\\" style=\\\"\\\" title=\\\"1464685476629253420.jpg\\\"/></p><p><br/></p>', '1', '5', '0.01', '0', null, '94', '3', '0', '0', '0', '2016-05-31 17:05:03');
INSERT INTO `goods` VALUES ('271', '1', '钢木简约套几塌塌米', '', 'SOFSYS', '广东', '', '', '<p><img src=\\\"/pic/upload/image/20160531/1464685758656837422.jpg\\\" style=\\\"\\\" title=\\\"1464685758656837422.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160531/1464685758273165423.jpg\\\" style=\\\"\\\" title=\\\"1464685758273165423.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160531/1464685763349418421.jpg\\\" style=\\\"\\\" title=\\\"1464685763349418421.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160531/1464685763827501424.jpg\\\" style=\\\"\\\" title=\\\"1464685763827501424.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160531/1464685765134577425.jpg\\\" style=\\\"\\\" title=\\\"1464685765134577425.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160531/1464685770577314426.jpg\\\" style=\\\"\\\" title=\\\"1464685770577314426.jpg\\\"/></p><p><br/></p>', '1', '5', '0.01', '0', null, '95', '5', '0', '0', '0', '2016-05-31 17:10:00');
INSERT INTO `goods` VALUES ('272', '1', '钢木简约套几塌塌米', '', 'SOFSYS', '广东', '', '', null, '1', '5', '0.01', '0', null, '95', '5', '0', '0', '1', '2016-05-31 17:10:08');
INSERT INTO `goods` VALUES ('273', '1', '钢木简约套几塌塌米', '', 'SOFSYS', '广东', '', '', '<p><img src=\\\"/pic/upload/image/20160531/1464685758656837422.jpg\\\" style=\\\"\\\" title=\\\"1464685758656837422.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160531/1464685758273165423.jpg\\\" style=\\\"\\\" title=\\\"1464685758273165423.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160531/1464685763349418421.jpg\\\" style=\\\"\\\" title=\\\"1464685763349418421.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160531/1464685763827501424.jpg\\\" style=\\\"\\\" title=\\\"1464685763827501424.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160531/1464685765134577425.jpg\\\" style=\\\"\\\" title=\\\"1464685765134577425.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160531/1464685770577314426.jpg\\\" style=\\\"\\\" title=\\\"1464685770577314426.jpg\\\"/></p><p><br/></p>', '1', '5', '0.01', '0', null, '95', '5', '0', '0', '1', '2016-05-31 17:10:24');
INSERT INTO `goods` VALUES ('274', '1', '美式乡村实木长餐桌北欧简约法式', '', '诺德森', '上海', '', '', '<p><img src=\\\"/pic/upload/image/20160601/1464744571511647428.jpg\\\" style=\\\"\\\" title=\\\"1464744571511647428.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464744571110583429.jpg\\\" style=\\\"\\\" title=\\\"1464744571110583429.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464744571203927427.jpg\\\" style=\\\"\\\" title=\\\"1464744571203927427.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464744573602444430.jpg\\\" style=\\\"\\\" title=\\\"1464744573602444430.jpg\\\"/></p><p><br/></p>', '1', '20', '0.01', '0', null, '100', '2', '0', '0', '0', '2016-06-01 09:30:02');
INSERT INTO `goods` VALUES ('275', '1', '多功能餐桌圆餐桌', '', ' 筑巢天下', '广东', '', '', '<p><img src=\\\"/pic/upload/image/20160601/1464744966165242431.jpg\\\" style=\\\"\\\" title=\\\"1464744966165242431.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464744967706883432.jpg\\\" style=\\\"\\\" title=\\\"1464744967706883432.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464744976110910434.jpg\\\" style=\\\"\\\" title=\\\"1464744976110910434.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464744976136845435.jpg\\\" style=\\\"\\\" title=\\\"1464744976136845435.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464744990923935437.jpg\\\" style=\\\"\\\" title=\\\"1464744990923935437.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464744992772549433.jpg\\\" style=\\\"\\\" title=\\\"1464744992772549433.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464744996152676436.jpg\\\" style=\\\"\\\" title=\\\"1464744996152676436.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464745001573140438.jpg\\\" style=\\\"\\\" title=\\\"1464745001573140438.jpg\\\"/></p><p><br/></p>', '1', '15', '0.01', '0', null, '101', '3', '0', '0', '0', '2016-06-01 09:37:07');
INSERT INTO `goods` VALUES ('276', '1', '折叠餐桌小户型伸缩餐桌椅组合', '', ' 冯氏木业', '广东', '', '', '<p><img src=\\\"/pic/upload/image/20160601/1464745333389566441.jpg\\\" style=\\\"\\\" title=\\\"1464745333389566441.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464745334385091440.jpg\\\" style=\\\"\\\" title=\\\"1464745334385091440.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464745334327471439.jpg\\\" style=\\\"\\\" title=\\\"1464745334327471439.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464745337375624443.jpg\\\" style=\\\"\\\" title=\\\"1464745337375624443.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464745344870059444.jpg\\\" style=\\\"\\\" title=\\\"1464745344870059444.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464745346133781446.jpg\\\" style=\\\"\\\" title=\\\"1464745346133781446.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464745346482300442.jpg\\\" style=\\\"\\\" title=\\\"1464745346482300442.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464745348316670445.jpg\\\" style=\\\"\\\" title=\\\"1464745348316670445.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464745350106159447.jpg\\\" style=\\\"\\\" title=\\\"1464745350106159447.jpg\\\"/></p><p><br/></p>', '1', '15', '0.01', '0', null, '102', '3', '0', '0', '0', '2016-06-01 09:44:51');
INSERT INTO `goods` VALUES ('277', '1', '北欧日式实木餐桌 ', '', '沃购', '广东', '', '', '<p><img src=\\\"/pic/upload/image/20160601/1464745674780295449.jpg\\\" style=\\\"\\\" title=\\\"1464745674780295449.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464745676100823448.jpg\\\" style=\\\"\\\" title=\\\"1464745676100823448.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464745676268217450.jpg\\\" style=\\\"\\\" title=\\\"1464745676268217450.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464745679580670451.jpg\\\" style=\\\"\\\" title=\\\"1464745679580670451.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464745685319424452.jpg\\\" style=\\\"\\\" title=\\\"1464745685319424452.jpg\\\"/></p><p><br/></p>', '1', '30', '0.01', '0', null, '103', '3', '0', '0', '0', '2016-06-01 09:49:01');
INSERT INTO `goods` VALUES ('278', '1', '北欧全实木餐椅', '', '富维利亚', '广东', '', '', '<p>						</p><p><img src=\\\"/pic/upload/image/20160601/1464746139134715454.jpg\\\" style=\\\"\\\" title=\\\"1464746139134715454.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464746143665959455.jpg\\\" style=\\\"\\\" title=\\\"1464746143665959455.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464746144541339453.jpg\\\" style=\\\"\\\" title=\\\"1464746144541339453.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464746146106946456.jpg\\\" style=\\\"\\\" title=\\\"1464746146106946456.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464746150463452457.jpg\\\" style=\\\"\\\" title=\\\"1464746150463452457.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464746151111323458.jpg\\\" style=\\\"\\\" title=\\\"1464746151111323458.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464746155483332459.jpg\\\" style=\\\"\\\" title=\\\"1464746155483332459.jpg\\\"/></p><p><br/></p>', '1', '20', '0.02', '0', '0.01', '104', '4', '1', '0', '0', '2016-06-01 09:56:24');
INSERT INTO `goods` VALUES ('279', '1', '简域实木小圆凳子简约彩色时尚家用 餐桌凳', '', ' sd/简域', '浙江', '', '', '<p><img src=\\\"/pic/upload/image/20160601/1464746555133919460.jpg\\\" style=\\\"\\\" title=\\\"1464746555133919460.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464746557102919461.jpg\\\" style=\\\"\\\" title=\\\"1464746557102919461.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464746558940416462.jpg\\\" style=\\\"\\\" title=\\\"1464746558940416462.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464746559495338463.jpg\\\" style=\\\"\\\" title=\\\"1464746559495338463.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464746560419129464.jpg\\\" style=\\\"\\\" title=\\\"1464746560419129464.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464746561736359465.jpg\\\" style=\\\"\\\" title=\\\"1464746561736359465.jpg\\\"/></p><p><br/></p>', '1', '5', '0.01', '0', null, '105', '6', '0', '0', '0', '2016-06-01 10:03:44');
INSERT INTO `goods` VALUES ('280', '1', '透明椅子塑料餐椅', '', ' 春分木语', '北京', '', '', '<p><img src=\\\"/pic/upload/image/20160601/1464746859328289467.jpg\\\" style=\\\"\\\" title=\\\"1464746859328289467.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464746859407683468.jpg\\\" style=\\\"\\\" title=\\\"1464746859407683468.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464746868843982470.jpg\\\" style=\\\"\\\" title=\\\"1464746868843982470.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464746868116125469.jpg\\\" style=\\\"\\\" title=\\\"1464746868116125469.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464746868369858471.jpg\\\" style=\\\"\\\" title=\\\"1464746868369858471.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464746872124577472.jpg\\\" style=\\\"\\\" title=\\\"1464746872124577472.jpg\\\"/></p><p><br/></p>', '1', '6', '0.01', '0', null, '117', '10', '0', '0', '0', '2016-06-01 10:08:23');
INSERT INTO `goods` VALUES ('281', '1', '餐边柜酒柜现代简约', '', ' 易构', '广东', '', '', '<p><img src=\\\"/pic/upload/image/20160601/1464747278128763473.jpg\\\" style=\\\"\\\" title=\\\"1464747278128763473.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464747278812827475.jpg\\\" style=\\\"\\\" title=\\\"1464747278812827475.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464747281357637476.jpg\\\" style=\\\"\\\" title=\\\"1464747281357637476.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464747281253026474.jpg\\\" style=\\\"\\\" title=\\\"1464747281253026474.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464747284138033477.jpg\\\" style=\\\"\\\" title=\\\"1464747284138033477.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464747286748365479.jpg\\\" style=\\\"\\\" title=\\\"1464747286748365479.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464747286849060478.jpg\\\" style=\\\"\\\" title=\\\"1464747286849060478.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464747288132537480.jpg\\\" style=\\\"\\\" title=\\\"1464747288132537480.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464747290366673481.jpg\\\" style=\\\"\\\" title=\\\"1464747290366673481.jpg\\\"/></p><p><br/></p>', '1', '40', '0.01', '0', null, '118', '2', '0', '0', '0', '2016-06-01 10:16:49');
INSERT INTO `goods` VALUES ('282', '1', '个性时尚不锈钢钢化玻璃餐车', '', '美萌家具', '广东', '', '', '<p><img src=\\\"/pic/upload/image/20160601/1464747630434405484.jpg\\\" style=\\\"\\\" title=\\\"1464747630434405484.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464747637168598483.jpg\\\" style=\\\"\\\" title=\\\"1464747637168598483.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464747640809513486.jpg\\\" style=\\\"\\\" title=\\\"1464747640809513486.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464747644993603482.jpg\\\" style=\\\"\\\" title=\\\"1464747644993603482.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464747645301394485.jpg\\\" style=\\\"\\\" title=\\\"1464747645301394485.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464747645907196487.jpg\\\" style=\\\"\\\" title=\\\"1464747645907196487.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464747649432125488.jpg\\\" style=\\\"\\\" title=\\\"1464747649432125488.jpg\\\"/></p><p><br/></p>', '1', '15', '0.01', '0', null, '119', '3', '0', '0', '0', '2016-06-01 10:21:16');
INSERT INTO `goods` VALUES ('283', '1', '客餐厅8件套', '', 'vvg', '广东', '', '', '<p><img src=\\\"/pic/upload/image/20160601/1464748856154914490.jpg\\\" style=\\\"\\\" title=\\\"1464748856154914490.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464748856190372489.jpg\\\" style=\\\"\\\" title=\\\"1464748856190372489.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464748857832191491.jpg\\\" style=\\\"\\\" title=\\\"1464748857832191491.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464748860640571492.jpg\\\" style=\\\"\\\" title=\\\"1464748860640571492.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464748862137727493.jpg\\\" style=\\\"\\\" title=\\\"1464748862137727493.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464748862553130494.jpg\\\" style=\\\"\\\" title=\\\"1464748862553130494.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464748866838086496.jpg\\\" style=\\\"\\\" title=\\\"1464748866838086496.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464748869145963497.jpg\\\" style=\\\"\\\" title=\\\"1464748869145963497.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464748874910982498.jpg\\\" style=\\\"\\\" title=\\\"1464748874910982498.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464748880134345495.jpg\\\" style=\\\"\\\" title=\\\"1464748880134345495.jpg\\\"/></p><p><br/></p>', '1', '100', '0.01', '0', null, '99', '2', '0', '0', '0', '2016-06-01 10:41:57');
INSERT INTO `goods` VALUES ('284', '1', '莉云居特价办公家具老板桌办公桌', '', '莉云居', '江苏徐州', '', '', '<p><img src=\\\"/pic/upload/image/20160601/1464749168534325499.jpg\\\" style=\\\"\\\" title=\\\"1464749168534325499.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464749168469734500.jpg\\\" style=\\\"\\\" title=\\\"1464749168469734500.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464749173658300503.jpg\\\" style=\\\"\\\" title=\\\"1464749173658300503.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464749175103426501.jpg\\\" style=\\\"\\\" title=\\\"1464749175103426501.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464749175848930504.jpg\\\" style=\\\"\\\" title=\\\"1464749175848930504.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464749179425197505.jpg\\\" style=\\\"\\\" title=\\\"1464749179425197505.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464749180109688502.jpg\\\" style=\\\"\\\" title=\\\"1464749180109688502.jpg\\\"/></p><p><br/></p>', '1', '30', '0.01', '0', null, '351', '2', '0', '0', '0', '2016-06-01 10:46:41');
INSERT INTO `goods` VALUES ('285', '1', '白色烤漆老板桌 ', '', '龙跃', '上海', '', '', '<p>						</p><p><br/></p><p><img src=\\\"/pic/upload/image/20160601/1464749415903925507.jpg\\\" style=\\\"\\\" title=\\\"1464749415903925507.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464749424720179506.jpg\\\" style=\\\"\\\" title=\\\"1464749424720179506.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464749424735241509.jpg\\\" style=\\\"\\\" title=\\\"1464749424735241509.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464749427235771508.jpg\\\" style=\\\"\\\" title=\\\"1464749427235771508.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464749428428166510.jpg\\\" style=\\\"\\\" title=\\\"1464749428428166510.jpg\\\"/></p><p><br/></p>', '1', '50', '0.02', '0', '0.01', '352', '2', '1', '0', '0', '2016-06-01 10:50:54');
INSERT INTO `goods` VALUES ('286', '1', '上海绿思欧办公家具办公桌定做时尚烤漆前台', '', '绿思欧', '上海', '', '', '<p><img src=\\\"/pic/upload/image/20160601/1464749639787137513.jpg\\\" style=\\\"\\\" title=\\\"1464749639787137513.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464749646465259511.jpg\\\" style=\\\"\\\" title=\\\"1464749646465259511.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464749650215331514.jpg\\\" style=\\\"\\\" title=\\\"1464749650215331514.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464749650731712512.jpg\\\" style=\\\"\\\" title=\\\"1464749650731712512.jpg\\\"/></p><p><br/></p>', '1', '100', '0.01', '0', null, '353', '1', '0', '0', '0', '2016-06-01 10:54:31');
INSERT INTO `goods` VALUES ('287', '1', '简约现代办公家具职员办公桌', '', ' 博伦', '广东', '', '', '<p><img src=\\\"/pic/upload/image/20160601/1464749838121349517.jpg\\\" style=\\\"\\\" title=\\\"1464749838121349517.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464749841508463516.jpg\\\" style=\\\"\\\" title=\\\"1464749841508463516.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464749843496500515.jpg\\\" style=\\\"\\\" title=\\\"1464749843496500515.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464749845320371518.jpg\\\" style=\\\"\\\" title=\\\"1464749845320371518.jpg\\\"/></p><p><br/></p>', '1', '100', '0.01', '0', null, '354', '3', '0', '0', '0', '2016-06-01 10:57:41');
INSERT INTO `goods` VALUES ('288', '1', '上海办公家具屏风办公桌', '', '远创', '上海', '', '', '<p><br/></p><p><br/></p><p><img src=\\\"/pic/upload/image/20160601/1464750114913392520.jpg\\\" style=\\\"\\\" title=\\\"1464750114913392520.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464750118103654522.jpg\\\" style=\\\"\\\" title=\\\"1464750118103654522.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464750118531872518.jpg\\\" style=\\\"\\\" title=\\\"1464750118531872518.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464750120113328515.jpg\\\" style=\\\"\\\" title=\\\"1464750120113328515.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464750123921740524.jpg\\\" style=\\\"\\\" title=\\\"1464750123921740524.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464750123334184523.jpg\\\" style=\\\"\\\" title=\\\"1464750123334184523.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464750125280309526.jpg\\\" style=\\\"\\\" title=\\\"1464750125280309526.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464750126101864525.jpg\\\" style=\\\"\\\" title=\\\"1464750126101864525.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464750130289173527.jpg\\\" style=\\\"\\\" title=\\\"1464750130289173527.jpg\\\"/></p><p><br/></p>', '1', '100', '0.01', '0', null, '355', '2', '0', '0', '0', '2016-06-01 11:03:21');
INSERT INTO `goods` VALUES ('289', '1', '国景老板桌', '', '国景', '广东中山', '', '', '<p>						</p><p><img src=\\\"/pic/upload/image/20160601/1464750434999628528.jpg\\\" style=\\\"\\\" title=\\\"1464750434999628528.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464750434746515529.jpg\\\" style=\\\"\\\" title=\\\"1464750434746515529.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464750437288528530.jpg\\\" style=\\\"\\\" title=\\\"1464750437288528530.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464750438813903531.jpg\\\" style=\\\"\\\" title=\\\"1464750438813903531.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464750439291066532.jpg\\\" style=\\\"\\\" title=\\\"1464750439291066532.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464750440865756533.jpg\\\" style=\\\"\\\" title=\\\"1464750440865756533.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464750441971485534.jpg\\\" style=\\\"\\\" title=\\\"1464750441971485534.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464750442111030535.jpg\\\" style=\\\"\\\" title=\\\"1464750442111030535.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464750443445335536.jpg\\\" style=\\\"\\\" title=\\\"1464750443445335536.jpg\\\"/></p><p><br/></p>', '1', '100', '0.02', '0', '0.01', '356', '3', '0', '0', '0', '2016-06-01 11:07:48');
INSERT INTO `goods` VALUES ('290', '1', '美式乡村复古做旧实木铁艺书桌办公桌椅套装', '', 'Rayzen/瑞桢', '福建泉州', '', '', '<p><img src=\\\"/pic/upload/image/20160601/1464750673124861538.jpg\\\" style=\\\"\\\" title=\\\"1464750673124861538.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464750673376528537.jpg\\\" style=\\\"\\\" title=\\\"1464750673376528537.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464750675674178539.jpg\\\" style=\\\"\\\" title=\\\"1464750675674178539.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464750675786104540.jpg\\\" style=\\\"\\\" title=\\\"1464750675786104540.jpg\\\"/></p><p><br/></p>', '1', '100', '0.01', '0', null, '357', '1', '0', '0', '0', '2016-06-01 11:11:37');
INSERT INTO `goods` VALUES ('291', '1', ' 简约 现代 长条桌 ', '', '荣阅家具', '上海', '', '', '<p>						</p><p><img src=\\\"/pic/upload/image/20160601/1464750887120699542.jpg\\\" style=\\\"\\\" title=\\\"1464750887120699542.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464750890104003543.jpg\\\" style=\\\"\\\" title=\\\"1464750890104003543.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464750890564318541.jpg\\\" style=\\\"\\\" title=\\\"1464750890564318541.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464750891715661544.jpg\\\" style=\\\"\\\" title=\\\"1464750891715661544.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464750893133910545.jpg\\\" style=\\\"\\\" title=\\\"1464750893133910545.jpg\\\"/></p><p><br/></p>', '1', '50', '0.02', '0', '0.01', '358', '2', '0', '0', '0', '2016-06-01 11:15:16');
INSERT INTO `goods` VALUES ('292', '1', '圆形洽谈桌', '', ' 香柏', '江苏徐州', '', '', '<p><img src=\\\"/pic/upload/image/20160601/1464751102132352548.jpg\\\" style=\\\"\\\" title=\\\"1464751102132352548.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464751104121310546.jpg\\\" style=\\\"\\\" title=\\\"1464751104121310546.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464751104901128547.jpg\\\" style=\\\"\\\" title=\\\"1464751104901128547.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464751107136372549.jpg\\\" style=\\\"\\\" title=\\\"1464751107136372549.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464751113113694550.jpg\\\" style=\\\"\\\" title=\\\"1464751113113694550.jpg\\\"/></p><p><br/></p>', '1', '50', '0.01', '0', null, '359', '2', '0', '0', '0', '2016-06-01 11:18:57');
INSERT INTO `goods` VALUES ('293', '1', '广州会议桌办公家具会议长桌会议桌椅组合', '', '太川', '广东', '', '', '<p><img src=\\\"/pic/upload/image/20160601/1464751442551151552.jpg\\\" style=\\\"\\\" title=\\\"1464751442551151552.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464751442129521551.jpg\\\" style=\\\"\\\" title=\\\"1464751442129521551.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464751443348858553.jpg\\\" style=\\\"\\\" title=\\\"1464751443348858553.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464751446680633554.jpg\\\" style=\\\"\\\" title=\\\"1464751446680633554.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464751449118724556.jpg\\\" style=\\\"\\\" title=\\\"1464751449118724556.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464751450968688555.jpg\\\" style=\\\"\\\" title=\\\"1464751450968688555.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464751451850781557.jpg\\\" style=\\\"\\\" title=\\\"1464751451850781557.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464751452120648558.jpg\\\" style=\\\"\\\" title=\\\"1464751452120648558.jpg\\\"/></p><p><br/></p>', '1', '100', '0.01', '0', null, '360', '3', '0', '0', '0', '2016-06-01 11:24:32');
INSERT INTO `goods` VALUES ('294', '1', '洽谈桌椅组合', '', '一品居', '江苏苏州', '', '', '<p><img src=\\\"/pic/upload/image/20160601/1464751775723665559.jpg\\\" style=\\\"\\\" title=\\\"1464751775723665559.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464751776445378562.jpg\\\" style=\\\"\\\" title=\\\"1464751776445378562.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464751777588287561.jpg\\\" style=\\\"\\\" title=\\\"1464751777588287561.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464751777102454563.jpg\\\" style=\\\"\\\" title=\\\"1464751777102454563.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464751778230220564.jpg\\\" style=\\\"\\\" title=\\\"1464751778230220564.jpg\\\"/></p><p><br/></p>', '1', '50', '0.01', '0', null, '361', '5', '0', '0', '0', '2016-06-01 11:30:01');
INSERT INTO `goods` VALUES ('295', '1', '资料柜文件柜档案柜', '', '苏州铭威办公家具', '江苏苏州', '', '', '<p><img src=\\\"/pic/upload/image/20160601/1464752023792344567.jpg\\\" style=\\\"\\\" title=\\\"1464752023792344567.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464752024946311566.jpg\\\" style=\\\"\\\" title=\\\"1464752024946311566.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464752027448348565.jpg\\\" style=\\\"\\\" title=\\\"1464752027448348565.jpg\\\"/></p><p><br/></p>', '1', '20', '0.01', '0', null, '362', '6', '0', '0', '0', '2016-06-01 11:34:03');
INSERT INTO `goods` VALUES ('296', '1', '铁皮柜资料柜', '', 'fuyide', '江苏苏州', '', '', '<p><img src=\\\"/pic/upload/image/20160601/1464752249125175569.jpg\\\" style=\\\"\\\" title=\\\"1464752249125175569.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464752249795786570.jpg\\\" style=\\\"\\\" title=\\\"1464752249795786570.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464752254113965568.jpg\\\" style=\\\"\\\" title=\\\"1464752254113965568.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464752257849017573.jpg\\\" style=\\\"\\\" title=\\\"1464752257849017573.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464752257116233571.jpg\\\" style=\\\"\\\" title=\\\"1464752257116233571.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464752270757359572.jpg\\\" style=\\\"\\\" title=\\\"1464752270757359572.jpg\\\"/></p><p><br/></p>', '1', '20', '0.01', '0', null, '363', '3', '0', '0', '0', '2016-06-01 11:38:10');
INSERT INTO `goods` VALUES ('297', '1', '档案柜', '', ' 致一强', '江苏苏州', '', '', '<p><img src=\\\"/pic/upload/image/20160601/1464752508126986573.jpg\\\" style=\\\"\\\" title=\\\"1464752508126986573.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464752508444690575.jpg\\\" style=\\\"\\\" title=\\\"1464752508444690575.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464752508476146574.jpg\\\" style=\\\"\\\" title=\\\"1464752508476146574.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464752509756068576.jpg\\\" style=\\\"\\\" title=\\\"1464752509756068576.jpg\\\"/></p><p><br/></p>', '1', '15', '0.01', '0', null, '364', '6', '0', '0', '0', '2016-06-01 11:42:19');
INSERT INTO `goods` VALUES ('298', '1', '6六门更衣柜', '', ' 万度', '上海', '', '', '<p><img src=\\\"/pic/upload/image/20160601/1464752696296015578.jpg\\\" style=\\\"\\\" title=\\\"1464752696296015578.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464752696663808579.jpg\\\" style=\\\"\\\" title=\\\"1464752696663808579.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464752700726591580.jpg\\\" style=\\\"\\\" title=\\\"1464752700726591580.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464752703540307577.jpg\\\" style=\\\"\\\" title=\\\"1464752703540307577.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464752704981942581.jpg\\\" style=\\\"\\\" title=\\\"1464752704981942581.jpg\\\"/></p><p><br/></p>', '1', '20', '0.01', '0', null, '365', '5', '0', '0', '0', '2016-06-01 11:45:25');
INSERT INTO `goods` VALUES ('299', '1', '办公沙发单人位', '', ' 高博', '广东', '', '', '<p>						</p><p><img src=\\\"/pic/upload/image/20160601/1464752930130997582.jpg\\\" style=\\\"\\\" title=\\\"1464752930130997582.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464752931172127584.jpg\\\" style=\\\"\\\" title=\\\"1464752931172127584.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464752932119430583.jpg\\\" style=\\\"\\\" title=\\\"1464752932119430583.jpg\\\"/></p><p><br/></p>', '1', '20', '0.01', '0', '0.01', '366', '5', '0', '0', '0', '2016-06-01 11:49:08');
INSERT INTO `goods` VALUES ('300', '1', '办公双人位沙发', '', '徕强', '广东', '', '', '<p><img src=\\\"/pic/upload/image/20160601/1464753147902978587.jpg\\\" style=\\\"\\\" title=\\\"1464753147902978587.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464753151101899585.jpg\\\" style=\\\"\\\" title=\\\"1464753151101899585.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464753154357680588.jpg\\\" style=\\\"\\\" title=\\\"1464753154357680588.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464753156997562586.jpg\\\" style=\\\"\\\" title=\\\"1464753156997562586.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464753157261202589.jpg\\\" style=\\\"\\\" title=\\\"1464753157261202589.jpg\\\"/></p><p><br/></p>', '1', '30', '0.01', '0', null, '367', '5', '0', '0', '0', '2016-06-01 11:52:59');
INSERT INTO `goods` VALUES ('301', '1', '钻石简约现代真皮三人位沙发办公沙发', '', '维艾斯', '广东', '', '', '<p>						</p><p><img src=\\\"/pic/upload/image/20160601/1464753578838775590.jpg\\\" style=\\\"\\\" title=\\\"1464753578838775590.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464753587111495592.jpg\\\" style=\\\"\\\" title=\\\"1464753587111495592.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464753587426703591.jpg\\\" style=\\\"\\\" title=\\\"1464753587426703591.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464753588107514593.jpg\\\" style=\\\"\\\" title=\\\"1464753588107514593.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464753590133579594.jpg\\\" style=\\\"\\\" title=\\\"1464753590133579594.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464753593193901595.jpg\\\" style=\\\"\\\" title=\\\"1464753593193901595.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464753601443356597.jpg\\\" style=\\\"\\\" title=\\\"1464753601443356597.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464753603722933596.jpg\\\" style=\\\"\\\" title=\\\"1464753603722933596.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464753604389050598.jpg\\\" style=\\\"\\\" title=\\\"1464753604389050598.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464753605126306599.jpg\\\" style=\\\"\\\" title=\\\"1464753605126306599.jpg\\\"/></p><p><br/></p>', '1', '30', '0.01', '0', '0.01', '368', '2', '1', '0', '0', '2016-06-01 12:00:56');
INSERT INTO `goods` VALUES ('302', '1', ' 日式布艺沙发', '', '米诺沙发', '广东', '', '', '<p>						</p><p><br/></p><p><br/></p><p><img src=\\\"/pic/upload/image/20160601/1464753881500115602.jpg\\\" style=\\\"\\\" title=\\\"1464753881500115602.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464753882845101601.jpg\\\" style=\\\"\\\" title=\\\"1464753882845101601.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464753882139169603.jpg\\\" style=\\\"\\\" title=\\\"1464753882139169603.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464753885238396606.jpg\\\" style=\\\"\\\" title=\\\"1464753885238396606.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464753888907841605.jpg\\\" style=\\\"\\\" title=\\\"1464753888907841605.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464753888338832604.jpg\\\" style=\\\"\\\" title=\\\"1464753888338832604.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464753890103061607.jpg\\\" style=\\\"\\\" title=\\\"1464753890103061607.jpg\\\"/></p><p><br/></p>', '1', '50', '0.02', '0', '0.01', '369', '6', '1', '0', '0', '2016-06-01 12:05:08');
INSERT INTO `goods` VALUES ('303', '1', '单面超市货架便利店自选超市货架', '', '恒威', '北京', '', '', null, '1', '20', '0.01', '0', null, '370', '6', '0', '0', '1', '2016-06-01 12:10:54');
INSERT INTO `goods` VALUES ('304', '1', '单面超市货架便利店自选超市货架', '', '恒威', '北京', '', '', '<p><img src=\\\"/pic/upload/image/20160601/1464754192114636609.jpg\\\" style=\\\"\\\" title=\\\"1464754192114636609.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464754202391632608.jpg\\\" style=\\\"\\\" title=\\\"1464754202391632608.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464754205471671611.jpg\\\" style=\\\"\\\" title=\\\"1464754205471671611.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464754206149363610.jpg\\\" style=\\\"\\\" title=\\\"1464754206149363610.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464754211105991613.jpg\\\" style=\\\"\\\" title=\\\"1464754211105991613.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464754214111323612.jpg\\\" style=\\\"\\\" title=\\\"1464754214111323612.jpg\\\"/></p><p><br/></p>', '1', '20', '0.01', '0', null, '370', '6', '0', '0', '0', '2016-06-01 12:11:07');
INSERT INTO `goods` VALUES ('305', '1', '仓储货架广州中型仓库货架东莞轻重型库房货', '', '宇鑫', '广东广州', '', '', '<p><img src=\\\"/pic/upload/image/20160601/1464754496129146616.jpg\\\" style=\\\"\\\" title=\\\"1464754496129146616.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464754496486302614.jpg\\\" style=\\\"\\\" title=\\\"1464754496486302614.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464754496110333615.jpg\\\" style=\\\"\\\" title=\\\"1464754496110333615.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464754500750216617.jpg\\\" style=\\\"\\\" title=\\\"1464754500750216617.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464754500138058618.jpg\\\" style=\\\"\\\" title=\\\"1464754500138058618.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464754501127421619.jpg\\\" style=\\\"\\\" title=\\\"1464754501127421619.jpg\\\"/></p><p><br/></p>', '1', '50', '0.01', '0', null, '371', '3', '0', '0', '0', '2016-06-01 12:15:18');
INSERT INTO `goods` VALUES ('306', '1', '房屋卫士聚氨酯防水涂料', '', '房屋卫士', '上海', '', '', '<p><img src=\\\"/pic/upload/image/20160601/1464759622607694621.jpg\\\" style=\\\"\\\" title=\\\"1464759622607694621.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464759629312841622.jpg\\\" style=\\\"\\\" title=\\\"1464759629312841622.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464759629135188623.jpg\\\" style=\\\"\\\" title=\\\"1464759629135188623.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464759630373515620.jpg\\\" style=\\\"\\\" title=\\\"1464759630373515620.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464759632308021625.jpg\\\" style=\\\"\\\" title=\\\"1464759632308021625.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464759632249799624.jpg\\\" style=\\\"\\\" title=\\\"1464759632249799624.jpg\\\"/></p><p><br/></p>', '1', '10', '0.01', '0', null, '260', '4', '0', '0', '0', '2016-06-01 13:41:00');
INSERT INTO `goods` VALUES ('307', '1', '立邦漆 屋得保耐候面漆 外墙乳胶漆 ', '', 'NIPPON PAINT/立邦', '上海', '', '', '<p>						</p><p><img src=\\\"/pic/upload/image/20160601/1464759937883743626.jpg\\\" style=\\\"\\\" title=\\\"1464759937883743626.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464759938410437627.jpg\\\" style=\\\"\\\" title=\\\"1464759938410437627.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464759942791741629.jpg\\\" style=\\\"\\\" title=\\\"1464759942791741629.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464759942114464628.jpg\\\" style=\\\"\\\" title=\\\"1464759942114464628.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464759944204487630.jpg\\\" style=\\\"\\\" title=\\\"1464759944204487630.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464759950380142631.jpg\\\" style=\\\"\\\" title=\\\"1464759950380142631.jpg\\\"/></p><p><br/></p>', '1', '12', '0.01', '0', '0.01', '261', '5', '0', '0', '0', '2016-06-01 13:46:47');
INSERT INTO `goods` VALUES ('308', '1', '三棵树漆 乳胶漆 净味竹炭墙面漆 ', '', 'SKSHU/三棵树', '福建', '', '', '<p>						</p><p><img src=\\\"/pic/upload/image/20160601/1464760231125377633.jpg\\\" style=\\\"\\\" title=\\\"1464760231125377633.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464760237920449634.jpg\\\" style=\\\"\\\" title=\\\"1464760237920449634.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464760242111047635.jpg\\\" style=\\\"\\\" title=\\\"1464760242111047635.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464760245138446632.jpg\\\" style=\\\"\\\" title=\\\"1464760245138446632.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464760252605414638.jpg\\\" style=\\\"\\\" title=\\\"1464760252605414638.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464760258100229637.jpg\\\" style=\\\"\\\" title=\\\"1464760258100229637.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464760260790235636.jpg\\\" style=\\\"\\\" title=\\\"1464760260790235636.jpg\\\"/></p><p><br/></p>', '1', '15', '0.01', '0', '0.01', '262', '6', '0', '0', '0', '2016-06-01 13:51:36');
INSERT INTO `goods` VALUES ('309', '1', '米素儿童壁纸胶套装墙纸胶', '', '米素', '江苏常州', '', '', null, '1', '15', '0.01', '0', null, '263', '5', '0', '0', '1', '2016-06-01 13:56:18');
INSERT INTO `goods` VALUES ('310', '1', '米素儿童壁纸胶套装墙纸胶', '', '米素', '江苏常州', '', '', '<p><img src=\\\"/pic/upload/image/20160601/1464760534293046640.jpg\\\" style=\\\"\\\" title=\\\"1464760534293046640.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464760537284009641.jpg\\\" style=\\\"\\\" title=\\\"1464760537284009641.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464760546392794642.jpg\\\" style=\\\"\\\" title=\\\"1464760546392794642.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464760548111882643.jpg\\\" style=\\\"\\\" title=\\\"1464760548111882643.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464760555775518644.jpg\\\" style=\\\"\\\" title=\\\"1464760555775518644.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464760556104162645.jpg\\\" style=\\\"\\\" title=\\\"1464760556104162645.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464760561140843639.jpg\\\" style=\\\"\\\" title=\\\"1464760561140843639.jpg\\\"/></p><p><br/></p>', '1', '15', '0.01', '0', null, '263', '5', '0', '0', '0', '2016-06-01 13:56:23');
INSERT INTO `goods` VALUES ('311', '1', '儿童墙纸儿童房卧室壁纸无纺布卡通条纹墙纸', '', '米素', '江苏常州', '', '', '<p><img src=\\\"/pic/upload/image/20160601/1464760817823284645.jpg\\\" style=\\\"\\\" title=\\\"1464760817823284645.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464760820906937646.jpg\\\" style=\\\"\\\" title=\\\"1464760820906937646.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464760821118883647.jpg\\\" style=\\\"\\\" title=\\\"1464760821118883647.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464760824942998648.jpg\\\" style=\\\"\\\" title=\\\"1464760824942998648.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464760833328332651.jpg\\\" style=\\\"\\\" title=\\\"1464760833328332651.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464760833108999650.jpg\\\" style=\\\"\\\" title=\\\"1464760833108999650.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/1464760835615569649.jpg\\\" style=\\\"\\\" title=\\\"1464760835615569649.jpg\\\"/></p><p><br/></p>', '1', '5', '0.01', '0', null, '264', '6', '0', '0', '0', '2016-06-01 14:00:50');
INSERT INTO `goods` VALUES ('312', '1', '美式乡村壁纸 ', '', ' Gray Girl/灰姑娘', '上海', '', '', null, '1', '5', '0.01', '0', null, '265', '6', '0', '0', '1', '2016-06-01 14:05:31');
INSERT INTO `goods` VALUES ('313', '1', '美式乡村壁纸 ', '', ' Gray Girl/灰姑娘', '上海', '', '', '<p><img src=\\\"/pic/upload/image/20160601/14647610959855993.jpg\\\" style=\\\"\\\" title=\\\"14647610959855993.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647610969546172.jpg\\\" style=\\\"\\\" title=\\\"14647610969546172.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647611007022784.jpg\\\" style=\\\"\\\" title=\\\"14647611007022784.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647611005441795.jpg\\\" style=\\\"\\\" title=\\\"14647611005441795.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647611011011031.jpg\\\" style=\\\"\\\" title=\\\"14647611011011031.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647611046636366.jpg\\\" style=\\\"\\\" title=\\\"14647611046636366.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647611041329767.jpg\\\" style=\\\"\\\" title=\\\"14647611041329767.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647611101246078.jpg\\\" style=\\\"\\\" title=\\\"14647611101246078.jpg\\\"/></p><p><br/></p>', '1', '5', '0.01', '0', null, '265', '6', '0', '0', '0', '2016-06-01 14:05:39');
INSERT INTO `goods` VALUES ('314', '1', '无纺布墙纸精雕田园壁纸温馨客厅', '', 'Delfino/德尔菲诺', '上海', '', '', '<p><img src=\\\"/pic/upload/image/20160601/14647613061205013.jpg\\\" style=\\\"\\\" title=\\\"14647613061205013.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647613062328882.jpg\\\" style=\\\"\\\" title=\\\"14647613062328882.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647613091283331.jpg\\\" style=\\\"\\\" title=\\\"14647613091283331.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647613131170554.jpg\\\" style=\\\"\\\" title=\\\"14647613131170554.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647613137555086.jpg\\\" style=\\\"\\\" title=\\\"14647613137555086.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647613145874695.jpg\\\" style=\\\"\\\" title=\\\"14647613145874695.jpg\\\"/></p><p><br/></p>', '1', '5', '0.01', '0', null, '266', '8', '0', '0', '0', '2016-06-01 14:08:50');
INSERT INTO `goods` VALUES ('315', '1', '竖条纹现代简约壁纸', '', ' HBSIR/海宝先生', '上海', '', '', null, '1', '5', '0.01', '0', null, '267', '6', '0', '0', '1', '2016-06-01 14:12:59');
INSERT INTO `goods` VALUES ('316', '1', '竖条纹现代简约壁纸', '', ' HBSIR/海宝先生', '上海', '', '', '<p><img src=\\\"/pic/upload/image/20160601/14647615411052722.jpg\\\" style=\\\"\\\" title=\\\"14647615411052722.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647615442310801.jpg\\\" style=\\\"\\\" title=\\\"14647615442310801.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647615451113063.jpg\\\" style=\\\"\\\" title=\\\"14647615451113063.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647615481374215.jpg\\\" style=\\\"\\\" title=\\\"14647615481374215.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647615501277186.jpg\\\" style=\\\"\\\" title=\\\"14647615501277186.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647615501387434.jpg\\\" style=\\\"\\\" title=\\\"14647615501387434.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647615564277787.jpg\\\" style=\\\"\\\" title=\\\"14647615564277787.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647615569115858.jpg\\\" style=\\\"\\\" title=\\\"14647615569115858.jpg\\\"/></p><p><br/></p>', '1', '5', '0.01', '0', null, '267', '6', '0', '0', '0', '2016-06-01 14:13:12');
INSERT INTO `goods` VALUES ('317', '1', '欧式壁纸客厅电视背景墙纸卧室温馨满铺无纺', '', '本木', '福建', '', '', '<p><img src=\\\"/pic/upload/image/20160601/14647618251000791.jpg\\\" style=\\\"\\\" title=\\\"14647618251000791.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647618277913542.jpg\\\" style=\\\"\\\" title=\\\"14647618277913542.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647618274170203.jpg\\\" style=\\\"\\\" title=\\\"14647618274170203.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647618298071044.jpg\\\" style=\\\"\\\" title=\\\"14647618298071044.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647618311096065.jpg\\\" style=\\\"\\\" title=\\\"14647618311096065.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647618331253947.jpg\\\" style=\\\"\\\" title=\\\"14647618331253947.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647618335914286.jpg\\\" style=\\\"\\\" title=\\\"14647618335914286.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647618368326218.jpg\\\" style=\\\"\\\" title=\\\"14647618368326218.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647618391151789.jpg\\\" style=\\\"\\\" title=\\\"14647618391151789.jpg\\\"/></p><p><br/></p>', '1', '5', '0.01', '0', null, '268', '9', '0', '0', '0', '2016-06-01 14:17:42');
INSERT INTO `goods` VALUES ('318', '1', '瓷砖背景墙欧式客厅电视背景墙微晶石影视艺', '', '阿兰贝尔', '广东', '', '', '<p><img src=\\\"/pic/upload/image/20160601/14647620456235731.jpg\\\" style=\\\"\\\" title=\\\"14647620456235731.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647620461362473.jpg\\\" style=\\\"\\\" title=\\\"14647620461362473.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647620471109702.jpg\\\" style=\\\"\\\" title=\\\"14647620471109702.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647620483838434.jpg\\\" style=\\\"\\\" title=\\\"14647620483838434.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647620501329255.jpg\\\" style=\\\"\\\" title=\\\"14647620501329255.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647620548932536.jpg\\\" style=\\\"\\\" title=\\\"14647620548932536.jpg\\\"/></p><p><br/></p>', '1', '10', '0.01', '0', null, '269', '10', '0', '0', '0', '2016-06-01 14:21:16');
INSERT INTO `goods` VALUES ('319', '1', '卫生间厨房阳台瓷砖地中海腰线拼', '', '森摩', '浙江温州', '', '', '<p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14658062881184403.jpg\\\" style=\\\"\\\" title=\\\"14658062881184403.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14658062932603422.jpg\\\" style=\\\"\\\" title=\\\"14658062932603422.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14658062957978091.jpg\\\" style=\\\"\\\" title=\\\"14658062957978091.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14658063017357576.jpg\\\" style=\\\"\\\" title=\\\"14658063017357576.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14658063021169304.jpg\\\" style=\\\"\\\" title=\\\"14658063021169304.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14658063031137455.jpg\\\" style=\\\"\\\" title=\\\"14658063031137455.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14658063101075927.jpg\\\" style=\\\"\\\" title=\\\"14658063101075927.jpg\\\"/></p><p><br/></p>', '1', '1', '0.01', '0', '0.01', '270', '10', '0', '0', '0', '2016-06-01 14:25:35');
INSERT INTO `goods` VALUES ('320', '1', '别墅文化石外墙砖瓷砖', '', '青山文化石', '浙江绍兴', '', '', '<p><img src=\\\"/pic/upload/image/20160601/14647626934045842.jpg\\\" style=\\\"\\\" title=\\\"14647626934045842.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647626949727331.jpg\\\" style=\\\"\\\" title=\\\"14647626949727331.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647626981187673.jpg\\\" style=\\\"\\\" title=\\\"14647626981187673.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647626994965434.jpg\\\" style=\\\"\\\" title=\\\"14647626994965434.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647626993533336.jpg\\\" style=\\\"\\\" title=\\\"14647626993533336.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647627041415748.jpg\\\" style=\\\"\\\" title=\\\"14647627041415748.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647627065361327.jpg\\\" style=\\\"\\\" title=\\\"14647627065361327.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647627134878519.jpg\\\" style=\\\"\\\" title=\\\"14647627134878519.jpg\\\"/></p><p><br/></p>', '1', '5', '0.01', '0', null, '271', '60', '0', '0', '0', '2016-06-01 14:32:19');
INSERT INTO `goods` VALUES ('321', '1', '孔雀鱼凤尾图欧式水晶玻璃马赛克电视背景墙', '', 'Guppies Mosaio/孔雀鱼马赛', '广东', '', '', '<p><img src=\\\"/pic/upload/image/20160601/14647629624674543.jpg\\\" style=\\\"\\\" title=\\\"14647629624674543.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647629679090892.jpg\\\" style=\\\"\\\" title=\\\"14647629679090892.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647629681174634.jpg\\\" style=\\\"\\\" title=\\\"14647629681174634.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647629717493125.jpg\\\" style=\\\"\\\" title=\\\"14647629717493125.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647629726133751.jpg\\\" style=\\\"\\\" title=\\\"14647629726133751.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647629744905196.jpg\\\" style=\\\"\\\" title=\\\"14647629744905196.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647629752738547.jpg\\\" style=\\\"\\\" title=\\\"14647629752738547.jpg\\\"/></p><p><br/></p>', '1', '5', '0.01', '0', null, '272', '20', '0', '0', '0', '2016-06-01 14:37:08');
INSERT INTO `goods` VALUES ('322', '1', '金刚石全抛釉防滑地板砖客厅地砖800800金刚釉', '', '九零石代', '广东', '', '', '<p><img src=\\\"/pic/upload/image/20160601/14647632421394011.jpg\\\" style=\\\"\\\" title=\\\"14647632421394011.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647632433605203.jpg\\\" style=\\\"\\\" title=\\\"14647632433605203.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647632461132254.jpg\\\" style=\\\"\\\" title=\\\"14647632461132254.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647632511599926.jpg\\\" style=\\\"\\\" title=\\\"14647632511599926.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647632531747522.jpg\\\" style=\\\"\\\" title=\\\"14647632531747522.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647632563029865.jpg\\\" style=\\\"\\\" title=\\\"14647632563029865.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647632651116678.jpg\\\" style=\\\"\\\" title=\\\"14647632651116678.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647632674346207.jpg\\\" style=\\\"\\\" title=\\\"14647632674346207.jpg\\\"/></p><p><br/></p>', '1', '5', '0.01', '0', null, '273', '20', '0', '0', '0', '2016-06-01 14:41:23');
INSERT INTO `goods` VALUES ('323', '1', '墙砖客厅电视背景墙瓷砖 瓷片卫生间瓷砖400x8', '', 'XIAOMI CERAMICS/小', '广东', '', '', null, '1', '5', '0.01', '0', null, '274', '50', '0', '0', '1', '2016-06-01 14:45:16');
INSERT INTO `goods` VALUES ('324', '1', '墙砖客厅电视背景墙瓷砖 瓷片卫生间瓷砖400x8', '', 'XIAOMI CERAMICS/小', '广东', '', '', '<p><img src=\\\"/pic/upload/image/20160601/14647634981326363.jpg\\\" style=\\\"\\\" title=\\\"14647634981326363.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647634981291902.jpg\\\" style=\\\"\\\" title=\\\"14647634981291902.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647635011439844.jpg\\\" style=\\\"\\\" title=\\\"14647635011439844.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647635038394635.jpg\\\" style=\\\"\\\" title=\\\"14647635038394635.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647635048465641.jpg\\\" style=\\\"\\\" title=\\\"14647635048465641.jpg\\\"/></p><p><br/></p>', '1', '5', '0.01', '0', null, '274', '50', '0', '0', '0', '2016-06-01 14:45:21');
INSERT INTO `goods` VALUES ('325', '1', '春红竹地板 中式典雅时尚对散节亮哑光1030*130', '', '春红', '江西', '', '', '<p><img src=\\\"/pic/upload/image/20160601/14647637361154063.jpg\\\" style=\\\"\\\" title=\\\"14647637361154063.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647637421219901.jpg\\\" style=\\\"\\\" title=\\\"14647637421219901.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647637433505362.jpg\\\" style=\\\"\\\" title=\\\"14647637433505362.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647637484604404.jpg\\\" style=\\\"\\\" title=\\\"14647637484604404.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647637541018697.jpg\\\" style=\\\"\\\" title=\\\"14647637541018697.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647637555729685.jpg\\\" style=\\\"\\\" title=\\\"14647637555729685.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647637551317806.jpg\\\" style=\\\"\\\" title=\\\"14647637551317806.jpg\\\"/></p><p><br/></p>', '1', '5', '0.01', '0', null, '275', '20', '0', '0', '0', '2016-06-01 14:49:40');
INSERT INTO `goods` VALUES ('326', '1', '橡木纯实木地板 ', '', '赛杉', '浙江湖州', '', '', '<p><img src=\\\"/pic/upload/image/20160601/14647639661135951.jpg\\\" style=\\\"\\\" title=\\\"14647639661135951.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647639673566902.jpg\\\" style=\\\"\\\" title=\\\"14647639673566902.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647639688605923.jpg\\\" style=\\\"\\\" title=\\\"14647639688605923.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647639721209535.jpg\\\" style=\\\"\\\" title=\\\"14647639721209535.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647639726199586.jpg\\\" style=\\\"\\\" title=\\\"14647639726199586.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647639731386654.jpg\\\" style=\\\"\\\" title=\\\"14647639731386654.jpg\\\"/></p><p><br/></p>', '1', '5', '0.01', '0', null, '276', '20', '0', '0', '0', '2016-06-01 14:53:14');
INSERT INTO `goods` VALUES ('327', '1', ' 实木复合地板', '', ' 生活家', '广东中山', '', '', '<p><img src=\\\"/pic/upload/image/20160601/14647642367873521.jpg\\\" style=\\\"\\\" title=\\\"14647642367873521.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647642381075322.jpg\\\" style=\\\"\\\" title=\\\"14647642381075322.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647642427844263.jpg\\\" style=\\\"\\\" title=\\\"14647642427844263.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647642451970425.jpg\\\" style=\\\"\\\" title=\\\"14647642451970425.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647642501350557.jpg\\\" style=\\\"\\\" title=\\\"14647642501350557.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647642515411246.jpg\\\" style=\\\"\\\" title=\\\"14647642515411246.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647642549602114.jpg\\\" style=\\\"\\\" title=\\\"14647642549602114.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647642584982648.jpg\\\" style=\\\"\\\" title=\\\"14647642584982648.jpg\\\"/></p><p><br/></p>', '1', '5', '0.01', '0', null, '277', '50', '0', '0', '1', '2016-06-01 14:57:53');
INSERT INTO `goods` VALUES ('328', '1', ' 实木复合地板', '', ' 生活家', '广东中山', '', '', '<p><img src=\\\"/pic/upload/image/20160601/14647642367873521.jpg\\\" style=\\\"\\\" title=\\\"14647642367873521.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647642381075322.jpg\\\" style=\\\"\\\" title=\\\"14647642381075322.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647642427844263.jpg\\\" style=\\\"\\\" title=\\\"14647642427844263.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647642451970425.jpg\\\" style=\\\"\\\" title=\\\"14647642451970425.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647642501350557.jpg\\\" style=\\\"\\\" title=\\\"14647642501350557.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647642515411246.jpg\\\" style=\\\"\\\" title=\\\"14647642515411246.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647642549602114.jpg\\\" style=\\\"\\\" title=\\\"14647642549602114.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647642584982648.jpg\\\" style=\\\"\\\" title=\\\"14647642584982648.jpg\\\"/></p><p><br/></p>', '1', '5', '0.01', '0', null, '277', '50', '0', '0', '0', '2016-06-01 14:57:57');
INSERT INTO `goods` VALUES ('329', '1', '圣象地板F4星10mm浮雕面F卫士三色可选 强化复�', '', '圣象', '江苏镇江', '', '', null, '1', '5', '0.01', '0', null, '278', '50', '0', '0', '1', '2016-06-01 15:03:08');
INSERT INTO `goods` VALUES ('330', '1', '圣象地板 强化地板', '', '圣象', '上海', '', '', '<p><img src=\\\"/pic/upload/image/20160606/14651908751204972.jpg\\\" style=\\\"\\\" title=\\\"14651908751204972.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160606/14651908761405761.jpg\\\" style=\\\"\\\" title=\\\"14651908761405761.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160606/14651908891012453.jpg\\\" style=\\\"\\\" title=\\\"14651908891012453.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160606/14651908913442554.jpg\\\" style=\\\"\\\" title=\\\"14651908913442554.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160606/14651908947653636.jpg\\\" style=\\\"\\\" title=\\\"14651908947653636.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160606/14651908951165217.jpg\\\" style=\\\"\\\" title=\\\"14651908951165217.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160606/14651908961142235.jpg\\\" style=\\\"\\\" title=\\\"14651908961142235.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160606/14651908992280688.jpg\\\" style=\\\"\\\" title=\\\"14651908992280688.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160606/14651909061338809.jpg\\\" style=\\\"\\\" title=\\\"14651909061338809.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160606/146519091010170110.jpg\\\" style=\\\"\\\" title=\\\"146519091010170110.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160606/146519091269702813.jpg\\\" style=\\\"\\\" title=\\\"146519091269702813.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160606/146519091513845012.jpg\\\" style=\\\"\\\" title=\\\"146519091513845012.jpg\\\"/></p><p><br/></p>', '1', '5', '0.01', '0', '0.01', '278', '50', '0', '0', '0', '2016-06-01 15:03:09');
INSERT INTO `goods` VALUES ('331', '1', '圣象地板F4星10mm浮雕面F卫士三色可选 强化复�', '', '圣象', '江苏镇江', '', '', '<p><img src=\\\"/pic/upload/image/20160601/14647645552943371.jpg\\\" style=\\\"\\\" title=\\\"14647645552943371.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647645555375532.jpg\\\" style=\\\"\\\" title=\\\"14647645555375532.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647645596605374.jpg\\\" style=\\\"\\\" title=\\\"14647645596605374.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647645631307823.jpg\\\" style=\\\"\\\" title=\\\"14647645631307823.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647645644669806.jpg\\\" style=\\\"\\\" title=\\\"14647645644669806.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647645681321507.jpg\\\" style=\\\"\\\" title=\\\"14647645681321507.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647645699051305.jpg\\\" style=\\\"\\\" title=\\\"14647645699051305.jpg\\\"/></p><p><br/></p>', '1', '5', '0.01', '0', null, '278', '50', '0', '0', '1', '2016-06-01 15:03:16');
INSERT INTO `goods` VALUES ('332', '1', '德高内墙防潮腻子粉 耐水白色补缝腻子膏', '', 'Davco/德高', '广东广州', '', '', null, '1', '10', '0.01', '0', null, '279', '20', '0', '0', '1', '2016-06-01 15:07:04');
INSERT INTO `goods` VALUES ('333', '1', '德高内墙防潮腻子粉 耐水白色补缝腻子膏', '', 'Davco/德高', '广东广州', '', '', '<p><img src=\\\"/pic/upload/image/20160601/14647647821511273.jpg\\\" style=\\\"\\\" title=\\\"14647647821511273.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647647867754322.jpg\\\" style=\\\"\\\" title=\\\"14647647867754322.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647647883691261.jpg\\\" style=\\\"\\\" title=\\\"14647647883691261.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647647949707966.jpg\\\" style=\\\"\\\" title=\\\"14647647949707966.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647647961134234.jpg\\\" style=\\\"\\\" title=\\\"14647647961134234.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647647993250625.jpg\\\" style=\\\"\\\" title=\\\"14647647993250625.jpg\\\"/></p><p><br/></p>', '1', '10', '0.01', '0', null, '279', '20', '0', '0', '0', '2016-06-01 15:07:09');
INSERT INTO `goods` VALUES ('334', '1', '刷墙涂刷工具', '', 'Fujiwara/藤原', '浙江台州', '', '', '<p><img src=\\\"/pic/upload/image/20160601/14647650198525452.jpg\\\" style=\\\"\\\" title=\\\"14647650198525452.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647650219232033.jpg\\\" style=\\\"\\\" title=\\\"14647650219232033.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647650223574651.jpg\\\" style=\\\"\\\" title=\\\"14647650223574651.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647650341371594.jpg\\\" style=\\\"\\\" title=\\\"14647650341371594.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647650351079407.jpg\\\" style=\\\"\\\" title=\\\"14647650351079407.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647650352165785.jpg\\\" style=\\\"\\\" title=\\\"14647650352165785.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647650371011419.jpg\\\" style=\\\"\\\" title=\\\"14647650371011419.jpg\\\"/></p><p><br/></p>', '1', '6', '0.01', '0', null, '280', '5', '0', '0', '0', '2016-06-01 15:11:23');
INSERT INTO `goods` VALUES ('335', '1', '双组份瓷砖专用填缝剂', '', '晏记', '上海', '', '', '<p><img src=\\\"/pic/upload/image/20160601/14647652551044893.jpg\\\" style=\\\"\\\" title=\\\"14647652551044893.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647652597427284.jpg\\\" style=\\\"\\\" title=\\\"14647652597427284.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647652638901981.jpg\\\" style=\\\"\\\" title=\\\"14647652638901981.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647652646902722.jpg\\\" style=\\\"\\\" title=\\\"14647652646902722.jpg\\\"/></p><p><br/></p>', '1', '3', '0.01', '0', null, '281', '30', '0', '0', '0', '2016-06-01 15:14:42');
INSERT INTO `goods` VALUES ('336', '1', '汉高百得玻璃胶 ', '', 'Pattex/百得', '上海', '', '', '<p><img src=\\\"/pic/upload/image/20160601/14647655481275763.jpg\\\" style=\\\"\\\" title=\\\"14647655481275763.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647655523735151.jpg\\\" style=\\\"\\\" title=\\\"14647655523735151.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647655537418672.jpg\\\" style=\\\"\\\" title=\\\"14647655537418672.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647655571613695.jpg\\\" style=\\\"\\\" title=\\\"14647655571613695.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647655631284244.jpg\\\" style=\\\"\\\" title=\\\"14647655631284244.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647655683127988.jpg\\\" style=\\\"\\\" title=\\\"14647655683127988.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647655711251457.jpg\\\" style=\\\"\\\" title=\\\"14647655711251457.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647655724232606.jpg\\\" style=\\\"\\\" title=\\\"14647655724232606.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647655831224949.jpg\\\" style=\\\"\\\" title=\\\"14647655831224949.jpg\\\"/></p><p><br/></p>', '1', '3', '0.01', '0', null, '282', '20', '0', '0', '0', '2016-06-01 15:20:02');
INSERT INTO `goods` VALUES ('337', '1', '防腐木实木地板室外地板', '', ' 沪涛', '上海', '', '', '<p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14658058411148431.jpg\\\" style=\\\"\\\" title=\\\"14658058411148431.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14658058451281092.jpg\\\" style=\\\"\\\" title=\\\"14658058451281092.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14658058456962113.jpg\\\" style=\\\"\\\" title=\\\"14658058456962113.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14658058469775964.jpg\\\" style=\\\"\\\" title=\\\"14658058469775964.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14658058498262107.jpg\\\" style=\\\"\\\" title=\\\"14658058498262107.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14658058521115298.jpg\\\" style=\\\"\\\" title=\\\"14658058521115298.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14658058535332925.jpg\\\" style=\\\"\\\" title=\\\"14658058535332925.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14658058549585756.jpg\\\" style=\\\"\\\" title=\\\"14658058549585756.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14658058563035899.jpg\\\" style=\\\"\\\" title=\\\"14658058563035899.jpg\\\"/></p><p><br/></p>', '1', '5', '0.01', '0', '0.01', '283', '50', '0', '0', '0', '2016-06-01 15:26:14');
INSERT INTO `goods` VALUES ('338', '1', '杉木直拼板指接板集成板材', '', '百强', '上海', '', '', '<p><img src=\\\"/pic/upload/image/20160601/14647663357289581.jpg\\\" style=\\\"\\\" title=\\\"14647663357289581.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647663429585752.jpg\\\" style=\\\"\\\" title=\\\"14647663429585752.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647663502850853.jpg\\\" style=\\\"\\\" title=\\\"14647663502850853.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647663551778934.jpg\\\" style=\\\"\\\" title=\\\"14647663551778934.jpg\\\"/></p><p><br/></p>', '1', '5', '0.01', '0', null, '284', '50', '0', '0', '0', '2016-06-01 15:33:24');
INSERT INTO `goods` VALUES ('339', '1', '六甲芯免漆板进口实木芯细木工板三聚氰胺双', '', '声达', '上海', '', '', '<p><img src=\\\"/pic/upload/image/20160601/14647666221991511.jpg\\\" style=\\\"\\\" title=\\\"14647666221991511.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647666336653574.jpg\\\" style=\\\"\\\" title=\\\"14647666336653574.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647666515192213.jpg\\\" style=\\\"\\\" title=\\\"14647666515192213.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647666525567452.jpg\\\" style=\\\"\\\" title=\\\"14647666525567452.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647666699578876.jpg\\\" style=\\\"\\\" title=\\\"14647666699578876.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647666851051357.jpg\\\" style=\\\"\\\" title=\\\"14647666851051357.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647667486205185.jpg\\\" style=\\\"\\\" title=\\\"14647667486205185.jpg\\\"/></p><p><br/></p>', '1', '6', '0.01', '0', null, '285', '50', '0', '0', '0', '2016-06-01 15:40:06');
INSERT INTO `goods` VALUES ('340', '1', '专利冷热三角阀 4分止水阀门水阀', '', '百汉', '百汉', '', '', '<p><img src=\\\"/pic/upload/image/20160601/14647685625212862.jpg\\\" style=\\\"\\\" title=\\\"14647685625212862.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647685632345231.jpg\\\" style=\\\"\\\" title=\\\"14647685632345231.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647685693018243.jpg\\\" style=\\\"\\\" title=\\\"14647685693018243.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647685711373355.jpg\\\" style=\\\"\\\" title=\\\"14647685711373355.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647685735213736.jpg\\\" style=\\\"\\\" title=\\\"14647685735213736.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647685749157164.jpg\\\" style=\\\"\\\" title=\\\"14647685749157164.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647685771218577.jpg\\\" style=\\\"\\\" title=\\\"14647685771218577.jpg\\\"/></p><p><br/></p>', '1', '2', '0.01', '0', null, '286', '10', '0', '0', '0', '2016-06-01 16:09:51');
INSERT INTO `goods` VALUES ('341', '1', 'PPR内丝弯头 内牙变径弯头 ', '', '天一金牛', '浙江绍兴', '', '', '<p>						</p><p><img src=\\\"/pic/upload/image/20160601/14647687632492831.jpg\\\" style=\\\"\\\" title=\\\"14647687632492831.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647687638752662.jpg\\\" style=\\\"\\\" title=\\\"14647687638752662.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647687686227124.jpg\\\" style=\\\"\\\" title=\\\"14647687686227124.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647687701428653.jpg\\\" style=\\\"\\\" title=\\\"14647687701428653.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647687721198005.jpg\\\" style=\\\"\\\" title=\\\"14647687721198005.jpg\\\"/></p><p><br/></p>', '1', '1', '0.01', '0', '0.01', '287', '50', '0', '0', '0', '2016-06-01 16:13:04');
INSERT INTO `goods` VALUES ('342', '1', 'PPR水管 冷热通用自来水管材 ', '', 'VASEN/伟星', '浙江台州', '', '', '<p>						</p><p><br/></p><p><img src=\\\"/pic/upload/image/20160601/14647689631364492.jpg\\\" style=\\\"\\\" title=\\\"14647689631364492.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647689639547031.jpg\\\" style=\\\"\\\" title=\\\"14647689639547031.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647689749488934.jpg\\\" style=\\\"\\\" title=\\\"14647689749488934.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647689761126055.jpg\\\" style=\\\"\\\" title=\\\"14647689761126055.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647689765424583.jpg\\\" style=\\\"\\\" title=\\\"14647689765424583.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647689771331276.jpg\\\" style=\\\"\\\" title=\\\"14647689771331276.jpg\\\"/></p><p><br/></p>', '1', '2', '0.01', '0', '0.01', '288', '50', '0', '0', '0', '2016-06-01 16:16:45');
INSERT INTO `goods` VALUES ('343', '1', '日本TOP超越快速万用钳,万能快速活动扳手', '', 'TOP', '广东广州', '', '', '<p><img src=\\\"/pic/upload/image/20160601/14647691765669002.jpg\\\" style=\\\"\\\" title=\\\"14647691765669002.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647691785452551.jpg\\\" style=\\\"\\\" title=\\\"14647691785452551.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647691822304783.jpg\\\" style=\\\"\\\" title=\\\"14647691822304783.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647691885055375.jpg\\\" style=\\\"\\\" title=\\\"14647691885055375.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647691918105894.jpg\\\" style=\\\"\\\" title=\\\"14647691918105894.jpg\\\"/></p><p><br/></p>', '1', '3', '0.01', '0', null, '7', '5', '0', '0', '0', '2016-06-01 16:20:06');
INSERT INTO `goods` VALUES ('344', '1', '螺丝刀组合笔记本电脑十字螺丝批起子改锥梅', '', 'Sata/世达', '上海', '', '', null, '1', '2', '0.01', '0', null, '217', '50', '0', '0', '1', '2016-06-01 16:26:32');
INSERT INTO `goods` VALUES ('345', '1', '螺丝刀组合笔记本电脑十字螺丝批起子改锥梅', '', 'Sata/世达', '上海', '', '', '<p><img src=\\\"/pic/upload/image/20160601/146476957411303111.jpg\\\" style=\\\"\\\" title=\\\"146476957411303111.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/146476957594566612.jpg\\\" style=\\\"\\\" title=\\\"146476957594566612.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/146476957711684414.jpg\\\" style=\\\"\\\" title=\\\"146476957711684414.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/146476957918736013.jpg\\\" style=\\\"\\\" title=\\\"146476957918736013.jpg\\\"/></p><p><br/></p>', '1', '2', '0.01', '0', null, '217', '50', '0', '0', '0', '2016-06-01 16:26:40');
INSERT INTO `goods` VALUES ('346', '1', '包塑八角锤磅锤 装修锤拆墙铁锤子家', '', '大汉力量', '山东', '', '', '<p>						</p><p><img src=\\\"/pic/upload/image/20160601/14647697876619142.jpg\\\" style=\\\"\\\" title=\\\"14647697876619142.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647697887525393.jpg\\\" style=\\\"\\\" title=\\\"14647697887525393.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647697908974274.jpg\\\" style=\\\"\\\" title=\\\"14647697908974274.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647697911316601.jpg\\\" style=\\\"\\\" title=\\\"14647697911316601.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647697934001956.jpg\\\" style=\\\"\\\" title=\\\"14647697934001956.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647697952456685.jpg\\\" style=\\\"\\\" title=\\\"14647697952456685.jpg\\\"/></p><p><br/></p>', '1', '1', '0.01', '0', '0.01', '218', '20', '0', '0', '0', '2016-06-01 16:30:18');
INSERT INTO `goods` VALUES ('347', '1', '飞炉锯子', '', ' R\\\\\\\'DEER/飞鹿', '广东深圳', '', '', '<p>						</p><p><img src=\\\"/pic/upload/image/20160601/14647700426533082.jpg\\\" style=\\\"\\\" title=\\\"14647700426533082.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647700431550433.jpg\\\" style=\\\"\\\" title=\\\"14647700431550433.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647700449417071.jpg\\\" style=\\\"\\\" title=\\\"14647700449417071.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647700478183355.jpg\\\" style=\\\"\\\" title=\\\"14647700478183355.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647700488744054.jpg\\\" style=\\\"\\\" title=\\\"14647700488744054.jpg\\\"/></p><p><br/></p>', '1', '2', '0.01', '0', '0.01', '219', '5', '0', '0', '0', '2016-06-01 16:34:23');
INSERT INTO `goods` VALUES ('348', '1', '得力测量工具', '', 'Deli/得力', '北京', '', '', '<p>						</p><p><img src=\\\"/pic/upload/image/20160601/14647702436868733.jpg\\\" style=\\\"\\\" title=\\\"14647702436868733.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647702461506111.jpg\\\" style=\\\"\\\" title=\\\"14647702461506111.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647702508527172.jpg\\\" style=\\\"\\\" title=\\\"14647702508527172.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647702524631085.jpg\\\" style=\\\"\\\" title=\\\"14647702524631085.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647702541326714.jpg\\\" style=\\\"\\\" title=\\\"14647702541326714.jpg\\\"/></p><p><br/></p>', '1', '1', '0.01', '0', '0.01', '220', '6', '0', '0', '0', '2016-06-01 16:37:43');
INSERT INTO `goods` VALUES ('349', '1', '金尚曲线锯多功能电锯拉花锯金属锯手电锯木', '', ' KSUN/金尚', '浙江金华', '', '', '<p><img src=\\\"/pic/upload/image/20160601/14647707144448191.jpg\\\" style=\\\"\\\" title=\\\"14647707144448191.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647707179759603.jpg\\\" style=\\\"\\\" title=\\\"14647707179759603.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647707197272802.jpg\\\" style=\\\"\\\" title=\\\"14647707197272802.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647707243055254.jpg\\\" style=\\\"\\\" title=\\\"14647707243055254.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647707301022696.jpg\\\" style=\\\"\\\" title=\\\"14647707301022696.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647707344906915.jpg\\\" style=\\\"\\\" title=\\\"14647707344906915.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647707346161297.jpg\\\" style=\\\"\\\" title=\\\"14647707346161297.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647707381126578.jpg\\\" style=\\\"\\\" title=\\\"14647707381126578.jpg\\\"/></p><p><br/></p>', '1', '1', '0.01', '0', null, '221', '6', '0', '0', '0', '2016-06-01 16:46:20');
INSERT INTO `goods` VALUES ('350', '1', '角磨机切割机打磨机磨光机抛光机', '', '东成', '江苏淮安', '', '', '<p><img src=\\\"/pic/upload/image/20160601/14647712191338502.jpg\\\" style=\\\"\\\" title=\\\"14647712191338502.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647712211238023.jpg\\\" style=\\\"\\\" title=\\\"14647712211238023.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647712275630271.jpg\\\" style=\\\"\\\" title=\\\"14647712275630271.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647712291163454.jpg\\\" style=\\\"\\\" title=\\\"14647712291163454.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647712313821225.jpg\\\" style=\\\"\\\" title=\\\"14647712313821225.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647712334852696.jpg\\\" style=\\\"\\\" title=\\\"14647712334852696.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647712397052907.jpg\\\" style=\\\"\\\" title=\\\"14647712397052907.jpg\\\"/></p><p><br/></p>', '1', '5', '0.01', '0', null, '222', '5', '0', '0', '0', '2016-06-01 16:54:30');
INSERT INTO `goods` VALUES ('351', '1', '东成角磨机', '', '东成', '上海', '', '', '<p>						</p><p><img src=\\\"/pic/upload/image/20160601/14647715421224251.jpg\\\" style=\\\"\\\" title=\\\"14647715421224251.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647715451112373.jpg\\\" style=\\\"\\\" title=\\\"14647715451112373.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647715485362622.jpg\\\" style=\\\"\\\" title=\\\"14647715485362622.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647715484928424.jpg\\\" style=\\\"\\\" title=\\\"14647715484928424.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647715533746776.jpg\\\" style=\\\"\\\" title=\\\"14647715533746776.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647715593463195.jpg\\\" style=\\\"\\\" title=\\\"14647715593463195.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647715596373867.jpg\\\" style=\\\"\\\" title=\\\"14647715596373867.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647715609663648.jpg\\\" style=\\\"\\\" title=\\\"14647715609663648.jpg\\\"/></p><p><br/></p>', '1', '5', '0.01', '0', '0.01', '223', '5', '0', '0', '0', '2016-06-01 16:59:34');
INSERT INTO `goods` VALUES ('352', '1', '无刷电动扳手/冲击扳手/架子工扳手/脚手架工', '', '千辰', '浙江金华', '', '', '<p><img src=\\\"/pic/upload/image/20160601/14647719311007202.jpg\\\" style=\\\"\\\" title=\\\"14647719311007202.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647719334596653.jpg\\\" style=\\\"\\\" title=\\\"14647719334596653.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647719341006551.jpg\\\" style=\\\"\\\" title=\\\"14647719341006551.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647719397337774.jpg\\\" style=\\\"\\\" title=\\\"14647719397337774.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647719472619775.jpg\\\" style=\\\"\\\" title=\\\"14647719472619775.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647719497102827.jpg\\\" style=\\\"\\\" title=\\\"14647719497102827.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647719505999066.jpg\\\" style=\\\"\\\" title=\\\"14647719505999066.jpg\\\"/></p><p><br/></p>', '1', '3', '0.01', '0', null, '224', '4', '0', '0', '0', '2016-06-01 17:06:15');
INSERT INTO `goods` VALUES ('353', '1', '博世TSB5500手电钻套装冲击钻 ', '', 'Bosch/博世', '辽宁沈阳', '', '', null, '1', '5', '0.01', '0', '0.01', '225', '10', '0', '0', '1', '2016-06-01 17:11:29');
INSERT INTO `goods` VALUES ('354', '1', '博世TSB5500手电钻套装冲击钻 ', '', 'Bosch/博世', '辽宁沈阳', '', '', '<p>						</p><p><img src=\\\"/pic/upload/image/20160601/14647722578645511.jpg\\\" style=\\\"\\\" title=\\\"14647722578645511.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647722581195592.jpg\\\" style=\\\"\\\" title=\\\"14647722581195592.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647722621170725.jpg\\\" style=\\\"\\\" title=\\\"14647722621170725.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647722633584543.jpg\\\" style=\\\"\\\" title=\\\"14647722633584543.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647722647594674.jpg\\\" style=\\\"\\\" title=\\\"14647722647594674.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647722681112976.jpg\\\" style=\\\"\\\" title=\\\"14647722681112976.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647722739621477.jpg\\\" style=\\\"\\\" title=\\\"14647722739621477.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160601/14647722738064158.jpg\\\" style=\\\"\\\" title=\\\"14647722738064158.jpg\\\"/></p><p><br/></p>', '1', '5', '0.01', '0', '0.01', '225', '10', '0', '0', '0', '2016-06-01 17:11:32');
INSERT INTO `goods` VALUES ('355', '1', '用多功能充电钻 手电钻', '', ' WORX/威克士', '江苏苏州', '', '', '<p><img src=\\\"/pic/upload/image/20160602/14648299021306963.jpg\\\" style=\\\"\\\" title=\\\"14648299021306963.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648299058899832.jpg\\\" style=\\\"\\\" title=\\\"14648299058899832.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648299052466151.jpg\\\" style=\\\"\\\" title=\\\"14648299052466151.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648299161143015.jpg\\\" style=\\\"\\\" title=\\\"14648299161143015.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648299236757716.jpg\\\" style=\\\"\\\" title=\\\"14648299236757716.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648299269154154.jpg\\\" style=\\\"\\\" title=\\\"14648299269154154.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648299299811247.jpg\\\" style=\\\"\\\" title=\\\"14648299299811247.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648299435242138.jpg\\\" style=\\\"\\\" title=\\\"14648299435242138.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648299541055139.jpg\\\" style=\\\"\\\" title=\\\"14648299541055139.jpg\\\"/></p><p><br/></p>', '1', '6', '0.01', '0', null, '226', '3', '0', '0', '0', '2016-06-02 09:12:49');
INSERT INTO `goods` VALUES ('356', '1', '凯迪仕指纹锁 家用智能锁', '', 'kaadas/凯迪仕', '广东深圳', '', '', '<p><img src=\\\"/pic/upload/image/20160602/14648302851343452.jpg\\\" style=\\\"\\\" title=\\\"14648302851343452.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648302869585751.jpg\\\" style=\\\"\\\" title=\\\"14648302869585751.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648302875920743.jpg\\\" style=\\\"\\\" title=\\\"14648302875920743.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648302904736934.jpg\\\" style=\\\"\\\" title=\\\"14648302904736934.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648302996333415.jpg\\\" style=\\\"\\\" title=\\\"14648302996333415.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648303008627877.jpg\\\" style=\\\"\\\" title=\\\"14648303008627877.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648303015192216.jpg\\\" style=\\\"\\\" title=\\\"14648303015192216.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648303035608339.jpg\\\" style=\\\"\\\" title=\\\"14648303035608339.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/146483030910513511.jpg\\\" style=\\\"\\\" title=\\\"146483030910513511.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648303141312818.jpg\\\" style=\\\"\\\" title=\\\"14648303141312818.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/146483031537519410.jpg\\\" style=\\\"\\\" title=\\\"146483031537519410.jpg\\\"/></p><p><br/></p>', '1', '100', '0.01', '0', null, '227', '5', '0', '0', '0', '2016-06-02 09:18:53');
INSERT INTO `goods` VALUES ('357', '1', '304不锈钢防盗门锁三件套装', '', '进轩', '浙江金华', '', '', '<p><img src=\\\"/pic/upload/image/20160602/14648305142274221.jpg\\\" style=\\\"\\\" title=\\\"14648305142274221.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648305188831414.jpg\\\" style=\\\"\\\" title=\\\"14648305188831414.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648305192840522.jpg\\\" style=\\\"\\\" title=\\\"14648305192840522.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648305201221193.jpg\\\" style=\\\"\\\" title=\\\"14648305201221193.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648305272195916.jpg\\\" style=\\\"\\\" title=\\\"14648305272195916.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648305308407117.jpg\\\" style=\\\"\\\" title=\\\"14648305308407117.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648305619488075.jpg\\\" style=\\\"\\\" title=\\\"14648305619488075.jpg\\\"/></p><p><br/></p>', '1', '6', '0.01', '0', null, '228', '6', '0', '0', '0', '2016-06-02 09:23:01');
INSERT INTO `goods` VALUES ('358', '1', '球形锁球形门锁室内卧室房门锁不锈钢通用圆', '', '荣力斯', '广东广州', '', '', '<p><img src=\\\"/pic/upload/image/20160602/14648308061048681.jpg\\\" style=\\\"\\\" title=\\\"14648308061048681.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648308073273423.jpg\\\" style=\\\"\\\" title=\\\"14648308073273423.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648308181265005.jpg\\\" style=\\\"\\\" title=\\\"14648308181265005.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648308197493982.jpg\\\" style=\\\"\\\" title=\\\"14648308197493982.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648308219017306.jpg\\\" style=\\\"\\\" title=\\\"14648308219017306.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648308325658248.jpg\\\" style=\\\"\\\" title=\\\"14648308325658248.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648308321019557.jpg\\\" style=\\\"\\\" title=\\\"14648308321019557.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648308334733504.jpg\\\" style=\\\"\\\" title=\\\"14648308334733504.jpg\\\"/></p><p><br/></p>', '1', '3', '0.01', '0', null, '229', '8', '0', '0', '0', '2016-06-02 09:27:27');
INSERT INTO `goods` VALUES ('359', '1', ' 欧式简约风格室内门锁 双舌锁具', '', ' 固特', '浙江杭州', '', '', '<p><img src=\\\"/pic/upload/image/20160602/14648310802824172.jpg\\\" style=\\\"\\\" title=\\\"14648310802824172.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648310901039083.jpg\\\" style=\\\"\\\" title=\\\"14648310901039083.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648310971138141.jpg\\\" style=\\\"\\\" title=\\\"14648310971138141.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648310983666304.jpg\\\" style=\\\"\\\" title=\\\"14648310983666304.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648311094444756.jpg\\\" style=\\\"\\\" title=\\\"14648311094444756.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648311165366497.jpg\\\" style=\\\"\\\" title=\\\"14648311165366497.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648311181434678.jpg\\\" style=\\\"\\\" title=\\\"14648311181434678.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648311185787345.jpg\\\" style=\\\"\\\" title=\\\"14648311185787345.jpg\\\"/></p><p><br/></p>', '1', '2', '0.01', '0', null, '230', '5', '0', '0', '0', '2016-06-02 09:32:12');
INSERT INTO `goods` VALUES ('360', '1', '室内卧室房门锁木门锁 分体锁执手锁具', '', 'Mrlock/锁先生', '北京', '', '', '<p><img src=\\\"/pic/upload/image/20160602/14648313171384203.jpg\\\" style=\\\"\\\" title=\\\"14648313171384203.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648313234356962.jpg\\\" style=\\\"\\\" title=\\\"14648313234356962.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648313341397245.jpg\\\" style=\\\"\\\" title=\\\"14648313341397245.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648313354956831.jpg\\\" style=\\\"\\\" title=\\\"14648313354956831.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648313379127044.jpg\\\" style=\\\"\\\" title=\\\"14648313379127044.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648313421792276.jpg\\\" style=\\\"\\\" title=\\\"14648313421792276.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648313462422257.jpg\\\" style=\\\"\\\" title=\\\"14648313462422257.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648313461245728.jpg\\\" style=\\\"\\\" title=\\\"14648313461245728.jpg\\\"/></p><p><br/></p>', '1', '2', '0.01', '0', null, '231', '7', '0', '0', '0', '2016-06-02 09:36:10');
INSERT INTO `goods` VALUES ('361', '1', '卡贝象牙白门锁双开门现代室内门锁房门锁把', '', 'Cobbe/卡贝', '浙江温州', '', '', '<p><img src=\\\"/pic/upload/image/20160602/14648319952593091.jpg\\\" style=\\\"\\\" title=\\\"14648319952593091.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648320007578323.jpg\\\" style=\\\"\\\" title=\\\"14648320007578323.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648320058511252.jpg\\\" style=\\\"\\\" title=\\\"14648320058511252.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648320107280974.jpg\\\" style=\\\"\\\" title=\\\"14648320107280974.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648320221187036.jpg\\\" style=\\\"\\\" title=\\\"14648320221187036.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648320223782495.jpg\\\" style=\\\"\\\" title=\\\"14648320223782495.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648320271143098.jpg\\\" style=\\\"\\\" title=\\\"14648320271143098.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648320273671047.jpg\\\" style=\\\"\\\" title=\\\"14648320273671047.jpg\\\"/></p><p><br/></p>', '1', '2', '0.01', '0', null, '232', '6', '0', '0', '0', '2016-06-02 09:47:27');
INSERT INTO `goods` VALUES ('362', '1', '防尘防沙防风镜挡风骑行防冲击工业劳保防护', '', 'CK Tech．/成楷科技', '北京', '', '', '<p><img src=\\\"/pic/upload/image/20160602/14648322695236531.jpg\\\" style=\\\"\\\" title=\\\"14648322695236531.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648322791529342.jpg\\\" style=\\\"\\\" title=\\\"14648322791529342.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648322812310373.jpg\\\" style=\\\"\\\" title=\\\"14648322812310373.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648322846630335.jpg\\\" style=\\\"\\\" title=\\\"14648322846630335.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648322871350816.jpg\\\" style=\\\"\\\" title=\\\"14648322871350816.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648323009664937.jpg\\\" style=\\\"\\\" title=\\\"14648323009664937.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648323011406574.jpg\\\" style=\\\"\\\" title=\\\"14648323011406574.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648323044205928.jpg\\\" style=\\\"\\\" title=\\\"14648323044205928.jpg\\\"/></p><p><br/></p>', '1', '3', '0.01', '0', null, '233', '7', '0', '0', '0', '2016-06-02 09:51:59');
INSERT INTO `goods` VALUES ('363', '1', '霍尼韦尔隔音耳罩专业防噪音睡眠耳塞消音降', '', 'Honeywell/霍尼韦尔', '上海', '', '', '<p><img src=\\\"/pic/upload/image/20160602/14648325586529212.jpg\\\" style=\\\"\\\" title=\\\"14648325586529212.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648325688464353.jpg\\\" style=\\\"\\\" title=\\\"14648325688464353.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648325738339554.jpg\\\" style=\\\"\\\" title=\\\"14648325738339554.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648325733601765.jpg\\\" style=\\\"\\\" title=\\\"14648325733601765.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648325841231527.jpg\\\" style=\\\"\\\" title=\\\"14648325841231527.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648325868490171.jpg\\\" style=\\\"\\\" title=\\\"14648325868490171.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648325871143396.jpg\\\" style=\\\"\\\" title=\\\"14648325871143396.jpg\\\"/></p><p><br/></p>', '1', '5', '0.01', '0', null, '234', '7', '0', '0', '0', '2016-06-02 09:56:42');
INSERT INTO `goods` VALUES ('364', '1', '专业户外安全绳高空作业绳子', '', ' 安索', '江苏', '', '', '<p><img src=\\\"/pic/upload/image/20160602/14648327867794341.jpg\\\" style=\\\"\\\" title=\\\"14648327867794341.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648327881625313.jpg\\\" style=\\\"\\\" title=\\\"14648327881625313.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648327961182252.jpg\\\" style=\\\"\\\" title=\\\"14648327961182252.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648327965910415.jpg\\\" style=\\\"\\\" title=\\\"14648327965910415.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648327981064604.jpg\\\" style=\\\"\\\" title=\\\"14648327981064604.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648328001540967.jpg\\\" style=\\\"\\\" title=\\\"14648328001540967.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648328041224166.jpg\\\" style=\\\"\\\" title=\\\"14648328041224166.jpg\\\"/></p><p><br/></p>', '1', '2', '0.01', '0', null, '235', '7', '0', '0', '0', '2016-06-02 10:00:28');
INSERT INTO `goods` VALUES ('365', '1', '正品3M防毒面具6200防毒口罩喷漆专用防尘甲醛', '', '3M', '上海', '', '', '<p><img src=\\\"/pic/upload/image/20160602/14648330021174502.jpg\\\" style=\\\"\\\" title=\\\"14648330021174502.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648330101231314.jpg\\\" style=\\\"\\\" title=\\\"14648330101231314.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648330145796381.jpg\\\" style=\\\"\\\" title=\\\"14648330145796381.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648330141179075.jpg\\\" style=\\\"\\\" title=\\\"14648330141179075.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648330158947163.jpg\\\" style=\\\"\\\" title=\\\"14648330158947163.jpg\\\"/></p><p><br/></p>', '1', '2', '0.01', '0', null, '236', '8', '0', '0', '0', '2016-06-02 10:03:48');
INSERT INTO `goods` VALUES ('366', '1', '斯博瑞安防护眼镜护目镜防风防雾防紫外线安', '', 'Sperian/斯博瑞安', '上海', '', '', '<p><img src=\\\"/pic/upload/image/20160602/14648332247902781.jpg\\\" style=\\\"\\\" title=\\\"14648332247902781.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648332332474323.jpg\\\" style=\\\"\\\" title=\\\"14648332332474323.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648332381429084.jpg\\\" style=\\\"\\\" title=\\\"14648332381429084.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648332435839845.jpg\\\" style=\\\"\\\" title=\\\"14648332435839845.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648332498029737.jpg\\\" style=\\\"\\\" title=\\\"14648332498029737.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648332501027772.jpg\\\" style=\\\"\\\" title=\\\"14648332501027772.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648332665576486.jpg\\\" style=\\\"\\\" title=\\\"14648332665576486.jpg\\\"/></p><p><br/></p>', '1', '1', '0.01', '0', null, '237', '7', '0', '0', '0', '2016-06-02 10:08:01');
INSERT INTO `goods` VALUES ('367', '1', '反光背心马交通马甲施工反光衣安全服', '', ' ShaienReflective/士禾反光', '江苏常州', '', '', '<p><img src=\\\"/pic/upload/image/20160602/14648334263966663.jpg\\\" style=\\\"\\\" title=\\\"14648334263966663.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648334271406831.jpg\\\" style=\\\"\\\" title=\\\"14648334271406831.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648334281177342.jpg\\\" style=\\\"\\\" title=\\\"14648334281177342.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648334322056054.jpg\\\" style=\\\"\\\" title=\\\"14648334322056054.jpg\\\"/></p><p><br/></p>', '1', '2', '0.01', '0', null, '238', '6', '0', '0', '0', '2016-06-02 10:10:59');
INSERT INTO `goods` VALUES ('368', '1', '钢头劳保鞋钢包头安全鞋防砸防刺穿', '', 'MODYF', '福建泉州', '', '', '<p><img src=\\\"/pic/upload/image/20160602/14648336434887543.jpg\\\" style=\\\"\\\" title=\\\"14648336434887543.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648336452444202.jpg\\\" style=\\\"\\\" title=\\\"14648336452444202.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648336511686845.jpg\\\" style=\\\"\\\" title=\\\"14648336511686845.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648336533708474.jpg\\\" style=\\\"\\\" title=\\\"14648336533708474.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648336639368877.jpg\\\" style=\\\"\\\" title=\\\"14648336639368877.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648336641391386.jpg\\\" style=\\\"\\\" title=\\\"14648336641391386.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648336824540711.jpg\\\" style=\\\"\\\" title=\\\"14648336824540711.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648336835228368.jpg\\\" style=\\\"\\\" title=\\\"14648336835228368.jpg\\\"/></p><p><br/></p>', '1', '2', '0.01', '0', null, '239', '6', '0', '0', '0', '2016-06-02 10:15:28');
INSERT INTO `goods` VALUES ('369', '1', '加厚耐磨线手套 白色棉纱劳保用品', '', '登升', '江苏无锡', '', '', '<p><img src=\\\"/pic/upload/image/20160602/14648339211004741.jpg\\\" style=\\\"\\\" title=\\\"14648339211004741.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648339225118202.jpg\\\" style=\\\"\\\" title=\\\"14648339225118202.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648339318866263.jpg\\\" style=\\\"\\\" title=\\\"14648339318866263.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648339403623275.jpg\\\" style=\\\"\\\" title=\\\"14648339403623275.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648339631089564.jpg\\\" style=\\\"\\\" title=\\\"14648339631089564.jpg\\\"/></p><p><br/></p>', '1', '1', '0.01', '0', null, '240', '8', '0', '0', '0', '2016-06-02 10:19:48');
INSERT INTO `goods` VALUES ('370', '1', ' 高强度玻璃钢安全帽', '', '飞迅', '上海', '', '', '<p><img src=\\\"/pic/upload/image/20160602/14648341981071103.jpg\\\" style=\\\"\\\" title=\\\"14648341981071103.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648342061296504.jpg\\\" style=\\\"\\\" title=\\\"14648342061296504.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648342095436631.jpg\\\" style=\\\"\\\" title=\\\"14648342095436631.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648342139483775.jpg\\\" style=\\\"\\\" title=\\\"14648342139483775.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648342169052592.jpg\\\" style=\\\"\\\" title=\\\"14648342169052592.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648342171326416.jpg\\\" style=\\\"\\\" title=\\\"14648342171326416.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648342178483287.jpg\\\" style=\\\"\\\" title=\\\"14648342178483287.jpg\\\"/></p><p><br/></p>', '1', '2', '0.01', '0', null, '241', '8', '0', '0', '0', '2016-06-02 10:23:54');
INSERT INTO `goods` VALUES ('371', '1', '家用梯子 折叠梯子人字梯', '', '奥誉', '上海', '', '', '<p>						</p><p><img src=\\\"/pic/upload/image/20160602/14648344321007803.jpg\\\" style=\\\"\\\" title=\\\"14648344321007803.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648344334669801.jpg\\\" style=\\\"\\\" title=\\\"14648344334669801.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648344411023942.jpg\\\" style=\\\"\\\" title=\\\"14648344411023942.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648344521060994.jpg\\\" style=\\\"\\\" title=\\\"14648344521060994.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648344605626835.jpg\\\" style=\\\"\\\" title=\\\"14648344605626835.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648344636092437.jpg\\\" style=\\\"\\\" title=\\\"14648344636092437.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648344701949338.jpg\\\" style=\\\"\\\" title=\\\"14648344701949338.jpg\\\"/></p><p><br/></p>', '1', '5', '0.01', '0', '0.01', '242', '5', '0', '0', '0', '2016-06-02 10:28:45');
INSERT INTO `goods` VALUES ('372', '1', ' 五金紧固件', '', '厚政', '安徽', '', '', '<p><img src=\\\"/pic/upload/image/20160602/14648346791195251.jpg\\\" style=\\\"\\\" title=\\\"14648346791195251.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648346831103372.jpg\\\" style=\\\"\\\" title=\\\"14648346831103372.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648346845451263.jpg\\\" style=\\\"\\\" title=\\\"14648346845451263.jpg\\\"/></p><p><br/></p>', '1', '4', '0.01', '0', null, '243', '6', '0', '0', '0', '2016-06-02 10:31:48');
INSERT INTO `goods` VALUES ('373', '1', '柜门拉手现代简约衣柜拉手欧式抽屉拉手', '', '思美家', '安徽', '', '', '<p><img src=\\\"/pic/upload/image/20160602/14648349562532853.jpg\\\" style=\\\"\\\" title=\\\"14648349562532853.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648349649397714.jpg\\\" style=\\\"\\\" title=\\\"14648349649397714.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648349671347842.jpg\\\" style=\\\"\\\" title=\\\"14648349671347842.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648349712852575.jpg\\\" style=\\\"\\\" title=\\\"14648349712852575.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648349781004011.jpg\\\" style=\\\"\\\" title=\\\"14648349781004011.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648349921315527.jpg\\\" style=\\\"\\\" title=\\\"14648349921315527.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648350088886926.jpg\\\" style=\\\"\\\" title=\\\"14648350088886926.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648350671161168.jpg\\\" style=\\\"\\\" title=\\\"14648350671161168.jpg\\\"/></p><p><br/></p>', '1', '1', '0.01', '0', null, '244', '8', '0', '0', '0', '2016-06-02 10:38:02');
INSERT INTO `goods` VALUES ('374', '1', '4寸弹簧合页 不锈钢隐形门合页 ', '', ' FuMelody Hardware/福美乐', '上海', '', '', null, '1', '1', '0.01', '0', null, '245', '9', '0', '0', '1', '2016-06-02 10:41:29');
INSERT INTO `goods` VALUES ('375', '1', '4寸弹簧合页 不锈钢隐形门合页 ', '', ' FuMelody Hardware/福美乐', '上海', '', '', '<p><img src=\\\"/pic/upload/image/20160602/14648352496987071.jpg\\\" style=\\\"\\\" title=\\\"14648352496987071.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648352504080273.jpg\\\" style=\\\"\\\" title=\\\"14648352504080273.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648352668327515.jpg\\\" style=\\\"\\\" title=\\\"14648352668327515.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648352661081214.jpg\\\" style=\\\"\\\" title=\\\"14648352661081214.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648352731226962.jpg\\\" style=\\\"\\\" title=\\\"14648352731226962.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648352808632176.jpg\\\" style=\\\"\\\" title=\\\"14648352808632176.jpg\\\"/></p><p><br/></p>', '1', '1', '0.01', '0', null, '245', '9', '0', '0', '0', '2016-06-02 10:41:48');
INSERT INTO `goods` VALUES ('376', '1', '移门滑轮推拉门滑轨', '', '画宇', '上海', '', '', '<p><img src=\\\"/pic/upload/image/20160602/14648354973445553.jpg\\\" style=\\\"\\\" title=\\\"14648354973445553.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648355033592724.jpg\\\" style=\\\"\\\" title=\\\"14648355033592724.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648355048402812.jpg\\\" style=\\\"\\\" title=\\\"14648355048402812.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648355201020711.jpg\\\" style=\\\"\\\" title=\\\"14648355201020711.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648355274869045.jpg\\\" style=\\\"\\\" title=\\\"14648355274869045.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648355322380946.jpg\\\" style=\\\"\\\" title=\\\"14648355322380946.jpg\\\"/></p><p><br/></p>', '1', '2', '0.01', '0', null, '246', '8', '0', '0', '0', '2016-06-02 10:46:03');
INSERT INTO `goods` VALUES ('377', '1', '固特不锈钢阻尼/液压缓冲铰链', '', '固特', '浙江温州', '', '', '<p><img src=\\\"/pic/upload/image/20160602/14648358428304271.jpg\\\" style=\\\"\\\" title=\\\"14648358428304271.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648358497305072.jpg\\\" style=\\\"\\\" title=\\\"14648358497305072.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648358501122393.jpg\\\" style=\\\"\\\" title=\\\"14648358501122393.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648358681296464.jpg\\\" style=\\\"\\\" title=\\\"14648358681296464.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648358761218356.jpg\\\" style=\\\"\\\" title=\\\"14648358761218356.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648358961379728.jpg\\\" style=\\\"\\\" title=\\\"14648358961379728.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648358971160055.jpg\\\" style=\\\"\\\" title=\\\"14648358971160055.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648359126574397.jpg\\\" style=\\\"\\\" title=\\\"14648359126574397.jpg\\\"/></p><p><br/></p>', '1', '1', '0.01', '0', null, '247', '7', '0', '0', '0', '2016-06-02 10:52:19');
INSERT INTO `goods` VALUES ('378', '1', '免打孔门吸地吸隐形304不锈钢门碰墙吸门挡卫', '', 'DRhine/德莱', '广东广州', '', '', '<p><img src=\\\"/pic/upload/image/20160602/14648361111006121.jpg\\\" style=\\\"\\\" title=\\\"14648361111006121.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648361144881092.jpg\\\" style=\\\"\\\" title=\\\"14648361144881092.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648361206704353.jpg\\\" style=\\\"\\\" title=\\\"14648361206704353.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648361228030165.jpg\\\" style=\\\"\\\" title=\\\"14648361228030165.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648361285106584.jpg\\\" style=\\\"\\\" title=\\\"14648361285106584.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648361291155446.jpg\\\" style=\\\"\\\" title=\\\"14648361291155446.jpg\\\"/></p><p><br/></p>', '1', '2', '0.01', '0', null, '248', '8', '0', '0', '0', '2016-06-02 10:56:11');
INSERT INTO `goods` VALUES ('379', '1', '工具车 五金工具柜', '', '一鸣', '浙江金华', '', '', '<p><img src=\\\"/pic/upload/image/20160602/14648363351109611.jpg\\\" style=\\\"\\\" title=\\\"14648363351109611.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648363354582453.jpg\\\" style=\\\"\\\" title=\\\"14648363354582453.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648363385314854.jpg\\\" style=\\\"\\\" title=\\\"14648363385314854.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648363441091712.jpg\\\" style=\\\"\\\" title=\\\"14648363441091712.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648363598238005.jpg\\\" style=\\\"\\\" title=\\\"14648363598238005.jpg\\\"/></p><p><br/></p>', '1', '6', '0.01', '0', null, '249', '7', '0', '0', '0', '2016-06-02 11:00:01');
INSERT INTO `goods` VALUES ('380', '1', '得威斯机修工具套装 ', '', 'DIWELLS/得威斯', '浙江', '', '', '<p><img src=\\\"/pic/upload/image/20160602/14648365982040562.jpg\\\" style=\\\"\\\" title=\\\"14648365982040562.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648366019673971.jpg\\\" style=\\\"\\\" title=\\\"14648366019673971.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648366117747874.jpg\\\" style=\\\"\\\" title=\\\"14648366117747874.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648366171911906.jpg\\\" style=\\\"\\\" title=\\\"14648366171911906.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648366188611083.jpg\\\" style=\\\"\\\" title=\\\"14648366188611083.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648366208312015.jpg\\\" style=\\\"\\\" title=\\\"14648366208312015.jpg\\\"/></p><p><br/></p>', '1', '10', '0.01', '0', null, '250', '6', '0', '0', '0', '2016-06-02 11:04:34');
INSERT INTO `goods` VALUES ('381', '1', '电钻工具套装家用工具维修组合家用工具套装', '', '科麦斯', '浙江', '', '', '<p><img src=\\\"/pic/upload/image/20160602/14648368791264833.jpg\\\" style=\\\"\\\" title=\\\"14648368791264833.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648368792157611.jpg\\\" style=\\\"\\\" title=\\\"14648368792157611.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648368884548455.jpg\\\" style=\\\"\\\" title=\\\"14648368884548455.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648368928930814.jpg\\\" style=\\\"\\\" title=\\\"14648368928930814.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648369073748496.jpg\\\" style=\\\"\\\" title=\\\"14648369073748496.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648369711148042.jpg\\\" style=\\\"\\\" title=\\\"14648369711148042.jpg\\\"/></p><p><br/></p>', '1', '30', '0.01', '0', null, '251', '5', '0', '0', '0', '2016-06-02 11:10:20');
INSERT INTO `goods` VALUES ('382', '1', '法斯特工具包帆布大号多功能单肩家电维修电', '', '法斯特', '浙江宁波', '', '', '<p><img src=\\\"/pic/upload/image/20160602/14648372087200503.jpg\\\" style=\\\"\\\" title=\\\"14648372087200503.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648372091256011.jpg\\\" style=\\\"\\\" title=\\\"14648372091256011.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648372249654185.jpg\\\" style=\\\"\\\" title=\\\"14648372249654185.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648372254723164.jpg\\\" style=\\\"\\\" title=\\\"14648372254723164.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648372261002642.jpg\\\" style=\\\"\\\" title=\\\"14648372261002642.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648372307285286.jpg\\\" style=\\\"\\\" title=\\\"14648372307285286.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648372454674977.jpg\\\" style=\\\"\\\" title=\\\"14648372454674977.jpg\\\"/></p><p><br/></p>', '1', '3', '0.01', '0', null, '252', '5', '0', '0', '0', '2016-06-02 11:15:07');
INSERT INTO `goods` VALUES ('383', '1', '菲克斯曼五金工具箱家用大号不锈钢维修电工', '', '：FIXMAN/菲克斯曼', '浙江宁波', '', '', '<p><img src=\\\"/pic/upload/image/20160602/14648374621193782.jpg\\\" style=\\\"\\\" title=\\\"14648374621193782.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648374789677844.jpg\\\" style=\\\"\\\" title=\\\"14648374789677844.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648374852967045.jpg\\\" style=\\\"\\\" title=\\\"14648374852967045.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648374889158023.jpg\\\" style=\\\"\\\" title=\\\"14648374889158023.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648374982461841.jpg\\\" style=\\\"\\\" title=\\\"14648374982461841.jpg\\\"/></p><p><br/></p>', '1', '3', '0.01', '0', null, '253', '4', '0', '0', '0', '2016-06-02 11:19:05');
INSERT INTO `goods` VALUES ('384', '1', ' 高端集成吊顶扣板换气扇', '', 'BAMO/巴玛', '浙江嘉兴', '', '', '<p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14658045032740692.jpg\\\" style=\\\"\\\" title=\\\"14658045032740692.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14658045097511191.jpg\\\" style=\\\"\\\" title=\\\"14658045097511191.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14658045116626894.jpg\\\" style=\\\"\\\" title=\\\"14658045116626894.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14658045168899835.jpg\\\" style=\\\"\\\" title=\\\"14658045168899835.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14658045204051443.jpg\\\" style=\\\"\\\" title=\\\"14658045204051443.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14658045269132206.jpg\\\" style=\\\"\\\" title=\\\"14658045269132206.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14658045281080828.jpg\\\" style=\\\"\\\" title=\\\"14658045281080828.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/146580453112649610.jpg\\\" style=\\\"\\\" title=\\\"146580453112649610.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14658045289228169.jpg\\\" style=\\\"\\\" title=\\\"14658045289228169.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14658045356757717.jpg\\\" style=\\\"\\\" title=\\\"14658045356757717.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/146580454177538912.jpg\\\" style=\\\"\\\" title=\\\"146580454177538912.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/146580454161079311.jpg\\\" style=\\\"\\\" title=\\\"146580454161079311.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/146580454352421313.jpg\\\" style=\\\"\\\" title=\\\"146580454352421313.jpg\\\"/></p><p><br/></p>', '1', '2', '0.01', '0', '0.01', '322', '5', '0', '0', '0', '2016-06-02 11:26:14');
INSERT INTO `goods` VALUES ('385', '1', ' 高端集成吊顶扣板换气扇', '', 'BAMO/巴玛', '浙江嘉兴', '', '', '<p><img src=\\\"/pic/upload/image/20160602/14648378157664391.jpg\\\" style=\\\"\\\" title=\\\"14648378157664391.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648378201151402.jpg\\\" style=\\\"\\\" title=\\\"14648378201151402.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648378301311395.jpg\\\" style=\\\"\\\" title=\\\"14648378301311395.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648378492318553.jpg\\\" style=\\\"\\\" title=\\\"14648378492318553.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648378548261676.jpg\\\" style=\\\"\\\" title=\\\"14648378548261676.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648378551518597.jpg\\\" style=\\\"\\\" title=\\\"14648378551518597.jpg\\\"/></p><p><br/></p>', '1', '2', '0.01', '0', null, '322', '5', '0', '0', '1', '2016-06-02 11:26:41');
INSERT INTO `goods` VALUES ('386', '1', ' 鸿雁吸顶式浴霸F01款 综合加热型+换气', '', '鸿雁', '广东广州', '', '', '<p><img src=\\\"/pic/upload/image/20160602/14648381934094901.jpg\\\" style=\\\"\\\" title=\\\"14648381934094901.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648382004399132.jpg\\\" style=\\\"\\\" title=\\\"14648382004399132.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648382078817215.jpg\\\" style=\\\"\\\" title=\\\"14648382078817215.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648382101238363.jpg\\\" style=\\\"\\\" title=\\\"14648382101238363.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648382296777076.jpg\\\" style=\\\"\\\" title=\\\"14648382296777076.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648382881299554.jpg\\\" style=\\\"\\\" title=\\\"14648382881299554.jpg\\\"/></p><p><br/></p>', '1', '5', '0.01', '0', null, '323', '3', '0', '0', '0', '2016-06-02 11:31:58');
INSERT INTO `goods` VALUES ('387', '1', '防水浴霸壁挂式浴霸灯暖风暖型PTC挂壁式浴霸卫生间取暖灯', '', '新家族', '浙江嘉兴', '', '', '<p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14658040561031773.jpg\\\" style=\\\"\\\" title=\\\"14658040561031773.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14658040574715854.jpg\\\" style=\\\"\\\" title=\\\"14658040574715854.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14658040601147652.jpg\\\" style=\\\"\\\" title=\\\"14658040601147652.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14658040613285475.jpg\\\" style=\\\"\\\" title=\\\"14658040613285475.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14658040644780406.jpg\\\" style=\\\"\\\" title=\\\"14658040644780406.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14658040645352721.jpg\\\" style=\\\"\\\" title=\\\"14658040645352721.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14658040737427287.jpg\\\" style=\\\"\\\" title=\\\"14658040737427287.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14658040734066938.jpg\\\" style=\\\"\\\" title=\\\"14658040734066938.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/146580407542326011.jpg\\\" style=\\\"\\\" title=\\\"146580407542326011.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14658040787054199.jpg\\\" style=\\\"\\\" title=\\\"14658040787054199.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/146580407999614210.jpg\\\" style=\\\"\\\" title=\\\"146580407999614210.jpg\\\"/></p><p><br/></p>', '1', '5', '0.01', '0', '0.01', '324', '7', '0', '0', '0', '2016-06-02 11:36:43');
INSERT INTO `goods` VALUES ('388', '1', 'TCL浴霸传统吊顶四灯灯暖型浴霸', '', ' TCL', '浙江嘉兴', '', '', null, '1', '5', '0.01', '0', null, '324', '7', '0', '0', '1', '2016-06-02 11:36:45');
INSERT INTO `goods` VALUES ('389', '1', 'TCL浴霸传统吊顶四灯灯暖型浴霸', '', ' TCL', '浙江嘉兴', '', '', '<p><img src=\\\"/pic/upload/image/20160602/14648385391331872.jpg\\\" style=\\\"\\\" title=\\\"14648385391331872.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648385415914713.jpg\\\" style=\\\"\\\" title=\\\"14648385415914713.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648385483881894.jpg\\\" style=\\\"\\\" title=\\\"14648385483881894.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648385539258281.jpg\\\" style=\\\"\\\" title=\\\"14648385539258281.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648385572433445.jpg\\\" style=\\\"\\\" title=\\\"14648385572433445.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648385648541806.jpg\\\" style=\\\"\\\" title=\\\"14648385648541806.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648385674957697.jpg\\\" style=\\\"\\\" title=\\\"14648385674957697.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648385696666058.jpg\\\" style=\\\"\\\" title=\\\"14648385696666058.jpg\\\"/></p><p><br/></p>', '1', '5', '0.01', '0', null, '324', '7', '0', '0', '1', '2016-06-02 11:37:01');
INSERT INTO `goods` VALUES ('390', '1', '风暖型单超导ptc浴霸集成吊顶灯浴室', '', '尚诚', '浙江嘉兴', '', '', '<p><img src=\\\"/pic/upload/image/20160602/14648388834175372.jpg\\\" style=\\\"\\\" title=\\\"14648388834175372.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648388855973243.jpg\\\" style=\\\"\\\" title=\\\"14648388855973243.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648388851146711.jpg\\\" style=\\\"\\\" title=\\\"14648388851146711.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648388936206045.jpg\\\" style=\\\"\\\" title=\\\"14648388936206045.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648388942670124.jpg\\\" style=\\\"\\\" title=\\\"14648388942670124.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648388951172016.jpg\\\" style=\\\"\\\" title=\\\"14648388951172016.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648389126335567.jpg\\\" style=\\\"\\\" title=\\\"14648389126335567.jpg\\\"/></p><p><br/></p>', '1', '8', '0.01', '0', null, '325', '5', '0', '0', '0', '2016-06-02 11:42:21');
INSERT INTO `goods` VALUES ('391', '1', '松下新风系统FV-06ZWP1C过滤PM2.5壁挂全热交换器', '', 'Panasonic/松下', '福建福州', '', '', '<p><img src=\\\"/pic/upload/image/20160602/14648391851209191.jpg\\\" style=\\\"\\\" title=\\\"14648391851209191.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648391911357432.jpg\\\" style=\\\"\\\" title=\\\"14648391911357432.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648391964277354.jpg\\\" style=\\\"\\\" title=\\\"14648391964277354.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648391971177305.jpg\\\" style=\\\"\\\" title=\\\"14648391971177305.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648392041074153.jpg\\\" style=\\\"\\\" title=\\\"14648392041074153.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648392066374727.jpg\\\" style=\\\"\\\" title=\\\"14648392066374727.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648392101978176.jpg\\\" style=\\\"\\\" title=\\\"14648392101978176.jpg\\\"/></p><p><br/></p>', '1', '20', '0.01', '0', null, '326', '3', '0', '0', '0', '2016-06-02 11:48:34');
INSERT INTO `goods` VALUES ('392', '1', '四季风集成吊顶铝扣板厨房卫生间吊顶天花集', '', '：四季风 Sijifeng', '浙江嘉兴', '', '', null, '1', '5', '0.01', '0', null, '327', '3', '0', '0', '1', '2016-06-02 11:54:10');
INSERT INTO `goods` VALUES ('393', '1', '集成吊顶铝扣板 厨房卫生间吊顶led灯铝镁合金板', '', '格勒', '浙江嘉兴', '', '', '<p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14658036881143652.jpg\\\" style=\\\"\\\" title=\\\"14658036881143652.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14658036885998631.jpg\\\" style=\\\"\\\" title=\\\"14658036885998631.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14658036931002553.jpg\\\" style=\\\"\\\" title=\\\"14658036931002553.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14658036971114994.jpg\\\" style=\\\"\\\" title=\\\"14658036971114994.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14658036974868185.jpg\\\" style=\\\"\\\" title=\\\"14658036974868185.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14658037005692677.jpg\\\" style=\\\"\\\" title=\\\"14658037005692677.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14658037033339266.jpg\\\" style=\\\"\\\" title=\\\"14658037033339266.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/146580370541095311.jpg\\\" style=\\\"\\\" title=\\\"146580370541095311.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14658037098756109.jpg\\\" style=\\\"\\\" title=\\\"14658037098756109.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/146580371052933312.jpg\\\" style=\\\"\\\" title=\\\"146580371052933312.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14658037121126398.jpg\\\" style=\\\"\\\" title=\\\"14658037121126398.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/146580371579703414.jpg\\\" style=\\\"\\\" title=\\\"146580371579703414.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/146580371599640013.jpg\\\" style=\\\"\\\" title=\\\"146580371599640013.jpg\\\"/></p><p><br/></p>', '1', '5', '0.01', '0', '0.01', '327', '3', '0', '0', '0', '2016-06-02 11:54:12');
INSERT INTO `goods` VALUES ('394', '1', '四季风集成吊顶铝扣板厨房卫生间吊顶天花集', '', '：四季风 Sijifeng', '浙江嘉兴', '', '', null, '1', '5', '0.01', '0', null, '327', '3', '0', '0', '1', '2016-06-02 11:54:14');
INSERT INTO `goods` VALUES ('395', '1', '四季风集成吊顶铝扣板厨房卫生间吊顶天花集', '', '：四季风 Sijifeng', '浙江嘉兴', '', '', null, '1', '5', '0.01', '0', null, '327', '3', '0', '0', '1', '2016-06-02 11:54:18');
INSERT INTO `goods` VALUES ('396', '1', '四季风集成吊顶铝扣板厨房卫生间吊顶天花集', '', '：四季风 Sijifeng', '浙江嘉兴', '', '', '<p><img src=\\\"/pic/upload/image/20160602/14648395448021123.jpg\\\" style=\\\"\\\" title=\\\"14648395448021123.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648395542181714.jpg\\\" style=\\\"\\\" title=\\\"14648395542181714.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648395637228905.jpg\\\" style=\\\"\\\" title=\\\"14648395637228905.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648395633766141.jpg\\\" style=\\\"\\\" title=\\\"14648395633766141.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648395679471722.jpg\\\" style=\\\"\\\" title=\\\"14648395679471722.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648395701367986.jpg\\\" style=\\\"\\\" title=\\\"14648395701367986.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648395809742827.jpg\\\" style=\\\"\\\" title=\\\"14648395809742827.jpg\\\"/></p><p><br/></p>', '1', '5', '0.01', '0', null, '327', '3', '0', '0', '1', '2016-06-02 11:54:23');
INSERT INTO `goods` VALUES ('397', '1', '聚雷士照明 集成吊顶LED灯平板面板灯铝扣板', '', 'nVc/雷士', '江苏常州', '', '', '<p>						</p><p><img src=\\\"/pic/upload/image/20160602/14648458861132162.jpg\\\" style=\\\"\\\" title=\\\"14648458861132162.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648458933980434.jpg\\\" style=\\\"\\\" title=\\\"14648458933980434.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648458931147613.jpg\\\" style=\\\"\\\" title=\\\"14648458931147613.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648458974281665.jpg\\\" style=\\\"\\\" title=\\\"14648458974281665.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648458986762871.jpg\\\" style=\\\"\\\" title=\\\"14648458986762871.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648458996675527.jpg\\\" style=\\\"\\\" title=\\\"14648458996675527.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648459035217606.jpg\\\" style=\\\"\\\" title=\\\"14648459035217606.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648459051357699.jpg\\\" style=\\\"\\\" title=\\\"14648459051357699.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648459061195338.jpg\\\" style=\\\"\\\" title=\\\"14648459061195338.jpg\\\"/></p><p><br/></p>', '1', '3', '0.01', '0', '0.01', '328', '4', '0', '0', '0', '2016-06-02 13:38:43');
INSERT INTO `goods` VALUES ('398', '1', '集成吊顶铝扣板 厨房卫生间 吊顶扣板', '', 'WOFON/武峰', '浙江嘉兴', '', '', '<p>						</p><p style=\\\"text-align: left;\\\"><img src=\\\"/pic/upload/image/20160613/14658032591182381.jpg\\\" style=\\\"\\\" title=\\\"14658032591182381.jpg\\\"/></p><p style=\\\"text-align: left;\\\"><img src=\\\"/pic/upload/image/20160613/14658032627149304.jpg\\\" style=\\\"\\\" title=\\\"14658032627149304.jpg\\\"/></p><p style=\\\"text-align: left;\\\"><img src=\\\"/pic/upload/image/20160613/14658032662626222.jpg\\\" style=\\\"\\\" title=\\\"14658032662626222.jpg\\\"/></p><p style=\\\"text-align: left;\\\"><img src=\\\"/pic/upload/image/20160613/14658032696869166.jpg\\\" style=\\\"\\\" title=\\\"14658032696869166.jpg\\\"/></p><p style=\\\"text-align: left;\\\"><img src=\\\"/pic/upload/image/20160613/14658032699869333.jpg\\\" style=\\\"\\\" title=\\\"14658032699869333.jpg\\\"/></p><p style=\\\"text-align: left;\\\"><img src=\\\"/pic/upload/image/20160613/14658032722173537.jpg\\\" style=\\\"\\\" title=\\\"14658032722173537.jpg\\\"/></p><p style=\\\"text-align: left;\\\"><img src=\\\"/pic/upload/image/20160613/14658032734783848.jpg\\\" style=\\\"\\\" title=\\\"14658032734783848.jpg\\\"/></p><p style=\\\"text-align: left;\\\"><img src=\\\"/pic/upload/image/20160613/14658032761853805.jpg\\\" style=\\\"\\\" title=\\\"14658032761853805.jpg\\\"/></p><p><br/></p>', '1', '5', '0.02', '0', '0.01', '329', '5', '1', '0', '0', '2016-06-02 13:44:27');
INSERT INTO `goods` VALUES ('399', '1', '四季风集成吊顶铝扣板厨房卫生间吊顶天花集', '', '四季风 Sijifeng', '浙江嘉兴', '', '', '<p><img src=\\\"/pic/upload/image/20160602/14648462371090031.jpg\\\" style=\\\"\\\" title=\\\"14648462371090031.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648462418859383.jpg\\\" style=\\\"\\\" title=\\\"14648462418859383.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648462431295904.jpg\\\" style=\\\"\\\" title=\\\"14648462431295904.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648462491188535.jpg\\\" style=\\\"\\\" title=\\\"14648462491188535.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648462508089972.jpg\\\" style=\\\"\\\" title=\\\"14648462508089972.jpg\\\"/></p><p><br/></p>', '1', '5', '0.01', '0', null, '329', '5', '0', '0', '1', '2016-06-02 13:44:35');
INSERT INTO `goods` VALUES ('400', '1', '鲁本斯暖气片家用水暖铜铝复合壁挂式装饰型', '', '鲁本斯', '山东济南', '', '', '<p><img src=\\\"/pic/upload/image/20160602/14648465058324491.jpg\\\" style=\\\"\\\" title=\\\"14648465058324491.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648465129932162.jpg\\\" style=\\\"\\\" title=\\\"14648465129932162.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648465171105443.jpg\\\" style=\\\"\\\" title=\\\"14648465171105443.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648465316533515.jpg\\\" style=\\\"\\\" title=\\\"14648465316533515.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648465338698874.jpg\\\" style=\\\"\\\" title=\\\"14648465338698874.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648465391232647.jpg\\\" style=\\\"\\\" title=\\\"14648465391232647.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648465408041346.jpg\\\" style=\\\"\\\" title=\\\"14648465408041346.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648465411740638.jpg\\\" style=\\\"\\\" title=\\\"14648465411740638.jpg\\\"/></p><p><br/></p>', '1', '5', '0.01', '0', null, '330', '5', '0', '0', '0', '2016-06-02 13:49:15');
INSERT INTO `goods` VALUES ('401', '1', '阳台门套 实木烤漆免漆飘窗套', '', 'TATA木门', '北京', '', '', '<p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14658026308537501.jpg\\\" style=\\\"\\\" title=\\\"14658026308537501.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14658026331201872.jpg\\\" style=\\\"\\\" title=\\\"14658026331201872.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14658026364927563.jpg\\\" style=\\\"\\\" title=\\\"14658026364927563.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14658026401057465.jpg\\\" style=\\\"\\\" title=\\\"14658026401057465.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14658026497689776.jpg\\\" style=\\\"\\\" title=\\\"14658026497689776.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14658026507234508.jpg\\\" style=\\\"\\\" title=\\\"14658026507234508.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14658026534594509.jpg\\\" style=\\\"\\\" title=\\\"14658026534594509.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/146580265612496810.jpg\\\" style=\\\"\\\" title=\\\"146580265612496810.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14658026591202867.jpg\\\" style=\\\"\\\" title=\\\"14658026591202867.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/146580266013456811.jpg\\\" style=\\\"\\\" title=\\\"146580266013456811.jpg\\\"/></p><p><br/></p>', '1', '8', '0.01', '0', '0.01', '331', '4', '0', '0', '0', '2016-06-02 13:52:57');
INSERT INTO `goods` VALUES ('402', '1', '专业制作工艺 免漆窗套 ', '', 'TATA木门', '北京', '', '', '<p><img src=\\\"/pic/upload/image/20160602/14648467418351603.jpg\\\" style=\\\"\\\" title=\\\"14648467418351603.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648467508681234.jpg\\\" style=\\\"\\\" title=\\\"14648467508681234.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648467521201661.jpg\\\" style=\\\"\\\" title=\\\"14648467521201661.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648467577918702.jpg\\\" style=\\\"\\\" title=\\\"14648467577918702.jpg\\\"/></p><p><br/></p>', '1', '8', '0.01', '0', null, '331', '4', '0', '0', '1', '2016-06-02 13:53:04');
INSERT INTO `goods` VALUES ('403', '1', '加厚铝合金百叶窗帘卷帘', '', '慕安娜', '浙江杭州', '', '', '<p><img src=\\\"/pic/upload/image/20160602/14648470841006041.jpg\\\" style=\\\"\\\" title=\\\"14648470841006041.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648470891301063.jpg\\\" style=\\\"\\\" title=\\\"14648470891301063.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648470921338844.jpg\\\" style=\\\"\\\" title=\\\"14648470921338844.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648470989361992.jpg\\\" style=\\\"\\\" title=\\\"14648470989361992.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648470997663525.jpg\\\" style=\\\"\\\" title=\\\"14648470997663525.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648471049800487.jpg\\\" style=\\\"\\\" title=\\\"14648471049800487.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648471049879666.jpg\\\" style=\\\"\\\" title=\\\"14648471049879666.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648471086765888.jpg\\\" style=\\\"\\\" title=\\\"14648471086765888.jpg\\\"/></p><p><br/></p>', '1', '5', '0.01', '0', null, '332', '7', '0', '0', '0', '2016-06-02 13:59:08');
INSERT INTO `goods` VALUES ('404', '1', '华廊断桥铝门窗 断桥铝门窗', '', '筑阁', '上海', '', '', '<p><img src=\\\"/pic/upload/image/20160602/14648474884105661.jpg\\\" style=\\\"\\\" title=\\\"14648474884105661.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648474898415722.jpg\\\" style=\\\"\\\" title=\\\"14648474898415722.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648474914117713.jpg\\\" style=\\\"\\\" title=\\\"14648474914117713.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648474967631685.jpg\\\" style=\\\"\\\" title=\\\"14648474967631685.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648474961077304.jpg\\\" style=\\\"\\\" title=\\\"14648474961077304.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648475068895967.jpg\\\" style=\\\"\\\" title=\\\"14648475068895967.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648475064604838.jpg\\\" style=\\\"\\\" title=\\\"14648475064604838.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648475106016276.jpg\\\" style=\\\"\\\" title=\\\"14648475106016276.jpg\\\"/></p><p><br/></p>', '1', '5', '0.01', '0', null, '333', '5', '0', '0', '0', '2016-06-02 14:05:28');
INSERT INTO `goods` VALUES ('405', '1', '塑钢门窗 实德窗 正品实德80推拉窗 ', '', '实德', '北京', '', '', '<p>						</p><p><img src=\\\"/pic/upload/image/20160602/14648478291221543.jpg\\\" style=\\\"\\\" title=\\\"14648478291221543.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648478333591432.jpg\\\" style=\\\"\\\" title=\\\"14648478333591432.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648478348774611.jpg\\\" style=\\\"\\\" title=\\\"14648478348774611.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648478426167746.jpg\\\" style=\\\"\\\" title=\\\"14648478426167746.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648478482826325.jpg\\\" style=\\\"\\\" title=\\\"14648478482826325.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648478543480844.jpg\\\" style=\\\"\\\" title=\\\"14648478543480844.jpg\\\"/></p><p><br/></p>', '1', '6', '0.01', '0', '0.01', '334', '7', '0', '0', '0', '2016-06-02 14:11:29');
INSERT INTO `goods` VALUES ('406', '1', '欧式美式乡村田园酒吧咖啡店铺复古假窗户木', '', '佳客', '浙江台州', '', '', null, '1', '6', '0.01', '0', null, '335', '6', '0', '0', '1', '2016-06-02 14:18:23');
INSERT INTO `goods` VALUES ('407', '1', '直销欧式实木百叶窗定制 PVC 移门折叠门活动遮光窗帘套隔断', '', '佳客', '浙江台州', '', '', '<p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14658008141280321.jpg\\\" style=\\\"\\\" title=\\\"14658008141280321.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14658008169432133.jpg\\\" style=\\\"\\\" title=\\\"14658008169432133.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14658008241307735.jpg\\\" style=\\\"\\\" title=\\\"14658008241307735.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14658008278440682.jpg\\\" style=\\\"\\\" title=\\\"14658008278440682.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14658008319992406.jpg\\\" style=\\\"\\\" title=\\\"14658008319992406.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14658008341213284.jpg\\\" style=\\\"\\\" title=\\\"14658008341213284.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14658008372969627.jpg\\\" style=\\\"\\\" title=\\\"14658008372969627.jpg\\\"/></p><p><br/></p>', '1', '6', '0.01', '0', '0.01', '335', '6', '0', '0', '0', '2016-06-02 14:18:36');
INSERT INTO `goods` VALUES ('408', '1', '柏优整体橱柜 现代简约 纳米微晶板材 德国爱', '', '柏优', '北京', '', '', null, '1', '10', '0.01', '0', null, '336', '5', '0', '0', '1', '2016-06-02 14:22:10');
INSERT INTO `goods` VALUES ('409', '1', '柏优整体橱柜 现代简约 纳米微晶板材 德国爱', '', '柏优', '北京', '', '', '<p><img src=\\\"/pic/upload/image/20160602/14648484913722241.jpg\\\" style=\\\"\\\" title=\\\"14648484913722241.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648484935823492.jpg\\\" style=\\\"\\\" title=\\\"14648484935823492.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648484939581023.jpg\\\" style=\\\"\\\" title=\\\"14648484939581023.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648485011495356.jpg\\\" style=\\\"\\\" title=\\\"14648485011495356.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648485081303695.jpg\\\" style=\\\"\\\" title=\\\"14648485081303695.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648485176073934.jpg\\\" style=\\\"\\\" title=\\\"14648485176073934.jpg\\\"/></p><p><br/></p>', '1', '10', '0.01', '0', null, '336', '5', '0', '0', '0', '2016-06-02 14:22:15');
INSERT INTO `goods` VALUES ('410', '1', '新标铝合金平开门定制钛镁合金厨房厕所卫生间门钢化玻璃厨卫浴室', '', 'Mexin/美心', '重庆', '', '', '<p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14658003622760912.jpg\\\" style=\\\"\\\" title=\\\"14658003622760912.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14658003671352703.jpg\\\" style=\\\"\\\" title=\\\"14658003671352703.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14658003678871004.jpg\\\" style=\\\"\\\" title=\\\"14658003678871004.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14658003731321801.jpg\\\" style=\\\"\\\" title=\\\"14658003731321801.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14658003741955796.jpg\\\" style=\\\"\\\" title=\\\"14658003741955796.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14658003781401937.jpg\\\" style=\\\"\\\" title=\\\"14658003781401937.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14658003796196575.jpg\\\" style=\\\"\\\" title=\\\"14658003796196575.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14658003831329128.jpg\\\" style=\\\"\\\" title=\\\"14658003831329128.jpg\\\"/></p><p><br/></p>', '1', '6', '0.01', '0', '0.01', '337', '5', '0', '0', '0', '2016-06-02 14:27:12');
INSERT INTO `goods` VALUES ('411', '1', '厨房移门铝合金推拉门', '', 'Mexin/美心', '重庆', '', '', '<p><img src=\\\"/pic/upload/image/20160602/14648487801827123.jpg\\\" style=\\\"\\\" title=\\\"14648487801827123.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648487811390351.jpg\\\" style=\\\"\\\" title=\\\"14648487811390351.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648487822399882.jpg\\\" style=\\\"\\\" title=\\\"14648487822399882.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648487981085084.jpg\\\" style=\\\"\\\" title=\\\"14648487981085084.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648488003526886.jpg\\\" style=\\\"\\\" title=\\\"14648488003526886.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648488041164485.jpg\\\" style=\\\"\\\" title=\\\"14648488041164485.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648488063539798.jpg\\\" style=\\\"\\\" title=\\\"14648488063539798.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648488089223869.jpg\\\" style=\\\"\\\" title=\\\"14648488089223869.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648488171376937.jpg\\\" style=\\\"\\\" title=\\\"14648488171376937.jpg\\\"/></p><p><br/></p>', '1', '6', '0.01', '0', null, '337', '5', '0', '0', '1', '2016-06-02 14:27:18');
INSERT INTO `goods` VALUES ('412', '1', '开放式厨房 高隔断 推拉门 艺术玻璃', '', '欧美宜居', '北京', '', '', '<p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14657998161232432.jpg\\\" style=\\\"\\\" title=\\\"14657998161232432.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14657998181451891.jpg\\\" style=\\\"\\\" title=\\\"14657998181451891.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14657998204379773.jpg\\\" style=\\\"\\\" title=\\\"14657998204379773.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14657998202276814.jpg\\\" style=\\\"\\\" title=\\\"14657998202276814.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14657998271269865.jpg\\\" style=\\\"\\\" title=\\\"14657998271269865.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14657998281218707.jpg\\\" style=\\\"\\\" title=\\\"14657998281218707.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14657998301346208.jpg\\\" style=\\\"\\\" title=\\\"14657998301346208.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14657998314666366.jpg\\\" style=\\\"\\\" title=\\\"14657998314666366.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14657998338617549.jpg\\\" style=\\\"\\\" title=\\\"14657998338617549.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/146579983613860510.jpg\\\" style=\\\"\\\" title=\\\"146579983613860510.jpg\\\"/></p><p><br/></p>', '1', '6', '0.01', '0', '0.01', '338', '5', '0', '0', '0', '2016-06-02 14:32:24');
INSERT INTO `goods` VALUES ('413', '1', '木质衣柜推拉门移门衣柜定制衣柜现代简约白色烤漆衣柜', '', '嘉依家', '上海', '', '', '<p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14657993207538301.jpg\\\" style=\\\"\\\" title=\\\"14657993207538301.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14657993275408233.jpg\\\" style=\\\"\\\" title=\\\"14657993275408233.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14657993315723222.jpg\\\" style=\\\"\\\" title=\\\"14657993315723222.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14657993344553626.jpg\\\" style=\\\"\\\" title=\\\"14657993344553626.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14657993349210524.jpg\\\" style=\\\"\\\" title=\\\"14657993349210524.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14657993424091895.jpg\\\" style=\\\"\\\" title=\\\"14657993424091895.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14657993446019287.jpg\\\" style=\\\"\\\" title=\\\"14657993446019287.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14657993466331698.jpg\\\" style=\\\"\\\" title=\\\"14657993466331698.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14657993497795639.jpg\\\" style=\\\"\\\" title=\\\"14657993497795639.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/146579935353789711.jpg\\\" style=\\\"\\\" title=\\\"146579935353789711.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/146579935514906210.jpg\\\" style=\\\"\\\" title=\\\"146579935514906210.jpg\\\"/></p><p><br/></p>', '1', '8', '0.01', '0', '0.01', '339', '6', '0', '0', '0', '2016-06-02 14:38:25');
INSERT INTO `goods` VALUES ('414', '1', '大功率油锯20寸伐木据', '', '米其', '江苏南京', '', '', '<p>						</p><p><img src=\\\"/pic/upload/image/20160602/14648497119806942.jpg\\\" style=\\\"\\\" title=\\\"14648497119806942.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648497111330923.jpg\\\" style=\\\"\\\" title=\\\"14648497111330923.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648497202686471.jpg\\\" style=\\\"\\\" title=\\\"14648497202686471.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648497215943544.jpg\\\" style=\\\"\\\" title=\\\"14648497215943544.jpg\\\"/></p><p><br/></p>', '1', '8', '0.01', '0', '0.01', '340', '5', '0', '0', '0', '2016-06-02 14:42:39');
INSERT INTO `goods` VALUES ('415', '1', '凯驰集团园艺浇花水管车收纳套装', '', 'KARCHER/凯驰', '广东东莞', '', '', '<p>						</p><p><img src=\\\"/pic/upload/image/20160602/14648500461405333.jpg\\\" style=\\\"\\\" title=\\\"14648500461405333.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648500584086725.jpg\\\" style=\\\"\\\" title=\\\"14648500584086725.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648500591037881.jpg\\\" style=\\\"\\\" title=\\\"14648500591037881.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648500636761154.jpg\\\" style=\\\"\\\" title=\\\"14648500636761154.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648500718928666.jpg\\\" style=\\\"\\\" title=\\\"14648500718928666.jpg\\\"/></p><p><br/></p>', '1', '9', '0.01', '0', '0.01', '341', '6', '0', '0', '0', '2016-06-02 14:48:17');
INSERT INTO `goods` VALUES ('416', '1', '萌肉物语 园艺资材 硅藻土 多肉植物种植配用', '', '萌肉物语', '天津', '', '', null, '1', '5', '0.01', '0', null, '342', '7', '0', '0', '0', '2016-06-02 14:51:00');
INSERT INTO `goods` VALUES ('417', '1', '萌肉物语 园艺资材 硅藻土 多肉植物种植配用', '', '萌肉物语', '天津', '', '', '<p><img src=\\\"/pic/upload/image/20160602/14648502509666221.jpg\\\" style=\\\"\\\" title=\\\"14648502509666221.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648502513158532.jpg\\\" style=\\\"\\\" title=\\\"14648502513158532.jpg\\\"/></p><p><br/></p>', '1', '5', '0.01', '0', null, '342', '7', '0', '0', '1', '2016-06-02 14:51:11');
INSERT INTO `goods` VALUES ('418', '1', '带芽香水百合种球 种子百合花苗套餐', '', '千惠美', '上海', '', '', '<p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14657835599059051.jpg\\\" style=\\\"\\\" title=\\\"14657835599059051.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14657835651157814.jpg\\\" style=\\\"\\\" title=\\\"14657835651157814.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14657835679491085.jpg\\\" style=\\\"\\\" title=\\\"14657835679491085.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14657835673719233.jpg\\\" style=\\\"\\\" title=\\\"14657835673719233.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14657835736771916.jpg\\\" style=\\\"\\\" title=\\\"14657835736771916.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14657835788171738.jpg\\\" style=\\\"\\\" title=\\\"14657835788171738.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14657835811209492.jpg\\\" style=\\\"\\\" title=\\\"14657835811209492.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14657835811140607.jpg\\\" style=\\\"\\\" title=\\\"14657835811140607.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14657835831403229.jpg\\\" style=\\\"\\\" title=\\\"14657835831403229.jpg\\\"/></p><p><br/></p>', '1', '3', '0.01', '0', '0.01', '343', '6', '0', '0', '0', '2016-06-02 14:54:24');
INSERT INTO `goods` VALUES ('419', '1', '园艺工具三件套工具组套装花铲耙锄园艺', '', '澳森园艺', '浙江台州', '', '', '<p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14657829381118521.jpg\\\" style=\\\"\\\" title=\\\"14657829381118521.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14657829414151274.jpg\\\" style=\\\"\\\" title=\\\"14657829414151274.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14657829441191983.jpg\\\" style=\\\"\\\" title=\\\"14657829441191983.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14657829451289572.jpg\\\" style=\\\"\\\" title=\\\"14657829451289572.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14657829471116025.jpg\\\" style=\\\"\\\" title=\\\"14657829471116025.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14657829498952766.jpg\\\" style=\\\"\\\" title=\\\"14657829498952766.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14657829534615158.jpg\\\" style=\\\"\\\" title=\\\"14657829534615158.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160613/14657829546395387.jpg\\\" style=\\\"\\\" title=\\\"14657829546395387.jpg\\\"/></p><p><br/></p>', '1', '5', '0.01', '0', '0.01', '344', '5', '0', '0', '0', '2016-06-02 14:59:16');
INSERT INTO `goods` VALUES ('420', '1', '多肉花盆陶瓷批发简约个性创意绿植园艺容器', '', '艺颜坊', '福建泉州', '', '', '<p>						</p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160602/14648509079745833.jpg\\\" style=\\\"\\\" title=\\\"14648509079745833.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160602/14648509102242814.jpg\\\" style=\\\"\\\" title=\\\"14648509102242814.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160602/14648509131730735.jpg\\\" style=\\\"\\\" title=\\\"14648509131730735.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160602/14648509209466561.jpg\\\" style=\\\"\\\" title=\\\"14648509209466561.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160602/14648509221361692.jpg\\\" style=\\\"\\\" title=\\\"14648509221361692.jpg\\\"/></p><p><br/></p>', '1', '3', '0.01', '0', '0.01', '345', '6', '0', '0', '0', '2016-06-02 15:02:36');
INSERT INTO `goods` VALUES ('421', '1', '美式乡村吸顶灯北欧韩式欧式走廊过道玄关阳', '', '韵梦', '广东中山', '', '', '<p><img src=\\\"/pic/upload/image/20160602/14648512214561361.jpg\\\" style=\\\"\\\" title=\\\"14648512214561361.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648512283687824.jpg\\\" style=\\\"\\\" title=\\\"14648512283687824.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648512305354442.jpg\\\" style=\\\"\\\" title=\\\"14648512305354442.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648512403031583.jpg\\\" style=\\\"\\\" title=\\\"14648512403031583.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648512525897075.jpg\\\" style=\\\"\\\" title=\\\"14648512525897075.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648512577498286.jpg\\\" style=\\\"\\\" title=\\\"14648512577498286.jpg\\\"/></p><p><br/></p>', '1', '3', '0.01', '0', null, '150', '6', '0', '0', '0', '2016-06-02 15:08:14');
INSERT INTO `goods` VALUES ('422', '1', '欧普照明 led筒灯', '', 'OPPLE/欧普照明', '江苏苏州', '', '', null, '1', '5', '0.01', '0', '0.01', '151', '7', '0', '0', '1', '2016-06-02 15:30:23');
INSERT INTO `goods` VALUES ('423', '1', '欧普照明 led筒灯', '', 'OPPLE/欧普照明', '江苏苏州', '', '', '<p>						</p><p><img src=\\\"/pic/upload/image/20160602/14648525641238883.jpg\\\" style=\\\"\\\" title=\\\"14648525641238883.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648525715606181.jpg\\\" style=\\\"\\\" title=\\\"14648525715606181.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648525755775294.jpg\\\" style=\\\"\\\" title=\\\"14648525755775294.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648525773305705.jpg\\\" style=\\\"\\\" title=\\\"14648525773305705.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648525777956572.jpg\\\" style=\\\"\\\" title=\\\"14648525777956572.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648525851005487.jpg\\\" style=\\\"\\\" title=\\\"14648525851005487.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648525854538566.jpg\\\" style=\\\"\\\" title=\\\"14648525854538566.jpg\\\"/></p><p><br/></p>', '1', '5', '0.01', '0', '0.01', '151', '7', '0', '0', '0', '2016-06-02 15:30:31');
INSERT INTO `goods` VALUES ('424', '1', 'led餐吊灯三头水晶吊灯玻璃灯饰吧台餐厅吊灯', '', 'AOZZO/奥朵', '上海', '', '', '<p>						</p><p><img src=\\\"/pic/upload/image/20160602/14648529742788452.jpg\\\" style=\\\"\\\" title=\\\"14648529742788452.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648529796550724.jpg\\\" style=\\\"\\\" title=\\\"14648529796550724.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648529792895171.jpg\\\" style=\\\"\\\" title=\\\"14648529792895171.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648529821358423.jpg\\\" style=\\\"\\\" title=\\\"14648529821358423.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648529835070006.jpg\\\" style=\\\"\\\" title=\\\"14648529835070006.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648529862087907.jpg\\\" style=\\\"\\\" title=\\\"14648529862087907.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648529872677435.jpg\\\" style=\\\"\\\" title=\\\"14648529872677435.jpg\\\"/></p><p><br/></p>', '1', '5', '0.02', '0', '0.01', '152', '6', '0', '0', '0', '2016-06-02 15:37:03');
INSERT INTO `goods` VALUES ('425', '1', '新款时尚现代美式简约创意不锈钢台灯卧室床', '', '宇宸灯饰', '广东中山', '', '', null, '1', '4', '0.01', '0', null, '153', '6', '0', '0', '1', '2016-06-02 15:44:14');
INSERT INTO `goods` VALUES ('426', '1', '新款时尚现代美式简约创意不锈钢台灯卧室床', '', '宇宸灯饰', '广东中山', '', '', '<p>						</p><p><img src=\\\"/pic/upload/image/20160602/14648532268185501.jpg\\\" style=\\\"\\\" title=\\\"14648532268185501.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648532274699072.jpg\\\" style=\\\"\\\" title=\\\"14648532274699072.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648532344028633.jpg\\\" style=\\\"\\\" title=\\\"14648532344028633.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648532426872174.jpg\\\" style=\\\"\\\" title=\\\"14648532426872174.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648532421171846.jpg\\\" style=\\\"\\\" title=\\\"14648532421171846.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648533031080055.jpg\\\" style=\\\"\\\" title=\\\"14648533031080055.jpg\\\"/></p><p><br/></p>', '1', '4', '0.02', '0', '0.01', '153', '6', '1', '0', '0', '2016-06-02 15:44:16');
INSERT INTO `goods` VALUES ('427', '1', '落地灯客厅简约现代卧室欧式创意北欧宜家落', '', '旭呈', '江苏苏州', '', '', '<p>						</p><p><img src=\\\"/pic/upload/image/20160602/14648536711371331.jpg\\\" style=\\\"\\\" title=\\\"14648536711371331.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648536741178764.jpg\\\" style=\\\"\\\" title=\\\"14648536741178764.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648536832192463.jpg\\\" style=\\\"\\\" title=\\\"14648536832192463.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648536983600892.jpg\\\" style=\\\"\\\" title=\\\"14648536983600892.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648537036758576.jpg\\\" style=\\\"\\\" title=\\\"14648537036758576.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648537405974965.jpg\\\" style=\\\"\\\" title=\\\"14648537405974965.jpg\\\"/></p><p><br/></p>', '1', '7', '0.02', '0', '0.01', '173', '6', '0', '0', '0', '2016-06-02 15:49:30');
INSERT INTO `goods` VALUES ('428', '1', '欧式壁灯 客厅卧室壁灯床头灯过道墙壁灯', '', '福仕福瑞达', '广东中山', '', '', '<p><img src=\\\"/pic/upload/image/20160620/14663947165611341.jpg\\\" style=\\\"\\\" title=\\\"14663947165611341.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160620/14663947183231683.jpg\\\" style=\\\"\\\" title=\\\"14663947183231683.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160620/14663947221329254.jpg\\\" style=\\\"\\\" title=\\\"14663947221329254.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160620/14663947241161295.jpg\\\" style=\\\"\\\" title=\\\"14663947241161295.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160620/14663947243099142.jpg\\\" style=\\\"\\\" title=\\\"14663947243099142.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160620/14663947279998866.jpg\\\" style=\\\"\\\" title=\\\"14663947279998866.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160620/14663947302251428.jpg\\\" style=\\\"\\\" title=\\\"14663947302251428.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160620/14663947319718299.jpg\\\" style=\\\"\\\" title=\\\"14663947319718299.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160620/14663947335439647.jpg\\\" style=\\\"\\\" title=\\\"14663947335439647.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160620/146639473697415310.jpg\\\" style=\\\"\\\" title=\\\"146639473697415310.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160620/146639474354284513.jpg\\\" style=\\\"\\\" title=\\\"146639474354284513.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160620/146639474583825911.jpg\\\" style=\\\"\\\" title=\\\"146639474583825911.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160620/146639474862662812.jpg\\\" style=\\\"\\\" title=\\\"146639474862662812.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160620/146639475328788214.jpg\\\" style=\\\"\\\" title=\\\"146639475328788214.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160620/146639475414845915.jpg\\\" style=\\\"\\\" title=\\\"146639475414845915.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160620/146639475810485916.jpg\\\" style=\\\"\\\" title=\\\"146639475810485916.jpg\\\"/></p><p><br/></p>', '1', '5', '0.01', '0', '0.01', '174', '5', '1', '0', '0', '2016-06-02 15:54:31');
INSERT INTO `goods` VALUES ('429', '1', '欧式全铜壁灯', '', '福仕福瑞达', '广东中山', '', '', '<p><img src=\\\"/pic/upload/image/20160602/14648540211349301.jpg\\\" style=\\\"\\\" title=\\\"14648540211349301.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648540216386342.jpg\\\" style=\\\"\\\" title=\\\"14648540216386342.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648540261043003.jpg\\\" style=\\\"\\\" title=\\\"14648540261043003.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648540281182594.jpg\\\" style=\\\"\\\" title=\\\"14648540281182594.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648540292628386.jpg\\\" style=\\\"\\\" title=\\\"14648540292628386.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648540324364715.jpg\\\" style=\\\"\\\" title=\\\"14648540324364715.jpg\\\"/></p><p><br/></p>', '1', '5', '0.01', '0', null, '174', '5', '0', '0', '1', '2016-06-02 15:54:56');
INSERT INTO `goods` VALUES ('430', '1', 'led灯泡节能灯泡', '', 'OPPLE/欧普照明', '山东', '', '', '<p><img src=\\\"/pic/upload/image/20160608/14653707558315891.jpg\\\" style=\\\"\\\" title=\\\"14653707558315891.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160608/14653707579151563.jpg\\\" style=\\\"\\\" title=\\\"14653707579151563.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160608/14653707608165712.jpg\\\" style=\\\"\\\" title=\\\"14653707608165712.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160608/14653707657303784.jpg\\\" style=\\\"\\\" title=\\\"14653707657303784.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160608/14653707742565125.jpg\\\" style=\\\"\\\" title=\\\"14653707742565125.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160608/14653707766913916.jpg\\\" style=\\\"\\\" title=\\\"14653707766913916.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160608/14653707843797559.jpg\\\" style=\\\"\\\" title=\\\"14653707843797559.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160608/14653707841479868.jpg\\\" style=\\\"\\\" title=\\\"14653707841479868.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160608/14653707876787837.jpg\\\" style=\\\"\\\" title=\\\"14653707876787837.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160608/146537078928723710.jpg\\\" style=\\\"\\\" title=\\\"146537078928723710.jpg\\\"/></p><p><br/></p>', '1', '1', '0.01', '0', '0.01', '154', '8', '0', '0', '0', '2016-06-02 15:59:31');
INSERT INTO `goods` VALUES ('431', '1', '超亮吸顶灯吊灯筒灯光源节能百搭', '', 'Philips/飞利浦', '山东', '', '', '<p><img src=\\\"/pic/upload/image/20160602/14648545799449771.jpg\\\" style=\\\"\\\" title=\\\"14648545799449771.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648545807315402.jpg\\\" style=\\\"\\\" title=\\\"14648545807315402.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648545821030783.jpg\\\" style=\\\"\\\" title=\\\"14648545821030783.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648545872371054.jpg\\\" style=\\\"\\\" title=\\\"14648545872371054.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648545971108366.jpg\\\" style=\\\"\\\" title=\\\"14648545971108366.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648546037108857.jpg\\\" style=\\\"\\\" title=\\\"14648546037108857.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648546048303415.jpg\\\" style=\\\"\\\" title=\\\"14648546048303415.jpg\\\"/></p><p><br/></p>', '1', '1', '0.01', '0', null, '155', '8', '0', '0', '0', '2016-06-02 16:03:59');
INSERT INTO `goods` VALUES ('432', '1', '飞利浦明尚led通用支架灯日光灯管', '', 'Philips/飞利浦', '上海', '', '', '<p>						</p><p><br/></p><p><br/></p><p style=\\\"text-align: left;\\\"><img src=\\\"/pic/upload/image/20160602/14648548271092233.jpg\\\" style=\\\"\\\" title=\\\"14648548271092233.jpg\\\"/></p><p style=\\\"text-align: left;\\\"><img src=\\\"/pic/upload/image/20160602/14648548311393321.jpg\\\" style=\\\"\\\" title=\\\"14648548311393321.jpg\\\"/></p><p style=\\\"text-align: left;\\\"><img src=\\\"/pic/upload/image/20160602/14648548357145855.jpg\\\" style=\\\"\\\" title=\\\"14648548357145855.jpg\\\"/></p><p style=\\\"text-align: left;\\\"><img src=\\\"/pic/upload/image/20160602/14648548514483912.jpg\\\" style=\\\"\\\" title=\\\"14648548514483912.jpg\\\"/></p><p style=\\\"text-align: left;\\\"><img src=\\\"/pic/upload/image/20160602/14648548533203286.jpg\\\" style=\\\"\\\" title=\\\"14648548533203286.jpg\\\"/></p><p style=\\\"text-align: left;\\\"><img src=\\\"/pic/upload/image/20160602/14648548571288244.jpg\\\" style=\\\"\\\" title=\\\"14648548571288244.jpg\\\"/></p><p style=\\\"text-align: left;\\\"><img src=\\\"/pic/upload/image/20160602/14648548588469947.jpg\\\" style=\\\"\\\" title=\\\"14648548588469947.jpg\\\"/></p><p style=\\\"text-align: left;\\\"><img src=\\\"/pic/upload/image/20160602/14648548642409778.jpg\\\" style=\\\"\\\" title=\\\"14648548642409778.jpg\\\"/></p><p style=\\\"text-align: left;\\\"><img src=\\\"/pic/upload/image/20160602/14648548676780089.jpg\\\" style=\\\"\\\" title=\\\"14648548676780089.jpg\\\"/></p><p><br/></p>', '1', '2', '0.01', '0', '0.01', '156', '7', '0', '0', '0', '2016-06-02 16:08:24');
INSERT INTO `goods` VALUES ('433', '1', '吸顶灯圆形卧室餐厅灯厨卫灯', '', 'AOZZO/奥朵', '广东佛山', '', '', '<p>						</p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160608/14653701731307643.jpg\\\" style=\\\"\\\" title=\\\"14653701731307643.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160608/14653701769600821.jpg\\\" style=\\\"\\\" title=\\\"14653701769600821.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160608/14653701801855532.jpg\\\" style=\\\"\\\" title=\\\"14653701801855532.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160608/14653701957847705.jpg\\\" style=\\\"\\\" title=\\\"14653701957847705.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160608/14653701961223736.jpg\\\" style=\\\"\\\" title=\\\"14653701961223736.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160608/14653701991577544.jpg\\\" style=\\\"\\\" title=\\\"14653701991577544.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160608/14653701991085267.jpg\\\" style=\\\"\\\" title=\\\"14653701991085267.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160608/14653701995637168.jpg\\\" style=\\\"\\\" title=\\\"14653701995637168.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160608/14653702029481199.jpg\\\" style=\\\"\\\" title=\\\"14653702029481199.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160608/146537020928887212.jpg\\\" style=\\\"\\\" title=\\\"146537020928887212.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160608/146537021011306111.jpg\\\" style=\\\"\\\" title=\\\"146537021011306111.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160608/146537021232458810.jpg\\\" style=\\\"\\\" title=\\\"146537021232458810.jpg\\\"/></p><p><br/></p>', '1', '3', '0.01', '0', '0.01', '158', '7', '0', '0', '0', '2016-06-02 16:12:20');
INSERT INTO `goods` VALUES ('434', '1', '北欧创意个性铁艺吊灯餐厅灯', '', '摩爵', '广东中山', '', '', '<p>						</p><p><img src=\\\"/pic/upload/image/20160602/14648553105023092.jpg\\\" style=\\\"\\\" title=\\\"14648553105023092.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648553101224723.jpg\\\" style=\\\"\\\" title=\\\"14648553101224723.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648553137265054.jpg\\\" style=\\\"\\\" title=\\\"14648553137265054.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648553174529955.jpg\\\" style=\\\"\\\" title=\\\"14648553174529955.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648553191510411.jpg\\\" style=\\\"\\\" title=\\\"14648553191510411.jpg\\\"/></p><p><br/></p>', '1', '2', '0.01', '0', '0.01', '159', '5', '0', '0', '0', '2016-06-02 16:16:00');
INSERT INTO `goods` VALUES ('435', '1', '美式乡村吊灯客厅灯 现代简约卧室灯', '', 'AOZZO/奥朵', '上海', '', '', '<p><img src=\\\"/pic/upload/image/20160602/14648555468940711.jpg\\\" style=\\\"\\\" title=\\\"14648555468940711.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648555515523552.jpg\\\" style=\\\"\\\" title=\\\"14648555515523552.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648555511135603.jpg\\\" style=\\\"\\\" title=\\\"14648555511135603.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648555553883184.jpg\\\" style=\\\"\\\" title=\\\"14648555553883184.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648555632887007.jpg\\\" style=\\\"\\\" title=\\\"14648555632887007.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648555661293536.jpg\\\" style=\\\"\\\" title=\\\"14648555661293536.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648555698731145.jpg\\\" style=\\\"\\\" title=\\\"14648555698731145.jpg\\\"/></p><p><br/></p>', '1', '7', '0.01', '0', null, '160', '5', '0', '0', '0', '2016-06-02 16:19:46');
INSERT INTO `goods` VALUES ('436', '1', '照明LED镜前灯卫生间浴室', '', '欧普', '上海', '', '', '<p><img src=\\\"/pic/upload/image/20160608/14653694878320621.jpg\\\" style=\\\"\\\" title=\\\"14653694878320621.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160608/14653694877262042.jpg\\\" style=\\\"\\\" title=\\\"14653694877262042.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160608/14653694907573593.jpg\\\" style=\\\"\\\" title=\\\"14653694907573593.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160608/14653694928234994.jpg\\\" style=\\\"\\\" title=\\\"14653694928234994.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160608/14653694978068456.jpg\\\" style=\\\"\\\" title=\\\"14653694978068456.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160608/14653695051199898.jpg\\\" style=\\\"\\\" title=\\\"14653695051199898.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160608/14653695101071575.jpg\\\" style=\\\"\\\" title=\\\"14653695101071575.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160608/14653695146531369.jpg\\\" style=\\\"\\\" title=\\\"14653695146531369.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160608/146536951926662410.jpg\\\" style=\\\"\\\" title=\\\"146536951926662410.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160608/146536952511880212.jpg\\\" style=\\\"\\\" title=\\\"146536952511880212.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160608/146536952526757111.jpg\\\" style=\\\"\\\" title=\\\"146536952526757111.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160608/14653695299876227.jpg\\\" style=\\\"\\\" title=\\\"14653695299876227.jpg\\\"/></p><p><br/></p>', '1', '2', '0.01', '0', '0.01', '162', '6', '0', '0', '0', '2016-06-02 16:24:04');
INSERT INTO `goods` VALUES ('437', '1', '欧式壁灯 ', '', ' Artbisic/亚特贝斯', '广东中山', '', '', '<p><img src=\\\"/pic/upload/image/20160602/14648561351369873.jpg\\\" style=\\\"\\\" title=\\\"14648561351369873.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648561363197262.jpg\\\" style=\\\"\\\" title=\\\"14648561363197262.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648561425137131.jpg\\\" style=\\\"\\\" title=\\\"14648561425137131.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648561442859034.jpg\\\" style=\\\"\\\" title=\\\"14648561442859034.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648561629801775.jpg\\\" style=\\\"\\\" title=\\\"14648561629801775.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648561664730056.jpg\\\" style=\\\"\\\" title=\\\"14648561664730056.jpg\\\"/></p><p><br/></p>', '1', '4', '0.01', '0', null, '163', '5', '0', '0', '0', '2016-06-02 16:30:24');
INSERT INTO `goods` VALUES ('438', '1', 'LED强光探照灯远射350米户外', '', '电魂', '北京', '', '', '<p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160608/14653689946645823.jpg\\\" style=\\\"\\\" title=\\\"14653689946645823.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160608/14653690009535841.jpg\\\" style=\\\"\\\" title=\\\"14653690009535841.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160608/14653690025465032.jpg\\\" style=\\\"\\\" title=\\\"14653690025465032.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160608/14653690095662125.jpg\\\" style=\\\"\\\" title=\\\"14653690095662125.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160608/14653690131023894.jpg\\\" style=\\\"\\\" title=\\\"14653690131023894.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160608/14653690187405767.jpg\\\" style=\\\"\\\" title=\\\"14653690187405767.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160608/14653690208124408.jpg\\\" style=\\\"\\\" title=\\\"14653690208124408.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160608/146536902695005510.jpg\\\" style=\\\"\\\" title=\\\"146536902695005510.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160608/14653690288072769.jpg\\\" style=\\\"\\\" title=\\\"14653690288072769.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160608/14653690337873956.jpg\\\" style=\\\"\\\" title=\\\"14653690337873956.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160608/146536903435191312.jpg\\\" style=\\\"\\\" title=\\\"146536903435191312.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160608/146536904014630811.jpg\\\" style=\\\"\\\" title=\\\"146536904014630811.jpg\\\"/></p><p><br/></p>', '1', '3', '0.01', '0', '0.01', '165', '5', '0', '0', '0', '2016-06-02 16:40:32');
INSERT INTO `goods` VALUES ('439', '1', '经典欧式吊灯', '', ' 铁艺吊灯', '广东中山', '', '', '<p><img src=\\\"/pic/upload/image/20160602/14648570131069943.jpg\\\" style=\\\"\\\" title=\\\"14648570131069943.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648570164194731.jpg\\\" style=\\\"\\\" title=\\\"14648570164194731.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648570206339012.jpg\\\" style=\\\"\\\" title=\\\"14648570206339012.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648570264915094.jpg\\\" style=\\\"\\\" title=\\\"14648570264915094.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648570318220365.jpg\\\" style=\\\"\\\" title=\\\"14648570318220365.jpg\\\"/></p><p><br/></p>', '1', '4', '0.01', '0', null, '166', '5', '0', '0', '0', '2016-06-02 16:44:18');
INSERT INTO `goods` VALUES ('440', '1', '简约现代LED餐厅灯餐吊灯', '', '佰丽灯饰', '广东中山', '', '', '<p><img src=\\\"/pic/upload/image/20160602/14648572878404963.jpg\\\" style=\\\"\\\" title=\\\"14648572878404963.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648572901226061.jpg\\\" style=\\\"\\\" title=\\\"14648572901226061.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648572938648092.jpg\\\" style=\\\"\\\" title=\\\"14648572938648092.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648573031285184.jpg\\\" style=\\\"\\\" title=\\\"14648573031285184.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648573136686276.jpg\\\" style=\\\"\\\" title=\\\"14648573136686276.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648573172827185.jpg\\\" style=\\\"\\\" title=\\\"14648573172827185.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648573245752487.jpg\\\" style=\\\"\\\" title=\\\"14648573245752487.jpg\\\"/></p><p><br/></p>', '1', '3', '0.01', '0', null, '167', '5', '0', '0', '0', '2016-06-02 16:49:11');
INSERT INTO `goods` VALUES ('441', '1', '欧式吊灯田园简欧客厅灯具', '', '奥缔斯登', '广东中山', '', '', '<p><img src=\\\"/pic/upload/image/20160602/14648575705448681.jpg\\\" style=\\\"\\\" title=\\\"14648575705448681.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648575771283632.jpg\\\" style=\\\"\\\" title=\\\"14648575771283632.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648575821012274.jpg\\\" style=\\\"\\\" title=\\\"14648575821012274.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648575911070973.jpg\\\" style=\\\"\\\" title=\\\"14648575911070973.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648575951707505.jpg\\\" style=\\\"\\\" title=\\\"14648575951707505.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648575984236907.jpg\\\" style=\\\"\\\" title=\\\"14648575984236907.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648576041222876.jpg\\\" style=\\\"\\\" title=\\\"14648576041222876.jpg\\\"/></p><p><br/></p>', '1', '8', '0.01', '0', null, '168', '6', '0', '0', '0', '2016-06-02 16:54:06');
INSERT INTO `goods` VALUES ('442', '1', '手工竹编灯具配件', '', '恒高', '广东', '', '', '<p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160608/14653683821021574.jpg\\\" style=\\\"\\\" title=\\\"14653683821021574.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160608/14653683862438182.jpg\\\" style=\\\"\\\" title=\\\"14653683862438182.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160608/14653683876125145.jpg\\\" style=\\\"\\\" title=\\\"14653683876125145.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160608/14653683923353037.jpg\\\" style=\\\"\\\" title=\\\"14653683923353037.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160608/14653683931528911.jpg\\\" style=\\\"\\\" title=\\\"14653683931528911.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160608/14653684051260578.jpg\\\" style=\\\"\\\" title=\\\"14653684051260578.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160608/14653684143720956.jpg\\\" style=\\\"\\\" title=\\\"14653684143720956.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160608/14653684159623629.jpg\\\" style=\\\"\\\" title=\\\"14653684159623629.jpg\\\"/></p><p><br/></p>', '1', '1', '0.01', '0', '0.01', '169', '8', '0', '0', '0', '2016-06-02 17:00:50');
INSERT INTO `goods` VALUES ('443', '1', '全铜防水开关插座液压缓冲阻尼式5五孔地插地面插', '', '罗格朗', '上海', '', '', '<p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160608/14653678074250672.jpg\\\" style=\\\"\\\" title=\\\"14653678074250672.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160608/14653678105116901.jpg\\\" style=\\\"\\\" title=\\\"14653678105116901.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160608/14653678228995793.jpg\\\" style=\\\"\\\" title=\\\"14653678228995793.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160608/14653678244187854.jpg\\\" style=\\\"\\\" title=\\\"14653678244187854.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160608/14653678285527867.jpg\\\" style=\\\"\\\" title=\\\"14653678285527867.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160608/14653678306919086.jpg\\\" style=\\\"\\\" title=\\\"14653678306919086.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160608/14653678339024195.jpg\\\" style=\\\"\\\" title=\\\"14653678339024195.jpg\\\"/></p><p><br/></p>', '1', '2', '0.01', '0', '0.01', '294', '7', '0', '0', '0', '2016-06-02 17:03:39');
INSERT INTO `goods` VALUES ('444', '1', '触摸屏86型C8触控智能开关', '', '优狐', '浙江温州', '', '', '<p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160608/14653672542772103.jpg\\\" style=\\\"\\\" title=\\\"14653672542772103.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160608/14653672605580792.jpg\\\" style=\\\"\\\" title=\\\"14653672605580792.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160608/14653672654926274.jpg\\\" style=\\\"\\\" title=\\\"14653672654926274.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160608/14653672659670961.jpg\\\" style=\\\"\\\" title=\\\"14653672659670961.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160608/14653672743300536.jpg\\\" style=\\\"\\\" title=\\\"14653672743300536.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160608/14653672748602055.jpg\\\" style=\\\"\\\" title=\\\"14653672748602055.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160608/14653672791017789.jpg\\\" style=\\\"\\\" title=\\\"14653672791017789.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160608/14653672918856378.jpg\\\" style=\\\"\\\" title=\\\"14653672918856378.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160608/146536729239115810.jpg\\\" style=\\\"\\\" title=\\\"146536729239115810.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160608/14653672971147747.jpg\\\" style=\\\"\\\" title=\\\"14653672971147747.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160608/146536729831223811.jpg\\\" style=\\\"\\\" title=\\\"146536729831223811.jpg\\\"/></p><p><br/></p>', '1', '1', '0.01', '0', '0.01', '295', '5', '0', '0', '0', '2016-06-02 17:06:16');
INSERT INTO `goods` VALUES ('445', '1', '欧普触摸开关', '', 'O＆P', '浙江温州', '', '', '<p><img src=\\\"/pic/upload/image/20160602/14648583463842733.jpg\\\" style=\\\"\\\" title=\\\"14648583463842733.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648583578726414.jpg\\\" style=\\\"\\\" title=\\\"14648583578726414.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648583583449422.jpg\\\" style=\\\"\\\" title=\\\"14648583583449422.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648583611039691.jpg\\\" style=\\\"\\\" title=\\\"14648583611039691.jpg\\\"/></p><p><br/></p>', '1', '1', '0.01', '0', null, '295', '5', '0', '0', '1', '2016-06-02 17:06:20');
INSERT INTO `goods` VALUES ('446', '1', '丹珑开关插座面板墙壁插座开 弱电插座', '', 'DENOO electric/丹珑', '广东江门', '', '', '<p><img src=\\\"/pic/upload/image/20160608/14653667867558533.jpg\\\" style=\\\"\\\" title=\\\"14653667867558533.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160608/14653667914944784.jpg\\\" style=\\\"\\\" title=\\\"14653667914944784.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160608/14653667951055312.jpg\\\" style=\\\"\\\" title=\\\"14653667951055312.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160608/14653668001497935.jpg\\\" style=\\\"\\\" title=\\\"14653668001497935.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160608/14653668125755506.jpg\\\" style=\\\"\\\" title=\\\"14653668125755506.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160608/14653668171139611.jpg\\\" style=\\\"\\\" title=\\\"14653668171139611.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160608/14653668191171368.jpg\\\" style=\\\"\\\" title=\\\"14653668191171368.jpg\\\"/></p><p><br/></p>', '1', '1', '0.01', '0', '0.01', '296', '7', '0', '0', '0', '2016-06-02 17:10:35');
INSERT INTO `goods` VALUES ('447', '1', '丹珑开关插座面板墙壁插座开 弱电插座', '', 'DENOO electric/丹珑', '广东江门', '', '', '<p><img src=\\\"/pic/upload/image/20160602/14648585754632372.jpg\\\" style=\\\"\\\" title=\\\"14648585754632372.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648585876032624.jpg\\\" style=\\\"\\\" title=\\\"14648585876032624.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648585904285101.jpg\\\" style=\\\"\\\" title=\\\"14648585904285101.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648585931575823.jpg\\\" style=\\\"\\\" title=\\\"14648585931575823.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648586014387095.jpg\\\" style=\\\"\\\" title=\\\"14648586014387095.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648586181132766.jpg\\\" style=\\\"\\\" title=\\\"14648586181132766.jpg\\\"/></p><p><br/></p>', '1', '1', '0.01', '0', null, '296', '7', '0', '0', '1', '2016-06-02 17:10:53');
INSERT INTO `goods` VALUES ('448', '1', '大板香槟开关插座面板86型墙壁插座', '', 'sernlcne', '浙江温州', '', '', '<p><img src=\\\"/pic/upload/image/20160602/14648588178311151.jpg\\\" style=\\\"\\\" title=\\\"14648588178311151.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648588231062882.jpg\\\" style=\\\"\\\" title=\\\"14648588231062882.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648588325886743.jpg\\\" style=\\\"\\\" title=\\\"14648588325886743.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648588363112054.jpg\\\" style=\\\"\\\" title=\\\"14648588363112054.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648588379966595.jpg\\\" style=\\\"\\\" title=\\\"14648588379966595.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160602/14648588541073296.jpg\\\" style=\\\"\\\" title=\\\"14648588541073296.jpg\\\"/></p><p><br/></p>', '1', '1', '0.01', '0', null, '297', '7', '0', '0', '0', '2016-06-02 17:14:48');
INSERT INTO `goods` VALUES ('449', '1', '西门子开关插座', '', '西门子', '上海', '', '', '<p><img src=\\\"/pic/upload/image/20160603/14649323708519003.jpg\\\" style=\\\"\\\" title=\\\"14649323708519003.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649323785782182.jpg\\\" style=\\\"\\\" title=\\\"14649323785782182.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649323801237724.jpg\\\" style=\\\"\\\" title=\\\"14649323801237724.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649323828786655.jpg\\\" style=\\\"\\\" title=\\\"14649323828786655.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649323931166721.jpg\\\" style=\\\"\\\" title=\\\"14649323931166721.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649323951165686.jpg\\\" style=\\\"\\\" title=\\\"14649323951165686.jpg\\\"/></p><p><br/></p>', '1', '1', '0.01', '0', null, '298', '8', '0', '0', '0', '2016-06-03 13:40:36');
INSERT INTO `goods` VALUES ('450', '1', '液晶监视器监控显示器', '', ' 富泰尔', '广东深圳', '', '', '<p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160608/14653657606818382.jpg\\\" style=\\\"\\\" title=\\\"14653657606818382.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160608/14653657761495351.jpg\\\" style=\\\"\\\" title=\\\"14653657761495351.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160608/14653657866545565.jpg\\\" style=\\\"\\\" title=\\\"14653657866545565.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160608/14653658039185136.jpg\\\" style=\\\"\\\" title=\\\"14653658039185136.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160608/14653658054875073.jpg\\\" style=\\\"\\\" title=\\\"14653658054875073.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160608/14653658071004367.jpg\\\" style=\\\"\\\" title=\\\"14653658071004367.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160608/14653658124234758.jpg\\\" style=\\\"\\\" title=\\\"14653658124234758.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160608/146536582193460710.jpg\\\" style=\\\"\\\" title=\\\"146536582193460710.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160608/14653658273886209.jpg\\\" style=\\\"\\\" title=\\\"14653658273886209.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160608/1465365827624348QQ截图20160608140325.jpg\\\" style=\\\"\\\" title=\\\"1465365827624348QQ截图20160608140325.jpg\\\"/></p><p><br/></p>', '1', '7', '0.01', '0', '0.01', '299', '6', '0', '0', '0', '2016-06-03 13:46:31');
INSERT INTO `goods` VALUES ('451', '1', '智能开关', '', '澳格纳', '北京', '', '', '<p>						</p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160608/14653646301315483.jpg\\\" style=\\\"\\\" title=\\\"14653646301315483.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160608/14653646391303644.jpg\\\" style=\\\"\\\" title=\\\"14653646391303644.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160608/14653646403725691.jpg\\\" style=\\\"\\\" title=\\\"14653646403725691.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160608/14653646424604832.jpg\\\" style=\\\"\\\" title=\\\"14653646424604832.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160608/14653646491301846.jpg\\\" style=\\\"\\\" title=\\\"14653646491301846.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160608/14653646543629738.jpg\\\" style=\\\"\\\" title=\\\"14653646543629738.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160608/14653646595253315.jpg\\\" style=\\\"\\\" title=\\\"14653646595253315.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160608/14653646627949269.jpg\\\" style=\\\"\\\" title=\\\"14653646627949269.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160608/146536466562568210.jpg\\\" style=\\\"\\\" title=\\\"146536466562568210.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160608/146536467425182111.jpg\\\" style=\\\"\\\" title=\\\"146536467425182111.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160608/146536467898383512.jpg\\\" style=\\\"\\\" title=\\\"146536467898383512.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160608/146536468786726213.jpg\\\" style=\\\"\\\" title=\\\"146536468786726213.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160608/146536469481106314.jpg\\\" style=\\\"\\\" title=\\\"146536469481106314.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160608/146536469675770316.jpg\\\" style=\\\"\\\" title=\\\"146536469675770316.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160608/14653647101277657.jpg\\\" style=\\\"\\\" title=\\\"14653647101277657.jpg\\\"/></p><p><br/></p>', '1', '2', '0.01', '0', '0.01', '300', '6', '1', '0', '0', '2016-06-03 13:51:34');
INSERT INTO `goods` VALUES ('452', '1', '手机无线报警器gsm防盗器家用店铺红外线', '', '图睿安防', '上海', '', '', '<p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160608/14653579821161122.jpg\\\" style=\\\"\\\" title=\\\"14653579821161122.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160608/14653579896984483.jpg\\\" style=\\\"\\\" title=\\\"14653579896984483.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160608/14653580006202174.jpg\\\" style=\\\"\\\" title=\\\"14653580006202174.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160608/14653580067902785.jpg\\\" style=\\\"\\\" title=\\\"14653580067902785.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160608/14653580068176046.jpg\\\" style=\\\"\\\" title=\\\"14653580068176046.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160608/14653580145839847.jpg\\\" style=\\\"\\\" title=\\\"14653580145839847.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160608/14653580191353348.jpg\\\" style=\\\"\\\" title=\\\"14653580191353348.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160608/14653580203723101.jpg\\\" style=\\\"\\\" title=\\\"14653580203723101.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160608/14653580253825099.jpg\\\" style=\\\"\\\" title=\\\"14653580253825099.jpg\\\"/></p><p><br/></p>', '1', '5', '0.01', '0', '0.01', '301', '6', '0', '0', '0', '2016-06-03 13:56:07');
INSERT INTO `goods` VALUES ('453', '1', '200万数字全套海康监控套装', '', 'HIKVISION/海康威视', '上海', '', '', '<p><img src=\\\"/pic/upload/image/20160603/14649337115234811.jpg\\\" style=\\\"\\\" title=\\\"14649337115234811.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649337202428284.jpg\\\" style=\\\"\\\" title=\\\"14649337202428284.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649337306940595.jpg\\\" style=\\\"\\\" title=\\\"14649337306940595.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649337344732632.jpg\\\" style=\\\"\\\" title=\\\"14649337344732632.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649337408705326.jpg\\\" style=\\\"\\\" title=\\\"14649337408705326.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649337448664013.jpg\\\" style=\\\"\\\" title=\\\"14649337448664013.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649337458178198.jpg\\\" style=\\\"\\\" title=\\\"14649337458178198.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649337485440937.jpg\\\" style=\\\"\\\" title=\\\"14649337485440937.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649337526555899.jpg\\\" style=\\\"\\\" title=\\\"14649337526555899.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/146493376112996810.jpg\\\" style=\\\"\\\" title=\\\"146493376112996810.jpg\\\"/></p><p><br/></p>', '1', '5', '0.01', '0', null, '302', '6', '0', '0', '0', '2016-06-03 14:02:55');
INSERT INTO `goods` VALUES ('454', '1', '高清3000线监控摄像头套餐', '', '警视卫', '广州东莞', '', '', '<p><img src=\\\"/pic/upload/image/20160603/14649343273695563.jpg\\\" style=\\\"\\\" title=\\\"14649343273695563.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649343324701222.jpg\\\" style=\\\"\\\" title=\\\"14649343324701222.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649343395199091.jpg\\\" style=\\\"\\\" title=\\\"14649343395199091.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649343423288484.jpg\\\" style=\\\"\\\" title=\\\"14649343423288484.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649343431863275.jpg\\\" style=\\\"\\\" title=\\\"14649343431863275.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649343488203578.jpg\\\" style=\\\"\\\" title=\\\"14649343488203578.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649343484566107.jpg\\\" style=\\\"\\\" title=\\\"14649343484566107.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649343537563699.jpg\\\" style=\\\"\\\" title=\\\"14649343537563699.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649343566609686.jpg\\\" style=\\\"\\\" title=\\\"14649343566609686.jpg\\\"/></p><p><br/></p>', '1', '1', '0.01', '0', null, '303', '7', '0', '0', '0', '2016-06-03 14:09:49');
INSERT INTO `goods` VALUES ('455', '1', '创意不用电池门铃', '', ' AuGreener/澳格纳', '上海', '', '', '<p><img src=\\\"/pic/upload/image/20160603/14649346689001382.jpg\\\" style=\\\"\\\" title=\\\"14649346689001382.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649346681165603.jpg\\\" style=\\\"\\\" title=\\\"14649346681165603.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649346702637844.jpg\\\" style=\\\"\\\" title=\\\"14649346702637844.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649346765499035.jpg\\\" style=\\\"\\\" title=\\\"14649346765499035.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649346812439046.jpg\\\" style=\\\"\\\" title=\\\"14649346812439046.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649346841210447.jpg\\\" style=\\\"\\\" title=\\\"14649346841210447.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649346901376151.jpg\\\" style=\\\"\\\" title=\\\"14649346901376151.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649346991957948.jpg\\\" style=\\\"\\\" title=\\\"14649346991957948.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649347042392569.jpg\\\" style=\\\"\\\" title=\\\"14649347042392569.jpg\\\"/></p><p><br/></p>', '1', '1', '0.01', '0', null, '304', '8', '0', '0', '0', '2016-06-03 14:18:39');
INSERT INTO `goods` VALUES ('456', '1', ' 西门子空气开关断路器', '', '西门子', '浙江台州', '', '', '<p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160608/14653570201052513.jpg\\\" style=\\\"\\\" title=\\\"14653570201052513.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160608/14653570233906851.jpg\\\" style=\\\"\\\" title=\\\"14653570233906851.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160608/14653570267724632.jpg\\\" style=\\\"\\\" title=\\\"14653570267724632.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160608/14653570328207454.jpg\\\" style=\\\"\\\" title=\\\"14653570328207454.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160608/14653570341107165.jpg\\\" style=\\\"\\\" title=\\\"14653570341107165.jpg\\\"/></p><p><br/></p>', '1', '2', '0.01', '0', '0.01', '305', '5', '0', '0', '0', '2016-06-03 14:24:03');
INSERT INTO `goods` VALUES ('457', '1', '法纳通32A漏电保护器', '', 'Fraaton/法纳通', '上海', '', '', '<p><img src=\\\"/pic/upload/image/20160603/14649356491271112.jpg\\\" style=\\\"\\\" title=\\\"14649356491271112.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649356581323014.jpg\\\" style=\\\"\\\" title=\\\"14649356581323014.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649356609171791.jpg\\\" style=\\\"\\\" title=\\\"14649356609171791.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649356682738116.jpg\\\" style=\\\"\\\" title=\\\"14649356682738116.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649356787893743.jpg\\\" style=\\\"\\\" title=\\\"14649356787893743.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649356861087808.jpg\\\" style=\\\"\\\" title=\\\"14649356861087808.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649356886958237.jpg\\\" style=\\\"\\\" title=\\\"14649356886958237.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649357051375165.jpg\\\" style=\\\"\\\" title=\\\"14649357051375165.jpg\\\"/></p><p><br/></p>', '1', '4', '0.01', '0', null, '306', '8', '0', '0', '0', '2016-06-03 14:35:24');
INSERT INTO `goods` VALUES ('458', '1', '家用保护空气开关', '', 'CHNT/正泰', '浙江杭州', '', '', '<p><img src=\\\"/pic/upload/image/20160603/14649365981188151.jpg\\\" style=\\\"\\\" title=\\\"14649365981188151.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649366009432992.jpg\\\" style=\\\"\\\" title=\\\"14649366009432992.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649366071240003.jpg\\\" style=\\\"\\\" title=\\\"14649366071240003.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649366131907594.jpg\\\" style=\\\"\\\" title=\\\"14649366131907594.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649366241074676.jpg\\\" style=\\\"\\\" title=\\\"14649366241074676.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649366291710515.jpg\\\" style=\\\"\\\" title=\\\"14649366291710515.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649366301175587.jpg\\\" style=\\\"\\\" title=\\\"14649366301175587.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649366316317068.jpg\\\" style=\\\"\\\" title=\\\"14649366316317068.jpg\\\"/></p><p><br/></p>', '1', '4', '0.01', '0', null, '307', '7', '0', '0', '0', '2016-06-03 14:50:52');
INSERT INTO `goods` VALUES ('459', '1', '施耐德强电箱 家装配电箱20回路暗装', '', 'Schneider Electric/施耐德', '上海', '', '', '<p><img src=\\\"/pic/upload/image/20160603/14649372594721873.jpg\\\" style=\\\"\\\" title=\\\"14649372594721873.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649372591250892.jpg\\\" style=\\\"\\\" title=\\\"14649372591250892.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649372601213361.jpg\\\" style=\\\"\\\" title=\\\"14649372601213361.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649372656243916.jpg\\\" style=\\\"\\\" title=\\\"14649372656243916.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649372671142534.jpg\\\" style=\\\"\\\" title=\\\"14649372671142534.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649372693209745.jpg\\\" style=\\\"\\\" title=\\\"14649372693209745.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649372761358557.jpg\\\" style=\\\"\\\" title=\\\"14649372761358557.jpg\\\"/></p><p><br/></p>', '1', '5', '0.01', '0', null, '308', '5', '0', '0', '0', '2016-06-03 15:01:30');
INSERT INTO `goods` VALUES ('460', '1', '弱电配电箱家用', '', 'e代家园', '浙江温州', '', '', '<p><img src=\\\"/pic/upload/image/20160603/14649375712627093.jpg\\\" style=\\\"\\\" title=\\\"14649375712627093.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649375819518631.jpg\\\" style=\\\"\\\" title=\\\"14649375819518631.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649375836009382.jpg\\\" style=\\\"\\\" title=\\\"14649375836009382.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649375917967335.jpg\\\" style=\\\"\\\" title=\\\"14649375917967335.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649375945126377.jpg\\\" style=\\\"\\\" title=\\\"14649375945126377.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649375941151146.jpg\\\" style=\\\"\\\" title=\\\"14649375941151146.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649375982812984.jpg\\\" style=\\\"\\\" title=\\\"14649375982812984.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649376102550068.jpg\\\" style=\\\"\\\" title=\\\"14649376102550068.jpg\\\"/></p><p><br/></p>', '1', '3', '0.01', '0', null, '309', '5', '0', '0', '0', '2016-06-03 15:07:11');
INSERT INTO `goods` VALUES ('461', '1', '远东电线电缆 BV6', '', 'FAR EAST CABLE/远东电缆', '江苏无锡', '', '', '<p><img src=\\\"/pic/upload/image/20160603/14649378431245681.jpg\\\" style=\\\"\\\" title=\\\"14649378431245681.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649378439758312.jpg\\\" style=\\\"\\\" title=\\\"14649378439758312.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649378491340483.jpg\\\" style=\\\"\\\" title=\\\"14649378491340483.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649378491406704.jpg\\\" style=\\\"\\\" title=\\\"14649378491406704.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649378501498795.jpg\\\" style=\\\"\\\" title=\\\"14649378501498795.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649378577630826.jpg\\\" style=\\\"\\\" title=\\\"14649378577630826.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649378711975159.jpg\\\" style=\\\"\\\" title=\\\"14649378711975159.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649378721157428.jpg\\\" style=\\\"\\\" title=\\\"14649378721157428.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649378751156697.jpg\\\" style=\\\"\\\" title=\\\"14649378751156697.jpg\\\"/></p><p><br/></p>', '1', '9', '0.01', '0', null, '310', '8', '0', '0', '0', '2016-06-03 15:11:28');
INSERT INTO `goods` VALUES ('462', '1', '远东电线电缆BV4平方国标铜芯家装空调电线 ', '', 'FAR EAST CABLE/远东电缆', '江苏无锡', '', '', '<p><img src=\\\"/pic/upload/image/20160603/14649380731242111.jpg\\\" style=\\\"\\\" title=\\\"14649380731242111.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649380751303862.jpg\\\" style=\\\"\\\" title=\\\"14649380751303862.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649380761229974.jpg\\\" style=\\\"\\\" title=\\\"14649380761229974.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649380771112543.jpg\\\" style=\\\"\\\" title=\\\"14649380771112543.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649380834986525.jpg\\\" style=\\\"\\\" title=\\\"14649380834986525.jpg\\\"/></p><p><br/></p>', '1', '9', '0.01', '0', null, '311', '7', '0', '0', '0', '2016-06-03 15:15:00');
INSERT INTO `goods` VALUES ('463', '1', '正泰电线电缆线国标BV2.5平方铜芯电线', '', 'CHNT/正泰', '上海', '', '', '<p><img src=\\\"/pic/upload/image/20160603/14649382571694591.jpg\\\" style=\\\"\\\" title=\\\"14649382571694591.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649382669880094.jpg\\\" style=\\\"\\\" title=\\\"14649382669880094.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649382669692903.jpg\\\" style=\\\"\\\" title=\\\"14649382669692903.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649382713076772.jpg\\\" style=\\\"\\\" title=\\\"14649382713076772.jpg\\\"/></p><p><br/></p>', '1', '9', '0.01', '0', null, '312', '6', '0', '0', '0', '2016-06-03 15:18:21');
INSERT INTO `goods` VALUES ('464', '1', ' 国标家装单股铜线 硬线 BV 1.5平方', '', 'CHNT/正泰', '浙江杭州', '', '', '<p><img src=\\\"/pic/upload/image/20160603/14649385247021922.jpg\\\" style=\\\"\\\" title=\\\"14649385247021922.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649385266070921.jpg\\\" style=\\\"\\\" title=\\\"14649385266070921.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649385301049413.jpg\\\" style=\\\"\\\" title=\\\"14649385301049413.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649385397015045.jpg\\\" style=\\\"\\\" title=\\\"14649385397015045.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649385431067017.jpg\\\" style=\\\"\\\" title=\\\"14649385431067017.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649385438176034.jpg\\\" style=\\\"\\\" title=\\\"14649385438176034.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649385499888708.jpg\\\" style=\\\"\\\" title=\\\"14649385499888708.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649385501310616.jpg\\\" style=\\\"\\\" title=\\\"14649385501310616.jpg\\\"/></p><p><br/></p>', '1', '8', '0.01', '0', null, '313', '7', '0', '0', '0', '2016-06-03 15:23:05');
INSERT INTO `goods` VALUES ('465', '1', '30米50拖线工程插排插座', '', 'BULL/公牛', '江苏无锡', '', '', '<p><img src=\\\"/pic/upload/image/20160603/14649389024915523.jpg\\\" style=\\\"\\\" title=\\\"14649389024915523.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649389022840951.jpg\\\" style=\\\"\\\" title=\\\"14649389022840951.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649389104520052.jpg\\\" style=\\\"\\\" title=\\\"14649389104520052.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649389115105295.jpg\\\" style=\\\"\\\" title=\\\"14649389115105295.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649389121069334.jpg\\\" style=\\\"\\\" title=\\\"14649389121069334.jpg\\\"/></p><p><br/></p>', '1', '9', '0.01', '0', null, '314', '6', '0', '0', '0', '2016-06-03 15:29:12');
INSERT INTO `goods` VALUES ('466', '1', '家用插座排插', '', ' 廷牛', '广东', '', '', '<p><img src=\\\"/pic/upload/image/20160603/14649392331129883.jpg\\\" style=\\\"\\\" title=\\\"14649392331129883.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649392348236712.jpg\\\" style=\\\"\\\" title=\\\"14649392348236712.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649392366474564.jpg\\\" style=\\\"\\\" title=\\\"14649392366474564.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649392431274901.jpg\\\" style=\\\"\\\" title=\\\"14649392431274901.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649392441079196.jpg\\\" style=\\\"\\\" title=\\\"14649392441079196.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649392531000278.jpg\\\" style=\\\"\\\" title=\\\"14649392531000278.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649392578559889.jpg\\\" style=\\\"\\\" title=\\\"14649392578559889.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649392601343027.jpg\\\" style=\\\"\\\" title=\\\"14649392601343027.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649392637157905.jpg\\\" style=\\\"\\\" title=\\\"14649392637157905.jpg\\\"/></p><p><br/></p>', '1', '1', '0.01', '0', null, '315', '7', '0', '0', '0', '2016-06-03 15:34:42');
INSERT INTO `goods` VALUES ('467', '1', '长方形淋浴房整体沐浴房', '', '艾戈恋家', '广东佛山', '', '', '<p>						</p><p style=\\\"text-align: left;\\\"><img src=\\\"/pic/upload/image/20160608/14653564145520113.jpg\\\" style=\\\"\\\" title=\\\"14653564145520113.jpg\\\"/></p><p style=\\\"text-align: left;\\\"><img src=\\\"/pic/upload/image/20160608/14653564209395121.jpg\\\" style=\\\"\\\" title=\\\"14653564209395121.jpg\\\"/></p><p style=\\\"text-align: left;\\\"><img src=\\\"/pic/upload/image/20160608/14653564223248462.jpg\\\" style=\\\"\\\" title=\\\"14653564223248462.jpg\\\"/></p><p style=\\\"text-align: left;\\\"><img src=\\\"/pic/upload/image/20160608/14653564351359766.jpg\\\" style=\\\"\\\" title=\\\"14653564351359766.jpg\\\"/></p><p style=\\\"text-align: left;\\\"><img src=\\\"/pic/upload/image/20160608/14653564381365744.jpg\\\" style=\\\"\\\" title=\\\"14653564381365744.jpg\\\"/></p><p style=\\\"text-align: left;\\\"><img src=\\\"/pic/upload/image/20160608/14653564401065945.jpg\\\" style=\\\"\\\" title=\\\"14653564401065945.jpg\\\"/></p><p style=\\\"text-align: left;\\\"><img src=\\\"/pic/upload/image/20160608/14653564589256998.jpg\\\" style=\\\"\\\" title=\\\"14653564589256998.jpg\\\"/></p><p style=\\\"text-align: left;\\\"><img src=\\\"/pic/upload/image/20160608/14653564692255299.jpg\\\" style=\\\"\\\" title=\\\"14653564692255299.jpg\\\"/></p><p style=\\\"text-align: left;\\\"><img src=\\\"/pic/upload/image/20160608/14653565341377237.jpg\\\" style=\\\"\\\" title=\\\"14653565341377237.jpg\\\"/></p><p><br/></p>', '1', '10', '0.02', '0', '0.01', '181', '6', '1', '0', '0', '2016-06-03 15:40:16');
INSERT INTO `goods` VALUES ('468', '1', '现代简约开放式整体橱柜', '', 'Goldenhome/金牌厨柜', '重庆', '', '', '<p>						</p><p><img src=\\\"/pic/upload/image/20160608/14653558682322852.jpg\\\" style=\\\"\\\" title=\\\"14653558682322852.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160608/14653558721038311.jpg\\\" style=\\\"\\\" title=\\\"14653558721038311.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160608/14653558771327614.jpg\\\" style=\\\"\\\" title=\\\"14653558771327614.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160608/14653558851196716.jpg\\\" style=\\\"\\\" title=\\\"14653558851196716.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160608/14653558899821145.jpg\\\" style=\\\"\\\" title=\\\"14653558899821145.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160608/14653558954801053.jpg\\\" style=\\\"\\\" title=\\\"14653558954801053.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160608/14653558982747149.jpg\\\" style=\\\"\\\" title=\\\"14653558982747149.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160608/14653559021045757.jpg\\\" style=\\\"\\\" title=\\\"14653559021045757.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160608/146535591027105710.jpg\\\" style=\\\"\\\" title=\\\"146535591027105710.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160608/14653559121190478+.jpg\\\" style=\\\"\\\" title=\\\"14653559121190478+.jpg\\\"/></p><p><br/></p>', '1', '9', '0.02', '0', '0.01', '182', '5', '0', '0', '0', '2016-06-03 15:44:16');
INSERT INTO `goods` VALUES ('469', '1', '欧式简约陶瓷卫浴六件套', '', '艺可美', '广州', '', '', '<p>						</p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160608/14653552403175311.jpg\\\" style=\\\"\\\" title=\\\"14653552403175311.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160608/14653552401038703.jpg\\\" style=\\\"\\\" title=\\\"14653552401038703.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160608/14653552468196692.jpg\\\" style=\\\"\\\" title=\\\"14653552468196692.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160608/14653552469587914.jpg\\\" style=\\\"\\\" title=\\\"14653552469587914.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160608/14653552637804245.jpg\\\" style=\\\"\\\" title=\\\"14653552637804245.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160608/14653552656482736.jpg\\\" style=\\\"\\\" title=\\\"14653552656482736.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160608/14653552675638458.jpg\\\" style=\\\"\\\" title=\\\"14653552675638458.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160608/146535528699992910.jpg\\\" style=\\\"\\\" title=\\\"146535528699992910.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160608/14653552867435469.jpg\\\" style=\\\"\\\" title=\\\"14653552867435469.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160608/146535529091756612.jpg\\\" style=\\\"\\\" title=\\\"146535529091756612.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160608/146535529625268211.jpg\\\" style=\\\"\\\" title=\\\"146535529625268211.jpg\\\"/></p><p><br/></p>', '1', '2', '0.02', '0', '0.01', '183', '8', '1', '0', '0', '2016-06-03 15:51:15');
INSERT INTO `goods` VALUES ('470', '1', '沐浴桶泡澡木桶', '', '百年羚', '四川成都', '', '', '<p><img src=\\\"/pic/upload/image/20160608/14653543261011671.jpg\\\" style=\\\"\\\" title=\\\"14653543261011671.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160608/14653543343399514.jpg\\\" style=\\\"\\\" title=\\\"14653543343399514.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160608/14653543412480355.jpg\\\" style=\\\"\\\" title=\\\"14653543412480355.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160608/14653543461379942.jpg\\\" style=\\\"\\\" title=\\\"14653543461379942.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160608/14653543532736823.jpg\\\" style=\\\"\\\" title=\\\"14653543532736823.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160608/14653543552635267.jpg\\\" style=\\\"\\\" title=\\\"14653543552635267.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160608/14653543595656959.jpg\\\" style=\\\"\\\" title=\\\"14653543595656959.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160608/14653543611050758.jpg\\\" style=\\\"\\\" title=\\\"14653543611050758.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160608/14653543626459076.jpg\\\" style=\\\"\\\" title=\\\"14653543626459076.jpg\\\"/></p><p><br/></p>', '1', '20', '0.01', '0', '0.01', '184', '6', '0', '0', '0', '2016-06-03 15:54:43');
INSERT INTO `goods` VALUES ('471', '1', '按摩浴缸 双人浴缸 三角浴缸 扇形浴缸', '', ' ARROW/箭牌', '广东佛山', '', '', '<p>						</p><p><img src=\\\"/pic/upload/image/20160608/14653536311367071.jpg\\\" style=\\\"\\\" title=\\\"14653536311367071.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160608/14653536387431584.jpg\\\" style=\\\"\\\" title=\\\"14653536387431584.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160608/14653536421123733.jpg\\\" style=\\\"\\\" title=\\\"14653536421123733.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160608/14653536457141985.jpg\\\" style=\\\"\\\" title=\\\"14653536457141985.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160608/14653536517022782.jpg\\\" style=\\\"\\\" title=\\\"14653536517022782.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160608/14653536616283507.jpg\\\" style=\\\"\\\" title=\\\"14653536616283507.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160608/14653536613669756.jpg\\\" style=\\\"\\\" title=\\\"14653536613669756.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160608/14653536727946679.jpg\\\" style=\\\"\\\" title=\\\"14653536727946679.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160608/14653536778796988.jpg\\\" style=\\\"\\\" title=\\\"14653536778796988.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160608/146535368110609012.jpg\\\" style=\\\"\\\" title=\\\"146535368110609012.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160608/146535368623482414.jpg\\\" style=\\\"\\\" title=\\\"146535368623482414.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160608/146535368766363615.jpg\\\" style=\\\"\\\" title=\\\"146535368766363615.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160608/146535370414055913.jpg\\\" style=\\\"\\\" title=\\\"146535370414055913.jpg\\\"/></p><p><br/></p>', '1', '20', '0.02', '0', '0.01', '185', '7', '1', '0', '0', '2016-06-03 15:59:49');
INSERT INTO `goods` VALUES ('472', '1', '壁挂净水机家用净水器中央软水软水器', '', 'ATLAS FILTRI/', '上海', '', '', '<p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160608/14653525633879742.jpg\\\" style=\\\"\\\" title=\\\"14653525633879742.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160608/14653525634161601.jpg\\\" style=\\\"\\\" title=\\\"14653525634161601.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160608/14653525788274585.jpg\\\" style=\\\"\\\" title=\\\"14653525788274585.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160608/14653525821178644.jpg\\\" style=\\\"\\\" title=\\\"14653525821178644.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160608/14653525912349537.jpg\\\" style=\\\"\\\" title=\\\"14653525912349537.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160608/14653525929626636.jpg\\\" style=\\\"\\\" title=\\\"14653525929626636.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160608/14653525986219818.jpg\\\" style=\\\"\\\" title=\\\"14653525986219818.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160608/14653526069069373.jpg\\\" style=\\\"\\\" title=\\\"14653526069069373.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160608/146535261310349110.jpg\\\" style=\\\"\\\" title=\\\"146535261310349110.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160608/146535262410899912.jpg\\\" style=\\\"\\\" title=\\\"146535262410899912.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160608/14653526327564989.jpg\\\" style=\\\"\\\" title=\\\"14653526327564989.jpg\\\"/></p><p style=\\\"text-align: center;\\\"><img src=\\\"/pic/upload/image/20160608/146535263264874711.jpg\\\" style=\\\"\\\" title=\\\"146535263264874711.jpg\\\"/></p><p><br/></p>', '1', '5', '0.01', '0', '0.01', '186', '6', '0', '0', '0', '2016-06-03 16:04:12');
INSERT INTO `goods` VALUES ('473', '1', '智能恒温花洒套装', '', 'DGPOSY', '上海', '', '', '<p>						</p><p style=\\\"text-align: left;\\\"><img src=\\\"/pic/upload/image/20160608/14653512059786713.jpg\\\" style=\\\"\\\" title=\\\"14653512059786713.jpg\\\"/></p><p style=\\\"text-align: left;\\\"><img src=\\\"/pic/upload/image/20160608/14653512177544332.jpg\\\" style=\\\"\\\" title=\\\"14653512177544332.jpg\\\"/></p><p style=\\\"text-align: left;\\\"><img src=\\\"/pic/upload/image/20160608/14653512297639865.jpg\\\" style=\\\"\\\" title=\\\"14653512297639865.jpg\\\"/></p><p style=\\\"text-align: left;\\\"><img src=\\\"/pic/upload/image/20160608/14653512334707676.jpg\\\" style=\\\"\\\" title=\\\"14653512334707676.jpg\\\"/></p><p style=\\\"text-align: left;\\\"><img src=\\\"/pic/upload/image/20160608/14653512391020924.jpg\\\" style=\\\"\\\" title=\\\"14653512391020924.jpg\\\"/></p><p style=\\\"text-align: left;\\\"><img src=\\\"/pic/upload/image/20160608/14653512415908691.jpg\\\" style=\\\"\\\" title=\\\"14653512415908691.jpg\\\"/></p><p style=\\\"text-align: left;\\\"><img src=\\\"/pic/upload/image/20160608/14653512496937159.jpg\\\" style=\\\"\\\" title=\\\"14653512496937159.jpg\\\"/></p><p style=\\\"text-align: left;\\\"><img src=\\\"/pic/upload/image/20160608/14653512574786428.jpg\\\" style=\\\"\\\" title=\\\"14653512574786428.jpg\\\"/></p><p style=\\\"text-align: left;\\\"><img src=\\\"/pic/upload/image/20160608/146535126057968110.jpg\\\" style=\\\"\\\" title=\\\"146535126057968110.jpg\\\"/></p><p style=\\\"text-align: left;\\\"><img src=\\\"/pic/upload/image/20160608/14653512615904827.jpg\\\" style=\\\"\\\" title=\\\"14653512615904827.jpg\\\"/></p><p style=\\\"text-align: left;\\\"><img src=\\\"/pic/upload/image/20160608/146535126860210012.jpg\\\" style=\\\"\\\" title=\\\"146535126860210012.jpg\\\"/></p><p style=\\\"text-align: left;\\\"><img src=\\\"/pic/upload/image/20160608/146535127840041013.jpg\\\" style=\\\"\\\" title=\\\"146535127840041013.jpg\\\"/></p><p style=\\\"text-align: left;\\\"><img src=\\\"/pic/upload/image/20160608/146535128390009514.jpg\\\" style=\\\"\\\" title=\\\"146535128390009514.jpg\\\"/></p><p style=\\\"text-align: left;\\\"><img src=\\\"/pic/upload/image/20160608/146535131324962711.jpg\\\" style=\\\"\\\" title=\\\"146535131324962711.jpg\\\"/></p><p><br/></p>', '1', '5', '0.02', '0', '0.01', '187', '6', '1', '0', '0', '2016-06-03 16:09:00');
INSERT INTO `goods` VALUES ('474', '1', '浴室淋雨花洒软管防爆', '', ' JOMOO/九牧', '浙江杭州', '', '', '<p><img src=\\\"/pic/upload/image/20160608/14653503014763182.jpg\\\" style=\\\"\\\" title=\\\"14653503014763182.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160608/14653503064970174.jpg\\\" style=\\\"\\\" title=\\\"14653503064970174.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160608/14653503155167681.jpg\\\" style=\\\"\\\" title=\\\"14653503155167681.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160608/14653503345320445.jpg\\\" style=\\\"\\\" title=\\\"14653503345320445.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160608/14653503431388676.jpg\\\" style=\\\"\\\" title=\\\"14653503431388676.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160608/14653503536854537.jpg\\\" style=\\\"\\\" title=\\\"14653503536854537.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160608/14653503541170333.jpg\\\" style=\\\"\\\" title=\\\"14653503541170333.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160608/14653503553267838.jpg\\\" style=\\\"\\\" title=\\\"14653503553267838.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160608/146535036988839110.jpg\\\" style=\\\"\\\" title=\\\"146535036988839110.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160608/14653503925749049.jpg\\\" style=\\\"\\\" title=\\\"14653503925749049.jpg\\\"/></p><p><br/></p>', '1', '2', '0.01', '0', '0.01', '188', '7', '0', '0', '0', '2016-06-03 16:14:01');
INSERT INTO `goods` VALUES ('475', '1', ' 五档调节手持花洒头莲蓬头喷头', '', 'bos/柏奥斯', '广东深圳', '', '', '<p><img src=\\\"/pic/upload/image/20160603/14649419171409631.jpg\\\" style=\\\"\\\" title=\\\"14649419171409631.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649419181232343.jpg\\\" style=\\\"\\\" title=\\\"14649419181232343.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649419233174452.jpg\\\" style=\\\"\\\" title=\\\"14649419233174452.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649419375008896.jpg\\\" style=\\\"\\\" title=\\\"14649419375008896.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649419383769154.jpg\\\" style=\\\"\\\" title=\\\"14649419383769154.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649419464837635.jpg\\\" style=\\\"\\\" title=\\\"14649419464837635.jpg\\\"/></p><p><br/></p>', '1', '1', '0.01', '0', null, '189', '6', '0', '0', '0', '2016-06-03 16:19:20');
INSERT INTO `goods` VALUES ('476', '1', '智能恒温花洒套装淋浴室', '', 'DGPOSY', '上海', '', '', '<p><img src=\\\"/pic/upload/image/20160603/14649422341585291.jpg\\\" style=\\\"\\\" title=\\\"14649422341585291.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649422351029662.jpg\\\" style=\\\"\\\" title=\\\"14649422351029662.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649422444131914.jpg\\\" style=\\\"\\\" title=\\\"14649422444131914.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649422513162835.jpg\\\" style=\\\"\\\" title=\\\"14649422513162835.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649422545844143.jpg\\\" style=\\\"\\\" title=\\\"14649422545844143.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649422571158026.jpg\\\" style=\\\"\\\" title=\\\"14649422571158026.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649422679937327.jpg\\\" style=\\\"\\\" title=\\\"14649422679937327.jpg\\\"/></p><p><br/></p>', '1', '10', '0.01', '0', null, '190', '4', '0', '0', '0', '2016-06-03 16:24:51');
INSERT INTO `goods` VALUES ('477', '1', '创意厕所刷 马桶刷', '', ' 颐馨', '广东佛山', '', '', '<p><img src=\\\"/pic/upload/image/20160603/14649425529819851.jpg\\\" style=\\\"\\\" title=\\\"14649425529819851.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649425634717574.jpg\\\" style=\\\"\\\" title=\\\"14649425634717574.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649425658620985.jpg\\\" style=\\\"\\\" title=\\\"14649425658620985.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649425701096796.jpg\\\" style=\\\"\\\" title=\\\"14649425701096796.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649425761383042.jpg\\\" style=\\\"\\\" title=\\\"14649425761383042.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649425851169513.jpg\\\" style=\\\"\\\" title=\\\"14649425851169513.jpg\\\"/></p><p><br/></p>', '1', '1', '0.01', '0', null, '191', '9', '0', '0', '0', '2016-06-03 16:30:28');
INSERT INTO `goods` VALUES ('478', '1', ' 卫生间洗手台厕所洗漱台透光带灯卫浴镜子', '', '靓晶晶', '江苏苏州', '', '', '<p>						</p><p><img src=\\\"/pic/upload/image/20160603/14649428455570462.jpg\\\" style=\\\"\\\" title=\\\"14649428455570462.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649428568720823.jpg\\\" style=\\\"\\\" title=\\\"14649428568720823.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649428581538384.jpg\\\" style=\\\"\\\" title=\\\"14649428581538384.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649428621132466.jpg\\\" style=\\\"\\\" title=\\\"14649428621132466.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649428639112415.jpg\\\" style=\\\"\\\" title=\\\"14649428639112415.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649428652046167.jpg\\\" style=\\\"\\\" title=\\\"14649428652046167.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649428653471801.jpg\\\" style=\\\"\\\" title=\\\"14649428653471801.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649428685724088.jpg\\\" style=\\\"\\\" title=\\\"14649428685724088.jpg\\\"/></p><p><br/></p>', '1', '3', '0.02', '0', '0.01', '192', '8', '1', '0', '0', '2016-06-03 16:35:12');
INSERT INTO `goods` VALUES ('479', '1', '皂盒酒店皂碟', '', '正山', '上海', '', '', '<p><img src=\\\"/pic/upload/image/20160603/14649431381083881.jpg\\\" style=\\\"\\\" title=\\\"14649431381083881.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649431401012102.jpg\\\" style=\\\"\\\" title=\\\"14649431401012102.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649431401185693.jpg\\\" style=\\\"\\\" title=\\\"14649431401185693.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649431512809974.jpg\\\" style=\\\"\\\" title=\\\"14649431512809974.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649431555280865.jpg\\\" style=\\\"\\\" title=\\\"14649431555280865.jpg\\\"/></p><p><br/></p>', '1', '1', '0.01', '0', null, '193', '8', '0', '0', '0', '2016-06-03 16:39:48');
INSERT INTO `goods` VALUES ('480', '1', '毛巾架太空铝卫生间置物架折叠浴巾架', '', ' 马谛氏', '浙江温州', '', '', '<p>						</p><p><img src=\\\"/pic/upload/image/20160603/14649435127109281.jpg\\\" style=\\\"\\\" title=\\\"14649435127109281.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649435151329464.jpg\\\" style=\\\"\\\" title=\\\"14649435151329464.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649435193517415.jpg\\\" style=\\\"\\\" title=\\\"14649435193517415.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649435195873832.jpg\\\" style=\\\"\\\" title=\\\"14649435195873832.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649435221003676.jpg\\\" style=\\\"\\\" title=\\\"14649435221003676.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649435237139833.jpg\\\" style=\\\"\\\" title=\\\"14649435237139833.jpg\\\"/></p><p><br/></p>', '1', '1', '0.02', '0', '0.01', '194', '7', '1', '0', '0', '2016-06-03 16:46:38');
INSERT INTO `goods` VALUES ('481', '1', '不锈钢金属编织冷热进水软管', '', ' MOBOAM', '福建泉州', '', '', '<p><img src=\\\"/pic/upload/image/20160603/14649438011246021.jpg\\\" style=\\\"\\\" title=\\\"14649438011246021.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649438058055544.jpg\\\" style=\\\"\\\" title=\\\"14649438058055544.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649438128350743.jpg\\\" style=\\\"\\\" title=\\\"14649438128350743.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649438172862476.jpg\\\" style=\\\"\\\" title=\\\"14649438172862476.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649438199321545.jpg\\\" style=\\\"\\\" title=\\\"14649438199321545.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649438218479842.jpg\\\" style=\\\"\\\" title=\\\"14649438218479842.jpg\\\"/></p><p><br/></p>', '1', '1', '0.01', '0', null, '195', '6', '0', '0', '0', '2016-06-03 16:50:43');
INSERT INTO `goods` VALUES ('482', '1', '好方便不锈钢厨房置物架', '', 'HAOFANGBIAN', '广东东莞', '', '', '<p>						</p><p><img src=\\\"/pic/upload/image/20160603/14649440399476021.jpg\\\" style=\\\"\\\" title=\\\"14649440399476021.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649440399616742.jpg\\\" style=\\\"\\\" title=\\\"14649440399616742.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649440409567683.jpg\\\" style=\\\"\\\" title=\\\"14649440409567683.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649440421063534.jpg\\\" style=\\\"\\\" title=\\\"14649440421063534.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649440493157675.jpg\\\" style=\\\"\\\" title=\\\"14649440493157675.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649440538537937.jpg\\\" style=\\\"\\\" title=\\\"14649440538537937.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649440531435546.jpg\\\" style=\\\"\\\" title=\\\"14649440531435546.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649440609904198.jpg\\\" style=\\\"\\\" title=\\\"14649440609904198.jpg\\\"/></p><p><br/></p>', '1', '2', '0.02', '0', '0.01', '196', '8', '0', '0', '0', '2016-06-03 16:54:32');
INSERT INTO `goods` VALUES ('483', '1', '洗衣机地漏隔虫隔臭加厚自封地漏', '', '艺杰斯', '广东广州', '', '', '<p><img src=\\\"/pic/upload/image/20160603/14649443933108613.jpg\\\" style=\\\"\\\" title=\\\"14649443933108613.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649443947324001.jpg\\\" style=\\\"\\\" title=\\\"14649443947324001.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649444016915204.jpg\\\" style=\\\"\\\" title=\\\"14649444016915204.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649444058287922.jpg\\\" style=\\\"\\\" title=\\\"14649444058287922.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649444104910785.jpg\\\" style=\\\"\\\" title=\\\"14649444104910785.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649444201252566.jpg\\\" style=\\\"\\\" title=\\\"14649444201252566.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649444241136817.jpg\\\" style=\\\"\\\" title=\\\"14649444241136817.jpg\\\"/></p><p><br/></p>', '1', '1', '0.01', '0', null, '197', '6', '0', '0', '0', '2016-06-03 17:00:48');
INSERT INTO `goods` VALUES ('484', '1', '三角阀冷热水通用角阀全铜加厚角阀', '', 'JOMOO/九牧', '安徽', '', '', '<p>						</p><p><img src=\\\"/pic/upload/image/20160607/14652852681179802.jpg\\\" style=\\\"\\\" title=\\\"14652852681179802.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160607/14652852749634811.jpg\\\" style=\\\"\\\" title=\\\"14652852749634811.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160607/14652852758821514.jpg\\\" style=\\\"\\\" title=\\\"14652852758821514.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160607/14652852781254635.jpg\\\" style=\\\"\\\" title=\\\"14652852781254635.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160607/14652852801514286.jpg\\\" style=\\\"\\\" title=\\\"14652852801514286.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160607/14652852811288973.jpg\\\" style=\\\"\\\" title=\\\"14652852811288973.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160607/14652852822845697.jpg\\\" style=\\\"\\\" title=\\\"14652852822845697.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160607/14652852882376218.jpg\\\" style=\\\"\\\" title=\\\"14652852882376218.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160607/146528529089071410.jpg\\\" style=\\\"\\\" title=\\\"146528529089071410.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160607/146528529174221211.jpg\\\" style=\\\"\\\" title=\\\"146528529174221211.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160607/14652852953506659.jpg\\\" style=\\\"\\\" title=\\\"14652852953506659.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160607/146528529666729312.jpg\\\" style=\\\"\\\" title=\\\"146528529666729312.jpg\\\"/></p><p><br/></p>', '1', '1', '0.02', '0', '0.01', '198', '7', '1', '0', '0', '2016-06-03 17:08:17');
INSERT INTO `goods` VALUES ('485', '1', 'JOMOO九牧角阀八字阀全铜主体加厚冷热三角阀', '', 'JOMOO/九牧', '安徽', '', '', '<p><img src=\\\"/pic/upload/image/20160603/14649447681388033.jpg\\\" style=\\\"\\\" title=\\\"14649447681388033.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649447723826811.jpg\\\" style=\\\"\\\" title=\\\"14649447723826811.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649447767545195.jpg\\\" style=\\\"\\\" title=\\\"14649447767545195.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649447838825812.jpg\\\" style=\\\"\\\" title=\\\"14649447838825812.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649447841345866.jpg\\\" style=\\\"\\\" title=\\\"14649447841345866.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649447977981534.jpg\\\" style=\\\"\\\" title=\\\"14649447977981534.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649448054686168.jpg\\\" style=\\\"\\\" title=\\\"14649448054686168.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649448115036877.jpg\\\" style=\\\"\\\" title=\\\"14649448115036877.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160603/14649448152431299.jpg\\\" style=\\\"\\\" title=\\\"14649448152431299.jpg\\\"/></p><p><br/></p>', '1', '1', '0.01', '0', null, '198', '7', '0', '0', '1', '2016-06-03 17:08:18');
INSERT INTO `goods` VALUES ('486', '1', '厨房厨盆净水龙头', '', '摩恩', '上海', '', '', null, '1', '1', '0.02', '0', '0.01', '199', '6', '0', '0', '1', '2016-06-06 10:36:47');
INSERT INTO `goods` VALUES ('487', '1', '厨房厨盆净水龙头', '', '摩恩', '上海', '', '', '<p><img src=\\\"/pic/upload/image/20160606/14651805113779481.jpg\\\" style=\\\"\\\" title=\\\"14651805113779481.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160606/14651805164625053.jpg\\\" style=\\\"\\\" title=\\\"14651805164625053.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160606/14651805225165964.jpg\\\" style=\\\"\\\" title=\\\"14651805225165964.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160606/14651805311133025.jpg\\\" style=\\\"\\\" title=\\\"14651805311133025.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160606/14651805352249276.jpg\\\" style=\\\"\\\" title=\\\"14651805352249276.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160606/14651805495498602.jpg\\\" style=\\\"\\\" title=\\\"14651805495498602.jpg\\\"/></p><p><br/></p>', '1', '1', '0.02', '0', '0.01', '199', '6', '0', '0', '0', '2016-06-06 10:36:58');
INSERT INTO `goods` VALUES ('488', '1', ' 全铜冷热分体式坐式缸边式浴缸龙头', '', '汉派', '广东江门', '', '', '<p>						</p><p><img src=\\\"/pic/upload/image/20160606/14651809069295291.jpg\\\" style=\\\"\\\" title=\\\"14651809069295291.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160606/14651809069195032.jpg\\\" style=\\\"\\\" title=\\\"14651809069195032.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160606/14651809111166673.jpg\\\" style=\\\"\\\" title=\\\"14651809111166673.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160606/14651809132986404.jpg\\\" style=\\\"\\\" title=\\\"14651809132986404.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160606/14651809171170166.jpg\\\" style=\\\"\\\" title=\\\"14651809171170166.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160606/14651809191352485.jpg\\\" style=\\\"\\\" title=\\\"14651809191352485.jpg\\\"/></p><p><br/></p>', '1', '3', '0.02', '0', '0.01', '200', '5', '1', '0', '0', '2016-06-06 10:43:01');
INSERT INTO `goods` VALUES ('489', '1', '全铜冷热水四分洗衣机水龙头', '', 'JOMOO/九牧', '浙江杭州', '', '', '<p>						</p><p><br/></p><p><img src=\\\"/pic/upload/image/20160607/14652845597842972.jpg\\\" style=\\\"\\\" title=\\\"14652845597842972.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160607/14652845662639993.jpg\\\" style=\\\"\\\" title=\\\"14652845662639993.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160607/14652845721655004.jpg\\\" style=\\\"\\\" title=\\\"14652845721655004.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160607/14652845746462511.jpg\\\" style=\\\"\\\" title=\\\"14652845746462511.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160607/14652845801035515.jpg\\\" style=\\\"\\\" title=\\\"14652845801035515.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160607/14652845871170127.jpg\\\" style=\\\"\\\" title=\\\"14652845871170127.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160607/14652845881012966.jpg\\\" style=\\\"\\\" title=\\\"14652845881012966.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160607/14652845894020028.jpg\\\" style=\\\"\\\" title=\\\"14652845894020028.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160607/14652845991216039.jpg\\\" style=\\\"\\\" title=\\\"14652845991216039.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160607/146528459999334510.jpg\\\" style=\\\"\\\" title=\\\"146528459999334510.jpg\\\"/></p><p><br/></p>', '1', '1', '0.02', '0', '0.01', '201', '7', '0', '0', '0', '2016-06-06 10:49:07');
INSERT INTO `goods` VALUES ('490', '1', '淋浴龙头花洒套装', '', '摩恩', '上海', '', '', '<p><img src=\\\"/pic/upload/image/20160606/14651816788480273.jpg\\\" style=\\\"\\\" title=\\\"14651816788480273.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160606/14651816819848251.jpg\\\" style=\\\"\\\" title=\\\"14651816819848251.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160606/14651816884344914.jpg\\\" style=\\\"\\\" title=\\\"14651816884344914.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160606/14651816895133262.jpg\\\" style=\\\"\\\" title=\\\"14651816895133262.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160606/14651816992231626.jpg\\\" style=\\\"\\\" title=\\\"14651816992231626.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160606/14651817043230825.jpg\\\" style=\\\"\\\" title=\\\"14651817043230825.jpg\\\"/></p><p><br/></p>', '1', '3', '0.01', '0', '0.01', '202', '6', '0', '0', '0', '2016-06-06 10:55:38');
INSERT INTO `goods` VALUES ('491', '1', '厨房龙头冷热单把手水龙头', '', '摩恩', '上海', '', '', null, '1', '4', '0.01', '0', '0.01', '203', '6', '0', '0', '0', '2016-06-06 11:03:39');
INSERT INTO `goods` VALUES ('492', '1', '厨房龙头冷热单把手水龙头', '', '摩恩', '上海', '', '', '<p><img src=\\\"/pic/upload/image/20160606/14651821536746953.jpg\\\" style=\\\"\\\" title=\\\"14651821536746953.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160606/14651821566459071.jpg\\\" style=\\\"\\\" title=\\\"14651821566459071.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160606/14651821646812362.jpg\\\" style=\\\"\\\" title=\\\"14651821646812362.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160606/14651821691235315.jpg\\\" style=\\\"\\\" title=\\\"14651821691235315.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160606/14651821772768236.jpg\\\" style=\\\"\\\" title=\\\"14651821772768236.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160606/14651821812815994.jpg\\\" style=\\\"\\\" title=\\\"14651821812815994.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160606/14651821883838868.jpg\\\" style=\\\"\\\" title=\\\"14651821883838868.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160606/14651821998116227.jpg\\\" style=\\\"\\\" title=\\\"14651821998116227.jpg\\\"/></p><p><br/></p>', '1', '4', '0.01', '0', '0.01', '203', '6', '0', '0', '1', '2016-06-06 11:03:51');
INSERT INTO `goods` VALUES ('493', '1', '全铜双孔面盆龙头 可旋转冷热水龙头', '', ' JCS/居臣仕', '浙江温州', '', '', '<p>						</p><p><img src=\\\"/pic/upload/image/20160606/14651825265569171.jpg\\\" style=\\\"\\\" title=\\\"14651825265569171.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160606/14651825281184192.jpg\\\" style=\\\"\\\" title=\\\"14651825281184192.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160606/14651825306910904.jpg\\\" style=\\\"\\\" title=\\\"14651825306910904.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160606/14651825331062493.jpg\\\" style=\\\"\\\" title=\\\"14651825331062493.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160606/14651825366943176.jpg\\\" style=\\\"\\\" title=\\\"14651825366943176.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160606/14651825389216118.jpg\\\" style=\\\"\\\" title=\\\"14651825389216118.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160606/14651825421851657.jpg\\\" style=\\\"\\\" title=\\\"14651825421851657.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160606/14651825452157185.jpg\\\" style=\\\"\\\" title=\\\"14651825452157185.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160606/14651825451163329.jpg\\\" style=\\\"\\\" title=\\\"14651825451163329.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160606/146518254871170211.jpg\\\" style=\\\"\\\" title=\\\"146518254871170211.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160606/146518254815362310.jpg\\\" style=\\\"\\\" title=\\\"146518254815362310.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160606/146518255311778212.jpg\\\" style=\\\"\\\" title=\\\"146518255311778212.jpg\\\"/></p><p><br/></p>', '1', '2', '0.02', '0', '0.01', '204', '9', '1', '0', '0', '2016-06-06 11:09:53');
INSERT INTO `goods` VALUES ('494', '1', '箭牌蹲便器', '', ' ARROW/箭牌', '广东佛山', '', '', '<p><img src=\\\"/pic/upload/image/20160606/14651829859260862.jpg\\\" style=\\\"\\\" title=\\\"14651829859260862.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160606/14651829871173903.jpg\\\" style=\\\"\\\" title=\\\"14651829871173903.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160606/14651829945946994.jpg\\\" style=\\\"\\\" title=\\\"14651829945946994.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160606/14651829988689401.jpg\\\" style=\\\"\\\" title=\\\"14651829988689401.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160606/14651830144552767.jpg\\\" style=\\\"\\\" title=\\\"14651830144552767.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160606/14651830318313306.jpg\\\" style=\\\"\\\" title=\\\"14651830318313306.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160606/14651830321976888.jpg\\\" style=\\\"\\\" title=\\\"14651830321976888.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160606/14651830508876595.jpg\\\" style=\\\"\\\" title=\\\"14651830508876595.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160606/14651830567435899.jpg\\\" style=\\\"\\\" title=\\\"14651830567435899.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160606/146518307382375710.jpg\\\" style=\\\"\\\" title=\\\"146518307382375710.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160606/146518308035582911.jpg\\\" style=\\\"\\\" title=\\\"146518308035582911.jpg\\\"/></p><p><br/></p>', '1', '7', '0.02', '0', '0.01', '205', '8', '0', '0', '0', '2016-06-06 11:18:47');
INSERT INTO `goods` VALUES ('495', '1', 'V型PP板亲子马桶盖', '', 'Panasonic/松下', '浙江杭州', '', '', '<p><img src=\\\"/pic/upload/image/20160607/14652839606379033.jpg\\\" style=\\\"\\\" title=\\\"14652839606379033.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160607/14652839685675462.jpg\\\" style=\\\"\\\" title=\\\"14652839685675462.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160607/14652839706394095.jpg\\\" style=\\\"\\\" title=\\\"14652839706394095.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160607/14652839709597801.jpg\\\" style=\\\"\\\" title=\\\"14652839709597801.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160607/14652839778164414.jpg\\\" style=\\\"\\\" title=\\\"14652839778164414.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160607/14652839772050896.jpg\\\" style=\\\"\\\" title=\\\"14652839772050896.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160607/14652839881130789.jpg\\\" style=\\\"\\\" title=\\\"14652839881130789.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160607/146528399413856210.jpg\\\" style=\\\"\\\" title=\\\"146528399413856210.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160607/14652839957633838.jpg\\\" style=\\\"\\\" title=\\\"14652839957633838.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160607/14652840003309147.jpg\\\" style=\\\"\\\" title=\\\"14652840003309147.jpg\\\"/></p><p><br/></p>', '1', '3', '0.02', '0', '0.01', '206', '6', '0', '0', '0', '2016-06-06 11:32:21');
INSERT INTO `goods` VALUES ('496', '1', '即热坐便器遥控全自动冲水烘干座便器电动一体智能马桶', '', '德希顿', '广东潮州', '', '', '<p>						</p><p><img src=\\\"/pic/upload/image/20160606/14651842805815313.jpg\\\" style=\\\"\\\" title=\\\"14651842805815313.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160606/14651842836676382.jpg\\\" style=\\\"\\\" title=\\\"14651842836676382.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160606/14651842905295064.jpg\\\" style=\\\"\\\" title=\\\"14651842905295064.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160606/14651842945555835.jpg\\\" style=\\\"\\\" title=\\\"14651842945555835.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160606/14651843018223376.jpg\\\" style=\\\"\\\" title=\\\"14651843018223376.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160606/14651843041079581.jpg\\\" style=\\\"\\\" title=\\\"14651843041079581.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160606/14651843066642818.jpg\\\" style=\\\"\\\" title=\\\"14651843066642818.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160606/14651843141324087.jpg\\\" style=\\\"\\\" title=\\\"14651843141324087.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160606/146518432139739810.jpg\\\" style=\\\"\\\" title=\\\"146518432139739810.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160606/14651843241624889.jpg\\\" style=\\\"\\\" title=\\\"14651843241624889.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160606/146518432979858311.jpg\\\" style=\\\"\\\" title=\\\"146518432979858311.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160606/146518433188443212.jpg\\\" style=\\\"\\\" title=\\\"146518433188443212.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160606/146518434138823213.jpg\\\" style=\\\"\\\" title=\\\"146518434138823213.jpg\\\"/></p><p><br/></p>', '1', '8', '0.02', '0', '0.01', '207', '8', '1', '0', '0', '2016-06-06 11:39:52');
INSERT INTO `goods` VALUES ('497', '1', '智能马桶盖日本电子坐便盖加热座便圈全自动冲洗器洁身器', '', 'Panasonic/松下', '浙江杭州', '', '', '<p><img src=\\\"/pic/upload/image/20160606/14651847719575431.jpg\\\" style=\\\"\\\" title=\\\"14651847719575431.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160606/14651847765870394.jpg\\\" style=\\\"\\\" title=\\\"14651847765870394.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160606/14651847837207823.jpg\\\" style=\\\"\\\" title=\\\"14651847837207823.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160606/14651847949989396.jpg\\\" style=\\\"\\\" title=\\\"14651847949989396.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160606/14651848001298182.jpg\\\" style=\\\"\\\" title=\\\"14651848001298182.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160606/14651848051276327.jpg\\\" style=\\\"\\\" title=\\\"14651848051276327.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160606/14651848093323778.jpg\\\" style=\\\"\\\" title=\\\"14651848093323778.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160606/14651848251096149.jpg\\\" style=\\\"\\\" title=\\\"14651848251096149.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160606/146518483612177110.jpg\\\" style=\\\"\\\" title=\\\"146518483612177110.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160606/146518484812748512.jpg\\\" style=\\\"\\\" title=\\\"146518484812748512.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160606/146518487244322711.jpg\\\" style=\\\"\\\" title=\\\"146518487244322711.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160606/14651848927198355.jpg\\\" style=\\\"\\\" title=\\\"14651848927198355.jpg\\\"/></p><p><br/></p>', '1', '6', '0.02', '0', '0.01', '208', '5', '0', '0', '0', '2016-06-06 11:49:52');
INSERT INTO `goods` VALUES ('498', '1', ' 现代独立式浴室柜组合', '', 'donba/东霸', '广东佛山', '', '', '<p>						</p><p><br/></p><p><img src=\\\"/pic/upload/image/20160607/14652820211185053.jpg\\\" style=\\\"\\\" title=\\\"14652820211185053.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160607/14652820345876424.jpg\\\" style=\\\"\\\" title=\\\"14652820345876424.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160607/14652820358580532.jpg\\\" style=\\\"\\\" title=\\\"14652820358580532.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160607/14652820387757335.jpg\\\" style=\\\"\\\" title=\\\"14652820387757335.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160607/14652820421141116.jpg\\\" style=\\\"\\\" title=\\\"14652820421141116.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160607/14652820432128351.jpg\\\" style=\\\"\\\" title=\\\"14652820432128351.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160607/14652820473942148.jpg\\\" style=\\\"\\\" title=\\\"14652820473942148.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160607/14652820538410139.jpg\\\" style=\\\"\\\" title=\\\"14652820538410139.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160607/146528207613437910.jpg\\\" style=\\\"\\\" title=\\\"146528207613437910.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160607/146528209795156112.jpg\\\" style=\\\"\\\" title=\\\"146528209795156112.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160607/146528210084578913.jpg\\\" style=\\\"\\\" title=\\\"146528210084578913.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160607/146528210995384215.jpg\\\" style=\\\"\\\" title=\\\"146528210995384215.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160607/146528211860425216.jpg\\\" style=\\\"\\\" title=\\\"146528211860425216.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160607/146528215250601011.jpg\\\" style=\\\"\\\" title=\\\"146528215250601011.jpg\\\"/></p><p><br/></p>', '1', '30', '0.02', '0', '0.01', '209', '4', '0', '0', '0', '2016-06-06 11:55:00');
INSERT INTO `goods` VALUES ('499', '1', ' 浴室柜组合简约现代卫浴洗手洗脸盆柜组合镜柜浴室柜', '', ' lixiangjia', '浙江杭州', '', '', '<p>						</p><p><img src=\\\"/pic/upload/image/20160615/14659559581302873.jpg\\\" style=\\\"\\\" title=\\\"14659559581302873.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160615/14659559607484512.jpg\\\" style=\\\"\\\" title=\\\"14659559607484512.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160615/14659559624302741.jpg\\\" style=\\\"\\\" title=\\\"14659559624302741.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160615/14659559683706324.jpg\\\" style=\\\"\\\" title=\\\"14659559683706324.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160615/14659559791215515.jpg\\\" style=\\\"\\\" title=\\\"14659559791215515.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160615/14659559842951547.jpg\\\" style=\\\"\\\" title=\\\"14659559842951547.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160615/14659559905480959.jpg\\\" style=\\\"\\\" title=\\\"14659559905480959.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160615/146595599340944710.jpg\\\" style=\\\"\\\" title=\\\"146595599340944710.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160615/146595599856324211.jpg\\\" style=\\\"\\\" title=\\\"146595599856324211.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160615/14659560065086788.jpg\\\" style=\\\"\\\" title=\\\"14659560065086788.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160615/14659560101108456.jpg\\\" style=\\\"\\\" title=\\\"14659560101108456.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160615/146595601611569912.jpg\\\" style=\\\"\\\" title=\\\"146595601611569912.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160615/146595601727157314.jpg\\\" style=\\\"\\\" title=\\\"146595601727157314.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160615/146595602518804816.jpg\\\" style=\\\"\\\" title=\\\"146595602518804816.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160615/146595603210615517.jpg\\\" style=\\\"\\\" title=\\\"146595603210615517.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160615/146595603327484313.jpg\\\" style=\\\"\\\" title=\\\"146595603327484313.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160615/146595603645153215.jpg\\\" style=\\\"\\\" title=\\\"146595603645153215.jpg\\\"/></p><p><br/></p>', '1', '40', '0.02', '0', '0.01', '210', '5', '1', '0', '0', '2016-06-06 12:02:25');
INSERT INTO `goods` VALUES ('500', '1', ' 现代简约悬挂式洗簌盆防潮柜1', 'S232', ' Queenswood/昆斯伍德', '福建泉州', '', '', '<p>						</p><p><br/></p><p><img src=\\\"/pic/upload/image/20160615/14659570271234491.jpg\\\" style=\\\"\\\" title=\\\"14659570271234491.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160615/14659570302672704.jpg\\\" style=\\\"\\\" title=\\\"14659570302672704.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160615/14659570336879922.jpg\\\" style=\\\"\\\" title=\\\"14659570336879922.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160615/14659570434817405.jpg\\\" style=\\\"\\\" title=\\\"14659570434817405.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160615/14659570534963286.jpg\\\" style=\\\"\\\" title=\\\"14659570534963286.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160615/14659570654617317.jpg\\\" style=\\\"\\\" title=\\\"14659570654617317.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160615/14659570691379598.jpg\\\" style=\\\"\\\" title=\\\"14659570691379598.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160615/14659570829691189.jpg\\\" style=\\\"\\\" title=\\\"14659570829691189.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160615/146595709816124011.jpg\\\" style=\\\"\\\" title=\\\"146595709816124011.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160615/146595710613331210.jpg\\\" style=\\\"\\\" title=\\\"146595710613331210.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160615/146595711841142612.jpg\\\" style=\\\"\\\" title=\\\"146595711841142612.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160615/14659571271295723.jpg\\\" style=\\\"\\\" title=\\\"14659571271295723.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160615/146595712713667713.jpg\\\" style=\\\"\\\" title=\\\"146595712713667713.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160615/146595713185788115.jpg\\\" style=\\\"\\\" title=\\\"146595713185788115.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160615/146595713912557914.jpg\\\" style=\\\"\\\" title=\\\"146595713912557914.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160615/146595714279965916.jpg\\\" style=\\\"\\\" title=\\\"146595714279965916.jpg\\\"/></p><p><br/></p>', '1', '30', '0.02', '0', '0.01', '211', '5', '0', '0', '0', '2016-06-06 13:14:42');
INSERT INTO `goods` VALUES ('501', '8', '白色云灰色天然石材文化石白砖电视背景墙别墅花园玄关外墙砖', '', '苏菲', '广东中山', '', '', '<p><img src=\\\"/pic/upload/image/20160621/14664987705241701.jpg\\\" style=\\\"\\\" title=\\\"14664987705241701.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160621/14664987731296542.jpg\\\" style=\\\"\\\" title=\\\"14664987731296542.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160621/14664987836715973.jpg\\\" style=\\\"\\\" title=\\\"14664987836715973.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160621/14664987899713136.jpg\\\" style=\\\"\\\" title=\\\"14664987899713136.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160621/14664987911391044.jpg\\\" style=\\\"\\\" title=\\\"14664987911391044.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160621/14664987941192975.jpg\\\" style=\\\"\\\" title=\\\"14664987941192975.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160621/14664988085045478.jpg\\\" style=\\\"\\\" title=\\\"14664988085045478.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160621/14664988136228427.jpg\\\" style=\\\"\\\" title=\\\"14664988136228427.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160621/146649881534429710.jpg\\\" style=\\\"\\\" title=\\\"146649881534429710.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160621/14664988161379259.jpg\\\" style=\\\"\\\" title=\\\"14664988161379259.jpg\\\"/></p><p><br/></p>', '1', '2', '0.02', '0', '0.01', '274', '5', '1', '0', '0', '2016-06-21 16:48:31');
INSERT INTO `goods` VALUES ('502', '8', '天然石材 黑色青色文化石 电视背景墙玄关花园外墙砖文化砖', '', '苏菲', '广州', '', '', null, '1', '5', '0.02', '0', '0.01', '271', '6', '0', '0', '0', '2016-06-21 16:52:51');
INSERT INTO `goods` VALUES ('503', '8', '天然石材 黑色青色文化石 电视背景墙玄关花园外墙砖文化砖', '', '苏菲', '广州', '', '', '<p><img src=\\\"/pic/upload/image/20160621/14664991011529341.jpg\\\" style=\\\"\\\" title=\\\"14664991011529341.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160621/14664991062371053.jpg\\\" style=\\\"\\\" title=\\\"14664991062371053.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160621/14664991151217155.jpg\\\" style=\\\"\\\" title=\\\"14664991151217155.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160621/14664991205088934.jpg\\\" style=\\\"\\\" title=\\\"14664991205088934.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160621/14664991216676382.jpg\\\" style=\\\"\\\" title=\\\"14664991216676382.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160621/14664991416630336.jpg\\\" style=\\\"\\\" title=\\\"14664991416630336.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160621/14664991435295067.jpg\\\" style=\\\"\\\" title=\\\"14664991435295067.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160621/14664991518272428.jpg\\\" style=\\\"\\\" title=\\\"14664991518272428.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160621/14664991538223379.jpg\\\" style=\\\"\\\" title=\\\"14664991538223379.jpg\\\"/></p><p><br/></p>', '1', '5', '0.02', '0', '0.01', '271', '6', '0', '0', '0', '2016-06-21 16:53:01');
INSERT INTO `goods` VALUES ('504', '8', '木纹砖 3D高清拼花木纹瓷砖 地毯砖厨房阳台卫生间瓷砖 ', '', '苏菲', '广州', '', '', '<p><img src=\\\"/pic/upload/image/20160621/14664993553194671.jpg\\\" style=\\\"\\\" title=\\\"14664993553194671.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160621/14664993579180404.jpg\\\" style=\\\"\\\" title=\\\"14664993579180404.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160621/14664993616642812.jpg\\\" style=\\\"\\\" title=\\\"14664993616642812.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160621/14664993614205925.jpg\\\" style=\\\"\\\" title=\\\"14664993614205925.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160621/14664993631242843.jpg\\\" style=\\\"\\\" title=\\\"14664993631242843.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160621/14664993683973986.jpg\\\" style=\\\"\\\" title=\\\"14664993683973986.jpg\\\"/></p><p><br/></p>', '1', '2', '0.02', '0', '0.01', '269', '3', '0', '0', '0', '2016-06-21 16:56:30');
INSERT INTO `goods` VALUES ('505', '8', '灰木纹凹凸文化石 纯天然大理石 高端电视背景墙砖沙发玄关背景墙', '', '苏菲', '广东佛山', '', '', null, '1', '2', '0.02', '0', '0.01', '272', '6', '0', '0', '0', '2016-06-21 17:00:50');
INSERT INTO `goods` VALUES ('506', '8', '灰木纹凹凸文化石 纯天然大理石 高端电视背景墙砖沙发玄关背景墙', '', '苏菲', '广东佛山', '', '', '<p><img src=\\\"/pic/upload/image/20160621/14664995408844323.jpg\\\" style=\\\"\\\" title=\\\"14664995408844323.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160621/14664995471010381.jpg\\\" style=\\\"\\\" title=\\\"14664995471010381.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160621/14664995668982455.jpg\\\" style=\\\"\\\" title=\\\"14664995668982455.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160621/14664995811313414.jpg\\\" style=\\\"\\\" title=\\\"14664995811313414.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160621/14664995811332266.jpg\\\" style=\\\"\\\" title=\\\"14664995811332266.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160621/14664996352263902.jpg\\\" style=\\\"\\\" title=\\\"14664996352263902.jpg\\\"/></p><p><br/></p>', '1', '2', '0.02', '0', '0.01', '272', '6', '0', '0', '0', '2016-06-21 17:01:03');
INSERT INTO `goods` VALUES ('507', '8', '天然马赛克大理石文化石卫生间厨房卧室会所浴室餐厅墙砖地砖', '', '苏菲', '广东佛山', '', '', '<p><img src=\\\"/pic/upload/image/20160621/14664998481071661.jpg\\\" style=\\\"\\\" title=\\\"14664998481071661.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160621/14664998551216552.jpg\\\" style=\\\"\\\" title=\\\"14664998551216552.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160621/14664998551180363.jpg\\\" style=\\\"\\\" title=\\\"14664998551180363.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160621/14664998577944525.jpg\\\" style=\\\"\\\" title=\\\"14664998577944525.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160621/14664998614408606.jpg\\\" style=\\\"\\\" title=\\\"14664998614408606.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160621/14664998678485004.jpg\\\" style=\\\"\\\" title=\\\"14664998678485004.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160621/14664998731933418.jpg\\\" style=\\\"\\\" title=\\\"14664998731933418.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160621/14664998828146779.jpg\\\" style=\\\"\\\" title=\\\"14664998828146779.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160621/14664998856036497.jpg\\\" style=\\\"\\\" title=\\\"14664998856036497.jpg\\\"/></p><p><br/></p>', '1', '6', '0.02', '0', '0.01', '272', '8', '0', '0', '0', '2016-06-21 17:05:07');
INSERT INTO `goods` VALUES ('508', '8', '地中海砖 田园砖 八角砖 花片 仿古砖八角砖大花片拼花砖 ', '', '苏菲', '广东中山', '', '', '<p><img src=\\\"/pic/upload/image/20160621/14665000623010073.jpg\\\" style=\\\"\\\" title=\\\"14665000623010073.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160621/14665000637949692.jpg\\\" style=\\\"\\\" title=\\\"14665000637949692.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160621/14665000669472581.jpg\\\" style=\\\"\\\" title=\\\"14665000669472581.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160621/14665000686995674.jpg\\\" style=\\\"\\\" title=\\\"14665000686995674.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160621/14665000771460925.jpg\\\" style=\\\"\\\" title=\\\"14665000771460925.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160621/14665000801274777.jpg\\\" style=\\\"\\\" title=\\\"14665000801274777.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160621/14665000826654006.jpg\\\" style=\\\"\\\" title=\\\"14665000826654006.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160621/14665000849360708.jpg\\\" style=\\\"\\\" title=\\\"14665000849360708.jpg\\\"/></p><p><br/></p>', '1', '8', '0.02', '0', '0.01', '273', '9', '0', '0', '0', '2016-06-21 17:09:22');
INSERT INTO `goods` VALUES ('509', '8', '凹凸3D高清喷墨文化石瓷砖 别墅小区楼房花园露台外墙砖砖蘑菇石', '', '苏菲', '广东佛山', '', '', '<p><img src=\\\"/pic/upload/image/20160621/14665003426259402.jpg\\\" style=\\\"\\\" title=\\\"14665003426259402.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160621/14665003436457771.jpg\\\" style=\\\"\\\" title=\\\"14665003436457771.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160621/14665003476237884.jpg\\\" style=\\\"\\\" title=\\\"14665003476237884.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160621/14665003517899345.jpg\\\" style=\\\"\\\" title=\\\"14665003517899345.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160621/14665003549694196.jpg\\\" style=\\\"\\\" title=\\\"14665003549694196.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160621/14665003583848767.jpg\\\" style=\\\"\\\" title=\\\"14665003583848767.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160621/14665003592838373.jpg\\\" style=\\\"\\\" title=\\\"14665003592838373.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160621/14665003616578699.jpg\\\" style=\\\"\\\" title=\\\"14665003616578699.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160621/14665003627362738.jpg\\\" style=\\\"\\\" title=\\\"14665003627362738.jpg\\\"/></p><p><br/></p>', '1', '7', '0.02', '0', '0.01', '271', '5', '1', '0', '0', '2016-06-21 17:13:40');
INSERT INTO `goods` VALUES ('510', '8', '凹凸3D高清喷墨文化石瓷砖 别墅小区楼房花园露台外墙砖砖蘑菇石', '', '苏菲', '广东佛山', '', '', '<p><img src=\\\"/pic/upload/image/20160621/14665003426259402.jpg\\\" style=\\\"\\\" title=\\\"14665003426259402.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160621/14665003436457771.jpg\\\" style=\\\"\\\" title=\\\"14665003436457771.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160621/14665003476237884.jpg\\\" style=\\\"\\\" title=\\\"14665003476237884.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160621/14665003517899345.jpg\\\" style=\\\"\\\" title=\\\"14665003517899345.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160621/14665003549694196.jpg\\\" style=\\\"\\\" title=\\\"14665003549694196.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160621/14665003583848767.jpg\\\" style=\\\"\\\" title=\\\"14665003583848767.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160621/14665003592838373.jpg\\\" style=\\\"\\\" title=\\\"14665003592838373.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160621/14665003616578699.jpg\\\" style=\\\"\\\" title=\\\"14665003616578699.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160621/14665003627362738.jpg\\\" style=\\\"\\\" title=\\\"14665003627362738.jpg\\\"/></p><p><br/></p>', '1', '7', '0.02', '0', '0.01', '271', '5', '1', '0', '0', '2016-06-21 17:13:48');
INSERT INTO `goods` VALUES ('511', '9', '淋浴花洒套装淋雨带升降杆全铜淋浴龙头冷热水豪华套装淋浴器', '', '惠达', '浙江杭州', '', '', null, '1', '8', '0.02', '0', '0.01', '190', '9', '0', '0', '1', '2016-06-22 13:29:58');
INSERT INTO `goods` VALUES ('512', '9', '淋浴花洒套装淋雨带升降杆全铜淋浴龙头冷热水豪华套装淋浴器', '', '惠达', '浙江杭州', '', '', '<p><img src=\\\"/pic/upload/image/20160622/14665733131116151.jpg\\\" style=\\\"\\\" title=\\\"14665733131116151.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665733221371764.jpg\\\" style=\\\"\\\" title=\\\"14665733221371764.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665733252386542.jpg\\\" style=\\\"\\\" title=\\\"14665733252386542.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665733286743945.jpg\\\" style=\\\"\\\" title=\\\"14665733286743945.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665733299510023.jpg\\\" style=\\\"\\\" title=\\\"14665733299510023.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665733391084658.jpg\\\" style=\\\"\\\" title=\\\"14665733391084658.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665733407651056.jpg\\\" style=\\\"\\\" title=\\\"14665733407651056.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665733451334327.jpg\\\" style=\\\"\\\" title=\\\"14665733451334327.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665733481287689.jpg\\\" style=\\\"\\\" title=\\\"14665733481287689.jpg\\\"/></p><p><br/></p>', '1', '8', '0.02', '0', '0.01', '190', '9', '0', '0', '1', '2016-06-22 13:30:09');
INSERT INTO `goods` VALUES ('513', '9', '爆款合金单孔龙头冷热面盆龙头脸盆龙头洗手盆龙头台盆水龙头', '', '惠达', '浙江杭州', '', '', '<p><img src=\\\"/pic/upload/image/20160622/14665735851003242.jpg\\\" style=\\\"\\\" title=\\\"14665735851003242.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665735872306501.jpg\\\" style=\\\"\\\" title=\\\"14665735872306501.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665735967587364.jpg\\\" style=\\\"\\\" title=\\\"14665735967587364.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665735981405333.jpg\\\" style=\\\"\\\" title=\\\"14665735981405333.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665736032442917.jpg\\\" style=\\\"\\\" title=\\\"14665736032442917.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665736041424355.jpg\\\" style=\\\"\\\" title=\\\"14665736041424355.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665736062463996.jpg\\\" style=\\\"\\\" title=\\\"14665736062463996.jpg\\\"/></p><p><br/></p>', '1', '5', '0.02', '0', '0.01', '204', '5', '1', '0', '0', '2016-06-22 13:34:05');
INSERT INTO `goods` VALUES ('514', '9', '水槽龙头 冷热水龙头 混水龙头 厨房水龙头', '', '惠达', '浙江杭州', '', '', '<p><img src=\\\"/pic/upload/image/20160622/14665738481036721.jpg\\\" style=\\\"\\\" title=\\\"14665738481036721.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665738537154894.jpg\\\" style=\\\"\\\" title=\\\"14665738537154894.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665738596761155.jpg\\\" style=\\\"\\\" title=\\\"14665738596761155.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665738663158536.jpg\\\" style=\\\"\\\" title=\\\"14665738663158536.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665738818762993.jpg\\\" style=\\\"\\\" title=\\\"14665738818762993.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665738811147447.jpg\\\" style=\\\"\\\" title=\\\"14665738811147447.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665738818707912.jpg\\\" style=\\\"\\\" title=\\\"14665738818707912.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665738901336358.jpg\\\" style=\\\"\\\" title=\\\"14665738901336358.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665738931076529.jpg\\\" style=\\\"\\\" title=\\\"14665738931076529.jpg\\\"/></p><p><br/></p>', '1', '6', '0.02', '0', '0.01', '203', '9', '1', '0', '0', '2016-06-22 13:38:52');
INSERT INTO `goods` VALUES ('515', '9', '地漏厂家 批发不锈钢防臭地漏 镜面抛光技术 加厚3厘 保用50年', '', '惠达', '浙江杭州', '', '', '<p><img src=\\\"/pic/upload/image/20160622/14665740791774631.jpg\\\" style=\\\"\\\" title=\\\"14665740791774631.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665740821099034.jpg\\\" style=\\\"\\\" title=\\\"14665740821099034.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665740871221842.jpg\\\" style=\\\"\\\" title=\\\"14665740871221842.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665741015766255.jpg\\\" style=\\\"\\\" title=\\\"14665741015766255.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665741021986346.jpg\\\" style=\\\"\\\" title=\\\"14665741021986346.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665741056434973.jpg\\\" style=\\\"\\\" title=\\\"14665741056434973.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665741139264747.jpg\\\" style=\\\"\\\" title=\\\"14665741139264747.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665741148787088.jpg\\\" style=\\\"\\\" title=\\\"14665741148787088.jpg\\\"/></p><p><br/></p>', '1', '6', '0.02', '0', '0.01', '197', '5', '1', '0', '0', '2016-06-22 13:43:39');
INSERT INTO `goods` VALUES ('516', '9', '厂家直供三角阀 超厚全铜角阀 200克 工程推荐', '', '惠达', '浙江杭州', '', '', '<p><img src=\\\"/pic/upload/image/20160622/14665743839745831.jpg\\\" style=\\\"\\\" title=\\\"14665743839745831.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665743858809462.jpg\\\" style=\\\"\\\" title=\\\"14665743858809462.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665743906296413.jpg\\\" style=\\\"\\\" title=\\\"14665743906296413.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665744021730736.jpg\\\" style=\\\"\\\" title=\\\"14665744021730736.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665744032116305.jpg\\\" style=\\\"\\\" title=\\\"14665744032116305.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665744067053768.jpg\\\" style=\\\"\\\" title=\\\"14665744067053768.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665744101273917.jpg\\\" style=\\\"\\\" title=\\\"14665744101273917.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665744345343254.jpg\\\" style=\\\"\\\" title=\\\"14665744345343254.jpg\\\"/></p><p><br/></p>', '1', '6', '0.01', '0', '0.01', '198', '5', '1', '0', '0', '2016-06-22 13:48:15');
INSERT INTO `goods` VALUES ('517', '9', '304钢丝软管 单孔龙头进水管 尖头冷热进水管 编织软管', '', '惠达', '浙江杭州', '', '', '<p><img src=\\\"/pic/upload/image/20160622/146657458145613610.jpg\\\" style=\\\"\\\" title=\\\"146657458145613610.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/146657458423577111.jpg\\\" style=\\\"\\\" title=\\\"146657458423577111.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/146657458611581113.jpg\\\" style=\\\"\\\" title=\\\"146657458611581113.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/146657458716554312.jpg\\\" style=\\\"\\\" title=\\\"146657458716554312.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665745951303909.jpg\\\" style=\\\"\\\" title=\\\"14665745951303909.jpg\\\"/></p><p><br/></p>', '1', '3', '0.02', '0', '0.01', '195', '5', '1', '0', '0', '2016-06-22 13:50:16');
INSERT INTO `goods` VALUES ('518', '10', '林氏木业现代榻榻米布艺床可拆洗布床1.5米简约软床1.8双人床R189', '', '林氏木业', '广东佛山', '', '', '<p><img src=\\\"/pic/upload/image/20160622/14665758822273361.jpg\\\" style=\\\"\\\" title=\\\"14665758822273361.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665758831247662.jpg\\\" style=\\\"\\\" title=\\\"14665758831247662.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665758844601813.jpg\\\" style=\\\"\\\" title=\\\"14665758844601813.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665758861210955.jpg\\\" style=\\\"\\\" title=\\\"14665758861210955.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665758986907037.jpg\\\" style=\\\"\\\" title=\\\"14665758986907037.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665758996891976.jpg\\\" style=\\\"\\\" title=\\\"14665758996891976.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665759053012654.jpg\\\" style=\\\"\\\" title=\\\"14665759053012654.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665759081052649.jpg\\\" style=\\\"\\\" title=\\\"14665759081052649.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665759159331018.jpg\\\" style=\\\"\\\" title=\\\"14665759159331018.jpg\\\"/></p><p><br/></p>', '1', '30', '0.01', '0', '0.01', '56', '5', '1', '0', '0', '2016-06-22 14:12:19');
INSERT INTO `goods` VALUES ('519', '10', '林氏木业成套家具钢化玻璃小户型客厅烤漆电视柜+茶几组合Y-TV219', '', '林氏', '广东佛山', '', '', '<p><img src=\\\"/pic/upload/image/20160622/14665761198123101.jpg\\\" style=\\\"\\\" title=\\\"14665761198123101.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665761235699122.jpg\\\" style=\\\"\\\" title=\\\"14665761235699122.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665761251365013.jpg\\\" style=\\\"\\\" title=\\\"14665761251365013.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665761362099526.jpg\\\" style=\\\"\\\" title=\\\"14665761362099526.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665761367724204.jpg\\\" style=\\\"\\\" title=\\\"14665761367724204.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665761401130275.jpg\\\" style=\\\"\\\" title=\\\"14665761401130275.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665761431207857.jpg\\\" style=\\\"\\\" title=\\\"14665761431207857.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665761477570589.jpg\\\" style=\\\"\\\" title=\\\"14665761477570589.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665761551803468.jpg\\\" style=\\\"\\\" title=\\\"14665761551803468.jpg\\\"/></p><p><br/></p>', '1', '10', '0.02', '0', '0.01', '92', '6', '1', '0', '0', '2016-06-22 14:16:13');
INSERT INTO `goods` VALUES ('520', '10', '林氏木业简约现代小户型餐桌4人钢化玻璃饭桌圆角餐台家具Y-CT203', '', '林氏', '广东佛山', '', '', '<p><img src=\\\"/pic/upload/image/20160622/14665763828775042.jpg\\\" style=\\\"\\\" title=\\\"14665763828775042.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665763839693763.jpg\\\" style=\\\"\\\" title=\\\"14665763839693763.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665763849077121.jpg\\\" style=\\\"\\\" title=\\\"14665763849077121.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665763931271895.jpg\\\" style=\\\"\\\" title=\\\"14665763931271895.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665763932212266.jpg\\\" style=\\\"\\\" title=\\\"14665763932212266.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665763977871377.jpg\\\" style=\\\"\\\" title=\\\"14665763977871377.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665763996866154.jpg\\\" style=\\\"\\\" title=\\\"14665763996866154.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665764009196328.jpg\\\" style=\\\"\\\" title=\\\"14665764009196328.jpg\\\"/></p><p><br/></p>', '1', '10', '0.02', '0', '0.01', '100', '5', '0', '0', '0', '2016-06-22 14:20:50');
INSERT INTO `goods` VALUES ('521', '10', '林氏木业现代皮布沙发可拆洗小户型客厅转角结合布沙发组合2053 饱满座包 少量现货', '', '林氏木业', '广东佛山', '', '', '<p><img src=\\\"/pic/upload/image/20160622/14665767135171551.jpg\\\" style=\\\"\\\" title=\\\"14665767135171551.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665767219026772.jpg\\\" style=\\\"\\\" title=\\\"14665767219026772.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665767221155053.jpg\\\" style=\\\"\\\" title=\\\"14665767221155053.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665767231186984.jpg\\\" style=\\\"\\\" title=\\\"14665767231186984.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665767274884536.jpg\\\" style=\\\"\\\" title=\\\"14665767274884536.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665767286599357.jpg\\\" style=\\\"\\\" title=\\\"14665767286599357.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665767304965005.jpg\\\" style=\\\"\\\" title=\\\"14665767304965005.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665767306240468.jpg\\\" style=\\\"\\\" title=\\\"14665767306240468.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665767353103889.jpg\\\" style=\\\"\\\" title=\\\"14665767353103889.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/146657674212900410.jpg\\\" style=\\\"\\\" title=\\\"146657674212900410.jpg\\\"/></p><p><br/></p>', '1', '20', '0.02', '0', '0.01', '82', '5', '1', '0', '0', '2016-06-22 14:26:03');
INSERT INTO `goods` VALUES ('522', '10', '林氏木业现代布沙发 小户型客厅U型组合简约布艺沙发样板房V8-163', '', '林氏木业', '广东佛山', '', '', '<p><img src=\\\"/pic/upload/image/20160622/14665770225131103.jpg\\\" style=\\\"\\\" title=\\\"14665770225131103.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665770231408382.jpg\\\" style=\\\"\\\" title=\\\"14665770231408382.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665770246053281.jpg\\\" style=\\\"\\\" title=\\\"14665770246053281.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665770288610226.jpg\\\" style=\\\"\\\" title=\\\"14665770288610226.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665770281817234.jpg\\\" style=\\\"\\\" title=\\\"14665770281817234.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665770327114449.jpg\\\" style=\\\"\\\" title=\\\"14665770327114449.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665770338736748.jpg\\\" style=\\\"\\\" title=\\\"14665770338736748.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665770376300717.jpg\\\" style=\\\"\\\" title=\\\"14665770376300717.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/146657704239541911.jpg\\\" style=\\\"\\\" title=\\\"146657704239541911.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/146657704311332810.jpg\\\" style=\\\"\\\" title=\\\"146657704311332810.jpg\\\"/></p><p><br/></p>', '1', '20', '0.02', '0', '0.01', '78', '6', '0', '0', '0', '2016-06-22 14:31:22');
INSERT INTO `goods` VALUES ('523', '12', '纯实木沙发白橡木转角沙发三人位布艺可拆洗沙发组合客厅简约家具', '', '忧木家具', '上海', '', '', null, '1', '10', '0.02', '0', '0.01', '81', '6', '1', '0', '0', '2016-06-22 14:41:36');
INSERT INTO `goods` VALUES ('524', '12', '纯实木沙发白橡木转角沙发三人位布艺可拆洗沙发组合客厅简约家具', '', '忧木家具', '上海', '', '', '<p><img src=\\\"/pic/upload/image/20160622/14665776449217401.jpg\\\" style=\\\"\\\" title=\\\"14665776449217401.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665776463525162.jpg\\\" style=\\\"\\\" title=\\\"14665776463525162.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665776475402204.jpg\\\" style=\\\"\\\" title=\\\"14665776475402204.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665776491918783.jpg\\\" style=\\\"\\\" title=\\\"14665776491918783.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665776516124286.jpg\\\" style=\\\"\\\" title=\\\"14665776516124286.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665776631877905.jpg\\\" style=\\\"\\\" title=\\\"14665776631877905.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665776632795777.jpg\\\" style=\\\"\\\" title=\\\"14665776632795777.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665776656002939.jpg\\\" style=\\\"\\\" title=\\\"14665776656002939.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665776689235488.jpg\\\" style=\\\"\\\" title=\\\"14665776689235488.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/146657766898349111.jpg\\\" style=\\\"\\\" title=\\\"146657766898349111.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/146657767084178710.jpg\\\" style=\\\"\\\" title=\\\"146657767084178710.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/146657767066286112.jpg\\\" style=\\\"\\\" title=\\\"146657767066286112.jpg\\\"/></p><p><br/></p>', '1', '10', '0.02', '0', '0.01', '81', '6', '1', '0', '0', '2016-06-22 14:41:43');
INSERT INTO `goods` VALUES ('525', '12', '纯实木茶几红橡木四抽咖啡桌1.2米1.4米带抽茶几茶桌美式简约家具', '', '优木家具', '上海', '', '', '<p><img src=\\\"/pic/upload/image/20160622/14665779065867811.jpg\\\" style=\\\"\\\" title=\\\"14665779065867811.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665779066669062.jpg\\\" style=\\\"\\\" title=\\\"14665779066669062.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665779078507813.jpg\\\" style=\\\"\\\" title=\\\"14665779078507813.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665779121174465.jpg\\\" style=\\\"\\\" title=\\\"14665779121174465.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665779141223826.jpg\\\" style=\\\"\\\" title=\\\"14665779141223826.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665779167368337.jpg\\\" style=\\\"\\\" title=\\\"14665779167368337.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665779172570718.jpg\\\" style=\\\"\\\" title=\\\"14665779172570718.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665779191110049.jpg\\\" style=\\\"\\\" title=\\\"14665779191110049.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/146657792521589010.jpg\\\" style=\\\"\\\" title=\\\"146657792521589010.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665779257236654.jpg\\\" style=\\\"\\\" title=\\\"14665779257236654.jpg\\\"/></p><p><br/></p>', '1', '10', '0.01', '0', '0.01', '92', '5', '1', '0', '0', '2016-06-22 14:46:38');
INSERT INTO `goods` VALUES ('526', '12', '纯实木书桌1米白橡木带抽屉1.2米电脑桌日式简约写字桌家用特价', '', '优木', '上海', '', '', '<p><img src=\\\"/pic/upload/image/20160622/14665782474467122.jpg\\\" style=\\\"\\\" title=\\\"14665782474467122.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665782492302203.jpg\\\" style=\\\"\\\" title=\\\"14665782492302203.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665782514653884.jpg\\\" style=\\\"\\\" title=\\\"14665782514653884.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665782549626205.jpg\\\" style=\\\"\\\" title=\\\"14665782549626205.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665782587923446.jpg\\\" style=\\\"\\\" title=\\\"14665782587923446.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665782598849487.jpg\\\" style=\\\"\\\" title=\\\"14665782598849487.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665782634483488.jpg\\\" style=\\\"\\\" title=\\\"14665782634483488.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665782631137321.jpg\\\" style=\\\"\\\" title=\\\"14665782631137321.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665782657109289.jpg\\\" style=\\\"\\\" title=\\\"14665782657109289.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/146657827310761310.jpg\\\" style=\\\"\\\" title=\\\"146657827310761310.jpg\\\"/></p><p><br/></p>', '1', '10', '0.02', '0', '0.01', '132', '5', '1', '0', '0', '2016-06-22 14:51:48');
INSERT INTO `goods` VALUES ('527', '12', '纯实木床进口白橡木床1.51.8米实木双人床简约现代欧式家具特价', '', '优木家具', '上海', '', '', '<p><img src=\\\"/pic/upload/image/20160622/14665784755181453.jpg\\\" style=\\\"\\\" title=\\\"14665784755181453.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665784844776094.jpg\\\" style=\\\"\\\" title=\\\"14665784844776094.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665784961298915.jpg\\\" style=\\\"\\\" title=\\\"14665784961298915.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665785128282326.jpg\\\" style=\\\"\\\" title=\\\"14665785128282326.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665785143201137.jpg\\\" style=\\\"\\\" title=\\\"14665785143201137.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665785143174451.jpg\\\" style=\\\"\\\" title=\\\"14665785143174451.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665785211329462.jpg\\\" style=\\\"\\\" title=\\\"14665785211329462.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665785223769159.jpg\\\" style=\\\"\\\" title=\\\"14665785223769159.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665785228421318.jpg\\\" style=\\\"\\\" title=\\\"14665785228421318.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/146657852510164510.jpg\\\" style=\\\"\\\" title=\\\"146657852510164510.jpg\\\"/></p><p><br/></p>', '1', '20', '0.02', '0', '0.01', '54', '6', '1', '0', '0', '2016-06-22 14:57:48');
INSERT INTO `goods` VALUES ('528', '12', '纯实木餐桌红橡木餐桌1.2/1.41.6米带抽屉餐桌椅组合美式家具特价', '', '优木家具', '上海', '', '', '<p><img src=\\\"/pic/upload/image/20160622/146657877512425413.jpg\\\" style=\\\"\\\" title=\\\"146657877512425413.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/146657877713568311.jpg\\\" style=\\\"\\\" title=\\\"146657877713568311.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/146657877939675312.jpg\\\" style=\\\"\\\" title=\\\"146657877939675312.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/146657878055928414.jpg\\\" style=\\\"\\\" title=\\\"146657878055928414.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/146657878313192215.jpg\\\" style=\\\"\\\" title=\\\"146657878313192215.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/146657878475056016.jpg\\\" style=\\\"\\\" title=\\\"146657878475056016.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/146657878813708218.jpg\\\" style=\\\"\\\" title=\\\"146657878813708218.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/146657879186644419.jpg\\\" style=\\\"\\\" title=\\\"146657879186644419.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/146657879313343717.jpg\\\" style=\\\"\\\" title=\\\"146657879313343717.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/146657879611819520.jpg\\\" style=\\\"\\\" title=\\\"146657879611819520.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/146657880087014521.jpg\\\" style=\\\"\\\" title=\\\"146657880087014521.jpg\\\"/></p><p><br/></p>', '1', '10', '0.02', '0', '0.01', '103', '5', '1', '0', '0', '2016-06-22 15:00:38');
INSERT INTO `goods` VALUES ('529', '13', '卡伊莲地中海布艺沙发美式乡村客厅田园布沙发U型三人小户型DSF01', '', '卡伊莲', '广东佛山', '', '', '<p><img src=\\\"/pic/upload/image/20160622/14665793641184571.jpg\\\" style=\\\"\\\" title=\\\"14665793641184571.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665793705096253.jpg\\\" style=\\\"\\\" title=\\\"14665793705096253.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665793703418012.jpg\\\" style=\\\"\\\" title=\\\"14665793703418012.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665793721402834.jpg\\\" style=\\\"\\\" title=\\\"14665793721402834.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665793756191415.jpg\\\" style=\\\"\\\" title=\\\"14665793756191415.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665793791187766.jpg\\\" style=\\\"\\\" title=\\\"14665793791187766.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665793881035219.jpg\\\" style=\\\"\\\" title=\\\"14665793881035219.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665794017009877.jpg\\\" style=\\\"\\\" title=\\\"14665794017009877.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665794034733498.jpg\\\" style=\\\"\\\" title=\\\"14665794034733498.jpg\\\"/></p><p><br/></p>', '1', '10', '0.02', '0', '0.01', '78', '6', '1', '0', '0', '2016-06-22 15:11:12');
INSERT INTO `goods` VALUES ('530', '13', '卡伊莲韩式田园床简约软靠床双人床1.5M米公主床板木家私BD2A-D*', '', '卡伊莲', '广东佛山', '', '', '<p><img src=\\\"/pic/upload/image/20160622/14665797201204883.jpg\\\" style=\\\"\\\" title=\\\"14665797201204883.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665797203924492.jpg\\\" style=\\\"\\\" title=\\\"14665797203924492.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665797251336655.jpg\\\" style=\\\"\\\" title=\\\"14665797251336655.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665797291268144.jpg\\\" style=\\\"\\\" title=\\\"14665797291268144.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665797294035951.jpg\\\" style=\\\"\\\" title=\\\"14665797294035951.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665797302507896.jpg\\\" style=\\\"\\\" title=\\\"14665797302507896.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665797329892147.jpg\\\" style=\\\"\\\" title=\\\"14665797329892147.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665797329350808.jpg\\\" style=\\\"\\\" title=\\\"14665797329350808.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665797351004539.jpg\\\" style=\\\"\\\" title=\\\"14665797351004539.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/146657973938737210.jpg\\\" style=\\\"\\\" title=\\\"146657973938737210.jpg\\\"/></p><p><br/></p>', '1', '20', '0.02', '0', '0.01', '54', '6', '1', '0', '0', '2016-06-22 15:16:44');
INSERT INTO `goods` VALUES ('531', '13', '卡伊莲欧式餐桌椅组合6人小户型餐厅吃饭桌法式白色餐台KT620C*', '', '卡伊莲', '广东佛山', '', '', null, '1', '20', '0.02', '0', '0.01', '100', '5', '1', '0', '0', '2016-06-22 15:22:18');
INSERT INTO `goods` VALUES ('532', '13', '卡伊莲欧式餐桌椅组合6人小户型餐厅吃饭桌法式白色餐台KT620C*', '', '卡伊莲', '广东佛山', '', '', '<p><img src=\\\"/pic/upload/image/20160622/14665800416095452.jpg\\\" style=\\\"\\\" title=\\\"14665800416095452.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665800431171624.jpg\\\" style=\\\"\\\" title=\\\"14665800431171624.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665800437143271.jpg\\\" style=\\\"\\\" title=\\\"14665800437143271.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665800481275846.jpg\\\" style=\\\"\\\" title=\\\"14665800481275846.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665800506012403.jpg\\\" style=\\\"\\\" title=\\\"14665800506012403.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665800511316778.jpg\\\" style=\\\"\\\" title=\\\"14665800511316778.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665800538946737.jpg\\\" style=\\\"\\\" title=\\\"14665800538946737.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665800541976019.jpg\\\" style=\\\"\\\" title=\\\"14665800541976019.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/146658005890254810.jpg\\\" style=\\\"\\\" title=\\\"146658005890254810.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665800611366565.jpg\\\" style=\\\"\\\" title=\\\"14665800611366565.jpg\\\"/></p><p><br/></p>', '1', '20', '0.02', '0', '0.01', '100', '5', '1', '0', '0', '2016-06-22 15:22:31');
INSERT INTO `goods` VALUES ('533', '13', '卡伊莲地中海高低儿童床男孩女孩上下双层床带护栏子母床家具BJ3A', '', '卡伊莲', '山东佛山', '', '', '<p><img src=\\\"/pic/upload/image/20160622/14665803501400511.jpg\\\" style=\\\"\\\" title=\\\"14665803501400511.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665803511025703.jpg\\\" style=\\\"\\\" title=\\\"14665803511025703.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665803534406452.jpg\\\" style=\\\"\\\" title=\\\"14665803534406452.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665803547973784.jpg\\\" style=\\\"\\\" title=\\\"14665803547973784.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665803553412425.jpg\\\" style=\\\"\\\" title=\\\"14665803553412425.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665803615225778.jpg\\\" style=\\\"\\\" title=\\\"14665803615225778.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665803636465096.jpg\\\" style=\\\"\\\" title=\\\"14665803636465096.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665803631393457.jpg\\\" style=\\\"\\\" title=\\\"14665803631393457.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665803641183469.jpg\\\" style=\\\"\\\" title=\\\"14665803641183469.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/146658036995616610.jpg\\\" style=\\\"\\\" title=\\\"146658036995616610.jpg\\\"/></p><p><br/></p>', '1', '20', '0.02', '0', '0.01', '142', '7', '1', '0', '0', '2016-06-22 15:26:33');
INSERT INTO `goods` VALUES ('534', '13', '卡伊莲天然乳胶双人床垫1.8米 1.5成人护脊弹簧软床垫席梦思CD006', '', '卡伊莲', '广东佛山', '', '', '<p><img src=\\\"/pic/upload/image/20160622/14665806933958491.jpg\\\" style=\\\"\\\" title=\\\"14665806933958491.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665806992811262.jpg\\\" style=\\\"\\\" title=\\\"14665806992811262.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665807005181023.jpg\\\" style=\\\"\\\" title=\\\"14665807005181023.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665807111767315.jpg\\\" style=\\\"\\\" title=\\\"14665807111767315.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665807135372946.jpg\\\" style=\\\"\\\" title=\\\"14665807135372946.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665807155695688.jpg\\\" style=\\\"\\\" title=\\\"14665807155695688.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665807192128357.jpg\\\" style=\\\"\\\" title=\\\"14665807192128357.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665807237509904.jpg\\\" style=\\\"\\\" title=\\\"14665807237509904.jpg\\\"/></p><p><br/></p>', '1', '10', '0.02', '0', '0.01', '62', '6', '1', '0', '0', '2016-06-22 15:33:06');
INSERT INTO `goods` VALUES ('535', '14', '夏季布艺户外休闲躺椅 阳台折叠躺椅 懒人办公室可午休躺椅沙发椅', '', '泡沫小敏', '浙江杭州', '', '', '<p><img src=\\\"/pic/upload/image/20160622/14665811995000293.jpg\\\" style=\\\"\\\" title=\\\"14665811995000293.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665811998042202.jpg\\\" style=\\\"\\\" title=\\\"14665811998042202.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665812055509351.jpg\\\" style=\\\"\\\" title=\\\"14665812055509351.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665812101142626.jpg\\\" style=\\\"\\\" title=\\\"14665812101142626.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665812121311954.jpg\\\" style=\\\"\\\" title=\\\"14665812121311954.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665812169017747.jpg\\\" style=\\\"\\\" title=\\\"14665812169017747.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665812223734725.jpg\\\" style=\\\"\\\" title=\\\"14665812223734725.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665812231050238.jpg\\\" style=\\\"\\\" title=\\\"14665812231050238.jpg\\\"/></p><p><br/></p>', '1', '8', '0.02', '0', '0.01', '111', '5', '1', '0', '0', '2016-06-22 15:42:15');
INSERT INTO `goods` VALUES ('536', '14', '北美进口白橡木 全实木布艺沙发 简约现代中小户型布艺沙发 组合', '', '泡沫小敏', '浙江杭州', '', '', '<p><img src=\\\"/pic/upload/image/20160622/14665830061280491.jpg\\\" style=\\\"\\\" title=\\\"14665830061280491.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665830071143133.jpg\\\" style=\\\"\\\" title=\\\"14665830071143133.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665830111182815.jpg\\\" style=\\\"\\\" title=\\\"14665830111182815.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665830154438722.jpg\\\" style=\\\"\\\" title=\\\"14665830154438722.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665830186527497.jpg\\\" style=\\\"\\\" title=\\\"14665830186527497.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665830197761646.jpg\\\" style=\\\"\\\" title=\\\"14665830197761646.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665830201198174.jpg\\\" style=\\\"\\\" title=\\\"14665830201198174.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665830221294528.jpg\\\" style=\\\"\\\" title=\\\"14665830221294528.jpg\\\"/></p><p><br/></p>', '1', '20', '0.02', '0', '0.01', '78', '5', '1', '0', '0', '2016-06-22 16:10:36');
INSERT INTO `goods` VALUES ('537', '14', '云溪床 北欧宜家纯实木家具 卧室双人床 白橡木1.8m床 日式简约床', '', '泡沫小敏', '浙江台州', '', '', '<p><img src=\\\"/pic/upload/image/20160622/14665832363775601.jpg\\\" style=\\\"\\\" title=\\\"14665832363775601.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665832402558234.jpg\\\" style=\\\"\\\" title=\\\"14665832402558234.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665832428185502.jpg\\\" style=\\\"\\\" title=\\\"14665832428185502.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665832491133246.jpg\\\" style=\\\"\\\" title=\\\"14665832491133246.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665832521211307.jpg\\\" style=\\\"\\\" title=\\\"14665832521211307.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665832527182863.jpg\\\" style=\\\"\\\" title=\\\"14665832527182863.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665832621040805.jpg\\\" style=\\\"\\\" title=\\\"14665832621040805.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665832631980759.jpg\\\" style=\\\"\\\" title=\\\"14665832631980759.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/146658327429614411.jpg\\\" style=\\\"\\\" title=\\\"146658327429614411.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665832741371338.jpg\\\" style=\\\"\\\" title=\\\"14665832741371338.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/146658327931748810.jpg\\\" style=\\\"\\\" title=\\\"146658327931748810.jpg\\\"/></p><p><br/></p>', '1', '20', '0.02', '0', '0.01', '54', '5', '1', '0', '0', '2016-06-22 16:16:12');
INSERT INTO `goods` VALUES ('538', '14', ' 实木餐桌椅组合 简约现代创意小户型长方形桌子 北欧风格餐桌饭桌', '', '泡沫小敏', '浙江台州', '', '', '<p><img src=\\\"/pic/upload/image/20160622/14665836226661311.jpg\\\" style=\\\"\\\" title=\\\"14665836226661311.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665836239357262.jpg\\\" style=\\\"\\\" title=\\\"14665836239357262.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665836246678533.jpg\\\" style=\\\"\\\" title=\\\"14665836246678533.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665836266758574.jpg\\\" style=\\\"\\\" title=\\\"14665836266758574.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665836322171385.jpg\\\" style=\\\"\\\" title=\\\"14665836322171385.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665836361893397.jpg\\\" style=\\\"\\\" title=\\\"14665836361893397.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665836464421949.jpg\\\" style=\\\"\\\" title=\\\"14665836464421949.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/146658365257413010.jpg\\\" style=\\\"\\\" title=\\\"146658365257413010.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665836531106088.jpg\\\" style=\\\"\\\" title=\\\"14665836531106088.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665836541138406.jpg\\\" style=\\\"\\\" title=\\\"14665836541138406.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/146658366230810712.jpg\\\" style=\\\"\\\" title=\\\"146658366230810712.jpg\\\"/></p><p><br/></p>', '1', '10', '0.02', '0', '0.01', '103', '5', '1', '0', '0', '2016-06-22 16:22:07');
INSERT INTO `goods` VALUES ('539', '14', '泡沫小敏 实木长野五斗柜 斗橱简约现代北欧风格原木抽屉收纳柜子', '', '泡沫小敏', '浙江台州', '', '', '<p><img src=\\\"/pic/upload/image/20160622/14665838851279671.jpg\\\" style=\\\"\\\" title=\\\"14665838851279671.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665838881406964.jpg\\\" style=\\\"\\\" title=\\\"14665838881406964.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665838885866952.jpg\\\" style=\\\"\\\" title=\\\"14665838885866952.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665838941271023.jpg\\\" style=\\\"\\\" title=\\\"14665838941271023.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665839008722116.jpg\\\" style=\\\"\\\" title=\\\"14665839008722116.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665839033807455.jpg\\\" style=\\\"\\\" title=\\\"14665839033807455.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665839037411368.jpg\\\" style=\\\"\\\" title=\\\"14665839037411368.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665839043502787.jpg\\\" style=\\\"\\\" title=\\\"14665839043502787.jpg\\\"/></p><p><br/></p>', '1', '10', '0.02', '0', '0.01', '66', '5', '1', '0', '0', '2016-06-22 16:25:17');
INSERT INTO `goods` VALUES ('540', '15', '欧宜家欧式美式沙发 美式实木真皮沙发简美客厅家具奢华沙发组合', '', '欧宜家', '广东佛山', '', '', null, '1', '20', '0.02', '0', '0.01', '75', '6', '1', '0', '0', '2016-06-22 16:37:51');
INSERT INTO `goods` VALUES ('541', '15', '欧宜家欧式美式沙发 美式实木真皮沙发简美客厅家具奢华沙发组合', '', '欧宜家', '广东佛山', '', '', null, '1', '20', '0.02', '0', '0.01', '75', '6', '1', '0', '0', '2016-06-22 16:37:59');
INSERT INTO `goods` VALUES ('542', '15', '欧宜家欧式美式沙发 美式实木真皮沙发简美客厅家具奢华沙发组合', '', '欧宜家', '广东佛山', '', '', '<p><img src=\\\"/pic/upload/image/20160622/14665846261275201.jpg\\\" style=\\\"\\\" title=\\\"14665846261275201.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665846271096702.jpg\\\" style=\\\"\\\" title=\\\"14665846271096702.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665846274512313.jpg\\\" style=\\\"\\\" title=\\\"14665846274512313.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665846309664935.jpg\\\" style=\\\"\\\" title=\\\"14665846309664935.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665846301108364.jpg\\\" style=\\\"\\\" title=\\\"14665846301108364.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665846328469947.jpg\\\" style=\\\"\\\" title=\\\"14665846328469947.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665846337608016.jpg\\\" style=\\\"\\\" title=\\\"14665846337608016.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665846361802178.jpg\\\" style=\\\"\\\" title=\\\"14665846361802178.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/146658463811076310.jpg\\\" style=\\\"\\\" title=\\\"146658463811076310.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665846385023099.jpg\\\" style=\\\"\\\" title=\\\"14665846385023099.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/146658464210508311.jpg\\\" style=\\\"\\\" title=\\\"146658464210508311.jpg\\\"/></p><p><br/></p>', '1', '20', '0.02', '0', '0.01', '75', '6', '1', '0', '1', '2016-06-22 16:38:10');
INSERT INTO `goods` VALUES ('543', '15', '欧式四门酒柜雕花实木柜法式客厅红酒柜高档象牙白色酒柜门厅柜', '', '欧宜家', '广东佛山', '', '', '<p><img src=\\\"/pic/upload/image/20160622/14665850373771301.jpg\\\" style=\\\"\\\" title=\\\"14665850373771301.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665850394693043.jpg\\\" style=\\\"\\\" title=\\\"14665850394693043.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665850401041112.jpg\\\" style=\\\"\\\" title=\\\"14665850401041112.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665850413990764.jpg\\\" style=\\\"\\\" title=\\\"14665850413990764.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665850505690526.jpg\\\" style=\\\"\\\" title=\\\"14665850505690526.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665850501521605.jpg\\\" style=\\\"\\\" title=\\\"14665850501521605.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665850526801607.jpg\\\" style=\\\"\\\" title=\\\"14665850526801607.jpg\\\"/></p><p><br/></p>', '1', '20', '0.02', '0', '0.01', '86', '5', '1', '0', '0', '2016-06-22 16:45:02');
INSERT INTO `goods` VALUES ('544', '15', '欧宜家 欧式实木梳妆台 小户型卧室梳妆桌现代简约田园公主化妆台', '', '欧宜家', '广东佛山', '', '', '<p><img src=\\\"/pic/upload/image/20160622/14665853379504852.jpg\\\" style=\\\"\\\" title=\\\"14665853379504852.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665853396290381.jpg\\\" style=\\\"\\\" title=\\\"14665853396290381.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665853428992353.jpg\\\" style=\\\"\\\" title=\\\"14665853428992353.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665853444203345.jpg\\\" style=\\\"\\\" title=\\\"14665853444203345.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665853451066416.jpg\\\" style=\\\"\\\" title=\\\"14665853451066416.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665853458154524.jpg\\\" style=\\\"\\\" title=\\\"14665853458154524.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665853498471237.jpg\\\" style=\\\"\\\" title=\\\"14665853498471237.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665853541184538.jpg\\\" style=\\\"\\\" title=\\\"14665853541184538.jpg\\\"/></p><p><br/></p>', '1', '20', '0.02', '0', '0.01', '70', '5', '0', '0', '0', '2016-06-22 16:50:03');
INSERT INTO `goods` VALUES ('545', '15', '欧式衣柜 推拉门双门趟门大衣柜 象牙白色 多功能大容量实木衣柜', '', '欧宜家', '广东佛山', '', '', null, '1', '8', '0.02', '0', '0.01', '65', '5', '1', '0', '0', '2016-06-22 16:57:26');
INSERT INTO `goods` VALUES ('546', '15', '欧式衣柜 推拉门双门趟门大衣柜 象牙白色 多功能大容量实木衣柜', '', '欧宜家', '广东佛山', '', '', '<p><img src=\\\"/pic/upload/image/20160622/14665858081375121.jpg\\\" style=\\\"\\\" title=\\\"14665858081375121.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665858081133153.jpg\\\" style=\\\"\\\" title=\\\"14665858081133153.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665858119693762.jpg\\\" style=\\\"\\\" title=\\\"14665858119693762.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665858111647254.jpg\\\" style=\\\"\\\" title=\\\"14665858111647254.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665858128972125.jpg\\\" style=\\\"\\\" title=\\\"14665858128972125.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665858196294257.jpg\\\" style=\\\"\\\" title=\\\"14665858196294257.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665858202212266.jpg\\\" style=\\\"\\\" title=\\\"14665858202212266.jpg\\\"/></p><p><br/></p>', '1', '8', '0.02', '0', '0.01', '65', '5', '1', '0', '1', '2016-06-22 16:57:32');
INSERT INTO `goods` VALUES ('547', '15', '欧宜家欧式床头柜时尚简约储物柜实木法式床边头柜田园收纳小柜子', '', '欧宜家', '广东佛山', '', '', '<p><img src=\\\"/pic/upload/image/20160622/14665861516282641.jpg\\\" style=\\\"\\\" title=\\\"14665861516282641.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665861518571502.jpg\\\" style=\\\"\\\" title=\\\"14665861518571502.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665861512010443.jpg\\\" style=\\\"\\\" title=\\\"14665861512010443.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665861547044305.jpg\\\" style=\\\"\\\" title=\\\"14665861547044305.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665861551321036.jpg\\\" style=\\\"\\\" title=\\\"14665861551321036.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665861552064664.jpg\\\" style=\\\"\\\" title=\\\"14665861552064664.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665861572029378.jpg\\\" style=\\\"\\\" title=\\\"14665861572029378.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665861573952467.jpg\\\" style=\\\"\\\" title=\\\"14665861573952467.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665861601290049.jpg\\\" style=\\\"\\\" title=\\\"14665861601290049.jpg\\\"/></p><p><br/></p>', '1', '10', '0.02', '0', '0.01', '68', '6', '1', '0', '0', '2016-06-22 17:02:57');
INSERT INTO `goods` VALUES ('548', '15', '韩式田园书桌实木学习桌 白色电脑桌转角简约家用时尚书台组合', '', '欧宜家', '广东佛山', '', '', '<p><img src=\\\"/pic/upload/image/20160622/14665864003171442.jpg\\\" style=\\\"\\\" title=\\\"14665864003171442.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665864024381923.jpg\\\" style=\\\"\\\" title=\\\"14665864024381923.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665864069502704.jpg\\\" style=\\\"\\\" title=\\\"14665864069502704.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665864071019721.jpg\\\" style=\\\"\\\" title=\\\"14665864071019721.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665864092186445.jpg\\\" style=\\\"\\\" title=\\\"14665864092186445.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665864137708288.jpg\\\" style=\\\"\\\" title=\\\"14665864137708288.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665864147927746.jpg\\\" style=\\\"\\\" title=\\\"14665864147927746.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665864202161489.jpg\\\" style=\\\"\\\" title=\\\"14665864202161489.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/146658642353759610.jpg\\\" style=\\\"\\\" title=\\\"146658642353759610.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665864237545627.jpg\\\" style=\\\"\\\" title=\\\"14665864237545627.jpg\\\"/></p><p><br/></p>', '1', '10', '0.02', '0', '0.01', '120', '5', '1', '0', '0', '2016-06-22 17:07:52');
INSERT INTO `goods` VALUES ('549', '15', '韩式田园书桌实木学习桌 白色电脑桌转角简约家用时尚书台组合', '', '欧宜家', '广东佛山', '', '', '<p><img src=\\\"/pic/upload/image/20160622/14665864003171442.jpg\\\" style=\\\"\\\" title=\\\"14665864003171442.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665864024381923.jpg\\\" style=\\\"\\\" title=\\\"14665864024381923.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665864069502704.jpg\\\" style=\\\"\\\" title=\\\"14665864069502704.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665864071019721.jpg\\\" style=\\\"\\\" title=\\\"14665864071019721.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665864092186445.jpg\\\" style=\\\"\\\" title=\\\"14665864092186445.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665864137708288.jpg\\\" style=\\\"\\\" title=\\\"14665864137708288.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665864147927746.jpg\\\" style=\\\"\\\" title=\\\"14665864147927746.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665864202161489.jpg\\\" style=\\\"\\\" title=\\\"14665864202161489.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/146658642353759610.jpg\\\" style=\\\"\\\" title=\\\"146658642353759610.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665864237545627.jpg\\\" style=\\\"\\\" title=\\\"14665864237545627.jpg\\\"/></p><p><br/></p>', '1', '10', '0.02', '0', '0.01', '120', '5', '1', '0', '0', '2016-06-22 17:07:58');
INSERT INTO `goods` VALUES ('550', '16', '道奇家具北欧现代风格日式小户型简约时尚高级布艺沙发特价促销', '', '道奇', '山东青岛', '', '', '<p><img src=\\\"/pic/upload/image/20160622/14665872031071832.jpg\\\" style=\\\"\\\" title=\\\"14665872031071832.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665872062267341.jpg\\\" style=\\\"\\\" title=\\\"14665872062267341.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665872128188083.jpg\\\" style=\\\"\\\" title=\\\"14665872128188083.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665872144583315.jpg\\\" style=\\\"\\\" title=\\\"14665872144583315.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665872161160484.jpg\\\" style=\\\"\\\" title=\\\"14665872161160484.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665872236021866.jpg\\\" style=\\\"\\\" title=\\\"14665872236021866.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665872241113367.jpg\\\" style=\\\"\\\" title=\\\"14665872241113367.jpg\\\"/></p><p><br/></p>', '1', '20', '0.02', '0', '0.01', '78', '9', '1', '0', '0', '2016-06-22 17:21:09');
INSERT INTO `goods` VALUES ('551', '16', '道奇家具橡木实木多功能电源接口USB接口健康时尚北欧风格新婚床', '', '道奇', '山东青岛', '', '', '<p><img src=\\\"/pic/upload/image/20160622/14665875037735393.jpg\\\" style=\\\"\\\" title=\\\"14665875037735393.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665875072143841.jpg\\\" style=\\\"\\\" title=\\\"14665875072143841.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665875112968332.jpg\\\" style=\\\"\\\" title=\\\"14665875112968332.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665875131196064.jpg\\\" style=\\\"\\\" title=\\\"14665875131196064.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665875151408437.jpg\\\" style=\\\"\\\" title=\\\"14665875151408437.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665875186141495.jpg\\\" style=\\\"\\\" title=\\\"14665875186141495.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665875196564068.jpg\\\" style=\\\"\\\" title=\\\"14665875196564068.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665875221280539.jpg\\\" style=\\\"\\\" title=\\\"14665875221280539.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665875239676126.jpg\\\" style=\\\"\\\" title=\\\"14665875239676126.jpg\\\"/></p><p><br/></p>', '1', '20', '0.02', '0', '0.01', '54', '5', '1', '0', '0', '2016-06-22 17:26:07');
INSERT INTO `goods` VALUES ('552', '16', '道奇家具北欧现代 红橡木家具 书桌 写字台 带抽屉 化妆台 电脑桌', '', '道奇', '山东青岛', '', '', '<p><img src=\\\"/pic/upload/image/20160622/14665877537382532.jpg\\\" style=\\\"\\\" title=\\\"14665877537382532.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665877569833621.jpg\\\" style=\\\"\\\" title=\\\"14665877569833621.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665877616932855.jpg\\\" style=\\\"\\\" title=\\\"14665877616932855.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665877628426913.jpg\\\" style=\\\"\\\" title=\\\"14665877628426913.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665877631356444.jpg\\\" style=\\\"\\\" title=\\\"14665877631356444.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665877653016526.jpg\\\" style=\\\"\\\" title=\\\"14665877653016526.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665877651019897.jpg\\\" style=\\\"\\\" title=\\\"14665877651019897.jpg\\\"/></p><p><br/></p>', '1', '20', '0.02', '0', '0.01', '70', '5', '1', '0', '0', '2016-06-22 17:29:37');
INSERT INTO `goods` VALUES ('553', '16', '日式家具时尚餐桌北欧现代风格橡木木质实木餐桌简约特价小户型', '', '道奇', '山东青岛', '', '', null, '1', '10', '0.02', '0', '0.01', '103', '5', '1', '0', '1', '2016-06-22 17:35:39');
INSERT INTO `goods` VALUES ('554', '16', '日式家具时尚餐桌北欧现代风格橡木木质实木餐桌简约特价小户型', '', '道奇', '山东青岛', '', '', '<p><img src=\\\"/pic/upload/image/20160622/14665880918545683.jpg\\\" style=\\\"\\\" title=\\\"14665880918545683.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665880927676861.jpg\\\" style=\\\"\\\" title=\\\"14665880927676861.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665880969450204.jpg\\\" style=\\\"\\\" title=\\\"14665880969450204.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665880975464602.jpg\\\" style=\\\"\\\" title=\\\"14665880975464602.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665881034904335.jpg\\\" style=\\\"\\\" title=\\\"14665881034904335.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665881031286656.jpg\\\" style=\\\"\\\" title=\\\"14665881031286656.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665881101416609.jpg\\\" style=\\\"\\\" title=\\\"14665881101416609.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665881104964577.jpg\\\" style=\\\"\\\" title=\\\"14665881104964577.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665881131002948.jpg\\\" style=\\\"\\\" title=\\\"14665881131002948.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/146658811484234710.jpg\\\" style=\\\"\\\" title=\\\"146658811484234710.jpg\\\"/></p><p><br/></p>', '1', '10', '0.02', '0', '0.01', '103', '5', '1', '0', '1', '2016-06-22 17:35:47');
INSERT INTO `goods` VALUES ('555', '16', '道奇家具实木家具日式北欧现代简约风格报刊架橡木隔断小户型书架', '', '道奇', '山东青岛', '', '', '<p><img src=\\\"/pic/upload/image/20160622/14665883721024583.jpg\\\" style=\\\"\\\" title=\\\"14665883721024583.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665883745280422.jpg\\\" style=\\\"\\\" title=\\\"14665883745280422.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665883741530211.jpg\\\" style=\\\"\\\" title=\\\"14665883741530211.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665883807457406.jpg\\\" style=\\\"\\\" title=\\\"14665883807457406.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665883811322365.jpg\\\" style=\\\"\\\" title=\\\"14665883811322365.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665883831244904.jpg\\\" style=\\\"\\\" title=\\\"14665883831244904.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665883864000238.jpg\\\" style=\\\"\\\" title=\\\"14665883864000238.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160622/14665883876287377.jpg\\\" style=\\\"\\\" title=\\\"14665883876287377.jpg\\\"/></p><p><br/></p>', '1', '10', '0.02', '0', '0.01', '128', '6', '1', '0', '0', '2016-06-22 17:41:10');
INSERT INTO `goods` VALUES ('556', '17', '美式乡村彩绘卧室板木梳妆台 地中海电脑桌 欧式宜家复古艺术斗柜', '', '欧菲曼', '广东中山', '', '', '<p><img src=\\\"/pic/upload/image/20160623/14666620189704521.jpg\\\" style=\\\"\\\" title=\\\"14666620189704521.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/14666620208972552.jpg\\\" style=\\\"\\\" title=\\\"14666620208972552.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/14666620216928543.jpg\\\" style=\\\"\\\" title=\\\"14666620216928543.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/14666620244919825.jpg\\\" style=\\\"\\\" title=\\\"14666620244919825.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/14666620264443464.jpg\\\" style=\\\"\\\" title=\\\"14666620264443464.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/14666620271961816.jpg\\\" style=\\\"\\\" title=\\\"14666620271961816.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/14666620274011857.jpg\\\" style=\\\"\\\" title=\\\"14666620274011857.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/14666620291105789.jpg\\\" style=\\\"\\\" title=\\\"14666620291105789.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/14666620293115078.jpg\\\" style=\\\"\\\" title=\\\"14666620293115078.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/146666203211720510.jpg\\\" style=\\\"\\\" title=\\\"146666203211720510.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/146666203221524412.jpg\\\" style=\\\"\\\" title=\\\"146666203221524412.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/146666203210329311.jpg\\\" style=\\\"\\\" title=\\\"146666203210329311.jpg\\\"/></p><p><br/></p>', '1', '6', '0.02', '0', '0.01', '70', '5', '1', '0', '0', '2016-06-23 14:07:48');
INSERT INTO `goods` VALUES ('557', '17', '地中海卧室玄关五斗柜 做旧美式乡村艺术储物柜 欧式板木收纳柜', '', '欧菲曼', '广东中山', '', '', '<p><img src=\\\"/pic/upload/image/20160623/14666624385017933.jpg\\\" style=\\\"\\\" title=\\\"14666624385017933.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/14666624421365092.jpg\\\" style=\\\"\\\" title=\\\"14666624421365092.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/14666624422569424.jpg\\\" style=\\\"\\\" title=\\\"14666624422569424.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/14666624452372345.jpg\\\" style=\\\"\\\" title=\\\"14666624452372345.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/14666624451119381.jpg\\\" style=\\\"\\\" title=\\\"14666624451119381.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/14666624467918276.jpg\\\" style=\\\"\\\" title=\\\"14666624467918276.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/14666624505936237.jpg\\\" style=\\\"\\\" title=\\\"14666624505936237.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/146666245868958410.jpg\\\" style=\\\"\\\" title=\\\"146666245868958410.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/14666624641187289.jpg\\\" style=\\\"\\\" title=\\\"14666624641187289.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/146666246794390211.jpg\\\" style=\\\"\\\" title=\\\"146666246794390211.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/14666624693315168.jpg\\\" style=\\\"\\\" title=\\\"14666624693315168.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/146666247112264012.jpg\\\" style=\\\"\\\" title=\\\"146666247112264012.jpg\\\"/></p><p><br/></p>', '1', '10', '0.02', '0', '0.01', '66', '6', '1', '0', '0', '2016-06-23 14:15:56');
INSERT INTO `goods` VALUES ('558', '17', '设计师真皮沙发组合创意简约现代皮沙发头层牛皮转角个性皮艺沙发', '', '欧菲曼', '广东中山', '', '', '<p><img src=\\\"/pic/upload/image/20160623/14666630101039213.jpg\\\" style=\\\"\\\" title=\\\"14666630101039213.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/14666630138509532.jpg\\\" style=\\\"\\\" title=\\\"14666630138509532.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/14666630181398534.jpg\\\" style=\\\"\\\" title=\\\"14666630181398534.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/14666630203282036.jpg\\\" style=\\\"\\\" title=\\\"14666630203282036.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/14666630214773515.jpg\\\" style=\\\"\\\" title=\\\"14666630214773515.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/14666630271391947.jpg\\\" style=\\\"\\\" title=\\\"14666630271391947.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/14666630271198048.jpg\\\" style=\\\"\\\" title=\\\"14666630271198048.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/14666630384386229.jpg\\\" style=\\\"\\\" title=\\\"14666630384386229.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/146666303883339610.jpg\\\" style=\\\"\\\" title=\\\"146666303883339610.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/146666304340996311.jpg\\\" style=\\\"\\\" title=\\\"146666304340996311.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/146666304712343613.jpg\\\" style=\\\"\\\" title=\\\"146666304712343613.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/146666304910335814.jpg\\\" style=\\\"\\\" title=\\\"146666304910335814.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/146666305322019312.jpg\\\" style=\\\"\\\" title=\\\"146666305322019312.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/146666305841482615.jpg\\\" style=\\\"\\\" title=\\\"146666305841482615.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/146666306013578617.jpg\\\" style=\\\"\\\" title=\\\"146666306013578617.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/146666306538728716.jpg\\\" style=\\\"\\\" title=\\\"146666306538728716.jpg\\\"/></p><p><br/></p>', '1', '20', '0.02', '0', '0.01', '75', '6', '1', '0', '0', '2016-06-23 15:16:16');
INSERT INTO `goods` VALUES ('559', '17', '美式乡村 地中海6斗餐桌 欧式韩式北欧板木 艺术做旧 出口品质', '', '欧菲曼', '广东中山', '', '', '<p><img src=\\\"/pic/upload/image/20160623/14666664038558162.jpg\\\" style=\\\"\\\" title=\\\"14666664038558162.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/14666664051262893.jpg\\\" style=\\\"\\\" title=\\\"14666664051262893.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/14666664119218264.jpg\\\" style=\\\"\\\" title=\\\"14666664119218264.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/14666664116400545.jpg\\\" style=\\\"\\\" title=\\\"14666664116400545.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/14666664131017311.jpg\\\" style=\\\"\\\" title=\\\"14666664131017311.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/14666664161669636.jpg\\\" style=\\\"\\\" title=\\\"14666664161669636.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/14666664167464297.jpg\\\" style=\\\"\\\" title=\\\"14666664167464297.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/14666664181034398.jpg\\\" style=\\\"\\\" title=\\\"14666664181034398.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/146666641923202710.jpg\\\" style=\\\"\\\" title=\\\"146666641923202710.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/14666664201298019.jpg\\\" style=\\\"\\\" title=\\\"14666664201298019.jpg\\\"/></p><p><br/></p>', '1', '10', '0.02', '0', '0.01', '100', '6', '1', '0', '0', '2016-06-23 15:23:55');
INSERT INTO `goods` VALUES ('560', '17', '欧菲曼美式乡村复古做旧彩绘酒柜地中海餐边柜欧式田园家具', '', '欧菲曼', '广东中山', '', '', '<p><img src=\\\"/pic/upload/image/20160623/14666670416050262.jpg\\\" style=\\\"\\\" title=\\\"14666670416050262.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/14666670412297891.jpg\\\" style=\\\"\\\" title=\\\"14666670412297891.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/14666670431393453.jpg\\\" style=\\\"\\\" title=\\\"14666670431393453.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/14666670451374006.jpg\\\" style=\\\"\\\" title=\\\"14666670451374006.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/14666670473874584.jpg\\\" style=\\\"\\\" title=\\\"14666670473874584.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/14666670507509907.jpg\\\" style=\\\"\\\" title=\\\"14666670507509907.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/14666670571360928.jpg\\\" style=\\\"\\\" title=\\\"14666670571360928.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/14666670625000299.jpg\\\" style=\\\"\\\" title=\\\"14666670625000299.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/14666670651260745.jpg\\\" style=\\\"\\\" title=\\\"14666670651260745.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/146666706938315410.jpg\\\" style=\\\"\\\" title=\\\"146666706938315410.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/146666706977216211.jpg\\\" style=\\\"\\\" title=\\\"146666706977216211.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/146666707830018912.jpg\\\" style=\\\"\\\" title=\\\"146666707830018912.jpg\\\"/></p><p><br/></p>', '1', '10', '0.02', '0', '0.01', '118', '6', '1', '0', '0', '2016-06-23 15:32:10');
INSERT INTO `goods` VALUES ('561', '18', '设计调性布艺沙发组合北欧宜家纯实木布沙发小户型三人可拆洗沙发', '', '纳美格调', '广东佛山', '', '', '<p><img src=\\\"/pic/upload/image/20160623/14666682404684431.jpg\\\" style=\\\"\\\" title=\\\"14666682404684431.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/14666682421094083.jpg\\\" style=\\\"\\\" title=\\\"14666682421094083.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/14666682423905564.jpg\\\" style=\\\"\\\" title=\\\"14666682423905564.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/14666682467462575.jpg\\\" style=\\\"\\\" title=\\\"14666682467462575.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/14666682471400686.jpg\\\" style=\\\"\\\" title=\\\"14666682471400686.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/14666682511096667.jpg\\\" style=\\\"\\\" title=\\\"14666682511096667.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/14666682511311952.jpg\\\" style=\\\"\\\" title=\\\"14666682511311952.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/14666682514783418.jpg\\\" style=\\\"\\\" title=\\\"14666682514783418.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/146666825510502311.jpg\\\" style=\\\"\\\" title=\\\"146666825510502311.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/14666682551033199.jpg\\\" style=\\\"\\\" title=\\\"14666682551033199.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/146666825820207713.jpg\\\" style=\\\"\\\" title=\\\"146666825820207713.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/146666825811574610.jpg\\\" style=\\\"\\\" title=\\\"146666825811574610.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/146666826031671315.jpg\\\" style=\\\"\\\" title=\\\"146666826031671315.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/146666826411981716.jpg\\\" style=\\\"\\\" title=\\\"146666826411981716.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/146666826413864814.jpg\\\" style=\\\"\\\" title=\\\"146666826413864814.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/146666826548109512.jpg\\\" style=\\\"\\\" title=\\\"146666826548109512.jpg\\\"/></p><p><br/></p>', '1', '10', '0.02', '0', '0.01', '78', '5', '1', '0', '0', '2016-06-23 15:51:27');
INSERT INTO `goods` VALUES ('562', '18', '设计师韩式创意时尚小户型茶几新北欧日式茶几 多功能储物箱小桌', '', '纳美', '广州', '', '', '<p><img src=\\\"/pic/upload/image/20160623/14666685851201273.jpg\\\" style=\\\"\\\" title=\\\"14666685851201273.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/14666685892961444.jpg\\\" style=\\\"\\\" title=\\\"14666685892961444.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/14666685906755552.jpg\\\" style=\\\"\\\" title=\\\"14666685906755552.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/14666685942419671.jpg\\\" style=\\\"\\\" title=\\\"14666685942419671.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/14666685961893395.jpg\\\" style=\\\"\\\" title=\\\"14666685961893395.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/14666686014795896.jpg\\\" style=\\\"\\\" title=\\\"14666686014795896.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/14666686035155638.jpg\\\" style=\\\"\\\" title=\\\"14666686035155638.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/14666686072927459.jpg\\\" style=\\\"\\\" title=\\\"14666686072927459.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/146666860892690410.jpg\\\" style=\\\"\\\" title=\\\"146666860892690410.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/14666686083502787.jpg\\\" style=\\\"\\\" title=\\\"14666686083502787.jpg\\\"/></p><p><br/></p>', '1', '5', '0.02', '0', '0.01', '92', '6', '1', '0', '0', '2016-06-23 15:57:07');
INSERT INTO `goods` VALUES ('563', '18', '设计师创意北欧电视柜胡桃木纹风格韩式简约电视柜电视墙柜组合', '', '纳美', '广东', '', '', '<p><img src=\\\"/pic/upload/image/20160623/14666689758589141.jpg\\\" style=\\\"\\\" title=\\\"14666689758589141.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/14666689811802172.jpg\\\" style=\\\"\\\" title=\\\"14666689811802172.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/14666689871176353.jpg\\\" style=\\\"\\\" title=\\\"14666689871176353.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/14666689897183724.jpg\\\" style=\\\"\\\" title=\\\"14666689897183724.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/14666689913990765.jpg\\\" style=\\\"\\\" title=\\\"14666689913990765.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/14666690029504857.jpg\\\" style=\\\"\\\" title=\\\"14666690029504857.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/14666690039355968.jpg\\\" style=\\\"\\\" title=\\\"14666690039355968.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/14666690088993646.jpg\\\" style=\\\"\\\" title=\\\"14666690088993646.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/146666901284751010.jpg\\\" style=\\\"\\\" title=\\\"146666901284751010.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/146666901226559211.jpg\\\" style=\\\"\\\" title=\\\"146666901226559211.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/14666690138154529.jpg\\\" style=\\\"\\\" title=\\\"14666690138154529.jpg\\\"/></p><p><br/></p>', '1', '6', '0.02', '0', '0.01', '83', '7', '1', '0', '0', '2016-06-23 16:03:47');
INSERT INTO `goods` VALUES ('564', '18', '北欧家具榉木真皮床1.8米设计师创意实木皮床双人婚床宜家皮艺床', '', '纳美', '广东', '', '', '<p><img src=\\\"/pic/upload/image/20160623/14666694176472841.jpg\\\" style=\\\"\\\" title=\\\"14666694176472841.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/14666694319030644.jpg\\\" style=\\\"\\\" title=\\\"14666694319030644.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/14666694321307092.jpg\\\" style=\\\"\\\" title=\\\"14666694321307092.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/14666694321102303.jpg\\\" style=\\\"\\\" title=\\\"14666694321102303.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/14666694357166516.jpg\\\" style=\\\"\\\" title=\\\"14666694357166516.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/14666694426057587.jpg\\\" style=\\\"\\\" title=\\\"14666694426057587.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/14666694432867635.jpg\\\" style=\\\"\\\" title=\\\"14666694432867635.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/14666694499920548.jpg\\\" style=\\\"\\\" title=\\\"14666694499920548.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/146666945811734310.jpg\\\" style=\\\"\\\" title=\\\"146666945811734310.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/14666694609502709.jpg\\\" style=\\\"\\\" title=\\\"14666694609502709.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/146666946712584211.jpg\\\" style=\\\"\\\" title=\\\"146666946712584211.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/146666946980465113.jpg\\\" style=\\\"\\\" title=\\\"146666946980465113.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/146666946921782612.jpg\\\" style=\\\"\\\" title=\\\"146666946921782612.jpg\\\"/></p><p><br/></p>', '1', '20', '0.02', '0', '0.01', '55', '8', '1', '0', '0', '2016-06-23 16:11:25');
INSERT INTO `goods` VALUES ('565', '18', '北欧实木餐桌椅组合 简约韩式小户型宜家长方形胡桃木纹饭桌餐台', '', '纳美', '广东', '', '', '<p><img src=\\\"/pic/upload/image/20160623/14666697021002641.jpg\\\" style=\\\"\\\" title=\\\"14666697021002641.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/14666697035423723.jpg\\\" style=\\\"\\\" title=\\\"14666697035423723.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/14666697148670042.jpg\\\" style=\\\"\\\" title=\\\"14666697148670042.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/14666697171301625.jpg\\\" style=\\\"\\\" title=\\\"14666697171301625.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/14666697187708284.jpg\\\" style=\\\"\\\" title=\\\"14666697187708284.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/14666697274221416.jpg\\\" style=\\\"\\\" title=\\\"14666697274221416.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/14666697291058669.jpg\\\" style=\\\"\\\" title=\\\"14666697291058669.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/14666697293183497.jpg\\\" style=\\\"\\\" title=\\\"14666697293183497.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/146666973121614811.jpg\\\" style=\\\"\\\" title=\\\"146666973121614811.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/146666973240931810.jpg\\\" style=\\\"\\\" title=\\\"146666973240931810.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/146666973480095012.jpg\\\" style=\\\"\\\" title=\\\"146666973480095012.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/14666697365979698.jpg\\\" style=\\\"\\\" title=\\\"14666697365979698.jpg\\\"/></p><p><br/></p>', '1', '10', '0.02', '0', '0.01', '103', '5', '1', '0', '1', '2016-06-23 16:18:56');
INSERT INTO `goods` VALUES ('566', '18', '欧式风格 高档绗缝布艺 椅垫 椅背巾 ', '', '三南', '广东佛山', '', '', null, '1', '3', '589.00', '0', '699.00', '99', '6', '1', '0', '0', '2016-06-23 16:39:41');
INSERT INTO `goods` VALUES ('567', '18', '欧式风格 高档绗缝布艺 椅垫 椅背巾 ', '', '三南', '广东佛山', '', '', '<p><img src=\\\"/pic/upload/image/20160623/14666711361100493.jpg\\\" style=\\\"\\\" title=\\\"14666711361100493.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/14666711368232414.jpg\\\" style=\\\"\\\" title=\\\"14666711368232414.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/14666711363759252.jpg\\\" style=\\\"\\\" title=\\\"14666711363759252.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/14666711415290757.jpg\\\" style=\\\"\\\" title=\\\"14666711415290757.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/14666711426520605.jpg\\\" style=\\\"\\\" title=\\\"14666711426520605.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/14666711421187846.jpg\\\" style=\\\"\\\" title=\\\"14666711421187846.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/14666711449431708.jpg\\\" style=\\\"\\\" title=\\\"14666711449431708.jpg\\\"/></p><p><br/></p>', '1', '3', '0.02', '0', '0.01', '99', '6', '1', '0', '1', '2016-06-23 16:39:57');
INSERT INTO `goods` VALUES ('568', '18', '现代风格 休闲藤椅 含坐垫吊椅 金属架藤椅', '', '蒂美悦', '浙江', '', '', null, '1', '20', '0.02', '0', '0.01', '111', '6', '1', '0', '0', '2016-06-23 16:44:53');
INSERT INTO `goods` VALUES ('569', '18', '现代风格 休闲藤椅 含坐垫吊椅 金属架藤椅', '', '蒂美悦', '浙江', '', '', '<p><img src=\\\"/pic/upload/image/20160623/14666714518177322.jpg\\\" style=\\\"\\\" title=\\\"14666714518177322.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/14666714527083034.jpg\\\" style=\\\"\\\" title=\\\"14666714527083034.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/14666714549743253.jpg\\\" style=\\\"\\\" title=\\\"14666714549743253.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/14666714591247576.jpg\\\" style=\\\"\\\" title=\\\"14666714591247576.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/14666714591403055.jpg\\\" style=\\\"\\\" title=\\\"14666714591403055.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/14666714617371347.jpg\\\" style=\\\"\\\" title=\\\"14666714617371347.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/14666714647671279.jpg\\\" style=\\\"\\\" title=\\\"14666714647671279.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/146667146587126410.jpg\\\" style=\\\"\\\" title=\\\"146667146587126410.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/14666714665030418.jpg\\\" style=\\\"\\\" title=\\\"14666714665030418.jpg\\\"/></p><p><br/></p>', '1', '20', '0.02', '0', '0.01', '111', '6', '1', '0', '1', '2016-06-23 16:45:30');
INSERT INTO `goods` VALUES ('570', '18', ' 韩式田园 实木书柜', '', '韩菲尔', '广东', '', '', '<p><img src=\\\"/pic/upload/image/20160623/14666719341073212.jpg\\\" style=\\\"\\\" title=\\\"14666719341073212.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/14666719345766684.jpg\\\" style=\\\"\\\" title=\\\"14666719345766684.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/14666719391073213.jpg\\\" style=\\\"\\\" title=\\\"14666719391073213.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/14666719405220615.jpg\\\" style=\\\"\\\" title=\\\"14666719405220615.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/14666719454629357.jpg\\\" style=\\\"\\\" title=\\\"14666719454629357.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/14666719478725556.jpg\\\" style=\\\"\\\" title=\\\"14666719478725556.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/14666719485123368.jpg\\\" style=\\\"\\\" title=\\\"14666719485123368.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/14666719492753609.jpg\\\" style=\\\"\\\" title=\\\"14666719492753609.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/146667195110334511.jpg\\\" style=\\\"\\\" title=\\\"146667195110334511.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/146667195712914210.jpg\\\" style=\\\"\\\" title=\\\"146667195712914210.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/146667195953763912.jpg\\\" style=\\\"\\\" title=\\\"146667195953763912.jpg\\\"/></p><p><br/></p>', '1', '20', '0.02', '0', '0.01', '127', '5', '1', '0', '0', '2016-06-23 16:53:19');
INSERT INTO `goods` VALUES ('571', '18', '地中海风格 美国白杨木框架床 清新双色搭配床板条床 ', '', '彼岸阳光', '上海', '', '', null, '1', '20', '0.02', '0', '0.01', '58', '6', '1', '0', '0', '2016-06-23 17:00:44');
INSERT INTO `goods` VALUES ('572', '18', '地中海风格 美国白杨木框架床 清新双色搭配床板条床 ', '', '彼岸阳光', '上海', '', '', '<p><br/></p><p><img src=\\\"/pic/upload/image/20160623/14666723696728872.jpg\\\" style=\\\"\\\" title=\\\"14666723696728872.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/14666723701305583.jpg\\\" style=\\\"\\\" title=\\\"14666723701305583.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/14666723721319134.jpg\\\" style=\\\"\\\" title=\\\"14666723721319134.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/14666723752845696.jpg\\\" style=\\\"\\\" title=\\\"14666723752845696.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/14666723752523385.jpg\\\" style=\\\"\\\" title=\\\"14666723752523385.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/14666723788907149.jpg\\\" style=\\\"\\\" title=\\\"14666723788907149.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/14666723791283208.jpg\\\" style=\\\"\\\" title=\\\"14666723791283208.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/14666723797722917.jpg\\\" style=\\\"\\\" title=\\\"14666723797722917.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/146667238113915110.jpg\\\" style=\\\"\\\" title=\\\"146667238113915110.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160623/146667238545927811.jpg\\\" style=\\\"\\\" title=\\\"146667238545927811.jpg\\\"/></p><p><br/></p>', '1', '20', '0.02', '0', '0.01', '58', '6', '1', '0', '1', '2016-06-23 17:01:02');
INSERT INTO `goods` VALUES ('573', '8', '现代风格 人气爆款 可拆卸靠包 精选头层珠光真皮1.8米床 ', '', '卡富亚', '广东佛山', '', '', '<p><img src=\\\"/pic/upload/image/20160624/14667345165187052.jpg\\\" style=\\\"\\\" title=\\\"14667345165187052.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667345193343993.jpg\\\" style=\\\"\\\" title=\\\"14667345193343993.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667345223708044.jpg\\\" style=\\\"\\\" title=\\\"14667345223708044.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667345243802286.jpg\\\" style=\\\"\\\" title=\\\"14667345243802286.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667345247911395.jpg\\\" style=\\\"\\\" title=\\\"14667345247911395.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667345301631339.jpg\\\" style=\\\"\\\" title=\\\"14667345301631339.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667345324255848.jpg\\\" style=\\\"\\\" title=\\\"14667345324255848.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667345357624807.jpg\\\" style=\\\"\\\" title=\\\"14667345357624807.jpg\\\"/></p><p><br/></p>', '1', '20', '0.02', '0', '0.01', '55', '5', '1', '0', '0', '2016-06-24 10:16:26');
INSERT INTO `goods` VALUES ('574', '8', ' 美式古典 传承经典 返璞归真 复古大气雕花 天然木纹1.8米床板条床', '', '凯撒豪庭', '广东佛山', '', '', '<p><img src=\\\"/pic/upload/image/20160624/14667348132318984.jpg\\\" style=\\\"\\\" title=\\\"14667348132318984.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667348131768173.jpg\\\" style=\\\"\\\" title=\\\"14667348131768173.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667348165221042.jpg\\\" style=\\\"\\\" title=\\\"14667348165221042.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667348201192416.jpg\\\" style=\\\"\\\" title=\\\"14667348201192416.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667348241386097.jpg\\\" style=\\\"\\\" title=\\\"14667348241386097.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667348271289278.jpg\\\" style=\\\"\\\" title=\\\"14667348271289278.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667348303529039.jpg\\\" style=\\\"\\\" title=\\\"14667348303529039.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/146673483059297710.jpg\\\" style=\\\"\\\" title=\\\"146673483059297710.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/146673483480327411.jpg\\\" style=\\\"\\\" title=\\\"146673483480327411.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667348543986035.jpg\\\" style=\\\"\\\" title=\\\"14667348543986035.jpg\\\"/></p><p><br/></p>', '1', '20', '0.02', '0', '0.01', '58', '6', '1', '0', '0', '2016-06-24 10:22:11');
INSERT INTO `goods` VALUES ('575', '8', ' 欧式简约 店长力荐 方中带圆对称式设计 1.5米纯色环保床板床 ', '', '简欧•安娜', '广东佛山', '', '', '<p>						</p><p><img src=\\\"/pic/upload/image/20160624/14667351451345941.jpg\\\" style=\\\"\\\" title=\\\"14667351451345941.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667351491023163.jpg\\\" style=\\\"\\\" title=\\\"14667351491023163.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667351531050495.jpg\\\" style=\\\"\\\" title=\\\"14667351531050495.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667351531303862.jpg\\\" style=\\\"\\\" title=\\\"14667351531303862.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667351559669244.jpg\\\" style=\\\"\\\" title=\\\"14667351559669244.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667351571236736.jpg\\\" style=\\\"\\\" title=\\\"14667351571236736.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667351589778977.jpg\\\" style=\\\"\\\" title=\\\"14667351589778977.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667351615557128.jpg\\\" style=\\\"\\\" title=\\\"14667351615557128.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/146673516423443710.jpg\\\" style=\\\"\\\" title=\\\"146673516423443710.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667351661124899.jpg\\\" style=\\\"\\\" title=\\\"14667351661124899.jpg\\\"/></p><p><br/></p>', '1', '20', '1099.00', '0', '999.00', '58', '5', '1', '0', '0', '2016-06-24 10:27:23');
INSERT INTO `goods` VALUES ('576', '8', ' 欧式田园 质量PK王 全实木内架 纯手工红杨木雕花描金点缀 内置进口弹簧L型转角沙发', '', '领美', '广东佛山', '', '', null, '1', '15', '0.02', '0', '0.01', '82', '5', '1', '0', '0', '2016-06-24 10:33:17');
INSERT INTO `goods` VALUES ('577', '8', ' 欧式田园 质量PK王 全实木内架 纯手工红杨木雕花描金点缀 内置进口弹簧L型转角沙发', '', '领美', '广东佛山', '', '', '<p><img src=\\\"/pic/upload/image/20160624/146673544011719712.jpg\\\" style=\\\"\\\" title=\\\"146673544011719712.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/146673545514243511.jpg\\\" style=\\\"\\\" title=\\\"146673545514243511.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/146673546078322114.jpg\\\" style=\\\"\\\" title=\\\"146673546078322114.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/146673546766376515.jpg\\\" style=\\\"\\\" title=\\\"146673546766376515.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/146673547811363416.jpg\\\" style=\\\"\\\" title=\\\"146673547811363416.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/146673547981239617.jpg\\\" style=\\\"\\\" title=\\\"146673547981239617.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/146673549265911718.jpg\\\" style=\\\"\\\" title=\\\"146673549265911718.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/146673549610965713.jpg\\\" style=\\\"\\\" title=\\\"146673549610965713.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/146673550793680121.jpg\\\" style=\\\"\\\" title=\\\"146673550793680121.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/146673551273648822.jpg\\\" style=\\\"\\\" title=\\\"146673551273648822.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/146673551510078419.jpg\\\" style=\\\"\\\" title=\\\"146673551510078419.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/146673552010052220.jpg\\\" style=\\\"\\\" title=\\\"146673552010052220.jpg\\\"/></p><p><br/></p>', '1', '15', '0.02', '0', '0.01', '82', '5', '1', '0', '1', '2016-06-24 10:33:37');
INSERT INTO `goods` VALUES ('578', '8', '地中海风格 上等白杨实木框架 储物收纳L型沙发 清新双色拼接转角沙发', '', '彼岸阳光', '广东佛山', '', '', '<p><img src=\\\"/pic/upload/image/20160624/14667357884243792.jpg\\\" style=\\\"\\\" title=\\\"14667357884243792.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667357911310403.jpg\\\" style=\\\"\\\" title=\\\"14667357911310403.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667357941404044.jpg\\\" style=\\\"\\\" title=\\\"14667357941404044.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667357947085185.jpg\\\" style=\\\"\\\" title=\\\"14667357947085185.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667357994469287.jpg\\\" style=\\\"\\\" title=\\\"14667357994469287.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667358005476658.jpg\\\" style=\\\"\\\" title=\\\"14667358005476658.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667358024083716.jpg\\\" style=\\\"\\\" title=\\\"14667358024083716.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667358041823259.jpg\\\" style=\\\"\\\" title=\\\"14667358041823259.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/146673580715835611.jpg\\\" style=\\\"\\\" title=\\\"146673580715835611.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/146673581165950512.jpg\\\" style=\\\"\\\" title=\\\"146673581165950512.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/146673581355437813.jpg\\\" style=\\\"\\\" title=\\\"146673581355437813.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/146673581741224414.jpg\\\" style=\\\"\\\" title=\\\"146673581741224414.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/146673581944654015.jpg\\\" style=\\\"\\\" title=\\\"146673581944654015.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/146673581934012310.jpg\\\" style=\\\"\\\" title=\\\"146673581934012310.jpg\\\"/></p><p><br/></p>', '1', '15', '0.02', '0', '0.01', '78', '6', '1', '0', '0', '2016-06-24 10:39:07');
INSERT INTO `goods` VALUES ('579', '8', ' 现代风格 名流之选 巴西进口头层黄牛皮 五档调节头枕左转角沙发（1+3+左贵妃） ', '', '凯撒豪庭', '广东佛山', '', '', '<p><img src=\\\"/pic/upload/image/20160624/14667361914044983.jpg\\\" style=\\\"\\\" title=\\\"14667361914044983.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667361931135732.jpg\\\" style=\\\"\\\" title=\\\"14667361931135732.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667361963600464.jpg\\\" style=\\\"\\\" title=\\\"14667361963600464.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667361978046945.jpg\\\" style=\\\"\\\" title=\\\"14667361978046945.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667362007520666.jpg\\\" style=\\\"\\\" title=\\\"14667362007520666.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667362027536587.jpg\\\" style=\\\"\\\" title=\\\"14667362027536587.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667362035347981.jpg\\\" style=\\\"\\\" title=\\\"14667362035347981.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667362072731228.jpg\\\" style=\\\"\\\" title=\\\"14667362072731228.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/146673621110548310.jpg\\\" style=\\\"\\\" title=\\\"146673621110548310.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/146673621661595611.jpg\\\" style=\\\"\\\" title=\\\"146673621661595611.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667362171164919.jpg\\\" style=\\\"\\\" title=\\\"14667362171164919.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/146673621811673612.jpg\\\" style=\\\"\\\" title=\\\"146673621811673612.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/146673621913070921.jpg\\\" style=\\\"\\\" title=\\\"146673621913070921.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/146673622560575822.jpg\\\" style=\\\"\\\" title=\\\"146673622560575822.jpg\\\"/></p><p><br/></p>', '1', '15', '0.02', '0', '0.01', '75', '7', '0', '0', '0', '2016-06-24 10:44:25');
INSERT INTO `goods` VALUES ('580', '8', '美式古典 王室贡品 白杨树榴木皮餐桌 转盘可卸式1.3米圆餐桌 ', '', '凯撒豪庭', '广东佛山', '', '', '<p><img src=\\\"/pic/upload/image/20160624/14667364701011634.jpg\\\" style=\\\"\\\" title=\\\"14667364701011634.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667364706743082.jpg\\\" style=\\\"\\\" title=\\\"14667364706743082.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667364728862823.jpg\\\" style=\\\"\\\" title=\\\"14667364728862823.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667364758093415.jpg\\\" style=\\\"\\\" title=\\\"14667364758093415.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667364795027836.jpg\\\" style=\\\"\\\" title=\\\"14667364795027836.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667364821308259.jpg\\\" style=\\\"\\\" title=\\\"14667364821308259.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667364831153508.jpg\\\" style=\\\"\\\" title=\\\"14667364831153508.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667364841089007.jpg\\\" style=\\\"\\\" title=\\\"14667364841089007.jpg\\\"/></p><p><br/></p>', '1', '16', '0.02', '0', '0.01', '101', '5', '1', '0', '0', '2016-06-24 10:50:19');
INSERT INTO `goods` VALUES ('581', '8', ' 英式风格 火爆热销款 罗马立柱式支撑脚 纯色餐厅5套装（1桌+4椅） ', '', '韩菲尔', '广东佛山', '', '', '<p><img src=\\\"/pic/upload/image/20160624/14667368346885094.jpg\\\" style=\\\"\\\" title=\\\"14667368346885094.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667368356378603.jpg\\\" style=\\\"\\\" title=\\\"14667368356378603.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667368416725862.jpg\\\" style=\\\"\\\" title=\\\"14667368416725862.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667368458398515.jpg\\\" style=\\\"\\\" title=\\\"14667368458398515.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667368491457918.jpg\\\" style=\\\"\\\" title=\\\"14667368491457918.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667368571061036.jpg\\\" style=\\\"\\\" title=\\\"14667368571061036.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667368575662987.jpg\\\" style=\\\"\\\" title=\\\"14667368575662987.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/146673686230957010.jpg\\\" style=\\\"\\\" title=\\\"146673686230957010.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/146673686690018112.jpg\\\" style=\\\"\\\" title=\\\"146673686690018112.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/146673686771777013.jpg\\\" style=\\\"\\\" title=\\\"146673686771777013.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/146673686814884611.jpg\\\" style=\\\"\\\" title=\\\"146673686814884611.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667368975348429.jpg\\\" style=\\\"\\\" title=\\\"14667368975348429.jpg\\\"/></p><p><br/></p>', '1', '15', '0.02', '0', '0.01', '100', '6', '1', '0', '0', '2016-06-24 10:55:50');
INSERT INTO `goods` VALUES ('582', '8', '韩式田园 实用的木质餐边柜 板式餐边柜 白色餐边柜', '', '韩菲尔', '广东佛山', '', '', '<p>						</p><p><img src=\\\"/pic/upload/image/20160624/14667372429068942.jpg\\\" style=\\\"\\\" title=\\\"14667372429068942.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667372441358723.jpg\\\" style=\\\"\\\" title=\\\"14667372441358723.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667372481225244.jpg\\\" style=\\\"\\\" title=\\\"14667372481225244.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667372511397626.jpg\\\" style=\\\"\\\" title=\\\"14667372511397626.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667372563498485.jpg\\\" style=\\\"\\\" title=\\\"14667372563498485.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667372611056431.jpg\\\" style=\\\"\\\" title=\\\"14667372611056431.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667372637706567.jpg\\\" style=\\\"\\\" title=\\\"14667372637706567.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667372647990578.jpg\\\" style=\\\"\\\" title=\\\"14667372647990578.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667372647912689.jpg\\\" style=\\\"\\\" title=\\\"14667372647912689.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/146673726912993410.jpg\\\" style=\\\"\\\" title=\\\"146673726912993410.jpg\\\"/></p><p><br/></p>', '1', '15', '1699.00', '0', '1399.00', '118', '6', '1', '0', '0', '2016-06-24 11:02:02');
INSERT INTO `goods` VALUES ('583', '8', ' 现代风格 白色转角旋转书桌书架组合 时尚个性书桌', '', '蒂美悦', '广东佛山', '', '', '<p>						</p><p><img src=\\\"/pic/upload/image/20160624/14667375177523672.jpg\\\" style=\\\"\\\" title=\\\"14667375177523672.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667375182252283.jpg\\\" style=\\\"\\\" title=\\\"14667375182252283.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667375228996226.jpg\\\" style=\\\"\\\" title=\\\"14667375228996226.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667375247125634.jpg\\\" style=\\\"\\\" title=\\\"14667375247125634.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667375269828457.jpg\\\" style=\\\"\\\" title=\\\"14667375269828457.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667375271459635.jpg\\\" style=\\\"\\\" title=\\\"14667375271459635.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667375311040599.jpg\\\" style=\\\"\\\" title=\\\"14667375311040599.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667375351104588.jpg\\\" style=\\\"\\\" title=\\\"14667375351104588.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/146673754263256710.jpg\\\" style=\\\"\\\" title=\\\"146673754263256710.jpg\\\"/></p><p><br/></p>', '1', '10', '2099.00', '0', '1999.00', '126', '8', '1', '0', '0', '2016-06-24 11:06:53');
INSERT INTO `goods` VALUES ('584', '8', '韩式田园 实木书柜', '', '韩菲尔', '广东佛山', '', '', '<p><img src=\\\"/pic/upload/image/20160624/14667377766766313.jpg\\\" style=\\\"\\\" title=\\\"14667377766766313.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667377788911022.jpg\\\" style=\\\"\\\" title=\\\"14667377788911022.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667377807027084.jpg\\\" style=\\\"\\\" title=\\\"14667377807027084.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667377849529816.jpg\\\" style=\\\"\\\" title=\\\"14667377849529816.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667377861189828.jpg\\\" style=\\\"\\\" title=\\\"14667377861189828.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667377892342659.jpg\\\" style=\\\"\\\" title=\\\"14667377892342659.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667377906256395.jpg\\\" style=\\\"\\\" title=\\\"14667377906256395.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667377927528847.jpg\\\" style=\\\"\\\" title=\\\"14667377927528847.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/146673779961010410.jpg\\\" style=\\\"\\\" title=\\\"146673779961010410.jpg\\\"/></p><p><br/></p>', '1', '10', '0.02', '0', '0.01', '127', '6', '0', '0', '0', '2016-06-24 11:10:40');
INSERT INTO `goods` VALUES ('585', '8', '欧式简约 简朴大方 免漆不褪色 玫瑰金拉手 环保吸塑工艺组合柜 ', '', '简欧•安娜', '广东佛山', '', '', '<p><img src=\\\"/pic/upload/image/20160624/14667380267236221.jpg\\\" style=\\\"\\\" title=\\\"14667380267236221.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667380292568132.jpg\\\" style=\\\"\\\" title=\\\"14667380292568132.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667380324453353.jpg\\\" style=\\\"\\\" title=\\\"14667380324453353.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667380331142144.jpg\\\" style=\\\"\\\" title=\\\"14667380331142144.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667380371407356.jpg\\\" style=\\\"\\\" title=\\\"14667380371407356.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667380391606805.jpg\\\" style=\\\"\\\" title=\\\"14667380391606805.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667380397744857.jpg\\\" style=\\\"\\\" title=\\\"14667380397744857.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667380452495418.jpg\\\" style=\\\"\\\" title=\\\"14667380452495418.jpg\\\"/></p><p><br/></p>', '1', '10', '0.02', '0', '0.01', '127', '9', '1', '0', '0', '2016-06-24 11:14:55');
INSERT INTO `goods` VALUES ('586', '8', '九牧节水静音喷射虹吸式抽水马桶11173', '', 'JOMOO九牧', '广东佛山', '', '', '<p><img src=\\\"/pic/upload/image/20160624/14667384519582743.jpg\\\" style=\\\"\\\" title=\\\"14667384519582743.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667384536741784.jpg\\\" style=\\\"\\\" title=\\\"14667384536741784.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667384541302785.jpg\\\" style=\\\"\\\" title=\\\"14667384541302785.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667384599747552.jpg\\\" style=\\\"\\\" title=\\\"14667384599747552.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667384658594306.jpg\\\" style=\\\"\\\" title=\\\"14667384658594306.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667384651336828.jpg\\\" style=\\\"\\\" title=\\\"14667384651336828.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667384651198397.jpg\\\" style=\\\"\\\" title=\\\"14667384651198397.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/146673847744753010.jpg\\\" style=\\\"\\\" title=\\\"146673847744753010.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667384791123349.jpg\\\" style=\\\"\\\" title=\\\"14667384791123349.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/146673848513894911.jpg\\\" style=\\\"\\\" title=\\\"146673848513894911.jpg\\\"/></p><p><br/></p>', '1', '10', '0.02', '0', '0.01', '206', '6', '1', '0', '0', '2016-06-24 11:22:06');
INSERT INTO `goods` VALUES ('587', '8', '全铜纯白8寸大顶喷时尚升降花洒套装', '', '卓美欧', '广东佛山', '', '', null, '1', '5', '289.00', '0', '239.00', '190', '6', '1', '0', '0', '2016-06-24 11:26:35');
INSERT INTO `goods` VALUES ('588', '8', '全铜纯白8寸大顶喷时尚升降花洒套装', '', '卓美欧', '广东佛山', '', '', null, '1', '5', '0.02', '0', '0.01', '190', '6', '1', '0', '1', '2016-06-24 11:26:36');
INSERT INTO `goods` VALUES ('589', '8', '全铜纯白8寸大顶喷时尚升降花洒套装', '', '卓美欧', '广东佛山', '', '', '<p><img src=\\\"/pic/upload/image/20160624/14667387181040032.jpg\\\" style=\\\"\\\" title=\\\"14667387181040032.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667387211339103.jpg\\\" style=\\\"\\\" title=\\\"14667387211339103.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667387285686646.jpg\\\" style=\\\"\\\" title=\\\"14667387285686646.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667387371323524.jpg\\\" style=\\\"\\\" title=\\\"14667387371323524.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667387393407685.jpg\\\" style=\\\"\\\" title=\\\"14667387393407685.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667387423488588.jpg\\\" style=\\\"\\\" title=\\\"14667387423488588.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667387441379169.jpg\\\" style=\\\"\\\" title=\\\"14667387441379169.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667387487759497.jpg\\\" style=\\\"\\\" title=\\\"14667387487759497.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/146673875312517510.jpg\\\" style=\\\"\\\" title=\\\"146673875312517510.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/146673875865042511.jpg\\\" style=\\\"\\\" title=\\\"146673875865042511.jpg\\\"/></p><p><br/></p>', '1', '5', '0.02', '0', '0.01', '190', '6', '1', '0', '1', '2016-06-24 11:26:52');
INSERT INTO `goods` VALUES ('590', '8', '进口橡木实木雕花浴室柜 黑金花天然大理石台面 93CM长实木浴室柜进口橡木实木雕花浴室柜 黑金花天然大理石台', '', '鸥达', '广东佛山', '', '', '<p>						</p><p><br/></p><p><img src=\\\"/pic/upload/image/20160624/14667390391428652.jpg\\\" style=\\\"\\\" title=\\\"14667390391428652.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667390431334584.jpg\\\" style=\\\"\\\" title=\\\"14667390431334584.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667390505588966.jpg\\\" style=\\\"\\\" title=\\\"14667390505588966.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667390549547035.jpg\\\" style=\\\"\\\" title=\\\"14667390549547035.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667390581189783.jpg\\\" style=\\\"\\\" title=\\\"14667390581189783.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667390623864257.jpg\\\" style=\\\"\\\" title=\\\"14667390623864257.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/146673906518675710.jpg\\\" style=\\\"\\\" title=\\\"146673906518675710.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667390719961859.jpg\\\" style=\\\"\\\" title=\\\"14667390719961859.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667391309871498.jpg\\\" style=\\\"\\\" title=\\\"14667391309871498.jpg\\\"/></p><p><br/></p>', '1', '20', '469.00', '0', '339.00', '210', '6', '1', '0', '0', '2016-06-24 11:33:05');
INSERT INTO `goods` VALUES ('591', '8', '欧式复古雕花象牙白室内房门锁 经典款式', '', 'KLC', '广东佛山', '', '', '<p><img src=\\\"/pic/upload/image/20160624/14667394791289231.jpg\\\" style=\\\"\\\" title=\\\"14667394791289231.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667394841132164.jpg\\\" style=\\\"\\\" title=\\\"14667394841132164.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667394885230082.jpg\\\" style=\\\"\\\" title=\\\"14667394885230082.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667394921018993.jpg\\\" style=\\\"\\\" title=\\\"14667394921018993.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667394959881817.jpg\\\" style=\\\"\\\" title=\\\"14667394959881817.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667394981272706.jpg\\\" style=\\\"\\\" title=\\\"14667394981272706.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667394994551908.jpg\\\" style=\\\"\\\" title=\\\"14667394994551908.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667395041126059.jpg\\\" style=\\\"\\\" title=\\\"14667395041126059.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/146673950410258710.jpg\\\" style=\\\"\\\" title=\\\"146673950410258710.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667395139492815.jpg\\\" style=\\\"\\\" title=\\\"14667395139492815.jpg\\\"/></p><p><br/></p>', '1', '3', '0.02', '0', '0.01', '228', '5', '1', '0', '0', '2016-06-24 11:39:15');
INSERT INTO `goods` VALUES ('592', '1', '真皮床简约现代实木软床双人床1.8米婚床主次卧室113', '真皮床113', 'KUKa/顾家家居', 'KUKa/顾家家居', '木', '馨奶白【床+排骨架', '<p><img src=\\\"/pic/upload/image/20160624/1466743774951002a1.jpg\\\" style=\\\"\\\" title=\\\"1466743774951002a1.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/1466743774407510a3.jpg\\\" style=\\\"\\\" title=\\\"1466743774407510a3.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/1466743777135511a2.jpg\\\" style=\\\"\\\" title=\\\"1466743777135511a2.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/1466743784803188a4.jpg\\\" style=\\\"\\\" title=\\\"1466743784803188a4.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/1466743786977380a5.jpg\\\" style=\\\"\\\" title=\\\"1466743786977380a5.jpg\\\"/></p><p><br/></p>', '3', '50', '5800.00', '0', '5300.00', '54', '300', '1', '0', '0', '2016-06-24 12:50:16');
INSERT INTO `goods` VALUES ('593', '8', '家用防盗门指纹锁智能密码锁大门电子门锁木门密码卡锁 红古铜色 ', '', 'VOC ', '广东佛山', '', '', '<p><img src=\\\"/pic/upload/image/20160624/14667444924412903.jpg\\\" style=\\\"\\\" title=\\\"14667444924412903.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667444927531852.jpg\\\" style=\\\"\\\" title=\\\"14667444927531852.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667444987871805.jpg\\\" style=\\\"\\\" title=\\\"14667444987871805.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667445072306504.jpg\\\" style=\\\"\\\" title=\\\"14667445072306504.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667445207874387.jpg\\\" style=\\\"\\\" title=\\\"14667445207874387.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667445238160976.jpg\\\" style=\\\"\\\" title=\\\"14667445238160976.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667445331424358.jpg\\\" style=\\\"\\\" title=\\\"14667445331424358.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667445361172611.jpg\\\" style=\\\"\\\" title=\\\"14667445361172611.jpg\\\"/></p><p><br/></p>', '1', '4', '0.02', '0', '0.01', '227', '5', '1', '0', '0', '2016-06-24 13:03:39');
INSERT INTO `goods` VALUES ('594', '8', '加厚黄铜铸造陶瓷阀芯角阀 六角阀 全铜角阀', '', '卓美欧', '广东佛山', '', '', null, '1', '2', '0.02', '0', '0.01', '198', '7', '1', '0', '0', '2016-06-24 13:08:22');
INSERT INTO `goods` VALUES ('595', '8', '加厚黄铜铸造陶瓷阀芯角阀 六角阀 全铜角阀', '', '卓美欧', '广东佛山', '', '', '<p><img src=\\\"/pic/upload/image/20160624/14667448461123003.jpg\\\" style=\\\"\\\" title=\\\"14667448461123003.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667448505967212.jpg\\\" style=\\\"\\\" title=\\\"14667448505967212.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667448551061294.jpg\\\" style=\\\"\\\" title=\\\"14667448551061294.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667448556944031.jpg\\\" style=\\\"\\\" title=\\\"14667448556944031.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667448591235746.jpg\\\" style=\\\"\\\" title=\\\"14667448591235746.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667448682985977.jpg\\\" style=\\\"\\\" title=\\\"14667448682985977.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667448694861305.jpg\\\" style=\\\"\\\" title=\\\"14667448694861305.jpg\\\"/></p><p><br/></p>', '1', '2', '0.02', '0', '0.01', '198', '7', '1', '0', '1', '2016-06-24 13:08:59');
INSERT INTO `goods` VALUES ('596', '8', '加厚黄铜铸造陶瓷阀芯角阀 六角阀 全铜角阀', '', '卓美欧', '广东佛山', '', '', '<p><img src=\\\"/pic/upload/image/20160624/14667448461123003.jpg\\\" style=\\\"\\\" title=\\\"14667448461123003.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667448505967212.jpg\\\" style=\\\"\\\" title=\\\"14667448505967212.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667448551061294.jpg\\\" style=\\\"\\\" title=\\\"14667448551061294.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667448556944031.jpg\\\" style=\\\"\\\" title=\\\"14667448556944031.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667448591235746.jpg\\\" style=\\\"\\\" title=\\\"14667448591235746.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667448682985977.jpg\\\" style=\\\"\\\" title=\\\"14667448682985977.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667448694861305.jpg\\\" style=\\\"\\\" title=\\\"14667448694861305.jpg\\\"/></p><p><br/></p>', '1', '2', '0.02', '0', '0.01', '198', '7', '1', '0', '1', '2016-06-24 13:09:32');
INSERT INTO `goods` VALUES ('597', '8', '卓美欧', '', '苏玫尔', '广东佛山', '', '', '<p><img src=\\\"/pic/upload/image/20160624/14667454329011713.jpg\\\" style=\\\"\\\" title=\\\"14667454329011713.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667454332951542.jpg\\\" style=\\\"\\\" title=\\\"14667454332951542.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667454374274344.jpg\\\" style=\\\"\\\" title=\\\"14667454374274344.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667454371760865.jpg\\\" style=\\\"\\\" title=\\\"14667454371760865.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667454385480956.jpg\\\" style=\\\"\\\" title=\\\"14667454385480956.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667454426703497.jpg\\\" style=\\\"\\\" title=\\\"14667454426703497.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667454432715738.jpg\\\" style=\\\"\\\" title=\\\"14667454432715738.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667454449096489.jpg\\\" style=\\\"\\\" title=\\\"14667454449096489.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/146674544870103012.jpg\\\" style=\\\"\\\" title=\\\"146674544870103012.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/146674544952774110.jpg\\\" style=\\\"\\\" title=\\\"146674544952774110.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/146674545045153211.jpg\\\" style=\\\"\\\" title=\\\"146674545045153211.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/146674545110882313.jpg\\\" style=\\\"\\\" title=\\\"146674545110882313.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/146674545384436914.jpg\\\" style=\\\"\\\" title=\\\"146674545384436914.jpg\\\"/></p><p><br/></p>', '1', '20', '0.02', '0', '0.01', '142', '6', '0', '0', '0', '2016-06-24 13:19:04');
INSERT INTO `goods` VALUES ('598', '1', '小户型布艺沙发 简约现代沙发 客厅沙发 实木三人沙发 日式田园沙发 蓝色三人位', 'SC29', '择木宜居', '择木宜居', '木质,布艺', '深蓝', '<p><img src=\\\"/pic/upload/image/20160624/1466750491101649147106760161782401283000_x.jpg\\\"/><img src=\\\"/pic/upload/image/20160624/1466750509135696149481151682192785910680_x.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/1466750523686830868013417423937334569900_x.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/1466750531199925897008087130314164055940_x.jpg\\\"/></p>', '3', '38', '1099.00', '0', '899.00', '78', '100', '1', '0', '0', '2016-06-24 14:42:38');
INSERT INTO `goods` VALUES ('599', '1', '都市中的田园风 浪漫简约 布艺沙发', 'hg301', '壹木家居', '壹木家居', '木、布', '蓝', '<p>						</p><p><img src=\\\"/pic/upload/image/20160624/1466754069562425aaaa_01.jpg\\\" style=\\\"\\\" title=\\\"1466754069562425aaaa_01.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/1466754073127511aaaa_02.jpg\\\" style=\\\"\\\" title=\\\"1466754073127511aaaa_02.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/1466754074119770aaaa_03.jpg\\\" style=\\\"\\\" title=\\\"1466754074119770aaaa_03.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/1466754078812569aaaa_05.jpg\\\" style=\\\"\\\" title=\\\"1466754078812569aaaa_05.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/1466754079114709aaaa_04.jpg\\\" style=\\\"\\\" title=\\\"1466754079114709aaaa_04.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/1466754082119598aaaa_06.jpg\\\" style=\\\"\\\" title=\\\"1466754082119598aaaa_06.jpg\\\"/></p><p><br/></p>', '1', '30', '3899.00', '0', '3299.00', '78', '100', '1', '0', '0', '2016-06-24 15:41:42');
INSERT INTO `goods` VALUES ('600', '16', '道奇家具日式实木橡木时尚北欧现代家居餐桌 实木餐桌椅组合 餐椅', '', '道奇', '北京', '', '', '<p><img src=\\\"/pic/upload/image/20160624/14667566391789261.jpg\\\" style=\\\"\\\" title=\\\"14667566391789261.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667566401313322.jpg\\\" style=\\\"\\\" title=\\\"14667566401313322.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667566451259023.jpg\\\" style=\\\"\\\" title=\\\"14667566451259023.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667566529690326.jpg\\\" style=\\\"\\\" title=\\\"14667566529690326.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667566581250464.jpg\\\" style=\\\"\\\" title=\\\"14667566581250464.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667566607138547.jpg\\\" style=\\\"\\\" title=\\\"14667566607138547.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667566661269309.jpg\\\" style=\\\"\\\" title=\\\"14667566661269309.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667566671326028.jpg\\\" style=\\\"\\\" title=\\\"14667566671326028.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/146675666838414410.jpg\\\" style=\\\"\\\" title=\\\"146675666838414410.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/14667566721372325.jpg\\\" style=\\\"\\\" title=\\\"14667566721372325.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/146675667541891413.jpg\\\" style=\\\"\\\" title=\\\"146675667541891413.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/146675667610968812.jpg\\\" style=\\\"\\\" title=\\\"146675667610968812.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/146675668030247011.jpg\\\" style=\\\"\\\" title=\\\"146675668030247011.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/146675668015401014.jpg\\\" style=\\\"\\\" title=\\\"146675668015401014.jpg\\\"/></p><p><br/></p>', '1', '10', '0.02', '0', '0.01', '99', '2', '1', '0', '0', '2016-06-24 16:25:40');
INSERT INTO `goods` VALUES ('601', '1', '可折叠拉伸餐桌设计 黑白双色拼接功能型1.43米餐桌', 'h365', '蒂美悦', '蒂美悦', '不锈钢', '', '', '1', '15', '899.00', '0', '699.00', '102', '50', '0', '0', '0', '2016-06-24 16:45:28');
INSERT INTO `goods` VALUES ('602', '1', '科勒卫浴 凯迪厨房水龙头 洗菜盆龙头 冷热水龙头 668', '668T', 'KOHLER/科勒', 'KOHLER/科勒', '不锈钢', '', '<p><img src=\\\"/pic/upload/image/20160624/1466761530123819TB2uQcpcFXXXXahXXXXXXXXXXXX_!!350653056.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/1466761536135808TB2OKQjcFXXXXbdXXXXXXXXXXXX_!!350653056.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/1466761540886153TB2d7sgcFXXXXbTXXXXXXXXXXXX_!!350653056.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/1466761545495123TB2wdEgcFXXXXXqXXXXXXXXXXXX_!!350653056.jpg\\\"/><img src=\\\"/pic/upload/image/20160624/1466761555283665TB2BY2_cFXXXXaZXpXXXXXXXXXX_!!350653056.jpg\\\"/></p>', '3', '2', '599.00', '0', '499.00', '203', '300', '0', '0', '0', '2016-06-24 17:47:35');
INSERT INTO `goods` VALUES ('603', '1', 'GERGO吉歌马赛克陶瓷砖背景墙边框修边条装饰条腰线地脚线建材', '陶瓷', 'gergo', 'gergo', '陶瓷', '8-01/30*4.8CM 8-03/60*', '<p><img src=\\\"/pic/upload/image/20160624/1466762941163477TB22tUxfXXXXXa9XpXXXXXXXXXX-1656388199.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/1466762957421281TB24ekQfXXXXXaNXXXXXXXXXXXX-1656388199.jpg\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/1466762958197429TB20zNfapXXXXXEXXXXXXXXXXXX-1656388199.gif\\\"/></p><p><img src=\\\"/pic/upload/image/20160624/1466762963676631TB2UmlaapXXXXXVXpXXXXXXXXXX-1656388199.gif\\\"/></p>', '1', '2', '38.00', '0', '26.00', '272', '150', '0', '0', '0', '2016-06-24 18:10:37');
INSERT INTO `goods` VALUES ('604', '1', '五金静音铰链柜门合页 阻尼液压缓冲飞机铰链冷轧钢铰链', 'HG-581款', 'Hutlon/汇泰龙', 'Hutlon/汇泰龙', '冷轧钢', '中弯=半盖=半遮（冷轧钢）HG-', '<p>						</p><p><img src=\\\"/pic/upload/image/20160624/1466763255596764TB28plCmFXXXXXiXXXXXXXXXXXX_!!808146202.jpg\\\"/><img src=\\\"/pic/upload/image/20160624/1466763270294767TB24vU4mpXXXXaoXpXXXXXXXXXX_!!808146202.jpg\\\"/><img src=\\\"/pic/upload/image/20160624/1466763260122692TB23M73mpXXXXasXpXXXXXXXXXX_!!808146202.jpg\\\"/><img src=\\\"/pic/upload/image/20160624/1466763276777067TB2xnjFpXXXXXXQXXXXXXXXXXXX_!!808146202.jpg\\\"/></p>', '1', '2', '15.00', '0', '9.90', '245', '100', '0', '0', '0', '2016-06-24 18:13:06');
INSERT INTO `goods` VALUES ('605', '1', '百强 防腐木地板 樟子松深度碳化木户外地板材庭院木材木方90*18', 'HW32618', '百强', '百强', '樟子松', '红棕', '<p><img src=\\\"/pic/upload/image/20160624/1466763486720997TB2YR7AlVXXXXXsXXXXXXXXXXXX_!!850030842.jpg\\\"/><img src=\\\"/pic/upload/image/20160624/1466763494100177TB2kHcAlVXXXXXgXXXXXXXXXXXX_!!850030842.jpg\\\"/><img src=\\\"/pic/upload/image/20160624/1466763498719749TB2f4sxlVXXXXX.XXXXXXXXXXXX_!!850030842.jpg\\\"/><img src=\\\"/pic/upload/image/20160624/1466763502317101TB2B53BlVXXXXXvXXXXXXXXXXXX_!!850030842.jpg\\\"/><img src=\\\"/pic/upload/image/20160624/1466763506315724TB2B53BlVXXXXXvXXXXXXXXXXXX_!!850030842.jpg\\\"/><img src=\\\"/pic/upload/image/20160624/1466763510199237TB2tEshlVXXXXckXXXXXXXXXXXX_!!850030842.jpg\\\"/></p>', '2', '5', '28.00', '0', '12.80', '283', '77', '0', '0', '0', '2016-06-24 18:18:36');

-- ----------------------------
-- Table structure for goodsbrowse
-- ----------------------------
DROP TABLE IF EXISTS `goodsbrowse`;
CREATE TABLE `goodsbrowse` (
  `ID` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `UserID` mediumint(8) unsigned NOT NULL,
  `GoodsID` mediumint(8) unsigned NOT NULL,
  `BrowseTime` datetime NOT NULL,
  PRIMARY KEY (`ID`),
  KEY `UserID` (`UserID`),
  KEY `GoodsID` (`GoodsID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of goodsbrowse
-- ----------------------------

-- ----------------------------
-- Table structure for goodscatalog
-- ----------------------------
DROP TABLE IF EXISTS `goodscatalog`;
CREATE TABLE `goodscatalog` (
  `ID` smallint(6) NOT NULL AUTO_INCREMENT COMMENT '标识码',
  `Name` varchar(50) NOT NULL COMMENT '分类名称',
  `ParentID` smallint(6) DEFAULT NULL COMMENT '父类ID',
  `OrderNum` tinyint(4) NOT NULL DEFAULT '0',
  `ImgUrl` varchar(100) DEFAULT NULL COMMENT '分类封面图',
  PRIMARY KEY (`ID`),
  KEY `ParentID` (`ParentID`),
  KEY `OrderNum` (`OrderNum`)
) ENGINE=MyISAM AUTO_INCREMENT=377 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of goodscatalog
-- ----------------------------
INSERT INTO `goodscatalog` VALUES ('1', '墙地面', '41', '11', null);
INSERT INTO `goodscatalog` VALUES ('2', '建材五金', '41', '10', null);
INSERT INTO `goodscatalog` VALUES ('6', '手动工具', '2', '0', null);
INSERT INTO `goodscatalog` VALUES ('53', '卧室柜类', '44', '3', null);
INSERT INTO `goodscatalog` VALUES ('7', '扳手类', '6', '0', null);
INSERT INTO `goodscatalog` VALUES ('50', '装饰材料', '41', '12', null);
INSERT INTO `goodscatalog` VALUES ('52', '床垫', '44', '2', null);
INSERT INTO `goodscatalog` VALUES ('26', '油漆涂料', '1', '0', null);
INSERT INTO `goodscatalog` VALUES ('25', '灯饰照明', '41', '7', null);
INSERT INTO `goodscatalog` VALUES ('54', '实木床', '51', '0', null);
INSERT INTO `goodscatalog` VALUES ('31', '壁纸', '1', '0', null);
INSERT INTO `goodscatalog` VALUES ('33', '电工电料', '41', '9', null);
INSERT INTO `goodscatalog` VALUES ('47', '书房', '43', '4', null);
INSERT INTO `goodscatalog` VALUES ('48', '儿童房', '43', '5', null);
INSERT INTO `goodscatalog` VALUES ('43', '家具城', '0', '1', null);
INSERT INTO `goodscatalog` VALUES ('44', '卧室', '43', '1', null);
INSERT INTO `goodscatalog` VALUES ('45', '客厅', '43', '2', null);
INSERT INTO `goodscatalog` VALUES ('41', '建材城', '0', '2', null);
INSERT INTO `goodscatalog` VALUES ('51', '床', '44', '1', null);
INSERT INTO `goodscatalog` VALUES ('49', '厨房卫浴', '41', '8', null);
INSERT INTO `goodscatalog` VALUES ('46', '餐厅', '43', '3', null);
INSERT INTO `goodscatalog` VALUES ('55', '皮艺床', '51', '0', null);
INSERT INTO `goodscatalog` VALUES ('56', '布艺床', '51', '0', null);
INSERT INTO `goodscatalog` VALUES ('57', '儿童床', '51', '0', null);
INSERT INTO `goodscatalog` VALUES ('58', '板式床', '51', '0', null);
INSERT INTO `goodscatalog` VALUES ('59', '充气床', '51', '0', null);
INSERT INTO `goodscatalog` VALUES ('60', '折叠床/午休床', '51', '0', null);
INSERT INTO `goodscatalog` VALUES ('61', '弹簧床垫', '52', '0', null);
INSERT INTO `goodscatalog` VALUES ('62', '乳胶床垫', '52', '0', null);
INSERT INTO `goodscatalog` VALUES ('63', '天然棕垫', '52', '0', null);
INSERT INTO `goodscatalog` VALUES ('64', '海绵床垫', '52', '0', null);
INSERT INTO `goodscatalog` VALUES ('65', '衣柜', '53', '0', null);
INSERT INTO `goodscatalog` VALUES ('66', '斗柜', '53', '0', null);
INSERT INTO `goodscatalog` VALUES ('67', '角柜', '53', '0', null);
INSERT INTO `goodscatalog` VALUES ('68', '床头柜', '53', '0', null);
INSERT INTO `goodscatalog` VALUES ('69', '穿衣镜', '53', '0', null);
INSERT INTO `goodscatalog` VALUES ('70', '梳妆台', '53', '0', null);
INSERT INTO `goodscatalog` VALUES ('71', '沙发', '45', '0', null);
INSERT INTO `goodscatalog` VALUES ('72', '客厅柜类', '45', '0', null);
INSERT INTO `goodscatalog` VALUES ('73', '客厅架类', '45', '0', null);
INSERT INTO `goodscatalog` VALUES ('74', '客厅几类', '45', '0', null);
INSERT INTO `goodscatalog` VALUES ('75', '真皮沙发', '71', '0', null);
INSERT INTO `goodscatalog` VALUES ('76', '组合沙发', '71', '0', null);
INSERT INTO `goodscatalog` VALUES ('77', '功能沙发', '71', '0', null);
INSERT INTO `goodscatalog` VALUES ('78', '布艺沙发', '71', '0', null);
INSERT INTO `goodscatalog` VALUES ('79', '休闲椅', '51', '0', null);
INSERT INTO `goodscatalog` VALUES ('80', '转角沙发', '71', '0', null);
INSERT INTO `goodscatalog` VALUES ('81', '实木沙发', '71', '0', null);
INSERT INTO `goodscatalog` VALUES ('82', '皮布结合沙发', '71', '0', null);
INSERT INTO `goodscatalog` VALUES ('83', '电视柜', '72', '0', null);
INSERT INTO `goodscatalog` VALUES ('84', '鞋柜', '72', '0', null);
INSERT INTO `goodscatalog` VALUES ('85', '门厅/玄关柜', '72', '0', null);
INSERT INTO `goodscatalog` VALUES ('86', '酒柜', '72', '0', null);
INSERT INTO `goodscatalog` VALUES ('87', '衣帽架', '73', '0', null);
INSERT INTO `goodscatalog` VALUES ('88', '隔板/置物架', '73', '0', null);
INSERT INTO `goodscatalog` VALUES ('89', '鞋架', '73', '0', null);
INSERT INTO `goodscatalog` VALUES ('90', '花架/花几', '73', '0', null);
INSERT INTO `goodscatalog` VALUES ('91', '多宝阁/博古架', '73', '0', null);
INSERT INTO `goodscatalog` VALUES ('92', '茶几', '74', '0', null);
INSERT INTO `goodscatalog` VALUES ('93', '角几/边几', '74', '0', null);
INSERT INTO `goodscatalog` VALUES ('94', '炕几', '74', '0', null);
INSERT INTO `goodscatalog` VALUES ('95', '套几', '74', '0', null);
INSERT INTO `goodscatalog` VALUES ('96', '餐桌', '46', '0', null);
INSERT INTO `goodscatalog` VALUES ('97', '餐椅', '46', '0', null);
INSERT INTO `goodscatalog` VALUES ('98', '餐边柜', '46', '0', null);
INSERT INTO `goodscatalog` VALUES ('99', '餐厅套装', '46', '0', null);
INSERT INTO `goodscatalog` VALUES ('100', '长餐桌', '96', '0', null);
INSERT INTO `goodscatalog` VALUES ('101', '圆餐桌', '96', '0', null);
INSERT INTO `goodscatalog` VALUES ('102', '折叠餐桌', '96', '0', null);
INSERT INTO `goodscatalog` VALUES ('103', '实木餐桌', '96', '0', null);
INSERT INTO `goodscatalog` VALUES ('104', '实木餐椅', '97', '0', null);
INSERT INTO `goodscatalog` VALUES ('105', '圆凳餐椅', '97', '0', null);
INSERT INTO `goodscatalog` VALUES ('106', '书桌', '47', '0', null);
INSERT INTO `goodscatalog` VALUES ('107', '书柜/书架', '47', '0', null);
INSERT INTO `goodscatalog` VALUES ('108', '电脑椅', '47', '0', null);
INSERT INTO `goodscatalog` VALUES ('109', '电脑桌', '47', '0', null);
INSERT INTO `goodscatalog` VALUES ('110', '收纳柜', '47', '0', null);
INSERT INTO `goodscatalog` VALUES ('111', '可躺', '108', '0', null);
INSERT INTO `goodscatalog` VALUES ('112', '升降', '108', '0', null);
INSERT INTO `goodscatalog` VALUES ('113', '折叠椅', '108', '0', null);
INSERT INTO `goodscatalog` VALUES ('114', '人体工程学椅', '108', '0', null);
INSERT INTO `goodscatalog` VALUES ('115', '老板椅', '108', '0', null);
INSERT INTO `goodscatalog` VALUES ('116', '办公家具', '43', '6', null);
INSERT INTO `goodscatalog` VALUES ('117', '塑料餐椅', '97', '0', null);
INSERT INTO `goodscatalog` VALUES ('118', '餐边柜', '98', '0', null);
INSERT INTO `goodscatalog` VALUES ('119', '餐车', '98', '0', null);
INSERT INTO `goodscatalog` VALUES ('120', '实木', '106', '0', null);
INSERT INTO `goodscatalog` VALUES ('121', '金属', '106', '0', null);
INSERT INTO `goodscatalog` VALUES ('122', '钢木', '106', '0', null);
INSERT INTO `goodscatalog` VALUES ('123', '木', '106', '0', null);
INSERT INTO `goodscatalog` VALUES ('124', '人造板', '106', '0', null);
INSERT INTO `goodscatalog` VALUES ('125', '竹', '106', '0', null);
INSERT INTO `goodscatalog` VALUES ('126', '组合书架', '107', '0', null);
INSERT INTO `goodscatalog` VALUES ('127', '书柜', '107', '0', null);
INSERT INTO `goodscatalog` VALUES ('128', '书架', '107', '0', null);
INSERT INTO `goodscatalog` VALUES ('129', '实木', '110', '0', null);
INSERT INTO `goodscatalog` VALUES ('130', '塑料', '110', '0', null);
INSERT INTO `goodscatalog` VALUES ('131', '布艺', '110', '0', null);
INSERT INTO `goodscatalog` VALUES ('132', '实木', '109', '0', null);
INSERT INTO `goodscatalog` VALUES ('133', '钢木', '109', '0', null);
INSERT INTO `goodscatalog` VALUES ('134', '板材', '109', '0', null);
INSERT INTO `goodscatalog` VALUES ('135', '塑料', '109', '0', null);
INSERT INTO `goodscatalog` VALUES ('136', '儿童床', '48', '0', null);
INSERT INTO `goodscatalog` VALUES ('137', '儿童衣柜', '48', '0', null);
INSERT INTO `goodscatalog` VALUES ('138', '学习桌椅', '48', '0', null);
INSERT INTO `goodscatalog` VALUES ('373', '学习桌', '138', '0', null);
INSERT INTO `goodscatalog` VALUES ('140', '儿童床垫', '48', '0', null);
INSERT INTO `goodscatalog` VALUES ('372', '卡通衣柜', '137', '0', null);
INSERT INTO `goodscatalog` VALUES ('142', '子母床', '136', '0', null);
INSERT INTO `goodscatalog` VALUES ('143', '实木儿童床', '136', '0', null);
INSERT INTO `goodscatalog` VALUES ('144', '灯具', '25', '0', null);
INSERT INTO `goodscatalog` VALUES ('145', 'LED照明', '25', '0', null);
INSERT INTO `goodscatalog` VALUES ('146', '吸顶灯', '25', '0', null);
INSERT INTO `goodscatalog` VALUES ('147', '配套灯具', '25', '0', null);
INSERT INTO `goodscatalog` VALUES ('148', '吊灯', '25', '0', null);
INSERT INTO `goodscatalog` VALUES ('149', '灯具配件', '25', '0', null);
INSERT INTO `goodscatalog` VALUES ('150', '吸顶灯', '144', '0', null);
INSERT INTO `goodscatalog` VALUES ('151', '筒灯/射灯', '144', '0', null);
INSERT INTO `goodscatalog` VALUES ('152', '吊灯', '144', '0', null);
INSERT INTO `goodscatalog` VALUES ('153', '台灯', '144', '0', null);
INSERT INTO `goodscatalog` VALUES ('154', '节能灯', '145', '0', null);
INSERT INTO `goodscatalog` VALUES ('155', '光源筒灯', '145', '0', null);
INSERT INTO `goodscatalog` VALUES ('156', '支架灯', '145', '0', null);
INSERT INTO `goodscatalog` VALUES ('158', '厨卫灯', '146', '0', null);
INSERT INTO `goodscatalog` VALUES ('159', '餐厅灯', '146', '0', null);
INSERT INTO `goodscatalog` VALUES ('160', '卧室灯', '160', '0', null);
INSERT INTO `goodscatalog` VALUES ('162', '镜前灯', '147', '0', null);
INSERT INTO `goodscatalog` VALUES ('163', '壁灯', '147', '0', null);
INSERT INTO `goodscatalog` VALUES ('164', '装饰台灯', '147', '0', null);
INSERT INTO `goodscatalog` VALUES ('165', '探照灯', '147', '0', null);
INSERT INTO `goodscatalog` VALUES ('166', '欧式经典', '148', '0', null);
INSERT INTO `goodscatalog` VALUES ('167', '简约现代', '148', '0', null);
INSERT INTO `goodscatalog` VALUES ('168', '欧式田园', '148', '0', null);
INSERT INTO `goodscatalog` VALUES ('169', '其他配件', '149', '0', null);
INSERT INTO `goodscatalog` VALUES ('175', '厨房卫浴', '49', '0', null);
INSERT INTO `goodscatalog` VALUES ('173', '落地灯', '144', '0', null);
INSERT INTO `goodscatalog` VALUES ('174', '壁灯', '144', '0', null);
INSERT INTO `goodscatalog` VALUES ('176', '淋浴花洒', '49', '0', null);
INSERT INTO `goodscatalog` VALUES ('177', '卫浴五金', '49', '0', null);
INSERT INTO `goodscatalog` VALUES ('178', '龙头', '49', '0', null);
INSERT INTO `goodscatalog` VALUES ('179', '马桶', '49', '0', null);
INSERT INTO `goodscatalog` VALUES ('180', '浴室柜', '49', '0', null);
INSERT INTO `goodscatalog` VALUES ('181', '淋浴房', '175', '0', null);
INSERT INTO `goodscatalog` VALUES ('182', '橱柜', '175', '0', null);
INSERT INTO `goodscatalog` VALUES ('183', '陶瓷件组套', '175', '0', null);
INSERT INTO `goodscatalog` VALUES ('184', '沐浴桶', '175', '0', null);
INSERT INTO `goodscatalog` VALUES ('185', '浴缸', '175', '0', null);
INSERT INTO `goodscatalog` VALUES ('186', '净水软水', '175', '0', null);
INSERT INTO `goodscatalog` VALUES ('187', '恒温花洒', '176', '0', null);
INSERT INTO `goodscatalog` VALUES ('188', '花洒软管', '176', '0', null);
INSERT INTO `goodscatalog` VALUES ('189', '手持花洒', '176', '0', null);
INSERT INTO `goodscatalog` VALUES ('190', '淋浴套装', '176', '0', null);
INSERT INTO `goodscatalog` VALUES ('191', '马桶刷', '177', '0', null);
INSERT INTO `goodscatalog` VALUES ('192', '镜子', '177', '0', null);
INSERT INTO `goodscatalog` VALUES ('193', '皂碟', '177', '0', null);
INSERT INTO `goodscatalog` VALUES ('194', '毛巾架', '177', '0', null);
INSERT INTO `goodscatalog` VALUES ('195', '软管', '177', '0', null);
INSERT INTO `goodscatalog` VALUES ('196', '置物架', '177', '0', null);
INSERT INTO `goodscatalog` VALUES ('197', '地漏', '177', '0', null);
INSERT INTO `goodscatalog` VALUES ('198', '角阀', '177', '0', null);
INSERT INTO `goodscatalog` VALUES ('199', '净水龙头', '178', '0', null);
INSERT INTO `goodscatalog` VALUES ('200', '浴缸龙头', '178', '0', null);
INSERT INTO `goodscatalog` VALUES ('201', '洗衣机龙头', '178', '0', null);
INSERT INTO `goodscatalog` VALUES ('202', '淋浴龙头', '178', '0', null);
INSERT INTO `goodscatalog` VALUES ('203', '厨用龙头', '178', '0', null);
INSERT INTO `goodscatalog` VALUES ('204', '面盆龙头', '178', '0', null);
INSERT INTO `goodscatalog` VALUES ('205', '蹲便器', '179', '0', null);
INSERT INTO `goodscatalog` VALUES ('206', '马桶盖', '179', '0', null);
INSERT INTO `goodscatalog` VALUES ('207', '智能马桶', '179', '0', null);
INSERT INTO `goodscatalog` VALUES ('208', '智能马桶盖/洁身器', '179', '0', null);
INSERT INTO `goodscatalog` VALUES ('209', '独立式', '180', '0', null);
INSERT INTO `goodscatalog` VALUES ('210', '落地式', '180', '0', null);
INSERT INTO `goodscatalog` VALUES ('211', '悬挂式', '180', '0', null);
INSERT INTO `goodscatalog` VALUES ('212', '电动工具', '2', '0', null);
INSERT INTO `goodscatalog` VALUES ('213', '锁具', '2', '0', null);
INSERT INTO `goodscatalog` VALUES ('214', '劳防用品', '2', '0', null);
INSERT INTO `goodscatalog` VALUES ('215', '家用五金', '2', '0', null);
INSERT INTO `goodscatalog` VALUES ('216', '工具箱/包', '2', '0', null);
INSERT INTO `goodscatalog` VALUES ('217', '螺丝刀', '6', '0', null);
INSERT INTO `goodscatalog` VALUES ('218', '锤类', '6', '0', null);
INSERT INTO `goodscatalog` VALUES ('219', '刃具/锯类', '6', '0', null);
INSERT INTO `goodscatalog` VALUES ('220', '测量工具', '6', '0', null);
INSERT INTO `goodscatalog` VALUES ('221', '曲线锯', '212', '0', null);
INSERT INTO `goodscatalog` VALUES ('222', '切割机', '212', '0', null);
INSERT INTO `goodscatalog` VALUES ('223', '角磨机', '212', '0', null);
INSERT INTO `goodscatalog` VALUES ('224', '冲击扳手', '212', '0', null);
INSERT INTO `goodscatalog` VALUES ('225', '冲击钻', '212', '0', null);
INSERT INTO `goodscatalog` VALUES ('226', '手电钻', '212', '0', null);
INSERT INTO `goodscatalog` VALUES ('227', '电子/指纹门锁', '213', '0', null);
INSERT INTO `goodscatalog` VALUES ('228', '防盗门锁', '213', '0', null);
INSERT INTO `goodscatalog` VALUES ('229', '球形锁', '213', '0', null);
INSERT INTO `goodscatalog` VALUES ('230', '双舌锁', '213', '0', null);
INSERT INTO `goodscatalog` VALUES ('231', '分体锁', '213', '0', null);
INSERT INTO `goodscatalog` VALUES ('232', '面板锁', '213', '0', null);
INSERT INTO `goodscatalog` VALUES ('233', '工业防护', '214', '0', null);
INSERT INTO `goodscatalog` VALUES ('234', '耳罩耳塞', '214', '0', null);
INSERT INTO `goodscatalog` VALUES ('235', '安全绳/带', '214', '0', null);
INSERT INTO `goodscatalog` VALUES ('236', '口罩面罩', '214', '0', null);
INSERT INTO `goodscatalog` VALUES ('237', '安全镜', '214', '0', null);
INSERT INTO `goodscatalog` VALUES ('238', '安全服', '214', '0', null);
INSERT INTO `goodscatalog` VALUES ('239', '安全鞋', '214', '0', null);
INSERT INTO `goodscatalog` VALUES ('240', '手套', '214', '0', null);
INSERT INTO `goodscatalog` VALUES ('241', '安全帽', '214', '0', null);
INSERT INTO `goodscatalog` VALUES ('242', '梯具', '215', '0', null);
INSERT INTO `goodscatalog` VALUES ('243', '紧固件', '215', '0', null);
INSERT INTO `goodscatalog` VALUES ('244', '拉手', '215', '0', null);
INSERT INTO `goodscatalog` VALUES ('245', '合页', '215', '0', null);
INSERT INTO `goodscatalog` VALUES ('246', '滑轨', '215', '0', null);
INSERT INTO `goodscatalog` VALUES ('247', '铰链', '215', '0', null);
INSERT INTO `goodscatalog` VALUES ('248', '门吸', '215', '0', null);
INSERT INTO `goodscatalog` VALUES ('249', '工具车/柜', '216', '0', null);
INSERT INTO `goodscatalog` VALUES ('250', '机修工具', '216', '0', null);
INSERT INTO `goodscatalog` VALUES ('251', '家用工具组合', '216', '0', null);
INSERT INTO `goodscatalog` VALUES ('252', '工具包', '216', '0', null);
INSERT INTO `goodscatalog` VALUES ('253', '工具箱', '216', '0', null);
INSERT INTO `goodscatalog` VALUES ('254', '瓷砖', '1', '0', null);
INSERT INTO `goodscatalog` VALUES ('255', '地板', '1', '0', null);
INSERT INTO `goodscatalog` VALUES ('256', '辅料/胶类', '1', '0', null);
INSERT INTO `goodscatalog` VALUES ('257', '木材板材', '1', '0', null);
INSERT INTO `goodscatalog` VALUES ('258', '管材管件', '1', '0', null);
INSERT INTO `goodscatalog` VALUES ('259', '其他', '26', '0', null);
INSERT INTO `goodscatalog` VALUES ('260', '防水涂料', '26', '0', null);
INSERT INTO `goodscatalog` VALUES ('261', '外墙涂料', '26', '0', null);
INSERT INTO `goodscatalog` VALUES ('262', '内墙涂料', '26', '0', null);
INSERT INTO `goodscatalog` VALUES ('263', '壁纸胶', '31', '0', null);
INSERT INTO `goodscatalog` VALUES ('264', '儿童', '31', '0', null);
INSERT INTO `goodscatalog` VALUES ('265', '美式', '31', '0', null);
INSERT INTO `goodscatalog` VALUES ('266', '田园', '31', '0', null);
INSERT INTO `goodscatalog` VALUES ('267', '简约', '31', '0', null);
INSERT INTO `goodscatalog` VALUES ('268', '欧式', '31', '0', null);
INSERT INTO `goodscatalog` VALUES ('269', '艺术砖', '254', '0', null);
INSERT INTO `goodscatalog` VALUES ('270', '腰线', '254', '0', null);
INSERT INTO `goodscatalog` VALUES ('271', '外墙砖', '254', '0', null);
INSERT INTO `goodscatalog` VALUES ('272', '马赛克', '254', '0', null);
INSERT INTO `goodscatalog` VALUES ('273', '地砖', '254', '0', null);
INSERT INTO `goodscatalog` VALUES ('274', '墙砖', '254', '0', null);
INSERT INTO `goodscatalog` VALUES ('275', '竹地板', '255', '0', null);
INSERT INTO `goodscatalog` VALUES ('276', '实木地板', '255', '0', null);
INSERT INTO `goodscatalog` VALUES ('277', '实木复合', '255', '0', null);
INSERT INTO `goodscatalog` VALUES ('278', '强化地板', '255', '0', null);
INSERT INTO `goodscatalog` VALUES ('279', '腻子粉', '256', '0', null);
INSERT INTO `goodscatalog` VALUES ('280', '涂刷工具', '256', '0', null);
INSERT INTO `goodscatalog` VALUES ('281', '填缝剂', '256', '0', null);
INSERT INTO `goodscatalog` VALUES ('282', '玻璃胶', '256', '0', null);
INSERT INTO `goodscatalog` VALUES ('283', '防腐木', '257', '0', null);
INSERT INTO `goodscatalog` VALUES ('284', '集成板', '257', '0', null);
INSERT INTO `goodscatalog` VALUES ('285', '细木工板', '257', '0', null);
INSERT INTO `goodscatalog` VALUES ('286', '阀门', '258', '0', null);
INSERT INTO `goodscatalog` VALUES ('287', 'PPR管件', '258', '0', null);
INSERT INTO `goodscatalog` VALUES ('288', 'PPR管', '258', '0', null);
INSERT INTO `goodscatalog` VALUES ('289', ' 开关插座', '33', '0', null);
INSERT INTO `goodscatalog` VALUES ('290', '智能家居', '33', '0', null);
INSERT INTO `goodscatalog` VALUES ('291', '配电箱', '33', '0', null);
INSERT INTO `goodscatalog` VALUES ('292', '电线电缆', '33', '0', null);
INSERT INTO `goodscatalog` VALUES ('293', '插线板', '33', '0', null);
INSERT INTO `goodscatalog` VALUES ('294', '地插', '289', '0', null);
INSERT INTO `goodscatalog` VALUES ('295', '触摸开关', '289', '0', null);
INSERT INTO `goodscatalog` VALUES ('296', '弱电插座', '289', '0', null);
INSERT INTO `goodscatalog` VALUES ('297', '墙壁插座', '289', '0', null);
INSERT INTO `goodscatalog` VALUES ('298', '开关', '289', '0', null);
INSERT INTO `goodscatalog` VALUES ('299', '监控显示器', '290', '0', null);
INSERT INTO `goodscatalog` VALUES ('300', '智能开关', '290', '0', null);
INSERT INTO `goodscatalog` VALUES ('301', '报警器', '290', '0', null);
INSERT INTO `goodscatalog` VALUES ('302', '监控套装', '290', '0', null);
INSERT INTO `goodscatalog` VALUES ('303', '监控摄像头', '290', '0', null);
INSERT INTO `goodscatalog` VALUES ('304', '门铃', '290', '0', null);
INSERT INTO `goodscatalog` VALUES ('305', '其他断路器', '291', '0', null);
INSERT INTO `goodscatalog` VALUES ('306', '漏电保护器', '291', '0', null);
INSERT INTO `goodscatalog` VALUES ('307', '空气开关', '291', '0', null);
INSERT INTO `goodscatalog` VALUES ('308', '强电配电箱', '291', '0', null);
INSERT INTO `goodscatalog` VALUES ('309', '弱电配电箱', '291', '0', null);
INSERT INTO `goodscatalog` VALUES ('310', 'BV6', '292', '0', null);
INSERT INTO `goodscatalog` VALUES ('311', 'BV4', '292', '0', null);
INSERT INTO `goodscatalog` VALUES ('312', 'BV2.5', '292', '0', null);
INSERT INTO `goodscatalog` VALUES ('313', 'BV1.5', '292', '0', null);
INSERT INTO `goodscatalog` VALUES ('314', '工程插座', '293', '0', null);
INSERT INTO `goodscatalog` VALUES ('315', '家用插座', '293', '0', null);
INSERT INTO `goodscatalog` VALUES ('316', '浴霸/换气扇', '50', '0', null);
INSERT INTO `goodscatalog` VALUES ('317', '吊顶', '50', '0', null);
INSERT INTO `goodscatalog` VALUES ('318', '散热器', '50', '0', null);
INSERT INTO `goodscatalog` VALUES ('319', '窗', '50', '0', null);
INSERT INTO `goodscatalog` VALUES ('320', '移门壁柜', '50', '0', null);
INSERT INTO `goodscatalog` VALUES ('321', '园艺休闲', '50', '0', null);
INSERT INTO `goodscatalog` VALUES ('322', '换气扇', '316', '0', null);
INSERT INTO `goodscatalog` VALUES ('323', '综合加热型', '316', '0', null);
INSERT INTO `goodscatalog` VALUES ('324', '灯暖型', '316', '0', null);
INSERT INTO `goodscatalog` VALUES ('325', '风暖型', '316', '0', null);
INSERT INTO `goodscatalog` VALUES ('326', '新风系统', '317', '0', null);
INSERT INTO `goodscatalog` VALUES ('327', '集成吊顶', '317', '0', null);
INSERT INTO `goodscatalog` VALUES ('328', '照明', '317', '0', null);
INSERT INTO `goodscatalog` VALUES ('329', '扣板', '317', '0', null);
INSERT INTO `goodscatalog` VALUES ('330', '暖气片', '318', '0', null);
INSERT INTO `goodscatalog` VALUES ('331', '窗套', '319', '0', null);
INSERT INTO `goodscatalog` VALUES ('332', '百叶窗', '319', '0', null);
INSERT INTO `goodscatalog` VALUES ('333', '断桥铝', '319', '0', null);
INSERT INTO `goodscatalog` VALUES ('334', '塑钢窗', '319', '0', null);
INSERT INTO `goodscatalog` VALUES ('335', '木质窗', '319', '0', null);
INSERT INTO `goodscatalog` VALUES ('336', '柜体', '320', '0', null);
INSERT INTO `goodscatalog` VALUES ('337', '铝合金门', '320', '0', null);
INSERT INTO `goodscatalog` VALUES ('338', '玻璃推拉门', '320', '0', null);
INSERT INTO `goodscatalog` VALUES ('339', '木质推拉门', '320', '0', null);
INSERT INTO `goodscatalog` VALUES ('340', '园艺机械', '321', '0', null);
INSERT INTO `goodscatalog` VALUES ('341', '休闲农业', '321', '0', null);
INSERT INTO `goodscatalog` VALUES ('342', '园艺资材', '321', '0', null);
INSERT INTO `goodscatalog` VALUES ('343', '种子种球', '321', '0', null);
INSERT INTO `goodscatalog` VALUES ('344', '园艺工具', '321', '0', null);
INSERT INTO `goodscatalog` VALUES ('345', '园艺容器', '321', '0', null);
INSERT INTO `goodscatalog` VALUES ('346', '办公桌类', '116', '0', null);
INSERT INTO `goodscatalog` VALUES ('347', '会议桌', '116', '0', null);
INSERT INTO `goodscatalog` VALUES ('348', '办公柜类', '116', '0', null);
INSERT INTO `goodscatalog` VALUES ('349', '办公沙发', '116', '0', null);
INSERT INTO `goodscatalog` VALUES ('350', '货架展示架', '116', '0', null);
INSERT INTO `goodscatalog` VALUES ('351', '办公桌', '346', '0', null);
INSERT INTO `goodscatalog` VALUES ('352', '班台班桌', '346', '0', null);
INSERT INTO `goodscatalog` VALUES ('353', '前台桌', '346', '0', null);
INSERT INTO `goodscatalog` VALUES ('354', '职员办公桌', '346', '0', null);
INSERT INTO `goodscatalog` VALUES ('355', '屏风办公桌', '346', '0', null);
INSERT INTO `goodscatalog` VALUES ('356', '老板桌', '346', '0', null);
INSERT INTO `goodscatalog` VALUES ('357', '办公桌椅套装', '346', '0', null);
INSERT INTO `goodscatalog` VALUES ('358', '长条桌', '347', '0', null);
INSERT INTO `goodscatalog` VALUES ('359', '洽谈桌', '347', '0', null);
INSERT INTO `goodscatalog` VALUES ('360', '会议桌椅组合', '347', '0', null);
INSERT INTO `goodscatalog` VALUES ('361', '洽谈桌椅组合', '347', '0', null);
INSERT INTO `goodscatalog` VALUES ('362', '文件柜', '348', '0', null);
INSERT INTO `goodscatalog` VALUES ('363', '铁皮柜', '348', '0', null);
INSERT INTO `goodscatalog` VALUES ('364', '档案柜', '348', '0', null);
INSERT INTO `goodscatalog` VALUES ('365', '更衣柜', '348', '0', null);
INSERT INTO `goodscatalog` VALUES ('366', '单人位', '349', '0', null);
INSERT INTO `goodscatalog` VALUES ('367', '双人位', '349', '0', null);
INSERT INTO `goodscatalog` VALUES ('368', '三人位', '349', '0', null);
INSERT INTO `goodscatalog` VALUES ('369', '组合沙发', '349', '0', null);
INSERT INTO `goodscatalog` VALUES ('370', '超市货架', '350', '0', null);
INSERT INTO `goodscatalog` VALUES ('371', '仓储货架', '350', '0', null);
INSERT INTO `goodscatalog` VALUES ('374', '学习椅', '138', '0', null);
INSERT INTO `goodscatalog` VALUES ('375', '椰棕床垫', '140', '0', null);
INSERT INTO `goodscatalog` VALUES ('376', '乳胶床垫', '140', '0', null);

-- ----------------------------
-- Table structure for goodseva
-- ----------------------------
DROP TABLE IF EXISTS `goodseva`;
CREATE TABLE `goodseva` (
  `ID` mediumint(9) NOT NULL AUTO_INCREMENT,
  `GSID` mediumint(9) NOT NULL,
  `GoodsID` mediumint(9) NOT NULL,
  `Comment` text,
  `GoodsScore` tinyint(4) NOT NULL DEFAULT '5',
  `ShopServiceScore` tinyint(4) NOT NULL DEFAULT '5',
  `DeliveryScore` tinyint(4) NOT NULL DEFAULT '5',
  `UserID` mediumint(9) NOT NULL,
  `EvaTime` datetime NOT NULL,
  PRIMARY KEY (`ID`),
  KEY `GoodsID` (`GoodsID`),
  KEY `UserID` (`UserID`),
  KEY `GSID` (`GSID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of goodseva
-- ----------------------------

-- ----------------------------
-- Table structure for goodsgallery
-- ----------------------------
DROP TABLE IF EXISTS `goodsgallery`;
CREATE TABLE `goodsgallery` (
  `ID` mediumint(9) NOT NULL AUTO_INCREMENT COMMENT '标识码',
  `GoodsID` mediumint(9) NOT NULL COMMENT '商品ID',
  `ImgUrl` varchar(255) NOT NULL COMMENT '图片在服务器上的存放地址',
  PRIMARY KEY (`ID`),
  KEY `GoodsID` (`GoodsID`)
) ENGINE=MyISAM AUTO_INCREMENT=701 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of goodsgallery
-- ----------------------------
INSERT INTO `goodsgallery` VALUES ('538', '428', '/pic/2016/06/20/nfd3hru2.jpg');
INSERT INTO `goodsgallery` VALUES ('534', '198', '/pic/2016/06/15/wbrtfh95.jpg');
INSERT INTO `goodsgallery` VALUES ('525', '209', '/pic/2016/06/14/kaynq8xv.jpg');
INSERT INTO `goodsgallery` VALUES ('212', '222', '/pic/2016/05/31/fjavuzcb.jpg');
INSERT INTO `goodsgallery` VALUES ('391', '434', '/pic/2016/06/02/jrmgfuwv.jpg');
INSERT INTO `goodsgallery` VALUES ('475', '436', '/pic/2016/06/08/qxibjz86.jpg');
INSERT INTO `goodsgallery` VALUES ('394', '437', '/pic/2016/06/02/6yrnkptj.jpg');
INSERT INTO `goodsgallery` VALUES ('474', '438', '/pic/2016/06/08/mugws9rf.jpg');
INSERT INTO `goodsgallery` VALUES ('396', '439', '/pic/2016/06/02/iju2758c.jpg');
INSERT INTO `goodsgallery` VALUES ('397', '440', '/pic/2016/06/02/7auf5icb.jpg');
INSERT INTO `goodsgallery` VALUES ('398', '441', '/pic/2016/06/02/umtgjy3a.jpg');
INSERT INTO `goodsgallery` VALUES ('473', '442', '/pic/2016/06/08/8kqyit76.jpg');
INSERT INTO `goodsgallery` VALUES ('476', '436', '/pic/2016/06/08/fyjxnkpd.jpg');
INSERT INTO `goodsgallery` VALUES ('477', '436', '/pic/2016/06/08/hbnvek2q.jpg');
INSERT INTO `goodsgallery` VALUES ('585', '556', '/pic/2016/06/23/ckjh3sa7.jpg');
INSERT INTO `goodsgallery` VALUES ('586', '557', '/pic/2016/06/23/4gbwv3iz.jpg');
INSERT INTO `goodsgallery` VALUES ('588', '559', '/pic/2016/06/23/pjrxqt3i.jpg');
INSERT INTO `goodsgallery` VALUES ('589', '560', '/pic/2016/06/23/7gmwfudj.jpg');
INSERT INTO `goodsgallery` VALUES ('590', '561', '/pic/2016/06/23/w6cmdai3.jpg');
INSERT INTO `goodsgallery` VALUES ('591', '562', '/pic/2016/06/23/rv74q8jz.jpg');
INSERT INTO `goodsgallery` VALUES ('592', '563', '/pic/2016/06/23/n6537hms.jpg');
INSERT INTO `goodsgallery` VALUES ('593', '564', '/pic/2016/06/23/t5di8g4a.jpg');
INSERT INTO `goodsgallery` VALUES ('595', '566', '/pic/2016/06/23/4ayh2dis.jpg');
INSERT INTO `goodsgallery` VALUES ('606', '571', '/pic/2016/06/23/7p3uzvbt.jpg');
INSERT INTO `goodsgallery` VALUES ('610', '573', '/pic/2016/06/24/7zsyaker.jpg');
INSERT INTO `goodsgallery` VALUES ('611', '573', '/pic/2016/06/24/zitahc2d.jpg');
INSERT INTO `goodsgallery` VALUES ('612', '573', '/pic/2016/06/24/pb5gr96c.jpg');
INSERT INTO `goodsgallery` VALUES ('613', '574', '/pic/2016/06/24/gkhcjwib.jpg');
INSERT INTO `goodsgallery` VALUES ('614', '574', '/pic/2016/06/24/g2kx5c9q.jpg');
INSERT INTO `goodsgallery` VALUES ('615', '574', '/pic/2016/06/24/spcdx258.jpg');
INSERT INTO `goodsgallery` VALUES ('616', '575', '/pic/2016/06/24/axyng48c.jpg');
INSERT INTO `goodsgallery` VALUES ('617', '575', '/pic/2016/06/24/he6itpkw.jpg');
INSERT INTO `goodsgallery` VALUES ('618', '575', '/pic/2016/06/24/bdvsczq2.jpg');
INSERT INTO `goodsgallery` VALUES ('619', '576', '/pic/2016/06/24/8eby354t.jpg');
INSERT INTO `goodsgallery` VALUES ('623', '578', '/pic/2016/06/24/kyqfjvhi.jpg');
INSERT INTO `goodsgallery` VALUES ('624', '578', '/pic/2016/06/24/85t3z2w9.jpg');
INSERT INTO `goodsgallery` VALUES ('625', '578', '/pic/2016/06/24/p84ba5xm.jpg');
INSERT INTO `goodsgallery` VALUES ('626', '579', '/pic/2016/06/24/ghic5maj.jpg');
INSERT INTO `goodsgallery` VALUES ('627', '579', '/pic/2016/06/24/h2wifyrz.jpg');
INSERT INTO `goodsgallery` VALUES ('628', '579', '/pic/2016/06/24/dtfugp5m.jpg');
INSERT INTO `goodsgallery` VALUES ('629', '580', '/pic/2016/06/24/bjkv26hw.jpg');
INSERT INTO `goodsgallery` VALUES ('630', '580', '/pic/2016/06/24/v49g3cqd.jpg');
INSERT INTO `goodsgallery` VALUES ('631', '580', '/pic/2016/06/24/xvjpbugq.jpg');
INSERT INTO `goodsgallery` VALUES ('632', '581', '/pic/2016/06/24/94rd8pej.jpg');
INSERT INTO `goodsgallery` VALUES ('633', '581', '/pic/2016/06/24/r56jbw3a.jpg');
INSERT INTO `goodsgallery` VALUES ('634', '581', '/pic/2016/06/24/j8mtykg4.jpg');
INSERT INTO `goodsgallery` VALUES ('635', '582', '/pic/2016/06/24/u648gm3r.jpg');
INSERT INTO `goodsgallery` VALUES ('636', '582', '/pic/2016/06/24/3bnjxap4.jpg');
INSERT INTO `goodsgallery` VALUES ('637', '582', '/pic/2016/06/24/83b9zhem.jpg');
INSERT INTO `goodsgallery` VALUES ('661', '592', '/pic/2016/06/24/vjfpz9wy.jpg');
INSERT INTO `goodsgallery` VALUES ('662', '592', '/pic/2016/06/24/erjb3wsz.jpg');
INSERT INTO `goodsgallery` VALUES ('663', '592', '/pic/2016/06/24/kmdw4a6p.jpg');
INSERT INTO `goodsgallery` VALUES ('677', '598', '/pic/2016/06/24/9yaq5xie.jpg');
INSERT INTO `goodsgallery` VALUES ('678', '598', '/pic/2016/06/24/asd3zhfj.png');
INSERT INTO `goodsgallery` VALUES ('679', '599', '/pic/2016/06/24/ebgywdnu.jpg');
INSERT INTO `goodsgallery` VALUES ('680', '599', '/pic/2016/06/24/bfk7zgxc.png');
INSERT INTO `goodsgallery` VALUES ('681', '600', '/pic/2016/06/24/chkqi62d.jpg');
INSERT INTO `goodsgallery` VALUES ('682', '600', '/pic/2016/06/24/2vh3d8tg.jpg');
INSERT INTO `goodsgallery` VALUES ('683', '600', '/pic/2016/06/24/w843b2pc.jpg');
INSERT INTO `goodsgallery` VALUES ('684', '601', '/pic/2016/06/24/5bwycti4.jpg');

-- ----------------------------
-- Table structure for goodsoff
-- ----------------------------
DROP TABLE IF EXISTS `goodsoff`;
CREATE TABLE `goodsoff` (
  `ID` mediumint(9) NOT NULL AUTO_INCREMENT,
  `ShopID` mediumint(9) unsigned NOT NULL,
  `Operator` varchar(30) DEFAULT NULL,
  `Remarks` text,
  `OffUserID` mediumint(9) unsigned NOT NULL,
  `OffTime` datetime NOT NULL,
  PRIMARY KEY (`ID`),
  KEY `ShopID` (`ShopID`),
  KEY `OffUserID` (`OffUserID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of goodsoff
-- ----------------------------

-- ----------------------------
-- Table structure for goodsoffdetail
-- ----------------------------
DROP TABLE IF EXISTS `goodsoffdetail`;
CREATE TABLE `goodsoffdetail` (
  `ID` mediumint(9) unsigned NOT NULL AUTO_INCREMENT,
  `GoodsOffID` mediumint(9) unsigned NOT NULL,
  `GoodsID` mediumint(9) unsigned NOT NULL,
  `OffCount` decimal(8,3) NOT NULL,
  PRIMARY KEY (`ID`),
  KEY `GoodsOffID` (`GoodsOffID`),
  KEY `GoodsID` (`GoodsID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of goodsoffdetail
-- ----------------------------

-- ----------------------------
-- Table structure for goodssale
-- ----------------------------
DROP TABLE IF EXISTS `goodssale`;
CREATE TABLE `goodssale` (
  `ID` mediumint(9) NOT NULL AUTO_INCREMENT,
  `ShopID` mediumint(9) NOT NULL,
  `Bill` decimal(10,2) NOT NULL,
  `CarriageBill` decimal(6,2) NOT NULL DEFAULT '0.00',
  `BuyerUserID` mediumint(9) NOT NULL,
  `RAID` mediumint(9) NOT NULL,
  `SaleTime` datetime NOT NULL,
  `PayStatus` tinyint(4) NOT NULL DEFAULT '0',
  `CashierUserID` mediumint(8) unsigned NOT NULL,
  `IsShow` tinyint(4) NOT NULL DEFAULT '1',
  `PayTime` datetime DEFAULT NULL,
  `CUID` mediumint(8) unsigned DEFAULT NULL,
  PRIMARY KEY (`ID`,`CashierUserID`),
  KEY `ShopID` (`ShopID`),
  KEY `BuyerUserID` (`BuyerUserID`),
  KEY `IsShow` (`IsShow`),
  KEY `CUID` (`CUID`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of goodssale
-- ----------------------------

-- ----------------------------
-- Table structure for goodssalecancel
-- ----------------------------
DROP TABLE IF EXISTS `goodssalecancel`;
CREATE TABLE `goodssalecancel` (
  `ID` mediumint(9) NOT NULL AUTO_INCREMENT,
  `GoodsSaleID` mediumint(9) NOT NULL,
  `CancelTime` datetime NOT NULL,
  `CancelUserID` mediumint(9) NOT NULL,
  `Status` tinyint(3) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `GoodsSaleID` (`GoodsSaleID`),
  KEY `CancelUserID` (`CancelUserID`),
  KEY `Status` (`Status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of goodssalecancel
-- ----------------------------

-- ----------------------------
-- Table structure for goodssalecanceldetail
-- ----------------------------
DROP TABLE IF EXISTS `goodssalecanceldetail`;
CREATE TABLE `goodssalecanceldetail` (
  `ID` mediumint(9) unsigned NOT NULL AUTO_INCREMENT,
  `GoodsSaleCancelID` mediumint(9) unsigned NOT NULL,
  `GoodsID` mediumint(9) unsigned NOT NULL,
  `CancelCount` decimal(8,3) NOT NULL,
  PRIMARY KEY (`ID`),
  KEY `GoodsSaleCancelID` (`GoodsSaleCancelID`),
  KEY `GoodsID` (`GoodsID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of goodssalecanceldetail
-- ----------------------------

-- ----------------------------
-- Table structure for goodssaledetail
-- ----------------------------
DROP TABLE IF EXISTS `goodssaledetail`;
CREATE TABLE `goodssaledetail` (
  `ID` mediumint(9) NOT NULL AUTO_INCREMENT,
  `GoodsSaleID` mediumint(9) NOT NULL,
  `GoodsID` mediumint(9) NOT NULL,
  `SaleCount` smallint(6) NOT NULL,
  `Price` decimal(8,2) NOT NULL,
  PRIMARY KEY (`ID`),
  KEY `GoodsSaleID` (`GoodsSaleID`),
  KEY `GoodsID` (`GoodsID`),
  KEY `SaleCount` (`SaleCount`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of goodssaledetail
-- ----------------------------

-- ----------------------------
-- Table structure for goods_tec_rel
-- ----------------------------
DROP TABLE IF EXISTS `goods_tec_rel`;
CREATE TABLE `goods_tec_rel` (
  `ID` mediumint(9) unsigned NOT NULL AUTO_INCREMENT COMMENT '标识码',
  `GoodsID` mediumint(9) unsigned NOT NULL COMMENT '建材ID',
  `TecID` smallint(6) unsigned NOT NULL COMMENT '工艺ID',
  PRIMARY KEY (`ID`),
  KEY `MatID` (`GoodsID`),
  KEY `TecID` (`TecID`)
) ENGINE=InnoDB AUTO_INCREMENT=146 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of goods_tec_rel
-- ----------------------------
INSERT INTO `goods_tec_rel` VALUES ('5', '54', '0');
INSERT INTO `goods_tec_rel` VALUES ('48', '83', '0');
INSERT INTO `goods_tec_rel` VALUES ('49', '84', '0');
INSERT INTO `goods_tec_rel` VALUES ('62', '96', '0');
INSERT INTO `goods_tec_rel` VALUES ('65', '99', '0');
INSERT INTO `goods_tec_rel` VALUES ('66', '100', '0');
INSERT INTO `goods_tec_rel` VALUES ('67', '101', '0');
INSERT INTO `goods_tec_rel` VALUES ('68', '102', '0');
INSERT INTO `goods_tec_rel` VALUES ('69', '103', '0');
INSERT INTO `goods_tec_rel` VALUES ('70', '104', '0');
INSERT INTO `goods_tec_rel` VALUES ('71', '105', '0');
INSERT INTO `goods_tec_rel` VALUES ('72', '106', '0');
INSERT INTO `goods_tec_rel` VALUES ('73', '107', '0');
INSERT INTO `goods_tec_rel` VALUES ('74', '108', '0');
INSERT INTO `goods_tec_rel` VALUES ('75', '109', '0');
INSERT INTO `goods_tec_rel` VALUES ('76', '110', '0');
INSERT INTO `goods_tec_rel` VALUES ('77', '111', '0');
INSERT INTO `goods_tec_rel` VALUES ('79', '113', '0');
INSERT INTO `goods_tec_rel` VALUES ('81', '115', '0');
INSERT INTO `goods_tec_rel` VALUES ('82', '116', '0');
INSERT INTO `goods_tec_rel` VALUES ('83', '117', '0');
INSERT INTO `goods_tec_rel` VALUES ('85', '118', '0');
INSERT INTO `goods_tec_rel` VALUES ('86', '119', '0');
INSERT INTO `goods_tec_rel` VALUES ('87', '120', '0');
INSERT INTO `goods_tec_rel` VALUES ('91', '121', '0');
INSERT INTO `goods_tec_rel` VALUES ('92', '124', '0');
INSERT INTO `goods_tec_rel` VALUES ('93', '125', '0');
INSERT INTO `goods_tec_rel` VALUES ('94', '126', '0');
INSERT INTO `goods_tec_rel` VALUES ('95', '127', '0');
INSERT INTO `goods_tec_rel` VALUES ('96', '128', '0');
INSERT INTO `goods_tec_rel` VALUES ('97', '129', '0');
INSERT INTO `goods_tec_rel` VALUES ('102', '134', '0');
INSERT INTO `goods_tec_rel` VALUES ('103', '132', '0');
INSERT INTO `goods_tec_rel` VALUES ('104', '131', '0');
INSERT INTO `goods_tec_rel` VALUES ('105', '130', '0');
INSERT INTO `goods_tec_rel` VALUES ('106', '135', '0');
INSERT INTO `goods_tec_rel` VALUES ('107', '136', '0');
INSERT INTO `goods_tec_rel` VALUES ('108', '137', '0');
INSERT INTO `goods_tec_rel` VALUES ('109', '138', '0');
INSERT INTO `goods_tec_rel` VALUES ('110', '139', '0');
INSERT INTO `goods_tec_rel` VALUES ('112', '140', '0');
INSERT INTO `goods_tec_rel` VALUES ('113', '141', '0');
INSERT INTO `goods_tec_rel` VALUES ('114', '142', '0');
INSERT INTO `goods_tec_rel` VALUES ('115', '143', '0');
INSERT INTO `goods_tec_rel` VALUES ('116', '144', '0');
INSERT INTO `goods_tec_rel` VALUES ('117', '145', '0');
INSERT INTO `goods_tec_rel` VALUES ('118', '146', '0');
INSERT INTO `goods_tec_rel` VALUES ('119', '147', '0');
INSERT INTO `goods_tec_rel` VALUES ('120', '148', '0');
INSERT INTO `goods_tec_rel` VALUES ('121', '149', '0');
INSERT INTO `goods_tec_rel` VALUES ('122', '150', '0');
INSERT INTO `goods_tec_rel` VALUES ('123', '151', '0');
INSERT INTO `goods_tec_rel` VALUES ('124', '152', '0');
INSERT INTO `goods_tec_rel` VALUES ('125', '153', '0');
INSERT INTO `goods_tec_rel` VALUES ('127', '154', '0');
INSERT INTO `goods_tec_rel` VALUES ('129', '156', '0');
INSERT INTO `goods_tec_rel` VALUES ('131', '158', '0');
INSERT INTO `goods_tec_rel` VALUES ('134', '161', '0');
INSERT INTO `goods_tec_rel` VALUES ('135', '155', '0');
INSERT INTO `goods_tec_rel` VALUES ('136', '157', '0');
INSERT INTO `goods_tec_rel` VALUES ('137', '159', '0');
INSERT INTO `goods_tec_rel` VALUES ('138', '160', '0');
INSERT INTO `goods_tec_rel` VALUES ('139', '162', '0');
INSERT INTO `goods_tec_rel` VALUES ('140', '163', '0');
INSERT INTO `goods_tec_rel` VALUES ('141', '164', '0');
INSERT INTO `goods_tec_rel` VALUES ('142', '165', '0');
INSERT INTO `goods_tec_rel` VALUES ('143', '166', '0');
INSERT INTO `goods_tec_rel` VALUES ('144', '167', '0');
INSERT INTO `goods_tec_rel` VALUES ('145', '168', '0');

-- ----------------------------
-- Table structure for houseestate
-- ----------------------------
DROP TABLE IF EXISTS `houseestate`;
CREATE TABLE `houseestate` (
  `ID` mediumint(9) NOT NULL AUTO_INCREMENT COMMENT '???',
  `HouseEstate` varchar(30) NOT NULL COMMENT '????',
  `WorkAreaID` mediumint(9) NOT NULL COMMENT 'WorkAreaID',
  PRIMARY KEY (`ID`),
  KEY `WorkAreaID` (`WorkAreaID`)
) ENGINE=InnoDB AUTO_INCREMENT=183 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of houseestate
-- ----------------------------
INSERT INTO `houseestate` VALUES ('1', '小石城', '520103');
INSERT INTO `houseestate` VALUES ('2', '保利云山国际', '520103');
INSERT INTO `houseestate` VALUES ('3', '天誉城', '520103');
INSERT INTO `houseestate` VALUES ('4', '梦想典城', '520103');
INSERT INTO `houseestate` VALUES ('5', '枫林', '520103');
INSERT INTO `houseestate` VALUES ('6', '中大国际广场', '520103');
INSERT INTO `houseestate` VALUES ('7', '银海元隆', '520103');
INSERT INTO `houseestate` VALUES ('8', '未来方舟', '520103');
INSERT INTO `houseestate` VALUES ('9', '花果园', '520102');
INSERT INTO `houseestate` VALUES ('10', '富中蝴蝶谷', '520103');
INSERT INTO `houseestate` VALUES ('11', '黄埔国际', '520114');
INSERT INTO `houseestate` VALUES ('12', '中国铁建国际城', '520102');
INSERT INTO `houseestate` VALUES ('13', '中铁逸都国际', '520115');
INSERT INTO `houseestate` VALUES ('14', '弘宇琉森堡', '520102');
INSERT INTO `houseestate` VALUES ('15', '首开紫郡', '520102');
INSERT INTO `houseestate` VALUES ('16', '万科缇香郡', '520115');
INSERT INTO `houseestate` VALUES ('17', '保利公园2010', '520112');
INSERT INTO `houseestate` VALUES ('18', '保利溪湖', '520111');
INSERT INTO `houseestate` VALUES ('19', '绿地伊顿公馆', '520113');
INSERT INTO `houseestate` VALUES ('20', '优品城邦', '520113');
INSERT INTO `houseestate` VALUES ('21', '万科悦城', '520103');
INSERT INTO `houseestate` VALUES ('24', '乐湾国际城', '520112');
INSERT INTO `houseestate` VALUES ('27', '经典天成', '520102');
INSERT INTO `houseestate` VALUES ('28', '多彩贵州城项目', '520102');
INSERT INTO `houseestate` VALUES ('29', '澜山壹号', '520102');
INSERT INTO `houseestate` VALUES ('30', '兆基新王府', '520102');
INSERT INTO `houseestate` VALUES ('31', '东泓福源国际', '520102');
INSERT INTO `houseestate` VALUES ('32', '金熙府', '520102');
INSERT INTO `houseestate` VALUES ('33', '特兴青云都汇', '520102');
INSERT INTO `houseestate` VALUES ('34', '朝庭四季花园', '520102');
INSERT INTO `houseestate` VALUES ('35', '茶玩世界', '520102');
INSERT INTO `houseestate` VALUES ('36', '太升国际', '520102');
INSERT INTO `houseestate` VALUES ('37', '一号码头', '520102');
INSERT INTO `houseestate` VALUES ('38', '保利凤凰湾', '520102');
INSERT INTO `houseestate` VALUES ('39', '润茂贵州物联港', '520102');
INSERT INTO `houseestate` VALUES ('40', '依水丽都', '520102');
INSERT INTO `houseestate` VALUES ('41', '白晶九号', '520102');
INSERT INTO `houseestate` VALUES ('42', '红岩东郡', '520102');
INSERT INTO `houseestate` VALUES ('43', '中天世纪新城', '520102');
INSERT INTO `houseestate` VALUES ('44', '都市阳光', '520102');
INSERT INTO `houseestate` VALUES ('45', '虹祥花郡', '520102');
INSERT INTO `houseestate` VALUES ('46', '富源同坐', '520102');
INSERT INTO `houseestate` VALUES ('47', '保利国际广场', '520102');
INSERT INTO `houseestate` VALUES ('48', '亨特国际金融中心', '520102');
INSERT INTO `houseestate` VALUES ('49', '祥和家园三期嘉院', '520102');
INSERT INTO `houseestate` VALUES ('50', '花样年华', '520102');
INSERT INTO `houseestate` VALUES ('51', '世纪南山', '520102');
INSERT INTO `houseestate` VALUES ('52', '都市国际城', '520102');
INSERT INTO `houseestate` VALUES ('53', '花果园亚太中心', '520102');
INSERT INTO `houseestate` VALUES ('54', '万科城', '520103');
INSERT INTO `houseestate` VALUES ('55', '万科玲珑湾', '520103');
INSERT INTO `houseestate` VALUES ('56', '万科公园5号', '520103');
INSERT INTO `houseestate` VALUES ('57', '黔灵半山', '520103');
INSERT INTO `houseestate` VALUES ('58', '中建华府', '520103');
INSERT INTO `houseestate` VALUES ('59', '劲嘉小石城', '520103');
INSERT INTO `houseestate` VALUES ('60', '施格名门', '520103');
INSERT INTO `houseestate` VALUES ('61', '中天未来方舟', '520103');
INSERT INTO `houseestate` VALUES ('62', '金龙星岛国际', '520103');
INSERT INTO `houseestate` VALUES ('63', '亨特萃山国际社区', '520103');
INSERT INTO `houseestate` VALUES ('64', '金马国际', '520103');
INSERT INTO `houseestate` VALUES ('65', '中和宝霖广场', '520103');
INSERT INTO `houseestate` VALUES ('66', '世纪汇金广场', '520103');
INSERT INTO `houseestate` VALUES ('67', '九州十里锦城', '520103');
INSERT INTO `houseestate` VALUES ('68', '红星城市广场', '520103');
INSERT INTO `houseestate` VALUES ('69', '汇金国际广场项目', '520103');
INSERT INTO `houseestate` VALUES ('70', '金狮小区狮子组团', '520103');
INSERT INTO `houseestate` VALUES ('71', '圣泉流云林城国际', '520103');
INSERT INTO `houseestate` VALUES ('72', '旺角金座二期', '520103');
INSERT INTO `houseestate` VALUES ('73', '贝地领航', '520103');
INSERT INTO `houseestate` VALUES ('74', '君临天下', '520103');
INSERT INTO `houseestate` VALUES ('75', '住那里', '520103');
INSERT INTO `houseestate` VALUES ('76', '大上海商贸城', '520103');
INSERT INTO `houseestate` VALUES ('77', '兴隆枫丹白鹭', '520103');
INSERT INTO `houseestate` VALUES ('78', '名门国际', '520103');
INSERT INTO `houseestate` VALUES ('79', '百灵尚品一号', '520103');
INSERT INTO `houseestate` VALUES ('80', '贵阳恒大名都', '520103');
INSERT INTO `houseestate` VALUES ('81', '雄骏国际', '520103');
INSERT INTO `houseestate` VALUES ('82', '东山壹号', '520103');
INSERT INTO `houseestate` VALUES ('83', '檀溪谷', '520103');
INSERT INTO `houseestate` VALUES ('84', '宅学', '520103');
INSERT INTO `houseestate` VALUES ('85', '北京路1号', '520103');
INSERT INTO `houseestate` VALUES ('86', '黔灵文峰苑', '520103');
INSERT INTO `houseestate` VALUES ('87', '中天铭廷', '520115');
INSERT INTO `houseestate` VALUES ('88', '喀斯特公园', '520115');
INSERT INTO `houseestate` VALUES ('89', '远大美域', '520115');
INSERT INTO `houseestate` VALUES ('90', '中渝万熙城', '520115');
INSERT INTO `houseestate` VALUES ('91', '华润国际社区', '520115');
INSERT INTO `houseestate` VALUES ('92', '美的林城时代', '520115');
INSERT INTO `houseestate` VALUES ('93', '观府壹号', '520115');
INSERT INTO `houseestate` VALUES ('94', '红华新天地', '520115');
INSERT INTO `houseestate` VALUES ('95', '中铁阅山湖', '520115');
INSERT INTO `houseestate` VALUES ('96', '中渝第一城', '520115');
INSERT INTO `houseestate` VALUES ('97', '中央国际', '520115');
INSERT INTO `houseestate` VALUES ('98', '茅台国际商务中心', '520115');
INSERT INTO `houseestate` VALUES ('99', '金阳新世界花园', '520115');
INSERT INTO `houseestate` VALUES ('100', '麒龙商务港', '520115');
INSERT INTO `houseestate` VALUES ('101', '中航城', '520115');
INSERT INTO `houseestate` VALUES ('102', '贵阳富力中心', '520115');
INSERT INTO `houseestate` VALUES ('103', '广大上城', '520115');
INSERT INTO `houseestate` VALUES ('104', '北大资源梦想城', '520115');
INSERT INTO `houseestate` VALUES ('105', '天一国际广场', '520115');
INSERT INTO `houseestate` VALUES ('106', '滨湖俊园', '520115');
INSERT INTO `houseestate` VALUES ('107', '俊发城', '520115');
INSERT INTO `houseestate` VALUES ('108', '贵阳西南国际商贸城', '520115');
INSERT INTO `houseestate` VALUES ('109', '德福中心', '520115');
INSERT INTO `houseestate` VALUES ('110', '金利大厦', '520115');
INSERT INTO `houseestate` VALUES ('111', '大川白金城', '520115');
INSERT INTO `houseestate` VALUES ('112', '金龙国际花园', '520115');
INSERT INTO `houseestate` VALUES ('113', '腾祥迈德国际', '520115');
INSERT INTO `houseestate` VALUES ('114', '中天会展城', '520115');
INSERT INTO `houseestate` VALUES ('115', '大唐东原财富广场', '520115');
INSERT INTO `houseestate` VALUES ('116', '黔桂国际商务中心', '520115');
INSERT INTO `houseestate` VALUES ('117', '烈变国际广场', '520115');
INSERT INTO `houseestate` VALUES ('118', '联合广场', '520115');
INSERT INTO `houseestate` VALUES ('119', '贵阳恒大城', '520113');
INSERT INTO `houseestate` VALUES ('120', '白云南路地下商业步行', '520113');
INSERT INTO `houseestate` VALUES ('121', '天域南湖', '520113');
INSERT INTO `houseestate` VALUES ('122', '白金壹号', '520113');
INSERT INTO `houseestate` VALUES ('123', '云祥山庄', '520113');
INSERT INTO `houseestate` VALUES ('124', '绿地新都会', '520113');
INSERT INTO `houseestate` VALUES ('125', '澜岸花园', '520113');
INSERT INTO `houseestate` VALUES ('126', '温泉曦月湾', '520112');
INSERT INTO `houseestate` VALUES ('127', '恒大雅苑', '520112');
INSERT INTO `houseestate` VALUES ('128', '保利林语', '520112');
INSERT INTO `houseestate` VALUES ('129', '观云', '520112');
INSERT INTO `houseestate` VALUES ('130', '泉天下泉城首府', '520112');
INSERT INTO `houseestate` VALUES ('131', '中渝万锦城', '520112');
INSERT INTO `houseestate` VALUES ('132', '阳晨美林', '520112');
INSERT INTO `houseestate` VALUES ('133', '锦嘉汇景城', '520112');
INSERT INTO `houseestate` VALUES ('134', '青果二期壹品峰景', '520112');
INSERT INTO `houseestate` VALUES ('135', '顺海花园', '520112');
INSERT INTO `houseestate` VALUES ('136', '尚善御景', '520112');
INSERT INTO `houseestate` VALUES ('137', '幸福里', '520112');
INSERT INTO `houseestate` VALUES ('138', '阳晨总部基地', '520112');
INSERT INTO `houseestate` VALUES ('139', '城市魔方', '520112');
INSERT INTO `houseestate` VALUES ('140', '水锦花都', '520112');
INSERT INTO `houseestate` VALUES ('141', '嘉馨苑', '520112');
INSERT INTO `houseestate` VALUES ('142', '保利紫薇郡', '520112');
INSERT INTO `houseestate` VALUES ('143', '溪谷', '520111');
INSERT INTO `houseestate` VALUES ('144', '中铁城锦溪', '520111');
INSERT INTO `houseestate` VALUES ('145', '花溪碧桂园', '520111');
INSERT INTO `houseestate` VALUES ('146', '贵阳国际汽配用品采购', '520111');
INSERT INTO `houseestate` VALUES ('147', '溪山御景', '520111');
INSERT INTO `houseestate` VALUES ('148', '万科亲爱的', '520114');
INSERT INTO `houseestate` VALUES ('149', '万科大都会', '520114');
INSERT INTO `houseestate` VALUES ('150', '万科金域华府花城', '520114');
INSERT INTO `houseestate` VALUES ('151', '恒大翡翠华庭', '520114');
INSERT INTO `houseestate` VALUES ('152', '北大资源缤纷广场', '520114');
INSERT INTO `houseestate` VALUES ('153', '元琦林居', '520114');
INSERT INTO `houseestate` VALUES ('154', '恒森自在城', '520114');
INSERT INTO `houseestate` VALUES ('155', '一鸣宽城', '520114');
INSERT INTO `houseestate` VALUES ('156', '龙湾国际二期', '520114');
INSERT INTO `houseestate` VALUES ('157', '亚青城', '520114');
INSERT INTO `houseestate` VALUES ('158', '云凯熙园二期', '520114');
INSERT INTO `houseestate` VALUES ('159', '美成新都', '520114');
INSERT INTO `houseestate` VALUES ('160', '大唐果', '520114');
INSERT INTO `houseestate` VALUES ('161', '南山高地', '520114');
INSERT INTO `houseestate` VALUES ('162', '美林谷', '520114');
INSERT INTO `houseestate` VALUES ('163', '兴隆珠江湾畔', '520114');
INSERT INTO `houseestate` VALUES ('164', '兴隆城市花园沐风园', '520114');
INSERT INTO `houseestate` VALUES ('165', '星河国际', '520114');
INSERT INTO `houseestate` VALUES ('166', '银河世纪', '520181');
INSERT INTO `houseestate` VALUES ('167', '时光贵州', '520181');
INSERT INTO `houseestate` VALUES ('168', '和谐水乡', '520181');
INSERT INTO `houseestate` VALUES ('169', '君悦国际', '520181');
INSERT INTO `houseestate` VALUES ('170', '尚湖城凤凰栖', '520181');
INSERT INTO `houseestate` VALUES ('171', '中央公园', '520181');
INSERT INTO `houseestate` VALUES ('172', '逸坤尚品', '520181');
INSERT INTO `houseestate` VALUES ('173', '源兴御景华府', '520181');
INSERT INTO `houseestate` VALUES ('174', '中环国际', '520181');
INSERT INTO `houseestate` VALUES ('175', '华龙·西贵府邸', '520181');
INSERT INTO `houseestate` VALUES ('176', '中央美域', '520181');
INSERT INTO `houseestate` VALUES ('177', '中深高原明珠花园', '520181');
INSERT INTO `houseestate` VALUES ('178', '印象康城', '520181');
INSERT INTO `houseestate` VALUES ('179', '锦绣蓝湾', '520181');
INSERT INTO `houseestate` VALUES ('180', '职教城·综合服务中心', '520181');
INSERT INTO `houseestate` VALUES ('181', '泰豪e时代', '520125');
INSERT INTO `houseestate` VALUES ('182', '贵安第一城', '520125');

-- ----------------------------
-- Table structure for inquiryinfo
-- ----------------------------
DROP TABLE IF EXISTS `inquiryinfo`;
CREATE TABLE `inquiryinfo` (
  `ID` mediumint(9) NOT NULL AUTO_INCREMENT COMMENT '标识码',
  `UserID` mediumint(9) DEFAULT NULL COMMENT '用户ID',
  `NickName` varchar(20) DEFAULT NULL COMMENT '用户称呼',
  `Mobile` varchar(11) NOT NULL COMMENT '手机号码',
  `wscount` tinyint(4) NOT NULL COMMENT '卧室数量',
  `ktcount` tinyint(4) NOT NULL COMMENT '客厅数量',
  `wsjcount` tinyint(4) NOT NULL COMMENT '卫生间数量',
  `Area` decimal(7,2) NOT NULL COMMENT '套内面积',
  `HouseEstate` varchar(30) DEFAULT NULL COMMENT '所在小区',
  `DecorationStyle` varchar(15) DEFAULT NULL COMMENT '装修风格',
  `DecorationType` tinyint(4) NOT NULL COMMENT '装修模式',
  `DecorationLevel` tinyint(4) NOT NULL COMMENT '装修档次',
  `InquiryTime` datetime NOT NULL COMMENT '询价时间',
  `IsHandled` tinyint(4) NOT NULL DEFAULT '0' COMMENT '是否已处理',
  PRIMARY KEY (`ID`),
  KEY `Mobile` (`Mobile`),
  KEY `InquiryTime` (`InquiryTime`),
  KEY `IsHandled` (`IsHandled`)
) ENGINE=MyISAM AUTO_INCREMENT=127 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of inquiryinfo
-- ----------------------------

-- ----------------------------
-- Table structure for instorage
-- ----------------------------
DROP TABLE IF EXISTS `instorage`;
CREATE TABLE `instorage` (
  `ID` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `ShopID` mediumint(8) unsigned NOT NULL,
  `Type` tinyint(4) NOT NULL,
  `InTime` datetime NOT NULL,
  `RUID` mediumint(9) NOT NULL,
  `Sender` varchar(15) DEFAULT NULL,
  `SenderPhone` varchar(12) DEFAULT NULL,
  `Memo` text,
  PRIMARY KEY (`ID`),
  KEY `ShopID` (`ShopID`),
  KEY `Type` (`Type`),
  KEY `RUID` (`RUID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of instorage
-- ----------------------------

-- ----------------------------
-- Table structure for instorageexam
-- ----------------------------
DROP TABLE IF EXISTS `instorageexam`;
CREATE TABLE `instorageexam` (
  `ID` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `ISID` mediumint(8) unsigned NOT NULL,
  `SLNO` varchar(10) NOT NULL,
  `GoodsID` mediumint(8) unsigned NOT NULL,
  `RequestCount` mediumint(8) unsigned NOT NULL,
  `InCount` mediumint(8) unsigned NOT NULL,
  `EUID` mediumint(8) unsigned NOT NULL,
  `Memo` text,
  PRIMARY KEY (`ID`),
  KEY `ISID` (`ISID`),
  KEY `GoodsID` (`GoodsID`),
  KEY `EUID` (`EUID`),
  KEY `SLNO` (`SLNO`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of instorageexam
-- ----------------------------

-- ----------------------------
-- Table structure for inventory
-- ----------------------------
DROP TABLE IF EXISTS `inventory`;
CREATE TABLE `inventory` (
  `ID` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `ShopID` mediumint(9) unsigned NOT NULL,
  `UserID` mediumint(9) unsigned NOT NULL,
  `Remarks` text,
  `InventoryTime` datetime NOT NULL,
  PRIMARY KEY (`ID`),
  KEY `ShopID` (`ShopID`),
  KEY `UserID` (`UserID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of inventory
-- ----------------------------

-- ----------------------------
-- Table structure for inventorydetail
-- ----------------------------
DROP TABLE IF EXISTS `inventorydetail`;
CREATE TABLE `inventorydetail` (
  `ID` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `InventoryID` mediumint(8) unsigned NOT NULL,
  `GoodsID` mediumint(9) unsigned NOT NULL,
  `InventoryCount` decimal(8,3) NOT NULL DEFAULT '0.000',
  `BeforeCount` decimal(8,3) DEFAULT NULL,
  `AfterCount` decimal(8,3) DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `InventoryID` (`InventoryID`),
  KEY `GoodsID` (`GoodsID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of inventorydetail
-- ----------------------------

-- ----------------------------
-- Table structure for inviteworker
-- ----------------------------
DROP TABLE IF EXISTS `inviteworker`;
CREATE TABLE `inviteworker` (
  `ID` mediumint(9) NOT NULL AUTO_INCREMENT COMMENT '标识码',
  `ProjectManagerID` mediumint(9) NOT NULL COMMENT '工长ID',
  `WorkerID` mediumint(9) NOT NULL COMMENT '工人ID',
  `InviteMessage` varchar(200) DEFAULT NULL COMMENT '邀请内容',
  `InviteTime` datetime DEFAULT NULL COMMENT '邀请时间',
  `InviteState` tinyint(4) DEFAULT '0' COMMENT '状态',
  PRIMARY KEY (`ID`),
  KEY `ProjectManagerID` (`ProjectManagerID`),
  KEY `WorkerID` (`WorkerID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of inviteworker
-- ----------------------------

-- ----------------------------
-- Table structure for links
-- ----------------------------
DROP TABLE IF EXISTS `links`;
CREATE TABLE `links` (
  `ID` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `Title` varchar(90) NOT NULL,
  `Link` varchar(300) NOT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of links
-- ----------------------------

-- ----------------------------
-- Table structure for lottery
-- ----------------------------
DROP TABLE IF EXISTS `lottery`;
CREATE TABLE `lottery` (
  `ID` int(11) NOT NULL AUTO_INCREMENT COMMENT '标识码',
  `Title` varchar(60) NOT NULL COMMENT '活动名称',
  `Content` text NOT NULL COMMENT '活动内容',
  `SignStartDate` date NOT NULL,
  `SignEndDate` date NOT NULL,
  `OpenDate` date NOT NULL COMMENT '开奖日期',
  PRIMARY KEY (`ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of lottery
-- ----------------------------

-- ----------------------------
-- Table structure for lotteryitem
-- ----------------------------
DROP TABLE IF EXISTS `lotteryitem`;
CREATE TABLE `lotteryitem` (
  `ID` mediumint(9) NOT NULL AUTO_INCREMENT COMMENT '标识码',
  `LID` smallint(6) NOT NULL COMMENT '抽奖活动ID',
  `Title` varchar(30) NOT NULL COMMENT '奖项名称',
  `ItemCount` tinyint(4) NOT NULL DEFAULT '1' COMMENT '该奖项数量',
  `Prize` varchar(150) NOT NULL COMMENT '奖品',
  PRIMARY KEY (`ID`),
  KEY `LID` (`LID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of lotteryitem
-- ----------------------------

-- ----------------------------
-- Table structure for lotteryresult
-- ----------------------------
DROP TABLE IF EXISTS `lotteryresult`;
CREATE TABLE `lotteryresult` (
  `ID` smallint(6) NOT NULL AUTO_INCREMENT COMMENT '标识码',
  `LIID` smallint(6) NOT NULL COMMENT '奖项ID',
  `UserID` mediumint(9) NOT NULL COMMENT '中奖用户ID',
  PRIMARY KEY (`ID`),
  KEY `LIID` (`LIID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of lotteryresult
-- ----------------------------

-- ----------------------------
-- Table structure for lotteryuser
-- ----------------------------
DROP TABLE IF EXISTS `lotteryuser`;
CREATE TABLE `lotteryuser` (
  `ID` mediumint(9) NOT NULL AUTO_INCREMENT COMMENT '标识码',
  `LID` smallint(6) NOT NULL COMMENT '抽奖活动ID',
  `UserID` mediumint(9) NOT NULL COMMENT '参加用户ID',
  PRIMARY KEY (`ID`),
  KEY `LID` (`LID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of lotteryuser
-- ----------------------------

-- ----------------------------
-- Table structure for mallrecommendsearchkey
-- ----------------------------
DROP TABLE IF EXISTS `mallrecommendsearchkey`;
CREATE TABLE `mallrecommendsearchkey` (
  `SearchKey` varchar(45) NOT NULL,
  `RecommendTime` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of mallrecommendsearchkey
-- ----------------------------

-- ----------------------------
-- Table structure for mallsearchkey
-- ----------------------------
DROP TABLE IF EXISTS `mallsearchkey`;
CREATE TABLE `mallsearchkey` (
  `SearchKey` varchar(45) NOT NULL,
  `SearchCount` smallint(5) unsigned NOT NULL,
  `SearchTime` datetime NOT NULL,
  KEY `SearchCount` (`SearchCount`),
  KEY `SearchTime` (`SearchTime`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of mallsearchkey
-- ----------------------------

-- ----------------------------
-- Table structure for material_tec_rel
-- ----------------------------
DROP TABLE IF EXISTS `material_tec_rel`;
CREATE TABLE `material_tec_rel` (
  `ID` mediumint(9) NOT NULL AUTO_INCREMENT COMMENT '标识码',
  `MatID` mediumint(9) NOT NULL COMMENT '建材ID',
  `TecID` smallint(6) NOT NULL COMMENT '工艺ID',
  PRIMARY KEY (`ID`),
  KEY `MatID` (`MatID`),
  KEY `TecID` (`TecID`)
) ENGINE=MyISAM AUTO_INCREMENT=146 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of material_tec_rel
-- ----------------------------
INSERT INTO `material_tec_rel` VALUES ('5', '54', '0');
INSERT INTO `material_tec_rel` VALUES ('48', '83', '0');
INSERT INTO `material_tec_rel` VALUES ('49', '84', '0');
INSERT INTO `material_tec_rel` VALUES ('67', '101', '0');
INSERT INTO `material_tec_rel` VALUES ('66', '100', '0');
INSERT INTO `material_tec_rel` VALUES ('62', '96', '0');
INSERT INTO `material_tec_rel` VALUES ('65', '99', '0');
INSERT INTO `material_tec_rel` VALUES ('68', '102', '0');
INSERT INTO `material_tec_rel` VALUES ('69', '103', '0');
INSERT INTO `material_tec_rel` VALUES ('70', '104', '0');
INSERT INTO `material_tec_rel` VALUES ('71', '105', '0');
INSERT INTO `material_tec_rel` VALUES ('72', '106', '0');
INSERT INTO `material_tec_rel` VALUES ('73', '107', '0');
INSERT INTO `material_tec_rel` VALUES ('74', '108', '0');
INSERT INTO `material_tec_rel` VALUES ('75', '109', '0');
INSERT INTO `material_tec_rel` VALUES ('76', '110', '0');
INSERT INTO `material_tec_rel` VALUES ('77', '111', '0');
INSERT INTO `material_tec_rel` VALUES ('144', '167', '0');
INSERT INTO `material_tec_rel` VALUES ('79', '113', '0');
INSERT INTO `material_tec_rel` VALUES ('145', '168', '0');
INSERT INTO `material_tec_rel` VALUES ('81', '115', '0');
INSERT INTO `material_tec_rel` VALUES ('82', '116', '0');
INSERT INTO `material_tec_rel` VALUES ('83', '117', '0');
INSERT INTO `material_tec_rel` VALUES ('85', '118', '0');
INSERT INTO `material_tec_rel` VALUES ('86', '119', '0');
INSERT INTO `material_tec_rel` VALUES ('87', '120', '0');
INSERT INTO `material_tec_rel` VALUES ('91', '121', '0');
INSERT INTO `material_tec_rel` VALUES ('93', '125', '0');
INSERT INTO `material_tec_rel` VALUES ('92', '124', '0');
INSERT INTO `material_tec_rel` VALUES ('94', '126', '0');
INSERT INTO `material_tec_rel` VALUES ('95', '127', '0');
INSERT INTO `material_tec_rel` VALUES ('96', '128', '0');
INSERT INTO `material_tec_rel` VALUES ('97', '129', '0');
INSERT INTO `material_tec_rel` VALUES ('105', '130', '0');
INSERT INTO `material_tec_rel` VALUES ('104', '131', '0');
INSERT INTO `material_tec_rel` VALUES ('103', '132', '0');
INSERT INTO `material_tec_rel` VALUES ('102', '134', '0');
INSERT INTO `material_tec_rel` VALUES ('106', '135', '0');
INSERT INTO `material_tec_rel` VALUES ('107', '136', '0');
INSERT INTO `material_tec_rel` VALUES ('108', '137', '0');
INSERT INTO `material_tec_rel` VALUES ('109', '138', '0');
INSERT INTO `material_tec_rel` VALUES ('110', '139', '0');
INSERT INTO `material_tec_rel` VALUES ('112', '140', '0');
INSERT INTO `material_tec_rel` VALUES ('113', '141', '0');
INSERT INTO `material_tec_rel` VALUES ('114', '142', '0');
INSERT INTO `material_tec_rel` VALUES ('115', '143', '0');
INSERT INTO `material_tec_rel` VALUES ('116', '144', '0');
INSERT INTO `material_tec_rel` VALUES ('117', '145', '0');
INSERT INTO `material_tec_rel` VALUES ('118', '146', '0');
INSERT INTO `material_tec_rel` VALUES ('119', '147', '0');
INSERT INTO `material_tec_rel` VALUES ('120', '148', '0');
INSERT INTO `material_tec_rel` VALUES ('121', '149', '0');
INSERT INTO `material_tec_rel` VALUES ('122', '150', '0');
INSERT INTO `material_tec_rel` VALUES ('123', '151', '0');
INSERT INTO `material_tec_rel` VALUES ('124', '152', '0');
INSERT INTO `material_tec_rel` VALUES ('125', '153', '0');
INSERT INTO `material_tec_rel` VALUES ('127', '154', '0');
INSERT INTO `material_tec_rel` VALUES ('135', '155', '0');
INSERT INTO `material_tec_rel` VALUES ('129', '156', '0');
INSERT INTO `material_tec_rel` VALUES ('136', '157', '0');
INSERT INTO `material_tec_rel` VALUES ('131', '158', '0');
INSERT INTO `material_tec_rel` VALUES ('137', '159', '0');
INSERT INTO `material_tec_rel` VALUES ('138', '160', '0');
INSERT INTO `material_tec_rel` VALUES ('134', '161', '0');
INSERT INTO `material_tec_rel` VALUES ('139', '162', '0');
INSERT INTO `material_tec_rel` VALUES ('140', '163', '0');
INSERT INTO `material_tec_rel` VALUES ('141', '164', '0');
INSERT INTO `material_tec_rel` VALUES ('142', '165', '0');
INSERT INTO `material_tec_rel` VALUES ('143', '166', '0');

-- ----------------------------
-- Table structure for message
-- ----------------------------
DROP TABLE IF EXISTS `message`;
CREATE TABLE `message` (
  `ID` mediumint(9) NOT NULL AUTO_INCREMENT COMMENT '标识码',
  `Title` varchar(60) NOT NULL COMMENT '标题',
  `Content` varchar(255) NOT NULL COMMENT '内容',
  `RecUID` mediumint(9) NOT NULL COMMENT '接收人用户ID',
  `SendUID` mediumint(9) NOT NULL COMMENT '发送人用户ID',
  `SendTime` datetime NOT NULL COMMENT '发送时间',
  PRIMARY KEY (`ID`),
  KEY `RecUID` (`RecUID`),
  KEY `SendUID` (`SendUID`)
) ENGINE=MyISAM AUTO_INCREMENT=212 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of message
-- ----------------------------

-- ----------------------------
-- Table structure for projectbooking
-- ----------------------------
DROP TABLE IF EXISTS `projectbooking`;
CREATE TABLE `projectbooking` (
  `ID` mediumint(9) NOT NULL AUTO_INCREMENT COMMENT '标识码',
  `PID` mediumint(9) NOT NULL COMMENT '项目ID',
  `Bill` decimal(10,2) NOT NULL COMMENT '设计费用',
  `BillRate` varchar(50) DEFAULT NULL COMMENT '支付比例',
  `UserID` mediumint(9) NOT NULL COMMENT '设计师、工长或工人用户ID',
  `UserType` tinyint(4) NOT NULL COMMENT '用户类型',
  `UpdateUID` mediumint(9) DEFAULT NULL COMMENT '状态更新人ID',
  `State` tinyint(4) NOT NULL DEFAULT '1' COMMENT '设计订单状态',
  `CreateTime` datetime NOT NULL COMMENT '订单创建时间',
  `UpdateTime` datetime NOT NULL COMMENT '订单更新时间',
  PRIMARY KEY (`ID`),
  KEY `PID` (`PID`),
  KEY `UserID` (`UserID`),
  KEY `State` (`State`),
  KEY `UserType` (`UserType`),
  KEY `UpdateTime` (`UpdateTime`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of projectbooking
-- ----------------------------

-- ----------------------------
-- Table structure for projectbookingattachment
-- ----------------------------
DROP TABLE IF EXISTS `projectbookingattachment`;
CREATE TABLE `projectbookingattachment` (
  `ID` mediumint(9) NOT NULL AUTO_INCREMENT COMMENT '标识码',
  `PBID` mediumint(9) NOT NULL COMMENT '项目订单ID',
  `AttachUrl` varchar(100) NOT NULL COMMENT '附件在服务器上的存放地址',
  PRIMARY KEY (`ID`),
  KEY `PBID` (`PBID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of projectbookingattachment
-- ----------------------------

-- ----------------------------
-- Table structure for projectconstruction
-- ----------------------------
DROP TABLE IF EXISTS `projectconstruction`;
CREATE TABLE `projectconstruction` (
  `ID` mediumint(9) NOT NULL AUTO_INCREMENT COMMENT '标识码',
  `PBID` mediumint(9) NOT NULL COMMENT '项目订单ID',
  `SpaceType` tinyint(4) NOT NULL COMMENT '施工空间分类',
  `TecID` smallint(6) NOT NULL COMMENT '工艺流程ID',
  `ArtificialCount` decimal(8,2) NOT NULL DEFAULT '0.00' COMMENT '人工使用计量',
  `Price` smallint(9) unsigned DEFAULT NULL COMMENT '人工单位报价',
  `MatID` mediumint(9) DEFAULT NULL COMMENT '材料ID',
  `MatericalCount` decimal(8,2) NOT NULL DEFAULT '0.00' COMMENT '材料使用计量',
  `DecorationStatus` tinyint(4) NOT NULL DEFAULT '0' COMMENT '装修进度状态',
  PRIMARY KEY (`ID`),
  KEY `PBID` (`PBID`),
  KEY `SpaceType` (`SpaceType`,`TecID`),
  KEY `DecorationStatus` (`DecorationStatus`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of projectconstruction
-- ----------------------------

-- ----------------------------
-- Table structure for projectmanager
-- ----------------------------
DROP TABLE IF EXISTS `projectmanager`;
CREATE TABLE `projectmanager` (
  `ID` mediumint(9) NOT NULL AUTO_INCREMENT COMMENT '标识码',
  `UserID` mediumint(9) NOT NULL COMMENT '登录用户ID',
  `Origin` mediumint(9) DEFAULT NULL COMMENT '籍贯',
  `WorkingYear` smallint(6) DEFAULT NULL COMMENT '从业开始时间',
  `GoodStyle` varchar(15) DEFAULT NULL COMMENT '擅长装修风格',
  `Work` text COMMENT '代表作品',
  `WorkerCount` smallint(6) DEFAULT NULL COMMENT '施工队伍',
  `WorkMethod` varchar(5) DEFAULT NULL COMMENT '施工方式',
  `AcceptCount` tinyint(4) DEFAULT NULL COMMENT '承接能力',
  `WorkArea` varchar(300) DEFAULT NULL COMMENT '服务区域',
  `Intro` text COMMENT '个人简介',
  `WorkIdea` varchar(200) DEFAULT NULL COMMENT '施工理念',
  `IsRecommend` tinyint(4) NOT NULL DEFAULT '0' COMMENT '是否推荐',
  `IsShow` tinyint(4) NOT NULL DEFAULT '1' COMMENT '前台是否可见',
  `Hits` mediumint(9) NOT NULL DEFAULT '0' COMMENT '浏览次数',
  PRIMARY KEY (`ID`),
  UNIQUE KEY `UserID` (`UserID`),
  KEY `GoodStyle` (`GoodStyle`),
  KEY `WorkMethod` (`WorkMethod`),
  KEY `WorkArea` (`WorkArea`(255)),
  KEY `WorkingYear` (`WorkingYear`),
  KEY `IsShow` (`IsShow`),
  KEY `Hits` (`Hits`),
  KEY `IsRecommend` (`IsRecommend`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of projectmanager
-- ----------------------------

-- ----------------------------
-- Table structure for projects
-- ----------------------------
DROP TABLE IF EXISTS `projects`;
CREATE TABLE `projects` (
  `ID` mediumint(9) NOT NULL AUTO_INCREMENT COMMENT '标识码',
  `UPID` mediumint(9) NOT NULL COMMENT '用户项目ID',
  `Area` decimal(7,2) DEFAULT NULL COMMENT '套内实际面积',
  `ktcount` tinyint(4) DEFAULT NULL COMMENT '客厅数量',
  `wscount` tinyint(4) DEFAULT NULL COMMENT '卧室数量',
  `wsjcount` tinyint(4) DEFAULT NULL COMMENT '卫生间数量',
  `HouseType` tinyint(4) DEFAULT NULL COMMENT '房屋类型',
  `DecorationStyle` tinyint(4) DEFAULT NULL COMMENT '装修风格',
  `DecorationType` tinyint(4) DEFAULT NULL COMMENT '装修类型',
  `DecorationLevel` tinyint(4) DEFAULT NULL COMMENT '装修档次',
  `Cost` int(11) DEFAULT NULL COMMENT '项目总造价',
  `CreateTime` datetime DEFAULT NULL COMMENT '创建项目时间',
  `UpdateTime` datetime DEFAULT NULL COMMENT '更新项目时间',
  `CUID` mediumint(9) DEFAULT NULL COMMENT '该项目装修顾问',
  `ChoicePMUID` mediumint(9) DEFAULT NULL COMMENT '该项目装修方案所选择的工长的用户ID',
  PRIMARY KEY (`ID`),
  UNIQUE KEY `UPID` (`UPID`),
  KEY `CUID` (`CUID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of projects
-- ----------------------------

-- ----------------------------
-- Table structure for projectsupervision
-- ----------------------------
DROP TABLE IF EXISTS `projectsupervision`;
CREATE TABLE `projectsupervision` (
  `ID` mediumint(9) NOT NULL AUTO_INCREMENT COMMENT '标识码',
  `PBID` mediumint(9) NOT NULL COMMENT '项目订单ID',
  `PCID` mediumint(9) NOT NULL COMMENT '项目方案ID',
  `Comment` text COMMENT '监理点评',
  `Status` tinyint(4) NOT NULL COMMENT '监理状态',
  `InputTime` datetime NOT NULL COMMENT '监理信息录入时间',
  PRIMARY KEY (`ID`),
  KEY `PBID` (`PBID`),
  KEY `PCID` (`PCID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of projectsupervision
-- ----------------------------

-- ----------------------------
-- Table structure for project_cam_rel
-- ----------------------------
DROP TABLE IF EXISTS `project_cam_rel`;
CREATE TABLE `project_cam_rel` (
  `ID` mediumint(9) NOT NULL AUTO_INCREMENT COMMENT '标识码',
  `PID` mediumint(9) NOT NULL COMMENT '项目ID',
  `UseName` varchar(45) NOT NULL COMMENT '使用名称',
  `CID` smallint(6) NOT NULL COMMENT '摄像头ID',
  `AddTime` datetime NOT NULL COMMENT '加入时间',
  PRIMARY KEY (`ID`),
  KEY `PID` (`PID`),
  KEY `CID` (`CID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of project_cam_rel
-- ----------------------------

-- ----------------------------
-- Table structure for receiptaddress
-- ----------------------------
DROP TABLE IF EXISTS `receiptaddress`;
CREATE TABLE `receiptaddress` (
  `ID` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `UserID` mediumint(9) NOT NULL,
  `Area` mediumint(8) unsigned NOT NULL,
  `Address` varchar(300) NOT NULL,
  `Contact` varchar(30) NOT NULL,
  `Phone` varchar(13) NOT NULL,
  `IsDefault` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `UserID` (`UserID`),
  KEY `IsDefault` (`IsDefault`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of receiptaddress
-- ----------------------------

-- ----------------------------
-- Table structure for role
-- ----------------------------
DROP TABLE IF EXISTS `role`;
CREATE TABLE `role` (
  `ID` smallint(6) NOT NULL AUTO_INCREMENT,
  `Name` varchar(30) NOT NULL,
  `Description` varchar(300) DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of role
-- ----------------------------
INSERT INTO `role` VALUES ('1', 'asdas ', 'asdasd');

-- ----------------------------
-- Table structure for roleright
-- ----------------------------
DROP TABLE IF EXISTS `roleright`;
CREATE TABLE `roleright` (
  `ID` mediumint(9) NOT NULL AUTO_INCREMENT,
  `RoleID` smallint(6) NOT NULL,
  `ModID` smallint(6) NOT NULL,
  `RightFlag` tinyint(4) DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `RoleID` (`RoleID`),
  KEY `ModID` (`ModID`)
) ENGINE=InnoDB AUTO_INCREMENT=30 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of roleright
-- ----------------------------
INSERT INTO `roleright` VALUES ('29', '1', '5', '15');

-- ----------------------------
-- Table structure for role_user_rel
-- ----------------------------
DROP TABLE IF EXISTS `role_user_rel`;
CREATE TABLE `role_user_rel` (
  `ID` mediumint(9) unsigned NOT NULL AUTO_INCREMENT,
  `RoleID` smallint(6) NOT NULL,
  `UserID` mediumint(9) unsigned NOT NULL,
  PRIMARY KEY (`ID`),
  KEY `RoleID` (`RoleID`),
  KEY `UserID` (`UserID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of role_user_rel
-- ----------------------------

-- ----------------------------
-- Table structure for selfgoodsadd
-- ----------------------------
DROP TABLE IF EXISTS `selfgoodsadd`;
CREATE TABLE `selfgoodsadd` (
  `ID` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `GoodsID` mediumint(8) unsigned NOT NULL,
  `AddCount` smallint(6) NOT NULL,
  `AddTime` datetime NOT NULL,
  `Remarks` text,
  PRIMARY KEY (`ID`),
  KEY `GoodsID` (`GoodsID`),
  KEY `AddTime` (`AddTime`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of selfgoodsadd
-- ----------------------------

-- ----------------------------
-- Table structure for shelves
-- ----------------------------
DROP TABLE IF EXISTS `shelves`;
CREATE TABLE `shelves` (
  `ID` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `SAID` smallint(5) unsigned NOT NULL,
  `Name` varchar(45) NOT NULL,
  `Type` tinyint(4) NOT NULL,
  `Tier` varchar(255) NOT NULL,
  `TierCount` tinyint(4) NOT NULL,
  `Memo` text,
  `IsDel` varchar(255) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `SAID` (`SAID`),
  KEY `Type` (`Type`),
  KEY `IsDel` (`IsDel`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of shelves
-- ----------------------------

-- ----------------------------
-- Table structure for shop
-- ----------------------------
DROP TABLE IF EXISTS `shop`;
CREATE TABLE `shop` (
  `ID` mediumint(9) NOT NULL AUTO_INCREMENT,
  `UserID` mediumint(9) NOT NULL,
  `Name` varchar(90) NOT NULL,
  `City` mediumint(9) NOT NULL,
  `Address` varchar(120) DEFAULT NULL,
  `Postcode` varchar(6) DEFAULT NULL,
  `ContactPeople` varchar(15) NOT NULL,
  `ContactPhone` varchar(13) NOT NULL,
  `Fax` varchar(13) DEFAULT NULL,
  `Email` varchar(50) DEFAULT NULL,
  `IsDel` tinyint(4) NOT NULL DEFAULT '0',
  `Remark` text,
  `AddTime` datetime NOT NULL,
  PRIMARY KEY (`ID`),
  UNIQUE KEY `Name` (`Name`),
  KEY `City` (`City`),
  KEY `IsDel` (`IsDel`),
  KEY `UserID` (`UserID`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of shop
-- ----------------------------
INSERT INTO `shop` VALUES ('1', '1', '硬汉联盟', '520102', '市南路瓮福大厦10楼', '550000', '胡腾', '0851-85962617', '0851-85962617', 'yaohuib@qq.com', '0', '做最好的互联网装修', '0000-00-00 00:00:00');
INSERT INTO `shop` VALUES ('4', '218', '木田家具', '140302', '', '', '22', '13885082881', '', '', '0', '', '2016-03-14 10:27:52');
INSERT INTO `shop` VALUES ('6', '219', 'DCSADAS', '120101', 'ASD', '', '789456', '12345678', '', '', '0', '', '2016-03-14 12:17:09');
INSERT INTO `shop` VALUES ('8', '256', '苏菲建材家居馆', '310101', '', '', '金香', '15285003205', '', '', '0', '苏菲建材家居馆', '2016-06-21 16:36:02');
INSERT INTO `shop` VALUES ('9', '257', '惠达卫浴', '330101', '', '', '金香', '15285003205', '', '', '0', '惠达卫浴，你值得拥有！', '2016-06-22 13:21:16');
INSERT INTO `shop` VALUES ('10', '258', '林氏木业', '440601', '', '', '金香', '15285003205', '', '', '0', '林氏木业，你值得拥有', '2016-06-22 14:06:27');
INSERT INTO `shop` VALUES ('12', '260', '忧木家具', '370201', '', '', '金香', '15285003205', '', '', '0', '忧木家具，你值得拥有！', '2016-06-22 14:34:54');
INSERT INTO `shop` VALUES ('13', '264', '卡伊莲', '440601', '', '', '金香', '152850003205', '', '', '0', '卡伊莲，你值得拥有！', '2016-06-22 15:03:18');
INSERT INTO `shop` VALUES ('14', '266', '泡沫小敏', '330101', '', '', '金香', '15285003205', '', '', '0', '泡沫小敏，你值得拥有！', '2016-06-22 15:35:33');
INSERT INTO `shop` VALUES ('15', '267', '欧宜家', '440601', '', '', '金香', '15285003205', '', '', '0', '欧宜家，你值得拥有！', '2016-06-22 16:30:22');
INSERT INTO `shop` VALUES ('16', '268', '道奇', '370201', '', '', '金香', '15285003205', '', '', '0', '道奇，你值得拥有！', '2016-06-22 17:13:13');
INSERT INTO `shop` VALUES ('17', '269', '欧菲曼', '0', '', '', '金香', '15285003205', '', '', '0', '欧菲曼，你值得拥有！', '2016-06-23 13:59:13');
INSERT INTO `shop` VALUES ('18', '270', '纳美格调家居', '440101', '', '', '金香', '15285003205', '', '', '0', '纳美格调家居，你值得拥有！', '2016-06-23 15:42:57');
INSERT INTO `shop` VALUES ('20', '277', '一木家私', '520111', '牛郎关威尔豪斯家居体验中心A1栋03', '', '姚徽', '19898989898', '', '', '0', '', '2016-07-04 09:56:02');

-- ----------------------------
-- Table structure for shoppingcart
-- ----------------------------
DROP TABLE IF EXISTS `shoppingcart`;
CREATE TABLE `shoppingcart` (
  `ID` mediumint(9) NOT NULL AUTO_INCREMENT,
  `UserID` mediumint(9) NOT NULL,
  `GoodsID` mediumint(9) NOT NULL,
  `BuyCount` smallint(6) NOT NULL DEFAULT '1',
  `AddTime` datetime NOT NULL,
  PRIMARY KEY (`ID`),
  KEY `UserID` (`UserID`),
  KEY `GoodsID` (`GoodsID`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of shoppingcart
-- ----------------------------
INSERT INTO `shoppingcart` VALUES ('1', '1', '198', '1', '2016-08-19 09:34:20');

-- ----------------------------
-- Table structure for smslog
-- ----------------------------
DROP TABLE IF EXISTS `smslog`;
CREATE TABLE `smslog` (
  `ID` mediumint(9) NOT NULL AUTO_INCREMENT COMMENT '标识码',
  `Mobile` varchar(11) NOT NULL COMMENT '电话号码',
  `Content` varchar(255) DEFAULT NULL COMMENT '短信内容',
  `SMSType` tinyint(4) NOT NULL COMMENT '短信类型',
  `SendTime` datetime NOT NULL COMMENT '发送时间',
  `SendState` smallint(4) DEFAULT NULL COMMENT '发送状态',
  PRIMARY KEY (`ID`),
  KEY `Mobile` (`Mobile`),
  KEY `SMSType` (`SMSType`),
  KEY `SendTime` (`SendTime`),
  KEY `SendState` (`SendState`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of smslog
-- ----------------------------

-- ----------------------------
-- Table structure for spiderbaitlog
-- ----------------------------
DROP TABLE IF EXISTS `spiderbaitlog`;
CREATE TABLE `spiderbaitlog` (
  `ID` mediumint(9) NOT NULL AUTO_INCREMENT COMMENT '标识码',
  `UserAgent` varchar(100) DEFAULT NULL COMMENT 'UserAgent',
  `QueryString` varchar(40) DEFAULT NULL COMMENT '网址参数',
  `Referer` varchar(100) DEFAULT NULL COMMENT '来源',
  `LogTime` datetime NOT NULL COMMENT '记录时间',
  PRIMARY KEY (`ID`)
) ENGINE=MyISAM AUTO_INCREMENT=18 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of spiderbaitlog
-- ----------------------------
INSERT INTO `spiderbaitlog` VALUES ('2', 'Mozilla/5.0 (compatible; MSIE 9.0; Windows NT 6.1; Trident/5.0); 360Spider', 'amp&id=1', 'http://www.manlm.com/cartoon.php?amp&id=1', '2015-12-03 20:33:09');
INSERT INTO `spiderbaitlog` VALUES ('6', 'Googlebot-Image/1.0', 'id=1&t=1', null, '2015-12-03 20:44:18');
INSERT INTO `spiderbaitlog` VALUES ('7', 'Mozilla/5.0 (compatible; Baiduspider/2.0; +http://www.baidu.com/search/spider.html)', 'id=1&amp', null, '2015-12-03 20:58:24');
INSERT INTO `spiderbaitlog` VALUES ('9', 'Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)', 'id=1&amp', null, '2015-12-03 21:15:18');
INSERT INTO `spiderbaitlog` VALUES ('10', 'Mozilla/5.0 (compatible; Baiduspider/2.0; +http://www.baidu.com/search/spider.html)', 'id=1&', null, '2015-12-03 21:31:44');
INSERT INTO `spiderbaitlog` VALUES ('11', 'Mozilla/5.0 (compatible; Baiduspider/2.0; +http://www.baidu.com/search/spider.html)', 'id=1&t=2', null, '2015-12-03 22:05:04');
INSERT INTO `spiderbaitlog` VALUES ('12', 'Mozilla/5.0 (compatible; Baiduspider/2.0; +http://www.baidu.com/search/spider.html)', 'id=1&t=1', null, '2015-12-03 22:38:24');

-- ----------------------------
-- Table structure for storagearea
-- ----------------------------
DROP TABLE IF EXISTS `storagearea`;
CREATE TABLE `storagearea` (
  `ID` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `WareID` smallint(5) unsigned NOT NULL,
  `Name` varchar(45) NOT NULL,
  `Memo` text,
  `IsDel` tinyint(4) NOT NULL,
  PRIMARY KEY (`ID`),
  KEY `IsDel` (`IsDel`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of storagearea
-- ----------------------------

-- ----------------------------
-- Table structure for storelocation
-- ----------------------------
DROP TABLE IF EXISTS `storelocation`;
CREATE TABLE `storelocation` (
  `SLNO` varchar(10) NOT NULL,
  `ShelvesID` mediumint(8) unsigned NOT NULL,
  `IsUse` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`SLNO`),
  KEY `IsUse` (`IsUse`),
  KEY `ShelvesID` (`ShelvesID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of storelocation
-- ----------------------------

-- ----------------------------
-- Table structure for supervisor
-- ----------------------------
DROP TABLE IF EXISTS `supervisor`;
CREATE TABLE `supervisor` (
  `ID` mediumint(9) NOT NULL AUTO_INCREMENT COMMENT '标识码',
  `UserID` mediumint(9) NOT NULL COMMENT '登录用户ID',
  `Origin` mediumint(9) DEFAULT NULL COMMENT '籍贯',
  `WorkingYear` smallint(6) DEFAULT NULL COMMENT '从业开始时间',
  `Price` smallint(6) DEFAULT NULL COMMENT '收费',
  `AcceptCount` tinyint(4) DEFAULT NULL COMMENT '承接能力',
  `WorkArea` varchar(300) DEFAULT NULL COMMENT '服务区域',
  `Intro` text COMMENT '个人简介',
  `SupervisorIdea` varchar(200) DEFAULT NULL COMMENT '监理理念',
  `IsShow` tinyint(4) NOT NULL DEFAULT '1' COMMENT '前台是否可见',
  `Hits` mediumint(9) NOT NULL DEFAULT '0' COMMENT '浏览次数',
  PRIMARY KEY (`ID`),
  UNIQUE KEY `UserID` (`UserID`),
  KEY `WorkArea` (`WorkArea`(255)),
  KEY `WorkingYear` (`WorkingYear`),
  KEY `Price` (`Price`),
  KEY `AcceptCount` (`AcceptCount`),
  KEY `IsShow` (`IsShow`),
  KEY `Hits` (`Hits`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of supervisor
-- ----------------------------

-- ----------------------------
-- Table structure for systemconfig
-- ----------------------------
DROP TABLE IF EXISTS `systemconfig`;
CREATE TABLE `systemconfig` (
  `ConfigName` varchar(50) NOT NULL,
  `ConfigValue` varchar(300) DEFAULT NULL,
  PRIMARY KEY (`ConfigName`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of systemconfig
-- ----------------------------
INSERT INTO `systemconfig` VALUES ('WebSiteName', '硬汉联盟');
INSERT INTO `systemconfig` VALUES ('WebSiteDomain', 'www.manlm.com');
INSERT INTO `systemconfig` VALUES ('WebSiteKeyWord', '硬汉联盟　设计师、工长、监理、工人雇佣平台　省钱省力省心的互联网家装模式 贵阳装修公司');
INSERT INTO `systemconfig` VALUES ('WebSiteTel', '0851-85962617');
INSERT INTO `systemconfig` VALUES ('WebSiteQQ', '2832828159');

-- ----------------------------
-- Table structure for user
-- ----------------------------
DROP TABLE IF EXISTS `user`;
CREATE TABLE `user` (
  `ID` mediumint(9) NOT NULL AUTO_INCREMENT COMMENT '???',
  `UserName` varchar(20) DEFAULT NULL COMMENT '???',
  `Password` varchar(32) DEFAULT NULL COMMENT '??',
  `BaseUserType` tinyint(4) DEFAULT '1' COMMENT '??????',
  `TrueName` varchar(24) DEFAULT NULL COMMENT '??',
  `Sex` tinyint(4) DEFAULT NULL COMMENT '??',
  `Birthday` date DEFAULT NULL COMMENT '????',
  `Mobile` varchar(11) DEFAULT NULL COMMENT '??',
  `EMail` varchar(50) DEFAULT NULL COMMENT '????',
  `QQ` varchar(12) DEFAULT NULL COMMENT 'QQ?',
  `Weixin` varchar(50) DEFAULT NULL COMMENT '???',
  `CardNO` varchar(18) DEFAULT NULL COMMENT '?????',
  `RegTime` datetime DEFAULT NULL COMMENT '????',
  `LastLoginTime` datetime DEFAULT NULL COMMENT '??????',
  `LoginIP` varchar(15) DEFAULT NULL COMMENT '????IP',
  `IsDel` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  UNIQUE KEY `UserName` (`UserName`),
  KEY `TrueName` (`TrueName`),
  KEY `IsDel` (`IsDel`)
) ENGINE=InnoDB AUTO_INCREMENT=590 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of user
-- ----------------------------
INSERT INTO `user` VALUES ('1', 'admin', '0cd7714abdb9024f513922cafff0eaeb', '0', '管理员', '1', '1981-09-19', '13885082881', 'yaohuib@qq.com', '123456', '', '522101198109192010', '2015-10-22 11:33:14', '2016-08-19 14:48:45', '127.0.0.1', '0');
INSERT INTO `user` VALUES ('11', '13885082881', 'd9dedb565bb45e013599f9bdfbb3c174', '1', '姚徽', null, null, '13885082881', null, null, null, null, '2015-10-22 14:12:21', '2016-07-19 17:15:43', '1.204.80.138', '0');
INSERT INTO `user` VALUES ('589', '13078523748', 'a0fac9a6097792eb46ec99760a8bc510', '2', '测试案例用', '1', '0000-00-00', '13078523748', '', '', '', '', '2015-11-30 10:29:43', '2016-08-12 10:21:32', '1.204.5.15', '0');

-- ----------------------------
-- Table structure for userproject
-- ----------------------------
DROP TABLE IF EXISTS `userproject`;
CREATE TABLE `userproject` (
  `ID` mediumint(9) NOT NULL AUTO_INCREMENT COMMENT '标识码',
  `UserID` mediumint(9) NOT NULL COMMENT '登录用户ID',
  `Area` decimal(7,2) DEFAULT NULL COMMENT '套内面积',
  `HouseArea` mediumint(8) DEFAULT NULL COMMENT '房屋所在行政区',
  `HouseEstate` varchar(30) DEFAULT NULL COMMENT '所在小区',
  `HouseNumber` varchar(100) DEFAULT NULL COMMENT '门牌号',
  `ktcount` tinyint(4) DEFAULT '1' COMMENT '客厅数量',
  `wscount` tinyint(4) DEFAULT '3' COMMENT '卧室数量',
  `wsjcount` tinyint(4) DEFAULT '1' COMMENT '卫生间数量',
  `HouseType` tinyint(4) DEFAULT NULL COMMENT '房屋类型',
  `DecorationStyle` varchar(15) DEFAULT NULL COMMENT '想要装修的风格',
  `DecorationType` tinyint(4) DEFAULT NULL COMMENT '装修类型',
  `DecorationLevel` tinyint(4) DEFAULT NULL COMMENT '装修档次',
  `Budget` int(9) DEFAULT NULL COMMENT '预算',
  `CreateTime` datetime DEFAULT NULL COMMENT '创建项目时间',
  PRIMARY KEY (`ID`),
  KEY `UserID` (`UserID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of userproject
-- ----------------------------

-- ----------------------------
-- Table structure for userright
-- ----------------------------
DROP TABLE IF EXISTS `userright`;
CREATE TABLE `userright` (
  `ID` mediumint(9) unsigned NOT NULL AUTO_INCREMENT,
  `UserID` smallint(6) unsigned NOT NULL,
  `ModID` smallint(6) NOT NULL,
  `RightFlag` tinyint(4) DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `ModID` (`ModID`),
  KEY `UserID` (`UserID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of userright
-- ----------------------------

-- ----------------------------
-- Table structure for warehouse
-- ----------------------------
DROP TABLE IF EXISTS `warehouse`;
CREATE TABLE `warehouse` (
  `ID` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `Name` varchar(45) NOT NULL,
  `Area` mediumint(8) unsigned DEFAULT NULL,
  `Memo` text,
  `IsDel` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `IsDel` (`IsDel`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of warehouse
-- ----------------------------

-- ----------------------------
-- Table structure for withdrawcash
-- ----------------------------
DROP TABLE IF EXISTS `withdrawcash`;
CREATE TABLE `withdrawcash` (
  `ID` mediumint(9) NOT NULL AUTO_INCREMENT COMMENT '标识码',
  `ApplyUID` mediumint(9) NOT NULL COMMENT '提现人用户ID',
  `Bill` decimal(10,2) NOT NULL COMMENT '提现金额',
  `Account` varchar(30) NOT NULL COMMENT '提现账户',
  `Bank` varchar(45) NOT NULL COMMENT '提现银行',
  `ApplyTime` datetime NOT NULL COMMENT '提现申请时间',
  `Status` tinyint(4) NOT NULL COMMENT '提现处理状态',
  `FailContent` text COMMENT '提现处理失败描述',
  `HandleTime` datetime DEFAULT NULL COMMENT '提现处理结束时间',
  `HandleUID` mediumint(9) DEFAULT NULL COMMENT '提现处理人用户ID',
  PRIMARY KEY (`ID`),
  KEY `ApplyUID` (`ApplyUID`),
  KEY `Status` (`Status`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of withdrawcash
-- ----------------------------

-- ----------------------------
-- Table structure for workarea
-- ----------------------------
DROP TABLE IF EXISTS `workarea`;
CREATE TABLE `workarea` (
  `WorkArea` mediumint(9) NOT NULL,
  PRIMARY KEY (`WorkArea`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of workarea
-- ----------------------------

-- ----------------------------
-- Table structure for worker
-- ----------------------------
DROP TABLE IF EXISTS `worker`;
CREATE TABLE `worker` (
  `ID` mediumint(9) NOT NULL AUTO_INCREMENT COMMENT '标识码',
  `UserID` mediumint(9) NOT NULL COMMENT '登录用户ID',
  `Origin` mediumint(9) DEFAULT NULL COMMENT '籍贯',
  `WorkingYear` smallint(6) DEFAULT NULL COMMENT '从业开始时间',
  `WorkType` varchar(15) DEFAULT NULL COMMENT '工种',
  `Price` smallint(6) DEFAULT NULL COMMENT '收费',
  `AcceptCount` tinyint(4) DEFAULT NULL COMMENT '承接能力',
  `WorkArea` varchar(300) DEFAULT NULL COMMENT '服务区域',
  `Intro` text COMMENT '个人简介',
  `WorkIdea` varchar(200) DEFAULT NULL COMMENT '施工理念',
  `ProjectManagerID` mediumint(9) DEFAULT NULL COMMENT '所属工长ID',
  `IsShow` tinyint(4) NOT NULL DEFAULT '1' COMMENT '前台是否可见',
  `Hits` mediumint(9) NOT NULL DEFAULT '0' COMMENT '浏览次数',
  PRIMARY KEY (`ID`),
  UNIQUE KEY `UserID` (`UserID`),
  KEY `WorkArea` (`WorkArea`(255)),
  KEY `WorkingYear` (`WorkingYear`),
  KEY `WorkType` (`WorkType`),
  KEY `Price` (`Price`),
  KEY `ProjectManagerID` (`ProjectManagerID`),
  KEY `AcceptCount` (`AcceptCount`),
  KEY `IsShow` (`IsShow`),
  KEY `Hits` (`Hits`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of worker
-- ----------------------------

-- ----------------------------
-- Table structure for workprice
-- ----------------------------
DROP TABLE IF EXISTS `workprice`;
CREATE TABLE `workprice` (
  `ID` mediumint(9) NOT NULL AUTO_INCREMENT COMMENT '标识码',
  `UserID` mediumint(9) NOT NULL COMMENT '工长或工人用户ID',
  `UserType` tinyint(4) NOT NULL COMMENT '用户身份',
  `SpaceType` tinyint(4) NOT NULL COMMENT '施工空间分类',
  `TecID` smallint(6) NOT NULL COMMENT '工艺流程ID',
  `Price` smallint(9) unsigned NOT NULL COMMENT '报价',
  PRIMARY KEY (`ID`),
  KEY `UserID` (`UserID`),
  KEY `UserType` (`UserType`),
  KEY `SpaceType` (`SpaceType`),
  KEY `TecID` (`TecID`)
) ENGINE=MyISAM AUTO_INCREMENT=145 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of workprice
-- ----------------------------
INSERT INTO `workprice` VALUES ('16', '1', '3', '4', '11', '50');
INSERT INTO `workprice` VALUES ('27', '1', '3', '7', '16', '38');
INSERT INTO `workprice` VALUES ('26', '1', '3', '4', '16', '38');
INSERT INTO `workprice` VALUES ('4', '30', '1', '3', '7', '300');
INSERT INTO `workprice` VALUES ('5', '30', '1', '2', '8', '300');
INSERT INTO `workprice` VALUES ('6', '30', '1', '8', '19', '200');
INSERT INTO `workprice` VALUES ('29', '1', '3', '2', '3', '4');
INSERT INTO `workprice` VALUES ('18', '1', '3', '5', '6', '30');
INSERT INTO `workprice` VALUES ('21', '1', '3', '1', '3', '4');
INSERT INTO `workprice` VALUES ('22', '1', '3', '1', '64', '18');
INSERT INTO `workprice` VALUES ('23', '1', '3', '1', '66', '4');
INSERT INTO `workprice` VALUES ('24', '1', '3', '1', '63', '8');
INSERT INTO `workprice` VALUES ('25', '1', '3', '1', '52', '20');
INSERT INTO `workprice` VALUES ('28', '1', '3', '7', '17', '150');
INSERT INTO `workprice` VALUES ('30', '130', '3', '1', '1', '50');
INSERT INTO `workprice` VALUES ('40', '134', '2', '0', '3', '15');
INSERT INTO `workprice` VALUES ('45', '134', '2', '0', '7', '380');
INSERT INTO `workprice` VALUES ('38', '134', '2', '0', '1', '3');
INSERT INTO `workprice` VALUES ('41', '134', '2', '0', '2', '3');
INSERT INTO `workprice` VALUES ('42', '134', '2', '0', '4', '25');
INSERT INTO `workprice` VALUES ('43', '134', '2', '0', '5', '25');
INSERT INTO `workprice` VALUES ('44', '134', '2', '0', '6', '380');
INSERT INTO `workprice` VALUES ('46', '134', '2', '0', '8', '320');
INSERT INTO `workprice` VALUES ('47', '134', '2', '0', '9', '35');
INSERT INTO `workprice` VALUES ('48', '134', '2', '0', '10', '30');
INSERT INTO `workprice` VALUES ('49', '134', '2', '0', '11', '30');
INSERT INTO `workprice` VALUES ('50', '134', '2', '0', '12', '35');
INSERT INTO `workprice` VALUES ('51', '134', '2', '0', '13', '30');
INSERT INTO `workprice` VALUES ('52', '134', '2', '0', '14', '30');
INSERT INTO `workprice` VALUES ('53', '134', '2', '0', '15', '0');
INSERT INTO `workprice` VALUES ('54', '134', '2', '0', '16', '45');
INSERT INTO `workprice` VALUES ('55', '134', '2', '0', '17', '120');
INSERT INTO `workprice` VALUES ('56', '134', '2', '0', '18', '240');
INSERT INTO `workprice` VALUES ('57', '134', '2', '0', '19', '450');
INSERT INTO `workprice` VALUES ('58', '134', '2', '0', '20', '250');
INSERT INTO `workprice` VALUES ('59', '134', '2', '0', '22', '80');
INSERT INTO `workprice` VALUES ('60', '134', '2', '0', '23', '35');
INSERT INTO `workprice` VALUES ('61', '134', '2', '0', '24', '35');
INSERT INTO `workprice` VALUES ('62', '134', '2', '0', '25', '35');
INSERT INTO `workprice` VALUES ('63', '134', '2', '0', '26', '15');
INSERT INTO `workprice` VALUES ('64', '134', '2', '0', '27', '15');
INSERT INTO `workprice` VALUES ('65', '134', '2', '0', '28', '30');
INSERT INTO `workprice` VALUES ('66', '134', '2', '0', '29', '30');
INSERT INTO `workprice` VALUES ('67', '134', '2', '0', '30', '30');
INSERT INTO `workprice` VALUES ('68', '134', '2', '0', '31', '55');
INSERT INTO `workprice` VALUES ('69', '134', '2', '0', '32', '75');
INSERT INTO `workprice` VALUES ('70', '134', '2', '0', '33', '65');
INSERT INTO `workprice` VALUES ('71', '134', '2', '0', '34', '50');
INSERT INTO `workprice` VALUES ('72', '134', '2', '0', '35', '50');
INSERT INTO `workprice` VALUES ('73', '134', '2', '0', '36', '80');
INSERT INTO `workprice` VALUES ('74', '134', '2', '0', '37', '80');
INSERT INTO `workprice` VALUES ('75', '134', '2', '0', '38', '55');
INSERT INTO `workprice` VALUES ('76', '134', '2', '0', '39', '55');
INSERT INTO `workprice` VALUES ('77', '134', '2', '0', '46', '70');
INSERT INTO `workprice` VALUES ('78', '134', '2', '0', '48', '150');
INSERT INTO `workprice` VALUES ('79', '134', '2', '0', '49', '120');
INSERT INTO `workprice` VALUES ('80', '134', '2', '0', '50', '45');
INSERT INTO `workprice` VALUES ('81', '134', '2', '0', '51', '380');
INSERT INTO `workprice` VALUES ('82', '134', '2', '0', '52', '15');
INSERT INTO `workprice` VALUES ('83', '134', '2', '0', '53', '20');
INSERT INTO `workprice` VALUES ('84', '134', '2', '0', '54', '75');
INSERT INTO `workprice` VALUES ('85', '134', '2', '0', '55', '150');
INSERT INTO `workprice` VALUES ('86', '134', '2', '0', '56', '310');
INSERT INTO `workprice` VALUES ('87', '134', '2', '0', '58', '240');
INSERT INTO `workprice` VALUES ('88', '134', '2', '0', '59', '0');
INSERT INTO `workprice` VALUES ('89', '134', '2', '0', '60', '0');
INSERT INTO `workprice` VALUES ('90', '134', '2', '0', '61', '70');
INSERT INTO `workprice` VALUES ('91', '134', '2', '0', '62', '4');
INSERT INTO `workprice` VALUES ('92', '134', '2', '0', '63', '6');
INSERT INTO `workprice` VALUES ('93', '134', '2', '0', '64', '7');
INSERT INTO `workprice` VALUES ('94', '134', '2', '0', '65', '0');
INSERT INTO `workprice` VALUES ('95', '134', '2', '0', '66', '70');
INSERT INTO `workprice` VALUES ('96', '134', '2', '0', '67', '60');
INSERT INTO `workprice` VALUES ('97', '134', '2', '0', '68', '0');
INSERT INTO `workprice` VALUES ('98', '134', '2', '0', '69', '30');
INSERT INTO `workprice` VALUES ('99', '134', '2', '0', '70', '50');
INSERT INTO `workprice` VALUES ('100', '134', '2', '0', '71', '10');
INSERT INTO `workprice` VALUES ('101', '134', '2', '0', '72', '80');
INSERT INTO `workprice` VALUES ('102', '134', '2', '0', '73', '70');
INSERT INTO `workprice` VALUES ('103', '134', '2', '0', '74', '0');
INSERT INTO `workprice` VALUES ('104', '134', '2', '0', '75', '0');
INSERT INTO `workprice` VALUES ('105', '134', '2', '0', '76', '0');
INSERT INTO `workprice` VALUES ('106', '134', '2', '0', '77', '0');
INSERT INTO `workprice` VALUES ('107', '134', '2', '0', '81', '200');
INSERT INTO `workprice` VALUES ('108', '134', '2', '0', '82', '200');
INSERT INTO `workprice` VALUES ('109', '134', '2', '0', '83', '200');
INSERT INTO `workprice` VALUES ('110', '134', '2', '0', '84', '300');
INSERT INTO `workprice` VALUES ('111', '134', '2', '0', '85', '200');
INSERT INTO `workprice` VALUES ('112', '134', '2', '0', '87', '70');
INSERT INTO `workprice` VALUES ('113', '134', '2', '0', '88', '110');
INSERT INTO `workprice` VALUES ('114', '134', '2', '0', '89', '0');
INSERT INTO `workprice` VALUES ('115', '134', '2', '0', '90', '0');
INSERT INTO `workprice` VALUES ('116', '1', '2', '2', '3', '50');
INSERT INTO `workprice` VALUES ('117', '1', '2', '2', '85', '45');
INSERT INTO `workprice` VALUES ('118', '1', '2', '3', '3', '30');
INSERT INTO `workprice` VALUES ('130', '337', '2', '1', '4', '1');
INSERT INTO `workprice` VALUES ('129', '337', '2', '3', '3', '1');
INSERT INTO `workprice` VALUES ('128', '337', '2', '2', '3', '1');
INSERT INTO `workprice` VALUES ('122', '337', '2', '1', '3', '1');
INSERT INTO `workprice` VALUES ('123', '337', '2', '2', '3', '1');
INSERT INTO `workprice` VALUES ('124', '337', '2', '3', '3', '1');
INSERT INTO `workprice` VALUES ('125', '337', '2', '1', '4', '1');
INSERT INTO `workprice` VALUES ('126', '337', '2', '3', '4', '1');
INSERT INTO `workprice` VALUES ('127', '337', '2', '2', '4', '1');
INSERT INTO `workprice` VALUES ('131', '337', '2', '3', '4', '1');
INSERT INTO `workprice` VALUES ('132', '337', '2', '3', '86', '1');
INSERT INTO `workprice` VALUES ('133', '337', '2', '1', '3', '1');
INSERT INTO `workprice` VALUES ('134', '337', '2', '2', '86', '1');
INSERT INTO `workprice` VALUES ('135', '337', '2', '1', '86', '1');
INSERT INTO `workprice` VALUES ('136', '337', '2', '2', '4', '1');
INSERT INTO `workprice` VALUES ('137', '337', '2', '1', '86', '1');
INSERT INTO `workprice` VALUES ('138', '337', '2', '3', '86', '1');
INSERT INTO `workprice` VALUES ('139', '337', '2', '1', '3', '1');
INSERT INTO `workprice` VALUES ('140', '337', '2', '2', '3', '1');
INSERT INTO `workprice` VALUES ('141', '337', '2', '3', '3', '1');
INSERT INTO `workprice` VALUES ('142', '337', '2', '1', '4', '1');
INSERT INTO `workprice` VALUES ('143', '337', '2', '2', '86', '1');
INSERT INTO `workprice` VALUES ('144', '1', '2', '8', '10', '100');

-- ----------------------------
-- Table structure for worktechnology
-- ----------------------------
DROP TABLE IF EXISTS `worktechnology`;
CREATE TABLE `worktechnology` (
  `ID` smallint(6) unsigned NOT NULL COMMENT '标识码',
  `Name` varchar(60) NOT NULL COMMENT '工艺名称',
  `Standard` text COMMENT '工艺标准',
  `Unit` tinyint(4) DEFAULT NULL COMMENT '计量单位',
  `DefaultPrice` smallint(5) unsigned NOT NULL,
  `UseMaterial` tinyint(4) DEFAULT NULL,
  `MaterialUnit` tinyint(4) DEFAULT NULL COMMENT '材料计量单位',
  `TecType` tinyint(4) NOT NULL COMMENT '工艺流程',
  PRIMARY KEY (`ID`),
  KEY `TecType` (`TecType`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of worktechnology
-- ----------------------------
INSERT INTO `worktechnology` VALUES ('1', '墙面开槽', '以实际发生额为准（多根穿线管费用增加）。', '1', '100', '0', null, '2');
INSERT INTO `worktechnology` VALUES ('2', '地面开槽', '以实际发生额为准（多根穿线管费用增加）。', '1', '0', '0', null, '2');
INSERT INTO `worktechnology` VALUES ('3', '原墙拆除', '含人工及垃圾袋装，不含修补', '1', '0', '0', null, '1');
INSERT INTO `worktechnology` VALUES ('10', '强电铺设', '1.全室强电采用国标贵缆“玉碟牌”（单）铜芯线，客厅空调为6平方、厨房、卫生间采用4/㎡线、(若厨房卫生间更换为6平方电线每米材料费另计)，普通插座采用2.5/㎡线，照明线采用1.5/㎡线。3.护套管采用PVC硬质阻燃管。4.管内电线不得接头，分线处用分线盒，分色安装。建筑面积在120-150m2以内，线路不超过10个回路，建筑面积在150-200m2以上，线路不超过12个回路，每增加一个回路，增加500元费用;8.不含灯具.开关插座.空开箱及特种电热布线。强电按米计算：6平方55元/米；4平方45元/米；2.5及1.5平方35元/米； 线路可走顶    ', '2', '0', '1', null, '2');
INSERT INTO `worktechnology` VALUES ('11', '弱电铺设', '1.弱电线（电话.电视.网络）单独穿管。2、建筑面积在90m2以内，网线、闭路、端口分别不超过2个；电话端口1个.电话线、电视线采用国标贵缆玉碟牌专用线.网络线采用深圳“安普同方”牌专用线。弱电每增加一个端口按11元/米。4、建筑面积每增加50㎡（以90㎡为基础）网线、闭路、电话端口分别增加1个； 线路可走顶    ', '2', '0', '1', null, '2');
INSERT INTO `worktechnology` VALUES ('12', '水路铺设', '1.厨、卫上水管采用“德标”牌PPR纳米健康热熔管。2.下水管采用“联塑牌”PVC硬质管。3.不含洁具、地漏、三角阀等管口以外配件。热水管只铺设到洗面盆，花洒，洗菜盆。如需增加按60元/米计算，线路可走顶。', '2', '0', '1', null, '2');
INSERT INTO `worktechnology` VALUES ('15', '电线统一换为多股铜芯', '以实际发生额为准（布管+穿管+国标线，不足50cm，按50cm计算）。', '2', '0', '0', null, '2');
INSERT INTO `worktechnology` VALUES ('13', '2.5平方电线改造', '以实际发生额为准（布管+穿管+国标线，不足50cm，按50cm计算）。', '2', '0', '0', null, '2');
INSERT INTO `worktechnology` VALUES ('14', '4平方电线改造', '以实际发生额为准（布管+穿管+国标线，不足50cm，按50cm计算）。', '2', '0', '0', null, '2');
INSERT INTO `worktechnology` VALUES ('6', '现浇楼面', '1.标准水泥、钢筋混凝土结构,专业模板制作。2.计量方法:按投影面积计算)', '1', '0', '1', null, '1');
INSERT INTO `worktechnology` VALUES ('7', '现浇楼梯', '1.标准水泥、钢筋混凝土结构,专业模板制作。2.计量方法:按投影面积计算)', '1', '0', '1', null, '1');
INSERT INTO `worktechnology` VALUES ('8', '新建12墙体', '红砖砌墙，325号水泥,含水泥砂浆粉砰，24墙费用按市场价另计', '1', '0', '1', null, '1');
INSERT INTO `worktechnology` VALUES ('9', '粉墙', '1.用国标32.5#水泥砂浆砌筑,垂直标厚.不超过20mm,每增加10mm则费用增加5元/平方.2.计量方法:按展开平面计算,', '1', '0', '1', null, '3');
INSERT INTO `worktechnology` VALUES ('16', '防水', '1.清理基层,堵塞所有上下水管处的缝隙;涂刷德标K11高级柔性防水剂.涂刷完毕后做闭水试验48小时.2.防水返墙高度应≥300mm.如甲方要求墙面做防潮防水处理则按实际发生量计算．3。淋浴墙防水返高2000mm。4.计量方法:按展开面积计算.', '1', '0', '1', null, '3');
INSERT INTO `worktechnology` VALUES ('17', '包下水管(单管）', '1.用标准红砖或轻质砖,国标32.5#水泥砂浆砌筑,(厨房卫生间内用),可内填隔音棉，费用另计，贴砖另计.', '5', '0', '1', null, '3');
INSERT INTO `worktechnology` VALUES ('18', '包下水管(双管）', '1.用标准红砖或轻质砖,国标32.5#水泥砂浆砌筑,(厨房卫生间内用)，可内填隔音棉，费用另计,贴砖另计.', '5', '0', '1', null, '3');
INSERT INTO `worktechnology` VALUES ('19', '卫生间回填', '建筑垃圾回填，压实平整，水泥砂浆,(海螺)325号水泥浇筑，找坡。不含面层，按投影面积*厚度计算，要用其它材质，市场价另计算。', '1', '0', '1', null, '3');
INSERT INTO `worktechnology` VALUES ('26', '地面找平', '水泥砂浆,金钻32.5号水泥,砂浆厚度5cm以内,超出部份按2元/cm计,水泥抛光.', '1', '0', '1', null, '3');
INSERT INTO `worktechnology` VALUES ('25', '瓷砖铺贴3', '规格：（800*800、600*600、300*300、300*450、300*600）1.用国标（海螺)32.5#水泥、砂浆铺贴.  2.对角钩缝采用白水泥勾缝（若需专业沟缝剂，则由业主提供）。 如需拼花，斜铺，留缝则价格另计    3.限高2500mm,如超高则另项计费.  4.增加不锈钢或铝合金线条客户提供,每平米另加收人工费8元.    5.如客户要求地面造型拼花费用另计(根据设计而定).', '1', '0', '1', null, '3');
INSERT INTO `worktechnology` VALUES ('24', '瓷砖铺贴2', '规格小于300mm*300mm 1.用国标（海螺)32.5#水泥、砂浆铺贴.  2.对角钩缝采用白水泥勾缝（若需专业沟缝剂，则由业主提供）。 如需拼花，斜铺，留缝则价格另计    3.限高2500mm,如超高则另项计费.  4.增加不锈钢或铝合金线条客户提供,每平米另加收人工费8元.    5.如客户要求地面造型拼花费用另计(根据设计而定).', '1', '0', '1', null, '3');
INSERT INTO `worktechnology` VALUES ('23', '瓷砖铺贴1', '规格800mm*800mm1.用国标（海螺)32.5#水泥、砂浆铺贴.  2.对角钩缝采用白水泥勾缝（若需专业沟缝剂，则由业主提供）。 如需拼花，斜铺，留缝则价格另计    3.限高2500mm,如超高则另项计费.  4.增加不锈钢或铝合金线条客户提供,每平米另加收人工费8元.    5.如客户要求地面造型拼花费用另计(根据设计而定).', '1', '0', '1', null, '3');
INSERT INTO `worktechnology` VALUES ('22', '瓷砖铺贴（马赛克）', '1.用国标（海螺)32.5#水泥、砂浆铺贴.  2.对角钩缝采用白水泥勾缝（若需专业沟缝剂，则由业主提供）。 如需拼花，斜铺，留缝则价格另计    3.限高2500mm,如超高则另项计费.  4.增加不锈钢或铝合金线条客户提供,每平米另加收人工费8元.    5.如客户要求地面造型拼花则费用另计(根据设计而定).', '1', '0', '1', null, '3');
INSERT INTO `worktechnology` VALUES ('27', '瓷砖腰线铺贴', '1.用国标（海螺)32.5#水泥、砂浆铺贴.  2.对角钩缝采用白水泥勾缝（若需专业沟缝剂由业主提供）。 如需拼花，斜铺，留缝则价格另计.  3.限高2500mm,如超高则另项计费.  4.增加不锈钢或铝合金线条客户提供,每平米另加收人工费8元.   ', '2', '0', '1', null, '3');
INSERT INTO `worktechnology` VALUES ('28', '阳台弦子', '1.用国标（海螺)32.5#水泥、砂浆铺贴.  2.对角钩缝采用白水泥勾缝（若需专业沟缝剂由业主提供）。 如需拼花，斜铺，留缝则价格另计  3.增加不锈钢或铝合金线条客户提供,每平米另加收人工费8元.   ', '2', '0', '1', null, '3');
INSERT INTO `worktechnology` VALUES ('29', '飘窗石铺贴', '1.用国标（海螺)32.5#水泥、砂浆铺贴，含磨边 2.对角钩缝采用白水泥勾缝（若需专业沟缝剂由业主提供）。 如需拼花，斜铺，留缝则价格另计  3.限宽600mm以内.   ', '2', '0', '1', null, '3');
INSERT INTO `worktechnology` VALUES ('20', '精铺木地板', '清理基层地面→定标高、弹线→选料→安装木龙骨→实木地板打眼安装，3*4铁杉木龙骨  专用地板钉安装牢固，表面平整干净、周边顺直', '1', '0', '1', null, '3');
INSERT INTO `worktechnology` VALUES ('30', '门槛石铺贴', '1.用国标（海螺)32.5#水泥、砂浆铺贴.，含磨边 2.对角钩缝采用白水泥勾缝（若需专业沟缝剂由业主提供）。 如需拼花，斜铺，留缝则价格另计. 3.限宽300mm以内。 ', '2', '0', '1', null, '3');
INSERT INTO `worktechnology` VALUES ('31', '木龙骨吊平顶', '30mm*50mm木龙骨基架，300*300的框架，刷防火涂料，面封\\\\\\\\\\\\\\\"泰山\\\\\\\\\\\\\\\"牌纸面石膏板，(局部可用木工板新桥,九厘板做造型)．螺丝嵌入石膏板内点防锈漆，石膏板之间须留3mm-8mm缝隙，且不允许小块拼接，２．不含饰面基层处理，披灰，油漆，刷乳胶漆及灯具、线路的安装铺设，石膏装饰线条等、3.计量方法:按地面投影面积计算', '1', '0', '1', null, '3');
INSERT INTO `worktechnology` VALUES ('32', '木龙骨石膏板造型顶', '30MM*50MM木龙骨基架，300*300的框架，刷防火涂料，面封\\\\\\\\\\\\\\\"泰山\\\\\\\\\\\\\\\"牌纸面石膏板，(局部可用木工板新桥,九厘板做造型)．螺丝嵌入石膏板内点防锈漆，石膏板之间须留3mm-8mm缝隙，且不允许小块拼接，２．不含饰面基层处理，披灰，油漆，刷乳胶漆及灯具、线路的安装铺设，石膏装饰线条等、3.直线型与异性弧线取费不同 4.计量方法:按地面投影面积计算', '1', '0', '1', null, '3');
INSERT INTO `worktechnology` VALUES ('33', '轻钢龙骨石膏板造型顶', '１．轻钢龙骨基架，主骨间距≤８００mm，付骨≤４００mm，木龙骨边框固定，\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"泰山\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"牌纸面石膏板基层，(局部可用木工板新桥,九厘板做造型)．螺丝嵌入石膏板内点防锈漆，石膏板之间须留3mm-8mm缝隙，且不允许小块拼接，２．不含饰面基层处理，披灰，油漆，刷乳胶漆及灯具、线路的安装铺设，石膏装饰线条等、3.计量方法:按地面投影面积计算', '1', '0', '1', null, '3');
INSERT INTO `worktechnology` VALUES ('51', '雕花隔断', '高密板做基层，喷涂有色漆。', '1', '0', '1', null, '3');
INSERT INTO `worktechnology` VALUES ('88', '砌门跺', '木龙骨基层，内打木工板，面贴石膏板。刷白色乳胶漆.', '3', '0', '1', null, '3');
INSERT INTO `worktechnology` VALUES ('34', '走边轻钢龙骨石膏板造型顶宽0.6m内带灯槽', '１．轻钢龙骨基架，主骨间距≤８００mm，付骨≤４００mm，木龙骨边框固定，泰山牌纸面石膏板基层，(局部可用木工板新桥,九厘板做造型)．螺丝嵌入石膏板内点防锈漆，石膏板之间须留3mm-8mm缝隙，且不允许小块拼接，２．不含饰面基层处理，披灰，油漆，刷乳胶漆及灯具、线路的安装铺设，石膏装饰线条等、3.计量方法:按地面投影面积计算', '2', '0', '0', null, '3');
INSERT INTO `worktechnology` VALUES ('35', '走边木龙骨石膏板造型顶宽0.6m内带灯槽', '30mm*50mm木龙骨基架，300mm*300mm的框架，刷防火涂料，面封\\\\\\\\\\\\\\\"泰山\\\\\\\\\\\\\\\"牌纸面石膏板，(局部可用木工板新桥,九厘板做造型)．螺丝嵌入石膏板内点防锈漆，石膏板之间须留3mm-8mm缝隙，且不允许小块拼接，２．不含饰面基层处理，披灰，油漆，刷乳胶漆及灯具、线路的安装铺设，石膏装饰线条等、3.直线型与异性弧线取费不同 4.计量方法:按地面投影面积计算', '2', '0', '1', null, '3');
INSERT INTO `worktechnology` VALUES ('36', '走边木龙骨石膏板二级造型顶宽0.6m内带灯槽', '30mm*50mm木龙骨基架，300mm*300mm的框架，刷防火涂料，面封\\\\\\\\\\\\\\\"泰山\\\\\\\\\\\\\\\"牌纸面石膏板，(局部可用木工板新桥,九厘板做造型)．螺丝嵌入石膏板内点防锈漆，石膏板之间须留3mm-8mm缝隙，且不允许小块拼接，２．不含饰面基层处理，披灰，油漆，刷乳胶漆及灯具、线路的安装铺设，石膏装饰线条等、3.直线型与异性弧线取费不同 4.计量方法:按地面投影面积计算', '2', '0', '1', null, '3');
INSERT INTO `worktechnology` VALUES ('37', '走边轻钢龙骨石膏板二级造型顶宽0.6m内带灯', '１．轻钢龙骨基架，主骨间距≤８００mm，付骨≤４００mm，木龙骨边框固定，\\\\\\\\\\\\\\\"泰山\\\\\\\\\\\\\\\"牌纸面石膏板基层，(局部可用木工板新桥,九厘板做造型)．螺丝嵌入石膏板内点防锈漆，石膏板之间须留3mm-8mm缝隙，且不允许小块拼接，２．不含饰面基层处理，披灰，油漆，刷乳胶漆及灯具、线路的安装铺设，石膏装饰线条等、3.计量方法:按地面投影面积计算', '2', '0', '1', null, '3');
INSERT INTO `worktechnology` VALUES ('38', '轻钢龙骨石膏板平顶', '轻钢龙骨基架，间距400*600mm，木龙骨边框固定，纸面石膏板，(局部可用木工板,九厘板做造型),螺丝嵌入石膏板内，石膏板之间须留3mm-8mm缝隙，且不允许小块拼接，不含饰面基层处理，披灰，油漆，刷乳胶漆及灯具、线路的安装铺设，石膏装饰线条等', '1', '0', '1', null, '3');
INSERT INTO `worktechnology` VALUES ('39', '木龙骨石膏板平顶', '30mm*50mm香杉木龙骨（非标），间距300*300mm，刷防火涂料，纸面石膏板，天龙骨用金属膨胀螺栓固定(局部可用木工板,九厘板做造型),螺丝嵌入石膏板内，石膏板之间须留3mm-8mm缝隙，且不允许小块拼接，不含饰面基层处理，披灰，油漆，刷乳胶漆及灯具、线路的安装铺设，石膏装饰线条等', '1', '0', '1', null, '3');
INSERT INTO `worktechnology` VALUES ('46', '铝扣板吊顶安装', '1、铝扣板厚度在0.6mm以内。2．先弹出水平线，主龙骨间距800MM,用膨胀螺丝固定吊竿，吊件固定主龙骨与扣板龙骨,校平后安装铝扣板,内角线收边。西铝扣板(0.5MM).   3、施工中材料不得用有污染、折裂、缺菱掉角、锤伤等的。4、面板与墙面、窗帘盒、灯具等交接处要严密。5、工程量计量方法:按投影面积Ｘ１．１０（损耗）', '1', '0', '1', null, '3');
INSERT INTO `worktechnology` VALUES ('48', '饰面板假梁', '规格100*200mm内，包含清理放线、木工板基层安装、饰面板安装、不含油漆，（150*300mm饰面板假梁每米费用另计）', '1', '0', '1', null, '3');
INSERT INTO `worktechnology` VALUES ('50', '明装窗帘合', '木工板基层，石膏板', '2', '0', '1', null, '3');
INSERT INTO `worktechnology` VALUES ('49', '石膏板假梁', '规格100*200mm内，包含清理放线、木工板基层安装、石膏板安装、不含面层处理，（150*300mm石膏板假梁每米费用另计）', '1', '0', '1', null, '3');
INSERT INTO `worktechnology` VALUES ('52', '瓷砖踢脚线明装铺设', '1.用国标（海螺牌)32.5#水泥、砂浆铺贴.及白水泥勾缝，如用专业沟缝剂由业主提供(不含主材)', '2', '0', '1', null, '3');
INSERT INTO `worktechnology` VALUES ('53', '瓷砖踢脚线暗装铺设', '1.用国标（海螺牌)32.5#水泥、砂浆铺贴.及白水泥勾缝，如用专业沟缝剂由业主提供(不含主材)', '2', '0', '1', null, '3');
INSERT INTO `worktechnology` VALUES ('54', '花岗岩踢脚线铺设', '基层处理、水泥砂浆贴花岗岩踢脚线(不含主材及磨边费用)', '2', '0', '1', null, '3');
INSERT INTO `worktechnology` VALUES ('55', '石膏板造型背景墙', '基层处理、木龙骨基层、刷防火涂料，纸面石膏板，(局部可用直接板,九厘板做造型),螺丝嵌入石膏板内，石膏板之间须留3mm-8mm缝隙，不含面层处理、披灰、油漆、乳胶漆及灯具、线路、灯带的安装铺设等', '1', '0', '1', null, '3');
INSERT INTO `worktechnology` VALUES ('56', '木饰面背景墙', '3*5香杉木龙骨，刷防火涂料，九层板基层、饰面板面层、木线条，不含面层处理、披灰、油漆、乳胶漆及灯具、线路、灯带的安装铺设等', '1', '0', '1', null, '3');
INSERT INTO `worktechnology` VALUES ('58', '木框玻璃隔断墙', '木工板，饰面板，木线条，8厘大玻清玻(不含油漆)', '1', '0', '1', null, '3');
INSERT INTO `worktechnology` VALUES ('59', '墙面墙龛（双飞粉面层）', '墙面开洞，粉平处理', '3', '0', '1', null, '3');
INSERT INTO `worktechnology` VALUES ('60', '墙面墙龛（饰面板面层）', '墙面开洞，粉平处理，木工板基层，饰面板面层，木线收口(不含油漆)', '3', '0', '1', null, '3');
INSERT INTO `worktechnology` VALUES ('62', '墙顶面石膏基层找平', '１．白水泥、石膏粉、志强牌胶单面批荡，不含面漆 2.找平厚度为3mm以内,每增加厚度10mm则每平米加1０元。3.阴阳角贴pvc护角条。4.计量方法:按实际面积计算', '1', '0', '1', null, '4');
INSERT INTO `worktechnology` VALUES ('63', '涂刷乳胶漆', '1.清理面层灰尘， 两遍腻子，砂纸带灯打磨，手刷或滚涂涂刷两遍多乐士白易净乳胶漆,如甲方要求机喷则另加3元/平米。2.每单元限两种颜色，每增加一色,另加200元。  ', '1', '0', '1', null, '4');
INSERT INTO `worktechnology` VALUES ('64', '批刮环保腻子', '1.高固腻子修阴阳角、找平，批刮环保腻子两遍，带灯光打磨平整。2.如原墙、顶面空鼓建议铲除后粉平，费用则另项计算。3.阴阳角贴pvc护角条。4.如原顶面水平误差过大，会影响后期效果，建议作效平（吊顶）处理，费用则另项计算。\r\n    ', '1', '0', '1', null, '4');
INSERT INTO `worktechnology` VALUES ('65', '硅藻泥', '1.高固腻子修阴阳角、找平，批刮环保腻子两遍，带灯光打磨平整。2.如原墙、顶面空鼓建议铲除后粉平，费用则另项计算。3.硅藻泥标准工艺处理。', '1', '0', '1', null, '4');
INSERT INTO `worktechnology` VALUES ('66', '透底清油漆', '1.清理面层，补灰、打磨平整光滑，嘉宝莉环保木器漆(康倍涂)(如市场断货，可选用同品质材料)二底三面，专业喷涂工艺，光滑无流坠。2.计量方法:按展开面积计算。', '1', '0', '1', null, '4');
INSERT INTO `worktechnology` VALUES ('67', '混油油漆施工', '1.清理面层，补灰、打磨平整光滑，嘉宝莉环保木器漆(康倍涂)(如市场断货，可选用同品质材料)二底三面，专业喷涂工艺，光滑无流坠。2.计量方法:按展开面积计算。', '1', '0', '1', null, '4');
INSERT INTO `worktechnology` VALUES ('68', '吊灯安装', '主材甲供（不包艺术水晶灯）', '3', '0', '0', null, '5');
INSERT INTO `worktechnology` VALUES ('69', '吸顶灯安装', '主材甲供', '3', '0', '0', null, '5');
INSERT INTO `worktechnology` VALUES ('70', '座式马桶安装', '主材甲供', '3', '0', '0', null, '5');
INSERT INTO `worktechnology` VALUES ('71', '毛巾架等挂件安装', '主材甲供', '3', '0', '1', null, '5');
INSERT INTO `worktechnology` VALUES ('89', '材料上楼费', '直接工程款*0.5%+50*（楼层-1），含人工、装车', '1', '0', '0', null, '1');
INSERT INTO `worktechnology` VALUES ('90', '垃圾清运费', '直接工程款*0.5%+50*（楼层-1），含人工、装车、运送到小区指定位置', '1', '0', '0', null, '5');
INSERT INTO `worktechnology` VALUES ('4', '原门、门框拆除', '人工、垃圾装袋、以及修补', '1', '0', '0', null, '1');
INSERT INTO `worktechnology` VALUES ('5', '原窗、窗框拆除', '人工、垃圾装袋、以及修补', '1', '0', '0', null, '1');
INSERT INTO `worktechnology` VALUES ('72', '木质地台', '1.30mm*50mm木龙骨架，300X300间距,18mm木工板基层（新桥牌） 2.不含面层材料,及安装等费用.3地台高度120MM~200mm', '1', '0', '1', null, '3');
INSERT INTO `worktechnology` VALUES ('73', '砖砌地台', '1.用标准红砖或轻质砖,国标（金钻)32.5#水泥砂浆砌筑抹平.3地台高度120mm~240mm', '1', '0', '1', null, '3');
INSERT INTO `worktechnology` VALUES ('74', '制作进户门套', '1.25mmX40mm木龙骨、木工板基层(新桥牌),面贴榉木饰面板,九厘板门边线基层,≤60mmX8mm实木门套线条.勾边线条收口.2.不含油漆及特殊要求.＞300MM墙体则另加15元/M.3.计量方法:按门套线延长米计算.4.混油门套加收15元/m。', '2', '0', '1', null, '3');
INSERT INTO `worktechnology` VALUES ('75', '制作双面门套', '1.25mmX40mm木龙骨、木工板基层(新桥牌),面贴榉木饰面板,九厘板门边线基层,≤60mmX8mm实木门套线条.勾边线条收口.2.不含油漆及特殊要求.＞300mm墙体则另加15元/m.3.混油门套加收20元/m。', '2', '0', '1', null, '3');
INSERT INTO `worktechnology` VALUES ('76', '制作单面普通窗套', '1.25mmX40mm木龙骨、木工板基层(新桥牌),面贴榉木饰面板,九厘板门边线基层,≤60mmX8mm实木门套线条.勾边线条收口.2.不含油漆及特殊要求.＞300mm墙体则另加15元/m.4.混油型加收20/m', '2', '0', '1', null, '3');
INSERT INTO `worktechnology` VALUES ('77', '制作飘窗普通窗套', '1.木工板基层(新桥牌),面贴榉木饰面板,九厘板窗边线基层,≤60mmX8mm实木窗套线条.勾边线条收口.限宽≤600mm     2.不含石材、油漆及特殊要求,3.混油型加收40/m', '2', '0', '1', null, '3');
INSERT INTO `worktechnology` VALUES ('81', '制作衣柜、储物柜', '1、含门  2.优质木工板(新桥牌)柜体，背板9mm夹板，外贴饰面板，实木及pvc线条收边。2.限深≤600mm，＞600mm则每平米另加50元.3.柜门木工板基层，外贴饰面板实木线条收边.4.拉手客户提供，每3平米含两个抽屉，不做抽屉价格不变，若超出一个另收50元一个。4.若拼花造型，每平米另加50元.5.含标准柜门合页、抽屉滑道.6.不含油漆。若改用高级合页、滑道由客户补差价。7.计量方法:按立面面积计算.', '1', '0', '1', null, '3');
INSERT INTO `worktechnology` VALUES ('82', '制作书柜', '1.优质木工板(新桥牌)柜体，背板9mm夹板，见光面贴饰面板，内贴保丽板，实木及pvc线条收边。2.限深≤350mm，＞350mm则每平米另加50元.3.柜门木工板基层，5mm浮法白玻璃或磨砂玻璃.实木线条收边.如客户提供玻璃，报价每平米则减20元.4.拉手客户提供，每3平米含两个抽屉，不做抽屉价格不变，若超出一个另收50元一个。4.若拼花造型，每平米另加50元.5.含标准柜门合页、抽屉滑道.6.不含 油漆。若改用高级合页、滑道由客户补差价。7.计量方法:按立面面积计算.', '1', '0', '1', null, '3');
INSERT INTO `worktechnology` VALUES ('83', '制作矮柜、吊柜（饰面型）', '规格：高800mm*宽400mm 1.优质木工板(新桥牌)柜体，背板9mm夹板，外贴饰面板，实木及pvc线条收边。2.拉手客户提供，每1.2米含两个抽屉，不做抽屉价格不变，若超出另收50元/个。3.若拼花造型，视设计图另计。4.含标准柜门合页、抽屉滑道。若改用高级合页、滑道由客户补差价。5.不含油漆。6.计量方法:按延长米计算.', '2', '0', '1', null, '3');
INSERT INTO `worktechnology` VALUES ('84', '制作电视柜', '规格：高450mm*宽600mm，桌面40mm厚   1.优质木工板(新桥牌)柜体，背板9MM夹板，外贴饰面板，实木及pvc线条收边。2.限深≤600mm，＞600mm则每平米另加50元. 3.柜门木工板基层，外贴饰面板实木线条收边.4.拉手客户提供，每80mm含1个抽屉，不做抽屉价格不变，若超出一个另收50元一个。4.若拼花造型，每平米另加50元.   5.含标准柜门合页、抽屉滑道.   6.不含 油漆。若改用高级合页、滑道由客户补差价。7.计量方法:按立面面积计算.', '2', '0', '1', null, '3');
INSERT INTO `worktechnology` VALUES ('85', '制作鞋柜', '规格：宽1200mm*高1000mm*深300mm以内。1.优质木工板(新桥牌)柜体，背板9MM夹板，外贴饰面板，实木及pvc线条收边。2.拉手客户提供，含两个抽屉，不做抽屉价格不变，若超出另收50元/个。3.若拼花造型，视设计图另计。4.含标准柜门合页、抽屉滑道。若改用高级合页、滑道由客户补差价。5.不含油漆。6.计量方法:按平方计算.', '1', '0', '1', null, '3');
INSERT INTO `worktechnology` VALUES ('86', '百叶造型柜门', '1.双层12厘夹板条框架压制 ，面层饰面板饰面（饰面板60元/张） ，50mm*8mm实木线条制做百页，含小五金配件，不含锁具。', '1', '0', '1', null, '0');
INSERT INTO `worktechnology` VALUES ('61', '入墙层板', '规格：30mm厚,凸墙350mm以内   1、优质免漆板基层，饰面见设计图。2、计量方法：按延长米计算。', '2', '0', '1', null, '3');
INSERT INTO `worktechnology` VALUES ('87', '封门头', '木龙骨基层，内打木工板，面贴石膏板。刷白色乳胶漆.', '3', '0', '1', null, '3');

-- ----------------------------
-- Procedure structure for Update_goodssalePayStatus
-- ----------------------------
DROP PROCEDURE IF EXISTS `Update_goodssalePayStatus`;
DELIMITER ;;
CREATE DEFINER=`manlm`@`%` PROCEDURE `Update_goodssalePayStatus`()
BEGIN 
	Update  goodssale   set  PayStatus=4   where  PayStatus=1 and (DATEDIFF(now(),PayTime) >= 15);
END
;;
DELIMITER ;

-- ----------------------------
-- Event structure for Update_goodssalePayStatus
-- ----------------------------
DROP EVENT IF EXISTS `Update_goodssalePayStatus`;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` EVENT `Update_goodssalePayStatus` ON SCHEDULE EVERY 1 DAY STARTS '2016-06-30 02:00:00' ON COMPLETION NOT PRESERVE ENABLE DO call Update_goodssalePayStatus()
;;
DELIMITER ;
