<?php
function getBillPaid($pbid) {//获得某项目订单已缴费的金额
	$paidbill = 0;
	include_once $_SERVER['DOCUMENT_ROOT'] . "/data/config.php";
	$conn = new mysqli($GLOBALS['db_host'], $GLOBALS['db_user'], $GLOBALS['db_pass'], $GLOBALS['db_name']);
	$billrs = $conn->query("select sum(bill) from bookingpay where out_trade_no like 'PBD" . $pbid . "-%'");
	if ($billrs) {
		$row = $billrs->fetch_array();
		if ($row[0] != "") {
			$paidbill = $row[0];
		}
		$billrs->free();
	}
	$conn->close();
	return $paidbill;
}


function getNeedPayBill($totalbill, $billrate, $paystep, &$billinfo = '', $pbid) {//根据费用比例来确定某个环节该支付的费用，并可计算出每个支付环节应支付的费用，该信息放在$billinfo中
	$billratearray = explode(',', $billrate);
	$frontpaybill = 0;
	$currpaybill = 0;
	for ($i = 0; $i < count($billratearray); $i++) {
		$billratearray[$i] = trim($billratearray[$i]);
		$billinfoarray = explode('|', $billratearray[$i]);
		$billinfoarray[1] = trim($billinfoarray[1]);
		if (is_numeric($billinfoarray[1])) {
			$currpaybill = round($totalbill * (float)$billinfoarray[1] / 10, 2);
			$billinfoarray[1] = $currpaybill;
			if ($i < count($billratearray) - 1) $frontpaybill += $currpaybill;
		} else {
			$billinfoarray[1] = '0';
		}
		if ($paystep == $i + 1) {
			$returnvalue = $billinfoarray[1];
		} elseif ($paystep == count($billratearray)) {
			$returnvalue = getBillPaid($pbid);
		}
		if ($i + 1 == count($billratearray)) {
			$billinfoarray[1] = $totalbill - $frontpaybill;
		}
		$billinfoarray[1] = '￥' . $billinfoarray[1];
		$billratearray[$i] = implode(':', $billinfoarray);
	}
	$billinfo = implode(';', $billratearray);
	return $returnvalue;
}


function getPayStepName($billrate, $paystep) {//得到某一付款步骤的名称
	$billratearray = explode(',', $billrate);
	if (count($billratearray) >= $paystep) {
		$billinfoarray = explode('|', $billratearray[$paystep - 1]);
		$returnvalue = $billinfoarray[0];
	} else { $returnvalue = ''; }
	return $returnvalue;
}


function getBalanceBill($pbid) {//用于结算某项目订单可结算的金额
	$banlacedbill = 0;
	$paidbill = 0;
	$querystr = 'PB_' . $pbid . '-%';
	include $_SERVER['DOCUMENT_ROOT'] . "/data/config.php";
	$conn = new mysqli($db_host, $db_user, $db_pass, $db_name);
	$billrs = $conn->prepare("select sum(bill) from bookingpay where out_trade_no like ?");
	$billrs->bind_param("s", $querystr);
	$billrs->execute();
	if ($billrs) {
		$billrs->bind_result($paidbill);
		$billrs->fetch();
	}
	$billrs->close();
	$paidbill = round($paidbill, 2);
	//查询该项目订单已支付的款项
	
	$billrs = $conn->prepare("select sum(bill) from balance where pbid = ?");
	$billrs->bind_param("s", $pbid);
	$billrs->execute();
	if ($billrs) {
		$billrs->bind_result($banlacedbill);
		$billrs->fetch();
	}
	$billrs->close();
	//查询该项目订单已经结算的款项
	$conn->close();
	return round($paidbill - $banlacedbill, 2);
}


function getWithDrawCashBill($userid) {//用于计算某用户可体现的金额
	$balancebill = 0;
	$cashedbill = 0;
	$cancashbill = 0;
	include $_SERVER['DOCUMENT_ROOT'] . "/data/config.php";
	$conn = new mysqli($db_host, $db_user, $db_pass, $db_name);
	$billrs = $conn->prepare("select sum(bill) from Balance where PBID in (select ID from ProjectBooking where UserID= ?)");
	$billrs->bind_param("s", $userid);
	$billrs->execute();
	if ($billrs) {
		$billrs->bind_result($balancebill);
		$billrs->fetch();
	}
	$billrs->close();
	//取得该用户已结算的金额
	
	$billrs = $conn->prepare("select sum(bill) from WithdrawCash where ApplyUID= ? and Status = 1");
	$billrs->bind_param("s", $userid);
	$billrs->execute();
	if ($billrs) {
		$billrs->bind_result($cashedbill);
		$billrs->fetch();
	}
	$billrs->close();
	//查询该用户已提现的金额
	$cancashbill = round($balancebill - $cashedbill, 2);
	if ($cancashbill < 0) $cancashbill = 0;
	return $cancashbill;
}
?>