<?php
/* *
 * 功能：支付宝服务器异步通知页面
 * 版本：3.3
 * 日期：2012-07-23
 * 说明：
 * 以下代码只是为了方便商户测试而提供的样例代码，商户可以根据自己网站的需要，按照技术文档编写,并非一定要使用该代码。
 * 该代码仅供学习和研究支付宝接口使用，只是提供一个参考。


 *************************页面功能说明*************************
 * 创建该页面文件时，请留心该页面文件中无任何HTML代码及空格。
 * 该页面不能在本机电脑测试，请到服务器上做测试。请确保外部可以访问该页面。
 * 该页面调试工具请使用写文本函数logResult，该函数已被默认关闭，见alipay_notify_class.php中的函数verifyNotify
 * 如果没有收到该页面返回的 success 信息，支付宝会在24小时内按一定的时间策略重发通知
 */

require_once("alipay.config.php");
require_once("lib/alipay_notify.class.php");

//计算得出通知验证结果
$alipayNotify = new AlipayNotify($alipay_config);
$verify_result = $alipayNotify->verifyNotify();

//if($verify_result) {//验证成功
if(true) {//验证成功
	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//请在这里加上商户的业务逻辑程序代
	
	//——请根据您的业务逻辑来编写程序（以下代码仅作参考）——
	
    //获取支付宝的通知返回参数，可参考技术文档中服务器异步通知参数列表
	
	//商户订单号

	$out_trade_no = $_POST['out_trade_no'];

	//支付宝交易号

	$trade_no = $_POST['trade_no'];

	//交易状态
	$trade_status = $_POST['trade_status'];
	
	$total_fee = $_POST['total_fee'];
	switch ($trade_status) {
	case "WAIT_BUYER_PAY":
		$trade_statusint = 0;
		break;
	case "TRADE_SUCCESS":
		$trade_statusint = 1;
		break;
	case "TRADE_FINISHED":
		$trade_statusint = 2;
		break;
	case "TRADE_CLOSED":
		$trade_statusint = 3;
		break;
	case "TRADE_PENDING":
		$trade_statusint = 4;
	}
	
	logResult(";o=" . $out_trade_no . ";b=" . $total_fee . ";be=" . $_POST['buyer_email'] . ";t=" . $trade_no . ";s=" . $trade_statusint . ".   ");	
	require_once $_SERVER['DOCUMENT_ROOT']."/data/config.php";
	$conn = new mysqli($db_host, $db_user, $db_pass, $db_name);
	$result = $conn->query("select id from bookingpay where out_trade_no = '" . $out_trade_no . "'");
	if ($result) {
		if ($result->num_rows > 0) {
			$row =$result->fetch_array();
			$bpid = $row[0];
		} else {
			$bpid = 0;
		}
		$result->free();
	}
	//查询该支付订单数据是否已在订单支付表中存在
	
	if ($bpid < 1) {
		$result = $conn->prepare("insert into bookingpay (out_trade_no, bill, buyer_email, trade_no, gmt_create, gmt_payment, gmt_close, trade_status) values (?, ?, ?, ?, ?, ?, ?, ?)");
		$result->bind_param("sdsssssi", $out_trade_no, $total_fee, $_POST['buyer_email'], $trade_no, $_POST['gmt_create'], $_POST['gmt_payment'], $_POST['gmt_close'], $trade_statusint);
	} else {
		$result = $conn->prepare("update bookingpay set bill = ?, buyer_email = ?, trade_no = ?, gmt_create = ?, gmt_payment = ?, gmt_close = ?, trade_status = ? where out_trade_no = ?");
		$result->bind_param("dsssssis", $total_fee, $_POST['buyer_email'], $trade_no, $_POST['gmt_create'], $_POST['gmt_payment'], $_POST['gmt_close'], $trade_statusint, $out_trade_no);
	}
	$result->execute();
	$result->close();
	
    if($trade_status == 'TRADE_FINISHED') {
		//判断该笔订单是否在商户网站中已经做过处理
			//如果没有做过处理，根据订单号（out_trade_no）在商户网站的订单系统中查到该笔订单的详细，并执行商户的业务程序
			//请务必判断请求时的total_fee、seller_id与通知时获取的total_fee、seller_id为一致的
			//如果有做过处理，不执行商户的业务程序
				
		//注意：
		//退款日期超过可退款期限后（如三个月可退款），支付宝系统发送该交易状态通知

        //调试用，写文本函数记录程序运行情况是否正常
        //logResult("这里写入想要调试的代码变量值，或其他运行的结果记录");
    }
    else if ($trade_status == 'TRADE_SUCCESS') {
		//判断该笔订单是否在商户网站中已经做过处理
			//如果没有做过处理，根据订单号（out_trade_no）在商户网站的订单系统中查到该笔订单的详细，并执行商户的业务程序
			//请务必判断请求时的total_fee、seller_id与通知时获取的total_fee、seller_id为一致的
			//如果有做过处理，不执行商户的业务程序
				
		//注意：
		//付款完成后，支付宝系统发送该交易状态通知

        //调试用，写文本函数记录程序运行情况是否正常
        //logResult("这里写入想要调试的代码变量值，或其他运行的结果记录");
		$GoodsType = substr($out_trade_no, 0, 5);	
		if ($GoodsType  == "GOODS")
		{
				$first = stripos($out_trade_no,'-');
	            $last = strripos($out_trade_no,'-');
	            $resstr = substr($out_trade_no, $first+1, $last-$first-1);
				$arr = explode('-',$resstr);
			    foreach ($arr as $sgid)
			    {
				   if ($sgid > 0)
				   {
				     $updatetime = date("Y-m-d H:i:s");
		             $result = $conn->prepare("update GoodsSale set PayStatus = ?, PayTime = ?  where id = ?");
		             $result->bind_param("isi", $trade_statusint,  $updatetime, $sgid);
		             $result->execute();
		             $result->close();
				  }
			   }
		}
		else
		{
		$pbtype = substr($out_trade_no, 2, 1);
		$pbstateStr = substr($out_trade_no, strlen($out_trade_no) - 1-16, 1);
		switch ($pbtype) {
		case "D":
			switch ($pbstateStr) {
			case 1:
				$pbstate = 3;
				break;
			case 2:
				$pbstate = 6;
			}
			break;
		case "P":
			switch ($pbstateStr) {
			case 1:
				$pbstate = 3;
				break;
			case 2:
				$pbstate = 5;
				break;
			case 3:
				$pbstate = 7;
			}
			break;
		case "W":
			switch ($pbstateStr) {
			case 1:
				$pbstate = 3;
				break;
			case 2:
				$pbstate = 5;
			}
			break;
		case "S":
			switch ($pbstateStr) {
			case 1:
				$pbstate = 3;
				break;
			case 2:
				$pbstate = 5;
			}
			break;
		}
		//$flagpos = strpos($out_trade_no, "-");
		$pbid = substr($out_trade_no, 3, strlen($out_trade_no) - 5-16);
		$updatetime = date("Y-m-d H:i:s");
		$result = $conn->prepare("update projectbooking set state = ?, updateuid = ?, updatetime = ? where id = ?");
		$result->bind_param("iisi", $pbstate, $_SESSION['userid'], $updatetime, $pbid);
		$result->execute();
		$result->close();
		}
    }
	$conn->close();

	//——请根据您的业务逻辑来编写程序（以上代码仅作参考）——
        
	echo "success";		//请不要修改或删除
}
else {
    //验证失败
    echo "fail";

    //调试用，写文本函数记录程序运行情况是否正常
    //logResult("这里写入想要调试的代码变量值，或其他运行的结果记录");
}
?>