DROP TABLE IF EXISTS `tc_about`;
CREATE TABLE IF NOT EXISTS `tc_about` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `title` varchar(100) NOT NULL,
  `keywords` varchar(100) NOT NULL,
  `description` varchar(255) NOT NULL,
  `content` text NOT NULL,
  `postdate` int(11) NOT NULL,
  `url` varchar(100) NOT NULL,
  `aboutorder` smallint(5) NOT NULL default '0',
  `is_show` tinyint(1) unsigned NOT NULL,
  `pageid` tinyint(1) NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `is_show` (`is_show`)
) TYPE=MyISAM AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `tc_admin`;
CREATE TABLE IF NOT EXISTS `tc_admin` (
  `userid` smallint(5) unsigned NOT NULL auto_increment,
  `username` varchar(30) NOT NULL,
  `password` varchar(32) NOT NULL,
  `truename` varchar(30) NOT NULL,
  `email` varchar(35) NOT NULL,
  `purview` text NOT NULL,
  `is_admin` tinyint(1) NOT NULL,
  `lastip` varchar(15) NOT NULL,
  `lastlogin` int(11) unsigned NOT NULL,
  PRIMARY KEY  (`userid`),
  KEY `username` (`username`)
) TYPE=MyISAM AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `tc_admin_log`;
CREATE TABLE IF NOT EXISTS `tc_admin_log` (
  `logid` int(10) unsigned NOT NULL auto_increment,
  `adminname` varchar(32) NOT NULL,
  `logdate` int(10) unsigned NOT NULL,
  `logtype` varchar(255) NOT NULL,
  `logip` varchar(15) NOT NULL,
  PRIMARY KEY  (`logid`)
) TYPE=MyISAM AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `tc_area`;
CREATE TABLE IF NOT EXISTS `tc_area` (
  `areaid` mediumint(6) NOT NULL auto_increment,
  `areaname` varchar(32) NOT NULL,
  `parentid` int(11) unsigned NOT NULL,
  `areaorder` smallint(6) NOT NULL,
  PRIMARY KEY  (`areaid`),
  KEY `areaname` (`areaname`)
) TYPE=MyISAM AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `tc_article`;
CREATE TABLE IF NOT EXISTS `tc_article` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `typeid` smallint(5) NOT NULL,
  `areaid` smallint(5) NOT NULL,
  `title` varchar(100) NOT NULL,
  `keywords` varchar(100) NOT NULL,
  `description` varchar(255) NOT NULL,
  `content` text NOT NULL,
  `thumb` varchar(50) NOT NULL,
  `listorder` smallint(5) NOT NULL default '0',
  `addtime` int(11) NOT NULL,
  `is_index` tinyint(1) unsigned NOT NULL,
  `is_pro` tinyint(1) unsigned NOT NULL,
  `click` int(11) NOT NULL,
  `comid` int(11) NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `is_index` (`is_index`),
  KEY `addtime` (`addtime`),
  KEY `is_pro` (`is_pro`)
) ENGINE=MyISAM AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `tc_card`;
CREATE TABLE IF NOT EXISTS `tc_card` (
  `id` int(11) NOT NULL auto_increment,
  `cardnum` int(6) NOT NULL,
  `cardkey` varchar(8) NOT NULL,
  `money` float NOT NULL,
  `userid` int(11) NOT NULL,
  `comid` int(11) NOT NULL,
  `acttime` int(11) NOT NULL,
  PRIMARY KEY  (`id`)
) TYPE=MyISAM AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `tc_card_fc`;
CREATE TABLE IF NOT EXISTS `tc_card_fc` (
  `id` int(11) NOT NULL auto_increment,
  `cardnum` int(6) NOT NULL,
  `fc` float NOT NULL,
  `siso` float NOT NULL,
  `userid` int(11) NOT NULL,
  `comid` int(11) NOT NULL,
  `addtime` int(11) NOT NULL,
  PRIMARY KEY  (`id`)
) TYPE=MyISAM AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `tc_com`;
CREATE TABLE IF NOT EXISTS `tc_com` (
  `comid` mediumint(6) unsigned NOT NULL auto_increment,
  `userid` int(11) unsigned NOT NULL,
  `catid` smallint(5) unsigned NOT NULL,
  `areaid` smallint(5) unsigned NOT NULL,
  `comname` varchar(100) NOT NULL,
  `thumb` varchar(50) NOT NULL,
  `introduce` text,
  `shoptip` varchar(200) NOT NULL,
  `phone` varchar(15) NOT NULL,
  `address` varchar(100) NOT NULL,
  `hours` varchar(50) NOT NULL,
  `mappoint` varchar(16) NOT NULL,
  `is_check` tinyint(1) unsigned NOT NULL,
  `click` int(11) NOT NULL,
  `postdate` int(11) unsigned NOT NULL,
  `jf_num` smallint(6) NOT NULL,
  `icon` varchar(50) NOT NULL,
  `sms_num` smallint(6) NOT NULL,
  `keycode` varchar(32) NOT NULL,
  PRIMARY KEY  (`comid`),
  KEY `userid` (`userid`)
) ENGINE=MyISAM  AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `tc_com_cat`;
CREATE TABLE IF NOT EXISTS `tc_com_cat` (
  `catid` mediumint(6) NOT NULL auto_increment,
  `catname` varchar(32) NOT NULL,
  `keywords` varchar(255) default NULL,
  `description` varchar(255) default NULL,
  `parentid` int(11) default NULL,
  `catorder` smallint(6) NOT NULL,
  PRIMARY KEY  (`catid`),
  KEY `parentid` (`parentid`),
  KEY `catname` (`catname`)
) ENGINE=MyISAM  AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `tc_com_comment`;
CREATE TABLE IF NOT EXISTS `tc_com_comment` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `eid` int(11) NOT NULL,
  `comid` mediumint(8) unsigned NOT NULL default '0',
  `userid` int(11) unsigned NOT NULL,
  `username` varchar(60) NOT NULL,
  `content` text NOT NULL,
  `cm_fw` int(1) NOT NULL,
  `cm_hj` int(1) NOT NULL,
  `cm_pz` int(1) NOT NULL,
  `is_check` tinyint(1) unsigned NOT NULL,
  `postdate` int(10) unsigned NOT NULL default '0',
  `ip` varchar(15) NOT NULL,
  `repost` text NOT NULL,
  `retime` int(11) NOT NULL,
  `formid` varchar(10) NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `infoid` (`comid`)
) TYPE=MyISAM AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `tc_com_config`;
CREATE TABLE IF NOT EXISTS `tc_com_config` (
  `id` mediumint(6) unsigned NOT NULL auto_increment,
  `comid` int(11) unsigned NOT NULL,
  `userid` int(11) NOT NULL,
  `jf_day` varchar(100) NOT NULL,
  `jf_bl` varchar(8) NOT NULL,
  `sms_key` varchar(50) NOT NULL,
  `zk_sojian` float NOT NULL,
  `zk_list` varchar(200) NOT NULL,
  `fc` smallint(2) NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `userid` (`comid`)
) TYPE=MyISAM ;

DROP TABLE IF EXISTS `tc_com_image`;
CREATE TABLE IF NOT EXISTS `tc_com_image` (
  `imgid` int(11) unsigned NOT NULL auto_increment,
  `comid` int(11) unsigned NOT NULL,
  `path` varchar(100) NOT NULL,
  PRIMARY KEY  (`imgid`),
  KEY `infoid` (`comid`)
) ENGINE=MyISAM  AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `tc_com_sms`;
CREATE TABLE IF NOT EXISTS `tc_com_sms` (
  `sid` int(11) NOT NULL auto_increment,
  `phone` varchar(12) NOT NULL,
  `star` tinyint(1) NOT NULL,
  `userid` int(11) unsigned NOT NULL,
  `comid` int(8) NOT NULL,
  `note` smallint(3) NOT NULL,
  `sendtime` int(11) NOT NULL default '0',
  PRIMARY KEY  (`sid`),
  KEY `username` (`userid`)
) ENGINE=MyISAM  AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `tc_config`;
CREATE TABLE IF NOT EXISTS `tc_config` (
  `setname` varchar(100) NOT NULL,
  `value` text,
  KEY `setname` (`setname`)
) TYPE=MyISAM ;

INSERT INTO `tc_config` (`setname`, `value`) VALUES
('webname', '乐卡同城一卡通通用积分系统'),
('weburl', 'http://localhost'),
('keywords', ''),
('copyright', ''),
('description', ''),
('banwords', ''),
('icp', ''),
('post_check', '0'),
('comment_check', '0'),
('count', ''),
('tplname', 'tc'),
('crypt', ''),
('maxpost', '1'),
('annouce', ''),
('rewrite', '0'),
('onlyarea', ''),
('map', ''),
('del_m_info', '1'),
('del_m_comment', '1'),
('pagesize', '20'),
('uc', '0'),
('uc_api', 'http://localhost/ucenter'),
('uc_appid', '1'),
('uc_key', ''),
('uc_dbhost', 'localhost'),
('uc_dbname', 'ucenter'),
('uc_dbuser', 'root'),
('uc_dbpwd', ''),
('uc_dbpre', 'uc_'),
('uc_charset', 'gbk'),
('expired_view', '0'),
('visitor_post', '1'),
('visitor_view', '1'),
('visitor_comment', '1'),
('closesystem', '0'),
('close_tips', '网站维护，暂时关闭，请稍后访问。'),
('sendmailtype', 'smtp'),
('smtphost', ''),
('smtpuser', ''),
('smtppass', ''),
('smtpport', '25'),
('phone', ''),
('email', ''),
('close_register', '0'),
('reg_check', '0'),
('wap', '1'),
('com_pagesize', '20'),
('com_thumbwidth', '170'),
('com_thumbheight', '140'),
('testemail', ''),
('token', ''),
('cardname', ''),
('diytitle', ''),
('page_num', '2'),
('max_zklist', '5'),
('creditnum', '0.1'),
('smsnum', '0.1'),
('usercreditnum', '0.01'),
('sms_user', ''),
('sms_pass', ''),
('com_money_tea', '0'),
('user_money_tea', '0'),
('citys', ''),
('citysid', ''),
('lejuan', '乐券'),
('tpl2name', 'mp'),
('del_m_credit', '0'),
('del_m_tx', '0'),
('del_m_juan', '0'),
('cardmoney', '5'),
('com_money_off', ''),
('sms_alidayu_appkey', ''),
('sms_alidayu_secret', ''),
('com_jf_num', '0'),
('com_sms_num', '0'),
('com_jf_sum', '0'),
('com_sms_sum', '0'),
('com_shop_card', '2'),
('thumbs', 'images/noface.png'),
('com_thumbs', 'images/noimg.gif'),
('sms_ming', ''),
('sms_yan_tplid', ''),
('sms_msg_tplid', '');

DROP TABLE IF EXISTS `tc_help`;
CREATE TABLE IF NOT EXISTS `tc_help` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `title` varchar(100) NOT NULL,
  `typeid` smallint(5) NOT NULL,
  `keywords` varchar(100) NOT NULL,
  `description` varchar(255) NOT NULL,
  `content` text NOT NULL,
  `listorder` smallint(5) NOT NULL default '0',
  `addtime` int(11) NOT NULL,
  `is_index` tinyint(1) unsigned NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `is_index` (`is_index`),
  KEY `addtime` (`addtime`)
) TYPE=MyISAM AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `tc_juan`;
CREATE TABLE IF NOT EXISTS `tc_juan` (
  `id` int(11) NOT NULL auto_increment,
  `money` float NOT NULL,
  `mid` tinyint(2) NOT NULL,
  `ssid` tinyint(2) NOT NULL,
  `smoney` float NOT NULL,
  `xfmy` float NOT NULL,
  `yxday` smallint(3) NOT NULL,
  `comid` int(11) NOT NULL,
  `nums` smallint(6) NOT NULL,
  `klc` tinyint(1) NOT NULL,
  PRIMARY KEY  (`id`)
) TYPE=MyISAM AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `tc_juan_pay`;
CREATE TABLE IF NOT EXISTS `tc_juan_pay` (
  `id` int(11) NOT NULL auto_increment,
  `jid` int(8) NOT NULL,
  `money` float NOT NULL,
  `smoney` float NOT NULL,
  `ssid` tinyint(1) NOT NULL,
  `userid` int(11) NOT NULL,
  `paytime` int(11) NOT NULL,
  `acttime` int(11) NOT NULL,
  `actcid` int(11) NOT NULL,
  `xfmy` float NOT NULL,
  `comid` int(11) NOT NULL,
  `yxday` smallint(5) NOT NULL,
  PRIMARY KEY  (`id`)
) TYPE=MyISAM AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `tc_member`;
CREATE TABLE IF NOT EXISTS `tc_member` (
  `userid` int(11) unsigned NOT NULL auto_increment,
  `uid` int(11) unsigned NOT NULL,
  `username` varchar(32) NOT NULL,
  `xingming` varchar(12) NOT NULL,
  `face` varchar(200) NOT NULL,
  `email` varchar(60) NOT NULL,
  `temp_mail` varchar(60) NOT NULL,
  `password` varchar(32) NOT NULL,
  `registertime` int(11) unsigned NOT NULL,
  `registerip` varchar(15) NOT NULL,
  `lastlogintime` int(11) unsigned NOT NULL,
  `lastloginip` varchar(15) NOT NULL,
  `sendmailtime` int(11) NOT NULL,
  `shengri` int(11) NOT NULL,
  `qq` varchar(15) NOT NULL,
  `phone` varchar(15) NOT NULL,
  `address` varchar(100) NOT NULL,
  `mappoint` varchar(50) NOT NULL,
  `money` float NOT NULL,
  `gold` float unsigned NOT NULL,
  `credit` smallint(5) unsigned NOT NULL,
  `lastposttime` int(10) unsigned NOT NULL,
  `status` tinyint(1) unsigned NOT NULL,
  `cardnum` varchar(8) NOT NULL,
  `formid` int(8) NOT NULL,
  `wx_openid` varchar(32) NOT NULL,
  PRIMARY KEY  (`userid`)
) TYPE=MyISAM AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `tc_nav`;
CREATE TABLE IF NOT EXISTS `tc_nav` (
  `id` smallint(5) unsigned NOT NULL auto_increment,
  `navname` varchar(32) NOT NULL,
  `url` varchar(100) NOT NULL,
  `target` varchar(6) NOT NULL,
  `navorder` smallint(5) unsigned NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `name` (`navname`),
  KEY `url` (`url`),
  KEY `navorder` (`navorder`)
) TYPE=MyISAM AUTO_INCREMENT=1 ;

INSERT INTO `tc_nav` (`id`, `navname`, `url`, `target`, `navorder`) VALUES
(2, '商家', 'com.php', '_self', 2),
(3, '资讯', 'article.php', '_self', 3);

DROP TABLE IF EXISTS `tc_pay`;
CREATE TABLE IF NOT EXISTS `tc_pay` (
  `payid` int(11) unsigned NOT NULL auto_increment,
  `typeid` tinyint(3) unsigned NOT NULL default '0',
  `note` char(200) NOT NULL default '',
  `paytype` char(20) NOT NULL default '',
  `amount` float NOT NULL default '0',
  `balance` float NOT NULL default '0',
  `year` smallint(4) unsigned NOT NULL default '0',
  `month` tinyint(2) unsigned NOT NULL default '0',
  `date` date NOT NULL default '0000-00-00',
  `userid` int(11) unsigned NOT NULL,
  `ip` char(15) NOT NULL default '',
  `inputer` char(30) NOT NULL default '',
  `inputtime` int(10) unsigned NOT NULL default '0',
  `deleted` tinyint(1) unsigned NOT NULL,
  PRIMARY KEY  (`payid`),
  KEY `type` (`typeid`,`year`,`month`,`date`),
  KEY `username` (`userid`)
) ENGINE=MyISAM  AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `tc_payment`;
CREATE TABLE IF NOT EXISTS `tc_payment` (
  `id` smallint(5) unsigned NOT NULL auto_increment,
  `paycenter` varchar(32) NOT NULL,
  `name` varchar(32) NOT NULL,
  `logo` varchar(100) NOT NULL,
  `sendurl` varchar(100) NOT NULL,
  `receiveurl` varchar(100) NOT NULL,
  `partnerid` varchar(100) NOT NULL,
  `keycode` varchar(100) NOT NULL,
  `percent` float unsigned NOT NULL default '0',
  `email` varchar(60) NOT NULL,
  `enable` tinyint(1) unsigned NOT NULL default '1',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  AUTO_INCREMENT=1 ;

INSERT INTO `tc_payment` (`id`, `paycenter`, `name`, `logo`, `sendurl`, `receiveurl`, `partnerid`, `keycode`, `percent`, `email`, `enable`) VALUES
(1, 'alipay', '支付宝', 'http://img.alipay.com/img/logo/logo_126x37.gif', 'http://www.alipay.com/cooperate/gateway.do', 'http://localhost/respond.php', '202020202020', 'abcde', 0, '', 1),
(2, 'yuer', '店铺余额', '', '/sendbuy.php', 'resinfo.php', '', '', 0, '', 1);

DROP TABLE IF EXISTS `tc_pay_add`;
CREATE TABLE IF NOT EXISTS `tc_pay_add` (
  `pid` int(11) NOT NULL auto_increment,
  `userid` int(11) NOT NULL,
  `value` float NOT NULL,
  `cardnum` varchar(18) NOT NULL,
  `payid` tinyint(1) NOT NULL,
  `addtime` int(11) NOT NULL,
  `note` varchar(100) NOT NULL,
  `ip` varchar(15) NOT NULL,
  PRIMARY KEY  (`pid`)
) ENGINE=MyISAM  AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `tc_pay_credit`;
CREATE TABLE IF NOT EXISTS `tc_pay_credit` (
  `cid` int(11) NOT NULL auto_increment,
  `tid` tinyint(1) NOT NULL,
  `userid` int(11) NOT NULL,
  `cnum` int(5) NOT NULL,
  `value` float NOT NULL,
  `addtime` int(11) NOT NULL,
  `ip` varchar(15) NOT NULL,
  `note` varchar(100) NOT NULL,
  PRIMARY KEY  (`cid`)
) ENGINE=MyISAM  AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `tc_pay_exchange`;
CREATE TABLE IF NOT EXISTS `tc_pay_exchange` (
  `exchangeid` int(11) NOT NULL auto_increment,
  `userid` int(11) unsigned NOT NULL,
  `orderid` varchar(15) NOT NULL,
  `cardnum` varchar(8) NOT NULL,
  `type` enum('money','gold','credit') NOT NULL default 'money',
  `value` float NOT NULL default '0',
  `zekou` smallint(2) NOT NULL,
  `yjia` float NOT NULL,
  `soj` float NOT NULL,
  `lej` float NOT NULL,
  `jifen` smallint(6) NOT NULL,
  `fc` float NOT NULL,
  `comid` int(8) NOT NULL,
  `note` varchar(255) NOT NULL,
  `addtime` int(11) NOT NULL default '0',
  `ip` varchar(15) NOT NULL default '',
  `dp` tinyint(1) unsigned NOT NULL,
  `payid` tinyint(1) NOT NULL,
  PRIMARY KEY  (`exchangeid`),
  KEY `username` (`userid`,`type`)
) ENGINE=MyISAM  AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `tc_pay_online`;
CREATE TABLE IF NOT EXISTS `tc_pay_online` (
  `payid` int(11) NOT NULL auto_increment,
  `paycenter` varchar(50) NOT NULL default '',
  `userid` int(11) unsigned NOT NULL,
  `comid` int(11) NOT NULL,
  `orderid` varchar(64) NOT NULL default '',
  `moneytype` varchar(10) NOT NULL default '0',
  `amount` double NOT NULL default '0',
  `nums` smallint(5) NOT NULL,
  `trade_fee` double NOT NULL default '0',
  `status` int(11) NOT NULL default '0',
  `contactname` varchar(50) NOT NULL default '',
  `telephone` varchar(50) NOT NULL default '',
  `email` varchar(50) NOT NULL default '',
  `sendtime` int(11) NOT NULL default '0',
  `receivetime` int(11) NOT NULL default '0',
  `ip` varchar(15) NOT NULL default '',
  PRIMARY KEY  (`payid`),
  KEY `username` (`userid`,`orderid`,`status`),
  KEY `orderid` (`orderid`)
) ENGINE=MyISAM  AUTO_INCREMENT=1 ;


DROP TABLE IF EXISTS `tc_pay_tx`;
CREATE TABLE IF NOT EXISTS `tc_pay_tx` (
  `id` int(11) NOT NULL auto_increment,
  `money` float NOT NULL,
  `txfs` varchar(20) NOT NULL,
  `zanghao` varchar(50) NOT NULL,
  `soxu` smallint(2) NOT NULL,
  `zuangtai` tinyint(1) NOT NULL,
  `comid` int(11) NOT NULL,
  `userid` int(11) NOT NULL,
  `txtime` int(11) NOT NULL,
  `tid` tinyint(1) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `tc_report`;
CREATE TABLE IF NOT EXISTS `tc_report` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `comid` int(11) unsigned NOT NULL,
  `type` tinyint(1) unsigned NOT NULL,
  `userid` int(11) NOT NULL,
  `orderid` varchar(15) NOT NULL,
  `content` text NOT NULL,
  `ip` varchar(15) NOT NULL,
  `postdate` int(11) unsigned NOT NULL,
  `zt` tinyint(1) NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `ip` (`ip`)
) TYPE=MyISAM AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `tc_shop_card`;
CREATE TABLE IF NOT EXISTS `tc_shop_card` (
  `id` int(8) NOT NULL auto_increment,
  `userid` int(11) NOT NULL,
  `username` varchar(20) character set utf8 NOT NULL,
  `phone` varchar(12) character set utf8 NOT NULL,
  `address` varchar(60) character set utf8 NOT NULL,
  `cardnum` smallint(2) NOT NULL,
  `payid` tinyint(1) NOT NULL,
  `money` float NOT NULL,
  `zt` tinyint(1) NOT NULL,
  `addtime` int(11) NOT NULL,
  PRIMARY KEY  (`id`)
) TYPE=MyISAM AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `tc_type`;
CREATE TABLE IF NOT EXISTS `tc_type` (
  `typeid` smallint(5) unsigned NOT NULL auto_increment,
  `typename` varchar(32) NOT NULL,
  `listorder` smallint(5) NOT NULL,
  `keywords` varchar(100) NOT NULL,
  `description` varchar(255) NOT NULL,
  `module` char(10) NOT NULL,
  PRIMARY KEY  (`typeid`)
) TYPE=MyISAM AUTO_INCREMENT=1 ;