<?php
function getDomain($url) {
	$pattern = '/[\w-]+\.(com|net|org|biz|info|gov|mobi|name|travel|jobs|tel|idv|asia|cn|hk|tw|la|sh|ac|io|ws|us|de|tm|cc|tv|vc|ag|bz|in|mn|sc|me|co)(\.(cn|hk|tw|kr))*/';
	preg_match($pattern, $url, $matches);
	
	if (count($matches) > 0) {
		return $matches[0];
	} else {
		$par_url = parse_url($url);
		$main_url = $par_url["host"];
		if (!strcmp((sprintf('%u', ip2long($main_url))), $main_url)) {
			return $main_url;
		} else {
			$arr_url = explode('.', $main_url);
			$count = count($arr_url);
		
			$endArr = array('com', 'net', 'org', 'gov', 'ac', 'bj', 'sh', 'tj', 'cq', 'he', 'sx', 'nm', 'ln', 'jl', 'hl', 'js', 'zj', 'ah', 'fj', 'jx', 'sd', 'ha', 'hb', 'hn', 'gd', 'gx', 'hi', 'sc', 'gz', 'yn', 'xz', 'sn', 'gs', 'qh', 'nx', 'xj', 'tw', 'hk', 'mo', 'idv');//com.cn  net.cn 等情况
			if (in_array($arr_url[$count - 2], $endArr)) {
				$domain = $arr_url[$count - 3].'.'.$arr_url[$count - 2].'.'.$arr_url[$count - 1];
			} else {
				$domain =  $arr_url[$count - 2].'.'.$arr_url[$count - 1];
			}
			return $domain;
		}
	}
}
	
function getFullUrl($url) {
	if ($url != "") {
		$url_parts = parse_url($url);
		if ($url_parts['scheme'] == "") {
			$url = "http://".$url;
		}
	}
	return $url;
}
	
function getShortUrl($url) {
	if ($url != "") {
		$url_parts = parse_url($url);
        if ($url_parts['host'] == "") {
			$url = $url_parts['path'];
		} else {
           	$url = $url_parts['host'];
        }
	}
	return $url;
}
	
function format_number($number) {
	if ($number == '') return "-";
	$nlen = strlen($number);
	while ($nlen > 3) {
		$fnumber = ",".substr($number, $nlen - 3, 3).$fnumber;
		$number = substr($number, 0, -3);
		$nlen = strlen($number);
	}
		
	if ($nlen <= 3) {
		$fnumber = $number.$fnumber;
	}
	return $fnumber;
}

function getUrlContent($url) {
	$content = @file_get_contents($url);
	return $content;
}

function getIPAddr($url) {
	include('ip.class.php');
		
	$ip = new IpLocation();
	$ip_arr = $ip -> getLocation($url);
	$ip_str = $ip_arr['ip'].' - '.$ip_arr['country'].$ip_arr['area'];
	$ip_str = iconv('gb2312', 'utf-8', $ip_str);
	return $ip_str;
	unset($ip_arr);
}
	
function getPageRank($url) {
	include('pagerank.php');
	
	$url = getShortUrl($url);
	$gpr = new GooglePR();
	$pr = $gpr -> GetPR($url);
	return $pr;
}
	
function getAlexaRank($url) {		
	$url = getDomain($url);
	$content = getUrlContent("http://xml.alexa.com/data?cli=10&dat=nsa&ver=quirk-searchstatus&url=$url");
	if (preg_match('/<POPULARITY[^>]*URL[^>]*TEXT[^>]*\"([0-9]+)\"/i', $content, $alexa)) {
		$alexarank = strip_tags($alexa[1]);
	} else {
		$alexarank = '-';
	}
	
	return $alexarank;
}
	
function getSogouRank($url) {		
	$url = getShortUrl($url);
	$content = getUrlContent("http://www.sogou.com/web?query=$url");
	$content = @iconv('gb2312', 'utf-8', $content);
	if (preg_match('/搜狗评级:(.*?)\/100/i', $content, $srank)) {
		$sogourank = $srank[1];
	} else {
		$sogourank = '-';
	}
	return $sogourank;
}
	
function getChinaRank($url) {		
	$url = getShortUrl($url);
	$content = getUrlContent("http://www.chinarank.org.cn/overview/Info.do?url=$url");
	$content = @iconv('gb2312', 'utf-8', $content);
	if (preg_match('/<span class=\"bold\">当前排名：<\/span><span class=\"rank_font_y2\">(.*?)<\/span>/i', $content, $crank)) {
		$chinarank = $crank[1];
	} else {
		$chinarank = '-';
	}
	return $chinarank;
}
	
/** 收录查询 */
function getGoogleIndex($url, $type) {
	$url = getShortUrl($url);
	$content = getUrlContent("http://www.google.com.hk/search?hl=zh-CN&source=hp&q=$type:$url");
	switch ($type) {
		case 'site' :
			$pattern = "/获得(.*?)条结果/i";
			break;
		case 'link' :
			$pattern = "/获得(.*?)条结果/i";
			break;
		default :
			exit;
	}
	if (preg_match($pattern, $content, $ggindex)) {
		$googleindex = trim(str_replace('约', '', $ggindex[1]));
	} else {
		$googleindex = '-';
	}
	return $googleindex;
}

function getBaiduIndex($url, $type) {
	$url = getShortUrl($url);
	$content = getUrlContent("http://www.baidu.com/s?wd=$type:$url");
	$content = @mb_convert_encoding($content, 'utf-8', 'gb2312');
	if (preg_match('/找到相关网页(.*?)篇/i', $content, $bdindex)) {
		$baiduindex = str_replace('约', '', $bdindex[1]);
	} else {
		$baiduindex = '-';
	}
	return $baiduindex;
}
	
function getBingIndex($url, $type) {
	$url = getShortUrl($url);
	$content = getUrlContent("http://cn.bing.com/search?q=$type:$url");
	if (preg_match('/共 (.*?) 条/i', $content, $byindex)) {
		$bingindex = $byindex[1];
	} else {
		$bingindex = '-';
	}
	return $bingindex;
}

function getYahooIndex($url, $type) {
	$url = getShortUrl($url);
	$qurl = "http://sitemap.cn.yahoo.com/search?p=";
	switch ($type) {
		case 'site' :
			$qurl .= $url;
			$pattern = "/被收录的网页： 共 <strong>(.*?)<\/strong> 条/i";
			break;
		case 'link' :
			$qurl .= $url.'&bwm=i';
			$pattern = "/链向该地址的网页： 共 <strong>(.*?)<\/strong> 条/i";
			break;
		default :
			exit;
	}
	$content = getUrlContent($qurl);
	if (preg_match($pattern, $content, $yhindex)) {
		$yahooindex = format_number($yhindex[1]);
	} else {
		$yahooindex = '-';
	}
	return $yahooindex;	
}
	
function getSosoIndex($url, $type) {
	$url = getShortUrl($url);
	$content = getUrlContent("http://www.soso.com/q?w=$type:$url");
	$content = @iconv('gb2312', 'utf-8', $content);
	if (preg_match('/搜索到约(.*?)项结果/i', $content, $ssindex)) {
		$sosoindex = $ssindex[1];
	} else {
		$sosoindex = '-';
	}
	return $sosoindex;	
}
	
function getSogouIndex($url, $type) {
	$url = getShortUrl($url);
	$qurl = "http://www.sogou.com/web?query=";
	switch ($type) {
		case 'site' :
			$qurl .= 'site:'.$url;
			break;
		case 'link' :
			$qurl .= 'link:'.$url;
			break;
		default :
			exit;
	}
	$content = getUrlContent($qurl);
	$content = @iconv('gb2312', 'utf-8', $content);
	if (preg_match('/<!--resultbarnum:(.*?)-->/i', $content, $sgindex)) {
		$sogouindex = $sgindex[1];
	} else {
		$sogouindex = '-';
	}
	return $sogouindex;
}
	
function getYoudaoIndex($url, $type) {
	$url = getShortUrl($url);
	$content = getUrlContent("http://www.youdao.com/search?ue=utf8&keyfrom=web.index&q=$type:$url");
	if (preg_match('/<span class=\"fr\">共(.*?)条结果<\/span>/i', $content, $ydindex)) {
		$youdaoindex = str_replace('约', '', $ydindex[1]);
	} else {
		$youdaoindex = '-';
	}
	return $youdaoindex;
}

function getHeaders($url) {
	$url = getFullUrl($url);
	$header_arr = @get_headers($url, 1);
		
	//foreach ($header_arr as $header_info) {
	//	$header_result .= $header_info.'<br />';
	//};
	
	return $header_arr[0];
	unset($header_arr);
}

function getDomainInfo($url) {
	$url = getDomain($url);
	$content = getUrlContent("http://whois.hichina.com/cgi-bin/whois?domain=$url");
	$content = @iconv('gb2312', 'utf-8', $content);
	if (preg_match("/<!-- start -->(.*?)<!-- end -->/is", $content, $whoisinfo)) {
		$whois = str_replace('友情提示：按注册局要求，过期域名可能会处于注册商自动续费期阶段，您在此查询所看到的域名到期日仅供参考<br />请您<a href="http://www.net.cn/has_client/userlogon/user_logon1.asp" target="_blank" class="link_gl">进入会员区</a>查看该域名的实际到期时间，并请及时进行续费，谢谢！', '', $whoisinfo[1]);
		$whois = nl2br(trim($whois));
		
		//Creation Date
		if (preg_match("/Creation Date:(.*?)<br \/>/i", $whois, $cdate)) {
			$createdate = date('Y-m-d', strtotime($cdate[1]));
		} else {
			$createdate = '未知';
		}
		
		//Updated Date
		if (preg_match("/Updated Date:(.*?)<br \/>/i", $whois, $udate)) {
			$updateddate = date('Y-m-d', strtotime($udate[1]));
		} else {
			$updateddate = '未知';
		}
		
		//Expiration Date
		if (preg_match("/Expiration Date:(.*?)<br \/>/i", $whois, $edate)) {
			$expireddate = date('Y-m-d', strtotime($edate[1]));
		} else {
			$expireddate = '未知';
		}
		
		$whoisinfo = '创建时间：'.$createdate.' - 修改时间：'.$updateddate.' - 过期时间：'.$expireddate;
	} else {
		$whoisinfo = '未知';
	}
	return $whoisinfo;
}
?>