﻿/*
	通用简单Ajax类
*/
function Ajax(args){
	
	function json2str(o){
		if(typeof(o)=='string')
			return encodeURIComponent(o);
		var s='';
		for(var i in o){
			s+='&'+i+'='+encodeURIComponent(o[i]);
		}
		return s;
	}
	
	var url=args.url || '',
		method = (args.method || "GET").toUpperCase(),
		timeout = args.timeout || 0,
		contentType = (args.contentType || "application/x-www-form-urlencoded") + '; charset=' + (args.encoding || 'utf-8'),
		async = args.async != undefined ? args.async : true,
		data = args.data != undefined ? json2str(args.data) : null,
		dataType = args.dataType || 'text',
		success = args.success || null,
		fail = args.fail || null,
		complete = args.complete || null;
	
	var xml = window.ActiveXObject ? new ActiveXObject("Microsoft.XMLHTTP") : new XMLHttpRequest();
	
	if ( method == 'GET' ){
		url  = url + "?" + (data ? data + '&' : '') + "reqTime=" + new Date().getTime();
		data = null;
	}
	
	xml.open(method, url, async);
	
	if (data)
		xml.setRequestHeader("Content-type", contentType);
		
	xml.onreadystatechange = function() {
		if (xml.readyState != 4)
			return;
		
		if (xml.status >= 200 && xml.status < 300 && success) {
			if (dataType == "xml") {
				success(xml.responseXML);
			} else {
				success(xml.responseText);
			}

		} else if (fail) {
			fail();
		}
		xml=undefined;
	}
	
	xml.send(data);
	
	this.abort=function(){xml.abort();}
	
}


var Event=new (function(){
	var regList = [];
	this.add=function(o,ev,fn,args){
		if(!fn._GUID_){
			fn._GUID_=((new Date()).getTime()+Math.random()).toString();
		}
 
		if(!o.regList){
			o.regList={};
		}
		if(!o.regList[ev]){
			o.regList[ev]=[];
		}
 
		if(o.regList[ev][fn._GUID_]==fn){
			return;
		}
		else{
			o.regList[ev][fn._GUID_]=fn;
		}
 
		_GV_helper=function(){
			return fn.call(o,arguments[0],args);
		}
 
		_GV_helper._GUID_=fn._GUID_;
		regList[_GV_helper._GUID_]=_GV_helper;
 
		if (document.addEventListener){
			o.addEventListener(ev,_GV_helper,false);
		}
		else{
			o.attachEvent('on'+ev,_GV_helper);
		}
	}
	this.remove=function(o,ev,fn){
		var helper;
		if(ev){
			if(fn){
				if(!fn._GUID_)
					return;
				helper=this.regList[fn._GUID_];
				if (document.removeEventListener){
					o.removeEventListener(ev,helper,false);
				}
				else{
					o.detachEvent('on'+ev,helper);
				}
				delete o.regList[ev][fn._GUID_];
			}else{
				for(var fn in o.regList[ev]){
					helper=regList[o.regList[ev][fn]._GUID_];
					if (document.removeEventListener){
						o.removeEventListener(ev,helper,false);
					}
					else{
						o.detachEvent('on'+ev,helper);
					}
					delete o.regList[ev][fn];
				}
			}
		}else{
			for(var ev in o.regList){
				for(var fn in o.regList[ev]){
					helper=this.regList[o.regList[ev][fn]._GUID_];
					if (document.removeEventListener){
						o.removeEventListener(ev,helper,false);
					}
					else{
						o.detachEvent('on'+ev,helper);
					}
					delete o.regList[ev][fn];
				}
			}
		}
	}
 
})();



var common=window.common=function(args){};

common.fn=common.prototype={
//窗口大小缩放时尺寸更新
updateSize:function(){
	//解决IE6下圆角absolute 1px bug
	if((/MSIE [3-6]\.0/i).test(window.navigator.userAgent)){
		var W=document.body.parentNode.clientWidth;
		document.body.style.width=W<760?(760+'px'):(W%4?((W-W%4)+'px'):(W%2?(W-1)+'px':'100%'));
	}
	
	//解决我的消息iframe尺寸更新
	var ifr=document.getElementById('inholder');
	var left=document.getElementById('left');
	var right=document.getElementById('right');
	if(ifr&&left){
		right.style.width = document.getElementById('in').offsetWidth-left.offsetWidth+'px';
	}
},

/*
	事件绑定
	如:window.onload=fn; -> bind(window,'load',fn);
*/
bind:Event.add,
unbind:Event.remove,

/*
	给对象添加一个class
	如:addClass(document.getElementById('id'),'classA classB');
	可以以空格分隔添加多个class
*/
addClass:function (el,cls){
	var arrCls=cls.split(/[ ]+/);
	if(el.className){
		for(var i=0;i<arrCls.length;i++){
			if(common.hasClass(el,cls)){
				cls=cls.replace(new RegExp('(^| +)'+arrCls[i]+'( +|$)'),' ');
			}
		}
		el.className=[el.className].concat(cls).join(' ');
	}
	else{
		el.className=cls;
	}
},

/*
	移除对象上的一个class
*/
removeClass:function (el,cls){
	if(!cls){
		el.className='';
	}else if(common.hasClass(el,cls)){
		el.className=el.className.replace(new RegExp('(^| +)'+cls+'( +|$)','g'),' ');
	}
},

/*
	添加/移除对象上的一个class
	没有就添加，有了就移除
*/
toggleClass:function (el,cls){
	if(!common.hasClass(el,cls)){
		common.addClass(el,cls);//11-2
		return true;
	}
	else{
		common.removeClass(el,cls);//11-2
		return false;
	}
},

/*
	判断某个对象是否含有某个或多个class
*/
hasClass:function(el,cls){
	if(!el.className||!cls)
		return false;
	var cls=cls.split(/[\.| +]/);
	var re;
	for(var i=cls.length-1;i>=0;i--){
		re=new RegExp('(^| +)'+cls[i]+'( +|$)');
		if(!(re.test(el.className)||!cls[i]))
			return false;
	}
	return true;
},

/*
	显示/隐藏一个元素
	@el:Element
	@sh:Boolean true:show; false:hide; undefined:toggle.
*/
show:function(el,sh){
	var style=el.currentStyle||document.defaultView.getComputedStyle(el,null);
	var dis=style.display||'';
	if(sh==undefined){
		el.style.display=(dis=='none'?'none':'');
	}else{
		el.style.display=sh?'':'none';
	}
},

trim:function(s){
	return s.replace(/^\s+|\s+$/g,'');
},

createFlash:function(idad, swfurl, wad, had, vs){
	var str = '<object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" codebase="http://fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=7,0,0,0" width="' + wad + '" height="' + had + '" id="' + idad + '" align="middle">';
	str += '<param name="allowScriptAccess" value="always">';
	str += '<param name="quality" value="high">';
	str += '<param name="movie" value="' + swfurl + '">';
	str += '<param name="wmode" value="opaque">';
	str += '<param name="flashvars" value="' + vs + '">';
	str += '<embed wmode="opaque" src="' + swfurl + '" flashvars="' + vs + '" quality="high" width="' + wad + '" height="' + had + '" name="' + idad + '" align="middle" allowScriptAccess="always" type="application/x-shockwave-flash" pluginspage="http://www.macromedia.com/go/getflashplayer">';
	str += '</object>';
	document.write(str);
},

onClose:function(){
	window.opener = null;
	window.close();   
}

}

common.extend=common.fn.extend=function(a,b){
	for(i in b)a[i]=b[i];
	return a;
};

common.extend(common,common.fn);

(function(){
	function init(){
		var tm=document.getElementById('topswitch');
		if(tm)common.bind(tm,'click',showTopMenu);
	}
	function showTopMenu(){
		common.show(document.getElementById('topmenu'));
	}
	if(window==top)common.bind(window,'load',init);
})();


function initNav(path){
	var path=path||'./';
	var menu=[
		{title:'首页',url:path+'index.html',file:'index.html'},
		{title:'如何加入连链',url:path+'faq.html',file:'faq.html'},
		{title:'全部网址',url:path+'urls.html',file:'urls.html'},
		{title:'标签',url:path+'tags.html',file:'tags.html'},
		{title:'使用高级代码',url:path+'code.html',file:'code.html'}
	];
	
	var url=location.pathname.replace(/\\/g,'/');// /xxx/xxx.xxx
	//var file=(file=url.split('/').pop())?file:menu[0].file; //index.html
	var file=url.split('/').pop();
	var cur=file?-1:0,subcur=0;
	var HTML='';//changed 11-1
		HTML+='<div id="hd">';
		HTML+='<div id="nav"><ul>';
	for(var i=0;i<menu.length;i++){
		HTML+='<li><a href="'+menu[i].url+'">'+menu[i].title+'</a></li>';
		//if(!i)cur=0;
		if(
			file==menu[i].file||
			(function(j){
				var submenu=menu[j].sb;
				if(!submenu)return false;
				for(var k=submenu.length-1;k>=0;k--){
					/*
						触发条件1：二级中的首页
						触发条件2：二级和三级的文件名前7个字母与数组中的二级对应匹配
					*/
					if(file==submenu[0].file){subcur=0;return true;}
					else if(file.substr(0,7)==submenu[k].file.substr(0,7)){subcur=k;return true;}
					//if(file==submenu[k].file){subcur=k;return true;}
				}
				return false;
			})(i)
		)cur=i;
	}
		HTML+='</ul></div>';
	
	if(cur>=0)var submenu=menu[cur].sb;
	if(submenu){
		HTML+='<div id="subnav">';
		HTML+='<ul>';
		for(var j=0;j<submenu.length;j++){
			if(submenu[j].show!=false)
				HTML+='<li><a href="'+submenu[j].url+'">'+submenu[j].title+'</a></li>';
		}
		HTML+='</ul>';
		HTML+='</div>';
		if(cur>1){
			HTML+='<div class="snline"><div class="in" style="margin-left:'+73*(subcur+1)+'px;"></div></div>';
		}
	}
	HTML+='</div>';
	
	//alert(HTML.replace(/></g,'>\n<'));
	document.write(HTML);
	
	//var nav=document.getElementById('nav').getElementsByTagName('li');
	if(cur>=0)
		common.addClass(
			document.getElementById('nav').getElementsByTagName('li')[cur],
			'active'
		);
	
	var subnav=document.getElementById('subnav');
	subnav=subnav?subnav.getElementsByTagName('li'):null;
	if(subnav&&subnav[subcur])common.addClass(subnav[subcur],'active');
	
}


function h(obj,url){
		obj.style.behavior='url(#default#homepage)';obj.setHomePage(url);
}

/*
	iframe高度自适应
	@ifr:HtmlIframeElement
	@ids:[String] 一组id字符串
	由iframe dom 里的onload属性调用
*/
function adjustIframe(ifr){
	ifr.height=ifr.contentWindow.document.body.scrollHeight;
}

/*
	链接实现跳转
*/

function reTo(urlStr){
	top.location.href = urlStr;
}

/*
	转换函数
*/
function htmlToText(t){
	var str = t;
	str= str.replace(/&lt;/g,'<');
	str= str.replace(/&gt;/g,'>');
	str= str.replace(/&amp;/g,'&');
	str= str.replace(/&quot;/g,'\"');
	str= str.replace(/&#39;/g,'\'');
	return str;
}

function textToHtml(t){
	var str = t;
	str= str.replace(/&/g,'&amp;');
	str= str.replace(/</g,'&lt;');
	str= str.replace(/>/g,'&gt;');
	str= str.replace(/\"/g,'&quot;');
	str= str.replace(/\'/g,'&#39;');
	return str;
}

function DragObject(args){
	var module=typeof(args.module)=='string'?document.getElementById(args.module):args.module;
	var handle=typeof(args.handle)=='string'?document.getElementById(args.handle):args.handle;
	function startDrag(e){
		var e=e||window.event;
		//var elem=e.target||e.srcElement;
		
		document.onmousemove=onDrag;
		document.onmouseup=stopDrag;
		
		//储存当前坐标差值参数
		module.subX=module.offsetLeft-e.clientX;
		module.subY=module.offsetTop-e.clientY;
		
		return false;
	}
	
	function onDrag(e){
		e=e||window.event;
		module.style.left=module.subX+e.clientX+'px';
		module.style.top=module.subY+e.clientY+'px';
		return false;
	}
	
	function stopDrag(){
		document.onmousemove=null;
		document.onmouseup=null;
	}
	
	handle.onmousedown=startDrag;
	
}

function Popup(args){
	var module=typeof(args.module)=='string'?document.getElementById(args.module):args.module;
	var background=args.background?(typeof(args.background)=='string'?document.getElementById(args.background):args.background):null;
	
	this.show=function(){
		if(background){
			common.addClass(background,'active');
			background.parentNode.appendChild(background);
		}
		common.addClass(module,'active');
		module.parentNode.appendChild(module);
		if(args.center){
			module.style.left=((document.documentElement.offsetWidth-module.offsetWidth)/2)+'px';
			module.style.top=((document.documentElement.offsetHeight-module.offsetHeight)/2)+'px';
		}
		return false;
	};
	
	this.hide=function(){
		common.removeClass(module,'active');
		if(background){
			common.removeClass(background,'active');
		}
		return false;
	};
}

var Valid={
	isDomain:function(s){
		return s.length<256&&/^(([a-z0-9][-a-z0-9]*[a-z0-9]|)\.)+[a-z]{2,6}$/i.test(s);
	}
};