/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.mapsdk.raster.model;

import com.tencent.mapsdk.raster.model.LatLng;
import com.tencent.mapsdk.rastercore.f.a;

public class LatLngBounds {
    private int mVersionCode;
    private LatLng southwest;
    private LatLng northeast;

    LatLngBounds(int n, LatLng object, LatLng latLng) {
        object = new Builder().include((LatLng)object).include(latLng);
        this.southwest = new LatLng(((Builder)object).mSouth, ((Builder)object).mWest);
        this.northeast = new LatLng(((Builder)object).mNorth, ((Builder)object).mEast);
        this.mVersionCode = n;
    }

    public LatLngBounds(LatLng latLng, LatLng latLng2) {
        this(1, latLng, latLng2);
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public static Builder builder() {
        return new Builder();
    }

    public LatLng getSouthwest() {
        return this.southwest;
    }

    public LatLng getNortheast() {
        return this.northeast;
    }

    public boolean contains(LatLng latLng) {
        return this.containsLatitude(latLng.getLatitude()) && this.containsLongitude(latLng.getLongitude());
    }

    public boolean contains(LatLngBounds latLngBounds) {
        boolean bl = false;
        if (latLngBounds == null) {
            return false;
        }
        if (this.contains(latLngBounds.southwest) && this.contains(latLngBounds.northeast)) {
            bl = true;
        }
        return bl;
    }

    public boolean intersects(LatLngBounds latLngBounds) {
        if (latLngBounds == null) {
            return false;
        }
        return this.intersect(latLngBounds) || latLngBounds.intersect(this);
    }

    private boolean intersect(LatLngBounds latLngBounds) {
        if (latLngBounds == null || latLngBounds.northeast == null || latLngBounds.southwest == null || this.northeast == null || this.southwest == null) {
            return false;
        }
        double d2 = latLngBounds.northeast.getLongitude() + latLngBounds.southwest.getLongitude() - this.northeast.getLongitude() - this.southwest.getLongitude();
        double d3 = this.northeast.getLongitude() - this.southwest.getLongitude() + latLngBounds.northeast.getLongitude() - latLngBounds.southwest.getLongitude();
        double d4 = latLngBounds.northeast.getLatitude() + latLngBounds.southwest.getLatitude() - this.northeast.getLatitude() - this.southwest.getLatitude();
        double d5 = this.northeast.getLatitude() - this.southwest.getLatitude() + latLngBounds.northeast.getLatitude() - latLngBounds.southwest.getLatitude();
        return Math.abs(d2) < d3 && Math.abs(d4) < d5;
    }

    public LatLngBounds including(LatLng latLng) {
        double d2 = Math.min(this.southwest.getLatitude(), latLng.getLatitude());
        double d3 = Math.max(this.northeast.getLatitude(), latLng.getLatitude());
        double d4 = this.northeast.getLongitude();
        double d5 = this.southwest.getLongitude();
        double d6 = latLng.getLongitude();
        if (!this.containsLongitude(d6)) {
            if (LatLngBounds.longitudeDistanceHeadingWest(d5, d6) < LatLngBounds.longitudeDistanceHeadingEast(d4, d6)) {
                d5 = d6;
            } else {
                d4 = d6;
            }
        }
        return new LatLngBounds(new LatLng(d2, d5), new LatLng(d3, d4));
    }

    private static double longitudeDistanceHeadingWest(double d2, double d3) {
        return (d2 - d3 + 360.0) % 360.0;
    }

    private static double longitudeDistanceHeadingEast(double d2, double d3) {
        return (d3 - d2 + 360.0) % 360.0;
    }

    private boolean containsLatitude(double d2) {
        return this.southwest.getLatitude() <= d2 && d2 <= this.northeast.getLatitude();
    }

    private boolean containsLongitude(double d2) {
        if (this.southwest.getLongitude() <= this.northeast.getLongitude()) {
            return this.southwest.getLongitude() <= d2 && d2 <= this.northeast.getLongitude();
        }
        return this.southwest.getLongitude() <= d2 || d2 <= this.northeast.getLongitude();
    }

    public final int hashCode() {
        return a.a(new Object[]{this.southwest, this.northeast});
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof LatLngBounds)) {
            return false;
        }
        object = (LatLngBounds)object;
        return this.southwest.equals(((LatLngBounds)object).southwest) && this.northeast.equals(((LatLngBounds)object).northeast);
    }

    public final String toString() {
        return a.a(a.a("southwest", this.southwest), a.a("northeast", this.northeast));
    }

    public static final class Builder {
        private double mSouth = Double.POSITIVE_INFINITY;
        private double mNorth = Double.NEGATIVE_INFINITY;
        private double mWest = Double.NaN;
        private double mEast = Double.NaN;

        /*
         * Enabled aggressive block sorting
         */
        public final Builder include(LatLng latLng) {
            this.mSouth = Math.min(this.mSouth, latLng.getLatitude());
            this.mNorth = Math.max(this.mNorth, latLng.getLatitude());
            double d2 = latLng.getLongitude();
            if (Double.isNaN(this.mWest)) {
                this.mWest = d2;
            } else {
                if (this.containsLongitude(d2)) return this;
                if (LatLngBounds.longitudeDistanceHeadingWest(this.mWest, d2) < LatLngBounds.longitudeDistanceHeadingEast(this.mEast, d2)) {
                    this.mWest = d2;
                    return this;
                }
            }
            this.mEast = d2;
            return this;
        }

        public final Builder include(Iterable<LatLng> object) {
            if (object != null) {
                object = object.iterator();
                while (object.hasNext()) {
                    LatLng latLng = (LatLng)object.next();
                    this.include(latLng);
                }
            }
            return this;
        }

        private boolean containsLongitude(double d2) {
            if (this.mWest <= this.mEast) {
                return this.mWest <= d2 && d2 <= this.mEast;
            }
            return this.mWest <= d2 || d2 <= this.mEast;
        }

        public final LatLngBounds build() {
            return new LatLngBounds(new LatLng(this.mSouth, this.mWest), new LatLng(this.mNorth, this.mEast));
        }
    }
}

