/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.mapsdk.raster.model;

import com.tencent.mapsdk.raster.model.LatLng;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class PolygonOptions {
    private int strokeColor = -16777216;
    private int fillColor = -16777216;
    private final List<LatLng> points = new ArrayList<LatLng>();
    private float strokeWidth = 10.0f;
    private boolean isVisible = true;
    private float zIndex = 0.0f;

    public final PolygonOptions add(LatLng latLng) {
        this.points.add(latLng);
        return this;
    }

    public final PolygonOptions add(LatLng ... latLngArray) {
        this.points.addAll(Arrays.asList(latLngArray));
        return this;
    }

    public final PolygonOptions addAll(Iterable<LatLng> object) {
        object = object.iterator();
        while (object.hasNext()) {
            LatLng latLng = (LatLng)object.next();
            this.points.add(latLng);
        }
        return this;
    }

    public final PolygonOptions strokeWidth(float f2) {
        this.strokeWidth = f2;
        return this;
    }

    public final PolygonOptions strokeColor(int n) {
        this.strokeColor = n;
        return this;
    }

    public final PolygonOptions fillColor(int n) {
        this.fillColor = n;
        return this;
    }

    public final PolygonOptions zIndex(float f2) {
        this.zIndex = f2;
        return this;
    }

    public final PolygonOptions visible(boolean bl) {
        this.isVisible = bl;
        return this;
    }

    public final List<LatLng> getPoints() {
        return this.points;
    }

    public final float getStrokeWidth() {
        return this.strokeWidth;
    }

    public final int getStrokeColor() {
        return this.strokeColor;
    }

    public final int getFillColor() {
        return this.fillColor;
    }

    public final float getZIndex() {
        return this.zIndex;
    }

    public final boolean isVisible() {
        return this.isVisible;
    }
}

