/*
 * Decompiled with CFR 0.152.
 */
package cn.jmessage.support.okhttp3;

import cn.jmessage.support.annotation.Nullable;
import cn.jmessage.support.okhttp3.Headers;
import cn.jmessage.support.okhttp3.HttpUrl;
import cn.jmessage.support.okhttp3.internal.Util;
import cn.jmessage.support.okhttp3.internal.http.HttpDate;
import cn.jmessage.support.okhttp3.internal.publicsuffix.PublicSuffixDatabase;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Cookie {
    private static final Pattern YEAR_PATTERN;
    private static final Pattern MONTH_PATTERN;
    private static final Pattern DAY_OF_MONTH_PATTERN;
    private static final Pattern TIME_PATTERN;
    private final String name;
    private final String value;
    private final long expiresAt;
    private final String domain;
    private final String path;
    private final boolean secure;
    private final boolean httpOnly;
    private final boolean persistent;
    private final boolean hostOnly;
    private static final String[] z;

    private Cookie(String string, String string2, long l2, String string3, String string4, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.name = string;
        this.value = string2;
        this.expiresAt = l2;
        this.domain = string3;
        this.path = string4;
        this.secure = bl;
        this.httpOnly = bl2;
        this.hostOnly = bl3;
        this.persistent = bl4;
    }

    Cookie(Builder builder) {
        if (builder.name == null) {
            throw new NullPointerException(z[9]);
        }
        if (builder.value == null) {
            throw new NullPointerException(z[8]);
        }
        if (builder.domain == null) {
            throw new NullPointerException(z[10]);
        }
        this.name = builder.name;
        this.value = builder.value;
        this.expiresAt = builder.expiresAt;
        this.domain = builder.domain;
        this.path = builder.path;
        this.secure = builder.secure;
        this.httpOnly = builder.httpOnly;
        this.persistent = builder.persistent;
        this.hostOnly = builder.hostOnly;
    }

    public final String name() {
        return this.name;
    }

    public final String value() {
        return this.value;
    }

    public final boolean persistent() {
        return this.persistent;
    }

    public final long expiresAt() {
        return this.expiresAt;
    }

    public final boolean hostOnly() {
        return this.hostOnly;
    }

    public final String domain() {
        return this.domain;
    }

    public final String path() {
        return this.path;
    }

    public final boolean httpOnly() {
        return this.httpOnly;
    }

    public final boolean secure() {
        return this.secure;
    }

    public final boolean matches(HttpUrl httpUrl) {
        if (!(this.hostOnly ? httpUrl.host().equals(this.domain) : Cookie.domainMatch(httpUrl.host(), this.domain))) {
            return false;
        }
        if (!Cookie.pathMatch(httpUrl, this.path)) {
            return false;
        }
        return !this.secure || httpUrl.isHttps();
    }

    private static boolean domainMatch(String string, String string2) {
        if (string.equals(string2)) {
            return true;
        }
        return string.endsWith(string2) && string.charAt(string.length() - string2.length() - 1) == '.' && !Util.verifyAsIpAddress(string);
    }

    private static boolean pathMatch(HttpUrl object, String string) {
        if (((String)(object = ((HttpUrl)object).encodedPath())).equals(string)) {
            return true;
        }
        if (((String)object).startsWith(string)) {
            if (string.endsWith("/")) {
                return true;
            }
            if (((String)object).charAt(string.length()) == '/') {
                return true;
            }
        }
        return false;
    }

    @Nullable
    public static Cookie parse(HttpUrl httpUrl, String string) {
        return Cookie.parse(System.currentTimeMillis(), httpUrl, string);
    }

    @Nullable
    static Cookie parse(long l2, HttpUrl httpUrl, String string) {
        long l3;
        int n2 = string.length();
        int n3 = Util.delimiterOffset(string, 0, n2, ';');
        int n4 = Util.delimiterOffset(string, 0, n3, '=');
        if (n4 == n3) {
            return null;
        }
        String string2 = Util.trimSubstring(string, 0, n4);
        if (string2.isEmpty() || Util.indexOfControlOrNonAscii(string2) != -1) {
            return null;
        }
        String string3 = Util.trimSubstring(string, n4 + 1, n3);
        if (Util.indexOfControlOrNonAscii(string3) != -1) {
            return null;
        }
        long l4 = 253402300799999L;
        long l5 = -1L;
        String string4 = null;
        String string5 = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = true;
        boolean bl4 = false;
        ++n3;
        while (n3 < n2) {
            String string6;
            int n5 = Util.delimiterOffset(string, n3, n2, ';');
            int n6 = Util.delimiterOffset(string, n3, n5, '=');
            String string7 = Util.trimSubstring(string, n3, n6);
            String string8 = string6 = n6 < n5 ? Util.trimSubstring(string, n6 + 1, n5) : "";
            if (string7.equalsIgnoreCase(z[12])) {
                try {
                    l4 = Cookie.parseExpires(string6, 0, string6.length());
                    bl4 = true;
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            } else if (string7.equalsIgnoreCase(z[14])) {
                try {
                    l5 = Cookie.parseMaxAge(string6);
                    bl4 = true;
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (string7.equalsIgnoreCase(z[11])) {
                try {
                    string4 = Cookie.parseDomain(string6);
                    bl3 = false;
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            } else if (string7.equalsIgnoreCase(z[16])) {
                string5 = string6;
            } else if (string7.equalsIgnoreCase(z[13])) {
                bl = true;
            } else if (string7.equalsIgnoreCase(z[15])) {
                bl2 = true;
            }
            n3 = n5 + 1;
        }
        if (l5 == Long.MIN_VALUE) {
            l4 = Long.MIN_VALUE;
        } else if (l5 != -1L && ((l4 = l2 + (l3 = l5 <= 9223372036854775L ? l5 * 1000L : Long.MAX_VALUE)) < l2 || l4 > 253402300799999L)) {
            l4 = 253402300799999L;
        }
        String string9 = httpUrl.host();
        if (string4 == null) {
            string4 = string9;
        } else if (!Cookie.domainMatch(string9, string4)) {
            return null;
        }
        if (string9.length() != string4.length() && PublicSuffixDatabase.get().getEffectiveTldPlusOne(string4) == null) {
            return null;
        }
        if (string5 == null || !string5.startsWith("/")) {
            String string10 = httpUrl.encodedPath();
            n3 = string10.lastIndexOf(47);
            string5 = n3 != 0 ? string10.substring(0, n3) : "/";
        }
        return new Cookie(string2, string3, l4, string4, string5, bl, bl2, bl3, bl4);
    }

    private static long parseExpires(String string, int n2, int n3) {
        n2 = Cookie.dateCharacterOffset(string, n2, n3, false);
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        int n7 = -1;
        int n8 = -1;
        int n9 = -1;
        Matcher matcher = TIME_PATTERN.matcher(string);
        while (n2 < n3) {
            int n10 = Cookie.dateCharacterOffset(string, n2 + 1, n3, true);
            matcher.region(n2, n10);
            if (n4 == -1 && matcher.usePattern(TIME_PATTERN).matches()) {
                n4 = Integer.parseInt(matcher.group(1));
                n5 = Integer.parseInt(matcher.group(2));
                n6 = Integer.parseInt(matcher.group(3));
            } else if (n7 == -1 && matcher.usePattern(DAY_OF_MONTH_PATTERN).matches()) {
                n7 = Integer.parseInt(matcher.group(1));
            } else if (n8 == -1 && matcher.usePattern(MONTH_PATTERN).matches()) {
                String string2 = matcher.group(1).toLowerCase(Locale.US);
                n8 = MONTH_PATTERN.pattern().indexOf(string2) / 4;
            } else if (n9 == -1 && matcher.usePattern(YEAR_PATTERN).matches()) {
                n9 = Integer.parseInt(matcher.group(1));
            }
            n2 = Cookie.dateCharacterOffset(string, n10 + 1, n3, false);
        }
        if (n9 >= 70 && n9 <= 99) {
            n9 += 1900;
        }
        if (n9 >= 0 && n9 <= 69) {
            n9 += 2000;
        }
        if (n9 < 1601) {
            throw new IllegalArgumentException();
        }
        if (n8 == -1) {
            throw new IllegalArgumentException();
        }
        if (n7 <= 0 || n7 > 31) {
            throw new IllegalArgumentException();
        }
        if (n4 < 0 || n4 > 23) {
            throw new IllegalArgumentException();
        }
        if (n5 < 0 || n5 > 59) {
            throw new IllegalArgumentException();
        }
        if (n6 < 0 || n6 > 59) {
            throw new IllegalArgumentException();
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar(Util.UTC);
        gregorianCalendar.setLenient(false);
        gregorianCalendar.set(1, n9);
        gregorianCalendar.set(2, n8 - 1);
        gregorianCalendar.set(5, n7);
        gregorianCalendar.set(11, n4);
        gregorianCalendar.set(12, n5);
        gregorianCalendar.set(13, n6);
        gregorianCalendar.set(14, 0);
        return gregorianCalendar.getTimeInMillis();
    }

    private static int dateCharacterOffset(String string, int n2, int n3, boolean bl) {
        while (n2 < n3) {
            char c2 = string.charAt(n2);
            if ((c2 < ' ' && c2 != '\t' || c2 >= '\u007f' || c2 >= '0' && c2 <= '9' || c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z' || c2 == ':') == !bl) {
                return n2;
            }
            ++n2;
        }
        return n3;
    }

    private static long parseMaxAge(String string) {
        try {
            long l2 = Long.parseLong(string);
            if (l2 <= 0L) {
                return Long.MIN_VALUE;
            }
            return l2;
        }
        catch (NumberFormatException numberFormatException) {
            if (string.matches(z[0])) {
                if (string.startsWith("-")) {
                    return Long.MIN_VALUE;
                }
                return Long.MAX_VALUE;
            }
            throw numberFormatException;
        }
    }

    private static String parseDomain(String string) {
        if (string.endsWith(".")) {
            throw new IllegalArgumentException();
        }
        if (string.startsWith(".")) {
            string = string.substring(1);
        }
        if ((string = Util.canonicalizeHost(string)) == null) {
            throw new IllegalArgumentException();
        }
        return string;
    }

    public static List<Cookie> parseAll(HttpUrl httpUrl, Headers object) {
        object = ((Headers)object).values(z[7]);
        ArrayList<Cookie> arrayList = null;
        int n2 = object.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Cookie cookie = Cookie.parse(httpUrl, (String)object.get(i2));
            if (cookie == null) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<Cookie>();
            }
            arrayList.add(cookie);
        }
        if (arrayList != null) {
            return Collections.unmodifiableList(arrayList);
        }
        return Collections.emptyList();
    }

    public final String toString() {
        return this.toString(false);
    }

    final String toString(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.name);
        stringBuilder.append('=');
        stringBuilder.append(this.value);
        if (this.persistent) {
            if (this.expiresAt == Long.MIN_VALUE) {
                stringBuilder.append(z[5]);
            } else {
                stringBuilder.append(z[3]).append(HttpDate.format(new Date(this.expiresAt)));
            }
        }
        if (!this.hostOnly) {
            stringBuilder.append(z[6]);
            if (bl) {
                stringBuilder.append(".");
            }
            stringBuilder.append(this.domain);
        }
        stringBuilder.append(z[1]).append(this.path);
        if (this.secure) {
            stringBuilder.append(z[2]);
        }
        if (this.httpOnly) {
            stringBuilder.append(z[4]);
        }
        return stringBuilder.toString();
    }

    public final boolean equals(@Nullable Object object) {
        if (!(object instanceof Cookie)) {
            return false;
        }
        object = (Cookie)object;
        return ((Cookie)object).name.equals(this.name) && ((Cookie)object).value.equals(this.value) && ((Cookie)object).domain.equals(this.domain) && ((Cookie)object).path.equals(this.path) && ((Cookie)object).expiresAt == this.expiresAt && ((Cookie)object).secure == this.secure && ((Cookie)object).httpOnly == this.httpOnly && ((Cookie)object).persistent == this.persistent && ((Cookie)object).hostOnly == this.hostOnly;
    }

    public final int hashCode() {
        int n2 = 527 + this.name.hashCode();
        n2 = 31 * n2 + this.value.hashCode();
        n2 = 31 * n2 + this.domain.hashCode();
        n2 = 31 * n2 + this.path.hashCode();
        n2 = 31 * n2 + (int)(this.expiresAt ^ this.expiresAt >>> 32);
        n2 = 31 * n2 + (this.secure ? 0 : 1);
        n2 = 31 * n2 + (this.httpOnly ? 0 : 1);
        n2 = 31 * n2 + (this.persistent ? 0 : 1);
        return 31 * n2 + (this.hostOnly ? 0 : 1);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String string2;
        int n2;
        String[] stringArray = new String[17];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n3 = 0;
        String string3 = "&Mba\u0002";
        int n4 = -1;
        block35: while (true) {
            char[] cArray;
            block44: {
                int n5;
                int n6;
                char[] cArray2;
                block43: {
                    char[] cArray3 = string3.toCharArray();
                    n2 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n6 = n7;
                    if (n7 <= 1) break block43;
                    cArray = cArray2;
                    n5 = n6;
                    if (n6 <= n2) break block44;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n2;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n2 % 5) {
                            case 0: {
                                n9 = 11;
                                break;
                            }
                            case 1: {
                                n9 = 114;
                                break;
                            }
                            case 2: {
                                n9 = 62;
                                break;
                            }
                            case 3: {
                                n9 = 5;
                                break;
                            }
                            default: {
                                n9 = 41;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n2;
                        cArray2 = cArray5;
                        n6 = n6;
                        if (n6 != 0) break;
                        cArray5 = cArray2;
                        n5 = n6;
                        n8 = n6;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n5 = n6;
                } while (n6 > n2);
            }
            string2 = new String(cArray);
            switch (n4) {
                default: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 1;
                    string3 = "0RNd]cO";
                    n4 = 0;
                    continue block35;
                }
                case 0: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 2;
                    string3 = "0RM`J~\u0000[";
                    n4 = 1;
                    continue block35;
                }
                case 1: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 3;
                    string3 = "0R[}Yb\u0000[v\u0014";
                    n4 = 2;
                    continue block35;
                }
                case 2: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 4;
                    string3 = "0RVq]{\u001dPiP";
                    n4 = 3;
                    continue block35;
                }
                case 3: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 5;
                    string3 = "0RSdQ&\u0013Y`\u0014;";
                    n4 = 4;
                    continue block35;
                }
                case 4: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 6;
                    string3 = "0RZjDj\u001bP8";
                    n4 = 5;
                    continue block35;
                }
                case 5: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 7;
                    string3 = "X\u0017J(jd\u001dUlL";
                    n4 = 6;
                    continue block35;
                }
                case 6: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 8;
                    string3 = "i\u0007WiMn\u0000\u0010sHg\u0007[%\u00146RPpEg";
                    n4 = 7;
                    continue block35;
                }
                case 7: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 9;
                    string3 = "i\u0007WiMn\u0000\u0010kHf\u0017\u001e8\u0014+\u001cKiE";
                    n4 = 8;
                    continue block35;
                }
                case 8: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 10;
                    string3 = "i\u0007WiMn\u0000\u0010aFf\u0013Wk\t6O\u001ek\\g\u001e";
                    n4 = 9;
                    continue block35;
                }
                case 9: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 11;
                    string3 = "o\u001dSd@e";
                    n4 = 10;
                    continue block35;
                }
                case 10: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 12;
                    string3 = "n\nNl[n\u0001";
                    n4 = 11;
                    continue block35;
                }
                case 11: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 13;
                    string3 = "x\u0017]p[n";
                    n4 = 12;
                    continue block35;
                }
                case 12: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 14;
                    string3 = "f\u0013F(Hl\u0017";
                    n4 = 13;
                    continue block35;
                }
                case 13: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 15;
                    string3 = "c\u0006JuFe\u001eG";
                    n4 = 14;
                    continue block35;
                }
                case 14: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 16;
                    string3 = "{\u0013Jm";
                    n4 = 15;
                    continue block35;
                }
                case 15: 
            }
            break;
        }
        stringArray2[n3] = string2.intern();
        z = stringArray3;
        String string4 = "#.Z~\u001b'FC,rU.ZX\u0003";
        int n10 = -1;
        block38: while (true) {
            char[] cArray;
            block46: {
                int n11;
                int n12;
                char[] cArray6;
                block45: {
                    char[] cArray7 = string4.toCharArray();
                    n2 = 0;
                    int n13 = cArray7.length;
                    cArray6 = cArray7;
                    n12 = n13;
                    if (n13 <= 1) break block45;
                    cArray = cArray6;
                    n11 = n12;
                    if (n12 <= n2) break block46;
                }
                do {
                    char[] cArray8 = cArray6;
                    char[] cArray9 = cArray6;
                    int n14 = n2;
                    while (true) {
                        int n15;
                        char c3 = cArray8[n14];
                        switch (n2 % 5) {
                            case 0: {
                                n15 = 11;
                                break;
                            }
                            case 1: {
                                n15 = 114;
                                break;
                            }
                            case 2: {
                                n15 = 62;
                                break;
                            }
                            case 3: {
                                n15 = 5;
                                break;
                            }
                            default: {
                                n15 = 41;
                            }
                        }
                        cArray8[n14] = (char)(c3 ^ n15);
                        ++n2;
                        cArray6 = cArray9;
                        n12 = n12;
                        if (n12 != 0) break;
                        cArray9 = cArray6;
                        n11 = n12;
                        n14 = n12;
                        cArray8 = cArray6;
                    }
                    cArray = cArray6;
                    n11 = n12;
                } while (n12 > n2);
            }
            string = new String(cArray).intern();
            switch (n10) {
                default: {
                    YEAR_PATTERN = Pattern.compile(string);
                    string4 = "#MW,\u0001a\u0013PyOn\u0010BhHy\u000e_u[w\u001f_|Ua\u0007PyC~\u001eBd\\l\u000eM`Yw\u001d]qUe\u001dHyMn\u0011\u0017+\u0003";
                    n10 = 0;
                    continue block38;
                }
                case 0: {
                    MONTH_PATTERN = Pattern.compile(string);
                    string4 = "#.Z~\u0018'@C,rU.ZX\u0003";
                    n10 = 1;
                    continue block38;
                }
                case 1: {
                    DAY_OF_MONTH_PATTERN = Pattern.compile(string);
                    string4 = "#.Z~\u0018'@C,\u0013#.Z~\u0018'@C,\u0013#.Z~\u0018'@C,rU.ZX\u0003";
                    n10 = 2;
                    continue block38;
                }
                case 2: 
            }
            break;
        }
        TIME_PATTERN = Pattern.compile(string);
    }

    public static final class Builder {
        String name;
        String value;
        long expiresAt = 253402300799999L;
        String domain;
        String path = "/";
        boolean secure;
        boolean httpOnly;
        boolean persistent;
        boolean hostOnly;
        private static final String[] z;

        public final Builder name(String string) {
            if (string == null) {
                throw new NullPointerException(z[3]);
            }
            if (!string.trim().equals(string)) {
                throw new IllegalArgumentException(z[2]);
            }
            this.name = string;
            return this;
        }

        public final Builder value(String string) {
            if (string == null) {
                throw new NullPointerException(z[1]);
            }
            if (!string.trim().equals(string)) {
                throw new IllegalArgumentException(z[0]);
            }
            this.value = string;
            return this;
        }

        public final Builder expiresAt(long l2) {
            if (l2 <= 0L) {
                l2 = Long.MIN_VALUE;
            }
            if (l2 > 253402300799999L) {
                l2 = 253402300799999L;
            }
            this.expiresAt = l2;
            this.persistent = true;
            return this;
        }

        public final Builder domain(String string) {
            return this.domain(string, false);
        }

        public final Builder hostOnlyDomain(String string) {
            return this.domain(string, true);
        }

        private Builder domain(String string, boolean bl) {
            if (string == null) {
                throw new NullPointerException(z[5]);
            }
            String string2 = Util.canonicalizeHost(string);
            if (string2 == null) {
                throw new IllegalArgumentException(z[4] + string);
            }
            this.domain = string2;
            this.hostOnly = bl;
            return this;
        }

        public final Builder path(String string) {
            if (!string.startsWith("/")) {
                throw new IllegalArgumentException(z[6]);
            }
            this.path = string;
            return this;
        }

        public final Builder secure() {
            this.secure = true;
            return this;
        }

        public final Builder httpOnly() {
            this.httpOnly = true;
            return this;
        }

        public final Cookie build() {
            return new Cookie(this);
        }

        /*
         * Handled impossible loop by duplicating code
         * Enabled aggressive block sorting
         */
        static {
            String string;
            String[] stringArray = new String[7];
            String[] stringArray2 = stringArray;
            String[] stringArray3 = stringArray;
            int n2 = 0;
            String string2 = ".Ip\u007f#xAo*(7\\<~41Eqo\"";
            int n3 = -1;
            block14: while (true) {
                char[] cArray;
                block19: {
                    int n4;
                    int n5;
                    char[] cArray2;
                    int n6;
                    block18: {
                        char[] cArray3 = string2.toCharArray();
                        n6 = 0;
                        int n7 = cArray3.length;
                        cArray2 = cArray3;
                        n5 = n7;
                        if (n7 <= 1) break block18;
                        cArray = cArray2;
                        n4 = n5;
                        if (n5 <= n6) break block19;
                    }
                    do {
                        char[] cArray4 = cArray2;
                        char[] cArray5 = cArray2;
                        int n8 = n6;
                        while (true) {
                            int n9;
                            char c2 = cArray4[n8];
                            switch (n6 % 5) {
                                case 0: {
                                    n9 = 88;
                                    break;
                                }
                                case 1: {
                                    n9 = 40;
                                    break;
                                }
                                case 2: {
                                    n9 = 28;
                                    break;
                                }
                                case 3: {
                                    n9 = 10;
                                    break;
                                }
                                default: {
                                    n9 = 70;
                                }
                            }
                            cArray4[n8] = (char)(c2 ^ n9);
                            ++n6;
                            cArray2 = cArray5;
                            n5 = n5;
                            if (n5 != 0) break;
                            cArray5 = cArray2;
                            n4 = n5;
                            n8 = n5;
                            cArray4 = cArray2;
                        }
                        cArray = cArray2;
                        n4 = n5;
                    } while (n5 > n6);
                }
                string = new String(cArray);
                switch (n3) {
                    default: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 1;
                        string2 = ".Ip\u007f#x\u0015!*(-Dp";
                        n3 = 0;
                        continue block14;
                    }
                    case 0: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 2;
                        string2 = "6Iqof1[<d),\bhx/5Eyn";
                        n3 = 1;
                        continue block14;
                    }
                    case 1: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 3;
                        string2 = "6Iqofe\u0015<d34D";
                        n3 = 2;
                        continue block14;
                    }
                    case 2: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 4;
                        string2 = "-Fyr6=Kho\"xLsg'1F&*";
                        n3 = 3;
                        continue block14;
                    }
                    case 3: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 5;
                        string2 = "<Gqk/6\b!7f6]pf";
                        n3 = 4;
                        continue block14;
                    }
                    case 4: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 6;
                        string2 = "(Ihbf5]o~f+\\}x2x_u~.x\u000f3-";
                        n3 = 5;
                        continue block14;
                    }
                    case 5: 
                }
                break;
            }
            stringArray2[n2] = string.intern();
            z = stringArray3;
        }
    }
}

