/*
 * Decompiled with CFR 0.152.
 */
package cn.jmessage.support.okhttp3;

import cn.jmessage.support.annotation.Nullable;
import cn.jmessage.support.okhttp3.CacheControl;
import cn.jmessage.support.okhttp3.Headers;
import cn.jmessage.support.okhttp3.HttpUrl;
import cn.jmessage.support.okhttp3.RequestBody;
import cn.jmessage.support.okhttp3.internal.Util;
import cn.jmessage.support.okhttp3.internal.http.HttpMethod;
import java.net.URL;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class Request {
    final HttpUrl url;
    final String method;
    final Headers headers;
    @Nullable
    final RequestBody body;
    final Map<Class<?>, Object> tags;
    private volatile CacheControl cacheControl;
    private static final String[] z;

    Request(Builder builder) {
        this.url = builder.url;
        this.method = builder.method;
        this.headers = builder.headers.build();
        this.body = builder.body;
        this.tags = Util.immutableMap(builder.tags);
    }

    public final HttpUrl url() {
        return this.url;
    }

    public final String method() {
        return this.method;
    }

    public final Headers headers() {
        return this.headers;
    }

    @Nullable
    public final String header(String string) {
        return this.headers.get(string);
    }

    public final List<String> headers(String string) {
        return this.headers.values(string);
    }

    @Nullable
    public final RequestBody body() {
        return this.body;
    }

    @Nullable
    public final Object tag() {
        return this.tag(Object.class);
    }

    @Nullable
    public final <T> T tag(Class<? extends T> clazz) {
        return clazz.cast(this.tags.get(clazz));
    }

    public final Builder newBuilder() {
        return new Builder(this);
    }

    public final CacheControl cacheControl() {
        CacheControl cacheControl = this.cacheControl;
        if (cacheControl != null) {
            return cacheControl;
        }
        this.cacheControl = CacheControl.parse(this.headers);
        return this.cacheControl;
    }

    public final boolean isHttps() {
        return this.url.isHttps();
    }

    public final String toString() {
        return z[0] + this.method + z[2] + this.url + z[1] + this.tags + '}';
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[3];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "\f|\u0014+\u001c-m\u001e3\u001c*q\n:D";
        int n3 = -1;
        block10: while (true) {
            char[] cArray;
            block15: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block14: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block14;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block15;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 94;
                                break;
                            }
                            case 1: {
                                n9 = 25;
                                break;
                            }
                            case 2: {
                                n9 = 101;
                                break;
                            }
                            case 3: {
                                n9 = 94;
                                break;
                            }
                            default: {
                                n9 = 121;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "r9\u0011?\u001e-$";
                    n3 = 0;
                    continue block10;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "r9\u0010,\u0015c";
                    n3 = 1;
                    continue block10;
                }
                case 1: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }

    public static class Builder {
        HttpUrl url;
        String method;
        Headers.Builder headers;
        RequestBody body;
        Map<Class<?>, Object> tags = Collections.emptyMap();
        private static final String[] z;

        public Builder() {
            this.method = z[0];
            this.headers = new Headers.Builder();
        }

        Builder(Request request) {
            this.url = request.url;
            this.method = request.method;
            this.body = request.body;
            this.tags = request.tags.isEmpty() ? Collections.emptyMap() : new LinkedHashMap(request.tags);
            this.headers = request.headers.newBuilder();
        }

        public Builder url(HttpUrl httpUrl) {
            if (httpUrl == null) {
                throw new NullPointerException(z[5]);
            }
            this.url = httpUrl;
            return this;
        }

        public Builder url(String string) {
            if (string == null) {
                throw new NullPointerException(z[5]);
            }
            if (string.regionMatches(true, 0, z[4], 0, 3)) {
                string = z[3] + string.substring(3);
            } else if (string.regionMatches(true, 0, z[1], 0, 4)) {
                string = z[2] + string.substring(4);
            }
            return this.url(HttpUrl.get(string));
        }

        public Builder url(URL uRL) {
            if (uRL == null) {
                throw new NullPointerException(z[5]);
            }
            return this.url(HttpUrl.get(uRL.toString()));
        }

        public Builder header(String string, String string2) {
            this.headers.set(string, string2);
            return this;
        }

        public Builder addHeader(String string, String string2) {
            this.headers.add(string, string2);
            return this;
        }

        public Builder removeHeader(String string) {
            this.headers.removeAll(string);
            return this;
        }

        public Builder headers(Headers headers) {
            this.headers = headers.newBuilder();
            return this;
        }

        public Builder cacheControl(CacheControl object) {
            if (((String)(object = ((CacheControl)object).toString())).isEmpty()) {
                return this.removeHeader(z[15]);
            }
            return this.header(z[15], (String)object);
        }

        public Builder get() {
            return this.method(z[0], null);
        }

        public Builder head() {
            return this.method(z[16], null);
        }

        public Builder post(RequestBody requestBody) {
            return this.method(z[12], requestBody);
        }

        public Builder delete(@Nullable RequestBody requestBody) {
            return this.method(z[13], requestBody);
        }

        public Builder delete() {
            return this.delete(Util.EMPTY_REQUEST);
        }

        public Builder put(RequestBody requestBody) {
            return this.method(z[14], requestBody);
        }

        public Builder patch(RequestBody requestBody) {
            return this.method(z[11], requestBody);
        }

        public Builder method(String string, @Nullable RequestBody requestBody) {
            if (string == null) {
                throw new NullPointerException(z[10]);
            }
            if (string.length() == 0) {
                throw new IllegalArgumentException(z[6]);
            }
            if (requestBody != null && !HttpMethod.permitsRequestBody(string)) {
                throw new IllegalArgumentException(z[7] + string + z[8]);
            }
            if (requestBody == null && HttpMethod.requiresRequestBody(string)) {
                throw new IllegalArgumentException(z[7] + string + z[9]);
            }
            this.method = string;
            this.body = requestBody;
            return this;
        }

        public Builder tag(@Nullable Object object) {
            return this.tag(Object.class, object);
        }

        public <T> Builder tag(Class<? super T> clazz, @Nullable T t2) {
            if (clazz == null) {
                throw new NullPointerException(z[17]);
            }
            if (t2 == null) {
                this.tags.remove(clazz);
            } else {
                if (this.tags.isEmpty()) {
                    this.tags = new LinkedHashMap();
                }
                this.tags.put(clazz, clazz.cast(t2));
            }
            return this;
        }

        public Request build() {
            if (this.url == null) {
                throw new IllegalStateException(z[5]);
            }
            return new Request(this);
        }

        /*
         * Handled impossible loop by duplicating code
         * Enabled aggressive block sorting
         */
        static {
            String string;
            String[] stringArray = new String[18];
            String[] stringArray2 = stringArray;
            String[] stringArray3 = stringArray;
            int n2 = 0;
            String string2 = "Z\u0016V";
            int n3 = -1;
            block25: while (true) {
                char[] cArray;
                block30: {
                    int n4;
                    int n5;
                    char[] cArray2;
                    int n6;
                    block29: {
                        char[] cArray3 = string2.toCharArray();
                        n6 = 0;
                        int n7 = cArray3.length;
                        cArray2 = cArray3;
                        n5 = n7;
                        if (n7 <= 1) break block29;
                        cArray = cArray2;
                        n4 = n5;
                        if (n5 <= n6) break block30;
                    }
                    do {
                        char[] cArray4 = cArray2;
                        char[] cArray5 = cArray2;
                        int n8 = n6;
                        while (true) {
                            int n9;
                            char c2 = cArray4[n8];
                            switch (n6 % 5) {
                                case 0: {
                                    n9 = 29;
                                    break;
                                }
                                case 1: {
                                    n9 = 83;
                                    break;
                                }
                                case 2: {
                                    n9 = 2;
                                    break;
                                }
                                case 3: {
                                    n9 = 31;
                                    break;
                                }
                                default: {
                                    n9 = 116;
                                }
                            }
                            cArray4[n8] = (char)(c2 ^ n9);
                            ++n6;
                            cArray2 = cArray5;
                            n5 = n5;
                            if (n5 != 0) break;
                            cArray5 = cArray2;
                            n4 = n5;
                            n8 = n5;
                            cArray4 = cArray2;
                        }
                        cArray = cArray2;
                        n4 = n5;
                    } while (n5 > n6);
                }
                string = new String(cArray);
                switch (n3) {
                    default: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 1;
                        string2 = "j q%";
                        n3 = 0;
                        continue block25;
                    }
                    case 0: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 2;
                        string2 = "u'vo\u0007'";
                        n3 = 1;
                        continue block25;
                    }
                    case 1: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 3;
                        string2 = "u'voN";
                        n3 = 2;
                        continue block25;
                    }
                    case 2: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 4;
                        string2 = "j 8";
                        n3 = 3;
                        continue block25;
                    }
                    case 3: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 5;
                        string2 = "h!n?I slj\u0018q";
                        n3 = 4;
                        continue block25;
                    }
                    case 4: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 6;
                        string2 = "p6vw\u001by}nz\u001az'j7]=n??D";
                        n3 = 5;
                        continue block25;
                    }
                    case 5: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 7;
                        string2 = "p6vw\u001bys";
                        n3 = 6;
                        continue block25;
                    }
                    case 6: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 8;
                        string2 = "=>wl\u0000==mkTu2tzT|spz\u0005h6qkT\u007f<ffZ";
                        n3 = 7;
                        continue block25;
                    }
                    case 7: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 9;
                        string2 = "=>wl\u0000=;ci\u0011=2\"m\u0011l&gl\u0000=1m{\r3";
                        n3 = 8;
                        continue block25;
                    }
                    case 8: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 10;
                        string2 = "p6vw\u001bys?\"Ts&ns";
                        n3 = 9;
                        continue block25;
                    }
                    case 9: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 11;
                        string2 = "M\u0012V\\<";
                        n3 = 10;
                        continue block25;
                    }
                    case 10: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 12;
                        string2 = "M\u001cQK";
                        n3 = 11;
                        continue block25;
                    }
                    case 11: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 13;
                        string2 = "Y\u0016NZ X";
                        n3 = 12;
                        continue block25;
                    }
                    case 12: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 14;
                        string2 = "M\u0006V";
                        n3 = 13;
                        continue block25;
                    }
                    case 13: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 15;
                        string2 = "^2aw\u00110\u0010mq\u0000o<n";
                        n3 = 14;
                        continue block25;
                    }
                    case 14: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 16;
                        string2 = "U\u0016C[";
                        n3 = 15;
                        continue block25;
                    }
                    case 15: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 17;
                        string2 = "i*rzT n\"q\u0001q?";
                        n3 = 16;
                        continue block25;
                    }
                    case 16: 
                }
                break;
            }
            stringArray2[n2] = string.intern();
            z = stringArray3;
        }
    }
}

