/*
 * Decompiled with CFR 0.152.
 */
package cn.jmessage.support.okhttp3;

import cn.jmessage.support.annotation.Nullable;
import cn.jmessage.support.okhttp3.MediaType;
import cn.jmessage.support.okhttp3.internal.Util;
import cn.jmessage.support.okio.BufferedSink;
import cn.jmessage.support.okio.ByteString;
import cn.jmessage.support.okio.Okio;
import cn.jmessage.support.okio.Source;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;

public abstract class RequestBody {
    private static final String[] z;

    @Nullable
    public abstract MediaType contentType();

    public long contentLength() throws IOException {
        return -1L;
    }

    public abstract void writeTo(BufferedSink var1) throws IOException;

    public static RequestBody create(@Nullable MediaType mediaType, String object) {
        Charset charset = Util.UTF_8;
        if (mediaType != null && (charset = mediaType.charset()) == null) {
            charset = Util.UTF_8;
            mediaType = MediaType.parse(mediaType + z[0]);
        }
        object = ((String)object).getBytes(charset);
        return RequestBody.create(mediaType, (byte[])object);
    }

    public static RequestBody create(final @Nullable MediaType mediaType, final ByteString byteString) {
        return new RequestBody(){

            @Override
            @Nullable
            public final MediaType contentType() {
                return mediaType;
            }

            @Override
            public final long contentLength() throws IOException {
                return byteString.size();
            }

            @Override
            public final void writeTo(BufferedSink bufferedSink) throws IOException {
                bufferedSink.write(byteString);
            }
        };
    }

    public static RequestBody create(@Nullable MediaType mediaType, byte[] byArray) {
        return RequestBody.create(mediaType, byArray, 0, byArray.length);
    }

    public static RequestBody create(final @Nullable MediaType mediaType, final byte[] byArray, final int n2, final int n3) {
        if (byArray == null) {
            throw new NullPointerException(z[1]);
        }
        Util.checkOffsetAndCount(byArray.length, n2, n3);
        return new RequestBody(){

            @Override
            @Nullable
            public final MediaType contentType() {
                return mediaType;
            }

            @Override
            public final long contentLength() {
                return n3;
            }

            @Override
            public final void writeTo(BufferedSink bufferedSink) throws IOException {
                bufferedSink.write(byArray, n2, n3);
            }
        };
    }

    public static RequestBody create(final @Nullable MediaType mediaType, final File file) {
        if (file == null) {
            throw new NullPointerException(z[1]);
        }
        return new RequestBody(){

            @Override
            @Nullable
            public final MediaType contentType() {
                return mediaType;
            }

            @Override
            public final long contentLength() {
                return file.length();
            }

            @Override
            public final void writeTo(BufferedSink bufferedSink) throws IOException {
                Source source = null;
                try {
                    source = Okio.source(file);
                    bufferedSink.writeAll(source);
                    return;
                }
                finally {
                    Util.closeQuietly(source);
                }
            }
        };
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[2];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "\"7y/Vkd\u007f3\nlc|j\u000f";
        int n3 = -1;
        block9: while (true) {
            char[] cArray;
            block14: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block13: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block13;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block14;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 25;
                                break;
                            }
                            case 1: {
                                n9 = 23;
                                break;
                            }
                            case 2: {
                                n9 = 26;
                                break;
                            }
                            case 3: {
                                n9 = 71;
                                break;
                            }
                            default: {
                                n9 = 55;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "zxt3Rwc:z\n9yo+[";
                    n3 = 0;
                    continue block9;
                }
                case 0: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

