/*
 * Decompiled with CFR 0.152.
 */
package cn.jmessage.support.okhttp3;

import cn.jmessage.support.annotation.Nullable;
import cn.jmessage.support.okhttp3.CacheControl;
import cn.jmessage.support.okhttp3.Challenge;
import cn.jmessage.support.okhttp3.Handshake;
import cn.jmessage.support.okhttp3.Headers;
import cn.jmessage.support.okhttp3.Protocol;
import cn.jmessage.support.okhttp3.Request;
import cn.jmessage.support.okhttp3.ResponseBody;
import cn.jmessage.support.okhttp3.internal.http.HttpHeaders;
import cn.jmessage.support.okio.Buffer;
import cn.jmessage.support.okio.BufferedSource;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

public final class Response
implements Closeable {
    final Request request;
    final Protocol protocol;
    final int code;
    final String message;
    @Nullable
    final Handshake handshake;
    final Headers headers;
    @Nullable
    final ResponseBody body;
    @Nullable
    final Response networkResponse;
    @Nullable
    final Response cacheResponse;
    @Nullable
    final Response priorResponse;
    final long sentRequestAtMillis;
    final long receivedResponseAtMillis;
    private volatile CacheControl cacheControl;
    private static final String[] z;

    Response(Builder builder) {
        this.request = builder.request;
        this.protocol = builder.protocol;
        this.code = builder.code;
        this.message = builder.message;
        this.handshake = builder.handshake;
        this.headers = builder.headers.build();
        this.body = builder.body;
        this.networkResponse = builder.networkResponse;
        this.cacheResponse = builder.cacheResponse;
        this.priorResponse = builder.priorResponse;
        this.sentRequestAtMillis = builder.sentRequestAtMillis;
        this.receivedResponseAtMillis = builder.receivedResponseAtMillis;
    }

    public final Request request() {
        return this.request;
    }

    public final Protocol protocol() {
        return this.protocol;
    }

    public final int code() {
        return this.code;
    }

    public final boolean isSuccessful() {
        return this.code >= 200 && this.code < 300;
    }

    public final String message() {
        return this.message;
    }

    public final Handshake handshake() {
        return this.handshake;
    }

    public final List<String> headers(String string) {
        return this.headers.values(string);
    }

    @Nullable
    public final String header(String string) {
        return this.header(string, null);
    }

    @Nullable
    public final String header(String string, @Nullable String string2) {
        if ((string = this.headers.get(string)) != null) {
            return string;
        }
        return string2;
    }

    public final Headers headers() {
        return this.headers;
    }

    public final ResponseBody peekBody(long l2) throws IOException {
        BufferedSource bufferedSource;
        BufferedSource bufferedSource2 = this.body.source();
        bufferedSource2.request(l2);
        bufferedSource2 = bufferedSource2.buffer().clone();
        if (((Buffer)bufferedSource2).size() > l2) {
            bufferedSource = new Buffer();
            ((Buffer)bufferedSource).write((Buffer)bufferedSource2, l2);
            ((Buffer)bufferedSource2).clear();
        } else {
            bufferedSource = bufferedSource2;
        }
        return ResponseBody.create(this.body.contentType(), ((Buffer)bufferedSource).size(), bufferedSource);
    }

    @Nullable
    public final ResponseBody body() {
        return this.body;
    }

    public final Builder newBuilder() {
        return new Builder(this);
    }

    public final boolean isRedirect() {
        switch (this.code) {
            case 300: 
            case 301: 
            case 302: 
            case 303: 
            case 307: 
            case 308: {
                return true;
            }
        }
        return false;
    }

    @Nullable
    public final Response networkResponse() {
        return this.networkResponse;
    }

    @Nullable
    public final Response cacheResponse() {
        return this.cacheResponse;
    }

    @Nullable
    public final Response priorResponse() {
        return this.priorResponse;
    }

    public final List<Challenge> challenges() {
        String string;
        if (this.code == 401) {
            string = z[5];
        } else if (this.code == 407) {
            string = z[6];
        } else {
            return Collections.emptyList();
        }
        return HttpHeaders.parseChallenges(this.headers(), string);
    }

    public final CacheControl cacheControl() {
        CacheControl cacheControl = this.cacheControl;
        if (cacheControl != null) {
            return cacheControl;
        }
        this.cacheControl = CacheControl.parse(this.headers);
        return this.cacheControl;
    }

    public final long sentRequestAtMillis() {
        return this.sentRequestAtMillis;
    }

    public final long receivedResponseAtMillis() {
        return this.receivedResponseAtMillis;
    }

    @Override
    public final void close() {
        if (this.body == null) {
            throw new IllegalStateException(z[0]);
        }
        this.body.close();
    }

    public final String toString() {
        return z[1] + (Object)((Object)this.protocol) + z[2] + this.code + z[4] + this.message + z[3] + this.request.url() + '}';
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[7];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "\u0014C\u0006O\u0006\bU\u0010\u001f\u0000\u0015\u0006\u001bP\u001dFC\u0019V\u000e\u000fD\u0019ZI\u0000I\u0007\u001f\bFD\u001a[\u0010FG\u001b[I\u000bS\u0006KI\bI\u0001\u001f\u000b\u0003\u0006\u0016S\u0006\u0015C\u0011";
        int n3 = -1;
        block14: while (true) {
            char[] cArray;
            block19: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block18: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block18;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block19;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 102;
                                break;
                            }
                            case 1: {
                                n9 = 38;
                                break;
                            }
                            case 2: {
                                n9 = 117;
                                break;
                            }
                            case 3: {
                                n9 = 63;
                                break;
                            }
                            default: {
                                n9 = 105;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "4C\u0006O\u0006\bU\u0010D\u0019\u0014I\u0001P\n\tJH";
                    n3 = 0;
                    continue block14;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "J\u0006\u0016P\r\u0003\u001b";
                    n3 = 1;
                    continue block14;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "J\u0006\u0000M\u0005[";
                    n3 = 2;
                    continue block14;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "J\u0006\u0018Z\u001a\u0015G\u0012ZT";
                    n3 = 3;
                    continue block14;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "1q\"\u0012(\u0013R\u001dZ\u0007\u0012O\u0016^\u001d\u0003";
                    n3 = 4;
                    continue block14;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "6T\u001aG\u0010Kg\u0000K\u0001\u0003H\u0001V\n\u0007R\u0010";
                    n3 = 5;
                    continue block14;
                }
                case 5: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }

    public static class Builder {
        Request request;
        Protocol protocol;
        int code = -1;
        String message;
        @Nullable
        Handshake handshake;
        Headers.Builder headers;
        ResponseBody body;
        Response networkResponse;
        Response cacheResponse;
        Response priorResponse;
        long sentRequestAtMillis;
        long receivedResponseAtMillis;
        private static final String[] z;

        public Builder() {
            this.headers = new Headers.Builder();
        }

        Builder(Response response) {
            this.request = response.request;
            this.protocol = response.protocol;
            this.code = response.code;
            this.message = response.message;
            this.handshake = response.handshake;
            this.headers = response.headers.newBuilder();
            this.body = response.body;
            this.networkResponse = response.networkResponse;
            this.cacheResponse = response.cacheResponse;
            this.priorResponse = response.priorResponse;
            this.sentRequestAtMillis = response.sentRequestAtMillis;
            this.receivedResponseAtMillis = response.receivedResponseAtMillis;
        }

        public Builder request(Request request) {
            this.request = request;
            return this;
        }

        public Builder protocol(Protocol protocol) {
            this.protocol = protocol;
            return this;
        }

        public Builder code(int n2) {
            this.code = n2;
            return this;
        }

        public Builder message(String string) {
            this.message = string;
            return this;
        }

        public Builder handshake(@Nullable Handshake handshake) {
            this.handshake = handshake;
            return this;
        }

        public Builder header(String string, String string2) {
            this.headers.set(string, string2);
            return this;
        }

        public Builder addHeader(String string, String string2) {
            this.headers.add(string, string2);
            return this;
        }

        public Builder removeHeader(String string) {
            this.headers.removeAll(string);
            return this;
        }

        public Builder headers(Headers headers) {
            this.headers = headers.newBuilder();
            return this;
        }

        public Builder body(@Nullable ResponseBody responseBody) {
            this.body = responseBody;
            return this;
        }

        public Builder networkResponse(@Nullable Response response) {
            if (response != null) {
                this.checkSupportResponse(z[5], response);
            }
            this.networkResponse = response;
            return this;
        }

        public Builder cacheResponse(@Nullable Response response) {
            if (response != null) {
                this.checkSupportResponse(z[10], response);
            }
            this.cacheResponse = response;
            return this;
        }

        private void checkSupportResponse(String string, Response response) {
            if (response.body != null) {
                throw new IllegalArgumentException(string + z[3]);
            }
            if (response.networkResponse != null) {
                throw new IllegalArgumentException(string + z[1]);
            }
            if (response.cacheResponse != null) {
                throw new IllegalArgumentException(string + z[0]);
            }
            if (response.priorResponse != null) {
                throw new IllegalArgumentException(string + z[2]);
            }
        }

        public Builder priorResponse(@Nullable Response response) {
            if (response != null) {
                this.checkPriorResponse(response);
            }
            this.priorResponse = response;
            return this;
        }

        private void checkPriorResponse(Response response) {
            if (response.body != null) {
                throw new IllegalArgumentException(z[4]);
            }
        }

        public Builder sentRequestAtMillis(long l2) {
            this.sentRequestAtMillis = l2;
            return this;
        }

        public Builder receivedResponseAtMillis(long l2) {
            this.receivedResponseAtMillis = l2;
            return this;
        }

        public Response build() {
            if (this.request == null) {
                throw new IllegalStateException(z[7]);
            }
            if (this.protocol == null) {
                throw new IllegalStateException(z[6]);
            }
            if (this.code < 0) {
                throw new IllegalStateException(z[9] + this.code);
            }
            if (this.message == null) {
                throw new IllegalStateException(z[8]);
            }
            return new Response(this);
        }

        /*
         * Handled impossible loop by duplicating code
         * Enabled aggressive block sorting
         */
        static {
            String string;
            String[] stringArray = new String[11];
            String[] stringArray2 = stringArray;
            String[] stringArray3 = stringArray;
            int n2 = 0;
            String string2 = "r.\f|R9\u001f\blJ3#\u001ez\u001a}pMqO0!";
            int n3 = -1;
            block18: while (true) {
                char[] cArray;
                block23: {
                    int n4;
                    int n5;
                    char[] cArray2;
                    int n6;
                    block22: {
                        char[] cArray3 = string2.toCharArray();
                        n6 = 0;
                        int n7 = cArray3.length;
                        cArray2 = cArray3;
                        n5 = n7;
                        if (n7 <= 1) break block22;
                        cArray = cArray2;
                        n4 = n5;
                        if (n5 <= n6) break block23;
                    }
                    do {
                        char[] cArray4 = cArray2;
                        char[] cArray5 = cArray2;
                        int n8 = n6;
                        while (true) {
                            int n9;
                            char c2 = cArray4[n8];
                            switch (n6 % 5) {
                                case 0: {
                                    n9 = 92;
                                    break;
                                }
                                case 1: {
                                    n9 = 77;
                                    break;
                                }
                                case 2: {
                                    n9 = 109;
                                    break;
                                }
                                case 3: {
                                    n9 = 31;
                                    break;
                                }
                                default: {
                                    n9 = 58;
                                }
                            }
                            cArray4[n8] = (char)(c2 ^ n9);
                            ++n6;
                            cArray2 = cArray5;
                            n5 = n5;
                            if (n5 != 0) break;
                            cArray5 = cArray2;
                            n4 = n5;
                            n8 = n5;
                            cArray4 = cArray2;
                        }
                        cArray = cArray2;
                        n4 = n5;
                    } while (n5 > n6);
                }
                string = new String(cArray);
                switch (n3) {
                    default: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 1;
                        string2 = "r#\bkM3?\u0006M_/=\u0002qI9mL\"\u001a28\u0001s";
                        n3 = 0;
                        continue block18;
                    }
                    case 0: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 2;
                        string2 = "r=\u001fvU.\u001f\blJ3#\u001ez\u001a}pMqO0!";
                        n3 = 1;
                        continue block18;
                    }
                    case 1: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 3;
                        string2 = "r/\u0002{C|lP?T)!\u0001";
                        n3 = 2;
                        continue block18;
                    }
                    case 2: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 4;
                        string2 = ",?\u0004pH\u000e(\u001eoU2>\b1X3)\u0014?\u001bam\u0003jV0";
                        n3 = 3;
                        continue block18;
                    }
                    case 3: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 5;
                        string2 = "2(\u0019hU.&?zI,\"\u0003l_";
                        n3 = 4;
                        continue block18;
                    }
                    case 4: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 6;
                        string2 = ",?\u0002kU?\"\u0001?\u0007am\u0003jV0";
                        n3 = 5;
                        continue block18;
                    }
                    case 5: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 7;
                        string2 = ".(\u001cj_/9M\"\u0007|#\u0018sV";
                        n3 = 6;
                        continue block18;
                    }
                    case 6: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 8;
                        string2 = "1(\u001el[;(M\"\u0007|#\u0018sV";
                        n3 = 7;
                        continue block18;
                    }
                    case 7: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 9;
                        string2 = "?\"\tz\u001a`m]%\u001a";
                        n3 = 8;
                        continue block18;
                    }
                    case 8: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 10;
                        string2 = "?,\u000ew_\u000e(\u001eoU2>\b";
                        n3 = 9;
                        continue block18;
                    }
                    case 9: 
                }
                break;
            }
            stringArray2[n2] = string.intern();
            z = stringArray3;
        }
    }
}

