/*
 * Decompiled with CFR 0.152.
 */
package cn.jmessage.support.okhttp3.internal.cache;

import cn.jmessage.support.annotation.Nullable;
import cn.jmessage.support.okhttp3.internal.Util;
import cn.jmessage.support.okhttp3.internal.cache.FaultHidingSink;
import cn.jmessage.support.okhttp3.internal.io.FileSystem;
import cn.jmessage.support.okhttp3.internal.platform.Platform;
import cn.jmessage.support.okio.BufferedSink;
import cn.jmessage.support.okio.BufferedSource;
import cn.jmessage.support.okio.Okio;
import cn.jmessage.support.okio.Sink;
import cn.jmessage.support.okio.Source;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.Flushable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.NoSuchElementException;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;

public final class DiskLruCache
implements Closeable,
Flushable {
    static final String JOURNAL_FILE;
    static final String JOURNAL_FILE_TEMP;
    static final String JOURNAL_FILE_BACKUP;
    static final String MAGIC;
    static final String VERSION_1 = "1";
    static final long ANY_SEQUENCE_NUMBER = -1L;
    static final Pattern LEGAL_KEY_PATTERN;
    private static final String CLEAN;
    private static final String DIRTY;
    private static final String REMOVE;
    private static final String READ;
    final FileSystem fileSystem;
    final File directory;
    private final File journalFile;
    private final File journalFileTmp;
    private final File journalFileBackup;
    private final int appVersion;
    private long maxSize;
    final int valueCount;
    private long size = 0L;
    BufferedSink journalWriter;
    final LinkedHashMap<String, Entry> lruEntries = new LinkedHashMap(0, 0.75f, true);
    int redundantOpCount;
    boolean hasJournalErrors;
    boolean initialized;
    boolean closed;
    boolean mostRecentTrimFailed;
    boolean mostRecentRebuildFailed;
    private long nextSequenceNumber = 0L;
    private final Executor executor;
    private final Runnable cleanupRunnable = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            DiskLruCache diskLruCache = DiskLruCache.this;
            synchronized (diskLruCache) {
                if (!DiskLruCache.this.initialized | DiskLruCache.this.closed) {
                    return;
                }
                try {
                    DiskLruCache.this.trimToSize();
                }
                catch (IOException iOException) {
                    DiskLruCache.this.mostRecentTrimFailed = true;
                }
                try {
                    if (DiskLruCache.this.journalRebuildRequired()) {
                        DiskLruCache.this.rebuildJournal();
                        DiskLruCache.this.redundantOpCount = 0;
                    }
                }
                catch (IOException iOException) {
                    DiskLruCache.this.mostRecentRebuildFailed = true;
                    DiskLruCache.this.journalWriter = Okio.buffer(Okio.blackhole());
                }
                return;
            }
        }
    };
    private static final String[] z;

    DiskLruCache(FileSystem fileSystem, File file, int n2, int n3, long l2, Executor executor) {
        this.fileSystem = fileSystem;
        this.directory = file;
        this.appVersion = n2;
        this.journalFile = new File(file, JOURNAL_FILE);
        this.journalFileTmp = new File(file, JOURNAL_FILE_TEMP);
        this.journalFileBackup = new File(file, JOURNAL_FILE_BACKUP);
        this.valueCount = n3;
        this.maxSize = l2;
        this.executor = executor;
    }

    public final synchronized void initialize() throws IOException {
        assert (Thread.holdsLock(this));
        if (this.initialized) {
            return;
        }
        if (this.fileSystem.exists(this.journalFileBackup)) {
            if (this.fileSystem.exists(this.journalFile)) {
                this.fileSystem.delete(this.journalFileBackup);
            } else {
                this.fileSystem.rename(this.journalFileBackup, this.journalFile);
            }
        }
        if (this.fileSystem.exists(this.journalFile)) {
            try {
                this.readJournal();
                this.processJournal();
                this.initialized = true;
                return;
            }
            catch (IOException iOException) {
                Platform.get().log(5, z[5] + this.directory + z[4] + iOException.getMessage() + z[6], iOException);
                try {
                    this.delete();
                }
                finally {
                    this.closed = false;
                }
            }
        }
        this.rebuildJournal();
        this.initialized = true;
    }

    public static DiskLruCache create(FileSystem fileSystem, File file, int n2, int n3, long l2) {
        if (l2 <= 0L) {
            throw new IllegalArgumentException(z[10]);
        }
        if (n3 <= 0) {
            throw new IllegalArgumentException(z[9]);
        }
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(0, 1, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), Util.threadFactory(z[8], true));
        return new DiskLruCache(fileSystem, file, n2, n3, l2, threadPoolExecutor);
    }

    private void readJournal() throws IOException {
        BufferedSource bufferedSource = Okio.buffer(this.fileSystem.source(this.journalFile));
        try {
            String string = bufferedSource.readUtf8LineStrict();
            String string2 = bufferedSource.readUtf8LineStrict();
            String string3 = bufferedSource.readUtf8LineStrict();
            String string4 = bufferedSource.readUtf8LineStrict();
            String string5 = bufferedSource.readUtf8LineStrict();
            if (!(MAGIC.equals(string) && VERSION_1.equals(string2) && Integer.toString(this.appVersion).equals(string3) && Integer.toString(this.valueCount).equals(string4) && "".equals(string5))) {
                throw new IOException(z[2] + string + z[1] + string2 + z[1] + string4 + z[1] + string5 + "]");
            }
            int n2 = 0;
            try {
                while (true) {
                    this.readJournalLine(bufferedSource.readUtf8LineStrict());
                    ++n2;
                }
            }
            catch (EOFException eOFException) {
                this.redundantOpCount = n2 - this.lruEntries.size();
                if (!bufferedSource.exhausted()) {
                    this.rebuildJournal();
                } else {
                    this.journalWriter = this.newJournalWriter();
                }
                return;
            }
        }
        finally {
            Util.closeQuietly(bufferedSource);
        }
    }

    private BufferedSink newJournalWriter() throws FileNotFoundException {
        Sink sink = this.fileSystem.appendingSink(this.journalFile);
        return Okio.buffer(new FaultHidingSink(sink){

            @Override
            protected void onException(IOException iOException) {
                assert (Thread.holdsLock(DiskLruCache.this));
                DiskLruCache.this.hasJournalErrors = true;
            }
        });
    }

    private void readJournalLine(String stringArray) throws IOException {
        Entry entry;
        String string;
        int n2 = stringArray.indexOf(32);
        if (n2 == -1) {
            throw new IOException(z[7] + (String)stringArray);
        }
        int n3 = n2 + 1;
        int n4 = stringArray.indexOf(32, n3);
        if (n4 == -1) {
            string = stringArray.substring(n3);
            if (n2 == 6 && stringArray.startsWith(REMOVE)) {
                this.lruEntries.remove(string);
                return;
            }
        } else {
            string = stringArray.substring(n3, n4);
        }
        if ((entry = this.lruEntries.get(string)) == null) {
            entry = new Entry(string);
            this.lruEntries.put(string, entry);
        }
        if (n4 != -1 && n2 == 5 && stringArray.startsWith(CLEAN)) {
            stringArray = stringArray.substring(n4 + 1).split(" ");
            entry.readable = true;
            entry.currentEditor = null;
            entry.setLengths(stringArray);
            return;
        }
        if (n4 == -1 && n2 == 5 && stringArray.startsWith(DIRTY)) {
            entry.currentEditor = new Editor(entry);
            return;
        }
        if (n4 != -1 || n2 != 4 || !stringArray.startsWith(READ)) {
            throw new IOException(z[7] + (String)stringArray);
        }
    }

    private void processJournal() throws IOException {
        this.fileSystem.delete(this.journalFileTmp);
        Iterator<Entry> iterator = this.lruEntries.values().iterator();
        while (iterator.hasNext()) {
            int n2;
            Entry entry = iterator.next();
            if (entry.currentEditor == null) {
                for (n2 = 0; n2 < this.valueCount; ++n2) {
                    this.size += entry.lengths[n2];
                }
                continue;
            }
            entry.currentEditor = null;
            for (n2 = 0; n2 < this.valueCount; ++n2) {
                this.fileSystem.delete(entry.cleanFiles[n2]);
                this.fileSystem.delete(entry.dirtyFiles[n2]);
            }
            iterator.remove();
        }
    }

    final synchronized void rebuildJournal() throws IOException {
        if (this.journalWriter != null) {
            this.journalWriter.close();
        }
        try (BufferedSink bufferedSink = Okio.buffer(this.fileSystem.sink(this.journalFileTmp));){
            bufferedSink.writeUtf8(MAGIC).writeByte(10);
            bufferedSink.writeUtf8(VERSION_1).writeByte(10);
            bufferedSink.writeDecimalLong(this.appVersion).writeByte(10);
            bufferedSink.writeDecimalLong(this.valueCount).writeByte(10);
            bufferedSink.writeByte(10);
            for (Entry entry : this.lruEntries.values()) {
                if (entry.currentEditor != null) {
                    bufferedSink.writeUtf8(DIRTY).writeByte(32);
                    bufferedSink.writeUtf8(entry.key);
                    bufferedSink.writeByte(10);
                    continue;
                }
                bufferedSink.writeUtf8(CLEAN).writeByte(32);
                bufferedSink.writeUtf8(entry.key);
                entry.writeLengths(bufferedSink);
                bufferedSink.writeByte(10);
            }
        }
        if (this.fileSystem.exists(this.journalFile)) {
            this.fileSystem.rename(this.journalFile, this.journalFileBackup);
        }
        this.fileSystem.rename(this.journalFileTmp, this.journalFile);
        this.fileSystem.delete(this.journalFileBackup);
        this.journalWriter = this.newJournalWriter();
        this.hasJournalErrors = false;
        this.mostRecentRebuildFailed = false;
    }

    public final synchronized Snapshot get(String string) throws IOException {
        this.initialize();
        this.checkNotClosed();
        this.validateKey(string);
        Object object = this.lruEntries.get(string);
        if (object == null || !((Entry)object).readable) {
            return null;
        }
        if ((object = ((Entry)object).snapshot()) == null) {
            return null;
        }
        ++this.redundantOpCount;
        this.journalWriter.writeUtf8(READ).writeByte(32).writeUtf8(string).writeByte(10);
        if (this.journalRebuildRequired()) {
            this.executor.execute(this.cleanupRunnable);
        }
        return object;
    }

    @Nullable
    public final Editor edit(String string) throws IOException {
        return this.edit(string, -1L);
    }

    final synchronized Editor edit(String object, long l2) throws IOException {
        this.initialize();
        this.checkNotClosed();
        this.validateKey((String)object);
        Entry entry = this.lruEntries.get(object);
        if (l2 != -1L && (entry == null || entry.sequenceNumber != l2)) {
            return null;
        }
        if (entry != null && entry.currentEditor != null) {
            return null;
        }
        if (this.mostRecentTrimFailed || this.mostRecentRebuildFailed) {
            this.executor.execute(this.cleanupRunnable);
            return null;
        }
        this.journalWriter.writeUtf8(DIRTY).writeByte(32).writeUtf8((String)object).writeByte(10);
        this.journalWriter.flush();
        if (this.hasJournalErrors) {
            return null;
        }
        if (entry == null) {
            entry = new Entry((String)object);
            this.lruEntries.put((String)object, entry);
        }
        entry.currentEditor = object = new Editor(entry);
        return object;
    }

    public final File getDirectory() {
        return this.directory;
    }

    public final synchronized long getMaxSize() {
        return this.maxSize;
    }

    public final synchronized void setMaxSize(long l2) {
        this.maxSize = l2;
        if (this.initialized) {
            this.executor.execute(this.cleanupRunnable);
        }
    }

    public final synchronized long size() throws IOException {
        this.initialize();
        return this.size;
    }

    final synchronized void completeEdit(Editor object, boolean bl) throws IOException {
        int n2;
        Entry entry = ((Editor)object).entry;
        if (entry.currentEditor != object) {
            throw new IllegalStateException();
        }
        if (bl && !entry.readable) {
            for (n2 = 0; n2 < this.valueCount; ++n2) {
                if (!((Editor)object).written[n2]) {
                    ((Editor)object).abort();
                    throw new IllegalStateException(z[11] + n2);
                }
                if (this.fileSystem.exists(entry.dirtyFiles[n2])) continue;
                ((Editor)object).abort();
                return;
            }
        }
        for (n2 = 0; n2 < this.valueCount; ++n2) {
            object = entry.dirtyFiles[n2];
            if (bl) {
                long l2;
                if (!this.fileSystem.exists((File)object)) continue;
                File file = entry.cleanFiles[n2];
                this.fileSystem.rename((File)object, file);
                long l3 = entry.lengths[n2];
                entry.lengths[n2] = l2 = this.fileSystem.size(file);
                this.size = this.size - l3 + l2;
                continue;
            }
            this.fileSystem.delete((File)object);
        }
        ++this.redundantOpCount;
        entry.currentEditor = null;
        if (entry.readable | bl) {
            entry.readable = true;
            this.journalWriter.writeUtf8(CLEAN).writeByte(32);
            this.journalWriter.writeUtf8(entry.key);
            entry.writeLengths(this.journalWriter);
            this.journalWriter.writeByte(10);
            if (bl) {
                entry.sequenceNumber = this.nextSequenceNumber++;
            }
        } else {
            this.lruEntries.remove(entry.key);
            this.journalWriter.writeUtf8(REMOVE).writeByte(32);
            this.journalWriter.writeUtf8(entry.key);
            this.journalWriter.writeByte(10);
        }
        this.journalWriter.flush();
        if (this.size > this.maxSize || this.journalRebuildRequired()) {
            this.executor.execute(this.cleanupRunnable);
        }
    }

    final boolean journalRebuildRequired() {
        return this.redundantOpCount >= 2000 && this.redundantOpCount >= this.lruEntries.size();
    }

    public final synchronized boolean remove(String object) throws IOException {
        this.initialize();
        this.checkNotClosed();
        this.validateKey((String)object);
        object = this.lruEntries.get(object);
        if (object == null) {
            return false;
        }
        boolean bl = this.removeEntry((Entry)object);
        if (bl && this.size <= this.maxSize) {
            this.mostRecentTrimFailed = false;
        }
        return bl;
    }

    final boolean removeEntry(Entry entry) throws IOException {
        if (entry.currentEditor != null) {
            entry.currentEditor.detach();
        }
        for (int i2 = 0; i2 < this.valueCount; ++i2) {
            this.fileSystem.delete(entry.cleanFiles[i2]);
            this.size -= entry.lengths[i2];
            entry.lengths[i2] = 0L;
        }
        ++this.redundantOpCount;
        this.journalWriter.writeUtf8(REMOVE).writeByte(32).writeUtf8(entry.key).writeByte(10);
        this.lruEntries.remove(entry.key);
        if (this.journalRebuildRequired()) {
            this.executor.execute(this.cleanupRunnable);
        }
        return true;
    }

    public final synchronized boolean isClosed() {
        return this.closed;
    }

    private synchronized void checkNotClosed() {
        if (this.isClosed()) {
            throw new IllegalStateException(z[0]);
        }
    }

    @Override
    public final synchronized void flush() throws IOException {
        if (!this.initialized) {
            return;
        }
        this.checkNotClosed();
        this.trimToSize();
        this.journalWriter.flush();
    }

    @Override
    public final synchronized void close() throws IOException {
        if (!this.initialized || this.closed) {
            this.closed = true;
            return;
        }
        for (Entry entry : this.lruEntries.values().toArray(new Entry[this.lruEntries.size()])) {
            if (entry.currentEditor == null) continue;
            entry.currentEditor.abort();
        }
        this.trimToSize();
        this.journalWriter.close();
        this.journalWriter = null;
        this.closed = true;
    }

    final void trimToSize() throws IOException {
        while (this.size > this.maxSize) {
            Entry entry = this.lruEntries.values().iterator().next();
            this.removeEntry(entry);
        }
        this.mostRecentTrimFailed = false;
    }

    public final void delete() throws IOException {
        this.close();
        this.fileSystem.deleteContents(this.directory);
    }

    public final synchronized void evictAll() throws IOException {
        this.initialize();
        for (Entry entry : this.lruEntries.values().toArray(new Entry[this.lruEntries.size()])) {
            this.removeEntry(entry);
        }
        this.mostRecentTrimFailed = false;
    }

    private void validateKey(String string) {
        if (!LEGAL_KEY_PATTERN.matcher(string).matches()) {
            throw new IllegalArgumentException(z[3] + string + "\"");
        }
    }

    public final synchronized Iterator<Snapshot> snapshots() throws IOException {
        this.initialize();
        return new Iterator<Snapshot>(){
            final Iterator<Entry> delegate;
            Snapshot nextSnapshot;
            Snapshot removeSnapshot;
            private static final String z;
            {
                this.delegate = new ArrayList<Entry>(DiskLruCache.this.lruEntries.values()).iterator();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasNext() {
                if (this.nextSnapshot != null) {
                    return true;
                }
                DiskLruCache diskLruCache = DiskLruCache.this;
                synchronized (diskLruCache) {
                    if (DiskLruCache.this.closed) {
                        return false;
                    }
                    while (this.delegate.hasNext()) {
                        Snapshot snapshot = this.delegate.next().snapshot();
                        if (snapshot == null) continue;
                        this.nextSnapshot = snapshot;
                        return true;
                    }
                }
                return false;
            }

            @Override
            public Snapshot next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.removeSnapshot = this.nextSnapshot;
                this.nextSnapshot = null;
                return this.removeSnapshot;
            }

            @Override
            public void remove() {
                if (this.removeSnapshot == null) {
                    throw new IllegalStateException(z);
                }
                try {
                    DiskLruCache.this.remove(this.removeSnapshot.key);
                    return;
                }
                catch (IOException iOException) {
                    return;
                }
                finally {
                    this.removeSnapshot = null;
                }
            }

            /*
             * Handled impossible loop by duplicating code
             * Enabled aggressive block sorting
             */
            static {
                char[] cArray;
                block10: {
                    int n2;
                    int n3;
                    char[] cArray2;
                    int n4;
                    block9: {
                        char[] cArray3 = "\u0012cH4+\u0005.\f{?\u0005`J)8@h@#)H/".toCharArray();
                        n4 = 0;
                        int n5 = cArray3.length;
                        cArray2 = cArray3;
                        n3 = n5;
                        if (n5 <= 1) break block9;
                        cArray = cArray2;
                        n2 = n3;
                        if (n3 <= n4) break block10;
                    }
                    do {
                        char[] cArray4 = cArray2;
                        char[] cArray5 = cArray2;
                        int n6 = n4;
                        while (true) {
                            int n7;
                            char c2 = cArray4[n6];
                            switch (n4 % 5) {
                                case 0: {
                                    n7 = 96;
                                    break;
                                }
                                case 1: {
                                    n7 = 6;
                                    break;
                                }
                                case 2: {
                                    n7 = 37;
                                    break;
                                }
                                case 3: {
                                    n7 = 91;
                                    break;
                                }
                                default: {
                                    n7 = 93;
                                }
                            }
                            cArray4[n6] = (char)(c2 ^ n7);
                            ++n4;
                            cArray2 = cArray5;
                            n3 = n3;
                            if (n3 != 0) break;
                            cArray5 = cArray2;
                            n2 = n3;
                            n6 = n3;
                            cArray4 = cArray2;
                        }
                        cArray = cArray2;
                        n2 = n3;
                    } while (n3 > n4);
                }
                z = new String(cArray).intern();
            }
        };
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        block43: {
            int n2;
            int n3;
            char[] cArray2;
            int n4;
            block42: {
                String string;
                String[] stringArray = new String[12];
                String[] stringArray2 = stringArray;
                String[] stringArray3 = stringArray;
                int n5 = 0;
                String string2 = "6b2PO=ai@J,";
                int n6 = 11;
                block33: while (true) {
                    char[] cArray3;
                    block41: {
                        int n7;
                        int n8;
                        char[] cArray4;
                        block40: {
                            char[] cArray5 = string2.toCharArray();
                            n4 = 0;
                            int n9 = cArray5.length;
                            cArray4 = cArray5;
                            n8 = n9;
                            if (n9 <= 1) break block40;
                            cArray3 = cArray4;
                            n7 = n8;
                            if (n8 <= n4) break block41;
                        }
                        do {
                            char[] cArray6 = cArray4;
                            char[] cArray7 = cArray4;
                            int n10 = n4;
                            while (true) {
                                int n11;
                                char c2 = cArray6[n10];
                                switch (n4 % 5) {
                                    case 0: {
                                        n11 = 92;
                                        break;
                                    }
                                    case 1: {
                                        n11 = 13;
                                        break;
                                    }
                                    case 2: {
                                        n11 = 71;
                                        break;
                                    }
                                    case 3: {
                                        n11 = 34;
                                        break;
                                    }
                                    default: {
                                        n11 = 33;
                                    }
                                }
                                cArray6[n10] = (char)(c2 ^ n11);
                                ++n4;
                                cArray4 = cArray7;
                                n8 = n8;
                                if (n8 != 0) break;
                                cArray7 = cArray4;
                                n7 = n8;
                                n10 = n8;
                                cArray6 = cArray4;
                            }
                            cArray3 = cArray4;
                            n7 = n8;
                        } while (n8 > n4);
                    }
                    string = new String(cArray3);
                    switch (n6) {
                        case 11: {
                            JOURNAL_FILE_BACKUP = string.intern();
                            string2 = "\u001fA\u0002co";
                            n6 = 12;
                            continue block33;
                        }
                        case 12: {
                            CLEAN = string.intern();
                            string2 = "\u000eH\nmw\u0019";
                            n6 = 13;
                            continue block33;
                        }
                        case 13: {
                            REMOVE = string.intern();
                            string2 = "\u0018D\u0015vx";
                            n6 = 14;
                            continue block33;
                        }
                        case 14: {
                            DIRTY = string.intern();
                            string2 = "0d%AN.hiKNrI.QJ\u0010\u007f2a@?e\"";
                            n6 = 15;
                            continue block33;
                        }
                        case 15: {
                            MAGIC = string.intern();
                            string2 = "\u000eH\u0006f";
                            n6 = 16;
                            continue block33;
                        }
                        case 16: {
                            READ = string.intern();
                            string2 = "6b2PO=aiVL,";
                            n6 = 17;
                            continue block33;
                        }
                        case 17: {
                            JOURNAL_FILE_TEMP = string.intern();
                            string2 = "6b2PO=a";
                            n6 = 18;
                            continue block33;
                        }
                        case 18: {
                            JOURNAL_FILE = string.intern();
                            string2 = "?l$JD|d4\u0002B0b4GE";
                            n6 = -1;
                            continue block33;
                        }
                        default: {
                            stringArray2[n5] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n5 = 1;
                            string2 = "p-";
                            n6 = 0;
                            continue block33;
                        }
                        case 0: {
                            stringArray2[n5] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n5 = 2;
                            string2 = ")c\"ZQ9n3GE|g(WS2l+\u0002I9l#GSf-\u001c";
                            n6 = 1;
                            continue block33;
                        }
                        case 1: {
                            stringArray2[n5] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n5 = 3;
                            string2 = "7h>Q\u00011x4V\u00011l3AI|\u007f\"ED$-\u001cC\f&=j\u001b~qP<\u0013\rm?w_\u001b|/";
                            n6 = 2;
                            continue block33;
                        }
                        case 2: {
                            stringArray2[n5] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n5 = 4;
                            string2 = "|d4\u0002B3\u007f5WQ(7g";
                            n6 = 3;
                            continue block33;
                        }
                        case 3: {
                            stringArray2[n5] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n5 = 5;
                            string2 = "\u0018d4Im.x\u0004CB4hg";
                            n6 = 4;
                            continue block33;
                        }
                        case 4: {
                            stringArray2[n5] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n5 = 6;
                            string2 = "p-5GL3{.LF";
                            n6 = 5;
                            continue block33;
                        }
                        case 5: {
                            stringArray2[n5] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n5 = 7;
                            string2 = ")c\"ZQ9n3GE|g(WS2l+\u0002M5c\"\u0018\u0001";
                            n6 = 6;
                            continue block33;
                        }
                        case 6: {
                            stringArray2[n5] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n5 = 8;
                            string2 = "\u0013f\u000fVU,-\u0003KR7A5Wb=n/G";
                            n6 = 7;
                            continue block33;
                        }
                        case 7: {
                            stringArray2[n5] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n5 = 9;
                            string2 = "*l+WD\u001fb2LU|1z\u0002\u0011";
                            n6 = 8;
                            continue block33;
                        }
                        case 8: {
                            stringArray2[n5] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n5 = 10;
                            string2 = "1l?qH&hg\u001e\u001c|=";
                            n6 = 9;
                            continue block33;
                        }
                        case 9: {
                            stringArray2[n5] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n5 = 11;
                            string2 = "\u0012h0NX|n5G@(h#\u0002D2y5[\u00018d#L\u0006(-$PD=y\"\u0002W=a2G\u0001:b5\u0002H2i\"Z\u0001";
                            n6 = 10;
                            continue block33;
                        }
                        case 10: 
                    }
                    break;
                }
                stringArray2[n5] = string.intern();
                z = stringArray3;
                char[] cArray8 = "\u0007ljX\u0011q4\u0018\u000f|'<k\u0013\u0013lp".toCharArray();
                n4 = 0;
                int n12 = cArray8.length;
                cArray2 = cArray8;
                n3 = n12;
                if (n12 <= 1) break block42;
                cArray = cArray2;
                n2 = n3;
                if (n3 <= n4) break block43;
            }
            do {
                char[] cArray9 = cArray2;
                char[] cArray10 = cArray2;
                int n13 = n4;
                while (true) {
                    int n14;
                    char c3 = cArray9[n13];
                    switch (n4 % 5) {
                        case 0: {
                            n14 = 92;
                            break;
                        }
                        case 1: {
                            n14 = 13;
                            break;
                        }
                        case 2: {
                            n14 = 71;
                            break;
                        }
                        case 3: {
                            n14 = 34;
                            break;
                        }
                        default: {
                            n14 = 33;
                        }
                    }
                    cArray9[n13] = (char)(c3 ^ n14);
                    ++n4;
                    cArray2 = cArray10;
                    n3 = n3;
                    if (n3 != 0) break;
                    cArray10 = cArray2;
                    n2 = n3;
                    n13 = n3;
                    cArray9 = cArray2;
                }
                cArray = cArray2;
                n2 = n3;
            } while (n3 > n4);
        }
        LEGAL_KEY_PATTERN = Pattern.compile(new String(cArray).intern());
    }

    private final class Entry {
        final String key;
        final long[] lengths;
        final File[] cleanFiles;
        final File[] dirtyFiles;
        boolean readable;
        Editor currentEditor;
        long sequenceNumber;
        private static final String[] z;

        Entry(String charSequence) {
            this.key = charSequence;
            this.lengths = new long[DiskLruCache.this.valueCount];
            this.cleanFiles = new File[DiskLruCache.this.valueCount];
            this.dirtyFiles = new File[DiskLruCache.this.valueCount];
            charSequence = new StringBuilder((String)charSequence).append('.');
            int n2 = ((StringBuilder)charSequence).length();
            for (int i2 = 0; i2 < DiskLruCache.this.valueCount; ++i2) {
                ((StringBuilder)charSequence).append(i2);
                this.cleanFiles[i2] = new File(DiskLruCache.this.directory, ((StringBuilder)charSequence).toString());
                ((StringBuilder)charSequence).append(z[0]);
                this.dirtyFiles[i2] = new File(DiskLruCache.this.directory, ((StringBuilder)charSequence).toString());
                ((StringBuilder)charSequence).setLength(n2);
            }
        }

        final void setLengths(String[] stringArray) throws IOException {
            if (stringArray.length != DiskLruCache.this.valueCount) {
                throw this.invalidLengths(stringArray);
            }
            try {
                for (int i2 = 0; i2 < stringArray.length; ++i2) {
                    this.lengths[i2] = Long.parseLong(stringArray[i2]);
                }
                return;
            }
            catch (NumberFormatException numberFormatException) {
                throw this.invalidLengths(stringArray);
            }
        }

        final void writeLengths(BufferedSink bufferedSink) throws IOException {
            long[] lArray = this.lengths;
            int n2 = this.lengths.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                long l2 = lArray[i2];
                bufferedSink.writeByte(32).writeDecimalLong(l2);
            }
        }

        private IOException invalidLengths(String[] stringArray) throws IOException {
            throw new IOException(z[1] + Arrays.toString(stringArray));
        }

        final Snapshot snapshot() {
            if (!Thread.holdsLock(DiskLruCache.this)) {
                throw new AssertionError();
            }
            Source[] sourceArray = new Source[DiskLruCache.this.valueCount];
            long[] lArray = (long[])this.lengths.clone();
            try {
                for (int i2 = 0; i2 < DiskLruCache.this.valueCount; ++i2) {
                    sourceArray[i2] = DiskLruCache.this.fileSystem.source(this.cleanFiles[i2]);
                }
                return new Snapshot(this.key, this.sequenceNumber, sourceArray, lArray);
            }
            catch (FileNotFoundException fileNotFoundException) {
                for (int i3 = 0; i3 < DiskLruCache.this.valueCount && sourceArray[i3] != null; ++i3) {
                    Util.closeQuietly(sourceArray[i3]);
                }
                try {
                    DiskLruCache.this.removeEntry(this);
                }
                catch (IOException iOException) {}
                return null;
            }
        }

        /*
         * Handled impossible loop by duplicating code
         * Enabled aggressive block sorting
         */
        static {
            String string;
            String[] stringArray = new String[2];
            String[] stringArray2 = stringArray;
            String[] stringArray3 = stringArray;
            int n2 = 0;
            String string2 = "$_Ls";
            int n3 = -1;
            block9: while (true) {
                char[] cArray;
                block14: {
                    int n4;
                    int n5;
                    char[] cArray2;
                    int n6;
                    block13: {
                        char[] cArray3 = string2.toCharArray();
                        n6 = 0;
                        int n7 = cArray3.length;
                        cArray2 = cArray3;
                        n5 = n7;
                        if (n7 <= 1) break block13;
                        cArray = cArray2;
                        n4 = n5;
                        if (n5 <= n6) break block14;
                    }
                    do {
                        char[] cArray4 = cArray2;
                        char[] cArray5 = cArray2;
                        int n8 = n6;
                        while (true) {
                            int n9;
                            char c2 = cArray4[n8];
                            switch (n6 % 5) {
                                case 0: {
                                    n9 = 10;
                                    break;
                                }
                                case 1: {
                                    n9 = 43;
                                    break;
                                }
                                case 2: {
                                    n9 = 33;
                                    break;
                                }
                                case 3: {
                                    n9 = 3;
                                    break;
                                }
                                default: {
                                    n9 = 73;
                                }
                            }
                            cArray4[n8] = (char)(c2 ^ n9);
                            ++n6;
                            cArray2 = cArray5;
                            n5 = n5;
                            if (n5 != 0) break;
                            cArray5 = cArray2;
                            n4 = n5;
                            n8 = n5;
                            cArray4 = cArray2;
                        }
                        cArray = cArray2;
                        n4 = n5;
                    } while (n5 > n6);
                }
                string = new String(cArray);
                switch (n3) {
                    default: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 1;
                        string2 = "\u007fED{9oHUf-*ANv;dJM#%cED9i";
                        n3 = 0;
                        continue block9;
                    }
                    case 0: 
                }
                break;
            }
            stringArray2[n2] = string.intern();
            z = stringArray3;
        }
    }

    public final class Editor {
        final Entry entry;
        final boolean[] written;
        private boolean done;

        Editor(Entry entry) {
            this.entry = entry;
            this.written = entry.readable ? null : new boolean[DiskLruCache.this.valueCount];
        }

        final void detach() {
            if (this.entry.currentEditor == this) {
                for (int i2 = 0; i2 < DiskLruCache.this.valueCount; ++i2) {
                    try {
                        DiskLruCache.this.fileSystem.delete(this.entry.dirtyFiles[i2]);
                        continue;
                    }
                    catch (IOException iOException) {}
                }
                this.entry.currentEditor = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final Source newSource(int n2) {
            DiskLruCache diskLruCache = DiskLruCache.this;
            synchronized (diskLruCache) {
                if (this.done) {
                    throw new IllegalStateException();
                }
                if (!this.entry.readable || this.entry.currentEditor != this) {
                    return null;
                }
                try {
                    return DiskLruCache.this.fileSystem.source(this.entry.cleanFiles[n2]);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    return null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final Sink newSink(int n2) {
            DiskLruCache diskLruCache = DiskLruCache.this;
            synchronized (diskLruCache) {
                if (this.done) {
                    throw new IllegalStateException();
                }
                if (this.entry.currentEditor != this) {
                    return Okio.blackhole();
                }
                if (!this.entry.readable) {
                    this.written[n2] = true;
                }
                Object object = this.entry.dirtyFiles[n2];
                try {
                    object = DiskLruCache.this.fileSystem.sink((File)object);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    return Okio.blackhole();
                }
                return new FaultHidingSink((Sink)object){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    protected void onException(IOException object) {
                        object = DiskLruCache.this;
                        synchronized (object) {
                            Editor.this.detach();
                            return;
                        }
                    }
                };
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void commit() throws IOException {
            DiskLruCache diskLruCache = DiskLruCache.this;
            synchronized (diskLruCache) {
                if (this.done) {
                    throw new IllegalStateException();
                }
                if (this.entry.currentEditor == this) {
                    DiskLruCache.this.completeEdit(this, true);
                }
                this.done = true;
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void abort() throws IOException {
            DiskLruCache diskLruCache = DiskLruCache.this;
            synchronized (diskLruCache) {
                if (this.done) {
                    throw new IllegalStateException();
                }
                if (this.entry.currentEditor == this) {
                    DiskLruCache.this.completeEdit(this, false);
                }
                this.done = true;
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void abortUnlessCommitted() {
            DiskLruCache diskLruCache = DiskLruCache.this;
            synchronized (diskLruCache) {
                if (!this.done && this.entry.currentEditor == this) {
                    try {
                        DiskLruCache.this.completeEdit(this, false);
                    }
                    catch (IOException iOException) {}
                }
                return;
            }
        }
    }

    public final class Snapshot
    implements Closeable {
        private final String key;
        private final long sequenceNumber;
        private final Source[] sources;
        private final long[] lengths;

        Snapshot(String string, long l2, Source[] sourceArray, long[] lArray) {
            this.key = string;
            this.sequenceNumber = l2;
            this.sources = sourceArray;
            this.lengths = lArray;
        }

        public final String key() {
            return this.key;
        }

        @Nullable
        public final Editor edit() throws IOException {
            return DiskLruCache.this.edit(this.key, this.sequenceNumber);
        }

        public final Source getSource(int n2) {
            return this.sources[n2];
        }

        public final long getLength(int n2) {
            return this.lengths[n2];
        }

        @Override
        public final void close() {
            Source[] sourceArray = this.sources;
            int n2 = this.sources.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Util.closeQuietly(sourceArray[i2]);
            }
        }
    }
}

