/*
 * Decompiled with CFR 0.152.
 */
package cn.jmessage.support.okhttp3.internal.connection;

import cn.jmessage.support.okhttp3.ConnectionSpec;
import cn.jmessage.support.okhttp3.internal.Internal;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ProtocolException;
import java.net.UnknownServiceException;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLProtocolException;
import javax.net.ssl.SSLSocket;

public final class ConnectionSpecSelector {
    private final List<ConnectionSpec> connectionSpecs;
    private int nextModeIndex = 0;
    private boolean isFallbackPossible;
    private boolean isFallback;
    private static final String[] z;

    public ConnectionSpecSelector(List<ConnectionSpec> list) {
        this.connectionSpecs = list;
    }

    public final ConnectionSpec configureSecureSocket(SSLSocket sSLSocket) throws IOException {
        ConnectionSpec connectionSpec = null;
        int n2 = this.connectionSpecs.size();
        for (int i2 = this.nextModeIndex; i2 < n2; ++i2) {
            ConnectionSpec connectionSpec2 = this.connectionSpecs.get(i2);
            if (!connectionSpec2.isCompatible(sSLSocket)) continue;
            connectionSpec = connectionSpec2;
            this.nextModeIndex = i2 + 1;
            break;
        }
        if (connectionSpec == null) {
            throw new UnknownServiceException(z[2] + this.isFallback + z[0] + this.connectionSpecs + z[1] + Arrays.toString(sSLSocket.getEnabledProtocols()));
        }
        this.isFallbackPossible = this.isFallbackPossible(sSLSocket);
        Internal.instance.apply(connectionSpec, sSLSocket, this.isFallback);
        return connectionSpec;
    }

    public final boolean connectionFailed(IOException iOException) {
        this.isFallback = true;
        if (!this.isFallbackPossible) {
            return false;
        }
        if (iOException instanceof ProtocolException) {
            return false;
        }
        if (iOException instanceof InterruptedIOException) {
            return false;
        }
        if (iOException instanceof SSLHandshakeException && iOException.getCause() instanceof CertificateException) {
            return false;
        }
        if (iOException instanceof SSLPeerUnverifiedException) {
            return false;
        }
        return iOException instanceof SSLHandshakeException || iOException instanceof SSLProtocolException;
    }

    private boolean isFallbackPossible(SSLSocket sSLSocket) {
        for (int i2 = this.nextModeIndex; i2 < this.connectionSpecs.size(); ++i2) {
            if (!this.connectionSpecs.get(i2).isCompatible(sSLSocket)) continue;
            return true;
        }
        return false;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[3];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "Wt\u0010\u001f\u0013\u001e'@";
        int n3 = -1;
        block10: while (true) {
            char[] cArray;
            block15: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block14: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block14;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block15;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 123;
                                break;
                            }
                            case 1: {
                                n9 = 84;
                                break;
                            }
                            case 2: {
                                n9 = 125;
                                break;
                            }
                            case 3: {
                                n9 = 112;
                                break;
                            }
                            default: {
                                n9 = 119;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "Wt\u000e\u0005\u0007\u000b;\u000f\u0004\u0012\u001ft\r\u0002\u0018\u000f;\u001e\u001f\u001b\bi";
                    n3 = 0;
                    continue block10;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = ".:\u001c\u0012\u001b\u001et\t\u001fW\u001d=\u0013\u0014W\u001a7\u001e\u0015\u0007\u000f5\u001f\u001c\u0012[$\u000f\u001f\u0003\u00147\u0012\u001c\u0004Ut\u0014\u00031\u001a8\u0011\u0012\u0016\u0018?@";
                    n3 = 1;
                    continue block10;
                }
                case 1: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

