/*
 * Decompiled with CFR 0.152.
 */
package cn.jmessage.support.okhttp3.internal.connection;

import cn.jmessage.support.annotation.Nullable;
import cn.jmessage.support.okhttp3.Address;
import cn.jmessage.support.okhttp3.Call;
import cn.jmessage.support.okhttp3.CertificatePinner;
import cn.jmessage.support.okhttp3.Connection;
import cn.jmessage.support.okhttp3.ConnectionPool;
import cn.jmessage.support.okhttp3.ConnectionSpec;
import cn.jmessage.support.okhttp3.EventListener;
import cn.jmessage.support.okhttp3.Handshake;
import cn.jmessage.support.okhttp3.HttpUrl;
import cn.jmessage.support.okhttp3.Interceptor;
import cn.jmessage.support.okhttp3.OkHttpClient;
import cn.jmessage.support.okhttp3.Protocol;
import cn.jmessage.support.okhttp3.Request;
import cn.jmessage.support.okhttp3.Response;
import cn.jmessage.support.okhttp3.Route;
import cn.jmessage.support.okhttp3.internal.Internal;
import cn.jmessage.support.okhttp3.internal.Util;
import cn.jmessage.support.okhttp3.internal.Version;
import cn.jmessage.support.okhttp3.internal.connection.ConnectionSpecSelector;
import cn.jmessage.support.okhttp3.internal.connection.RouteException;
import cn.jmessage.support.okhttp3.internal.connection.StreamAllocation;
import cn.jmessage.support.okhttp3.internal.http.HttpCodec;
import cn.jmessage.support.okhttp3.internal.http.HttpHeaders;
import cn.jmessage.support.okhttp3.internal.http1.Http1Codec;
import cn.jmessage.support.okhttp3.internal.http2.ErrorCode;
import cn.jmessage.support.okhttp3.internal.http2.Http2Codec;
import cn.jmessage.support.okhttp3.internal.http2.Http2Connection;
import cn.jmessage.support.okhttp3.internal.http2.Http2Stream;
import cn.jmessage.support.okhttp3.internal.platform.Platform;
import cn.jmessage.support.okhttp3.internal.tls.OkHostnameVerifier;
import cn.jmessage.support.okhttp3.internal.ws.RealWebSocket;
import cn.jmessage.support.okio.BufferedSink;
import cn.jmessage.support.okio.BufferedSource;
import cn.jmessage.support.okio.Okio;
import cn.jmessage.support.okio.Source;
import java.io.IOException;
import java.lang.ref.Reference;
import java.net.ConnectException;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownServiceException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public final class RealConnection
extends Http2Connection.Listener
implements Connection {
    private static final String NPE_THROW_WITH_NULL;
    private static final int MAX_TUNNEL_ATTEMPTS = 21;
    private final ConnectionPool connectionPool;
    private final Route route;
    private Socket rawSocket;
    private Socket socket;
    private Handshake handshake;
    private Protocol protocol;
    private Http2Connection http2Connection;
    private BufferedSource source;
    private BufferedSink sink;
    public boolean noNewStreams;
    public int successCount;
    public int allocationLimit = 1;
    public final List<Reference<StreamAllocation>> allocations = new ArrayList<Reference<StreamAllocation>>();
    public long idleAtNanos = Long.MAX_VALUE;
    private static final String[] z;

    public RealConnection(ConnectionPool connectionPool, Route route) {
        this.connectionPool = connectionPool;
        this.route = route;
    }

    public static RealConnection testConnection(ConnectionPool object, Route route, Socket socket, long l2) {
        object = new RealConnection((ConnectionPool)object, route);
        v0.socket = socket;
        ((RealConnection)object).idleAtNanos = l2;
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void connect(int n2, int n3, int n4, int n5, boolean bl, Call call, EventListener eventListener) {
        if (this.protocol != null) {
            throw new IllegalStateException(z[25]);
        }
        RouteException routeException = null;
        Object object = this.route.address().connectionSpecs();
        ConnectionSpecSelector connectionSpecSelector = new ConnectionSpecSelector((List<ConnectionSpec>)object);
        if (this.route.address().sslSocketFactory() == null) {
            if (!object.contains(ConnectionSpec.CLEARTEXT)) {
                throw new RouteException(new UnknownServiceException(z[27]));
            }
            object = this.route.address().url().host();
            if (!Platform.get().isCleartextTrafficPermitted((String)object)) {
                throw new RouteException(new UnknownServiceException(z[24] + (String)object + z[26]));
            }
        } else if (this.route.address().protocols().contains((Object)Protocol.H2_PRIOR_KNOWLEDGE)) {
            throw new RouteException(new UnknownServiceException(z[22]));
        }
        while (true) {
            try {
                if (this.route.requiresTunnel()) {
                    this.connectTunnel(n2, n3, n4, call, eventListener);
                    if (this.rawSocket == null) {
                        break;
                    }
                } else {
                    this.connectSocket(n2, n3, call, eventListener);
                }
                this.establishProtocol(connectionSpecSelector, n5, call, eventListener);
                eventListener.connectEnd(call, this.route.socketAddress(), this.route.proxy(), this.protocol);
            }
            catch (IOException iOException) {
                Util.closeQuietly(this.socket);
                Util.closeQuietly(this.rawSocket);
                this.socket = null;
                this.rawSocket = null;
                this.source = null;
                this.sink = null;
                this.handshake = null;
                this.protocol = null;
                this.http2Connection = null;
                eventListener.connectFailed(call, this.route.socketAddress(), this.route.proxy(), null, iOException);
                if (routeException == null) {
                    routeException = new RouteException(iOException);
                    continue;
                }
                routeException.addConnectException(iOException);
                if (bl && connectionSpecSelector.connectionFailed(iOException)) continue;
                throw routeException;
            }
            break;
        }
        if (this.route.requiresTunnel() && this.rawSocket == null) {
            object = new ProtocolException(z[23]);
            throw new RouteException((IOException)object);
        }
        if (this.http2Connection != null) {
            object = this.connectionPool;
            synchronized (object) {
                this.allocationLimit = this.http2Connection.maxConcurrentStreams();
                return;
            }
        }
    }

    private void connectTunnel(int n2, int n3, int n4, Call call, EventListener eventListener) throws IOException {
        Request request = this.createTunnelRequest();
        HttpUrl httpUrl = request.url();
        for (int i2 = 0; i2 < 21; ++i2) {
            this.connectSocket(n2, n3, call, eventListener);
            request = this.createTunnel(n3, n4, request, httpUrl);
            if (request == null) break;
            Util.closeQuietly(this.rawSocket);
            this.rawSocket = null;
            this.sink = null;
            this.source = null;
            eventListener.connectEnd(call, this.route.socketAddress(), this.route.proxy(), null);
        }
    }

    private void connectSocket(int n2, int n3, Call call, EventListener eventListener) throws IOException {
        Proxy proxy = this.route.proxy();
        Address address = this.route.address();
        this.rawSocket = proxy.type() == Proxy.Type.DIRECT || proxy.type() == Proxy.Type.HTTP ? address.socketFactory().createSocket() : new Socket(proxy);
        eventListener.connectStart(call, this.route.socketAddress(), proxy);
        this.rawSocket.setSoTimeout(n3);
        try {
            Platform.get().connectSocket(this.rawSocket, this.route.socketAddress(), n2);
        }
        catch (ConnectException connectException) {
            ConnectException connectException2 = new ConnectException(z[10] + this.route.socketAddress());
            connectException2.initCause(connectException);
            throw connectException2;
        }
        try {
            this.source = Okio.buffer(Okio.source(this.rawSocket));
            this.sink = Okio.buffer(Okio.sink(this.rawSocket));
            return;
        }
        catch (NullPointerException nullPointerException) {
            if (NPE_THROW_WITH_NULL.equals(nullPointerException.getMessage())) {
                throw new IOException(nullPointerException);
            }
            return;
        }
    }

    private void establishProtocol(ConnectionSpecSelector connectionSpecSelector, int n2, Call call, EventListener eventListener) throws IOException {
        if (this.route.address().sslSocketFactory() == null) {
            if (this.route.address().protocols().contains((Object)Protocol.H2_PRIOR_KNOWLEDGE)) {
                this.socket = this.rawSocket;
                this.protocol = Protocol.H2_PRIOR_KNOWLEDGE;
                this.startHttp2(n2);
                return;
            }
            this.socket = this.rawSocket;
            this.protocol = Protocol.HTTP_1_1;
            return;
        }
        eventListener.secureConnectStart(call);
        this.connectTls(connectionSpecSelector);
        eventListener.secureConnectEnd(call, this.handshake);
        if (this.protocol == Protocol.HTTP_2) {
            this.startHttp2(n2);
        }
    }

    private void startHttp2(int n2) throws IOException {
        this.socket.setSoTimeout(0);
        this.http2Connection = new Http2Connection.Builder(true).socket(this.socket, this.route.address().url().host(), this.source, this.sink).listener(this).pingIntervalMillis(n2).build();
        this.http2Connection.start();
    }

    private void connectTls(ConnectionSpecSelector object) throws IOException {
        Address address = this.route.address();
        Object object2 = address.sslSocketFactory();
        SSLSocket sSLSocket = null;
        try {
            sSLSocket = (SSLSocket)((SSLSocketFactory)object2).createSocket(this.rawSocket, address.url().host(), address.url().port(), true);
            object = ((ConnectionSpecSelector)object).configureSecureSocket(sSLSocket);
            if (((ConnectionSpec)object).supportsTlsExtensions()) {
                Platform.get().configureTlsExtensions(sSLSocket, address.url().host(), address.protocols());
            }
            sSLSocket.startHandshake();
            object2 = sSLSocket.getSession();
            Handshake handshake = Handshake.get((SSLSession)object2);
            if (!address.hostnameVerifier().verify(address.url().host(), (SSLSession)object2)) {
                object = (X509Certificate)handshake.peerCertificates().get(0);
                throw new SSLPeerUnverifiedException(z[8] + address.url().host() + z[9] + CertificatePinner.pin((Certificate)object) + z[7] + ((X509Certificate)object).getSubjectDN().getName() + z[6] + OkHostnameVerifier.allSubjectAltNames((X509Certificate)object));
            }
            address.certificatePinner().check(address.url().host(), handshake.peerCertificates());
            object = ((ConnectionSpec)object).supportsTlsExtensions() ? Platform.get().getSelectedProtocol(sSLSocket) : null;
            this.socket = sSLSocket;
            this.source = Okio.buffer(Okio.source(this.socket));
            this.sink = Okio.buffer(Okio.sink(this.socket));
            this.handshake = handshake;
            Protocol protocol = this.protocol = object != null ? Protocol.get((String)object) : Protocol.HTTP_1_1;
            if (sSLSocket != null) {
                Platform.get().afterHandshake(sSLSocket);
            }
            return;
        }
        catch (AssertionError assertionError) {
            try {
                object = assertionError;
                if (Util.isAndroidGetsocknameError(assertionError)) {
                    throw new IOException((Throwable)object);
                }
                throw object;
            }
            catch (Throwable throwable) {
                if (sSLSocket != null) {
                    Platform.get().afterHandshake(sSLSocket);
                }
                Util.closeQuietly(sSLSocket);
                throw throwable;
            }
        }
    }

    private Request createTunnel(int n2, int n3, Request object, HttpUrl object2) throws IOException {
        Response response;
        object2 = z[20] + Util.hostHeader((HttpUrl)object2, true) + z[21];
        block4: while (true) {
            Http1Codec http1Codec = new Http1Codec(null, null, this.source, this.sink);
            this.source.timeout().timeout(n2, TimeUnit.MILLISECONDS);
            this.sink.timeout().timeout(n3, TimeUnit.MILLISECONDS);
            http1Codec.writeRequest(((Request)object).headers(), (String)object2);
            http1Codec.finishRequest();
            response = http1Codec.readResponseHeaders(false).request((Request)object).build();
            long l2 = HttpHeaders.contentLength(response);
            if (l2 == -1L) {
                l2 = 0L;
            }
            object = http1Codec.newFixedLengthSource(l2);
            Util.skipAll((Source)object, Integer.MAX_VALUE, TimeUnit.MILLISECONDS);
            object.close();
            switch (response.code()) {
                case 200: {
                    if (!this.source.buffer().exhausted() || !this.sink.buffer().exhausted()) {
                        throw new IOException(z[16]);
                    }
                    return null;
                }
                case 407: {
                    object = this.route.address().proxyAuthenticator().authenticate(this.route, response);
                    if (object != null) continue block4;
                    throw new IOException(z[19]);
                    if (!z[15].equalsIgnoreCase(response.header(z[18]))) continue block4;
                    return object;
                }
            }
            break;
        }
        throw new IOException(z[17] + response.code());
    }

    private Request createTunnelRequest() {
        return new Request.Builder().url(this.route.address().url()).header(z[14], Util.hostHeader(this.route.address().url(), true)).header(z[12], z[11]).header(z[13], Version.userAgent()).build();
    }

    public final boolean isEligible(Address address, @Nullable Route route) {
        if (this.allocations.size() >= this.allocationLimit || this.noNewStreams) {
            return false;
        }
        if (!Internal.instance.equalsNonHost(this.route.address(), address)) {
            return false;
        }
        if (address.url().host().equals(this.route().address().url().host())) {
            return true;
        }
        if (this.http2Connection == null) {
            return false;
        }
        if (route == null) {
            return false;
        }
        if (route.proxy().type() != Proxy.Type.DIRECT) {
            return false;
        }
        if (this.route.proxy().type() != Proxy.Type.DIRECT) {
            return false;
        }
        if (!this.route.socketAddress().equals(route.socketAddress())) {
            return false;
        }
        if (route.address().hostnameVerifier() != OkHostnameVerifier.INSTANCE) {
            return false;
        }
        if (!this.supportsUrl(address.url())) {
            return false;
        }
        try {
            address.certificatePinner().check(address.url().host(), this.handshake().peerCertificates());
        }
        catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
            return false;
        }
        return true;
    }

    public final boolean supportsUrl(HttpUrl httpUrl) {
        if (httpUrl.port() != this.route.address().url().port()) {
            return false;
        }
        if (!httpUrl.host().equals(this.route.address().url().host())) {
            return this.handshake != null && OkHostnameVerifier.INSTANCE.verify(httpUrl.host(), (X509Certificate)this.handshake.peerCertificates().get(0));
        }
        return true;
    }

    public final HttpCodec newCodec(OkHttpClient okHttpClient, Interceptor.Chain chain, StreamAllocation streamAllocation) throws SocketException {
        if (this.http2Connection != null) {
            return new Http2Codec(okHttpClient, chain, streamAllocation, this.http2Connection);
        }
        this.socket.setSoTimeout(chain.readTimeoutMillis());
        this.source.timeout().timeout(chain.readTimeoutMillis(), TimeUnit.MILLISECONDS);
        this.sink.timeout().timeout(chain.writeTimeoutMillis(), TimeUnit.MILLISECONDS);
        return new Http1Codec(okHttpClient, streamAllocation, this.source, this.sink);
    }

    public final RealWebSocket.Streams newWebSocketStreams(final StreamAllocation streamAllocation) {
        return new RealWebSocket.Streams(true, this.source, this.sink){

            @Override
            public void close() throws IOException {
                streamAllocation.streamFinished(true, streamAllocation.codec(), -1L, null);
            }
        };
    }

    @Override
    public final Route route() {
        return this.route;
    }

    public final void cancel() {
        Util.closeQuietly(this.rawSocket);
    }

    @Override
    public final Socket socket() {
        return this.socket;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean isHealthy(boolean bl) {
        if (this.socket.isClosed()) return false;
        if (this.socket.isInputShutdown()) return false;
        if (this.socket.isOutputShutdown()) {
            return false;
        }
        if (this.http2Connection != null) {
            if (this.http2Connection.isShutdown()) return false;
            return true;
        }
        if (!bl) return true;
        try {
            int n2 = this.socket.getSoTimeout();
            try {
                this.socket.setSoTimeout(1);
                if (!this.source.exhausted()) return true;
                return false;
            }
            finally {
                this.socket.setSoTimeout(n2);
            }
        }
        catch (SocketTimeoutException socketTimeoutException) {
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    @Override
    public final void onStream(Http2Stream http2Stream) throws IOException {
        http2Stream.close(ErrorCode.REFUSED_STREAM);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void onSettings(Http2Connection http2Connection) {
        ConnectionPool connectionPool = this.connectionPool;
        synchronized (connectionPool) {
            this.allocationLimit = http2Connection.maxConcurrentStreams();
            return;
        }
    }

    @Override
    public final Handshake handshake() {
        return this.handshake;
    }

    public final boolean isMultiplexed() {
        return this.http2Connection != null;
    }

    @Override
    public final Protocol protocol() {
        return this.protocol;
    }

    public final String toString() {
        return z[4] + this.route.address().url().host() + ":" + this.route.address().url().port() + z[5] + this.route.proxy() + z[1] + this.route.socketAddress() + z[0] + (this.handshake != null ? this.handshake.cipherSuite() : z[3]) + z[2] + (Object)((Object)this.protocol) + '}';
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[28];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "(\u0003\u000e:2|\u001c\u0015!-|\u0005\t9)|\u000e\u00046 ,\u001f\u0015:+";
        int n3 = 27;
        block36: while (true) {
            char[] cArray;
            block41: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block40: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block40;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block41;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 92;
                                break;
                            }
                            case 1: {
                                n9 = 107;
                                break;
                            }
                            case 2: {
                                n9 = 124;
                                break;
                            }
                            case 3: {
                                n9 = 85;
                                break;
                            }
                            default: {
                                n9 = 69;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                case 27: {
                    NPE_THROW_WITH_NULL = string.intern();
                    string2 = "|\b\u0015%-9\u0019/ ,(\u000eA";
                    n3 = -1;
                    continue block36;
                }
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "|\u0003\u0013&1\u001d\u000f\u0018' /\u0018A";
                    n3 = 0;
                    continue block36;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "|\u001b\u000e:13\b\u00139x";
                    n3 = 1;
                    continue block36;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "2\u0004\u00120";
                    n3 = 2;
                    continue block36;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "\u001f\u0004\u0012; ?\u001f\u0015:+'";
                    n3 = 3;
                    continue block36;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "pK\f'*$\u0012A";
                    n3 = 4;
                    continue block36;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "VK\\ue/\u001e\u001e? ?\u001f=91\u0012\n\u001106fK";
                    n3 = 5;
                    continue block36;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "VK\\ue\u0018%Fu";
                    n3 = 6;
                    continue block36;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = "\u0014\u0004\u000f!+=\u0006\u0019u";
                    n3 = 7;
                    continue block36;
                }
                case 7: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 9;
                    string2 = "|\u0005\u0013!e*\u000e\u000e<#5\u000e\u0018oO|K\\u&9\u0019\b<#5\b\u001d! fK";
                    n3 = 8;
                    continue block36;
                }
                case 8: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 10;
                    string2 = "\u001a\n\u00159 8K\b:e?\u0004\u0012; ?\u001f\\!*|";
                    n3 = 9;
                    continue block36;
                }
                case 9: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 11;
                    string2 = "\u0017\u000e\u0019%h\u001d\u0007\u0015# ";
                    n3 = 10;
                    continue block36;
                }
                case 10: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 12;
                    string2 = "\f\u0019\u0013-<q(\u0013;+9\b\b<*2";
                    n3 = 11;
                    continue block36;
                }
                case 11: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 13;
                    string2 = "\t\u0018\u0019'h\u001d\f\u0019;1";
                    n3 = 12;
                    continue block36;
                }
                case 12: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 14;
                    string2 = "\u0014\u0004\u000f!";
                    n3 = 13;
                    continue block36;
                }
                case 13: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 15;
                    string2 = "?\u0007\u0013& ";
                    n3 = 14;
                    continue block36;
                }
                case 14: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 16;
                    string2 = "\b'/u1)\u0005\u00120)|\t\t3#9\u0019\u00191e(\u0004\u0013u(=\u0005\u0005u'%\u001f\u0019&d";
                    n3 = 15;
                    continue block36;
                }
                case 15: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 17;
                    string2 = "\t\u0005\u0019-59\b\b0!|\u0019\u0019&53\u0005\u000f0e?\u0004\u00180e:\u0004\u000eu\u0006\u0013%2\u0010\u0006\bQ\\";
                    n3 = 16;
                    continue block36;
                }
                case 16: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 18;
                    string2 = "\u001f\u0004\u0012; ?\u001f\u0015:+";
                    n3 = 17;
                    continue block36;
                }
                case 17: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 19;
                    string2 = "\u001a\n\u00159 8K\b:e=\u001e\b= 2\u001f\u00156$(\u000e\\\",(\u0003\\%73\u0013\u0005";
                    n3 = 18;
                    continue block36;
                }
                case 18: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 20;
                    string2 = "\u001f$2\u001b\u0000\u001f?\\";
                    n3 = 19;
                    continue block36;
                }
                case 19: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 21;
                    string2 = "|#(\u0001\u0015sZRd";
                    n3 = 20;
                    continue block36;
                }
                case 20: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 22;
                    string2 = "\u0014Y#\u0005\u0017\u0015$.\n\u000e\u0012$+\u0019\u0000\u0018,9u&=\u0005\u0012:1|\t\u0019u0/\u000e\u0018u25\u001f\u0014u\r\b?,\u0006";
                    n3 = 21;
                    continue block36;
                }
                case 21: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 23;
                    string2 = "\b\u0004\u0013u(=\u0005\u0005u1)\u0005\u00120)|\b\u0013;+9\b\b<*2\u0018\\41(\u000e\u0011%19\u000fFuwm";
                    n3 = 22;
                    continue block36;
                }
                case 22: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 24;
                    string2 = "\u001f'9\u0014\u0017\b.$\u0001e?\u0004\u0011802\u0002\u001f415\u0004\u0012u13K";
                    n3 = 23;
                    continue block36;
                }
                case 23: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 25;
                    string2 = "=\u0007\u000e0$8\u0012\\6*2\u0005\u0019619\u000f";
                    n3 = 24;
                    continue block36;
                }
                case 24: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 26;
                    string2 = "|\u0005\u0013!e,\u000e\u000e8,(\u001f\u00191e>\u0012\\; (\u001c\u0013'.|\u0018\u001960.\u0002\b,e,\u0004\u0010<&%";
                    n3 = 25;
                    continue block36;
                }
                case 25: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 27;
                    string2 = "\u001f'9\u0014\u0017\b.$\u0001e?\u0004\u0011802\u0002\u001f415\u0004\u0012u+3\u001f\\0+=\t\u00100!|\r\u0013'e?\u0007\u00150+(";
                    n3 = 26;
                    continue block36;
                }
                case 26: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

