/*
 * Decompiled with CFR 0.152.
 */
package cn.jmessage.support.okhttp3.internal.http1;

import cn.jmessage.support.okhttp3.Headers;
import cn.jmessage.support.okhttp3.HttpUrl;
import cn.jmessage.support.okhttp3.OkHttpClient;
import cn.jmessage.support.okhttp3.Request;
import cn.jmessage.support.okhttp3.Response;
import cn.jmessage.support.okhttp3.ResponseBody;
import cn.jmessage.support.okhttp3.internal.Internal;
import cn.jmessage.support.okhttp3.internal.Util;
import cn.jmessage.support.okhttp3.internal.connection.RealConnection;
import cn.jmessage.support.okhttp3.internal.connection.StreamAllocation;
import cn.jmessage.support.okhttp3.internal.http.HttpCodec;
import cn.jmessage.support.okhttp3.internal.http.HttpHeaders;
import cn.jmessage.support.okhttp3.internal.http.RealResponseBody;
import cn.jmessage.support.okhttp3.internal.http.RequestLine;
import cn.jmessage.support.okhttp3.internal.http.StatusLine;
import cn.jmessage.support.okio.Buffer;
import cn.jmessage.support.okio.BufferedSink;
import cn.jmessage.support.okio.BufferedSource;
import cn.jmessage.support.okio.ForwardingTimeout;
import cn.jmessage.support.okio.Okio;
import cn.jmessage.support.okio.Sink;
import cn.jmessage.support.okio.Source;
import cn.jmessage.support.okio.Timeout;
import java.io.EOFException;
import java.io.IOException;
import java.net.ProtocolException;
import java.util.concurrent.TimeUnit;

public final class Http1Codec
implements HttpCodec {
    private static final int STATE_IDLE = 0;
    private static final int STATE_OPEN_REQUEST_BODY = 1;
    private static final int STATE_WRITING_REQUEST_BODY = 2;
    private static final int STATE_READ_RESPONSE_HEADERS = 3;
    private static final int STATE_OPEN_RESPONSE_BODY = 4;
    private static final int STATE_READING_RESPONSE_BODY = 5;
    private static final int STATE_CLOSED = 6;
    private static final int HEADER_LIMIT = 262144;
    final OkHttpClient client;
    final StreamAllocation streamAllocation;
    final BufferedSource source;
    final BufferedSink sink;
    int state = 0;
    private long headerLimit = 262144L;
    private static final String[] z;

    public Http1Codec(OkHttpClient okHttpClient, StreamAllocation streamAllocation, BufferedSource bufferedSource, BufferedSink bufferedSink) {
        this.client = okHttpClient;
        this.streamAllocation = streamAllocation;
        this.source = bufferedSource;
        this.sink = bufferedSink;
    }

    @Override
    public final Sink createRequestBody(Request request, long l2) {
        if (z[4].equalsIgnoreCase(request.header(z[3]))) {
            return this.newChunkedSink();
        }
        if (l2 != -1L) {
            return this.newFixedLengthSink(l2);
        }
        throw new IllegalStateException(z[5]);
    }

    @Override
    public final void cancel() {
        RealConnection realConnection = this.streamAllocation.connection();
        if (realConnection != null) {
            realConnection.cancel();
        }
    }

    @Override
    public final void writeRequestHeaders(Request request) throws IOException {
        String string = RequestLine.get(request, this.streamAllocation.connection().route().proxy().type());
        this.writeRequest(request.headers(), string);
    }

    @Override
    public final ResponseBody openResponseBody(Response closeable) throws IOException {
        this.streamAllocation.eventListener.responseBodyStart(this.streamAllocation.call);
        String string = closeable.header(z[6]);
        if (!HttpHeaders.hasBody(closeable)) {
            Source source = this.newFixedLengthSource(0L);
            return new RealResponseBody(string, 0L, Okio.buffer(source));
        }
        if (z[4].equalsIgnoreCase(closeable.header(z[3]))) {
            Source source = this.newChunkedSource(closeable.request().url());
            return new RealResponseBody(string, -1L, Okio.buffer(source));
        }
        long l2 = HttpHeaders.contentLength(closeable);
        if (l2 != -1L) {
            closeable = this.newFixedLengthSource(l2);
            return new RealResponseBody(string, l2, Okio.buffer((Source)closeable));
        }
        return new RealResponseBody(string, -1L, Okio.buffer(this.newUnknownLengthSource()));
    }

    public final boolean isClosed() {
        return this.state == 6;
    }

    @Override
    public final void flushRequest() throws IOException {
        this.sink.flush();
    }

    @Override
    public final void finishRequest() throws IOException {
        this.sink.flush();
    }

    public final void writeRequest(Headers headers, String string) throws IOException {
        if (this.state != 0) {
            throw new IllegalStateException(z[1] + this.state);
        }
        this.sink.writeUtf8(string).writeUtf8(z[8]);
        int n2 = headers.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.sink.writeUtf8(headers.name(i2)).writeUtf8(z[7]).writeUtf8(headers.value(i2)).writeUtf8(z[8]);
        }
        this.sink.writeUtf8(z[8]);
        this.state = 1;
    }

    @Override
    public final Response.Builder readResponseHeaders(boolean bl) throws IOException {
        if (this.state != 1 && this.state != 3) {
            throw new IllegalStateException(z[1] + this.state);
        }
        try {
            StatusLine statusLine = StatusLine.parse(this.readHeaderLine());
            Response.Builder builder = new Response.Builder().protocol(statusLine.protocol).code(statusLine.code).message(statusLine.message).headers(this.readHeaders());
            if (bl && statusLine.code == 100) {
                return null;
            }
            if (statusLine.code == 100) {
                this.state = 3;
                return builder;
            }
            this.state = 4;
            return builder;
        }
        catch (EOFException eOFException) {
            IOException iOException = new IOException(z[2] + this.streamAllocation);
            iOException.initCause(eOFException);
            throw iOException;
        }
    }

    private String readHeaderLine() throws IOException {
        String string = this.source.readUtf8LineStrict(this.headerLimit);
        this.headerLimit -= (long)string.length();
        return string;
    }

    public final Headers readHeaders() throws IOException {
        String string;
        Headers.Builder builder = new Headers.Builder();
        while ((string = this.readHeaderLine()).length() != 0) {
            Internal.instance.addLenient(builder, string);
        }
        return builder.build();
    }

    public final Sink newChunkedSink() {
        if (this.state != 1) {
            throw new IllegalStateException(z[1] + this.state);
        }
        this.state = 2;
        return new ChunkedSink();
    }

    public final Sink newFixedLengthSink(long l2) {
        if (this.state != 1) {
            throw new IllegalStateException(z[1] + this.state);
        }
        this.state = 2;
        return new FixedLengthSink(l2);
    }

    public final Source newFixedLengthSource(long l2) throws IOException {
        if (this.state != 4) {
            throw new IllegalStateException(z[1] + this.state);
        }
        this.state = 5;
        return new FixedLengthSource(l2);
    }

    public final Source newChunkedSource(HttpUrl httpUrl) throws IOException {
        if (this.state != 4) {
            throw new IllegalStateException(z[1] + this.state);
        }
        this.state = 5;
        return new ChunkedSource(httpUrl);
    }

    public final Source newUnknownLengthSource() throws IOException {
        if (this.state != 4) {
            throw new IllegalStateException(z[1] + this.state);
        }
        if (this.streamAllocation == null) {
            throw new IllegalStateException(z[0]);
        }
        this.state = 5;
        this.streamAllocation.noNewStreams();
        return new UnknownLengthSource();
    }

    final void detachTimeout(ForwardingTimeout forwardingTimeout) {
        Timeout timeout = forwardingTimeout.delegate();
        forwardingTimeout.setDelegate(Timeout.NONE);
        timeout.clearDeadline();
        timeout.clearTimeout();
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[9];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "VEv&,Hph/\"FPp*\"K\u00119~mKDh/";
        int n3 = -1;
        block16: while (true) {
            char[] cArray;
            block21: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block20: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block20;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block21;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 37;
                                break;
                            }
                            case 1: {
                                n9 = 49;
                                break;
                            }
                            case 2: {
                                n9 = 4;
                                break;
                            }
                            case 3: {
                                n9 = 67;
                                break;
                            }
                            default: {
                                n9 = 77;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "VEe7(\u001f\u0011";
                    n3 = 0;
                    continue block16;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "P_a;=@Rp&)\u0005Tj'mJW$09WTe.mJ_$";
                    n3 = 1;
                    continue block16;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "qCe->CTvn\bKRk'$KV";
                    n3 = 2;
                    continue block16;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "FYq-&@U";
                    n3 = 3;
                    continue block16;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "fPj-\"Q\u0011w7?@Pic,\u0005Ca28@Bpc/JU}c:LEl,8Q\u0011g+8KZa'm@_g,)L_cc\"W\u0011ec&K^s-mF^j7(KE$/(KVp+l";
                    n3 = 4;
                    continue block16;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "f^j7(KE)\u00174UT";
                    n3 = 5;
                    continue block16;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "\u001f\u0011";
                    n3 = 6;
                    continue block16;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = "(;";
                    n3 = 7;
                    continue block16;
                }
                case 7: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }

    private class UnknownLengthSource
    extends AbstractSource {
        private boolean inputExhausted;
        private static final String[] z;

        UnknownLengthSource() {
        }

        @Override
        public long read(Buffer buffer, long l2) throws IOException {
            if (l2 < 0L) {
                throw new IllegalArgumentException(z[0] + l2);
            }
            if (this.closed) {
                throw new IllegalStateException(z[1]);
            }
            if (this.inputExhausted) {
                return -1L;
            }
            long l3 = super.read(buffer, l2);
            if (l3 == -1L) {
                this.inputExhausted = true;
                this.endOfInput(true, null);
                return -1L;
            }
            return l3;
        }

        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            if (!this.inputExhausted) {
                this.endOfInput(false, null);
            }
            this.closed = true;
        }

        /*
         * Handled impossible loop by duplicating code
         * Enabled aggressive block sorting
         */
        static {
            String string;
            String[] stringArray = new String[2];
            String[] stringArray2 = stringArray;
            String[] stringArray3 = stringArray;
            int n2 = 0;
            String string2 = "\u001fB\u0016\u0011'\u0012N\f\u0000DA\u001bRND";
            int n3 = -1;
            block9: while (true) {
                char[] cArray;
                block14: {
                    int n4;
                    int n5;
                    char[] cArray2;
                    int n6;
                    block13: {
                        char[] cArray3 = string2.toCharArray();
                        n6 = 0;
                        int n7 = cArray3.length;
                        cArray2 = cArray3;
                        n5 = n7;
                        if (n7 <= 1) break block13;
                        cArray = cArray2;
                        n4 = n5;
                        if (n5 <= n6) break block14;
                    }
                    do {
                        char[] cArray4 = cArray2;
                        char[] cArray5 = cArray2;
                        int n8 = n6;
                        while (true) {
                            int n9;
                            char c2 = cArray4[n8];
                            switch (n6 % 5) {
                                case 0: {
                                    n9 = 125;
                                    break;
                                }
                                case 1: {
                                    n9 = 59;
                                    break;
                                }
                                case 2: {
                                    n9 = 98;
                                    break;
                                }
                                case 3: {
                                    n9 = 116;
                                    break;
                                }
                                default: {
                                    n9 = 100;
                                }
                            }
                            cArray4[n8] = (char)(c2 ^ n9);
                            ++n6;
                            cArray2 = cArray5;
                            n5 = n5;
                            if (n5 != 0) break;
                            cArray5 = cArray2;
                            n4 = n5;
                            n8 = n5;
                            cArray4 = cArray2;
                        }
                        cArray = cArray2;
                        n4 = n5;
                    } while (n5 > n6);
                }
                string = new String(cArray);
                switch (n3) {
                    default: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 1;
                        string2 = "\u001eW\r\u0007\u0001\u0019";
                        n3 = 0;
                        continue block9;
                    }
                    case 0: 
                }
                break;
            }
            stringArray2[n2] = string.intern();
            z = stringArray3;
        }
    }

    private class ChunkedSource
    extends AbstractSource {
        private static final long NO_CHUNK_YET = -1L;
        private final HttpUrl url;
        private long bytesRemainingInChunk;
        private boolean hasMoreChunks;
        private static final String[] z;

        ChunkedSource(HttpUrl httpUrl) {
            this.bytesRemainingInChunk = -1L;
            this.hasMoreChunks = true;
            this.url = httpUrl;
        }

        @Override
        public long read(Buffer object, long l2) throws IOException {
            long l3;
            if (l2 < 0L) {
                throw new IllegalArgumentException(z[1] + l2);
            }
            if (this.closed) {
                throw new IllegalStateException(z[2]);
            }
            if (!this.hasMoreChunks) {
                return -1L;
            }
            if (this.bytesRemainingInChunk == 0L || this.bytesRemainingInChunk == -1L) {
                this.readChunkSize();
                if (!this.hasMoreChunks) {
                    return -1L;
                }
            }
            if ((l3 = super.read((Buffer)object, Math.min(l2, this.bytesRemainingInChunk))) == -1L) {
                object = new ProtocolException(z[0]);
                this.endOfInput(false, (IOException)object);
                throw object;
            }
            this.bytesRemainingInChunk -= l3;
            return l3;
        }

        private void readChunkSize() throws IOException {
            if (this.bytesRemainingInChunk != -1L) {
                Http1Codec.this.source.readUtf8LineStrict();
            }
            try {
                this.bytesRemainingInChunk = Http1Codec.this.source.readHexadecimalUnsignedLong();
                String string = Http1Codec.this.source.readUtf8LineStrict().trim();
                if (this.bytesRemainingInChunk < 0L || !string.isEmpty() && !string.startsWith(";")) {
                    throw new ProtocolException(z[3] + this.bytesRemainingInChunk + string + "\"");
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new ProtocolException(numberFormatException.getMessage());
            }
            if (this.bytesRemainingInChunk == 0L) {
                this.hasMoreChunks = false;
                HttpHeaders.receiveHeaders(Http1Codec.this.client.cookieJar(), this.url, Http1Codec.this.readHeaders());
                this.endOfInput(true, null);
            }
        }

        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            if (this.hasMoreChunks && !Util.discard(this, 100, TimeUnit.MILLISECONDS)) {
                this.endOfInput(false, null);
            }
            this.closed = true;
        }

        /*
         * Handled impossible loop by duplicating code
         * Enabled aggressive block sorting
         */
        static {
            String string;
            String[] stringArray = new String[4];
            String[] stringArray2 = stringArray;
            String[] stringArray3 = stringArray;
            int n2 = 0;
            String string2 = "\f\u0015$\u001cN\u001c\u00185\u0001ZY\u001e/\u0000\u001e\u0016\u001da\u0017J\u000b\u001e \t";
            int n3 = -1;
            block11: while (true) {
                char[] cArray;
                block16: {
                    int n4;
                    int n5;
                    char[] cArray2;
                    int n6;
                    block15: {
                        char[] cArray3 = string2.toCharArray();
                        n6 = 0;
                        int n7 = cArray3.length;
                        cArray2 = cArray3;
                        n5 = n7;
                        if (n7 <= 1) break block15;
                        cArray = cArray2;
                        n4 = n5;
                        if (n5 <= n6) break block16;
                    }
                    do {
                        char[] cArray4 = cArray2;
                        char[] cArray5 = cArray2;
                        int n8 = n6;
                        while (true) {
                            int n9;
                            char c2 = cArray4[n8];
                            switch (n6 % 5) {
                                case 0: {
                                    n9 = 121;
                                    break;
                                }
                                case 1: {
                                    n9 = 123;
                                    break;
                                }
                                case 2: {
                                    n9 = 65;
                                    break;
                                }
                                case 3: {
                                    n9 = 100;
                                    break;
                                }
                                default: {
                                    n9 = 62;
                                }
                            }
                            cArray4[n8] = (char)(c2 ^ n9);
                            ++n6;
                            cArray2 = cArray5;
                            n5 = n5;
                            if (n5 != 0) break;
                            cArray5 = cArray2;
                            n4 = n5;
                            n8 = n5;
                            cArray4 = cArray2;
                        }
                        cArray = cArray2;
                        n4 = n5;
                    } while (n5 > n6);
                }
                string = new String(cArray);
                switch (n3) {
                    default: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 1;
                        string2 = "\u001b\u00025\u0001}\u0016\u000e/\u0010\u001eE[q^\u001e";
                        n3 = 0;
                        continue block11;
                    }
                    case 0: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 2;
                        string2 = "\u001a\u0017.\u0017[\u001d";
                        n3 = 1;
                        continue block11;
                    }
                    case 1: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 3;
                        string2 = "\u001c\u00031\u0001]\r\u001e%D]\u0011\u000e/\u000f\u001e\n\u0012;\u0001\u001e\u0018\u0015%DQ\t\u000f(\u000bP\u0018\u0017a\u0001F\r\u001e/\u0017W\u0016\u00152D\\\f\u000fa\u0013_\n[c";
                        n3 = 2;
                        continue block11;
                    }
                    case 2: 
                }
                break;
            }
            stringArray2[n2] = string.intern();
            z = stringArray3;
        }
    }

    private class FixedLengthSource
    extends AbstractSource {
        private long bytesRemaining;
        private static final String[] z;

        FixedLengthSource(long l2) throws IOException {
            this.bytesRemaining = l2;
            if (this.bytesRemaining == 0L) {
                this.endOfInput(true, null);
            }
        }

        @Override
        public long read(Buffer object, long l2) throws IOException {
            if (l2 < 0L) {
                throw new IllegalArgumentException(z[2] + l2);
            }
            if (this.closed) {
                throw new IllegalStateException(z[0]);
            }
            if (this.bytesRemaining == 0L) {
                return -1L;
            }
            long l3 = super.read((Buffer)object, Math.min(this.bytesRemaining, l2));
            if (l3 == -1L) {
                object = new ProtocolException(z[1]);
                this.endOfInput(false, (IOException)object);
                throw object;
            }
            this.bytesRemaining -= l3;
            if (this.bytesRemaining == 0L) {
                this.endOfInput(true, null);
            }
            return l3;
        }

        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            if (this.bytesRemaining != 0L && !Util.discard(this, 100, TimeUnit.MILLISECONDS)) {
                this.endOfInput(false, null);
            }
            this.closed = true;
        }

        /*
         * Handled impossible loop by duplicating code
         * Enabled aggressive block sorting
         */
        static {
            String string;
            String[] stringArray = new String[3];
            String[] stringArray2 = stringArray;
            String[] stringArray3 = stringArray;
            int n2 = 0;
            String string2 = "DsF\u001e\u0015C";
            int n3 = -1;
            block10: while (true) {
                char[] cArray;
                block15: {
                    int n4;
                    int n5;
                    char[] cArray2;
                    int n6;
                    block14: {
                        char[] cArray3 = string2.toCharArray();
                        n6 = 0;
                        int n7 = cArray3.length;
                        cArray2 = cArray3;
                        n5 = n7;
                        if (n7 <= 1) break block14;
                        cArray = cArray2;
                        n4 = n5;
                        if (n5 <= n6) break block15;
                    }
                    do {
                        char[] cArray4 = cArray2;
                        char[] cArray5 = cArray2;
                        int n8 = n6;
                        while (true) {
                            int n9;
                            char c2 = cArray4[n8];
                            switch (n6 % 5) {
                                case 0: {
                                    n9 = 39;
                                    break;
                                }
                                case 1: {
                                    n9 = 31;
                                    break;
                                }
                                case 2: {
                                    n9 = 41;
                                    break;
                                }
                                case 3: {
                                    n9 = 109;
                                    break;
                                }
                                default: {
                                    n9 = 112;
                                }
                            }
                            cArray4[n8] = (char)(c2 ^ n9);
                            ++n6;
                            cArray2 = cArray5;
                            n5 = n5;
                            if (n5 != 0) break;
                            cArray5 = cArray2;
                            n4 = n5;
                            n8 = n5;
                            cArray4 = cArray2;
                        }
                        cArray = cArray2;
                        n4 = n5;
                    } while (n5 > n6);
                }
                string = new String(cArray);
                switch (n3) {
                    default: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 1;
                        string2 = "RqL\u0015\u0000B|]\b\u0014\u0007zG\tPHy\t\u001e\u0004UzH\u0000";
                        n3 = 0;
                        continue block10;
                    }
                    case 0: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 2;
                        string2 = "Ef]\b3HjG\u0019P\u001b?\u0019WP";
                        n3 = 1;
                        continue block10;
                    }
                    case 1: 
                }
                break;
            }
            stringArray2[n2] = string.intern();
            z = stringArray3;
        }
    }

    private abstract class AbstractSource
    implements Source {
        protected final ForwardingTimeout timeout;
        protected boolean closed;
        protected long bytesRead;
        private static final String z;

        private AbstractSource() {
            this.timeout = new ForwardingTimeout(Http1Codec.this.source.timeout());
            this.bytesRead = 0L;
        }

        @Override
        public Timeout timeout() {
            return this.timeout;
        }

        @Override
        public long read(Buffer buffer, long l2) throws IOException {
            try {
                long l3 = Http1Codec.this.source.read(buffer, l2);
                if (l3 > 0L) {
                    this.bytesRead += l3;
                }
                return l3;
            }
            catch (IOException iOException) {
                this.endOfInput(false, iOException);
                throw iOException;
            }
        }

        protected final void endOfInput(boolean bl, IOException iOException) throws IOException {
            if (Http1Codec.this.state == 6) {
                return;
            }
            if (Http1Codec.this.state != 5) {
                throw new IllegalStateException(z + Http1Codec.this.state);
            }
            Http1Codec.this.detachTimeout(this.timeout);
            Http1Codec.this.state = 6;
            if (Http1Codec.this.streamAllocation != null) {
                Http1Codec.this.streamAllocation.streamFinished(!bl, Http1Codec.this, this.bytesRead, iOException);
            }
        }

        /*
         * Handled impossible loop by duplicating code
         * Enabled aggressive block sorting
         */
        static {
            char[] cArray;
            block10: {
                int n2;
                int n3;
                char[] cArray2;
                int n4;
                block9: {
                    char[] cArray3 = "na\b\u000ek'5".toCharArray();
                    n4 = 0;
                    int n5 = cArray3.length;
                    cArray2 = cArray3;
                    n3 = n5;
                    if (n5 <= 1) break block9;
                    cArray = cArray2;
                    n2 = n3;
                    if (n3 <= n4) break block10;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n6 = n4;
                    while (true) {
                        int n7;
                        char c2 = cArray4[n6];
                        switch (n4 % 5) {
                            case 0: {
                                n7 = 29;
                                break;
                            }
                            case 1: {
                                n7 = 21;
                                break;
                            }
                            case 2: {
                                n7 = 105;
                                break;
                            }
                            case 3: {
                                n7 = 122;
                                break;
                            }
                            default: {
                                n7 = 14;
                            }
                        }
                        cArray4[n6] = (char)(c2 ^ n7);
                        ++n4;
                        cArray2 = cArray5;
                        n3 = n3;
                        if (n3 != 0) break;
                        cArray5 = cArray2;
                        n2 = n3;
                        n6 = n3;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n2 = n3;
                } while (n3 > n4);
            }
            z = new String(cArray).intern();
        }
    }

    private final class ChunkedSink
    implements Sink {
        private final ForwardingTimeout timeout;
        private boolean closed;
        private static final String[] z;

        ChunkedSink() {
            this.timeout = new ForwardingTimeout(Http1Codec.this.sink.timeout());
        }

        @Override
        public final Timeout timeout() {
            return this.timeout;
        }

        @Override
        public final void write(Buffer buffer, long l2) throws IOException {
            if (this.closed) {
                throw new IllegalStateException(z[2]);
            }
            if (l2 == 0L) {
                return;
            }
            Http1Codec.this.sink.writeHexadecimalUnsignedLong(l2);
            Http1Codec.this.sink.writeUtf8(z[1]);
            Http1Codec.this.sink.write(buffer, l2);
            Http1Codec.this.sink.writeUtf8(z[1]);
        }

        @Override
        public final synchronized void flush() throws IOException {
            if (this.closed) {
                return;
            }
            Http1Codec.this.sink.flush();
        }

        @Override
        public final synchronized void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.closed = true;
            Http1Codec.this.sink.writeUtf8(z[0]);
            Http1Codec.this.detachTimeout(this.timeout);
            Http1Codec.this.state = 3;
        }

        /*
         * Handled impossible loop by duplicating code
         * Enabled aggressive block sorting
         */
        static {
            String string;
            String[] stringArray = new String[3];
            String[] stringArray2 = stringArray;
            String[] stringArray3 = stringArray;
            int n2 = 0;
            String string2 = "\u0002Zhr\u000b";
            int n3 = -1;
            block10: while (true) {
                char[] cArray;
                block15: {
                    int n4;
                    int n5;
                    char[] cArray2;
                    int n6;
                    block14: {
                        char[] cArray3 = string2.toCharArray();
                        n6 = 0;
                        int n7 = cArray3.length;
                        cArray2 = cArray3;
                        n5 = n7;
                        if (n7 <= 1) break block14;
                        cArray = cArray2;
                        n4 = n5;
                        if (n5 <= n6) break block15;
                    }
                    do {
                        char[] cArray4 = cArray2;
                        char[] cArray5 = cArray2;
                        int n8 = n6;
                        while (true) {
                            int n9;
                            char c2 = cArray4[n8];
                            switch (n6 % 5) {
                                case 0: {
                                    n9 = 50;
                                    break;
                                }
                                case 1: {
                                    n9 = 87;
                                    break;
                                }
                                case 2: {
                                    n9 = 98;
                                    break;
                                }
                                case 3: {
                                    n9 = 127;
                                    break;
                                }
                                default: {
                                    n9 = 1;
                                }
                            }
                            cArray4[n8] = (char)(c2 ^ n9);
                            ++n6;
                            cArray2 = cArray5;
                            n5 = n5;
                            if (n5 != 0) break;
                            cArray5 = cArray2;
                            n4 = n5;
                            n8 = n5;
                            cArray4 = cArray2;
                        }
                        cArray = cArray2;
                        n4 = n5;
                    } while (n5 > n6);
                }
                string = new String(cArray);
                switch (n3) {
                    default: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 1;
                        string2 = "?]";
                        n3 = 0;
                        continue block10;
                    }
                    case 0: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 2;
                        string2 = "Q;\r\fdV";
                        n3 = 1;
                        continue block10;
                    }
                    case 1: 
                }
                break;
            }
            stringArray2[n2] = string.intern();
            z = stringArray3;
        }
    }

    private final class FixedLengthSink
    implements Sink {
        private final ForwardingTimeout timeout;
        private boolean closed;
        private long bytesRemaining;
        private static final String[] z;

        FixedLengthSink(long l2) {
            this.timeout = new ForwardingTimeout(Http1Codec.this.sink.timeout());
            this.bytesRemaining = l2;
        }

        @Override
        public final Timeout timeout() {
            return this.timeout;
        }

        @Override
        public final void write(Buffer buffer, long l2) throws IOException {
            if (this.closed) {
                throw new IllegalStateException(z[1]);
            }
            Util.checkOffsetAndCount(buffer.size(), 0L, l2);
            if (l2 > this.bytesRemaining) {
                throw new ProtocolException(z[2] + this.bytesRemaining + z[0] + l2);
            }
            Http1Codec.this.sink.write(buffer, l2);
            this.bytesRemaining -= l2;
        }

        @Override
        public final void flush() throws IOException {
            if (this.closed) {
                return;
            }
            Http1Codec.this.sink.flush();
        }

        @Override
        public final void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.closed = true;
            if (this.bytesRemaining > 0L) {
                throw new ProtocolException(z[3]);
            }
            Http1Codec.this.detachTimeout(this.timeout);
            Http1Codec.this.state = 3;
        }

        /*
         * Handled impossible loop by duplicating code
         * Enabled aggressive block sorting
         */
        static {
            String string;
            String[] stringArray = new String[4];
            String[] stringArray2 = stringArray;
            String[] stringArray3 = stringArray;
            int n2 = 0;
            String string2 = "\u000f\u0004D\u000b_\\F_\nN\u000f\u0014X\u001c_F\u0010X\u001b\u001a";
            int n3 = -1;
            block11: while (true) {
                char[] cArray;
                block16: {
                    int n4;
                    int n5;
                    char[] cArray2;
                    int n6;
                    block15: {
                        char[] cArray3 = string2.toCharArray();
                        n6 = 0;
                        int n7 = cArray3.length;
                        cArray2 = cArray3;
                        n5 = n7;
                        if (n7 <= 1) break block15;
                        cArray = cArray2;
                        n4 = n5;
                        if (n5 <= n6) break block16;
                    }
                    do {
                        char[] cArray4 = cArray2;
                        char[] cArray5 = cArray2;
                        int n8 = n6;
                        while (true) {
                            int n9;
                            char c2 = cArray4[n8];
                            switch (n6 % 5) {
                                case 0: {
                                    n9 = 47;
                                    break;
                                }
                                case 1: {
                                    n9 = 102;
                                    break;
                                }
                                case 2: {
                                    n9 = 61;
                                    break;
                                }
                                case 3: {
                                    n9 = 127;
                                    break;
                                }
                                default: {
                                    n9 = 58;
                                }
                            }
                            cArray4[n8] = (char)(c2 ^ n9);
                            ++n6;
                            cArray2 = cArray5;
                            n5 = n5;
                            if (n5 != 0) break;
                            cArray5 = cArray2;
                            n4 = n5;
                            n8 = n5;
                            cArray4 = cArray2;
                        }
                        cArray = cArray2;
                        n4 = n5;
                    } while (n5 > n6);
                }
                string = new String(cArray);
                switch (n3) {
                    default: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 1;
                        string2 = "L\nR\f_K";
                        n3 = 0;
                        continue block11;
                    }
                    case 0: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 2;
                        string2 = "J\u001eM\u001aY[\u0003Y_";
                        n3 = 1;
                        continue block11;
                    }
                    case 1: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 3;
                        string2 = "Z\bX\u0007JJ\u0005I\u001a^\u000f\u0003S\u001b\u001a@\u0000\u001d\fN]\u0003\\\u0012";
                        n3 = 2;
                        continue block11;
                    }
                    case 2: 
                }
                break;
            }
            stringArray2[n2] = string.intern();
            z = stringArray3;
        }
    }
}

