/*
 * Decompiled with CFR 0.152.
 */
package cn.jmessage.support.okhttp3.internal.http2;

import cn.jmessage.support.okhttp3.Headers;
import cn.jmessage.support.okhttp3.Interceptor;
import cn.jmessage.support.okhttp3.OkHttpClient;
import cn.jmessage.support.okhttp3.Protocol;
import cn.jmessage.support.okhttp3.Request;
import cn.jmessage.support.okhttp3.Response;
import cn.jmessage.support.okhttp3.ResponseBody;
import cn.jmessage.support.okhttp3.internal.Internal;
import cn.jmessage.support.okhttp3.internal.Util;
import cn.jmessage.support.okhttp3.internal.connection.StreamAllocation;
import cn.jmessage.support.okhttp3.internal.http.HttpCodec;
import cn.jmessage.support.okhttp3.internal.http.HttpHeaders;
import cn.jmessage.support.okhttp3.internal.http.RealResponseBody;
import cn.jmessage.support.okhttp3.internal.http.RequestLine;
import cn.jmessage.support.okhttp3.internal.http.StatusLine;
import cn.jmessage.support.okhttp3.internal.http2.ErrorCode;
import cn.jmessage.support.okhttp3.internal.http2.Header;
import cn.jmessage.support.okhttp3.internal.http2.Http2Connection;
import cn.jmessage.support.okhttp3.internal.http2.Http2Stream;
import cn.jmessage.support.okio.Buffer;
import cn.jmessage.support.okio.ByteString;
import cn.jmessage.support.okio.ForwardingSource;
import cn.jmessage.support.okio.Okio;
import cn.jmessage.support.okio.Sink;
import cn.jmessage.support.okio.Source;
import java.io.IOException;
import java.net.ProtocolException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;

public final class Http2Codec
implements HttpCodec {
    private static final ByteString CONNECTION;
    private static final ByteString HOST;
    private static final ByteString KEEP_ALIVE;
    private static final ByteString PROXY_CONNECTION;
    private static final ByteString TRANSFER_ENCODING;
    private static final ByteString TE;
    private static final ByteString ENCODING;
    private static final ByteString UPGRADE;
    private static final List<ByteString> HTTP_2_SKIPPED_REQUEST_HEADERS;
    private static final List<ByteString> HTTP_2_SKIPPED_RESPONSE_HEADERS;
    private final Interceptor.Chain chain;
    final StreamAllocation streamAllocation;
    private final Http2Connection connection;
    private Http2Stream stream;
    private final Protocol protocol;
    private static final String[] z;

    public Http2Codec(OkHttpClient okHttpClient, Interceptor.Chain chain, StreamAllocation streamAllocation, Http2Connection http2Connection) {
        this.chain = chain;
        this.streamAllocation = streamAllocation;
        this.connection = http2Connection;
        this.protocol = okHttpClient.protocols().contains((Object)Protocol.H2_PRIOR_KNOWLEDGE) ? Protocol.H2_PRIOR_KNOWLEDGE : Protocol.HTTP_2;
    }

    @Override
    public final Sink createRequestBody(Request request, long l2) {
        return this.stream.getSink();
    }

    @Override
    public final void writeRequestHeaders(Request object) throws IOException {
        if (this.stream != null) {
            return;
        }
        boolean bl = ((Request)object).body() != null;
        object = Http2Codec.http2HeadersList((Request)object);
        this.stream = this.connection.newStream((List<Header>)object, bl);
        this.stream.readTimeout().timeout(this.chain.readTimeoutMillis(), TimeUnit.MILLISECONDS);
        this.stream.writeTimeout().timeout(this.chain.writeTimeoutMillis(), TimeUnit.MILLISECONDS);
    }

    @Override
    public final void flushRequest() throws IOException {
        this.connection.flush();
    }

    @Override
    public final void finishRequest() throws IOException {
        this.stream.getSink().close();
    }

    @Override
    public final Response.Builder readResponseHeaders(boolean bl) throws IOException {
        Response.Builder builder = Http2Codec.readHttp2HeadersList(this.stream.takeResponseHeaders(), this.protocol);
        if (bl && Internal.instance.code(builder) == 100) {
            return null;
        }
        return builder;
    }

    public static List<Header> http2HeadersList(Request request) {
        Headers headers = request.headers();
        ArrayList<Header> arrayList = new ArrayList<Header>(headers.size() + 4);
        arrayList.add(new Header(Header.TARGET_METHOD, request.method()));
        arrayList.add(new Header(Header.TARGET_PATH, RequestLine.requestPath(request.url())));
        String string = request.header(z[0]);
        if (string != null) {
            arrayList.add(new Header(Header.TARGET_AUTHORITY, string));
        }
        arrayList.add(new Header(Header.TARGET_SCHEME, request.url().scheme()));
        int n2 = headers.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            ByteString byteString = ByteString.encodeUtf8(headers.name(i2).toLowerCase(Locale.US));
            if (HTTP_2_SKIPPED_REQUEST_HEADERS.contains(byteString)) continue;
            arrayList.add(new Header(byteString, headers.value(i2)));
        }
        return arrayList;
    }

    public static Response.Builder readHttp2HeadersList(List<Header> list, Protocol protocol) throws IOException {
        StatusLine statusLine = null;
        Headers.Builder builder = new Headers.Builder();
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object = list.get(i2);
            if (object == null) {
                if (statusLine == null || statusLine.code != 100) continue;
                statusLine = null;
                builder = new Headers.Builder();
                continue;
            }
            ByteString byteString = ((Header)object).name;
            object = ((Header)object).value.utf8();
            if (byteString.equals(Header.RESPONSE_STATUS)) {
                statusLine = StatusLine.parse(z[3] + (String)object);
                continue;
            }
            if (HTTP_2_SKIPPED_RESPONSE_HEADERS.contains(byteString)) continue;
            Internal.instance.addLenient(builder, byteString.utf8(), (String)object);
        }
        if (statusLine == null) {
            throw new ProtocolException(z[2]);
        }
        return new Response.Builder().protocol(protocol).code(statusLine.code).message(statusLine.message).headers(builder.build());
    }

    @Override
    public final ResponseBody openResponseBody(Response closeable) throws IOException {
        this.streamAllocation.eventListener.responseBodyStart(this.streamAllocation.call);
        String string = closeable.header(z[1]);
        long l2 = HttpHeaders.contentLength(closeable);
        closeable = new StreamFinishingSource(this.stream.getSource());
        return new RealResponseBody(string, l2, Okio.buffer((Source)closeable));
    }

    @Override
    public final void cancel() {
        if (this.stream != null) {
            this.stream.closeLater(ErrorCode.CANCEL);
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String string2;
        int n2;
        String[] stringArray = new String[4];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n3 = 0;
        String string3 = "V7\u0015`";
        int n4 = -1;
        block26: while (true) {
            char[] cArray;
            block35: {
                int n5;
                int n6;
                char[] cArray2;
                block34: {
                    char[] cArray3 = string3.toCharArray();
                    n2 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n6 = n7;
                    if (n7 <= 1) break block34;
                    cArray = cArray2;
                    n5 = n6;
                    if (n6 <= n2) break block35;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n2;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n2 % 5) {
                            case 0: {
                                n9 = 30;
                                break;
                            }
                            case 1: {
                                n9 = 88;
                                break;
                            }
                            case 2: {
                                n9 = 102;
                                break;
                            }
                            case 3: {
                                n9 = 20;
                                break;
                            }
                            default: {
                                n9 = 57;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n2;
                        cArray2 = cArray5;
                        n6 = n6;
                        if (n6 != 0) break;
                        cArray5 = cArray2;
                        n5 = n6;
                        n8 = n6;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n5 = n6;
                } while (n6 > n2);
            }
            string2 = new String(cArray);
            switch (n4) {
                default: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 1;
                    string3 = "]7\b`\\p,K@@n=";
                    n4 = 0;
                    continue block26;
                }
                case 0: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 2;
                    string3 = "[ \u0016qZj=\u00024\u001e$+\u0012uMk+A4Q{9\u0002qK>6\t`\u0019n*\u0003g\\p,";
                    n4 = 1;
                    continue block26;
                }
                case 1: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 3;
                    string3 = "V\f2D\u0016/vW4";
                    n4 = 2;
                    continue block26;
                }
                case 2: 
            }
            break;
        }
        stringArray2[n3] = string2.intern();
        z = stringArray3;
        String string4 = "}7\bz\\},\u000f{W";
        int n10 = -1;
        block29: while (true) {
            char[] cArray;
            block37: {
                int n11;
                int n12;
                char[] cArray6;
                block36: {
                    char[] cArray7 = string4.toCharArray();
                    n2 = 0;
                    int n13 = cArray7.length;
                    cArray6 = cArray7;
                    n12 = n13;
                    if (n13 <= 1) break block36;
                    cArray = cArray6;
                    n11 = n12;
                    if (n12 <= n2) break block37;
                }
                do {
                    char[] cArray8 = cArray6;
                    char[] cArray9 = cArray6;
                    int n14 = n2;
                    while (true) {
                        int n15;
                        char c3 = cArray8[n14];
                        switch (n2 % 5) {
                            case 0: {
                                n15 = 30;
                                break;
                            }
                            case 1: {
                                n15 = 88;
                                break;
                            }
                            case 2: {
                                n15 = 102;
                                break;
                            }
                            case 3: {
                                n15 = 20;
                                break;
                            }
                            default: {
                                n15 = 57;
                            }
                        }
                        cArray8[n14] = (char)(c3 ^ n15);
                        ++n2;
                        cArray6 = cArray9;
                        n12 = n12;
                        if (n12 != 0) break;
                        cArray9 = cArray6;
                        n11 = n12;
                        n14 = n12;
                        cArray8 = cArray6;
                    }
                    cArray = cArray6;
                    n11 = n12;
                } while (n12 > n2);
            }
            string = new String(cArray).intern();
            switch (n10) {
                default: {
                    CONNECTION = ByteString.encodeUtf8(string);
                    string4 = "v7\u0015`";
                    n10 = 0;
                    continue block29;
                }
                case 0: {
                    HOST = ByteString.encodeUtf8(string);
                    string4 = "u=\u0003d\u0014\u007f4\u000fb\\";
                    n10 = 1;
                    continue block29;
                }
                case 1: {
                    KEEP_ALIVE = ByteString.encodeUtf8(string);
                    string4 = "n*\tl@3;\tzW{;\u0012}Vp";
                    n10 = 2;
                    continue block29;
                }
                case 2: {
                    PROXY_CONNECTION = ByteString.encodeUtf8(string);
                    string4 = "j*\u0007zJx=\u00149\\p;\tpPp?";
                    n10 = 3;
                    continue block29;
                }
                case 3: {
                    TRANSFER_ENCODING = ByteString.encodeUtf8(string);
                    string4 = "j=";
                    n10 = 4;
                    continue block29;
                }
                case 4: {
                    TE = ByteString.encodeUtf8(string);
                    string4 = "{6\u0005{]w6\u0001";
                    n10 = 5;
                    continue block29;
                }
                case 5: {
                    ENCODING = ByteString.encodeUtf8(string);
                    string4 = "k(\u0001fXz=";
                    n10 = 6;
                    continue block29;
                }
                case 6: 
            }
            break;
        }
        UPGRADE = ByteString.encodeUtf8(string);
        HTTP_2_SKIPPED_REQUEST_HEADERS = Util.immutableList(CONNECTION, HOST, KEEP_ALIVE, PROXY_CONNECTION, TE, TRANSFER_ENCODING, ENCODING, UPGRADE, Header.TARGET_METHOD, Header.TARGET_PATH, Header.TARGET_SCHEME, Header.TARGET_AUTHORITY);
        HTTP_2_SKIPPED_RESPONSE_HEADERS = Util.immutableList(CONNECTION, HOST, KEEP_ALIVE, PROXY_CONNECTION, TE, TRANSFER_ENCODING, ENCODING, UPGRADE);
    }

    class StreamFinishingSource
    extends ForwardingSource {
        boolean completed;
        long bytesRead;

        StreamFinishingSource(Source source) {
            super(source);
            this.completed = false;
            this.bytesRead = 0L;
        }

        @Override
        public long read(Buffer buffer, long l2) throws IOException {
            try {
                long l3 = this.delegate().read(buffer, l2);
                if (l3 > 0L) {
                    this.bytesRead += l3;
                }
                return l3;
            }
            catch (IOException iOException) {
                this.endOfInput(iOException);
                throw iOException;
            }
        }

        @Override
        public void close() throws IOException {
            super.close();
            this.endOfInput(null);
        }

        private void endOfInput(IOException iOException) {
            if (this.completed) {
                return;
            }
            this.completed = true;
            Http2Codec.this.streamAllocation.streamFinished(false, Http2Codec.this, this.bytesRead, iOException);
        }
    }
}

