/*
 * Decompiled with CFR 0.152.
 */
package cn.jmessage.support.okhttp3.internal.http2;

import cn.jmessage.support.okhttp3.internal.http2.ErrorCode;
import cn.jmessage.support.okhttp3.internal.http2.Header;
import cn.jmessage.support.okhttp3.internal.http2.Http2Connection;
import cn.jmessage.support.okhttp3.internal.http2.StreamResetException;
import cn.jmessage.support.okio.AsyncTimeout;
import cn.jmessage.support.okio.Buffer;
import cn.jmessage.support.okio.BufferedSource;
import cn.jmessage.support.okio.Sink;
import cn.jmessage.support.okio.Source;
import cn.jmessage.support.okio.Timeout;
import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.List;

public final class Http2Stream {
    long unacknowledgedBytesRead = 0L;
    long bytesLeftInWriteWindow;
    final int id;
    final Http2Connection connection;
    private final List<Header> requestHeaders;
    private List<Header> responseHeaders;
    private boolean hasResponseHeaders;
    private final FramingSource source;
    final FramingSink sink;
    final StreamTimeout readTimeout = new StreamTimeout();
    final StreamTimeout writeTimeout = new StreamTimeout();
    ErrorCode errorCode = null;
    private static final String[] z;

    Http2Stream(int n2, Http2Connection http2Connection, boolean bl, boolean bl2, List<Header> list) {
        if (http2Connection == null) {
            throw new NullPointerException(z[0]);
        }
        if (list == null) {
            throw new NullPointerException(z[1]);
        }
        this.id = n2;
        this.connection = http2Connection;
        this.bytesLeftInWriteWindow = http2Connection.peerSettings.getInitialWindowSize();
        this.source = new FramingSource(http2Connection.okHttpSettings.getInitialWindowSize());
        this.sink = new FramingSink();
        this.source.finished = bl2;
        this.sink.finished = bl;
        this.requestHeaders = list;
    }

    public final int getId() {
        return this.id;
    }

    public final synchronized boolean isOpen() {
        if (this.errorCode != null) {
            return false;
        }
        return !this.source.finished && !this.source.closed || !this.sink.finished && !this.sink.closed || !this.hasResponseHeaders;
    }

    public final boolean isLocallyInitiated() {
        boolean bl;
        boolean bl2 = bl = (this.id & 1) == 1;
        return this.connection.client == bl;
    }

    public final Http2Connection getConnection() {
        return this.connection;
    }

    public final List<Header> getRequestHeaders() {
        return this.requestHeaders;
    }

    public final synchronized List<Header> takeResponseHeaders() throws IOException {
        if (!this.isLocallyInitiated()) {
            throw new IllegalStateException(z[2]);
        }
        this.readTimeout.enter();
        try {
            while (this.responseHeaders == null && this.errorCode == null) {
                this.waitForIo();
            }
        }
        finally {
            this.readTimeout.exitAndThrowIfTimedOut();
        }
        List<Header> list = this.responseHeaders;
        if (list != null) {
            this.responseHeaders = null;
            return list;
        }
        throw new StreamResetException(this.errorCode);
    }

    public final synchronized ErrorCode getErrorCode() {
        return this.errorCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void sendResponseHeaders(List<Header> list, boolean bl) throws IOException {
        assert (!Thread.holdsLock(this));
        if (list == null) {
            throw new NullPointerException(z[4]);
        }
        boolean bl2 = false;
        boolean bl3 = false;
        Object object = this;
        synchronized (object) {
            this.hasResponseHeaders = true;
            if (!bl) {
                this.sink.finished = true;
                bl3 = true;
                bl2 = true;
            }
        }
        if (!bl3) {
            object = this.connection;
            synchronized (object) {
                bl3 = this.connection.bytesLeftInWriteWindow == 0L;
            }
        }
        this.connection.writeSynReply(this.id, bl2, list);
        if (bl3) {
            this.connection.flush();
        }
    }

    public final Timeout readTimeout() {
        return this.readTimeout;
    }

    public final Timeout writeTimeout() {
        return this.writeTimeout;
    }

    public final Source getSource() {
        return this.source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Sink getSink() {
        Http2Stream http2Stream = this;
        synchronized (http2Stream) {
            if (!this.hasResponseHeaders && !this.isLocallyInitiated()) {
                throw new IllegalStateException(z[3]);
            }
        }
        return this.sink;
    }

    public final void close(ErrorCode errorCode) throws IOException {
        if (!this.closeInternal(errorCode)) {
            return;
        }
        this.connection.writeSynReset(this.id, errorCode);
    }

    public final void closeLater(ErrorCode errorCode) {
        if (!this.closeInternal(errorCode)) {
            return;
        }
        this.connection.writeSynResetLater(this.id, errorCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean closeInternal(ErrorCode errorCode) {
        assert (!Thread.holdsLock(this));
        Http2Stream http2Stream = this;
        synchronized (http2Stream) {
            if (this.errorCode != null) {
                return false;
            }
            if (this.source.finished && this.sink.finished) {
                return false;
            }
            this.errorCode = errorCode;
            this.notifyAll();
        }
        this.connection.removeStream(this.id);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void receiveHeaders(List<Header> list) {
        assert (!Thread.holdsLock(this));
        boolean bl = true;
        Http2Stream http2Stream = this;
        synchronized (http2Stream) {
            this.hasResponseHeaders = true;
            if (this.responseHeaders == null) {
                this.responseHeaders = list;
                bl = this.isOpen();
                this.notifyAll();
            } else {
                ArrayList<Header> arrayList = new ArrayList<Header>();
                arrayList.addAll(this.responseHeaders);
                arrayList.add(null);
                arrayList.addAll(list);
                this.responseHeaders = arrayList;
            }
        }
        if (!bl) {
            this.connection.removeStream(this.id);
        }
    }

    final void receiveData(BufferedSource bufferedSource, int n2) throws IOException {
        assert (!Thread.holdsLock(this));
        this.source.receive(bufferedSource, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void receiveFin() {
        boolean bl;
        assert (!Thread.holdsLock(this));
        Http2Stream http2Stream = this;
        synchronized (http2Stream) {
            this.source.finished = true;
            bl = this.isOpen();
            this.notifyAll();
        }
        if (!bl) {
            this.connection.removeStream(this.id);
        }
    }

    final synchronized void receiveRstStream(ErrorCode errorCode) {
        if (this.errorCode == null) {
            this.errorCode = errorCode;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void cancelStreamIfNecessary() throws IOException {
        boolean bl;
        boolean bl2;
        assert (!Thread.holdsLock(this));
        Http2Stream http2Stream = this;
        synchronized (http2Stream) {
            bl2 = !this.source.finished && this.source.closed && (this.sink.finished || this.sink.closed);
            bl = this.isOpen();
        }
        if (bl2) {
            this.close(ErrorCode.CANCEL);
            return;
        }
        if (!bl) {
            this.connection.removeStream(this.id);
        }
    }

    final void addBytesToWriteWindow(long l2) {
        this.bytesLeftInWriteWindow += l2;
        if (l2 > 0L) {
            this.notifyAll();
        }
    }

    final void checkOutNotClosed() throws IOException {
        if (this.sink.closed) {
            throw new IOException(z[5]);
        }
        if (this.sink.finished) {
            throw new IOException(z[6]);
        }
        if (this.errorCode != null) {
            throw new StreamResetException(this.errorCode);
        }
    }

    final void waitForIo() throws InterruptedIOException {
        try {
            this.wait();
            return;
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw new InterruptedIOException();
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[7];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "\\[\u000e\u001eG\\@\t\u001fL\u001f\t]PLJX\f";
        int n3 = -1;
        block14: while (true) {
            char[] cArray;
            block19: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block18: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block18;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block19;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 63;
                                break;
                            }
                            case 1: {
                                n9 = 52;
                                break;
                            }
                            case 2: {
                                n9 = 96;
                                break;
                            }
                            case 3: {
                                n9 = 112;
                                break;
                            }
                            default: {
                                n9 = 34;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "MQ\u0011\u0005GL@(\u0015C[Q\u0012\u0003\u0002\u0002\t@\u001eWSX";
                    n3 = 0;
                    continue block14;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "LQ\u0012\u0006GMG@\u0013CQZ\u000f\u0004\u0002MQ\u0001\u0014\u0002MQ\u0013\u0000MQG\u0005PJZU\u0004\u0015PL";
                    n3 = 1;
                    continue block14;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "MQ\u0010\u001c[\u001fV\u0005\u0016MMQ@\u0002GNA\u0005\u0003VVZ\u0007PVWQ@\u0003KQ_";
                    n3 = 2;
                    continue block14;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "MQ\u0013\u0000MQG\u00058G^P\u0005\u0002Q\u001f\t]PLJX\f";
                    n3 = 3;
                    continue block14;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "L@\u0012\u0015CR\u0014\u0003\u001cMLQ\u0004";
                    n3 = 4;
                    continue block14;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "L@\u0012\u0015CR\u0014\u0006\u0019LVG\b\u0015F";
                    n3 = 5;
                    continue block14;
                }
                case 5: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }

    class StreamTimeout
    extends AsyncTimeout {
        private static final String z;

        StreamTimeout() {
        }

        @Override
        protected void timedOut() {
            Http2Stream.this.closeLater(ErrorCode.CANCEL);
        }

        @Override
        protected IOException newTimeoutException(IOException iOException) {
            SocketTimeoutException socketTimeoutException = new SocketTimeoutException(z);
            if (iOException != null) {
                socketTimeoutException.initCause(iOException);
            }
            return socketTimeoutException;
        }

        public void exitAndThrowIfTimedOut() throws IOException {
            if (this.exit()) {
                throw this.newTimeoutException(null);
            }
        }

        /*
         * Handled impossible loop by duplicating code
         * Enabled aggressive block sorting
         */
        static {
            char[] cArray;
            block10: {
                int n2;
                int n3;
                char[] cArray2;
                int n4;
                block9: {
                    char[] cArray3 = "Uk\u0017\u0003ZTv".toCharArray();
                    n4 = 0;
                    int n5 = cArray3.length;
                    cArray2 = cArray3;
                    n3 = n5;
                    if (n5 <= 1) break block9;
                    cArray = cArray2;
                    n2 = n3;
                    if (n3 <= n4) break block10;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n6 = n4;
                    while (true) {
                        int n7;
                        char c2 = cArray4[n6];
                        switch (n4 % 5) {
                            case 0: {
                                n7 = 33;
                                break;
                            }
                            case 1: {
                                n7 = 2;
                                break;
                            }
                            case 2: {
                                n7 = 122;
                                break;
                            }
                            case 3: {
                                n7 = 102;
                                break;
                            }
                            default: {
                                n7 = 53;
                            }
                        }
                        cArray4[n6] = (char)(c2 ^ n7);
                        ++n4;
                        cArray2 = cArray5;
                        n3 = n3;
                        if (n3 != 0) break;
                        cArray5 = cArray2;
                        n2 = n3;
                        n6 = n3;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n2 = n3;
                } while (n3 > n4);
            }
            z = new String(cArray).intern();
        }
    }

    final class FramingSink
    implements Sink {
        private static final long EMIT_BUFFER_SIZE = 16384L;
        private final Buffer sendBuffer = new Buffer();
        boolean closed;
        boolean finished;

        FramingSink() {
        }

        @Override
        public final void write(Buffer buffer, long l2) throws IOException {
            assert (!Thread.holdsLock(Http2Stream.this));
            this.sendBuffer.write(buffer, l2);
            while (this.sendBuffer.size() >= 16384L) {
                this.emitFrame(false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void emitFrame(boolean bl) throws IOException {
            long l2;
            Http2Stream http2Stream = Http2Stream.this;
            synchronized (http2Stream) {
                Http2Stream.this.writeTimeout.enter();
                try {
                    while (Http2Stream.this.bytesLeftInWriteWindow <= 0L && !this.finished && !this.closed && Http2Stream.this.errorCode == null) {
                        Http2Stream.this.waitForIo();
                    }
                }
                finally {
                    Http2Stream.this.writeTimeout.exitAndThrowIfTimedOut();
                }
                Http2Stream.this.checkOutNotClosed();
                l2 = Math.min(Http2Stream.this.bytesLeftInWriteWindow, this.sendBuffer.size());
                Http2Stream.this.bytesLeftInWriteWindow -= l2;
            }
            Http2Stream.this.writeTimeout.enter();
            try {
                Http2Stream.this.connection.writeData(Http2Stream.this.id, bl && l2 == this.sendBuffer.size(), this.sendBuffer, l2);
                return;
            }
            finally {
                Http2Stream.this.writeTimeout.exitAndThrowIfTimedOut();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void flush() throws IOException {
            assert (!Thread.holdsLock(Http2Stream.this));
            Http2Stream http2Stream = Http2Stream.this;
            synchronized (http2Stream) {
                Http2Stream.this.checkOutNotClosed();
            }
            while (this.sendBuffer.size() > 0L) {
                this.emitFrame(false);
                Http2Stream.this.connection.flush();
            }
        }

        @Override
        public final Timeout timeout() {
            return Http2Stream.this.writeTimeout;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void close() throws IOException {
            assert (!Thread.holdsLock(Http2Stream.this));
            Http2Stream http2Stream = Http2Stream.this;
            synchronized (http2Stream) {
                if (this.closed) {
                    return;
                }
            }
            if (!Http2Stream.this.sink.finished) {
                if (this.sendBuffer.size() > 0L) {
                    while (this.sendBuffer.size() > 0L) {
                        this.emitFrame(true);
                    }
                } else {
                    Http2Stream.this.connection.writeData(Http2Stream.this.id, true, null, 0L);
                }
            }
            http2Stream = Http2Stream.this;
            synchronized (http2Stream) {
                this.closed = true;
            }
            Http2Stream.this.connection.flush();
            Http2Stream.this.cancelStreamIfNecessary();
        }
    }

    private final class FramingSource
    implements Source {
        private final Buffer receiveBuffer = new Buffer();
        private final Buffer readBuffer = new Buffer();
        private final long maxByteCount;
        boolean closed;
        boolean finished;
        private static final String[] z;

        FramingSource(long l2) {
            this.maxByteCount = l2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final long read(Buffer buffer, long l2) throws IOException {
            ErrorCode errorCode;
            if (l2 < 0L) {
                throw new IllegalArgumentException(z[0] + l2);
            }
            long l3 = -1L;
            Http2Stream http2Stream = Http2Stream.this;
            synchronized (http2Stream) {
                this.waitUntilReadable();
                if (this.closed) {
                    throw new IOException(z[1]);
                }
                errorCode = Http2Stream.this.errorCode;
                if (this.readBuffer.size() > 0L) {
                    l3 = this.readBuffer.read(buffer, Math.min(l2, this.readBuffer.size()));
                    Http2Stream.this.unacknowledgedBytesRead += l3;
                }
                if (errorCode == null && Http2Stream.this.unacknowledgedBytesRead >= (long)(Http2Stream.this.connection.okHttpSettings.getInitialWindowSize() / 2)) {
                    Http2Stream.this.connection.writeWindowUpdateLater(Http2Stream.this.id, Http2Stream.this.unacknowledgedBytesRead);
                    Http2Stream.this.unacknowledgedBytesRead = 0L;
                }
            }
            if (l3 != -1L) {
                this.updateConnectionFlowControl(l3);
                return l3;
            }
            if (errorCode != null) {
                throw new StreamResetException(errorCode);
            }
            return -1L;
        }

        private void updateConnectionFlowControl(long l2) {
            assert (!Thread.holdsLock(Http2Stream.this));
            Http2Stream.this.connection.updateConnectionFlowControl(l2);
        }

        private void waitUntilReadable() throws IOException {
            Http2Stream.this.readTimeout.enter();
            try {
                while (this.readBuffer.size() == 0L && !this.finished && !this.closed && Http2Stream.this.errorCode == null) {
                    Http2Stream.this.waitForIo();
                }
                return;
            }
            finally {
                Http2Stream.this.readTimeout.exitAndThrowIfTimedOut();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void receive(BufferedSource bufferedSource, long l2) throws IOException {
            assert (!Thread.holdsLock(Http2Stream.this));
            while (l2 > 0L) {
                boolean bl;
                boolean bl2;
                Http2Stream http2Stream = Http2Stream.this;
                synchronized (http2Stream) {
                    bl2 = this.finished;
                    bl = l2 + this.readBuffer.size() > this.maxByteCount;
                }
                if (bl) {
                    bufferedSource.skip(l2);
                    Http2Stream.this.closeLater(ErrorCode.FLOW_CONTROL_ERROR);
                    return;
                }
                if (bl2) {
                    bufferedSource.skip(l2);
                    return;
                }
                long l3 = bufferedSource.read(this.receiveBuffer, l2);
                if (l3 == -1L) {
                    throw new EOFException();
                }
                l2 -= l3;
                Http2Stream http2Stream2 = Http2Stream.this;
                synchronized (http2Stream2) {
                    bl = this.readBuffer.size() == 0L;
                    this.readBuffer.writeAll(this.receiveBuffer);
                    if (bl) {
                        Http2Stream.this.notifyAll();
                    }
                }
            }
        }

        @Override
        public final Timeout timeout() {
            return Http2Stream.this.readTimeout;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void close() throws IOException {
            long l2;
            Http2Stream http2Stream = Http2Stream.this;
            synchronized (http2Stream) {
                this.closed = true;
                l2 = this.readBuffer.size();
                this.readBuffer.clear();
                Http2Stream.this.notifyAll();
            }
            if (l2 > 0L) {
                this.updateConnectionFlowControl(l2);
            }
            Http2Stream.this.cancelStreamIfNecessary();
        }

        /*
         * Handled impossible loop by duplicating code
         * Enabled aggressive block sorting
         */
        static {
            String string;
            String[] stringArray = new String[2];
            String[] stringArray2 = stringArray;
            String[] stringArray3 = stringArray;
            int n2 = 0;
            String string2 = "\u000e\u0013`\u0003\u0003\u0003\u001fz\u0012`PJ$\\`";
            int n3 = -1;
            block9: while (true) {
                char[] cArray;
                block14: {
                    int n4;
                    int n5;
                    char[] cArray2;
                    int n6;
                    block13: {
                        char[] cArray3 = string2.toCharArray();
                        n6 = 0;
                        int n7 = cArray3.length;
                        cArray2 = cArray3;
                        n5 = n7;
                        if (n7 <= 1) break block13;
                        cArray = cArray2;
                        n4 = n5;
                        if (n5 <= n6) break block14;
                    }
                    do {
                        char[] cArray4 = cArray2;
                        char[] cArray5 = cArray2;
                        int n8 = n6;
                        while (true) {
                            int n9;
                            char c2 = cArray4[n8];
                            switch (n6 % 5) {
                                case 0: {
                                    n9 = 108;
                                    break;
                                }
                                case 1: {
                                    n9 = 106;
                                    break;
                                }
                                case 2: {
                                    n9 = 20;
                                    break;
                                }
                                case 3: {
                                    n9 = 102;
                                    break;
                                }
                                default: {
                                    n9 = 64;
                                }
                            }
                            cArray4[n8] = (char)(c2 ^ n9);
                            ++n6;
                            cArray2 = cArray5;
                            n5 = n5;
                            if (n5 != 0) break;
                            cArray5 = cArray2;
                            n4 = n5;
                            n8 = n5;
                            cArray4 = cArray2;
                        }
                        cArray = cArray2;
                        n4 = n5;
                    } while (n5 > n6);
                }
                string = new String(cArray);
                switch (n3) {
                    default: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 1;
                        string2 = "\u001f\u001ef\u0003!\u0001Jw\n/\u001f\u000fp";
                        n3 = 0;
                        continue block9;
                    }
                    case 0: 
                }
                break;
            }
            stringArray2[n2] = string.intern();
            z = stringArray3;
        }
    }
}

