/*
 * Decompiled with CFR 0.152.
 */
package cn.jmessage.support.okhttp3.internal.http2;

import cn.jmessage.support.okhttp3.internal.Util;
import cn.jmessage.support.okhttp3.internal.http2.ErrorCode;
import cn.jmessage.support.okhttp3.internal.http2.Header;
import cn.jmessage.support.okhttp3.internal.http2.Hpack;
import cn.jmessage.support.okhttp3.internal.http2.Http2;
import cn.jmessage.support.okhttp3.internal.http2.Settings;
import cn.jmessage.support.okio.Buffer;
import cn.jmessage.support.okio.BufferedSink;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

final class Http2Writer
implements Closeable {
    private static final Logger logger;
    private final BufferedSink sink;
    private final boolean client;
    private final Buffer hpackBuffer;
    private int maxFrameSize;
    private boolean closed;
    final Hpack.Writer hpackWriter;
    private static final String[] z;

    Http2Writer(BufferedSink bufferedSink, boolean bl) {
        this.sink = bufferedSink;
        this.client = bl;
        this.hpackBuffer = new Buffer();
        this.hpackWriter = new Hpack.Writer(this.hpackBuffer);
        this.maxFrameSize = 16384;
    }

    public final synchronized void connectionPreface() throws IOException {
        if (this.closed) {
            throw new IOException(z[0]);
        }
        if (!this.client) {
            return;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(Util.format(z[3], Http2.CONNECTION_PREFACE.hex()));
        }
        this.sink.write(Http2.CONNECTION_PREFACE.toByteArray());
        this.sink.flush();
    }

    public final synchronized void applyAndAckSettings(Settings settings) throws IOException {
        if (this.closed) {
            throw new IOException(z[0]);
        }
        this.maxFrameSize = settings.getMaxFrameSize(this.maxFrameSize);
        if (settings.getHeaderTableSize() != -1) {
            this.hpackWriter.setHeaderTableSizeSetting(settings.getHeaderTableSize());
        }
        this.frameHeader(0, 0, (byte)4, (byte)1);
        this.sink.flush();
    }

    public final synchronized void pushPromise(int n2, int n3, List<Header> list) throws IOException {
        if (this.closed) {
            throw new IOException(z[0]);
        }
        this.hpackWriter.writeHeaders(list);
        long l2 = this.hpackBuffer.size();
        int n4 = (int)Math.min((long)(this.maxFrameSize - 4), l2);
        byte by = l2 == (long)n4 ? (byte)4 : 0;
        this.frameHeader(n2, n4 + 4, (byte)5, by);
        this.sink.writeInt(n3 & Integer.MAX_VALUE);
        this.sink.write(this.hpackBuffer, (long)n4);
        if (l2 > (long)n4) {
            this.writeContinuationFrames(n2, l2 - (long)n4);
        }
    }

    public final synchronized void flush() throws IOException {
        if (this.closed) {
            throw new IOException(z[0]);
        }
        this.sink.flush();
    }

    public final synchronized void synStream(boolean bl, int n2, int n3, List<Header> list) throws IOException {
        if (this.closed) {
            throw new IOException(z[0]);
        }
        this.headers(bl, n2, list);
    }

    public final synchronized void synReply(boolean bl, int n2, List<Header> list) throws IOException {
        if (this.closed) {
            throw new IOException(z[0]);
        }
        this.headers(bl, n2, list);
    }

    public final synchronized void headers(int n2, List<Header> list) throws IOException {
        if (this.closed) {
            throw new IOException(z[0]);
        }
        this.headers(false, n2, list);
    }

    public final synchronized void rstStream(int n2, ErrorCode errorCode) throws IOException {
        if (this.closed) {
            throw new IOException(z[0]);
        }
        if (errorCode.httpCode == -1) {
            throw new IllegalArgumentException();
        }
        this.frameHeader(n2, 4, (byte)3, (byte)0);
        this.sink.writeInt(errorCode.httpCode);
        this.sink.flush();
    }

    public final int maxDataLength() {
        return this.maxFrameSize;
    }

    public final synchronized void data(boolean bl, int n2, Buffer buffer, int n3) throws IOException {
        if (this.closed) {
            throw new IOException(z[0]);
        }
        byte by = 0;
        if (bl) {
            by = 1;
        }
        this.dataFrame(n2, by, buffer, n3);
    }

    final void dataFrame(int n2, byte by, Buffer buffer, int n3) throws IOException {
        this.frameHeader(n2, n3, (byte)0, by);
        if (n3 > 0) {
            this.sink.write(buffer, (long)n3);
        }
    }

    public final synchronized void settings(Settings settings) throws IOException {
        if (this.closed) {
            throw new IOException(z[0]);
        }
        int n2 = settings.size() * 6;
        this.frameHeader(0, n2, (byte)4, (byte)0);
        for (n2 = 0; n2 < 10; ++n2) {
            if (!settings.isSet(n2)) continue;
            int n3 = n2;
            if (n3 == 4) {
                n3 = 3;
            } else if (n3 == 7) {
                n3 = 4;
            }
            this.sink.writeShort(n3);
            this.sink.writeInt(settings.get(n2));
        }
        this.sink.flush();
    }

    public final synchronized void ping(boolean bl, int n2, int n3) throws IOException {
        if (this.closed) {
            throw new IOException(z[0]);
        }
        bl = bl;
        this.frameHeader(0, 8, (byte)6, bl ? 1 : 0);
        this.sink.writeInt(n2);
        this.sink.writeInt(n3);
        this.sink.flush();
    }

    public final synchronized void goAway(int n2, ErrorCode errorCode, byte[] byArray) throws IOException {
        if (this.closed) {
            throw new IOException(z[0]);
        }
        if (errorCode.httpCode == -1) {
            throw Http2.illegalArgument(z[4], new Object[0]);
        }
        int n3 = 8 + byArray.length;
        this.frameHeader(0, n3, (byte)7, (byte)0);
        this.sink.writeInt(n2);
        this.sink.writeInt(errorCode.httpCode);
        if (byArray.length > 0) {
            this.sink.write(byArray);
        }
        this.sink.flush();
    }

    public final synchronized void windowUpdate(int n2, long l2) throws IOException {
        if (this.closed) {
            throw new IOException(z[0]);
        }
        if (l2 == 0L || l2 > Integer.MAX_VALUE) {
            throw Http2.illegalArgument(z[5], l2);
        }
        this.frameHeader(n2, 4, (byte)8, (byte)0);
        this.sink.writeInt((int)l2);
        this.sink.flush();
    }

    public final void frameHeader(int n2, int n3, byte by, byte by2) throws IOException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(Http2.frameLog(false, n2, n3, by, by2));
        }
        if (n3 > this.maxFrameSize) {
            throw Http2.illegalArgument(z[1], this.maxFrameSize, n3);
        }
        if ((n2 & Integer.MIN_VALUE) != 0) {
            throw Http2.illegalArgument(z[2], n2);
        }
        Http2Writer.writeMedium(this.sink, n3);
        this.sink.writeByte(by & 0xFF);
        this.sink.writeByte(by2 & 0xFF);
        this.sink.writeInt(n2 & Integer.MAX_VALUE);
    }

    @Override
    public final synchronized void close() throws IOException {
        this.closed = true;
        this.sink.close();
    }

    private static void writeMedium(BufferedSink bufferedSink, int n2) throws IOException {
        bufferedSink.writeByte(n2 >>> 16 & 0xFF);
        bufferedSink.writeByte(n2 >>> 8 & 0xFF);
        bufferedSink.writeByte(n2 & 0xFF);
    }

    private void writeContinuationFrames(int n2, long l2) throws IOException {
        while (l2 > 0L) {
            int n3;
            this.frameHeader(n2, n3, (byte)9, (l2 -= (long)(n3 = (int)Math.min((long)this.maxFrameSize, l2))) == 0L ? (byte)4 : 0);
            this.sink.write(this.hpackBuffer, (long)n3);
        }
    }

    final void headers(boolean bl, int n2, List<Header> list) throws IOException {
        byte by;
        if (this.closed) {
            throw new IOException(z[0]);
        }
        this.hpackWriter.writeHeaders(list);
        long l2 = this.hpackBuffer.size();
        int n3 = (int)Math.min((long)this.maxFrameSize, l2);
        byte by2 = by = l2 == (long)n3 ? (byte)4 : 0;
        if (bl) {
            by = (byte)(by | 1);
        }
        this.frameHeader(n2, n3, (byte)1, by);
        this.sink.write(this.hpackBuffer, (long)n3);
        if (l2 > (long)n3) {
            this.writeContinuationFrames(n2, l2 - (long)n3);
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[6];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "wDLlgp";
        int n3 = -1;
        block13: while (true) {
            char[] cArray;
            block18: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block17: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block17;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block18;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 20;
                                break;
                            }
                            case 1: {
                                n9 = 40;
                                break;
                            }
                            case 2: {
                                n9 = 35;
                                break;
                            }
                            case 3: {
                                n9 = 31;
                                break;
                            }
                            default: {
                                n9 = 2;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "RzbRGK{jEGKmqMMF\bOzls\\K?<4\rG%\"1L";
                    n3 = 0;
                    continue block13;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "fMPzpbMG?`}\\\u0003lg`\u0012\u0003:q";
                    n3 = 1;
                    continue block13;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "*\u0016\u0003\\MZff\\V]gm?'g";
                    n3 = 2;
                    continue block13;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "qZQppWGGz,|\\WoA{LF??)\b\u000e.";
                    n3 = 3;
                    continue block13;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "cAM{mc{Jeg]F@mgyMMk\")\u0015\u0003/\"hT\u0003hkzLLhQ}RFVlwZFrgz\\\u0003!\"$P\u0014ydrNEydX\u0012\u0003:q";
                    n3 = 4;
                    continue block13;
                }
                case 4: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
        logger = Logger.getLogger(Http2.class.getName());
    }
}

