/*
 * Decompiled with CFR 0.152.
 */
package cn.jmessage.support.okhttp3.internal.platform;

import android.os.Build;
import android.util.Log;
import cn.jmessage.support.annotation.Nullable;
import cn.jmessage.support.okhttp3.Protocol;
import cn.jmessage.support.okhttp3.internal.Util;
import cn.jmessage.support.okhttp3.internal.platform.OptionalMethod;
import cn.jmessage.support.okhttp3.internal.platform.Platform;
import cn.jmessage.support.okhttp3.internal.tls.CertificateChainCleaner;
import cn.jmessage.support.okhttp3.internal.tls.TrustRootIndex;
import java.io.IOException;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.security.NoSuchAlgorithmException;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;

class AndroidPlatform
extends Platform {
    private static final int MAX_LOG_LENGTH = 4000;
    private final Class<?> sslParametersClass;
    private final OptionalMethod<Socket> setUseSessionTickets;
    private final OptionalMethod<Socket> setHostname;
    private final OptionalMethod<Socket> getAlpnSelectedProtocol;
    private final OptionalMethod<Socket> setAlpnProtocols;
    private final CloseGuard closeGuard = CloseGuard.get();
    private static final String[] z;

    AndroidPlatform(Class<?> clazz, OptionalMethod<Socket> optionalMethod, OptionalMethod<Socket> optionalMethod2, OptionalMethod<Socket> optionalMethod3, OptionalMethod<Socket> optionalMethod4) {
        this.sslParametersClass = clazz;
        this.setUseSessionTickets = optionalMethod;
        this.setHostname = optionalMethod2;
        this.getAlpnSelectedProtocol = optionalMethod3;
        this.setAlpnProtocols = optionalMethod4;
    }

    @Override
    public void connectSocket(Socket object, InetSocketAddress serializable, int n2) throws IOException {
        try {
            ((Socket)object).connect((SocketAddress)serializable, n2);
            return;
        }
        catch (AssertionError assertionError) {
            object = assertionError;
            if (Util.isAndroidGetsocknameError(assertionError)) {
                throw new IOException((Throwable)object);
            }
            throw object;
        }
        catch (SecurityException securityException) {
            serializable = new IOException(z[17]);
            ((Throwable)serializable).initCause(securityException);
            throw serializable;
        }
        catch (ClassCastException classCastException) {
            if (Build.VERSION.SDK_INT == 26) {
                serializable = new IOException(z[17]);
                ((Throwable)serializable).initCause(classCastException);
                throw serializable;
            }
            throw classCastException;
        }
    }

    @Override
    protected X509TrustManager trustManager(SSLSocketFactory sSLSocketFactory) {
        Object object;
        Object object2 = AndroidPlatform.readFieldOrNull(sSLSocketFactory, this.sslParametersClass, z[1]);
        if (object2 == null) {
            try {
                object = Class.forName(z[2], false, sSLSocketFactory.getClass().getClassLoader());
                object2 = AndroidPlatform.readFieldOrNull(sSLSocketFactory, object, z[1]);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return super.trustManager(sSLSocketFactory);
            }
        }
        if ((object = AndroidPlatform.readFieldOrNull(object2, X509TrustManager.class, z[3])) != null) {
            return object;
        }
        return AndroidPlatform.readFieldOrNull(object2, X509TrustManager.class, z[4]);
    }

    @Override
    public void configureTlsExtensions(SSLSocket sSLSocket, String objectArray, List<Protocol> list) {
        if (objectArray != null) {
            this.setUseSessionTickets.invokeOptionalWithoutCheckedException(sSLSocket, true);
            this.setHostname.invokeOptionalWithoutCheckedException(sSLSocket, new Object[]{objectArray});
        }
        if (this.setAlpnProtocols != null && this.setAlpnProtocols.isSupported(sSLSocket)) {
            objectArray = new Object[]{AndroidPlatform.concatLengthPrefixed(list)};
            this.setAlpnProtocols.invokeWithoutCheckedException(sSLSocket, objectArray);
        }
    }

    @Override
    @Nullable
    public String getSelectedProtocol(SSLSocket object) {
        if (this.getAlpnSelectedProtocol == null) {
            return null;
        }
        if (!this.getAlpnSelectedProtocol.isSupported((Socket)object)) {
            return null;
        }
        byte[] byArray = (byte[])this.getAlpnSelectedProtocol.invokeWithoutCheckedException((Socket)object, new Object[0]);
        object = byArray;
        if (byArray != null) {
            return new String((byte[])object, Util.UTF_8);
        }
        return null;
    }

    @Override
    public void log(int n2, String string, Throwable throwable) {
        int n3 = n2 = n2 == 5 ? 5 : 3;
        if (throwable != null) {
            string = string + '\n' + Log.getStackTraceString((Throwable)throwable);
        }
        int n4 = string.length();
        for (int i2 = 0; i2 < n4; ++i2) {
            int n5;
            int n6 = string.indexOf(10, i2);
            n6 = n6 != -1 ? n6 : n4;
            do {
                n5 = Math.min(n6, i2 + 4000);
                Log.println((int)n2, (String)z[10], (String)string.substring(i2, n5));
            } while ((i2 = n5) < n6);
        }
    }

    @Override
    public Object getStackTraceForCloseable(String string) {
        return this.closeGuard.createAndOpen(string);
    }

    @Override
    public void logCloseableLeak(String string, Object object) {
        if (!this.closeGuard.warnIfOpen(object)) {
            this.log(5, string, null);
        }
    }

    @Override
    public boolean isCleartextTrafficPermitted(String string) {
        try {
            Class<?> clazz = Class.forName(z[9]);
            Object object = clazz.getMethod(z[7], new Class[0]).invoke(null, new Object[0]);
            return this.api24IsCleartextTrafficPermitted(string, clazz, object);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return super.isCleartextTrafficPermitted(string);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return super.isCleartextTrafficPermitted(string);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
            throw Util.assertionError(z[8], exception);
        }
    }

    private boolean api24IsCleartextTrafficPermitted(String string, Class<?> clazz, Object object) throws InvocationTargetException, IllegalAccessException {
        try {
            return (Boolean)clazz.getMethod(z[14], String.class).invoke(object, string);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return this.api23IsCleartextTrafficPermitted(string, clazz, object);
        }
    }

    private boolean api23IsCleartextTrafficPermitted(String string, Class<?> clazz, Object object) throws InvocationTargetException, IllegalAccessException {
        try {
            return (Boolean)clazz.getMethod(z[14], new Class[0]).invoke(object, new Object[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return super.isCleartextTrafficPermitted(string);
        }
    }

    private static boolean supportsAlpn() {
        if (Security.getProvider(z[15]) != null) {
            return true;
        }
        try {
            Class.forName(z[16]);
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    @Override
    public CertificateChainCleaner buildCertificateChainCleaner(X509TrustManager x509TrustManager) {
        try {
            GenericDeclaration genericDeclaration = Class.forName(z[5]);
            Object obj = genericDeclaration.getConstructor(X509TrustManager.class).newInstance(x509TrustManager);
            genericDeclaration = genericDeclaration.getMethod(z[6], X509Certificate[].class, String.class, String.class);
            return new AndroidCertificateChainCleaner(obj, (Method)genericDeclaration);
        }
        catch (Exception exception) {
            return super.buildCertificateChainCleaner(x509TrustManager);
        }
    }

    public static Platform buildIfSupported() {
        try {
            Class<?> clazz;
            try {
                clazz = Class.forName(z[21]);
            }
            catch (ClassNotFoundException classNotFoundException) {
                clazz = Class.forName(z[18]);
            }
            OptionalMethod<Socket> optionalMethod = new OptionalMethod<Socket>(null, z[22], Boolean.TYPE);
            OptionalMethod<Socket> optionalMethod2 = new OptionalMethod<Socket>(null, z[23], String.class);
            OptionalMethod optionalMethod3 = null;
            OptionalMethod optionalMethod4 = null;
            if (AndroidPlatform.supportsAlpn()) {
                optionalMethod3 = new OptionalMethod(byte[].class, z[20], new Class[0]);
                optionalMethod4 = new OptionalMethod(null, z[19], byte[].class);
            }
            return new AndroidPlatform(clazz, optionalMethod, optionalMethod2, optionalMethod3, optionalMethod4);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    @Override
    public TrustRootIndex buildTrustRootIndex(X509TrustManager x509TrustManager) {
        try {
            Method method = x509TrustManager.getClass().getDeclaredMethod(z[0], X509Certificate.class);
            method.setAccessible(true);
            return new AndroidTrustRootIndex(x509TrustManager, method);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return super.buildTrustRootIndex(x509TrustManager);
        }
    }

    @Override
    public SSLContext getSSLContext() {
        if (Build.VERSION.SDK_INT >= 16 && Build.VERSION.SDK_INT < 22) {
            try {
                return SSLContext.getInstance(z[12]);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
        }
        try {
            return SSLContext.getInstance(z[11]);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalStateException(z[13], noSuchAlgorithmException);
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[24];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "}\u0019x\u0003=i\u0005e\u0013(u\u0013~\b\u001bY\t_\u0014\u001an\u0015d&\u0007\u007f#\u007f\u0000\u0007z\u0004c\u0015\f";
        int n3 = -1;
        block31: while (true) {
            char[] cArray;
            block36: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block35: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block35;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block36;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 27;
                                break;
                            }
                            case 1: {
                                n9 = 112;
                                break;
                            }
                            case 2: {
                                n9 = 22;
                                break;
                            }
                            case 3: {
                                n9 = 103;
                                break;
                            }
                            default: {
                                n9 = 105;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "h\u0003z7\bi\u0011{\u0002\u001d~\u0002e";
                    n3 = 0;
                    continue block31;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "x\u001f{I\u000et\u001fq\u000b\f5\u0011x\u0003\u001bt\u0019rI\u000ev\u00038\b\u001b|^u\b\u0007h\u0013d\u001e\u0019o^E4%K\u0011d\u0006\u0004~\u0004s\u0015\u001aR\u001df\u000b";
                    n3 = 1;
                    continue block31;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "cE&^=i\u0005e\u0013$z\u001ew\u0000\fi";
                    n3 = 2;
                    continue block31;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "o\u0002c\u0014\u001dV\u0011x\u0006\u000e~\u0002";
                    n3 = 3;
                    continue block31;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "z\u001er\u0015\u0006r\u00148\t\fo^~\u0013\u001dk^NRY\"$d\u0012\u001ao=w\t\b|\u0015d\"\u0011o\u0015x\u0014\u0000t\u001ee";
                    n3 = 4;
                    continue block31;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "x\u0018s\u0004\u0002H\u0015d\u0011\fi$d\u0012\u001ao\u0015r";
                    n3 = 5;
                    continue block31;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "|\u0015b.\u0007h\u0004w\t\n~";
                    n3 = 6;
                    continue block31;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = "n\u001ew\u0005\u0005~Pb\bI\u007f\u0015b\u0002\u001bv\u0019x\u0002Ix\u001cs\u0006\u001bo\u0015n\u0013Ih\u0005f\u0017\u0006i\u0004";
                    n3 = 7;
                    continue block31;
                }
                case 7: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 9;
                    string2 = "z\u001er\u0015\u0006r\u00148\u0014\fx\u0005d\u000e\u001db^X\u0002\u001dl\u001fd\f:~\u0013c\u0015\u0000o\tF\b\u0005r\u0013o";
                    n3 = 8;
                    continue block31;
                }
                case 8: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 10;
                    string2 = "T\u001b^\u0013\u001dk";
                    n3 = 9;
                    continue block31;
                }
                case 9: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 11;
                    string2 = "O<E";
                    n3 = 10;
                    continue block31;
                }
                case 10: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 12;
                    string2 = "O<E\u0011X5B";
                    n3 = 11;
                    continue block31;
                }
                case 11: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 13;
                    string2 = "U\u001f63%HPf\u0015\u0006m\u0019r\u0002\u001b";
                    n3 = 12;
                    continue block31;
                }
                case 12: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 14;
                    string2 = "r\u0003U\u000b\fz\u0002b\u0002\u0011o$d\u0006\u000f}\u0019u7\fi\u001d\u007f\u0013\u001d~\u0014";
                    n3 = 13;
                    continue block31;
                }
                case 13: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 15;
                    string2 = "\\=E$\u0006i\u0015I(\u0019~\u001eE4%";
                    n3 = 14;
                    continue block31;
                }
                case 14: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 16;
                    string2 = "z\u001er\u0015\u0006r\u00148\t\fo^X\u0002\u001dl\u001fd\f";
                    n3 = 15;
                    continue block31;
                }
                case 15: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 17;
                    string2 = "^\bu\u0002\u0019o\u0019y\tIr\u001e6\u0004\u0006u\u001es\u0004\u001d";
                    n3 = 16;
                    continue block31;
                }
                case 16: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 18;
                    string2 = "t\u0002qI\bk\u0011u\u000f\f5\u0018w\u0015\u0004t\u001eoI\u0011u\u0015bI\u0019i\u001f`\u000e\r~\u00028\r\u001ah\u001584:W w\u0015\bv\u0015b\u0002\u001bh9{\u0017\u0005";
                    n3 = 17;
                    continue block31;
                }
                case 17: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 19;
                    string2 = "h\u0015b&\u0005k\u001eF\u0015\u0006o\u001fu\b\u0005h";
                    n3 = 18;
                    continue block31;
                }
                case 18: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 20;
                    string2 = "|\u0015b&\u0005k\u001eE\u0002\u0005~\u0013b\u0002\rK\u0002y\u0013\u0006x\u001fz";
                    n3 = 19;
                    continue block31;
                }
                case 19: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 21;
                    string2 = "x\u001f{I\bu\u0014d\b\u0000\u007f^y\u0015\u000e5\u0013y\t\u001ax\u0002o\u0017\u001d5#E+9z\u0002w\n\fo\u0015d\u0014 v\u0000z";
                    n3 = 20;
                    continue block31;
                }
                case 20: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 22;
                    string2 = "h\u0015b2\u001a~#s\u0014\u001ar\u001fx3\u0000x\u001bs\u0013\u001a";
                    n3 = 21;
                    continue block31;
                }
                case 21: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 23;
                    string2 = "h\u0015b/\u0006h\u0004x\u0006\u0004~";
                    n3 = 22;
                    continue block31;
                }
                case 22: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }

    static final class AndroidTrustRootIndex
    implements TrustRootIndex {
        private final X509TrustManager trustManager;
        private final Method findByIssuerAndSignatureMethod;
        private static final String z;

        AndroidTrustRootIndex(X509TrustManager x509TrustManager, Method method) {
            this.findByIssuerAndSignatureMethod = method;
            this.trustManager = x509TrustManager;
        }

        @Override
        public final X509Certificate findByIssuerAndSignature(X509Certificate object) {
            try {
                object = (TrustAnchor)this.findByIssuerAndSignatureMethod.invoke((Object)this.trustManager, object);
                if (object != null) {
                    return ((TrustAnchor)object).getTrustedCert();
                }
                return null;
            }
            catch (IllegalAccessException illegalAccessException) {
                throw Util.assertionError(z, illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                return null;
            }
        }

        public final boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof AndroidTrustRootIndex)) {
                return false;
            }
            object = (AndroidTrustRootIndex)object;
            return this.trustManager.equals(((AndroidTrustRootIndex)object).trustManager) && this.findByIssuerAndSignatureMethod.equals(((AndroidTrustRootIndex)object).findByIssuerAndSignatureMethod);
        }

        public final int hashCode() {
            return this.trustManager.hashCode() + 31 * this.findByIssuerAndSignatureMethod.hashCode();
        }

        /*
         * Handled impossible loop by duplicating code
         * Enabled aggressive block sorting
         */
        static {
            char[] cArray;
            block10: {
                int n2;
                int n3;
                char[] cArray2;
                int n4;
                block9: {
                    char[] cArray3 = "3\bN\tj#F[\u0004&!\u0003[Ko5\u0015Z\u000euf\u0007A\u000f&5\u000fH\u0005g2\u0013]\u000e".toCharArray();
                    n4 = 0;
                    int n5 = cArray3.length;
                    cArray2 = cArray3;
                    n3 = n5;
                    if (n5 <= 1) break block9;
                    cArray = cArray2;
                    n2 = n3;
                    if (n3 <= n4) break block10;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n6 = n4;
                    while (true) {
                        int n7;
                        char c2 = cArray4[n6];
                        switch (n4 % 5) {
                            case 0: {
                                n7 = 70;
                                break;
                            }
                            case 1: {
                                n7 = 102;
                                break;
                            }
                            case 2: {
                                n7 = 47;
                                break;
                            }
                            case 3: {
                                n7 = 107;
                                break;
                            }
                            default: {
                                n7 = 6;
                            }
                        }
                        cArray4[n6] = (char)(c2 ^ n7);
                        ++n4;
                        cArray2 = cArray5;
                        n3 = n3;
                        if (n3 != 0) break;
                        cArray5 = cArray2;
                        n2 = n3;
                        n6 = n3;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n2 = n3;
                } while (n3 > n4);
            }
            z = new String(cArray).intern();
        }
    }

    static final class CloseGuard {
        private final Method getMethod;
        private final Method openMethod;
        private final Method warnIfOpenMethod;
        private static final String[] z;

        CloseGuard(Method method, Method method2, Method method3) {
            this.getMethod = method;
            this.openMethod = method2;
            this.warnIfOpenMethod = method3;
        }

        final Object createAndOpen(String string) {
            if (this.getMethod != null) {
                try {
                    Object object = this.getMethod.invoke(null, new Object[0]);
                    this.openMethod.invoke(object, string);
                    return object;
                }
                catch (Exception exception) {}
            }
            return null;
        }

        final boolean warnIfOpen(Object object) {
            boolean bl = false;
            if (object != null) {
                try {
                    this.warnIfOpenMethod.invoke(object, new Object[0]);
                    bl = true;
                }
                catch (Exception exception) {}
            }
            return bl;
        }

        static CloseGuard get() {
            Method method;
            Method method2;
            GenericDeclaration genericDeclaration;
            try {
                genericDeclaration = Class.forName(z[3]);
                method2 = genericDeclaration.getMethod(z[0], new Class[0]);
                method = genericDeclaration.getMethod(z[1], String.class);
                genericDeclaration = genericDeclaration.getMethod(z[2], new Class[0]);
            }
            catch (Exception exception) {
                method2 = null;
                method = null;
                genericDeclaration = null;
            }
            return new CloseGuard(method2, method, (Method)genericDeclaration);
        }

        /*
         * Handled impossible loop by duplicating code
         * Enabled aggressive block sorting
         */
        static {
            String string;
            String[] stringArray = new String[4];
            String[] stringArray2 = stringArray;
            String[] stringArray3 = stringArray;
            int n2 = 0;
            String string2 = "O35";
            int n3 = -1;
            block11: while (true) {
                char[] cArray;
                block16: {
                    int n4;
                    int n5;
                    char[] cArray2;
                    int n6;
                    block15: {
                        char[] cArray3 = string2.toCharArray();
                        n6 = 0;
                        int n7 = cArray3.length;
                        cArray2 = cArray3;
                        n5 = n7;
                        if (n7 <= 1) break block15;
                        cArray = cArray2;
                        n4 = n5;
                        if (n5 <= n6) break block16;
                    }
                    do {
                        char[] cArray4 = cArray2;
                        char[] cArray5 = cArray2;
                        int n8 = n6;
                        while (true) {
                            int n9;
                            char c2 = cArray4[n8];
                            switch (n6 % 5) {
                                case 0: {
                                    n9 = 40;
                                    break;
                                }
                                case 1: {
                                    n9 = 86;
                                    break;
                                }
                                case 2: {
                                    n9 = 65;
                                    break;
                                }
                                case 3: {
                                    n9 = 103;
                                    break;
                                }
                                default: {
                                    n9 = 122;
                                }
                            }
                            cArray4[n8] = (char)(c2 ^ n9);
                            ++n6;
                            cArray2 = cArray5;
                            n5 = n5;
                            if (n5 != 0) break;
                            cArray5 = cArray2;
                            n4 = n5;
                            n8 = n5;
                            cArray4 = cArray2;
                        }
                        cArray = cArray2;
                        n4 = n5;
                    } while (n5 > n6);
                }
                string = new String(cArray);
                switch (n3) {
                    default: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 1;
                        string2 = "G&$\t";
                        n3 = 0;
                        continue block11;
                    }
                    case 0: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 2;
                        string2 = "_73\t3N\u00191\u0002\u0014";
                        n3 = 1;
                        continue block11;
                    }
                    case 1: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 3;
                        string2 = "L7-\u0011\u0013Cx2\u001e\t\\3,I9D92\u0002=]73\u0003";
                        n3 = 2;
                        continue block11;
                    }
                    case 2: 
                }
                break;
            }
            stringArray2[n2] = string.intern();
            z = stringArray3;
        }
    }

    static final class AndroidCertificateChainCleaner
    extends CertificateChainCleaner {
        private final Object x509TrustManagerExtensions;
        private final Method checkServerTrusted;
        private static final String z;

        AndroidCertificateChainCleaner(Object object, Method method) {
            this.x509TrustManagerExtensions = object;
            this.checkServerTrusted = method;
        }

        @Override
        public final List<Certificate> clean(List<Certificate> x509CertificateArray, String object) throws SSLPeerUnverifiedException {
            try {
                x509CertificateArray = x509CertificateArray.toArray(new X509Certificate[x509CertificateArray.size()]);
                return (List)this.checkServerTrusted.invoke(this.x509TrustManagerExtensions, x509CertificateArray, z, object);
            }
            catch (InvocationTargetException invocationTargetException) {
                object = new SSLPeerUnverifiedException(invocationTargetException.getMessage());
                ((Throwable)object).initCause(invocationTargetException);
                throw object;
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new AssertionError((Object)illegalAccessException);
            }
        }

        public final boolean equals(Object object) {
            return object instanceof AndroidCertificateChainCleaner;
        }

        public final int hashCode() {
            return 0;
        }

        /*
         * Handled impossible loop by duplicating code
         * Enabled aggressive block sorting
         */
        static {
            char[] cArray;
            block10: {
                int n2;
                int n3;
                char[] cArray2;
                int n4;
                block9: {
                    char[] cArray3 = "ye_".toCharArray();
                    n4 = 0;
                    int n5 = cArray3.length;
                    cArray2 = cArray3;
                    n3 = n5;
                    if (n5 <= 1) break block9;
                    cArray = cArray2;
                    n2 = n3;
                    if (n3 <= n4) break block10;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n6 = n4;
                    while (true) {
                        int n7;
                        char c2 = cArray4[n6];
                        switch (n4 % 5) {
                            case 0: {
                                n7 = 43;
                                break;
                            }
                            case 1: {
                                n7 = 54;
                                break;
                            }
                            case 2: {
                                n7 = 30;
                                break;
                            }
                            case 3: {
                                n7 = 107;
                                break;
                            }
                            default: {
                                n7 = 27;
                            }
                        }
                        cArray4[n6] = (char)(c2 ^ n7);
                        ++n4;
                        cArray2 = cArray5;
                        n3 = n3;
                        if (n3 != 0) break;
                        cArray5 = cArray2;
                        n2 = n3;
                        n6 = n3;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n2 = n3;
                } while (n3 > n4);
            }
            z = new String(cArray).intern();
        }
    }
}

