/*
 * Decompiled with CFR 0.152.
 */
package cn.jmessage.support.okhttp3.internal.platform;

import cn.jmessage.support.annotation.Nullable;
import cn.jmessage.support.okhttp3.OkHttpClient;
import cn.jmessage.support.okhttp3.Protocol;
import cn.jmessage.support.okhttp3.internal.platform.AndroidPlatform;
import cn.jmessage.support.okhttp3.internal.platform.Jdk9Platform;
import cn.jmessage.support.okhttp3.internal.platform.JdkWithJettyBootPlatform;
import cn.jmessage.support.okhttp3.internal.tls.BasicCertificateChainCleaner;
import cn.jmessage.support.okhttp3.internal.tls.BasicTrustRootIndex;
import cn.jmessage.support.okhttp3.internal.tls.CertificateChainCleaner;
import cn.jmessage.support.okhttp3.internal.tls.TrustRootIndex;
import cn.jmessage.support.okio.Buffer;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.NoSuchAlgorithmException;
import java.security.Security;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;

public class Platform {
    private static final Platform PLATFORM;
    public static final int INFO = 4;
    public static final int WARN = 5;
    private static final Logger logger;
    private static final String[] z;

    public static Platform get() {
        return PLATFORM;
    }

    public String getPrefix() {
        return z[1];
    }

    protected X509TrustManager trustManager(SSLSocketFactory sSLSocketFactory) {
        try {
            Class<?> clazz = Class.forName(z[15]);
            sSLSocketFactory = Platform.readFieldOrNull(sSLSocketFactory, clazz, z[14]);
            if (sSLSocketFactory == null) {
                return null;
            }
            return Platform.readFieldOrNull(sSLSocketFactory, X509TrustManager.class, z[13]);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public void configureTlsExtensions(SSLSocket sSLSocket, String string, List<Protocol> list) {
    }

    public void afterHandshake(SSLSocket sSLSocket) {
    }

    @Nullable
    public String getSelectedProtocol(SSLSocket sSLSocket) {
        return null;
    }

    public void connectSocket(Socket socket, InetSocketAddress inetSocketAddress, int n2) throws IOException {
        socket.connect(inetSocketAddress, n2);
    }

    public void log(int n2, String string, Throwable throwable) {
        Level level = n2 == 5 ? Level.WARNING : Level.INFO;
        logger.log(level, string, throwable);
    }

    public boolean isCleartextTrafficPermitted(String string) {
        return true;
    }

    public Object getStackTraceForCloseable(String string) {
        if (logger.isLoggable(Level.FINE)) {
            return new Throwable(string);
        }
        return null;
    }

    public void logCloseableLeak(String string, Object object) {
        if (object == null) {
            string = string + z[0];
        }
        this.log(5, string, (Throwable)object);
    }

    public static List<String> alpnProtocolNames(List<Protocol> list) {
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Protocol protocol = list.get(i2);
            if (protocol == Protocol.HTTP_1_0) continue;
            arrayList.add(protocol.toString());
        }
        return arrayList;
    }

    public CertificateChainCleaner buildCertificateChainCleaner(X509TrustManager x509TrustManager) {
        return new BasicCertificateChainCleaner(this.buildTrustRootIndex(x509TrustManager));
    }

    public CertificateChainCleaner buildCertificateChainCleaner(SSLSocketFactory sSLSocketFactory) {
        X509TrustManager x509TrustManager = this.trustManager(sSLSocketFactory);
        if (x509TrustManager == null) {
            throw new IllegalStateException(z[8] + Platform.get() + z[7] + sSLSocketFactory.getClass());
        }
        return this.buildCertificateChainCleaner(x509TrustManager);
    }

    public static boolean isConscryptPreferred() {
        if (z[12].equals(System.getProperty(z[11]))) {
            return true;
        }
        String string = Security.getProviders()[0].getName();
        return z[10].equals(string);
    }

    private static Platform findPlatform() {
        Platform platform = AndroidPlatform.buildIfSupported();
        if (platform != null) {
            return platform;
        }
        platform = Jdk9Platform.buildIfSupported();
        if (platform != null) {
            return platform;
        }
        platform = JdkWithJettyBootPlatform.buildIfSupported();
        if (platform != null) {
            return platform;
        }
        return new Platform();
    }

    static byte[] concatLengthPrefixed(List<Protocol> list) {
        Buffer buffer = new Buffer();
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Protocol protocol = list.get(i2);
            if (protocol == Protocol.HTTP_1_0) continue;
            buffer.writeByte(protocol.toString().length());
            buffer.writeUtf8(protocol.toString());
        }
        return buffer.readByteArray();
    }

    static <T> T readFieldOrNull(Object object, Class<T> clazz, String string) {
        while (true) {
            Object object2;
            for (object2 = object.getClass(); object2 != Object.class; object2 = ((Class)object2).getSuperclass()) {
                try {
                    Object object3 = ((Class)object2).getDeclaredField(string);
                    ((Field)object3).setAccessible(true);
                    object3 = ((Field)object3).get(object);
                    if (object3 == null || !clazz.isInstance(object3)) {
                        return null;
                    }
                    return clazz.cast(object3);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    continue;
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new AssertionError();
                }
            }
            if (string.equals(z[9]) || (object2 = Platform.readFieldOrNull(object, Object.class, z[9])) == null) break;
            object = object2;
        }
        return null;
    }

    public SSLContext getSSLContext() {
        String string = System.getProperty(z[3]);
        if (z[6].equals(string)) {
            try {
                return SSLContext.getInstance(z[4]);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
        }
        try {
            return SSLContext.getInstance(z[2]);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalStateException(z[5], noSuchAlgorithmException);
        }
    }

    public TrustRootIndex buildTrustRootIndex(X509TrustManager x509TrustManager) {
        return new BasicTrustRootIndex(x509TrustManager.getAcceptedIssuers());
    }

    public void configureSslSocketFactory(SSLSocketFactory sSLSocketFactory) {
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[16];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "+yj\u0019\u001cnH%N\u0007n_`\u0019\u001bcDv\u0019\u0018j^%X\u0003gBfX\u001bnI)\u0019\u001cnY%M\u0007n\rJR'\u007fYuz\u0003bHkMOgBb^\ny\ri\\\u0019nA%M\u0000+kLw*1\rIV\blHw\u0017\bnYIV\blHw\u0011 `eqM\u001fHAl\\\u0001\u007f\u0003fU\u000ex^+^\n\u007fcdT\n#\u0004,\u0017\u001cnYI\\\u0019nA-u\n}Hi\u0017)Bc@\u0010T";
        int n3 = -1;
        block23: while (true) {
            char[] cArray;
            block28: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block27: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block27;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block28;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 11;
                                break;
                            }
                            case 1: {
                                n9 = 45;
                                break;
                            }
                            case 2: {
                                n9 = 5;
                                break;
                            }
                            case 3: {
                                n9 = 57;
                                break;
                            }
                            default: {
                                n9 = 111;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "DFMM\u001b{";
                    n3 = 0;
                    continue block23;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "_aV";
                    n3 = 1;
                    continue block23;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "aLsXAx]`Z\u0006mDfX\u001bbBk\u0017\u0019n_vP\u0000e";
                    n3 = 2;
                    continue block23;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "_aVO^%\u001f";
                    n3 = 3;
                    continue block23;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "EB%m#X\ruK\u0000}Da\\\u001d";
                    n3 = 4;
                    continue block23;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = ":\u00032";
                    n3 = 5;
                    continue block23;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "'\rvJ\u0003XBfR\n\u007fkdZ\u001bd_|\u0019\u0006x\r";
                    n3 = 6;
                    continue block23;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = "^Cd[\u0003n\rqVOnUqK\u000ehY%M\u0007n\rqK\u001axY%T\u000eeLb\\\u001d+Bk\u0019";
                    n3 = 7;
                    continue block23;
                }
                case 7: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 9;
                    string2 = "oHi\\\bjY`";
                    n3 = 8;
                    continue block23;
                }
                case 8: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 10;
                    string2 = "HBkJ\fyTuM";
                    n3 = 9;
                    continue block23;
                }
                case 9: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 11;
                    string2 = "dFmM\u001b{\u0003uU\u000e\u007fKjK\u0002";
                    n3 = 10;
                    continue block23;
                }
                case 10: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 12;
                    string2 = "hBkJ\fyTuM";
                    n3 = 11;
                    continue block23;
                }
                case 11: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 13;
                    string2 = "\u007f_pJ\u001bFLkX\bn_";
                    n3 = 12;
                    continue block23;
                }
                case 12: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 14;
                    string2 = "hBkM\nsY";
                    n3 = 13;
                    continue block23;
                }
                case 13: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 15;
                    string2 = "xXk\u0017\u001cnNpK\u0006\u007fT+J\u001cg\u0003Vj#HBkM\nsYLT\u001fg";
                    n3 = 14;
                    continue block23;
                }
                case 14: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
        PLATFORM = Platform.findPlatform();
        logger = Logger.getLogger(OkHttpClient.class.getName());
    }
}

