/*
 * Decompiled with CFR 0.152.
 */
package cn.jmessage.support.okhttp3.internal.publicsuffix;

import cn.jmessage.support.okhttp3.internal.Util;
import cn.jmessage.support.okhttp3.internal.platform.Platform;
import cn.jmessage.support.okio.GzipSource;
import cn.jmessage.support.okio.Okio;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.IDN;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;

public final class PublicSuffixDatabase {
    public static final String PUBLIC_SUFFIX_RESOURCE;
    private static final byte[] WILDCARD_LABEL;
    private static final String[] EMPTY_RULE;
    private static final String[] PREVAILING_RULE;
    private static final byte EXCEPTION_MARKER = 33;
    private static final PublicSuffixDatabase instance;
    private final AtomicBoolean listRead = new AtomicBoolean(false);
    private final CountDownLatch readCompleteLatch = new CountDownLatch(1);
    private byte[] publicSuffixListBytes;
    private byte[] publicSuffixExceptionListBytes;
    private static final String[] z;

    public static PublicSuffixDatabase get() {
        return instance;
    }

    public final String getEffectiveTldPlusOne(String stringArray) {
        Object object;
        if (stringArray == null) {
            throw new NullPointerException(z[1]);
        }
        String[] stringArray2 = IDN.toUnicode((String)stringArray).split(z[0]);
        if (stringArray2.length == ((String[])(object = this.findMatchingRule(stringArray2))).length && object[0].charAt(0) != '!') {
            return null;
        }
        int n2 = object[0].charAt(0) == '!' ? stringArray2.length - ((String[])object).length : stringArray2.length - (((String[])object).length + 1);
        object = new StringBuilder();
        stringArray = stringArray.split(z[0]);
        while (n2 < stringArray.length) {
            ((StringBuilder)object).append(stringArray[n2]).append('.');
            ++n2;
        }
        ((StringBuilder)object).deleteCharAt(((StringBuilder)object).length() - 1);
        return ((StringBuilder)object).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] findMatchingRule(String[] stringArray) {
        Object object;
        int n2;
        Object object2;
        if (!this.listRead.get() && this.listRead.compareAndSet(false, true)) {
            this.readTheListUninterruptibly();
        } else {
            try {
                this.readCompleteLatch.await();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
        Object object3 = this;
        synchronized (object3) {
            if (this.publicSuffixListBytes == null) {
                throw new IllegalStateException(z[3]);
            }
        }
        object3 = new byte[stringArray.length][];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            object3[i2] = stringArray[i2].getBytes(Util.UTF_8);
        }
        String string = null;
        for (int i3 = 0; i3 < ((Object)object3).length; ++i3) {
            object2 = PublicSuffixDatabase.binarySearchBytes(this.publicSuffixListBytes, (byte[][])object3, i3);
            if (object2 == null) continue;
            string = object2;
            break;
        }
        Object object4 = null;
        if (((Object)object3).length > 1) {
            object2 = (byte[][])object3.clone();
            for (n2 = 0; n2 < ((Object)object2).length - 1; ++n2) {
                object2[n2] = WILDCARD_LABEL;
                object = PublicSuffixDatabase.binarySearchBytes(this.publicSuffixListBytes, (byte[][])object2, n2);
                if (object == null) continue;
                object4 = object;
                break;
            }
        }
        object2 = null;
        if (object4 != null) {
            for (n2 = 0; n2 < ((Object)object3).length - 1; ++n2) {
                object = PublicSuffixDatabase.binarySearchBytes(this.publicSuffixExceptionListBytes, (byte[][])object3, n2);
                if (object == null) continue;
                object2 = object;
                break;
            }
        }
        if (object2 != null) {
            return ("!" + (String)object2).split(z[0]);
        }
        if (string == null && object4 == null) {
            return PREVAILING_RULE;
        }
        String[] stringArray2 = string != null ? string.split(z[0]) : EMPTY_RULE;
        String[] stringArray3 = object = object4 != null ? object4.split(z[0]) : EMPTY_RULE;
        if (stringArray2.length > ((String[])object).length) {
            return stringArray2;
        }
        return object;
    }

    private static String binarySearchBytes(byte[] byArray, byte[][] byArray2, int n2) {
        int n3 = 0;
        int n4 = byArray.length;
        String string = null;
        while (n3 < n4) {
            int n5;
            int n6;
            int n7;
            for (n7 = (n3 + n4) / 2; n7 >= 0 && byArray[n7] != 10; --n7) {
            }
            ++n7;
            int n8 = 1;
            while (byArray[n7 + n8] != 10) {
                ++n8;
            }
            int n9 = n7 + n8 - n7;
            int n10 = n2;
            int n11 = 0;
            int n12 = 0;
            boolean bl = false;
            while (true) {
                if (bl) {
                    n6 = 46;
                    bl = false;
                } else {
                    n6 = byArray2[n10][n11] & 0xFF;
                }
                n5 = byArray[n7 + n12] & 0xFF;
                if ((n6 -= n5) != 0) break;
                ++n11;
                if (++n12 == n9) break;
                if (byArray2[n10].length != n11) continue;
                if (n10 == byArray2.length - 1) break;
                ++n10;
                n11 = -1;
                bl = true;
            }
            if (n6 < 0) {
                n4 = n7 - 1;
                continue;
            }
            if (n6 > 0) {
                n3 = n7 + n8 + 1;
                continue;
            }
            n6 = n9 - n12;
            n5 = byArray2[n10].length - n11;
            ++n10;
            while (n10 < byArray2.length) {
                n5 += byArray2[n10].length;
                ++n10;
            }
            if (n5 < n6) {
                n4 = n7 - 1;
                continue;
            }
            if (n5 > n6) {
                n3 = n7 + n8 + 1;
                continue;
            }
            string = new String(byArray, n7, n9, Util.UTF_8);
            break;
        }
        return string;
    }

    private void readTheListUninterruptibly() {
        boolean bl = false;
        while (true) {
            try {
                this.readTheList();
                return;
            }
            catch (InterruptedIOException interruptedIOException) {
                bl = true;
                continue;
            }
            catch (IOException iOException) {
                Platform.get().log(5, z[2], iOException);
                return;
            }
            break;
        }
        finally {
            if (bl) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readTheList() throws IOException {
        byte[] byArray;
        Object object = PublicSuffixDatabase.class.getResourceAsStream(PUBLIC_SUFFIX_RESOURCE);
        if (object == null) {
            return;
        }
        Object object2 = Okio.buffer(new GzipSource(Okio.source((InputStream)object)));
        try {
            object = new byte[object2.readInt()];
            object2.readFully((byte[])object);
            byArray = new byte[object2.readInt()];
            object2.readFully(byArray);
        }
        finally {
            Util.closeQuietly((Closeable)object2);
        }
        object2 = this;
        synchronized (object2) {
            this.publicSuffixListBytes = (byte[])object;
            this.publicSuffixExceptionListBytes = byArray;
        }
        this.readCompleteLatch.countDown();
    }

    final void setListBytes(byte[] byArray, byte[] byArray2) {
        this.publicSuffixListBytes = byArray;
        this.publicSuffixExceptionListBytes = byArray2;
        this.listRead.set(true);
        this.readCompleteLatch.countDown();
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[4];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "y=(T\"j;?^-`0/Ken2";
        int n3 = 3;
        block12: while (true) {
            char[] cArray;
            block17: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block16: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block16;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block17;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 9;
                                break;
                            }
                            case 1: {
                                n9 = 72;
                                break;
                            }
                            case 2: {
                                n9 = 74;
                                break;
                            }
                            case 3: {
                                n9 = 56;
                                break;
                            }
                            default: {
                                n9 = 75;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                case 3: {
                    PUBLIC_SUFFIX_RESOURCE = string.intern();
                    string2 = "Uf";
                    n3 = -1;
                    continue block12;
                }
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "m''Y\"ghw\u0005kg=&T";
                    n3 = 0;
                    continue block12;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "O)#T.mh>Wk{-+\\ky=(T\"jh9M-o!2\u0018'`;>";
                    n3 = 1;
                    continue block12;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "\\&+Z'lh>Wke'+\\ky=(T\"j;?^-`0/Ken2jJ.z'?J(lh,J$dh>P.)+&Y8z8+L#'";
                    n3 = 2;
                    continue block12;
                }
                case 2: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
        WILDCARD_LABEL = new byte[]{42};
        EMPTY_RULE = new String[0];
        PREVAILING_RULE = new String[]{"*"};
        instance = new PublicSuffixDatabase();
    }
}

