/*
 * Decompiled with CFR 0.152.
 */
package cn.jmessage.support.okio;

import cn.jmessage.support.annotation.Nullable;
import cn.jmessage.support.okio.Base64;
import cn.jmessage.support.okio.Buffer;
import cn.jmessage.support.okio.Util;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class ByteString
implements Serializable,
Comparable<ByteString> {
    static final char[] HEX_DIGITS;
    private static final long serialVersionUID = 1L;
    public static final ByteString EMPTY;
    final byte[] data;
    transient int hashCode;
    transient String utf8;
    private static final String[] z;

    ByteString(byte[] byArray) {
        this.data = byArray;
    }

    public static ByteString of(byte ... byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException(z[4]);
        }
        return new ByteString((byte[])byArray.clone());
    }

    public static ByteString of(byte[] byArray, int n2, int n3) {
        if (byArray == null) {
            throw new IllegalArgumentException(z[4]);
        }
        Util.checkOffsetAndCount(byArray.length, n2, n3);
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, n2, byArray2, 0, n3);
        return new ByteString(byArray2);
    }

    public static ByteString of(ByteBuffer byteBuffer) {
        if (byteBuffer == null) {
            throw new IllegalArgumentException(z[4]);
        }
        byte[] byArray = new byte[byteBuffer.remaining()];
        byteBuffer.get(byArray);
        return new ByteString(byArray);
    }

    public static ByteString encodeUtf8(String string) {
        if (string == null) {
            throw new IllegalArgumentException(z[6]);
        }
        ByteString byteString = new ByteString(string.getBytes(Util.UTF_8));
        new ByteString(string.getBytes(Util.UTF_8)).utf8 = string;
        return byteString;
    }

    public static ByteString encodeString(String string, Charset charset) {
        if (string == null) {
            throw new IllegalArgumentException(z[6]);
        }
        if (charset == null) {
            throw new IllegalArgumentException(z[27]);
        }
        return new ByteString(string.getBytes(charset));
    }

    public String utf8() {
        String string = this.utf8;
        if (string != null) {
            return string;
        }
        this.utf8 = new String(this.data, Util.UTF_8);
        return this.utf8;
    }

    public String string(Charset charset) {
        if (charset == null) {
            throw new IllegalArgumentException(z[27]);
        }
        return new String(this.data, charset);
    }

    public String base64() {
        return Base64.encode(this.data);
    }

    public ByteString md5() {
        return this.digest(z[30]);
    }

    public ByteString sha1() {
        return this.digest(z[29]);
    }

    public ByteString sha256() {
        return this.digest(z[2]);
    }

    public ByteString sha512() {
        return this.digest(z[0]);
    }

    private ByteString digest(String string) {
        try {
            return ByteString.of(MessageDigest.getInstance(string).digest(this.data));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AssertionError((Object)noSuchAlgorithmException);
        }
    }

    public ByteString hmacSha1(ByteString byteString) {
        return this.hmac(z[28], byteString);
    }

    public ByteString hmacSha256(ByteString byteString) {
        return this.hmac(z[5], byteString);
    }

    public ByteString hmacSha512(ByteString byteString) {
        return this.hmac(z[20], byteString);
    }

    private ByteString hmac(String string, ByteString byteString) {
        try {
            Mac mac = Mac.getInstance(string);
            mac.init(new SecretKeySpec(byteString.toByteArray(), string));
            return ByteString.of(mac.doFinal(this.data));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AssertionError((Object)noSuchAlgorithmException);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new IllegalArgumentException(invalidKeyException);
        }
    }

    public String base64Url() {
        return Base64.encodeUrl(this.data);
    }

    @Nullable
    public static ByteString decodeBase64(String object) {
        if (object == null) {
            throw new IllegalArgumentException(z[3]);
        }
        byte[] byArray = Base64.decode((String)object);
        object = byArray;
        if (byArray != null) {
            return new ByteString((byte[])object);
        }
        return null;
    }

    public String hex() {
        char[] cArray = new char[this.data.length * 2];
        int n2 = 0;
        byte[] byArray = this.data;
        int n3 = this.data.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            byte by = byArray[i2];
            cArray[n2++] = HEX_DIGITS[by >> 4 & 0xF];
            cArray[n2++] = HEX_DIGITS[by & 0xF];
        }
        return new String(cArray);
    }

    public static ByteString decodeHex(String string) {
        if (string == null) {
            throw new IllegalArgumentException(z[24]);
        }
        if (string.length() % 2 != 0) {
            throw new IllegalArgumentException(z[25] + string);
        }
        byte[] byArray = new byte[string.length() / 2];
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            int n2 = ByteString.decodeHexDigit(string.charAt(i2 * 2)) << 4;
            int n3 = ByteString.decodeHexDigit(string.charAt(i2 * 2 + 1));
            byArray[i2] = (byte)(n2 + n3);
        }
        return ByteString.of(byArray);
    }

    private static int decodeHexDigit(char c2) {
        if (c2 >= '0' && c2 <= '9') {
            return c2 - 48;
        }
        if (c2 >= 'a' && c2 <= 'f') {
            return c2 - 97 + 10;
        }
        if (c2 >= 'A' && c2 <= 'F') {
            return c2 - 65 + 10;
        }
        throw new IllegalArgumentException(z[26] + c2);
    }

    public static ByteString read(InputStream inputStream, int n2) throws IOException {
        int n3;
        if (inputStream == null) {
            throw new IllegalArgumentException(z[22]);
        }
        if (n2 < 0) {
            throw new IllegalArgumentException(z[23] + n2);
        }
        byte[] byArray = new byte[n2];
        for (int i2 = 0; i2 < n2; i2 += n3) {
            n3 = inputStream.read(byArray, i2, n2 - i2);
            if (n3 != -1) continue;
            throw new EOFException();
        }
        return new ByteString(byArray);
    }

    public ByteString toAsciiLowercase() {
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            byte by = this.data[i2];
            if (by < 65 || by > 90) continue;
            byte[] byArray = (byte[])this.data.clone();
            byte[] byArray2 = byArray;
            byArray[i2++] = (byte)(by - -32);
            while (i2 < byArray2.length) {
                by = byArray2[i2];
                if (by >= 65 && by <= 90) {
                    byArray2[i2] = (byte)(by - -32);
                }
                ++i2;
            }
            return new ByteString(byArray2);
        }
        return this;
    }

    public ByteString toAsciiUppercase() {
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            byte by = this.data[i2];
            if (by < 97 || by > 122) continue;
            byte[] byArray = (byte[])this.data.clone();
            byte[] byArray2 = byArray;
            byArray[i2++] = (byte)(by - 32);
            while (i2 < byArray2.length) {
                by = byArray2[i2];
                if (by >= 97 && by <= 122) {
                    byArray2[i2] = (byte)(by - 32);
                }
                ++i2;
            }
            return new ByteString(byArray2);
        }
        return this;
    }

    public ByteString substring(int n2) {
        return this.substring(n2, this.data.length);
    }

    public ByteString substring(int n2, int n3) {
        if (n2 < 0) {
            throw new IllegalArgumentException(z[7]);
        }
        if (n3 > this.data.length) {
            throw new IllegalArgumentException(z[8] + this.data.length + ")");
        }
        int n4 = n3 - n2;
        if (n4 < 0) {
            throw new IllegalArgumentException(z[9]);
        }
        if (n2 == 0 && n3 == this.data.length) {
            return this;
        }
        byte[] byArray = new byte[n4];
        System.arraycopy(this.data, n2, byArray, 0, n4);
        return new ByteString(byArray);
    }

    public byte getByte(int n2) {
        return this.data[n2];
    }

    public int size() {
        return this.data.length;
    }

    public byte[] toByteArray() {
        return (byte[])this.data.clone();
    }

    byte[] internalArray() {
        return this.data;
    }

    public ByteBuffer asByteBuffer() {
        return ByteBuffer.wrap(this.data).asReadOnlyBuffer();
    }

    public void write(OutputStream outputStream) throws IOException {
        if (outputStream == null) {
            throw new IllegalArgumentException(z[1]);
        }
        outputStream.write(this.data);
    }

    void write(Buffer buffer) {
        buffer.write(this.data, 0, this.data.length);
    }

    public boolean rangeEquals(int n2, ByteString byteString, int n3, int n4) {
        return byteString.rangeEquals(n3, this.data, n2, n4);
    }

    public boolean rangeEquals(int n2, byte[] byArray, int n3, int n4) {
        return n2 >= 0 && n2 <= this.data.length - n4 && n3 >= 0 && n3 <= byArray.length - n4 && Util.arrayRangeEquals(this.data, n2, byArray, n3, n4);
    }

    public final boolean startsWith(ByteString byteString) {
        return this.rangeEquals(0, byteString, 0, byteString.size());
    }

    public final boolean startsWith(byte[] byArray) {
        return this.rangeEquals(0, byArray, 0, byArray.length);
    }

    public final boolean endsWith(ByteString byteString) {
        return this.rangeEquals(this.size() - byteString.size(), byteString, 0, byteString.size());
    }

    public final boolean endsWith(byte[] byArray) {
        return this.rangeEquals(this.size() - byArray.length, byArray, 0, byArray.length);
    }

    public final int indexOf(ByteString byteString) {
        return this.indexOf(byteString.internalArray(), 0);
    }

    public final int indexOf(ByteString byteString, int n2) {
        return this.indexOf(byteString.internalArray(), n2);
    }

    public final int indexOf(byte[] byArray) {
        return this.indexOf(byArray, 0);
    }

    public int indexOf(byte[] byArray, int n2) {
        int n3 = this.data.length - byArray.length;
        for (n2 = Math.max(n2, 0); n2 <= n3; ++n2) {
            if (!Util.arrayRangeEquals(this.data, n2, byArray, 0, byArray.length)) continue;
            return n2;
        }
        return -1;
    }

    public final int lastIndexOf(ByteString byteString) {
        return this.lastIndexOf(byteString.internalArray(), this.size());
    }

    public final int lastIndexOf(ByteString byteString, int n2) {
        return this.lastIndexOf(byteString.internalArray(), n2);
    }

    public final int lastIndexOf(byte[] byArray) {
        return this.lastIndexOf(byArray, this.size());
    }

    public int lastIndexOf(byte[] byArray, int n2) {
        for (n2 = Math.min(n2, this.data.length - byArray.length); n2 >= 0; --n2) {
            if (!Util.arrayRangeEquals(this.data, n2, byArray, 0, byArray.length)) continue;
            return n2;
        }
        return -1;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        return object instanceof ByteString && ((ByteString)object).size() == this.data.length && ((ByteString)object).rangeEquals(0, this.data, 0, this.data.length);
    }

    public int hashCode() {
        int n2 = this.hashCode;
        if (n2 != 0) {
            return n2;
        }
        this.hashCode = Arrays.hashCode(this.data);
        return this.hashCode;
    }

    @Override
    public int compareTo(ByteString byteString) {
        int n2 = this.size();
        int n3 = byteString.size();
        int n4 = Math.min(n2, n3);
        for (int i2 = 0; i2 < n4; ++i2) {
            int n5;
            int n6 = this.getByte(i2) & 0xFF;
            if (n6 == (n5 = byteString.getByte(i2) & 0xFF)) continue;
            if (n6 < n5) {
                return -1;
            }
            return 1;
        }
        if (n2 == n3) {
            return 0;
        }
        if (n2 < n3) {
            return -1;
        }
        return 1;
    }

    public String toString() {
        if (this.data.length == 0) {
            return z[12];
        }
        String string = this.utf8();
        int n2 = ByteString.codePointIndexToCharIndex(string, 64);
        if (n2 == -1) {
            if (this.data.length <= 64) {
                return z[14] + this.hex() + "]";
            }
            return z[18] + this.data.length + z[10] + this.substring(0, 64).hex() + z[11];
        }
        String string2 = string.substring(0, n2).replace("\\", z[17]).replace("\n", z[16]).replace("\r", z[15]);
        if (n2 < string.length()) {
            return z[18] + this.data.length + z[13] + string2 + z[11];
        }
        return z[19] + string2 + "]";
    }

    static int codePointIndexToCharIndex(String string, int n2) {
        int n3;
        int n4 = 0;
        int n5 = string.length();
        for (int i2 = 0; i2 < n5; i2 += Character.charCount(n3)) {
            if (n4 == n2) {
                return i2;
            }
            n3 = string.codePointAt(i2);
            if (Character.isISOControl(n3) && n3 != 10 && n3 != 13 || n3 == 65533) {
                return -1;
            }
            ++n4;
        }
        return string.length();
    }

    private void readObject(ObjectInputStream object) throws IOException {
        int n2 = ((ObjectInputStream)object).readInt();
        object = ByteString.read((InputStream)object, n2);
        try {
            Field field = ByteString.class.getDeclaredField(z[21]);
            field.setAccessible(true);
            field.set(this, ((ByteString)object).data);
            return;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new AssertionError();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AssertionError();
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(this.data.length);
        objectOutputStream.write(this.data);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[31];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "m#,TM\u000fY";
        int n3 = -1;
        block38: while (true) {
            char[] cArray;
            block43: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block42: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block42;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block43;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 62;
                                break;
                            }
                            case 1: {
                                n9 = 107;
                                break;
                            }
                            case 2: {
                                n9 = 109;
                                break;
                            }
                            case 3: {
                                n9 = 121;
                                break;
                            }
                            default: {
                                n9 = 120;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "Q\u001e\u0019YE\u0003K\u0003\f\u0014R";
                    n3 = 0;
                    continue block38;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "m#,TJ\u000b]";
                    n3 = 1;
                    continue block38;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "\\\n\u001e\u001cN\nKPDXP\u001e\u0001\u0015";
                    n3 = 2;
                    continue block38;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "Z\n\u0019\u0018X\u0003VM\u0017\rR\u0007";
                    n3 = 3;
                    continue block38;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "v\u0006\f\u001a+v*_LN";
                    n3 = 4;
                    continue block38;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "MKPDXP\u001e\u0001\u0015";
                    n3 = 5;
                    continue block38;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "\\\u000e\n\u0010\u0016w\u0005\t\u001c\u0000\u001eWMI";
                    n3 = 6;
                    continue block38;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = "[\u0005\t0\u0016Z\u000e\u0015YF\u001e\u0007\b\u0017\u001fJ\u0003E";
                    n3 = 7;
                    continue block38;
                }
                case 7: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 9;
                    string2 = "[\u0005\t0\u0016Z\u000e\u0015YD\u001e\t\b\u001e\u0011P\"\u0003\u001d\u001dF";
                    n3 = 8;
                    continue block38;
                }
                case 8: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 10;
                    string2 = "\u001e\u0003\b\u0001E";
                    n3 = 9;
                    continue block38;
                }
                case 9: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 11;
                    string2 = "\u20186";
                    n3 = 10;
                    continue block38;
                }
                case 10: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 12;
                    string2 = "e\u0018\u0004\u0003\u001d\u0003[0";
                    n3 = 11;
                    continue block38;
                }
                case 11: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 13;
                    string2 = "\u001e\u001f\b\u0001\f\u0003";
                    n3 = 12;
                    continue block38;
                }
                case 12: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 14;
                    string2 = "e\u0003\b\u0001E";
                    n3 = 13;
                    continue block38;
                }
                case 13: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 15;
                    string2 = "b\u0019";
                    n3 = 14;
                    continue block38;
                }
                case 14: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 16;
                    string2 = "b\u0005";
                    n3 = 15;
                    continue block38;
                }
                case 15: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 17;
                    string2 = "b7";
                    n3 = 16;
                    continue block38;
                }
                case 16: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 18;
                    string2 = "e\u0018\u0004\u0003\u001d\u0003";
                    n3 = 17;
                    continue block38;
                }
                case 17: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 19;
                    string2 = "e\u001f\b\u0001\f\u0003";
                    n3 = 18;
                    continue block38;
                }
                case 18: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 20;
                    string2 = "v\u0006\f\u001a+v*XHJ";
                    n3 = 19;
                    continue block38;
                }
                case 19: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 21;
                    string2 = "Z\n\u0019\u0018";
                    n3 = 20;
                    continue block38;
                }
                case 20: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 22;
                    string2 = "W\u0005MDE\u001e\u0005\u0018\u0015\u0014";
                    n3 = 21;
                    continue block38;
                }
                case 21: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 23;
                    string2 = "\\\u0012\u0019\u001c;Q\u001e\u0003\rX\u0002K]CX";
                    n3 = 22;
                    continue block38;
                }
                case 22: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 24;
                    string2 = "V\u000e\u0015YE\u0003K\u0003\f\u0014R";
                    n3 = 23;
                    continue block38;
                }
                case 23: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 25;
                    string2 = "k\u0005\b\u0001\b[\b\u0019\u001c\u001c\u001e\u0003\b\u0001XM\u001f\u001f\u0010\u0016YQM";
                    n3 = 24;
                    continue block38;
                }
                case 24: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 26;
                    string2 = "k\u0005\b\u0001\b[\b\u0019\u001c\u001c\u001e\u0003\b\u0001XZ\u0002\n\u0010\f\u0004K";
                    n3 = 25;
                    continue block38;
                }
                case 25: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 27;
                    string2 = "]\u0003\f\u000b\u000b[\u001fMDE\u001e\u0005\u0018\u0015\u0014";
                    n3 = 26;
                    continue block38;
                }
                case 26: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 28;
                    string2 = "v\u0006\f\u001a+v*\\";
                    n3 = 27;
                    continue block38;
                }
                case 27: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 29;
                    string2 = "m#,TI";
                    n3 = 28;
                    continue block38;
                }
                case 28: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 30;
                    string2 = "s/X";
                    n3 = 29;
                    continue block38;
                }
                case 29: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
        HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        EMPTY = ByteString.of(new byte[0]);
    }
}

