/*
 * Decompiled with CFR 0.152.
 */
package cn.jmessage.support.okio;

import cn.jmessage.support.okio.Buffer;
import cn.jmessage.support.okio.BufferedSink;
import cn.jmessage.support.okio.DeflaterSink;
import cn.jmessage.support.okio.Okio;
import cn.jmessage.support.okio.Segment;
import cn.jmessage.support.okio.Sink;
import cn.jmessage.support.okio.Timeout;
import cn.jmessage.support.okio.Util;
import java.io.IOException;
import java.util.zip.CRC32;
import java.util.zip.Deflater;

public final class GzipSink
implements Sink {
    private final BufferedSink sink;
    private final Deflater deflater;
    private final DeflaterSink deflaterSink;
    private boolean closed;
    private final CRC32 crc = new CRC32();
    private static final String[] z;

    public GzipSink(Sink sink) {
        if (sink == null) {
            throw new IllegalArgumentException(z[0]);
        }
        this.deflater = new Deflater(-1, true);
        this.sink = Okio.buffer(sink);
        this.deflaterSink = new DeflaterSink(this.sink, this.deflater);
        this.writeHeader();
    }

    @Override
    public final void write(Buffer buffer, long l2) throws IOException {
        if (l2 < 0L) {
            throw new IllegalArgumentException(z[1] + l2);
        }
        if (l2 == 0L) {
            return;
        }
        this.updateCrc(buffer, l2);
        this.deflaterSink.write(buffer, l2);
    }

    @Override
    public final void flush() throws IOException {
        this.deflaterSink.flush();
    }

    @Override
    public final Timeout timeout() {
        return this.sink.timeout();
    }

    @Override
    public final void close() throws IOException {
        Throwable throwable;
        block9: {
            block8: {
                if (this.closed) {
                    return;
                }
                throwable = null;
                try {
                    this.deflaterSink.finishDeflate();
                    this.writeFooter();
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                try {
                    this.deflater.end();
                }
                catch (Throwable throwable3) {
                    if (throwable != null) break block8;
                    throwable = throwable3;
                }
            }
            try {
                this.sink.close();
            }
            catch (Throwable throwable4) {
                if (throwable != null) break block9;
                throwable = throwable4;
            }
        }
        this.closed = true;
        if (throwable != null) {
            Util.sneakyRethrow(throwable);
        }
    }

    public final Deflater deflater() {
        return this.deflater;
    }

    private void writeHeader() {
        Buffer buffer = this.sink.buffer();
        buffer.writeShort(8075);
        buffer.writeByte(8);
        buffer.writeByte(0);
        buffer.writeInt(0);
        buffer.writeByte(0);
        buffer.writeByte(0);
    }

    private void writeFooter() throws IOException {
        this.sink.writeIntLe((int)this.crc.getValue());
        this.sink.writeIntLe((int)this.deflater.getBytesRead());
    }

    private void updateCrc(Buffer object, long l2) {
        object = ((Buffer)object).head;
        while (l2 > 0L) {
            int n2 = (int)Math.min(l2, (long)(((Segment)object).limit - ((Segment)object).pos));
            this.crc.update(((Segment)object).data, ((Segment)object).pos, n2);
            l2 -= (long)n2;
            object = ((Segment)object).next;
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[2];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "v\u001e\u000bh\u000f8JEmZi\u001b";
        int n3 = -1;
        block9: while (true) {
            char[] cArray;
            block14: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block13: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block13;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block14;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 5;
                                break;
                            }
                            case 1: {
                                n9 = 119;
                                break;
                            }
                            case 2: {
                                n9 = 101;
                                break;
                            }
                            case 3: {
                                n9 = 3;
                                break;
                            }
                            default: {
                                n9 = 47;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "g\u000e\u0011flj\u0002\u000bw\u000f9WU9\u000f";
                    n3 = 0;
                    continue block9;
                }
                case 0: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

