/*
 * Decompiled with CFR 0.152.
 */
package cn.jmessage.support.okio;

import cn.jmessage.support.annotation.Nullable;
import cn.jmessage.support.okio.Buffer;
import cn.jmessage.support.okio.ByteString;
import cn.jmessage.support.okio.ForwardingSink;
import cn.jmessage.support.okio.Segment;
import cn.jmessage.support.okio.Sink;
import cn.jmessage.support.okio.Util;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public final class HashingSink
extends ForwardingSink {
    @Nullable
    private final MessageDigest messageDigest;
    @Nullable
    private final Mac mac;
    private static final String[] z;

    public static HashingSink md5(Sink sink) {
        return new HashingSink(sink, z[5]);
    }

    public static HashingSink sha1(Sink sink) {
        return new HashingSink(sink, z[4]);
    }

    public static HashingSink sha256(Sink sink) {
        return new HashingSink(sink, z[1]);
    }

    public static HashingSink sha512(Sink sink) {
        return new HashingSink(sink, z[6]);
    }

    public static HashingSink hmacSha1(Sink sink, ByteString byteString) {
        return new HashingSink(sink, byteString, z[3]);
    }

    public static HashingSink hmacSha256(Sink sink, ByteString byteString) {
        return new HashingSink(sink, byteString, z[0]);
    }

    public static HashingSink hmacSha512(Sink sink, ByteString byteString) {
        return new HashingSink(sink, byteString, z[2]);
    }

    private HashingSink(Sink sink, String string) {
        super(sink);
        try {
            this.messageDigest = MessageDigest.getInstance(string);
            this.mac = null;
            return;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AssertionError();
        }
    }

    private HashingSink(Sink sink, ByteString byteString, String string) {
        super(sink);
        try {
            this.mac = Mac.getInstance(string);
            this.mac.init(new SecretKeySpec(byteString.toByteArray(), string));
            this.messageDigest = null;
            return;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AssertionError();
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new IllegalArgumentException(invalidKeyException);
        }
    }

    @Override
    public final void write(Buffer buffer, long l2) throws IOException {
        int n2;
        Util.checkOffsetAndCount(buffer.size, 0L, l2);
        Segment segment = buffer.head;
        for (long i2 = 0L; i2 < l2; i2 += (long)n2) {
            n2 = (int)Math.min(l2 - i2, (long)(segment.limit - segment.pos));
            if (this.messageDigest != null) {
                this.messageDigest.update(segment.data, segment.pos, n2);
            } else {
                this.mac.update(segment.data, segment.pos, n2);
            }
            segment = segment.next;
        }
        super.write(buffer, l2);
    }

    public final ByteString hash() {
        return ByteString.of(this.messageDigest != null ? this.messageDigest.digest() : this.mac.doFinal());
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[7];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "7)\u001c@\f7\u0005O\u0016i";
        int n3 = -1;
        block14: while (true) {
            char[] cArray;
            block19: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block18: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block18;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block19;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 127;
                                break;
                            }
                            case 1: {
                                n9 = 68;
                                break;
                            }
                            case 2: {
                                n9 = 125;
                                break;
                            }
                            case 3: {
                                n9 = 35;
                                break;
                            }
                            default: {
                                n9 = 95;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = ",\f<\u000emJr";
                    n3 = 0;
                    continue block14;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "7)\u001c@\f7\u0005H\u0012m";
                    n3 = 1;
                    continue block14;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "7)\u001c@\f7\u0005L";
                    n3 = 2;
                    continue block14;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = ",\f<\u000en";
                    n3 = 3;
                    continue block14;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "2\u0000H";
                    n3 = 4;
                    continue block14;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = ",\f<\u000ejNv";
                    n3 = 5;
                    continue block14;
                }
                case 5: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

