/*
 * Decompiled with CFR 0.152.
 */
package cn.jmessage.support.okio;

import cn.jmessage.support.okio.Buffer;
import cn.jmessage.support.okio.ByteString;
import cn.jmessage.support.okio.ForwardingSource;
import cn.jmessage.support.okio.Segment;
import cn.jmessage.support.okio.Source;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public final class HashingSource
extends ForwardingSource {
    private final MessageDigest messageDigest;
    private final Mac mac;
    private static final String[] z;

    public static HashingSource md5(Source source) {
        return new HashingSource(source, z[2]);
    }

    public static HashingSource sha1(Source source) {
        return new HashingSource(source, z[1]);
    }

    public static HashingSource sha256(Source source) {
        return new HashingSource(source, z[4]);
    }

    public static HashingSource hmacSha1(Source source, ByteString byteString) {
        return new HashingSource(source, byteString, z[0]);
    }

    public static HashingSource hmacSha256(Source source, ByteString byteString) {
        return new HashingSource(source, byteString, z[3]);
    }

    private HashingSource(Source source, String string) {
        super(source);
        try {
            this.messageDigest = MessageDigest.getInstance(string);
            this.mac = null;
            return;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AssertionError();
        }
    }

    private HashingSource(Source source, ByteString byteString, String string) {
        super(source);
        try {
            this.mac = Mac.getInstance(string);
            this.mac.init(new SecretKeySpec(byteString.toByteArray(), string));
            this.messageDigest = null;
            return;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AssertionError();
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new IllegalArgumentException(invalidKeyException);
        }
    }

    @Override
    public final long read(Buffer buffer, long l2) throws IOException {
        long l3 = super.read(buffer, l2);
        if (l3 != -1L) {
            long l4;
            long l5 = buffer.size - l3;
            Segment segment = buffer.head;
            for (l4 = buffer.size; l4 > l5; l4 -= (long)(segment.limit - segment.pos)) {
                segment = segment.prev;
            }
            while (l4 < buffer.size) {
                int n2 = (int)((long)segment.pos + l5 - l4);
                if (this.messageDigest != null) {
                    this.messageDigest.update(segment.data, n2, segment.limit - n2);
                } else {
                    this.mac.update(segment.data, n2, segment.limit - n2);
                }
                l5 = l4 += (long)(segment.limit - segment.pos);
                segment = segment.next;
            }
        }
        return l3;
    }

    public final ByteString hash() {
        return ByteString.of(this.messageDigest != null ? this.messageDigest.digest() : this.mac.doFinal());
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[5];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "*y\u000eu\t*U^";
        int n3 = -1;
        block12: while (true) {
            char[] cArray;
            block17: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block16: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block16;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block17;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 98;
                                break;
                            }
                            case 1: {
                                n9 = 20;
                                break;
                            }
                            case 2: {
                                n9 = 111;
                                break;
                            }
                            case 3: {
                                n9 = 22;
                                break;
                            }
                            default: {
                                n9 = 90;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "1\\.;k";
                    n3 = 0;
                    continue block12;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "/PZ";
                    n3 = 1;
                    continue block12;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "*y\u000eu\t*U]#l";
                    n3 = 2;
                    continue block12;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "1\\.;hW\"";
                    n3 = 3;
                    continue block12;
                }
                case 3: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

